#include "common.h"
#include "libWrapper.h"

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _SELECT_FROM_H
#define _SELECT_FROM_H
#include "selectFrom.h"
#endif

#ifndef _EXTERN_H
#include "extern.h"
#define _EXTERN_H
#endif

/****************************************************************
 *
 * Private function
 *
 ***************************************************************/
static void
releaseSensorForClient(SENSOR *pHeadSensor)
{
  SENSOR *pSensor;

  while (pHeadSensor->next != NULL) {
    pSensor = pHeadSensor->next;
    pHeadSensor->next = pHeadSensor->next->next;
    free(pSensor);
  }
}

static void
releaseSensorSegmentForClient(SENSOR_SEGMENT *pHeadSensorSegment)
{
  SENSOR_SEGMENT *trash;

  while (pHeadSensorSegment->next != NULL) {
    trash = pHeadSensorSegment->next;
    pHeadSensorSegment->next = pHeadSensorSegment->next->next;
    releaseSensorForClient(&(trash->headSensor));
    free(trash);
  }
}

/****************************************************************
 *
 * Public function
 *
 ***************************************************************/
extern void
releaseBaseTupleForClient(TUPLE *pHeadTuple, const ATTR attr[], const int numOfAttr)
{
  int attrid;
  int byteOffset;
  TUPLE *trash;
  SENSOR_SEGMENT *pSensorSegment;

  while (pHeadTuple->next != NULL) {
    trash = pHeadTuple->next;
    pHeadTuple->next = pHeadTuple->next->next;
    for (byteOffset = 0, attrid = 0; 
         attrid < numOfAttr; 
         byteOffset += attr[attrid].sizOfAttr, attrid ++) {
      switch (attr[attrid].attrType) {
      case SENSOR_SEGMENT_DOUBLE:
        pSensorSegment = (SENSOR_SEGMENT *)(trash->obj + byteOffset);
        releaseSensorSegmentForClient(pSensorSegment);
        break;
      default: break;
      }
    }
    free(trash->obj);
    free(trash);
  }
}

extern void
releaseAnswerForClient(ANSWER answer)
{
  releaseBaseTupleForClient(&(answer.headTuple), answer.attr, answer.numOfAttr);
  free(answer.attr);
}

extern void
releaseCondition(CONDITION headCondition)
{
  CONDITION *conditionP;

  while (headCondition.next != NULL) {
    conditionP = headCondition.next;
    headCondition.next = headCondition.next->next;
    free(conditionP);
  }
}

extern void
releaseOffset(OFFSET *pHeadOffset)
{
  OFFSET *trash;

  while (pHeadOffset->next != NULL) {
    trash = pHeadOffset->next;
    pHeadOffset->next = pHeadOffset->next->next;
    free(trash);
  }
}

extern void
releaseSensorSegmentAttrList(SENSOR_SEGMENT_ATTR_LIST *pHeadSSAL)
{
  SENSOR_SEGMENT_ATTR_LIST *pSSAL;

  while (pHeadSSAL->next != NULL) {
    pSSAL = pHeadSSAL->next;    
    pHeadSSAL->next = pHeadSSAL->next->next;
    free(pSSAL);
  }
}
