#include "common.h"
#include "libWrapper.h"
#include "schema.h"
#include "selectFrom.h"
#include <dirent.h>
#include <sys/errno.h>
#include "buffsize.h"
#include "monitorInfo.h"

extern void sendback(const int sockfd, void *ptr, const int size, const int flag);
/****************************************************************
 *
 * Function
 *
 ***************************************************************/
static void
sendAllOfMonitor(const int acptfd)
{
  char monitorDirName[BUFFSIZE];
  BOOLEAN finish = FALSE;
  DIR *pDir;
  struct dirent *pDirent;

  bzero(monitorDirName, BUFFSIZE);
  sprintf(monitorDirName, getenv("HOME"), MONITOR_DIR_NAME);
  if ((pDir = opendir(monitorDirName)) == NULL) ERR;
  while (1) {
    pDirent = readdir(pDir);
    if (pDirent == NULL) {
      finish = TRUE;
      sendback(acptfd, &finish, sizeof(BOOLEAN), 0);
      break;
    }
    else if ((strcmp(pDirent->d_name, ".") != 0) && (strcmp(pDirent->d_name, "..") != 0)) {
      finish = FALSE;
      sendback(acptfd, &finish, sizeof(BOOLEAN), 0);
      sendback(acptfd, pDirent->d_name, BUFFSIZE, 0);
    }
  } 
  closedir(pDir);
}

static void
sendSingleMonitor(const int acptfd, const char monitorName[])
{
  int fd;
  char monitorInfo[BUFFSIZE];
  char monitorFileName[BUFFSIZE];
  BOOLEAN finish;
  extern int errno;
  MONITOR_QUERY monitorQuery;
  
  bzero(monitorFileName, BUFFSIZE);
  sprintf(monitorFileName, "%s/%s/%s", getenv("HOME"), MONITOR_DIR_NAME, monitorName);
  fd = open(monitorFileName, O_RDONLY);
  if ((fd == -1) && (errno == ENOENT)) {
    if (close(fd) == -1) ERR;

    finish = FALSE;
    sendback(acptfd, &finish, sizeof(BOOLEAN), 0);
    bzero(monitorInfo, BUFFSIZE);
    strncpy(monitorInfo, "No such table", strlen("No such table"));
    sendback(acptfd, monitorInfo, BUFFSIZE, 0);
  }
  else {
    if (read(fd, &monitorQuery, sizeof(MONITOR_QUERY)) == -1) ERR;
    if (close(fd) == -1) ERR;

    finish = FALSE;
    sendback(acptfd, &finish, sizeof(BOOLEAN), 0);
    bzero(monitorInfo, BUFFSIZE);
    sprintf(monitorInfo, "PERIOD: %ldsec & %ld usec", monitorQuery.period.tv_sec, monitorQuery.period.tv_usec);
    sendback(acptfd, monitorInfo, BUFFSIZE, 0);

    finish = FALSE;
    sendback(acptfd, &finish, sizeof(BOOLEAN), 0);
    bzero(monitorInfo, BUFFSIZE);
    sprintf(monitorInfo, "QUERY:  %s", monitorQuery.query);
    sendback(acptfd, monitorInfo, BUFFSIZE, 0);
  }    
  finish = TRUE;
  sendback(acptfd, &finish, sizeof(BOOLEAN), 0);
}

extern void
sendMonitor(const int acptfd, const char query[])
{
  int left;
  int right;
  int qid;
  char monitorName[BUFFSIZE];

  for (qid = 0; qid < QUERY_BUFFSIZE; qid++) {
    if ((query[qid] == '\\') && strncmp(&query[qid], "\\m", strlen("\\m")) == 0) {
      qid += strlen("\\m");
      break;
    }
  }
  for (;qid < QUERY_BUFFSIZE; qid++) {
    if ((query[qid] != '\0') && (query[qid] != '\n')) {
      break;
    }
  }
  if (qid == QUERY_BUFFSIZE) {
    sendAllOfMonitor(acptfd);
  }
  else {
    while (query[qid] == ' ') 
      qid++;
    left = qid;

    while (query[qid] != '\n' && query[qid] != '\0') 
      qid++; 
    right = qid;

    bzero(monitorName, BUFFSIZE);
    strncpy(monitorName, &query[left], right-left);
    sendSingleMonitor(acptfd, monitorName);
  }
}
