#include "common.h"
#include "libWrapper.h"
#include "schema.h"
#include "selectFrom.h"
#include <dirent.h>
#include <sys/errno.h>
#include "buffsize.h"
#include "monitorInfo.h"
#include "windowDir.h"

#ifndef _WINDOW_H
#define _WINDOW_H
#include "window.h"
#endif

/****************************************************************
 *
 * Declaration
 *
 ***************************************************************/
extern void sendback(const int sockfd, void *ptr, const int size, const int flag);

/****************************************************************
 *
 * Gloval variable
 *
 ***************************************************************/
extern METAW HeadMetaw;

/****************************************************************
 *
 * Function
 *
 ***************************************************************/
static void
sendAllOfWindow(const int acptfd)
{
  char name[BUFFSIZE];
  BOOLEAN finish = FALSE;
  DIR *dirP;
  struct dirent *direntP;

  bzero(name, BUFFSIZE);
  sprintf(name, "%s/%s", getenv("HOME"), WINDOW_DIR);
  if ((dirP = opendir(name)) == NULL) ERR;
  while (1) {
    direntP = readdir(dirP);
    if (direntP == NULL) {
      finish = TRUE;
      sendback(acptfd, &finish, sizeof(BOOLEAN), 0);
      break;
    }
    else if ((strcmp(direntP->d_name, ".") != 0) && (strcmp(direntP->d_name, "..") != 0)) {
      finish = FALSE;
      sendback(acptfd, &finish, sizeof(BOOLEAN), 0);
      sendback(acptfd, direntP->d_name, BUFFSIZE, 0);
    }
  } 
  closedir(dirP);
}

static void
sendSingleWindow(const int acptfd, const char name[])
{
  int i;
  BOOLEAN finish;
  char msg[BUFFSIZE];
  METAW *metawP;

  for (metawP = HeadMetaw.next; metawP != NULL; metawP = metawP->next) {
    if (!strcmp(metawP->w->name, name))
      break;
  }

  if (metawP == NULL) {
    finish = FALSE;
    sendback(acptfd, &finish, sizeof(BOOLEAN), 0);
    bzero(msg, BUFFSIZE);
    strcpy(msg, "No such window");
    sendback(acptfd, msg, BUFFSIZE, 0);
  }
  else {
    for (i = 0; i < metawP->w->num; i++) {
      finish = FALSE;
      sendback(acptfd, &finish, sizeof(BOOLEAN), 0);
      bzero(msg, BUFFSIZE);
      sprintf(msg, "%ld:%ld:%f", metawP->w->p[i].t.tv_sec, metawP->w->p[i].t.tv_usec, metawP->w->p[i].v);
      sendback(acptfd, msg, BUFFSIZE, 0);
    }
  }    

  finish = TRUE;
  sendback(acptfd, &finish, sizeof(BOOLEAN), 0);
}

extern void
sendWindow(const int acptfd, const char query[])
{
  int l, r;
  int qid;
  char name[BUFFSIZE];

  for (qid = 0; qid < QUERY_BUFFSIZE; qid++) {
    if ((query[qid] == '\\') && strncmp(&query[qid], "\\w", strlen("\\w")) == 0) {
      qid += strlen("\\w");
      break;
    }
  }
  for (; qid < QUERY_BUFFSIZE; qid++) {
    if ((query[qid] != '\0') && (query[qid] != '\n')) {
      break;
    }
  }

  if (qid == QUERY_BUFFSIZE) {
    sendAllOfWindow(acptfd);
  }
  else {
    while (query[qid] == ' ') 
      qid++;
    l = qid;
    while ((query[qid] != '\n') && (query[qid] != '\0')) 
      qid++;
    r = qid;
    bzero(name, BUFFSIZE);
    strncpy(name, &query[l], r - l);
    sendSingleWindow(acptfd, name);
  }
}
