#include "common.h"
#include "libWrapper.h"

/*******************************************************
 *
 * Declaration
 *
 *******************************************************/
extern void setHalt(void);

/*******************************************************
 *
 * Private Function
 *
 *******************************************************/
static void *
sighandler(int sig)
{
  printf("Signal obtained\n");

  switch (sig) {
  case SIGPIPE:    
    printf("SIGPIPE\n");    
    pthread_exit(NULL);    
    break;
  case SIGINT:
    printf("SIGINT\n");
    setHalt();
    break;
  case SIGSEGV:
    printf("SIGSEGV\n");
    setHalt();
#ifdef USE_ERTF
    print_queue();
#endif
    break;
  }

  return NULL;
}

/*****************************
 *
 * Public Function
 *
 *****************************/
extern void
initSignal(void)
{
  signal(SIGPIPE, (void(*)())sighandler);
  signal(SIGINT, (void(*)())sighandler); 
}
