#include "common.h"
#include "libWrapper.h"
#include "port.h"
#include "host.h"
#include "dataDir.h"
#include <sys/time.h>
#include <sys/resource.h>

extern void shutdownPages(void);

static BOOLEAN HaltSystem = FALSE;

static void *
synchr(void)
{
  while (HaltSystem == FALSE) 
    usleep(1000);

  shutdownPages();

  /* 
   * Is this enough for already written pages ? 
   * I am slightly anxious.
   */
  {
    int i;
    for (i = 0; i < 3; i++)
      sync();
  }

  /* O.K. Finishing */
  exit(0);

  return NULL;
}

extern void
setHalt(void)
{
  HaltSystem = TRUE;
}

extern void
initSynchr(void)
{
  pthread_t thread;

  if (pthread_create(&thread, NULL, (void *)synchr, NULL)) ERR;
  if (pthread_detach(thread)) ERR;
}

