/*
 * LESS means a symbol '<'
 */
#include "common.h"
#include "libWrapper.h"

#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

#ifndef _SELECT_FROM_H
#define _SELECT_FROM_H
#include "selectFrom.h"
#endif

#ifndef _EXTERN_H
#include "extern.h"
#define _EXTERN_H
#endif

/*
 * Functions
 */
static ANSWER
execSelectionCaseLessLeftTrueRightFalseOr(ANSWER answer, const CONDITION *pCondition)
{
  int attrid;
  int byteOffset;
  int intData;
  double doubleData;
  TUPLE *pAnswerTuple;
  ATTR_TYPE attrType;
  TUPLE_LIST *pAndorTupleList;

  pAndorTupleList = &answer.headAndorTupleList;
  while (pAndorTupleList->next != NULL) {
    pAndorTupleList = pAndorTupleList->next;
  }

  for (byteOffset = 0, attrid = 0; attrid < pCondition->u.binary.aid; attrid ++) {
    byteOffset += answer.attr[attrid].sizOfAttr;
  }
  attrType = answer.attr[pCondition->u.binary.aid].attrType;
  for (pAnswerTuple = answer.headTuple.next; pAnswerTuple != NULL; pAnswerTuple = pAnswerTuple->next) {
    switch (attrType) {
    case INT:    memcpy(&intData, pAnswerTuple->obj + byteOffset, sizeof(int));       break;
    case DOUBLE: memcpy(&doubleData, pAnswerTuple->obj + byteOffset, sizeof(double)); break;
    default: break;
    }
    if (((attrType == DOUBLE) && (doubleData < atof(pCondition->u.binary.rightText))) ||
        ((attrType == INT)    && (intData    < atoi(pCondition->u.binary.rightText)))) {
      pAnswerTuple->selected = TRUE;
      if ((pAndorTupleList->next = calloc(1, sizeof(TUPLE_LIST))) == NULL) ERR;
      pAndorTupleList = pAndorTupleList->next;
      pAndorTupleList->pTuple = pAnswerTuple;
    }
  }

  return answer;
}

static ANSWER
execSelectionCaseLessLeftTrueRightFalseAnd(ANSWER answer, const CONDITION *pCondition)
{
  int attrid;
  int byteOffset;
  int intData;
  double doubleData;
  ATTR_TYPE attrType;
  TUPLE_LIST *pMarkAndorTupleList;

  attrType = answer.attr[pCondition->u.binary.aid].attrType;
  for (pMarkAndorTupleList = answer.headAndorTupleList.next;
       pMarkAndorTupleList != NULL;
       pMarkAndorTupleList = pMarkAndorTupleList->next) {
    if (pMarkAndorTupleList->pTuple->selected == TRUE) {
      if (pMarkAndorTupleList->pTuple->certified == FALSE) {
        for (byteOffset = 0, attrid = 0; attrid < pCondition->u.binary.aid; attrid ++) {
          byteOffset += answer.attr[attrid].sizOfAttr;
        }
        switch (attrType) {
        case INT:    
          memcpy(&intData, pMarkAndorTupleList->pTuple->obj + byteOffset, sizeof(int)); 
          break;
        case DOUBLE: 
          memcpy(&doubleData, pMarkAndorTupleList->pTuple->obj + byteOffset, sizeof(double)); 
          break;
        default: 
          break;
        }
        if (((doubleData >= atof(pCondition->u.binary.rightText)) && (attrType == DOUBLE)) ||
            ((intData >= atoi(pCondition->u.binary.rightText)) && (attrType == INT))) {
          pMarkAndorTupleList->pTuple->selected = FALSE;
        }
      }
    }
  }

  return answer;
}

extern ANSWER
execSelectionCaseLess(const CONDITION *pCondition, ANSWER answer)
{
  if (pCondition->andor == OR) {
    TUPLE_LIST *trash;
    while (answer.headAndorTupleList.next != NULL) {
      trash = answer.headAndorTupleList.next;
      if (trash->pTuple->selected == TRUE) {
        trash->pTuple->certified = TRUE;
      }
      answer.headAndorTupleList.next = answer.headAndorTupleList.next->next;
      free(trash);
    }
  }

  switch (pCondition->andor) {
  case OR:  
    answer = execSelectionCaseLessLeftTrueRightFalseOr(answer, pCondition);  
    break;
  case AND: 
    answer = execSelectionCaseLessLeftTrueRightFalseAnd(answer, pCondition); 
    break;
  }

  return answer;
}
