#include "port.h"
#include "host.h"
#include "common.h" 
#include "libWrapper.h"
#include "schema.h"
#include "selectFrom.h"
#include <gtk/gtk.h>

typedef struct {
  GdkDrawable *pixmap;
  GdkGC *gc;
} typGraphics;

static GdkGC *PenToDrawGraph = NULL;
static typGraphics *g;
static SENSOR GlobalHeadSensor;
static ATTR_TYPE GlobalAttrType;

/*
 * NewGraphics
 *
 * Create a new graphics data element to keep track
 * of the pixmap and the gc.
 */
static typGraphics 
*NewGraphics ()
{
  typGraphics *gfx;

  /* --- Allocate the space --- */
  gfx = (typGraphics *) g_malloc (sizeof (typGraphics));
  
  /* --- Initialize --- */
  gfx->gc = NULL;
  gfx->pixmap = NULL;
  
  /* --- Hand back, ready to use. --- */
  return (gfx);
}


/*
 * GetPen
 *
 * Get a pen using the GdkColor passed in.  The "pen"
 * (just a GdkGC) is created and returned ready for 
 * use.
 */
static GdkGC *
GetPen(typGraphics *g, GdkColor *c)
{
  GdkGC *gc;
  gc = gdk_gc_new(g->pixmap);
  gdk_gc_set_foreground(gc, c);

  return (gc);
}


/*
 * NewColor
 *
 * Create and allocate a GdkColor with the color 
 * specified in the parameter list.
 */ 
static GdkColor *
NewColor (long red, long green, long blue)
{
  /* --- Get the color --- */
  GdkColor *c = (GdkColor *) g_malloc (sizeof (GdkColor));
  
  /* --- Fill it in. --- */
  c->red = red;
  c->green = green;
  c->blue = blue;
  
  gdk_color_alloc (gdk_colormap_get_system (), c);
  
  return (c);
}

static SENSOR
getHeadSensor(void)
{
  return GlobalHeadSensor;
}

static ATTR_TYPE
getAttrType(void)
{
  return GlobalAttrType;
}

static void 
drawSensor(GdkGC *pen, typGraphics *g)
{
  gint time;
  gint data;
  gint prevData;
  SENSOR headSensor;
  SENSOR *pSensor;
  ATTR_TYPE attrType;

  headSensor = getHeadSensor();
  attrType = getAttrType();
  
  pSensor = headSensor.next;

  time = 0;
  data = 0;
  prevData = 0;
  while (pSensor != NULL) {
    switch(attrType) {
    case SENSOR_INT:    data = pSensor->timedObjInSensor.objInSensor.intData;         break;
    case SENSOR_DOUBLE: data = (int)pSensor->timedObjInSensor.objInSensor.doubleData; break;
    default: break;
    }
    gdk_draw_line(g->pixmap, pen, time, 200-prevData, time+1, 200-data);
    pSensor = pSensor->next;
    prevData = data;
    time ++;
  }
}

static void 
drawGraph(GtkWidget *drawingArea)
{
  GdkRectangle update_rect;

  /* --- clear pixmap so we can draw on it. --- */
  gdk_draw_rectangle (g->pixmap, drawingArea->style->white_gc, TRUE, 0, 0, drawingArea->allocation.width, drawingArea->allocation.height);
  drawSensor(PenToDrawGraph, g);
  
  /* --- Update the screen with the background pixmap --- */
  update_rect.x = 0;
  update_rect.y = 0;
  update_rect.width = drawingArea->allocation.width;
  update_rect.height = drawingArea->allocation.height;
  
  gtk_widget_draw(drawingArea, &update_rect);
}


static void 
configure_event(GtkWidget *drawingArea)
{
  g = NewGraphics();
  g->pixmap = (GdkPixmap *)gdk_pixmap_new(drawingArea->window, drawingArea->allocation.width, drawingArea->allocation.height, -1);
  PenToDrawGraph = GetPen(g, NewColor(0, 0, 0xffff));
  gdk_draw_rectangle(g->pixmap, drawingArea->style->white_gc, TRUE, 0, 0, drawingArea->allocation.width, drawingArea->allocation.height);
}

static void
expose_event(GtkWidget *drawingArea, GdkEventExpose *event)
{
  printf("expose_event\n");

  gdk_draw_pixmap(drawingArea->window, drawingArea->style->fg_gc[GTK_WIDGET_STATE(drawingArea)], g->pixmap, 
		  event->area.x, event->area.y, event->area.x, event->area.y, event->area.width, event->area.height);
}

static void
setDataForSensor(SENSOR headSensor, ATTR_TYPE attrType)
{
  GlobalHeadSensor = headSensor;
  GlobalAttrType = attrType;
}

extern GtkWidget *
makeGraph(SENSOR headSensor, ATTR_TYPE attrType)
{
  GtkWidget *drawingArea;
  gint tag;
  
  setDataForSensor(headSensor, attrType);
  drawingArea = gtk_drawing_area_new();
  gtk_drawing_area_size(GTK_DRAWING_AREA(drawingArea), 200, 200);
  gtk_widget_show(drawingArea);

  gtk_signal_connect(GTK_OBJECT (drawingArea), "expose_event", (GtkSignalFunc) expose_event, NULL); 
  gtk_signal_connect(GTK_OBJECT(drawingArea),"configure_event", (GtkSignalFunc) configure_event, NULL);

  tag = gtk_timeout_add(500, (GtkFunction)drawGraph, (gpointer)drawingArea);

  return (drawingArea);
}
