#include "common.h"
#include "buffsize.h"
#include "libWrapper.h"
#include "schema.h"
#include "libKraft.h"

/***************************************************************
 *
 * Prototype
 *
 ***************************************************************/
extern int connectCli(int port, char hostname[]);

/***************************************************************
 *
 * Private Function
 *
 ***************************************************************/
static int 
getLoopMax(const int argc, const char *argv[])
{
  int loopMax;

  if (argc != 2) {
    printf("Usage: program LoopMax\n");
    exit(1);
  }
  else {
    loopMax = atoi(argv[1]);
  }

  return loopMax;
}

static void
sendTransCommand(const char command[], const int kraftfd)
{
  char query[BUFFSIZE];
  TYPE_OF_ANSWER typeOfAnswer;

  bzero(query, BUFFSIZE);
  strcpy(query, command);
  sendQuery(query, kraftfd);
  typeOfAnswer = recvTypeOfAnswer(kraftfd);
}

/***************************************************************
 *
 * Public Function
 *
 ***************************************************************/
extern int 
main(const int argc, const char *argv[])
{
  int kraftfd;
  int loopid;
  int loopmax;
  char query[BUFFSIZE];
  TYPE_OF_ANSWER typeOfAnswer;
  ATTR_TYPE attrType;
  struct timeval sleepTime;

  sleepTime.tv_sec = 1;
  sleepTime.tv_usec = 0;

  kraftfd = connectKraft();
  sendTransCommand("begin", kraftfd);
  loopmax = getLoopMax(argc, argv);
  for (loopid = 0; loopid < loopmax; loopid ++) {
    bzero(query, BUFFSIZE);
    sprintf(query, "select * from hoge");
    sendQuery(query, kraftfd);    
    if (isThisAppend(query) == TRUE) {
      RecvBack(kraftfd, &attrType, sizeof(ATTR_TYPE), 0);
    }
    typeOfAnswer = recvTypeOfAnswer(kraftfd);
    /*printResultForRelation(kraftfd);*/

    select(0, NULL, NULL, NULL, &sleepTime);
  }
  sendTransCommand("commit", kraftfd);
  sendExitAndCloseSockfd(kraftfd);

  return 0;
}
