#ifndef _SCHEMA_H
#define _SCHEMA_H
#include "schema.h"
#endif

typedef enum {
  PERSISTENT_EXIT, 
  PERSISTENT_INSERT, 
  PERSISTENT_DELETE, 
  PERSISTENT_APPEND
} PERSISTENT_OBJ_TYPE;
typedef enum {
  VOLATILE_INSERT, 
  VOLATILE_APPEND
} VOLATILE_OBJ_TYPE;
typedef enum {
  STATE_COMMIT, 
  STATE_COMMITING, 
  STATE_COMMITTED, 
  STATE_ABORT, 
  STATE_ABORTING, 
  STATE_ABORTED, 
  STATE_BEGIN,
} STATE_OF_TRANS;
/*
 * Persistent Objects 
 */
typedef struct _PERSISTENT_DELETE_OBJ {
  char schemaName[BUFFSIZE];
  int tplid;
} PERSISTENT_DELETE_OBJ;
typedef struct _PERSISTENT_INSERT_OBJ {
  char schemaName[BUFFSIZE];
  void *objP;
  PAGEINFO pi;
} PERSISTENT_INSERT_OBJ;
typedef struct _PERSISTENT_APPEND_OBJ {
  char schemaName[BUFFSIZE];
  char attrName[BUFFSIZE];
  SDOBJ obj;
  PAGEINFO pi;
} PERSISTENT_APPEND_OBJ;
#ifndef _ATTR_LIST_H
#include "attrList.h"
#define _ATTR_LIST_H
#endif 

typedef struct _PERSISTENT_CREATE_OBJ {
  char schemaName[BUFFSIZE];
  int schemaSize;
  ATTR_LIST headAttrList;
} PERSISTENT_CREATE_OBJ;
typedef struct _PERSISTENT_DROP_OBJ {
  char schemaName[BUFFSIZE];
} PERSISTENT_DROP_OBJ;
typedef union _UNION_PERSISTENT_OBJ {
  PERSISTENT_CREATE_OBJ create;
  PERSISTENT_DROP_OBJ   drop;
  PERSISTENT_INSERT_OBJ insert;
  PERSISTENT_DELETE_OBJ delete;
  PERSISTENT_APPEND_OBJ append;
} UNION_PERSISTENT_OBJ;
typedef struct _PERSISTENT_OBJ {
  PERSISTENT_OBJ_TYPE type;
  UNION_PERSISTENT_OBJ u;
  struct _PERSISTENT_OBJ *next;
  struct _PERSISTENT_OBJ *prev;
} PERSISTENT_OBJ;


/*
 * Transaction Information
 */
/*
typedef struct _TRANS_INFO {
  int dbClientFd;
  int logfd;
  int transid;
  pthread_t pthreadid;
  PERSISTENT_OBJ head;
  PERSISTENT_OBJ *tailP;
  STATE_OF_TRANS stateOfTrans;
  struct _TRANS_INFO *next;
} TRANS_INFO;
*/

#define _TRANS_INFO_H
