/***************************************************************************
                          docSlots.cpp  -  description
                             -------------------
    begin                :   2 22 2003
    copyright            : (C) 2003 by K.Kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//using namespace std;
//#include <iostream>
#include <unistd.h>

// include files for Qt
#include <qdatetime.h>
#include <qlistview.h>
#include <qfile.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qmessagebox.h>
#include <qcombobox.h>
#include <qpixmap.h>
#include <qtextedit.h>
#include <qlineedit.h>
#include <qpainter.h>
#include <qframe.h>
#include <qspinbox.h>
#include <qtabwidget.h>
#include <qprogressbar.h>
#include <qpopupmenu.h>
#include <qradiobutton.h>
#include <qlabel.h>

// include files for KDE
#include <klocale.h>

// application specific includes
#include "kroneconfig.h"
#include "system.h"
#include "option.h"
#include "docTables.h"
#include "commonWgt.h"
#include "listTabs.h"
#include "varDlg.h"
#include "exeDlg.h"
#include "timeDlg.h"
#include "clockView.h"
#include "viewTabs.h"
#include "kronekoview.h"
#include "kroneko.h"
#include "kronekodoc.h"

extern Option* g_Option;
extern QDateTime* g_CurTime;
extern bool g_ViewMode;

//
// Initialize View
void KronekoDoc::setView( KronekoView *v )
{
  view = v;

//---------- listTab ----------
  connect( v->listTab,
            SIGNAL( currentChanged( QWidget* ) ), this,
            SLOT( slotListTabChanged( QWidget* ) ) );

//---------- viewTab ----------
  connect( v->viewTab,
            SIGNAL( currentChanged( QWidget* ) ), this,
            SLOT( slotViewTabChanged( QWidget* ) ) );

//---------- stngLvw ----------
  connect( v->stngLvw,
            SIGNAL( selectionChanged( QListViewItem* ) ), this,
            SLOT( slotStngListChanged( QListViewItem* ) ) );
  if ( !g_ViewMode ){
    connect( v->stngLvw,
            SIGNAL( doubleClicked( QListViewItem* ) ), this,
            SLOT( slotListEdit( QListViewItem* ) ) );
  }

//---------- execLvw ----------
  connect( v->execLvw,
            SIGNAL( selectionChanged( QListViewItem* ) ), this,
            SLOT( slotExecListChanged( QListViewItem* ) ) );
  if ( !g_ViewMode ){
    connect( v->execLvw,
            SIGNAL( doubleClicked( QListViewItem* ) ), this,
            SLOT( slotListEdit( QListViewItem* ) ) );
  }

#ifndef CRON_DILLON
//---------- logLvw ----------
  connect( v->logLvw,
            SIGNAL( selectionChanged( QListViewItem* ) ), this,
            SLOT( slotLogListChanged( QListViewItem* ) ) );
#endif

//---------- cronEditWgt ----------
  if ( !g_ViewMode ){
#ifndef CRON_DILLON
  connect( v->cronEditWgt->filCmb,
              SIGNAL( activated( int ) ), this,
              SLOT ( slotCronFileChange( int ) ) );
#endif
  connect( v->cronEditWgt->usrCmb,
              SIGNAL( activated( const QString& ) ), this,
              SLOT ( slotCronUserChange( const QString& ) ) );
  connect( v->cronEditWgt->cmtTed,
              SIGNAL( textChanged() ), this,
              SLOT ( slotCronCmntChanged() ) );
  connect( v->cronEditWgt->cmdLed,
              SIGNAL( textChanged( const QString& ) ), this,
              SLOT ( slotCronCmndChanged( const QString& ) ) );
  connect( v->cronEditWgt->timLed,
              SIGNAL( textChanged( const QString& ) ), this,
              SLOT ( slotCronTimeChanged( const QString& ) ) );
  connect( v->cronEditWgt->timBtn,
              SIGNAL( clicked() ), this,
              SLOT( slotCronTimeEdit() ) );
  connect( v->cronEditWgt->varBtn,
              SIGNAL( clicked() ), this,
              SLOT( slotCronVarDlg() ) );
  connect( v->cronEditWgt->modBtn,
              SIGNAL( clicked() ), this,
              SLOT( slotCronModify() ) );
  connect( v->cronEditWgt->creBtn,
              SIGNAL( clicked() ), this,
              SLOT( slotCronCreate() ) );
  connect( v->cronEditWgt->delBtn,
              SIGNAL( clicked() ), this,
              SLOT( slotCronDelete() ) );
  connect( v->cronEditWgt->exeBtn,
              SIGNAL( clicked() ), this,
              SLOT( slotCronExecute() ) );

//---------- anacEditWgt ----------
  if ( System::getAnacStatus() & ANAC_WRITABLE ){
    connect( v->anacEditWgt->cmtTed,
              SIGNAL( textChanged() ), this,
              SLOT ( slotAnacCmntChanged() ) );
    connect( v->anacEditWgt->cmdLed,
              SIGNAL( textChanged( const QString& ) ), this,
              SLOT ( slotAnacCmndChanged( const QString& ) ) );
    connect( v->anacEditWgt->idtLed,
              SIGNAL( textChanged( const QString& ) ), this,
              SLOT ( slotAnacIdentChanged( const QString& ) ) );
    connect( v->anacEditWgt->prdSpb,
              SIGNAL( valueChanged( int ) ), this,
              SLOT ( slotAnacPeriodChanged( int ) ) );
    connect( v->anacEditWgt->dlySpb,
              SIGNAL( valueChanged( int ) ), this,
              SLOT ( slotAnacDelayChanged( int ) ) );
    connect( v->anacEditWgt->varBtn,
              SIGNAL( clicked() ), this,
              SLOT( slotAnacVarDlg() ) );
    connect( v->anacEditWgt->modBtn,
              SIGNAL( clicked() ), this,
              SLOT( slotAnacModify() ) );
    connect( v->anacEditWgt->creBtn,
              SIGNAL( clicked() ), this,
              SLOT( slotAnacCreate() ) );
    connect( v->anacEditWgt->delBtn,
              SIGNAL( clicked() ), this,
              SLOT( slotAnacDelete() ) );
    connect( v->anacEditWgt->exeBtn, SIGNAL( clicked() ),
             this, SLOT( slotAnacExecute() ) );
  }
  
//---------- atEditWgt ----------
  connect( v->atEditWgt->timLed,
              SIGNAL( textChanged( const QString& ) ), this,
              SLOT ( slotAtTimeChanged( const QString& ) ) );
  connect( v->atEditWgt->timBtn,
              SIGNAL( clicked() ), this,
              SLOT( slotAtTimeEdit() ) );
  connect( v->atEditWgt->cmdTed,
              SIGNAL( textChanged() ), this,
              SLOT ( slotAtCmndChanged() ) );
  connect( v->atEditWgt->queLed,
              SIGNAL( textChanged( const QString& ) ), this,
              SLOT ( slotAtQueChanged( const QString& ) ) );
  connect( v->atEditWgt->monRdb,
              SIGNAL( clicked() ), this,
              SLOT( slotAtMailOn() ) );
  connect( v->atEditWgt->mofRdb,
              SIGNAL( clicked() ), this,
              SLOT( slotAtMailOff() ) );
  connect( v->atEditWgt->modBtn,
              SIGNAL( clicked() ), this,
              SLOT( slotAtModify() ) );
  connect( v->atEditWgt->creBtn,
              SIGNAL( clicked() ), this,
              SLOT( slotAtCreate() ) );
  connect( v->atEditWgt->delBtn,
              SIGNAL( clicked() ), this,
              SLOT( slotAtDelete() ) );
  connect( v->atEditWgt->exeBtn,
              SIGNAL( clicked() ), this,
              SLOT( slotAtExecute() ) );
  }
  startTimer( 1000 );


}

//
// Timer Event
void KronekoDoc::timerEvent( QTimerEvent* )
{
  // Get Current Date Time
  *g_CurTime = QDateTime::currentDateTime();
  int sec = g_CurTime->time().second();

  // Clear MiliSecond
  g_CurTime->setTime( QTime( g_CurTime->time().hour(), g_CurTime->time().minute(), sec ) );

  // Display Clock Time
  if ( sec == 0 ) {
    // Reset Next Time of All List
    pStart( RUN_LIST_TIME );
  }else{
    if ( curView == VIEW_CLOCK ) view->clockWgt->dspCurTime();

    // Play Sound
    if ( g_Option->useSound ){
      if ( sec == ( 60 - g_Option->soundSec ) ){
        for ( QListViewItemIterator it( view->stngLvw ); it.current(); ++it ){
          TabLvi *c = (TabLvi*)it.current();
          if ( c->dType != ANACRON ){
            if ( g_CurTime->secsTo( c->Next ) <= g_Option->soundSec ){
              QString fn = CwaveFile( g_Option->soundName ).fullName;
              QString cstr = System::getCommand( SOUND_CMD ) + " " + fn;
              Command cmd( cstr, true );
              break;
            }            
          }
        }
      }
    }
  }
}

//---------- listTab ----------
//
// List Tab Changed
void KronekoDoc::slotListTabChanged(QWidget *w)
{
  if ( w == view->stngLvw ) {
    // Setting List
    curList = LIST_STNG;
  }else if ( w == view->execLvw ) {
    // Execute List
    curList = LIST_EXEC;
#ifndef CRON_DILLON
  }else if ( w == view->logLvw ) {
    // Log List
    curList = LIST_LOG;
#endif
  }
  
  // Initialize View
  dspView();
}


//---------- viewTab ----------
//
// View Tab Changed
void KronekoDoc::slotViewTabChanged(QWidget *w)
{
  if ( w == view->clockWgt ) {
    // Clock View
    curView = VIEW_CLOCK;
  } else if ( w == view->detailWgt ) {
    // Detail View
    curView = VIEW_DETAIL;
  }else{
    // Edit View
    curView = VIEW_EDIT;
  }
  // Initialize View
  dspView();
}

//---------- stngLvw ----------
//
// Setting List Selected
void KronekoDoc::slotStngListChanged(QListViewItem *i)
{
  // Current List View Item
  curStngItem = (TabLvi *)i;
  // Initialize View  
  dspView();
}

//---------- execLvw ----------
//
// Execute List Selected
void KronekoDoc::slotExecListChanged(QListViewItem *i)
{
  // Current List View Item
  curExecItem = (TabLvi *)i;
  // Initialize View
  dspView();
}

//---------- logLvw ----------
//
// Execute List Selected
void KronekoDoc::slotLogListChanged(QListViewItem *i)
{
  // Current List View Item
  curLogItem = (TabLvi *)i;
  // Initialize View
  dspView();
}


//
// Edit Selected Item
void KronekoDoc::slotListEdit(QListViewItem*)
{
  editSelect();
}

//---------- cronEditWgt ----------
//
// File Name Change
void KronekoDoc::slotCronFileChange(int i)
{
#ifndef CRON_DILLON
  CronEditWgt *e = view->cronEditWgt;

  if ( e->filCmb->count() == 1 ) return;
  QString u;
  if ( i == 0 ){
    // System 'crontab'
    e->editCron->cronType = CRON_ETC;
    // Initialize User ComboBox
    e->usrCmb->setUser( UserComboBox::All );
    u = "";
  }else{
    // User 'crontab'
    e->editCron->cronType = CRON_USER;
    if ( System::uid() == 0 ){
      // Initialize User ComboBox
      e->usrCmb->setUser( UserComboBox::AllowCron );
      QStringList sl = System::cronUsers();
      if ( sl.find( e->editCron->User ) == sl.end() ){
        e->editCron->User = sl.first();
      }
    }else{
      // Initialize User ComboBox
      e->editCron->User = System::uName();
      e->usrCmb->setUser( UserComboBox::Current );
      e->filCmb->iniFile( e->editCron->User, CRON_USER );
//      e->filCmb->setCurrent( CRON_USER  );      // User File
    }
    u = e->editCron->User;
  }
  // Get Current User Table
  for( UserTbl* ut=userTbl.first(); ut; ut=userTbl.next() ){
    if ( ut->dType == CRON && ut->User == u ){
      if ( ut->Flag & NO_DATA ) newCronUser( ut );
      // Set User Table
      e->editCron->userTbl = ut;
      // Variable
      e->varLvw->setVar(ut->Vars);
      break;
    }
  }
  // Current User
  e->usrCmb->setCurrentText( e->editCron->User );

  // Set Button
  e->setButton( *curEditCron );
#endif

}

//
// User Change
void KronekoDoc::slotCronUserChange(const QString & s)
{
  CronEditWgt *e = view->cronEditWgt;

  // Set User
  e->editCron->User = s;

#ifdef CRON_DILLON
  for( UserTbl* ut=userTbl.first(); ut; ut=userTbl.next() ){
    if ( ut->dType == CRON && ut->User == s ) {
      if ( ut->Flag & NO_DATA ) newCronUser( ut );
      e->editCron->userTbl = ut;
      e->varLvw->setVar(ut->Vars);
      break;
    }
  }
#else
  if ( e->editCron->cronType == CRON_USER ) {
    // User 'crontab'
    for( UserTbl* ut=userTbl.first(); ut; ut=userTbl.next() ){
      if ( ut->dType == CRON && ut->User == s ) {
        if ( ut->Flag & NO_DATA ) newCronUser( ut );
        e->editCron->userTbl = ut;
        e->varLvw->setVar(ut->Vars);
        break;
      }
    }
    e->filCmb->iniFile( e->editCron->User, CRON_USER );
  }
#endif

  // Set Button
  e->setButton( *curEditCron );
}

//
// Comment Change
void KronekoDoc::slotCronCmntChanged()
{
  // Set Comment
  CronEditWgt *e = view->cronEditWgt;
  e->editCron->Cmnt = e->cmtTed->text();

  // Set Button
  e->setButton( *curEditCron );
}

//
// Command Change
void KronekoDoc::slotCronCmndChanged(const QString &s)
{
  // Set Command
  CronEditWgt *e = view->cronEditWgt;
  e->editCron->Cmnd = s;

  // Set Button
  e->setButton( *curEditCron );
}

//
// Time Change
void KronekoDoc::slotCronTimeChanged(const QString &s)
{
  // Set Time
  CronEditWgt *e = view->cronEditWgt;
  e->editCron->Time = s;

  // Set Button
  e->setButton( *curEditCron );
}

//
// Time Edit Dialog Button
void KronekoDoc::slotCronTimeEdit()
{

  CronEditWgt *e = view->cronEditWgt;
  // Time Edit Dialog
  CronTimeDlg dlg( e->timLed->text() );

  if ( dlg.exec() == QDialog::Accepted ){
    // Set Time
    e->timLed->setText( dlg.getTime() );
  }
  
}

//
// Variable Edit Dialog Button
void KronekoDoc::slotCronVarDlg()
{
  CronEditWgt *e = view->cronEditWgt;

  // File Name
  QString fn;
#ifdef CRON_DILLON
  fn = g_Option->cronPathSpool + "/" + e->editCron->User;
#else
  if ( e->editCron->cronType == CRON_USER )
    fn = g_Option->cronPathSpool + "/" + e->editCron->User;
  else
    fn = g_Option->cronFileSys;
#endif
    
  // Variable Edit Dialog
  VarDlg dlg( fn, e->editCron->userTbl, true );
  if ( dlg.exec() == QDialog::Accepted ){
    if ( QMessageBox::information( getApp(),
          i18n("Modify Data"), i18n("If Changed Variable, Affect All Task.\nUpdate Data ?"),
          "OK", "Cancel" ) != 0 ){
      return;
    }
    e->editCron->userTbl->Head = dlg.getHead();      // Header Comment
    // Variable
    e->varLvw->clear();
    e->editCron->userTbl->Vars->clear();
    for ( QListViewItemIterator it( dlg.varLvw ); it.current(); ++it ){
      VarListViewItem *v = (VarListViewItem *)it.current();
      e->editCron->userTbl->Vars->append( new VarTbl( v->name, v->value, v->cmnt ) );
    }
    e->varLvw->setVar(e->editCron->userTbl->Vars);
    e->editCron->userTbl->Flag |= EDIT_MODIFY;
    bUpdate = true;
    view->stngLvw->resetFlag();
    view->execLvw->resetFlag();
  }
}

//
// Modify
void KronekoDoc::slotCronModify()
{

  // Data Check
  QString estr = chkCron( view->cronEditWgt->editCron );
  if ( estr != "" ){
    QMessageBox::warning( getApp(),i18n("'crontab' Data Check"), estr );
    return;
  }
  
  CronEditWgt *e = view->cronEditWgt;

  // Save Button Enable
  bUpdate = true;

  // Remove Editing Data
  bool nflg = false;
#ifdef CRON_DILLON
  if ( e->editCron->User != curEditCron->User ) nflg = true;
#else
  if ( curEditCron->cronType != e->editCron->cronType ) {
    nflg = true;
  }else if ( e->editCron->cronType == CRON_USER ){
    if ( e->editCron->User != curEditCron->User ) nflg = true;     
  }
#endif
  int flg = curEditCron->Flag;

  // Editing Modified Data
  if ( nflg ){
    curEditCron->Flag = EDIT_DELETE;
    curEditCron = new CronTbl();
    *curEditCron = *e->editCron;
    curEditCron->Flag = EDIT_CREATE | EDIT_CURRENT;
    cronTbl.append( curEditCron );
  }else{
    TabLvi *c = view->stngLvw->getItem( (void*)curEditCron );
    if ( c != NULL ) view->stngLvw->takeItem( c );
    *curEditCron = *e->editCron;
    curEditCron->Flag = flg | EDIT_MODIFY;
  }    
  curStngItem = view->stngLvw->addItem(curEditCron, CronTime(curEditCron).GetNextTime(*g_CurTime));
  view->stngLvw->setSelected( curStngItem, true );

  // Set Button
  e->setButton( *curEditCron );
  // Reset Execute List
  view->stngLvw->resetFlag();
  pStart( RUN_LIST_EXEC );
}

//
// Create
void KronekoDoc::slotCronCreate()
{

  // Data Check
  QString estr = chkCron( view->cronEditWgt->editCron );
  if ( estr != "" ) {
    QMessageBox::warning( getApp(),i18n("'crontab' Data Check"), estr );
    return;
  }

  // Save Button Enable
  bUpdate = true;

  // New 'crontab' Table
  if ( curEditCron != NULL ){
    curEditCron->Flag &= ~EDIT_CURRENT;
  }
  curEditCron = new CronTbl();
  *curEditCron = *view->cronEditWgt->editCron;
  curEditCron->Flag = EDIT_CREATE | EDIT_CURRENT;
  cronTbl.append( curEditCron );
  curStngItem = view->stngLvw->addItem(curEditCron, CronTime(curEditCron).GetNextTime(*g_CurTime));

  view->stngLvw->setSelected( curStngItem, true );
  // Set Button
  view->cronEditWgt->setButton( *curEditCron );
  // Reset Task List
  view->stngLvw->resetFlag();
  // Reset Execute List
  pStart( RUN_LIST_EXEC );

}

//
// Delete
void KronekoDoc::slotCronDelete()
{

  // Save Button Enable
  bUpdate = true;
  getApp()->fileSave->setEnabled( bUpdate );

  // Delete Flag ON
  curEditCron->Flag |= EDIT_DELETE;

  // Set Button
  view->cronEditWgt->setButton( *curEditCron );

  // Reset Pixmap
  view->stngLvw->resetFlag();
  view->execLvw->resetFlag();

}

//
// Execute
void KronekoDoc::slotCronExecute()
{
  if ( QMessageBox::information( getApp(),
          i18n("TEST Execute"), i18n("Execute Current Editing Command ?"),
          QMessageBox::Ok, QMessageBox::Cancel ) == QMessageBox::Ok ){
    ExeDlg dlg( view->cronEditWgt->editCron );
    dlg.exec();
  }
}


//---------- anacEditWgt ----------
//
// Comment Change
void KronekoDoc::slotAnacCmntChanged()
{
  // Set Comment
  AnacEditWgt *e = view->anacEditWgt;
  e->editAnac->Cmnt = e->cmtTed->text();

  // Set Button
  e->setButton( *curEditAnac );
}

//
// Command Change
void KronekoDoc::slotAnacCmndChanged(const QString &s)
{
  // Set Command
  AnacEditWgt *e = view->anacEditWgt;
  e->editAnac->Cmnd = s;

  // Set Button
  e->setButton( *curEditAnac );
}

//
// Ident Change
void KronekoDoc::slotAnacIdentChanged(const QString &s)
{
  // Set Ident
  AnacEditWgt *e = view->anacEditWgt;
  e->editAnac->Idnt = s;

  // Set Button
  e->setButton( *curEditAnac );
}

//
// Period Change
void KronekoDoc::slotAnacPeriodChanged( int v )
{
  // Set Period
  AnacEditWgt *e = view->anacEditWgt;
  e->editAnac->Prod = v;

  // Set Button
  e->setButton( *curEditAnac );
}

//
// Delay Change
void KronekoDoc::slotAnacDelayChanged( int v )
{
  // Set Delay
  AnacEditWgt *e = view->anacEditWgt;
  e->editAnac->Dlay = v;

  // Set Button
  e->setButton( *curEditAnac );
}

//
// Variable Edit Button
void KronekoDoc::slotAnacVarDlg()
{
  
  AnacEditWgt *e = view->anacEditWgt;

  // Variable Edit Dialog
  VarDlg dlg( g_Option->anacFileSys, e->editAnac->userTbl, false );
  if ( dlg.exec() == QDialog::Accepted ){
    if ( QMessageBox::information( getApp(),
          i18n("Modify Data"), i18n("If Changed Variable, Affect All Task.\nUpdate Data ?"),
          QMessageBox::Ok, QMessageBox::Cancel ) == QMessageBox::Cancel ){
      return;
    }
    // Header
    bUpdate = true;
    e->editAnac->userTbl->Head = dlg.getHead();
    // Variables
    e->varLvw->clear();
    e->editAnac->userTbl->Vars->clear();
    for ( QListViewItemIterator it( dlg.varLvw ); it.current(); ++it ){
      VarListViewItem *v = (VarListViewItem *)it.current();
      e->editAnac->userTbl->Vars->append( new VarTbl( v->name, v->value, v->cmnt ) );
    }
    e->varLvw->setVar(e->editAnac->userTbl->Vars);

    // Set Modify
    e->editAnac->userTbl->Flag |= EDIT_MODIFY;

    // Reset Pixmap
    view->stngLvw->resetFlag();
    view->execLvw->resetFlag();
  }
}

//
// Modify
void KronekoDoc::slotAnacModify()
{

  // Data Check
  QString estr = chkAnac( view->anacEditWgt->editAnac, false );
  if ( estr != "" ) {
    QMessageBox::warning( getApp(), i18n("anacron Data Check"), estr );
    return;
  }

  // Save Button Enable
  bUpdate = true;

  // Remove Editing Data  
  AnacEditWgt *e = view->anacEditWgt;
  int flg = curEditAnac->Flag;
  TabLvi *c = view->stngLvw->getItem( (void*)curEditAnac );
  if ( c != NULL ) view->stngLvw->takeItem( c );

  // Add Current Modified Data
  *curEditAnac = *e->editAnac;
  int p = curEditAnac->Prod;
  if ( p == 0 ) p = 2;
  curEditAnac->Mtim = g_CurTime->addDays( -p );
  curEditAnac->Mtim.setTime( g_Option->ponTime.addSecs(curEditAnac->Dlay*60) );
  curEditAnac->Flag = flg | EDIT_MODIFY;
  curStngItem = view->stngLvw->addItem(curEditAnac, CronTime(curEditAnac).GetNextTime(*g_CurTime));
  view->stngLvw->setSelected( curStngItem, true );

  // Set Button
  e->setButton( *curEditAnac );

  // Reset Execute List
  pStart( RUN_LIST_EXEC );

}

//
// Create
void KronekoDoc::slotAnacCreate()
{

  // Data Check
  QString estr = chkAnac( view->anacEditWgt->editAnac, true );
  if ( estr != "" ) {
    QMessageBox::warning( getApp(), i18n("anacron Data Check"), estr );
    return;
  }

  // Save Button Enable
  bUpdate = true;

  // Create 'anacron' Table
  if ( curEditAnac != NULL ){
    curEditAnac->Flag &= ~EDIT_CURRENT;
  }
  curEditAnac = new AnacTbl();
  *curEditAnac = *view->anacEditWgt->editAnac;

  // Not Executed
  int p = curEditAnac->Prod;
  if ( p == 0 ) p = 2;
  curEditAnac->Mtim = g_CurTime->addDays( -p );
  curEditAnac->Mtim.setTime( g_Option->ponTime.addSecs(curEditAnac->Dlay*60) );
  curEditAnac->Flag = EDIT_CREATE | EDIT_CURRENT;
  anacTbl.append( curEditAnac );
  curStngItem = view->stngLvw->addItem(curEditAnac, CronTime(curEditAnac).GetNextTime(*g_CurTime));

  view->stngLvw->setSelected( curStngItem, true );
  // Set Button
  view->anacEditWgt->setButton( *curEditAnac );

  // Reset Task List
  view->stngLvw->resetFlag();

  // Reset Execute List
  pStart( RUN_LIST_EXEC );

}

//
// Delete
void KronekoDoc::slotAnacDelete()
{

  // Save Button Enable
  bUpdate = true;

  curEditAnac->Flag |= EDIT_DELETE;
  getApp()->fileSave->setEnabled( bUpdate );

  // Set Button
  view->anacEditWgt->setButton( *curEditAnac );

  // Reset Pixmap
  view->stngLvw->resetFlag();
  view->execLvw->resetFlag();

}

//
// Execute
void KronekoDoc::slotAnacExecute()
{
  if ( QMessageBox::information( getApp(),
          i18n("TEST Execute"), i18n("Execute Current Editing Command ?"),
          QMessageBox::Ok, QMessageBox::Cancel ) == QMessageBox::Ok ){
    ExeDlg dlg( view->anacEditWgt->editAnac, 1 );
    dlg.exec();
  }
}


//---------- atEditWgt ----------
//
// Command Change
void KronekoDoc::slotAtCmndChanged()
{
  // Set Command
  AtEditWgt *e = view->atEditWgt;
  e->editAt->Cmnd = e->cmdTed->text();

  // Set Button
  e->setButton( *curEditAt );
}

//
// Time Change
void KronekoDoc::slotAtTimeChanged(const QString &s)
{
  // Set Time
  AtEditWgt *e = view->atEditWgt;
  e->editAt->Time = QDateTime::fromString( s, Qt::ISODate );

  // Set Button
  e->setButton( *curEditAt );
}

//
// Queue Chenage
void KronekoDoc::slotAtQueChanged(const QString &s)
{
  // Set Queue
  AtEditWgt *e = view->atEditWgt;
  e->editAt->Qno = s[0];

  // Set Button
  e->setButton( *curEditAt );
}

//
// Time Edit Dialog
void KronekoDoc::slotAtTimeEdit()
{

  AtEditWgt *e = view->atEditWgt;

  // Time Check
  if ( ! e->editAt->Time.date().isValid() ){
    QMessageBox::warning( getApp(), i18n("Date Error"), i18n("Invalid Date.\nChanged Date Time") );
    e->editAt->Time = g_CurTime->addSecs( g_Option->atNewTime*60 );
    e->timLed->setText( e->editAt->Time.toString( "yyyy-MM-dd hh:mm" ) );
  }
  if ( ! e->editAt->Time.time().isValid() ){
    QMessageBox::warning( getApp(), i18n("Time Error"), i18n("Invalid Time.\nChanged Time") );
    e->editAt->Time.setTime( QTime( 0, 0, 0 ) );
    e->timLed->setText( e->editAt->Time.toString( "yyyy-MM-dd hh:mm" ) );
  }
  AtTimeDlg dlg( e->editAt->Time );
  if (  dlg.exec() == QDialog::Accepted ){
    e->timLed->setText(dlg.getTime());
  }
}

//
// Mail On
void KronekoDoc::slotAtMailOn()
{
  AtEditWgt *e = view->atEditWgt;
  e->editAt->Mail = 1;
  e->setButton( *curEditAt );
}

//
// Mail Off
void KronekoDoc::slotAtMailOff()
{
  AtEditWgt *e = view->atEditWgt;
  e->editAt->Mail = 0;
  e->setButton( *curEditAt );
}

//
// Modify
void KronekoDoc::slotAtModify()
{

  if ( ! chkAt( view->atEditWgt->editAt ) ) return;

  // Save Button Enable
  bUpdate = true;

  AtEditWgt *e = view->atEditWgt;
  int flg = curEditAt->Flag;
  TabLvi *c = view->stngLvw->getItem( (void*)curEditAt );
  if ( c != NULL ) view->stngLvw->takeItem( c );

  *curEditAt = *e->editAt;
  curEditAt->Flag = flg | EDIT_MODIFY;
  curStngItem = view->stngLvw->addItem(curEditAt);
  view->stngLvw->setSelected( curStngItem, true );

  // Set Button
  e->setButton( *curEditAt );

  // Reset Execute List
  pStart( RUN_LIST_EXEC );

}

//
// Create
void KronekoDoc::slotAtCreate()
{

  if ( ! chkAt( view->atEditWgt->editAt ) ) return;

  // Save Button Enable
  bUpdate = true;

//  if ( curEditAt->Flag & EDIT_DELETE ){
  if ( curEditAt != NULL ){
    curEditAt->Flag &= ~EDIT_CURRENT;
  }
//  }
//    curStngItem =  view->stngLvw->getItem( curEditAt );
//    view->stngLvw->resetFlag();
//  }else{
  curEditAt = new AtTbl();
  *curEditAt = *view->atEditWgt->editAt;
  curEditAt->User = System::uName();
  curEditAt->Flag = EDIT_CREATE | EDIT_CURRENT;
  curEditAt->exeCnt = 0;
  atTbl.append( curEditAt );
  curStngItem = view->stngLvw->addItem(curEditAt);
//  }
  view->stngLvw->setSelected( curStngItem, true );

  // Set Button
  view->atEditWgt->setButton( *curEditAt );
  // Reset Task List
  view->stngLvw->resetFlag();
  // Reset Execute List
  pStart( RUN_LIST_EXEC );

}

//
// Delete
void KronekoDoc::slotAtDelete()
{

  // Save Button Enable
  bUpdate = true;
  getApp()->fileSave->setEnabled( bUpdate );

  curEditAt->Flag = EDIT_DELETE | EDIT_CURRENT;
  view->stngLvw->resetFlag();
  view->execLvw->resetFlag();

  // Set Button
  view->atEditWgt->setButton( *curEditAt );

}

//
// Execute
void KronekoDoc::slotAtExecute()
{
  if ( QMessageBox::information( getApp(),
          i18n("TEST Execute"), i18n("Execute Current Editing Command ?"),
          QMessageBox::Ok, QMessageBox::Cancel ) == QMessageBox::Ok ){
    ExeDlg dlg( view->atEditWgt->editAt );
    dlg.exec();
  }
}
