/***************************************************************************
                          kroneko.h  -  description
                             -------------------
    begin                :   2  8 00:43:28 JST 2003
    copyright            : (C) 2003 by kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRONEKO_H
#define KRONEKO_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt

// include files for KDE 
#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kaction.h>
#include <kurl.h>

// forward declaration of the Kroneko classes
class KronekoDoc;
class KronekoView;
class QProgressBar;
class RuneDlg;

/**
  * The base class for Kroneko application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KronekoView creates your center view, which is connected
  * to the window's Doc object.
  * KronekoApp reimplements the methods that KMainWindow provides for main window handling and supports
  * full session management as well as using KActions.
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
class KronekoApp : public KMainWindow
{
  Q_OBJECT

  friend class KronekoView;

  public:
    /** construtor of KronekoApp, calls all init functions to create the application.
     */
    KronekoApp(QWidget* parent=0, const char* name=0);
    ~KronekoApp();

  protected:
    /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
     * file
     */ 	
    void saveOptions();
    /** read general Options again and initialize all variables like the recent file list
     */
    void readOptions();
    /** initializes the KActions of the application */
    void initActions();
    /** sets up the statusbar for the main window by initialzing a statuslabel.
     */
    void initStatusBar();
    /** initializes the document object of the main window that is connected to the view in initView().
     * @see initView();
     */
    void initDocument();
    /** creates the centerwidget of the KTMainWindow instance and sets it as the view
     */
    void initView();
    /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's
     * properties.
     * @see KTMainWindow#queryExit
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryExit();

  public slots:
    /** save a document */
    void slotFileSave();
    /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
     * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
     */
    void slotFileQuit();
    /** toggles the toolbar
     */
    void slotViewToolBar();
    /** toggles the statusbar
     */
    void slotViewStatusBar();
    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */
    /** New Cron Data */
    void slotFileNewCron();
    /** New Anacron Data */
    void slotFileNewAnac();
    /** New At Data */
    void slotFileNewAt();
    /** Edit Select */
    void slotFileEdit();
    /** Edit Time */
    void slotFileTime();
    /** Reload Data */
    void slotFileReload();
    /** Reload Log Data */
    void slotFileLogReload();
    /** show statistic
     */
    void slotFileDetail();
    /** Remove From Execute List */
    void slotFileRemExe();
    
    void slotStatusMsg(const QString &text);

    void slotStatusMsgTotal();

    /** Status of User Count */
    void slotStatusMsgUser( const QString& u, int u_t, int e_t );

    void slotProgressBar( int pgs );
    /** set preferences
     */
    void slotPreferences();
    /** show Todays Tips
     */
    void slotRuneOfToday();

  public:
    /** the configuration object of the application */
    KConfig *config;
    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
    KronekoView *view;
    /** doc represents your actual document and is created only once. It keeps
     * information such as filename and does the serialization of your files.
     */
    KronekoDoc *doc;

    QProgressBar *statusProgress;

    RuneDlg* rune;

    // KAction pointers to enable/disable actions
    KAction* fileSave;
    KAction* fileQuit;
    KToggleAction* viewToolBar;
    KToggleAction* viewStatusBar;
    
    KAction* fileReload;
#ifndef CRON_DILLON
    KAction* fileLogReload;
#endif
    KAction* fileNewCron;
    KAction* fileNewAnac;
    KAction* fileNewAt;
    KAction* fileEdit;
    KAction* fileTime;
    KAction* fileDetail;
    KToggleAction* fileRemExe;    // Remove From Execute List
    KAction* setPreferences;

    KAction* runeTip;

};
 
#endif // KRONEKO_H
