/***************************************************************************
                          clockView.h  -  description
                             -------------------
    begin                :   2 22 2003
    copyright            : (C) 2003 by K.Kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef CLOCKVIEW_H
#define CLOCKVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <math.h>

// include files for Qt

// include files for KDE

// forward declaration

#define RAD ( 3.14159265 * 2.0 )

/**
  * Clock Configuration Class
  */
class ClockConfig
{
  public:
    /** Constructor */
    ClockConfig();

    /** Get Color from string : "r,g,b" */
    QColor  getColor( const QString& c );

    QPixmap backImage;          // Background Image
    QPixmap clockImage;         // Clock Image
    QFont   font;           // Font ( Forground )
    QPen    forgFramePen;       // Frame Pen ( Forground )
    QPen    backFramePen;       // Frame Pen ( Shadow )
    QPen    forgTextPen;        // Text Pen ( Forground )
    QPen    backTextPen;        // Text Pen ( Shadow );
    QPen    forgStextPen;       // Select Text Pen ( Forground )
    QPen    backStextPen;      // Select Text Pen ( Background )
    QPen    handPen;            // Hand Frame
    QBrush  handBrush;          // Hand Brush
    QPen    secPen;             // Second Hand Pen
//    QBrush  secBrush;           // Second Hand Brush
    QPen    ivalPen;            // Interval Circle Pen
    QPen    nextHandPen;        // Next Time Hand Pen
    QBrush  nextHandBrush;      // Next Time Brush
    QSize   clockSize;          // Clock Diamiter
    int     shortHandSpace;     // Short Hand Space
    int     middleHandSpace;    // Middle Hand Space
    int     frameSpace;         // Frame Space
};

/**
  * Clock Painter Class
  */
class PaintClock : public QPainter
{

  public:
    /** Constructor */
    PaintClock(const QPaintDevice *pd, const QPoint& cent);

    /** Initialize Frame */
    void initFrame();
    /** Draw Year */
    void drawYear( int cur, int next, bool flg );
    /** Draw Month */
    void drawMonth( int cur, int next, int sec, int days  );
    /** Draw Week */
    void drawWeek( int cur, int next, int sec  );
    /** Draw Day */
    void drawDay( int cur, int next, int sec, int days  );
    /** Draw Hour */
    void drawHour( int cur, int next, int sec  );
    /** Draw Min */
    void drawMin( int cur, int next, int sec  );
    /** Draw Second */
    void drawSec(  int sec, int n );

//  private:
    /** Get Circle X Position */
    inline int getCirX( double d, int l /* Radius */ )
          { return ( int( cos( RAD * ( 1.25 - d ) ) * l ) ); }
    /** Get Circle Y Position */
    inline int getCirY( double d, int l /* Radius */ )
          { return ( int( sin( RAD * ( 0.75 + d ) ) * l ) ); }
    /** Draw Circle */
//    inline void drwCircle( int l /* Radius */)
//          { drawEllipse( -(l), -(l), l*2, l*2 );  }
    void drwCircle( int l /* Radius */);

    /** Draw Cirlce Line */
    void drwCirLine( double d, int l, int sz );
    /** Draw Number Text */
    void drwNum( int l, double d, int num );
    /** Draw Pie */
    void drwPie( double d1, double d2, int l );
    /** Draw Arc */
    void drwArc( double d1, double d2, int l );
    /** Draw Interval Arc */
    void drwIval( double d1, double d2, int l );
    /** Draw Number */
    void drwYearN( int s, int n );     // Year
    void drwMonthN( int n );    // Month
    void drwWeekN( int n );     // Week
    void drwDayN( int n );      // Day
    void drwHourN( int n );     // Hour
    void drwMinN( int n );      // Minute

    /** Center Position */
    QPoint center;
    /** Circle Diamiter */
    int     cir1, cir2, cir3, cir4, cir5;
    QPen  penBack;
    QPen  penForg;

};

/**
  * Clock Class
  */
class ClockView : public QFrame
{
  public:
    /** Constructor */
    ClockView( QWidget *p );

    /** Initialize Clock 'cron' time */
    void iniClock( CronTbl *cr, QDateTime* t );
    /** Initialize Clock 'anacron' time */
    void iniClock( AnacTbl *an, QDateTime* t );
    /** Initialize Clock Next time */
    void iniClock(QDateTime* t, CronBit* c=NULL );
    /** Draw Current and Next Time */
    void drawTime();
    /** Initialize Frame */
    void iniFrame( bool clkIni );

  private:

    /** Frame Pixmap */
    QPixmap     *pixFrame;
    /** Clock Pixmap */
    QPixmap     *pixCron;
    /** Next Time */
    QDateTime   *nextTime;
    /** Cron Bit */
    CronBit     *cronBit;
    /** Event(Paint) */
    void paintEvent( QPaintEvent* );
    /** Event(Resize) */
    void resizeEvent( QResizeEvent* );
    /** Previous Draw Second */
    int PrevSec;
    /** Start Year */
    int startYear;

};

#endif // CLOCKVIEW_H
