/***************************************************************************
                          varDlg.h  -  description
                             -------------------
    begin                :   2 22 2003
    copyright            : (C) 2003 by K.Kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef VARDLG_H
#define VARDLG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qtextedit.h>
#include <qlist.h>
#include <qlistview.h>

// include files for KDE
#include <kdialog.h>

// forward declaration
class QTextEdit;
class QLineEdit;
class QPushButton;
class UserTbl;
class VarTbl;
class VarListView;
class UserComboBox;
class CButtonGroup;

/**
  * Variable Dialog Class
  */
class VarDlg : public KDialog
{
  Q_OBJECT
  public:
    /** Constructor */
    VarDlg(const QString& fname, UserTbl* envs, bool mflg );
    /** Destructor */
    ~VarDlg() {}

    inline QString getHead() { return hedTed->text(); }

  private:
    /** Set Mail Radio Button from Variable */
    void  setMailFromVar();
    /** Set create/modify/delete/ok button Enable/Disable */
    void  setButtons();

    QTextEdit     *hedTed;      // Comment Edit
    QTextEdit     *cmtTed;      // Variable Comment Edit
    QLineEdit     *namLed;      // Variable Name
    QLineEdit     *valLed;      // Variable Valune
    CButtonGroup  *mailGrp;     // Mail Button Group
    CButtonGroup  *varGrp;      // Variable Button (Modify/Create/Delete)
    UserComboBox  *usrCmb;      // Mail Send User Combo Box
    QPushButton   *okBtn;       // OK Button
    bool  mailFlag;             // Mail flag

  public:
    VarListView   *varLvw;      // Variable List Box


  protected slots:
    /** Header Changed */
    void slotHeaderChanged();
    /** Variable List Setect */
    void slotVarChanged(QListViewItem *i);
    /** Variable Name Changed */
    void slotNameChanged( const QString& );
    /** Variable Value Changed */
    void slotValueChanged( const QString& );
    /** Variable Comment Changed */
    void slotCommentChanged();
    /** Mail Send User Changed */
    void slotUserChanged( const QString& );
    /** Mail Mode Changed */
    void slotMailButtons(int);
    /** Variable Modify Actions */
    void slotVarButtons(int);

};

#endif // VARDLG_H
