/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.gameserver.ai.L2VehicleAI;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.actor.L2Vehicle;
import com.l2jserver.gameserver.model.actor.instance.L2BoatInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.VehicleDeparture;
import com.l2jserver.gameserver.network.serverpackets.VehicleInfo;
import com.l2jserver.gameserver.network.serverpackets.VehicleStarted;

public class L2BoatAI
extends L2VehicleAI {
    public L2BoatAI(L2Vehicle.AIAccessor accessor) {
        super(accessor);
    }

    @Override
    protected void moveTo(int x, int y, int z) {
        if (!this._actor.isMovementDisabled()) {
            if (!this._clientMoving) {
                this._actor.broadcastPacket(new VehicleStarted(this.getActor(), 1));
            }
            this._clientMoving = true;
            this._accessor.moveTo(x, y, z);
            this._actor.broadcastPacket(new VehicleDeparture(this.getActor()));
        }
    }

    @Override
    protected void clientStopMoving(L2CharPosition pos) {
        if (this._actor.isMoving()) {
            this._accessor.stopMove(pos);
        }
        if (this._clientMoving || pos != null) {
            this._clientMoving = false;
            this._actor.broadcastPacket(new VehicleStarted(this.getActor(), 0));
            this._actor.broadcastPacket(new VehicleInfo(this.getActor()));
        }
    }

    @Override
    public void describeStateToPlayer(L2PcInstance player) {
        if (this._clientMoving) {
            player.sendPacket(new VehicleDeparture(this.getActor()));
        }
    }

    @Override
    public L2BoatInstance getActor() {
        return (L2BoatInstance)this._actor;
    }
}

