/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2DropData;
import com.l2jserver.gameserver.model.L2MinionData;
import com.l2jserver.gameserver.model.L2NpcAIData;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import gnu.trove.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class NpcTable {
    private static Logger _log = Logger.getLogger(NpcTable.class.getName());
    private TIntObjectHashMap<L2NpcTemplate> _npcs = new TIntObjectHashMap();

    public static NpcTable getInstance() {
        return SingletonHolder._instance;
    }

    private NpcTable() {
        this.restoreNpcData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreNpcData() {
        Connection con = null;
        try {
            int npc_id;
            ResultSet NpcAIDataTable;
            L2NpcTemplate npcDat;
            L2DropData dropDat;
            ResultSet dropData;
            PreparedStatement statement2;
            int level;
            int skillId;
            int mobId;
            L2Skill npcSkill;
            L2NpcTemplate npcDat2;
            ResultSet npcskills;
            ResultSet npcdata;
            PreparedStatement statement;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                statement = con.prepareStatement("SELECT " + L2DatabaseFactory.getInstance().safetyString("id", "idTemplate", "name", "serverSideName", "title", "serverSideTitle", "class", "collision_radius", "collision_height", "level", "sex", "type", "attackrange", "hp", "mp", "hpreg", "mpreg", "str", "con", "dex", "int", "wit", "men", "exp", "sp", "patk", "pdef", "matk", "mdef", "atkspd", "aggro", "matkspd", "rhand", "lhand", "armor", "enchant", "walkspd", "runspd", "isUndead", "absorb_level", "absorb_type", "drop_herbs") + " FROM npc");
                npcdata = statement.executeQuery();
                this.fillNpcTable(npcdata, false);
                npcdata.close();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "NPCTable: Error creating NPC table.", e);
            }
            if (Config.CUSTOM_NPC_TABLE) {
                try {
                    statement = con.prepareStatement("SELECT " + L2DatabaseFactory.getInstance().safetyString("id", "idTemplate", "name", "serverSideName", "title", "serverSideTitle", "class", "collision_radius", "collision_height", "level", "sex", "type", "attackrange", "hp", "mp", "hpreg", "mpreg", "str", "con", "dex", "int", "wit", "men", "exp", "sp", "patk", "pdef", "matk", "mdef", "atkspd", "aggro", "matkspd", "rhand", "lhand", "armor", "enchant", "walkspd", "runspd", "isUndead", "absorb_level", "absorb_type", "drop_herbs") + " FROM custom_npc");
                    npcdata = statement.executeQuery();
                    this.fillNpcTable(npcdata, true);
                    npcdata.close();
                    statement.close();
                }
                catch (Exception e) {
                    _log.log(Level.SEVERE, "NPCTable: Error creating custom NPC table.", e);
                }
            }
            try {
                statement = con.prepareStatement("SELECT npcid, skillid, level FROM npcskills");
                npcskills = statement.executeQuery();
                npcDat2 = null;
                npcSkill = null;
                while (npcskills.next()) {
                    mobId = npcskills.getInt("npcid");
                    npcDat2 = (L2NpcTemplate)this._npcs.get(mobId);
                    if (npcDat2 == null) {
                        _log.warning("NPCTable: Skill data for undefined NPC. npcId: " + mobId);
                        continue;
                    }
                    skillId = npcskills.getInt("skillid");
                    level = npcskills.getInt("level");
                    if (npcDat2.race == null && skillId == 4416) {
                        npcDat2.setRace(level);
                        continue;
                    }
                    npcSkill = SkillTable.getInstance().getInfo(skillId, level);
                    if (npcSkill == null) continue;
                    npcDat2.addSkill(npcSkill);
                }
                npcskills.close();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "NPCTable: Error reading NPC skills table.", e);
            }
            if (Config.CUSTOM_NPC_SKILLS_TABLE) {
                try {
                    statement = con.prepareStatement("SELECT npcid, skillid, level FROM custom_npcskills");
                    npcskills = statement.executeQuery();
                    npcDat2 = null;
                    npcSkill = null;
                    while (npcskills.next()) {
                        mobId = npcskills.getInt("npcid");
                        npcDat2 = (L2NpcTemplate)this._npcs.get(mobId);
                        if (npcDat2 == null) {
                            _log.warning("Custom NPCTable: Skill data for undefined NPC. npcId: " + mobId);
                            continue;
                        }
                        skillId = npcskills.getInt("skillid");
                        level = npcskills.getInt("level");
                        if (npcDat2.race == null && skillId == 4416) {
                            npcDat2.setRace(level);
                            continue;
                        }
                        npcSkill = SkillTable.getInstance().getInfo(skillId, level);
                        if (npcSkill == null) continue;
                        npcDat2.addSkill(npcSkill);
                    }
                    npcskills.close();
                    statement.close();
                }
                catch (Exception e) {
                    _log.log(Level.SEVERE, "Custom NPCTable: Error reading NPC skills table.", e);
                }
            }
            try {
                statement2 = con.prepareStatement("SELECT " + L2DatabaseFactory.getInstance().safetyString("mobId", "itemId", "min", "max", "category", "chance") + " FROM droplist ORDER BY mobId, chance DESC");
                dropData = statement2.executeQuery();
                dropDat = null;
                npcDat = null;
                while (dropData.next()) {
                    mobId = dropData.getInt("mobId");
                    npcDat = (L2NpcTemplate)this._npcs.get(mobId);
                    if (npcDat == null) {
                        _log.warning("NPCTable: Drop data for undefined NPC. npcId: " + mobId);
                        continue;
                    }
                    dropDat = new L2DropData();
                    dropDat.setItemId(dropData.getInt("itemId"));
                    dropDat.setMinDrop(dropData.getInt("min"));
                    dropDat.setMaxDrop(dropData.getInt("max"));
                    dropDat.setChance(dropData.getInt("chance"));
                    int category = dropData.getInt("category");
                    if (ItemTable.getInstance().getTemplate(dropDat.getItemId()) == null) {
                        _log.warning("Drop data for undefined item template! NpcId: " + mobId + " itemId: " + dropDat.getItemId());
                        continue;
                    }
                    npcDat.addDropData(dropDat, category);
                }
                dropData.close();
                statement2.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "NPCTable: Error reading NPC dropdata. ", e);
            }
            if (Config.CUSTOM_DROPLIST_TABLE) {
                try {
                    statement2 = con.prepareStatement("SELECT " + L2DatabaseFactory.getInstance().safetyString("mobId", "itemId", "min", "max", "category", "chance") + " FROM custom_droplist ORDER BY mobId, chance DESC");
                    dropData = statement2.executeQuery();
                    dropDat = null;
                    npcDat = null;
                    int cCount = 0;
                    while (dropData.next()) {
                        int mobId2 = dropData.getInt("mobId");
                        npcDat = (L2NpcTemplate)this._npcs.get(mobId2);
                        if (npcDat == null) {
                            _log.warning("NPCTable: CUSTOM DROPLIST: Drop data for undefined NPC. npcId: " + mobId2);
                            continue;
                        }
                        dropDat = new L2DropData();
                        dropDat.setItemId(dropData.getInt("itemId"));
                        dropDat.setMinDrop(dropData.getInt("min"));
                        dropDat.setMaxDrop(dropData.getInt("max"));
                        dropDat.setChance(dropData.getInt("chance"));
                        int category = dropData.getInt("category");
                        if (ItemTable.getInstance().getTemplate(dropDat.getItemId()) == null) {
                            _log.warning("Custom drop data for undefined item template! NpcId: " + mobId2 + " itemId: " + dropDat.getItemId());
                            continue;
                        }
                        npcDat.addDropData(dropDat, category);
                        ++cCount;
                    }
                    dropData.close();
                    statement2.close();
                    _log.info("CustomDropList: Added " + cCount + " custom droplist.");
                }
                catch (Exception e) {
                    _log.log(Level.SEVERE, "NPCTable: Error reading NPC custom dropdata.", e);
                }
            }
            try {
                PreparedStatement statement3 = con.prepareStatement("SELECT " + L2DatabaseFactory.getInstance().safetyString("npc_id", "class_id") + " FROM skill_learn");
                ResultSet learndata = statement3.executeQuery();
                while (learndata.next()) {
                    int npcId = learndata.getInt("npc_id");
                    int classId = learndata.getInt("class_id");
                    L2NpcTemplate npc = this.getTemplate(npcId);
                    if (npc == null) {
                        _log.warning("NPCTable: Error getting NPC template ID " + npcId + " while trying to load skill trainer data.");
                        continue;
                    }
                    npc.addTeachInfo(ClassId.values()[classId]);
                }
                learndata.close();
                statement3.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "NPCTable: Error reading NPC trainer data.", e);
            }
            try {
                PreparedStatement statement4 = con.prepareStatement("SELECT " + L2DatabaseFactory.getInstance().safetyString("boss_id", "minion_id", "amount_min", "amount_max") + " FROM minions");
                ResultSet minionData = statement4.executeQuery();
                L2MinionData minionDat = null;
                L2NpcTemplate npcDat3 = null;
                int cnt = 0;
                while (minionData.next()) {
                    int raidId = minionData.getInt("boss_id");
                    npcDat3 = (L2NpcTemplate)this._npcs.get(raidId);
                    if (npcDat3 == null) {
                        _log.warning("Minion references undefined boss NPC. Boss NpcId: " + raidId);
                        continue;
                    }
                    minionDat = new L2MinionData();
                    minionDat.setMinionId(minionData.getInt("minion_id"));
                    minionDat.setAmountMin(minionData.getInt("amount_min"));
                    minionDat.setAmountMax(minionData.getInt("amount_max"));
                    npcDat3.addRaidData(minionDat);
                    ++cnt;
                }
                minionData.close();
                statement4.close();
                _log.info("NpcTable: Loaded " + cnt + " Minions.");
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "NPCTable: Error loading minion data.", e);
            }
            try {
                PreparedStatement statement10 = con.prepareStatement("SELECT " + L2DatabaseFactory.getInstance().safetyString("npc_id", "primary_attack", "skill_chance", "canMove", "soulshot", "spiritshot", "sschance", "spschance", "minrangeskill", "minrangechance", "maxrangeskill", "maxrangechance", "ischaos", "clan", "clan_range", "enemyClan", "enemyRange", "ai_type", "dodge") + " FROM npcAIData ORDER BY npc_id");
                NpcAIDataTable = statement10.executeQuery();
                L2NpcAIData npcAIDat = null;
                L2NpcTemplate npcDat4 = null;
                int cont = 0;
                while (NpcAIDataTable.next()) {
                    npc_id = NpcAIDataTable.getInt("npc_id");
                    npcDat4 = (L2NpcTemplate)this._npcs.get(npc_id);
                    if (npcDat4 == null) {
                        _log.severe("NPCTable: AI Data Error with id : " + npc_id);
                        continue;
                    }
                    npcAIDat = new L2NpcAIData();
                    npcAIDat.setPrimaryAttack(NpcAIDataTable.getInt("primary_attack"));
                    npcAIDat.setSkillChance(NpcAIDataTable.getInt("skill_chance"));
                    npcAIDat.setCanMove(NpcAIDataTable.getInt("canMove"));
                    npcAIDat.setSoulShot(NpcAIDataTable.getInt("soulshot"));
                    npcAIDat.setSpiritShot(NpcAIDataTable.getInt("spiritshot"));
                    npcAIDat.setSoulShotChance(NpcAIDataTable.getInt("sschance"));
                    npcAIDat.setSpiritShotChance(NpcAIDataTable.getInt("spschance"));
                    npcAIDat.setIsChaos(NpcAIDataTable.getInt("ischaos"));
                    npcAIDat.setShortRangeSkill(NpcAIDataTable.getInt("minrangeskill"));
                    npcAIDat.setShortRangeChance(NpcAIDataTable.getInt("minrangechance"));
                    npcAIDat.setLongRangeSkill(NpcAIDataTable.getInt("maxrangeskill"));
                    npcAIDat.setLongRangeChance(NpcAIDataTable.getInt("maxrangechance"));
                    npcAIDat.setClan(NpcAIDataTable.getString("clan"));
                    npcAIDat.setClanRange(NpcAIDataTable.getInt("clan_range"));
                    npcAIDat.setEnemyClan(NpcAIDataTable.getString("enemyClan"));
                    npcAIDat.setEnemyRange(NpcAIDataTable.getInt("enemyRange"));
                    npcAIDat.setDodge(NpcAIDataTable.getInt("dodge"));
                    npcAIDat.setAi(NpcAIDataTable.getString("ai_type"));
                    npcDat4.setAIData(npcAIDat);
                    ++cont;
                }
                NpcAIDataTable.close();
                statement10.close();
                _log.info("NPC AI Data Table: Loaded " + cont + " AI Data.");
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "NPCTable: Error reading NPC AI Data: " + e.getMessage(), e);
            }
            if (Config.CUSTOM_NPC_TABLE) {
                try {
                    statement = con.prepareStatement("SELECT " + L2DatabaseFactory.getInstance().safetyString("npc_id", "primary_attack", "skill_chance", "canMove", "soulshot", "spiritshot", "sschance", "spschance", "minrangeskill", "minrangechance", "maxrangeskill", "maxrangechance", "ischaos", "clan", "clan_range", "enemyClan", "enemyRange", "ai_type", "dodge") + " FROM custom_npcAIData ORDER BY npc_id");
                    NpcAIDataTable = statement.executeQuery();
                    L2NpcAIData npcAIDat = null;
                    L2NpcTemplate npcDat5 = null;
                    int cont = 0;
                    while (NpcAIDataTable.next()) {
                        npc_id = NpcAIDataTable.getInt("npc_id");
                        npcDat5 = (L2NpcTemplate)this._npcs.get(npc_id);
                        if (npcDat5 == null) {
                            _log.severe("NPCTable: Custom AI Data Error with id : " + npc_id);
                            continue;
                        }
                        npcAIDat = new L2NpcAIData();
                        npcAIDat.setPrimaryAttack(NpcAIDataTable.getInt("primary_attack"));
                        npcAIDat.setSkillChance(NpcAIDataTable.getInt("skill_chance"));
                        npcAIDat.setCanMove(NpcAIDataTable.getInt("canMove"));
                        npcAIDat.setSoulShot(NpcAIDataTable.getInt("soulshot"));
                        npcAIDat.setSpiritShot(NpcAIDataTable.getInt("spiritshot"));
                        npcAIDat.setSoulShotChance(NpcAIDataTable.getInt("sschance"));
                        npcAIDat.setSpiritShotChance(NpcAIDataTable.getInt("spschance"));
                        npcAIDat.setIsChaos(NpcAIDataTable.getInt("ischaos"));
                        npcAIDat.setShortRangeSkill(NpcAIDataTable.getInt("minrangeskill"));
                        npcAIDat.setShortRangeChance(NpcAIDataTable.getInt("minrangechance"));
                        npcAIDat.setLongRangeSkill(NpcAIDataTable.getInt("maxrangeskill"));
                        npcAIDat.setLongRangeChance(NpcAIDataTable.getInt("maxrangechance"));
                        npcAIDat.setClan(NpcAIDataTable.getString("clan"));
                        npcAIDat.setClanRange(NpcAIDataTable.getInt("clan_range"));
                        npcAIDat.setEnemyClan(NpcAIDataTable.getString("enemyClan"));
                        npcAIDat.setEnemyRange(NpcAIDataTable.getInt("enemyRange"));
                        npcAIDat.setDodge(NpcAIDataTable.getInt("dodge"));
                        npcAIDat.setAi(NpcAIDataTable.getString("ai_type"));
                        npcDat5.setAIData(npcAIDat);
                        ++cont;
                    }
                    NpcAIDataTable.close();
                    statement.close();
                    _log.info("NPC AI Data Table: Loaded " + cont + " Custom AI Data.");
                }
                catch (Exception e) {
                    _log.log(Level.SEVERE, "NPCTable: Error reading NPC Custom AI Data: " + e.getMessage(), e);
                }
            }
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    private void fillNpcTable(ResultSet NpcData, boolean customData) throws Exception {
        int count = 0;
        while (NpcData.next()) {
            StatsSet npcDat = new StatsSet();
            int id = NpcData.getInt("id");
            int idTemp = NpcData.getInt("idTemplate");
            assert (idTemp < 1000000);
            npcDat.set("npcId", id);
            npcDat.set("idTemplate", idTemp);
            int level = NpcData.getInt("level");
            npcDat.set("level", level);
            npcDat.set("jClass", NpcData.getString("class"));
            npcDat.set("baseShldDef", 0);
            npcDat.set("baseShldRate", 0);
            npcDat.set("baseCritRate", 38);
            npcDat.set("name", NpcData.getString("name"));
            npcDat.set("serverSideName", NpcData.getBoolean("serverSideName"));
            npcDat.set("title", NpcData.getString("title"));
            npcDat.set("serverSideTitle", NpcData.getBoolean("serverSideTitle"));
            npcDat.set("collision_radius", NpcData.getDouble("collision_radius"));
            npcDat.set("collision_height", NpcData.getDouble("collision_height"));
            npcDat.set("sex", NpcData.getString("sex"));
            npcDat.set("type", NpcData.getString("type"));
            npcDat.set("baseAtkRange", NpcData.getInt("attackrange"));
            npcDat.set("rewardExp", NpcData.getInt("exp"));
            npcDat.set("rewardSp", NpcData.getInt("sp"));
            npcDat.set("basePAtkSpd", NpcData.getInt("atkspd"));
            npcDat.set("baseMAtkSpd", NpcData.getInt("matkspd"));
            npcDat.set("aggroRange", NpcData.getInt("aggro"));
            npcDat.set("rhand", NpcData.getInt("rhand"));
            npcDat.set("lhand", NpcData.getInt("lhand"));
            npcDat.set("armor", NpcData.getInt("armor"));
            npcDat.set("enchant", NpcData.getInt("enchant"));
            npcDat.set("baseWalkSpd", NpcData.getInt("walkspd"));
            npcDat.set("baseRunSpd", NpcData.getInt("runspd"));
            npcDat.safeSet("baseSTR", NpcData.getInt("str"), 0, 100, "Loading npc template id: " + NpcData.getInt("idTemplate"));
            npcDat.safeSet("baseCON", NpcData.getInt("con"), 0, 100, "Loading npc template id: " + NpcData.getInt("idTemplate"));
            npcDat.safeSet("baseDEX", NpcData.getInt("dex"), 0, 100, "Loading npc template id: " + NpcData.getInt("idTemplate"));
            npcDat.safeSet("baseINT", NpcData.getInt("int"), 0, 100, "Loading npc template id: " + NpcData.getInt("idTemplate"));
            npcDat.safeSet("baseWIT", NpcData.getInt("wit"), 0, 100, "Loading npc template id: " + NpcData.getInt("idTemplate"));
            npcDat.safeSet("baseMEN", NpcData.getInt("men"), 0, 100, "Loading npc template id: " + NpcData.getInt("idTemplate"));
            npcDat.set("baseHpMax", NpcData.getInt("hp"));
            npcDat.set("baseCpMax", 0);
            npcDat.set("baseMpMax", NpcData.getInt("mp"));
            npcDat.set("baseHpReg", NpcData.getFloat("hpreg") > 0.0f ? (double)NpcData.getFloat("hpreg") : 1.5 + (double)(level - 1) / 10.0);
            npcDat.set("baseMpReg", NpcData.getFloat("mpreg") > 0.0f ? (double)NpcData.getFloat("mpreg") : 0.9 + 0.3 * ((double)(level - 1) / 10.0));
            npcDat.set("basePAtk", NpcData.getInt("patk"));
            npcDat.set("basePDef", NpcData.getInt("pdef"));
            npcDat.set("baseMAtk", NpcData.getInt("matk"));
            npcDat.set("baseMDef", NpcData.getInt("mdef"));
            npcDat.set("isUndead", NpcData.getString("isUndead"));
            npcDat.set("absorb_level", NpcData.getString("absorb_level"));
            npcDat.set("absorb_type", NpcData.getString("absorb_type"));
            npcDat.set("drop_herbs", Boolean.valueOf(NpcData.getString("drop_herbs")));
            L2NpcTemplate template = new L2NpcTemplate(npcDat);
            template.addVulnerability(Stats.BOW_WPN_VULN, 1.0);
            template.addVulnerability(Stats.CROSSBOW_WPN_VULN, 1.0);
            template.addVulnerability(Stats.BLUNT_WPN_VULN, 1.0);
            template.addVulnerability(Stats.DAGGER_WPN_VULN, 1.0);
            this._npcs.put(id, (Object)template);
            ++count;
        }
        if (!customData) {
            _log.info("NpcTable: (Re)Loaded " + count + " NPC template(s).");
        } else {
            _log.info("NpcTable: (Re)Loaded " + count + " custom NPC template(s).");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadNpc(int id) {
        Connection con = null;
        try {
            L2NpcTemplate old = this.getTemplate(id);
            FastMap skills = new FastMap();
            if (old.getSkills() != null) {
                skills.putAll(old.getSkills());
            }
            FastList categories = new FastList();
            if (old.getDropData() != null) {
                categories.addAll(old.getDropData());
            }
            ClassId[] classIds = null;
            if (old.getTeachInfo() != null) {
                classIds = (ClassId[])old.getTeachInfo().clone();
            }
            FastList minions = new FastList();
            if (old.getMinionData() != null) {
                minions.addAll(old.getMinionData());
            }
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement st = con.prepareStatement("SELECT " + L2DatabaseFactory.getInstance().safetyString("id", "idTemplate", "name", "serverSideName", "title", "serverSideTitle", "class", "collision_radius", "collision_height", "level", "sex", "type", "attackrange", "hp", "mp", "hpreg", "mpreg", "str", "con", "dex", "int", "wit", "men", "exp", "sp", "patk", "pdef", "matk", "mdef", "atkspd", "aggro", "matkspd", "rhand", "lhand", "armor", "enchant", "walkspd", "runspd", "isUndead", "absorb_level", "absorb_type", "drop_herbs") + " FROM npc WHERE id=?");
            st.setInt(1, id);
            ResultSet rs = st.executeQuery();
            this.fillNpcTable(rs, false);
            if (Config.CUSTOM_NPC_TABLE) {
                st = con.prepareStatement("SELECT " + L2DatabaseFactory.getInstance().safetyString("id", "idTemplate", "name", "serverSideName", "title", "serverSideTitle", "class", "collision_radius", "collision_height", "level", "sex", "type", "attackrange", "hp", "mp", "hpreg", "mpreg", "str", "con", "dex", "int", "wit", "men", "exp", "sp", "patk", "pdef", "matk", "mdef", "atkspd", "aggro", "matkspd", "rhand", "lhand", "armor", "enchant", "walkspd", "runspd", "isUndead", "absorb_level", "absorb_type", "drop_herbs") + " FROM custom_npc WHERE id=?");
                st.setInt(1, id);
                rs = st.executeQuery();
                this.fillNpcTable(rs, true);
            }
            rs.close();
            st.close();
            L2NpcTemplate created = this.getTemplate(id);
            for (L2Skill skill : skills.values()) {
                created.addSkill(skill);
            }
            if (classIds != null) {
                for (ClassId classId : classIds) {
                    created.addTeachInfo(classId);
                }
            }
            for (L2MinionData minion : minions) {
                created.addRaidData(minion);
            }
            L2DatabaseFactory.close(con);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "NPCTable: Could not reload data for NPC " + id + ": " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public void reloadAllNpc() {
        this.restoreNpcData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveNpc(StatsSet npc) {
        Connection con = null;
        try {
            PreparedStatement statement;
            StringBuilder sbQuery;
            con = L2DatabaseFactory.getInstance().getConnection();
            Map<String, Object> set = npc.getSet();
            int length = 0;
            for (String obj : set.keySet()) {
                length += obj.length() + 7 + 15;
            }
            StringBuilder sbValues = new StringBuilder(length);
            for (String obj : set.keySet()) {
                String name = obj;
                if (name.equalsIgnoreCase("npcId")) continue;
                if (sbValues.length() > 0) {
                    sbValues.append(", ");
                }
                sbValues.append(name);
                sbValues.append(" = '");
                sbValues.append(set.get(name));
                sbValues.append('\'');
            }
            int updated = 0;
            if (Config.CUSTOM_NPC_TABLE) {
                sbQuery = new StringBuilder(sbValues.length() + 28);
                sbQuery.append("UPDATE custom_npc SET ");
                sbQuery.append(sbValues.toString());
                sbQuery.append(" WHERE id = ?");
                statement = con.prepareStatement(sbQuery.toString());
                statement.setInt(1, npc.getInteger("npcId"));
                updated = statement.executeUpdate();
                statement.close();
            }
            if (updated == 0) {
                sbQuery = new StringBuilder(sbValues.length() + 28);
                sbQuery.append("UPDATE npc SET ");
                sbQuery.append(sbValues.toString());
                sbQuery.append(" WHERE id = ?");
                statement = con.prepareStatement(sbQuery.toString());
                statement.setInt(1, npc.getInteger("npcId"));
                statement.executeUpdate();
                statement.close();
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "NPCTable: Could not store new NPC data in database: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public void replaceTemplate(L2NpcTemplate npc) {
        this._npcs.put(npc.npcId, (Object)npc);
    }

    public L2NpcTemplate getTemplate(int id) {
        return (L2NpcTemplate)this._npcs.get(id);
    }

    public L2NpcTemplate getTemplateByName(String name) {
        for (Object npcTemplate : this._npcs.getValues()) {
            if (!((L2NpcTemplate)npcTemplate).name.equalsIgnoreCase(name)) continue;
            return (L2NpcTemplate)npcTemplate;
        }
        return null;
    }

    public L2NpcTemplate[] getAllOfLevel(int lvl) {
        FastList list = new FastList();
        for (Object t : this._npcs.getValues()) {
            if (((L2NpcTemplate)t).level != lvl) continue;
            list.add((L2NpcTemplate)t);
        }
        return list.toArray(new L2NpcTemplate[list.size()]);
    }

    public L2NpcTemplate[] getAllMonstersOfLevel(int lvl) {
        FastList list = new FastList();
        for (Object t : this._npcs.getValues()) {
            if (((L2NpcTemplate)t).level != lvl || !"L2Monster".equals(((L2NpcTemplate)t).type)) continue;
            list.add((L2NpcTemplate)t);
        }
        return list.toArray(new L2NpcTemplate[list.size()]);
    }

    public L2NpcTemplate[] getAllNpcStartingWith(String letter) {
        FastList list = new FastList();
        for (Object t : this._npcs.getValues()) {
            if (!((L2NpcTemplate)t).name.startsWith(letter) || !"L2Npc".equals(((L2NpcTemplate)t).type)) continue;
            list.add((L2NpcTemplate)t);
        }
        return list.toArray(new L2NpcTemplate[list.size()]);
    }

    public Set<Integer> getAllNpcOfClassType(String classType) {
        return null;
    }

    public Set<Integer> getAllNpcOfL2jClass(Class<?> clazz) {
        return null;
    }

    public Set<Integer> getAllNpcOfAiType(String aiType) {
        return null;
    }

    private static class SingletonHolder {
        protected static final NpcTable _instance = new NpcTable();

        private SingletonHolder() {
        }
    }
}

