/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.handler;

import com.l2jserver.Config;
import com.l2jserver.gameserver.handler.IAdminCommandHandler;
import gnu.trove.TIntObjectHashMap;
import java.util.logging.Logger;

public class AdminCommandHandler {
    private static Logger _log = Logger.getLogger(AdminCommandHandler.class.getName());
    private TIntObjectHashMap<IAdminCommandHandler> _datatable = new TIntObjectHashMap();

    public static AdminCommandHandler getInstance() {
        return SingletonHolder._instance;
    }

    private AdminCommandHandler() {
    }

    public void registerAdminCommandHandler(IAdminCommandHandler handler) {
        String[] ids = handler.getAdminCommandList();
        for (int i = 0; i < ids.length; ++i) {
            if (Config.DEBUG) {
                _log.fine("Adding handler for command " + ids[i]);
            }
            this._datatable.put(ids[i].hashCode(), (Object)handler);
        }
    }

    public IAdminCommandHandler getAdminCommandHandler(String adminCommand) {
        String command = adminCommand;
        if (adminCommand.indexOf(" ") != -1) {
            command = adminCommand.substring(0, adminCommand.indexOf(" "));
        }
        if (Config.DEBUG) {
            _log.fine("getting handler for command: " + command + " -> " + (this._datatable.get(command.hashCode()) != null));
        }
        return (IAdminCommandHandler)this._datatable.get(command.hashCode());
    }

    public int size() {
        return this._datatable.size();
    }

    private static class SingletonHolder {
        protected static final AdminCommandHandler _instance = new AdminCommandHandler();

        private SingletonHolder() {
        }
    }
}

