/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class L2Request {
    private static final int REQUEST_TIMEOUT = 15;
    protected L2PcInstance _player;
    protected L2PcInstance _partner;
    protected boolean _isRequestor;
    protected boolean _isAnswerer;
    protected L2GameClientPacket _requestPacket;

    public L2Request(L2PcInstance player) {
        this._player = player;
    }

    protected void clear() {
        this._partner = null;
        this._requestPacket = null;
        this._isRequestor = false;
        this._isAnswerer = false;
    }

    private synchronized void setPartner(L2PcInstance partner) {
        this._partner = partner;
    }

    public L2PcInstance getPartner() {
        return this._partner;
    }

    private synchronized void setRequestPacket(L2GameClientPacket packet) {
        this._requestPacket = packet;
    }

    public L2GameClientPacket getRequestPacket() {
        return this._requestPacket;
    }

    public synchronized boolean setRequest(L2PcInstance partner, L2GameClientPacket packet) {
        if (partner == null) {
            this._player.sendPacket(new SystemMessage(SystemMessageId.YOU_HAVE_INVITED_THE_WRONG_TARGET));
            return false;
        }
        if (partner.getRequest().isProcessingRequest()) {
            SystemMessage sm = new SystemMessage(SystemMessageId.C1_IS_BUSY_TRY_LATER);
            sm.addString(partner.getName());
            this._player.sendPacket(sm);
            sm = null;
            return false;
        }
        if (this.isProcessingRequest()) {
            this._player.sendPacket(new SystemMessage(SystemMessageId.WAITING_FOR_ANOTHER_REPLY));
            return false;
        }
        this._partner = partner;
        this._requestPacket = packet;
        this.setOnRequestTimer(true);
        this._partner.getRequest().setPartner(this._player);
        this._partner.getRequest().setRequestPacket(packet);
        this._partner.getRequest().setOnRequestTimer(false);
        return true;
    }

    private void setOnRequestTimer(boolean isRequestor) {
        this._isRequestor = isRequestor;
        this._isAnswerer = !isRequestor;
        ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

            @Override
            public void run() {
                L2Request.this.clear();
            }
        }, 15000L);
    }

    public void onRequestResponse() {
        if (this._partner != null) {
            this._partner.getRequest().clear();
        }
        this.clear();
    }

    public boolean isProcessingRequest() {
        return this._partner != null;
    }
}

