/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.instancemanager.AuctionManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.type.L2ClanHallZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowInfoUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class ClanHall {
    protected static final Logger _log = Logger.getLogger(ClanHall.class.getName());
    private int _clanHallId;
    private List<L2DoorInstance> _doors;
    private List<String> _doorDefault;
    private String _name;
    private int _ownerId;
    private int _lease;
    private String _desc;
    private String _location;
    private String _locName;
    protected long _paidUntil;
    private L2ClanHallZone _zone;
    private int _grade;
    protected final int _chRate = 604800000;
    protected boolean _isFree = true;
    private Map<Integer, ClanHallFunction> _functions;
    protected boolean _paid;
    public static final int FUNC_TELEPORT = 1;
    public static final int FUNC_ITEM_CREATE = 2;
    public static final int FUNC_RESTORE_HP = 3;
    public static final int FUNC_RESTORE_MP = 4;
    public static final int FUNC_RESTORE_EXP = 5;
    public static final int FUNC_SUPPORT = 6;
    public static final int FUNC_DECO_FRONTPLATEFORM = 7;
    public static final int FUNC_DECO_CURTAINS = 8;

    public ClanHall(int clanHallId, String name, int ownerId, int lease, String desc, String location, String locName, long paidUntil, int Grade, boolean paid) {
        this._clanHallId = clanHallId;
        this._name = name;
        this._ownerId = ownerId;
        if (Config.DEBUG) {
            _log.warning("Init Owner : " + this._ownerId);
        }
        this._lease = lease;
        this._desc = desc;
        this._location = location;
        this._locName = locName.intern();
        this._paidUntil = paidUntil;
        this._grade = Grade;
        this._paid = paid;
        this._doorDefault = new FastList();
        this._functions = new FastMap();
        if (ownerId != 0) {
            this._isFree = false;
            this.initialyzeTask(false);
            this.loadFunctions();
        }
    }

    public final boolean getPaid() {
        return this._paid;
    }

    public final int getId() {
        return this._clanHallId;
    }

    public final String getName() {
        return this._name;
    }

    public final int getOwnerId() {
        return this._ownerId;
    }

    public final int getLease() {
        return this._lease;
    }

    public final String getDesc() {
        return this._desc;
    }

    public final String getLocation() {
        return this._location;
    }

    public final String getLocName() {
        return this._locName;
    }

    public final long getPaidUntil() {
        return this._paidUntil;
    }

    public final GregorianCalendar getPaidTomorrow() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(this._paidUntil + 604800000L);
        return cal;
    }

    public final int getGrade() {
        return this._grade;
    }

    public final List<L2DoorInstance> getDoors() {
        if (this._doors == null) {
            this._doors = new FastList();
        }
        return this._doors;
    }

    public final L2DoorInstance getDoor(int doorId) {
        if (doorId <= 0) {
            return null;
        }
        for (L2DoorInstance door : this.getDoors()) {
            if (door.getDoorId() != doorId) continue;
            return door;
        }
        return null;
    }

    public ClanHallFunction getFunction(int type) {
        return this._functions.get(type);
    }

    public void setZone(L2ClanHallZone zone) {
        this._zone = zone;
    }

    public L2ClanHallZone getZone() {
        return this._zone;
    }

    public void free() {
        this._ownerId = 0;
        this._isFree = true;
        for (Map.Entry<Integer, ClanHallFunction> fc : this._functions.entrySet()) {
            this.removeFunction(fc.getKey());
        }
        this._functions.clear();
        this._paidUntil = 0L;
        this._paid = false;
        this.updateDb();
    }

    public void setOwner(L2Clan clan) {
        if (this._ownerId > 0 || clan == null) {
            return;
        }
        this._ownerId = clan.getClanId();
        this._isFree = false;
        this._paidUntil = System.currentTimeMillis();
        this.initialyzeTask(true);
        clan.broadcastToOnlineMembers(new PledgeShowInfoUpdate(clan));
        this.updateDb();
    }

    @Deprecated
    public void spawnDoor() {
        this.spawnDoor(false);
    }

    @Deprecated
    public void spawnDoor(boolean isDoorWeak) {
        for (int i = 0; i < this.getDoors().size(); ++i) {
            L2DoorInstance door = this.getDoors().get(i);
            if (door.getCurrentHp() <= 0.0) {
                door.decayMe();
                door = DoorTable.parseList(this._doorDefault.get(i), false);
                DoorTable.getInstance().putDoor(door);
                if (isDoorWeak) {
                    door.setCurrentHp(door.getMaxHp() / 2);
                }
                door.spawnMe(door.getX(), door.getY(), door.getZ());
                this.getDoors().set(i, door);
                continue;
            }
            if (!door.getOpen()) continue;
            door.closeMe();
        }
    }

    @Deprecated
    public void openCloseDoor(L2PcInstance activeChar, int doorId, boolean open) {
        if (activeChar != null && activeChar.getClanId() == this.getOwnerId()) {
            this.openCloseDoor(doorId, open);
        }
    }

    @Deprecated
    public void openCloseDoor(int doorId, boolean open) {
        this.openCloseDoor(this.getDoor(doorId), open);
    }

    @Deprecated
    public void openCloseDoor(L2DoorInstance door, boolean open) {
        if (door != null) {
            if (open) {
                door.openMe();
            } else {
                door.closeMe();
            }
        }
    }

    @Deprecated
    public void openCloseDoors(L2PcInstance activeChar, boolean open) {
        if (activeChar != null && activeChar.getClanId() == this.getOwnerId()) {
            this.openCloseDoors(open);
        }
    }

    public void openCloseDoors(boolean open) {
        for (L2DoorInstance door : this.getDoors()) {
            if (door == null) continue;
            if (open) {
                door.openMe();
                continue;
            }
            door.closeMe();
        }
    }

    public void banishForeigners() {
        this._zone.banishForeigners(this.getOwnerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFunctions() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("Select * from clanhall_functions where hall_id = ?");
            statement.setInt(1, this.getId());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                this._functions.put(rs.getInt("type"), new ClanHallFunction(rs.getInt("type"), rs.getInt("lvl"), rs.getInt("lease"), 0, rs.getLong("rate"), rs.getLong("endTime"), true));
            }
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: ClanHall.loadFunctions(): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFunction(int functionType) {
        this._functions.remove(functionType);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM clanhall_functions WHERE hall_id=? AND type=?");
            statement.setInt(1, this.getId());
            statement.setInt(2, functionType);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: ClanHall.removeFunctions(int functionType): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public boolean updateFunctions(L2PcInstance player, int type, int lvl, int lease, long rate, boolean addNew) {
        if (player == null) {
            return false;
        }
        if (Config.DEBUG) {
            _log.warning("Called ClanHall.updateFunctions(int type, int lvl, int lease, long rate, boolean addNew) Owner : " + this.getOwnerId());
        }
        if (lease > 0 && !player.destroyItemByItemId("Consume", 57, lease, null, true)) {
            return false;
        }
        if (addNew) {
            this._functions.put(type, new ClanHallFunction(type, lvl, lease, 0, rate, 0L, false));
        } else if (lvl == 0 && lease == 0) {
            this.removeFunction(type);
        } else {
            int diffLease = lease - this._functions.get(type).getLease();
            if (Config.DEBUG) {
                _log.warning("Called ClanHall.updateFunctions diffLease : " + diffLease);
            }
            if (diffLease > 0) {
                this._functions.remove(type);
                this._functions.put(type, new ClanHallFunction(type, lvl, lease, 0, rate, -1L, false));
            } else {
                this._functions.get(type).setLease(lease);
                this._functions.get(type).setLvl(lvl);
                this._functions.get(type).dbSave();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDb() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE clanhall SET ownerId=?, paidUntil=?, paid=? WHERE id=?");
            statement.setInt(1, this._ownerId);
            statement.setLong(2, this._paidUntil);
            statement.setInt(3, this._paid ? 1 : 0);
            statement.setInt(4, this._clanHallId);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception: updateOwnerInDB(L2Clan clan): " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    private void initialyzeTask(boolean forced) {
        long currentTime = System.currentTimeMillis();
        if (this._paidUntil > currentTime) {
            ThreadPoolManager.getInstance().scheduleGeneral(new FeeTask(), this._paidUntil - currentTime);
        } else if (!this._paid && !forced) {
            if (System.currentTimeMillis() + 86400000L <= this._paidUntil + 604800000L) {
                ThreadPoolManager.getInstance().scheduleGeneral(new FeeTask(), System.currentTimeMillis() + 86400000L);
            } else {
                ThreadPoolManager.getInstance().scheduleGeneral(new FeeTask(), this._paidUntil + 604800000L - System.currentTimeMillis());
            }
        } else {
            ThreadPoolManager.getInstance().scheduleGeneral(new FeeTask(), 0L);
        }
    }

    private class FeeTask
    implements Runnable {
        @Override
        public void run() {
            try {
                if (ClanHall.this._isFree) {
                    return;
                }
                L2Clan Clan = ClanTable.getInstance().getClan(ClanHall.this.getOwnerId());
                if (ClanTable.getInstance().getClan(ClanHall.this.getOwnerId()).getWarehouse().getAdena() >= (long)ClanHall.this.getLease()) {
                    if (ClanHall.this._paidUntil != 0L) {
                        while (ClanHall.this._paidUntil <= System.currentTimeMillis()) {
                            ClanHall.this._paidUntil += 604800000L;
                        }
                    } else {
                        ClanHall.this._paidUntil = System.currentTimeMillis() + 604800000L;
                    }
                    ClanTable.getInstance().getClan(ClanHall.this.getOwnerId()).getWarehouse().destroyItemByItemId("CH_rental_fee", 57, ClanHall.this.getLease(), null, null);
                    if (Config.DEBUG) {
                        _log.warning("deducted " + ClanHall.this.getLease() + " adena from " + ClanHall.this.getName() + " owner's cwh for ClanHall _paidUntil: " + ClanHall.this._paidUntil);
                    }
                    ThreadPoolManager.getInstance().scheduleGeneral(new FeeTask(), ClanHall.this._paidUntil - System.currentTimeMillis());
                    ClanHall.this._paid = true;
                    ClanHall.this.updateDb();
                } else {
                    ClanHall.this._paid = false;
                    if (System.currentTimeMillis() > ClanHall.this._paidUntil + 604800000L) {
                        if (ClanHallManager.getInstance().loaded()) {
                            AuctionManager.getInstance().initNPC(ClanHall.this.getId());
                            ClanHallManager.getInstance().setFree(ClanHall.this.getId());
                            Clan.broadcastToOnlineMembers(new SystemMessage(SystemMessageId.THE_CLAN_HALL_FEE_IS_ONE_WEEK_OVERDUE_THEREFORE_THE_CLAN_HALL_OWNERSHIP_HAS_BEEN_REVOKED));
                        } else {
                            ThreadPoolManager.getInstance().scheduleGeneral(new FeeTask(), 3000L);
                        }
                    } else {
                        ClanHall.this.updateDb();
                        SystemMessage sm = new SystemMessage(SystemMessageId.PAYMENT_FOR_YOUR_CLAN_HALL_HAS_NOT_BEEN_MADE_PLEASE_MAKE_PAYMENT_TO_YOUR_CLAN_WAREHOUSE_BY_S1_TOMORROW);
                        sm.addNumber(ClanHall.this.getPaidTomorrow().get(11));
                        Clan.broadcastToOnlineMembers(sm);
                        if (System.currentTimeMillis() + 86400000L <= ClanHall.this._paidUntil + 604800000L) {
                            ThreadPoolManager.getInstance().scheduleGeneral(new FeeTask(), System.currentTimeMillis() + 86400000L);
                        } else {
                            ThreadPoolManager.getInstance().scheduleGeneral(new FeeTask(), ClanHall.this._paidUntil + 604800000L - System.currentTimeMillis());
                        }
                    }
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    public class ClanHallFunction {
        private int _type;
        private int _lvl;
        protected int _fee;
        protected int _tempFee;
        private long _rate;
        private long _endDate;
        protected boolean _inDebt;
        public boolean _cwh;

        public ClanHallFunction(int type, int lvl, int lease, int tempLease, long rate, long time, boolean cwh) {
            this._type = type;
            this._lvl = lvl;
            this._fee = lease;
            this._tempFee = tempLease;
            this._rate = rate;
            this._endDate = time;
            this.initializeTask(cwh);
        }

        public int getType() {
            return this._type;
        }

        public int getLvl() {
            return this._lvl;
        }

        public int getLease() {
            return this._fee;
        }

        public long getRate() {
            return this._rate;
        }

        public long getEndTime() {
            return this._endDate;
        }

        public void setLvl(int lvl) {
            this._lvl = lvl;
        }

        public void setLease(int lease) {
            this._fee = lease;
        }

        public void setEndTime(long time) {
            this._endDate = time;
        }

        private void initializeTask(boolean cwh) {
            if (ClanHall.this._isFree) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this._endDate > currentTime) {
                ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(cwh), this._endDate - currentTime);
            } else {
                ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(cwh), 0L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dbSave() {
            Connection con = null;
            try {
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("REPLACE INTO clanhall_functions (hall_id, type, lvl, lease, rate, endTime) VALUES (?,?,?,?,?,?)");
                statement.setInt(1, ClanHall.this.getId());
                statement.setInt(2, this.getType());
                statement.setInt(3, this.getLvl());
                statement.setInt(4, this.getLease());
                statement.setLong(5, this.getRate());
                statement.setLong(6, this.getEndTime());
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Exception: ClanHall.updateFunctions(int type, int lvl, int lease, long rate, long time, boolean addNew): " + e.getMessage(), e);
            }
            finally {
                L2DatabaseFactory.close(con);
            }
        }

        private class FunctionTask
        implements Runnable {
            public FunctionTask(boolean cwh) {
                ClanHallFunction.this._cwh = cwh;
            }

            @Override
            public void run() {
                try {
                    if (ClanHall.this._isFree) {
                        return;
                    }
                    if (ClanTable.getInstance().getClan(ClanHall.this.getOwnerId()).getWarehouse().getAdena() >= (long)ClanHallFunction.this._fee || !ClanHallFunction.this._cwh) {
                        int fee = ClanHallFunction.this._fee;
                        if (ClanHallFunction.this.getEndTime() == -1L) {
                            fee = ClanHallFunction.this._tempFee;
                        }
                        ClanHallFunction.this.setEndTime(System.currentTimeMillis() + ClanHallFunction.this.getRate());
                        ClanHallFunction.this.dbSave();
                        if (ClanHallFunction.this._cwh) {
                            ClanTable.getInstance().getClan(ClanHall.this.getOwnerId()).getWarehouse().destroyItemByItemId("CH_function_fee", 57, fee, null, null);
                            if (Config.DEBUG) {
                                _log.warning("deducted " + fee + " adena from " + ClanHall.this.getName() + " owner's cwh for function id : " + ClanHallFunction.this.getType());
                            }
                        }
                        ThreadPoolManager.getInstance().scheduleGeneral(new FunctionTask(true), ClanHallFunction.this.getRate());
                    } else {
                        ClanHall.this.removeFunction(ClanHallFunction.this.getType());
                    }
                }
                catch (Exception e) {
                    _log.log(Level.SEVERE, "", e);
                }
            }
        }
    }
}

