/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.HeroSkillTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.olympiad.Olympiad;
import com.l2jserver.gameserver.model.olympiad.OlympiadManager;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadMatchEnd;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadMode;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.SkillCoolTime;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.L2FastList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

class OlympiadGame {
    protected static final Logger _log = Logger.getLogger(OlympiadGame.class.getName());
    protected static final Logger _logResults = Logger.getLogger("olympiad");
    protected final Olympiad.COMP_TYPE _type;
    protected boolean _aborted = false;
    protected boolean _gamestarted = false;
    protected boolean _playerOneDisconnected;
    protected boolean _playerTwoDisconnected;
    protected boolean _playerOneDefaulted;
    protected boolean _playerTwoDefaulted;
    protected String _playerOneName;
    protected String _playerTwoName;
    protected int _playerOneID = 0;
    protected int _playerTwoID = 0;
    protected int _playerOneClass = 0;
    protected int _playerTwoClass = 0;
    protected static final int OLY_BUFFER = 36402;
    protected static final int OLY_MANAGER = 31688;
    private static final String POINTS = "olympiad_points";
    private static final String COMP_DONE = "competitions_done";
    private static final String COMP_WON = "competitions_won";
    private static final String COMP_LOST = "competitions_lost";
    private static final String COMP_DRAWN = "competitions_drawn";
    protected static boolean _battleStarted;
    protected static boolean _gameIsStarted;
    protected long _startTime = 0L;
    public int _damageP1 = 0;
    public int _damageP2 = 0;
    public L2PcInstance _playerOne;
    public L2PcInstance _playerTwo;
    public L2Spawn _spawnOne;
    public L2Spawn _spawnTwo;
    protected L2FastList<L2PcInstance> _players;
    private final int[] _stadiumPort;
    private int x1;
    private int y1;
    private int z1;
    private int x2;
    private int y2;
    private int z2;
    public final int _stadiumID;
    protected SystemMessage _sm;
    private SystemMessage _sm2;
    private SystemMessage _sm3;

    protected OlympiadGame(int id, Olympiad.COMP_TYPE type, L2FastList<L2PcInstance> list) {
        this._stadiumID = id;
        this._playerOneDisconnected = false;
        this._playerTwoDisconnected = false;
        this._type = type;
        this._stadiumPort = OlympiadManager.STADIUMS[id].getCoordinates();
        if (list != null) {
            this._players = list;
            this._playerOne = (L2PcInstance)list.get(0);
            this._playerTwo = (L2PcInstance)list.get(1);
            try {
                this._playerOneName = this._playerOne.getName();
                this._playerTwoName = this._playerTwo.getName();
                this._playerOne.setOlympiadGameId(id);
                this._playerTwo.setOlympiadGameId(id);
                this._playerOneID = this._playerOne.getObjectId();
                this._playerTwoID = this._playerTwo.getObjectId();
                this._playerOneClass = this._playerOne.getBaseClass();
                this._playerTwoClass = this._playerTwo.getBaseClass();
            }
            catch (Exception e) {
                this._aborted = true;
                this.clearPlayers();
            }
            if (Config.DEBUG) {
                _log.info("Olympiad System: Game - " + id + ": " + this._playerOne.getName() + " Vs " + this._playerTwo.getName());
            }
        } else {
            this._aborted = true;
            this.clearPlayers();
            return;
        }
    }

    public boolean isAborted() {
        return this._aborted;
    }

    protected void clearPlayers() {
        this._playerOne = null;
        this._playerTwo = null;
        this._players = null;
        this._playerOneName = "";
        this._playerTwoName = "";
        this._playerOneID = 0;
        this._playerTwoID = 0;
    }

    protected void handleDisconnect(L2PcInstance player) {
        if (this._gamestarted) {
            if (player == this._playerOne) {
                this._playerOneDisconnected = true;
            } else if (player == this._playerTwo) {
                this._playerTwoDisconnected = true;
            }
        }
    }

    public L2Spawn SpawnBuffer(int xPos, int yPos, int zPos, int npcId) {
        L2NpcTemplate template = NpcTable.getInstance().getTemplate(npcId);
        try {
            L2Spawn spawn = new L2Spawn(template);
            spawn.setLocx(xPos);
            spawn.setLocy(yPos);
            spawn.setLocz(zPos);
            spawn.setAmount(1);
            spawn.setHeading(0);
            spawn.setRespawnDelay(1);
            SpawnTable.getInstance().addNewSpawn(spawn, false);
            spawn.init();
            return spawn;
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "", e);
            return null;
        }
    }

    protected void removals() {
        if (this._aborted) {
            return;
        }
        if (this._playerOne == null || this._playerTwo == null) {
            return;
        }
        if (this._playerOneDisconnected || this._playerTwoDisconnected) {
            return;
        }
        Iterator i$ = this._players.iterator();
        while (i$.hasNext()) {
            L2PcInstance player = (L2PcInstance)i$.next();
            try {
                player.stopAllEffectsExceptThoseThatLastThroughDeath();
                if (player.getClan() != null) {
                    for (L2Skill skill : player.getClan().getAllSkills()) {
                        player.removeSkill(skill, false, true);
                    }
                    if (player.getClan().getHasCastle() > 0) {
                        CastleManager.getInstance().getCastleByOwner(player.getClan()).removeResidentialSkills(player);
                    }
                    if (player.getClan().getHasFort() > 0) {
                        FortManager.getInstance().getFortByOwner(player.getClan()).removeResidentialSkills(player);
                    }
                }
                if (player.isCastingNow()) {
                    player.abortCast();
                }
                player.getAppearance().setVisible();
                if (player.isHero()) {
                    for (L2Skill skill : HeroSkillTable.getHeroSkills()) {
                        player.removeSkill(skill, false);
                    }
                }
                player.setCurrentCp(player.getMaxCp());
                player.setCurrentHp(player.getMaxHp());
                player.setCurrentMp(player.getMaxMp());
                if (player.getPet() != null) {
                    L2Summon summon = player.getPet();
                    summon.stopAllEffects();
                    if (summon instanceof L2PetInstance) {
                        summon.unSummon(player);
                    }
                }
                player.stopCubicsByOthers();
                if (player.getParty() != null) {
                    L2Party party = player.getParty();
                    party.removePartyMember(player);
                }
                if (player.getAgathionId() > 0) {
                    player.setAgathionId(0);
                    player.broadcastUserInfo();
                }
                player.checkItemRestriction();
                player.disableAutoShotsAll();
                if (player.getActiveWeaponInstance() != null) {
                    player.getActiveWeaponInstance().setChargedSoulshot(0);
                    player.getActiveWeaponInstance().setChargedSpiritshot(0);
                }
                for (L2Skill skill : player.getAllSkills()) {
                    if (skill.getReuseDelay() > 900000) continue;
                    player.enableSkill(skill);
                }
                player.sendSkillList();
                player.sendPacket(new SkillCoolTime(player));
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "", e);
            }
        }
    }

    protected boolean portPlayersToArena() {
        boolean _playerTwoCrash;
        boolean _playerOneCrash = this._playerOne == null || this._playerOneDisconnected;
        boolean bl = _playerTwoCrash = this._playerTwo == null || this._playerTwoDisconnected;
        if (_playerOneCrash || _playerTwoCrash || this._aborted) {
            this._playerOne = null;
            this._playerTwo = null;
            this._aborted = true;
            return false;
        }
        try {
            this.x1 = this._playerOne.getX();
            this.y1 = this._playerOne.getY();
            this.z1 = this._playerOne.getZ();
            this.x2 = this._playerTwo.getX();
            this.y2 = this._playerTwo.getY();
            this.z2 = this._playerTwo.getZ();
            if (this._playerOne.isSitting()) {
                this._playerOne.standUp();
            }
            if (this._playerTwo.isSitting()) {
                this._playerTwo.standUp();
            }
            this._playerOne.setTarget(null);
            this._playerTwo.setTarget(null);
            this._gamestarted = true;
            this._playerOne.setIsInOlympiadMode(true);
            this._playerOne.setIsOlympiadStart(false);
            this._playerOne.setOlympiadSide(1);
            this._playerOne.olyBuff = 5;
            this._playerTwo.setIsInOlympiadMode(true);
            this._playerTwo.setIsOlympiadStart(false);
            this._playerTwo.setOlympiadSide(2);
            this._playerTwo.olyBuff = 5;
            this._playerOne.setInstanceId(0);
            this._playerOne.teleToLocation(this._stadiumPort[0] + 1200, this._stadiumPort[1], this._stadiumPort[2], false);
            this._playerTwo.setInstanceId(0);
            this._playerTwo.teleToLocation(this._stadiumPort[0] - 1200, this._stadiumPort[1], this._stadiumPort[2], false);
            this._playerOne.sendPacket(new ExOlympiadMode(2));
            this._playerTwo.sendPacket(new ExOlympiadMode(2));
            this._spawnOne = this.SpawnBuffer(this._stadiumPort[0] + 1100, this._stadiumPort[1], this._stadiumPort[2], 36402);
            this._spawnTwo = this.SpawnBuffer(this._stadiumPort[0] - 1100, this._stadiumPort[1], this._stadiumPort[2], 36402);
            _gameIsStarted = false;
        }
        catch (NullPointerException e) {
            _log.log(Level.WARNING, "", e);
            return false;
        }
        return true;
    }

    protected void cleanEffects() {
        if (this._playerOne == null || this._playerTwo == null) {
            return;
        }
        if (this._playerOneDisconnected || this._playerTwoDisconnected) {
            return;
        }
        Iterator i$ = this._players.iterator();
        while (i$.hasNext()) {
            L2PcInstance player = (L2PcInstance)i$.next();
            try {
                player.stopAllEffectsExceptThoseThatLastThroughDeath();
                player.clearSouls();
                player.clearCharges();
                if (player.getAgathionId() > 0) {
                    player.setAgathionId(0);
                }
                if (player.getPet() == null) continue;
                L2Summon summon = player.getPet();
                summon.stopAllEffects();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "cleanEffects()", e);
            }
        }
    }

    protected void portPlayersBack() {
        if (this._playerOne != null) {
            this._playerOne.sendPacket(new ExOlympiadMatchEnd());
            this._playerOne.teleToLocation(this.x1, this.y1, this.z1, true);
        }
        if (this._playerTwo != null) {
            this._playerTwo.sendPacket(new ExOlympiadMatchEnd());
            this._playerTwo.teleToLocation(this.x2, this.y2, this.z2, true);
        }
    }

    protected void PlayersStatusBack() {
        Iterator i$ = this._players.iterator();
        while (i$.hasNext()) {
            L2PcInstance player = (L2PcInstance)i$.next();
            if (player == null) continue;
            try {
                if (Olympiad.getInstance().playerInStadia(player)) {
                    if (player.isDead()) {
                        player.setIsDead(false);
                    }
                    player.getStatus().startHpMpRegeneration();
                    player.setCurrentCp(player.getMaxCp());
                    player.setCurrentHp(player.getMaxHp());
                    player.setCurrentMp(player.getMaxMp());
                }
                if (player.isTransformed()) {
                    player.untransform();
                }
                player.setIsInOlympiadMode(false);
                player.setIsOlympiadStart(false);
                player.setOlympiadSide(-1);
                player.setOlympiadGameId(-1);
                player.sendPacket(new ExOlympiadMode(0));
                if (player.getClan() != null) {
                    for (L2Skill skill : player.getClan().getAllSkills()) {
                        if (skill.getMinPledgeClass() > player.getPledgeClass()) continue;
                        player.addSkill(skill, false);
                    }
                    if (player.getClan().getHasCastle() > 0) {
                        CastleManager.getInstance().getCastleByOwner(player.getClan()).giveResidentialSkills(player);
                    }
                    if (player.getClan().getHasFort() > 0) {
                        FortManager.getInstance().getFortByOwner(player.getClan()).giveResidentialSkills(player);
                    }
                }
                if (player.isHero()) {
                    for (L2Skill skill : HeroSkillTable.getHeroSkills()) {
                        player.addSkill(skill, false);
                    }
                }
                player.sendSkillList();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "portPlayersToArena()", e);
            }
        }
    }

    protected boolean haveWinner() {
        if (this._aborted || this._playerOne == null || this._playerTwo == null || this._playerOneDisconnected || this._playerTwoDisconnected) {
            return true;
        }
        double playerOneHp = 0.0;
        try {
            if (this._playerOne != null && this._playerOne.getOlympiadGameId() != -1) {
                playerOneHp = this._playerOne.getCurrentHp();
            }
        }
        catch (Exception e) {
            playerOneHp = 0.0;
        }
        double playerTwoHp = 0.0;
        try {
            if (this._playerTwo != null && this._playerTwo.getOlympiadGameId() != -1) {
                playerTwoHp = this._playerTwo.getCurrentHp();
            }
        }
        catch (Exception e) {
            playerTwoHp = 0.0;
        }
        return playerTwoHp <= 0.0 || playerOneHp <= 0.0;
    }

    protected void validateWinner() {
        SystemMessage sm;
        String classed;
        int _gpreward;
        int _div;
        if (this._aborted) {
            return;
        }
        boolean _pOneCrash = this._playerOne == null || this._playerOneDisconnected;
        boolean _pTwoCrash = this._playerTwo == null || this._playerTwoDisconnected;
        switch (this._type) {
            case NON_CLASSED: {
                _div = 5;
                _gpreward = Config.ALT_OLY_NONCLASSED_RITEM_C;
                classed = "no";
                break;
            }
            default: {
                _div = 3;
                _gpreward = Config.ALT_OLY_CLASSED_RITEM_C;
                classed = "yes";
            }
        }
        StatsSet playerOneStat = Olympiad.getNobleStats(this._playerOneID);
        StatsSet playerTwoStat = Olympiad.getNobleStats(this._playerTwoID);
        int playerOnePlayed = playerOneStat.getInteger(COMP_DONE);
        int playerTwoPlayed = playerTwoStat.getInteger(COMP_DONE);
        int playerOneWon = playerOneStat.getInteger(COMP_WON);
        int playerTwoWon = playerTwoStat.getInteger(COMP_WON);
        int playerOneLost = playerOneStat.getInteger(COMP_LOST);
        int playerTwoLost = playerTwoStat.getInteger(COMP_LOST);
        int playerOneDrawn = playerOneStat.getInteger(COMP_DRAWN);
        int playerTwoDrawn = playerTwoStat.getInteger(COMP_DRAWN);
        int playerOnePoints = playerOneStat.getInteger(POINTS);
        int playerTwoPoints = playerTwoStat.getInteger(POINTS);
        int pointDiff = Math.min(Math.min(playerOnePoints, playerTwoPoints) / _div, Config.ALT_OLY_MAX_POINTS);
        if (this._playerOneDefaulted || this._playerTwoDefaulted) {
            LogRecord record;
            SystemMessage sm2;
            int lostPoints;
            if (this._playerOneDefaulted) {
                lostPoints = Math.min(playerOnePoints / 3, Config.ALT_OLY_MAX_POINTS);
                playerOneStat.set(POINTS, playerOnePoints - lostPoints);
                Olympiad.updateNobleStats(this._playerOneID, playerOneStat);
                sm2 = new SystemMessage(SystemMessageId.C1_HAS_LOST_S2_OLYMPIAD_POINTS);
                sm2.addString(this._playerOneName);
                sm2.addNumber(lostPoints);
                this.broadcastMessage(sm2, false);
                if (Config.DEBUG) {
                    _log.info("Olympia Result: " + this._playerOneName + " lost " + lostPoints + " points for defaulting");
                }
                if (Config.ALT_OLY_LOG_FIGHTS) {
                    record = new LogRecord(Level.INFO, this._playerOneName + " default");
                    record.setParameters(new Object[]{this._playerOneName, this._playerTwoName, 0, 0, 0, 0, lostPoints, classed});
                    _logResults.log(record);
                }
            }
            if (this._playerTwoDefaulted) {
                lostPoints = Math.min(playerTwoPoints / 3, Config.ALT_OLY_MAX_POINTS);
                playerTwoStat.set(POINTS, playerTwoPoints - lostPoints);
                Olympiad.updateNobleStats(this._playerTwoID, playerTwoStat);
                sm2 = new SystemMessage(SystemMessageId.C1_HAS_LOST_S2_OLYMPIAD_POINTS);
                sm2.addString(this._playerTwoName);
                sm2.addNumber(lostPoints);
                this.broadcastMessage(sm2, false);
                if (Config.DEBUG) {
                    _log.info("Olympia Result: " + this._playerTwoName + " lost " + lostPoints + " points for defaulting");
                }
                if (Config.ALT_OLY_LOG_FIGHTS) {
                    record = new LogRecord(Level.INFO, this._playerTwoName + " default");
                    record.setParameters(new Object[]{this._playerOneName, this._playerTwoName, 0, 0, 0, 0, lostPoints, classed});
                    _logResults.log(record);
                }
            }
            return;
        }
        if (_pOneCrash || _pTwoCrash) {
            if (_pOneCrash && !_pTwoCrash) {
                try {
                    playerOneStat.set(POINTS, playerOnePoints - pointDiff);
                    playerOneStat.set(COMP_LOST, playerOneLost + 1);
                    if (Config.DEBUG) {
                        _log.info("Olympia Result: " + this._playerOneName + " vs " + this._playerTwoName + " ... " + this._playerOneName + " lost " + pointDiff + " points for crash");
                    }
                    if (Config.ALT_OLY_LOG_FIGHTS) {
                        LogRecord record = new LogRecord(Level.INFO, this._playerOneName + " crash");
                        record.setParameters(new Object[]{this._playerOneName, this._playerTwoName, 0, 0, 0, 0, pointDiff, classed});
                        _logResults.log(record);
                    }
                    playerTwoStat.set(POINTS, playerTwoPoints + pointDiff);
                    playerTwoStat.set(COMP_WON, playerTwoWon + 1);
                    if (Config.DEBUG) {
                        _log.info("Olympia Result: " + this._playerOneName + " vs " + this._playerTwoName + " ... " + this._playerTwoName + " Win " + pointDiff + " points");
                    }
                    this._sm = new SystemMessage(SystemMessageId.C1_HAS_WON_THE_GAME);
                    this._sm2 = new SystemMessage(SystemMessageId.C1_HAS_GAINED_S2_OLYMPIAD_POINTS);
                    this._sm.addString(this._playerTwoName);
                    this.broadcastMessage(this._sm, true);
                    this._sm2.addString(this._playerTwoName);
                    this._sm2.addNumber(pointDiff);
                    this.broadcastMessage(this._sm2, false);
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Exception on validateWinnder(): " + e.getMessage(), e);
                }
            } else if (_pTwoCrash && !_pOneCrash) {
                try {
                    playerTwoStat.set(POINTS, playerTwoPoints - pointDiff);
                    playerTwoStat.set(COMP_LOST, playerTwoLost + 1);
                    if (Config.DEBUG) {
                        _log.info("Olympia Result: " + this._playerTwoName + " vs " + this._playerOneName + " ... " + this._playerTwoName + " lost " + pointDiff + " points for crash");
                    }
                    if (Config.ALT_OLY_LOG_FIGHTS) {
                        LogRecord record = new LogRecord(Level.INFO, this._playerTwoName + " crash");
                        record.setParameters(new Object[]{this._playerOneName, this._playerTwoName, 0, 0, 0, 0, pointDiff, classed});
                        _logResults.log(record);
                    }
                    playerOneStat.set(POINTS, playerOnePoints + pointDiff);
                    playerOneStat.set(COMP_WON, playerOneWon + 1);
                    if (Config.DEBUG) {
                        _log.info("Olympia Result: " + this._playerTwoName + " vs " + this._playerOneName + " ... " + this._playerOneName + " Win " + pointDiff + " points");
                    }
                    this._sm = new SystemMessage(SystemMessageId.C1_HAS_WON_THE_GAME);
                    this._sm2 = new SystemMessage(SystemMessageId.C1_HAS_GAINED_S2_OLYMPIAD_POINTS);
                    this._sm.addString(this._playerOneName);
                    this.broadcastMessage(this._sm, true);
                    this._sm2.addString(this._playerOneName);
                    this._sm2.addNumber(pointDiff);
                    this.broadcastMessage(this._sm2, false);
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Exception on validateWinnder(): " + e.getMessage(), e);
                }
            } else if (_pOneCrash && _pTwoCrash) {
                try {
                    playerOneStat.set(POINTS, playerOnePoints - pointDiff);
                    playerOneStat.set(COMP_LOST, playerOneLost + 1);
                    playerTwoStat.set(POINTS, playerTwoPoints - pointDiff);
                    playerTwoStat.set(COMP_LOST, playerTwoLost + 1);
                    if (Config.DEBUG) {
                        _log.info("Olympia Result: " + this._playerOneName + " vs " + this._playerTwoName + " ... " + " both lost " + pointDiff + " points for crash");
                    }
                    if (Config.ALT_OLY_LOG_FIGHTS) {
                        LogRecord record = new LogRecord(Level.INFO, "both crash");
                        record.setParameters(new Object[]{this._playerOneName, this._playerTwoName, 0, 0, 0, 0, pointDiff, classed});
                        _logResults.log(record);
                    }
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Exception on validateWinnder(): " + e.getMessage(), e);
                }
            }
            playerOneStat.set(COMP_DONE, playerOnePlayed + 1);
            playerTwoStat.set(COMP_DONE, playerTwoPlayed + 1);
            Olympiad.updateNobleStats(this._playerOneID, playerOneStat);
            Olympiad.updateNobleStats(this._playerTwoID, playerTwoStat);
            return;
        }
        double playerOneHp = 0.0;
        if (!this._playerOne.isDead()) {
            playerOneHp = this._playerOne.getCurrentHp() + this._playerOne.getCurrentCp();
        }
        double playerTwoHp = 0.0;
        if (!this._playerTwo.isDead()) {
            playerTwoHp = this._playerTwo.getCurrentHp() + this._playerTwo.getCurrentCp();
        }
        this._sm = new SystemMessage(SystemMessageId.C1_HAS_WON_THE_GAME);
        this._sm2 = new SystemMessage(SystemMessageId.C1_HAS_GAINED_S2_OLYMPIAD_POINTS);
        this._sm3 = new SystemMessage(SystemMessageId.C1_HAS_LOST_S2_OLYMPIAD_POINTS);
        String result = "";
        this._playerOne = L2World.getInstance().getPlayer(this._playerOneID);
        this._players.set(0, this._playerOne);
        this._playerTwo = L2World.getInstance().getPlayer(this._playerTwoID);
        this._players.set(1, this._playerTwo);
        String winner = "draw";
        long _fightTime = System.currentTimeMillis() - this._startTime;
        if (this._playerOne == null && this._playerTwo == null) {
            playerOneStat.set(COMP_DRAWN, playerOneDrawn + 1);
            playerTwoStat.set(COMP_DRAWN, playerTwoDrawn + 1);
            result = " tie";
            this._sm = new SystemMessage(SystemMessageId.THE_GAME_ENDED_IN_A_TIE);
            this.broadcastMessage(this._sm, true);
        } else if (this._playerTwo == null || this._playerTwo.isOnline() == 0 || playerTwoHp == 0.0 && playerOneHp != 0.0 || this._damageP1 > this._damageP2 && playerTwoHp != 0.0 && playerOneHp != 0.0) {
            playerOneStat.set(POINTS, playerOnePoints + pointDiff);
            playerTwoStat.set(POINTS, playerTwoPoints - pointDiff);
            playerOneStat.set(COMP_WON, playerOneWon + 1);
            playerTwoStat.set(COMP_LOST, playerTwoLost + 1);
            this._sm.addString(this._playerOneName);
            this.broadcastMessage(this._sm, true);
            this._sm2.addString(this._playerOneName);
            this._sm2.addNumber(pointDiff);
            this.broadcastMessage(this._sm2, false);
            this._sm3.addString(this._playerTwoName);
            this._sm3.addNumber(pointDiff);
            this.broadcastMessage(this._sm3, false);
            winner = this._playerOneName + " won";
            try {
                this.saveResults(this._playerOneID, this._playerTwoID, this._playerOneClass, this._playerTwoClass, 1, this._startTime, _fightTime, this._type == Olympiad.COMP_TYPE.CLASSED ? 1 : 0);
                result = " (" + playerOneHp + "hp vs " + playerTwoHp + "hp - " + this._damageP1 + "dmg vs " + this._damageP2 + "dmg) " + this._playerOneName + " win " + pointDiff + " points";
                L2ItemInstance item = this._playerOne.getInventory().addItem("Olympiad", Config.ALT_OLY_BATTLE_REWARD_ITEM, _gpreward, this._playerOne, null);
                InventoryUpdate iu = new InventoryUpdate();
                iu.addModifiedItem(item);
                this._playerOne.sendPacket(iu);
                sm = new SystemMessage(SystemMessageId.EARNED_S2_S1_S);
                sm.addItemName(item);
                sm.addNumber(_gpreward);
                this._playerOne.sendPacket(sm);
            }
            catch (Exception e) {}
        } else if (this._playerOne == null || this._playerOne.isOnline() == 0 || playerOneHp == 0.0 && playerTwoHp != 0.0 || this._damageP2 > this._damageP1 && playerOneHp != 0.0 && playerTwoHp != 0.0) {
            playerTwoStat.set(POINTS, playerTwoPoints + pointDiff);
            playerOneStat.set(POINTS, playerOnePoints - pointDiff);
            playerTwoStat.set(COMP_WON, playerTwoWon + 1);
            playerOneStat.set(COMP_LOST, playerOneLost + 1);
            this._sm.addString(this._playerTwoName);
            this.broadcastMessage(this._sm, true);
            this._sm2.addString(this._playerTwoName);
            this._sm2.addNumber(pointDiff);
            this.broadcastMessage(this._sm2, false);
            this._sm3.addString(this._playerOneName);
            this._sm3.addNumber(pointDiff);
            this.broadcastMessage(this._sm3, false);
            winner = this._playerTwoName + " won";
            try {
                this.saveResults(this._playerOneID, this._playerTwoID, this._playerOneClass, this._playerTwoClass, 2, this._startTime, _fightTime, this._type == Olympiad.COMP_TYPE.CLASSED ? 1 : 0);
                result = " (" + playerOneHp + "hp vs " + playerTwoHp + "hp - " + this._damageP1 + "dmg vs " + this._damageP2 + "dmg) " + this._playerTwoName + " win " + pointDiff + " points";
                L2ItemInstance item = this._playerTwo.getInventory().addItem("Olympiad", Config.ALT_OLY_BATTLE_REWARD_ITEM, _gpreward, this._playerTwo, null);
                InventoryUpdate iu = new InventoryUpdate();
                iu.addModifiedItem(item);
                this._playerTwo.sendPacket(iu);
                sm = new SystemMessage(SystemMessageId.EARNED_S2_S1_S);
                sm.addItemName(item);
                sm.addNumber(_gpreward);
                this._playerTwo.sendPacket(sm);
            }
            catch (Exception e) {}
        } else {
            this.saveResults(this._playerOneID, this._playerTwoID, this._playerOneClass, this._playerTwoClass, 0, this._startTime, _fightTime, this._type == Olympiad.COMP_TYPE.CLASSED ? 1 : 0);
            result = " tie";
            this._sm = new SystemMessage(SystemMessageId.THE_GAME_ENDED_IN_A_TIE);
            this.broadcastMessage(this._sm, true);
            int pointOneDiff = Math.min(playerOnePoints / 5, Config.ALT_OLY_MAX_POINTS);
            int pointTwoDiff = Math.min(playerTwoPoints / 5, Config.ALT_OLY_MAX_POINTS);
            playerOneStat.set(POINTS, playerOnePoints - pointOneDiff);
            playerTwoStat.set(POINTS, playerTwoPoints - pointTwoDiff);
            playerOneStat.set(COMP_DRAWN, playerOneDrawn + 1);
            playerTwoStat.set(COMP_DRAWN, playerTwoDrawn + 1);
            this._sm2 = new SystemMessage(SystemMessageId.C1_HAS_LOST_S2_OLYMPIAD_POINTS);
            this._sm2.addString(this._playerOneName);
            this._sm2.addNumber(pointOneDiff);
            this.broadcastMessage(this._sm2, false);
            this._sm3 = new SystemMessage(SystemMessageId.C1_HAS_LOST_S2_OLYMPIAD_POINTS);
            this._sm3.addString(this._playerTwoName);
            this._sm3.addNumber(pointTwoDiff);
            this.broadcastMessage(this._sm3, false);
        }
        if (Config.DEBUG) {
            _log.info("Olympia Result: " + this._playerOneName + " vs " + this._playerTwoName + " ... " + result);
        }
        playerOneStat.set(COMP_DONE, playerOnePlayed + 1);
        playerTwoStat.set(COMP_DONE, playerTwoPlayed + 1);
        Olympiad.updateNobleStats(this._playerOneID, playerOneStat);
        Olympiad.updateNobleStats(this._playerTwoID, playerTwoStat);
        if (Config.ALT_OLY_LOG_FIGHTS) {
            LogRecord record = new LogRecord(Level.INFO, winner);
            record.setParameters(new Object[]{this._playerOneName, this._playerTwoName, playerOneHp, playerTwoHp, this._damageP1, this._damageP2, pointDiff, classed});
            _logResults.log(record);
        }
        int step = 10;
        int i = 40;
        while (i > 0) {
            this._sm = new SystemMessage(SystemMessageId.YOU_WILL_BE_MOVED_TO_TOWN_IN_S1_SECONDS);
            this._sm.addNumber(i);
            this.broadcastMessage(this._sm, false);
            switch (i) {
                case 10: {
                    step = 5;
                    break;
                }
                case 5: {
                    step = 1;
                }
            }
            try {
                Thread.sleep(step * 1000);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            i = (byte)(i - step);
        }
    }

    protected boolean makeCompetitionStart() {
        this._startTime = System.currentTimeMillis();
        if (this._aborted) {
            return false;
        }
        this._sm = new SystemMessage(SystemMessageId.STARTS_THE_GAME);
        this.broadcastMessage(this._sm, true);
        _gameIsStarted = true;
        try {
            Iterator i$ = this._players.iterator();
            while (i$.hasNext()) {
                L2PcInstance player = (L2PcInstance)i$.next();
                player.setIsOlympiadStart(true);
                player.updateEffectIcons();
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "", e);
            this._aborted = true;
            return false;
        }
        return true;
    }

    protected void addDamage(L2PcInstance player, int damage) {
        if (this._playerOne == null || this._playerTwo == null) {
            return;
        }
        if (player == this._playerOne) {
            this._damageP1 += damage;
        } else if (player == this._playerTwo) {
            this._damageP2 += damage;
        }
    }

    protected String getTitle() {
        String msg = this._playerOneName + " / " + this._playerTwoName;
        return msg;
    }

    protected L2PcInstance[] getPlayers() {
        if (this._players == null || this._players.isEmpty()) {
            return null;
        }
        Object[] players = new L2PcInstance[this._players.size()];
        this._players.toArray(players);
        return players;
    }

    protected void broadcastMessage(SystemMessage sm, boolean toAll) {
        Iterator<L2PcInstance> i$ = this._players.iterator();
        while (i$.hasNext()) {
            L2PcInstance player = (L2PcInstance)i$.next();
            if (player == null) continue;
            player.sendPacket(sm);
        }
        if (toAll && OlympiadManager.STADIUMS[this._stadiumID].getSpectators() != null) {
            for (L2PcInstance spec : OlympiadManager.STADIUMS[this._stadiumID].getSpectators()) {
                if (spec == null) continue;
                spec.sendPacket(sm);
            }
        }
    }

    protected void announceGame() {
        String gameType = null;
        switch (this._type) {
            case NON_CLASSED: {
                gameType = "class-free individual match";
                break;
            }
            default: {
                gameType = "class-specific individual match";
            }
        }
        for (L2Spawn manager : SpawnTable.getInstance().getSpawnTable().values()) {
            if (manager == null || manager.getNpcid() != 31688) continue;
            int objId = manager.getLastSpawn().getObjectId();
            String npcName = manager.getLastSpawn().getName();
            manager.getLastSpawn().broadcastPacket(new CreatureSay(objId, 1, npcName, "Olympiad " + gameType + " is going to begin in Arena " + (this._stadiumID + 1) + " in a moment."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveResults(int _playerOne, int _playerTwo, int _playerOneClass, int _playerTwoClass, int _winner, long _startTime, long _fightTime, int _classed) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO olympiad_fights (charOneId, charTwoId, charOneClass, charTwoClass, winner, start, time, classed) values(?,?,?,?,?,?,?,?)");
            statement.setInt(1, _playerOne);
            statement.setInt(2, _playerTwo);
            statement.setInt(3, _playerOneClass);
            statement.setInt(4, _playerTwoClass);
            statement.setInt(5, _winner);
            statement.setLong(6, _startTime);
            statement.setLong(7, _fightTime);
            statement.setInt(8, _classed);
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            if (_log.isLoggable(Level.SEVERE)) {
                _log.log(Level.SEVERE, "SQL exception while saving olympiad fight.", e);
            }
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }
}

