/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.EnterWorld;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.nio.BufferUnderflowException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mmocore.network.ReceivablePacket;

public abstract class L2GameClientPacket
extends ReceivablePacket<L2GameClient> {
    private static final Logger _log = Logger.getLogger(L2GameClientPacket.class.getName());

    protected boolean read() {
        try {
            this.readImpl();
            return true;
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Client: " + ((L2GameClient)this.getClient()).toString() + " - Failed reading: " + this.getType() + " - L2J Server Version: " + Config.SERVER_VERSION + " - DP Revision: " + Config.DATAPACK_VERSION + " ; " + e.getMessage(), e);
            if (e instanceof BufferUnderflowException) {
                if (GameTimeController.getGameTicks() - ((L2GameClient)this.getClient()).underflowReadStartTick > 600) {
                    ((L2GameClient)this.getClient()).underflowReadStartTick = GameTimeController.getGameTicks();
                    ((L2GameClient)this.getClient()).underflowReadsInMin = 1;
                } else {
                    ((L2GameClient)this.getClient()).underflowReadsInMin = (byte)(((L2GameClient)this.getClient()).underflowReadsInMin + 1);
                    if (((L2GameClient)this.getClient()).underflowReadsInMin > 1) {
                        ((L2GameClient)this.getClient()).closeNow();
                        _log.severe("Client " + ((L2GameClient)this.getClient()).toString() + " - Disconnected: Too many buffer underflow exceptions");
                    }
                }
            }
            return false;
        }
    }

    protected abstract void readImpl();

    public void run() {
        block8: {
            try {
                if (GameTimeController.getGameTicks() - ((L2GameClient)this.getClient()).packetsSentStartTick > 10) {
                    ((L2GameClient)this.getClient()).packetsSentStartTick = GameTimeController.getGameTicks();
                    ((L2GameClient)this.getClient()).packetsSentInSec = 0;
                } else {
                    ((L2GameClient)this.getClient()).packetsSentInSec = (byte)(((L2GameClient)this.getClient()).packetsSentInSec + 1);
                    if (((L2GameClient)this.getClient()).packetsSentInSec > 12) {
                        if (((L2GameClient)this.getClient()).packetsSentInSec < 100) {
                            this.sendPacket(ActionFailed.STATIC_PACKET);
                        }
                        return;
                    }
                }
                this.runImpl();
                L2PcInstance actor = ((L2GameClient)this.getClient()).getActiveChar();
                if (actor != null && (actor.isSpawnProtected() || actor.isInvul()) && this.triggersOnActionRequest()) {
                    actor.onActionRequest();
                    if (Config.DEBUG) {
                        _log.info("Spawn protection for player " + actor.getName() + " removed by packet: " + this.getType());
                    }
                }
                this.cleanUp();
            }
            catch (Throwable t) {
                _log.log(Level.SEVERE, "Client: " + ((L2GameClient)this.getClient()).toString() + " - Failed running: " + this.getType() + " - L2J Server Version: " + Config.SERVER_VERSION + " - DP Revision: " + Config.DATAPACK_VERSION + " ; " + t.getMessage(), t);
                if (!(this instanceof EnterWorld)) break block8;
                ((L2GameClient)this.getClient()).closeNow();
            }
        }
    }

    protected abstract void runImpl();

    protected final void sendPacket(L2GameServerPacket gsp) {
        ((L2GameClient)this.getClient()).sendPacket(gsp);
    }

    public abstract String getType();

    protected boolean triggersOnActionRequest() {
        return true;
    }

    protected void cleanUp() {
    }
}

