/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.datatables.PetNameTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestChangePetName
extends L2GameClientPacket {
    private static final String REQUESTCHANGEPETNAME__C__89 = "[C] 89 RequestChangePetName";
    private String _name;

    @Override
    protected void readImpl() {
        this._name = this.readS();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2Summon pet = ((L2Character)activeChar).getPet();
        if (pet == null) {
            return;
        }
        if (pet.getName() != null) {
            ((L2Object)activeChar).sendPacket(new SystemMessage(SystemMessageId.NAMING_YOU_CANNOT_SET_NAME_OF_THE_PET));
            return;
        }
        if (PetNameTable.getInstance().doesPetNameExist(this._name, pet.getTemplate().npcId)) {
            ((L2Object)activeChar).sendPacket(new SystemMessage(SystemMessageId.NAMING_ALREADY_IN_USE_BY_ANOTHER_PET));
            return;
        }
        if (this._name.length() < 3 || this._name.length() > 16) {
            ((L2Character)activeChar).sendMessage("\u30da\u30c3\u30c8\u306b\u306f3\u6587\u5b57\u4ee5\u4e0a16\u6587\u5b57\u307e\u3067\u306e\u540d\u524d\u304c\u3064\u3051\u3089\u308c\u307e\u3059\u3002");
            return;
        }
        if (!PetNameTable.getInstance().isValidPetName(this._name)) {
            ((L2Object)activeChar).sendPacket(new SystemMessage(SystemMessageId.NAMING_PETNAME_CONTAINS_INVALID_CHARS));
            return;
        }
        pet.setName(this._name);
        pet.updateAndBroadcastStatus(1);
    }

    @Override
    public String getType() {
        return REQUESTCHANGEPETNAME__C__89;
    }
}

