/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.AbstractRefinePacket;
import com.l2jserver.gameserver.network.serverpackets.ExPutCommissionResultForVariationMake;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public final class RequestConfirmGemStone
extends AbstractRefinePacket {
    private static final String _C__D0_2B_REQUESTCONFIRMGEMSTONE = "[C] D0:2B RequestConfirmGemStone";
    private int _targetItemObjId;
    private int _refinerItemObjId;
    private int _gemstoneItemObjId;
    private long _gemStoneCount;

    @Override
    protected void readImpl() {
        this._targetItemObjId = this.readD();
        this._refinerItemObjId = this.readD();
        this._gemstoneItemObjId = this.readD();
        this._gemStoneCount = this.readQ();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2ItemInstance targetItem = (L2ItemInstance)L2World.getInstance().findObject(this._targetItemObjId);
        if (targetItem == null) {
            return;
        }
        L2ItemInstance refinerItem = (L2ItemInstance)L2World.getInstance().findObject(this._refinerItemObjId);
        if (refinerItem == null) {
            return;
        }
        L2ItemInstance gemStoneItem = (L2ItemInstance)L2World.getInstance().findObject(this._gemstoneItemObjId);
        if (gemStoneItem == null) {
            return;
        }
        if (!RequestConfirmGemStone.isValid(activeChar, targetItem, refinerItem, gemStoneItem)) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.THIS_IS_NOT_A_SUITABLE_ITEM));
            return;
        }
        AbstractRefinePacket.LifeStone ls = RequestConfirmGemStone.getLifeStone(refinerItem.getItemId());
        if (ls == null) {
            return;
        }
        if (this._gemStoneCount != (long)RequestConfirmGemStone.getGemStoneCount(targetItem.getItem().getItemGrade(), ls.getGrade())) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.GEMSTONE_QUANTITY_IS_INCORRECT));
            return;
        }
        activeChar.sendPacket(new ExPutCommissionResultForVariationMake(this._gemstoneItemObjId, this._gemStoneCount, gemStoneItem.getItemId()));
    }

    @Override
    public String getType() {
        return _C__D0_2B_REQUESTCONFIRMGEMSTONE;
    }
}

