/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.ItemRequest;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.TradeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.util.Util;
import java.util.logging.Logger;
import javolution.util.FastSet;

public final class RequestPrivateStoreBuy
extends L2GameClientPacket {
    private static final String _C__79_REQUESTPRIVATESTOREBUY = "[C] 79 RequestPrivateStoreBuy";
    private static Logger _log = Logger.getLogger(RequestPrivateStoreBuy.class.getName());
    private static final int BATCH_LENGTH = 20;
    private int _storePlayerId;
    private FastSet<ItemRequest> _items = null;

    @Override
    protected void readImpl() {
        this._storePlayerId = this.readD();
        int count = this.readD();
        if (count <= 0 || count > Config.MAX_ITEM_IN_PACKET || count * 20 != this._buf.remaining()) {
            return;
        }
        this._items = FastSet.newInstance();
        for (int i = 0; i < count; ++i) {
            int objectId = this.readD();
            long cnt = this.readQ();
            long price = this.readQ();
            if (objectId < 1 || cnt < 1L || price < 0L) {
                this._items = null;
                return;
            }
            this._items.add((Object)new ItemRequest(objectId, cnt, price));
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (this._items == null) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("privatestorebuy")) {
            player.sendMessage("You buying items too fast.");
            return;
        }
        L2Object object = L2World.getInstance().findObject(this._storePlayerId);
        if (!(object instanceof L2PcInstance)) {
            return;
        }
        if (player.isCursedWeaponEquipped()) {
            return;
        }
        L2PcInstance storePlayer = (L2PcInstance)object;
        if (!player.isInsideRadius(storePlayer, 150, true, false)) {
            return;
        }
        if (player.getInstanceId() != storePlayer.getInstanceId() && player.getInstanceId() != -1) {
            return;
        }
        if (storePlayer.getPrivateStoreType() != 1 && storePlayer.getPrivateStoreType() != 8) {
            return;
        }
        TradeList storeList = storePlayer.getSellList();
        if (storeList == null) {
            return;
        }
        if (!player.getAccessLevel().allowTransaction()) {
            player.sendMessage("Transactions are disable for your Access Level");
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (storePlayer.getPrivateStoreType() == 8 && storeList.getItemCount() > this._items.size()) {
            String msgErr = "[RequestPrivateStoreBuy] player " + ((L2GameClient)this.getClient()).getActiveChar().getName() + " tried to buy less items than sold by package-sell, ban this player for bot usage!";
            Util.handleIllegalPlayerAction(((L2GameClient)this.getClient()).getActiveChar(), msgErr, Config.DEFAULT_PUNISH);
            return;
        }
        int result = storeList.privateStoreBuy(player, this._items);
        if (result > 0) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            if (result > 1) {
                _log.warning("PrivateStore buy has failed due to invalid list or request. Player: " + player.getName() + ", Private store of: " + storePlayer.getName());
            }
            return;
        }
        if (storeList.getItemCount() == 0) {
            storePlayer.setPrivateStoreType(0);
            storePlayer.broadcastUserInfo();
        }
    }

    @Override
    public String getType() {
        return _C__79_REQUESTPRIVATESTOREBUY;
    }

    @Override
    protected void cleanUp() {
        FastSet.recycle(this._items);
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return false;
    }
}

