/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.ClanWarehouse;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.itemcontainer.PcWarehouse;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.util.logging.Logger;

public final class SendWareHouseWithDrawList
extends L2GameClientPacket {
    private static final String _C__32_SENDWAREHOUSEWITHDRAWLIST = "[C] 32 SendWareHouseWithDrawList";
    private static Logger _log = Logger.getLogger(SendWareHouseWithDrawList.class.getName());
    private static final int BATCH_LENGTH = 12;
    private WarehouseItem[] _items = null;

    @Override
    protected void readImpl() {
        int count = this.readD();
        if (count <= 0 || count > Config.MAX_ITEM_IN_PACKET || count * 12 != this._buf.remaining()) {
            return;
        }
        this._items = new WarehouseItem[count];
        for (int i = 0; i < count; ++i) {
            int objId = this.readD();
            long cnt = this.readQ();
            if (objId < 1 || cnt < 0L) {
                this._items = null;
                return;
            }
            this._items[i] = new WarehouseItem(objId, cnt);
        }
    }

    @Override
    protected void runImpl() {
        if (this._items == null) {
            return;
        }
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("withdraw")) {
            player.sendMessage("You withdrawing items too fast.");
            return;
        }
        ItemContainer warehouse = player.getActiveWarehouse();
        if (warehouse == null) {
            return;
        }
        L2Npc manager = player.getLastFolkNPC();
        if (!(manager != null && manager.isWarehouse() && manager.canInteract(player) || player.isGM())) {
            return;
        }
        if (!(warehouse instanceof PcWarehouse) && !player.getAccessLevel().allowTransaction()) {
            player.sendMessage("Transactions are disable for your Access Level");
            return;
        }
        if (!Config.ALT_GAME_KARMA_PLAYER_CAN_USE_WAREHOUSE && player.getKarma() > 0) {
            return;
        }
        if (Config.ALT_MEMBERS_CAN_WITHDRAW_FROM_CLANWH) {
            if (warehouse instanceof ClanWarehouse && (player.getClanPrivileges() & 8) != 8) {
                return;
            }
        } else if (warehouse instanceof ClanWarehouse && !player.isClanLeader()) {
            player.sendPacket(new SystemMessage(SystemMessageId.ONLY_CLAN_LEADER_CAN_RETRIEVE_ITEMS_FROM_CLAN_WAREHOUSE));
            return;
        }
        int weight = 0;
        int slots = 0;
        for (WarehouseItem i : this._items) {
            L2ItemInstance item = warehouse.getItemByObjectId(i.getObjectId());
            if (item == null || item.getCount() < i.getCount()) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to withdraw non-existent item from warehouse.", Config.DEFAULT_PUNISH);
                return;
            }
            weight = (int)((long)weight + i.getCount() * (long)item.getItem().getWeight());
            if (!item.isStackable()) {
                slots = (int)((long)slots + i.getCount());
                continue;
            }
            if (player.getInventory().getItemByItemId(item.getItemId()) != null) continue;
            ++slots;
        }
        if (!player.getInventory().validateCapacity(slots)) {
            this.sendPacket(new SystemMessage(SystemMessageId.SLOTS_FULL));
            return;
        }
        if (!player.getInventory().validateWeight(weight)) {
            this.sendPacket(new SystemMessage(SystemMessageId.WEIGHT_LIMIT_EXCEEDED));
            return;
        }
        InventoryUpdate playerIU = Config.FORCE_INVENTORY_UPDATE ? null : new InventoryUpdate();
        for (WarehouseItem i : this._items) {
            L2ItemInstance oldItem = warehouse.getItemByObjectId(i.getObjectId());
            if (oldItem == null || oldItem.getCount() < i.getCount()) {
                _log.warning("Error withdrawing a warehouse object for char " + player.getName() + " (olditem == null)");
                return;
            }
            L2ItemInstance newItem = warehouse.transferItem(warehouse.getName(), i.getObjectId(), i.getCount(), player.getInventory(), player, manager);
            if (newItem == null) {
                _log.warning("Error withdrawing a warehouse object for char " + player.getName() + " (newitem == null)");
                return;
            }
            if (playerIU == null) continue;
            if (newItem.getCount() > i.getCount()) {
                playerIU.addModifiedItem(newItem);
                continue;
            }
            playerIU.addNewItem(newItem);
        }
        if (playerIU != null) {
            player.sendPacket(playerIU);
        } else {
            player.sendPacket(new ItemList(player, false));
        }
        StatusUpdate su = new StatusUpdate(player);
        su.addAttribute(14, player.getCurrentLoad());
        player.sendPacket(su);
    }

    @Override
    public String getType() {
        return _C__32_SENDWAREHOUSEWITHDRAWLIST;
    }

    private class WarehouseItem {
        private final int _objectId;
        private final long _count;

        public WarehouseItem(int id, long num) {
            this._objectId = id;
            this._count = num;
        }

        public int getObjectId() {
            return this._objectId;
        }

        public long getCount() {
            return this._count;
        }
    }
}

