/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.script.faenor;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.script.DateRange;
import com.l2jserver.gameserver.script.IntList;
import com.l2jserver.gameserver.script.Parser;
import com.l2jserver.gameserver.script.ParserFactory;
import com.l2jserver.gameserver.script.ScriptEngine;
import com.l2jserver.gameserver.script.faenor.FaenorEventParser;
import com.l2jserver.gameserver.script.faenor.FaenorParser;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Date;
import java.util.logging.Logger;
import javax.script.ScriptContext;
import javolution.text.TypeFormat;
import org.w3c.dom.Node;

public class FaenorEventParserEx
extends FaenorParser {
    static Logger _log = Logger.getLogger(FaenorEventParser.class.getName());
    private DateRange _eventDates = null;

    private void doCleanAllPlayers(Node cleanNode) {
        try {
            for (Node node = cleanNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (FaenorEventParserEx.isNodeName(node, "ItemsRange")) {
                    _log.warning("Event cleaning : ItemsRange.");
                    int minItemID = TypeFormat.parseInt((String)FaenorEventParserEx.attribute(node, "MinItemID"));
                    int maxItemID = TypeFormat.parseInt((String)FaenorEventParserEx.attribute(node, "MaxItemID"));
                    this.sql_DeleteItemsToItemIdRange(minItemID, maxItemID);
                    continue;
                }
                if (!FaenorEventParserEx.isNodeName(node, "Item")) continue;
                _log.warning("Event cleaning : Item.");
                int ItemID = TypeFormat.parseInt((String)FaenorEventParserEx.attribute(node, "ItemID"));
                this.sql_DeleteItemsToItemId(ItemID);
            }
        }
        catch (Exception e) {
            _log.warning("Error in event parser.");
            e.printStackTrace();
        }
    }

    private void parceSpawnNpc(Node spawnNode) {
        try {
            int npcid = TypeFormat.parseInt((String)FaenorEventParserEx.attribute(spawnNode, "NpcId"));
            int coordinatesX = TypeFormat.parseInt((String)FaenorEventParserEx.attribute(spawnNode, "SpawnX"));
            int coordinatesY = TypeFormat.parseInt((String)FaenorEventParserEx.attribute(spawnNode, "SpawnY"));
            int coordinatesZ = TypeFormat.parseInt((String)FaenorEventParserEx.attribute(spawnNode, "SpawnZ"));
            int head = TypeFormat.parseInt((String)FaenorEventParserEx.attribute(spawnNode, "Heading"));
            int respawn_delay = TypeFormat.parseInt((String)FaenorEventParserEx.attribute(spawnNode, "RespawnDelay"));
            L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(npcid);
            if (template1 == null) {
                return;
            }
            L2Spawn spawn = new L2Spawn(template1);
            spawn.setLocx(coordinatesX);
            spawn.setLocy(coordinatesY);
            spawn.setLocz(coordinatesZ);
            spawn.setAmount(1);
            spawn.setHeading(head);
            spawn.setRespawnDelay(respawn_delay);
            spawn.init();
            SpawnTable.getInstance().addNewSpawn(spawn, false);
            if (respawn_delay <= 0) {
                spawn.stopRespawn();
            }
        }
        catch (Exception e) {
            _log.warning("Error in event parser.");
            e.printStackTrace();
        }
    }

    private void parseEventClean(Node CommandNode) {
        try {
            for (Node node = CommandNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!FaenorEventParserEx.isNodeName(node, "Take") || !FaenorEventParserEx.attribute(node, "From").equalsIgnoreCase("AllPlayers")) continue;
                this.doCleanAllPlayers(node);
            }
        }
        catch (Exception e) {
            _log.warning("Error in event parser.");
            e.printStackTrace();
        }
    }

    private void parseEventDropList(Node dropList) {
        _log.fine("Parsing Droplist.");
        DateRange _activeDate = null;
        _activeDate = DateRange.parse(FaenorEventParserEx.attribute(dropList, "Active"), DATE_FORMAT);
        Date currentDate = new Date();
        if (!_activeDate.isWithinRange(currentDate)) {
            _log.warning("FaenorEventParser: Drops has disabled! Out of date!");
            return;
        }
        for (Node node = dropList.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (FaenorEventParserEx.isNodeName(node, "AllDrop")) {
                this.parseForAllEventDrop(node);
                continue;
            }
            if (!FaenorEventParserEx.isNodeName(node, "NpcsDrop")) continue;
            this.parseForNpcsEventDrop(node);
        }
    }

    private void parseEventMessage(Node sysMsg) {
        _log.fine("Parsing Event Message.");
        DateRange _activeDate = null;
        _activeDate = DateRange.parse(FaenorEventParserEx.attribute(sysMsg, "Active"), DATE_FORMAT);
        Date currentDate = new Date();
        if (!_activeDate.isWithinRange(currentDate)) {
            return;
        }
        try {
            String type = FaenorEventParserEx.attribute(sysMsg, "Type");
            String[] message = FaenorEventParserEx.attribute(sysMsg, "Msg").split("\n");
            if (type.equalsIgnoreCase("OnJoin")) {
                _bridge.onPlayerLogin(message, this._eventDates);
            }
        }
        catch (Exception e) {
            _log.warning("Error in event parser.");
            e.printStackTrace();
        }
    }

    private void parseForAllEventDrop(Node drop) {
        _log.fine("Parsing Drop.");
        try {
            int[] items = IntList.parse(FaenorEventParserEx.attribute(drop, "Items"));
            int[] count = IntList.parse(FaenorEventParserEx.attribute(drop, "Count"));
            double chance = FaenorEventParserEx.getPercent(FaenorEventParserEx.attribute(drop, "Chance"));
            _bridge.addEventDrop(items, count, chance, this._eventDates);
        }
        catch (Exception e) {
            System.err.println("ERROR(parseEventDrop):" + e.getMessage());
        }
    }

    private void parseForNpcsEventDrop(Node drop) {
        _log.fine("Parsing for npcs Drop.");
        try {
            int[] npcs;
            int[] items = IntList.parse(FaenorEventParserEx.attribute(drop, "Items"));
            int[] count = IntList.parse(FaenorEventParserEx.attribute(drop, "Count"));
            double chance = FaenorEventParserEx.getPercent(FaenorEventParserEx.attribute(drop, "Chance"));
            for (int npc : npcs = IntList.parse(FaenorEventParserEx.attribute(drop, "Npcs"))) {
                if (npc <= 0) continue;
                throw new UnsupportedOperationException();
            }
        }
        catch (Exception e) {
            System.err.println("ERROR(parseEventDrop):" + e.getMessage());
        }
    }

    @Override
    public void parseScript(Node eventNode, ScriptContext context) {
        String ID = FaenorEventParserEx.attribute(eventNode, "ID");
        _log.fine("Parsing Event \"" + ID + "\"");
        this._eventDates = DateRange.parse(FaenorEventParserEx.attribute(eventNode, "Active"), DATE_FORMAT);
        Date currentDate = new Date();
        if (!this._eventDates.isWithinRange(currentDate)) {
            _log.warning("Event ID: (" + ID + ") has passed... Ignored.");
            for (Node node = eventNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!FaenorEventParserEx.isNodeName(node, "EventEnd")) continue;
                this.parseEventClean(node);
            }
            return;
        }
        _log.warning("Event ID: (" + ID + ") ... Started.");
        for (Node node = eventNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (FaenorEventParserEx.isNodeName(node, "DropList")) {
                this.parseEventDropList(node);
                continue;
            }
            if (FaenorEventParserEx.isNodeName(node, "Message")) {
                this.parseEventMessage(node);
                continue;
            }
            if (!FaenorEventParserEx.isNodeName(node, "SpawnList")) continue;
            this.parseSpawnList(node);
        }
    }

    private void parseSpawnList(Node spawnNode) {
        try {
            for (Node node = spawnNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!FaenorEventParserEx.isNodeName(node, "Spawn")) continue;
                this.parceSpawnNpc(node);
            }
        }
        catch (Exception e) {
            _log.warning("Error in event parser.");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sql_DeleteItemsToItemId(int _itemId) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM items WHERE item_id=?");
            statement.setInt(1, _itemId);
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("Could not delete item " + _itemId + " in DB: " + e.getMessage());
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sql_DeleteItemsToItemIdRange(int _itemIdMin, int _itemIdMax) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM items WHERE item_id>=? AND item_id<=?");
            statement.setInt(1, _itemIdMin);
            statement.setInt(2, _itemIdMax);
            statement.executeUpdate();
            statement.close();
        }
        catch (Exception e) {
            _log.warning("Could not delete items " + _itemIdMin + " <> " + _itemIdMax + " in DB: " + e.getMessage());
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    static {
        ScriptEngine.parserFactories.put(FaenorEventParserEx.getParserName("Event"), new FaenorEventParserFactory());
    }

    static class FaenorEventParserFactory
    extends ParserFactory {
        FaenorEventParserFactory() {
        }

        @Override
        public Parser create() {
            return new FaenorEventParser();
        }
    }
}

