/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.MultiSell;
import com.l2jserver.gameserver.model.Elementals;
import com.l2jserver.gameserver.model.L2Augmentation;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.model.multisell.Entry;
import com.l2jserver.gameserver.model.multisell.Ingredient;
import com.l2jserver.gameserver.model.multisell.PreparedListContainer;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.ArrayList;
import java.util.logging.Logger;
import javolution.util.FastList;

public class MultiSellChoose
extends L2GameClientPacket {
    private static final String _C__A7_MULTISELLCHOOSE = "[C] A7 MultiSellChoose";
    private static Logger _log = Logger.getLogger(MultiSellChoose.class.getName());
    private int _listId;
    private int _entryId;
    private long _amount;

    @Override
    protected void readImpl() {
        this._listId = this.readD();
        this._entryId = this.readD();
        this._amount = this.readQ();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getMultiSell().tryPerformAction("multisell choose")) {
            player.setMultiSell(null);
            return;
        }
        if (this._amount < 1L || this._amount > 5000L) {
            player.setMultiSell(null);
            return;
        }
        PreparedListContainer list = player.getMultiSell();
        if (list == null || list.getListId() != this._listId) {
            player.setMultiSell(null);
            return;
        }
        L2Npc target = player.getLastFolkNPC();
        if (!(player.isGM() || target != null && list.checkNpcObjectId(target.getObjectId()) && target.canInteract(player))) {
            player.setMultiSell(null);
            return;
        }
        for (Entry entry : list.getEntries()) {
            SystemMessage sm;
            if (entry.getEntryId() != this._entryId) continue;
            if (!entry.isStackable() && this._amount > 1L) {
                _log.severe("Character: " + player.getName() + " is trying to set amount > 1 on non-stackable multisell, id:" + this._listId + ":" + this._entryId);
                player.setMultiSell(null);
                return;
            }
            PcInventory inv = player.getInventory();
            int slots = 0;
            int weight = 0;
            for (Ingredient e : entry.getProducts()) {
                if (e.getItemId() < 0) continue;
                if (!e.isStackable()) {
                    slots = (int)((long)slots + e.getItemCount() * this._amount);
                } else if (player.getInventory().getItemByItemId(e.getItemId()) == null) {
                    ++slots;
                }
                weight = (int)((long)weight + e.getItemCount() * this._amount * (long)e.getWeight());
            }
            if (!inv.validateWeight(weight)) {
                player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.WEIGHT_LIMIT_EXCEEDED));
                return;
            }
            if (!inv.validateCapacity(slots)) {
                player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.SLOTS_FULL));
                return;
            }
            ArrayList<Ingredient> ingredientsList = new ArrayList<Ingredient>(entry.getIngredients().size());
            for (Ingredient e : entry.getIngredients()) {
                boolean newIng = true;
                int i = ingredientsList.size();
                while (--i >= 0) {
                    Ingredient ex = (Ingredient)ingredientsList.get(i);
                    if (ex.getItemId() != e.getItemId() || ex.getEnchantLevel() != e.getEnchantLevel()) continue;
                    if (ex.getItemCount() + e.getItemCount() > Integer.MAX_VALUE) {
                        player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_EXCEEDED_QUANTITY_THAT_CAN_BE_INPUTTED));
                        return;
                    }
                    Ingredient ing = ex.clone();
                    ing.setItemCount(ex.getItemCount() + e.getItemCount());
                    ingredientsList.set(i, ing);
                    newIng = false;
                    break;
                }
                if (!newIng) continue;
                ingredientsList.add(e);
            }
            for (Ingredient e : ingredientsList) {
                if (e.getItemCount() * this._amount > Integer.MAX_VALUE) {
                    player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_HAVE_EXCEEDED_QUANTITY_THAT_CAN_BE_INPUTTED));
                    return;
                }
                if (e.getItemId() < 0) {
                    if (MultiSell.checkSpecialIngredient(e.getItemId(), e.getItemCount() * this._amount, player)) continue;
                    return;
                }
                long required = Config.ALT_BLACKSMITH_USE_RECIPES || !e.getMaintainIngredient() ? e.getItemCount() * this._amount : e.getItemCount();
                if (inv.getInventoryItemCount(e.getItemId(), list.getMaintainEnchantment() ? e.getEnchantLevel() : -1, false) >= required) continue;
                sm = SystemMessage.getSystemMessage(SystemMessageId.S2_UNIT_OF_THE_ITEM_S1_REQUIRED);
                sm.addItemName(e.getTemplate());
                sm.addNumber((int)required);
                player.sendPacket(sm);
                return;
            }
            FastList augmentation = FastList.newInstance();
            Elementals[] elemental = null;
            try {
                for (Ingredient e : entry.getIngredients()) {
                    if (e.getItemId() < 0) {
                        if (MultiSell.getSpecialIngredient(e.getItemId(), e.getItemCount() * this._amount, player)) continue;
                        return;
                    }
                    L2ItemInstance itemToTake = inv.getItemByItemId(e.getItemId());
                    if (itemToTake == null) {
                        _log.severe("Character: " + player.getName() + " is trying to cheat in multisell, id:" + this._listId + ":" + this._entryId);
                        player.setMultiSell(null);
                        return;
                    }
                    if (!Config.ALT_BLACKSMITH_USE_RECIPES && e.getMaintainIngredient()) continue;
                    if (itemToTake.isStackable()) {
                        if (player.destroyItem("Multisell", itemToTake.getObjectId(), e.getItemCount() * this._amount, player.getTarget(), true)) continue;
                        player.setMultiSell(null);
                        return;
                    }
                    if (list.getMaintainEnchantment()) {
                        L2ItemInstance[] inventoryContents = inv.getAllItemsByItemId(e.getItemId(), e.getEnchantLevel(), false);
                        int i = 0;
                        while ((long)i < e.getItemCount() * this._amount) {
                            if (inventoryContents[i].isAugmented()) {
                                augmentation.add((Object)inventoryContents[i].getAugmentation());
                            }
                            if (inventoryContents[i].getElementals() != null) {
                                elemental = inventoryContents[i].getElementals();
                            }
                            if (!player.destroyItem("Multisell", inventoryContents[i].getObjectId(), 1L, player.getTarget(), true)) {
                                player.setMultiSell(null);
                                return;
                            }
                            ++i;
                        }
                        continue;
                    }
                    int i = 1;
                    while ((long)i <= e.getItemCount() * this._amount) {
                        L2ItemInstance[] inventoryContents = inv.getAllItemsByItemId(e.getItemId(), false);
                        itemToTake = inventoryContents[0];
                        if (itemToTake.getEnchantLevel() > 0) {
                            for (L2ItemInstance item : inventoryContents) {
                                if (item.getEnchantLevel() < itemToTake.getEnchantLevel() && (itemToTake = item).getEnchantLevel() == 0) break;
                            }
                        }
                        if (!player.destroyItem("Multisell", itemToTake.getObjectId(), 1L, player.getTarget(), true)) {
                            player.setMultiSell(null);
                            return;
                        }
                        ++i;
                    }
                }
                for (Ingredient e : entry.getProducts()) {
                    if (e.getItemId() < 0) {
                        MultiSell.addSpecialProduct(e.getItemId(), e.getItemCount() * this._amount, player);
                        continue;
                    }
                    if (e.isStackable()) {
                        inv.addItem("Multisell", e.getItemId(), e.getItemCount() * this._amount, player, player.getTarget());
                    } else {
                        L2ItemInstance product = null;
                        int i = 0;
                        while ((long)i < e.getItemCount() * this._amount) {
                            product = inv.addItem("Multisell", e.getItemId(), 1L, player, player.getTarget());
                            if (list.getMaintainEnchantment()) {
                                if (i < augmentation.size()) {
                                    product.setAugmentation(new L2Augmentation(((L2Augmentation)augmentation.get(i)).getAugmentationId(), ((L2Augmentation)augmentation.get(i)).getSkill()));
                                }
                                if (elemental != null) {
                                    for (Elementals elm : elemental) {
                                        product.setElementAttr(elm.getElement(), elm.getValue());
                                    }
                                }
                                product.setEnchantLevel(e.getEnchantLevel());
                                product.updateDatabase();
                            }
                            ++i;
                        }
                    }
                    if (e.getItemCount() * this._amount > 1L) {
                        sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S2_S1_S);
                        sm.addItemName(e.getItemId());
                        sm.addItemNumber(e.getItemCount() * this._amount);
                        player.sendPacket(sm);
                        sm = null;
                        continue;
                    }
                    if (list.getMaintainEnchantment() && e.getEnchantLevel() > 0) {
                        sm = SystemMessage.getSystemMessage(SystemMessageId.ACQUIRED_S1_S2);
                        sm.addItemNumber(e.getEnchantLevel());
                        sm.addItemName(e.getItemId());
                    } else {
                        sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_ITEM_S1);
                        sm.addItemName(e.getItemId());
                    }
                    player.sendPacket(sm);
                    sm = null;
                }
                player.sendPacket(new ItemList(player, false));
                StatusUpdate su = new StatusUpdate(player);
                su.addAttribute(14, player.getCurrentLoad());
                player.sendPacket(su);
                su = null;
            }
            finally {
                FastList.recycle((FastList)augmentation);
            }
            if (entry.getTaxAmount() <= 0L) break;
            target.getCastle().addToTreasury(entry.getTaxAmount() * this._amount);
            break;
        }
    }

    @Override
    public String getType() {
        return _C__A7_MULTISELLCHOOSE;
    }
}

