/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.ActionKey;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import java.util.List;
import java.util.Map;
import javolution.util.FastList;
import javolution.util.FastMap;

public class RequestSaveKeyMapping
extends L2GameClientPacket {
    int _tabNum;
    Map<Integer, List<ActionKey>> _keyMap = new FastMap();
    Map<Integer, List<Integer>> _catMap = new FastMap();

    @Override
    public String getType() {
        return "[C] D0:22 RequestSaveKeyMapping";
    }

    @Override
    protected void readImpl() {
        int category = 0;
        this.readD();
        this.readD();
        this._tabNum = this.readD();
        for (int i = 0; i < this._tabNum; ++i) {
            int cmd1Size = this.readC();
            for (int j = 0; j < cmd1Size; ++j) {
                int cmdId = this.readC();
                this.insertCategory(category, cmdId);
            }
            ++category;
            int cmd2Size = this.readC();
            for (int j = 0; j < cmd2Size; ++j) {
                int cmdId = this.readC();
                this.insertCategory(category, cmdId);
            }
            ++category;
            int cmdSize = this.readD();
            for (int j = 0; j < cmdSize; ++j) {
                int cmd = this.readD();
                int key = this.readD();
                int tgKey1 = this.readD();
                int tgKey2 = this.readD();
                int show = this.readD();
                this.insertKey(i, cmd, key, tgKey1, tgKey2, show);
            }
        }
        this.readD();
        this.readD();
    }

    public void insertCategory(int cat, int cmd) {
        if (this._catMap.containsKey(cat)) {
            this._catMap.get(cat).add(cmd);
        } else {
            FastList tmp = new FastList();
            tmp.add(cmd);
            this._catMap.put(cat, (List<Integer>)tmp);
        }
    }

    public void insertKey(int cat, int cmdId, int key, int tgKey1, int tgKey2, int show) {
        ActionKey tmk = new ActionKey(cat, cmdId, key, tgKey1, tgKey2, show);
        if (this._keyMap.containsKey(cat)) {
            this._keyMap.get(cat).add(tmk);
        } else {
            FastList tmp = new FastList();
            tmp.add(tmk);
            this._keyMap.put(cat, (List<ActionKey>)tmp);
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (((L2GameClient)this.getClient()).getState() != L2GameClient.GameClientState.IN_GAME) {
            return;
        }
        if (Config.STORE_UI_SETTINGS) {
            player.getUISettings().storeAll(this._catMap, this._keyMap);
        }
    }
}

