/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastSet;

public class KnownListUpdateTaskManager {
    protected static final Logger _log = Logger.getLogger(KnownListUpdateTaskManager.class.getName());
    private static final int FULL_UPDATE_TIMER = 100;
    public static boolean updatePass = true;
    public static int _fullUpdateTimer = 100;
    private static final FastSet<L2WorldRegion> _failedRegions = new FastSet(1);

    private KnownListUpdateTaskManager() {
        ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new KnownListUpdate(), 1000L, Config.KNOWNLIST_UPDATE_INTERVAL);
    }

    public static KnownListUpdateTaskManager getInstance() {
        return SingletonHolder._instance;
    }

    public void updateRegion(L2WorldRegion region, boolean fullUpdate, boolean forgetObjects) {
        Collection<L2Object> vObj = region.getVisibleObjects().values();
        for (L2Object object : vObj) {
            boolean aggro;
            if (object == null || !object.isVisible()) continue;
            boolean bl = aggro = Config.GUARD_ATTACK_AGGRO_MOB && object instanceof L2GuardInstance || object instanceof L2Attackable && ((L2Attackable)object).getEnemyClan() != null;
            if (forgetObjects) {
                object.getKnownList().forgetObjects(aggro || fullUpdate);
                continue;
            }
            for (L2WorldRegion regi : region.getSurroundingRegions()) {
                if (object instanceof L2Playable || aggro && regi.isActive() || fullUpdate) {
                    Collection<L2Object> inrObj = regi.getVisibleObjects().values();
                    for (L2Object l2Object : inrObj) {
                        if (l2Object == object) continue;
                        object.getKnownList().addKnownObject(l2Object);
                    }
                    continue;
                }
                if (!(object instanceof L2Character) || !regi.isActive()) continue;
                Collection<L2Playable> inrPls = regi.getVisiblePlayable().values();
                for (L2Playable l2Playable : inrPls) {
                    if (l2Playable == object) continue;
                    object.getKnownList().addKnownObject(l2Playable);
                }
            }
        }
    }

    private static class SingletonHolder {
        protected static final KnownListUpdateTaskManager _instance = new KnownListUpdateTaskManager();

        private SingletonHolder() {
        }
    }

    private class KnownListUpdate
    implements Runnable {
        @Override
        public void run() {
            try {
                L2WorldRegion[][] arr$ = L2World.getInstance().getAllWorldRegions();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    L2WorldRegion[] regions;
                    for (L2WorldRegion r : regions = arr$[i$]) {
                        try {
                            boolean failed = _failedRegions.contains((Object)r);
                            if (r.isActive()) {
                                KnownListUpdateTaskManager.this.updateRegion(r, _fullUpdateTimer == 100 || failed, updatePass);
                            }
                            if (!failed) continue;
                            _failedRegions.remove((Object)r);
                        }
                        catch (Exception e) {
                            _log.log(Level.WARNING, "KnownListUpdateTaskManager: updateRegion(" + _fullUpdateTimer + "," + updatePass + ") failed for region " + r.getName() + ". Full update scheduled. " + e.getMessage(), e);
                            _failedRegions.add((Object)r);
                        }
                    }
                }
                boolean bl = updatePass = !updatePass;
                _fullUpdateTimer = _fullUpdateTimer > 0 ? --_fullUpdateTimer : 100;
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "", e);
            }
        }
    }
}

