DROP TABLE IF EXISTS `npc`;
CREATE TABLE `npc`(
  `id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `idTemplate` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name` varchar(200) NOT NULL DEFAULT '',
  `serverSideName` tinyint(1) NOT NULL DEFAULT '0',
  `title` varchar(45) NOT NULL DEFAULT '',
  `serverSideTitle` tinyint(1) NOT NULL DEFAULT '0',
  `class` varchar(200) DEFAULT NULL,
  `collision_radius` decimal(6,2) DEFAULT NULL,
  `collision_height` decimal(6,2) DEFAULT NULL,
  `level` tinyint(2) DEFAULT NULL,
  `sex` enum('etc','female','male') NOT NULL DEFAULT 'etc',
  `type` varchar(22) DEFAULT NULL,
  `attackrange` smallint(4) DEFAULT NULL,
  `hp` decimal(14,5) DEFAULT NULL,
  `mp` decimal(14,5) DEFAULT NULL,
  `hpreg` decimal(12,5) DEFAULT NULL,
  `mpreg` decimal(12,5) DEFAULT NULL,
  `str` tinyint(2) NOT NULL DEFAULT '40',
  `con` tinyint(2) NOT NULL DEFAULT '43',
  `dex` tinyint(2) NOT NULL DEFAULT '30',
  `int` tinyint(2) NOT NULL DEFAULT '21',
  `wit` tinyint(2) NOT NULL DEFAULT '20',
  `men` tinyint(2) NOT NULL DEFAULT '20',
  `exp` int(9) NOT NULL DEFAULT '0',
  `sp` int(9) NOT NULL DEFAULT '0',
  `patk` decimal(12,5) DEFAULT NULL,
  `pdef` decimal(12,5) DEFAULT NULL,
  `matk` decimal(12,5) DEFAULT NULL,
  `mdef` decimal(12,5) DEFAULT NULL,
  `atkspd` smallint(4) NOT NULL DEFAULT '230',
  `critical` tinyint(1) NOT NULL DEFAULT '1',
  `aggro` smallint(4) NOT NULL DEFAULT '0',
  `matkspd` smallint(4) NOT NULL DEFAULT '333',
  `rhand` smallint(5) unsigned NOT NULL DEFAULT '0',
  `lhand` smallint(5) unsigned NOT NULL DEFAULT '0',
  `enchant` tinyint(1) NOT NULL DEFAULT '0',
  `walkspd` smallint(3) NOT NULL DEFAULT '60',
  `runspd` smallint(3) NOT NULL DEFAULT '120',
  `targetable` tinyint(1) NOT NULL DEFAULT '1',
  `show_name` tinyint(1) NOT NULL DEFAULT '1',
  `dropHerbGroup` tinyint(1) NOT NULL DEFAULT '0',
  `basestats` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) DEFAULT CHARSET=utf8;

INSERT INTO `npc` VALUES 
(1,1,'Thomas D. Turkey',0,'Misguided Holiday Scrooge',0,'LineageMonster4.br_crazy_turkey','20.00','30.00',80,'male','L2Npc',40,'680.00000','1820.00000','0.00000','0.90000',40,43,30,21,20,20,0,0,'14.00000','101400.00000','6.00000','307525.00000',230,1,0,333,0,0,0,20,160,1,1,0,1),
(2,2,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',80,'male','L2Npc',40,'2880.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1499.00000','577.00000','1035.00000','384.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(3,3,'Santa\'s Helper',0,'',0,'LineageNPC.e_smith_master_MDwarf','8.00','17.00',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,490,10,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,120,1,1,0,1),
(4,4,'Holiday Santa',0,'Happy Holidays!',0,'LineageNPC2.br_xmas08_santa','9.00','16.00',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,490,10,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,120,1,1,0,1),
(5,5,'Holiday Santa',0,'Happy Holidays!',0,'LineageNPC2.br_xmas08_santa','9.00','16.00',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,490,10,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,120,1,1,0,1),
(6,6,'Holiday Sled',0,'Happy Holidays!',0,'LineageNPC2.br_xmas08_sled','9.00','27.30',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,10,490,10,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,30,120,1,1,0,1),
(7,7,'Birthday Cake',0,'',0,'LineageNPC2.br_birthday_cake','0.01','5.50',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,10,490,10,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,30,120,1,1,0,1),
(8,8,'Spirit of Fire',0,'',0,'LineageMonster4.br_fire_elemental','16.00','22.00',1,'male','L2Npc',40,'3862.00000','1494.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'8.00000','36.00000','5.00000','25.00000',253,1,0,333,0,0,0,25,120,1,1,0,0),
(9,9,'Explosive Spirit of Fire',0,'',0,'LineageMonster4.br_fire_elemental_of_fierce','26.00','35.00',1,'male','L2Npc',40,'3862.00000','1494.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'8.00000','36.00000','5.00000','25.00000',253,1,0,333,0,0,0,45,180,1,1,0,0),
(10,10,'Jack Sage',0,'Eva\'s High Priest',0,'LineageNPC2.br_archbishop_of_eva','8.00','26.50',85,'male','L2Npc',40,'3862.00000','1494.00000','7.50000','2.70000',40,43,30,21,20,20,723,10,'1187.00000','515.00000','819.00000','342.00000',253,4,0,333,0,0,0,50,120,1,1,0,0),
(11,11,'Eva\'s Obelisk',0,'',0,'LineageNPC2.br_obelisk_of_eva','40.01','120.00',70,'male','L2Npc',40,'3862.00000','1494.00000','7.50000','2.70000',40,43,30,21,20,10,490,10,'1086.00000','471.00000','748.00000','313.00000',253,4,0,333,0,0,0,30,120,0,1,0,0),
(12,12,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',80,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1498.00000','577.00000','1033.00000','384.00000',253,4,0,333,0,0,0,1,1,0,1,0,0),
(13,13,'Warm Hearted Sno',0,'Beginner Supporter',0,'LineageNPC2.br_tp_actor','9.00','28.30',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,4,180,1,1,0,0),
(14,14,'Warm Hearted Sno',0,'Beginner Supporter',0,'LineageNPC2.br_tp_actor','9.00','28.30',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,4,180,1,1,0,0),
(15,15,'Warm Hearted Sno',0,'Beginner Supporter',0,'LineageNPC2.br_tp_actor','9.00','28.30',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,4,180,1,1,0,0),
(16,16,'Warm Hearted Sno',0,'Beginner Supporter',0,'LineageNPC2.br_tp_actor','9.00','28.30',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,4,180,1,1,0,0),
(17,17,'Warm Hearted Sno',0,'Beginner Supporter',0,'LineageNPC2.br_tp_actor','9.00','28.30',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,4,180,1,1,0,0),
(18,18,'Warm Hearted Sno',0,'Beginner Supporter',0,'LineageNPC2.br_tp_actor','9.00','28.30',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,4,180,1,1,0,0),
(19,19,'Wooldy',0,'Halloween Children',0,'LineageMonster5.br_wooldie','22.00','30.00',80,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'14.00000','68.00000','10.00000','46.00000',253,1,0,333,0,0,0,25,120,1,1,0,0),
(20,20,'Verdandi',0,'Halloween Children',0,'LineageMonster5.br_berdandi','10.00','12.00',80,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'14.00000','68.00000','10.00000','46.00000',253,1,0,333,0,0,0,45,180,1,1,0,0),
(21,21,'Skooldy',0,'Jack Game Trainer',0,'LineageMonster5.br_scooldie','23.00','23.00',80,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'14.00000','68.00000','10.00000','46.00000',253,1,0,333,0,0,0,45,180,1,1,0,0),
(22,22,'Lucky Sky Lantern',0,'',0,'LineageNPC2.br_lamp','4.20','5.00',70,'male','L2Npc',40,'3862.00000','1494.00000','7.50000','2.70000',40,43,30,21,20,10,490,10,'1086.00000','471.00000','748.00000','313.00000',253,4,0,333,0,0,0,30,120,1,1,0,0),
(23,23,'Ambience Sky Lantern',0,'',0,'LineageNPC2.br_lamp','4.20','5.00',70,'male','L2Npc',40,'3862.00000','1494.00000','7.50000','2.70000',40,43,30,21,20,10,490,10,'1086.00000','471.00000','748.00000','313.00000',253,4,0,333,0,0,0,30,120,1,1,0,0),
(24,24,'Sway Sky Lantern',0,'',0,'LineageNPC2.br_lamp','4.20','5.00',70,'male','L2Npc',40,'3862.00000','1494.00000','7.50000','2.70000',40,43,30,21,20,10,490,10,'1086.00000','471.00000','748.00000','313.00000',253,4,0,333,0,0,0,30,120,1,1,0,0),
(25,25,'Comfort Sky Lantern',0,'',0,'LineageNPC2.br_lamp','4.20','5.00',70,'male','L2Npc',40,'3862.00000','1494.00000','7.50000','2.70000',40,43,30,21,20,10,490,10,'1086.00000','471.00000','748.00000','313.00000',253,4,0,333,0,0,0,30,120,1,1,0,0),
(26,26,'Halloween Event Manager',0,'',0,'LineageNPC.clear_npc','0.10','0.10',80,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1498.00000','577.00000','1033.00000','384.00000',253,4,0,333,0,0,0,1,1,0,1,0,0),
(27,27,'Kadomas',0,'',0,'LineageNPC2.br_kadomatsu','24.50','14.00',80,'male','L2Npc',40,'3862.00000','1494.00000','0.00000','0.90000',40,43,30,21,20,25,0,0,'14.00000','101447.00000','10.00000','307184.00000',253,1,0,333,0,0,0,60,180,1,1,0,0),
(28,28,'Kotatz',0,'',0,'LineageNPC2.br_kotatsu','25.50','10.00',80,'male','L2Npc',40,'3862.00000','1494.00000','7.50000','2.70000',40,43,30,21,20,10,0,0,'1154.00000','500.00000','795.00000','333.00000',253,4,0,333,0,0,0,30,120,0,0,0,0),
(29,29,'Flame Box',0,'Flame Box',0,'LineageNPC2.br_fire_box','11.00','12.50',70,'male','L2Npc',40,'3862.00000','1494.00000','7.50000','2.70000',40,43,30,21,20,10,490,10,'1086.00000','471.00000','748.00000','313.00000',253,4,0,333,0,0,0,30,120,1,1,0,0),
(30,30,'Santa',0,'Merry Christmas',0,'LineageNPC2.br_xmas08_santa','9.00','16.00',70,'male','L2Npc',40,'3862.00000','1494.00000','7.50000','2.70000',40,43,30,21,20,20,490,10,'1086.00000','471.00000','748.00000','313.00000',253,4,0,333,0,0,0,50,120,1,1,0,0),
(31,31,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',80,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1498.00000','577.00000','1033.00000','384.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(32,32,'Jet Bike',0,'',0,'LineageNPC2.br_z_bike','21.50','27.00',80,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1498.00000','577.00000','1033.00000','384.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(33,33,'Trejuo',0,'Blessed Child',0,'LineageNPC2.br_blessed_taiboy','10.00','13.00',80,'female','L2Npc',40,'1673.00000','810.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1498.00000','577.00000','1033.00000','384.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(34,34,'Sujin',0,'Blessed Child',0,'LineageNPC2.br_blessed_taiboy','10.00','13.00',80,'female','L2Npc',40,'1673.00000','810.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1498.00000','577.00000','1033.00000','384.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(1501,1501,'Majo Agathion',0,'',0,'LineageNPC2.br_agathion_mazu','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1502,1502,'Gold Agathion',0,'',0,'LineageNPC2.br_agathion_mazu','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1503,1503,'Black Agathion',0,'',0,'LineageNPC2.br_agathion_mazu','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1504,1504,'Plaipitak Agathion',0,'',0,'LineageNPC2.br_agathion_elephant','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1505,1505,'Baby Panda Agathion',0,'',0,'LineageNPC2.br_agathion_bpanda','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1506,1506,'Bamboo Panda Agathion',0,'',0,'LineageNPC2.br_agathion_mpanda','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1507,1507,'Sexy Panda Agathion',0,'',0,'LineageNPC2.br_agathion_wpanda','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1508,1508,'White Cupid Agathion',0,'',0,'LineageNPC2.br_agathion_wcupid','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1509,1509,'Dark Cupid Agathion',0,'',0,'LineageNPC2.br_agathion_dcupid','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1510,1510,'White Maneki Neko Agathion',0,'',0,'LineageNPC2.br_agathion_maneki','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1511,1511,'Black Maneki Neko Agathion',0,'',0,'LineageNPC2.br_agathion_maneki','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1512,1512,'Brown Maneki Neko Agathion',0,'',0,'LineageNPC2.br_agathion_maneki','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1513,1513,'One-Eyed Bat Drove Agathion',0,'',0,'LineageNPC2.br_agathion_bat','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1514,1514,'Pegasus Agathion',0,'',0,'LineageNPC2.br_agathion_pegasus','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1515,1515,'Yellow-Robed Tojigong Agathion',0,'',0,'LineageNPC2.br_agathion_tozi','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1516,1516,'Blue-Robed Tojigong Agathion',0,'',0,'LineageNPC2.br_agathion_tozi','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1517,1517,'Green-Robed Tojigong Agathion',0,'',0,'LineageNPC2.br_agathion_tozi','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1518,1518,'Bugbear Agathion',0,'',0,'LineageNPC2.br_agathion_bugbear','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1519,1519,'Red Sumo Wrestler Agathion',0,'',0,'LineageNPC2.br_agathion_redsumo','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1520,1520,'Blue Sumo Wrestler Agathion',0,'',0,'LineageNPC2.br_agathion_bluesumo','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1521,1521,'Great Sumo Match Agathion',0,'',0,'LineageNPC2.br_agathion_match','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1522,1522,'Button-Eyed Bear Doll',0,'',0,'LineageNPC2.br_agathion_bear','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1523,1523,'God of Fortune',0,'',0,'LineageNPC2.br_agathion_wealthgod','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1524,1524,'Dryad Agathion',0,'',0,'LineageNPC2.br_agathion_dryad','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1525,1525,'Wonboso Agathion',0,'',0,'LineageNPC2.br_agathion_cashcow','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1526,1526,'Daewoonso Agathion',0,'',0,'LineageNPC2.br_agathion_luckycow','0.01','5.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(1527,1527,'Pomona Agathion',0,'',0,'LineageNPC2.br_agathion_pomona','0.01','5.50',55,'female','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1528,1528,'Weaver Agathion',0,'',0,'LineageNPC2.br_agathion_womanweaver','0.01','5.50',55,'female','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1529,1529,'Chon-chon Agathion',0,'',0,'LineageNPC2.br_agathion_luckygirl','0.01','5.50',55,'female','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1530,1530,'Tang-tang Agathion',0,'',0,'LineageNPC2.br_agathion_luckyboy','0.01','5.50',55,'female','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1531,1531,'Dancing Lucky Kid Agathion',0,'',0,'LineageNPC2.br_agathion_dancingchild','0.01','5.50',55,'female','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1532,1532,'Monkey King Agathion',0,'',0,'LineageNPC2.br_agathion_sunwukong','0.01','5.50',55,'female','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1533,1533,'Utanka Agathion',0,'',0,'LineageNPC2.br_agathion_uthanka','0.01','5.50',55,'female','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1534,1534,'Bonus B Agathion',0,'',0,'LineageNPC2.br_agathion_bonus','0.01','5.50',55,'female','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1535,1535,'Zombie Agathion',0,'',0,'LineageNPC2.br_agathion_gangsi','7.00','6.00',55,'female','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1536,1536,'Baekyi Hwamae Agathion',0,'',0,'LineageNPC2.br_agathion_bluebird','6.01','5.00',55,'female','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1537,1537,'Gwanwoo Hwamae Agathion',0,'',0,'LineageNPC2.br_agathion_hatbird','6.01','5.00',55,'female','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1538,1538,'Baby Rudolph',0,'',0,'LineageNPC2.br_pet_rudolf','21.50','27.00',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',35,37,30,32,20,25,0,0,'388.11142','60000.00000','265.02979','20000.00000',253,4,0,333,0,0,0,35,170,1,1,0,0),
(1539,1539,'Iken Agathion',0,'',0,'LineageNPC2.br_local_JP_Mfighter','0.01','5.50',55,'female','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1540,1540,'Lana Agathion',0,'',0,'LineageNPC2.br_local_JP_FFighter','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1541,1541,'Gnocian Agathion',0,'',0,'LineageNPC2.br_local_JP_MElf','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1542,1542,'Orodriel Agathion',0,'',0,'LineageNPC2.br_local_JP_Felf','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1543,1543,'Lakinos Agathion',0,'',0,'LineageNPC2.br_local_JP_MDarkelf','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1544,1544,'Mortia Agathion',0,'',0,'LineageNPC2.br_local_JP_Fdarkelf','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1545,1545,'Hayance Agathion',0,'',0,'LineageNPC2.br_local_JP_MDwarf','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1546,1546,'Meruril Agathion',0,'',0,'LineageNPC2.br_local_JP_FDwarf','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1547,1547,'Taman ze Lapatui Agathion',0,'',0,'LineageNPC2.br_local_JP_MOrc','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1548,1548,'Kaurin Agathion',0,'',0,'LineageNPC2.br_local_JP_FOrc','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1549,1549,'Ahertbein Agathion',0,'',0,'LineageNPC2.br_local_JP_MKamael','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1550,1550,'Naonin Agathion',0,'',0,'LineageNPC2.br_local_JP_FKamael','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1551,1551,'Guangong Agathion',0,'',0,'LineageNPC2.br_aga_warriorgod','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1552,1552,'Gwanseum Nyang Nyang Agathion',0,'',0,'LineageNPC2.br_aga_mercygod','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1553,1553,'Blue Opera Agathion',0,'',0,'LineageNPC2.br_aga_blue_pekingopera','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1554,1554,'Red Opera Agathion',0,'',0,'LineageNPC2.br_aga_red_pekingopera','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1555,1555,'Opera Agathion',0,'',0,'LineageNPC2.br_aga_redblue_pekingopera','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1556,1556,'Mandarin Dress Agathion',0,'',0,'LineageNPC2.br_aga_chinesedress','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1557,1557,'Nepal Snow Agathion',0,'',0,'LineageNPC2.br_aga_suno_trumpet','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1558,1558,'Round Ball Snow Agathion',0,'',0,'LineageNPC2.br_aga_suno_ball','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1559,1559,'Ladder Snow Agathion',0,'',0,'LineageNPC2.br_aga_suno_tall','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1560,1560,'Blue Opera Agathion',0,'',0,'LineageNPC2.br_aga_blue_pekingopera','0.01','5.50',55,'male','L2Npc',40,'2643.00000','988.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1561,1561,'Baby Rudolph',0,'',0,'LineageNPC2.br_pet_rudolf','21.50','27.00',55,'male','L2Pet',40,'3862.00000','1494.00000','6.50000','2.40000',35,37,30,32,20,25,0,0,'1303.00000','471.00000','607.00000','382.00000',253,4,0,333,0,0,0,35,170,1,1,0,0),
(1562,1562,'Deseloph',0,'',0,'LineageNPC2.br_pet_rose_lover_m_a','20.20','16.00',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',35,37,30,32,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,30,180,1,1,0,0),
(1563,1563,'Hyum',0,'',0,'LineageNPC2.br_pet_rose_lover_m_a','20.20','16.00',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1564,1564,'Rekang',0,'',0,'LineageNPC2.br_pet_rose_lover_m_a','20.20','16.00',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',38,40,30,26,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,0),
(1565,1565,'Lilias',0,'',0,'LineageNPC2.br_pet_rose_lover_f_a','23.50','17.00',55,'female','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',38,40,30,26,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,0),
(1566,1566,'Lapham',0,'',0,'LineageNPC2.br_pet_rose_lover_f_a','23.50','17.00',55,'female','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',38,40,30,26,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,0),
(1567,1567,'Mafum',0,'',0,'LineageNPC2.br_pet_rose_lover_f_a','23.50','17.00',55,'female','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',38,40,30,26,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,0),
(1568,1568,'Deseloph',0,'',0,'LineageNPC2.br_pet_rose_lover_m_b','24.30','16.00',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',38,40,30,26,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,0),
(1569,1569,'Hyum',0,'',0,'LineageNPC2.br_pet_rose_lover_m_b','24.30','16.00',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',38,40,30,26,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,0),
(1570,1570,'Rekang',0,'',0,'LineageNPC2.br_pet_rose_lover_m_b','24.30','16.00',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',38,40,30,26,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,0),
(1571,1571,'Lilias',0,'',0,'LineageNPC2.br_pet_rose_lover_f_b','22.70','17.00',55,'female','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',38,40,30,26,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,0),
(1572,1572,'Lapham',0,'',0,'LineageNPC2.br_pet_rose_lover_f_b','22.70','17.00',55,'female','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',38,40,30,26,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,0),
(1573,1573,'Mafum',0,'',0,'LineageNPC2.br_pet_rose_lover_f_b','22.70','17.00',55,'female','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',38,40,30,26,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,0),
(1574,1574,'Phoenix',0,'',0,'LineageNPC2.br_aga_china_phoenix','0.01','5.50',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1575,1575,'Three-headed Dragon',0,'',0,'LineageNPC2.br_aga_threehead','0.01','5.50',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1576,1576,'Ball Trapping Gnosian',0,'',0,'LineageNPC2.br_aga_ball_male','0.01','5.50',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1577,1577,'Ball Trapping Orodriel',0,'',0,'LineageNPC2.br_aga_ball_female','0.01','5.50',55,'female','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1578,1578,'Penalty Kick',0,'',0,'LineageNPC2.br_aga_ball_kick','0.01','5.50',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1579,1579,'Ball Trapping Gnosian (blue)',0,'',0,'LineageNPC2.br_aga_ball_male','0.01','5.50',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1580,1580,'Ball Trapping Orodriel (blue)',0,'',0,'LineageNPC2.br_aga_ball_female','0.01','5.50',55,'female','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1581,1581,'Penalty Kick (blue)',0,'',0,'LineageNPC2.br_aga_ball_kick','0.01','5.50',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1582,1582,'Ball Trapping Gnosian (red)',0,'',0,'LineageNPC2.br_aga_ball_male','0.01','5.50',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1583,1583,'Ball Trapping Orodriel (red)',0,'',0,'LineageNPC2.br_aga_ball_female','0.01','5.50',55,'female','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1584,1584,'Penalty Kick (red)',0,'',0,'LineageNPC2.br_aga_ball_kick','0.01','5.50',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1585,1585,'Granny Tiger',0,'',0,'LineageNPC2.br_aga_tiger_grandma','0.01','5.50',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1586,1586,'Flower Fairy Spirit',0,'',0,'LineageNPC2.br_aga_flower','0.01','5.50',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1587,1587,'Cheerleader Orodriel',0,'',0,'LineageNPC2.br_aga_cheer','0.01','5.50',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1588,1588,'Cheerleader Lana',0,'',0,'LineageNPC2.br_aga_cheer','0.01','5.50',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1589,1589,'Cheerleader Naonin',0,'',0,'LineageNPC2.br_aga_cheer','0.01','5.50',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1590,1590,'Cheerleader Mortia',0,'',0,'LineageNPC2.br_aga_cheer','0.01','5.50',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1591,1591,'Cheerleader Kaurin',0,'',0,'LineageNPC2.br_aga_cheer','0.01','5.50',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1592,1592,'Cheerleader Meruril',0,'',0,'LineageNPC2.br_aga_cheer','0.01','5.50',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(1593,1593,'Handy',0,'',0,'LineageNPC2.br_aga_ball_kick','0.01','5.50',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(4301,4301,'Queen of Hearts',0,'Valentine Messenger',0,'LineageMonster2.queen_of_cat','8.00','15.00',70,'female','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,10,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,26,120,1,1,0,1),
(4302,4302,'Master Dugi',0,'Soul Healer',0,'LineageNPC2.event_comic_masteryogy','9.00','16.70',1,'female','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,50,160,1,1,0,0),
(4303,4303,'Skooldy',0,'Halloween Children',0,'LineageMonster5.br_scooldie','23.00','23.00',85,'male','L2Npc',40,'3862.00000','1494.00000','7.50000','2.70000',40,43,30,21,20,20,723,10,'1187.00000','515.00000','819.00000','342.00000',253,4,0,333,0,0,0,50,120,1,1,0,0),
(4304,4304,'Santa',0,'Merry Christmas',0,'LineageNPC2.br_xmas08_santa','9.00','16.00',70,'male','L2Npc',40,'3862.00000','1494.00000','7.50000','2.70000',40,43,30,21,20,20,490,10,'1086.00000','471.00000','748.00000','313.00000',253,4,0,333,0,0,0,50,120,1,1,0,0),
(4305,4305,'Rosalia',0,'Hopeless Romantic',0,'LineageNPC2.message_event_master','10.00','20.00',70,'female','L2Npc',40,'3862.00000','1494.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','748.00000','313.00000',253,4,0,333,0,0,0,50,160,1,1,0,0),
(4306,4306,'Steve Shyagel',0,'Eva\'s High Priest',0,'LineageNPC2.br_archbishop_of_eva','8.00','26.50',85,'male','L2Npc',40,'3862.00000','1494.00000','7.50000','2.70000',40,43,30,21,20,20,723,10,'1187.00000','515.00000','819.00000','342.00000',253,4,0,333,0,0,0,50,120,1,1,0,0),
(12077,12077,'Wolf',0,'',0,'LineageMonster.pet_wolf','13.00','11.50',15,'male','L2Pet',40,'246.95422','149.20000','2.50000','1.20000',40,43,30,21,20,25,0,0,'29.61691','73.55216','20.22451','53.82228',253,4,0,333,0,0,0,24,125,1,1,0,0),
(12311,12311,'Hatchling of the Wind',0,'',0,'LineageMonster.hatchling','9.00','10.00',35,'male','L2Pet',40,'772.73802','402.60000','4.50000','1.80000',40,43,30,21,20,25,0,0,'129.32896','136.72948','88.31491','100.05270',253,4,0,333,0,0,0,80,140,1,1,0,0),
(12312,12312,'Hatchling of the Stars',0,'',0,'LineageMonster.hatchling','9.00','10.00',35,'male','L2Pet',40,'772.73802','402.60000','4.50000','1.80000',40,43,30,21,20,25,0,0,'129.32896','136.72948','88.31491','100.05270',253,4,0,333,0,0,0,80,140,1,1,0,0),
(12313,12313,'Hatchling of Twilight',0,'',0,'LineageMonster.hatchling','9.00','10.00',35,'male','L2Pet',40,'772.73802','402.60000','4.50000','1.80000',40,43,30,21,20,25,0,0,'129.32896','136.72948','88.31491','100.05270',253,4,0,333,0,0,0,80,140,1,1,0,0),
(12526,12526,'Wind Strider',0,'',0,'LineageMonster.strider','23.00','31.00',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,80,170,1,1,0,0),
(12527,12527,'Star Strider',0,'',0,'LineageMonster.strider','23.00','31.00',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,80,170,1,1,0,0),
(12528,12528,'Twilight Strider',0,'',0,'LineageMonster.strider','23.00','31.00',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,80,170,1,1,0,0),
(12564,12564,'Sin Eater',0,'',0,'LineageMonster.imp','10.00','24.00',15,'male','L2Pet',40,'424.20000','149.20000','7.25130','1.20000',40,1,30,21,20,25,0,0,'29.61691','73.55216','20.22451','53.82228',253,4,0,333,0,0,0,60,125,1,1,0,0),
(12621,12621,'Wyvern',0,'',0,'LineageMonster.wyvern','60.00','80.00',70,'male','L2Pet',40,'2444.46819','1345.80000','7.50000','2.70000',40,43,30,21,20,25,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,80,170,1,1,0,0),
(12774,12774,'Young Squash',0,'',0,'LineageNPC.drop_gourd_50_sm','10.00','10.50',1,'etc','L2Npc',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,10,0,0,'8.00000','40.00000','7.00000','26.00000',230,1,0,333,0,0,0,50,100,1,1,0,1),
(12775,12775,'High Quality Squash',0,'',0,'LineageNPC.drop_gourd','23.00','25.00',1,'etc','L2Npc',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,10,0,0,'8.00000','40.00000','7.00000','26.00000',230,1,0,333,0,0,0,50,100,1,1,0,1),
(12776,12776,'Low Quality Squash',0,'',0,'LineageNPC.drop_gourd_25_sm','15.00','16.00',1,'etc','L2Npc',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,10,0,0,'8.00000','40.00000','7.00000','26.00000',230,1,0,333,0,0,0,50,100,1,1,0,1),
(12777,12777,'Large Young Squash',0,'',0,'LineageNPC.drop_gourd','23.00','25.00',1,'etc','L2Npc',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,10,0,0,'8.00000','40.00000','7.00000','26.00000',230,1,0,333,0,0,0,50,100,1,1,0,1),
(12778,12778,'High Quality Large Squash',0,'',0,'LineageNPC.drop_gourd_50_bi','34.00','40.00',1,'etc','L2Npc',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,10,0,0,'8.00000','40.00000','7.00000','26.00000',230,1,0,333,0,0,0,50,100,1,1,0,1),
(12779,12779,'Low Quality Large Squash',0,'',0,'LineageNPC.drop_gourd_25_bi','28.00','31.00',1,'etc','L2Npc',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,10,0,0,'8.00000','40.00000','7.00000','26.00000',230,1,0,333,0,0,0,50,100,1,1,0,1),
(12780,12780,'Baby Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12.00','15.00',25,'male','L2BabyPet',40,'460.96247','259.20000','3.50000','1.50000',40,43,30,21,20,25,0,0,'64.83203','101.83533','44.27187','74.51868',253,4,0,333,0,0,0,30,120,1,1,0,1),
(12781,12781,'Baby Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7.00','15.00',25,'male','L2BabyPet',40,'460.96247','259.20000','3.50000','1.50000',40,43,30,21,20,25,0,0,'64.83203','101.83533','44.27187','74.51868',253,4,0,333,0,0,0,13,120,1,1,0,1),
(12782,12782,'Baby Cougar',0,'',0,'LineageMonster2.baby_tiger','11.00','15.70',25,'male','L2BabyPet',40,'460.96247','259.20000','3.50000','1.50000',40,43,30,21,20,25,0,0,'64.83203','101.83533','44.27187','74.51868',253,4,0,333,0,0,0,28,120,1,1,0,1),
(13001,13001,'Heart of Warding',0,'',0,'LineageNPC.heart_of_warding','17.00','75.00',70,'etc','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,10,490,10,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,120,1,1,0,1),
(13002,13002,'Life Control Tower',0,'',0,'LineageNPC.broadcasting_tower','13.00','54.00',20,'etc','L2ControlTower',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,10,40,10,'48.00000','95.00000','30.00000','63.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13003,13003,'Life Control Tower',0,'',0,'LineageNPC.dead_castle_aden_controltower_jewel','7.00','35.00',20,'etc','L2ControlTower',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,10,40,10,'48.00000','95.00000','30.00000','63.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13004,13004,'Flame Control Tower',0,'',0,'LineageNPC.broadcasting_tower','13.00','54.00',20,'etc','L2FlameTower',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,10,40,10,'48.00000','95.00000','30.00000','63.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13005,13005,'Flame Control Tower',0,'',0,'LineageNPC.dead_castle_aden_controltower_jewel','7.00','35.00',20,'etc','L2FlameTower',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,10,40,10,'48.00000','95.00000','30.00000','63.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13006,13006,'Christmas Tree',0,'',0,'LineageDeco.x_mas_tree','0.01','0.01',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,10,490,10,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,30,120,1,1,0,1),
(13007,13007,'Special Christmas Tree',0,'',0,'LineageDeco.x_mas_tree_50_bi','0.00','0.00',70,'male','L2XmassTree',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,10,490,10,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,30,120,1,1,0,1),
(13014,13014,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',85,'male','L2Npc',40,'3047.00000','1680.00000','8.50000','3.00000',40,43,30,21,20,10,0,0,'1696.00000','630.00000','1165.00000','419.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(13015,13015,'',0,'',0,'LineageMonster3.Evilate_weather','16.00','18.50',85,'female','L2Npc',40,'3047.00000','1680.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1696.00000','630.00000','1165.00000','419.00000',230,4,0,333,0,0,0,10,1,1,1,0,1),
(13016,13016,'King Squash',0,'',0,'LineageNPC.drop_gourd','23.00','25.00',1,'etc','L2Npc',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,10,0,0,'8.00000','40.00000','7.00000','26.00000',230,1,0,333,0,0,0,50,100,1,1,0,1),
(13017,13017,'Emperor Squash',0,'',0,'LineageNPC.drop_gourd_50_bi','34.00','40.00',1,'etc','L2Npc',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,10,0,0,'8.00000','40.00000','7.00000','26.00000',230,1,0,333,0,0,0,50,100,1,1,0,1),
(13018,13018,'',0,'',0,'LineageNPC2.skill_dummy_00_a','5.00','10.00',70,'etc','L2EffectPoint',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,20,1,1,0,1),
(13019,13019,'',0,'',0,'LineageNPC2.skill_dummy_00_a','5.00','10.00',70,'etc','L2EffectPoint',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,20,1,1,0,1),
(13020,13020,'',0,'',0,'LineageNPC2.skill_dummy_00_a','5.00','10.00',70,'etc','L2EffectPoint',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,20,1,1,0,1),
(13021,13021,'',0,'',0,'LineageNPC2.skill_dummy_00_a','5.00','10.00',70,'etc','L2EffectPoint',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,20,1,1,0,1),
(13022,13022,'',0,'',0,'LineageNPC2.skill_dummy_00_a','5.00','10.00',70,'etc','L2EffectPoint',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,20,1,1,0,1),
(13023,13023,'',0,'',0,'LineageNPC2.skill_dummy_00_a','5.00','10.00',70,'etc','L2EffectPoint',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,20,1,1,0,1),
(13024,13024,'',0,'',0,'LineageNPC2.skill_dummy_00_a','5.00','10.00',70,'etc','L2EffectPoint',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,20,1,1,0,1),
(13025,13025,'',0,'',0,'LineageNPC2.skill_dummy_01_a','5.00','10.00',70,'etc','L2EffectPoint',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,20,1,1,0,1),
(13026,13026,'',0,'',0,'LineageNPC2.skill_dummy_01_a','5.00','10.00',70,'etc','L2EffectPoint',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,20,1,1,0,1),
(13027,13027,'',0,'',0,'LineageNPC2.skill_dummy_01_a','5.00','10.00',70,'etc','L2EffectPoint',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,20,1,1,0,1),
(13028,13028,'',0,'',0,'LineageNPC2.skill_dummy_01_a','5.00','10.00',70,'etc','L2EffectPoint',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,20,1,1,0,1),
(13029,13029,'',0,'',0,'LineageNPC2.skill_dummy_01_a','5.00','10.00',70,'etc','L2EffectPoint',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,20,1,1,0,1),
(13030,13030,'',0,'',0,'LineageNPC2.skill_dummy_01_a','5.00','10.00',70,'etc','L2EffectPoint',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,20,1,1,0,1),
(13031,13031,'Huge Pig',0,'',0,'LineageNPC2.E_pig_ball','15.00','18.30',80,'male','L2Npc',40,'680.00000','1820.00000','0.00000','0.90000',40,43,30,21,20,20,0,0,'14.00000','101400.00000','6.00000','307525.00000',230,1,0,333,0,0,0,60,160,1,1,0,1),
(13032,13032,'Huge Pig',0,'',0,'LineageNPC2.E_pig_ball','15.00','18.30',80,'male','L2Npc',40,'680.00000','1820.00000','0.00000','0.90000',40,43,30,21,20,20,0,0,'14.00000','101400.00000','6.00000','307525.00000',230,1,0,333,0,0,0,60,160,1,1,0,1),
(13033,13033,'Huge Pig',0,'',0,'LineageNPC2.E_pig_ball','15.00','18.30',80,'male','L2Npc',40,'680.00000','1820.00000','0.00000','0.90000',40,43,30,21,20,20,0,0,'14.00000','101400.00000','6.00000','307525.00000',230,1,0,333,0,0,0,60,160,1,1,0,1),
(13034,13034,'Super Huge Pig',0,'',0,'LineageNPC2.E_pig_ball_H','29.00','38.70',80,'male','L2Monster',40,'3400.00000','5459.00000','0.00000','0.90000',40,43,30,21,20,20,0,0,'14.00000','101400.00000','6.00000','307525.00000',230,1,0,333,0,0,0,60,160,1,1,0,1),
(13035,13035,'Golden Pig',0,'',0,'LineageNPC2.E_pig_ball','15.00','18.30',80,'male','L2Npc',40,'680.00000','1820.00000','0.00000','0.90000',40,43,30,21,20,20,0,0,'14.00000','101400.00000','6.00000','307525.00000',230,1,0,333,0,0,0,60,160,1,1,0,1),
(13036,13036,'Alchemist\'s Chest',0,'',0,'LineageMonster.mimic_even','8.50','8.50',80,'male','L2Npc',40,'2880.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1499.00000','577.00000','1035.00000','384.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(13037,13037,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',28,'etc','L2Npc',40,'544.00000','274.00000','3.50000','1.50000',40,43,30,21,20,20,0,0,'93.00000','131.00000','67.00000','87.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13038,13038,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',36,'etc','L2Npc',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,0,0,'171.00000','176.00000','115.00000','117.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13039,13039,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',43,'etc','L2Npc',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,0,0,'275.00000','223.00000','191.00000','148.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13040,13040,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',49,'etc','L2Npc',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,0,0,'398.00000','270.00000','275.00000','180.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13041,13041,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',55,'etc','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13042,13042,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',60,'etc','L2Npc',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'711.00000','369.00000','491.00000','246.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13043,13043,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',64,'etc','L2Npc',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'853.00000','409.00000','584.00000','272.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13044,13044,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',68,'etc','L2Npc',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1006.00000','450.00000','695.00000','299.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13045,13045,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',72,'etc','L2Npc',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1168.00000','492.00000','801.00000','327.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13046,13046,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',49,'etc','L2Npc',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,0,0,'398.00000','270.00000','275.00000','180.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13047,13047,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',55,'etc','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13048,13048,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',60,'etc','L2Npc',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'711.00000','369.00000','491.00000','246.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13049,13049,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',64,'etc','L2Npc',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'853.00000','409.00000','584.00000','272.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13050,13050,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',68,'etc','L2Npc',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1006.00000','450.00000','695.00000','299.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13051,13051,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',72,'etc','L2Npc',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1168.00000','492.00000','801.00000','327.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13052,13052,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',55,'etc','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13053,13053,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',60,'etc','L2Npc',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'711.00000','369.00000','491.00000','246.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13054,13054,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',64,'etc','L2Npc',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'853.00000','409.00000','584.00000','272.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13055,13055,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',68,'etc','L2Npc',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1006.00000','450.00000','695.00000','299.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13056,13056,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',72,'etc','L2Npc',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1168.00000','492.00000','801.00000','327.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13057,13057,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',40,'etc','L2Npc',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,0,0,'226.00000','202.00000','157.00000','134.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13058,13058,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',46,'etc','L2Npc',40,'1230.00000','580.00000','5.50000','2.10000',40,43,30,21,20,20,0,0,'332.00000','246.00000','231.00000','164.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13059,13059,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',52,'etc','L2Npc',40,'1520.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'472.00000','295.00000','321.00000','197.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13060,13060,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',58,'etc','L2Npc',40,'1828.00000','889.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'646.00000','350.00000','447.00000','233.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13061,13061,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',62,'etc','L2Npc',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'780.00000','389.00000','535.00000','259.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13062,13062,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',66,'etc','L2Npc',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'928.00000','429.00000','641.00000','285.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13063,13063,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',70,'etc','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13064,13064,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',74,'etc','L2Npc',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1251.00000','513.00000','863.00000','342.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13065,13065,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',52,'etc','L2Npc',40,'1520.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'472.00000','295.00000','321.00000','197.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13066,13066,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',58,'etc','L2Npc',40,'1828.00000','889.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'646.00000','350.00000','447.00000','233.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13067,13067,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',62,'etc','L2Npc',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'780.00000','389.00000','535.00000','259.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13068,13068,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',66,'etc','L2Npc',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'928.00000','429.00000','641.00000','285.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13069,13069,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',70,'etc','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13070,13070,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',74,'etc','L2Npc',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1251.00000','513.00000','863.00000','342.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13071,13071,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.50','25.00',43,'etc','L2Decoy',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,0,0,'275.00000','223.00000','191.00000','148.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13072,13072,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.50','25.00',52,'etc','L2Decoy',40,'1520.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'472.00000','295.00000','321.00000','197.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13073,13073,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.50','25.00',60,'etc','L2Decoy',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'711.00000','369.00000','491.00000','246.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13074,13074,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.50','25.00',66,'etc','L2Decoy',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'928.00000','429.00000','641.00000','285.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13075,13075,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.50','25.00',70,'etc','L2Decoy',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13076,13076,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.50','25.00',74,'etc','L2Decoy',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1251.00000','513.00000','863.00000','342.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13077,13077,'Onyx Beast',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,30,180,1,1,0,1),
(13078,13078,'Doom Wraith',0,'',0,'LineageMonster.death_blader_tr','13.00','25.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,100,180,1,1,0,1),
(13079,13079,'Grail Apostle',0,'',0,'LineageMonster3.apostle_grail_tr','10.00','35.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(13080,13080,'Grail Apostle',0,'',0,'LineageMonster2.apostle_warrior','8.00','30.00',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(13081,13081,'Unicorn',0,'',0,'LineageMonster.Unicorn_tr','15.00','28.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,46,180,1,1,0,1),
(13082,13082,'Lilim Knight',0,'',0,'LineageMonster4.lilim_knight_tr','12.00','25.50',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,56,180,1,1,0,1),
(13083,13083,'Golem Guardian',0,'',0,'LineageMonster3.golem_guardian_tr','13.00','25.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,53,180,1,1,0,1),
(13084,13084,'Inferno Drake',0,'',0,'LineageMonster2.inferno_drake_tr','15.00','24.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,57,180,1,1,0,1),
(13085,13085,'Dragon Bomber',0,'',0,'LineageMonster3.antaras_ex_b_tr','16.00','24.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,100,180,1,1,0,1),
(13086,13086,'Zariche',0,'',0,'LineageMonster4.Avatar_Z','12.00','31.57',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,8190,0,0,80,180,1,1,0,1),
(13087,13087,'Akamanah',0,'',0,'LineageMonster4.Avatar_A','10.00','32.73',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,8689,0,0,80,180,1,1,0,1),
(13088,13088,'Final Form',0,'',0,'LineageMonster4.Specular_Form','9.00','38.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(13089,13089,'Final Form',0,'',0,'LineageMonster4.Specular_Form_F','10.00','32.76',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(13090,13090,'Native',0,'',0,'LineageNPC.a_common_peopleC_Mhuman','8.00','23.50',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,180,1,1,0,1),
(13091,13091,'Yeti',0,'',0,'LineageMonster.yeti','15.00','27.50',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,80,180,1,1,0,1),
(13092,13092,'Buffalo',0,'',0,'LineageMonster2.buffalo','22.00','31.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,80,180,1,1,0,1),
(13093,13093,'Pig',0,'',0,'LineageNPC2.E_pig_ball','15.00','18.30',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(13094,13094,'Zombie',0,'',0,'LineageMonster3.zombie_laborer','11.00','24.60',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,36,180,1,1,0,1),
(13095,13095,'Pixy',0,'',0,'LineageMonster.pixy','5.00','25.00',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,80,180,1,1,0,1),
(13096,13096,'Rabbit',0,'',0,'LineageMonster.rabbit','5.00','4.50',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,180,1,1,0,1),
(13097,13097,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',80,'male','L2Monster',40,'2880.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1499.00000','577.00000','1035.00000','384.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(13098,13098,'Event Treasure Chest',0,'',0,'LineageMonster.mimic_even','8.50','8.50',80,'male','L2EventChest',40,'2880.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1499.00000','577.00000','1035.00000','384.00000',230,4,0,253,0,0,0,80,1,1,1,0,1),
(13099,13099,'Zaken',0,'',0,'LineageMonster.zaken_tr','16.00','32.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,42,180,1,1,0,1),
(13100,13100,'Anakim',0,'',0,'LineageMonster2.anakim_tr','15.50','29.00',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,45,180,1,1,0,1),
(13101,13101,'Benom',0,'',0,'LineageMonster3.benom_tr','20.00','56.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,79,180,1,1,0,1),
(13102,13102,'Gordon',0,'',0,'LineageMonster3.Cruel_Rider_tr','43.00','46.60',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(13103,13103,'Ranku',0,'',0,'LineageMonster4.LaneCoo_tr','13.00','29.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,26,180,1,1,0,1),
(13104,13104,'Kiyachi',0,'',0,'LineageMonster4.Keyache_tr','12.00','29.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,26,180,1,1,0,1),
(13105,13105,'Demon Prince',0,'',0,'LineageMonster4.rahuu_tr','33.00','49.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(13106,13106,'Heretic Male',0,'',0,'LineageMonster3.heretic_privates_tr','7.70','28.40',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(13107,13107,'Heretic Female',0,'',0,'LineageMonster3.heretic_priest_tr','8.00','19.60',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,30,180,1,1,0,1),
(13108,13108,'Vale master',0,'',0,'LineageMonster.vale_master_tr','12.00','40.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,70,180,1,1,0,1),
(13109,13109,'Saber Tooth Tiger',0,'',0,'LineageMonster.saber_toothed_tiger_tr','34.00','28.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,8190,0,0,60,180,1,1,0,1),
(13110,13110,'Ol Mahum',0,'',0,'LineageMonster.oel_mahum_champion_tr','23.00','61.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,8689,0,0,67,180,1,1,0,1),
(13111,13111,'Doll Blader',0,'',0,'LineageMonster.doll_blader_tr','6.00','12.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,22,180,1,1,0,1),
(13112,13112,'Divine Knight',0,'',0,'LineageMonster4.Divine_tanker','16.00','30.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,49,180,1,1,0,1),
(13113,13113,'Divine Warrior',0,'',0,'LineageMonster4.Divine_Warrior','14.50','29.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,46,180,1,1,0,1),
(13114,13114,'Divine Rogue',0,'',0,'LineageMonster4.Divine_Rogue','10.00','28.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,180,1,1,0,1),
(13115,13115,'Divine Healer',0,'',0,'LineageMonster4.Divine_healer','10.00','25.00',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(13116,13116,'Divine Wizard',0,'',0,'LineageMonster4.Divine_Wizard','10.00','26.00',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,180,1,1,0,1),
(13117,13117,'Divine Enchanter',0,'',0,'LineageMonster4.Divine_enchanter','8.00','18.25',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(13118,13118,'Divine Summoner',0,'',0,'LineageMonster4.Divine_healer','10.00','25.00',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(13119,13119,'Dwarf Golem',0,'',0,'LineageMonster3.chaos_golem_tr','31.00','51.80',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,18,180,1,1,0,1),
(13120,13120,'Giant rat',0,'',0,'LineageMonster4.little_mouse_120p','15.00','20.00',80,'male','L2Npc',40,'680.00000','1820.00000','0.00000','0.90000',40,43,30,21,20,20,0,0,'14.00000','101400.00000','6.00000','307525.00000',230,1,0,333,0,0,0,20,160,1,1,0,1),
(13121,13121,'Giant rat',0,'',0,'LineageMonster4.little_mouse_120p','15.00','20.00',80,'male','L2Npc',40,'680.00000','1820.00000','0.00000','0.90000',40,43,30,21,20,20,0,0,'14.00000','101400.00000','6.00000','307525.00000',230,1,0,333,0,0,0,20,160,1,1,0,1),
(13122,13122,'Giant rat',0,'',0,'LineageMonster4.little_mouse_120p','15.00','20.00',80,'male','L2Npc',40,'680.00000','1820.00000','0.00000','0.90000',40,43,30,21,20,20,0,0,'14.00000','101400.00000','6.00000','307525.00000',230,1,0,333,0,0,0,20,160,1,1,0,1),
(13123,13123,'Super giant rat',0,'',0,'LineageMonster4.little_mouse_180p','19.00','33.00',80,'male','L2Npc',40,'3400.00000','5459.00000','0.00000','0.90000',40,43,30,21,20,20,0,0,'14.00000','101400.00000','6.00000','307525.00000',230,1,0,333,0,0,0,29,160,1,1,0,1),
(13124,13124,'Giant rat',0,'Mr. Bashful',0,'LineageMonster4.little_mouse_120p','15.00','20.00',80,'male','L2Npc',40,'680.00000','1820.00000','0.00000','0.90000',40,43,30,21,20,20,0,0,'14.00000','101400.00000','6.00000','307525.00000',230,1,0,333,0,0,0,20,160,1,1,0,1),
(13125,13125,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',64,'etc','L2Npc',40,'2245.00000','1110.00000','0.00000','0.90000',40,43,30,21,20,20,0,0,'13.00000','91800.00000','6.00000','278410.00000',230,1,0,333,0,0,0,50,1,1,1,0,1),
(13126,13126,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',64,'etc','L2Npc',40,'2444.00000','1225.00000','0.00000','0.90000',40,43,30,21,20,20,0,0,'13.00000','91800.00000','6.00000','278410.00000',230,1,0,333,0,0,0,50,1,1,1,0,1),
(13127,13127,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',68,'etc','L2Npc',40,'2632.00000','1342.00000','0.00000','0.90000',40,43,30,21,20,20,0,0,'13.00000','94200.00000','6.00000','285689.00000',230,1,0,333,0,0,0,50,1,1,1,0,1),
(13128,13128,'Golem Trader',0,'',0,'LineageNPC.e_teleporter_FDwarf','8.00','21.30',70,'female','L2MerchantSummon',40,'2632.00000','1342.00000','0.00000','0.90000',40,43,30,21,20,20,0,0,'13.00000','95400.00000','6.00000','289328.00000',230,1,0,333,0,0,0,50,1,1,1,0,1),
(13129,13129,'Teleporter',0,'',0,'LineageNPC.a_teleporter_FHuman','8.00','25.00',55,'female','L2Npc',40,'1673.00000','810.00000','0.00000','0.90000',40,43,30,21,20,25,0,0,'13.00000','86400.00000','5.00000','262033.00000',230,1,0,333,0,0,0,50,180,1,1,0,1),
(13130,13130,'Light Purple Maned Horse',0,'',0,'LineageMonster4.gray_horse','31.00','32.50',55,'female','L2Npc',40,'1673.00000','810.00000','0.00000','0.90000',40,43,30,21,20,25,0,0,'13.00000','86400.00000','5.00000','262033.00000',230,1,0,333,0,0,0,41,180,1,1,0,1),
(13131,13131,'Grizzly Bear',0,'',0,'LineageMonster.grizzly','21.00','40.00',55,'male','L2Npc',40,'1673.00000','810.00000','0.00000','0.90000',40,43,30,21,20,25,0,0,'13.00000','86400.00000','5.00000','262033.00000',230,1,0,333,0,0,0,40,180,1,1,0,1),
(13132,13132,'Timitran',0,'',0,'LineageMonster.ti_mi_tran','23.00','90.00',55,'male','L2Npc',40,'1673.00000','810.00000','0.00000','0.90000',40,43,30,21,20,25,0,0,'13.00000','86400.00000','5.00000','262033.00000',230,1,0,333,0,0,0,12,180,1,1,0,1),
(13133,13133,'Lava Golem',0,'',0,'LineageMonster2.lava_golem','22.00','45.00',55,'male','L2Npc',40,'1673.00000','810.00000','0.00000','0.90000',40,43,30,21,20,25,0,0,'13.00000','86400.00000','5.00000','262033.00000',230,1,0,333,0,0,0,13,180,1,1,0,1),
(13134,13134,'Yeti',0,'',0,'LineageMonster.yeti_20_bi','18.00','32.00',55,'male','L2Npc',40,'1673.00000','810.00000','0.00000','0.90000',40,43,30,21,20,25,0,0,'13.00000','86400.00000','5.00000','262033.00000',230,1,0,333,0,0,0,16,180,1,1,0,1),
(13135,13135,'Pumpkin Ghost',0,'',0,'LineageNpc2.Pumpkin_Head_man','12.00','18.00',55,'male','L2Npc',40,'1673.00000','810.00000','0.00000','0.90000',40,43,30,21,20,25,0,0,'13.00000','86400.00000','5.00000','262033.00000',230,1,0,333,0,0,0,60,180,1,1,0,1),
(13136,13136,'',0,'',0,'LineageNpcEV.battle_banner','90.00','36.00',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,1,180,0,0,0,1),
(13137,13137,'',0,'',0,'LineageNpcEV.battle_banner','90.00','36.00',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,1,180,0,0,0,1),
(13138,13138,'',0,'',0,'LineageNpcEV.battle_banner','90.00','36.00',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,1,180,0,0,0,1),
(13139,13139,'',0,'',0,'LineageNpcEV.battle_banner','90.00','36.00',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,1,180,0,0,0,1),
(13140,13140,'',0,'',0,'LineageNpcEV.battle_banner','90.00','36.00',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,1,180,0,0,0,1),
(13141,13141,'',0,'',0,'LineageNpcEV.battle_banner','90.00','36.00',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,1,180,0,0,0,1),
(13142,13142,'Final Form',0,'',0,'LineageMonster4.Specular_Form_air','9.00','38.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(13143,13143,'Final Form',0,'',0,'LineageMonster4.Specular_Form_F_air','10.00','32.76',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(13144,13144,'Aurabird-Falcon',0,'',0,'LineageMonster4.closed_attacker','38.00','14.25',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,100,180,1,1,0,1),
(13145,13145,'Aurabird-Owl',0,'',0,'LineageMonster4.heavy_shooter','40.00','18.57',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,100,180,1,1,0,1),
(13146,13146,'Tawny-Maned Lion',0,'',0,'LineageMonster4.tawny_maned_lion','25.00','22.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,43,180,1,1,0,1),
(13147,13147,'Steam Sledge',0,'',0,'LineageMonster4.steam_sledge','40.00','27.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,40,180,1,1,0,1),
(13148,13148,'Lindvior',0,'',0,'LineageMonster4.lindvior_air','190.00','390.60',55,'female','L2FlyMonster',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,100,180,0,0,0,1),
(13149,13149,'For Presentation 1',0,'',0,'LineageNPC.clear_npc','0.10','0.10',85,'male','L2Npc',40,'4234.00000','1680.00000','8.50000','3.00000',40,43,30,21,20,10,0,0,'2052.00000','630.00000','1415.00000','419.00000',230,4,0,333,0,0,0,1,160,0,0,0,1),
(13150,13150,'For Presentation 2',0,'',0,'LineageNPC.clear_npc','0.10','0.10',85,'male','L2Npc',40,'4234.00000','1680.00000','8.50000','3.00000',40,43,30,21,20,10,0,0,'2052.00000','630.00000','1415.00000','419.00000',230,4,0,333,0,0,0,1,160,0,0,0,1),
(13151,13151,'For Presentation 3',0,'',0,'LineageNPC.clear_npc','0.10','0.10',85,'male','L2Npc',40,'4234.00000','1680.00000','8.50000','3.00000',40,43,30,21,20,10,0,0,'2052.00000','630.00000','1415.00000','419.00000',230,4,0,333,0,0,0,1,160,0,0,0,1),
(13152,13152,'For Presentation 4',0,'',0,'LineageNPC.clear_npc','0.10','0.10',85,'male','L2Npc',40,'4234.00000','1680.00000','8.50000','3.00000',40,43,30,21,20,10,0,0,'2052.00000','630.00000','1415.00000','419.00000',230,4,0,333,0,0,0,1,160,0,0,0,1),
(13153,13153,'For Presentation 5',0,'',0,'LineageNPC.clear_npc','0.10','0.10',85,'male','L2Npc',40,'4234.00000','1680.00000','8.50000','3.00000',40,43,30,21,20,10,0,0,'2052.00000','630.00000','1415.00000','419.00000',230,4,0,333,0,0,0,1,160,0,0,0,1),
(13154,13154,'Demon Race',0,'',0,'LineageMonster4.summoner_demon_tr','11.00','27.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,0,1,0,1),
(13155,13155,'Unicorniun',0,'',0,'LineageMonster4.summoner_unicorn_tr','8.00','30.00',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,0,0,1),
(13156,13156,'Myo Race',0,'',0,'LineageMonster4.summoner_cat_tr','10.00','23.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,80,180,0,0,0,1),
(13157,13157,'Frog',0,'',0,'LineageMonster.poison_toad','20.00','10.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,180,1,1,0,1),
(13158,13158,'Young Child',0,'',0,'LineageNPC2.a_child_people_Mhuman','5.00','12.30',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,26,180,1,1,0,1),
(13159,13159,'Mercenary',0,'',0,'LineageNPC.a_fighterguild_master_Mhuman','8.00','23.50',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,180,1,1,0,1),
(13160,13160,'Snowman',0,'',0,'LineageNpc2.snow_man','28.00','30.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,20,180,1,1,0,1),
(13161,13161,'Scarecrow',0,'',0,'LineageNpc2.scarecrow','13.00','30.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,23,180,1,1,0,1),
(13162,13162,'Tin Plate Golem',0,'',0,'LineageNpc2.tin_golem','13.00','18.50',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,13,180,1,1,0,1),
(13163,13163,'Tow',0,'',0,'LineageNPC2.tow','4.40','8.25',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,155,180,1,1,0,1),
(13164,13164,'Lure Tow',0,'',0,'LineageNPC2.tow_lure','4.40','8.25',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,155,180,1,1,0,1),
(13165,13165,'Heavy Tow',0,'',0,'LineageNPC2.tow_heavy','4.40','8.25',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,165,180,1,1,0,1),
(13166,13166,'Wing Tow',0,'',0,'LineageNPC2.tow_whim','4.40','8.25',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,140,180,1,1,0,1),
(13167,13167,'Main Role A',0,'',0,'LineageNPC2.tp_actor','9.00','28.30',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,4,180,1,1,0,1),
(13168,13168,'Main Role B',0,'',0,'LineageNPC2.tp_actor','9.00','28.30',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,4,180,1,1,0,1),
(13169,13169,'Human Male Mercenary',0,'',0,'LineageNPC.a_guard_MHuman','8.00','24.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,180,1,1,0,1),
(13170,13170,'Male Elf Mercenary',0,'',0,'LineageNPC.a_guard_MElf','8.00','23.50',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,180,1,1,0,1),
(13171,13171,'Dark Elf Female Mercenary',0,'',0,'LineageNPC.a_guard_FDarkelf','8.00','25.00',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,180,1,1,0,1),
(13172,13172,'Orc Male Mercenary',0,'',0,'LineageNPC.e_guard_MOrc','8.00','27.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,180,1,1,0,1),
(13173,13173,'Dwarf Male Mercenary',0,'',0,'LineageNPC.e_guard_MDwarf','8.00','19.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,180,1,1,0,1),
(13174,13174,'Kamael Male Mercenary',0,'',0,'LineageNPC2.K_M1_guard','13.00','25.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,39,180,1,1,0,1),
(13175,13175,'Knight Level Mercenary',0,'',0,'LineageNPC.a_royal_guardA_MHuman','8.00','24.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,180,1,1,0,1),
(13176,13176,'Archer Level Mercenary',0,'',0,'LineageNPC2.archer_of_insurgents','10.00','23.50',55,'male','L2Npc',1100,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,8,0,333,15302,0,0,30,180,1,1,0,1),
(13177,13177,'Wizard Level Mercenary',0,'',0,'LineageNPC2.mage_of_insurgents','9.00','23.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,28,180,1,1,0,1),
(13178,13178,'Trooper Level Mercenary',0,'',0,'LineageNPC2.K_F1_guard_Master','13.00','22.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,48,180,1,1,0,1),
(13179,13179,'Knight Leader Elite Mercenary',0,'',0,'LineageMonster3.Kight_of_Dawn','12.00','24.50',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,36,180,1,1,0,1),
(13180,13180,'Commander Elite Mercenary',0,'',0,'LineageNPC2.chief_of_insurgents','10.00','26.99',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,30,180,1,1,0,1),
(13181,13181,'Treasure Box',0,'Gracia',0,'LineageMonster.mimic_even','8.50','8.50',80,'male','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(13182,13182,'Free Gift Merchant',0,'Gracia',0,'LineageMonster.silver_cat','7.00','15.00',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,48,120,1,1,0,1),
(13183,13183,'Thomas D. Turkey',0,'',0,'LineageNpc2.crazy_turkey','25.00','34.00',80,'female','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,120,1,1,0,1),
(13184,13184,'Santa Claus',0,'',0,'LineageNPC2.santa_claus','10.00','21.00',80,'male','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,120,0,1,0,1),
(13185,13185,'Santa Claus',0,'',0,'LineageNPC2.santa_claus_120p','12.00','25.00',80,'male','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,120,0,1,0,1),
(13186,13186,'Santa Claus',0,'',0,'LineageNPC2.santa_sled','0.01','50.00',80,'female','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,55,0,0,0,1),
(13187,13187,'Milk Cow',0,'',0,'LineageMonster4.milk_cow','16.00','12.50',85,'male','L2Npc',40,'4234.00000','1680.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'2052.00000','630.00000','1415.00000','419.00000',230,1,0,333,0,0,0,25,120,1,1,0,1),
(13188,13188,'Head Milk Cow',0,'',0,'LineageMonster4.milk_cow_200p','26.00','28.50',85,'male','L2Npc',40,'4234.00000','1680.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'2052.00000','630.00000','1415.00000','419.00000',230,1,0,333,0,0,0,45,180,1,1,0,1),
(13189,13189,'Bull',0,'',0,'LineageMonster4.yellow_cow','16.00','12.50',85,'male','L2Npc',40,'4234.00000','1680.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'2052.00000','630.00000','1415.00000','419.00000',230,1,0,333,0,0,0,25,120,1,1,0,1),
(13190,13190,'Head Bull',0,'',0,'LineageMonster4.yellow_cow_200p','26.00','28.50',85,'male','L2Npc',40,'4234.00000','1680.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'2052.00000','630.00000','1415.00000','419.00000',230,1,0,333,0,0,0,45,180,1,1,0,1),
(13191,13191,'Gloomy Milk Cow',0,'',0,'LineageMonster4.milk_cow_e','16.00','12.50',85,'male','L2Npc',40,'538.00000','1680.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'2052.00000','104400.00000','12.00000','316623.00000',230,1,0,333,0,0,0,25,120,1,1,0,1),
(13192,13192,'Gloomy Head Milk Cow',0,'',0,'LineageMonster4.milk_cow_200p_e','26.00','28.50',85,'male','L2Npc',40,'6804.00000','1680.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'2052.00000','104400.00000','12.00000','316623.00000',230,1,0,333,0,0,0,45,180,1,1,0,1),
(13193,13193,'',0,'',0,'LineageNpcEV.obelisk_of_middle_square','229.00','177.50',55,'female','L2Npc',40,'1673.00000','810.00000','0.00000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,1,180,0,1,0,1),
(13194,13194,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',85,'male','L2Npc',40,'4234.00000','1680.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'2052.00000','104400.00000','12.00000','316623.00000',230,1,0,333,0,0,0,1,120,1,1,0,1),
(13195,13195,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',85,'male','L2Npc',40,'4234.00000','1680.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'2052.00000','104400.00000','12.00000','316623.00000',230,1,0,333,0,0,0,1,120,1,1,0,1),
(13196,13196,'Great Pig',0,'Mis-summoned',0,'LineageNPC2.E_pig_ball','15.00','18.30',85,'male','L2Npc',40,'6804.00000','1680.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'2052.00000','104400.00000','12.00000','316623.00000',230,1,0,333,0,0,0,60,120,1,1,0,1),
(13197,13197,'Guardian\'s Strider',0,'',0,'LineageNPC.training_doll_150p','13.00','40.00',55,'etc','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,50,180,1,1,0,0),
(13198,13198,'Native',0,'',0,'LineageNPC.a_common_peopleC_Mhuman','8.00','23.50',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,50,180,1,1,0,0),
(13199,13199,'Native',0,'',0,'LineageNPC.a_common_peopleB_FHuman','8.00','20.50',79,'female','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1548.00000','567.00000','1067.00000','377.00000',253,4,0,333,0,0,0,50,180,1,1,0,0),
(13200,13200,'Young Child',0,'',0,'LineageNPC2.a_child_people_Fhuman','5.00','12.30',79,'female','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1548.00000','567.00000','1067.00000','377.00000',253,4,0,333,0,0,0,24,180,1,1,0,0),
(13201,13201,'Guards of the Dawn',0,'',0,'LineageNPC.a_fighterguild_master_FHuman','8.00','21.50',79,'female','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1548.00000','567.00000','1067.00000','377.00000',253,4,0,333,0,0,0,50,180,1,1,0,0),
(13202,13202,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',76,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1348.00000','534.00000','929.00000','355.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13203,13203,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',77,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1409.00000','545.00000','971.00000','362.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13204,13204,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',78,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1474.00000','556.00000','1016.00000','370.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13205,13205,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',79,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1548.00000','567.00000','1067.00000','377.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13206,13206,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1625.00000','577.00000','1121.00000','384.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13207,13207,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',81,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1705.00000','588.00000','1176.00000','391.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13208,13208,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',82,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1788.00000','598.00000','1233.00000','398.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13209,13209,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',83,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13210,13210,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',84,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13211,13211,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',85,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13212,13212,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',86,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2139.00000','640.00000','1475.00000','425.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13213,13213,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',76,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1348.00000','534.00000','929.00000','355.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13214,13214,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',77,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1409.00000','545.00000','971.00000','362.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13215,13215,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',78,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1474.00000','556.00000','1016.00000','370.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13216,13216,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',79,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1548.00000','567.00000','1067.00000','377.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13217,13217,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1625.00000','577.00000','1121.00000','384.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13218,13218,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',81,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1705.00000','588.00000','1176.00000','391.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13219,13219,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',82,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1788.00000','598.00000','1233.00000','398.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13220,13220,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',83,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13221,13221,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',84,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13222,13222,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',85,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13223,13223,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',86,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2139.00000','640.00000','1475.00000','425.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13224,13224,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',76,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1348.00000','534.00000','929.00000','355.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13225,13225,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',77,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1409.00000','545.00000','971.00000','362.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13226,13226,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',78,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1474.00000','556.00000','1016.00000','370.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13227,13227,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',79,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1548.00000','567.00000','1067.00000','377.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13228,13228,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1625.00000','577.00000','1121.00000','384.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13229,13229,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',81,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1705.00000','588.00000','1176.00000','391.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13230,13230,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',82,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1788.00000','598.00000','1233.00000','398.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13231,13231,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',83,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13232,13232,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',84,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13233,13233,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',85,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13234,13234,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',86,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2139.00000','640.00000','1475.00000','425.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13235,13235,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',76,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1348.00000','534.00000','929.00000','355.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13236,13236,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',77,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1409.00000','545.00000','971.00000','362.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13237,13237,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',78,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1474.00000','556.00000','1016.00000','370.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13238,13238,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',79,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1548.00000','567.00000','1067.00000','377.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13239,13239,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1625.00000','577.00000','1121.00000','384.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13240,13240,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',81,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1705.00000','588.00000','1176.00000','391.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13241,13241,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',82,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1788.00000','598.00000','1233.00000','398.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13242,13242,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',83,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13243,13243,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',84,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13244,13244,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',85,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13245,13245,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',86,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2139.00000','640.00000','1475.00000','425.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13246,13246,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',76,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1348.00000','534.00000','929.00000','355.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13247,13247,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',77,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1409.00000','545.00000','971.00000','362.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13248,13248,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',78,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1474.00000','556.00000','1016.00000','370.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13249,13249,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',79,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1548.00000','567.00000','1067.00000','377.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13250,13250,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1625.00000','577.00000','1121.00000','384.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13251,13251,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',81,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1705.00000','588.00000','1176.00000','391.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13252,13252,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',82,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1788.00000','598.00000','1233.00000','398.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13253,13253,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',83,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13254,13254,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',84,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13255,13255,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',85,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13256,13256,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',86,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2139.00000','640.00000','1475.00000','425.00000',253,4,0,333,0,0,0,50,1,1,1,0,0),
(13257,13257,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.50','25.00',76,'etc','L2Decoy',40,'2758.00000','1540.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1348.00000','534.00000','929.00000','355.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13258,13258,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.50','25.00',77,'etc','L2Decoy',40,'2856.00000','1574.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1409.00000','545.00000','971.00000','362.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13259,13259,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.50','25.00',78,'etc','L2Decoy',40,'2974.00000','1607.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1474.00000','556.00000','1016.00000','370.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13260,13260,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.50','25.00',79,'etc','L2Decoy',40,'3127.00000','1641.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1548.00000','567.00000','1067.00000','377.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13261,13261,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.50','25.00',80,'etc','L2Decoy',40,'3290.00000','1674.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1625.00000','577.00000','1121.00000','384.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13262,13262,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.50','25.00',81,'etc','L2Decoy',40,'3461.00000','1708.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1705.00000','588.00000','1176.00000','391.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13263,13263,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.50','25.00',82,'etc','L2Decoy',40,'3643.00000','1743.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1788.00000','598.00000','1233.00000','398.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13264,13264,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.50','25.00',83,'etc','L2Decoy',40,'3835.00000','1777.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13265,13265,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.50','25.00',84,'etc','L2Decoy',40,'4039.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13266,13266,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.50','25.00',85,'etc','L2Decoy',40,'4234.00000','1846.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13267,13267,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.50','25.00',86,'etc','L2Decoy',40,'4439.00000','1881.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2139.00000','640.00000','1475.00000','425.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(13268,13268,'Aqua Elf',0,'',0,'LineageNPC2.bikini_elf','12.00','27.50',55,'female','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,50,180,1,1,0,0),
(13269,13269,'Hot Weather',0,'',0,'LineageMonster5.event_the_heat','9.00','14.50',80,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'17.00000','101447.00000','1121.00000','307184.00000',253,4,0,333,0,0,0,30,160,1,1,0,0),
(13270,13270,'Sultriness',0,'',0,'LineageMonster5.event_terrible_heat','30.00','53.50',80,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'17.00000','101447.00000','1121.00000','307184.00000',253,4,0,333,0,0,0,30,160,1,1,0,0),
(13271,13271,'Young Watermelon',0,'',0,'LineageNPC2.event_unripe_watermelon','11.00','22.00',1,'etc','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,10,0,0,'8.00000','40.00000','5.00000','27.00000',253,1,0,333,0,0,0,50,100,1,1,0,0),
(13272,13272,'Defective Watermelon',0,'',0,'LineageNPC2.event_bad_watermelon','14.00','30.00',1,'etc','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,10,0,0,'8.00000','40.00000','5.00000','27.00000',253,1,0,333,0,0,0,50,100,1,1,0,0),
(13273,13273,'Rain Watermelon',0,'',0,'LineageNPC2.event_good_watermelon','17.00','35.00',1,'etc','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,10,0,0,'8.00000','40.00000','5.00000','27.00000',253,1,0,333,0,0,0,50,100,1,1,0,0),
(13274,13274,'Large Rain Watermelon',0,'',0,'LineageNPC2.event_king_watermelon','30.00','65.00',1,'etc','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,10,0,0,'8.00000','40.00000','5.00000','27.00000',253,1,0,333,0,0,0,50,100,1,1,0,0),
(13275,13275,'Young Honey Watermelon',0,'',0,'LineageNPC2.event_big_watermelon','10.00','20.00',1,'etc','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,10,0,0,'8.00000','40.00000','5.00000','27.00000',253,1,0,333,0,0,0,50,100,1,1,0,0),
(13276,13276,'Defective Honey Watermelon',0,'',0,'LineageNPC2.event_bad_big_watermelon','20.00','40.00',1,'etc','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,10,0,0,'8.00000','40.00000','5.00000','27.00000',253,1,0,333,0,0,0,50,100,1,1,0,0),
(13277,13277,'Rain Honey Watermelon',0,'',0,'LineageNPC2.event_good_big_watermelon','26.00','52.00',1,'etc','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,10,0,0,'8.00000','40.00000','5.00000','27.00000',253,1,0,333,0,0,0,50,100,1,1,0,0),
(13278,13278,'Large Rain Honey Watermelon',0,'',0,'LineageNPC2.event_king_big_watermelon','30.00','60.00',1,'etc','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,10,0,0,'8.00000','40.00000','5.00000','27.00000',253,1,0,333,0,0,0,50,100,1,1,0,0),
(13279,13279,'Uldie',0,'',0,'LineageMonster4.wooldie','8.00','17.00',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,10,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,18,160,1,1,0,0),
(13280,13280,'Belldandy',0,'',0,'LineageMonster4.berdandi','9.00','20.50',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,22,174,1,1,0,0),
(13281,13281,'Skooldie',0,'Event manager',0,'LineageMonster4.scooldie','8.00','12.80',80,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1625.00000','577.00000','1121.00000','384.00000',253,4,0,333,0,0,0,15,160,1,1,0,0),
(13282,13282,'Skooldie',0,'',0,'LineageMonster4.scooldie','8.00','12.80',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,15,160,1,1,0,0),
(13283,13283,'Treykan',0,'',0,'LineageMonster5.traikan','25.00','27.00',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,88,180,1,1,0,0),
(13284,13284,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',80,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1625.00000','577.00000','1121.00000','384.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(13285,13285,'Santa Claus',0,'Event manager',0,'LineageNPC2.santa_claus_120p','12.00','25.00',80,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1625.00000','577.00000','1121.00000','384.00000',253,4,0,333,0,0,0,50,120,1,1,0,0),
(13286,13286,'Baby White Tiger',0,'',0,'LineageMonster2.baby_tiger_e','11.00','15.70',85,'male','L2Npc',40,'3862.00000','1494.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','104450.00000','10.00000','316244.00000',253,1,0,333,0,0,0,28,120,1,1,0,0),
(13287,13287,'Baby White Tiger Captain',0,'',0,'LineageMonster2.baby_tiger_200p_e','22.00','29.50',85,'male','L2Npc',40,'3862.00000','1494.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','104450.00000','10.00000','316244.00000',253,1,0,333,0,0,0,28,180,1,1,0,0),
(13288,13288,'Gloomy Baby White Tiger',0,'',0,'LineageMonster2.baby_tiger_de','11.00','15.70',85,'male','L2Npc',40,'3862.00000','1494.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','104450.00000','10.00000','316244.00000',253,1,0,333,0,0,0,28,120,1,1,0,0),
(13289,13289,'Gloomy Baby White Tiger Captain',0,'',0,'LineageMonster2.baby_tiger_200p_de','22.00','29.50',85,'male','L2Npc',40,'3862.00000','1494.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','104450.00000','10.00000','316244.00000',253,1,0,333,0,0,0,28,180,1,1,0,0),
(13290,13290,'White Tiger',0,'',0,'LineageMonster2.youth_tiger_e','16.00','17.20',85,'male','L2Npc',40,'3862.00000','1494.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','104450.00000','10.00000','316244.00000',253,1,0,333,0,0,0,60,120,1,1,0,0),
(13291,13291,'White Tiger Captain',0,'',0,'LineageMonster2.youth_tiger_200p_e','50.00','34.00',85,'male','L2Npc',40,'3862.00000','1494.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','104450.00000','10.00000','316244.00000',253,1,0,333,0,0,0,60,180,1,1,0,0),
(13292,13292,'Employee of Magic Research Institute',0,'Event manager',0,'LineageNPC.e_smith_Fdwarf','8.00','17.50',75,'female','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1292.00000','524.00000','890.00000','348.00000',253,4,0,333,313,0,0,50,120,1,1,0,0),
(13293,13293,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',85,'male','L2Npc',40,'3862.00000','1494.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,1,0,333,0,0,0,1,120,1,1,0,0),
(13294,13294,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',85,'male','L2Npc',40,'3862.00000','1494.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,1,0,333,0,0,0,1,120,1,1,0,0),
(13295,13295,'Shining White',0,'Event manager',0,'LineageNPC.e_smith_Fdwarf','8.00','17.50',80,'female','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1625.00000','577.00000','1121.00000','384.00000',253,4,0,333,0,0,0,50,160,1,1,0,0),
(13296,13296,'Freya',0,'Event manager',0,'LineageMonster5.freya_small','18.00','36.00',80,'female','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1625.00000','577.00000','1121.00000','384.00000',253,4,0,333,0,0,0,54,160,1,1,0,0),
(14001,14001,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',46,'male','L2Pet',40,'2914.00000','816.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'482.00000','245.00000','202.00000','230.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14002,14002,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',54,'male','L2Pet',40,'3843.00000','1102.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'763.00000','313.00000','339.00000','293.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14003,14003,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',62,'male','L2Pet',40,'4829.00000','1404.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1133.00000','388.00000','532.00000','363.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14004,14004,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',66,'male','L2Pet',40,'5319.00000','1561.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1347.00000','428.00000','649.00000','401.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14005,14005,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',70,'male','L2Pet',40,'5793.00000','1722.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1577.00000','470.00000','780.00000','440.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14006,14006,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',74,'male','L2Pet',40,'6238.00000','1888.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1816.00000','512.00000','921.00000','480.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14007,14007,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',76,'male','L2Pet',40,'6446.00000','1972.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1937.00000','534.00000','994.00000','500.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14008,14008,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',78,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2068.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14009,14009,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',78,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2078.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14010,14010,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',78,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2088.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14011,14011,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',78,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2099.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14012,14012,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',79,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2109.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14013,14013,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',79,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2119.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14014,14014,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',79,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2130.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14015,14015,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',79,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2140.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14016,14016,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',80,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2150.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14017,14017,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',80,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2173.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14018,14018,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',80,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2184.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14019,14019,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',80,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2194.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14020,14020,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',81,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2204.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14021,14021,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',81,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2215.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14022,14022,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',81,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2225.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14023,14023,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',81,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2236.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14024,14024,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',82,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2246.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14025,14025,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',82,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2256.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14026,14026,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',82,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2280.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14027,14027,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',82,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2290.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14028,14028,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',83,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2301.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14029,14029,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',83,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2311.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14030,14030,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',83,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2322.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14031,14031,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',83,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2332.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14032,14032,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',84,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2343.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14033,14033,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',84,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2353.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14034,14034,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',84,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2363.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14035,14035,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',85,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2374.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14036,14036,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',85,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2384.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14037,14037,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11.00','25.00',85,'male','L2Pet',40,'7085.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2395.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,60,140,1,1,0,0),
(14038,14038,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',42,'male','L2Pet',40,'2490.00000','1019.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'374.00000','215.00000','152.00000','202.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14039,14039,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',50,'male','L2Pet',40,'3367.00000','1435.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'611.00000','278.00000','264.00000','260.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14040,14040,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',58,'male','L2Pet',40,'4333.00000','1876.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'937.00000','349.00000','428.00000','327.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14041,14041,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',64,'male','L2Pet',40,'5076.00000','2223.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1238.00000','408.00000','589.00000','382.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14042,14042,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',68,'male','L2Pet',40,'5559.00000','2462.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1460.00000','449.00000','713.00000','421.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14043,14043,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',72,'male','L2Pet',40,'6020.00000','2707.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1695.00000','491.00000','849.00000','460.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14044,14044,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',78,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2068.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14045,14045,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',78,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2078.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14046,14046,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',78,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2088.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14047,14047,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',78,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2099.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14048,14048,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',79,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2109.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14049,14049,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',79,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2119.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14050,14050,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',79,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2130.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14051,14051,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',79,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2140.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14052,14052,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',80,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2150.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14053,14053,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',80,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2173.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14054,14054,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',80,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2184.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14055,14055,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',80,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2194.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14056,14056,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',81,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2204.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14057,14057,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',81,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2215.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14058,14058,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',81,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2225.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14059,14059,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',81,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2236.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14060,14060,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',82,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2246.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14061,14061,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',82,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2256.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14062,14062,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',82,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2280.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14063,14063,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',82,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2290.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14064,14064,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',83,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2301.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14065,14065,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',83,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2311.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14066,14066,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',83,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2322.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14067,14067,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',83,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2332.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14068,14068,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',84,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2343.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14069,14069,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',84,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2353.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14070,14070,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',84,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2363.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14071,14071,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',85,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2374.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14072,14072,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',85,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2384.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14073,14073,'Corrupted Man',0,'',0,'LineageMonster.zombie','13.00','21.00',85,'male','L2Pet',40,'6642.00000','3086.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2395.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,15,140,1,1,0,0),
(14074,14074,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',58,'male','L2Pet',40,'3467.00000','1251.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'1015.00000','349.00000','428.00000','327.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14075,14075,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',62,'male','L2Pet',40,'3863.00000','1404.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1227.00000','388.00000','532.00000','363.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14076,14076,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',66,'male','L2Pet',40,'4255.00000','1561.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1459.00000','428.00000','649.00000','401.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14077,14077,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',70,'male','L2Pet',40,'4634.00000','1722.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1708.00000','470.00000','780.00000','440.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14078,14078,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',72,'male','L2Pet',40,'4816.00000','1804.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1837.00000','491.00000','849.00000','460.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14079,14079,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',74,'male','L2Pet',40,'4990.00000','1888.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1967.00000','512.00000','921.00000','480.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14080,14080,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',76,'male','L2Pet',40,'5157.00000','1972.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2098.00000','534.00000','994.00000','500.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14081,14081,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',78,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2229.00000','555.00000','1069.00000','520.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14082,14082,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',78,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2245.00000','555.00000','1069.00000','520.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14083,14083,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',78,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2261.00000','555.00000','1069.00000','520.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14084,14084,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',78,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2277.00000','555.00000','1069.00000','520.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14085,14085,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',79,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2293.00000','555.00000','1069.00000','520.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14086,14086,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',79,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2309.00000','555.00000','1069.00000','520.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14087,14087,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',79,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2325.00000','555.00000','1069.00000','520.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14088,14088,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',79,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2341.00000','555.00000','1069.00000','520.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14089,14089,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',80,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2357.00000','555.00000','1069.00000','520.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14090,14090,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',80,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2388.00000','558.00000','1082.00000','523.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14091,14091,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',80,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2404.00000','558.00000','1082.00000','523.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14092,14092,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',80,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2420.00000','558.00000','1082.00000','523.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14093,14093,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',81,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2436.00000','558.00000','1082.00000','523.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14094,14094,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',81,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2452.00000','558.00000','1082.00000','523.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14095,14095,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',81,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2468.00000','558.00000','1082.00000','523.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14096,14096,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',81,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2484.00000','558.00000','1082.00000','523.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14097,14097,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',82,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2500.00000','558.00000','1082.00000','523.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14098,14098,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',82,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2517.00000','558.00000','1082.00000','523.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14099,14099,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',82,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2548.00000','562.00000','1095.00000','526.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14100,14100,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',82,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2564.00000','562.00000','1095.00000','526.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14101,14101,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',83,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2580.00000','562.00000','1095.00000','526.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14102,14102,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',83,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2596.00000','562.00000','1095.00000','526.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14103,14103,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',83,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2613.00000','562.00000','1095.00000','526.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14104,14104,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',83,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2629.00000','562.00000','1095.00000','526.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14105,14105,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',84,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2645.00000','562.00000','1095.00000','526.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14106,14106,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',84,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2661.00000','562.00000','1095.00000','526.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14107,14107,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',84,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2678.00000','562.00000','1095.00000','526.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14108,14108,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',85,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2694.00000','562.00000','1095.00000','526.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14109,14109,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',85,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2710.00000','562.00000','1095.00000','526.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14110,14110,'Cursed Man',0,'',0,'LineageMonster.doll_master','20.00','42.00',85,'male','L2Pet',40,'5314.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2726.00000','562.00000','1095.00000','526.00000',278,8,0,333,0,0,0,80,160,1,1,0,0),
(14111,14111,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',22,'male','L2Pet',40,'984.00000','279.00000','3.50000','1.50000',40,43,30,21,20,25,0,0,'82.00000','102.00000','28.00000','95.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14112,14112,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',27,'male','L2Pet',40,'1310.00000','367.00000','3.50000','1.50000',40,43,30,21,20,25,0,0,'124.00000','125.00000','45.00000','117.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14113,14113,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',32,'male','L2Pet',40,'1700.00000','458.00000','4.50000','1.80000',40,43,30,21,20,25,0,0,'186.00000','151.00000','69.00000','140.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14114,14114,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',37,'male','L2Pet',40,'2155.00000','533.00000','4.50000','1.80000',40,43,30,21,20,25,0,0,'267.00000','181.00000','104.00000','169.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14115,14115,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',42,'male','L2Pet',40,'2673.00000','679.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'376.00000','236.00000','152.00000','221.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14116,14116,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',46,'male','L2Pet',40,'3128.00000','816.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'486.00000','270.00000','202.00000','252.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14117,14117,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',50,'male','L2Pet',40,'3614.00000','957.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'615.00000','305.00000','263.00000','285.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14118,14118,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',54,'male','L2Pet',40,'4125.00000','1102.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'768.00000','342.00000','339.00000','322.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14119,14119,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',58,'male','L2Pet',40,'4651.00000','1251.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'943.00000','383.00000','428.00000','360.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14120,14120,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',60,'male','L2Pet',40,'4917.00000','1327.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'1040.00000','404.00000','477.00000','379.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14121,14121,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',62,'male','L2Pet',40,'5183.00000','1404.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1142.00000','426.00000','531.00000','399.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14122,14122,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',64,'male','L2Pet',40,'5448.00000','1482.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1248.00000','449.00000','588.00000','420.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14123,14123,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',66,'male','L2Pet',40,'5710.00000','1561.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1357.00000','470.00000','649.00000','440.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14124,14124,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',68,'male','L2Pet',40,'5967.00000','1641.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1472.00000','493.00000','713.00000','462.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14125,14125,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',70,'male','L2Pet',40,'6218.00000','1722.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1588.00000','515.00000','779.00000','483.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14126,14126,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',72,'male','L2Pet',40,'6461.00000','1803.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1708.00000','540.00000','848.00000','505.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14127,14127,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',74,'male','L2Pet',40,'6695.00000','1888.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1829.00000','563.00000','920.00000','527.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14128,14128,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',76,'male','L2Pet',40,'6919.00000','1972.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1952.00000','586.00000','993.00000','548.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14129,14129,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',78,'male','L2Pet',40,'7150.00000','2059.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2083.00000','609.00000','1071.00000','569.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14130,14130,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',78,'male','L2Pet',40,'7209.00000','2081.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2117.00000','614.00000','1092.00000','574.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14131,14131,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',78,'male','L2Pet',40,'7269.00000','2103.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2152.00000','620.00000','1113.00000','579.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14132,14132,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',78,'male','L2Pet',40,'7329.00000','2126.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2188.00000','626.00000','1134.00000','584.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14133,14133,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',79,'male','L2Pet',40,'7390.00000','2149.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2224.00000','632.00000','1156.00000','589.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14134,14134,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',79,'male','L2Pet',40,'7451.00000','2172.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2261.00000','638.00000','1178.00000','594.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14135,14135,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',79,'male','L2Pet',40,'7513.00000','2195.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2298.00000','644.00000','1201.00000','599.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14136,14136,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',79,'male','L2Pet',40,'7575.00000','2219.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2336.00000','650.00000','1224.00000','604.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14137,14137,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',80,'male','L2Pet',40,'7638.00000','2243.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2375.00000','656.00000','1248.00000','609.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14138,14138,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',80,'male','L2Pet',40,'7701.00000','2267.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2414.00000','662.00000','1272.00000','614.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14139,14139,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',80,'male','L2Pet',40,'7765.00000','2292.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2454.00000','668.00000','1296.00000','619.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14140,14140,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',80,'male','L2Pet',40,'7829.00000','2317.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2495.00000','674.00000','1321.00000','624.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14141,14141,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',81,'male','L2Pet',40,'7894.00000','2342.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2536.00000','680.00000','1346.00000','629.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14142,14142,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',81,'male','L2Pet',40,'7959.00000','2367.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2578.00000','686.00000','1372.00000','635.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14143,14143,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',81,'male','L2Pet',40,'8025.00000','2393.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2621.00000','692.00000','1398.00000','641.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14144,14144,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',81,'male','L2Pet',40,'8091.00000','2419.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2664.00000','698.00000','1425.00000','647.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14145,14145,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',82,'male','L2Pet',40,'8158.00000','2445.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2708.00000','704.00000','1452.00000','653.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14146,14146,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',82,'male','L2Pet',40,'8226.00000','2471.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2753.00000','710.00000','1480.00000','659.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14147,14147,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',82,'male','L2Pet',40,'8294.00000','2498.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2799.00000','716.00000','1509.00000','665.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14148,14148,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',82,'male','L2Pet',40,'8363.00000','2525.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2845.00000','723.00000','1538.00000','671.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14149,14149,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',83,'male','L2Pet',40,'8432.00000','2552.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2892.00000','730.00000','1568.00000','677.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14150,14150,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',83,'male','L2Pet',40,'8502.00000','2580.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2940.00000','737.00000','1598.00000','683.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14151,14151,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',83,'male','L2Pet',40,'8572.00000','2608.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2989.00000','744.00000','1629.00000','689.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14152,14152,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',83,'male','L2Pet',40,'8643.00000','2636.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3039.00000','751.00000','1660.00000','695.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14153,14153,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',84,'male','L2Pet',40,'8715.00000','2665.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3089.00000','758.00000','1692.00000','701.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14154,14154,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',84,'male','L2Pet',40,'8787.00000','2694.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3140.00000','765.00000','1725.00000','707.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14155,14155,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',84,'male','L2Pet',40,'8860.00000','2723.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3192.00000','772.00000','1758.00000','713.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14156,14156,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',85,'male','L2Pet',40,'8933.00000','2753.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3245.00000','779.00000','1792.00000','719.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14157,14157,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',85,'male','L2Pet',40,'9007.00000','2783.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3299.00000','786.00000','1827.00000','725.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14158,14158,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9.00','16.00',85,'male','L2Pet',40,'9082.00000','2813.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3354.00000','793.00000','1862.00000','731.00000',278,4,0,333,0,0,0,80,120,1,1,0,0),
(14159,14159,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',22,'female','L2Pet',40,'984.00000','279.00000','3.50000','1.50000',40,43,30,21,20,25,0,0,'74.00000','102.00000','34.00000','95.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14160,14160,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',27,'female','L2Pet',40,'1310.00000','367.00000','3.50000','1.50000',40,43,30,21,20,25,0,0,'113.00000','125.00000','54.00000','117.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14161,14161,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',32,'female','L2Pet',40,'1700.00000','458.00000','4.50000','1.80000',40,43,30,21,20,25,0,0,'169.00000','151.00000','83.00000','140.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14162,14162,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',37,'female','L2Pet',40,'2155.00000','553.00000','4.50000','1.80000',40,43,30,21,20,25,0,0,'242.00000','181.00000','126.00000','169.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14163,14163,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',42,'female','L2Pet',40,'2673.00000','679.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'342.00000','236.00000','183.00000','221.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14164,14164,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',46,'female','L2Pet',40,'3128.00000','816.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'441.00000','270.00000','244.00000','252.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14165,14165,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',50,'female','L2Pet',40,'3614.00000','957.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'559.00000','305.00000','319.00000','285.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14166,14166,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',54,'female','L2Pet',40,'4125.00000','1102.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'698.00000','342.00000','410.00000','322.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14167,14167,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',58,'female','L2Pet',40,'4651.00000','1251.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'857.00000','383.00000','518.00000','360.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14168,14168,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',60,'female','L2Pet',40,'4917.00000','1327.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'946.00000','404.00000','578.00000','379.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14169,14169,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',62,'female','L2Pet',40,'5183.00000','1404.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1038.00000','426.00000','642.00000','399.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14170,14170,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',64,'female','L2Pet',40,'5448.00000','1482.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1135.00000','449.00000','711.00000','420.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14171,14171,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',66,'female','L2Pet',40,'5710.00000','1561.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1233.00000','470.00000','785.00000','440.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14172,14172,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',68,'female','L2Pet',40,'5967.00000','1641.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1338.00000','493.00000','862.00000','462.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14173,14173,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',70,'female','L2Pet',40,'6218.00000','1722.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1443.00000','515.00000','943.00000','483.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14174,14174,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',72,'female','L2Pet',40,'6461.00000','1804.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1553.00000','540.00000','1026.00000','505.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14175,14175,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',74,'female','L2Pet',40,'6695.00000','1888.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1663.00000','563.00000','1113.00000','527.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14176,14176,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',76,'female','L2Pet',40,'6919.00000','1972.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1775.00000','586.00000','1201.00000','548.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14177,14177,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',78,'female','L2Pet',40,'7150.00000','2059.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1894.00000','609.00000','1295.00000','569.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14178,14178,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',78,'female','L2Pet',40,'7209.00000','2081.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1925.00000','614.00000','1320.00000','574.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14179,14179,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',78,'female','L2Pet',40,'7269.00000','2103.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1957.00000','620.00000','1345.00000','579.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14180,14180,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',78,'female','L2Pet',40,'7329.00000','2126.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1989.00000','626.00000','1371.00000','584.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14181,14181,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',79,'female','L2Pet',40,'7390.00000','2149.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2022.00000','632.00000','1397.00000','589.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14182,14182,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',79,'female','L2Pet',40,'7451.00000','2172.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2055.00000','638.00000','1424.00000','594.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14183,14183,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',79,'female','L2Pet',40,'7513.00000','2195.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2089.00000','644.00000','1451.00000','599.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14184,14184,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',79,'female','L2Pet',40,'7575.00000','2219.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2124.00000','650.00000','1479.00000','604.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14185,14185,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',80,'female','L2Pet',40,'7638.00000','2243.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2159.00000','656.00000','1507.00000','609.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14186,14186,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',80,'female','L2Pet',40,'7701.00000','2267.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2195.00000','662.00000','1536.00000','614.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14187,14187,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',80,'female','L2Pet',40,'7765.00000','2292.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2231.00000','668.00000','1566.00000','619.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14188,14188,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',80,'female','L2Pet',40,'7829.00000','2317.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2268.00000','674.00000','1596.00000','624.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14189,14189,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',81,'female','L2Pet',40,'7894.00000','2342.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2306.00000','680.00000','1627.00000','629.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14190,14190,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',81,'female','L2Pet',40,'7959.00000','2367.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2344.00000','686.00000','1658.00000','635.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14191,14191,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',81,'female','L2Pet',40,'8025.00000','2393.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2383.00000','692.00000','1690.00000','641.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14192,14192,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',81,'female','L2Pet',40,'8091.00000','2419.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2422.00000','698.00000','1723.00000','647.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14193,14193,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',82,'female','L2Pet',40,'8158.00000','2445.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2462.00000','704.00000','1756.00000','653.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14194,14194,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',82,'female','L2Pet',40,'8226.00000','2471.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2503.00000','710.00000','1790.00000','659.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14195,14195,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',82,'female','L2Pet',40,'8294.00000','2498.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2544.00000','716.00000','1825.00000','665.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14196,14196,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',82,'female','L2Pet',40,'8363.00000','2525.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2586.00000','723.00000','1860.00000','671.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14197,14197,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',83,'female','L2Pet',40,'8432.00000','2552.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2629.00000','730.00000','1896.00000','677.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14198,14198,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',83,'female','L2Pet',40,'8502.00000','2580.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2673.00000','737.00000','1933.00000','683.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14199,14199,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',83,'female','L2Pet',40,'8572.00000','2608.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2717.00000','744.00000','1970.00000','689.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14200,14200,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',83,'female','L2Pet',40,'8643.00000','2636.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2762.00000','751.00000','2008.00000','695.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14201,14201,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',84,'female','L2Pet',40,'8715.00000','2665.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2808.00000','758.00000','2047.00000','701.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14202,14202,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',84,'female','L2Pet',40,'8787.00000','2694.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2855.00000','765.00000','2087.00000','707.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14203,14203,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',84,'female','L2Pet',40,'8860.00000','2723.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2902.00000','772.00000','2127.00000','713.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14204,14204,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',85,'female','L2Pet',40,'8933.00000','2753.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2950.00000','779.00000','2168.00000','719.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14205,14205,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',85,'female','L2Pet',40,'9007.00000','2783.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2999.00000','786.00000','2210.00000','725.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14206,14206,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8.00','15.00',85,'female','L2Pet',40,'9082.00000','2813.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3049.00000','793.00000','2253.00000','731.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14207,14207,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',42,'male','L2Pet',40,'2008.00000','679.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'413.00000','236.00000','152.00000','221.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14208,14208,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',46,'male','L2Pet',40,'2351.00000','816.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'534.00000','270.00000','202.00000','252.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14209,14209,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',50,'male','L2Pet',40,'2716.00000','957.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'676.00000','305.00000','263.00000','285.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14210,14210,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',54,'male','L2Pet',40,'3100.00000','1102.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'844.00000','342.00000','339.00000','322.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14211,14211,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',58,'male','L2Pet',40,'3496.00000','1251.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'1036.00000','393.00000','428.00000','360.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14212,14212,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',60,'male','L2Pet',40,'3695.00000','1327.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'1142.00000','404.00000','477.00000','379.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14213,14213,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',62,'male','L2Pet',40,'3895.00000','1404.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1255.00000','426.00000','531.00000','399.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14214,14214,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',64,'male','L2Pet',40,'4094.00000','1482.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1372.00000','449.00000','588.00000','420.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14215,14215,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',66,'male','L2Pet',40,'4291.00000','1561.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1491.00000','470.00000','649.00000','440.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14216,14216,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',68,'male','L2Pet',40,'4484.00000','1641.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1618.00000','493.00000','713.00000','462.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14217,14217,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',70,'male','L2Pet',40,'4673.00000','1722.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1745.00000','515.00000','779.00000','483.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14218,14218,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',72,'male','L2Pet',40,'4856.00000','1804.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1878.00000','540.00000','848.00000','505.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14219,14219,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',74,'male','L2Pet',40,'5032.00000','1888.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2010.00000','563.00000','920.00000','527.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14220,14220,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',76,'male','L2Pet',40,'5200.00000','1972.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2146.00000','586.00000','993.00000','548.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14221,14221,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',78,'male','L2Pet',40,'5373.00000','2059.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2291.00000','609.00000','1071.00000','569.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14222,14222,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',78,'male','L2Pet',40,'5417.00000','2081.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2329.00000','614.00000','1092.00000','574.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14223,14223,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',78,'male','L2Pet',40,'5462.00000','2103.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2368.00000','620.00000','1113.00000','579.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14224,14224,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',78,'male','L2Pet',40,'5507.00000','2126.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2408.00000','626.00000','1134.00000','584.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14225,14225,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',79,'male','L2Pet',40,'5552.00000','2149.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2448.00000','632.00000','1156.00000','589.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14226,14226,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',79,'male','L2Pet',40,'5598.00000','2172.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2489.00000','638.00000','1178.00000','594.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14227,14227,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',79,'male','L2Pet',40,'5644.00000','2195.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2531.00000','644.00000','1201.00000','599.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14228,14228,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',79,'male','L2Pet',40,'5690.00000','2219.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2573.00000','650.00000','1224.00000','604.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14229,14229,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',80,'male','L2Pet',40,'5737.00000','2243.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2616.00000','656.00000','1248.00000','609.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14230,14230,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',80,'male','L2Pet',40,'5784.00000','2267.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2660.00000','662.00000','1272.00000','614.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14231,14231,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',80,'male','L2Pet',40,'5832.00000','2292.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2704.00000','668.00000','1296.00000','619.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14232,14232,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',80,'male','L2Pet',40,'5880.00000','2317.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2749.00000','674.00000','1321.00000','624.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14233,14233,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',81,'male','L2Pet',40,'5928.00000','2342.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2795.00000','680.00000','1346.00000','629.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14234,14234,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',81,'male','L2Pet',40,'5977.00000','2367.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2842.00000','686.00000','1372.00000','635.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14235,14235,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',81,'male','L2Pet',40,'6026.00000','2393.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2890.00000','692.00000','1398.00000','641.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14236,14236,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',81,'male','L2Pet',40,'6076.00000','2419.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2938.00000','698.00000','1425.00000','647.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14237,14237,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',82,'male','L2Pet',40,'6126.00000','2445.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2987.00000','704.00000','1452.00000','653.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14238,14238,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',82,'male','L2Pet',40,'6176.00000','2471.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3037.00000','710.00000','1480.00000','659.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14239,14239,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',82,'male','L2Pet',40,'6227.00000','2498.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3088.00000','716.00000','1509.00000','665.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14240,14240,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',82,'male','L2Pet',40,'6278.00000','2525.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3140.00000','723.00000','1538.00000','671.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14241,14241,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',83,'male','L2Pet',40,'6330.00000','2552.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3193.00000','730.00000','1568.00000','677.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14242,14242,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',83,'male','L2Pet',40,'6382.00000','2580.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3246.00000','737.00000','1598.00000','683.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14243,14243,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',83,'male','L2Pet',40,'6435.00000','2608.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3300.00000','744.00000','1629.00000','689.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14244,14244,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',83,'male','L2Pet',40,'6488.00000','2636.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3355.00000','751.00000','1660.00000','695.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14245,14245,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',84,'male','L2Pet',40,'6541.00000','2665.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3411.00000','758.00000','1692.00000','701.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14246,14246,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',84,'male','L2Pet',40,'6595.00000','2694.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3468.00000','765.00000','1725.00000','707.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14247,14247,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',84,'male','L2Pet',40,'6649.00000','2723.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3526.00000','772.00000','1758.00000','713.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14248,14248,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',85,'male','L2Pet',40,'6704.00000','2753.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3585.00000','779.00000','1792.00000','719.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14249,14249,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',85,'male','L2Pet',40,'6759.00000','2783.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3645.00000','786.00000','1827.00000','725.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14250,14250,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7.00','15.00',85,'male','L2Pet',40,'6815.00000','2813.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3706.00000','793.00000','1862.00000','731.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14251,14251,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',58,'female','L2Pet',40,'2889.00000','1251.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'779.00000','348.00000','428.00000','327.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14252,14252,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',60,'female','L2Pet',40,'3054.00000','1327.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'860.00000','368.00000','477.00000','345.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14253,14253,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',62,'female','L2Pet',40,'3219.00000','1404.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'944.00000','388.00000','531.00000','363.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14254,14254,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',64,'female','L2Pet',40,'3384.00000','1482.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1031.00000','408.00000','588.00000','381.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14255,14255,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',66,'female','L2Pet',40,'3546.00000','1561.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1121.00000','427.00000','649.00000','400.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14256,14256,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',68,'female','L2Pet',40,'3706.00000','1641.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1217.00000','449.00000','713.00000','420.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14257,14257,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',70,'female','L2Pet',40,'3862.00000','1722.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1312.00000','469.00000','779.00000','439.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14258,14258,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',72,'female','L2Pet',40,'4013.00000','1804.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1412.00000','491.00000','848.00000','459.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14259,14259,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',74,'female','L2Pet',40,'4158.00000','1888.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1511.00000','511.00000','920.00000','479.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14260,14260,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',76,'female','L2Pet',40,'4297.00000','1972.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1613.00000','532.00000','993.00000','498.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14265,14265,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',78,'female','L2Pet',40,'4440.00000','2059.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1721.00000','553.00000','1071.00000','517.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14266,14266,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',78,'female','L2Pet',40,'4476.00000','2081.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1749.00000','558.00000','1092.00000','521.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14267,14267,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',78,'female','L2Pet',40,'4513.00000','2103.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1778.00000','563.00000','1113.00000','525.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14268,14268,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',78,'female','L2Pet',40,'4550.00000','2126.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1807.00000','568.00000','1134.00000','530.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14269,14269,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',79,'female','L2Pet',40,'4587.00000','2149.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1837.00000','573.00000','1156.00000','535.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14270,14270,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',79,'female','L2Pet',40,'4625.00000','2172.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1867.00000','578.00000','1178.00000','540.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14271,14271,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',79,'female','L2Pet',40,'4663.00000','2195.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1898.00000','583.00000','1201.00000','545.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14272,14272,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',79,'female','L2Pet',40,'4701.00000','2219.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1929.00000','588.00000','1224.00000','550.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14273,14273,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',80,'female','L2Pet',40,'4740.00000','2243.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1961.00000','593.00000','1248.00000','555.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14274,14274,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',80,'female','L2Pet',40,'4779.00000','2267.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1993.00000','598.00000','1272.00000','560.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14275,14275,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',80,'female','L2Pet',40,'4818.00000','2292.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2026.00000','603.00000','1296.00000','565.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14276,14276,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',80,'female','L2Pet',40,'4858.00000','2317.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2059.00000','608.00000','1321.00000','570.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14277,14277,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',81,'female','L2Pet',40,'4898.00000','2342.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2093.00000','614.00000','1346.00000','575.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14278,14278,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',81,'female','L2Pet',40,'4938.00000','2367.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2128.00000','620.00000','1372.00000','580.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14279,14279,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',81,'female','L2Pet',40,'4979.00000','2393.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2163.00000','626.00000','1398.00000','585.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14280,14280,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',81,'female','L2Pet',40,'5020.00000','2419.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2199.00000','632.00000','1425.00000','590.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14281,14281,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',82,'female','L2Pet',40,'5061.00000','2445.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2235.00000','638.00000','1452.00000','595.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14282,14282,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',82,'female','L2Pet',40,'5103.00000','2471.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2272.00000','644.00000','1480.00000','600.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14283,14283,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',82,'female','L2Pet',40,'5145.00000','2498.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2310.00000','650.00000','1509.00000','605.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14284,14284,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',82,'female','L2Pet',40,'5187.00000','2525.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2348.00000','656.00000','1538.00000','610.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14285,14285,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',83,'female','L2Pet',40,'5230.00000','2552.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2387.00000','662.00000','1568.00000','615.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14286,14286,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',83,'female','L2Pet',40,'5273.00000','2580.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2426.00000','668.00000','1598.00000','620.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14287,14287,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',83,'female','L2Pet',40,'5316.00000','2608.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2466.00000','674.00000','1629.00000','625.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14288,14288,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',83,'female','L2Pet',40,'5360.00000','2636.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2507.00000','680.00000','1660.00000','630.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14289,14289,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',84,'female','L2Pet',40,'5404.00000','2665.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2548.00000','686.00000','1692.00000','636.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14290,14290,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',84,'female','L2Pet',40,'5448.00000','2694.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2590.00000','692.00000','1725.00000','642.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14291,14291,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',84,'female','L2Pet',40,'5493.00000','2723.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2633.00000','698.00000','1758.00000','648.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14292,14292,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',85,'female','L2Pet',40,'5538.00000','2753.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2677.00000','704.00000','1792.00000','654.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14293,14293,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',85,'female','L2Pet',40,'5584.00000','2783.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2721.00000','710.00000','1827.00000','660.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14294,14294,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8.00','15.00',85,'female','L2Pet',40,'5630.00000','2813.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2766.00000','717.00000','1862.00000','666.00000',278,4,0,333,0,0,0,26,170,1,1,0,0),
(14295,14295,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',22,'male','L2Pet',40,'984.00000','279.00000','3.50000','1.50000',40,43,30,21,20,25,0,0,'82.00000','102.00000','28.00000','95.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14296,14296,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',27,'male','L2Pet',40,'1310.00000','367.00000','3.50000','1.50000',40,43,30,21,20,25,0,0,'124.00000','125.00000','45.00000','117.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14297,14297,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',32,'male','L2Pet',40,'1700.00000','458.00000','4.50000','1.80000',40,43,30,21,20,25,0,0,'186.00000','151.00000','69.00000','140.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14298,14298,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',37,'male','L2Pet',40,'2155.00000','553.00000','4.50000','1.80000',40,43,30,21,20,25,0,0,'267.00000','181.00000','104.00000','169.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14299,14299,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',42,'male','L2Pet',40,'2673.00000','679.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'376.00000','236.00000','152.00000','221.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14300,14300,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',46,'male','L2Pet',40,'3128.00000','757.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'486.00000','270.00000','202.00000','252.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14301,14301,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',50,'male','L2Pet',40,'3614.00000','957.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'615.00000','305.00000','263.00000','285.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14302,14302,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',54,'male','L2Pet',40,'4125.00000','1102.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'768.00000','342.00000','339.00000','322.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14303,14303,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',58,'male','L2Pet',40,'4651.00000','1251.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'943.00000','383.00000','428.00000','360.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14304,14304,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',60,'male','L2Pet',40,'4917.00000','1327.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'1040.00000','404.00000','477.00000','379.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14305,14305,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',62,'male','L2Pet',40,'5183.00000','1404.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1142.00000','426.00000','531.00000','399.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14306,14306,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',64,'male','L2Pet',40,'5448.00000','1482.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1248.00000','449.00000','588.00000','420.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14307,14307,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',66,'male','L2Pet',40,'5710.00000','1561.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1357.00000','470.00000','649.00000','440.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14308,14308,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',68,'male','L2Pet',40,'5967.00000','1641.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1472.00000','493.00000','713.00000','462.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14309,14309,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',70,'male','L2Pet',40,'6218.00000','1722.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1588.00000','515.00000','779.00000','483.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14310,14310,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',72,'male','L2Pet',40,'6461.00000','1804.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1708.00000','540.00000','848.00000','505.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14311,14311,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',74,'male','L2Pet',40,'6695.00000','1888.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1829.00000','563.00000','920.00000','527.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14312,14312,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',76,'male','L2Pet',40,'6919.00000','1972.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1952.00000','586.00000','993.00000','548.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14313,14313,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',78,'male','L2Pet',40,'7150.00000','2059.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2083.00000','609.00000','1071.00000','569.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14314,14314,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',78,'male','L2Pet',40,'7209.00000','2081.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2117.00000','614.00000','1092.00000','574.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14315,14315,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',78,'male','L2Pet',40,'7269.00000','2103.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2152.00000','620.00000','1113.00000','579.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14316,14316,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',78,'male','L2Pet',40,'7329.00000','2126.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2188.00000','626.00000','1134.00000','584.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14317,14317,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',79,'male','L2Pet',40,'7390.00000','2149.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2224.00000','632.00000','1156.00000','589.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14318,14318,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',79,'male','L2Pet',40,'7451.00000','2172.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2261.00000','638.00000','1178.00000','594.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14319,14319,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',79,'male','L2Pet',40,'7513.00000','2195.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2298.00000','644.00000','1201.00000','599.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14320,14320,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',79,'male','L2Pet',40,'7575.00000','2219.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2336.00000','650.00000','1224.00000','604.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14321,14321,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',80,'male','L2Pet',40,'7638.00000','2243.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2375.00000','656.00000','1248.00000','609.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14322,14322,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',80,'male','L2Pet',40,'7701.00000','2267.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2414.00000','662.00000','1272.00000','614.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14323,14323,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',80,'male','L2Pet',40,'7765.00000','2292.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2454.00000','668.00000','1296.00000','619.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14324,14324,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',80,'male','L2Pet',40,'7829.00000','2317.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2495.00000','674.00000','1321.00000','624.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14325,14325,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',81,'male','L2Pet',40,'7894.00000','2342.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2536.00000','680.00000','1346.00000','629.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14326,14326,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',81,'male','L2Pet',40,'7959.00000','2367.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2578.00000','686.00000','1372.00000','635.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14327,14327,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',81,'male','L2Pet',40,'8025.00000','2393.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2621.00000','692.00000','1398.00000','641.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14328,14328,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',81,'male','L2Pet',40,'8091.00000','2419.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2664.00000','698.00000','1425.00000','647.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14329,14329,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',82,'male','L2Pet',40,'8158.00000','2445.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2708.00000','704.00000','1452.00000','653.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14330,14330,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',82,'male','L2Pet',40,'8226.00000','2471.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2753.00000','710.00000','1480.00000','659.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14331,14331,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',82,'male','L2Pet',40,'8294.00000','2498.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2799.00000','716.00000','1509.00000','665.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14332,14332,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',82,'male','L2Pet',40,'8363.00000','2525.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2845.00000','723.00000','1538.00000','671.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14333,14333,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',83,'male','L2Pet',40,'8432.00000','2552.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2892.00000','730.00000','1568.00000','677.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14334,14334,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',83,'male','L2Pet',40,'8502.00000','2580.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2940.00000','737.00000','1598.00000','683.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14335,14335,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',83,'male','L2Pet',40,'8572.00000','2608.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2989.00000','744.00000','1629.00000','689.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14336,14336,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',83,'male','L2Pet',40,'8643.00000','2636.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3039.00000','751.00000','1660.00000','695.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14337,14337,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',84,'male','L2Pet',40,'8715.00000','2665.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3089.00000','758.00000','1692.00000','701.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14338,14338,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',84,'male','L2Pet',40,'8787.00000','2694.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3140.00000','765.00000','1725.00000','707.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14339,14339,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',84,'male','L2Pet',40,'8860.00000','2723.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3192.00000','772.00000','1758.00000','713.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14340,14340,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',85,'male','L2Pet',40,'8933.00000','2753.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3245.00000','779.00000','1792.00000','719.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14341,14341,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',85,'male','L2Pet',40,'9007.00000','2783.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3299.00000','786.00000','1827.00000','725.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14342,14342,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11.00','18.00',85,'male','L2Pet',40,'9082.00000','2813.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3354.00000','793.00000','1862.00000','731.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14343,14343,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',22,'male','L2Pet',40,'984.00000','279.00000','3.50000','1.50000',40,43,30,21,20,25,0,0,'74.00000','102.00000','34.00000','95.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14344,14344,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',27,'male','L2Pet',40,'1310.00000','367.00000','3.50000','1.50000',40,43,30,21,20,25,0,0,'113.00000','125.00000','54.00000','117.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14345,14345,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',32,'male','L2Pet',40,'1700.00000','458.00000','4.50000','1.80000',40,43,30,21,20,25,0,0,'169.00000','151.00000','83.00000','140.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14346,14346,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',37,'male','L2Pet',40,'2155.00000','553.00000','4.50000','1.80000',40,43,30,21,20,25,0,0,'242.00000','181.00000','126.00000','169.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14347,14347,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',42,'male','L2Pet',40,'2673.00000','679.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'342.00000','236.00000','183.00000','221.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14348,14348,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',46,'male','L2Pet',40,'3128.00000','816.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'441.00000','270.00000','244.00000','252.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14349,14349,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',50,'male','L2Pet',40,'3614.00000','957.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'559.00000','305.00000','319.00000','285.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14350,14350,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',54,'male','L2Pet',40,'4125.00000','1102.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'698.00000','342.00000','410.00000','322.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14351,14351,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',58,'male','L2Pet',40,'4651.00000','1251.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'857.00000','383.00000','518.00000','360.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14352,14352,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',60,'male','L2Pet',40,'4917.00000','1327.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'946.00000','404.00000','578.00000','379.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14353,14353,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',62,'male','L2Pet',40,'5813.00000','1404.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1038.00000','426.00000','642.00000','399.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14354,14354,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',64,'male','L2Pet',40,'5448.00000','1482.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1134.00000','449.00000','711.00000','420.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14355,14355,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',66,'male','L2Pet',40,'5710.00000','1561.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1231.00000','470.00000','785.00000','440.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14356,14356,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',68,'male','L2Pet',40,'5967.00000','1641.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1338.00000','493.00000','862.00000','462.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14357,14357,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',70,'male','L2Pet',40,'6218.00000','1722.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1443.00000','515.00000','943.00000','483.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14358,14358,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',72,'male','L2Pet',40,'6461.00000','1804.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1553.00000','540.00000','1026.00000','505.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14359,14359,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',74,'male','L2Pet',40,'6695.00000','1888.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1663.00000','563.00000','1113.00000','527.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14360,14360,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',76,'male','L2Pet',40,'6919.00000','1972.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1775.00000','586.00000','1201.00000','548.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14361,14361,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',78,'male','L2Pet',40,'7150.00000','2059.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1894.00000','609.00000','1295.00000','569.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14362,14362,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',78,'male','L2Pet',40,'7209.00000','2081.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1925.00000','614.00000','1320.00000','574.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14363,14363,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',78,'male','L2Pet',40,'7269.00000','2103.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1957.00000','620.00000','1345.00000','579.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14364,14364,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',78,'male','L2Pet',40,'7329.00000','2126.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1989.00000','626.00000','1371.00000','584.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14365,14365,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',79,'male','L2Pet',40,'7390.00000','2149.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2022.00000','632.00000','1397.00000','589.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14366,14366,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',79,'male','L2Pet',40,'7451.00000','2172.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2055.00000','638.00000','1424.00000','594.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14367,14367,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',79,'male','L2Pet',40,'7513.00000','2195.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2089.00000','644.00000','1451.00000','599.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14368,14368,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',79,'male','L2Pet',40,'7575.00000','2219.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2124.00000','650.00000','1479.00000','604.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14369,14369,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',80,'male','L2Pet',40,'7638.00000','2243.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2159.00000','656.00000','1507.00000','609.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14370,14370,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',80,'male','L2Pet',40,'7701.00000','2267.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2195.00000','662.00000','1536.00000','614.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14371,14371,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',80,'male','L2Pet',40,'7765.00000','2292.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2231.00000','668.00000','1566.00000','619.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14372,14372,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',80,'male','L2Pet',40,'7829.00000','2317.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2268.00000','674.00000','1596.00000','624.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14373,14373,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',81,'male','L2Pet',40,'7894.00000','2342.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2306.00000','680.00000','1627.00000','629.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14374,14374,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',81,'male','L2Pet',40,'7959.00000','2367.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2344.00000','686.00000','1658.00000','635.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14375,14375,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',81,'male','L2Pet',40,'8025.00000','2393.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2383.00000','692.00000','1690.00000','641.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14376,14376,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',81,'male','L2Pet',40,'8091.00000','2419.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2422.00000','698.00000','1723.00000','647.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14377,14377,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',82,'male','L2Pet',40,'8158.00000','2445.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2462.00000','704.00000','1756.00000','653.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14378,14378,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',82,'male','L2Pet',40,'8226.00000','2471.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2503.00000','710.00000','1790.00000','659.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14379,14379,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',82,'male','L2Pet',40,'8294.00000','2498.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2544.00000','716.00000','1825.00000','665.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14380,14380,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',82,'male','L2Pet',40,'8363.00000','2525.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2586.00000','723.00000','1860.00000','671.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14381,14381,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',83,'male','L2Pet',40,'8432.00000','2552.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2629.00000','730.00000','1896.00000','677.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14382,14382,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',83,'male','L2Pet',40,'8502.00000','2580.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2673.00000','737.00000','1933.00000','683.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14383,14383,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',83,'male','L2Pet',40,'8572.00000','2608.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2717.00000','744.00000','1970.00000','689.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14384,14384,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',83,'male','L2Pet',40,'8643.00000','2636.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2762.00000','751.00000','2008.00000','695.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14385,14385,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',84,'male','L2Pet',40,'8715.00000','2665.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2808.00000','758.00000','2047.00000','701.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14386,14386,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',84,'male','L2Pet',40,'8787.00000','2694.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2855.00000','765.00000','2087.00000','707.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14387,14387,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',84,'male','L2Pet',40,'8860.00000','2723.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2902.00000','772.00000','2127.00000','713.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14388,14388,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',85,'male','L2Pet',40,'8933.00000','2753.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2950.00000','779.00000','2168.00000','719.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14389,14389,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',85,'male','L2Pet',40,'9007.00000','2783.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2999.00000','786.00000','2210.00000','725.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14390,14390,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13.00','17.50',85,'male','L2Pet',40,'9082.00000','2813.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3049.00000','793.00000','2253.00000','731.00000',278,4,0,333,0,0,0,27,140,1,1,0,0),
(14391,14391,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',42,'male','L2Pet',40,'2008.00000','637.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'376.00000','236.00000','221.00000','221.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14392,14392,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',46,'male','L2Pet',40,'2351.00000','816.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'486.00000','270.00000','295.00000','252.00000',278,4,0,467,0,0,0,48,180,1,1,0,0),
(14393,14393,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',50,'male','L2Pet',40,'2716.00000','957.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'615.00000','305.00000','384.00000','285.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14394,14394,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',54,'male','L2Pet',40,'3100.00000','1102.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'768.00000','342.00000','495.00000','322.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14395,14395,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',58,'male','L2Pet',40,'3496.00000','1251.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'943.00000','383.00000','625.00000','360.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14396,14396,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',60,'male','L2Pet',40,'3695.00000','1327.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'1040.00000','404.00000','697.00000','379.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14397,14397,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',62,'male','L2Pet',40,'3895.00000','1404.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1142.00000','426.00000','775.00000','399.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14398,14398,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',64,'male','L2Pet',40,'4094.00000','1482.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1248.00000','449.00000','858.00000','420.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14399,14399,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',66,'male','L2Pet',40,'4291.00000','1561.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1356.00000','470.00000','947.00000','440.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14400,14400,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',68,'male','L2Pet',40,'4484.00000','1641.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1472.00000','493.00000','1041.00000','462.00000',278,4,0,432,0,0,0,48,180,1,1,0,0),
(14401,14401,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',70,'male','L2Pet',40,'4673.00000','1722.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1587.00000','515.00000','1137.00000','483.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14402,14402,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',72,'male','L2Pet',40,'4856.00000','1804.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1708.00000','540.00000','1238.00000','505.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14403,14403,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',74,'male','L2Pet',40,'5032.00000','1888.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1828.00000','563.00000','1343.00000','527.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14404,14404,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',76,'male','L2Pet',40,'5200.00000','1972.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1952.00000','586.00000','1449.00000','548.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14405,14405,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',78,'male','L2Pet',40,'5373.00000','2059.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2084.00000','609.00000','1564.00000','569.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14406,14406,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',78,'male','L2Pet',40,'5417.00000','2081.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2119.00000','614.00000','1594.00000','574.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14407,14407,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',78,'male','L2Pet',40,'5462.00000','2103.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2154.00000','620.00000','1625.00000','579.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14408,14408,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',78,'male','L2Pet',40,'5507.00000','2126.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2190.00000','626.00000','1656.00000','584.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14409,14409,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',79,'male','L2Pet',40,'5552.00000','2149.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2226.00000','632.00000','1688.00000','589.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14410,14410,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',79,'male','L2Pet',40,'5598.00000','2172.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2263.00000','638.00000','1721.00000','594.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14411,14411,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',79,'male','L2Pet',40,'5644.00000','2195.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2301.00000','644.00000','1754.00000','599.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14412,14412,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',79,'male','L2Pet',40,'5690.00000','2219.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2339.00000','650.00000','1788.00000','604.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14413,14413,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',80,'male','L2Pet',40,'5737.00000','2243.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2378.00000','656.00000','1823.00000','609.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14414,14414,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',80,'male','L2Pet',40,'5784.00000','2267.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2418.00000','662.00000','1858.00000','614.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14415,14415,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',80,'male','L2Pet',40,'5832.00000','2292.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2458.00000','668.00000','1894.00000','619.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14416,14416,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',80,'male','L2Pet',40,'5880.00000','2317.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2499.00000','674.00000','1931.00000','624.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14417,14417,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',81,'male','L2Pet',40,'5928.00000','2342.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2541.00000','680.00000','1969.00000','629.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14418,14418,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',81,'male','L2Pet',40,'5977.00000','2367.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2583.00000','686.00000','2007.00000','635.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14419,14419,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',81,'male','L2Pet',40,'6026.00000','2393.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2626.00000','692.00000','2046.00000','641.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14420,14420,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',81,'male','L2Pet',40,'6076.00000','2419.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2670.00000','698.00000','2086.00000','647.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14421,14421,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',82,'male','L2Pet',40,'6126.00000','2445.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2715.00000','704.00000','2127.00000','653.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14422,14422,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',82,'male','L2Pet',40,'6176.00000','2471.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2760.00000','710.00000','2168.00000','659.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14423,14423,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',82,'male','L2Pet',40,'6227.00000','2498.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2806.00000','716.00000','2210.00000','665.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14424,14424,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',82,'male','L2Pet',40,'6278.00000','2525.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2853.00000','723.00000','2253.00000','671.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14425,14425,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',83,'male','L2Pet',40,'6330.00000','2552.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2901.00000','730.00000','2297.00000','677.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14426,14426,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',83,'male','L2Pet',40,'6382.00000','2580.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2949.00000','737.00000','2342.00000','683.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14427,14427,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',83,'male','L2Pet',40,'6435.00000','2608.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2998.00000','744.00000','2388.00000','689.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14428,14428,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',83,'male','L2Pet',40,'6488.00000','2636.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3048.00000','751.00000','2435.00000','695.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14429,14429,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',84,'male','L2Pet',40,'6541.00000','2665.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3099.00000','758.00000','2482.00000','701.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14430,14430,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',84,'male','L2Pet',40,'6595.00000','2694.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3151.00000','765.00000','2530.00000','707.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14431,14431,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',84,'male','L2Pet',40,'6649.00000','2723.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3204.00000','772.00000','2579.00000','713.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14432,14432,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',85,'male','L2Pet',40,'6704.00000','2753.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3258.00000','779.00000','2629.00000','719.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14433,14433,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',85,'male','L2Pet',40,'6759.00000','2783.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3312.00000','786.00000','2680.00000','725.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14434,14434,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11.00','16.00',85,'male','L2Pet',40,'6815.00000','2813.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3367.00000','793.00000','2732.00000','731.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14435,14435,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',58,'male','L2Pet',40,'2889.00000','1251.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'779.00000','348.00000','428.00000','327.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14436,14436,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',60,'male','L2Pet',40,'3054.00000','1327.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'860.00000','368.00000','477.00000','345.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14437,14437,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',62,'male','L2Pet',40,'3219.00000','1404.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'944.00000','388.00000','531.00000','363.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14438,14438,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',64,'male','L2Pet',40,'3384.00000','1482.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1031.00000','408.00000','588.00000','381.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14439,14439,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',66,'male','L2Pet',40,'3546.00000','1561.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1121.00000','427.00000','649.00000','400.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14440,14440,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',68,'male','L2Pet',40,'3706.00000','1641.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1217.00000','449.00000','713.00000','420.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14441,14441,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',70,'male','L2Pet',40,'3862.00000','1722.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1312.00000','469.00000','779.00000','439.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14442,14442,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',72,'male','L2Pet',40,'4013.00000','1804.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1412.00000','491.00000','848.00000','459.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14443,14443,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',74,'male','L2Pet',40,'4158.00000','1888.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1511.00000','511.00000','920.00000','479.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14444,14444,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',76,'male','L2Pet',40,'4297.00000','1972.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1613.00000','532.00000','993.00000','498.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14449,14449,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',78,'male','L2Pet',40,'4440.00000','2059.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1721.00000','553.00000','1071.00000','517.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14450,14450,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',78,'male','L2Pet',40,'4476.00000','2081.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1749.00000','558.00000','1092.00000','521.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14451,14451,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',78,'male','L2Pet',40,'4513.00000','2103.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1778.00000','563.00000','1113.00000','525.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14452,14452,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',78,'male','L2Pet',40,'4550.00000','2126.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1807.00000','568.00000','1134.00000','530.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14453,14453,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',79,'male','L2Pet',40,'4587.00000','2149.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1837.00000','573.00000','1156.00000','535.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14454,14454,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',79,'male','L2Pet',40,'4625.00000','2172.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1867.00000','578.00000','1178.00000','540.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14455,14455,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',79,'male','L2Pet',40,'4663.00000','2195.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1898.00000','583.00000','1201.00000','545.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14456,14456,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',79,'male','L2Pet',40,'4701.00000','2219.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1929.00000','588.00000','1224.00000','550.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14457,14457,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',80,'male','L2Pet',40,'4740.00000','2243.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1961.00000','593.00000','1248.00000','555.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14458,14458,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',80,'male','L2Pet',40,'4779.00000','2267.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1993.00000','598.00000','1272.00000','560.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14459,14459,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',80,'male','L2Pet',40,'4818.00000','2292.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2026.00000','603.00000','1296.00000','565.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14460,14460,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',80,'male','L2Pet',40,'4858.00000','2317.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2059.00000','608.00000','1321.00000','570.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14461,14461,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',81,'male','L2Pet',40,'4898.00000','2342.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2093.00000','614.00000','1346.00000','575.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14462,14462,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',81,'male','L2Pet',40,'4938.00000','2367.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2128.00000','620.00000','1372.00000','580.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14463,14463,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',81,'male','L2Pet',40,'4979.00000','2393.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2163.00000','626.00000','1398.00000','585.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14464,14464,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',81,'male','L2Pet',40,'5020.00000','2419.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2199.00000','632.00000','1425.00000','590.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14465,14465,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',82,'male','L2Pet',40,'5061.00000','2445.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2235.00000','638.00000','1452.00000','595.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14466,14466,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',82,'male','L2Pet',40,'5103.00000','2471.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2272.00000','644.00000','1480.00000','600.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14467,14467,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',82,'male','L2Pet',40,'5145.00000','2498.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2310.00000','650.00000','1509.00000','605.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14468,14468,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',82,'male','L2Pet',40,'5187.00000','2525.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2348.00000','656.00000','1538.00000','610.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14469,14469,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',83,'male','L2Pet',40,'5230.00000','2552.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2387.00000','662.00000','1568.00000','615.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14470,14470,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',83,'male','L2Pet',40,'5273.00000','2580.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2426.00000','668.00000','1598.00000','620.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14471,14471,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',83,'male','L2Pet',40,'5316.00000','2608.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2466.00000','674.00000','1629.00000','625.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14472,14472,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',83,'male','L2Pet',40,'5360.00000','2636.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2507.00000','680.00000','1660.00000','630.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14473,14473,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',84,'male','L2Pet',40,'5404.00000','2665.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2548.00000','686.00000','1692.00000','636.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14474,14474,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',84,'male','L2Pet',40,'5448.00000','2694.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2590.00000','692.00000','1725.00000','642.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14475,14475,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',84,'male','L2Pet',40,'5493.00000','2723.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2633.00000','698.00000','1758.00000','648.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14476,14476,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',85,'male','L2Pet',40,'5538.00000','2753.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2677.00000','704.00000','1792.00000','654.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14477,14477,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',85,'male','L2Pet',40,'5584.00000','2783.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2721.00000','710.00000','1827.00000','660.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14478,14478,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9.00','25.50',85,'male','L2Pet',40,'5630.00000','2813.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2766.00000','717.00000','1862.00000','666.00000',278,4,0,333,0,0,0,27,160,1,1,0,0),
(14479,14479,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',22,'male','L2Pet',40,'984.00000','279.00000','3.50000','1.50000',40,43,30,21,20,25,0,0,'82.00000','102.00000','28.00000','95.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14480,14480,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',27,'male','L2Pet',40,'1310.00000','367.00000','3.50000','1.50000',40,43,30,21,20,25,0,0,'124.00000','125.00000','45.00000','117.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14481,14481,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',32,'male','L2Pet',40,'1700.00000','458.00000','4.50000','1.80000',40,43,30,21,20,25,0,0,'186.00000','151.00000','69.00000','140.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14482,14482,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',37,'male','L2Pet',40,'2155.00000','533.00000','4.50000','1.80000',40,43,30,21,20,25,0,0,'267.00000','181.00000','104.00000','169.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14483,14483,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',42,'male','L2Pet',40,'2673.00000','679.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'376.00000','236.00000','152.00000','221.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14484,14484,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',46,'male','L2Pet',40,'3128.00000','816.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'486.00000','270.00000','202.00000','252.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14485,14485,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',50,'male','L2Pet',40,'3614.00000','957.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'615.00000','305.00000','263.00000','285.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14486,14486,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',54,'male','L2Pet',40,'4125.00000','1102.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'768.00000','342.00000','339.00000','322.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14487,14487,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',58,'male','L2Pet',40,'4651.00000','1251.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'943.00000','383.00000','428.00000','360.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14488,14488,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',60,'male','L2Pet',40,'4917.00000','1327.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'1040.00000','404.00000','477.00000','379.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14489,14489,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',62,'male','L2Pet',40,'5183.00000','1404.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1142.00000','426.00000','531.00000','399.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14490,14490,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',64,'male','L2Pet',40,'5448.00000','1482.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1248.00000','449.00000','588.00000','420.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14491,14491,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',66,'male','L2Pet',40,'5710.00000','1561.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1357.00000','470.00000','649.00000','440.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14492,14492,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',68,'male','L2Pet',40,'5967.00000','1641.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1472.00000','493.00000','713.00000','462.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14493,14493,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',70,'male','L2Pet',40,'6218.00000','1722.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1588.00000','515.00000','779.00000','483.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14494,14494,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',72,'male','L2Pet',40,'6461.00000','1804.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1708.00000','540.00000','848.00000','505.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14495,14495,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',74,'male','L2Pet',40,'6695.00000','1888.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1829.00000','563.00000','920.00000','527.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14496,14496,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',76,'male','L2Pet',40,'6919.00000','1972.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1952.00000','586.00000','993.00000','548.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14497,14497,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',78,'male','L2Pet',40,'7150.00000','2059.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2083.00000','609.00000','1071.00000','569.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14498,14498,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',78,'male','L2Pet',40,'7209.00000','2081.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2117.00000','614.00000','1092.00000','574.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14499,14499,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',78,'male','L2Pet',40,'7269.00000','2103.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2152.00000','620.00000','1113.00000','579.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14500,14500,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',78,'male','L2Pet',40,'7329.00000','2126.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2188.00000','626.00000','1134.00000','584.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14501,14501,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',79,'male','L2Pet',40,'7390.00000','2149.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2224.00000','632.00000','1156.00000','589.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14502,14502,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',79,'male','L2Pet',40,'7451.00000','2172.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2261.00000','638.00000','1178.00000','594.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14503,14503,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',79,'male','L2Pet',40,'7513.00000','2195.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2298.00000','644.00000','1201.00000','599.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14504,14504,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',79,'male','L2Pet',40,'7575.00000','2219.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2336.00000','650.00000','1224.00000','604.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14505,14505,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',80,'male','L2Pet',40,'7638.00000','2243.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2375.00000','656.00000','1248.00000','609.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14506,14506,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',80,'male','L2Pet',40,'7701.00000','2267.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2414.00000','662.00000','1272.00000','614.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14507,14507,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',80,'male','L2Pet',40,'7765.00000','2292.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2454.00000','668.00000','1296.00000','619.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14508,14508,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',80,'male','L2Pet',40,'7829.00000','2317.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2495.00000','674.00000','1321.00000','624.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14509,14509,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',81,'male','L2Pet',40,'7894.00000','2342.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2536.00000','680.00000','1346.00000','629.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14510,14510,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',81,'male','L2Pet',40,'7959.00000','2367.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2578.00000','686.00000','1372.00000','635.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14511,14511,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',81,'male','L2Pet',40,'8025.00000','2393.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2621.00000','692.00000','1398.00000','641.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14512,14512,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',81,'male','L2Pet',40,'8091.00000','2419.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2664.00000','698.00000','1425.00000','647.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14513,14513,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',82,'male','L2Pet',40,'8158.00000','2445.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2708.00000','704.00000','1452.00000','653.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14514,14514,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',82,'male','L2Pet',40,'8226.00000','2471.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2753.00000','710.00000','1480.00000','659.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14515,14515,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',82,'male','L2Pet',40,'8294.00000','2498.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2799.00000','716.00000','1509.00000','665.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14516,14516,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',82,'male','L2Pet',40,'8363.00000','2525.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2845.00000','723.00000','1538.00000','671.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14517,14517,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',83,'male','L2Pet',40,'8432.00000','2552.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2892.00000','730.00000','1568.00000','677.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14518,14518,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',83,'male','L2Pet',40,'8502.00000','2580.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2940.00000','737.00000','1598.00000','683.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14519,14519,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',83,'male','L2Pet',40,'8572.00000','2608.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2989.00000','744.00000','1629.00000','689.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14520,14520,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',83,'male','L2Pet',40,'8643.00000','2636.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3039.00000','751.00000','1660.00000','695.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14521,14521,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',84,'male','L2Pet',40,'8715.00000','2665.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3089.00000','758.00000','1692.00000','701.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14522,14522,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',84,'male','L2Pet',40,'8787.00000','2694.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3140.00000','765.00000','1725.00000','707.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14523,14523,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',84,'male','L2Pet',40,'8860.00000','2723.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3192.00000','772.00000','1758.00000','713.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14524,14524,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',85,'male','L2Pet',40,'8933.00000','2753.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3245.00000','779.00000','1792.00000','719.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14525,14525,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',85,'male','L2Pet',40,'9007.00000','2783.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3299.00000','786.00000','1827.00000','725.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14526,14526,'Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',85,'male','L2Pet',40,'9082.00000','2813.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3354.00000','793.00000','1862.00000','731.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14527,14527,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',22,'female','L2Pet',40,'984.00000','279.00000','3.50000','1.50000',40,43,30,21,20,25,0,0,'74.00000','102.00000','34.00000','95.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14528,14528,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',27,'female','L2Pet',40,'1310.00000','367.00000','3.50000','1.50000',40,43,30,21,20,25,0,0,'113.00000','125.00000','54.00000','117.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14529,14529,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',32,'female','L2Pet',40,'1700.00000','458.00000','4.50000','1.80000',40,43,30,21,20,25,0,0,'169.00000','151.00000','83.00000','140.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14530,14530,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',37,'female','L2Pet',40,'2155.00000','553.00000','4.50000','1.80000',40,43,30,21,20,25,0,0,'242.00000','181.00000','126.00000','169.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14531,14531,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',42,'female','L2Pet',40,'2673.00000','679.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'342.00000','236.00000','183.00000','221.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14532,14532,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',46,'female','L2Pet',40,'3128.00000','816.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'441.00000','270.00000','244.00000','252.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14533,14533,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',50,'female','L2Pet',40,'3614.00000','957.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'559.00000','305.00000','319.00000','285.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14534,14534,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',54,'female','L2Pet',40,'4125.00000','1102.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'698.00000','342.00000','410.00000','322.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14535,14535,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',58,'female','L2Pet',40,'4651.00000','1251.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'857.00000','383.00000','518.00000','360.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14536,14536,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',60,'female','L2Pet',40,'4917.00000','1327.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'946.00000','404.00000','578.00000','379.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14537,14537,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',62,'female','L2Pet',40,'5183.00000','1404.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1038.00000','426.00000','642.00000','399.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14538,14538,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',64,'female','L2Pet',40,'5448.00000','1482.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1135.00000','449.00000','711.00000','420.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14539,14539,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',66,'female','L2Pet',40,'5710.00000','1561.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1233.00000','470.00000','785.00000','440.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14540,14540,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',68,'female','L2Pet',40,'5967.00000','1641.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1338.00000','493.00000','862.00000','462.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14541,14541,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',70,'female','L2Pet',40,'6218.00000','1722.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1443.00000','515.00000','943.00000','483.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14542,14542,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',72,'female','L2Pet',40,'6461.00000','1804.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1553.00000','540.00000','1026.00000','505.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14543,14543,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',74,'female','L2Pet',40,'6695.00000','1888.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1663.00000','563.00000','1113.00000','527.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14544,14544,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',76,'female','L2Pet',40,'6919.00000','1972.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1775.00000','586.00000','1201.00000','548.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14545,14545,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',78,'female','L2Pet',40,'7150.00000','2059.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1894.00000','609.00000','1295.00000','569.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14546,14546,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',78,'female','L2Pet',40,'7209.00000','2081.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1925.00000','614.00000','1320.00000','574.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14547,14547,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',78,'female','L2Pet',40,'7269.00000','2103.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1957.00000','620.00000','1345.00000','579.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14548,14548,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',78,'female','L2Pet',40,'7329.00000','2126.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1989.00000','626.00000','1371.00000','584.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14549,14549,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',79,'female','L2Pet',40,'7390.00000','2149.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2022.00000','632.00000','1397.00000','589.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14550,14550,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',79,'female','L2Pet',40,'7451.00000','2172.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2055.00000','638.00000','1424.00000','594.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14551,14551,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',79,'female','L2Pet',40,'7513.00000','2195.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2089.00000','644.00000','1451.00000','599.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14552,14552,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',79,'female','L2Pet',40,'7575.00000','2219.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2124.00000','650.00000','1479.00000','604.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14553,14553,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',80,'female','L2Pet',40,'7638.00000','2243.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2159.00000','656.00000','1507.00000','609.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14554,14554,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',80,'female','L2Pet',40,'7701.00000','2267.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2195.00000','662.00000','1536.00000','614.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14555,14555,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',80,'female','L2Pet',40,'7765.00000','2292.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2231.00000','668.00000','1566.00000','619.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14556,14556,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',80,'female','L2Pet',40,'7829.00000','2317.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2268.00000','674.00000','1596.00000','624.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14557,14557,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',81,'female','L2Pet',40,'7894.00000','2342.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2306.00000','680.00000','1627.00000','629.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14558,14558,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',81,'female','L2Pet',40,'7959.00000','2367.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2344.00000','686.00000','1658.00000','635.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14559,14559,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',81,'female','L2Pet',40,'8025.00000','2393.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2383.00000','692.00000','1690.00000','641.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14560,14560,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',81,'female','L2Pet',40,'8091.00000','2419.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2422.00000','698.00000','1723.00000','647.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14561,14561,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',82,'female','L2Pet',40,'8158.00000','2445.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2462.00000','704.00000','1756.00000','653.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14562,14562,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',82,'female','L2Pet',40,'8226.00000','2471.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2503.00000','710.00000','1790.00000','659.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14563,14563,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',82,'female','L2Pet',40,'8294.00000','2498.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2544.00000','716.00000','1825.00000','665.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14564,14564,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',82,'female','L2Pet',40,'8363.00000','2525.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2586.00000','723.00000','1860.00000','671.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14565,14565,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',83,'female','L2Pet',40,'8432.00000','2552.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2629.00000','730.00000','1896.00000','677.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14566,14566,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',83,'female','L2Pet',40,'8502.00000','2580.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2673.00000','737.00000','1933.00000','683.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14567,14567,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',83,'female','L2Pet',40,'8572.00000','2608.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2717.00000','744.00000','1970.00000','689.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14568,14568,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',83,'female','L2Pet',40,'8643.00000','2636.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2762.00000','751.00000','2008.00000','695.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14569,14569,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',84,'female','L2Pet',40,'8715.00000','2665.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2808.00000','758.00000','2047.00000','701.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14570,14570,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',84,'female','L2Pet',40,'8787.00000','2694.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2855.00000','765.00000','2087.00000','707.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14571,14571,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',84,'female','L2Pet',40,'8860.00000','2723.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2902.00000','772.00000','2127.00000','713.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14572,14572,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',85,'female','L2Pet',40,'8933.00000','2753.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2950.00000','779.00000','2168.00000','719.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14573,14573,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',85,'female','L2Pet',40,'9007.00000','2783.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2999.00000','786.00000','2210.00000','725.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14574,14574,'Silhouette',0,'',0,'LineageMonster.silhouette','8.00','23.00',85,'female','L2Pet',40,'9082.00000','2813.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3049.00000','793.00000','2253.00000','731.00000',278,4,0,333,0,0,0,80,140,1,1,0,0),
(14575,14575,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',42,'male','L2Pet',40,'2008.00000','679.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'376.00000','236.00000','221.00000','221.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14576,14576,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',46,'male','L2Pet',40,'2351.00000','816.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'486.00000','270.00000','295.00000','252.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14577,14577,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',50,'male','L2Pet',40,'2716.00000','957.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'615.00000','305.00000','384.00000','285.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14578,14578,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',54,'male','L2Pet',40,'3100.00000','1102.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'768.00000','342.00000','495.00000','322.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14579,14579,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',58,'male','L2Pet',40,'3496.00000','1251.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'943.00000','383.00000','625.00000','360.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14580,14580,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',60,'male','L2Pet',40,'3695.00000','1327.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'1040.00000','404.00000','697.00000','379.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14581,14581,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',62,'male','L2Pet',40,'3895.00000','1404.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1142.00000','426.00000','775.00000','399.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14582,14582,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',64,'male','L2Pet',40,'4094.00000','1482.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1248.00000','449.00000','858.00000','420.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14583,14583,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',66,'male','L2Pet',40,'4291.00000','1561.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1357.00000','470.00000','948.00000','440.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14584,14584,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',68,'male','L2Pet',40,'4484.00000','1641.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1472.00000','493.00000','1041.00000','462.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14585,14585,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',70,'male','L2Pet',40,'4673.00000','1722.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1588.00000','515.00000','1138.00000','483.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14586,14586,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',72,'male','L2Pet',40,'4856.00000','1804.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1709.00000','540.00000','1238.00000','505.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14587,14587,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',74,'male','L2Pet',40,'5032.00000','1888.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1829.00000','563.00000','1343.00000','527.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14588,14588,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',76,'male','L2Pet',40,'5200.00000','1972.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1952.00000','586.00000','1450.00000','548.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14589,14589,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',78,'male','L2Pet',40,'5373.00000','2059.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2085.00000','609.00000','1565.00000','569.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14590,14590,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',78,'male','L2Pet',40,'5417.00000','2081.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2120.00000','614.00000','1595.00000','574.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14591,14591,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',78,'male','L2Pet',40,'5462.00000','2103.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2155.00000','620.00000','1626.00000','579.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14592,14592,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',78,'male','L2Pet',40,'5507.00000','2126.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2191.00000','626.00000','1658.00000','584.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14593,14593,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',79,'male','L2Pet',40,'5552.00000','2149.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2228.00000','632.00000','1690.00000','589.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14594,14594,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',79,'male','L2Pet',40,'5598.00000','2172.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2265.00000','638.00000','1723.00000','594.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14595,14595,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',79,'male','L2Pet',40,'5644.00000','2195.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2303.00000','644.00000','1756.00000','599.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14596,14596,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',79,'male','L2Pet',40,'5690.00000','2219.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2341.00000','650.00000','1790.00000','604.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14597,14597,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',80,'male','L2Pet',40,'5737.00000','2243.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2380.00000','656.00000','1825.00000','609.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14598,14598,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',80,'male','L2Pet',40,'5784.00000','2267.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2420.00000','662.00000','1860.00000','614.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14599,14599,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',80,'male','L2Pet',40,'5832.00000','2292.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2460.00000','668.00000','1896.00000','619.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14600,14600,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',80,'male','L2Pet',40,'5880.00000','2317.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2501.00000','674.00000','1933.00000','624.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14601,14601,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',81,'male','L2Pet',40,'5928.00000','2342.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2543.00000','680.00000','1971.00000','629.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14602,14602,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',81,'male','L2Pet',40,'5977.00000','2367.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2585.00000','686.00000','2009.00000','635.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14603,14603,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',81,'male','L2Pet',40,'6026.00000','2393.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2628.00000','692.00000','2048.00000','641.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14604,14604,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',81,'male','L2Pet',40,'6076.00000','2419.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2672.00000','698.00000','2088.00000','647.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14605,14605,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',82,'male','L2Pet',40,'6126.00000','2445.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2717.00000','704.00000','2129.00000','653.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14606,14606,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',82,'male','L2Pet',40,'6176.00000','2471.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2762.00000','710.00000','2170.00000','659.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14607,14607,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',82,'male','L2Pet',40,'6227.00000','2498.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2808.00000','716.00000','2212.00000','665.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14608,14608,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',82,'male','L2Pet',40,'6278.00000','2525.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2855.00000','723.00000','2255.00000','671.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14609,14609,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',83,'male','L2Pet',40,'6330.00000','2552.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2903.00000','730.00000','2299.00000','677.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14610,14610,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',83,'male','L2Pet',40,'6382.00000','2580.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2952.00000','737.00000','2344.00000','683.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14611,14611,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',83,'male','L2Pet',40,'6435.00000','2608.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3001.00000','744.00000','2390.00000','689.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14612,14612,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',83,'male','L2Pet',40,'6488.00000','2636.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3051.00000','751.00000','2437.00000','695.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14613,14613,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',84,'male','L2Pet',40,'6541.00000','2665.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3102.00000','758.00000','2485.00000','701.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14614,14614,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',84,'male','L2Pet',40,'6595.00000','2694.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3154.00000','765.00000','2533.00000','707.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14615,14615,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',84,'male','L2Pet',40,'6649.00000','2723.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3207.00000','772.00000','2582.00000','713.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14616,14616,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',85,'male','L2Pet',40,'6704.00000','2753.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3261.00000','779.00000','2632.00000','719.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14617,14617,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',85,'male','L2Pet',40,'6759.00000','2783.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3316.00000','786.00000','2683.00000','725.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14618,14618,'Soulless',0,'',0,'LineageMonster.shadeless','7.00','33.00',85,'male','L2Pet',40,'6815.00000','2813.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3372.00000','793.00000','2735.00000','731.00000',278,4,0,333,0,0,0,48,180,1,1,0,0),
(14619,14619,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',58,'male','L2Pet',40,'5778.00000','1251.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'779.00000','560.00000','428.00000','527.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14620,14620,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',60,'male','L2Pet',40,'6109.00000','1327.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'860.00000','592.00000','477.00000','555.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14621,14621,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',62,'male','L2Pet',40,'6439.00000','1404.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'944.00000','624.00000','531.00000','585.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14622,14622,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',64,'male','L2Pet',40,'6768.00000','1482.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1031.00000','657.00000','588.00000','614.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14623,14623,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',66,'male','L2Pet',40,'7093.00000','1561.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1121.00000','688.00000','649.00000','645.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14624,14624,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',68,'male','L2Pet',40,'7412.00000','1641.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1217.00000','722.00000','713.00000','676.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14625,14625,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',70,'male','L2Pet',40,'7724.00000','1722.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1312.00000','755.00000','779.00000','707.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14626,14626,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',72,'male','L2Pet',40,'8026.00000','1804.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1412.00000','790.00000','848.00000','739.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14627,14627,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',74,'male','L2Pet',40,'8317.00000','1888.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1511.00000','822.00000','920.00000','771.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14628,14628,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',76,'male','L2Pet',40,'8595.00000','1972.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1613.00000','856.00000','993.00000','802.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14633,14633,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',78,'male','L2Pet',40,'8882.00000','2059.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1721.00000','891.00000','1071.00000','833.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14634,14634,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',78,'male','L2Pet',40,'8956.00000','2081.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1749.00000','899.00000','1092.00000','841.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14635,14635,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',78,'male','L2Pet',40,'9030.00000','2103.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1778.00000','908.00000','1113.00000','849.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14636,14636,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',78,'male','L2Pet',40,'9105.00000','2126.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1807.00000','917.00000','1134.00000','857.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14637,14637,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',79,'male','L2Pet',40,'9181.00000','2149.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1837.00000','926.00000','1156.00000','865.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14638,14638,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',79,'male','L2Pet',40,'9257.00000','2172.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1867.00000','935.00000','1178.00000','873.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14639,14639,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',79,'male','L2Pet',40,'9334.00000','2195.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1898.00000','944.00000','1201.00000','881.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14640,14640,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',79,'male','L2Pet',40,'9411.00000','2219.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1929.00000','953.00000','1224.00000','889.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14641,14641,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',80,'male','L2Pet',40,'9489.00000','2243.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1961.00000','962.00000','1248.00000','897.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14642,14642,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',80,'male','L2Pet',40,'9568.00000','2267.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1993.00000','971.00000','1272.00000','905.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14643,14643,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',80,'male','L2Pet',40,'9647.00000','2292.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2026.00000','980.00000','1296.00000','913.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14644,14644,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',80,'male','L2Pet',40,'9727.00000','2317.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2059.00000','989.00000','1321.00000','921.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14645,14645,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',81,'male','L2Pet',40,'9808.00000','2342.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2093.00000','998.00000','1346.00000','929.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14646,14646,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',81,'male','L2Pet',40,'9889.00000','2367.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2128.00000','1008.00000','1372.00000','937.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14647,14647,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',81,'male','L2Pet',40,'9971.00000','2393.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2163.00000','1018.00000','1398.00000','946.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14648,14648,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',81,'male','L2Pet',40,'10054.00000','2419.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2199.00000','1028.00000','1425.00000','955.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14649,14649,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',82,'male','L2Pet',40,'10137.00000','2445.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2235.00000','1038.00000','1452.00000','964.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14650,14650,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',82,'male','L2Pet',40,'10221.00000','2471.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2272.00000','1048.00000','1480.00000','973.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14651,14651,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',82,'male','L2Pet',40,'10306.00000','2498.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2310.00000','1058.00000','1509.00000','982.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14652,14652,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',82,'male','L2Pet',40,'10392.00000','2525.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2348.00000','1068.00000','1538.00000','991.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14653,14653,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',83,'male','L2Pet',40,'10478.00000','2552.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2387.00000','1078.00000','1568.00000','1000.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14654,14654,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',83,'male','L2Pet',40,'10565.00000','2580.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2426.00000','1088.00000','1598.00000','1009.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14655,14655,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',83,'male','L2Pet',40,'10653.00000','2608.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2466.00000','1098.00000','1629.00000','1018.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14656,14656,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',83,'male','L2Pet',40,'10741.00000','2636.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2507.00000','1109.00000','1660.00000','1027.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14657,14657,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',84,'male','L2Pet',40,'10830.00000','2665.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2548.00000','1120.00000','1692.00000','1036.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14658,14658,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',84,'male','L2Pet',40,'10920.00000','2694.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2590.00000','1131.00000','1725.00000','1046.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14659,14659,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',84,'male','L2Pet',40,'11011.00000','2723.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2633.00000','1142.00000','1758.00000','1056.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14660,14660,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',85,'male','L2Pet',40,'11102.00000','2753.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2677.00000','1153.00000','1792.00000','1066.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14661,14661,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',85,'male','L2Pet',40,'11194.00000','2783.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2721.00000','1164.00000','1827.00000','1076.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14662,14662,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10.00','35.50',85,'male','L2Pet',40,'11287.00000','2813.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2766.00000','1175.00000','1862.00000','1086.00000',278,4,0,333,0,0,0,30,180,1,1,0,0),
(14663,14663,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',30,'male','L2Pet',40,'1269.00000','421.00000','3.50000','1.50000',40,43,30,21,20,25,0,0,'131.00000','140.00000','85.00000','130.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14664,14664,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',38,'male','L2Pet',40,'1862.00000','573.00000','4.50000','1.80000',40,43,30,21,20,25,0,0,'237.00000','187.00000','163.00000','175.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14665,14665,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',45,'male','L2Pet',40,'2487.00000','781.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'376.00000','237.00000','275.00000','222.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14666,14666,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',51,'male','L2Pet',40,'3089.00000','993.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'539.00000','285.00000','411.00000','267.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14667,14667,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',57,'male','L2Pet',40,'3733.00000','1213.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'742.00000','340.00000','590.00000','317.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14668,14668,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',62,'male','L2Pet',40,'4282.00000','1404.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'944.00000','388.00000','775.00000','363.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14669,14669,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',66,'male','L2Pet',40,'4716.00000','1561.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1121.00000','427.00000','648.00000','400.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14670,14670,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',70,'male','L2Pet',40,'5136.00000','1722.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1312.00000','469.00000','1138.00000','439.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14671,14671,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',74,'male','L2Pet',40,'5531.00000','1888.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1511.00000','511.00000','1343.00000','479.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14672,14672,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',78,'male','L2Pet',40,'5890.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1713.00000','554.00000','1560.00000','519.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14673,14673,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',78,'male','L2Pet',40,'5910.00000','2068.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1723.00000','556.00000','1568.00000','521.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14674,14674,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',78,'male','L2Pet',40,'5931.00000','2078.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1733.00000','557.00000','1578.00000','523.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14675,14675,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',78,'male','L2Pet',40,'5952.00000','2089.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1743.00000','559.00000','1586.00000','523.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14676,14676,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',79,'male','L2Pet',40,'5972.00000','2100.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1764.00000','566.00000','1614.00000','528.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14677,14677,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',79,'male','L2Pet',40,'5993.00000','2111.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1774.00000','567.00000','1624.00000','531.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14678,14678,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',79,'male','L2Pet',40,'6014.00000','2121.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1784.00000','569.00000','1632.00000','533.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14679,14679,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',79,'male','L2Pet',40,'6035.00000','2132.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1794.00000','571.00000','1641.00000','535.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14680,14680,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',80,'male','L2Pet',40,'6052.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1813.00000','576.00000','1671.00000','538.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14681,14681,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',80,'male','L2Pet',40,'6072.00000','2154.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1823.00000','577.00000','1679.00000','540.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14682,14682,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',80,'male','L2Pet',40,'6092.00000','2165.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1833.00000','579.00000','1688.00000','542.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14683,14683,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',80,'male','L2Pet',40,'6112.00000','2176.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1843.00000','581.00000','1696.00000','545.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14684,14684,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',81,'male','L2Pet',40,'6129.00000','2187.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1862.00000','586.00000','1724.00000','548.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14685,14685,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',81,'male','L2Pet',40,'6148.00000','2198.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1872.00000','588.00000','1735.00000','550.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14686,14686,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',81,'male','L2Pet',40,'6167.00000','2209.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1880.00000','589.00000','1744.00000','552.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14687,14687,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',81,'male','L2Pet',40,'6187.00000','2219.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1891.00000','591.00000','1752.00000','554.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14688,14688,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',82,'male','L2Pet',40,'6203.00000','2231.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1910.00000','595.00000','1781.00000','558.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14689,14689,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',82,'male','L2Pet',40,'6221.00000','2241.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1920.00000','598.00000','1789.00000','560.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14690,14690,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',82,'male','L2Pet',40,'6239.00000','2252.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1928.00000','600.00000','1798.00000','562.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14691,14691,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',82,'male','L2Pet',40,'6258.00000','2263.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1939.00000','601.00000','1806.00000','564.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14692,14692,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',83,'male','L2Pet',40,'6273.00000','2275.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1958.00000','607.00000','1836.00000','568.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14693,14693,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',83,'male','L2Pet',40,'6290.00000','2286.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1966.00000','608.00000','1844.00000','570.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14694,14694,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',83,'male','L2Pet',40,'6308.00000','2297.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1977.00000','610.00000','1853.00000','572.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14695,14695,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',83,'male','L2Pet',40,'6325.00000','2308.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1985.00000','612.00000','1861.00000','574.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14696,14696,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',84,'male','L2Pet',40,'6339.00000','2319.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2005.00000','617.00000','1892.00000','577.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14697,14697,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',84,'male','L2Pet',40,'6356.00000','2330.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2013.00000','619.00000','1897.00000','580.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14698,14698,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',84,'male','L2Pet',40,'6372.00000','2341.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2024.00000','621.00000','1906.00000','582.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14699,14699,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',85,'male','L2Pet',40,'6402.00000','2363.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2052.00000','628.00000','1946.00000','587.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14700,14700,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',85,'male','L2Pet',40,'6423.00000','2378.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2062.00000','631.00000','1957.00000','590.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14701,14701,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5.00','19.00',85,'male','L2Pet',40,'6444.00000','2393.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2075.00000','633.00000','1966.00000','592.00000',278,4,0,333,0,0,0,30,150,1,1,0,0),
(14702,14702,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',60,'male','L2Pet',40,'3054.00000','1327.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'860.00000','368.00000','477.00000','345.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14703,14703,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',64,'male','L2Pet',40,'3384.00000','1482.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1031.00000','408.00000','588.00000','381.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14704,14704,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',68,'male','L2Pet',40,'3706.00000','1641.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1217.00000','449.00000','713.00000','420.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14705,14705,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',72,'male','L2Pet',40,'4013.00000','1804.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1412.00000','491.00000','848.00000','459.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14706,14706,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',76,'male','L2Pet',40,'4297.00000','1972.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1613.00000','532.00000','993.00000','498.00000',278,4,0,333,0,0,0,48,140,1,1,0,0),
(14707,14707,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',78,'male','L2Pet',40,'4428.00000','2057.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1713.00000','554.00000','1068.00000','519.00000',278,4,0,333,0,0,0,48,141,1,1,0,0),
(14708,14708,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',78,'male','L2Pet',40,'4444.00000','2068.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1723.00000','556.00000','1074.00000','521.00000',278,4,0,333,0,0,0,48,142,1,1,0,0),
(14709,14709,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',78,'male','L2Pet',40,'4459.00000','2078.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1733.00000','557.00000','1081.00000','523.00000',278,4,0,333,0,0,0,48,143,1,1,0,0),
(14710,14710,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',78,'male','L2Pet',40,'4475.00000','2089.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1743.00000','559.00000','1086.00000','523.00000',278,4,0,333,0,0,0,48,144,1,1,0,0),
(14711,14711,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',79,'male','L2Pet',40,'4490.00000','2100.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1764.00000','566.00000','1105.00000','528.00000',278,4,0,333,0,0,0,48,145,1,1,0,0),
(14712,14712,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',79,'male','L2Pet',40,'4506.00000','2111.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1774.00000','567.00000','1112.00000','531.00000',278,4,0,333,0,0,0,48,146,1,1,0,0),
(14713,14713,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',79,'male','L2Pet',40,'4522.00000','2121.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1784.00000','569.00000','1118.00000','533.00000',278,4,0,333,0,0,0,48,147,1,1,0,0),
(14714,14714,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',79,'male','L2Pet',40,'4537.00000','2132.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1794.00000','571.00000','1124.00000','535.00000',278,4,0,333,0,0,0,48,148,1,1,0,0),
(14715,14715,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',80,'male','L2Pet',40,'4550.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1813.00000','576.00000','1144.00000','538.00000',278,4,0,333,0,0,0,48,149,1,1,0,0),
(14716,14716,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',80,'male','L2Pet',40,'4566.00000','2154.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1823.00000','577.00000','1150.00000','540.00000',278,4,0,333,0,0,0,48,150,1,1,0,0),
(14717,14717,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',80,'male','L2Pet',40,'4581.00000','2165.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1833.00000','579.00000','1156.00000','542.00000',278,4,0,333,0,0,0,48,151,1,1,0,0),
(14718,14718,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',80,'male','L2Pet',40,'4596.00000','2176.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1843.00000','581.00000','1161.00000','545.00000',278,4,0,333,0,0,0,48,152,1,1,0,0),
(14719,14719,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',81,'male','L2Pet',40,'4608.00000','2187.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1862.00000','585.00000','1181.00000','548.00000',278,4,0,333,0,0,0,48,153,1,1,0,0),
(14720,14720,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',81,'male','L2Pet',40,'4623.00000','2198.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1872.00000','588.00000','1188.00000','550.00000',278,4,0,333,0,0,0,48,154,1,1,0,0),
(14721,14721,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',81,'male','L2Pet',40,'4637.00000','2209.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1880.00000','589.00000','1194.00000','552.00000',278,4,0,333,0,0,0,48,155,1,1,0,0),
(14722,14722,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',81,'male','L2Pet',40,'4651.00000','2219.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1891.00000','591.00000','1200.00000','554.00000',278,4,0,333,0,0,0,48,156,1,1,0,0),
(14723,14723,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',82,'male','L2Pet',40,'4663.00000','2231.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1910.00000','596.00000','1220.00000','558.00000',278,4,0,333,0,0,0,48,157,1,1,0,0),
(14724,14724,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',82,'male','L2Pet',40,'4677.00000','2241.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1920.00000','598.00000','1225.00000','560.00000',278,4,0,333,0,0,0,48,158,1,1,0,0),
(14725,14725,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',82,'male','L2Pet',40,'4691.00000','2252.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1928.00000','600.00000','1231.00000','562.00000',278,4,0,333,0,0,0,48,159,1,1,0,0),
(14726,14726,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',82,'male','L2Pet',40,'4705.00000','2263.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1939.00000','601.00000','1237.00000','564.00000',278,4,0,333,0,0,0,48,160,1,1,0,0),
(14727,14727,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',83,'male','L2Pet',40,'4716.00000','2275.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1958.00000','607.00000','1257.00000','568.00000',278,4,0,333,0,0,0,48,161,1,1,0,0),
(14728,14728,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',83,'male','L2Pet',40,'4729.00000','2286.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1966.00000','608.00000','1263.00000','570.00000',278,4,0,333,0,0,0,48,162,1,1,0,0),
(14729,14729,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',83,'male','L2Pet',40,'4742.00000','2297.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1977.00000','610.00000','1269.00000','572.00000',278,4,0,333,0,0,0,48,163,1,1,0,0),
(14730,14730,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',83,'male','L2Pet',40,'4756.00000','2308.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1985.00000','612.00000','1275.00000','574.00000',278,4,0,333,0,0,0,48,164,1,1,0,0),
(14731,14731,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',84,'male','L2Pet',40,'4766.00000','2319.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2005.00000','617.00000','1296.00000','577.00000',278,4,0,333,0,0,0,48,165,1,1,0,0),
(14732,14732,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',84,'male','L2Pet',40,'4779.00000','2330.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2013.00000','619.00000','1299.00000','580.00000',278,4,0,333,0,0,0,48,166,1,1,0,0),
(14733,14733,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',84,'male','L2Pet',40,'4791.00000','2341.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2024.00000','621.00000','1305.00000','582.00000',278,4,0,333,0,0,0,48,167,1,1,0,0),
(14734,14734,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',85,'male','L2Pet',40,'4813.00000','2363.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2052.00000','628.00000','1332.00000','587.00000',278,4,0,333,0,0,0,48,168,1,1,0,0),
(14735,14735,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',85,'male','L2Pet',40,'4829.00000','2378.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2062.00000','631.00000','1340.00000','590.00000',278,4,0,333,0,0,0,48,169,1,1,0,0),
(14736,14736,'Big Boom',0,'',0,'LineageMonster.big_boom','6.00','13.00',85,'male','L2Pet',40,'4845.00000','2393.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'2075.00000','633.00000','1346.00000','592.00000',278,4,0,333,0,0,0,48,170,1,1,0,0),
(14737,14737,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',55,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'2142.00000','1205.00000','384.00000','883.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14738,14738,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',78,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'2509.00000','1398.00000','440.00000','1024.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14739,14739,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',78,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'2534.00000','1398.00000','440.00000','1024.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14740,14740,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',78,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'2558.00000','1398.00000','440.00000','1024.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14741,14741,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',78,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'2583.00000','1398.00000','440.00000','1024.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14742,14742,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',79,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'2624.00000','1406.00000','447.00000','1030.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14743,14743,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',79,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'2649.00000','1406.00000','447.00000','1030.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14744,14744,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',79,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'2674.00000','1406.00000','447.00000','1030.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14745,14745,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',79,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'2699.00000','1406.00000','447.00000','1030.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14746,14746,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',80,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'2740.00000','1415.00000','444.00000','1036.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14747,14747,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',80,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'2765.00000','1415.00000','444.00000','1036.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14748,14748,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',80,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'2790.00000','1415.00000','444.00000','1036.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14749,14749,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',80,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'2816.00000','1415.00000','444.00000','1036.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14750,14750,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',81,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'2858.00000','1423.00000','452.00000','1043.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14751,14751,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',81,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'2883.00000','1423.00000','452.00000','1043.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14752,14752,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',81,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'2908.00000','1423.00000','452.00000','1043.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14753,14753,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',81,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'2933.00000','1423.00000','452.00000','1043.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14754,14754,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',82,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'2976.00000','1431.00000','451.00000','1048.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14755,14755,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',82,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'3002.00000','1431.00000','451.00000','1048.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14756,14756,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',82,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'3027.00000','1431.00000','451.00000','1048.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14757,14757,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',82,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'3053.00000','1431.00000','451.00000','1048.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14758,14758,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',83,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'3096.00000','1440.00000','458.00000','1055.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14759,14759,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',83,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'3122.00000','1440.00000','458.00000','1055.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14760,14760,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',83,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'3147.00000','1440.00000','458.00000','1055.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14761,14761,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',83,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'3173.00000','1440.00000','458.00000','1055.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14762,14762,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',84,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'3217.00000','1448.00000','456.00000','1061.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14763,14763,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',84,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'3243.00000','1448.00000','456.00000','1061.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14764,14764,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',84,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'3268.00000','1448.00000','456.00000','1061.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14765,14765,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',85,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'3313.00000','1456.00000','463.00000','1067.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14766,14766,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',85,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'3339.00000','1456.00000','463.00000','1067.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14767,14767,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60.00','140.00',85,'male','L2SiegeSummon',80,'500000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'3365.00000','1456.00000','463.00000','1067.00000',136,4,0,333,0,0,0,40,40,1,1,0,1),
(14768,14768,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',60,'male','L2SiegeSummon',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'711.00000','496.00000','873.00000','330.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14769,14769,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',78,'male','L2SiegeSummon',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1418.00000','557.00000','979.00000','371.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14770,14770,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',78,'male','L2SiegeSummon',40,'2813.00000','1470.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1426.00000','559.00000','984.00000','372.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14771,14771,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',78,'male','L2SiegeSummon',40,'2823.00000','1478.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1433.00000','561.00000','995.00000','374.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14772,14772,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',78,'male','L2SiegeSummon',40,'2832.00000','1485.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1442.00000','563.00000','1000.00000','375.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14773,14773,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',79,'male','L2SiegeSummon',40,'2842.00000','1493.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1458.00000','568.00000','1007.00000','378.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14774,14774,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',79,'male','L2SiegeSummon',40,'2853.00000','1501.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1467.00000','570.00000','1012.00000','380.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14775,14775,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',79,'male','L2SiegeSummon',40,'2862.00000','1508.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1475.00000','572.00000','1019.00000','380.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14776,14776,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',79,'male','L2SiegeSummon',40,'2872.00000','1516.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1483.00000','574.00000','1023.00000','382.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14777,14777,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',80,'male','L2SiegeSummon',40,'2880.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1499.00000','579.00000','1040.00000','385.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14778,14778,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',80,'male','L2SiegeSummon',40,'2890.00000','1531.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1508.00000','581.00000','1046.00000','387.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14779,14779,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',80,'male','L2SiegeSummon',40,'2899.00000','1539.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1516.00000','582.00000','1051.00000','388.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14780,14780,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',80,'male','L2SiegeSummon',40,'2909.00000','1547.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1524.00000','584.00000','1056.00000','389.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14781,14781,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',81,'male','L2SiegeSummon',40,'2917.00000','1555.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1540.00000','589.00000','1063.00000','393.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14782,14782,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',81,'male','L2SiegeSummon',40,'2926.00000','1562.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1548.00000','591.00000','1068.00000','393.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14783,14783,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',81,'male','L2SiegeSummon',40,'2935.00000','1570.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1556.00000','593.00000','1079.00000','395.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14784,14784,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',81,'male','L2SiegeSummon',40,'2944.00000','1578.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1564.00000','595.00000','1084.00000','396.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14785,14785,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',82,'male','L2SiegeSummon',40,'2952.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1580.00000','600.00000','1095.00000','399.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14786,14786,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',82,'male','L2SiegeSummon',40,'2961.00000','1593.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1588.00000','602.00000','1100.00000','401.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14787,14787,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',82,'male','L2SiegeSummon',40,'2970.00000','1602.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1596.00000','603.00000','1101.00000','402.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14788,14788,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',82,'male','L2SiegeSummon',40,'2978.00000','1609.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1603.00000','605.00000','1106.00000','402.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14789,14789,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',83,'male','L2SiegeSummon',40,'2985.00000','1617.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1619.00000','610.00000','1117.00000','407.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14790,14790,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',83,'male','L2SiegeSummon',40,'2994.00000','1625.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1628.00000','612.00000','1122.00000','407.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14791,14791,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',83,'male','L2SiegeSummon',40,'3002.00000','1633.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1635.00000','614.00000','1127.00000','409.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14792,14792,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',83,'male','L2SiegeSummon',40,'3010.00000','1641.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1643.00000','616.00000','1132.00000','410.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14793,14793,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',84,'male','L2SiegeSummon',40,'3017.00000','1648.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1658.00000','621.00000','1149.00000','413.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14794,14794,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',84,'male','L2SiegeSummon',40,'3025.00000','1657.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1666.00000','623.00000','1154.00000','415.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14795,14795,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',84,'male','L2SiegeSummon',40,'3033.00000','1665.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1673.00000','626.00000','1163.00000','416.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14796,14796,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',85,'male','L2SiegeSummon',40,'3047.00000','1680.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1696.00000','632.00000','1172.00000','420.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14797,14797,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',85,'male','L2SiegeSummon',40,'3057.00000','1691.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1706.00000','634.00000','1183.00000','422.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14798,14798,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93.00','90.00',85,'male','L2SiegeSummon',40,'3066.00000','1702.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1715.00000','594.00000','1065.00000','395.00000',230,4,0,333,0,0,0,10,10,1,1,0,1),
(14799,14799,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',42,'male','L2Pet',40,'1826.00000','679.00000','5.50000','2.10000',40,43,30,21,20,25,0,0,'311.00000','215.00000','152.00000','202.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14800,14800,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',51,'male','L2Pet',40,'2555.00000','993.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'539.00000','286.00000','281.00000','268.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14801,14801,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',60,'male','L2Pet',40,'3359.00000','1327.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'860.00000','368.00000','478.00000','345.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14802,14802,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',64,'male','L2Pet',40,'3722.00000','1482.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1031.00000','408.00000','589.00000','382.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14803,14803,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',68,'male','L2Pet',40,'4076.00000','1641.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1217.00000','449.00000','713.00000','421.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14804,14804,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',72,'male','L2Pet',40,'4414.00000','1804.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1413.00000','491.00000','849.00000','460.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14805,14805,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',76,'male','L2Pet',40,'4727.00000','1972.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1614.00000','534.00000','994.00000','500.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14806,14806,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',78,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1723.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14807,14807,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',78,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1732.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14808,14808,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',78,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1740.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14809,14809,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',78,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1749.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14810,14810,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',79,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1757.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14811,14811,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',79,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1766.00000','555.00000','1069.00000','520.00000',370,4,0,333,0,0,0,25,150,1,1,0,0),
(14812,14812,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',79,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1775.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14813,14813,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',79,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1783.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14814,14814,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',80,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1792.00000','555.00000','1069.00000','520.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14815,14815,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',80,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1811.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14816,14816,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',80,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1820.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14817,14817,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',80,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1828.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14818,14818,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',81,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1837.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14819,14819,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',81,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1846.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14820,14820,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',81,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1854.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14821,14821,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',81,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1863.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14822,14822,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',82,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1871.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14823,14823,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',82,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1880.00000','558.00000','1082.00000','523.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14824,14824,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',82,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1900.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14825,14825,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',82,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1909.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14826,14826,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',83,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1917.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14827,14827,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',83,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1926.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14828,14828,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',83,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1935.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14829,14829,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',83,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1943.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14830,14830,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',84,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1952.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14831,14831,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',84,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1961.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14832,14832,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',84,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1969.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14833,14833,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',85,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1978.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14834,14834,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',85,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1987.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14835,14835,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',85,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'1995.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,25,150,1,1,0,0),
(14836,14836,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6.00','16.01',80,'male','L2Pet',40,'6053.00000','2143.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'2646.00000','633.00000','2006.00000','593.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14837,14837,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.50','17.00',80,'male','L2Pet',40,'6053.00000','2143.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'2646.00000','633.00000','2006.00000','593.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14838,14838,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.50','33.50',80,'male','L2Pet',40,'6053.00000','2143.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'2646.00000','633.00000','2006.00000','593.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14839,14839,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',68,'male','L2SiegeSummon',80,'50000.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'19.00000','1314.00000','419.00000','963.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14840,14840,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',78,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'21.00000','1398.00000','440.00000','1024.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14841,14841,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',78,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'21.00000','1398.00000','440.00000','1024.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14842,14842,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',78,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'21.00000','1398.00000','440.00000','1024.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14843,14843,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',78,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'21.00000','1398.00000','440.00000','1024.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14844,14844,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',79,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'22.00000','1406.00000','447.00000','1030.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14845,14845,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',79,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'22.00000','1406.00000','447.00000','1030.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14846,14846,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',79,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'23.00000','1406.00000','447.00000','1030.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14847,14847,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',79,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'23.00000','1406.00000','447.00000','1030.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14848,14848,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',80,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'23.00000','1415.00000','444.00000','1036.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14849,14849,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',80,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'23.00000','1415.00000','444.00000','1036.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14850,14850,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',80,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'23.00000','1415.00000','444.00000','1036.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14851,14851,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',80,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'23.00000','1415.00000','444.00000','1036.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14852,14852,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',81,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'24.00000','1423.00000','452.00000','1043.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14853,14853,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',81,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'24.00000','1423.00000','452.00000','1043.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14854,14854,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',81,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'24.00000','1423.00000','452.00000','1043.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14855,14855,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',81,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'25.00000','1423.00000','452.00000','1043.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14856,14856,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',82,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'25.00000','1431.00000','451.00000','1048.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14857,14857,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',82,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'25.00000','1431.00000','451.00000','1048.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14858,14858,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',82,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'26.00000','1431.00000','451.00000','1048.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14859,14859,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',82,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'26.00000','1431.00000','451.00000','1048.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14860,14860,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',83,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'26.00000','1440.00000','458.00000','1055.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14861,14861,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',83,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'28.00000','1440.00000','458.00000','1055.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14862,14862,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',83,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'28.00000','1440.00000','458.00000','1055.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14863,14863,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',83,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'28.00000','1440.00000','458.00000','1055.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14864,14864,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',84,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'28.00000','1448.00000','456.00000','1061.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14865,14865,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',84,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'28.00000','1448.00000','456.00000','1061.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14866,14866,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',84,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'28.00000','1448.00000','456.00000','1061.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14867,14867,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',85,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'28.00000','1456.00000','463.00000','1067.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14868,14868,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',85,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'28.00000','1456.00000','463.00000','1067.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14869,14869,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45.00','47.50',85,'male','L2SiegeSummon',80,'50000.00000','810.00000','8.50000','2.40000',40,43,30,21,20,25,0,0,'29.00000','1456.00000','463.00000','1067.00000',136,4,0,333,0,0,0,60,40,1,1,0,1),
(14870,14870,'Divine Beast',0,'',0,'LineageMonster4.Divine_beast','31.00','15.50',80,'male','L2Pet',40,'5025.00000','2143.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'1900.00000','562.00000','1095.00000','526.00000',278,4,0,333,0,0,0,40,180,1,1,0,0),
(14871,14871,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6.00','16.01',81,'male','L2Pet',40,'6120.00000','2174.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'2705.00000','641.00000','2059.00000','600.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14872,14872,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6.00','16.01',81,'male','L2Pet',40,'6187.00000','2205.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'2765.00000','649.00000','2113.00000','607.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14873,14873,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6.00','16.01',81,'male','L2Pet',40,'6255.00000','2237.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'2827.00000','657.00000','2168.00000','614.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14874,14874,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6.00','16.01',82,'male','L2Pet',40,'6324.00000','2269.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'2890.00000','665.00000','2225.00000','621.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14875,14875,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6.00','16.01',82,'male','L2Pet',40,'6394.00000','2302.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'2955.00000','673.00000','2283.00000','628.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14876,14876,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6.00','16.01',82,'male','L2Pet',40,'6464.00000','2335.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3021.00000','681.00000','2343.00000','636.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14877,14877,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6.00','16.01',83,'male','L2Pet',40,'6535.00000','2369.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3089.00000','689.00000','2404.00000','644.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14878,14878,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6.00','16.01',83,'male','L2Pet',40,'6607.00000','2403.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3158.00000','698.00000','2467.00000','652.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14879,14879,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6.00','16.01',83,'male','L2Pet',40,'6680.00000','2438.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3229.00000','707.00000','2532.00000','660.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14880,14880,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6.00','16.01',84,'male','L2Pet',40,'6754.00000','2473.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3301.00000','716.00000','2598.00000','668.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14881,14881,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6.00','16.01',84,'male','L2Pet',40,'6828.00000','2509.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3375.00000','725.00000','2666.00000','676.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14882,14882,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6.00','16.01',84,'male','L2Pet',40,'6903.00000','2545.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3451.00000','734.00000','2736.00000','684.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14883,14883,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6.00','16.01',85,'male','L2Pet',40,'6979.00000','2582.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3528.00000','743.00000','2808.00000','692.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14884,14884,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6.00','16.01',85,'male','L2Pet',40,'7056.00000','2619.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3607.00000','752.00000','2882.00000','700.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14885,14885,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6.00','16.01',85,'male','L2Pet',40,'7134.00000','2657.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3688.00000','761.00000','2958.00000','708.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14886,14886,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.50','17.00',81,'male','L2Pet',40,'6120.00000','2174.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'2705.00000','641.00000','2059.00000','600.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14887,14887,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.50','17.00',81,'male','L2Pet',40,'6187.00000','2205.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'2765.00000','649.00000','2113.00000','607.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14888,14888,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.50','17.00',81,'male','L2Pet',40,'6255.00000','2237.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'2827.00000','657.00000','2168.00000','614.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14889,14889,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.50','17.00',82,'male','L2Pet',40,'6324.00000','2269.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'2890.00000','665.00000','2225.00000','621.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14890,14890,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.50','17.00',82,'male','L2Pet',40,'6394.00000','2302.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'2955.00000','673.00000','2283.00000','628.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14891,14891,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.50','17.00',82,'male','L2Pet',40,'6464.00000','2335.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3021.00000','681.00000','2343.00000','636.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14892,14892,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.50','17.00',83,'male','L2Pet',40,'6535.00000','2369.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3089.00000','689.00000','2404.00000','644.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14893,14893,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.50','17.00',83,'male','L2Pet',40,'6607.00000','2403.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3158.00000','698.00000','2467.00000','652.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14894,14894,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.50','17.00',83,'male','L2Pet',40,'6680.00000','2438.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3229.00000','707.00000','2532.00000','660.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14895,14895,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.50','17.00',84,'male','L2Pet',40,'6754.00000','2473.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3301.00000','716.00000','2598.00000','668.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14896,14896,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.50','17.00',84,'male','L2Pet',40,'6828.00000','2509.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3375.00000','725.00000','2666.00000','676.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14897,14897,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.50','17.00',84,'male','L2Pet',40,'6903.00000','2545.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3451.00000','734.00000','2736.00000','684.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14898,14898,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.50','17.00',85,'male','L2Pet',40,'6979.00000','2582.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3528.00000','743.00000','2808.00000','692.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14899,14899,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.50','17.00',85,'male','L2Pet',40,'7056.00000','2619.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3607.00000','752.00000','2882.00000','700.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14900,14900,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.50','17.00',85,'male','L2Pet',40,'7134.00000','2657.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3688.00000','761.00000','2958.00000','708.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14901,14901,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.50','33.50',81,'male','L2Pet',40,'6120.00000','2174.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'2705.00000','641.00000','2059.00000','600.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14902,14902,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.50','33.50',81,'male','L2Pet',40,'6187.00000','2205.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'2765.00000','649.00000','2113.00000','607.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14903,14903,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.50','33.50',81,'male','L2Pet',40,'6255.00000','2237.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'2827.00000','657.00000','2168.00000','614.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14904,14904,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.50','33.50',82,'male','L2Pet',40,'6324.00000','2269.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'2890.00000','665.00000','2225.00000','621.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14905,14905,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.50','33.50',82,'male','L2Pet',40,'6394.00000','2302.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'2955.00000','673.00000','2283.00000','628.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14906,14906,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.50','33.50',82,'male','L2Pet',40,'6464.00000','2335.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3021.00000','681.00000','2343.00000','636.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14907,14907,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.50','33.50',83,'male','L2Pet',40,'6535.00000','2369.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3089.00000','689.00000','2404.00000','644.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14908,14908,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.50','33.50',83,'male','L2Pet',40,'6607.00000','2403.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3158.00000','698.00000','2467.00000','652.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14909,14909,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.50','33.50',83,'male','L2Pet',40,'6680.00000','2438.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3229.00000','707.00000','2532.00000','660.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14910,14910,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.50','33.50',84,'male','L2Pet',40,'6754.00000','2473.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3301.00000','716.00000','2598.00000','668.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14911,14911,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.50','33.50',84,'male','L2Pet',40,'6828.00000','2509.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3375.00000','725.00000','2666.00000','676.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14912,14912,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.50','33.50',84,'male','L2Pet',40,'6903.00000','2545.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3451.00000','734.00000','2736.00000','684.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14913,14913,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.50','33.50',85,'male','L2Pet',40,'6979.00000','2582.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3528.00000','743.00000','2808.00000','692.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14914,14914,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.50','33.50',85,'male','L2Pet',40,'7056.00000','2619.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3607.00000','752.00000','2882.00000','700.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14915,14915,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.50','33.50',85,'male','L2Pet',40,'7134.00000','2657.00000','8.50000','6.00000',40,43,30,21,20,25,0,0,'3688.00000','761.00000','2958.00000','708.00000',278,4,0,333,0,0,0,160,180,1,1,0,0),
(14916,14916,'Tigress',0,'',0,'LineageMonster.saber_toothed_tiger_070p','22.00','18.40',61,'male','L2Pet',40,'3137.00000','1184.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'894.00000','379.00000','413.00000','308.00000',278,4,0,333,0,0,0,47,170,1,1,0,0),
(14917,14917,'Tigress',0,'',0,'LineageMonster.saber_toothed_tiger_070p','22.00','18.40',61,'male','L2Pet',40,'3137.00000','1184.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'894.00000','379.00000','413.00000','308.00000',278,4,0,333,0,0,0,47,170,1,1,0,0),
(14918,14918,'Imperial Phoenix',0,'',0,'LineageMonster4.phoenix','7.00','34.00',83,'female','L2Pet',40,'7134.00000','2657.00000','8.50000','3.00000',40,43,30,21,20,25,0,0,'3688.00000','761.00000','2958.00000','708.00000',278,4,0,333,0,0,0,60,180,1,1,0,0),
(16013,16013,'Trained Buffalo',0,'',0,'LineageMonster2.buffalo','22.00','31.00',67,'male','L2TamedBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'967.00000','439.00000','663.00000','293.00000',230,4,0,333,0,0,0,80,120,1,1,0,1),
(16014,16014,'Trained Buffalo',0,'',0,'LineageMonster2.buffalo','22.00','31.00',67,'male','L2TamedBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'967.00000','439.00000','663.00000','293.00000',230,4,0,333,0,0,0,80,120,1,1,0,1),
(16015,16015,'Trained Cougar',0,'',0,'LineageMonster.saber_toothed_tiger','34.00','28.00',69,'male','L2TamedBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1046.00000','460.00000','717.00000','307.00000',230,4,0,333,0,0,0,60,120,1,1,0,1),
(16016,16016,'Trained Cougar',0,'',0,'LineageMonster.saber_toothed_tiger','34.00','28.00',69,'male','L2TamedBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'1046.00000','460.00000','717.00000','307.00000',230,4,0,333,0,0,0,60,120,1,1,0,1),
(16017,16017,'Trained Kookaburra',0,'',0,'LineageMonster2.pet_ostrich','10.00','33.00',65,'male','L2TamedBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'890.00000','419.00000','615.00000','279.00000',230,4,0,333,0,0,0,23,120,1,1,0,1),
(16018,16018,'Trained Kookaburra',0,'',0,'LineageMonster2.pet_ostrich','10.00','33.00',65,'male','L2TamedBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,25,0,0,'890.00000','419.00000','615.00000','279.00000',230,4,0,333,0,0,0,23,120,1,1,0,1),
(16019,16019,'Tiny Baby Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12.00','15.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,25,2146,200,'967.00000','439.00000','663.00000','293.00000',230,4,0,333,0,0,0,30,120,1,1,0,1),
(16020,16020,'Tame Tiny Baby Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12.00','15.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,25,2146,200,'967.00000','439.00000','663.00000','293.00000',230,4,0,333,0,0,0,30,120,1,1,0,1),
(16021,16021,'Tiny Baby Cougar',0,'',0,'LineageMonster2.baby_tiger','11.00','15.70',69,'male','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,25,2276,218,'1046.00000','460.00000','717.00000','307.00000',230,4,0,333,0,0,0,28,120,1,1,0,1),
(16022,16022,'Tame Tiny Baby Cougar',0,'',0,'LineageMonster2.baby_tiger','11.00','15.70',69,'male','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,25,2276,218,'1046.00000','460.00000','717.00000','307.00000',230,4,0,333,0,0,0,28,120,1,1,0,1),
(16023,16023,'Tiny Baby Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7.00','15.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,25,2020,183,'890.00000','419.00000','615.00000','279.00000',230,4,0,333,0,0,0,13,120,1,1,0,1),
(16024,16024,'Tame Tiny Baby Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7.00','15.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,25,2020,183,'890.00000','419.00000','615.00000','279.00000',230,4,0,333,0,0,0,13,120,1,1,0,1),
(16025,16025,'Great Wolf',0,'',0,'LineageMonster4.Pet_Wolf_B','25.00','21.41',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,45,170,1,1,0,0),
(16026,16026,'Beastly Agathion',0,'',0,'LineageNPC2.Agathion_BF','9.00','11.30',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(16027,16027,'Rainbow Agathion',0,'',0,'LineageNPC2.Agathion_RA','11.00','6.70',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(16028,16028,'Lord Agathion',0,'',0,'LineageNPC2.Agathion_CL','3.00','9.50',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(16029,16029,'Fortress Agathion',0,'',0,'LineageNPC2.Agathion_FT','1.00','3.50',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(16030,16030,'Great Wolf',0,'',0,'LineageMonster4.Pet_Wolf_Ba','25.00','23.56',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,253,0,0,0,45,170,1,1,0,0),
(16031,16031,'Little Angel Agathion',0,'',0,'LineageNpc2.Agathion_ag','0.01','4.55',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(16032,16032,'Little Devil Agathion',0,'',0,'LineageNpc2.Agathion_st','0.01','5.50',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(16033,16033,'Rudolph Agathion',0,'',0,'LineageNpc2.Agathion_rd','0.01','5.27',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(16034,16034,'Improved Baby Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12.00','15.00',55,'male','L2BabyPet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,30,170,1,1,0,1),
(16035,16035,'Improved Baby Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7.00','15.00',55,'male','L2BabyPet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,13,170,1,1,0,1),
(16036,16036,'Improved Baby Cougar',0,'',0,'LineageMonster2.baby_tiger','11.00','15.70',55,'male','L2BabyPet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,28,170,1,1,0,1),
(16037,16037,'Great Snow Wolf',0,'',0,'LineageMonster4.Pet_Wolf_Ba','25.00','23.56',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,253,0,0,0,45,170,1,1,0,0),
(16038,16038,'Red Wind Strider',0,'',0,'LineageMonster.strider','23.00','31.00',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,80,170,1,1,0,0),
(16039,16039,'Red Star Strider',0,'',0,'LineageMonster.strider','23.00','31.00',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,80,170,1,1,0,0),
(16040,16040,'Red Twilight Strider',0,'',0,'LineageMonster.strider','23.00','31.00',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,80,170,1,1,0,0),
(16041,16041,'Fenrir',0,'',0,'LineageMonster4.Pet_Wolf_Ba','25.00','23.56',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,253,0,0,0,45,170,1,1,0,0),
(16042,16042,'Snow Fenrir',0,'',0,'LineageMonster4.Pet_Wolf_Ba','25.00','23.56',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,253,0,0,0,45,170,1,1,0,0),
(16043,16043,'Fox Shaman',0,'',0,'LineageMonster4.foxian_wizard_pet','10.00','18.50',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',35,37,30,32,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,35,170,1,1,0,0),
(16044,16044,'Wild Beast Fighter',0,'',0,'LineageMonster4.beast_fighter_pet','10.00','18.50',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,22,170,1,1,0,0),
(16045,16045,'White Weasel',0,'',0,'LineageMonster4.ferret_pet','6.50','12.50',55,'male','L2BabyPet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,30,170,1,1,0,0),
(16046,16046,'Fairy Princess',0,'',0,'LineageMonster4.fairy_princess_pet','10.00','15.00',55,'male','L2BabyPet',40,'1673.05473','889.80000','6.50000','2.40000',35,37,30,32,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,35,170,1,1,0,0),
(16049,16049,'Love Agathion',0,'',0,'LineageNpc2.agathion_love','0.01','3.75',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(16050,16050,'Owl Monk',0,'',0,'LineageMonster4.owl_wizard_the_pet','40.00','27.50',55,'female','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,30,180,1,1,0,0),
(16051,16051,'Spirit Shaman',0,'',0,'LineageMonster4.sprit_magician_the_pet','12.80','15.60',55,'male','L2BabyPet',40,'1673.05473','889.80000','6.50000','2.40000',35,37,30,32,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,30,180,1,1,0,0),
(16052,16052,'Toy Knight',0,'',0,'LineageMonster4.toy_knight_the_pet','10.00','15.00',55,'male','L2BabyPet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,0),
(16053,16053,'Turtle Ascetic',0,'',0,'LineageMonster4.turtle_buffer_the_pet','11.00','10.00',55,'male','L2BabyPet',40,'1673.05473','889.80000','6.50000','2.40000',38,40,30,26,20,25,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,0),
(16054,16054,'Monkey',0,'',0,'LineageNpc2.agathion_mk','0.01','7.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(16055,16055,'Griffon',0,'',0,'LineageNpc2.agathion_gr','0.01','5.50',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(16056,16056,'Joy',0,'',0,'LineageNpc2.agathion_happy','0.01','6.50',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(16057,16057,'Sorrow',0,'',0,'LineageNpc2.agathion_sorrow','0.01','5.00',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(16058,16058,'Anger',0,'',0,'LineageNpc2.agathion_anger','0.01','3.00',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(16059,16059,'Boy Bear',0,'',0,'LineageNPC2.teddy_bear_boy','3.00','7.00',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,180,1,1,0,1),
(16060,16060,'Girl Bear',0,'',0,'LineageNPC2.teddy_bear_girl','3.00','7.00',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,180,1,1,0,1),
(16061,16061,'Collection Device',0,'',0,'LineageNPC2.collecting_golem','5.50','6.25',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,180,1,1,0,1),
(16062,16062,'Knight',0,'',0,'LineageNPC2.agathion_pvp','0.01','7.00',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,25,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,180,1,1,0,1),
(16063,16063,'Saerom',0,'',0,'LineageNPC2.agathion_gift','0.01','5.15',55,'female','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,50,180,1,1,0,1),
(16064,16064,'Juju',0,'',0,'LineageNPC2.agathion_cupi','0.01','5.75',55,'female','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,50,180,1,1,0,0),
(16065,16065,'Oink Oink',0,'',0,'LineageNPC2.agathion_pig','0.01','5.75',55,'female','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,50,180,1,1,0,0),
(16066,16066,'Light of Dawn',0,'',0,'LineageNPC2.agathion_pig','0.01','5.75',55,'female','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,50,180,1,1,0,0),
(16067,16067,'Deinonychus',0,'',0,'LineageMonster3.deinonychus','14.00','14.30',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,20,0,0,'388.11142','223.63620','265.02979','163.64727',253,1,0,333,0,0,0,24,160,1,1,0,0),
(16068,16068,'Guardian\'s Strider',0,'',0,'LineageMonster4.dragon_descendant_2a','27.00','33.50',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,20,0,0,'388.11142','223.63620','265.02979','163.64727',253,4,0,333,0,0,0,40,170,1,1,0,0),
(16069,16069,'Pona',0,'',0,'LineageNPC2.agathion_pona','0.01','5.15',55,'female','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,50,180,1,1,0,0),
(16070,16070,'Towbat',0,'',0,'LineageNPC2.agathion_tow','0.01','5.75',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,50,180,1,1,0,0),
(16071,16071,'Maguen',0,'',0,'LineageMonster5.marguene_pet','11.00','13.25',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,20,0,0,'388.11142','223.63620','265.02979','163.64727',253,1,0,333,0,0,0,15,120,1,1,0,0),
(16072,16072,'Elite Maguen',0,'',0,'LineageMonster5.marguene_pet_elite','11.00','13.25',55,'male','L2Pet',40,'1673.05473','889.80000','6.50000','2.40000',40,43,30,21,20,20,0,0,'388.11142','223.63620','265.02979','163.64727',253,1,0,333,0,0,0,15,120,1,1,0,0),
(16073,16073,'Rudolph Agathion',0,'',0,'LineageNpc2.Agathion_rd','0.01','5.27',55,'male','L2Npc',40,'3862.00000','1494.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'554.00000','322.00000','382.00000','214.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(18001,18001,'Blood Queen',0,'',0,'LineageMonster.bloody_queen','14.00','40.00',60,'female','L2Monster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,4536,394,'711.00000','369.00000','491.00000','203.00000',230,4,300,333,0,0,0,80,160,1,1,0,1),
(18002,18002,'Blood Queen',0,'',0,'LineageMonster.bloody_queen','14.00','40.00',60,'female','L2Monster',40,'1933.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,4320,375,'783.00000','369.00000','491.00000','203.00000',230,4,300,333,0,0,0,80,160,1,1,0,1),
(18003,18003,'Bearded Keltir',0,'',0,'LineageMonster.keltir','9.50','10.00',1,'male','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,29,2,'3.00000','40.00000','7.00000','22.00000',230,4,0,333,0,0,0,23,110,1,1,0,1),
(18004,18004,'Susceptor Prime',0,'',0,'LineageMonster.susceptor_prime','45.00','72.00',49,'male','L2Monster',1100,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,0,1,'398.00000','270.00000','275.00000','149.00000',230,8,0,333,0,0,0,78,170,1,1,0,1),
(18005,18005,'Mimic',0,'',0,'LineageMonster.mimic','8.50','8.50',52,'male','L2Monster',40,'1570.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,3245,251,'487.00000','305.00000','321.00000','163.00000',230,4,0,333,0,0,0,80,156,1,1,0,1),
(18006,18006,'Maruk Lord',0,'',0,'LineageMonster.death_blader','15.00','45.00',68,'male','L2Monster',40,'2422.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,6057,586,'1038.00000','464.00000','695.00000','248.00000',230,4,500,333,1472,0,0,100,170,1,1,0,1),
(18007,18007,'Limal Karinness',0,'',0,'LineageMonster.bloody_queen','14.00','40.00',69,'female','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,5951,582,'1151.00000','460.00000','794.00000','253.00000',230,4,500,333,0,0,0,80,140,1,1,0,1),
(18008,18008,'Karik',0,'',0,'LineageMonster.karik','25.00','90.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,6370,632,'1195.00000','471.00000','820.00000','259.00000',230,4,500,333,0,0,0,37,200,1,1,0,1),
(18009,18009,'Offering of Branded Elder',0,'',0,'LineageMonster.orc_fighter_bi','12.00','26.40',34,'male','L2FestivalMonster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,1755,102,'148.00000','164.00000','99.00000','90.00000',230,4,0,333,127,0,0,45,30,1,1,0,1),
(18010,18010,'Offering of the Branded',0,'',0,'LineageMonster.orc','10.00','21.00',32,'male','L2FestivalMonster',40,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,1524,86,'112.00000','129.00000','85.00000','84.00000',230,8,0,333,218,0,0,45,30,1,1,0,1),
(18011,18011,'Offering of Branded Archer',0,'',0,'LineageMonster.orc_archer','14.00','25.00',28,'male','L2FestivalMonster',1100,'544.00000','274.00000','3.50000','1.50000',40,43,30,21,20,20,1001,53,'208.00000','111.00000','67.00000','72.00000',230,8,0,333,14,0,0,45,60,1,1,0,1),
(18012,18012,'Offering of Branded Warrior',0,'',0,'LineageMonster.orc_champion','10.00','23.00',29,'male','L2FestivalMonster',40,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,1026,55,'101.00000','136.00000','72.00000','75.00000',230,4,0,333,125,0,0,45,110,1,1,0,1),
(18013,18013,'Offering of Branded Follower',0,'',0,'LineageMonster.orc_shaman','9.00','22.00',29,'male','L2FestivalMonster',40,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,1227,66,'88.00000','115.00000','72.00000','75.00000',230,8,0,333,316,0,0,45,150,1,1,0,1),
(18014,18014,'Offering of Branded Berserker',0,'',0,'LineageMonster.virud_lizardman','10.00','23.00',37,'male','L2FestivalMonster',40,'847.00000','393.00000','4.50000','1.80000',40,43,30,21,20,20,2277,140,'183.00000','182.00000','123.00000','100.00000',230,4,0,333,292,0,0,43,115,1,1,0,1),
(18015,18015,'Offering of Branded Zealot',0,'',0,'LineageMonster.orc_fighter_bi','12.00','26.40',34,'male','L2FestivalMonster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,1651,96,'129.00000','139.00000','99.00000','90.00000',230,8,0,333,158,0,0,45,155,1,1,0,1),
(18016,18016,'Offering of Branded Marksman',0,'',0,'LineageMonster.orc_archer_20_bi','16.00','30.00',32,'male','L2FestivalMonster',1100,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,1266,71,'283.00000','129.00000','85.00000','84.00000',230,8,0,333,273,0,0,45,130,1,1,0,1),
(18017,18017,'Offering of Branded Disciple',0,'',0,'LineageMonster.batur_orc','9.00','21.50',34,'male','L2FestivalMonster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,1651,96,'148.00000','164.00000','99.00000','90.00000',230,4,0,333,129,0,0,80,165,1,1,0,1),
(18018,18018,'Offering of Branded Saint',0,'',0,'LineageMonster.batur_orc_20_bi','10.00','25.30',39,'male','L2FestivalMonster',40,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,2172,138,'211.00000','195.00000','147.00000','107.00000',230,4,0,333,72,0,0,80,165,1,1,0,1),
(18019,18019,'Apostate\'s Offering Elder',0,'',0,'LineageMonster.orc_champion_20_bi','12.00','27.60',45,'male','L2FestivalMonster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,3013,210,'313.00000','238.00000','212.00000','131.00000',230,4,0,333,72,0,0,45,30,1,1,0,1),
(18020,18020,'Apostate\'s Offering',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',43,'male','L2FestivalMonster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,2751,186,'241.00000','190.00000','191.00000','123.00000',230,8,0,333,223,0,0,45,30,1,1,0,1),
(18021,18021,'Apostate\'s Offering Archer',0,'',0,'LineageMonster.batur_orc_archer','11.00','21.50',39,'male','L2FestivalMonster',1100,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,1880,119,'468.00000','166.00000','147.00000','107.00000',230,8,0,333,275,0,0,45,60,1,1,0,1),
(18022,18022,'Apostate\'s Offering Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10.00','20.00',40,'male','L2FestivalMonster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,1920,124,'226.00000','202.00000','157.00000','111.00000',230,4,0,333,127,0,0,80,115,1,1,0,1),
(18023,18023,'Apostate\'s Offering Follower',0,'',0,'LineageMonster.batur_orc_shaman','11.00','16.00',40,'male','L2FestivalMonster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,2296,148,'198.00000','172.00000','157.00000','111.00000',230,8,0,333,316,0,0,50,155,1,1,0,1),
(18024,18024,'Apostate\'s Offering Berserker',0,'',0,'LineageMonster.zenta_lizardman','11.00','32.00',48,'male','L2FestivalMonster',40,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,3832,280,'375.00000','262.00000','260.00000','144.00000',230,4,0,333,297,0,0,37,120,1,1,0,1),
(18025,18025,'Apostate\'s Offering Zealot',0,'',0,'LineageMonster.batur_orc_20_bi','10.00','25.30',45,'male','L2FestivalMonster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,2892,201,'273.00000','202.00000','212.00000','131.00000',230,8,0,333,172,0,0,80,160,1,1,0,1),
(18026,18026,'Apostate\'s Offering Marksman',0,'',0,'LineageMonster.batur_orc_archer_20_bi','13.00','25.30',43,'male','L2FestivalMonster',1100,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,2285,154,'611.00000','190.00000','191.00000','123.00000',230,8,0,333,277,0,0,45,135,1,1,0,1),
(18027,18027,'Apostate\'s Offering Disciple',0,'',0,'LineageMonster.batur_orc_overlord','12.00','24.00',45,'male','L2FestivalMonster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,2892,201,'313.00000','238.00000','212.00000','131.00000',230,4,0,333,74,0,0,80,170,1,1,0,1),
(18028,18028,'Apostate\'s Offering Saint',0,'',0,'LineageMonster.batur_orc_overlord_20_bi','14.00','28.80',50,'male','L2FestivalMonster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,3570,269,'421.00000','278.00000','286.00000','153.00000',230,4,0,333,133,0,0,80,170,1,1,0,1),
(18029,18029,'Witch\'s Offering Elder',0,'',0,'LineageMonster.batur_orc_warrior_20_bi','12.00','24.00',56,'male','L2FestivalMonster',40,'1725.00000','836.00000','6.50000','2.40000',40,43,30,21,20,20,4666,383,'583.00000','331.00000','404.00000','183.00000',230,4,0,333,133,0,0,80,30,1,1,0,1),
(18030,18030,'Witch\'s Offering',0,'',0,'LineageMonster.batur_orc','9.00','21.50',54,'male','L2FestivalMonster',40,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,4339,346,'460.00000','266.00000','364.00000','172.00000',230,8,0,333,226,0,0,80,30,1,1,0,1),
(18031,18031,'Witch\'s Offering Archer',0,'',0,'LineageMonster.batur_orc_archer','11.00','21.50',50,'male','L2FestivalMonster',1100,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,3090,233,'936.00000','237.00000','286.00000','153.00000',230,8,0,333,278,0,0,45,70,1,1,0,1),
(18032,18032,'Witch\'s Offering Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10.00','20.00',51,'male','L2FestivalMonster',40,'1470.00000','706.00000','6.50000','2.40000',40,43,30,21,20,20,3121,238,'446.00000','287.00000','309.00000','158.00000',230,4,0,333,72,0,0,80,120,1,1,0,1),
(18033,18033,'Witch\'s Offering Follower',0,'',0,'LineageMonster.batur_orc_shaman','11.00','16.00',51,'male','L2FestivalMonster',40,'1470.00000','706.00000','6.50000','2.40000',40,43,30,21,20,20,3733,285,'390.00000','244.00000','309.00000','158.00000',230,8,0,333,316,0,0,50,160,1,1,0,1),
(18034,18034,'Witch\'s Offering Berserker',0,'',0,'LineageMonster.virud_lizardman_warrior','12.00','30.00',59,'male','L2FestivalMonster',40,'1881.00000','916.00000','6.50000','2.40000',40,43,30,21,20,20,5790,495,'678.00000','359.00000','464.00000','198.00000',230,4,0,333,301,0,0,52,125,1,1,0,1),
(18035,18035,'Witch\'s Offering Zealot',0,'',0,'LineageMonster.batur_orc_20_bi','10.00','25.30',56,'male','L2FestivalMonster',40,'1725.00000','836.00000','6.50000','2.40000',40,43,30,21,20,20,4478,368,'511.00000','282.00000','404.00000','183.00000',230,8,0,333,91,0,0,80,165,1,1,0,1),
(18036,18036,'Witch\'s Offering Marksman',0,'',0,'LineageMonster.batur_orc_archer_20_bi','13.00','25.30',54,'male','L2FestivalMonster',1100,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,3604,287,'1168.00000','266.00000','364.00000','172.00000',230,8,0,333,282,0,0,45,140,1,1,0,1),
(18037,18037,'Witch\'s Offering Disciple',0,'',0,'LineageMonster.batur_orc_overlord','12.00','24.00',56,'male','L2FestivalMonster',40,'1725.00000','836.00000','6.50000','2.40000',40,43,30,21,20,20,4478,368,'583.00000','331.00000','404.00000','183.00000',230,4,0,333,135,0,0,80,175,1,1,0,1),
(18038,18038,'Witch\'s Offering Saint',0,'',0,'LineageMonster.batur_orc_overlord_20_bi','14.00','28.80',61,'male','L2FestivalMonster',40,'1985.00000','970.00000','7.50000','2.70000',40,43,30,21,20,20,5314,468,'745.00000','379.00000','510.00000','209.00000',230,4,0,333,79,0,0,80,175,1,1,0,1),
(18039,18039,'Dark Omen Offering Elder',0,'',0,'LineageMonster.batur_orc_warrior_20_bi','12.00','24.00',67,'male','L2FestivalMonster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,6680,636,'967.00000','439.00000','663.00000','242.00000',230,4,0,333,79,0,0,80,30,1,1,0,1),
(18040,18040,'Dark Omen Offering',0,'',0,'LineageMonster.batur_orc','9.00','21.50',65,'male','L2FestivalMonster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,6287,584,'779.00000','356.00000','615.00000','231.00000',230,8,0,333,234,0,0,80,30,1,1,0,1),
(18041,18041,'Dark Omen Offering Archer',0,'',0,'LineageMonster.batur_orc_archer','11.00','21.50',61,'male','L2FestivalMonster',1100,'1985.00000','970.00000','7.50000','2.70000',40,43,30,21,20,20,4599,405,'1656.00000','322.00000','510.00000','209.00000',230,8,0,333,283,0,0,45,70,1,1,0,1),
(18042,18042,'Dark Omen Offering Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10.00','20.00',62,'male','L2FestivalMonster',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,4613,411,'780.00000','389.00000','535.00000','214.00000',230,4,0,333,133,0,0,80,125,1,1,0,1),
(18043,18043,'Dark Omen Offering Follower',0,'',0,'LineageMonster.batur_orc_shaman','11.00','16.00',62,'male','L2FestivalMonster',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,5517,492,'683.00000','330.00000','535.00000','214.00000',230,8,0,333,316,0,0,50,165,1,1,0,1),
(18044,18044,'Dark Omen Offering Berserker',0,'',0,'LineageMonster.virud_lizardman_warrior','12.00','30.00',70,'male','L2FestivalMonster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,8150,808,'1086.00000','471.00000','749.00000','259.00000',230,4,0,333,97,0,0,52,130,1,1,0,1),
(18045,18045,'Dark Omen Offering Zealot',0,'',0,'LineageMonster.batur_orc_20_bi','10.00','25.30',67,'male','L2FestivalMonster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,6410,610,'846.00000','373.00000','663.00000','242.00000',230,8,0,333,2503,0,0,80,170,1,1,0,1),
(18046,18046,'Dark Omen Offering Marksman',0,'',0,'LineageMonster.batur_orc_archer_20_bi','13.00','25.30',65,'male','L2FestivalMonster',1100,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,5222,485,'1978.00000','356.00000','615.00000','231.00000',230,8,0,333,286,0,0,45,145,1,1,0,1),
(18047,18047,'Dark Omen Offering Disciple',0,'',0,'LineageMonster.batur_orc_overlord','12.00','24.00',67,'male','L2FestivalMonster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,6410,610,'967.00000','439.00000','663.00000','242.00000',230,4,0,333,142,0,0,80,180,1,1,0,1),
(18048,18048,'Dark Omen Offering Saint',0,'',0,'LineageMonster.batur_orc_overlord_20_bi','14.00','28.80',72,'male','L2FestivalMonster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,7403,752,'1168.00000','492.00000','801.00000','271.00000',230,4,0,333,2500,0,0,80,180,1,1,0,1),
(18049,18049,'Offering of Forbidden Path Elder',0,'',0,'LineageMonster.batur_orc_overlord_20_bi','14.00','28.80',78,'male','L2FestivalMonster',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,9053,991,'1418.00000','556.00000','973.00000','307.00000',230,4,0,333,2500,0,0,80,30,1,1,0,1),
(18050,18050,'Offering of Forbidden Path',0,'',0,'LineageMonster.batur_orc_warrior','10.00','20.00',76,'male','L2FestivalMonster',40,'2720.00000','1402.00000','8.50000','3.00000',40,43,30,21,20,20,8595,919,'1168.00000','454.00000','921.00000','294.00000',230,8,0,333,236,0,0,80,30,1,1,0,1),
(18051,18051,'Offering of Forbidden Path Archer',0,'',0,'LineageMonster.ketra_orc_archer','12.00','27.00',78,'male','L2FestivalMonster',1100,'3011.00000','1617.00000','8.77200','3.09060',40,43,30,21,20,20,8311,955,'3687.00000','525.00000','1175.00000','340.00000',230,8,0,333,287,0,0,45,70,1,1,0,1),
(18052,18052,'Offering of Forbidden Path Warrior',0,'',0,'LineageMonster.ketra_orc_warrior','12.00','24.00',78,'male','L2FestivalMonster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,7680,862,'1512.00000','581.00000','1058.00000','320.00000',230,4,0,333,79,0,0,36,130,1,1,0,1),
(18053,18053,'Offering of Forbidden Path Follower',0,'',0,'LineageMonster.ketra_orc_shaman','10.00','23.00',78,'male','L2FestivalMonster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,9185,1031,'1323.00000','494.00000','1058.00000','320.00000',230,8,0,333,316,0,0,10,180,1,1,0,1),
(18054,18054,'Offering of Forbidden Path Berserker',0,'',0,'LineageMonster.zenta_lizardman_warrior','13.00','35.00',78,'male','L2FestivalMonster',40,'2975.00000','1586.00000','8.72100','3.07020',40,43,30,21,20,20,10912,1239,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,305,0,0,40,135,1,1,0,1),
(18055,18055,'Offering of Forbidden Path Zealot',0,'',0,'LineageMonster.ketra_orc_20_bi','14.00','34.80',78,'male','L2FestivalMonster',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,8688,951,'1240.00000','472.00000','973.00000','307.00000',230,8,0,333,175,0,0,45,195,1,1,0,1),
(18056,18056,'Offering of Forbidden Path Marksman',0,'',0,'LineageMonster.ketra_orc_archer_20_bi','14.00','32.40',76,'male','L2FestivalMonster',1100,'2720.00000','1402.00000','8.50000','3.00000',40,43,30,21,20,20,7139,763,'2964.00000','454.00000','921.00000','294.00000',230,8,0,333,289,0,0,45,150,1,1,0,1),
(18057,18057,'Offering of Forbidden Path Disciple',0,'',0,'LineageMonster.ketra_orc_overload','12.00','24.00',78,'male','L2FestivalMonster',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,8688,951,'1418.00000','556.00000','973.00000','307.00000',230,4,0,333,151,0,0,33,195,1,1,0,1),
(18058,18058,'Offering of Forbidden Path Saint',0,'',0,'LineageMonster.ketra_orc_overload_20_bi','14.00','28.80',78,'male','L2FestivalMonster',40,'3045.00000','1649.00000','8.82300','3.11100',40,43,30,21,20,20,9837,1144,'1733.00000','636.00000','1236.00000','351.00000',230,4,0,333,2500,0,0,33,195,1,1,0,1),
(18059,18059,'Offering of Branded Elder',0,'',0,'LineageMonster.orc_fighter_bi','12.00','26.40',34,'male','L2FestivalMonster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,1720,100,'148.00000','164.00000','99.00000','90.00000',230,4,0,333,127,0,0,45,30,1,1,0,1),
(18060,18060,'Offering of the Branded',0,'',0,'LineageMonster.orc','10.00','21.00',32,'male','L2FestivalMonster',40,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,1524,86,'112.00000','129.00000','85.00000','84.00000',230,8,0,333,218,0,0,45,30,1,1,0,1),
(18061,18061,'Offering of Branded Archer',0,'',0,'LineageMonster.orc_archer','14.00','25.00',28,'male','L2FestivalMonster',1100,'544.00000','274.00000','3.50000','1.50000',40,43,30,21,20,20,1001,53,'208.00000','111.00000','67.00000','72.00000',230,8,0,333,14,0,0,45,60,1,1,0,1),
(18062,18062,'Offering of Branded Warrior',0,'',0,'LineageMonster.orc_champion','10.00','23.00',29,'male','L2FestivalMonster',40,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,1026,55,'101.00000','136.00000','72.00000','75.00000',230,4,0,333,125,0,0,45,110,1,1,0,1),
(18063,18063,'Offering of Branded Follower',0,'',0,'LineageMonster.orc_shaman','9.00','22.00',29,'male','L2FestivalMonster',40,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,1227,66,'88.00000','115.00000','72.00000','75.00000',230,8,0,333,316,0,0,45,150,1,1,0,1),
(18064,18064,'Offering of Branded Berserker',0,'',0,'LineageMonster.virud_lizardman','10.00','23.00',37,'male','L2FestivalMonster',40,'847.00000','393.00000','4.50000','1.80000',40,43,30,21,20,20,2277,140,'183.00000','182.00000','123.00000','100.00000',230,4,0,333,292,0,0,43,115,1,1,0,1),
(18065,18065,'Offering of Branded Zealot',0,'',0,'LineageMonster.orc_fighter_bi','12.00','26.40',34,'male','L2FestivalMonster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,1651,96,'129.00000','139.00000','99.00000','90.00000',230,8,0,333,158,0,0,45,155,1,1,0,1),
(18066,18066,'Offering of Branded Marksman',0,'',0,'LineageMonster.orc_archer_20_bi','16.00','30.00',32,'male','L2FestivalMonster',1100,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,1266,71,'283.00000','129.00000','85.00000','84.00000',230,8,0,333,273,0,0,45,130,1,1,0,1),
(18067,18067,'Offering of Branded Disciple',0,'',0,'LineageMonster.batur_orc','9.00','21.50',34,'male','L2FestivalMonster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,1651,96,'148.00000','164.00000','99.00000','90.00000',230,4,0,333,129,0,0,80,165,1,1,0,1),
(18068,18068,'Offering of Branded Saint',0,'',0,'LineageMonster.batur_orc_20_bi','10.00','25.30',39,'male','L2FestivalMonster',40,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,2172,138,'211.00000','195.00000','147.00000','107.00000',230,4,0,333,72,0,0,80,165,1,1,0,1),
(18069,18069,'Apostate\'s Offering Elder',0,'',0,'LineageMonster.orc_champion_20_bi','12.00','27.60',45,'male','L2FestivalMonster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,3013,210,'313.00000','238.00000','212.00000','131.00000',230,4,0,333,72,0,0,45,30,1,1,0,1),
(18070,18070,'Apostate\'s Offering',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',43,'male','L2FestivalMonster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,2751,186,'241.00000','190.00000','191.00000','123.00000',230,8,0,333,223,0,0,45,30,1,1,0,1),
(18071,18071,'Apostate\'s Offering Archer',0,'',0,'LineageMonster.batur_orc_archer','11.00','21.50',39,'male','L2FestivalMonster',1100,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,1880,119,'468.00000','166.00000','147.00000','107.00000',230,8,0,333,275,0,0,45,60,1,1,0,1),
(18072,18072,'Apostate\'s Offering Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10.00','20.00',40,'male','L2FestivalMonster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,1920,124,'226.00000','202.00000','157.00000','111.00000',230,4,0,333,127,0,0,80,115,1,1,0,1),
(18073,18073,'Apostate\'s Offering Follower',0,'',0,'LineageMonster.batur_orc_shaman','11.00','16.00',40,'male','L2FestivalMonster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,2296,148,'198.00000','172.00000','157.00000','111.00000',230,8,0,333,316,0,0,50,155,1,1,0,1),
(18074,18074,'Apostate\'s Offering Berserker',0,'',0,'LineageMonster.zenta_lizardman','11.00','32.00',48,'male','L2FestivalMonster',40,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,3832,280,'375.00000','262.00000','260.00000','144.00000',230,4,0,333,297,0,0,37,120,1,1,0,1),
(18075,18075,'Apostate\'s Offering Zealot',0,'',0,'LineageMonster.batur_orc_20_bi','10.00','25.30',45,'male','L2FestivalMonster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,2892,201,'273.00000','202.00000','212.00000','131.00000',230,8,0,333,172,0,0,80,160,1,1,0,1),
(18076,18076,'Apostate\'s Offering Marksman',0,'',0,'LineageMonster.batur_orc_archer_20_bi','13.00','25.30',43,'male','L2FestivalMonster',1100,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,2285,154,'611.00000','190.00000','191.00000','123.00000',230,8,0,333,277,0,0,45,135,1,1,0,1),
(18077,18077,'Apostate\'s Offering Disciple',0,'',0,'LineageMonster.batur_orc_overlord','12.00','24.00',45,'male','L2FestivalMonster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,2892,201,'313.00000','238.00000','212.00000','131.00000',230,4,0,333,74,0,0,80,170,1,1,0,1),
(18078,18078,'Apostate\'s Offering Saint',0,'',0,'LineageMonster.batur_orc_overlord_20_bi','14.00','28.80',50,'male','L2FestivalMonster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,3570,269,'421.00000','278.00000','286.00000','153.00000',230,4,0,333,133,0,0,80,170,1,1,0,1),
(18079,18079,'Witch\'s Offering Elder',0,'',0,'LineageMonster.batur_orc_warrior_20_bi','12.00','24.00',56,'male','L2FestivalMonster',40,'1725.00000','836.00000','6.50000','2.40000',40,43,30,21,20,20,4666,383,'583.00000','331.00000','404.00000','183.00000',230,4,0,333,133,0,0,80,30,1,1,0,1),
(18080,18080,'Witch\'s Offering',0,'',0,'LineageMonster.batur_orc','9.00','21.50',54,'male','L2FestivalMonster',40,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,4339,346,'460.00000','266.00000','364.00000','172.00000',230,8,0,333,226,0,0,80,30,1,1,0,1),
(18081,18081,'Witch\'s Offering Archer',0,'',0,'LineageMonster.batur_orc_archer','11.00','21.50',50,'male','L2FestivalMonster',1100,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,3090,233,'936.00000','237.00000','286.00000','153.00000',230,8,0,333,278,0,0,45,70,1,1,0,1),
(18082,18082,'Witch\'s Offering Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10.00','20.00',51,'male','L2FestivalMonster',40,'1470.00000','706.00000','6.50000','2.40000',40,43,30,21,20,20,3121,238,'446.00000','287.00000','309.00000','158.00000',230,4,0,333,72,0,0,80,120,1,1,0,1),
(18083,18083,'Witch\'s Offering Follower',0,'',0,'LineageMonster.batur_orc_shaman','11.00','16.00',51,'male','L2FestivalMonster',40,'1470.00000','706.00000','6.50000','2.40000',40,43,30,21,20,20,3733,285,'390.00000','244.00000','309.00000','158.00000',230,8,0,333,316,0,0,50,160,1,1,0,1),
(18084,18084,'Witch\'s Offering Berserker',0,'',0,'LineageMonster.virud_lizardman_warrior','12.00','30.00',59,'male','L2FestivalMonster',40,'1881.00000','916.00000','6.50000','2.40000',40,43,30,21,20,20,5790,495,'678.00000','359.00000','464.00000','198.00000',230,4,0,333,301,0,0,52,125,1,1,0,1),
(18085,18085,'Witch\'s Offering Zealot',0,'',0,'LineageMonster.batur_orc_20_bi','10.00','25.30',56,'male','L2FestivalMonster',40,'1725.00000','836.00000','6.50000','2.40000',40,43,30,21,20,20,4478,368,'511.00000','282.00000','404.00000','183.00000',230,8,0,333,91,0,0,80,165,1,1,0,1),
(18086,18086,'Witch\'s Offering Marksman',0,'',0,'LineageMonster.batur_orc_archer_20_bi','13.00','25.30',54,'male','L2FestivalMonster',1100,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,3604,287,'1168.00000','266.00000','364.00000','172.00000',230,8,0,333,282,0,0,45,140,1,1,0,1),
(18087,18087,'Witch\'s Offering Disciple',0,'',0,'LineageMonster.batur_orc_overlord','12.00','24.00',56,'male','L2FestivalMonster',40,'1725.00000','836.00000','6.50000','2.40000',40,43,30,21,20,20,4478,368,'583.00000','331.00000','404.00000','183.00000',230,4,0,333,135,0,0,80,175,1,1,0,1),
(18088,18088,'Witch\'s Offering Saint',0,'',0,'LineageMonster.batur_orc_overlord_20_bi','14.00','28.80',61,'male','L2FestivalMonster',40,'1985.00000','970.00000','7.50000','2.70000',40,43,30,21,20,20,5314,468,'745.00000','379.00000','510.00000','209.00000',230,4,0,333,79,0,0,80,175,1,1,0,1),
(18089,18089,'Dark Omen Offering Elder',0,'',0,'LineageMonster.batur_orc_warrior_20_bi','12.00','24.00',67,'male','L2FestivalMonster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,6680,636,'967.00000','439.00000','663.00000','242.00000',230,4,0,333,79,0,0,80,30,1,1,0,1),
(18090,18090,'Dark Omen Offering',0,'',0,'LineageMonster.batur_orc','9.00','21.50',65,'male','L2FestivalMonster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,6287,584,'779.00000','356.00000','615.00000','231.00000',230,8,0,333,234,0,0,80,30,1,1,0,1),
(18091,18091,'Dark Omen Offering Archer',0,'',0,'LineageMonster.batur_orc_archer','11.00','21.50',61,'male','L2FestivalMonster',1100,'1985.00000','970.00000','7.50000','2.70000',40,43,30,21,20,20,4599,405,'1656.00000','322.00000','510.00000','209.00000',230,8,0,333,283,0,0,45,70,1,1,0,1),
(18092,18092,'Dark Omen Offering Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10.00','20.00',62,'male','L2FestivalMonster',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,4613,411,'780.00000','389.00000','535.00000','214.00000',230,4,0,333,133,0,0,80,125,1,1,0,1),
(18093,18093,'Dark Omen Offering Follower',0,'',0,'LineageMonster.batur_orc_shaman','11.00','16.00',62,'male','L2FestivalMonster',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,5517,492,'683.00000','330.00000','535.00000','214.00000',230,8,0,333,316,0,0,50,165,1,1,0,1),
(18094,18094,'Dark Omen Offering Berserker',0,'',0,'LineageMonster.virud_lizardman_warrior','12.00','30.00',70,'male','L2FestivalMonster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,8150,808,'1086.00000','471.00000','749.00000','259.00000',230,4,0,333,97,0,0,52,130,1,1,0,1),
(18095,18095,'Dark Omen Offering Zealot',0,'',0,'LineageMonster.batur_orc_20_bi','10.00','25.30',67,'male','L2FestivalMonster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,6410,610,'846.00000','373.00000','663.00000','242.00000',230,8,0,333,2503,0,0,80,170,1,1,0,1),
(18096,18096,'Dark Omen Offering Marksman',0,'',0,'LineageMonster.batur_orc_archer_20_bi','13.00','25.30',65,'male','L2FestivalMonster',1100,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,5222,485,'1978.00000','356.00000','615.00000','231.00000',230,8,0,333,286,0,0,45,145,1,1,0,1),
(18097,18097,'Dark Omen Offering Disciple',0,'',0,'LineageMonster.batur_orc_overlord','12.00','24.00',67,'male','L2FestivalMonster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,6410,610,'967.00000','439.00000','663.00000','242.00000',230,4,0,333,142,0,0,80,180,1,1,0,1),
(18098,18098,'Dark Omen Offering Saint',0,'',0,'LineageMonster.batur_orc_overlord_20_bi','14.00','28.80',72,'male','L2FestivalMonster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,7403,752,'1168.00000','492.00000','801.00000','271.00000',230,4,0,333,2500,0,0,80,180,1,1,0,1),
(18099,18099,'Offering of Forbidden Path Elder',0,'',0,'LineageMonster.batur_orc_overlord_20_bi','14.00','28.80',78,'male','L2FestivalMonster',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,9053,991,'1418.00000','556.00000','973.00000','307.00000',230,4,0,333,2500,0,0,80,30,1,1,0,1),
(18100,18100,'Offering of Forbidden Path',0,'',0,'LineageMonster.batur_orc_warrior','10.00','20.00',76,'male','L2FestivalMonster',40,'2720.00000','1402.00000','8.50000','3.00000',40,43,30,21,20,20,8595,919,'1168.00000','454.00000','921.00000','294.00000',230,8,0,333,236,0,0,80,30,1,1,0,1),
(18101,18101,'Offering of Forbidden Path Archer',0,'',0,'LineageMonster.ketra_orc_archer','12.00','27.00',78,'male','L2FestivalMonster',1100,'3011.00000','1617.00000','8.77200','3.09060',40,43,30,21,20,20,8311,955,'3687.00000','525.00000','1175.00000','340.00000',230,8,0,333,287,0,0,45,70,1,1,0,1),
(18102,18102,'Offering of Forbidden Path Warrior',0,'',0,'LineageMonster.ketra_orc_warrior','12.00','24.00',78,'male','L2FestivalMonster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,7680,862,'1512.00000','581.00000','1058.00000','320.00000',230,4,0,333,79,0,0,36,130,1,1,0,1),
(18103,18103,'Offering of Forbidden Path Follower',0,'',0,'LineageMonster.ketra_orc_shaman','10.00','23.00',78,'male','L2FestivalMonster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,9185,1031,'1323.00000','494.00000','1058.00000','320.00000',230,8,0,333,316,0,0,10,180,1,1,0,1),
(18104,18104,'Offering of Forbidden Path Berserker',0,'',0,'LineageMonster.zenta_lizardman_warrior','13.00','35.00',78,'male','L2FestivalMonster',40,'2975.00000','1586.00000','8.72100','3.07020',40,43,30,21,20,20,10912,1239,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,305,0,0,40,135,1,1,0,1),
(18105,18105,'Offering of Forbidden Path Zealot',0,'',0,'LineageMonster.ketra_orc_20_bi','14.00','34.80',78,'male','L2FestivalMonster',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,8688,951,'1240.00000','472.00000','973.00000','307.00000',230,8,0,333,175,0,0,45,195,1,1,0,1),
(18106,18106,'Offering of Forbidden Path Marksman',0,'',0,'LineageMonster.ketra_orc_archer_20_bi','14.00','32.40',76,'male','L2FestivalMonster',1100,'2720.00000','1402.00000','8.50000','3.00000',40,43,30,21,20,20,7139,763,'2964.00000','454.00000','921.00000','294.00000',230,8,0,333,289,0,0,45,150,1,1,0,1),
(18107,18107,'Offering of Forbidden Path Disciple',0,'',0,'LineageMonster.ketra_orc_overload','12.00','24.00',78,'male','L2FestivalMonster',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,8688,951,'1418.00000','556.00000','973.00000','307.00000',230,4,0,333,151,0,0,33,195,1,1,0,1),
(18108,18108,'Offering of Forbidden Path Saint',0,'',0,'LineageMonster.ketra_orc_overload_20_bi','14.00','28.80',78,'male','L2FestivalMonster',40,'3045.00000','1649.00000','8.82300','3.11100',40,43,30,21,20,20,9837,1144,'1733.00000','636.00000','1236.00000','351.00000',230,4,0,333,2500,0,0,33,195,1,1,0,1),
(18109,18109,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.50','8.50',30,'male','L2FestivalMonster',40,'633.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,90,0,'0.00000','141.00000','2.00000','78.00000',230,1,0,0,0,0,0,80,195,1,1,0,1),
(18110,18110,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.50','8.50',41,'male','L2FestivalMonster',40,'942.00000','459.00000','5.50000','2.10000',40,43,30,21,20,20,168,0,'0.00000','209.00000','2.00000','115.00000',230,1,0,0,0,0,0,80,195,1,1,0,1),
(18111,18111,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.50','8.50',52,'male','L2FestivalMonster',40,'1303.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,270,0,'0.00000','295.00000','2.00000','163.00000',230,1,0,0,0,0,0,80,195,1,1,0,1),
(18112,18112,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.50','8.50',63,'male','L2FestivalMonster',40,'1672.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,397,0,'0.00000','399.00000','2.00000','220.00000',230,1,0,0,0,0,0,80,195,1,1,0,1),
(18113,18113,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.50','8.50',72,'male','L2FestivalMonster',40,'1939.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,518,0,'0.00000','492.00000','2.00000','271.00000',230,1,0,0,0,0,0,80,195,1,1,0,1),
(18114,18114,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.50','8.50',30,'male','L2FestivalMonster',40,'633.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,90,0,'0.00000','141.00000','2.00000','78.00000',230,1,0,0,0,0,0,80,195,1,1,0,1),
(18115,18115,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.50','8.50',41,'male','L2FestivalMonster',40,'942.00000','459.00000','5.50000','2.10000',40,43,30,21,20,20,168,0,'0.00000','209.00000','2.00000','115.00000',230,1,0,0,0,0,0,80,195,1,1,0,1),
(18116,18116,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.50','8.50',52,'male','L2FestivalMonster',40,'1303.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,270,0,'0.00000','295.00000','2.00000','163.00000',230,1,0,0,0,0,0,80,195,1,1,0,1),
(18117,18117,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.50','8.50',63,'male','L2FestivalMonster',40,'1672.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,397,0,'0.00000','399.00000','2.00000','220.00000',230,1,0,0,0,0,0,80,195,1,1,0,1),
(18118,18118,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.50','8.50',72,'male','L2FestivalMonster',40,'1939.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,518,0,'0.00000','492.00000','2.00000','271.00000',230,1,0,0,0,0,0,80,195,1,1,0,1),
(18119,18119,'Corpse of Deadman',0,'',0,'LineageMonster.zombie_corpse','13.00','21.00',63,'male','L2Monster',40,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'816.00000','399.00000','559.00000','220.00000',230,4,0,333,0,0,0,15,1,1,1,0,1),
(18120,18120,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9.00','36.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,58584,6652,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,134,6721,0,39,150,1,1,0,1),
(18121,18121,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9.00','36.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,55563,6309,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,134,6721,0,39,150,1,1,0,1),
(18122,18122,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9.00','36.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,42434,4818,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,134,6721,0,39,150,1,1,0,1),
(18123,18123,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9.00','36.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,58584,6652,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,134,6721,0,39,150,1,1,0,1),
(18124,18124,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9.00','36.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,55563,6309,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,134,6721,0,39,150,1,1,0,1),
(18125,18125,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9.00','36.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,42434,4818,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,134,6721,0,39,150,1,1,0,1),
(18126,18126,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9.00','36.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,58584,6652,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,134,6721,0,39,150,1,1,0,1),
(18127,18127,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9.00','36.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,55563,6309,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,134,6721,0,39,150,1,1,0,1),
(18128,18128,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9.00','36.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,42434,4818,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,134,6721,0,39,150,1,1,0,1),
(18129,18129,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9.00','36.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,58584,6652,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,134,6721,0,39,150,1,1,0,1),
(18130,18130,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9.00','36.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,55563,6309,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,134,6721,0,39,150,1,1,0,1),
(18131,18131,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9.00','36.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,42434,4818,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,134,6721,0,39,150,1,1,0,1),
(18132,18132,'Imperial Healer',0,'',0,'LineageMonster2.tera_beetle','19.00','54.50',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,59699,6779,'1311.00000','798.00000','762.00000','440.00000',230,4,0,333,0,0,0,45,170,1,1,0,1),
(18133,18133,'Imperial Mosaic',0,'',0,'LineageMonster2.scorpion','28.00','66.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,55141,6261,'1388.00000','600.00000','1116.00000','330.00000',230,8,0,333,0,0,0,37,170,1,1,0,1),
(18134,18134,'Imperial Mosaic',0,'',0,'LineageMonster2.scorpion','28.00','66.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,41438,4705,'1388.00000','600.00000','1116.00000','330.00000',230,8,0,333,0,0,0,37,170,1,1,0,1),
(18135,18135,'Imperial Mosaic',0,'',0,'LineageMonster2.scorpion','28.00','66.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,54900,6234,'1388.00000','600.00000','1116.00000','330.00000',230,8,0,333,0,0,0,37,170,1,1,0,1),
(18136,18136,'Imperial Mosaic',0,'',0,'LineageMonster2.scorpion','28.00','66.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,55141,6261,'1262.00000','726.00000','927.00000','400.00000',230,8,0,333,0,0,0,37,170,1,1,0,1),
(18137,18137,'Imperial Mosaic',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,40876,4641,'1587.00000','600.00000','1116.00000','330.00000',230,1,0,333,0,0,0,45,180,1,1,0,1),
(18138,18138,'Imperial Mosaic',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,54418,6179,'1587.00000','600.00000','1116.00000','330.00000',230,1,0,333,0,0,0,45,180,1,1,0,1),
(18139,18139,'Imperial Mosaic',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,53615,6088,'1587.00000','600.00000','1116.00000','330.00000',230,1,0,333,0,0,0,45,180,1,1,0,1),
(18140,18140,'Imperial Mosaic',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,54394,6176,'1443.00000','726.00000','927.00000','400.00000',230,1,0,333,0,0,0,45,180,1,1,0,1),
(18141,18141,'Beetle of Grave',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','34.88400','3.07020',40,43,30,21,20,20,34982,3972,'2555.00000','410.00000','2906.00000','226.00000',230,1,0,333,0,0,0,45,180,1,1,0,1),
(18142,18142,'Beetle of Grave',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','34.88400','3.07020',40,43,30,21,20,20,34982,3972,'2555.00000','410.00000','2906.00000','226.00000',230,1,0,333,0,0,0,45,180,1,1,0,1),
(18143,18143,'Beetle of Grave',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','34.88400','3.07020',40,43,30,21,20,20,34982,3972,'2555.00000','410.00000','2906.00000','226.00000',230,1,0,333,0,0,0,45,180,1,1,0,1),
(18144,18144,'Beetle of Grave',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','34.88400','3.07020',40,43,30,21,20,20,34982,3972,'2555.00000','410.00000','2906.00000','226.00000',230,1,0,333,0,0,0,45,180,1,1,0,1),
(18145,18145,'Beetle of Grave',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','34.88400','3.07020',40,43,30,21,20,20,29597,3361,'2112.00000','496.00000','1980.00000','273.00000',230,1,0,333,0,0,0,45,180,1,1,0,1),
(18146,18146,'Beetle of Grave',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','34.88400','3.07020',40,43,30,21,20,20,30276,3438,'2112.00000','496.00000','1980.00000','273.00000',230,1,0,333,0,0,0,45,180,1,1,0,1),
(18147,18147,'Beetle of Grave',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','34.88400','3.07020',40,43,30,21,20,20,28188,3201,'2112.00000','496.00000','1980.00000','273.00000',230,1,0,333,0,0,0,45,180,1,1,0,1),
(18148,18148,'Beetle of Grave',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','34.88400','3.07020',40,43,30,21,20,20,32814,3726,'2112.00000','496.00000','1980.00000','273.00000',230,1,0,333,0,0,0,45,180,1,1,0,1),
(18149,18149,'Beetle of Grave',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','34.88400','3.07020',40,43,30,21,20,20,28991,3292,'2112.00000','496.00000','1980.00000','273.00000',230,1,0,333,0,0,0,45,180,1,1,0,1),
(18150,18150,'Victim',0,'',0,'LineageNPC.a_tombkeeperA','7.00','23.00',78,'female','L2SepulcherMonster',40,'2975.00000','1586.00000','8.72100','3.07020',40,43,30,21,20,20,0,0,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18151,18151,'Victim',0,'',0,'LineageNPC.a_tombkeeperA','7.00','23.00',78,'female','L2SepulcherMonster',40,'2975.00000','1586.00000','8.72100','3.07020',40,43,30,21,20,20,0,0,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18152,18152,'Victim',0,'',0,'LineageNPC.a_tombkeeperA','7.00','23.00',78,'female','L2SepulcherMonster',40,'2975.00000','1586.00000','8.72100','3.07020',40,43,30,21,20,20,0,0,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18153,18153,'Victim',0,'',0,'LineageNPC.a_tombkeeperA','7.00','23.00',78,'female','L2SepulcherMonster',40,'2975.00000','1586.00000','8.72100','3.07020',40,43,30,21,20,20,0,0,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18154,18154,'Victim',0,'',0,'LineageNPC.a_tombkeeperA','7.00','23.00',78,'female','L2SepulcherMonster',40,'2975.00000','1586.00000','8.72100','3.07020',40,43,30,21,20,20,0,0,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18155,18155,'Victim',0,'',0,'LineageNPC.a_tombkeeperA','7.00','23.00',78,'female','L2SepulcherMonster',40,'2975.00000','1586.00000','8.72100','3.07020',40,43,30,21,20,20,0,0,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18156,18156,'Victim',0,'',0,'LineageNPC.a_tombkeeperA','7.00','23.00',78,'female','L2SepulcherMonster',40,'2975.00000','1586.00000','8.72100','3.07020',40,43,30,21,20,20,0,0,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18157,18157,'Victim',0,'',0,'LineageNPC.a_tombkeeperA','7.00','23.00',78,'female','L2SepulcherMonster',40,'2975.00000','1586.00000','8.72100','3.07020',40,43,30,21,20,20,0,0,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18158,18158,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes','21.00','50.00',78,'male','L2SepulcherMonster',40,'17851.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,0,0,'1919.00000','1051.00000','1636.00000','301.00000',230,1,0,333,0,0,0,31,150,1,1,0,1),
(18159,18159,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes','21.00','50.00',78,'male','L2SepulcherMonster',40,'17851.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,0,0,'1919.00000','545.00000','1636.00000','580.00000',230,1,0,333,0,0,0,31,150,1,1,0,1),
(18160,18160,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes','21.00','50.00',78,'male','L2SepulcherMonster',40,'17851.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,0,0,'1919.00000','1051.00000','1636.00000','301.00000',230,1,0,333,0,0,0,31,150,1,1,0,1),
(18161,18161,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes','21.00','50.00',78,'male','L2SepulcherMonster',40,'17851.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,0,0,'1919.00000','545.00000','1636.00000','580.00000',230,1,0,333,0,0,0,31,150,1,1,0,1),
(18162,18162,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes','21.00','50.00',78,'male','L2SepulcherMonster',40,'17851.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,0,0,'1919.00000','1051.00000','1636.00000','301.00000',230,1,0,333,0,0,0,31,150,1,1,0,1),
(18163,18163,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes','21.00','50.00',78,'male','L2SepulcherMonster',40,'17851.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,0,0,'1919.00000','545.00000','1636.00000','580.00000',230,1,0,333,0,0,0,31,150,1,1,0,1),
(18164,18164,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes','21.00','50.00',78,'male','L2SepulcherMonster',40,'17851.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,0,0,'1919.00000','1051.00000','1636.00000','301.00000',230,1,0,333,0,0,0,31,150,1,1,0,1),
(18165,18165,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes','21.00','50.00',78,'male','L2SepulcherMonster',40,'17851.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,0,0,'1919.00000','545.00000','1636.00000','580.00000',230,1,0,333,0,0,0,31,150,1,1,0,1),
(18166,18166,'Imperial Guard',0,'',0,'LineageMonster.death_knight','12.00','30.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,42032,4773,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,142,0,0,27,110,1,1,0,1),
(18167,18167,'Imperial Guard',0,'',0,'LineageMonster.death_knight','12.00','30.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,41438,4705,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,142,0,0,27,110,1,1,0,1),
(18168,18168,'Imperial Guard',0,'',0,'LineageMonster.death_knight','12.00','30.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,42595,4837,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,142,0,0,27,110,1,1,0,1),
(18169,18169,'Imperial Guard',0,'',0,'LineageMonster.death_knight','12.00','30.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,41237,4683,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,142,0,0,27,110,1,1,0,1),
(18170,18170,'Imperial Guard',0,'',0,'LineageMonster.doll_master','20.00','42.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,41278,4687,'1848.00000','496.00000','1980.00000','273.00000',230,8,0,333,0,0,0,80,160,1,1,0,1),
(18171,18171,'Imperial Guard',0,'',0,'LineageMonster.doll_master','20.00','42.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,42884,4869,'1148.00000','798.00000','762.00000','440.00000',230,8,0,333,0,0,0,80,160,1,1,0,1),
(18172,18172,'Imperial Guard',0,'',0,'LineageMonster.doll_master','20.00','42.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,40876,4641,'1388.00000','600.00000','1116.00000','330.00000',230,8,0,333,0,0,0,80,160,1,1,0,1),
(18173,18173,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,45345,5149,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,0,0,0,37,160,1,1,0,1),
(18174,18174,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,55932,6351,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,0,0,0,37,160,1,1,0,1),
(18175,18175,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,42803,4860,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,0,0,0,37,160,1,1,0,1),
(18176,18176,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,45345,5149,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,0,0,0,37,160,1,1,0,1),
(18177,18177,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,55932,6351,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,0,0,0,37,160,1,1,0,1),
(18178,18178,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,42803,4860,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,0,0,0,37,160,1,1,0,1),
(18179,18179,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,45345,5149,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,0,0,0,37,160,1,1,0,1),
(18180,18180,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,55932,6351,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,0,0,0,37,160,1,1,0,1),
(18181,18181,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,42803,4860,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,0,0,0,37,160,1,1,0,1),
(18182,18182,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,45345,5149,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,0,0,0,37,160,1,1,0,1),
(18183,18183,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,55932,6351,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,0,0,0,37,160,1,1,0,1),
(18184,18184,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,42803,4860,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,0,0,0,37,160,1,1,0,1),
(18185,18185,'Evil Astrologer',0,'',0,'LineageMonster.doll_blader','6.00','12.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,56482,6414,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,5129,5129,0,22,150,1,1,0,1),
(18186,18186,'Evil Astrologer',0,'',0,'LineageMonster.doll_blader','6.00','12.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,56803,6450,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,5129,5129,0,22,150,1,1,0,1),
(18187,18187,'Knight of Darkness',0,'',0,'LineageMonster.death_lord','21.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,55141,6261,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,78,0,0,40,160,1,1,0,1),
(18188,18188,'Knight of Darkness',0,'',0,'LineageMonster.death_lord','21.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,41438,4705,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,78,0,0,40,160,1,1,0,1),
(18189,18189,'Knight of Darkness',0,'',0,'LineageMonster.death_lord','21.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,54900,6234,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,78,0,0,40,160,1,1,0,1),
(18190,18190,'Knight of Darkness',0,'',0,'LineageMonster.death_lord','21.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,55141,6261,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,78,0,0,40,160,1,1,0,1),
(18191,18191,'Witch of dust',0,'',0,'LineageMonster.banshee','9.00','23.00',78,'female','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,40876,4641,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,3939,0,0,80,160,1,1,0,1),
(18192,18192,'Witch of dust',0,'',0,'LineageMonster.banshee','9.00','23.00',78,'female','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,54418,6179,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,3939,0,0,80,160,1,1,0,1),
(18193,18193,'Witch of dust',0,'',0,'LineageMonster.banshee','9.00','23.00',78,'female','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,53615,6088,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,3939,0,0,80,160,1,1,0,1),
(18194,18194,'Witch of dust',0,'',0,'LineageMonster.banshee','9.00','23.00',78,'female','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,54394,6176,'1919.00000','545.00000','1636.00000','301.00000',230,4,0,333,3939,0,0,80,160,1,1,0,1),
(18195,18195,'Signet of Emperor',0,'',0,'LineageMonster.ant_larva','12.00','8.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,41679,4733,'2555.00000','410.00000','2906.00000','226.00000',230,4,0,333,0,0,0,40,60,1,1,0,1),
(18196,18196,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,136143,15459,'1083.00000','966.00000','520.00000','533.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18197,18197,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,136143,15459,'1083.00000','966.00000','520.00000','533.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18198,18198,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,136143,15459,'1083.00000','966.00000','520.00000','533.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18199,18199,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,136143,15459,'1083.00000','966.00000','520.00000','533.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18200,18200,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,136143,15459,'1083.00000','966.00000','520.00000','533.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18201,18201,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,136143,15459,'1083.00000','966.00000','520.00000','533.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18202,18202,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,136143,15459,'1083.00000','966.00000','520.00000','533.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18203,18203,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,136143,15459,'1083.00000','966.00000','520.00000','533.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18204,18204,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,136143,15459,'1083.00000','966.00000','520.00000','533.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18205,18205,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,136143,15459,'1083.00000','966.00000','520.00000','533.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18206,18206,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,136143,15459,'1083.00000','966.00000','520.00000','533.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18207,18207,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,136143,15459,'1083.00000','966.00000','520.00000','533.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18208,18208,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,136143,15459,'1083.00000','966.00000','520.00000','533.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18209,18209,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,136143,15459,'1083.00000','966.00000','520.00000','533.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18210,18210,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,136143,15459,'1083.00000','966.00000','520.00000','533.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18211,18211,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,136143,15459,'1083.00000','966.00000','520.00000','533.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18212,18212,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes','14.00','57.75',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,173610,19713,'1311.00000','798.00000','762.00000','440.00000',230,4,0,333,6722,0,0,35,185,1,1,0,1),
(18213,18213,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes','14.00','57.75',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,173610,19713,'1311.00000','798.00000','762.00000','440.00000',230,4,0,333,6722,0,0,35,185,1,1,0,1),
(18214,18214,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes','14.00','57.75',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,173610,19713,'1311.00000','798.00000','762.00000','440.00000',230,4,0,333,6722,0,0,35,185,1,1,0,1),
(18215,18215,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes','14.00','57.75',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,173610,19713,'1311.00000','798.00000','762.00000','440.00000',230,4,0,333,6722,0,0,35,185,1,1,0,1),
(18216,18216,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes','14.00','57.75',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,173610,19713,'1311.00000','798.00000','762.00000','440.00000',230,4,0,333,6722,0,0,35,185,1,1,0,1),
(18217,18217,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes','14.00','57.75',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,173610,19713,'1311.00000','798.00000','762.00000','440.00000',230,4,0,333,6722,0,0,35,185,1,1,0,1),
(18218,18218,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes','14.00','57.75',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,173610,19713,'1311.00000','798.00000','762.00000','440.00000',230,4,0,333,6722,0,0,35,185,1,1,0,1),
(18219,18219,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes','14.00','57.75',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,173610,19713,'1311.00000','798.00000','762.00000','440.00000',230,4,0,333,6722,0,0,35,185,1,1,0,1),
(18220,18220,'Shaman of Darkness',0,'',0,'LineageMonster.banshee','9.00','23.00',78,'female','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,56803,6450,'1745.00000','600.00000','1357.00000','330.00000',230,4,0,333,3939,0,0,80,160,1,1,0,1),
(18221,18221,'Shaman of Darkness',0,'',0,'LineageMonster.banshee','9.00','23.00',78,'female','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,58329,6623,'1745.00000','600.00000','1357.00000','330.00000',230,4,0,333,3939,0,0,80,160,1,1,0,1),
(18222,18222,'Assassin of Darkness',0,'',0,'LineageMonster2.ashuras','13.00','37.50',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,55261,6275,'2112.00000','496.00000','1980.00000','273.00000',230,4,0,333,0,0,0,41,190,1,1,0,1),
(18223,18223,'Assassin of Darkness',0,'',0,'LineageMonster2.ashuras','13.00','37.50',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,41438,4705,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,0,0,0,41,190,1,1,0,1),
(18224,18224,'Assassin of Darkness',0,'',0,'LineageMonster2.ashuras','13.00','37.50',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,55823,6339,'2112.00000','496.00000','1980.00000','273.00000',230,4,0,333,0,0,0,41,190,1,1,0,1),
(18225,18225,'Assassin of Darkness',0,'',0,'LineageMonster2.ashuras','13.00','37.50',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,55261,6275,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,0,0,0,41,190,1,1,0,1),
(18226,18226,'Caster of Darkness',0,'',0,'LineageMonster.vale_master','12.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,40876,4641,'2112.00000','496.00000','1980.00000','273.00000',230,4,0,333,0,0,0,70,155,1,1,0,1),
(18227,18227,'Caster of Darkness',0,'',0,'LineageMonster.vale_master','12.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,70240,7976,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,0,0,0,70,155,1,1,0,1),
(18228,18228,'Caster of Darkness',0,'',0,'LineageMonster.vale_master','12.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,52812,5997,'2112.00000','496.00000','1980.00000','273.00000',230,4,0,333,0,0,0,70,155,1,1,0,1),
(18229,18229,'Caster of Darkness',0,'',0,'LineageMonster.vale_master','12.00','40.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,54394,6176,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,0,0,0,70,155,1,1,0,1),
(18230,18230,'Signet of Emperor',0,'',0,'LineageMonster.ant_larva','12.00','8.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','26.16300','3.07020',40,43,30,21,20,20,22486,2553,'2555.00000','410.00000','2906.00000','226.00000',230,4,0,333,0,0,0,40,60,1,1,0,1),
(18231,18231,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15.00','42.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,66895,7596,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,5795,0,0,53,140,1,1,0,1),
(18232,18232,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15.00','42.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,66895,7596,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,5795,0,0,53,140,1,1,0,1),
(18233,18233,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15.00','42.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,66895,7596,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,5795,0,0,53,140,1,1,0,1),
(18234,18234,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15.00','42.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,66895,7596,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,5795,0,0,53,140,1,1,0,1),
(18235,18235,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15.00','42.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,66895,7596,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,5795,0,0,53,140,1,1,0,1),
(18236,18236,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15.00','42.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,66895,7596,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,5795,0,0,53,140,1,1,0,1),
(18237,18237,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15.00','42.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,66895,7596,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,5795,0,0,53,140,1,1,0,1),
(18238,18238,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15.00','42.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,66895,7596,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,5795,0,0,53,140,1,1,0,1),
(18239,18239,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15.00','42.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,66895,7596,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,5795,0,0,53,140,1,1,0,1),
(18240,18240,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15.00','42.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,66895,7596,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,5795,0,0,53,140,1,1,0,1),
(18241,18241,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15.00','42.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,66895,7596,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,5795,0,0,53,140,1,1,0,1),
(18242,18242,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15.00','42.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,66895,7596,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,5795,0,0,53,140,1,1,0,1),
(18243,18243,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15.00','42.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','52.32600','3.07020',40,43,30,21,20,20,66895,7596,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,5795,0,0,53,140,1,1,0,1),
(18244,18244,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11.00','20.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','26.16300','3.07020',40,43,30,21,20,20,0,0,'2112.00000','496.00000','1980.00000','273.00000',230,4,0,333,0,0,0,90,1,1,1,0,1),
(18245,18245,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11.00','20.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','26.16300','3.07020',40,43,30,21,20,20,0,0,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,0,0,0,90,1,1,1,0,1),
(18246,18246,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11.00','20.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','26.16300','3.07020',40,43,30,21,20,20,0,0,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,0,0,0,90,1,1,1,0,1),
(18247,18247,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11.00','20.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','26.16300','3.07020',40,43,30,21,20,20,0,0,'2112.00000','496.00000','1980.00000','273.00000',230,4,0,333,0,0,0,90,1,1,1,0,1),
(18248,18248,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11.00','20.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','26.16300','3.07020',40,43,30,21,20,20,0,0,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,0,0,0,90,1,1,1,0,1),
(18249,18249,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11.00','20.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','26.16300','3.07020',40,43,30,21,20,20,0,0,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,0,0,0,90,1,1,1,0,1),
(18250,18250,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11.00','20.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','26.16300','3.07020',40,43,30,21,20,20,0,0,'2112.00000','496.00000','1980.00000','273.00000',230,4,0,333,0,0,0,90,1,1,1,0,1),
(18251,18251,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11.00','20.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','26.16300','3.07020',40,43,30,21,20,20,0,0,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,0,0,0,90,1,1,1,0,1),
(18252,18252,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11.00','20.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','26.16300','3.07020',40,43,30,21,20,20,0,0,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,0,0,0,90,1,1,1,0,1),
(18253,18253,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11.00','20.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','26.16300','3.07020',40,43,30,21,20,20,0,0,'2112.00000','496.00000','1980.00000','273.00000',230,4,0,333,0,0,0,90,1,1,1,0,1),
(18254,18254,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11.00','20.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','26.16300','3.07020',40,43,30,21,20,20,0,0,'1443.00000','726.00000','927.00000','400.00000',230,4,0,333,0,0,0,90,1,1,1,0,1),
(18255,18255,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11.00','20.00',78,'male','L2SepulcherMonster',40,'2975.00000','1586.00000','26.16300','3.07020',40,43,30,21,20,20,0,0,'1587.00000','600.00000','1116.00000','330.00000',230,4,0,333,0,0,0,90,1,1,1,0,1),
(18256,18256,'Halisha\'s Treasure Box',0,'',0,'LineageMonster.mimic','8.50','8.50',78,'male','L2SepulcherMonster',40,'1.00000','1.00000','0.00000','0.00000',40,43,30,21,20,20,0,0,'2.00000','2.00000','4.00000','2.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18257,18257,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',78,'male','L2Monster',40,'3365.00000','1798.00000','3.21000','3.21000',40,43,30,21,20,20,0,0,'1742.00000','667.00000','1280.00000','368.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18258,18258,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',78,'male','L2Monster',40,'3365.00000','1798.00000','3.21000','3.21000',40,43,30,21,20,20,0,0,'1742.00000','667.00000','1280.00000','368.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18259,18259,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',78,'male','L2Monster',40,'3365.00000','1798.00000','3.21000','3.21000',40,43,30,21,20,20,0,0,'1742.00000','667.00000','1280.00000','368.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18260,18260,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',78,'male','L2Monster',40,'3365.00000','1798.00000','3.21000','3.21000',40,43,30,21,20,20,0,0,'1742.00000','667.00000','1280.00000','368.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18261,18261,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',78,'male','L2Monster',40,'3365.00000','1798.00000','3.21000','3.21000',40,43,30,21,20,20,0,0,'1742.00000','667.00000','1280.00000','368.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18262,18262,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',78,'male','L2Monster',40,'3365.00000','1798.00000','3.21000','3.21000',40,43,30,21,20,20,0,0,'1742.00000','667.00000','1280.00000','368.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18263,18263,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',78,'male','L2Monster',40,'3365.00000','1798.00000','3.21000','3.21000',40,43,30,21,20,20,0,0,'1742.00000','667.00000','1280.00000','368.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18264,18264,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',78,'male','L2Monster',40,'3365.00000','1798.00000','3.21000','3.21000',40,43,30,21,20,20,0,0,'1742.00000','667.00000','1280.00000','368.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18265,18265,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',21,'male','L2Chest',40,'376.00000','187.00000','1.50000','1.50000',40,43,30,21,20,20,0,0,'53.00000','102.00000','38.00000','57.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18266,18266,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',24,'male','L2Chest',40,'449.00000','224.00000','1.50000','1.50000',40,43,30,21,20,20,0,0,'68.00000','115.00000','48.00000','63.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18267,18267,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',27,'male','L2Chest',40,'532.00000','261.00000','1.50000','1.50000',40,43,30,21,20,20,0,0,'87.00000','130.00000','62.00000','71.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18268,18268,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',30,'male','L2Chest',40,'623.00000','300.00000','1.50000','1.50000',40,43,30,21,20,20,0,0,'109.00000','146.00000','77.00000','80.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18269,18269,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',33,'male','L2Chest',40,'725.00000','339.00000','1.80000','1.80000',40,43,30,21,20,20,0,0,'138.00000','163.00000','96.00000','89.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18270,18270,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',36,'male','L2Chest',40,'835.00000','380.00000','1.80000','1.80000',40,43,30,21,20,20,0,0,'171.00000','181.00000','115.00000','100.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18271,18271,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',39,'male','L2Chest',40,'956.00000','421.00000','1.80000','1.80000',40,43,30,21,20,20,0,0,'211.00000','201.00000','147.00000','111.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18272,18272,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',42,'male','L2Chest',40,'1085.00000','483.00000','2.10000','2.10000',40,43,30,21,20,20,0,0,'258.00000','223.00000','174.00000','123.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18273,18273,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',45,'male','L2Chest',40,'1222.00000','556.00000','2.10000','2.10000',40,43,30,21,20,20,0,0,'313.00000','246.00000','212.00000','135.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18274,18274,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',48,'male','L2Chest',40,'1366.00000','630.00000','2.10000','2.10000',40,43,30,21,20,20,0,0,'375.00000','270.00000','260.00000','149.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18275,18275,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',51,'male','L2Chest',40,'1518.00000','706.00000','2.40000','2.40000',40,43,30,21,20,20,0,0,'446.00000','296.00000','309.00000','163.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18276,18276,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',54,'male','L2Chest',40,'1674.00000','784.00000','2.40000','2.40000',40,43,30,21,20,20,0,0,'526.00000','323.00000','364.00000','178.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18277,18277,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',57,'male','L2Chest',40,'1834.00000','862.00000','2.40000','2.40000',40,43,30,21,20,20,0,0,'614.00000','351.00000','420.00000','193.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18278,18278,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',60,'male','L2Chest',40,'1996.00000','943.00000','2.40000','2.40000',40,43,30,21,20,20,0,0,'711.00000','381.00000','491.00000','210.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18279,18279,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',63,'male','L2Chest',40,'2158.00000','1025.00000','2.70000','2.70000',40,43,30,21,20,20,0,0,'816.00000','411.00000','559.00000','227.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18280,18280,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',66,'male','L2Chest',40,'2317.00000','1110.00000','2.70000','2.70000',40,43,30,21,20,20,0,0,'928.00000','443.00000','641.00000','244.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18281,18281,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',69,'male','L2Chest',40,'2473.00000','1196.00000','2.70000','2.70000',40,43,30,21,20,20,0,0,'1046.00000','475.00000','717.00000','261.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18282,18282,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',72,'male','L2Chest',40,'2622.00000','1283.00000','3.00000','3.00000',40,43,30,21,20,20,0,0,'1168.00000','507.00000','801.00000','280.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18283,18283,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',75,'male','L2Chest',40,'2763.00000','1372.00000','3.00000','3.00000',40,43,30,21,20,20,0,0,'1293.00000','540.00000','891.00000','298.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18284,18284,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',78,'male','L2Chest',40,'2894.00000','1462.00000','3.00000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','574.00000','973.00000','316.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18285,18285,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',78,'male','L2Chest',40,'3101.00000','1602.00000','3.09000','3.10030',40,43,30,21,20,20,0,0,'1602.00000','625.00000','1143.00000','344.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18286,18286,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',78,'male','L2Chest',40,'3301.00000','1748.00000','3.18000','3.18000',40,43,30,21,20,20,0,0,'1697.00000','654.00000','1236.00000','361.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18287,18287,'Otherworldly Invader Food',0,'',0,'LineageMonster.mimic','8.50','8.50',33,'male','L2Chest',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,0,0,'138.00000','158.00000','96.00000','87.00000',230,4,0,333,0,0,0,80,165,1,1,0,1),
(18288,18288,'Otherworldly Invader Food',0,'',0,'LineageMonster.mimic','8.50','8.50',35,'male','L2Chest',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,0,0,'159.00000','170.00000','111.00000','93.00000',230,4,0,333,0,0,0,80,165,1,1,0,1),
(18289,18289,'Dimension Invader Food',0,'',0,'LineageMonster.mimic','8.50','8.50',43,'male','L2Chest',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,0,0,'275.00000','223.00000','191.00000','123.00000',230,4,0,333,0,0,0,80,165,1,1,0,1),
(18290,18290,'Dimension Invader Food',0,'',0,'LineageMonster.mimic','8.50','8.50',45,'male','L2Chest',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,0,0,'313.00000','238.00000','212.00000','131.00000',230,4,0,333,0,0,0,80,165,1,1,0,1),
(18291,18291,'Purgatory Invader Food',0,'',0,'LineageMonster.mimic','8.50','8.50',53,'male','L2Chest',40,'1571.00000','757.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'498.00000','304.00000','344.00000','168.00000',230,4,0,333,0,0,0,80,165,1,1,0,1),
(18292,18292,'Purgatory Invader Food',0,'',0,'LineageMonster.mimic','8.50','8.50',55,'male','L2Chest',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'554.00000','322.00000','384.00000','178.00000',230,4,0,333,0,0,0,80,165,1,1,0,1),
(18293,18293,'Forbidden Path Invader Food',0,'',0,'LineageMonster.mimic','8.50','8.50',63,'male','L2Chest',40,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'816.00000','399.00000','559.00000','220.00000',230,4,0,333,0,0,0,80,165,1,1,0,1),
(18294,18294,'Forbidden Path Invader Food',0,'',0,'LineageMonster.mimic','8.50','8.50',65,'male','L2Chest',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'890.00000','419.00000','615.00000','231.00000',230,4,0,333,0,0,0,80,165,1,1,0,1),
(18295,18295,'Dark Omen Invader Food',0,'',0,'LineageMonster.mimic','8.50','8.50',73,'male','L2Chest',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1209.00000','502.00000','830.00000','277.00000',230,4,0,333,0,0,0,80,165,1,1,0,1),
(18296,18296,'Dark Omen Invader Food',0,'',0,'LineageMonster.mimic','8.50','8.50',75,'male','L2Chest',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1293.00000','524.00000','891.00000','289.00000',230,4,0,333,0,0,0,80,165,1,1,0,1),
(18297,18297,'Messenger Invader Food',0,'',0,'LineageMonster.mimic','8.50','8.50',78,'male','L2Chest',40,'3134.00000','1698.00000','8.92500','3.15000',40,43,30,21,20,20,0,0,'1651.00000','620.00000','1190.00000','342.00000',230,4,0,333,0,0,0,80,165,1,1,0,1),
(18298,18298,'Messenger Invader Food',0,'',0,'LineageMonster.mimic','8.50','8.50',78,'male','L2Chest',40,'3260.00000','1798.00000','9.09500','3.21000',40,43,30,21,20,20,0,0,'1742.00000','646.00000','1280.00000','357.00000',230,4,0,333,0,0,0,80,165,1,1,0,1),
(18299,18299,'Flame of the Branded',0,'',0,'LineageMonster.big_boom','6.00','13.00',35,'male','L2Npc',40,'2318.00000','366.00000','13.50000','1.80000',40,43,30,21,20,20,4894,290,'159.00000','170.00000','111.00000','93.00000',230,1,0,333,0,0,0,48,30,1,1,0,1),
(18300,18300,'Offering of the Branded Evoked Spirit',0,'',0,'LineageMonster.orc','10.00','21.00',33,'male','L2Npc',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,1751,100,'138.00000','158.00000','96.00000','87.00000',230,4,0,333,158,0,0,45,155,1,1,0,1),
(18301,18301,'Flame of Apostates',0,'',0,'LineageMonster.big_boom','6.00','13.00',46,'male','L2Npc',40,'3689.00000','580.00000','16.50000','2.10000',40,43,30,21,20,20,8454,599,'332.00000','246.00000','231.00000','135.00000',230,1,0,333,0,0,0,48,30,1,1,0,1),
(18302,18302,'Offering of Apostates Evoked Spirit',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',44,'male','L2Npc',40,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,3113,213,'293.00000','231.00000','199.00000','127.00000',230,4,0,333,172,0,0,45,160,1,1,0,1),
(18303,18303,'Flame of the Witch',0,'',0,'LineageMonster.big_boom','6.00','13.00',57,'male','L2Npc',40,'5330.00000','862.00000','19.50000','2.40000',40,43,30,21,20,20,12980,1079,'614.00000','340.00000','420.00000','188.00000',230,1,0,333,0,0,0,48,30,1,1,0,1),
(18304,18304,'Offering of the Witch Evoked Spirit',0,'',0,'LineageMonster.batur_orc','9.00','21.50',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,4864,393,'554.00000','322.00000','384.00000','178.00000',230,4,0,333,91,0,0,80,165,1,1,0,1),
(18305,18305,'Flame of Dark Omen',0,'',0,'LineageMonster.big_boom','6.00','13.00',68,'male','L2Npc',40,'7037.00000','1166.00000','22.50000','2.70000',40,43,30,21,20,20,18473,1784,'1006.00000','450.00000','695.00000','248.00000',230,1,0,333,0,0,0,48,30,1,1,0,1),
(18306,18306,'Offering of Dark Omen Evoked Spirit',0,'',0,'LineageMonster.batur_orc','9.00','21.50',66,'male','L2Npc',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,7004,659,'928.00000','429.00000','641.00000','236.00000',230,4,0,333,2503,0,0,80,170,1,1,0,1),
(18307,18307,'Flame of Forbidden Path',0,'',0,'LineageMonster.big_boom','6.00','13.00',78,'male','L2Npc',40,'8612.00000','1508.00000','25.75500','3.03000',40,43,30,21,20,20,24933,2763,'1464.00000','569.00000','1020.00000','313.00000',230,1,0,333,0,0,0,48,30,1,1,0,1),
(18308,18308,'Offering of /Forbidden Path Evoked Spirit',0,'',0,'LineageMonster.batur_orc_warrior','10.00','20.00',77,'male','L2Npc',40,'2762.00000','1432.00000','8.50000','3.00000',40,43,30,21,20,20,9534,1032,'1376.00000','545.00000','944.00000','300.00000',230,4,0,333,175,0,0,80,175,1,1,0,1),
(18309,18309,'Flame of the Branded',0,'',0,'LineageMonster.big_boom','6.00','13.00',35,'male','L2Npc',40,'2318.00000','366.00000','13.50000','1.80000',40,43,30,21,20,20,4894,290,'159.00000','170.00000','111.00000','93.00000',230,1,0,333,0,0,0,48,30,1,1,0,1),
(18310,18310,'Offering of the Branded Evoked Spirit',0,'',0,'LineageMonster.orc','10.00','21.00',33,'male','L2Npc',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,1751,100,'138.00000','158.00000','96.00000','87.00000',230,4,0,333,158,0,0,45,155,1,1,0,1),
(18311,18311,'Flame of Apostates',0,'',0,'LineageMonster.big_boom','6.00','13.00',46,'male','L2Npc',40,'3689.00000','580.00000','16.50000','2.10000',40,43,30,21,20,20,8454,599,'332.00000','246.00000','231.00000','135.00000',230,1,0,333,0,0,0,48,30,1,1,0,1),
(18312,18312,'Offering of Apostates Evoked Spirit',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',44,'male','L2Npc',40,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,3113,213,'293.00000','231.00000','199.00000','127.00000',230,4,0,333,172,0,0,45,160,1,1,0,1),
(18313,18313,'Flame of the Witch',0,'',0,'LineageMonster.big_boom','6.00','13.00',57,'male','L2Npc',40,'5330.00000','862.00000','19.50000','2.40000',40,43,30,21,20,20,12980,1079,'614.00000','340.00000','420.00000','188.00000',230,1,0,333,0,0,0,48,30,1,1,0,1),
(18314,18314,'Offering of the Witch Evoked Spirit',0,'',0,'LineageMonster.batur_orc','9.00','21.50',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,4864,393,'554.00000','322.00000','384.00000','178.00000',230,4,0,333,91,0,0,80,165,1,1,0,1),
(18315,18315,'Flame of Dark Omen',0,'',0,'LineageMonster.big_boom','6.00','13.00',68,'male','L2Npc',40,'7037.00000','1166.00000','22.50000','2.70000',40,43,30,21,20,20,18473,1784,'1006.00000','450.00000','695.00000','248.00000',230,1,0,333,0,0,0,48,30,1,1,0,1),
(18316,18316,'Offering of Dark Omen Evoked Spirit',0,'',0,'LineageMonster.batur_orc','9.00','21.50',66,'male','L2Npc',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,7004,659,'928.00000','429.00000','641.00000','236.00000',230,4,0,333,2503,0,0,80,170,1,1,0,1),
(18317,18317,'Flame of Forbidden Path',0,'',0,'LineageMonster.big_boom','6.00','13.00',78,'male','L2Npc',40,'8527.00000','1493.00000','25.50000','3.00000',40,43,30,21,20,20,24933,2763,'1450.00000','563.00000','1020.00000','311.00000',230,1,0,333,0,0,0,48,30,1,1,0,1),
(18318,18318,'Offering of Forbidden Path Evoked Spirit',0,'',0,'LineageMonster.batur_orc_warrior','10.00','20.00',77,'male','L2Npc',40,'2762.00000','1432.00000','8.50000','3.00000',40,43,30,21,20,20,9534,1032,'1376.00000','545.00000','944.00000','300.00000',230,4,0,333,175,0,0,80,175,1,1,0,1),
(18319,18319,'Caught Frog',0,'',0,'LineageMonster.poison_toad','20.00','10.00',10,'male','L2PenaltyMonster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,422,14,'19.00000','52.00000','10.00000','34.00000',230,1,0,333,0,0,0,50,110,1,1,0,1),
(18320,18320,'Caught Undine',0,'',0,'LineageMonster.undine','12.00','27.00',20,'female','L2PenaltyMonster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,844,37,'48.00000','80.00000','30.00000','52.00000',230,4,0,333,0,0,0,60,120,1,1,0,1),
(18321,18321,'Caught Rakul',0,'',0,'LineageMonster.rakul','30.00','39.00',30,'male','L2PenaltyMonster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,1550,85,'109.00000','120.00000','77.00000','78.00000',230,1,0,333,156,0,0,60,130,1,1,0,1),
(18322,18322,'Caught Sea Giant',0,'',0,'LineageMonster.water_giant','13.00','44.00',40,'male','L2PenaltyMonster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,2756,178,'226.00000','172.00000','157.00000','111.00000',230,4,0,333,131,0,0,35,140,1,1,0,1),
(18323,18323,'Caught Sea Horse Soldier',0,'',0,'LineageMonster.theeder','9.00','32.00',50,'male','L2PenaltyMonster',80,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,4306,324,'421.00000','237.00000','286.00000','153.00000',230,4,0,333,291,0,0,80,150,1,1,0,1),
(18324,18324,'Caught Homunculus',0,'',0,'LineageMonster2.homunculus','12.00','32.50',60,'male','L2PenaltyMonster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,6200,538,'711.00000','314.00000','491.00000','203.00000',230,4,0,333,0,0,0,30,160,1,1,0,1),
(18325,18325,'Caught Flava',0,'',0,'LineageMonster2.flava','18.00','34.00',70,'male','L2PenaltyMonster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,8439,837,'1086.00000','400.00000','749.00000','259.00000',230,1,0,333,0,0,0,30,170,1,1,0,1),
(18326,18326,'Caught Gigantic Eye',0,'',0,'LineageMonster2.hundred_eye','21.00','55.00',78,'male','L2PenaltyMonster',40,'2880.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,11022,1237,'1482.00000','485.00000','1058.00000','314.00000',230,1,0,333,0,0,0,30,180,1,1,0,1),
(18327,18327,'Freya\'s Servant',0,'',0,'LineageMonster.gargoyle_02te','16.00','50.00',58,'male','L2Monster',40,'1828.00000','889.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'565.00000','350.00000','447.00000','212.00000',230,8,500,333,0,0,0,140,140,1,1,0,1),
(18328,18328,'Hall Alarm Device',0,'',0,'LineageNPC.grave_keeper_key','8.00','21.00',83,'male','L2Monster',40,'100000.00000','1680.00000','8.80000','3.10000',40,43,30,21,20,20,0,0,'1763.00000','652.00000','1309.00000','433.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(18329,18329,'Hall Keeper Captain',0,'',0,'LineageMonster.death_lord','21.00','40.00',83,'male','L2Monster',40,'2985.00000','1617.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',230,4,0,333,78,0,0,40,160,1,1,0,1),
(18330,18330,'Hall Keeper Wizard',0,'',0,'LineageMonster.vale_master','12.00','40.00',83,'male','L2Monster',40,'2880.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',230,4,0,333,326,0,0,70,175,1,1,0,1),
(18331,18331,'Hall Keeper Guard',0,'',0,'LineageMonster.death_knight','12.00','30.00',83,'male','L2Monster',40,'2952.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',230,4,0,333,142,0,0,27,110,1,1,0,1),
(18332,18332,'Hall Keeper Patrol',0,'',0,'LineageMonster.headless_knight','21.00','31.00',83,'male','L2Monster',40,'2917.00000','1555.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',230,4,0,333,124,0,0,70,170,1,1,0,1),
(18333,18333,'Hall Keeper Suicidal Soldier',0,'',0,'LineageMonster3.self_blaster','9.00','25.80',83,'male','L2Monster',40,'2880.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',230,4,0,333,0,0,0,30,150,1,1,0,1),
(18334,18334,'Dark Choir Captain',0,'',0,'LineageMonster2.erinyes_cmd','21.00','50.00',83,'male','L2Monster',40,'3047.00000','1680.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',230,1,0,333,0,0,0,31,150,1,1,0,1),
(18335,18335,'Dark Choir Prima Donna',0,'',0,'LineageMonster3.portrait_spirit','23.00','40.00',83,'male','L2Monster',40,'2952.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',230,4,0,333,0,0,0,30,200,1,1,0,1),
(18336,18336,'Dark Choir Lancer',0,'',0,'LineageMonster.death_blader','15.00','45.00',83,'male','L2Monster',40,'2952.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',230,4,0,333,1472,0,0,100,180,1,1,0,1),
(18337,18337,'Dark Choir Archer',0,'',0,'LineageMonster.skeleton_archer_20_bi','13.00','32.50',83,'male','L2Monster',40,'2952.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',230,1,0,333,279,0,0,40,140,1,1,0,1),
(18338,18338,'Dark Choir Witch Doctor',0,'',0,'LineageMonster3.portrait_spirit_winged','23.00','40.00',83,'male','L2Monster',40,'2952.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',230,4,0,333,0,0,0,30,190,1,1,0,1),
(18339,18339,'Dark Choir Player',0,'',0,'LineageMonster.skeleton','11.00','25.00',83,'male','L2Monster',40,'2880.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',230,4,0,333,150,103,0,60,140,1,1,0,1),
(18340,18340,'Hall Keeper Suicidal Soldier',0,'',0,'LineageMonster3.self_blaster','9.00','25.80',83,'male','L2Monster',40,'2880.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',230,4,0,333,0,0,0,30,100,1,1,0,1),
(18341,18341,'Hall Keeper Suicidal Soldier',0,'',0,'LineageMonster3.self_blaster','9.00','25.80',83,'male','L2Monster',40,'2880.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',230,4,0,333,0,0,0,30,150,1,1,0,1),
(18342,18342,'Gremlin',0,'',0,'LineageMonster.gremlin','10.00','15.00',1,'male','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,29,2,'8.00000','40.00000','7.00000','25.00000',230,4,0,333,0,0,0,20,50,1,1,0,1),
(18343,18343,'Gatekeeper Zombie',0,'',0,'LineageMonster3.zombie_gateguard','17.00','30.50',78,'male','L2Monster',40,'2985.00000','1617.00000','8.65000','3.05000',40,43,30,21,20,20,0,0,'1698.00000','623.00000','1236.00000','415.00000',230,1,500,333,8217,0,0,33,120,1,1,0,1),
(18344,18344,'Ancient Egg',0,'',0,'LineageNpcEV.dinosaur_nest','53.00','11.50',78,'etc','L2Monster',40,'10.00000','1712.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1654.00000','611.00000','1181.00000','407.00000',230,1,0,333,0,0,0,50,100,1,1,0,1),
(18345,18345,'Sprigant',0,'',0,'LineageMonster3.Arachnoid','45.00','67.00',78,'female','L2Monster',40,'2985.00000','1617.00000','8.50000','3.00000',40,43,30,21,20,20,8267,961,'1698.00000','623.00000','1236.00000','415.00000',230,1,500,333,0,0,0,60,165,1,1,0,1),
(18346,18346,'Sprigant',0,'',0,'LineageMonster3.Arachnoid','45.00','67.00',78,'female','L2Monster',40,'2985.00000','1617.00000','8.50000','3.00000',40,43,30,21,20,20,8267,961,'1698.00000','623.00000','1236.00000','415.00000',230,1,500,333,0,0,0,60,150,1,1,0,1),
(18347,18347,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter','15.50','22.50',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,708,31,'48.00000','95.00000','30.00000','63.00000',230,4,600,333,0,0,0,36,120,1,1,0,1),
(18348,18348,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter','15.50','22.50',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,949,35,'53.00000','99.00000','38.00000','66.00000',230,4,600,333,0,0,0,36,110,1,1,0,1),
(18349,18349,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Gunner','15.00','24.50',21,'male','L2Monster',700,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,907,41,'53.00000','99.00000','38.00000','66.00000',230,10,600,333,10128,0,0,36,110,1,1,0,1),
(18350,18350,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter','15.50','22.50',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,1000,35,'53.00000','99.00000','38.00000','66.00000',230,4,600,333,0,0,0,36,110,1,1,0,1),
(18351,18351,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter','15.50','22.50',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,952,35,'53.00000','99.00000','38.00000','66.00000',230,4,600,333,0,0,0,36,110,1,1,0,1),
(18352,18352,'Kamael Guard',0,'',0,'LineageMonster4.Mostro_Fighter','15.50','22.50',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,1808,68,'57.00000','103.00000','36.00000','69.00000',230,4,200,333,0,0,0,36,130,1,1,0,1),
(18353,18353,'Guardian of Records',0,'',0,'LineageMonster4.Mostro_Fighter','15.50','22.50',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,2401,99,'57.00000','103.00000','36.00000','69.00000',230,4,200,333,0,0,0,36,130,1,1,0,1),
(18354,18354,'Guardian of Observation',0,'',0,'LineageMonster4.Mostro_Fighter','15.50','22.50',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,1808,68,'57.00000','103.00000','36.00000','69.00000',230,4,200,333,0,0,0,36,130,1,1,0,1),
(18355,18355,'Spicula\'s Guard',0,'',0,'LineageMonster4.Mostro_Fighter','15.50','22.50',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,2542,99,'57.00000','103.00000','36.00000','69.00000',230,4,200,333,0,0,0,36,130,1,1,0,1),
(18356,18356,'Harkilgamed\'s Gatekeeper',0,'',0,'LineageMonster4.Mostro_Gunner','15.00','24.50',22,'male','L2Monster',700,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,2470,111,'57.00000','103.00000','36.00000','69.00000',230,10,200,333,10128,0,0,36,130,1,1,0,1),
(18357,18357,'Rodenpicula\'s Gatekeeper',0,'',0,'LineageMonster4.Mostro_Fighter','15.50','22.50',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,2401,99,'57.00000','103.00000','36.00000','69.00000',230,4,200,333,0,0,0,36,130,1,1,0,1),
(18358,18358,'Guardian of Secrets',0,'',0,'LineageMonster4.Mostro_Fighter','15.50','22.50',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,1808,68,'57.00000','103.00000','36.00000','69.00000',230,4,200,333,0,0,0,36,130,1,1,0,1),
(18359,18359,'Arviterre\'s Guardian',0,'',0,'LineageMonster4.Mostro_Fighter','15.50','22.50',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,1808,68,'57.00000','103.00000','36.00000','69.00000',230,4,200,333,0,0,0,36,130,1,1,0,1),
(18360,18360,'Katenar\'s Gatekeeper',0,'',0,'LineageMonster4.Mostro_Fighter','15.50','22.50',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,1808,68,'57.00000','103.00000','36.00000','69.00000',230,4,200,333,0,0,0,36,130,1,1,0,1),
(18361,18361,'Guardian of Prediction',0,'',0,'LineageMonster4.Mostro_Fighter','15.50','22.50',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,2401,99,'57.00000','103.00000','36.00000','69.00000',230,4,200,333,0,0,0,36,130,1,1,0,1),
(18362,18362,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter','15.50','22.50',19,'male','L2Monster',40,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,742,30,'44.00000','91.00000','32.00000','61.00000',230,4,600,333,0,0,0,36,120,1,1,0,1),
(18363,18363,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Gunner','15.00','24.50',19,'male','L2Monster',700,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,670,29,'44.00000','91.00000','32.00000','61.00000',230,10,600,333,10128,0,0,36,110,1,1,0,1),
(18364,18364,'Witch Warder',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',79,'male','L2Monster',40,'2842.00000','1493.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1458.00000','566.00000','1006.00000','377.00000',230,4,0,333,0,0,0,30,170,1,1,0,1),
(18365,18365,'Witch Warder',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',80,'male','L2Monster',40,'2880.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1499.00000','577.00000','1035.00000','384.00000',230,4,0,333,0,0,0,30,170,1,1,0,1),
(18366,18366,'Witch Warder',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',82,'male','L2Monster',40,'2952.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1580.00000','598.00000','1090.00000','398.00000',230,4,0,333,0,0,0,30,170,1,1,0,1),
(18367,18367,'Prison Guard',0,'',0,'LineageMonster3.zombie_gateguard','17.00','30.50',80,'male','L2Monster',40,'2880.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1499.00000','577.00000','1035.00000','384.00000',230,4,0,333,8217,0,0,33,50,1,1,0,1),
(18368,18368,'Prison Guard',0,'',0,'LineageMonster3.zombie_gateguard','17.00','30.50',80,'male','L2Monster',40,'2880.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,8579,962,'1499.00000','577.00000','1035.00000','384.00000',230,4,500,333,8217,0,0,33,160,1,1,0,1),
(18369,18369,'Chromatic Crystalline Golem',0,'',0,'LineageMonster4.Crystal_Golem','34.00','47.00',82,'male','L2Monster',40,'2952.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,20,9308,1017,'1580.00000','598.00000','1090.00000','398.00000',230,4,0,333,0,0,0,54,170,1,1,0,1),
(18370,18370,'Chromatic Crystalline Golem',0,'',0,'LineageMonster4.Crystal_Golem','34.00','47.00',82,'male','L2Monster',40,'2952.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,20,8545,934,'1580.00000','598.00000','1090.00000','398.00000',230,4,0,333,0,0,0,54,170,1,1,0,1),
(18371,18371,'Beleth Sample',0,'',0,'LineageMonster3.zombie_gateguard','17.00','30.50',82,'male','L2Monster',40,'2952.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,20,7697,841,'1580.00000','598.00000','1090.00000','398.00000',230,4,0,333,8217,0,0,33,50,1,1,0,1),
(18372,18372,'Beleth Sample',0,'',0,'LineageMonster3.zombie_laborer','11.00','24.60',82,'male','L2Monster',40,'2952.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,20,7697,841,'1580.00000','598.00000','1090.00000','398.00000',230,4,0,333,123,0,0,36,180,1,1,0,1),
(18373,18373,'Beleth Sample',0,'',0,'LineageMonster3.zombie_enlisted_man','17.00','22.30',82,'male','L2Monster',40,'2952.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,20,7697,841,'1580.00000','598.00000','1090.00000','398.00000',230,4,0,333,0,0,0,38,200,1,1,0,1),
(18374,18374,'Beleth Sample',0,'',0,'LineageMonster3.zombie_em_knight','17.00','22.30',82,'male','L2Monster',40,'2952.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,20,7697,841,'1580.00000','598.00000','1090.00000','398.00000',230,4,0,333,8215,0,0,38,200,1,1,0,1),
(18375,18375,'Beleth Sample',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',82,'male','L2Monster',40,'2952.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,20,7697,841,'1580.00000','598.00000','1090.00000','398.00000',230,4,0,333,946,945,0,80,15,1,1,0,1),
(18376,18376,'Beleth Sample',0,'',0,'LineageMonster.vale_master','12.00','40.00',82,'male','L2Monster',40,'2952.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,20,7697,841,'1580.00000','598.00000','1090.00000','398.00000',230,4,0,333,205,0,0,70,155,1,1,0,1),
(18377,18377,'Beleth Sample',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',82,'male','L2Monster',40,'2952.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,20,7697,841,'1580.00000','598.00000','1090.00000','398.00000',230,4,0,333,150,103,0,40,160,1,1,0,1),
(18378,18378,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_switch','20.00','13.50',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18379,18379,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18380,18380,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18381,18381,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18382,18382,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18383,18383,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18384,18384,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18385,18385,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18386,18386,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18387,18387,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18388,18388,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18389,18389,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18390,18390,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18391,18391,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18392,18392,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18393,18393,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18394,18394,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18395,18395,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18396,18396,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18397,18397,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18398,18398,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18399,18399,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18400,18400,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18401,18401,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18402,18402,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18403,18403,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18404,18404,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18405,18405,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18406,18406,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18407,18407,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18408,18408,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18409,18409,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18410,18410,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18411,18411,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18412,18412,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18413,18413,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18414,18414,'Warrior\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',18,'etc','L2Npc',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,0,0,'40.00000','87.00000','25.00000','58.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(18415,18415,'Midway Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',18,'etc','L2Npc',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,0,0,'40.00000','87.00000','25.00000','58.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(18416,18416,'Doorman',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',18,'etc','L2Npc',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,0,0,'40.00000','87.00000','25.00000','58.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(18417,18417,'Bridge Keeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',18,'etc','L2Npc',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,0,0,'40.00000','87.00000','25.00000','58.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(18418,18418,'Bridge Keeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',18,'etc','L2Npc',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,0,0,'40.00000','87.00000','25.00000','58.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(18419,18419,'Bridge Keeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',18,'etc','L2Npc',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,0,0,'40.00000','87.00000','25.00000','58.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(18420,18420,'Trap',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',18,'etc','L2Npc',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,0,0,'40.00000','87.00000','25.00000','58.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(18427,18427,'',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18428,18428,'',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18429,18429,'',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18430,18430,'',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18431,18431,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',70,'etc','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18432,18432,'Trap',0,'',0,'LineageNpcEV.Trap_device_wall_switch','13.60','38.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18433,18433,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18434,18434,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18435,18435,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18436,18436,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18437,18437,'Trap',0,'',0,'LineageNPC.clear_npc','0.10','0.10',18,'male','L2Npc',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,0,0,'40.00000','87.00000','25.00000','58.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18438,18438,'Trap',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',15,'etc','L2Npc',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,0,0,'39.00000','85.00000','28.00000','57.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(18441,18441,'Kamael Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',18,'etc','L2Npc',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,0,0,'40.00000','87.00000','25.00000','58.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(18442,18442,'Trap',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',18,'etc','L2Npc',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,0,0,'40.00000','87.00000','25.00000','58.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(18443,18443,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',78,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1418.00000','556.00000','973.00000','370.00000',230,4,0,333,0,0,0,1,160,1,1,0,1),
(18444,18444,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter','15.50','22.50',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,816,36,'48.00000','95.00000','30.00000','63.00000',230,4,600,333,0,0,0,36,120,1,1,0,1),
(18445,18445,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',80,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1434.00000','562.00000','984.00000','375.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18446,18446,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',80,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1434.00000','562.00000','984.00000','375.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18447,18447,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',80,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1434.00000','562.00000','984.00000','375.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18448,18448,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',80,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1434.00000','562.00000','984.00000','375.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18449,18449,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',80,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1434.00000','562.00000','984.00000','375.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18450,18450,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',80,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1434.00000','562.00000','984.00000','375.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18451,18451,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',80,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1434.00000','562.00000','984.00000','375.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18452,18452,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',80,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1434.00000','562.00000','984.00000','375.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18453,18453,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',80,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1434.00000','562.00000','984.00000','375.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18454,18454,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',80,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1434.00000','562.00000','984.00000','375.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18455,18455,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',80,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1434.00000','562.00000','984.00000','375.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18456,18456,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',80,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1434.00000','562.00000','984.00000','375.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18457,18457,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',80,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1434.00000','562.00000','984.00000','375.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18458,18458,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',80,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1434.00000','562.00000','984.00000','375.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18459,18459,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',80,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1434.00000','562.00000','984.00000','375.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18460,18460,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',80,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1434.00000','562.00000','984.00000','375.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18461,18461,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',80,'etc','L2Npc',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1434.00000','562.00000','984.00000','375.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18463,18463,'Remnant Diabolist',0,'',0,'LineageNPC.e_traderB_Fdwarf_mon_120p','8.00','22.00',81,'female','L2Monster',1100,'65569.00000','1617.00000','113.26544','3.00000',40,43,30,21,20,20,260217,28102,'9526.00000','974.00000','6645.00000','971.00000',230,8,400,253,8527,0,0,49,160,1,1,0,1),
(18464,18464,'Remnant Diviner',0,'',0,'LineageNPC.a_mageguild_teacher_Mhuman_mon','8.00','23.00',81,'male','L2Monster',40,'65569.00000','1617.00000','113.26544','3.00000',40,43,30,21,20,20,254867,27524,'9526.00000','974.00000','6645.00000','971.00000',230,4,400,253,8532,0,0,50,160,1,1,0,1),
(18465,18465,'Derek',0,'First Generation Seer',0,'LineageNPC.a_mageguild_teacher_Mhuman_mon_120p','10.00','28.10',81,'male','L2Monster',40,'336949.00000','1617.00000','194.03041','3.00000',40,43,30,21,20,20,1067320,115266,'13179.00000','974.00000','9194.00000','971.00000',230,4,0,253,8678,0,0,50,160,1,1,0,1),
(18466,18466,'Outpost Captain',0,'',0,'LineageMonster3.benom','20.00','56.00',81,'male','L2Monster',40,'111547.00000','1680.00000','187.26079','3.00000',40,43,30,21,20,20,0,0,'15685.00000','1008.00000','11069.00000','1005.00000',230,4,300,253,8203,8203,0,79,220,1,1,0,1),
(18467,18467,'Wounded Land Guard',0,'',0,'LineageMonster4.eyeless','36.00','43.50',81,'male','L2Monster',40,'336061.00000','1648.00000','189.14297','3.00000',40,43,30,21,20,20,0,0,'13404.00000','991.00000','9405.00000','988.00000',230,4,0,333,0,0,0,60,210,1,1,0,1),
(18468,18468,'Doorman',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',18,'etc','L2Npc',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,0,0,'40.00000','87.00000','25.00000','58.00000',230,4,0,333,0,0,0,50,1,1,1,0,1),
(18469,18469,'Hall Guard',0,'',0,'LineageMonster.blade_stakato_120p','18.00','43.20',83,'male','L2Npc',40,'32829.00000','1617.00000','111.50705','3.00000',40,43,30,21,20,20,253630,26086,'9919.00000','974.00000','6832.00000','972.00000',230,4,0,333,0,0,0,25,180,1,1,0,1),
(18470,18470,'Hall Guard',0,'',0,'LineageMonster.blade_stakato_soldier_120p','23.00','45.50',83,'male','L2Npc',40,'32829.00000','1617.00000','111.50705','3.00000',40,43,30,21,20,20,103029,11126,'9919.00000','974.00000','6832.00000','972.00000',230,4,0,333,0,0,0,25,180,1,1,0,1),
(18471,18471,'Hall Guard',0,'',0,'LineageMonster4.Anthias','20.00','41.00',83,'male','L2Npc',40,'32829.00000','1617.00000','111.50705','3.00000',40,43,30,21,20,20,45987,4761,'9919.00000','974.00000','6832.00000','972.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(18472,18472,'Hall Guard',0,'',0,'LineageMonster4.Anthias','20.00','41.00',83,'male','L2Npc',40,'32829.00000','1617.00000','111.50705','3.00000',40,43,30,21,20,20,112394,12138,'9919.00000','974.00000','6832.00000','972.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(18473,18473,'Hall Captain',0,'',0,'LineageMonster3.cannibal_stakato_leader_120p','34.00','48.80',83,'male','L2Npc',40,'336949.00000','1617.00000','190.74537','3.00000',40,43,30,21,20,20,724449,78237,'13191.00000','974.00000','9085.00000','972.00000',230,4,0,333,0,0,0,40,250,1,1,0,1),
(18474,18474,'Alarm',0,'',0,'LineageNpcEV.trioll_altar','9.00','33.50',83,'etc','L2Monster',40,'2985.00000','1617.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1619.00000','609.00000','1112.00000','405.00000',230,4,0,253,0,0,0,50,1,1,1,0,1),
(18475,18475,'Hall Guard',0,'',0,'LineageMonster.undine','12.00','27.00',83,'female','L2Npc',40,'32829.00000','1617.00000','111.50705','3.00000',40,43,30,21,20,20,90678,9792,'9919.00000','974.00000','6832.00000','972.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(18476,18476,'Hall Guard',0,'',0,'LineageMonster.lienrik_210p','12.00','50.00',83,'male','L2Npc',40,'32829.00000','1617.00000','111.50705','3.00000',40,43,30,21,20,20,104688,11305,'9919.00000','974.00000','6832.00000','972.00000',230,4,0,333,0,0,0,100,180,1,1,0,1),
(18477,18477,'Coral Treasure Chest',0,'',0,'LineageMonster.mimic_even','8.50','8.50',83,'male','L2Npc',40,'2985.00000','1617.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1619.00000','609.00000','1112.00000','405.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18478,18478,'Herb Jar',0,'',0,'LineageNpcEV.herb_pot','8.00','21.50',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,0,0,'31.00000','76.00000','23.00000','51.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18479,18479,'Inner Castle Sentry',0,'',0,'LineageMonster.kel_mahum','13.00','26.00',81,'male','L2Npc',40,'4234.00000','1680.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2050.00000','630.00000','1447.00000','419.00000',230,4,0,333,0,0,0,50,180,1,1,0,1),
(18480,18480,'Inner Castle Guard',0,'',0,'LineageMonster4.eyeless','36.00','43.50',81,'male','L2Npc',40,'4234.00000','1680.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2050.00000','630.00000','1447.00000','419.00000',230,4,0,333,0,0,0,60,210,1,1,0,1),
(18481,18481,'Inner Castle Seer',0,'',0,'LineageMonster4.eyeless','36.00','43.50',81,'male','L2Npc',40,'4234.00000','1680.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2050.00000','630.00000','1447.00000','419.00000',230,4,0,333,0,0,0,60,210,1,1,0,1),
(18482,18482,'Fafurion Kindred',0,'',0,'LineageMonster3.Water_Drake','55.00','80.50',82,'female','L2Monster',40,'2952.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1580.00000','598.00000','1090.00000','398.00000',230,4,0,253,0,0,0,60,160,1,1,0,1),
(18483,18483,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter','15.50','22.50',19,'male','L2Monster',40,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,1353,57,'44.00000','91.00000','32.00000','61.00000',230,4,600,333,0,0,0,36,120,1,1,0,1),
(18484,18484,'Naia Failan',0,'',0,'LineageNPC.heart_of_warding','17.00','75.00',83,'etc','L2Npc',40,'3835.00000','1617.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1875.00000','609.00000','1293.00000','405.00000',230,4,0,333,0,0,0,50,80,1,1,0,1),
(18485,18485,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18486,18486,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18487,18487,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18488,18488,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18489,18489,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18490,18490,'Beleth\'s Slave',0,'',0,'LineageMonster4.devil_doll','8.00','17.50',86,'female','L2Monster',40,'18540.00000','1712.00000','185.67997','3.00000',40,43,30,21,20,20,65975,6876,'17991.00000','1024.00000','12385.00000','1022.00000',230,4,0,333,0,0,0,60,160,1,1,0,1),
(18491,18491,'Lock',0,'Tower of Naia',0,'LineageNpcEV.soulprison','21.00','53.00',87,'male','L2Npc',40,'597542.00000','1744.00000','0.00000','3.00000',40,43,30,21,20,20,0,0,'2.00000','2288.00000','4.00000','2325.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18492,18492,'Controller',0,'Tower of Naia',0,'LineageNpcEV.elobrate_machine','13.00','20.00',87,'male','L2Npc',40,'4657.00000','1744.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2234.00000','650.00000','1536.00000','433.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18493,18493,'Ward',0,'Tower of Naia',0,'LineageMonster2.hundred_eye','21.00','55.00',87,'male','L2Npc',40,'10160613.00000','1744.00000','330.31517','3.00000',40,43,30,21,20,20,0,0,'22808.00000','1300.00000','15707.00000','1731.00000',230,4,0,333,0,0,0,30,170,1,1,0,1),
(18494,18494,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13.00','20.00',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18495,18495,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13.00','20.00',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18496,18496,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13.00','20.00',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18497,18497,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13.00','20.00',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18498,18498,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13.00','20.00',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18499,18499,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13.00','20.00',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18500,18500,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13.00','20.00',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18501,18501,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13.00','20.00',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18502,18502,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13.00','20.00',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18503,18503,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13.00','20.00',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18504,18504,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13.00','20.00',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18505,18505,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13.00','20.00',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18506,18506,'Soul Crystal Pillar',0,'',0,'LineageNpcEV.soulprison','21.00','53.00',87,'male','L2Npc',40,'4657.00000','1744.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2234.00000','650.00000','1536.00000','433.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18507,18507,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18508,18508,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18509,18509,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18510,18510,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18511,18511,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18512,18512,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18513,18513,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18514,18514,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18515,18515,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18516,18516,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18517,18517,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18518,18518,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18519,18519,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18520,18520,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18521,18521,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18522,18522,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18523,18523,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18524,18524,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18525,18525,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18526,18526,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18527,18527,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18528,18528,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18529,18529,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18530,18530,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18531,18531,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18532,18532,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18533,18533,'',0,'',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18534,18534,'Kertang\'s Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',45,'male','L2Npc',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,0,0,'313.00000','238.00000','212.00000','159.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18535,18535,'Kertang\'s Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',55,'male','L2Npc',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'554.00000','322.00000','384.00000','215.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18536,18536,'Kertang\'s Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',65,'male','L2Npc',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'890.00000','419.00000','615.00000','279.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18537,18537,'Kertang\'s Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',75,'male','L2Npc',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1293.00000','524.00000','891.00000','348.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18538,18538,'Kertang\'s Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',85,'male','L2Npc',40,'4234.00000','1680.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2052.00000','630.00000','1415.00000','419.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18539,18539,'Resurrection Tower',0,'',0,'LineageNpcEV.resurrection_tower','28.00','50.00',45,'male','L2Npc',40,'24127.00000','556.00000','52.59398','2.10000',40,43,30,21,20,20,0,0,'1282.00000','381.00000','880.00000','380.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18540,18540,'Resurrection Tower',0,'',0,'LineageNpcEV.resurrection_tower','28.00','50.00',55,'male','L2Npc',40,'46220.00000','810.00000','93.75778','2.40000',40,43,30,21,20,20,0,0,'3166.00000','515.00000','2181.00000','515.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18541,18541,'Resurrection Tower',0,'',0,'LineageNpcEV.resurrection_tower','28.00','50.00',65,'male','L2Npc',40,'64711.00000','1082.00000','122.74326','2.70000',40,43,30,21,20,20,0,0,'6862.00000','670.00000','4722.00000','669.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18542,18542,'Resurrection Tower',0,'',0,'LineageNpcEV.resurrection_tower','28.00','50.00',75,'male','L2Npc',40,'74308.00000','1372.00000','132.35209','3.00000',40,43,30,21,20,20,0,0,'10389.00000','838.00000','7151.00000','837.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18543,18543,'Resurrection Tower',0,'',0,'LineageNpcEV.resurrection_tower','28.00','50.00',80,'male','L2Npc',40,'113229.00000','1524.00000','195.70889','3.00000',40,43,30,21,20,20,0,0,'15093.00000','923.00000','10390.00000','922.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18544,18544,'Cruma Border',0,'Event Monster',0,'LineageNpcEV.trap_ironcastle','12.00','20.40',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,0,0,'313.00000','238.00000','212.00000','159.00000',230,4,0,333,0,0,0,1,1,1,1,1,1),
(18545,18545,'Ancient Experiment',0,'Event Monster',0,'LineageMonster.marsh_stakato_soldier','10.00','25.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,0,0,'313.00000','238.00000','212.00000','159.00000',230,4,0,333,127,0,0,30,155,1,1,0,1),
(18546,18546,'Ancient Experiment',0,'Event Monster',0,'LineageMonster.stone_golem','20.00','31.00',45,'male','L2Monster',40,'12601.00000','556.00000','27.46903','2.10000',40,43,30,21,20,20,0,0,'715.00000','381.00000','489.00000','380.00000',230,1,0,333,0,0,0,23,23,1,1,0,1),
(18547,18547,'Ancient Experiment',0,'Event Monster',0,'LineageMonster.onyx_beast','14.00','14.50',45,'male','L2Monster',40,'37803.00000','556.00000','27.46903','2.10000',40,43,30,21,20,20,0,0,'447.00000','381.00000','310.00000','380.00000',230,4,0,333,0,0,0,30,120,1,1,0,1),
(18548,18548,'Ancient Experiment',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',45,'male','L2Monster',40,'12601.00000','556.00000','27.46903','2.10000',40,43,30,21,20,20,0,0,'715.00000','381.00000','489.00000','380.00000',230,4,0,333,0,0,0,30,120,1,1,0,1),
(18549,18549,'Ancient Experiment',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',45,'male','L2Monster',40,'12601.00000','556.00000','27.46903','2.10000',40,43,30,21,20,20,0,0,'715.00000','381.00000','489.00000','380.00000',230,4,0,333,0,0,0,30,120,1,1,0,1),
(18550,18550,'Cruma Phantom',0,'Event Monster',0,'LineageMonster.death_blader','15.00','45.00',50,'male','L2Monster',40,'17718.00000','680.00000','37.23481','2.10000',40,43,30,21,20,20,0,0,'1092.00000','445.00000','753.00000','445.00000',230,4,0,333,1472,0,0,100,170,1,1,0,1),
(18551,18551,'Cruma Phantom',0,'Event Monster',0,'LineageMonster.susceptor','20.00','35.00',50,'male','L2Monster',40,'53155.00000','680.00000','37.23481','2.10000',40,43,30,21,20,20,0,0,'677.00000','445.00000','468.00000','445.00000',230,1,0,333,0,0,0,27,150,1,1,0,1),
(18552,18552,'Cruma Phantom',0,'',0,'LineageMonster.gamlin','11.00','32.00',50,'male','L2Monster',40,'17718.00000','680.00000','37.23481','2.10000',40,43,30,21,20,20,0,0,'1092.00000','445.00000','753.00000','445.00000',230,4,0,333,6307,0,0,80,170,1,1,0,1),
(18553,18553,'Cruma Phantom',0,'',0,'LineageMonster.leogul','15.00','35.00',50,'male','L2Monster',40,'17718.00000','680.00000','37.23481','2.10000',40,43,30,21,20,20,0,0,'1092.00000','445.00000','753.00000','445.00000',230,4,0,333,6307,0,0,80,170,1,1,0,1),
(18554,18554,'Tomlan Kamos',0,'Kaneus',0,'LineageMonster.bugbear_bi','25.00','53.00',23,'male','L2Monster',40,'51639.00000','1055.00000','10.66205','4.80000',40,43,30,21,20,20,355901,19458,'76.00000','171.00000','49.00000','171.00000',230,4,0,333,4,0,0,55,130,1,1,0,1);
INSERT INTO `npc` VALUES 
(18555,18555,'Ol Ariosh',0,'Kaneus',0,'LineageMonster.ol_mahum_champion_05te_120p','16.00','33.20',26,'male','L2Monster',40,'60567.00000','1242.00000','12.17924','4.80000',40,43,30,21,20,20,397272,23285,'113.00000','193.00000','75.00000','193.00000',230,4,0,333,67,633,0,50,110,1,1,0,1),
(18556,18556,'Follower of Ariosh',0,'',0,'LineageMonster.ol_mahum_champion','14.00','27.00',26,'male','L2Monster',40,'487.00000','1242.00000','3.50000','4.80000',40,43,30,21,20,20,0,0,'79.00000','121.00000','57.00000','80.00000',230,4,0,333,69,102,0,50,110,1,1,0,1),
(18557,18557,'Ranc Deumus',0,'Kaneus',0,'LineageMonster.virud_lizardman_warrior_bi','12.00','34.50',26,'male','L2Monster',40,'60567.00000','1242.00000','12.17924','4.80000',40,43,30,21,20,20,397272,23285,'113.00000','193.00000','75.00000','193.00000',230,4,0,333,93,0,0,52,130,1,1,0,1),
(18558,18558,'Crimson Hatu Otis',0,'Kaneus',0,'LineageMonster.crimson_bear','19.00','36.00',33,'male','L2Monster',40,'77013.00000','1697.00000','14.59763','6.48000',40,43,30,21,20,20,549172,35415,'232.00000','252.00000','162.00000','252.00000',230,4,0,333,0,0,0,37,170,1,1,0,1),
(18559,18559,'Seer Flouros',0,'Kaneus',0,'LineageMonster.monster_eye_05te_ef','21.00','43.00',36,'male','L2Monster',40,'94225.00000','1900.00000','17.43173','6.48000',40,43,30,21,20,20,620253,41849,'305.00000','281.00000','207.00000','281.00000',230,4,0,333,0,0,0,90,90,1,1,0,1),
(18560,18560,'Follower of Flouros',0,'',0,'LineageMonster.monster_eye','21.00','43.00',36,'male','L2Monster',40,'809.00000','1900.00000','4.50000','6.48000',40,43,30,21,20,20,0,0,'171.00000','176.00000','115.00000','117.00000',230,4,0,333,0,0,0,90,90,1,1,0,1),
(18561,18561,'Granitick Duerga',0,'Kaneus',0,'LineageMonster.stone_golem','20.00','31.00',36,'male','L2Monster',40,'94225.00000','1900.00000','17.43173','6.48000',40,43,30,21,20,20,620253,41849,'305.00000','281.00000','207.00000','281.00000',230,1,0,333,0,0,0,23,23,1,1,0,1),
(18562,18562,'Blade Otis',0,'Kaneus',0,'LineageMonster.blade_stakato_drone_10_sm','14.00','35.10',43,'male','L2Monster',40,'132635.00000','2536.00000','23.23618','11.55000',40,43,30,21,20,20,784383,58093,'473.00000','357.00000','322.00000','357.00000',230,4,0,333,131,0,0,25,155,1,1,0,1),
(18563,18563,'Follower of Otis',0,'',0,'LineageMonster.marsh_stakato_drone','9.00','24.00',43,'male','L2Monster',40,'1094.00000','2536.00000','5.50000','11.55000',40,43,30,21,20,20,0,0,'275.00000','223.00000','191.00000','148.00000',230,4,0,333,223,0,0,80,155,1,1,0,1),
(18564,18564,'Weird Bunei',0,'Kaneus',0,'LineageMonster3.Water_Drake','55.00','80.50',46,'female','L2Monster',40,'165223.00000','2902.00000','28.30202','11.55000',40,43,30,21,20,20,848114,69276,'630.00000','394.00000','431.00000','393.00000',230,4,0,333,0,0,0,60,160,1,1,0,1),
(18565,18565,'Brave Martim',0,'Kaneus',0,'LineageMonster.ogre_50_bi','30.00','66.00',46,'male','L2Monster',40,'165223.00000','2902.00000','28.30202','11.55000',40,43,30,21,20,20,848114,69276,'630.00000','394.00000','431.00000','393.00000',230,4,0,333,298,0,0,33,185,1,1,0,1),
(18566,18566,'Kaim Abigore',0,'Kaneus',0,'LineageMonster.kaim_vanul_50_bi','36.00','60.00',53,'male','L2Monster',40,'294175.00000','3787.00000','47.90696','13.20000',40,43,30,21,20,20,967925,88254,'1134.00000','487.00000','783.00000','486.00000',230,4,0,333,0,0,0,60,250,1,1,0,1),
(18567,18567,'Follower of Abigore',0,'',0,'LineageMonster.liviona','15.00','28.00',53,'male','L2Monster',40,'1571.00000','3787.00000','6.50000','13.20000',40,43,30,21,20,20,0,0,'498.00000','304.00000','344.00000','202.00000',230,4,0,333,0,0,0,80,170,1,1,0,1),
(18568,18568,'Knight Montagnar',0,'Kaneus',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',56,'male','L2Monster',40,'318250.00000','4180.00000','50.75543','13.20000',40,43,30,21,20,20,1002611,124970,'1603.00000','530.00000','1101.00000','530.00000',230,4,0,333,946,945,0,80,120,1,1,0,1),
(18569,18569,'Follower of Montagnar',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',56,'male','L2Monster',40,'1725.00000','4180.00000','6.50000','13.20000',40,43,30,21,20,20,0,0,'583.00000','331.00000','404.00000','220.00000',230,4,0,333,0,0,0,25,150,1,1,0,1),
(18570,18570,'Summer Yaganitan',0,'Kaneus',0,'LineageMonster2.flava_15_bi','23.00','39.00',56,'male','L2Monster',40,'318250.00000','4180.00000','50.75543','13.20000',40,43,30,21,20,20,1002611,124970,'1603.00000','530.00000','1101.00000','530.00000',230,4,0,333,0,0,0,30,165,1,1,0,1),
(18571,18571,'Venomous Storace',0,'Kaneus',0,'LineageMonster.serpent_slave_50_bi','25.00','72.00',63,'male','L2Monster',40,'420501.00000','5129.00000','63.97426','16.47000',40,43,30,21,20,20,1046467,179455,'2823.00000','638.00000','1941.00000','637.00000',230,4,0,333,73,0,0,70,110,1,1,0,1),
(18572,18572,'Follower of Storace',0,'',0,'LineageMonster.cave_maiden_080p','21.00','54.00',63,'female','L2Monster',40,'2090.00000','5129.00000','7.50000','16.47000',40,43,30,21,20,20,0,0,'816.00000','399.00000','559.00000','266.00000',230,4,0,333,73,0,0,50,100,1,1,0,1),
(18573,18573,'Kel Bilette',0,'Kaneus',0,'LineageMonster.kel_mahum_champion_50_bi','19.00','48.00',66,'male','L2Monster',40,'445991.00000','5549.00000','66.53897','16.47000',40,43,30,21,20,20,1052061,186892,'3273.00000','686.00000','2256.00000','685.00000',230,4,0,333,75,0,0,50,170,1,1,0,1),
(18574,18574,'Follower of Bilette',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13.00','25.00',66,'male','L2Monster',40,'2245.00000','5549.00000','7.50000','16.47000',40,43,30,21,20,20,0,0,'928.00000','429.00000','641.00000','285.00000',230,4,0,333,193,0,0,50,160,1,1,0,1),
(18575,18575,'Warlord Tamuze',0,'Kaneus',0,'LineageMonster3.Vampire_Troop_Leader_120p','22.00','43.00',66,'male','L2Monster',40,'445991.00000','5549.00000','66.53897','16.47000',40,43,30,21,20,20,1052061,186892,'3273.00000','686.00000','2256.00000','685.00000',230,4,0,333,8686,0,0,60,160,1,1,0,1),
(18576,18576,'Follower of Tamuze',0,'',0,'LineageMonster3.self_blaster','9.00','25.80',66,'male','L2Monster',40,'2245.00000','5549.00000','7.50000','16.47000',40,43,30,21,20,20,0,0,'928.00000','429.00000','641.00000','285.00000',230,4,0,333,0,0,0,30,240,1,1,0,1),
(18577,18577,'White Allosce',0,'Kaneus',0,'LineageMonster2.hundred_eye','21.00','55.00',73,'male','L2Monster',40,'475290.00000','6561.00000','67.84613','18.30000',40,43,30,21,20,20,1169076,202886,'4722.00000','804.00000','3253.00000','802.00000',230,1,0,333,0,0,0,30,170,1,1,0,1),
(18578,18578,'Follower of Allosce',0,'',0,'LineageMonster.monster_eye','21.00','43.00',73,'male','L2Monster',40,'2587.00000','6561.00000','8.50000','18.30000',40,43,30,21,20,20,0,0,'1209.00000','502.00000','830.00000','334.00000',230,4,0,333,0,0,0,90,90,1,1,0,1),
(18579,18579,'Hunting Ground Keeper',0,'',0,'LineageMonster4.employee_of_baroness','15.00','28.70',70,'male','L2Npc',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,1,0,333,13062,0,0,55,160,1,1,0,1),
(18580,18580,'Cursed Girl',0,'',0,'LineageMonster4.cursed_housemaid','8.00','17.00',71,'male','L2Npc',40,'2493.00000','1253.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1127.00000','481.00000','778.00000','320.00000',230,4,0,333,0,0,0,18,160,1,1,0,1),
(18581,18581,'Gardener',0,'',0,'LineageMonster4.gardener','17.00','26.80',72,'male','L2Npc',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1168.00000','492.00000','801.00000','327.00000',230,4,0,333,0,0,0,36,160,1,1,0,1),
(18582,18582,'Turned Girl',0,'Kratei\'s Fortune',0,'LineageMonster4.cursed_housemaid','8.00','17.00',75,'male','L2Npc',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1293.00000','524.00000','891.00000','348.00000',230,4,0,333,0,0,0,18,160,1,1,0,1),
(18583,18583,'Housekeeper',0,'',0,'LineageMonster4.mad_laundry_maid','9.00','21.60',74,'male','L2Npc',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1251.00000','513.00000','863.00000','342.00000',230,4,0,333,0,0,0,33,160,1,1,0,1),
(18584,18584,'Turned Boy',0,'',0,'LineageMonster4.cursed_errand_boy','8.00','12.80',75,'male','L2Npc',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1293.00000','524.00000','891.00000','348.00000',230,4,0,333,0,0,0,15,160,1,1,0,1),
(18585,18585,'Cursed Girl',0,'',0,'LineageMonster4.cursed_housemaid','8.00','17.00',75,'male','L2Npc',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1293.00000','524.00000','891.00000','348.00000',230,4,0,333,0,0,0,18,160,1,1,0,1),
(18586,18586,'Gardener',0,'',0,'LineageMonster4.gardener','17.00','26.80',75,'male','L2Npc',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1293.00000','524.00000','891.00000','348.00000',230,4,0,333,0,0,0,36,160,1,1,0,1),
(18587,18587,'Begrudged Maid',0,'',0,'LineageMonster4.head_parlour_maid','25.00','32.00',76,'male','L2Npc',40,'2758.00000','1402.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1349.00000','534.00000','931.00000','356.00000',230,4,0,333,0,0,0,50,160,1,1,0,1),
(18588,18588,'Hunting Ground Keeper',0,'',0,'LineageMonster4.employee_of_baroness','15.00','28.70',77,'male','L2Npc',40,'2857.00000','1432.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1410.00000','545.00000','968.00000','363.00000',230,1,0,333,13062,0,0,55,160,1,1,0,1),
(18589,18589,'Cursed Gardener',0,'',0,'LineageMonster4.gardener','17.00','26.80',77,'male','L2Npc',40,'2857.00000','1432.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1410.00000','545.00000','968.00000','363.00000',230,4,0,333,0,0,0,36,160,1,1,0,1),
(18590,18590,'Baroness\' Employee',0,'',0,'LineageMonster4.employee_of_baroness','15.00','28.70',78,'male','L2Npc',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,1,0,333,13061,0,0,55,160,1,1,0,1),
(18591,18591,'Begrudged Boy',0,'',0,'LineageMonster4.cursed_errand_boy','8.00','12.80',79,'male','L2Npc',40,'3128.00000','1493.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1549.00000','566.00000','1069.00000','377.00000',230,4,0,333,0,0,0,15,160,1,1,0,1),
(18592,18592,'Kratei\'s Steward',0,'',0,'LineageMonster4.chief_steward','18.00','31.00',80,'male','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,55,160,1,1,0,1),
(18593,18593,'Housekeeper',0,'',0,'LineageMonster4.mad_laundry_maid','9.00','21.60',80,'male','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,33,160,1,1,0,1),
(18594,18594,'Mansion Guide',0,'',0,'LineageMonster4.mad_laundry_maid','9.00','21.60',81,'male','L2Npc',40,'3462.00000','1555.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1707.00000','588.00000','1172.00000','391.00000',230,4,0,333,0,0,0,33,160,1,1,0,1),
(18595,18595,'Baroness\' Employee',0,'',0,'LineageMonster4.employee_of_baroness','15.00','28.70',82,'male','L2Npc',40,'3644.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1789.00000','598.00000','1230.00000','398.00000',230,1,0,333,13061,0,0,55,160,1,1,0,1),
(18596,18596,'Cursed Gardener',0,'',0,'LineageMonster4.gardener','17.00','26.80',83,'male','L2Npc',40,'3835.00000','1617.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1875.00000','609.00000','1293.00000','405.00000',230,4,0,333,0,0,0,36,160,1,1,0,1),
(18597,18597,'Begrudged Maid',0,'',0,'LineageMonster4.head_parlour_maid','25.00','32.00',84,'male','L2Npc',40,'4039.00000','1648.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1964.00000','619.00000','1349.00000','412.00000',230,4,0,333,0,0,0,50,160,1,1,0,1),
(18598,18598,'Cursed Head Maid',0,'',0,'LineageMonster4.head_parlour_maid','25.00','32.00',85,'male','L2Npc',40,'4234.00000','1680.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2052.00000','630.00000','1415.00000','419.00000',230,4,0,333,0,0,0,50,160,1,1,0,1),
(18599,18599,'Mansion Manager',0,'',0,'LineageMonster4.steward','21.00','25.00',85,'male','L2Npc',40,'4234.00000','1680.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2052.00000','630.00000','1415.00000','419.00000',230,4,0,333,0,0,0,76,160,1,1,0,1),
(18600,18600,'Kratei\'s Steward',0,'',0,'LineageMonster4.chief_steward','18.00','31.00',86,'male','L2Npc',40,'4440.00000','1712.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2142.00000','640.00000','1472.00000','426.00000',230,4,0,333,0,0,0,55,160,1,1,0,1),
(18601,18601,'Kratei\'s Watcher',0,'',0,'LineageNpcEV.trap_ironcastle_150p_a','18.00','32.00',70,'male','L2Npc',40,'1.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18602,18602,'Kratei\'s Watcher',0,'',0,'LineageNpcEV.trap_ironcastle_150p','18.00','32.00',70,'male','L2Npc',40,'1.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18603,18603,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',73,'male','L2Npc',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1209.00000','502.00000','830.00000','334.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18604,18604,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',73,'male','L2Npc',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1209.00000','502.00000','830.00000','334.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18605,18605,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',73,'male','L2Npc',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1209.00000','502.00000','830.00000','334.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18606,18606,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',73,'male','L2Npc',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1209.00000','502.00000','830.00000','334.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18607,18607,'Gargos',0,'Spirit of Fire',0,'LineageMonster.vale_master','12.00','40.00',39,'male','L2Monster',40,'26166.00000','352.00000','9.00000','1.80000',40,43,30,21,20,20,11225,714,'211.00000','170.00000','107.00000','113.00000',230,4,0,333,0,0,0,70,155,1,1,0,1),
(18608,18608,'Kinsus',0,'Spirit of Fire',0,'LineageMonster4.Anthias','20.00','41.00',39,'male','L2Monster',40,'16291.00000','352.00000','9.00000','1.80000',40,43,30,21,20,20,11225,714,'211.00000','170.00000','107.00000','113.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(18609,18609,'Papion',0,'Spirit of Water',0,'LineageMonster4.Anthias','20.00','41.00',36,'male','L2Monster',40,'10513.00000','313.00000','9.00000','1.80000',40,43,30,21,20,20,10783,652,'171.00000','152.00000','86.00000','102.00000',230,4,0,333,0,0,0,60,180,1,1,0,1),
(18610,18610,'Hillas',0,'Spirit of Water',0,'LineageMonster.sylph_100_bi','20.00','70.00',36,'female','L2Monster',40,'12144.00000','313.00000','9.00000','1.80000',40,43,30,21,20,20,10783,652,'171.00000','152.00000','86.00000','102.00000',230,4,0,333,0,0,0,60,140,1,1,0,1),
(18611,18611,'Spirit of Water',0,'',0,'LineageMonster.undine','12.00','27.00',33,'female','L2Monster',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,631,22,'138.00000','158.00000','96.00000','105.00000',230,4,0,333,0,0,0,60,100,1,1,0,1),
(18612,18612,'Spirit of Water',0,'',0,'LineageMonster.sylph','11.00','35.00',36,'female','L2Monster',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,726,28,'171.00000','176.00000','115.00000','117.00000',230,4,0,333,0,0,0,60,100,1,1,0,1),
(18613,18613,'Spirit of Water',0,'',0,'LineageMonster.sylph_110p','12.00','39.70',39,'female','L2Monster',40,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,852,35,'211.00000','195.00000','147.00000','130.00000',230,4,0,333,0,0,0,60,100,1,1,0,1),
(18614,18614,'Spirit of Fire',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',36,'male','L2Monster',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,726,28,'171.00000','176.00000','115.00000','117.00000',230,4,0,333,150,103,0,40,160,1,1,0,1),
(18615,18615,'Spirit of Fire',0,'',0,'LineageMonster.dre_vanul','14.00','36.00',39,'male','L2Monster',40,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,852,35,'211.00000','195.00000','147.00000','130.00000',230,4,0,333,0,0,0,80,80,1,1,0,1),
(18616,18616,'Bloom',0,'',0,'LineageMonster.magical_weaver','11.00','20.00',36,'male','L2Monster',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,726,28,'171.00000','176.00000','115.00000','117.00000',230,1,0,333,0,0,0,90,90,1,1,0,1),
(18617,18617,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',36,'male','L2Npc',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,726,28,'171.00000','176.00000','115.00000','117.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18618,18618,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',36,'male','L2Npc',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,726,28,'171.00000','176.00000','115.00000','117.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18619,18619,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',36,'male','L2Npc',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,726,28,'171.00000','176.00000','115.00000','117.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18620,18620,'Adiantum',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',42,'male','L2Monster',40,'27475.00000','393.00000','9.00000','1.80000',40,43,30,21,20,20,91640,4070,'258.00000','189.00000','128.00000','126.00000',230,1,0,333,0,0,0,30,120,1,1,0,1),
(18621,18621,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',42,'male','L2Npc',40,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,989,44,'258.00000','216.00000','174.00000','143.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18622,18622,'Powder Keg',0,'',0,'LineageNPCEV.gunpowder','80.00','60.00',61,'female','L2Monster',40,'3862.00000','1494.00000','7.50000','2.70000',40,43,30,21,20,20,2085,174,'1303.00000','471.00000','607.00000','382.00000',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18623,18623,'Begrudged Archer',0,'',0,'LineageMonster.skeleton_archer_20_bi','13.00','32.50',61,'male','L2Monster',1100,'3137.00000','1184.00000','7.50000','2.70000',40,43,30,21,20,20,3210,273,'894.00000','379.00000','413.00000','308.00000',253,8,400,333,279,0,0,40,140,1,1,0,1),
(18624,18624,'Deadman\'s Grudge',0,'',0,'LineageMonster.unpleasant_humming','12.00','26.00',58,'male','L2Monster',40,'2889.00000','1085.00000','6.50000','2.40000',40,43,30,21,20,20,1885,151,'775.00000','350.00000','362.00000','284.00000',253,8,400,333,0,0,0,21,143,1,1,0,1),
(18625,18625,'Deadman\'s Grudge',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',61,'male','L2Monster',40,'3137.00000','1184.00000','7.50000','2.70000',40,43,30,21,20,20,2085,174,'894.00000','379.00000','413.00000','308.00000',253,4,400,333,78,0,0,40,160,1,1,0,1),
(18626,18626,'Deadman\'s Grudge',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',64,'male','L2Monster',40,'3384.00000','1285.00000','7.50000','2.70000',40,43,30,21,20,20,2295,199,'1023.00000','409.00000','473.00000','332.00000',253,8,400,333,225,945,0,80,120,1,1,0,1),
(18627,18627,'Deadman\'s Grudge',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',64,'male','L2Monster',40,'3384.00000','1285.00000','7.50000','2.70000',40,43,30,21,20,20,2295,199,'1023.00000','409.00000','473.00000','332.00000',253,4,400,333,225,945,0,80,120,1,1,0,1),
(18628,18628,'Atan',0,'Lookout',0,'LineageMonster.pirates_zombie','10.00','23.00',61,'male','L2Monster',40,'1985.00000','970.00000','7.50000','2.70000',40,43,30,21,20,20,2934,249,'745.00000','379.00000','510.00000','252.00000',230,8,0,333,232,0,0,11,145,1,1,0,1),
(18629,18629,'Kams',0,'Panuka',0,'LineageMonster.skeleton_knight_50_bi','15.00','39.00',61,'male','L2Monster',40,'34907.00000','1184.00000','15.00000','2.70000',40,43,30,21,20,20,63183,5562,'894.00000','379.00000','413.00000','308.00000',253,4,600,333,150,103,0,40,160,1,1,0,1),
(18630,18630,'Hikoro',0,'Panuka',0,'LineageMonster.rakul','30.00','39.00',61,'male','L2Monster',40,'34907.00000','1184.00000','15.00000','2.70000',40,43,30,21,20,20,63183,5562,'894.00000','379.00000','413.00000','308.00000',253,4,600,333,3,0,0,60,150,1,1,0,1),
(18631,18631,'Alkaso',0,'Panuka',0,'LineageMonster.pirates_zombie_captain_20_bi','20.00','33.60',64,'male','L2Monster',40,'36120.00000','1285.00000','15.00000','2.70000',40,43,30,21,20,20,64881,5952,'1023.00000','409.00000','473.00000','332.00000',253,8,600,333,232,0,0,14,155,1,1,0,1),
(18632,18632,'Gerbera',0,'Panuka',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9.00','36.00',64,'male','L2Monster',40,'39056.00000','1285.00000','15.00000','2.70000',40,43,30,21,20,20,64881,5952,'1023.00000','409.00000','473.00000','332.00000',253,4,600,333,134,6721,0,39,150,1,1,0,1),
(18633,18633,'Lematan',0,'',0,'LineageMonster4.cursed_pirate','24.00','37.00',67,'male','L2Monster',40,'78113.00000','1389.00000','15.00000','2.70000',40,43,30,21,20,20,317821,23080,'1160.00000','439.00000','537.00000','357.00000',278,4,600,333,0,0,0,26,120,1,1,0,1),
(18634,18634,'Lematan\'s Follower',0,'',0,'LineageMonster.pirates_zombie','10.00','23.00',64,'male','L2Monster',40,'3384.00000','1285.00000','7.50000','2.70000',40,43,30,21,20,20,2295,199,'1023.00000','409.00000','473.00000','332.00000',253,8,0,333,232,0,0,11,145,1,1,0,1),
(18635,18635,'Varka Silenos Recruit',0,'',0,'LineageMonster2.barka_silenos_hunter','16.00','38.00',71,'male','L2Monster',40,'7484.00000','1283.00000','17.00000','3.00000',40,43,30,21,20,20,31557,2980,'580.00000','489.00000','201.00000','325.00000',230,4,0,333,2504,6918,0,44,175,1,1,0,1),
(18636,18636,'Varka Silenos Footman',0,'',0,'LineageMonster2.barka_silenos_warrior','16.00','41.00',71,'male','L2Monster',40,'7484.00000','1283.00000','17.00000','3.00000',40,43,30,21,20,20,31557,2980,'580.00000','489.00000','201.00000','325.00000',230,4,0,333,2504,6918,0,34,175,1,1,0,1),
(18637,18637,'Grazing Antelope',0,'',0,'LineageMonster2.antelope','17.00','34.00',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,4087,400,'1168.00000','492.00000','801.00000','327.00000',230,4,0,333,0,0,0,45,185,1,1,0,1),
(18638,18638,'Varka Silenos Scout',0,'',0,'LineageMonster2.barka_silenos_hunter','16.00','38.00',72,'male','L2Monster',80,'7578.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,3341,338,'584.00000','492.00000','198.00000','327.00000',230,4,0,333,2504,6918,0,44,175,1,1,0,1),
(18639,18639,'Varka Silenos Hunter',0,'',0,'LineageMonster2.barka_silenos_archer','8.00','37.50',72,'male','L2Monster',1100,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,2905,292,'1168.00000','492.00000','801.00000','327.00000',230,8,0,333,6917,0,0,30,175,1,1,0,1),
(18640,18640,'Varka Silenos Shaman',0,'',0,'LineageMonster2.barka_silenos_shaman','14.00','39.50',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,2905,292,'1168.00000','492.00000','801.00000','327.00000',230,1,0,333,6716,0,0,36,150,1,1,0,1),
(18641,18641,'Varka Silenos Priest',0,'',0,'LineageMonster2.barka_silenos_priest','9.00','41.50',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,4802,513,'1168.00000','492.00000','801.00000','327.00000',230,4,0,333,6716,0,0,36,180,1,1,0,1),
(18642,18642,'Varka Silenos Warrior',0,'',0,'LineageMonster2.barka_silenos_warrior','16.00','41.00',72,'male','L2Monster',40,'7578.00000','1342.00000','17.00000','3.00000',40,43,30,21,20,20,3801,402,'617.00000','507.00000','215.00000','337.00000',230,4,0,333,142,6918,0,34,175,1,1,0,1),
(18643,18643,'Grazing Antelope',0,'',0,'LineageMonster2.antelope','17.00','34.00',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,4201,434,'1209.00000','502.00000','830.00000','334.00000',230,4,0,333,0,0,0,45,185,1,1,0,1),
(18644,18644,'Varka Silenos Medium',0,'',0,'LineageMonster2.barka_silenos_shaman','14.00','39.50',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,2905,316,'1168.00000','492.00000','801.00000','327.00000',230,1,0,333,6716,0,0,36,150,1,1,0,1),
(18645,18645,'Varka Silenos Magus',0,'',0,'LineageMonster2.barka_silenos_mage_20_bi','11.00','55.20',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,3255,360,'1209.00000','502.00000','830.00000','334.00000',230,1,0,333,6716,6918,0,36,175,1,1,0,1),
(18646,18646,'Varka Silenos Officer',0,'',0,'LineageMonster2.barka_silenos_chieftain','18.00','42.50',73,'male','L2Monster',40,'6661.00000','1402.00000','17.00000','3.00000',40,43,30,21,20,20,37623,3932,'663.00000','525.00000','230.00000','349.00000',230,1,0,333,2504,6918,0,25,175,1,1,0,1),
(18647,18647,'Grazing Flava',0,'',0,'LineageMonster2.flava','18.00','34.00',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,4133,449,'1251.00000','513.00000','863.00000','342.00000',230,4,0,333,0,0,0,30,165,1,1,0,1),
(18648,18648,'Varka Silenos Seer',0,'',0,'LineageMonster2.barka_silenos_shaman','14.00','39.50',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,2807,308,'1209.00000','502.00000','830.00000','334.00000',230,1,0,333,6716,0,0,36,150,1,1,0,1),
(18649,18649,'Varka Silenos Great Magus',0,'',0,'LineageMonster2.barka_silenos_warrior_20_bi','20.00','49.20',73,'male','L2Monster',40,'9374.00000','1432.00000','17.00000','3.00000',40,43,30,21,20,20,37090,4028,'704.00000','532.00000','233.00000','354.00000',230,4,0,333,2500,6918,0,34,175,1,1,0,1),
(18650,18650,'Varka Silenos General',0,'',0,'LineageMonster2.barka_silenos_chieftain','18.00','42.50',73,'male','L2Monster',40,'9374.00000','1432.00000','17.00000','3.00000',40,43,30,21,20,20,37090,4028,'704.00000','532.00000','233.00000','354.00000',230,1,0,333,2500,6918,0,25,175,1,1,0,1),
(18651,18651,'Grazing Elder Antelope',0,'',0,'LineageMonster2.antelope','17.00','34.00',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,4133,467,'1251.00000','513.00000','863.00000','342.00000',230,1,0,333,0,0,0,45,185,1,1,0,1),
(18652,18652,'Varka Silenos Great Seer',0,'',0,'LineageMonster2.barka_silenos_shaman','14.00','39.50',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,2885,333,'1251.00000','513.00000','863.00000','342.00000',230,1,0,333,6716,0,0,36,150,1,1,0,1),
(18653,18653,'Varka\'s Elite Guard',0,'',0,'LineageMonster2.barka_silenos_warrior','16.00','41.00',74,'male','L2Monster',40,'6704.00000','1342.00000','17.00000','3.00000',40,43,30,21,20,20,39208,3836,'625.00000','513.00000','863.00000','342.00000',230,4,0,333,2504,6918,0,34,175,1,1,0,1),
(18654,18654,'Varka\'s Commander',0,'',0,'LineageMonster2.barka_silenos_chieftain_20_bi','22.00','51.00',72,'male','L2Monster',40,'6657.00000','1372.00000','17.00000','3.00000',40,43,30,21,20,20,36599,3398,'634.00000','514.00000','870.00000','342.00000',230,4,0,333,2500,6918,0,25,175,1,1,0,1),
(18655,18655,'Varka\'s Head Guard',0,'',0,'LineageMonster2.barka_silenos_warrior','16.00','41.00',74,'male','L2Monster',40,'8619.00000','1432.00000','17.00000','3.00000',40,43,30,21,20,20,38113,4028,'693.00000','535.00000','241.00000','357.00000',230,4,0,333,142,6918,0,34,175,1,1,0,1),
(18656,18656,'Varka\'s Head Magus',0,'',0,'LineageMonster2.barka_silenos_shaman','14.00','39.50',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,2885,333,'1251.00000','513.00000','863.00000','342.00000',230,1,0,333,6716,0,0,36,150,1,1,0,1),
(18657,18657,'Prophet Guard',0,'',0,'LineageMonster2.barka_silenos_warrior','16.00','41.00',74,'male','L2Monster',40,'8619.00000','1462.00000','17.00000','3.00000',40,43,30,21,20,20,37565,4122,'720.00000','542.00000','249.00000','361.00000',230,4,0,333,2504,6918,0,34,175,1,1,0,1),
(18658,18658,'Disciple of Prophet',0,'',0,'LineageMonster2.barka_silenos_priest','9.00','41.50',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,2885,333,'1251.00000','513.00000','863.00000','342.00000',230,4,0,333,6716,0,0,36,180,1,1,0,1),
(18659,18659,'Varka\'s Prophet',0,'',0,'LineageMonster2.barka_silenos_shaman_20_bi','17.00','47.50',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,2885,346,'1251.00000','513.00000','863.00000','342.00000',230,1,0,333,6716,0,0,36,150,1,1,0,1),
(18660,18660,'Latana',0,'',0,'LineageMonster4.wounded_dragon','60.00','60.00',75,'female','L2Monster',40,'60326.00000','1139.00000','17.00000','2.70000',40,43,30,21,20,20,453825,4067,'7755.00000','524.00000','891.00000','348.00000',230,4,800,3819,0,0,0,1,80,1,1,0,1),
(18661,18661,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',75,'male','L2Npc',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,8087,614,'1293.00000','524.00000','891.00000','348.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18662,18662,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',73,'male','L2Npc',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,7661,300,'1209.00000','502.00000','830.00000','334.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18663,18663,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',73,'male','L2Npc',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1209.00000','502.00000','830.00000','334.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18664,18664,'Fortune Bug',0,'',0,'LineageMonster4.jackpot_bug','16.00','22.50',52,'male','L2Monster',40,'1520.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'472.00000','295.00000','321.00000','197.00000',230,4,0,333,0,0,0,45,160,1,1,0,1),
(18665,18665,'Fortune Bug',0,'',0,'LineageMonster4.jackpot_bug','16.00','22.50',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,45,160,1,1,0,1),
(18666,18666,'Fortune Bug',0,'',0,'LineageMonster4.jackpot_bug','16.00','22.50',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1293.00000','524.00000','891.00000','348.00000',230,4,0,333,0,0,0,45,160,1,1,0,1),
(18667,18667,'Ward of Death',0,'',0,'LineageNpcEV.trap_immortality','24.00','48.50',83,'female','L2Monster',40,'3835.00000','1617.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1875.00000','609.00000','1293.00000','405.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18668,18668,'Ward of Death',0,'',0,'LineageNpcEV.trap_immortality','24.00','48.50',83,'female','L2Monster',40,'3835.00000','1617.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1875.00000','609.00000','1293.00000','405.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18669,18669,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1209.00000','502.00000','830.00000','334.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18670,18670,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1209.00000','502.00000','830.00000','334.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18671,18671,'Block',0,'',0,'LineageNPC2.block','16.00','17.00',1,'female','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','7.00000','26.00000',230,4,0,333,0,0,0,50,160,1,0,0,1),
(18672,18672,'Block',0,'',0,'LineageNPC2.block','16.00','17.00',1,'male','L2Block',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','7.00000','26.00000',230,4,0,333,0,0,0,50,160,1,0,0,1),
(18673,18673,'Block',0,'',0,'LineageNPC2.block','16.00','17.00',1,'female','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','7.00000','26.00000',230,4,0,333,0,0,0,50,160,1,0,0,1),
(18674,18674,'Block',0,'',0,'LineageNPC2.block','16.00','17.00',1,'female','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','7.00000','26.00000',230,4,0,333,0,0,0,50,160,1,0,0,1),
(18675,18675,'Block',0,'',0,'LineageNPC2.block','16.00','17.00',1,'female','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','7.00000','26.00000',230,4,0,333,0,0,0,50,160,1,0,0,1),
(18676,18676,'Block-Carrying Girl',0,'',0,'LineageNPC2.block_mother','12.00','31.00',73,'female','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1209.00000','502.00000','830.00000','334.00000',230,4,0,333,0,0,0,120,120,1,1,0,1),
(18677,18677,'Dragon Steed Troop Messenger',0,'',0,'LineageMonster4.dragon_peltast','25.00','46.50',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1209.00000','502.00000','830.00000','334.00000',230,4,0,333,0,0,0,89,220,1,1,0,1),
(18678,18678,'Energy Seed - Water',0,'',0,'LineageNPC.seed_click_dummy_water','10.00','10.00',1,'male','L2Npc',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','7.00000','26.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18679,18679,'Energy Seed - Fire',0,'',0,'LineageNPC.seed_click_dummy_fire','10.00','10.00',1,'male','L2Npc',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','7.00000','26.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18680,18680,'Energy Seed - Wind',0,'',0,'LineageNPC.seed_click_dummy_wind','10.00','10.00',2,'male','L2Npc',40,'48.00000','43.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','42.00000','7.00000','28.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18681,18681,'Energy Seed - Earth',0,'',0,'LineageNPC.seed_click_dummy_earth','10.00','10.00',2,'male','L2Npc',40,'48.00000','43.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','42.00000','7.00000','28.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18682,18682,'Energy Seed - Divinity',0,'',0,'LineageNPC.seed_click_dummy_holy','10.00','10.00',3,'male','L2Npc',40,'58.00000','50.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'9.00000','44.00000','9.00000','30.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18683,18683,'Energy Seed - Darkness',0,'',0,'LineageNPC.seed_click_dummy_dark','10.00','10.00',3,'male','L2Npc',40,'58.00000','50.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'9.00000','44.00000','9.00000','30.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18684,18684,'Red Star Stone',0,'',0,'LineageNpcEV.star_stone_a','54.00','61.00',1,'female','L2FlyNpc',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','7.00000','26.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18685,18685,'Red Star Stone',0,'',0,'LineageNpcEV.star_stone_b','38.00','43.50',1,'female','L2FlyNpc',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','7.00000','26.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18686,18686,'Red Star Stone',0,'',0,'LineageNpcEV.star_stone_c','38.00','30.50',1,'female','L2FlyNpc',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','7.00000','26.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18687,18687,'Blue Star Stone',0,'',0,'LineageNpcEV.star_stone_a','54.00','61.00',1,'female','L2FlyNpc',40,'48.00000','43.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','42.00000','7.00000','28.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18688,18688,'Blue Star Stone',0,'',0,'LineageNpcEV.star_stone_b','38.00','43.50',1,'female','L2FlyNpc',40,'48.00000','43.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','42.00000','7.00000','28.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18689,18689,'Blue Star Stone',0,'',0,'LineageNpcEV.star_stone_c','38.00','30.50',1,'female','L2FlyNpc',40,'48.00000','43.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','42.00000','7.00000','28.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18690,18690,'Green Star Stone',0,'',0,'LineageNpcEV.star_stone_a','54.00','61.00',1,'female','L2FlyNpc',40,'58.00000','50.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'9.00000','43.00000','9.00000','29.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18691,18691,'Green Star Stone',0,'',0,'LineageNpcEV.star_stone_b','38.00','43.50',1,'female','L2FlyNpc',40,'58.00000','50.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'9.00000','43.00000','9.00000','29.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18692,18692,'Green Star Stone',0,'',0,'LineageNpcEV.star_stone_c','38.00','30.50',1,'female','L2FlyNpc',40,'58.00000','50.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'9.00000','43.00000','9.00000','29.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18693,18693,'Treasure Box of the Ancient Giants',0,'',0,'LineageMonster.mimic','8.50','8.50',76,'male','L2Monster',40,'1.00000','1402.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1349.00000','534.00000','931.00000','356.00000',230,4,0,333,0,0,0,80,1,1,1,0,1),
(18694,18694,'Treasure Box Guard',0,'',0,'LineageMonster2.magmagoil_lad_20_sm','12.00','60.00',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,1,0,333,0,0,0,1,1,1,1,0,1),
(18695,18695,'Treasure Box Guard',0,'',0,'LineageMonster2.magmagoil_20_sm','12.00','60.00',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18696,18696,'Dimension Moving Device',0,'',0,'LineageNpcEV.teleport_gate_of_legion','44.50','7.00',80,'female','L2Monster',40,'13505.00000','1680.00000','95.72635','3.00000',40,43,30,21,20,20,0,0,'2050.00000','3288.00000','1455.00000','419.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18697,18697,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Monster',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18698,18698,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Monster',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18699,18699,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Monster',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18700,18700,'',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Monster',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18701,18701,'',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Monster',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18702,18702,'Dimension Moving Device',0,'',0,'LineageNpcEV.teleport_gate_of_legion','44.50','7.00',80,'female','L2Npc',40,'111547.00000','1680.00000','195.70889','3.00000',40,43,30,21,20,20,0,0,'15685.00000','1008.00000','11135.00000','1005.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18703,18703,'Defeated Troops Controller',0,'',0,'LineageNpcEV.crystal_of_secret_door','57.00','74.00',80,'female','L2Monster',40,'111547.00000','1680.00000','195.70889','3.00000',40,43,30,21,20,20,0,0,'15685.00000','1008.00000','11135.00000','1005.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18704,18704,'Tumor of Death',0,'',0,'LineageNpcEV.tumor_immortality','42.00','55.00',79,'female','L2Monster',40,'339687.00000','1524.00000','197.22315','3.00000',40,43,30,21,20,20,0,0,'12520.00000','924.00000','8684.00000','921.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18705,18705,'Destroyed Tumor',0,'',0,'LineageNpcEV.tumor_immortality_a','42.00','55.00',79,'female','L2TerrainObject',40,'339687.00000','1524.00000','197.22315','3.00000',40,43,30,21,20,20,0,0,'12520.00000','924.00000','8684.00000','921.00000',230,4,0,333,0,0,0,1,1,0,1,0,1),
(18706,18706,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality','0.00','6.00',79,'female','L2Monster',40,'33094.00000','1524.00000','115.29594','3.00000',40,43,30,21,20,20,0,0,'9623.00000','924.00000','6675.00000','921.00000',230,4,0,333,0,0,0,1,1,1,0,0,1),
(18707,18707,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1209.00000','502.00000','830.00000','334.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18708,18708,'Tumor of Death',0,'',0,'LineageNpcEV.tumor_immortality','42.00','55.00',81,'female','L2Monster',40,'111547.00000','1680.00000','194.03041','3.00000',40,43,30,21,20,20,0,0,'15685.00000','1008.00000','11069.00000','1005.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18709,18709,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality_080p','0.10','6.10',80,'female','L2Monster',40,'33094.00000','1524.00000','114.39958','3.00000',40,43,30,21,20,20,0,0,'9631.00000','923.00000','6635.00000','922.00000',230,4,0,333,0,0,0,1,1,1,0,0,1),
(18710,18710,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality','0.00','6.00',81,'female','L2Monster',40,'32946.00000','1586.00000','113.41926','3.00000',40,43,30,21,20,20,0,0,'9816.00000','957.00000','6808.00000','955.00000',230,4,0,333,0,0,0,1,1,1,0,0,1),
(18711,18711,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality_120p','0.00','8.50',81,'female','L2Monster',40,'32596.00000','1680.00000','113.41926','3.00000',40,43,30,21,20,20,0,0,'10100.00000','1008.00000','7128.00000','1005.00000',230,4,0,333,0,0,0,1,1,1,0,0,1),
(18712,18712,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality_080p','0.10','6.10',81,'female','L2Monster',40,'65104.00000','1680.00000','113.26544','3.00000',40,43,30,21,20,20,0,0,'9696.00000','1008.00000','6843.00000','1005.00000',230,4,0,333,0,0,0,1,1,1,0,0,1),
(18713,18713,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality','0.00','6.00',81,'female','L2Monster',40,'65104.00000','1680.00000','113.26544','3.00000',40,43,30,21,20,20,0,0,'9696.00000','1008.00000','6843.00000','1005.00000',230,4,0,333,0,0,0,1,1,1,0,0,1),
(18714,18714,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality_120p','0.00','8.50',81,'female','L2Monster',40,'65104.00000','1680.00000','113.26544','3.00000',40,43,30,21,20,20,0,0,'9696.00000','1008.00000','6843.00000','1005.00000',230,4,0,333,0,0,0,1,1,1,0,0,1),
(18715,18715,'Conquered Soul',0,'',0,'LineageMonster4.death_knight_n_104p','22.88','41.60',81,'male','L2Monster',80,'3835.00000','1617.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1307.00000','405.00000',230,4,0,333,13983,0,0,43,180,1,1,0,1),
(18716,18716,'Conquered Soul',0,'',0,'LineageMonster4.Death_slayer_080p','16.00','27.20',81,'male','L2Monster',40,'3835.00000','1617.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1307.00000','405.00000',230,4,0,333,13985,0,0,64,200,1,1,0,1),
(18717,18717,'Conquered Soul',0,'',0,'LineageMonster4.lich_b_088p','21.12','40.48',81,'male','L2Monster',40,'3835.00000','1617.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1307.00000','405.00000',230,4,0,333,0,0,0,46,200,1,1,0,1),
(18718,18718,'Sacrificed Fanatic',0,'',0,'LineageMonster4.ravager_silen_dead','27.00','48.50',81,'male','L2Npc',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1346.00000','546.00000','934.00000','363.00000',230,4,0,333,13987,0,0,1,200,1,1,0,1),
(18719,18719,'Sacrificed Fanatic',0,'',0,'LineageMonster4.disciple_silen_dead','19.00','44.00',81,'male','L2Npc',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1346.00000','546.00000','934.00000','363.00000',230,4,0,333,0,0,0,1,170,1,1,0,1),
(18720,18720,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18721,18721,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18722,18722,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18723,18723,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18724,18724,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18725,18725,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18726,18726,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18727,18727,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18728,18728,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18729,18729,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18730,18730,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18731,18731,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18732,18732,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18733,18733,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18734,18734,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18735,18735,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18736,18736,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18737,18737,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18738,18738,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18739,18739,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18740,18740,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18741,18741,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18742,18742,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18743,18743,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18744,18744,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18745,18745,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18746,18746,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18747,18747,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18748,18748,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18749,18749,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18750,18750,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18751,18751,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18752,18752,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18753,18753,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18754,18754,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18755,18755,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18756,18756,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18757,18757,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18758,18758,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18759,18759,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18760,18760,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18761,18761,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18762,18762,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18763,18763,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18764,18764,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18765,18765,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18766,18766,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18767,18767,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18768,18768,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18769,18769,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18770,18770,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18771,18771,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18772,18772,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18773,18773,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18774,18774,'Trap',0,'',0,'LineageNpc2.trap_mark','5.00','10.00',80,'etc','L2Npc',40,'3290.00000','1524.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1627.00000','577.00000','1117.00000','384.00000',230,4,0,333,0,0,0,50,100,1,1,0,1),
(18775,18775,'Seed of Destruction Control Device',0,'',0,'LineageNpcEV.crystal_of_secret_door','57.00','74.00',81,'female','L2Npc',40,'32946.00000','1586.00000','113.41926','3.00000',40,43,30,21,20,20,147312,11412,'9816.00000','957.00000','6808.00000','955.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18776,18776,'Obelisk',0,'',0,'LineageNpcEV.obelisk_of_middle_square','229.00','177.50',81,'female','L2Monster',40,'32946.00000','1586.00000','113.41926','3.00000',40,43,30,21,20,20,0,0,'9816.00000','957.00000','6808.00000','955.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18777,18777,'Great Powerful Device',0,'',0,'LineageNpcEV.crystal_of_secret_door','57.00','74.00',81,'female','L2Monster',40,'32946.00000','1586.00000','113.41926','3.00000',40,43,30,21,20,20,0,0,'9816.00000','957.00000','6808.00000','955.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18778,18778,'Throne of Destruction Powerful Device',0,'',0,'LineageNpcEV.protector_of_seed','57.00','74.00',81,'female','L2Monster',40,'32946.00000','1586.00000','113.41926','3.00000',40,43,30,21,20,20,0,0,'9816.00000','957.00000','6808.00000','955.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18779,18779,'',0,'',0,'LineageNPC.clear_npc','0.10','0.10',82,'male','L2Monster',40,'3644.00000','1586.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1789.00000','598.00000','1230.00000','398.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18780,18780,'Symbol of Cohemenes',0,'',0,'LineageNpcEV.trap_immortality','24.00','48.50',83,'female','L2Monster',40,'3835.00000','1617.00000','111.35538','3.00000',40,43,30,21,20,20,0,0,'1875.00000','609.00000','1293.00000','405.00000',230,4,0,333,0,0,0,1,1,1,1,0,1),
(18781,18781,'Young Drake Wing',0,'',0,'LineageMonster4.m_drake_wing_knave','153.00','63.00',83,'male','L2Monster',40,'3835.00000','1617.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1875.00000','609.00000','1293.00000','405.00000',230,4,0,333,0,0,0,60,150,1,1,0,1),
(18782,18782,'Zealot of Shilen',0,'',0,'LineageMonster4.disciple_silen','19.00','44.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','313.00000',230,4,0,333,0,0,0,73,170,1,1,0,1),
(18783,18783,'Defeated Troops Commander',0,'',0,'LineageMonster4.Dragon_centurion_135p','28.00','46.50',81,'male','L2Monster',40,'112316.00000','1617.00000','194.03041','3.00000',40,43,30,21,20,20,0,0,'15445.00000','974.00000','10775.00000','971.00000',230,4,0,333,13978,0,0,55,210,1,1,0,1),
(18784,18784,'Defeated Troops No 1 Battalion Commander',0,'',0,'LineageMonster4.Dragon_centurion_135p','28.00','46.50',81,'male','L2Monster',40,'112717.00000','1586.00000','194.03041','3.00000',40,43,30,21,20,20,0,0,'15325.00000','957.00000','10629.00000','955.00000',230,4,0,333,13978,0,0,55,210,1,1,0,1),
(18785,18785,'Defeated Troops White Dragon Leader',0,'',0,'LineageMonster4.Dragon_centurion_120p','22.00','42.00',81,'male','L2Monster',40,'112922.00000','1555.00000','194.03041','3.00000',40,43,30,21,20,20,0,0,'15215.00000','940.00000','10474.00000','939.00000',230,4,0,333,13979,13980,0,56,210,1,1,0,1),
(18786,18786,'Defeated Troops Infantry',0,'',0,'LineageMonster4.Dragon_centurion_120p','22.00','42.00',80,'male','L2Monster',40,'113229.00000','1524.00000','195.70889','3.00000',40,43,30,21,20,20,0,0,'15093.00000','923.00000','10390.00000','922.00000',230,4,0,333,13979,13980,0,56,210,1,1,0,1),
(18787,18787,'Defeated Troops Magic Leader',0,'',0,'LineageMonster4.dragon_mage_075p','28.00','39.50',81,'male','L2Monster',40,'56403.00000','1586.00000','194.18423','3.00000',40,43,30,21,20,20,0,0,'15700.00000','957.00000','10889.00000','955.00000',230,4,0,333,0,0,0,92,170,1,1,0,1),
(18788,18788,'Defeated Troops Magician',0,'',0,'LineageMonster4.dragon_mage_075p','28.00','39.50',81,'male','L2Monster',40,'56506.00000','1555.00000','194.18423','3.00000',40,43,30,21,20,20,0,0,'15582.00000','940.00000','10726.00000','939.00000',230,4,0,333,0,0,0,92,170,1,1,0,1),
(18789,18789,'Defeated Troops Magic Soldier',0,'',0,'LineageMonster4.dragon_mage_065p','25.00','34.50',80,'male','L2Monster',40,'33094.00000','1524.00000','114.39958','3.00000',40,43,30,21,20,20,0,0,'9631.00000','923.00000','6635.00000','922.00000',230,4,0,333,13981,0,0,82,170,1,1,0,1),
(18790,18790,'Defeated Troops Healer',0,'',0,'LineageMonster4.dragon_mage_065p','25.00','34.50',79,'male','L2Monster',40,'33155.00000','1493.00000','115.29594','3.00000',40,43,30,21,20,20,0,0,'9462.00000','906.00000','6517.00000','905.00000',230,4,0,333,13981,0,0,82,170,1,1,0,1),
(18791,18791,'Defeated Troops Javelin Thrower',0,'',0,'LineageMonster4.dragon_peltast','25.00','46.50',80,'male','L2Monster',1100,'56659.00000','1524.00000','195.86371','3.00000',40,43,30,21,20,20,0,0,'15449.00000','923.00000','10641.00000','922.00000',230,8,0,333,13843,0,0,89,220,1,1,0,1),
(18792,18792,'Defeated Troops Javelin Thrower',0,'',0,'LineageMonster4.dragon_peltast','25.00','46.50',80,'male','L2Monster',1100,'56659.00000','1524.00000','195.86371','3.00000',40,43,30,21,20,20,0,0,'15449.00000','923.00000','10641.00000','922.00000',230,8,0,333,13843,0,0,89,220,1,1,0,1),
(18793,18793,'Bizarre Cocoon',0,'',0,'LineageNpcEV.n_event_stakato_egg_a','24.00','27.00',84,'male','L2Monster',40,'2444.00000','2444.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',278,4,0,333,0,0,0,1,1,1,1,0,0),
(18794,18794,'Bizarre Cocoon',0,'',0,'LineageNpcEV.n_event_stakato_egg_b','35.00','27.00',84,'male','L2Monster',40,'2444.00000','2444.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',278,4,0,333,0,0,0,1,1,1,1,0,0),
(18795,18795,'Bizarre Cocoon',0,'',0,'LineageNpcEV.n_event_stakato_egg_c','48.00','27.00',84,'male','L2Monster',40,'2444.00000','2444.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',278,4,0,333,0,0,0,1,1,1,1,0,0),
(18796,18796,'Bizarre Cocoon',0,'',0,'LineageNpcEV.n_event_stakato_egg_d','24.00','27.00',84,'male','L2Monster',40,'2444.00000','2444.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',278,4,0,333,0,0,0,1,1,1,1,0,0),
(18797,18797,'Bizarre Cocoon',0,'',0,'LineageNpcEV.n_event_stakato_egg_e','35.00','27.00',84,'male','L2Monster',40,'2444.00000','2444.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',278,4,0,333,0,0,0,1,1,1,1,0,0),
(18798,18798,'Bizarre Cocoon',0,'',0,'LineageNpcEV.n_event_stakato_egg_f','48.00','27.00',84,'male','L2Monster',40,'2444.00000','2444.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',278,4,0,333,0,0,0,1,1,1,1,0,0),
(18799,18799,'Newborn Lavasaurus',0,'',0,'LineageMonster2.magmagoil_20_sm','12.00','60.00',77,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,49441,5079,'1409.00000','545.00000','971.00000','362.00000',253,1,0,333,0,0,0,1,1,1,1,0,0),
(18800,18800,'Fledgling Lavasaurus',0,'',0,'LineageMonster2.magmagoil','15.00','75.00',77,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,49441,5079,'1409.00000','545.00000','971.00000','362.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(18801,18801,'Adult Lavasaurus',0,'',0,'LineageMonster2.magmagoil_lad_20_sm','12.00','60.00',77,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,49441,5079,'1409.00000','545.00000','971.00000','362.00000',253,1,0,333,0,0,0,1,1,1,1,0,0),
(18802,18802,'Elderly Lavasaurus',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,50733,5271,'1474.00000','556.00000','1016.00000','370.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(18803,18803,'Ancient Lavasaurus',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,50733,5271,'1474.00000','556.00000','1016.00000','370.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(18804,18804,'Tar Beetle',0,'',0,'LineageMonster2.scarab_20_sm_e','18.00','26.00',78,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1474.00000','556.00000','1016.00000','370.00000',253,4,0,333,0,0,0,45,180,0,1,0,0),
(18805,18805,'Waste Landfill Machine',0,'',0,'LineageNpcEV.riding_control_unit_c','19.00','28.00',83,'female','L2Monster',40,'4639.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(18806,18806,'Brazier of Purity',0,'',0,'LineageNpcEV.warp_gate_a','16.00','31.00',83,'male','L2Monster',40,'4639.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(18807,18807,'Frightened Ragna Orc',0,'',0,'LineageMonster.batur_orc_03te','9.00','21.50',81,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,2639,292,'1705.00000','588.00000','1176.00000','391.00000',253,4,0,333,0,0,0,80,130,1,1,0,0),
(18808,18808,'Dark Shaman Varangka',0,'',0,'LineageMonster2.ketra_orc_chieftain_20_bi_e','17.00','46.20',82,'male','L2Monster',40,'3862.00000','1494.00000','41.20673','50.00000',40,43,30,21,20,20,142334,15560,'834.00000','598.00000','1233.00000','398.00000',253,1,0,333,6719,0,0,24,175,1,1,0,0),
(18809,18809,'Varangka\'s Retainer',0,'',0,'LineageMonster.batur_orc_overlord_03te_120p','12.00','28.00',82,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,16412,1794,'834.00000','598.00000','1233.00000','398.00000',253,4,0,333,6365,0,0,80,140,1,1,0,0),
(18810,18810,'Varangka\'s Page',0,'',0,'LineageMonster.batur_orc_shaman_a_01te_120p_e','11.00','21.50',82,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,17412,1904,'834.00000','598.00000','1233.00000','398.00000',253,4,0,333,8680,0,0,50,120,1,1,0,0),
(18811,18811,'Guardian of the Altar',0,'',0,'LineageMonster2.parasitic_eye_050p_e','17.00','29.00',82,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1788.00000','598.00000','1233.00000','398.00000',253,1,0,333,0,0,0,30,160,1,1,0,0),
(18812,18812,'Kasha\'s Eye',0,'',0,'LineageMonster2.parasitic_eye_050p_e_r','17.00','29.00',81,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1705.00000','588.00000','1176.00000','391.00000',253,4,0,333,0,0,0,30,160,1,1,0,0),
(18813,18813,'Kasha\'s Eye',0,'',0,'LineageMonster2.parasitic_eye_050p_e_g','17.00','29.00',81,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1705.00000','588.00000','1176.00000','391.00000',253,4,0,333,0,0,0,30,160,1,1,0,0),
(18814,18814,'Kasha\'s Eye',0,'',0,'LineageMonster2.parasitic_eye_050p_e_b','17.00','29.00',81,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1705.00000','588.00000','1176.00000','391.00000',253,4,0,333,0,0,0,30,160,1,1,0,0),
(18815,18815,'Guard of the Grave',0,'Death-calling',0,'LineageMonster2.magmagoil_20_sm','12.00','60.00',83,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(18816,18816,'Chieftain\'s Treasure Chest',0,'',0,'LineageMonster.mimic','8.50','8.50',81,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1705.00000','588.00000','1176.00000','391.00000',253,4,0,333,0,0,0,80,120,1,1,0,0),
(18817,18817,'Invader Martyr of Nightmare',0,'',0,'LineageMonster.doll_master','20.00','42.00',81,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1705.00000','588.00000','1176.00000','391.00000',253,1,0,333,0,0,0,80,160,1,1,0,0),
(18818,18818,'Nihil Invader Martyr',0,'',0,'LineageMonster5.scapegoat','20.00','32.50',81,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1705.00000','588.00000','1176.00000','391.00000',253,4,0,333,0,0,0,45,180,1,1,0,0),
(18819,18819,'Nihil Invader Treasure Chest',0,'',0,'LineageMonster5.bounded_mimic','11.00','8.00',82,'female','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1788.00000','598.00000','1233.00000','398.00000',253,4,0,333,0,0,0,30,120,1,1,0,0),
(18820,18820,'Nihil Invader Treasure Chest',0,'',0,'LineageMonster5.bounded_mimic','11.00','8.00',82,'female','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1788.00000','598.00000','1233.00000','398.00000',253,4,0,333,0,0,0,30,120,1,1,0,0),
(18821,18821,'Mutant Martyr',0,'',0,'LineageMonster5.doll_claw','28.00','50.00',84,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,50,165,1,1,0,0),
(18822,18822,'Mutant Treasure Chest',0,'',0,'LineageMonster5.bounded_mimic','11.00','8.00',84,'female','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,30,120,1,1,0,0),
(18823,18823,'Mutant Treasure Chest',0,'',0,'LineageMonster5.bounded_mimic','11.00','8.00',84,'female','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,30,120,1,1,0,0),
(18824,18824,'Merchant of Mammon A',0,'',0,'LineageNPC.a_warehouse_keeper_MDwarf','8.00','17.00',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,50,100,1,1,0,0),
(18825,18825,'Merchant of Mammon B',0,'',0,'LineageNPC.e_guard_MDwarf','8.00','19.00',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,50,100,1,1,0,0),
(18826,18826,'Shilen\'s Evil Thoughts For Presentation',0,'',0,'LineageMonster5.vicious_mind_of_silen','14.00','27.50',80,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1625.00000','577.00000','1121.00000','384.00000',253,4,0,333,0,0,0,30,180,1,1,0,0),
(18827,18827,'Priest Cain for Presentation',0,'',0,'LineageNPC.a_sanctuary_teacher_MHuman','8.00','23.00',80,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1625.00000','577.00000','1121.00000','384.00000',253,4,0,333,0,0,0,50,100,1,1,0,0),
(18828,18828,'High Priest of Dawn',0,'',0,'LineageNPC2.high_priest_of_dawn','10.00','22.50',80,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1625.00000','577.00000','1121.00000','384.00000',253,4,0,333,0,0,0,50,100,1,1,0,0),
(18829,18829,'Shilen\'s Evil Thoughts Leader For Presentation',0,'',0,'LineageMonster5.leader_mind_of_silen','27.00','40.00',80,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1625.00000','577.00000','1121.00000','384.00000',253,4,0,333,0,0,0,45,180,1,1,0,0),
(18830,18830,'ssq For Presentation Camera Dummy 1',0,'',0,'LineageNPC.camera_target_dummy','11.00','25.00',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(18831,18831,'ssq For Presentation Camera Dummy 2',0,'',0,'LineageNPC.camera_target_dummy','11.00','25.00',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(18832,18832,'ssq For Presentation Camera Dummy 3',0,'',0,'LineageNPC.camera_target_dummy','11.00','25.00',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(18833,18833,'Emperor\'s Seal Device',0,'',0,'LineageNPCEV.ssq_sealing_emperor','16.00','24.00',1,'female','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(18834,18834,'Guards of the Dawn',0,'',0,'LineageNPC.a_fighterguild_master_Mhuman','8.00','23.50',85,'male','L2Npc',80,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,16,0,0,50,100,1,1,0,0),
(18835,18835,'Guards of the Dawn',0,'',0,'LineageNPC.a_mageguild_master_MHuman','8.00','24.00',85,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,1,0,333,5,0,0,50,100,1,1,0,0),
(18836,18836,'Varangka\'s Guardian',0,'',0,'LineageMonster2.ahrimanes_70p','14.00','39.50',82,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,16412,1794,'1788.00000','598.00000','1233.00000','398.00000',253,4,0,333,0,0,0,35,185,1,1,0,0),
(18837,18837,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.10','0.10',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,0,1,0,0),
(18838,18838,'Treasure Chest of Invader Soldier of Nightmare',0,'',0,'LineageMonster5.bounded_mimic','11.00','8.00',84,'female','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,30,120,1,1,0,0),
(18839,18839,'Wild Maguen',0,'',0,'LineageMonster5.marguene','11.00','13.25',85,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,15,120,1,1,0,0),
(18840,18840,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.10','0.10',85,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18841,18841,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.10','0.10',85,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18842,18842,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.10','0.10',85,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18843,18843,'Cokrakon\'s Ward',0,'',0,'LineageNpcEV.totem_of_cocracon_a','30.00','54.00',85,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,1,1,0,1,0,0),
(18844,18844,'Reptilikon\'s Ward',0,'',0,'LineageNpcEV.totem_of_cocracon_b','30.00','54.00',85,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,1,1,0,1,0,0),
(18845,18845,'Torumba\'s Telegraph',0,'',0,'LineageNPC.camera_target_dummy_a','0.10','0.10',85,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18846,18846,'Kegor',0,'',0,'LineageMonster5.swordmaster_kegor','15.00','27.50',85,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,40,120,1,1,0,0),
(18847,18847,'Freya',0,'Ice Queen',0,'LineageMonster5.freya_throne','50.00','98.50',85,'female','L2Npc',40,'3862.00000','1494.00000','918.19550','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,45,150,1,1,0,0),
(18848,18848,'Battalion Leader',0,'Jinia Guild',0,'LineageNPC2.garrison_of_insurgents','10.00','23.75',85,'female','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,80,641,0,30,160,1,1,0,0),
(18849,18849,'Legionnaire',0,'Jinia Guild',0,'LineageNPC2.officer_of_insurgents_orc','14.50','30.00',85,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,9813,9813,0,40,160,1,1,0,0),
(18850,18850,'Jinia',0,'',0,'LineageMonster5.guildmaster_jinia','11.00','23.50',85,'female','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,40,120,1,1,0,0),
(18851,18851,'Kegor',0,'',0,'LineageMonster5.swordmaster_kegor','15.00','27.50',85,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,40,120,1,1,0,0),
(18852,18852,'Sirra',0,'',0,'LineageMonster5.human_sirr','10.00','22.00',85,'female','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,40,120,1,1,0,0),
(18853,18853,'Glacier',0,'',0,'LineageNpcEV.freezing_stone','24.00','27.00',85,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(18854,18854,'Archer\'s Breath',0,'',0,'LineageMonster5.ice_elemental_bomb','20.00','50.00',85,'male','L2Npc',40,'3862.00000','1494.00000','109.44298','3.00000',40,43,30,21,20,20,0,0,'10099.00000','1008.00000','6964.00000','1005.00000',253,4,0,333,0,0,0,30,80,1,1,0,0),
(18855,18855,'Archery Knight',0,'',0,'LineageMonster5.ice_knight','9.50','31.00',85,'male','L2Npc',40,'3862.00000','1494.00000','109.44298','3.00000',40,43,30,21,20,20,0,0,'10099.00000','1008.00000','6964.00000','1005.00000',253,4,0,333,0,0,0,20,150,1,1,0,0),
(18856,18856,'Archery Knight',0,'',0,'LineageMonster5.ice_knight','9.50','31.00',85,'male','L2Npc',40,'3862.00000','1494.00000','109.44298','300.00000',40,43,30,21,20,20,0,0,'27771.00000','1008.00000','6964.00000','1005.00000',253,4,0,333,0,0,0,20,150,1,1,0,0),
(18857,18857,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.10','0.10',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18858,18858,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.10','0.10',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18859,18859,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.10','0.10',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18860,18860,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.10','0.10',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18861,18861,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.10','0.10',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18862,18862,'Tanta Lizardman Guard',0,'Escort of Ugoros',0,'LineageMonster.zenta_lizardman_warrior','13.00','35.00',82,'male','L2Monster',80,'4039.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,19616,2145,'1788.00000','598.00000','1233.00000','398.00000',278,4,0,333,98,0,0,40,140,1,1,0,0),
(18863,18863,'Seer Ugoros',0,'Tanta Lizardmen',0,'LineageMonster5.tantaar_lizardman_high_sorcerer','40.00','53.50',84,'male','L2Monster',40,'30390.00000','4812.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',278,4,0,333,0,0,0,90,150,1,1,0,0),
(18864,18864,'Fantasy Mushroom',0,'',0,'LineageNpcEV.target_board_a','16.00','23.00',85,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',278,4,0,333,0,0,0,1,1,1,1,0,0),
(18865,18865,'Sticky Mushroom',0,'',0,'LineageNpcEV.rug_fungus','15.00','25.00',85,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',278,4,0,333,0,0,0,1,1,1,1,0,0),
(18866,18866,'Rainbow Frog',0,'',0,'LineageMonster5.poison_arrow_frog','20.00','18.00',85,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',278,4,0,333,0,0,0,15,40,1,1,0,0),
(18867,18867,'Abyss Weed',0,'',0,'LineageNpcEV.poison_plant_b','30.00','27.00',85,'male','L2Monster',40,'1.00000','1.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',278,4,0,333,0,0,0,1,1,1,1,0,0),
(18868,18868,'Energy Plant',0,'',0,'LineageNpcEV.rosehip_fragrant','15.00','33.00',85,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',278,4,0,333,0,0,0,1,1,1,1,0,0),
(18869,18869,'Kookaburra',1,'Tame',0,'LineageMonster2.baby_ostrich','7.00','15.00',83,'male','L2TamedBeast',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,13,110,1,1,0,0),
(18870,18870,'Cougar',1,'Tame',0,'LineageMonster2.baby_tiger','11.00','15.70',83,'male','L2TamedBeast',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',253,1,0,333,0,0,0,28,110,1,1,0,0),
(18871,18871,'Buffalo',1,'Tame',0,'LineageMonster2.baby_buffalo','12.00','15.00',84,'male','L2TamedBeast',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,30,110,1,1,0,0),
(18872,18872,'Grendel',1,'Tame',0,'LineageMonster5.baby_bionic_bear','9.00','12.50',84,'male','L2TamedBeast',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,40,120,1,1,0,0),
(18873,18873,'Baby Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7.00','15.00',83,'male','L2FeedableBeast',40,'3835.00000','1777.00000','8.50000','3.00000',40,43,30,21,20,20,11630,1256,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,13,110,1,1,1,0),
(18874,18874,'Young Kookaburra',0,'',0,'LineageMonster2.baby_ostrich_140p','12.00','21.00',83,'male','L2FeedableBeast',40,'3835.00000','1777.00000','8.50000','3.00000',40,43,30,21,20,20,18776,1918,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,13,110,1,1,1,0),
(18875,18875,'Young Kookaburra',0,'',0,'LineageMonster2.baby_ostrich_140p','12.00','21.00',83,'male','L2FeedableBeast',40,'3835.00000','1777.00000','8.50000','3.00000',40,43,30,21,20,20,25005,2686,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,13,110,1,1,1,0),
(18876,18876,'Adult Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8.00','26.40',83,'male','L2FeedableBeast',40,'3835.00000','1777.00000','8.50000','3.00000',40,43,30,21,20,20,8516,874,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,23,190,1,1,1,0),
(18877,18877,'Adult Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8.00','26.40',83,'male','L2FeedableBeast',40,'3835.00000','1777.00000','8.50000','3.00000',40,43,30,21,20,20,72113,7459,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,23,190,1,1,1,0),
(18878,18878,'Full Grown Kookaburra',0,'',0,'LineageMonster2.rough_ostrich','10.00','33.00',83,'male','L2FeedableBeast',40,'3835.00000','1777.00000','8.50000','3.00000',40,43,30,21,20,20,11959,1246,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,23,190,1,1,1,0),
(18879,18879,'Full Grown Kookaburra',0,'',0,'LineageMonster2.rough_ostrich','10.00','33.00',83,'male','L2FeedableBeast',40,'3835.00000','1777.00000','8.50000','3.00000',40,43,30,21,20,20,76500,6972,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,23,190,1,1,1,0),
(18880,18880,'Baby Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11.00','15.70',83,'male','L2FeedableBeast',40,'3835.00000','1777.00000','8.50000','3.00000',40,43,30,21,20,20,11630,1256,'1874.00000','609.00000','1292.00000','405.00000',253,1,0,333,0,0,0,28,110,1,1,1,0),
(18881,18881,'Young Cougar',0,'',0,'LineageMonster2.baby_tiger_130p','13.00','21.00',83,'male','L2FeedableBeast',40,'3835.00000','1777.00000','8.50000','3.00000',40,43,30,21,20,20,18776,1918,'1874.00000','609.00000','1292.00000','405.00000',253,1,0,333,0,0,0,28,110,1,1,1,0),
(18882,18882,'Young Cougar',0,'',0,'LineageMonster2.baby_tiger_130p','13.00','21.00',83,'male','L2FeedableBeast',40,'3835.00000','1777.00000','8.50000','3.00000',40,43,30,21,20,20,25005,2686,'1874.00000','609.00000','1292.00000','405.00000',253,1,0,333,0,0,0,28,110,1,1,1,0),
(18883,18883,'Adult Cougar',0,'',0,'LineageMonster2.youth_tiger','16.00','17.20',83,'male','L2FeedableBeast',40,'3835.00000','1777.00000','8.50000','3.00000',40,43,30,21,20,20,8516,874,'1874.00000','609.00000','1292.00000','405.00000',253,1,0,333,0,0,0,60,170,1,1,1,0),
(18884,18884,'Adult Cougar',0,'',0,'LineageMonster2.youth_tiger','16.00','17.20',83,'male','L2FeedableBeast',40,'3835.00000','1777.00000','8.50000','3.00000',40,43,30,21,20,20,72113,7459,'1874.00000','609.00000','1292.00000','405.00000',253,1,0,333,0,0,0,60,170,1,1,1,0),
(18885,18885,'Full Grown Cougar',0,'',0,'LineageMonster.saber_toothed_tiger','34.00','28.00',83,'male','L2FeedableBeast',40,'3835.00000','1777.00000','8.50000','3.00000',40,43,30,21,20,20,11959,1246,'1874.00000','609.00000','1292.00000','405.00000',253,1,0,333,0,0,0,60,170,1,1,1,0),
(18886,18886,'Full Grown Cougar',0,'',0,'LineageMonster.saber_toothed_tiger','34.00','28.00',83,'male','L2FeedableBeast',40,'3835.00000','1777.00000','8.50000','3.00000',40,43,30,21,20,20,76500,6972,'1874.00000','609.00000','1292.00000','405.00000',253,1,0,333,0,0,0,60,170,1,1,1,0),
(18887,18887,'Baby Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12.00','15.00',84,'male','L2FeedableBeast',40,'4039.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,12929,1379,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,30,110,1,1,1,0),
(18888,18888,'Young Buffalo',0,'',0,'LineageMonster2.baby_buffalo_140p','16.00','22.00',84,'male','L2FeedableBeast',40,'4039.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,20911,2111,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,30,110,1,1,1,0),
(18889,18889,'Young Buffalo',0,'',0,'LineageMonster2.baby_buffalo_140p','16.00','22.00',84,'male','L2FeedableBeast',40,'4039.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,27445,2908,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,30,110,1,1,1,0),
(18890,18890,'Adult Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16.00','25.20',84,'male','L2FeedableBeast',40,'4039.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,9438,957,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,20,170,1,1,1,0),
(18891,18891,'Adult Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16.00','25.20',84,'male','L2FeedableBeast',40,'4039.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,79302,8101,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,20,170,1,1,1,0),
(18892,18892,'Full Grown Buffalo',0,'',0,'LineageMonster2.buffalo','22.00','31.00',84,'male','L2FeedableBeast',40,'4039.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,13050,1342,'1962.00000','619.00000','1353.00000','412.00000',253,1,0,333,0,0,0,80,170,1,1,1,0),
(18893,18893,'Full Grown Buffalo',0,'',0,'LineageMonster2.buffalo','22.00','31.00',84,'male','L2FeedableBeast',40,'4039.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,83904,7596,'1962.00000','619.00000','1353.00000','412.00000',253,1,0,333,0,0,0,80,170,1,1,1,0),
(18894,18894,'Baby Alpine Grendel',0,'',0,'LineageMonster5.baby_bionic_bear','9.00','12.50',84,'male','L2FeedableBeast',40,'4039.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,12929,1379,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,40,120,1,1,1,0),
(18895,18895,'Young Grendel',0,'',0,'LineageMonster5.baby_bionic_bear_e','9.00','12.50',84,'male','L2FeedableBeast',40,'4039.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,20911,2111,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,40,120,1,1,1,0),
(18896,18896,'Young Grendel',0,'',0,'LineageMonster5.baby_bionic_bear_e','9.00','12.50',84,'male','L2FeedableBeast',40,'4039.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,27445,2908,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,40,120,1,1,1,0),
(18897,18897,'Adult Grendel',0,'',0,'LineageMonster2.bionic_bear','15.00','39.00',84,'male','L2FeedableBeast',40,'4039.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,9438,957,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,36,155,1,1,1,0),
(18898,18898,'Adult Grendel',0,'',0,'LineageMonster2.bionic_bear','15.00','39.00',84,'male','L2FeedableBeast',40,'4039.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,79302,8101,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,36,155,1,1,1,0),
(18899,18899,'Full Grown Grendel',0,'',0,'LineageMonster5.rough_bionic_bear','34.00','32.50',84,'male','L2FeedableBeast',40,'4039.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,13050,1342,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,40,120,1,1,1,0),
(18900,18900,'Full Grown Grendel',0,'',0,'LineageMonster5.rough_bionic_bear','34.00','32.50',84,'male','L2FeedableBeast',40,'4039.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,83904,7596,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,40,120,1,1,1,0),
(18901,18901,'Kookaburra',0,'Golden',0,'LineageMonster2.baby_ostrich_140p_e','12.00','21.00',83,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,13,110,1,1,0,0),
(18902,18902,'Cougar',0,'Golden',0,'LineageMonster2.baby_tiger_130p_e','13.00','21.00',83,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,28,110,1,1,0,0),
(18903,18903,'Buffalo',0,'Golden',0,'LineageMonster2.baby_buffalo_140p_e','16.00','22.00',84,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,30,110,1,1,0,0),
(18904,18904,'Grendel',0,'Golden',0,'LineageMonster5.baby_bionic_bear_160p','12.00','17.00',84,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,40,120,1,1,0,0),
(18905,18905,'Farm Ravager',0,'Crazed',0,'LineageMonster5.xel_mahum_warrior','29.00','37.00',84,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,243976,2243,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,60,180,1,1,0,0),
(18906,18906,'Farm Bandit',0,'',0,'LineageMonster5.xel_mahum_warrior','29.00','37.00',84,'male','L2Monster',40,'4039.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,17662,1884,'1962.00000','619.00000','1353.00000','412.00000',253,4,400,333,0,0,0,60,180,1,1,1,0),
(18907,18907,'Beast Devourer',0,'',0,'LineageMonster5.xel_mahum_sniper','27.00','31.00',84,'male','L2Monster',40,'4039.00000','1812.00000','8.50000','3.00000',40,43,30,21,20,20,18652,1990,'1962.00000','619.00000','1353.00000','412.00000',253,4,400,333,0,0,0,60,150,1,1,1,0),
(18908,18908,'Sel Mahum Chef',0,'',0,'LineageMonster5.ol_mahum_cooker','20.00','37.00',83,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,17548,1759,'1874.00000','609.00000','1292.00000','405.00000',253,4,0,333,0,0,0,40,120,1,1,0,0),
(18909,18909,'Solina Knights',0,'',0,'LineageMonster3.monk_warrior','12.00','28.40',83,'male','L2Monster',40,'6060.00000','2168.00000','8.50000','3.00000',40,43,30,21,20,20,29810,3060,'1874.00000','609.00000','1292.00000','405.00000',253,4,200,333,8211,8210,0,53,150,1,1,0,0),
(18910,18910,'Solina Knight Captain',0,'',0,'LineageMonster5.solina_knight','14.00','31.50',83,'male','L2Monster',40,'9090.00000','2168.00000','8.50000','3.00000',40,43,30,21,20,20,44216,4545,'1874.00000','609.00000','1292.00000','405.00000',253,4,200,333,0,0,0,30,66,1,1,0,0),
(18911,18911,'Abbey Treasure Chest',0,'',0,'LineageNpcEV.monastery_treasurebox','17.00','13.00',84,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'15.00000','77.00000','10.00000','51.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(18912,18912,'Scarecrow',0,'',0,'LineageNpcEV.puppet','27.00','37.50',1,'male','L2Monster',40,'50000.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,200,333,0,0,0,1,1,1,1,0,0),
(18913,18913,'Furnace',0,'',0,'LineageNpcEV.secret_pot_b','18.00','30.00',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(18914,18914,'Furnace',0,'',0,'LineageNpcEV.secret_pot_a','18.00','30.00',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(18915,18915,'Divine Furnace',0,'',0,'LineageNpcEV.secret_pot_c','18.00','30.00',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(18916,18916,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.10','0.10',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18917,18917,'Pavel Safety Device',0,'',0,'LineageMonster4.giga_whirligig_40p','12.00','22.50',72,'male','L2Monster',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1167.00000','492.00000','805.00000','327.00000',253,4,0,333,0,0,0,250,250,1,1,0,0),
(18918,18918,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.10','0.10',85,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18919,18919,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.10','0.10',85,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18920,18920,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.10','0.10',84,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18921,18921,'Square Base',0,'',0,'LineageNpcEV.dark_clouds_crystal','23.00','37.00',84,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(18922,18922,'Door Golem',0,'Final',0,'LineageMonster2.baby_buffalo','12.00','15.00',84,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,30,80,1,1,0,0),
(18923,18923,'Door Golem',0,'Final',0,'LineageMonster2.baby_buffalo','12.00','15.00',84,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,30,80,1,1,0,0),
(18924,18924,'Door Golem',0,'',0,'LineageMonster2.baby_buffalo','12.00','15.00',84,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,30,80,1,1,0,0),
(18925,18925,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30.00','13.00',84,'etc','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(18926,18926,'Mercenary Archer',0,'Jinia Guild',0,'LineageNPC2.archer_of_insurgents','10.00','23.50',85,'male','L2Npc',1100,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,8,0,333,0,0,0,30,160,1,1,0,0),
(18927,18927,'Fire',0,'',0,'LineageNpcEV.camp_fire_a','29.00','30.50',84,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18928,18928,'Annihilation Furnace',0,'',0,'LineageNpcEV.gracia_fire_pot','63.00','33.50',85,'male','L2TerrainObject',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18929,18929,'Ward of the Grail',0,'',0,'LineageMonster.will_o_wisp','13.00','22.00',84,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1962.00000','619.00000','1353.00000','412.00000',253,1,0,333,0,0,0,25,140,0,1,0,0),
(18930,18930,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.10','0.10',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18931,18931,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.10','0.10',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18932,18932,'',0,'',0,'LineageNpcEV.freezing_dummy','0.10','0.10',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18933,18933,'Fire Feed',0,'',0,'LineageNpcEV.camp_fire_c','29.00','30.50',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,1,0,0,0),
(18934,18934,'Abbey Treasure Chest',0,'',0,'LineageNpcEV.monastery_treasurebox','17.00','13.00',84,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'15.00000','77.00000','10.00000','51.00000',253,4,0,333,0,0,0,1,1,1,1,0,0),
(18935,18935,'Divine Sword Protection',0,'',0,'LineageNPC.camera_target_dummy_a','0.10','0.10',85,'male','L2Npc',40,'3862.00000','1494.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'2049.00000','630.00000','1413.00000','419.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(18936,18936,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.10','0.10',1,'male','L2Npc',40,'3862.00000','1494.00000','2.00000','0.90000',40,43,30,21,20,20,0,0,'8.00000','40.00000','5.00000','27.00000',253,4,0,333,0,0,0,1,1,0,0,0,0),
(20001,20001,'Gremlin',0,'',0,'LineageMonster.gremlin','10.00','15.00',1,'male','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,29,2,'8.00000','40.00000','7.00000','25.00000',230,4,0,333,0,0,0,20,50,1,1,0,1),
(20002,20002,'Rabbit',0,'',0,'LineageMonster.rabbit','5.00','4.50',1,'male','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,29,2,'8.00000','40.00000','7.00000','25.00000',230,4,0,333,0,0,0,50,80,1,1,0,1),
(20003,20003,'Goblin',0,'',0,'LineageMonster.goblin','10.00','16.50',5,'male','L2Monster',40,'80.00000','63.00000','2.00000','0.90000',40,43,30,21,20,20,178,5,'12.00000','49.00000','5.00000','30.00000',230,1,0,333,4,0,0,40,110,1,1,1,1),
(20004,20004,'Imp',0,'',0,'LineageMonster.imp','10.00','24.00',6,'male','L2Monster',40,'94.00000','70.00000','2.00000','0.90000',40,43,30,21,20,20,214,6,'13.00000','51.00000','6.00000','31.00000',230,4,0,333,0,0,0,60,80,1,1,1,1),
(20005,20005,'Imp Elder',0,'',0,'LineageMonster.imp','10.00','24.00',7,'male','L2Monster',40,'108.00000','77.00000','2.00000','0.90000',40,43,30,21,20,20,249,8,'14.00000','53.00000','6.00000','32.00000',230,4,0,333,0,0,0,60,80,1,1,1,1),
(20006,20006,'Orc Archer',0,'',0,'LineageMonster.orc_archer','14.00','25.00',8,'male','L2Monster',1100,'125.00000','84.00000','2.00000','0.90000',40,43,30,21,20,20,293,10,'16.00000','56.00000','12.00000','34.00000',230,8,0,333,14,0,0,45,110,1,1,1,1),
(20007,20007,'Green Fungus',0,'',0,'LineageMonster.walking_fungus','15.00','22.50',9,'male','L2Monster',40,'143.00000','92.00000','2.00000','0.90000',40,43,30,21,20,20,321,11,'18.00000','58.00000','14.00000','35.00000',230,4,0,333,0,0,0,70,110,1,1,1,1),
(20008,20008,'Felim Lizardman',0,'',0,'LineageMonster.virud_lizardman','10.00','23.00',14,'male','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,499,19,'28.00000','73.00000','16.00000','44.00000',230,4,0,333,1,0,0,43,130,1,1,1,1),
(20009,20009,'Vuku Orc',0,'',0,'LineageMonster.orc','10.00','21.00',14,'male','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,499,19,'28.00000','73.00000','16.00000','44.00000',230,1,0,333,156,0,0,45,110,1,1,1,1),
(20010,20010,'Felim Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman','10.00','23.00',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,534,22,'31.00000','76.00000','23.00000','47.00000',230,4,0,333,16,0,0,43,130,1,1,1,1),
(20011,20011,'Vuku Orc Archer',0,'',0,'LineageMonster.orc_archer','14.00','25.00',15,'male','L2Monster',1100,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,551,22,'31.00000','76.00000','23.00000','47.00000',230,8,0,333,14,0,0,45,110,1,1,1,1),
(20012,20012,'Gora Werewolf',0,'',0,'LineageMonster.werewolf','10.00','26.00',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,582,23,'33.00000','80.00000','20.00000','48.00000',230,1,500,333,0,0,0,50,120,1,1,1,1),
(20013,20013,'Dryad',0,'',0,'LineageMonster.dryad','9.00','20.00',13,'female','L2Monster',40,'215.00000','120.00000','2.50000','1.20000',40,43,30,21,20,20,463,18,'25.00000','70.00000','15.00000','43.00000',230,4,0,333,0,0,0,40,110,1,1,1,1),
(20014,20014,'Felim Lizardman Warrior',0,'',0,'LineageMonster.virud_lizardman_warrior','12.00','30.00',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,606,25,'37.00000','83.00000','27.00000','51.00000',230,4,0,333,16,0,0,52,130,1,1,1,1),
(20015,20015,'Marsh Zombie',0,'',0,'LineageMonster.zombie','13.00','21.00',13,'male','L2Monster',40,'215.00000','120.00000','2.50000','1.20000',40,43,30,21,20,20,655,26,'25.00000','70.00000','15.00000','43.00000',230,4,0,333,0,0,0,15,15,1,1,1,1),
(20016,20016,'Stone Golem',0,'',0,'LineageMonster.stone_golem','20.00','31.00',13,'male','L2Monster',40,'215.00000','120.00000','2.50000','1.20000',40,43,30,21,20,20,655,26,'25.00000','70.00000','15.00000','43.00000',230,4,0,333,0,0,0,23,23,1,1,1,1),
(20017,20017,'Vuku Orc Fighter',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,618,26,'37.00000','83.00000','27.00000','51.00000',230,4,500,333,2,0,0,45,110,1,1,1,1),
(20018,20018,'Carnivorous Fungus',0,'',0,'LineageMonster.walking_fungus','15.00','22.50',14,'male','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,424,16,'28.00000','73.00000','16.00000','44.00000',230,4,500,333,0,0,0,70,110,1,1,0,1),
(20019,20019,'Dryad Elder',0,'',0,'LineageMonster.dryad','9.00','20.00',14,'female','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,499,19,'28.00000','73.00000','16.00000','44.00000',230,4,0,333,0,0,0,40,110,1,1,1,1),
(20020,20020,'Marsh Zombie Lord',0,'',0,'LineageMonster.zombie','13.00','21.00',14,'male','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,705,27,'28.00000','73.00000','16.00000','44.00000',230,4,0,333,0,0,0,15,15,1,1,1,1),
(20021,20021,'Red Bear',0,'',0,'LineageMonster.grizzly','21.00','40.00',14,'male','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,499,19,'28.00000','73.00000','16.00000','44.00000',230,4,0,333,0,0,0,40,110,1,1,1,1),
(20022,20022,'Misery Skeleton',0,'',0,'LineageMonster.skeleton','11.00','25.00',14,'male','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,424,16,'28.00000','73.00000','16.00000','44.00000',230,8,500,333,946,945,0,60,140,1,1,0,1),
(20023,20023,'Shadow Beast',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,534,22,'31.00000','76.00000','23.00000','47.00000',230,4,0,333,0,0,0,30,120,1,1,1,1),
(20024,20024,'Langk Lizardman Warrior',0,'',0,'LineageMonster.virud_lizardman_warrior','12.00','30.00',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,618,26,'37.00000','83.00000','27.00000','51.00000',230,4,500,333,16,0,0,52,130,1,1,1,1),
(20025,20025,'Lesser Dark Horror',0,'',0,'LineageMonster.dark_horror','20.00','35.00',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,545,22,'31.00000','76.00000','23.00000','47.00000',230,4,500,333,0,0,0,100,100,1,1,1,1),
(20026,20026,'Ruin Zombie',0,'',0,'LineageMonster.zombie','13.00','21.00',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,756,31,'31.00000','76.00000','23.00000','47.00000',230,4,0,333,0,0,0,15,15,1,1,1,1),
(20027,20027,'Langk Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman','10.00','23.00',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,571,23,'33.00000','80.00000','20.00000','48.00000',230,4,0,333,16,0,0,43,130,1,1,1,1),
(20028,20028,'Pincher',0,'',0,'LineageMonster.giant_spider','26.00','25.50',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,571,23,'33.00000','80.00000','20.00000','48.00000',230,4,0,333,0,0,0,72,130,1,1,1,1),
(20029,20029,'Ruin Zombie Leader',0,'',0,'LineageMonster.zombie','13.00','21.00',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,807,33,'33.00000','80.00000','20.00000','48.00000',230,4,0,333,0,0,0,15,15,1,1,1,1),
(20030,20030,'Langk Lizardman',0,'',0,'LineageMonster.virud_lizardman','10.00','23.00',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,534,22,'31.00000','76.00000','23.00000','47.00000',230,4,0,333,1,0,0,43,130,1,1,1,1),
(20031,20031,'Omen Beast',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,505,21,'37.00000','83.00000','27.00000','51.00000',230,4,0,333,0,0,0,30,120,1,1,0,1),
(20032,20032,'Pinrul',0,'',0,'LineageMonster.giant_spider','26.00','25.50',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,606,25,'37.00000','83.00000','27.00000','51.00000',230,4,0,333,0,0,0,72,130,1,1,1,1),
(20033,20033,'Shade Horror',0,'',0,'LineageMonster.dark_horror','20.00','35.00',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,505,21,'37.00000','83.00000','27.00000','51.00000',230,4,0,333,0,0,0,100,100,1,1,0,1),
(20034,20034,'Prowler',0,'',0,'LineageMonster.giant_spider','26.00','25.50',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,618,26,'37.00000','83.00000','27.00000','51.00000',230,4,500,333,0,0,0,72,130,1,1,1,1),
(20035,20035,'Tracker Skeleton',0,'',0,'LineageMonster.skeleton','11.00','25.00',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,606,25,'37.00000','83.00000','27.00000','51.00000',230,8,0,333,946,945,0,60,140,1,1,1,1),
(20036,20036,'Lirein',0,'',0,'LineageMonster.sylph','11.00','35.00',18,'female','L2Monster',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,653,28,'40.00000','87.00000','25.00000','52.00000',230,4,500,333,0,0,0,60,60,1,1,1,1),
(20037,20037,'Mana Seeker',0,'',0,'LineageMonster.mana_vampire','11.00','20.00',18,'male','L2Monster',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,992,43,'40.00000','87.00000','25.00000','52.00000',230,1,0,333,0,0,0,90,90,1,1,0,1),
(20038,20038,'Venomous Spider',0,'',0,'LineageMonster.poison_spider','27.00','25.50',18,'male','L2Monster',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,704,31,'40.00000','87.00000','25.00000','52.00000',230,4,0,333,0,0,0,60,140,1,1,1,1),
(20039,20039,'Scavenger Wererat',0,'',0,'LineageMonster.wererat','14.00','25.00',18,'male','L2Monster',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,640,28,'40.00000','87.00000','25.00000','52.00000',230,8,0,333,12,0,0,80,120,1,1,1,1),
(20040,20040,'Sukar Wererat',0,'',0,'LineageMonster.wererat','14.00','25.00',18,'male','L2Monster',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,533,23,'40.00000','87.00000','25.00000','52.00000',230,8,0,333,216,0,0,80,120,1,1,0,1),
(20041,20041,'Tainted Zombie',0,'',0,'LineageMonster.zombie','13.00','21.00',18,'male','L2Monster',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,754,33,'40.00000','87.00000','25.00000','52.00000',230,4,0,333,0,0,0,15,15,1,1,0,1),
(20042,20042,'Tracker Skeleton Leader',0,'',0,'LineageMonster.skeleton','11.00','25.00',18,'male','L2Monster',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,653,28,'40.00000','87.00000','25.00000','52.00000',230,8,500,333,946,945,0,60,140,1,1,1,1),
(20043,20043,'Arachnid Tracker',0,'',0,'LineageMonster.poison_spider','27.00','25.50',19,'male','L2Monster',40,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,761,34,'44.00000','91.00000','32.00000','55.00000',230,4,500,333,0,0,0,60,140,1,1,1,1),
(20044,20044,'Lirein Elder',0,'',0,'LineageMonster.sylph','11.00','35.00',19,'female','L2Monster',40,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,692,31,'44.00000','91.00000','32.00000','55.00000',230,4,500,333,0,0,0,60,60,1,1,1,1),
(20045,20045,'Skeleton Scout',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',19,'male','L2Monster',1100,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,699,31,'44.00000','91.00000','32.00000','55.00000',230,8,0,333,275,0,0,40,140,1,1,1,1),
(20046,20046,'Stink Zombie',0,'',0,'LineageMonster.zombie','13.00','21.00',19,'male','L2Monster',40,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,799,36,'44.00000','91.00000','32.00000','55.00000',230,4,0,333,0,0,0,15,15,1,1,0,1),
(20047,20047,'Sukar Wererat Leader',0,'',0,'LineageMonster.wererat','14.00','25.00',19,'male','L2Monster',40,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,576,26,'44.00000','91.00000','32.00000','55.00000',230,8,500,333,216,0,0,80,120,1,1,0,1),
(20048,20048,'Lesser Succubus',0,'',0,'LineageMonster.succubus','10.00','36.00',20,'female','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,606,27,'48.00000','95.00000','30.00000','57.00000',230,4,500,333,0,0,0,60,100,1,1,0,1),
(20049,20049,'Lycanthrope',0,'',0,'LineageMonster.werewolf','10.00','26.00',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,727,32,'48.00000','95.00000','30.00000','57.00000',230,1,500,333,0,0,0,50,120,1,1,1,1),
(20050,20050,'Arachnid Predator',0,'',0,'LineageMonster.poison_spider','27.00','25.50',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,800,35,'48.00000','95.00000','30.00000','57.00000',230,4,500,333,0,0,0,60,140,1,1,1,1),
(20051,20051,'Skeleton Bowman',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',20,'male','L2Monster',1100,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,734,32,'48.00000','95.00000','30.00000','57.00000',230,8,0,333,275,0,0,40,140,1,1,1,1),
(20052,20052,'Lesser Succubus Turen',0,'',0,'LineageMonster.succubus','10.00','36.00',21,'female','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,780,36,'53.00000','99.00000','38.00000','60.00000',230,4,500,333,0,0,0,60,100,1,1,0,1),
(20053,20053,'Ol Mahum Patrol',0,'',0,'LineageMonster.ol_mahum_archer','14.00','25.00',21,'male','L2Monster',1100,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,945,43,'53.00000','99.00000','38.00000','60.00000',230,8,0,333,14,0,0,50,110,1,1,1,1),
(20054,20054,'Ruin Spartoi',0,'',0,'LineageMonster.spartoi','11.00','27.00',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,917,42,'53.00000','99.00000','38.00000','60.00000',230,4,0,333,73,0,0,60,140,1,1,1,1),
(20055,20055,'Wandering Eye',0,'',0,'LineageMonster.monster_eye','21.00','43.00',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,917,42,'53.00000','99.00000','38.00000','60.00000',230,4,0,333,0,0,0,90,159,1,1,1,1),
(20056,20056,'Dre Vanul Disposer',0,'',0,'LineageMonster.dre_vanul','14.00','36.00',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,921,43,'57.00000','103.00000','36.00000','62.00000',230,1,500,333,0,0,0,80,80,1,1,0,1),
(20057,20057,'Lesser Succubus Tilfo',0,'',0,'LineageMonster.succubus','10.00','36.00',22,'female','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,838,40,'57.00000','103.00000','36.00000','62.00000',230,4,500,333,0,0,0,60,100,1,1,0,1),
(20058,20058,'Ol Mahum Guard',0,'',0,'LineageMonster.ol_mahum','13.50','25.00',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,986,47,'57.00000','103.00000','36.00000','62.00000',230,4,0,333,2,0,0,50,110,1,1,1,1),
(20059,20059,'Hungry Eye',0,'',0,'LineageMonster.monster_eye','21.00','43.00',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,986,47,'57.00000','103.00000','36.00000','62.00000',230,4,0,333,0,0,0,90,159,1,1,1,1),
(20060,20060,'Raging Spartoi',0,'',0,'LineageMonster.spartoi','11.00','27.00',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,1005,48,'57.00000','103.00000','36.00000','62.00000',230,8,500,333,946,945,0,60,140,1,1,1,1),
(20061,20061,'Ol Mahum Straggler',0,'',0,'LineageMonster.ol_mahum','13.50','25.00',23,'male','L2Monster',40,'411.00000','211.00000','3.50000','1.50000',40,43,30,21,20,20,1075,52,'62.00000','107.00000','40.00000','65.00000',230,4,500,333,2,0,0,50,110,1,1,1,1),
(20062,20062,'Tumran Bugbear',0,'',0,'LineageMonster.bugbear','17.00','35.00',23,'male','L2Monster',40,'411.00000','211.00000','3.50000','1.50000',40,43,30,21,20,20,1054,50,'62.00000','107.00000','40.00000','65.00000',230,1,0,333,156,0,0,55,130,1,1,1,1),
(20063,20063,'Ol Mahum Shooter',0,'',0,'LineageMonster.ol_mahum_archer','14.00','25.00',24,'male','L2Monster',1100,'435.00000','224.00000','3.50000','1.50000',40,43,30,21,20,20,1156,56,'68.00000','112.00000','48.00000','67.00000',230,8,0,333,14,0,0,50,110,1,1,1,1),
(20064,20064,'Tumran Bugbear Warrior',0,'',0,'LineageMonster.bugbear','17.00','35.00',24,'male','L2Monster',40,'435.00000','224.00000','3.50000','1.50000',40,43,30,21,20,20,1145,56,'68.00000','112.00000','48.00000','67.00000',230,1,500,333,88,0,0,55,130,1,1,1,1),
(20065,20065,'Ol Mahum Patrolman',0,'',0,'LineageMonster.ol_mahum','13.50','25.00',25,'male','L2Monster',40,'461.00000','236.00000','3.50000','1.50000',40,43,30,21,20,20,992,49,'73.00000','116.00000','52.00000','70.00000',230,4,0,333,2,0,0,50,110,1,1,0,1),
(20066,20066,'Ol Mahum Captain',0,'',0,'LineageMonster.ol_mahum_champion','14.00','27.00',25,'male','L2Monster',40,'461.00000','236.00000','3.50000','1.50000',40,43,30,21,20,20,1263,64,'73.00000','116.00000','52.00000','70.00000',230,4,500,333,69,0,0,50,110,1,1,1,1),
(20067,20067,'Monster Eye Watcher',0,'',0,'LineageMonster.monster_eye','21.00','43.00',25,'male','L2Monster',40,'461.00000','236.00000','3.50000','1.50000',40,43,30,21,20,20,1191,60,'73.00000','116.00000','52.00000','70.00000',230,4,0,333,0,0,0,90,159,1,1,1,1),
(20068,20068,'Monster Eye Destroyer',0,'',0,'LineageMonster.monster_eye','21.00','43.00',26,'male','L2Monster',40,'487.00000','248.00000','3.50000','1.50000',40,43,30,21,20,20,1294,65,'79.00000','121.00000','57.00000','73.00000',230,4,500,333,0,0,0,90,159,1,1,1,1),
(20069,20069,'Selu Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman','10.00','23.00',26,'male','L2Monster',40,'487.00000','248.00000','3.50000','1.50000',40,43,30,21,20,20,1057,53,'79.00000','121.00000','57.00000','73.00000',230,4,0,333,16,0,0,43,130,1,1,0,1),
(20070,20070,'Lesser Basilisk',0,'',0,'LineageMonster.lesser_basilisk','34.00','25.00',27,'male','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,1349,70,'87.00000','126.00000','62.00000','76.00000',230,4,500,333,0,0,0,35,131,1,1,1,1),
(20071,20071,'Selu Lizardman Warrior',0,'',0,'LineageMonster.virud_lizardman_warrior','12.00','30.00',27,'male','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,1136,58,'87.00000','126.00000','62.00000','76.00000',230,4,500,333,16,0,0,52,130,1,1,0,1),
(20072,20072,'Basilisk',0,'',0,'LineageMonster.lesser_basilisk','34.00','25.00',28,'male','L2Monster',40,'544.00000','274.00000','3.50000','1.50000',40,43,30,21,20,20,1428,74,'93.00000','131.00000','67.00000','80.00000',230,4,500,333,0,0,0,35,131,1,1,1,1),
(20073,20073,'Ol Mahum Legionnaire',0,'',0,'LineageMonster.ol_mahum','13.50','25.00',28,'male','L2Monster',40,'544.00000','274.00000','3.50000','1.50000',40,43,30,21,20,20,1178,62,'93.00000','131.00000','67.00000','80.00000',230,4,0,333,2,0,0,50,110,1,1,0,1),
(20074,20074,'Androscorpio',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',29,'male','L2Monster',40,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,1492,80,'101.00000','136.00000','72.00000','82.00000',230,4,0,333,0,0,0,30,120,1,1,1,1),
(20075,20075,'Ant Larva',0,'',0,'LineageMonster.ant_larva','12.00','8.00',29,'male','L2Monster',40,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,1368,73,'101.00000','136.00000','72.00000','82.00000',230,4,0,333,0,0,0,40,60,1,1,0,1),
(20076,20076,'Ol Mahum Commander',0,'',0,'LineageMonster.ol_mahum_champion','14.00','27.00',29,'male','L2Monster',40,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,1583,85,'101.00000','136.00000','72.00000','82.00000',230,4,500,333,69,0,0,50,110,1,1,1,1),
(20077,20077,'Androscorpio Hunter',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,1571,86,'109.00000','141.00000','77.00000','85.00000',230,4,0,333,0,0,0,30,120,1,1,1,1),
(20078,20078,'Whispering Wind',0,'',0,'LineageMonster.sylph_100_bi','20.00','70.00',30,'female','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,1571,86,'109.00000','141.00000','77.00000','85.00000',230,4,0,333,0,0,0,60,60,1,1,1,1),
(20079,20079,'Ant',0,'',0,'LineageMonster.ant','26.00','15.00',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,1571,86,'109.00000','141.00000','77.00000','85.00000',230,4,0,333,0,0,0,40,130,1,1,0,1),
(20080,20080,'Ant Captain',0,'',0,'LineageMonster.ant','26.00','15.00',31,'male','L2Monster',40,'636.00000','313.00000','4.50000','1.80000',40,43,30,21,20,20,1711,95,'118.00000','146.00000','83.00000','89.00000',230,4,500,333,0,0,0,40,130,1,1,0,1),
(20081,20081,'Ant Overseer',0,'',0,'LineageMonster.ant','26.00','15.00',32,'male','L2Monster',40,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,2881,162,'128.00000','152.00000','85.00000','92.00000',230,4,0,333,0,0,0,40,130,1,1,0,1),
(20082,20082,'Ant Recruit',0,'',0,'LineageMonster.ant_soldier','35.00','17.00',33,'male','L2Monster',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,1742,100,'138.00000','158.00000','96.00000','96.00000',230,4,0,333,0,0,0,80,130,1,1,0,1),
(20083,20083,'Granite Golem',0,'',0,'LineageMonster.stone_golem','20.00','31.00',33,'male','L2Monster',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,2687,155,'138.00000','158.00000','96.00000','96.00000',230,4,0,333,0,0,0,23,23,1,1,1,1),
(20084,20084,'Ant Patrol',0,'',0,'LineageMonster.ant_soldier','35.00','17.00',34,'male','L2Monster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,2001,116,'148.00000','164.00000','99.00000','99.00000',230,4,0,333,0,0,0,80,130,1,1,0,1),
(20085,20085,'Puncher',0,'',0,'LineageMonster.stone_golem','20.00','31.00',34,'male','L2Monster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,2910,170,'148.00000','164.00000','99.00000','99.00000',230,4,500,333,0,0,0,23,23,1,1,1,1),
(20086,20086,'Ant Guard',0,'',0,'LineageMonster.ant_soldier','35.00','17.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,1782,106,'159.00000','170.00000','111.00000','102.00000',230,4,0,333,0,0,0,80,174,1,1,0,1),
(20087,20087,'Ant Soldier',0,'',0,'LineageMonster.ant_soldier','35.00','17.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,4274,253,'159.00000','170.00000','111.00000','102.00000',230,4,500,333,0,0,0,80,174,1,1,0,1),
(20088,20088,'Ant Warrior Captain',0,'',0,'LineageMonster.ant_soldier','35.00','17.00',36,'male','L2Monster',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,4763,288,'171.00000','176.00000','115.00000','107.00000',230,4,500,333,0,0,0,80,174,1,1,0,1),
(20089,20089,'Noble Ant',0,'',0,'LineageMonster.noble_ant','20.00','48.00',37,'male','L2Monster',40,'847.00000','393.00000','4.50000','1.80000',40,43,30,21,20,20,1991,122,'183.00000','182.00000','123.00000','111.00000',230,4,0,333,0,0,0,80,174,1,1,0,1),
(20090,20090,'Noble Ant Leader',0,'',0,'LineageMonster.noble_ant','20.00','48.00',38,'male','L2Monster',40,'886.00000','407.00000','4.50000','1.80000',40,43,30,21,20,20,4391,274,'197.00000','189.00000','137.00000','114.00000',230,4,500,333,0,0,0,80,174,1,1,0,1),
(20091,20091,'Young Fox',0,'',0,'LineageMonster.fox','9.50','10.00',1,'male','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,29,2,'8.00000','40.00000','7.00000','25.00000',230,4,0,333,0,0,0,23,110,1,1,0,1),
(20092,20092,'Monster Eye',0,'',0,'LineageMonster.monster_eye','21.00','43.00',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,294,10,'19.00000','61.00000','10.00000','37.00000',230,1,0,333,0,0,0,90,134,1,1,0,1),
(20093,20093,'Orc Fighter',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,363,12,'19.00000','61.00000','10.00000','37.00000',230,4,500,333,1,0,0,45,110,1,1,1,1),
(20094,20094,'Orc Marksman',0,'',0,'LineageMonster.orc_archer','14.00','25.00',10,'male','L2Monster',1100,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,306,10,'19.00000','61.00000','10.00000','37.00000',230,8,0,333,14,0,0,45,110,1,1,0,1),
(20095,20095,'Vampire Bat',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,297,10,'19.00000','61.00000','10.00000','37.00000',230,1,0,333,0,0,0,60,80,1,1,0,1),
(20096,20096,'Orc Lieutenant',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',11,'male','L2Monster',40,'185.00000','106.00000','2.50000','1.20000',40,43,30,21,20,20,392,15,'21.00000','64.00000','11.00000','39.00000',230,4,0,333,2,0,0,45,110,1,1,1,1),
(20097,20097,'Drill Bat',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',11,'male','L2Monster',40,'185.00000','106.00000','2.50000','1.20000',40,43,30,21,20,20,326,12,'21.00000','64.00000','11.00000','39.00000',230,1,0,333,0,0,0,60,80,1,1,0,1),
(20098,20098,'Orc Fighter Leader',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',12,'male','L2Monster',40,'199.00000','113.00000','2.50000','1.20000',40,43,30,21,20,20,448,17,'23.00000','67.00000','17.00000','41.00000',230,4,500,333,2,0,0,45,110,1,1,1,1),
(20099,20099,'Skeleton',0,'',0,'LineageMonster.skeleton','11.00','25.00',12,'male','L2Monster',40,'199.00000','113.00000','2.50000','1.20000',40,43,30,21,20,20,363,13,'23.00000','67.00000','17.00000','41.00000',230,8,500,333,946,945,0,60,140,1,1,0,1),
(20100,20100,'Skeleton Archer',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',13,'male','L2Monster',1100,'215.00000','120.00000','2.50000','1.20000',40,43,30,21,20,20,405,16,'25.00000','70.00000','15.00000','43.00000',230,8,500,333,14,0,0,40,140,1,1,0,1),
(20101,20101,'Crasher',0,'',0,'LineageMonster.stone_golem','20.00','31.00',14,'male','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,705,27,'28.00000','73.00000','16.00000','44.00000',230,4,0,333,0,0,0,23,23,1,1,1,1),
(20102,20102,'Skeleton Marksman',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',14,'male','L2Monster',1100,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,428,17,'28.00000','73.00000','16.00000','44.00000',230,8,0,333,14,0,0,40,140,1,1,0,1),
(20103,20103,'Giant Spider',0,'',0,'LineageMonster.giant_spider','26.00','25.50',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,545,22,'31.00000','76.00000','23.00000','47.00000',230,4,500,333,0,0,0,72,130,1,1,1,1),
(20104,20104,'Skeleton Lord',0,'',0,'LineageMonster.skeleton','11.00','25.00',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,445,18,'31.00000','76.00000','23.00000','47.00000',230,8,0,333,946,945,0,60,140,1,1,0,1),
(20105,20105,'Dark Horror',0,'',0,'LineageMonster.dark_horror','20.00','35.00',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,577,23,'33.00000','80.00000','20.00000','48.00000',230,4,500,333,0,0,0,100,100,1,1,1,1),
(20106,20106,'Talon Spider',0,'',0,'LineageMonster.giant_spider','26.00','25.50',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,571,23,'33.00000','80.00000','20.00000','48.00000',230,4,0,333,0,0,0,72,130,1,1,1,1),
(20107,20107,'Wererat',0,'',0,'LineageMonster.wererat','14.00','25.00',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,476,19,'33.00000','80.00000','20.00000','48.00000',230,1,0,333,0,0,0,80,120,1,1,0,1),
(20108,20108,'Blade Spider',0,'',0,'LineageMonster.giant_spider','26.00','25.50',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,618,26,'37.00000','83.00000','27.00000','51.00000',230,4,500,333,0,0,0,72,130,1,1,1,1),
(20109,20109,'Salamander',0,'',0,'LineageMonster.salamander','16.00','6.80',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,990,42,'37.00000','83.00000','27.00000','51.00000',230,1,0,333,0,0,0,64,96,1,1,0,1),
(20110,20110,'Undine',0,'',0,'LineageMonster.undine','12.00','27.00',17,'female','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,958,40,'37.00000','83.00000','27.00000','51.00000',230,1,500,333,0,0,0,60,60,1,1,0,1),
(20111,20111,'Wererat Leader',0,'',0,'LineageMonster.wererat','14.00','25.00',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,958,40,'37.00000','83.00000','27.00000','51.00000',230,4,500,333,1,0,0,80,120,1,1,0,1),
(20112,20112,'Salamander Elder',0,'',0,'LineageMonster.salamander','16.00','6.80',18,'male','L2Monster',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,992,43,'40.00000','87.00000','25.00000','52.00000',230,1,0,333,0,0,0,64,96,1,1,0,1),
(20113,20113,'Undine Elder',0,'',0,'LineageMonster.undine','12.00','27.00',18,'female','L2Monster',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,1012,44,'40.00000','87.00000','25.00000','52.00000',230,1,500,333,0,0,0,60,60,1,1,0,1),
(20114,20114,'Salamander Noble',0,'',0,'LineageMonster.salamander','16.00','6.80',19,'male','L2Monster',40,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,1051,47,'44.00000','91.00000','32.00000','55.00000',230,1,0,333,0,0,0,64,96,1,1,0,1),
(20115,20115,'Undine Noble',0,'',0,'LineageMonster.undine','12.00','27.00',19,'female','L2Monster',40,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,1072,48,'44.00000','91.00000','32.00000','55.00000',230,1,500,333,0,0,0,60,60,1,1,0,1),
(20116,20116,'Fox',0,'',0,'LineageMonster.fox','9.50','10.00',2,'male','L2Monster',40,'48.00000','43.00000','2.00000','0.90000',40,43,30,21,20,20,59,2,'8.00000','42.00000','7.00000','25.00000',230,4,0,333,0,0,0,23,110,1,1,0,1),
(20117,20117,'Dre Vanul',0,'',0,'LineageMonster.dre_vanul','14.00','36.00',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,666,29,'48.00000','95.00000','30.00000','57.00000',230,1,500,333,0,0,0,80,80,1,1,0,1),
(20118,20118,'Dre Vanul Scout',0,'',0,'LineageMonster.dre_vanul','14.00','36.00',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,780,36,'53.00000','99.00000','38.00000','60.00000',230,1,0,333,0,0,0,80,80,1,1,0,1),
(20119,20119,'Elder Fox',0,'',0,'LineageMonster.fox','9.50','10.00',3,'male','L2Monster',40,'58.00000','50.00000','2.00000','0.90000',40,43,30,21,20,20,88,2,'9.00000','44.00000','9.00000','27.00000',230,4,0,333,0,0,0,23,110,1,1,0,1),
(20120,20120,'Wolf',0,'',0,'LineageMonster.wolf','13.00','9.00',4,'male','L2Monster',40,'68.00000','57.00000','2.00000','0.90000',40,43,30,21,20,20,141,4,'10.00000','46.00000','9.00000','28.00000',230,4,0,333,0,0,0,24,110,1,1,1,1),
(20121,20121,'Giant Toad',0,'',0,'LineageMonster.poison_toad','20.00','10.00',5,'male','L2Monster',40,'80.00000','63.00000','2.00000','0.90000',40,43,30,21,20,20,178,5,'12.00000','49.00000','5.00000','30.00000',230,4,0,333,0,0,0,50,100,1,1,1,1),
(20130,20130,'Orc',0,'',0,'LineageMonster.orc','10.00','21.00',6,'male','L2Monster',40,'94.00000','70.00000','2.00000','0.90000',40,43,30,21,20,20,214,6,'13.00000','51.00000','6.00000','31.00000',230,1,0,333,156,0,0,45,110,1,1,1,1),
(20131,20131,'Orc Grunt',0,'',0,'LineageMonster.orc','10.00','21.00',7,'male','L2Monster',40,'108.00000','77.00000','2.00000','0.90000',40,43,30,21,20,20,249,8,'14.00000','53.00000','6.00000','32.00000',230,1,0,333,4,0,0,45,110,1,1,1,1),
(20132,20132,'Werewolf',0,'',0,'LineageMonster.werewolf','10.00','26.00',9,'male','L2Monster',40,'143.00000','92.00000','2.00000','0.90000',40,43,30,21,20,20,321,11,'18.00000','58.00000','14.00000','35.00000',230,1,0,333,0,0,0,50,120,1,1,1,1),
(20133,20133,'Bugbear',0,'',0,'LineageMonster.bugbear','17.00','35.00',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,780,36,'53.00000','99.00000','38.00000','60.00000',230,1,500,333,4,0,0,55,130,1,1,0,1),
(20134,20134,'Cave Maiden',0,'',0,'LineageMonster.cave_maiden','25.00','65.00',59,'female','L2Monster',40,'1881.00000','916.00000','6.50000','2.40000',40,43,30,21,20,20,6135,524,'678.00000','359.00000','464.00000','218.00000',230,4,500,333,68,0,0,70,174,1,1,0,1),
(20135,20135,'Alligator',0,'',0,'LineageMonster.crocodile','28.00','11.50',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,2848,184,'226.00000','202.00000','157.00000','122.00000',230,4,500,333,0,0,0,70,174,1,1,1,1),
(20136,20136,'Death Knight',0,'',0,'LineageMonster.death_knight','12.00','30.00',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,14026,1012,'421.00000','278.00000','286.00000','185.00000',230,4,500,333,75,0,0,27,110,1,1,0,1),
(20137,20137,'Drake',0,'',0,'LineageMonster.drake','30.00','100.00',57,'male','L2Monster',40,'1777.00000','862.00000','6.50000','2.40000',40,43,30,21,20,20,5784,481,'614.00000','340.00000','420.00000','207.00000',230,4,500,333,0,0,0,70,174,1,1,0,1),
(20138,20138,'Gargoyle',0,'',0,'LineageMonster.gargoyle','16.00','50.00',27,'male','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,1136,58,'87.00000','126.00000','62.00000','76.00000',230,4,500,333,0,0,0,140,140,1,1,0,1),
(20139,20139,'Giant Bee',0,'',0,'LineageMonster.giant_bee','8.00','24.50',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,471,19,'33.00000','80.00000','20.00000','48.00000',230,4,0,333,0,0,0,90,90,1,1,0,1),
(20140,20140,'Giant Leech',0,'',0,'LineageMonster.giant_leech','70.00','29.00',24,'male','L2Monster',40,'435.00000','224.00000','3.50000','1.50000',40,43,30,21,20,20,954,47,'68.00000','112.00000','48.00000','67.00000',230,4,500,333,0,0,0,50,110,1,1,0,1),
(20141,20141,'Giant Wild Hog',0,'',0,'LineageMonster.giant_wild_hog','25.00','27.00',47,'male','L2Monster',40,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,3277,235,'353.00000','254.00000','244.00000','154.00000',230,4,500,333,0,0,0,35,120,1,1,0,1),
(20142,20142,'Griffon',0,'',0,'LineageMonster.griffin','20.00','44.00',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,594,26,'48.00000','95.00000','30.00000','57.00000',230,4,0,333,0,0,0,90,90,1,1,0,1),
(20143,20143,'Grizzly',0,'',0,'LineageMonster.grizzly','21.00','40.00',12,'male','L2Monster',40,'199.00000','113.00000','2.50000','1.20000',40,43,30,21,20,20,436,16,'23.00000','67.00000','17.00000','41.00000',230,4,500,333,0,0,0,40,110,1,1,1,1),
(20144,20144,'Hangman Tree',0,'',0,'LineageMonster.hanged_man_ripper','35.00','80.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,2181,130,'159.00000','170.00000','111.00000','102.00000',230,4,500,333,0,0,0,55,174,1,1,1,1),
(20145,20145,'Harpy',0,'',0,'LineageMonster.harpy','10.00','42.00',32,'female','L2Monster',40,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,1805,101,'128.00000','152.00000','85.00000','92.00000',230,4,500,333,0,0,0,60,100,1,1,1,1),
(20146,20146,'Headless Knight',0,'',0,'LineageMonster.headless_knight','21.00','31.00',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,4450,335,'421.00000','278.00000','286.00000','169.00000',230,4,500,333,124,0,0,70,174,1,1,0,1),
(20147,20147,'Hobgoblin',0,'',0,'LineageMonster.hobgoblin','12.00','24.00',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,917,42,'53.00000','99.00000','38.00000','60.00000',230,1,0,333,4,0,0,45,110,1,1,1,1),
(20148,20148,'Hungry Spirit',0,'',0,'LineageMonster.hungry_spirit','13.00','40.00',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,2350,151,'226.00000','202.00000','157.00000','122.00000',230,4,500,333,0,0,0,15,120,1,1,0,1),
(20149,20149,'Iron Golem',0,'',0,'LineageMonster.iron_golem','18.00','34.00',38,'male','L2Monster',40,'886.00000','407.00000','4.50000','1.80000',40,43,30,21,20,20,3029,188,'197.00000','189.00000','137.00000','114.00000',230,4,500,333,0,0,0,20,20,1,1,0,1),
(20150,20150,'King Bugbear',0,'',0,'LineageMonster.king_bugbear','15.00','40.00',32,'male','L2Monster',40,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,1519,85,'128.00000','152.00000','85.00000','92.00000',230,1,500,333,88,0,0,55,130,1,1,0,1),
(20151,20151,'Kobold',0,'',0,'LineageMonster.kobold','10.00','15.00',4,'male','L2Monster',40,'68.00000','57.00000','2.00000','0.90000',40,43,30,21,20,20,119,3,'10.00000','46.00000','9.00000','28.00000',230,1,0,333,4,0,0,47,110,1,1,0,1),
(20152,20152,'Lizardman',0,'',0,'LineageMonster.virud_lizardman','10.00','23.00',19,'male','L2Monster',40,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,565,25,'44.00000','91.00000','32.00000','55.00000',230,4,0,333,291,0,0,43,130,1,1,0,1),
(20153,20153,'Magical Weaver',0,'',0,'LineageMonster.magical_weaver','11.00','20.00',11,'male','L2Monster',40,'185.00000','106.00000','2.50000','1.20000',40,43,30,21,20,20,392,15,'21.00000','64.00000','11.00000','39.00000',230,4,0,333,0,0,0,90,90,1,1,1,1),
(20154,20154,'Mandragora Sprout',0,'',0,'LineageMonster.manadragora','14.00','17.80',21,'female','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,917,42,'53.00000','99.00000','38.00000','60.00000',230,4,0,333,0,0,0,80,80,1,1,1,1),
(20155,20155,'Mandragora Sapling',0,'',0,'LineageMonster.mandragora_a','15.00','26.00',23,'female','L2Monster',40,'411.00000','211.00000','3.50000','1.50000',40,43,30,21,20,20,1075,52,'62.00000','107.00000','40.00000','65.00000',230,4,500,333,0,0,0,80,120,1,1,1,1),
(20156,20156,'Mandragora Blossom',0,'',0,'LineageMonster.mandragora_b','12.00','25.50',25,'female','L2Monster',40,'461.00000','236.00000','3.50000','1.50000',40,43,30,21,20,20,1215,61,'73.00000','116.00000','52.00000','70.00000',230,4,500,333,0,0,0,80,120,1,1,1,1),
(20157,20157,'Marsh Stakato',0,'',0,'LineageMonster.marsh_stakato','10.00','20.00',29,'male','L2Monster',40,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,1811,97,'101.00000','136.00000','72.00000','82.00000',230,8,500,333,223,0,0,21,120,1,1,1,1),
(20158,20158,'Medusa',0,'',0,'LineageMonster.medusa','10.00','25.00',34,'female','L2Monster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,2058,120,'148.00000','164.00000','99.00000','99.00000',230,4,500,333,0,0,0,50,110,1,1,1,1),
(20159,20159,'Minotaur',0,'',0,'LineageMonster.minotaur','21.00','45.50',43,'male','L2Monster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,2716,184,'275.00000','223.00000','191.00000','135.00000',230,1,500,333,300,0,0,40,120,1,1,0,1),
(20160,20160,'Neer Crawler',0,'',0,'LineageMonster.neer_crawler','14.00','22.00',28,'male','L2Monster',40,'544.00000','274.00000','3.50000','1.50000',40,43,30,21,20,20,1442,76,'93.00000','131.00000','67.00000','80.00000',230,4,500,333,0,0,0,50,90,1,1,1,1),
(20161,20161,'Oel Mahum',0,'',0,'LineageMonster.oel_mahum','20.00','37.00',53,'male','L2Monster',40,'1571.00000','757.00000','6.50000','2.40000',40,43,30,21,20,20,4846,380,'498.00000','304.00000','344.00000','202.00000',230,4,500,333,127,0,0,70,110,1,1,1,1),
(20162,20162,'Ogre',0,'',0,'LineageMonster.ogre','21.00','44.00',41,'male','L2Monster',40,'1008.00000','459.00000','5.50000','2.10000',40,43,30,21,20,20,2469,162,'241.00000','209.00000','163.00000','126.00000',230,4,500,333,98,0,0,22,80,1,1,0,1),
(20163,20163,'Ol Mahum',0,'',0,'LineageMonster.ol_mahum','13.50','25.00',23,'male','L2Monster',40,'411.00000','211.00000','3.50000','1.50000',40,43,30,21,20,20,878,42,'62.00000','107.00000','40.00000','65.00000',230,4,0,333,2,0,0,50,110,1,1,0,1),
(20164,20164,'Ol Mahum Archer',0,'',0,'LineageMonster.ol_mahum_archer','14.00','25.00',25,'male','L2Monster',1100,'461.00000','236.00000','3.50000','1.50000',40,43,30,21,20,20,1043,53,'73.00000','116.00000','52.00000','70.00000',230,8,500,333,14,0,0,50,110,1,1,0,1),
(20165,20165,'Ol Mahum Champion',0,'',0,'LineageMonster.ol_mahum_champion','14.00','27.00',29,'male','L2Monster',40,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,1509,80,'101.00000','136.00000','72.00000','82.00000',230,4,500,333,69,0,0,50,110,1,1,0,1),
(20166,20166,'Succubus',0,'',0,'LineageMonster.succubus','10.00','36.00',32,'female','L2Monster',40,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,1519,85,'128.00000','152.00000','85.00000','92.00000',230,4,500,333,0,0,0,60,100,1,1,0,1),
(20167,20167,'Serpent Slave',0,'',0,'LineageMonster.serpent_slave','17.00','46.00',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,2374,154,'226.00000','202.00000','157.00000','122.00000',230,4,500,333,73,0,0,70,110,1,1,0,1),
(20168,20168,'Silenos',0,'',0,'LineageMonster.silenos','14.00','32.50',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,1571,86,'109.00000','141.00000','77.00000','85.00000',230,1,0,333,88,0,0,70,110,1,1,1,1),
(20169,20169,'Skeleton Royal Guard',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',26,'male','L2Monster',40,'487.00000','248.00000','3.50000','1.50000',40,43,30,21,20,20,1078,54,'79.00000','121.00000','57.00000','73.00000',230,8,500,333,946,945,0,80,120,1,1,0,1),
(20170,20170,'Spartoi',0,'',0,'LineageMonster.spartoi','11.00','27.00',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,454,19,'31.00000','76.00000','23.00000','47.00000',230,8,500,333,946,945,0,60,140,1,1,0,1),
(20171,20171,'Specter',0,'',0,'LineageMonster.dark_horror','20.00','35.00',26,'male','L2Monster',40,'487.00000','248.00000','3.50000','1.50000',40,43,30,21,20,20,1294,65,'79.00000','121.00000','57.00000','73.00000',230,4,500,333,0,0,0,100,100,1,1,1,1),
(20172,20172,'Sylph',0,'',0,'LineageMonster.sylph','11.00','35.00',10,'female','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,297,10,'19.00000','61.00000','10.00000','37.00000',230,4,0,333,0,0,0,60,60,1,1,0,1),
(20173,20173,'Troll',0,'',0,'LineageMonster.troll','21.00','35.00',33,'male','L2Monster',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,1600,91,'138.00000','158.00000','96.00000','96.00000',230,1,500,333,0,0,0,55,110,1,1,0,1),
(20174,20174,'Two-Headed Giant',0,'',0,'LineageMonster.twin_headed_giant','17.00','39.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,1799,107,'159.00000','170.00000','111.00000','102.00000',230,1,500,333,4,0,0,45,100,1,1,0,1),
(20175,20175,'Walking Fungus',0,'',0,'LineageMonster.walking_fungus','15.00','22.50',8,'male','L2Monster',40,'125.00000','84.00000','2.00000','0.90000',40,43,30,21,20,20,237,8,'16.00000','56.00000','12.00000','34.00000',230,4,0,333,0,0,0,70,110,1,1,0,1),
(20176,20176,'Wyrm',0,'',0,'LineageMonster.wyrm','29.00','72.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,2181,130,'159.00000','170.00000','111.00000','102.00000',230,4,500,333,0,0,0,70,174,1,1,1,1),
(20177,20177,'Zombie',0,'',0,'LineageMonster.zombie','13.00','21.00',6,'male','L2Monster',40,'94.00000','70.00000','2.00000','0.90000',40,43,30,21,20,20,178,5,'13.00000','51.00000','6.00000','31.00000',230,4,0,333,0,0,0,15,15,1,1,0,1),
(20189,20189,'Puma',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,441,18,'31.00000','76.00000','23.00000','47.00000',230,4,0,333,0,0,0,30,120,1,1,0,1),
(20190,20190,'Skeleton Marauder',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',29,'male','L2Monster',1100,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,1568,84,'101.00000','136.00000','72.00000','82.00000',230,8,500,333,14,0,0,40,140,1,1,1,1),
(20191,20191,'Skeleton Raider',0,'',0,'LineageMonster.skeleton','11.00','25.00',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,1602,88,'109.00000','141.00000','77.00000','85.00000',230,8,500,333,946,945,0,60,140,1,1,1,1),
(20192,20192,'Tyrant',0,'',0,'LineageMonster.grave','15.00','29.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,2138,126,'159.00000','170.00000','111.00000','102.00000',230,4,0,333,0,0,0,70,174,1,1,1,1),
(20193,20193,'Tyrant Kingpin',0,'',0,'LineageMonster.grave','15.00','29.00',36,'male','L2Monster',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,2307,139,'171.00000','176.00000','115.00000','107.00000',230,4,500,333,0,0,0,70,174,1,1,1,1),
(20194,20194,'Queen Undine',0,'',0,'LineageMonster.undine','12.00','27.00',50,'female','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,3709,280,'421.00000','278.00000','286.00000','169.00000',230,4,500,333,0,0,0,60,60,1,1,0,1),
(20197,20197,'Sorrow Maiden',0,'',0,'LineageMonster.sylph','11.00','35.00',27,'female','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,1323,67,'87.00000','126.00000','62.00000','76.00000',230,4,0,333,0,0,0,60,60,1,1,1,1),
(20198,20198,'Neer Ghoul Berserker',0,'',0,'LineageMonster.neer_crawler','14.00','22.00',29,'male','L2Monster',40,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,1522,82,'101.00000','136.00000','72.00000','82.00000',230,4,500,333,0,0,0,50,90,1,1,1,1),
(20199,20199,'Amber Basilisk',0,'',0,'LineageMonster.lesser_basilisk','34.00','25.00',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,1869,102,'109.00000','141.00000','77.00000','85.00000',230,4,0,333,0,0,0,35,131,1,1,1,1),
(20200,20200,'Strain',0,'',0,'LineageMonster.hungry_spirit','13.00','40.00',31,'male','L2Monster',40,'636.00000','313.00000','4.50000','1.80000',40,43,30,21,20,20,1661,92,'118.00000','146.00000','83.00000','89.00000',230,4,0,333,0,0,0,15,120,1,1,1,1),
(20201,20201,'Ghoul',0,'',0,'LineageMonster.zombie','13.00','21.00',32,'male','L2Monster',40,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,2502,140,'128.00000','152.00000','85.00000','92.00000',230,4,0,333,0,0,0,15,15,1,1,1,1),
(20202,20202,'Dead Seeker',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',34,'male','L2Monster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,1998,116,'148.00000','164.00000','99.00000','99.00000',230,4,0,333,0,0,0,60,80,1,1,1,1),
(20203,20203,'Dion Grizzly',0,'',0,'LineageMonster.grizzly','21.00','40.00',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,706,31,'48.00000','95.00000','30.00000','57.00000',230,4,0,333,0,0,0,40,110,1,1,1,1),
(20204,20204,'Bloody Bee',0,'',0,'LineageMonster.giant_bee','8.00','24.50',23,'male','L2Monster',40,'411.00000','211.00000','3.50000','1.50000',40,43,30,21,20,20,1148,55,'62.00000','107.00000','40.00000','65.00000',230,4,0,333,0,0,0,90,90,1,1,1,1),
(20205,20205,'Dire Wolf',0,'',0,'LineageMonster.dire_wolf','13.00','11.00',24,'male','L2Monster',40,'435.00000','224.00000','3.50000','1.50000',40,43,30,21,20,20,1145,56,'68.00000','112.00000','48.00000','67.00000',230,4,500,333,0,0,0,24,110,1,1,1,1),
(20206,20206,'Kadif Werewolf',0,'',0,'LineageMonster.werewolf','10.00','26.00',25,'male','L2Monster',40,'461.00000','236.00000','3.50000','1.50000',40,43,30,21,20,20,1179,59,'73.00000','116.00000','52.00000','70.00000',230,4,0,333,0,0,0,50,120,1,1,1,1),
(20207,20207,'Ol Mahum Guerilla',0,'',0,'LineageMonster.ol_mahum','13.50','25.00',26,'male','L2Monster',40,'487.00000','248.00000','3.50000','1.50000',40,43,30,21,20,20,2359,119,'79.00000','121.00000','57.00000','73.00000',230,4,0,333,2,19,0,50,110,1,1,1,1),
(20208,20208,'Ol Mahum Raider',0,'',0,'LineageMonster.ol_mahum','13.50','25.00',27,'male','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,2485,127,'87.00000','126.00000','62.00000','76.00000',230,8,0,333,10,0,0,50,110,1,1,1,1),
(20209,20209,'Ol Mahum Marksman',0,'',0,'LineageMonster.ol_mahum_archer','14.00','25.00',28,'male','L2Monster',1100,'544.00000','274.00000','3.50000','1.50000',40,43,30,21,20,20,2709,142,'93.00000','131.00000','67.00000','80.00000',230,8,0,333,275,0,0,50,110,1,1,1,1),
(20210,20210,'Ol Mahum Sergeant',0,'',0,'LineageMonster.ol_mahum','13.50','25.00',29,'male','L2Monster',40,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,2776,149,'101.00000','136.00000','72.00000','82.00000',230,4,0,333,68,19,0,50,110,1,1,1,1),
(20211,20211,'Ol Mahum Captain',0,'',0,'LineageMonster.ol_mahum_champion','14.00','27.00',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,2980,163,'109.00000','141.00000','77.00000','85.00000',230,4,500,333,123,19,0,50,110,1,1,1,1),
(20212,20212,'Bloody Axe Turmak',0,'Ol Mahum Lord',0,'LineageMonster.ol_mahum_champion','14.00','27.00',34,'male','L2Monster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,3528,206,'148.00000','164.00000','99.00000','99.00000',230,4,500,333,69,19,0,50,110,1,1,0,1),
(20213,20213,'Porta',0,'',0,'LineageMonster.stone_golem','20.00','31.00',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,10438,647,'226.00000','202.00000','157.00000','134.00000',230,1,0,333,0,0,0,23,23,1,1,0,1),
(20214,20214,'Excuro',0,'',0,'LineageMonster.mana_vampire','11.00','20.00',41,'male','L2Monster',40,'1008.00000','459.00000','5.50000','2.10000',40,43,30,21,20,20,6668,417,'241.00000','209.00000','163.00000','139.00000',230,4,0,333,0,0,0,90,90,1,1,0,1),
(20215,20215,'Mordeo',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',42,'male','L2Monster',40,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,7709,493,'258.00000','216.00000','174.00000','143.00000',230,4,500,333,0,0,0,30,120,1,1,0,1),
(20216,20216,'Ricenseo',0,'',0,'LineageMonster.monster_eye','21.00','43.00',43,'male','L2Monster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,6864,442,'275.00000','223.00000','191.00000','148.00000',230,1,0,333,0,0,0,90,90,1,1,0,1),
(20217,20217,'Krator',0,'',0,'LineageMonster.stone_golem','20.00','31.00',44,'male','L2Monster',40,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,7997,523,'293.00000','231.00000','199.00000','153.00000',230,1,0,333,0,0,0,23,23,1,1,0,1),
(20218,20218,'Premo',0,'',0,'LineageMonster.troll','21.00','35.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,8303,552,'313.00000','238.00000','212.00000','159.00000',230,1,0,333,0,0,0,55,110,1,1,0,1),
(20219,20219,'Validus',0,'',0,'LineageMonster.grave','15.00','29.00',46,'male','L2Monster',40,'1230.00000','580.00000','5.50000','2.10000',40,43,30,21,20,20,9348,635,'332.00000','246.00000','231.00000','164.00000',230,4,0,333,0,0,0,70,110,1,1,0,1),
(20220,20220,'Dicor',0,'',0,'LineageMonster.mandragora_b','12.00','25.50',47,'female','L2Monster',40,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,9429,646,'353.00000','254.00000','244.00000','169.00000',230,4,500,333,0,0,0,80,120,1,1,0,1),
(20221,20221,'Perum',0,'',0,'LineageMonster.iron_golem','18.00','34.00',48,'male','L2Monster',40,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,13708,955,'375.00000','262.00000','260.00000','175.00000',230,1,500,333,0,0,0,20,20,1,1,0,1),
(20222,20222,'Torfe',0,'',0,'LineageMonster.grave','15.00','29.00',49,'male','L2Monster',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,10330,730,'398.00000','270.00000','275.00000','180.00000',230,4,0,333,0,0,0,70,110,1,1,0,1),
(20223,20223,'Mandragora Sprout',0,'',0,'LineageMonster.manadragora','14.00','17.80',20,'female','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,784,35,'48.00000','95.00000','30.00000','57.00000',230,4,0,333,0,0,0,80,80,1,1,1,1),
(20224,20224,'Ol Mahum Ranger',0,'',0,'LineageMonster.ol_mahum_archer','14.00','25.00',22,'male','L2Monster',1100,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,1271,60,'57.00000','103.00000','36.00000','62.00000',230,8,0,333,13,0,0,50,110,1,1,1,1),
(20225,20225,'Giant Mist Leech',0,'',0,'LineageMonster.giant_leech','70.00','29.00',25,'male','L2Monster',40,'461.00000','236.00000','3.50000','1.50000',40,43,30,21,20,20,1191,60,'73.00000','116.00000','52.00000','70.00000',230,4,0,333,0,0,0,50,110,1,1,1,1),
(20226,20226,'Gray Ant',0,'',0,'LineageMonster.ant','26.00','15.00',26,'male','L2Monster',40,'487.00000','248.00000','3.50000','1.50000',40,43,30,21,20,20,1268,64,'79.00000','121.00000','57.00000','73.00000',230,4,0,333,0,0,0,40,130,1,1,1,1),
(20227,20227,'Horror Mist Ripper',0,'',0,'LineageMonster.dark_horror','20.00','35.00',27,'male','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,1349,70,'87.00000','126.00000','62.00000','76.00000',230,4,500,333,0,0,0,100,100,1,1,1,1),
(20228,20228,'Giant Crimson Ant',0,'',0,'LineageMonster.ant_soldier','35.00','17.00',28,'male','L2Monster',40,'544.00000','274.00000','3.50000','1.50000',40,43,30,21,20,20,1555,82,'93.00000','131.00000','67.00000','80.00000',230,4,0,333,0,0,0,80,130,1,1,1,1),
(20229,20229,'Stinger Wasp',0,'',0,'LineageMonster.giant_bee','8.00','24.50',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,1745,95,'109.00000','141.00000','77.00000','85.00000',230,4,500,333,0,0,0,90,90,1,1,1,1),
(20230,20230,'Marsh Stakato Worker',0,'',0,'LineageMonster.marsh_stakato_worker','9.00','21.00',31,'male','L2Monster',40,'636.00000','313.00000','4.50000','1.80000',40,43,30,21,20,20,1996,110,'118.00000','146.00000','83.00000','89.00000',230,1,0,333,153,0,0,20,140,1,1,1,1),
(20231,20231,'Toad Lord',0,'',0,'LineageMonster.poison_toad','20.00','10.00',32,'male','L2Monster',40,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,1946,109,'128.00000','152.00000','85.00000','92.00000',230,4,0,333,0,0,0,50,100,1,1,1,1),
(20232,20232,'Marsh Stakato Soldier',0,'',0,'LineageMonster.marsh_stakato_soldier','10.00','25.00',33,'male','L2Monster',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,1901,109,'138.00000','158.00000','96.00000','96.00000',230,8,0,333,217,0,0,30,155,1,1,1,1),
(20233,20233,'Marsh Spider',0,'',0,'LineageMonster.poison_spider','27.00','25.50',34,'male','L2Monster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,2241,131,'148.00000','164.00000','99.00000','99.00000',230,4,500,333,0,0,0,60,140,1,1,1,1),
(20234,20234,'Marsh Stakato Drone',0,'',0,'LineageMonster.marsh_stakato_drone','9.00','24.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,2268,134,'159.00000','170.00000','111.00000','102.00000',230,8,500,333,219,0,0,80,174,1,1,1,1),
(20235,20235,'Shackle',0,'',0,'LineageMonster.hungry_spirit','13.00','40.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,3569,248,'313.00000','238.00000','212.00000','144.00000',230,4,500,333,0,0,0,15,174,1,1,0,1),
(20236,20236,'Cave Servant',0,'',0,'LineageMonster.skeleton','11.00','25.00',46,'male','L2Monster',40,'1230.00000','580.00000','5.50000','2.10000',40,43,30,21,20,20,3693,262,'332.00000','246.00000','231.00000','149.00000',230,4,0,333,79,945,0,60,174,1,1,0,1),
(20237,20237,'Cave Servant Archer',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',47,'male','L2Monster',1100,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,4972,356,'353.00000','254.00000','244.00000','154.00000',230,8,0,333,14,0,0,40,174,1,1,0,1),
(20238,20238,'Cave Servant Warrior',0,'',0,'LineageMonster.skeleton','11.00','25.00',48,'male','L2Monster',40,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,4785,349,'375.00000','262.00000','260.00000','159.00000',230,4,0,333,77,2495,0,60,174,1,1,0,1),
(20239,20239,'Cave Servant Captain',0,'',0,'LineageMonster.spartoi','11.00','27.00',49,'male','L2Monster',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,5086,376,'398.00000','270.00000','275.00000','164.00000',230,4,500,333,73,2495,0,60,174,1,1,0,1),
(20240,20240,'Royal Cave Servant',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',51,'male','L2Monster',40,'1470.00000','706.00000','6.50000','2.40000',40,43,30,21,20,20,5455,416,'446.00000','287.00000','309.00000','174.00000',230,8,0,333,946,945,0,80,174,1,1,0,1),
(20241,20241,'Hunter Gargoyle',0,'',0,'LineageMonster.hunter_gargoyle','25.00','65.00',52,'male','L2Monster',40,'1520.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,5420,419,'472.00000','295.00000','321.00000','197.00000',230,4,0,333,0,0,0,100,100,1,1,1,1),
(20242,20242,'Dustwind Gargoyle',0,'',0,'LineageMonster.hunter_gargoyle','25.00','65.00',53,'male','L2Monster',40,'1571.00000','757.00000','6.50000','2.40000',40,43,30,21,20,20,5776,454,'498.00000','304.00000','344.00000','184.00000',230,4,0,333,0,0,0,100,174,1,1,0,1),
(20243,20243,'Thunder Wyrm',0,'',0,'LineageMonster.wyrm','29.00','72.00',54,'male','L2Monster',40,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,5140,409,'526.00000','313.00000','364.00000','189.00000',230,4,500,333,0,0,0,70,174,1,1,0,1),
(20244,20244,'Malruk Succubus',0,'',0,'LineageMonster.succubus','10.00','36.00',55,'female','L2Monster',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,5279,426,'554.00000','322.00000','384.00000','195.00000',230,4,0,333,0,0,0,60,174,1,1,0,1),
(20245,20245,'Malruk Succubus Turen',0,'',0,'LineageMonster.succubus','10.00','36.00',56,'female','L2Monster',40,'1725.00000','836.00000','6.50000','2.40000',40,43,30,21,20,20,5473,450,'583.00000','331.00000','404.00000','201.00000',230,4,0,333,0,0,0,60,174,1,1,0,1),
(20246,20246,'Cave Keeper',0,'',0,'LineageMonster.serpent_slave','17.00','46.00',58,'male','L2Monster',40,'1828.00000','889.00000','6.50000','2.40000',40,43,30,21,20,20,6987,590,'646.00000','350.00000','447.00000','212.00000',230,8,0,333,223,0,0,70,174,1,1,0,1),
(20248,20248,'Turak Bugbear',0,'',0,'LineageMonster.bugbear','17.00','35.00',31,'male','L2Monster',40,'636.00000','313.00000','4.50000','1.80000',40,43,30,21,20,20,1677,94,'118.00000','146.00000','83.00000','89.00000',230,1,0,333,88,0,0,55,130,1,1,1,1),
(20249,20249,'Turak Bugbear Warrior',0,'',0,'LineageMonster.bugbear','17.00','35.00',33,'male','L2Monster',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,3606,206,'138.00000','158.00000','96.00000','96.00000',230,4,500,333,73,0,0,55,130,1,1,1,1),
(20250,20250,'Glass Jaguar',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',27,'male','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,1323,67,'87.00000','126.00000','62.00000','76.00000',230,4,0,333,0,0,0,30,120,1,1,1,1),
(20251,20251,'Delu Lizardman',0,'',0,'LineageMonster.virud_lizardman','10.00','23.00',28,'male','L2Monster',40,'544.00000','274.00000','3.50000','1.50000',40,43,30,21,20,20,1400,73,'93.00000','131.00000','67.00000','80.00000',230,4,0,333,1,19,0,43,130,1,1,1,1),
(20252,20252,'Delu Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman','10.00','23.00',29,'male','L2Monster',40,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,1477,79,'101.00000','136.00000','72.00000','82.00000',230,4,0,333,123,0,0,43,130,1,1,1,1),
(20253,20253,'Delu Lizardman Warrior',0,'',0,'LineageMonster.virud_lizardman_warrior','12.00','30.00',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,1586,86,'109.00000','141.00000','77.00000','85.00000',230,4,500,333,16,0,0,52,130,1,1,1,1),
(20254,20254,'Skeleton Axeman',0,'',0,'LineageMonster.skeleton','11.00','25.00',28,'male','L2Monster',40,'544.00000','274.00000','3.50000','1.50000',40,43,30,21,20,20,1442,76,'93.00000','131.00000','67.00000','80.00000',230,1,500,333,86,0,0,60,140,1,1,1,1),
(20255,20255,'Batur Orc',0,'',0,'LineageMonster.batur_orc','9.00','21.50',31,'male','L2Monster',40,'636.00000','313.00000','4.50000','1.80000',40,43,30,21,20,20,1398,78,'118.00000','146.00000','83.00000','89.00000',230,4,0,333,123,0,0,80,130,1,1,0,1),
(20256,20256,'Batur Orc Archer',0,'',0,'LineageMonster.batur_orc_archer','11.00','21.50',32,'male','L2Monster',1100,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,1921,108,'128.00000','152.00000','85.00000','92.00000',230,8,0,333,13,0,0,45,130,1,1,0,1),
(20257,20257,'Batur Orc Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10.00','20.00',33,'male','L2Monster',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,1922,110,'138.00000','158.00000','96.00000','96.00000',230,4,500,333,123,19,0,80,120,1,1,0,1),
(20258,20258,'Batur Orc Shaman',0,'',0,'LineageMonster.batur_orc_shaman','11.00','16.00',34,'male','L2Monster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,1681,98,'148.00000','164.00000','99.00000','99.00000',230,1,0,333,7,0,0,50,120,1,1,0,1),
(20259,20259,'Batur Orc Overlord',0,'',0,'LineageMonster.batur_orc_overlord','12.00','24.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,2163,128,'159.00000','170.00000','111.00000','102.00000',230,4,500,333,79,0,0,80,140,1,1,0,1),
(20260,20260,'Orc Champion',0,'',0,'LineageMonster.orc_champion','10.00','23.00',14,'male','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,435,17,'28.00000','73.00000','16.00000','44.00000',230,4,500,333,2,0,0,45,130,1,1,0,1),
(20261,20261,'Orc Shaman',0,'',0,'LineageMonster.orc_shaman','9.00','22.00',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,505,21,'37.00000','83.00000','27.00000','51.00000',230,1,0,333,7,0,0,45,120,1,1,0,1),
(20265,20265,'Monster Eye Searcher',0,'',0,'LineageMonster.monster_eye','21.00','43.00',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,1833,86,'57.00000','103.00000','36.00000','62.00000',230,1,0,333,0,0,0,90,159,1,1,1,1),
(20266,20266,'Monster Eye Gazer',0,'',0,'LineageMonster.monster_eye','21.00','43.00',25,'male','L2Monster',40,'461.00000','236.00000','3.50000','1.50000',40,43,30,21,20,20,1191,60,'73.00000','116.00000','52.00000','70.00000',230,4,0,333,0,0,0,90,159,1,1,1,1),
(20267,20267,'Breka Orc',0,'',0,'LineageMonster.batur_orc','9.00','21.50',31,'male','L2Monster',40,'636.00000','313.00000','4.50000','1.80000',40,43,30,21,20,20,1677,94,'118.00000','146.00000','83.00000','89.00000',230,8,0,333,215,0,0,80,130,1,1,1,1),
(20268,20268,'Breka Orc Archer',0,'',0,'LineageMonster.batur_orc_archer','11.00','21.50',32,'male','L2Monster',1100,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,2305,130,'128.00000','152.00000','85.00000','92.00000',230,8,0,333,275,0,0,45,130,1,1,1,1),
(20269,20269,'Breka Orc Shaman',0,'',0,'LineageMonster.batur_orc_shaman','11.00','16.00',34,'male','L2Monster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,2018,118,'148.00000','164.00000','99.00000','99.00000',230,1,0,333,7,0,0,50,120,1,1,1,1),
(20270,20270,'Breka Orc Overlord',0,'',0,'LineageMonster.batur_orc_overlord','12.00','24.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,2857,169,'159.00000','170.00000','111.00000','102.00000',230,4,500,333,79,0,0,80,174,1,1,1,1),
(20271,20271,'Breka Orc Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10.00','20.00',33,'male','L2Monster',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,2307,132,'138.00000','158.00000','96.00000','96.00000',230,4,500,333,123,20,0,80,120,1,1,1,1),
(20272,20272,'Cave Servant',0,'',0,'LineageMonster.skeleton','11.00','25.00',46,'male','L2Monster',40,'1230.00000','580.00000','5.50000','2.10000',40,43,30,21,20,20,3078,218,'332.00000','246.00000','231.00000','149.00000',230,4,0,333,79,945,0,60,140,1,1,0,1),
(20273,20273,'Cave Servant Archer',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',47,'male','L2Monster',1100,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,3309,238,'353.00000','254.00000','244.00000','154.00000',230,8,0,333,275,0,0,40,140,1,1,0,1),
(20274,20274,'Cave Servant Warrior',0,'',0,'LineageMonster.skeleton','11.00','25.00',48,'male','L2Monster',40,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,3351,245,'375.00000','262.00000','260.00000','159.00000',230,4,0,333,77,0,0,60,140,1,1,0,1),
(20275,20275,'Cave Servant Captain',0,'',0,'LineageMonster.spartoi','11.00','27.00',49,'male','L2Monster',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,3562,263,'398.00000','270.00000','275.00000','164.00000',230,4,500,333,73,0,0,60,140,1,1,0,1),
(20276,20276,'Royal Cave Servant',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',51,'male','L2Monster',40,'1470.00000','706.00000','6.50000','2.40000',40,43,30,21,20,20,3783,288,'446.00000','287.00000','309.00000','174.00000',230,8,0,333,946,945,0,80,120,1,1,0,1),
(20277,20277,'Cave Keeper',0,'',0,'LineageMonster.serpent_slave','17.00','46.00',58,'male','L2Monster',40,'1828.00000','889.00000','6.50000','2.40000',40,43,30,21,20,20,4893,413,'646.00000','350.00000','447.00000','212.00000',230,8,0,333,223,0,0,70,110,1,1,0,1),
(20279,20279,'Shackle',0,'',0,'LineageMonster.hungry_spirit','13.00','40.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,2974,206,'313.00000','238.00000','212.00000','144.00000',230,4,500,333,0,0,0,15,120,1,1,0,1),
(20280,20280,'Headless Knight',0,'',0,'LineageMonster.headless_knight','21.00','31.00',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,3709,280,'421.00000','278.00000','286.00000','169.00000',230,4,500,333,124,0,0,70,110,1,1,0,1),
(20281,20281,'Dustwind Gargoyle',0,'',0,'LineageMonster.hunter_gargoyle','25.00','65.00',53,'male','L2Monster',40,'1571.00000','757.00000','6.50000','2.40000',40,43,30,21,20,20,4045,318,'498.00000','304.00000','344.00000','184.00000',230,4,0,333,0,0,0,100,100,1,1,0,1),
(20282,20282,'Thunder Wyrm',0,'',0,'LineageMonster.wyrm','29.00','72.00',54,'male','L2Monster',40,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,4283,342,'526.00000','313.00000','364.00000','189.00000',230,4,500,333,0,0,0,70,70,1,1,0,1),
(20283,20283,'Malruk Succubus',0,'',0,'LineageMonster.succubus','10.00','36.00',55,'female','L2Monster',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,4400,355,'554.00000','322.00000','384.00000','195.00000',230,4,0,333,0,0,0,60,100,1,1,0,1),
(20284,20284,'Malruk Succubus Turen',0,'',0,'LineageMonster.succubus','10.00','36.00',56,'female','L2Monster',40,'1725.00000','836.00000','6.50000','2.40000',40,43,30,21,20,20,4561,374,'583.00000','331.00000','404.00000','201.00000',230,4,0,333,0,0,0,60,100,1,1,0,1),
(20285,20285,'Drake',0,'',0,'LineageMonster.drake','30.00','100.00',57,'male','L2Monster',40,'1777.00000','862.00000','6.50000','2.40000',40,43,30,21,20,20,4820,401,'614.00000','340.00000','420.00000','207.00000',230,4,500,333,0,0,0,70,70,1,1,0,1),
(20286,20286,'Hunter Gargoyle',0,'',0,'LineageMonster.hunter_gargoyle','25.00','65.00',52,'male','L2Monster',40,'1520.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,3894,301,'472.00000','295.00000','321.00000','179.00000',230,4,0,333,0,0,0,100,100,1,1,0,1),
(20287,20287,'Cave Maiden',0,'',0,'LineageMonster.cave_maiden','25.00','65.00',59,'female','L2Monster',40,'1881.00000','916.00000','6.50000','2.40000',40,43,30,21,20,20,5113,437,'678.00000','359.00000','464.00000','218.00000',230,4,500,333,68,0,0,70,120,1,1,0,1),
(20291,20291,'Enku Orc Champion',0,'',0,'LineageMonster.orc_champion','10.00','23.00',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,1113,52,'53.00000','99.00000','38.00000','60.00000',230,4,500,333,2,0,0,45,130,1,1,1,1),
(20292,20292,'Enku Orc Shaman',0,'',0,'LineageMonster.orc_shaman','9.00','22.00',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,813,36,'48.00000','95.00000','30.00000','57.00000',230,1,0,333,7,0,0,45,120,1,1,1,1),
(20293,20293,'Virud Lizardman',0,'',0,'LineageMonster.virud_lizardman','10.00','23.00',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,594,26,'48.00000','95.00000','30.00000','57.00000',230,4,0,333,291,0,0,43,130,1,1,0,1),
(20294,20294,'Virud Lizardman Matriarch',0,'',0,'LineageMonster.virud_lizardman_matriarch','13.00','37.00',24,'male','L2Monster',40,'435.00000','224.00000','3.50000','1.50000',40,43,30,21,20,20,1142,56,'68.00000','112.00000','48.00000','67.00000',230,4,500,333,2,19,0,56,130,1,1,0,1),
(20295,20295,'Virud Lizardman Warrior',0,'',0,'LineageMonster.virud_lizardman_warrior','12.00','30.00',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,838,40,'57.00000','103.00000','36.00000','62.00000',230,4,500,333,16,0,0,52,130,1,1,0,1),
(20296,20296,'Virud Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman_scout','10.00','22.00',21,'male','L2Monster',1100,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,787,36,'53.00000','99.00000','38.00000','60.00000',230,8,0,333,2507,0,0,43,130,1,1,0,1),
(20297,20297,'Virud Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman','10.00','29.00',23,'male','L2Monster',40,'411.00000','211.00000','3.50000','1.50000',40,43,30,21,20,20,878,42,'62.00000','107.00000','40.00000','65.00000',230,1,0,333,7,0,0,43,120,1,1,0,1),
(20298,20298,'Virud Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman','10.00','29.00',23,'male','L2Monster',40,'411.00000','211.00000','3.50000','1.50000',40,43,30,21,20,20,878,42,'62.00000','107.00000','40.00000','65.00000',230,1,0,333,7,0,0,43,120,1,1,0,1),
(20299,20299,'Zenta Lizardman',0,'',0,'LineageMonster.zenta_lizardman','11.00','32.00',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,2327,150,'226.00000','202.00000','157.00000','122.00000',230,4,0,333,68,0,0,37,140,1,1,0,1),
(20300,20300,'Zenta Lizardman Matriarch',0,'',0,'LineageMonster.zenta_lizardman_matriarch','20.00','40.00',44,'male','L2Monster',40,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,3418,234,'293.00000','231.00000','199.00000','139.00000',230,8,500,333,221,0,0,53,140,1,1,0,1),
(20301,20301,'Zenta Lizardman Scout',0,'',0,'LineageMonster.zenta_lizardman_scout','11.00','30.00',41,'male','L2Monster',1100,'1008.00000','459.00000','5.50000','2.10000',40,43,30,21,20,20,2518,164,'241.00000','209.00000','163.00000','126.00000',230,8,0,333,14,0,0,37,150,1,1,0,1),
(20302,20302,'Zenta Lizardman Warrior',0,'',0,'LineageMonster.zenta_lizardman_warrior','13.00','35.00',42,'male','L2Monster',40,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,2617,174,'258.00000','216.00000','174.00000','131.00000',230,4,500,333,16,0,0,40,140,1,1,0,1),
(20303,20303,'Zenta Lizardman Shaman',0,'',0,'LineageMonster.zenta_lizardman_shaman','13.00','35.00',43,'male','L2Monster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,2689,182,'275.00000','223.00000','191.00000','135.00000',230,1,0,333,7,0,0,43,130,1,1,0,1),
(20304,20304,'Marsh Stakato Queen',0,'',0,'LineageMonster.marsh_stakato_queen','15.00','37.00',36,'female','L2Monster',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,2288,138,'171.00000','176.00000','115.00000','107.00000',230,4,500,333,74,0,0,130,130,1,1,0,1),
(20305,20305,'Grave',0,'',0,'LineageMonster.grave','15.00','29.00',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,2350,151,'226.00000','202.00000','157.00000','122.00000',230,4,500,333,0,0,0,70,110,1,1,0,1),
(20307,20307,'Garum Werewolf',0,'',0,'LineageMonster.werewolf','10.00','26.00',9,'male','L2Monster',40,'143.00000','92.00000','2.00000','0.90000',40,43,30,21,20,20,321,11,'18.00000','58.00000','14.00000','35.00000',230,1,0,333,5,0,0,50,120,1,1,1,1),
(20308,20308,'Hook Spider',0,'',0,'LineageMonster.giant_spider','26.00','25.50',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,571,23,'33.00000','80.00000','20.00000','48.00000',230,4,0,333,0,0,0,72,130,1,1,1,1),
(20309,20309,'Brown Fox',0,'',0,'LineageMonster.fox','9.50','10.00',2,'male','L2Monster',40,'48.00000','43.00000','2.00000','0.90000',40,43,30,21,20,20,59,2,'8.00000','42.00000','7.00000','25.00000',230,4,0,333,0,0,0,23,110,1,1,0,1),
(20310,20310,'Brown Bear',0,'',0,'LineageMonster.grizzly_bi','21.00','50.00',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,577,23,'33.00000','80.00000','20.00000','48.00000',230,4,500,333,0,0,0,40,110,1,1,1,1),
(20311,20311,'Rakeclaw Imp',0,'',0,'LineageMonster.imp','10.00','24.00',6,'male','L2Monster',40,'94.00000','70.00000','2.00000','0.90000',40,43,30,21,20,20,214,6,'13.00000','51.00000','6.00000','31.00000',230,4,0,333,0,0,0,60,80,1,1,1,1),
(20312,20312,'Rakeclaw Imp Hunter',0,'',0,'LineageMonster.imp','10.00','24.00',7,'male','L2Monster',40,'108.00000','77.00000','2.00000','0.90000',40,43,30,21,20,20,249,8,'14.00000','53.00000','6.00000','32.00000',230,4,0,333,0,0,0,60,80,1,1,1,1),
(20313,20313,'Rakeclaw Imp Chieftain',0,'',0,'LineageMonster.imp_bi','10.00','30.00',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,363,12,'19.00000','61.00000','10.00000','37.00000',230,4,500,333,0,0,0,60,80,1,1,1,1),
(20314,20314,'Great White Shark',0,'',0,'LineageMonster.great_white_shark','20.00','7.00',42,'male','L2Monster',40,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,2617,174,'258.00000','216.00000','174.00000','131.00000',230,4,500,333,0,0,0,80,174,1,1,0,1),
(20316,20316,'Darkwing Bat',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',11,'male','L2Monster',40,'185.00000','106.00000','2.50000','1.20000',40,43,30,21,20,20,392,15,'21.00000','64.00000','11.00000','39.00000',230,4,0,333,0,0,0,60,80,1,1,1,1),
(20317,20317,'Black Wolf',0,'',0,'LineageMonster.wolf','13.00','9.00',4,'male','L2Monster',40,'68.00000','57.00000','2.00000','0.90000',40,43,30,21,20,20,141,4,'10.00000','46.00000','9.00000','28.00000',230,4,0,333,0,0,0,24,110,1,1,1,1),
(20318,20318,'Black Timber Wolf',0,'',0,'LineageMonster.wolf_bi','13.00','10.80',6,'male','L2Monster',40,'94.00000','70.00000','2.00000','0.90000',40,43,30,21,20,20,212,6,'13.00000','51.00000','6.00000','31.00000',230,4,0,333,0,0,0,24,110,1,1,1,1),
(20319,20319,'Goblin Grave Robber',0,'',0,'LineageMonster.goblin','10.00','16.50',5,'male','L2Monster',40,'80.00000','63.00000','2.00000','0.90000',40,43,30,21,20,20,178,5,'12.00000','49.00000','5.00000','30.00000',230,1,0,333,4,0,0,40,110,1,1,1,1),
(20320,20320,'Goblin Tomb Raider Leader',0,'',0,'LineageMonster.goblin_bi','10.00','21.40',12,'male','L2Monster',40,'199.00000','113.00000','2.50000','1.20000',40,43,30,21,20,20,428,16,'23.00000','67.00000','17.00000','41.00000',230,8,0,333,12,0,0,40,110,1,1,1,1),
(20321,20321,'Goblin Thief',0,'',0,'LineageMonster.goblin_bi','10.00','21.40',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,356,12,'19.00000','61.00000','10.00000','37.00000',230,8,0,333,217,0,0,40,110,1,1,1,1),
(20322,20322,'Goblin Brigand',0,'',0,'LineageMonster.goblin','10.00','16.50',8,'male','L2Monster',40,'125.00000','84.00000','2.00000','0.90000',40,43,30,21,20,20,285,10,'16.00000','56.00000','12.00000','34.00000',230,1,0,333,4,0,0,40,110,1,1,1,1),
(20323,20323,'Goblin Brigand Leader',0,'',0,'LineageMonster.goblin_bi','10.00','21.40',14,'male','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,509,20,'28.00000','73.00000','16.00000','44.00000',230,8,500,333,217,0,0,40,110,1,1,1,1),
(20324,20324,'Goblin Brigand Lieutenant',0,'',0,'LineageMonster.goblin','10.00','16.50',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,363,12,'19.00000','61.00000','10.00000','37.00000',230,8,500,333,10,0,0,40,110,1,1,1,1),
(20325,20325,'Goblin Raider',0,'',0,'LineageMonster.goblin','10.00','16.50',5,'male','L2Monster',40,'80.00000','63.00000','2.00000','0.90000',40,43,30,21,20,20,178,5,'12.00000','49.00000','5.00000','30.00000',230,1,0,333,4,0,0,40,110,1,1,1,1),
(20326,20326,'Goblin Scout',0,'',0,'LineageMonster.goblin','10.00','16.50',8,'male','L2Monster',40,'125.00000','84.00000','2.00000','0.90000',40,43,30,21,20,20,285,10,'16.00000','56.00000','12.00000','34.00000',230,1,0,333,4,0,0,40,110,1,1,1,1),
(20327,20327,'Goblin Snooper',0,'',0,'LineageMonster.goblin','10.00','16.50',5,'male','L2Monster',40,'80.00000','63.00000','2.00000','0.90000',40,43,30,21,20,20,178,5,'12.00000','49.00000','5.00000','30.00000',230,1,0,333,4,0,0,40,110,1,1,1,1),
(20328,20328,'Goblin Lookout',0,'',0,'LineageMonster.goblin','10.00','16.50',8,'male','L2Monster',40,'125.00000','84.00000','2.00000','0.90000',40,43,30,21,20,20,285,10,'16.00000','56.00000','12.00000','34.00000',230,8,0,333,12,0,0,40,110,1,1,1,1),
(20329,20329,'Ghost Guardian',0,'',0,'LineageMonster.human_ghost','8.00','22.00',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,772,36,'53.00000','99.00000','38.00000','60.00000',230,4,500,333,0,0,0,80,140,1,1,0,1),
(20330,20330,'Mineshaft Bat',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',11,'male','L2Monster',40,'185.00000','106.00000','2.50000','1.20000',40,43,30,21,20,20,326,12,'21.00000','64.00000','11.00000','39.00000',230,4,0,333,0,0,0,60,80,1,1,0,1),
(20331,20331,'Monster Eye Tracker',0,'',0,'LineageMonster.monster_eye','21.00','43.00',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,297,10,'19.00000','61.00000','10.00000','37.00000',230,4,0,333,0,0,0,90,134,1,1,0,1),
(20333,20333,'Greystone Golem',0,'',0,'LineageMonster.stone_golem','20.00','31.00',13,'male','L2Monster',40,'215.00000','120.00000','2.50000','1.20000',40,43,30,21,20,20,655,26,'25.00000','70.00000','15.00000','43.00000',230,4,0,333,0,0,0,23,23,1,1,1,1),
(20334,20334,'Gremlin Scavenger',0,'',0,'LineageMonster.gremlin','10.00','15.00',1,'male','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,29,2,'8.00000','40.00000','7.00000','25.00000',230,4,0,333,0,0,0,20,50,1,1,0,1),
(20335,20335,'Grizzly Bear',0,'',0,'LineageMonster.grizzly_bi','21.00','50.00',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,600,25,'37.00000','83.00000','27.00000','51.00000',230,4,0,333,0,0,0,40,110,1,1,1,1),
(20336,20336,'Green Dryad',0,'',0,'LineageMonster.dryad_sm','6.00','15.00',8,'female','L2Monster',40,'125.00000','84.00000','2.00000','0.90000',40,43,30,21,20,20,285,10,'16.00000','56.00000','12.00000','34.00000',230,4,0,333,0,0,0,40,110,1,1,1,1),
(20337,20337,'Longtail Fox',0,'',0,'LineageMonster.fox','9.50','10.00',2,'male','L2Monster',40,'48.00000','43.00000','2.00000','0.90000',40,43,30,21,20,20,59,2,'8.00000','42.00000','7.00000','25.00000',230,4,0,333,0,0,0,23,110,1,1,0,1),
(20338,20338,'Nightmare Weaver',0,'',0,'LineageMonster.magical_weaver','11.00','20.00',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,849,40,'53.00000','99.00000','38.00000','60.00000',230,4,500,333,0,0,0,90,90,1,1,0,1),
(20340,20340,'Slave Skeleton',0,'',0,'LineageMonster.skeleton','11.00','25.00',12,'male','L2Monster',40,'199.00000','113.00000','2.50000','1.20000',40,43,30,21,20,20,363,13,'23.00000','67.00000','17.00000','41.00000',230,8,500,333,946,0,0,60,140,1,1,0,1),
(20341,20341,'Undead Slave',0,'',0,'LineageMonster.zombie','13.00','21.00',19,'male','L2Monster',40,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,799,36,'44.00000','91.00000','32.00000','55.00000',230,4,0,333,0,0,0,15,15,1,1,0,1),
(20342,20342,'Werewolf Chieftain',0,'',0,'LineageMonster.werewolf_bi','11.00','29.70',12,'male','L2Monster',40,'199.00000','113.00000','2.50000','1.20000',40,43,30,21,20,20,436,16,'23.00000','67.00000','17.00000','41.00000',230,1,500,333,5,0,0,50,120,1,1,1,1),
(20343,20343,'Werewolf Hunter',0,'',0,'LineageMonster.werewolf','10.00','26.00',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,363,12,'19.00000','61.00000','10.00000','37.00000',230,1,500,333,5,0,0,50,120,1,1,1,1),
(20345,20345,'Dark Terror',0,'',0,'LineageMonster.dark_horror','20.00','35.00',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,534,22,'33.00000','80.00000','20.00000','48.00000',230,4,500,333,0,0,0,100,100,1,1,0,1),
(20346,20346,'Darkstone Golem',0,'',0,'LineageMonster.stone_golem','20.00','31.00',13,'male','L2Monster',40,'215.00000','120.00000','2.50000','1.20000',40,43,30,21,20,20,545,21,'25.00000','70.00000','15.00000','43.00000',230,4,0,333,0,0,0,23,23,1,1,0,1),
(20347,20347,'Doom Wraith',0,'',0,'LineageMonster.death_blader','15.00','45.00',55,'male','L2Monster',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,4488,362,'554.00000','322.00000','384.00000','195.00000',230,4,500,333,1472,0,0,100,174,1,1,0,1),
(20348,20348,'Cave Spider',0,'',0,'LineageMonster.giant_spider','26.00','25.50',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,445,18,'31.00000','76.00000','23.00000','47.00000',230,4,0,333,0,0,0,72,130,1,1,0,1),
(20349,20349,'Cave Bat',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',13,'male','L2Monster',40,'215.00000','120.00000','2.50000','1.20000',40,43,30,21,20,20,386,15,'25.00000','70.00000','15.00000','43.00000',230,4,0,333,0,0,0,60,80,1,1,0,1),
(20350,20350,'Cave Fang Spider',0,'',0,'LineageMonster.giant_spider','26.00','25.50',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,485,20,'33.00000','80.00000','20.00000','48.00000',230,4,500,333,0,0,0,72,130,1,1,0,1),
(20351,20351,'Dre Vanul Tracker',0,'',0,'LineageMonster.dre_vanul','14.00','36.00',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,606,27,'48.00000','95.00000','30.00000','57.00000',230,4,500,333,0,0,0,80,80,1,1,0,1),
(20352,20352,'Dre Vanul Slayer',0,'',0,'LineageMonster.dre_vanul','14.00','36.00',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,921,43,'57.00000','103.00000','36.00000','62.00000',230,4,500,333,0,0,0,80,80,1,1,0,1),
(20353,20353,'Dre Vanul Beholder',0,'',0,'LineageMonster.dre_vanul','14.00','36.00',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,780,36,'53.00000','99.00000','38.00000','60.00000',230,4,500,333,0,0,0,80,80,1,1,0,1),
(20354,20354,'Dwarf Ghost',0,'',0,'LineageMonster.dwarf_ghost','10.00','18.70',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,606,27,'48.00000','95.00000','30.00000','57.00000',230,4,500,333,0,0,0,80,140,1,1,0,1),
(20356,20356,'Langk Lizardman Leader',0,'',0,'LineageMonster.virud_lizardman_warrior_bi','12.00','34.50',25,'male','L2Monster',40,'461.00000','236.00000','3.50000','1.50000',40,43,30,21,20,20,1215,61,'73.00000','116.00000','52.00000','70.00000',230,4,500,333,16,0,0,52,130,1,1,1,1),
(20357,20357,'Langk Lizardman Lieutenant',0,'',0,'LineageMonster.virud_lizardman_warrior','12.00','30.00',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,986,47,'57.00000','103.00000','36.00000','62.00000',230,4,0,333,16,0,0,52,130,1,1,1,1),
(20358,20358,'Ratman Hunter',0,'',0,'LineageMonster.wererat','14.00','25.00',18,'male','L2Monster',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,640,28,'40.00000','87.00000','25.00000','52.00000',230,8,0,333,11,0,0,80,120,1,1,1,1),
(20359,20359,'Ratman Warrior',0,'',0,'LineageMonster.wererat','14.00','25.00',19,'male','L2Monster',40,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,678,30,'44.00000','91.00000','32.00000','55.00000',230,4,0,333,2,0,0,80,120,1,1,1,1),
(20360,20360,'Ratman Spy',0,'',0,'LineageMonster.wererat_sm','14.00','18.70',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,571,23,'33.00000','80.00000','20.00000','48.00000',230,8,0,333,12,0,0,80,120,1,1,1,1),
(20361,20361,'Tunath Orc Marksman',0,'',0,'LineageMonster.orc_archer','14.00','25.00',10,'male','L2Monster',1100,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,306,10,'19.00000','61.00000','10.00000','37.00000',230,8,0,333,14,0,0,45,110,1,1,0,1),
(20362,20362,'Tunath Orc Warrior',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',12,'male','L2Monster',40,'199.00000','113.00000','2.50000','1.20000',40,43,30,21,20,20,363,13,'23.00000','67.00000','17.00000','41.00000',230,4,500,333,2,0,0,45,110,1,1,0,1),
(20363,20363,'Maraku Werewolf',0,'',0,'LineageMonster.werewolf','10.00','26.00',9,'male','L2Monster',40,'143.00000','92.00000','2.00000','0.90000',40,43,30,21,20,20,321,11,'18.00000','58.00000','14.00000','35.00000',230,4,0,333,0,0,0,50,120,1,1,1,1),
(20364,20364,'Maraku Werewolf Chieftain',0,'',0,'LineageMonster.werewolf_bi','11.00','29.70',14,'male','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,509,20,'28.00000','73.00000','16.00000','44.00000',230,8,500,333,217,0,0,50,120,1,1,1,1),
(20365,20365,'Mountain Fungus',0,'',0,'LineageMonster.walking_fungus','15.00','22.50',8,'male','L2Monster',40,'125.00000','84.00000','2.00000','0.90000',40,43,30,21,20,20,285,10,'16.00000','56.00000','12.00000','34.00000',230,4,0,333,0,0,0,70,110,1,1,1,1),
(20367,20367,'Merkenis Escort',0,'',0,'LineageMonster.spartoi','11.00','27.00',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,606,27,'48.00000','95.00000','30.00000','57.00000',230,4,0,333,68,0,0,60,140,1,1,0,1),
(20368,20368,'Grave Keeper',0,'',0,'LineageMonster.stone_golem','20.00','31.00',13,'male','L2Monster',40,'215.00000','120.00000','2.50000','1.20000',40,43,30,21,20,20,545,21,'25.00000','70.00000','15.00000','43.00000',230,4,0,333,0,0,0,23,23,1,1,0,1),
(20369,20369,'Moonstone Beast',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,600,25,'37.00000','83.00000','27.00000','51.00000',230,4,0,333,0,0,0,30,120,1,1,1,1),
(20370,20370,'Barbed Bat',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',12,'male','L2Monster',40,'199.00000','113.00000','2.50000','1.20000',40,43,30,21,20,20,428,16,'23.00000','67.00000','17.00000','41.00000',230,4,0,333,0,0,0,60,80,1,1,1,1),
(20371,20371,'Mist Terror',0,'',0,'LineageMonster.dark_horror','20.00','35.00',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,454,19,'31.00000','76.00000','23.00000','47.00000',230,4,500,333,0,0,0,100,100,1,1,0,1),
(20372,20372,'Baraq Orc Fighter',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,303,10,'19.00000','61.00000','10.00000','37.00000',230,4,500,333,2,0,0,45,110,1,1,0,1),
(20373,20373,'Baraq Orc Warrior Leader',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',11,'male','L2Monster',40,'185.00000','106.00000','2.50000','1.20000',40,43,30,21,20,20,326,12,'21.00000','64.00000','11.00000','39.00000',230,4,0,333,2,0,0,45,110,1,1,0,1),
(20374,20374,'Baranka\'s Guard',0,'',0,'LineageMonster.spartoi','11.00','27.00',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,1093,52,'57.00000','103.00000','36.00000','62.00000',230,4,500,333,68,0,0,60,140,1,1,0,1),
(20375,20375,'Baranka\'s Escort',0,'',0,'LineageMonster.spartoi','11.00','27.00',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,780,36,'53.00000','99.00000','38.00000','60.00000',230,8,500,333,946,0,0,60,140,1,1,0,1),
(20376,20376,'Varikan Brigand Leader',0,'',0,'LineageMonster.goblin_bi','10.00','21.40',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,1007,34,'19.00000','61.00000','10.00000','37.00000',230,1,500,333,12,0,0,40,110,1,1,0,1),
(20377,20377,'Varika\'s Bandit',0,'',0,'LineageMonster.goblin','10.00','16.50',7,'male','L2Monster',40,'108.00000','77.00000','2.00000','0.90000',40,43,30,21,20,20,167,6,'14.00000','53.00000','6.00000','32.00000',230,1,0,333,0,0,0,40,110,1,1,0,1),
(20378,20378,'Stone Giant',0,'',0,'LineageMonster.stone_golem','20.00','31.00',13,'male','L2Monster',40,'215.00000','120.00000','2.50000','1.20000',40,43,30,21,20,20,545,21,'25.00000','70.00000','15.00000','43.00000',230,1,0,333,0,0,0,23,23,1,1,0,1),
(20379,20379,'Stone Soldier',0,'',0,'LineageMonster.stone_golem','20.00','31.00',14,'male','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,705,27,'28.00000','73.00000','16.00000','44.00000',230,4,0,333,0,0,0,23,23,1,1,1,1),
(20380,20380,'Stone Guardian',0,'',0,'LineageMonster.stone_golem','20.00','31.00',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,807,33,'33.00000','80.00000','20.00000','48.00000',230,4,0,333,0,0,0,23,23,1,1,1,1),
(20381,20381,'Vaiss Orc',0,'',0,'LineageMonster.orc','10.00','21.00',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,297,10,'19.00000','61.00000','10.00000','37.00000',230,1,0,333,156,0,0,45,110,1,1,0,1),
(20382,20382,'Vaiss Orc Warrior Leader',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',11,'male','L2Monster',40,'185.00000','106.00000','2.50000','1.20000',40,43,30,21,20,20,326,12,'21.00000','64.00000','11.00000','39.00000',230,4,0,333,2,0,0,45,110,1,1,0,1),
(20383,20383,'Arachnid Hunter',0,'',0,'LineageMonster.binding','12.00','21.00',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,1469,80,'109.00000','141.00000','77.00000','85.00000',230,4,500,333,0,0,0,10,140,1,1,0,1),
(20385,20385,'Balor Orc Archer',0,'',0,'LineageMonster.orc_archer','14.00','25.00',8,'male','L2Monster',1100,'125.00000','84.00000','2.00000','0.90000',40,43,30,21,20,20,293,10,'16.00000','56.00000','12.00000','34.00000',230,8,0,333,14,0,0,45,110,1,1,1,1),
(20386,20386,'Balor Orc Fighter',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,363,12,'19.00000','61.00000','10.00000','37.00000',230,4,500,333,2,0,0,45,110,1,1,1,1),
(20387,20387,'Balor Orc Fighter Leader',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',12,'male','L2Monster',40,'199.00000','113.00000','2.50000','1.20000',40,43,30,21,20,20,436,16,'23.00000','67.00000','17.00000','41.00000',230,4,500,333,2,0,0,45,110,1,1,1,1),
(20388,20388,'Balor Orc Lieutenant',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',11,'male','L2Monster',40,'185.00000','106.00000','2.50000','1.20000',40,43,30,21,20,20,392,15,'21.00000','64.00000','11.00000','39.00000',230,4,0,333,2,0,0,45,110,1,1,1,1),
(20389,20389,'Boogle Ratman',0,'',0,'LineageMonster.wererat','14.00','25.00',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,476,19,'33.00000','80.00000','20.00000','48.00000',230,8,0,333,12,0,0,80,120,1,1,0,1),
(20390,20390,'Boogle Ratman Leader',0,'',0,'LineageMonster.wererat','14.00','25.00',18,'male','L2Monster',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,533,23,'40.00000','87.00000','25.00000','52.00000',230,8,0,333,12,0,0,80,120,1,1,0,1),
(20391,20391,'Red Fox',0,'',0,'LineageMonster.fox','9.50','10.00',2,'male','L2Monster',40,'48.00000','43.00000','2.00000','0.90000',40,43,30,21,20,20,59,2,'8.00000','42.00000','7.00000','25.00000',230,4,0,333,0,0,0,23,110,1,1,0,1),
(20392,20392,'Redeye Bat',0,'',0,'LineageMonster.vampire_bat_bi','10.00','42.00',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,534,22,'31.00000','76.00000','23.00000','47.00000',230,4,0,333,0,0,0,60,80,1,1,1,1),
(20393,20393,'Red Scavenger Spider',0,'',0,'LineageMonster.giant_spider','26.00','25.50',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,571,23,'33.00000','80.00000','20.00000','48.00000',230,4,0,333,0,0,0,72,130,1,1,1,1),
(20394,20394,'Crimson Tarantula',0,'',0,'LineageMonster.giant_spider','26.00','25.50',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,450,18,'31.00000','76.00000','23.00000','47.00000',230,4,500,333,0,0,0,72,130,1,1,0,1),
(20398,20398,'Vrykolakas',0,'',0,'LineageMonster.werewolf_bi','11.00','29.70',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,1386,57,'31.00000','76.00000','23.00000','47.00000',230,1,500,333,0,0,0,50,120,1,1,0,1),
(20399,20399,'Vrykolakas Wolfkin',0,'',0,'LineageMonster.wolf_bi','13.00','10.80',9,'male','L2Monster',40,'143.00000','92.00000','2.00000','0.90000',40,43,30,21,20,20,177,6,'18.00000','58.00000','14.00000','35.00000',230,1,0,333,0,0,0,24,110,1,1,0,1),
(20400,20400,'Blood Fungus',0,'',0,'LineageMonster.walking_fungus','15.00','22.50',12,'male','L2Monster',40,'199.00000','113.00000','2.50000','1.20000',40,43,30,21,20,20,428,16,'23.00000','67.00000','17.00000','41.00000',230,4,0,333,0,0,0,70,110,1,1,1,1),
(20401,20401,'Veelan Bugbear',0,'',0,'LineageMonster.bugbear','17.00','35.00',23,'male','L2Monster',40,'411.00000','211.00000','3.50000','1.50000',40,43,30,21,20,20,1054,50,'62.00000','107.00000','40.00000','65.00000',230,1,0,333,156,0,0,55,130,1,1,1,1),
(20402,20402,'Veelan Bugbear Warrior',0,'',0,'LineageMonster.bugbear','17.00','35.00',24,'male','L2Monster',40,'435.00000','224.00000','3.50000','1.50000',40,43,30,21,20,20,1145,56,'68.00000','112.00000','48.00000','67.00000',230,1,500,333,88,0,0,55,130,1,1,1,1),
(20403,20403,'Hunter Tarantula',0,'',0,'LineageMonster.giant_spider','26.00','25.50',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,571,23,'33.00000','80.00000','20.00000','48.00000',230,4,0,333,0,0,0,72,130,1,1,1,1),
(20404,20404,'Silent Horror',0,'',0,'LineageMonster.dark_horror','20.00','35.00',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,485,20,'33.00000','80.00000','20.00000','48.00000',230,1,500,333,0,0,0,100,100,1,1,0,1),
(20405,20405,'Young Brown Fox',0,'',0,'LineageMonster.fox','9.50','10.00',1,'male','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,29,2,'8.00000','40.00000','7.00000','25.00000',230,4,0,333,0,0,0,23,110,1,1,0,1),
(20406,20406,'Young Red Fox',0,'',0,'LineageMonster.fox','9.50','10.00',1,'male','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,29,2,'8.00000','40.00000','7.00000','25.00000',230,4,0,333,0,0,0,23,110,1,1,0,1),
(20407,20407,'Young Crimson Fox',0,'',0,'LineageMonster.fox','9.50','10.00',1,'male','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,29,2,'8.00000','40.00000','7.00000','25.00000',230,4,0,333,0,0,0,23,110,1,1,0,1),
(20410,20410,'Scavenger Spider',0,'',0,'LineageMonster.giant_spider','26.00','25.50',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,545,22,'31.00000','76.00000','23.00000','47.00000',230,4,500,333,0,0,0,72,130,1,1,1,1),
(20411,20411,'Scavenger Bat',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',18,'male','L2Monster',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,640,28,'40.00000','87.00000','25.00000','52.00000',230,4,0,333,0,0,0,60,80,1,1,1,1),
(20412,20412,'Susceptor',0,'',0,'LineageMonster.susceptor','20.00','35.00',49,'male','L2Monster',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,3492,258,'398.00000','270.00000','275.00000','164.00000',230,4,500,333,0,0,0,27,174,1,1,0,1),
(20415,20415,'Scarlet Salamander',0,'',0,'LineageMonster.salamander','16.00','6.80',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,555,23,'37.00000','83.00000','27.00000','51.00000',230,4,0,333,0,0,0,64,96,1,1,0,1),
(20416,20416,'Scarlet Salamander Elder',0,'',0,'LineageMonster.salamander','16.00','6.80',18,'male','L2Monster',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,587,26,'40.00000','87.00000','25.00000','52.00000',230,4,0,333,0,0,0,64,96,1,1,0,1),
(20418,20418,'Crystalline Beast',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',18,'male','L2Monster',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,634,28,'40.00000','87.00000','25.00000','52.00000',230,4,0,333,0,0,0,30,120,1,1,1,1),
(20419,20419,'Akaste Succubus',0,'',0,'LineageMonster.succubus','10.00','36.00',20,'female','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,606,27,'48.00000','95.00000','30.00000','57.00000',230,4,500,333,0,0,0,60,100,1,1,0,1),
(20420,20420,'Akaste Succubus Turen',0,'',0,'LineageMonster.succubus','10.00','36.00',21,'female','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,780,36,'53.00000','99.00000','38.00000','60.00000',230,4,500,333,0,0,0,60,100,1,1,0,1),
(20421,20421,'Akaste Succubus Tilfo',0,'',0,'LineageMonster.succubus_bi','10.00','43.20',22,'female','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,838,40,'57.00000','103.00000','36.00000','62.00000',230,4,500,333,0,0,0,60,100,1,1,0,1),
(20422,20422,'Akaste Bone Warlord',0,'',0,'LineageMonster.skeleton','11.00','25.00',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,613,26,'37.00000','83.00000','27.00000','51.00000',230,4,500,333,2,18,0,60,140,1,1,0,1),
(20423,20423,'Akaste Bone Archer',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',14,'male','L2Monster',1100,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,428,17,'28.00000','73.00000','16.00000','44.00000',230,8,0,333,275,0,0,40,140,1,1,0,1),
(20424,20424,'Akaste Bone Lord',0,'',0,'LineageMonster.skeleton','11.00','25.00',19,'male','L2Monster',40,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,592,26,'44.00000','91.00000','32.00000','55.00000',230,4,500,333,68,19,0,60,140,1,1,0,1),
(20425,20425,'Akaste Bone Soldier',0,'',0,'LineageMonster.skeleton','11.00','25.00',12,'male','L2Monster',40,'199.00000','113.00000','2.50000','1.20000',40,43,30,21,20,20,363,13,'23.00000','67.00000','17.00000','41.00000',230,8,500,333,946,0,0,60,140,1,1,0,1),
(20426,20426,'Evil Eye',0,'',0,'LineageMonster.monster_eye','21.00','43.00',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,356,12,'19.00000','61.00000','10.00000','37.00000',230,4,0,333,0,0,0,90,134,1,1,1,1),
(20427,20427,'Evil Eye Watcher',0,'',0,'LineageMonster.monster_eye','21.00','43.00',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,297,10,'19.00000','61.00000','10.00000','37.00000',230,4,0,333,0,0,0,90,134,1,1,0,1),
(20428,20428,'Evil Eye Patroller',0,'',0,'LineageMonster.monster_eye','21.00','43.00',14,'male','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,499,19,'28.00000','73.00000','16.00000','44.00000',230,4,0,333,0,0,0,90,134,1,1,1,1),
(20429,20429,'Evil Eye Lookout',0,'',0,'LineageMonster.monster_eye','21.00','43.00',14,'male','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,416,16,'28.00000','73.00000','16.00000','44.00000',230,4,0,333,0,0,0,90,134,1,1,0,1),
(20431,20431,'Elf Ghost',0,'',0,'LineageMonster.elf_ghost','7.00','21.00',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,606,27,'48.00000','95.00000','30.00000','57.00000',230,4,500,333,0,0,0,80,140,1,1,0,1),
(20432,20432,'Elpy',0,'',0,'LineageMonster.elpy','5.00','4.50',1,'male','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,35,2,'8.00000','40.00000','7.00000','25.00000',230,4,0,333,0,0,0,50,80,1,1,1,1),
(20433,20433,'Festering Bat',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',13,'male','L2Monster',40,'215.00000','120.00000','2.50000','1.20000',40,43,30,21,20,20,463,18,'25.00000','70.00000','15.00000','43.00000',230,4,0,333,0,0,0,60,80,1,1,1,1),
(20435,20435,'Opal Beast',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,450,18,'31.00000','76.00000','23.00000','47.00000',230,4,500,333,0,0,0,30,120,1,1,0,1),
(20436,20436,'Ol Mahum Supplier',0,'',0,'LineageMonster.ol_mahum_bi','13.50','29.20',23,'male','L2Monster',40,'411.00000','211.00000','3.50000','1.50000',40,43,30,21,20,20,1054,50,'62.00000','107.00000','40.00000','65.00000',230,4,0,333,2,19,0,50,110,1,1,1,1),
(20437,20437,'Ol Mahum Recruit',0,'',0,'LineageMonster.ol_mahum','13.50','25.00',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,917,42,'53.00000','99.00000','38.00000','60.00000',230,4,0,333,68,19,0,50,110,1,1,1,1),
(20438,20438,'Ol Mahum General',0,'',0,'LineageMonster.ol_mahum_champion','14.00','27.00',26,'male','L2Monster',40,'487.00000','248.00000','3.50000','1.50000',40,43,30,21,20,20,1294,65,'79.00000','121.00000','57.00000','73.00000',230,4,500,333,67,102,0,50,110,1,1,1,1),
(20439,20439,'Ol Mahum Officer',0,'',0,'LineageMonster.ol_mahum','13.50','25.00',24,'male','L2Monster',40,'435.00000','224.00000','3.50000','1.50000',40,43,30,21,20,20,1123,55,'68.00000','112.00000','48.00000','67.00000',230,4,0,333,66,0,0,50,110,1,1,1,1),
(20440,20440,'Elder Brown Fox',0,'',0,'LineageMonster.fox','9.50','10.00',3,'male','L2Monster',40,'58.00000','50.00000','2.00000','0.90000',40,43,30,21,20,20,88,2,'9.00000','44.00000','9.00000','27.00000',230,4,0,333,0,0,0,23,110,1,1,0,1),
(20441,20441,'Elder Longtail Fox',0,'',0,'LineageMonster.fox','9.50','10.00',3,'male','L2Monster',40,'58.00000','50.00000','2.00000','0.90000',40,43,30,21,20,20,88,2,'9.00000','44.00000','9.00000','27.00000',230,4,0,333,0,0,0,23,110,1,1,0,1),
(20442,20442,'Elder Wolf',0,'',0,'LineageMonster.wolf','13.00','9.00',5,'male','L2Monster',40,'80.00000','63.00000','2.00000','0.90000',40,43,30,21,20,20,176,5,'12.00000','49.00000','5.00000','30.00000',230,4,0,333,0,0,0,24,110,1,1,1,1),
(20443,20443,'Elder Red Fox',0,'',0,'LineageMonster.fox','9.50','10.00',3,'male','L2Monster',40,'58.00000','50.00000','2.00000','0.90000',40,43,30,21,20,20,88,2,'9.00000','44.00000','9.00000','27.00000',230,4,0,333,0,0,0,23,110,1,1,0,1),
(20444,20444,'Elder Prairie Fox',0,'',0,'LineageMonster.fox','9.50','10.00',3,'male','L2Monster',40,'58.00000','50.00000','2.00000','0.90000',40,43,30,21,20,20,88,2,'9.00000','44.00000','9.00000','27.00000',230,4,0,333,0,0,0,23,110,1,1,0,1),
(20445,20445,'Uthanka Pirate',0,'',0,'LineageMonster.orc','10.00','21.00',7,'male','L2Monster',40,'108.00000','77.00000','2.00000','0.90000',40,43,30,21,20,20,154,5,'14.00000','53.00000','6.00000','32.00000',230,4,0,333,3,0,0,45,110,1,1,0,1),
(20446,20446,'Utuku Orc',0,'',0,'LineageMonster.orc','10.00','21.00',6,'male','L2Monster',40,'94.00000','70.00000','2.00000','0.90000',40,43,30,21,20,20,214,6,'13.00000','51.00000','6.00000','31.00000',230,1,0,333,156,0,0,45,110,1,1,1,1),
(20447,20447,'Utuku Orc Archer',0,'',0,'LineageMonster.orc_archer','14.00','25.00',8,'male','L2Monster',1100,'125.00000','84.00000','2.00000','0.90000',40,43,30,21,20,20,293,10,'16.00000','56.00000','12.00000','34.00000',230,8,0,333,14,0,0,45,110,1,1,1,1),
(20448,20448,'Utuku Orc Grunt',0,'',0,'LineageMonster.orc','10.00','21.00',7,'male','L2Monster',40,'108.00000','77.00000','2.00000','0.90000',40,43,30,21,20,20,249,8,'14.00000','53.00000','6.00000','32.00000',230,4,0,333,3,0,0,45,110,1,1,1,1),
(20449,20449,'Will-O-Wisp',0,'',0,'LineageMonster.will_o_wisp','13.00','22.00',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,533,22,'31.00000','76.00000','23.00000','47.00000',230,4,0,333,0,0,0,80,140,1,1,0,1),
(20450,20450,'Relic Werewolf',0,'',0,'LineageMonster.werewolf','10.00','26.00',9,'male','L2Monster',40,'143.00000','92.00000','2.00000','0.90000',40,43,30,21,20,20,268,9,'18.00000','58.00000','14.00000','35.00000',230,1,0,333,0,0,0,50,120,1,1,0,1),
(20451,20451,'Relic Spartoi',0,'',0,'LineageMonster.spartoi','11.00','27.00',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,1422,65,'53.00000','99.00000','38.00000','60.00000',230,4,0,333,68,0,0,60,140,1,1,0,1),
(20453,20453,'Human Ghost',0,'',0,'LineageMonster.human_ghost','8.00','22.00',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,606,27,'48.00000','95.00000','30.00000','57.00000',230,4,500,333,0,0,0,80,140,1,1,0,1),
(20454,20454,'Oblivion Watcher',0,'',0,'LineageMonster.monster_eye','21.00','43.00',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,227,10,'37.00000','83.00000','27.00000','51.00000',230,1,0,333,0,0,0,90,90,1,1,0,1),
(20455,20455,'Doom Soldier',0,'',0,'LineageMonster.skeleton','11.00','25.00',14,'male','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,424,16,'28.00000','73.00000','16.00000','44.00000',230,8,500,333,946,0,0,60,140,1,1,0,1),
(20456,20456,'Ashen Wolf',0,'',0,'LineageMonster.wolf','13.00','9.00',4,'male','L2Monster',40,'68.00000','57.00000','2.00000','0.90000',40,43,30,21,20,20,141,4,'10.00000','46.00000','9.00000','28.00000',230,4,0,333,0,0,0,24,110,1,1,1,1),
(20457,20457,'Zombie Soldier',0,'',0,'LineageMonster.zombie','13.00','21.00',19,'male','L2Monster',40,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,959,43,'44.00000','91.00000','32.00000','55.00000',230,4,0,333,0,0,0,15,15,1,1,1,1),
(20458,20458,'Zombie Warrior',0,'',0,'LineageMonster.zombie_bi','13.00','27.50',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,1421,67,'57.00000','103.00000','36.00000','62.00000',230,4,500,333,0,0,0,15,15,1,1,1,1),
(20460,20460,'Crimson Spider',0,'',0,'LineageMonster.giant_spider','26.00','25.50',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,545,22,'31.00000','76.00000','23.00000','47.00000',230,4,500,333,0,0,0,72,130,1,1,1,1),
(20461,20461,'Dungeon Spider',0,'',0,'LineageMonster.giant_spider','26.00','25.50',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,454,19,'31.00000','76.00000','23.00000','47.00000',230,1,500,333,0,0,0,72,130,1,1,0,1),
(20462,20462,'Cave Blade Spider',0,'',0,'LineageMonster.giant_spider','26.00','25.50',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,515,22,'37.00000','83.00000','27.00000','51.00000',230,1,500,333,0,0,0,72,130,1,1,0,1),
(20463,20463,'Dungeon Skeleton Archer',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',13,'male','L2Monster',1100,'215.00000','120.00000','2.50000','1.20000',40,43,30,21,20,20,397,16,'25.00000','70.00000','15.00000','43.00000',230,8,0,333,275,0,0,40,140,1,1,0,1),
(20464,20464,'Dungeon Skeleton',0,'',0,'LineageMonster.skeleton','11.00','25.00',12,'male','L2Monster',40,'199.00000','113.00000','2.50000','1.20000',40,43,30,21,20,20,363,13,'23.00000','67.00000','17.00000','41.00000',230,8,500,333,946,0,0,60,140,1,1,0,1),
(20465,20465,'Prairie Fox',0,'',0,'LineageMonster.fox','9.50','10.00',2,'male','L2Monster',40,'48.00000','43.00000','2.00000','0.90000',40,43,30,21,20,20,59,2,'8.00000','42.00000','7.00000','25.00000',230,4,0,333,0,0,0,23,110,1,1,0,1),
(20466,20466,'Pincer Spider',0,'',0,'LineageMonster.giant_spider','26.00','25.50',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,618,26,'37.00000','83.00000','27.00000','51.00000',230,4,500,333,0,0,0,72,130,1,1,1,1),
(20468,20468,'Kaboo Orc',0,'',0,'LineageMonster.orc','10.00','21.00',6,'male','L2Monster',40,'94.00000','70.00000','2.00000','0.90000',40,43,30,21,20,20,214,6,'13.00000','51.00000','6.00000','31.00000',230,1,0,333,156,0,0,45,110,1,1,1,1),
(20469,20469,'Kaboo Orc Archer',0,'',0,'LineageMonster.orc_archer','14.00','25.00',8,'male','L2Monster',1100,'125.00000','84.00000','2.00000','0.90000',40,43,30,21,20,20,293,10,'16.00000','56.00000','12.00000','34.00000',230,8,0,333,14,0,0,45,110,1,1,1,1),
(20470,20470,'Kaboo Orc Grunt',0,'',0,'LineageMonster.orc','10.00','21.00',7,'male','L2Monster',40,'108.00000','77.00000','2.00000','0.90000',40,43,30,21,20,20,249,8,'14.00000','53.00000','6.00000','32.00000',230,4,0,333,3,0,0,45,110,1,1,1,1),
(20471,20471,'Kaboo Orc Fighter',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,363,12,'19.00000','61.00000','10.00000','37.00000',230,4,500,333,2,0,0,45,110,1,1,1,1),
(20472,20472,'Kaboo Orc Fighter Leader',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',12,'male','L2Monster',40,'199.00000','113.00000','2.50000','1.20000',40,43,30,21,20,20,436,16,'23.00000','67.00000','17.00000','41.00000',230,4,500,333,2,0,0,45,110,1,1,1,1),
(20473,20473,'Kaboo Orc Fighter Lieutenant',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',11,'male','L2Monster',40,'185.00000','106.00000','2.50000','1.20000',40,43,30,21,20,20,392,15,'21.00000','64.00000','11.00000','39.00000',230,4,0,333,2,0,0,45,110,1,1,1,1),
(20474,20474,'Kasha Spider',0,'',0,'LineageMonster.giant_spider','26.00','25.50',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,534,22,'31.00000','76.00000','23.00000','47.00000',230,4,0,333,0,0,0,72,130,1,1,1,1),
(20475,20475,'Kasha Wolf',0,'',0,'LineageMonster.wolf','13.00','9.00',4,'male','L2Monster',40,'68.00000','57.00000','2.00000','0.90000',40,43,30,21,20,20,141,4,'10.00000','46.00000','9.00000','28.00000',230,4,0,333,0,0,0,24,110,1,1,1,1),
(20476,20476,'Kasha Fang Spider',0,'',0,'LineageMonster.giant_spider','26.00','25.50',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,571,23,'33.00000','80.00000','20.00000','48.00000',230,4,0,333,0,0,0,72,130,1,1,1,1),
(20477,20477,'Kasha Timber Wolf',0,'',0,'LineageMonster.wolf_bi','13.00','10.80',6,'male','L2Monster',40,'94.00000','70.00000','2.00000','0.90000',40,43,30,21,20,20,212,6,'13.00000','51.00000','6.00000','31.00000',230,4,0,333,0,0,0,24,110,1,1,1,1),
(20478,20478,'Kasha Blade Spider',0,'',0,'LineageMonster.giant_spider','26.00','25.50',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,667,28,'37.00000','83.00000','27.00000','51.00000',230,4,0,333,0,0,0,72,130,1,1,1,1),
(20479,20479,'Kasha Bear',0,'',0,'LineageMonster.grizzly_bi','21.00','50.00',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,540,22,'31.00000','76.00000','23.00000','47.00000',230,4,500,333,0,0,0,40,110,1,1,1,1),
(20480,20480,'Blade Bat',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,356,12,'19.00000','61.00000','10.00000','37.00000',230,4,0,333,0,0,0,60,80,1,1,1,1),
(20481,20481,'Bearded Keltir',0,'',0,'LineageMonster.keltir','9.50','10.00',1,'male','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,35,2,'8.00000','40.00000','7.00000','25.00000',230,4,0,333,0,0,0,23,110,1,1,1,1),
(20483,20483,'Corpse Candle',0,'',0,'LineageMonster.will_o_wisp','13.00','22.00',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,604,25,'37.00000','83.00000','27.00000','51.00000',230,4,0,333,0,0,0,80,140,1,1,0,1),
(20487,20487,'Kuruka Ratman',0,'',0,'LineageMonster.wererat','14.00','25.00',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,476,19,'33.00000','80.00000','20.00000','48.00000',230,8,0,333,216,0,0,80,120,1,1,0,1),
(20488,20488,'Kuruka Ratman Hunter',0,'',0,'LineageMonster.wererat','14.00','25.00',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,505,21,'37.00000','83.00000','27.00000','51.00000',230,4,0,333,3,0,0,80,120,1,1,0,1),
(20489,20489,'Quicksilver Beast',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,450,18,'31.00000','76.00000','23.00000','47.00000',230,4,500,333,0,0,0,30,120,1,1,0,1),
(20490,20490,'Death Doll',0,'',0,'LineageMonster.crimson_doll','15.00','38.00',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,2611,169,'226.00000','202.00000','157.00000','122.00000',230,4,500,333,0,0,0,60,150,1,1,0,1),
(20491,20491,'Crypt Horror',0,'',0,'LineageMonster.dark_horror','20.00','35.00',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,454,19,'31.00000','76.00000','23.00000','47.00000',230,4,500,333,0,0,0,100,100,1,1,0,1),
(20492,20492,'Kirunak\'s Guards',0,'',0,'LineageMonster.spartoi','11.00','27.00',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,764,35,'53.00000','99.00000','38.00000','60.00000',230,4,0,333,68,0,0,60,140,1,1,0,1),
(20494,20494,'Turek War Hound',0,'',0,'LineageMonster.dire_wolf','13.00','11.00',24,'male','L2Monster',40,'435.00000','224.00000','3.50000','1.50000',40,43,30,21,20,20,2088,103,'68.00000','112.00000','48.00000','67.00000',230,4,0,333,0,0,0,24,110,1,1,0,1),
(20495,20495,'Turek Orc Warlord',0,'',0,'LineageMonster.orc_champion','10.00','23.00',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,3338,182,'109.00000','141.00000','77.00000','85.00000',230,4,500,333,127,0,0,45,130,1,1,0,1),
(20496,20496,'Turek Orc Archer',0,'',0,'LineageMonster.orc_archer','14.00','25.00',27,'male','L2Monster',1100,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,2585,132,'87.00000','126.00000','62.00000','76.00000',230,8,0,333,14,0,0,45,110,1,1,0,1),
(20497,20497,'Turek Orc Skirmisher',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',28,'male','L2Monster',40,'544.00000','274.00000','3.50000','1.50000',40,43,30,21,20,20,2682,140,'93.00000','131.00000','67.00000','80.00000',230,4,500,333,121,0,0,45,110,1,1,0,1),
(20498,20498,'Turek Orc Supplier',0,'',0,'LineageMonster.orc_fighter','12.00','22.00',27,'male','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,2485,127,'87.00000','126.00000','62.00000','76.00000',230,8,0,333,11,0,0,45,110,1,1,0,1),
(20499,20499,'Turek Orc Footman',0,'',0,'LineageMonster.orc','10.00','21.00',26,'male','L2Monster',40,'487.00000','248.00000','3.50000','1.50000',40,43,30,21,20,20,2359,119,'79.00000','121.00000','57.00000','73.00000',230,4,0,333,2,0,0,45,110,1,1,0,1),
(20500,20500,'Turek Orc Sentinel',0,'',0,'LineageMonster.orc','10.00','21.00',25,'male','L2Monster',40,'461.00000','236.00000','3.50000','1.50000',40,43,30,21,20,20,2215,110,'73.00000','116.00000','52.00000','70.00000',230,4,0,333,3,0,0,45,110,1,1,0,1),
(20501,20501,'Turek Orc Shaman',0,'',0,'LineageMonster.orc_shaman','9.00','22.00',29,'male','L2Monster',40,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,2776,149,'101.00000','136.00000','72.00000','82.00000',230,1,0,333,7,0,0,45,120,1,1,0,1),
(20502,20502,'Twink Puma',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,540,22,'31.00000','76.00000','23.00000','47.00000',230,4,500,333,0,0,0,30,120,1,1,1,1),
(20504,20504,'Dread Soldier',0,'',0,'LineageMonster.skeleton','11.00','25.00',14,'male','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,424,16,'28.00000','73.00000','16.00000','44.00000',230,8,500,333,946,0,0,60,140,1,1,0,1),
(20505,20505,'Ruin Bat',0,'',0,'LineageMonster.vampire_bat_bi','10.00','42.00',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,713,32,'48.00000','95.00000','30.00000','57.00000',230,4,0,333,0,0,0,60,80,1,1,1,1),
(20506,20506,'Ruin Imp',0,'',0,'LineageMonster.imp_bi','10.00','30.00',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,606,25,'37.00000','83.00000','27.00000','51.00000',230,4,0,333,0,0,0,60,80,1,1,1,1),
(20507,20507,'Ruin Imp Elder',0,'',0,'LineageMonster.imp_bi','10.00','30.00',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,936,43,'53.00000','99.00000','38.00000','60.00000',230,4,500,333,0,0,0,60,80,1,1,1,1),
(20508,20508,'Plunder Tarantula',0,'',0,'LineageMonster.giant_spider','26.00','25.50',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,618,26,'37.00000','83.00000','27.00000','51.00000',230,4,500,333,0,0,0,72,130,1,1,1,1),
(20509,20509,'Spore Fungus',0,'',0,'LineageMonster.walking_fungus','15.00','22.50',9,'male','L2Monster',40,'143.00000','92.00000','2.00000','0.90000',40,43,30,21,20,20,321,11,'18.00000','58.00000','14.00000','35.00000',230,4,0,333,0,0,0,70,110,1,1,1,1),
(20510,20510,'Puma',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',12,'male','L2Monster',40,'199.00000','113.00000','2.50000','1.20000',40,43,30,21,20,20,423,16,'23.00000','67.00000','17.00000','41.00000',230,4,0,333,0,0,0,30,120,1,1,1,1),
(20511,20511,'Pitchstone Golem',0,'',0,'LineageMonster.stone_golem','20.00','31.00',19,'male','L2Monster',40,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,799,36,'44.00000','91.00000','32.00000','55.00000',230,4,0,333,0,0,0,23,23,1,1,0,1),
(20512,20512,'Field Stalker',0,'',0,'LineageMonster.field_stalker','16.00','36.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,2175,128,'159.00000','170.00000','111.00000','102.00000',230,4,500,333,0,0,0,70,110,1,1,0,1),
(20513,20513,'Skeleton Knight',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',32,'male','L2Monster',40,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,1519,85,'128.00000','152.00000','85.00000','92.00000',230,4,500,333,150,0,0,40,160,1,1,0,1),
(20514,20514,'Shield Skeleton',0,'',0,'LineageMonster.skeleton','11.00','25.00',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,534,22,'31.00000','76.00000','23.00000','47.00000',230,1,0,333,157,103,0,60,140,1,1,1,1),
(20515,20515,'Skeleton Infantryman',0,'',0,'LineageMonster.skeleton','11.00','25.00',16,'male','L2Monster',40,'265.00000','143.00000','2.50000','1.20000',40,43,30,21,20,20,571,23,'33.00000','80.00000','20.00000','48.00000',230,1,0,333,157,18,0,60,140,1,1,1,1),
(20516,20516,'Skeleton Sentinel',0,'',0,'LineageMonster.skeleton_bi','11.00','31.00',14,'male','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,424,16,'28.00000','73.00000','16.00000','44.00000',230,8,500,333,946,0,0,60,140,1,1,0,1),
(20517,20517,'Skeleton Hunter',0,'',0,'LineageMonster.skeleton','11.00','25.00',12,'male','L2Monster',40,'199.00000','113.00000','2.50000','1.20000',40,43,30,21,20,20,363,13,'23.00000','67.00000','17.00000','41.00000',230,8,500,333,946,0,0,60,140,1,1,0,1),
(20518,20518,'Skeleton Hunter Archer',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',13,'male','L2Monster',1100,'215.00000','120.00000','2.50000','1.20000',40,43,30,21,20,20,397,16,'25.00000','70.00000','15.00000','43.00000',230,8,0,333,275,0,0,40,140,1,1,0,1),
(20519,20519,'Skeleton Pikeman',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',27,'male','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,1136,58,'87.00000','126.00000','62.00000','76.00000',230,4,500,333,299,0,0,50,155,1,1,0,1),
(20520,20520,'Pirate Captain Uthanka',0,'',0,'LineageMonster.orc_fighter_bi','12.00','26.40',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,926,32,'19.00000','61.00000','10.00000','37.00000',230,1,500,333,2,0,0,45,110,1,1,0,1),
(20521,20521,'Whinstone Golem',0,'',0,'LineageMonster.stone_golem','20.00','31.00',14,'male','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,705,27,'28.00000','73.00000','16.00000','44.00000',230,4,0,333,0,0,0,23,23,1,1,1,1),
(20522,20522,'White Fang',0,'',0,'LineageMonster.wolf_bi','13.00','10.80',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,917,31,'19.00000','61.00000','10.00000','37.00000',230,1,500,333,0,0,0,24,110,1,1,0,1),
(20524,20524,'Grey Wolf Elder',0,'',0,'LineageMonster.wolf','13.00','9.00',7,'male','L2Monster',40,'108.00000','77.00000','2.00000','0.90000',40,43,30,21,20,20,152,5,'14.00000','53.00000','6.00000','32.00000',230,1,0,333,0,0,0,24,110,1,1,0,1),
(20525,20525,'Gray Wolf',0,'',0,'LineageMonster.wolf','13.00','9.00',4,'male','L2Monster',40,'68.00000','57.00000','2.00000','0.90000',40,43,30,21,20,20,141,4,'10.00000','46.00000','9.00000','28.00000',230,4,0,333,0,0,0,24,110,1,1,1,1),
(20526,20526,'Obsidian Golem',0,'',0,'LineageMonster.stone_golem','20.00','31.00',15,'male','L2Monster',40,'247.00000','136.00000','2.50000','1.20000',40,43,30,21,20,20,756,31,'31.00000','76.00000','23.00000','47.00000',230,4,0,333,0,0,0,23,23,1,1,1,1),
(20527,20527,'Great Snow Wolf',0,'',0,'LineageMonster.dire_wolf','13.00','11.00',4,'male','L2Monster',40,'68.00000','57.00000','2.00000','0.90000',40,43,30,21,20,20,121,3,'10.00000','46.00000','9.00000','28.00000',230,4,500,333,0,0,0,24,110,1,1,0,1),
(20528,20528,'Goblin Lord',0,'',0,'LineageMonster.goblin','10.00','16.50',13,'male','L2Monster',40,'215.00000','120.00000','2.50000','1.20000',40,43,30,21,20,20,458,18,'25.00000','70.00000','15.00000','43.00000',230,8,0,333,217,0,0,40,110,1,1,1,1),
(20529,20529,'Young Brown Keltir',0,'',0,'LineageMonster.keltir','9.50','10.00',1,'male','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,35,2,'8.00000','40.00000','7.00000','25.00000',230,4,0,333,0,0,0,23,110,1,1,1,1),
(20530,20530,'Young Red Keltir',0,'',0,'LineageMonster.keltir','9.50','10.00',1,'male','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,35,2,'8.00000','40.00000','7.00000','25.00000',230,4,0,333,0,0,0,23,110,1,1,1,1),
(20531,20531,'Young Prairie Keltir',0,'',0,'LineageMonster.keltir','9.50','10.00',1,'male','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,35,2,'8.00000','40.00000','7.00000','25.00000',230,4,0,333,0,0,0,23,110,1,1,1,1),
(20532,20532,'Brown Keltir',0,'',0,'LineageMonster.keltir','9.50','10.00',2,'male','L2Monster',40,'48.00000','43.00000','2.00000','0.90000',40,43,30,21,20,20,71,2,'8.00000','42.00000','7.00000','25.00000',230,4,0,333,0,0,0,23,110,1,1,1,1),
(20533,20533,'Longtail Keltir',0,'',0,'LineageMonster.keltir','9.50','10.00',2,'male','L2Monster',40,'48.00000','43.00000','2.00000','0.90000',40,43,30,21,20,20,71,2,'8.00000','42.00000','7.00000','25.00000',230,4,0,333,0,0,0,23,110,1,1,1,1),
(20534,20534,'Red Keltir',0,'',0,'LineageMonster.keltir','9.50','10.00',2,'male','L2Monster',40,'48.00000','43.00000','2.00000','0.90000',40,43,30,21,20,20,71,2,'8.00000','42.00000','7.00000','25.00000',230,4,0,333,0,0,0,23,110,1,1,1,1),
(20535,20535,'Prairie Keltir',0,'',0,'LineageMonster.keltir','9.50','10.00',2,'male','L2Monster',40,'48.00000','43.00000','2.00000','0.90000',40,43,30,21,20,20,71,2,'8.00000','42.00000','7.00000','25.00000',230,4,0,333,0,0,0,23,110,1,1,1,1),
(20536,20536,'Elder Brown Keltir',0,'',0,'LineageMonster.keltir','9.50','10.00',3,'male','L2Monster',40,'58.00000','50.00000','2.00000','0.90000',40,43,30,21,20,20,106,2,'9.00000','44.00000','9.00000','27.00000',230,4,0,333,0,0,0,23,110,1,1,1,1),
(20537,20537,'Elder Red Keltir',0,'',0,'LineageMonster.keltir','9.50','10.00',3,'male','L2Monster',40,'58.00000','50.00000','2.00000','0.90000',40,43,30,21,20,20,106,2,'9.00000','44.00000','9.00000','27.00000',230,4,0,333,0,0,0,23,110,1,1,1,1),
(20538,20538,'Elder Prairie Keltir',0,'',0,'LineageMonster.keltir','9.50','10.00',3,'male','L2Monster',40,'58.00000','50.00000','2.00000','0.90000',40,43,30,21,20,20,106,2,'9.00000','44.00000','9.00000','27.00000',230,4,0,333,0,0,0,23,110,1,1,1,1),
(20539,20539,'Elder Longtail Keltir',0,'',0,'LineageMonster.keltir','9.50','10.00',3,'male','L2Monster',40,'58.00000','50.00000','2.00000','0.90000',40,43,30,21,20,20,106,2,'9.00000','44.00000','9.00000','27.00000',230,4,0,333,0,0,0,23,110,1,1,1,1),
(20540,20540,'Gemstone Beast',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',12,'male','L2Monster',40,'199.00000','113.00000','2.50000','1.20000',40,43,30,21,20,20,353,13,'23.00000','67.00000','17.00000','41.00000',230,4,0,333,0,0,0,30,120,1,1,0,1),
(20541,20541,'Ore Bat',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,500,21,'37.00000','83.00000','27.00000','51.00000',230,4,0,333,0,0,0,60,80,1,1,0,1),
(20542,20542,'Skeleton Longbowman',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',19,'male','L2Monster',1100,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,588,26,'44.00000','91.00000','32.00000','55.00000',230,8,500,333,275,0,0,40,140,1,1,0,1),
(20543,20543,'Ghost',0,'',0,'LineageMonster.human_ghost','8.00','22.00',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,600,27,'48.00000','95.00000','30.00000','57.00000',230,4,500,333,0,0,0,80,140,1,1,0,1),
(20544,20544,'Elder Keltir',0,'',0,'LineageMonster.keltir','9.50','10.00',3,'male','L2Monster',40,'58.00000','50.00000','2.00000','0.90000',40,43,30,21,20,20,106,2,'9.00000','44.00000','9.00000','27.00000',230,4,0,333,0,0,0,23,110,1,1,1,1),
(20545,20545,'Young Keltir',0,'',0,'LineageMonster.keltir','9.50','10.00',1,'male','L2Monster',40,'40.00000','36.00000','2.00000','0.90000',40,43,30,21,20,20,35,2,'8.00000','40.00000','7.00000','25.00000',230,4,0,333,0,0,0,23,110,1,1,1,1),
(20546,20546,'Turek Orc Elder',0,'',0,'LineageMonster.orc_shaman','9.00','22.00',34,'male','L2Monster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,2058,120,'148.00000','164.00000','99.00000','99.00000',230,1,500,333,7,0,0,45,120,1,1,0,1),
(20547,20547,'Ol Mahum Reserve',0,'',0,'LineageMonster.ol_mahum_bi','13.50','29.20',23,'male','L2Monster',40,'411.00000','211.00000','3.50000','1.50000',40,43,30,21,20,20,1054,50,'62.00000','107.00000','40.00000','65.00000',230,4,0,333,2,0,0,50,110,1,1,1,1),
(20548,20548,'Ol Mahum Deserter',0,'',0,'LineageMonster.ol_mahum','13.50','25.00',23,'male','L2Monster',40,'411.00000','211.00000','3.50000','1.50000',40,43,30,21,20,20,1075,52,'62.00000','107.00000','40.00000','65.00000',230,4,500,333,2,0,0,50,110,1,1,1,1),
(20549,20549,'Ol Mahum Lord',0,'',0,'LineageMonster.ol_mahum_champion','14.00','27.00',34,'male','L2Monster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,4233,247,'148.00000','164.00000','99.00000','99.00000',230,4,500,333,69,19,0,50,110,1,1,1,1),
(20550,20550,'Guardian Basilisk',0,'',0,'LineageMonster.lesser_basilisk','34.00','25.00',36,'male','L2Monster',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,2352,142,'171.00000','176.00000','115.00000','107.00000',230,4,0,333,0,0,0,35,174,1,1,1,1),
(20551,20551,'Road Scavenger',0,'',0,'LineageMonster.wererat','14.00','25.00',37,'male','L2Monster',40,'847.00000','393.00000','4.50000','1.80000',40,43,30,21,20,20,2389,146,'183.00000','182.00000','123.00000','111.00000',230,8,0,333,221,0,0,80,174,1,1,1,1),
(20552,20552,'Fettered Soul',0,'',0,'LineageMonster.binding','12.00','21.00',38,'male','L2Monster',40,'886.00000','407.00000','4.50000','1.80000',40,43,30,21,20,20,5152,322,'197.00000','189.00000','137.00000','114.00000',230,4,0,333,0,0,0,10,174,1,1,1,1),
(20553,20553,'Windsus',0,'',0,'LineageMonster.giant_wild_hog','25.00','27.00',39,'male','L2Monster',40,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,2655,169,'211.00000','195.00000','147.00000','118.00000',230,4,0,333,0,0,0,35,174,1,1,1,1),
(20554,20554,'Grandis',0,'',0,'LineageMonster.twin_headed_giant','17.00','39.00',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,3102,200,'226.00000','202.00000','157.00000','122.00000',230,4,500,333,0,0,0,45,174,1,1,1,1),
(20555,20555,'Giant Fungus',0,'',0,'LineageMonster.walking_fungus_bi','15.00','31.30',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,2792,180,'226.00000','202.00000','157.00000','122.00000',230,4,0,333,0,0,0,70,174,1,1,1,1),
(20556,20556,'Giant Monstereye',0,'',0,'LineageMonster.monster_eye_bi','29.00','60.00',41,'male','L2Monster',40,'1008.00000','459.00000','5.50000','2.10000',40,43,30,21,20,20,2934,192,'241.00000','209.00000','163.00000','126.00000',230,4,0,333,0,0,0,90,174,1,1,1,1),
(20557,20557,'Dire Wyrm',0,'',0,'LineageMonster.wyrm','29.00','72.00',42,'male','L2Monster',40,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,3109,208,'258.00000','216.00000','174.00000','131.00000',230,4,500,333,0,0,0,70,174,1,1,1,1),
(20558,20558,'Rotting tree',0,'',0,'LineageMonster.hanged_man_ripper','35.00','80.00',43,'male','L2Monster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,3195,216,'275.00000','223.00000','191.00000','135.00000',230,4,0,333,0,0,0,55,174,1,1,1,1),
(20559,20559,'Rotting Golem',0,'',0,'LineageMonster.stone_golem_bi_one','20.00','43.40',44,'male','L2Monster',40,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,4730,324,'293.00000','231.00000','199.00000','139.00000',230,4,0,333,0,0,0,23,23,1,1,1,1),
(20560,20560,'Trisalim Spider',0,'',0,'LineageMonster.giant_spider','26.00','25.50',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,3499,244,'313.00000','238.00000','212.00000','144.00000',230,4,0,333,0,0,0,72,174,1,1,1,1),
(20561,20561,'Trisalim Tarantula',0,'',0,'LineageMonster.poison_spider','27.00','25.50',46,'male','L2Monster',40,'1230.00000','580.00000','5.50000','2.10000',40,43,30,21,20,20,4144,294,'332.00000','246.00000','231.00000','149.00000',230,4,500,333,0,0,0,60,174,1,1,1,1),
(20562,20562,'Spore Zombie',0,'',0,'LineageMonster.zombie_bi','13.00','27.50',47,'male','L2Monster',40,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,4310,308,'353.00000','254.00000','244.00000','154.00000',230,4,0,333,0,0,0,15,15,1,1,1,1),
(20563,20563,'Manashen Gargoyle',0,'',0,'LineageMonster.gargoyle','16.00','50.00',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,3323,215,'226.00000','202.00000','157.00000','122.00000',230,4,0,333,0,0,0,140,174,1,1,1,1),
(20564,20564,'Enchanted Monstereye',0,'',0,'LineageMonster.monster_eye','21.00','43.00',41,'male','L2Monster',40,'1008.00000','459.00000','5.50000','2.10000',40,43,30,21,20,20,2992,196,'241.00000','209.00000','163.00000','126.00000',230,4,500,333,0,0,0,90,174,1,1,1,1),
(20565,20565,'Enchanted Stone Golem',0,'',0,'LineageMonster.stone_golem_bi','20.00','40.30',42,'male','L2Monster',40,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,4353,290,'258.00000','216.00000','174.00000','131.00000',230,4,0,333,0,0,0,23,23,1,1,1,1),
(20566,20566,'Enchanted Iron Golem',0,'',0,'LineageMonster.iron_golem','18.00','34.00',43,'male','L2Monster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,4563,308,'275.00000','223.00000','191.00000','135.00000',230,4,0,333,0,0,0,20,20,1,1,1,1),
(20567,20567,'Enchanted Gargoyle',0,'',0,'LineageMonster.gargoyle','16.00','50.00',44,'male','L2Monster',40,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,4021,275,'293.00000','231.00000','199.00000','139.00000',230,4,0,333,0,0,0,140,174,1,1,1,1),
(20568,20568,'Formor',0,'',0,'LineageMonster.troll','21.00','35.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,3534,246,'313.00000','238.00000','212.00000','144.00000',230,4,0,333,0,0,0,55,174,1,1,1,1),
(20569,20569,'Formor Elder',0,'',0,'LineageMonster.troll','21.00','35.00',46,'male','L2Monster',40,'1230.00000','580.00000','5.50000','2.10000',40,43,30,21,20,20,3841,272,'332.00000','246.00000','231.00000','149.00000',230,4,0,333,0,0,0,55,174,1,1,1,1),
(20570,20570,'Tarlk Bugbear',0,'',0,'LineageMonster.bugbear','17.00','35.00',47,'male','L2Monster',40,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,3855,276,'353.00000','254.00000','244.00000','154.00000',230,1,0,333,88,0,0,55,174,1,1,1,1),
(20571,20571,'Tarlk Bugbear Warrior',0,'',0,'LineageMonster.bugbear','17.00','35.00',48,'male','L2Monster',40,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,4553,332,'375.00000','262.00000','260.00000','159.00000',230,1,500,333,169,0,0,55,174,1,1,1,1),
(20572,20572,'Tarlk Bugbear High Warrior',0,'',0,'LineageMonster.king_bugbear','15.00','40.00',49,'male','L2Monster',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,4987,368,'398.00000','270.00000','275.00000','164.00000',230,1,0,333,160,0,0,55,174,1,1,1,1),
(20573,20573,'Tarlk Basilisk',0,'',0,'LineageMonster.lesser_basilisk','34.00','25.00',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,4288,323,'421.00000','278.00000','286.00000','185.00000',230,4,0,333,0,0,0,35,100,1,1,1,1),
(20574,20574,'Elder Tarlk Basilisk',0,'',0,'LineageMonster.lesser_basilisk','34.00','25.00',51,'male','L2Monster',40,'1470.00000','706.00000','6.50000','2.40000',40,43,30,21,20,20,4506,343,'446.00000','287.00000','309.00000','191.00000',230,4,500,333,0,0,0,35,100,1,1,1,1),
(20575,20575,'Oel Mahum Warrior',0,'',0,'LineageMonster.oel_mahum_warrior','20.00','38.00',54,'male','L2Monster',40,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,5051,402,'526.00000','313.00000','364.00000','208.00000',230,4,0,333,72,0,0,70,160,1,1,1,1),
(20576,20576,'Oel Mahum Witch Doctor',0,'',0,'LineageMonster.oel_mahum_witch_doctor','15.00','34.00',55,'male','L2Monster',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,10289,791,'554.00000','322.00000','384.00000','215.00000',230,1,0,333,201,0,0,70,130,1,1,1,1),
(20577,20577,'Leto Lizardman',0,'',0,'LineageMonster.zenta_lizardman','11.00','32.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,2138,126,'159.00000','170.00000','111.00000','102.00000',230,4,0,333,66,0,0,37,174,1,1,1,1),
(20578,20578,'Leto Lizardman Archer',0,'',0,'LineageMonster.zenta_lizardman_scout','11.00','30.00',36,'male','L2Monster',1100,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,2330,140,'171.00000','176.00000','115.00000','107.00000',230,8,0,333,14,0,0,37,174,1,1,1,1),
(20579,20579,'Leto Lizardman Soldier',0,'',0,'LineageMonster.zenta_lizardman','11.00','32.00',37,'male','L2Monster',40,'847.00000','393.00000','4.50000','1.80000',40,43,30,21,20,20,2437,150,'183.00000','182.00000','123.00000','111.00000',230,4,500,333,68,0,0,37,174,1,1,1,1),
(20580,20580,'Leto Lizardman Warrior',0,'',0,'LineageMonster.zenta_lizardman_warrior','13.00','35.00',38,'male','L2Monster',40,'886.00000','407.00000','4.50000','1.80000',40,43,30,21,20,20,4688,292,'197.00000','189.00000','137.00000','114.00000',230,4,0,333,93,0,0,40,174,1,1,1,1),
(20581,20581,'Leto Lizardman Shaman',0,'',0,'LineageMonster.zenta_lizardman_shaman','13.00','35.00',39,'male','L2Monster',40,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,2655,169,'211.00000','195.00000','147.00000','118.00000',230,1,0,333,159,0,0,43,174,1,1,1,1),
(20582,20582,'Leto Lizardman Overlord',0,'',0,'LineageMonster.zenta_lizardman_matriarch','20.00','40.00',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,5298,342,'226.00000','202.00000','157.00000','122.00000',230,8,500,333,221,0,0,53,174,1,1,1,1),
(20583,20583,'Timak Orc',0,'',0,'LineageMonster.batur_orc','9.00','21.50',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,2792,180,'226.00000','202.00000','157.00000','122.00000',230,4,0,333,2,0,0,80,174,1,1,1,1),
(20584,20584,'Timak Orc Archer',0,'',0,'LineageMonster.batur_orc_archer','11.00','21.50',41,'male','L2Monster',1100,'1008.00000','459.00000','5.50000','2.10000',40,43,30,21,20,20,3783,247,'241.00000','209.00000','163.00000','126.00000',230,8,0,333,14,0,0,45,174,1,1,1,1),
(20585,20585,'Timak Orc Soldier',0,'',0,'LineageMonster.batur_orc','9.00','21.50',42,'male','L2Monster',40,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,3737,248,'258.00000','216.00000','174.00000','131.00000',230,4,500,333,66,0,0,80,174,1,1,1,1),
(20586,20586,'Timak Orc Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10.00','20.00',43,'male','L2Monster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,3582,242,'275.00000','223.00000','191.00000','135.00000',230,4,0,333,68,0,0,80,174,1,1,1,1),
(20587,20587,'Timak Orc Shaman',0,'',0,'LineageMonster.batur_orc_shaman','11.00','16.00',44,'male','L2Monster',40,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,3379,232,'293.00000','231.00000','199.00000','139.00000',230,1,0,333,179,0,0,50,174,1,1,1,1),
(20588,20588,'Timak Orc Overlord',0,'',0,'LineageMonster.batur_orc_overlord','12.00','24.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,4441,308,'313.00000','238.00000','212.00000','144.00000',230,4,500,333,127,0,0,80,174,1,1,1,1),
(20589,20589,'Fline',0,'',0,'LineageMonster.sylph','11.00','35.00',45,'female','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,6639,462,'313.00000','238.00000','212.00000','144.00000',230,4,0,333,0,0,0,60,174,1,1,0,1),
(20590,20590,'Liele',0,'',0,'LineageMonster.undine','12.00','27.00',46,'female','L2Monster',40,'1230.00000','580.00000','5.50000','2.10000',40,43,30,21,20,20,6869,487,'332.00000','246.00000','231.00000','149.00000',230,4,0,333,0,0,0,60,174,1,1,0,1),
(20591,20591,'Valley Treant',0,'',0,'LineageMonster.ti_mi_tran','23.00','90.00',47,'male','L2Monster',40,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,10140,727,'353.00000','254.00000','244.00000','154.00000',230,4,0,333,0,0,0,12,12,1,1,0,1),
(20592,20592,'Satyr',0,'',0,'LineageMonster.pan','14.00','35.00',48,'male','L2Monster',40,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,11074,809,'375.00000','262.00000','260.00000','159.00000',230,4,500,333,291,0,0,45,174,1,1,0,1),
(20593,20593,'Unicorn',0,'',0,'LineageMonster.unicorn','14.00','30.00',49,'male','L2Monster',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,11880,878,'398.00000','270.00000','275.00000','164.00000',230,4,0,333,0,0,0,46,174,1,1,0,1),
(20594,20594,'Forest Runner',0,'',0,'LineageMonster.mandragora_b','12.00','25.50',50,'female','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,8116,611,'421.00000','278.00000','286.00000','169.00000',230,4,0,333,0,0,0,80,174,1,1,0,1),
(20595,20595,'Fline Elder',0,'',0,'LineageMonster.sylph','11.00','35.00',51,'female','L2Monster',40,'1470.00000','706.00000','6.50000','2.40000',40,43,30,21,20,20,8443,644,'446.00000','287.00000','309.00000','174.00000',230,4,0,333,0,0,0,60,174,1,1,0,1),
(20596,20596,'Liele Elder',0,'',0,'LineageMonster.undine','12.00','27.00',52,'female','L2Monster',40,'1520.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,8953,692,'472.00000','295.00000','321.00000','179.00000',230,4,500,333,0,0,0,60,174,1,1,0,1),
(20597,20597,'Valley Treant Elder',0,'',0,'LineageMonster.ti_mi_tran','23.00','90.00',53,'male','L2Monster',40,'1571.00000','757.00000','6.50000','2.40000',40,43,30,21,20,20,18717,1471,'498.00000','304.00000','344.00000','184.00000',230,4,0,333,0,0,0,12,12,1,1,0,1),
(20598,20598,'Satyr Elder',0,'',0,'LineageMonster.pan','14.00','35.00',54,'male','L2Monster',40,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,13741,1096,'526.00000','313.00000','364.00000','189.00000',230,4,0,333,297,0,0,45,174,1,1,0,1),
(20599,20599,'Unicorn Elder',0,'',0,'LineageMonster.unicorn','14.00','30.00',55,'male','L2Monster',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,14255,1151,'554.00000','322.00000','384.00000','195.00000',230,4,0,333,0,0,0,46,174,1,1,0,1),
(20600,20600,'Karul Bugbear',0,'',0,'LineageMonster.bugbear','17.00','35.00',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,3290,212,'226.00000','202.00000','157.00000','122.00000',230,1,0,333,88,0,0,55,174,1,1,1,1),
(20601,20601,'Tamlin Orc',0,'',0,'LineageMonster.batur_orc','9.00','21.50',41,'male','L2Monster',40,'1008.00000','459.00000','5.50000','2.10000',40,43,30,21,20,20,2934,192,'241.00000','209.00000','163.00000','126.00000',230,4,0,333,2,0,0,80,174,1,1,1,1),
(20602,20602,'Tamlin Orc Archer',0,'',0,'LineageMonster.batur_orc_archer','11.00','21.50',42,'male','L2Monster',1100,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,3970,264,'258.00000','216.00000','174.00000','131.00000',230,8,0,333,14,0,0,45,174,1,1,1,1),
(20603,20603,'Kronbe Spider',0,'',0,'LineageMonster.giant_spider','26.00','25.50',43,'male','L2Monster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,3259,221,'275.00000','223.00000','191.00000','135.00000',230,4,500,333,0,0,0,72,174,1,1,1,1),
(20604,20604,'Rakin',0,'',0,'LineageMonster.twin_headed_giant','17.00','39.00',44,'male','L2Monster',40,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,3981,272,'293.00000','231.00000','199.00000','139.00000',230,1,0,333,89,0,0,45,174,1,1,1,1),
(20605,20605,'Weird Drake',0,'',0,'LineageMonster.drake','30.00','100.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,3605,251,'313.00000','238.00000','212.00000','144.00000',230,4,500,333,0,0,0,70,174,1,1,1,1),
(20606,20606,'Kuran Kobold',0,'',0,'LineageMonster.kobold','10.00','15.00',27,'male','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,2282,116,'87.00000','126.00000','62.00000','76.00000',230,4,0,333,0,0,0,47,110,1,1,0,1),
(20607,20607,'Kuran Kobold Warrior',0,'',0,'LineageMonster.kobold','10.00','15.00',28,'male','L2Monster',40,'544.00000','274.00000','3.50000','1.50000',40,43,30,21,20,20,2415,127,'93.00000','131.00000','67.00000','80.00000',230,4,0,333,0,0,0,47,110,1,1,0,1),
(20608,20608,'Patin Archer',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',29,'male','L2Monster',1100,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,2454,132,'101.00000','136.00000','72.00000','82.00000',230,8,500,333,14,0,0,40,140,1,1,0,1),
(20609,20609,'Rakin Salamander',0,'',0,'LineageMonster.salamander','16.00','6.80',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,2566,140,'109.00000','141.00000','77.00000','85.00000',230,1,0,333,0,0,0,64,96,1,1,0,1),
(20610,20610,'Sentinel Of Water',0,'',0,'LineageMonster.monster_eye','21.00','43.00',31,'male','L2Monster',40,'636.00000','313.00000','4.50000','1.80000',40,43,30,21,20,20,2600,144,'118.00000','146.00000','83.00000','89.00000',230,4,0,333,0,0,0,90,90,1,1,0,1),
(20611,20611,'Dre Vanul Warrior',0,'',0,'LineageMonster.dre_vanul','14.00','36.00',32,'male','L2Monster',40,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,2770,156,'128.00000','152.00000','85.00000','92.00000',230,4,0,333,0,0,0,80,80,1,1,0,1),
(20612,20612,'Salamander Rowin',0,'',0,'LineageMonster.salamander','16.00','6.80',33,'male','L2Monster',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,3166,181,'138.00000','158.00000','96.00000','96.00000',230,1,500,333,0,0,0,64,96,1,1,0,1),
(20613,20613,'Lafi Lizardman',0,'',0,'LineageMonster.virud_lizardman','10.00','23.00',27,'male','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,2282,116,'87.00000','126.00000','62.00000','76.00000',230,4,0,333,291,0,0,43,130,1,1,0,1),
(20614,20614,'Lafi Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman_scout','10.00','22.00',28,'male','L2Monster',1100,'544.00000','274.00000','3.50000','1.50000',40,43,30,21,20,20,2257,119,'93.00000','131.00000','67.00000','80.00000',230,8,0,333,2507,0,0,43,130,1,1,0,1),
(20615,20615,'Ritmal Swordsman',0,'',0,'LineageMonster.spartoi','11.00','27.00',29,'male','L2Monster',40,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,2626,140,'101.00000','136.00000','72.00000','82.00000',230,4,500,333,73,0,0,60,140,1,1,0,1),
(20616,20616,'Rakin Undine',0,'',0,'LineageMonster.undine','12.00','27.00',30,'female','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,3443,188,'109.00000','141.00000','77.00000','85.00000',230,1,0,333,0,0,0,60,60,1,1,0,1),
(20617,20617,'Sentinel Of Water',0,'',0,'LineageMonster.magical_weaver','11.00','20.00',31,'male','L2Monster',40,'636.00000','313.00000','4.50000','1.80000',40,43,30,21,20,20,2625,145,'118.00000','146.00000','83.00000','89.00000',230,4,0,333,0,0,0,90,90,1,1,0,1),
(20618,20618,'Kanil Succubus',0,'',0,'LineageMonster.succubus','10.00','36.00',32,'female','L2Monster',40,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,2919,164,'128.00000','152.00000','85.00000','92.00000',230,4,0,333,0,0,0,60,100,1,1,0,1),
(20619,20619,'Rowin Undine',0,'',0,'LineageMonster.undine','12.00','27.00',33,'female','L2Monster',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,3005,173,'138.00000','158.00000','96.00000','96.00000',230,1,500,333,0,0,0,60,60,1,1,0,1),
(20620,20620,'Cave Beast',0,'',0,'LineageMonster.troll','21.00','35.00',61,'male','L2Monster',40,'1985.00000','970.00000','7.50000','2.70000',40,43,30,21,20,20,15494,1363,'745.00000','379.00000','510.00000','230.00000',230,4,500,333,0,0,0,55,174,1,1,0,1),
(20621,20621,'Death Wave',0,'',0,'LineageMonster.will_o_wisp','13.00','22.00',62,'male','L2Monster',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,16701,1488,'780.00000','389.00000','535.00000','235.00000',230,4,500,333,0,0,0,80,174,1,1,0,1),
(20622,20622,'Malruk Soldier',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',63,'male','L2Monster',40,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,17833,1610,'816.00000','399.00000','559.00000','242.00000',230,8,500,333,221,0,0,80,174,1,1,0,1),
(20623,20623,'Plando',0,'',0,'LineageMonster.virud_lizardman_scout','10.00','22.00',64,'male','L2Monster',1100,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,23778,2177,'853.00000','409.00000','584.00000','248.00000',230,8,500,333,2507,0,0,43,174,1,1,0,1),
(20624,20624,'Cave Howler',0,'',0,'LineageMonster.twin_headed_giant','17.00','39.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,24178,2246,'890.00000','419.00000','615.00000','253.00000',230,4,500,333,0,0,0,45,174,1,1,0,1),
(20625,20625,'Malruk Knight',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,24146,2273,'928.00000','429.00000','641.00000','260.00000',230,4,500,333,78,0,0,40,174,1,1,0,1),
(20626,20626,'Malruk Berserker',0,'',0,'LineageMonster.death_knight','12.00','30.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,34656,3300,'967.00000','439.00000','663.00000','266.00000',230,4,500,333,77,0,0,27,174,1,1,0,1),
(20627,20627,'Malruk Lord',0,'',0,'LineageMonster.death_blader','15.00','45.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,29789,2878,'1006.00000','450.00000','695.00000','272.00000',230,4,500,333,1472,0,0,100,174,1,1,0,1),
(20628,20628,'Limal Karinness',0,'',0,'LineageMonster.bloody_queen','14.00','40.00',69,'female','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,32098,3140,'1046.00000','460.00000','717.00000','279.00000',230,4,500,333,0,0,0,80,174,1,1,0,1),
(20629,20629,'Karik',0,'',0,'LineageMonster.karik','25.00','90.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,39507,3917,'1086.00000','471.00000','749.00000','285.00000',230,4,500,333,0,0,0,37,174,1,1,0,1),
(20630,20630,'Taik Orc',0,'',0,'LineageMonster.ketra_orc','12.00','29.00',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,2792,180,'226.00000','202.00000','157.00000','122.00000',230,4,0,333,127,0,0,45,174,1,1,1,1),
(20631,20631,'Taik Orc Archer',0,'',0,'LineageMonster.ketra_orc_archer','12.00','27.00',41,'male','L2Monster',1100,'1008.00000','459.00000','5.50000','2.10000',40,43,30,21,20,20,3783,247,'241.00000','209.00000','163.00000','126.00000',230,8,0,333,14,0,0,45,174,1,1,1,1),
(20632,20632,'Taik Orc Warrior',0,'',0,'LineageMonster.ketra_orc_warrior','12.00','24.00',42,'male','L2Monster',40,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,3774,251,'258.00000','216.00000','174.00000','131.00000',230,4,500,333,75,0,0,36,174,1,1,1,1),
(20633,20633,'Taik Orc Shaman',0,'',0,'LineageMonster.ketra_orc_shaman','10.00','23.00',43,'male','L2Monster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,3682,248,'275.00000','223.00000','191.00000','135.00000',230,1,0,333,9,0,0,10,174,1,1,1,1),
(20634,20634,'Taik Orc Captain',0,'',0,'LineageMonster.ketra_orc_warrior','12.00','24.00',44,'male','L2Monster',40,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,7065,484,'293.00000','231.00000','199.00000','139.00000',230,4,500,333,75,104,0,36,174,1,1,1,1),
(20635,20635,'Carinkain',0,'',0,'LineageMonster.mana_vampire','11.00','20.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,3569,248,'313.00000','238.00000','212.00000','144.00000',230,4,500,333,0,0,0,90,174,1,1,1,1),
(20636,20636,'Forest of Mirrors Ghost',0,'',0,'LineageMonster.dwarf_ghost','10.00','18.70',46,'male','L2Monster',40,'1230.00000','580.00000','5.50000','2.10000',40,43,30,21,20,20,3973,282,'332.00000','246.00000','231.00000','149.00000',230,4,500,333,0,0,0,80,174,1,1,1,1),
(20637,20637,'Forest of Mirrors Ghost',0,'',0,'LineageMonster.elf_ghost','7.00','21.00',47,'male','L2Monster',40,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,4148,298,'353.00000','254.00000','244.00000','154.00000',230,4,500,333,0,0,0,80,174,1,1,1,1),
(20638,20638,'Forest of Mirrors Ghost',0,'',0,'LineageMonster.human_ghost','8.00','22.00',48,'male','L2Monster',40,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,4326,316,'375.00000','262.00000','260.00000','159.00000',230,4,500,333,0,0,0,80,174,1,1,1,1),
(20639,20639,'Mirror',0,'',0,'LineageMonster.mirror','26.00','52.00',49,'male','L2Monster',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,10210,755,'398.00000','270.00000','275.00000','164.00000',230,4,0,333,0,0,0,80,174,1,1,1,1),
(20640,20640,'Harit Lizardman',0,'',0,'LineageMonster.zenta_lizardman','11.00','32.00',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,4363,329,'421.00000','278.00000','286.00000','169.00000',230,1,0,333,88,945,0,37,174,1,1,1,1),
(20641,20641,'Harit Lizardman Grunt',0,'',0,'LineageMonster.zenta_lizardman','11.00','32.00',51,'male','L2Monster',40,'1470.00000','706.00000','6.50000','2.40000',40,43,30,21,20,20,5402,412,'446.00000','287.00000','309.00000','174.00000',230,4,0,333,70,0,0,37,174,1,1,1,1),
(20642,20642,'Harit Lizardman Archer',0,'',0,'LineageMonster.zenta_lizardman_scout','11.00','30.00',52,'male','L2Monster',1100,'1520.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,5057,391,'472.00000','295.00000','321.00000','179.00000',230,8,500,333,14,0,0,37,174,1,1,1,1),
(20643,20643,'Harit Lizardman Warrior',0,'',0,'LineageMonster.zenta_lizardman_warrior','13.00','35.00',53,'male','L2Monster',40,'1571.00000','757.00000','6.50000','2.40000',40,43,30,21,20,20,5199,409,'498.00000','304.00000','344.00000','184.00000',230,4,0,333,291,0,0,40,174,1,1,1,1),
(20644,20644,'Harit Lizardman Shaman',0,'',0,'LineageMonster.zenta_lizardman_shaman','13.00','35.00',54,'male','L2Monster',40,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,5089,406,'526.00000','313.00000','364.00000','189.00000',230,1,0,333,9,0,0,43,174,1,1,1,1),
(20645,20645,'Harit Lizardman Matriarch',0,'',0,'LineageMonster.zenta_lizardman_matriarch','20.00','40.00',55,'male','L2Monster',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,11444,924,'554.00000','322.00000','384.00000','195.00000',230,4,500,333,221,0,0,53,174,1,1,1,1),
(20646,20646,'Halingka',0,'',0,'LineageMonster.saber_toothed_tiger','34.00','28.00',55,'male','L2Monster',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,8623,696,'554.00000','322.00000','384.00000','195.00000',230,1,0,333,0,0,0,60,170,1,1,0,1),
(20647,20647,'Yintzu',0,'',0,'LineageMonster.field_stalker','16.00','36.00',56,'male','L2Monster',40,'1725.00000','836.00000','6.50000','2.40000',40,43,30,21,20,20,8653,710,'583.00000','331.00000','404.00000','201.00000',230,1,500,333,0,0,0,70,110,1,1,0,1),
(20648,20648,'Paliote',0,'',0,'LineageMonster.will_o_wisp','13.00','22.00',57,'male','L2Monster',40,'1777.00000','862.00000','6.50000','2.40000',40,43,30,21,20,20,9826,816,'614.00000','340.00000','420.00000','207.00000',230,1,0,333,0,0,0,80,140,1,1,0,1),
(20649,20649,'Hamrut',0,'',0,'LineageMonster.poison_spider','27.00','25.50',58,'male','L2Monster',40,'1828.00000','889.00000','6.50000','2.40000',40,43,30,21,20,20,9781,827,'646.00000','350.00000','447.00000','212.00000',230,1,500,333,0,0,0,60,140,1,1,0,1),
(20650,20650,'Kranrot',0,'',0,'LineageMonster.crimson_bear','19.00','36.00',59,'male','L2Monster',40,'1881.00000','916.00000','6.50000','2.40000',40,43,30,21,20,20,10586,905,'678.00000','359.00000','464.00000','218.00000',230,1,500,333,0,0,0,37,170,1,1,0,1),
(20651,20651,'Gamlin',0,'',0,'LineageMonster.gamlin','11.00','32.00',60,'male','L2Monster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,9835,853,'711.00000','369.00000','491.00000','224.00000',230,1,0,333,0,0,0,80,170,1,1,0,1),
(20652,20652,'Leogul',0,'',0,'LineageMonster.leogul','15.00','35.00',61,'male','L2Monster',40,'1985.00000','970.00000','7.50000','2.70000',40,43,30,21,20,20,10369,913,'745.00000','379.00000','510.00000','230.00000',230,1,500,333,0,0,0,80,170,1,1,0,1),
(20653,20653,'Lesser Giant',0,'',0,'LineageMonster.lesser_giant','50.00','44.00',61,'male','L2Monster',40,'1985.00000','970.00000','7.50000','2.70000',40,43,30,21,20,20,14612,1286,'745.00000','379.00000','510.00000','230.00000',230,1,0,333,3937,0,0,15,180,1,1,0,1),
(20654,20654,'Lesser Giant Soldier',0,'',0,'LineageMonster.lesser_giant','50.00','44.00',62,'male','L2Monster',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,22406,1997,'780.00000','389.00000','535.00000','235.00000',230,1,0,333,3937,0,0,15,180,1,1,0,1),
(20655,20655,'Lesser Giant Shooter',0,'',0,'LineageMonster.lesser_giant_shooter','50.00','44.00',63,'male','L2Monster',1100,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,18307,1652,'816.00000','399.00000','559.00000','242.00000',230,8,500,333,4028,0,0,80,180,1,1,0,1),
(20656,20656,'Lesser Giant Scout',0,'',0,'LineageMonster.lesser_giant_shooter','50.00','44.00',63,'male','L2Monster',1100,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,16702,1508,'816.00000','399.00000','559.00000','242.00000',230,8,500,333,4028,0,0,80,180,1,1,0,1),
(20657,20657,'Lesser Giant Mage',0,'',0,'LineageMonster.lesser_giant_mage','50.00','44.00',64,'male','L2Monster',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,13228,1211,'853.00000','409.00000','584.00000','248.00000',230,1,0,333,3938,0,0,15,180,1,1,0,1),
(20658,20658,'Lesser Giant Elder',0,'',0,'LineageMonster.lesser_giant_mage','50.00','44.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,12778,1187,'890.00000','419.00000','615.00000','253.00000',230,1,0,333,3938,0,0,15,180,1,1,0,1),
(20659,20659,'Grave Wanderer',0,'',0,'LineageMonster.zombie','13.00','21.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,4948,344,'313.00000','238.00000','212.00000','144.00000',230,4,0,333,0,0,0,15,15,1,1,1,1),
(20660,20660,'Archer of Greed',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',46,'male','L2Monster',1100,'1230.00000','580.00000','5.50000','2.10000',40,43,30,21,20,20,4858,344,'332.00000','246.00000','231.00000','149.00000',230,8,500,333,14,0,0,40,174,1,1,1,1),
(20661,20661,'Hatar Ratman Thief',0,'',0,'LineageMonster.wererat','14.00','25.00',47,'male','L2Monster',40,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,4588,329,'353.00000','254.00000','244.00000','154.00000',230,8,0,333,946,0,0,80,174,1,1,1,1),
(20662,20662,'Hatar Ratman Boss',0,'',0,'LineageMonster.wererat','14.00','25.00',48,'male','L2Monster',40,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,4785,349,'375.00000','262.00000','260.00000','159.00000',230,8,0,333,221,0,0,80,174,1,1,1,1),
(20663,20663,'Hatar Hanishee',0,'',0,'LineageMonster.medusa','10.00','25.00',49,'female','L2Monster',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,4190,310,'398.00000','270.00000','275.00000','164.00000',230,4,0,333,0,0,0,50,174,1,1,1,1),
(20664,20664,'Deprive',0,'',0,'LineageMonster.field_stalker','16.00','36.00',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,4406,332,'421.00000','278.00000','286.00000','169.00000',230,4,500,333,0,0,0,70,174,1,1,1,1),
(20665,20665,'Taik Orc Supply',0,'',0,'LineageMonster.ketra_orc','12.00','29.00',51,'male','L2Monster',40,'1470.00000','706.00000','6.50000','2.40000',40,43,30,21,20,20,5402,412,'446.00000','287.00000','309.00000','174.00000',230,4,0,333,69,0,0,45,174,1,1,1,1),
(20666,20666,'Taik Orc Seeker',0,'',0,'LineageMonster.ketra_orc','12.00','29.00',52,'male','L2Monster',40,'1520.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,5616,434,'472.00000','295.00000','321.00000','179.00000',230,4,0,333,72,0,0,45,174,1,1,0,1),
(20667,20667,'Farcran',0,'',0,'LineageMonster.crimson_bear','19.00','36.00',53,'male','L2Monster',40,'1571.00000','757.00000','6.50000','2.40000',40,43,30,21,20,20,5776,454,'498.00000','304.00000','344.00000','184.00000',230,4,0,333,0,0,0,37,174,1,1,1,1),
(20668,20668,'Grave Guard',0,'',0,'LineageMonster.gargoyle','16.00','50.00',54,'male','L2Monster',40,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,5140,409,'526.00000','313.00000','364.00000','189.00000',230,4,500,333,0,0,0,140,174,1,1,0,1),
(20669,20669,'Taik Orc Supply Leader',0,'',0,'LineageMonster.ketra_orc_warrior','12.00','24.00',55,'male','L2Monster',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,6408,517,'554.00000','322.00000','384.00000','195.00000',230,4,500,333,75,0,0,36,174,1,1,0,1),
(20670,20670,'Crimson Drake',0,'',0,'LineageMonster.drake','30.00','100.00',61,'male','L2Monster',40,'1985.00000','970.00000','7.50000','2.70000',40,43,30,21,20,20,6558,577,'745.00000','379.00000','510.00000','230.00000',230,4,200,333,0,0,0,70,174,1,1,0,1),
(20671,20671,'Kadios',0,'',0,'LineageMonster.devastator','35.00','35.00',62,'male','L2Monster',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,6843,610,'780.00000','389.00000','535.00000','235.00000',230,4,200,333,0,0,0,25,174,1,1,0,1),
(20672,20672,'Trives',0,'',0,'LineageMonster.serpent_slave','17.00','46.00',63,'male','L2Monster',40,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,6927,625,'816.00000','399.00000','559.00000','242.00000',230,4,0,333,127,0,0,70,174,1,1,0,1),
(20673,20673,'Falibati',0,'',0,'LineageMonster.cave_maiden','25.00','65.00',64,'female','L2Monster',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,7219,661,'853.00000','409.00000','584.00000','248.00000',230,4,300,333,73,0,0,70,174,1,1,0,1),
(20674,20674,'Doom Knight',0,'',0,'LineageMonster.death_blader','15.00','45.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,10379,965,'890.00000','419.00000','615.00000','253.00000',230,4,300,333,1472,0,0,100,174,1,1,0,1),
(20675,20675,'Tairim',0,'',0,'LineageMonster.will_o_wisp','13.00','22.00',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,4581,346,'421.00000','278.00000','286.00000','169.00000',230,4,0,333,0,0,0,80,174,1,1,0,1),
(20676,20676,'Judge of Marsh',0,'',0,'LineageMonster.hanged_man_ripper','35.00','80.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,7447,692,'890.00000','419.00000','615.00000','253.00000',230,4,500,333,0,0,0,55,174,1,1,1,1),
(20677,20677,'Tulben',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,8363,787,'928.00000','429.00000','641.00000','260.00000',230,4,0,333,0,0,0,60,174,1,1,1,1),
(20678,20678,'Tortured Undead',0,'',0,'LineageMonster.hungry_spirit','13.00','40.00',53,'male','L2Monster',40,'1571.00000','757.00000','6.50000','2.40000',40,43,30,21,20,20,4902,385,'498.00000','304.00000','344.00000','184.00000',230,4,0,333,0,0,0,15,174,1,1,0,1),
(20679,20679,'Marsh Stalker',0,'',0,'LineageMonster.gargoyle','16.00','50.00',54,'male','L2Monster',40,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,5039,402,'526.00000','313.00000','364.00000','189.00000',230,4,0,333,0,0,0,140,174,1,1,1,1),
(20680,20680,'Marsh Drake',0,'',0,'LineageMonster.drake','30.00','100.00',55,'male','L2Monster',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,5332,431,'554.00000','322.00000','384.00000','195.00000',230,4,500,333,0,0,0,70,174,1,1,1,1),
(20681,20681,'Vanor Silenos',0,'',0,'LineageMonster.heltor_silenos','13.00','29.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,3711,258,'313.00000','238.00000','212.00000','144.00000',230,1,0,333,88,0,0,34,174,1,1,1,1),
(20682,20682,'Vanor Silenos Grunt',0,'',0,'LineageMonster.heltor_silenos','13.00','29.00',46,'male','L2Monster',40,'1230.00000','580.00000','5.50000','2.10000',40,43,30,21,20,20,3693,262,'332.00000','246.00000','231.00000','149.00000',230,1,0,333,158,18,0,34,174,1,1,1,1),
(20683,20683,'Vanor Silenos Scout',0,'',0,'LineageMonster.heltor_silenos','13.00','29.00',47,'male','L2Monster',40,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,4805,344,'353.00000','254.00000','244.00000','154.00000',230,1,500,333,5,0,0,34,174,1,1,1,1),
(20684,20684,'Vanor Silenos Warrior',0,'',0,'LineageMonster.heltor_silenos_warrior','13.00','31.00',48,'male','L2Monster',40,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,5026,367,'375.00000','262.00000','260.00000','159.00000',230,1,0,333,160,0,0,36,174,1,1,1,1),
(20685,20685,'Vanor Silenos Shaman',0,'',0,'LineageMonster.heltor_silenos_shaman','13.00','32.00',49,'male','L2Monster',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,4190,310,'398.00000','270.00000','275.00000','164.00000',230,1,0,333,9,0,0,29,174,1,1,1,1),
(20686,20686,'Vanor Silenos Chieftain',0,'',0,'LineageMonster.heltor_silenos_chieftain','13.00','31.50',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,8731,658,'421.00000','278.00000','286.00000','169.00000',230,4,0,333,75,0,0,27,174,1,1,1,1),
(20738,20738,'Kobold Looter Bepook',0,'',0,'LineageMonster.kobold_bi','15.00','24.00',13,'male','L2Monster',40,'215.00000','120.00000','2.50000','1.20000',40,43,30,21,20,20,1326,52,'25.00000','70.00000','15.00000','43.00000',230,1,500,333,4,0,0,47,110,1,1,0,1),
(20739,20739,'Bepook\'s Pet',0,'',0,'LineageMonster.wolf','13.00','9.00',10,'male','L2Monster',40,'163.00000','98.00000','2.00000','0.90000',40,43,30,21,20,20,220,7,'19.00000','61.00000','10.00000','37.00000',230,1,0,333,0,0,0,24,110,1,1,0,1),
(20742,20742,'Mystical Weaver',0,'',0,'LineageMonster.magical_weaver','11.00','20.00',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,821,38,'57.00000','103.00000','36.00000','62.00000',230,4,0,333,0,0,0,90,90,1,1,0,1),
(20743,20743,'Howler',0,'',0,'LineageMonster.werewolf','10.00','26.00',25,'male','L2Monster',40,'461.00000','236.00000','3.50000','1.50000',40,43,30,21,20,20,1012,50,'73.00000','116.00000','52.00000','70.00000',230,4,500,333,0,0,0,50,120,1,1,0,1),
(20744,20744,'Red Eye Vampire Bat',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,821,38,'57.00000','103.00000','36.00000','62.00000',230,4,0,333,0,0,0,60,80,1,1,0,1),
(20745,20745,'Gigantiops',0,'',0,'LineageMonster.ant_soldier','35.00','17.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,3218,191,'159.00000','170.00000','111.00000','102.00000',230,4,500,333,0,0,0,80,174,1,1,0,1),
(20746,20746,'Young Gigantiops',0,'',0,'LineageMonster.ant','26.00','15.00',31,'male','L2Monster',40,'636.00000','313.00000','4.50000','1.80000',40,43,30,21,20,20,2475,137,'118.00000','146.00000','83.00000','89.00000',230,4,0,333,0,0,0,40,139,1,1,0,1),
(20747,20747,'Roxide',0,'',0,'LineageMonster.succubus','10.00','36.00',32,'female','L2Monster',40,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,3504,197,'128.00000','152.00000','85.00000','92.00000',230,4,500,333,0,0,0,60,159,1,1,0,1),
(20748,20748,'Roxide Cohort',0,'',0,'LineageMonster.spartoi','11.00','27.00',29,'male','L2Monster',40,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,3240,174,'101.00000','136.00000','72.00000','82.00000',230,4,0,333,73,0,0,60,159,1,1,0,1),
(20749,20749,'Death Fire',0,'',0,'LineageMonster.dre_vanul','14.00','36.00',32,'male','L2Monster',40,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,3504,197,'128.00000','152.00000','85.00000','92.00000',230,4,500,333,0,0,0,80,159,1,1,0,1),
(20750,20750,'Fire Archer',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',29,'male','L2Monster',1100,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,3354,180,'101.00000','136.00000','72.00000','82.00000',230,8,0,333,14,0,0,40,159,1,1,0,1),
(20751,20751,'Snipe',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',44,'male','L2Monster',40,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,13373,880,'293.00000','231.00000','199.00000','153.00000',230,4,0,333,0,0,0,30,120,1,1,0,1),
(20752,20752,'Snipe Cohort',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',42,'male','L2Monster',40,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,7085,451,'258.00000','216.00000','174.00000','143.00000',230,4,0,333,0,0,0,30,120,1,1,0,1),
(20753,20753,'Dark Lord',0,'',0,'LineageMonster.death_blader','15.00','45.00',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,11417,826,'421.00000','278.00000','286.00000','185.00000',230,4,500,333,1472,0,0,100,170,1,1,0,1),
(20754,20754,'Dark Knight',0,'',0,'LineageMonster.death_knight','12.00','30.00',48,'male','L2Monster',40,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,12549,887,'375.00000','262.00000','260.00000','175.00000',230,4,0,333,127,0,0,27,110,1,1,0,1),
(20755,20755,'Talakin',0,'',0,'LineageMonster.ol_mahum_champion','14.00','27.00',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,2364,130,'109.00000','141.00000','77.00000','85.00000',230,4,500,333,2,0,0,50,133,1,1,0,1),
(20756,20756,'Talakin Archer',0,'',0,'LineageMonster.ol_mahum_archer','14.00','25.00',28,'male','L2Monster',1100,'544.00000','274.00000','3.50000','1.50000',40,43,30,21,20,20,2261,119,'93.00000','131.00000','67.00000','80.00000',230,8,0,333,14,0,0,50,133,1,1,0,1),
(20757,20757,'Talakin Raider',0,'',0,'LineageMonster.ol_mahum','13.50','25.00',27,'male','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,1657,85,'87.00000','126.00000','62.00000','76.00000',230,4,0,333,3,0,0,50,133,1,1,0,1),
(20758,20758,'Dragon Bearer Chief',0,'',0,'LineageMonster.spartoi','11.00','27.00',49,'male','L2Monster',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,6307,467,'398.00000','270.00000','275.00000','164.00000',230,4,500,333,123,945,0,60,174,1,1,0,1),
(20759,20759,'Dragon Bearer Warrior',0,'',0,'LineageMonster.skeleton','11.00','25.00',48,'male','L2Monster',40,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,5934,433,'375.00000','262.00000','260.00000','159.00000',230,4,0,333,2,945,0,60,174,1,1,0,1),
(20760,20760,'Dragon Bearer Archer',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',47,'male','L2Monster',1100,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,6165,442,'353.00000','254.00000','244.00000','154.00000',230,8,0,333,14,0,0,40,174,1,1,0,1),
(20761,20761,'Pytan',0,'',0,'LineageMonster.bloody_queen','14.00','40.00',69,'female','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,23881,2336,'1046.00000','460.00000','717.00000','279.00000',230,4,500,333,0,0,0,80,174,1,1,0,1),
(20762,20762,'Pytan Knight',0,'',0,'LineageMonster.death_blader','15.00','45.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,16852,1628,'1006.00000','450.00000','695.00000','272.00000',230,4,0,333,1472,0,0,100,174,1,1,0,1),
(20763,20763,'Lord of the Plains',0,'',0,'LineageMonster.zenta_lizardman_matriarch','20.00','40.00',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,4644,300,'226.00000','202.00000','157.00000','122.00000',230,8,500,333,221,0,0,53,174,1,1,0,1),
(20764,20764,'Shaman of the Plains',0,'',0,'LineageMonster.zenta_lizardman_shaman','13.00','35.00',39,'male','L2Monster',40,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,4150,264,'211.00000','195.00000','147.00000','118.00000',230,1,0,333,179,0,0,43,174,1,1,0,1),
(20765,20765,'Warrior of the Plains',0,'',0,'LineageMonster.zenta_lizardman_warrior','13.00','35.00',38,'male','L2Monster',40,'886.00000','407.00000','4.50000','1.80000',40,43,30,21,20,20,3591,224,'197.00000','189.00000','137.00000','114.00000',230,4,0,333,16,0,0,40,174,1,1,0,1),
(20766,20766,'Scout of the Plains',0,'',0,'LineageMonster.zenta_lizardman_scout','11.00','30.00',36,'male','L2Monster',1100,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,3192,193,'171.00000','176.00000','115.00000','107.00000',230,8,0,333,14,0,0,37,174,1,1,0,1),
(20767,20767,'Timak Orc Troop Leader',0,'',0,'LineageMonster.batur_orc_overlord','12.00','24.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,5762,401,'313.00000','238.00000','212.00000','144.00000',230,4,0,333,79,0,0,80,174,1,1,0,1),
(20768,20768,'Timak Orc Troop Shaman',0,'',0,'LineageMonster.batur_orc_shaman','11.00','16.00',44,'male','L2Monster',40,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,5559,380,'293.00000','231.00000','199.00000','139.00000',230,1,0,333,7,0,0,50,174,1,1,0,1),
(20769,20769,'Timak Orc Troop Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10.00','20.00',43,'male','L2Monster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,4421,299,'275.00000','223.00000','191.00000','135.00000',230,4,0,333,123,19,0,80,174,1,1,0,1),
(20770,20770,'Timak Orc Troop Archer',0,'',0,'LineageMonster.batur_orc_archer','11.00','21.50',41,'male','L2Monster',1100,'1008.00000','459.00000','5.50000','2.10000',40,43,30,21,20,20,5183,340,'241.00000','209.00000','163.00000','126.00000',230,8,0,333,13,0,0,45,174,1,1,0,1),
(20771,20771,'Barif',0,'',0,'LineageMonster.lesser_giant_mage','50.00','44.00',64,'male','L2Monster',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,15637,1432,'853.00000','409.00000','584.00000','248.00000',230,1,500,333,3938,0,0,15,180,1,1,0,1),
(20772,20772,'Barif\'s Pet',0,'',0,'LineageMonster.leogul','15.00','35.00',61,'male','L2Monster',40,'1985.00000','970.00000','7.50000','2.70000',40,43,30,21,20,20,15199,1338,'745.00000','379.00000','510.00000','230.00000',230,1,0,333,0,0,0,80,170,1,1,0,1),
(20773,20773,'Conjurer Bat Lord',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,12643,1284,'1168.00000','492.00000','801.00000','298.00000',230,4,500,333,0,0,0,60,174,1,1,0,1),
(20774,20774,'Conjurer Bat',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,13368,1326,'1086.00000','471.00000','749.00000','285.00000',230,4,0,333,0,0,0,60,174,1,1,0,1),
(20775,20775,'Bugbear Raider',0,'',0,'LineageMonster.bugbear','17.00','35.00',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,600,25,'37.00000','83.00000','27.00000','51.00000',230,4,0,333,0,0,0,55,130,1,1,1,1),
(20776,20776,'Dark Succubus',0,'',0,'LineageMonster.succubus','10.00','36.00',20,'female','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,784,35,'48.00000','95.00000','30.00000','57.00000',230,4,0,333,0,0,0,60,100,1,1,1,1),
(20777,20777,'Hunter Bear',0,'',0,'LineageMonster.grizzly','21.00','40.00',14,'male','L2Monster',40,'230.00000','128.00000','2.50000','1.20000',40,43,30,21,20,20,499,19,'28.00000','73.00000','16.00000','44.00000',230,4,0,333,0,0,0,40,110,1,1,1,1),
(20778,20778,'Ragna Orc Overlord',0,'',0,'LineageMonster.orc_champion','10.00','23.00',39,'male','L2Monster',40,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,2973,188,'211.00000','195.00000','147.00000','118.00000',230,4,0,333,2,0,0,45,174,1,1,0,1),
(20779,20779,'Ragna Orc Seer',0,'',0,'LineageMonster.orc_shaman','9.00','22.00',39,'male','L2Monster',40,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,2655,169,'211.00000','195.00000','147.00000','118.00000',230,1,0,333,7,0,0,45,174,1,1,0,1),
(20780,20780,'Bloody Axe Elite',0,'',0,'LineageMonster.ol_mahum_champion','14.00','27.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,2159,127,'159.00000','170.00000','111.00000','102.00000',230,4,500,333,2,0,0,50,174,1,1,1,1),
(20781,20781,'Delu Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman','10.00','29.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,2138,126,'159.00000','170.00000','111.00000','102.00000',230,1,0,333,7,0,0,43,174,1,1,1,1),
(20782,20782,'Ol Mahum Novice',0,'',0,'LineageMonster.ol_mahum','13.50','25.00',17,'male','L2Monster',40,'282.00000','151.00000','2.50000','1.20000',40,43,30,21,20,20,618,26,'37.00000','83.00000','27.00000','51.00000',230,4,500,333,1,0,0,50,110,1,1,1,1),
(20783,20783,'Dread Wolf',0,'',0,'LineageMonster.dire_wolf','13.00','11.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,981,58,'159.00000','170.00000','111.00000','102.00000',230,4,500,333,0,0,0,24,140,1,1,1,1),
(20784,20784,'Tasaba Lizardman',0,'',0,'LineageMonster.virud_lizardman_scout','10.00','22.00',36,'male','L2Monster',1100,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,1111,67,'171.00000','176.00000','115.00000','107.00000',230,8,0,333,2507,0,0,43,140,1,1,1,1),
(20785,20785,'Tasaba Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman','10.00','29.00',37,'male','L2Monster',40,'847.00000','393.00000','4.50000','1.80000',40,43,30,21,20,20,1075,66,'183.00000','182.00000','123.00000','111.00000',230,1,0,333,7,0,0,43,140,1,1,1,1),
(20786,20786,'Lienrik',0,'',0,'LineageMonster.lienrik','12.00','50.00',39,'male','L2Monster',40,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,1195,76,'211.00000','195.00000','147.00000','118.00000',230,8,0,333,0,0,0,100,150,1,1,1,1),
(20787,20787,'Lienrik Lad',0,'',0,'LineageMonster.lienrik','12.00','50.00',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,1453,94,'226.00000','202.00000','157.00000','122.00000',230,8,500,333,0,0,0,100,174,1,1,1,1),
(20788,20788,'Rakul',0,'',0,'LineageMonster.rakul','30.00','39.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,2544,150,'159.00000','170.00000','111.00000','102.00000',230,4,0,333,3,0,0,60,174,1,1,1,1),
(20789,20789,'Crokian',0,'',0,'LineageMonster.crokian','18.00','29.00',36,'male','L2Monster',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,2399,145,'171.00000','176.00000','115.00000','107.00000',230,4,500,333,5128,0,0,18,174,1,1,1,1),
(20790,20790,'Dailaon',0,'',0,'LineageMonster.dailaon','20.00','28.00',37,'male','L2Monster',1100,'847.00000','393.00000','4.50000','1.80000',40,43,30,21,20,20,3081,190,'183.00000','182.00000','123.00000','111.00000',230,8,0,333,5127,0,0,18,174,1,1,1,1),
(20791,20791,'Crokian Warrior',0,'',0,'LineageMonster.crokian','18.00','29.00',38,'male','L2Monster',40,'886.00000','407.00000','4.50000','1.80000',40,43,30,21,20,20,5307,331,'197.00000','189.00000','137.00000','114.00000',230,4,500,333,5128,0,0,18,174,1,1,1,1),
(20792,20792,'Farhite',0,'',0,'LineageMonster.farhite','16.00','31.00',39,'male','L2Monster',40,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,4938,314,'211.00000','195.00000','147.00000','118.00000',230,1,0,333,5131,0,0,15,174,1,1,1,1),
(20793,20793,'Nos',0,'',0,'LineageMonster.nos','26.00','42.00',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,5404,349,'226.00000','202.00000','157.00000','122.00000',230,4,500,333,5130,0,0,18,174,1,1,1,1),
(20794,20794,'Blade Stakato',0,'',0,'LineageMonster.blade_stakato','15.00','36.00',41,'male','L2Monster',40,'1008.00000','459.00000','5.50000','2.10000',40,43,30,21,20,20,5048,330,'241.00000','209.00000','163.00000','126.00000',230,4,0,333,223,0,0,25,174,1,1,0,1),
(20795,20795,'Blade Stakato Worker',0,'',0,'LineageMonster.blade_stakato_worker','13.00','40.00',42,'male','L2Monster',40,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,4772,318,'258.00000','216.00000','174.00000','131.00000',230,8,0,333,226,0,0,25,174,1,1,0,1),
(20796,20796,'Blade Stakato Warrior',0,'',0,'LineageMonster.blade_stakato_soldier','15.00','38.00',43,'male','L2Monster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,5102,344,'275.00000','223.00000','191.00000','135.00000',230,1,500,333,232,0,0,25,174,1,1,0,1),
(20797,20797,'Blade Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone','15.00','39.00',44,'male','L2Monster',40,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,7754,530,'293.00000','231.00000','199.00000','139.00000',230,4,0,333,74,0,0,25,174,1,1,0,1),
(20798,20798,'Water Giant',0,'',0,'LineageMonster.water_giant','13.00','44.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,6270,436,'313.00000','238.00000','212.00000','144.00000',230,4,500,333,5132,0,0,35,174,1,1,0,1),
(20799,20799,'Queen Undine Lad',0,'',0,'LineageMonster.undine','12.00','27.00',46,'female','L2Monster',40,'1230.00000','580.00000','5.50000','2.10000',40,43,30,21,20,20,6312,448,'332.00000','246.00000','231.00000','149.00000',230,4,0,333,0,0,0,60,174,1,1,0,1),
(20800,20800,'Eva\'s Seeker',0,'',0,'LineageMonster.field_stalker','16.00','36.00',47,'male','L2Monster',40,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,5917,424,'353.00000','254.00000','244.00000','154.00000',230,4,0,333,0,0,0,70,174,1,1,0,1),
(20801,20801,'Theeder Piker',0,'',0,'LineageMonster.theeder','9.00','32.00',48,'male','L2Monster',80,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,7134,521,'375.00000','262.00000','260.00000','159.00000',230,4,500,333,302,0,0,80,174,1,1,0,1),
(20802,20802,'Theeder Mage',0,'',0,'LineageMonster.theeder','9.00','32.00',49,'male','L2Monster',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,7262,536,'398.00000','270.00000','275.00000','164.00000',230,1,0,333,192,0,0,80,174,1,1,0,1),
(20803,20803,'Doll Master',0,'',0,'LineageMonster.doll_master','20.00','42.00',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,14218,1072,'421.00000','278.00000','286.00000','169.00000',230,4,500,333,0,0,0,80,174,1,1,0,1),
(20804,20804,'Crokian Lad',0,'',0,'LineageMonster.crokian_100_bi','36.00','61.00',41,'male','L2Monster',40,'1008.00000','459.00000','5.50000','2.10000',40,43,30,21,20,20,6178,404,'241.00000','209.00000','163.00000','126.00000',230,4,500,333,5128,0,0,18,174,1,1,0,1),
(20805,20805,'Dailaon Lad',0,'',0,'LineageMonster.dailaon_100_bi','40.00','58.00',42,'male','L2Monster',1100,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,6697,446,'258.00000','216.00000','174.00000','131.00000',230,8,0,333,5127,0,0,18,174,1,1,0,1),
(20806,20806,'Crokian Lad Warrior',0,'',0,'LineageMonster.crokian_100_bi','36.00','61.00',43,'male','L2Monster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,6428,434,'275.00000','223.00000','191.00000','135.00000',230,4,500,333,5128,0,0,18,174,1,1,0,1),
(20807,20807,'Farhite Lad',0,'',0,'LineageMonster.farhite_50_bi','24.00','48.00',44,'male','L2Monster',40,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,6761,463,'293.00000','231.00000','199.00000','139.00000',230,1,0,333,5131,0,0,15,174,1,1,0,1),
(20808,20808,'Nos Lad',0,'',0,'LineageMonster.nos_100_bi','52.00','86.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,8371,582,'313.00000','238.00000','212.00000','144.00000',230,4,500,333,128,0,0,18,174,1,1,0,1),
(20809,20809,'Ghost of the Tower',0,'',0,'LineageMonster.human_ghost','8.00','22.00',60,'male','L2Monster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,14562,1264,'711.00000','369.00000','491.00000','224.00000',230,1,500,333,0,0,0,80,143,1,1,0,1),
(20810,20810,'Seer of Hallate',0,'',0,'LineageMonster.field_stalker','16.00','36.00',60,'male','L2Monster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,14562,1264,'711.00000','369.00000','491.00000','224.00000',230,1,500,333,0,0,0,70,170,1,1,0,1),
(20811,20811,'Ghastly Warrior',0,'',0,'LineageMonster.unpleasant_humming','12.00','26.00',61,'male','L2Monster',40,'1985.00000','970.00000','7.50000','2.70000',40,43,30,21,20,20,17170,1511,'745.00000','379.00000','510.00000','230.00000',230,8,500,333,0,0,0,21,150,1,1,0,1),
(20812,20812,'Archer of Despair',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',61,'male','L2Monster',1100,'1985.00000','970.00000','7.50000','2.70000',40,43,30,21,20,20,16950,1492,'745.00000','379.00000','510.00000','230.00000',230,8,500,333,284,0,0,40,160,1,1,0,1),
(20813,20813,'Crendion',0,'',0,'LineageMonster.liviona','15.00','28.00',62,'male','L2Monster',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,15397,1372,'780.00000','389.00000','535.00000','235.00000',230,4,500,333,0,0,0,80,160,1,1,0,1),
(20814,20814,'Blader of Despair',0,'',0,'LineageMonster.spartoi','11.00','27.00',62,'male','L2Monster',80,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,17778,1584,'780.00000','389.00000','535.00000','235.00000',230,4,500,333,79,0,0,60,143,1,1,0,1),
(20815,20815,'Hound Dog of Hallate',0,'',0,'LineageMonster.dire_wolf','13.00','11.00',63,'male','L2Monster',40,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,22001,1986,'816.00000','399.00000','559.00000','242.00000',230,1,500,333,0,0,0,24,165,1,1,0,1),
(20816,20816,'Hallate\'s Royal Guard',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',63,'male','L2Monster',40,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,18356,1657,'816.00000','399.00000','559.00000','242.00000',230,8,500,333,946,945,0,80,164,1,1,0,1),
(20817,20817,'Corrupt Sage',0,'',0,'LineageMonster.vale_master','12.00','40.00',64,'male','L2Monster',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,19137,1752,'853.00000','409.00000','584.00000','248.00000',230,1,500,333,210,0,0,70,160,1,1,0,1),
(20818,20818,'Hallate\'s Warrior',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',64,'male','L2Monster',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,17735,1624,'853.00000','409.00000','584.00000','248.00000',230,4,500,333,78,0,0,40,160,1,1,0,1),
(20819,20819,'Archer of Abyss',0,'',0,'LineageMonster.fiend_archer','17.00','55.00',65,'male','L2Monster',1100,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,17603,1636,'890.00000','419.00000','615.00000','253.00000',230,8,500,333,0,0,0,70,165,1,1,0,1),
(20820,20820,'Hallate\'s Knight',0,'',0,'LineageMonster.death_knight','12.00','30.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,35090,3260,'890.00000','419.00000','615.00000','253.00000',230,4,500,333,80,0,0,27,160,1,1,0,1),
(20821,20821,'Erin Ediunce',0,'',0,'LineageMonster.banshee','9.00','23.00',66,'female','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,25609,2411,'928.00000','429.00000','641.00000','260.00000',230,1,500,333,3939,0,0,80,165,1,1,0,1),
(20822,20822,'Hallate\'s Maid',0,'',0,'LineageMonster.bloody_queen','14.00','40.00',66,'female','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,23832,2243,'928.00000','429.00000','641.00000','260.00000',230,8,500,333,0,0,0,80,160,1,1,0,1),
(20823,20823,'Platinum Tribe Soldier',0,'',0,'LineageMonster.kel_mahum','13.00','26.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,27669,2635,'967.00000','439.00000','663.00000','266.00000',230,8,500,333,242,0,0,50,160,1,1,0,1),
(20824,20824,'Hallate\'s Commander',0,'',0,'LineageMonster.death_blader','15.00','45.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,24884,2370,'967.00000','439.00000','663.00000','266.00000',230,1,500,333,1472,0,0,100,170,1,1,0,1),
(20825,20825,'Hallate\'s Inspector',0,'',0,'LineageMonster.karik_25_bi','31.00','110.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,25991,2510,'1006.00000','450.00000','695.00000','272.00000',230,1,500,333,0,0,0,37,170,1,1,0,1),
(20826,20826,'Platinum Tribe Archer',0,'',0,'LineageMonster.kel_mahum_archer','13.00','27.00',68,'male','L2Monster',1100,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,27541,2660,'1006.00000','450.00000','695.00000','272.00000',230,8,500,333,288,0,0,50,160,1,1,0,1),
(20827,20827,'Platinum Tribe Warrior',0,'',0,'LineageMonster.kel_mahum_warrior','13.00','28.00',69,'male','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,28758,2814,'1046.00000','460.00000','717.00000','279.00000',230,4,500,333,148,0,0,50,160,1,1,0,1),
(20828,20828,'Platinum Tribe Shaman',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13.00','25.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,35291,3499,'1086.00000','471.00000','749.00000','285.00000',230,1,500,333,202,0,0,50,160,1,1,0,1),
(20829,20829,'Platinum Tribe Overlord',0,'',0,'LineageMonster.kel_mahum_champion','13.00','32.00',71,'male','L2Monster',40,'2493.00000','1253.00000','8.50000','3.00000',40,43,30,21,20,20,50697,5087,'1127.00000','481.00000','778.00000','292.00000',230,4,500,333,147,0,0,50,170,1,1,0,1),
(20830,20830,'Guardian Angel',0,'',0,'LineageMonster.angel','13.50','36.50',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1168.00000','492.00000','801.00000','298.00000',230,4,500,333,148,0,0,30,170,1,1,0,1),
(20831,20831,'Seal Angel',0,'',0,'LineageMonster.angel','13.50','36.50',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1209.00000','502.00000','830.00000','304.00000',230,4,500,333,148,0,0,30,170,1,1,0,1),
(20832,20832,'Zaken\'s Pikeman',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',43,'male','L2Monster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,3264,221,'275.00000','223.00000','191.00000','135.00000',230,4,500,333,292,0,0,50,174,1,1,0,1),
(20833,20833,'Zaken\'s Archer',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',44,'male','L2Monster',1100,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,3631,248,'293.00000','231.00000','199.00000','139.00000',230,8,0,333,279,0,0,40,174,1,1,0,1),
(20834,20834,'Mardian',0,'',0,'LineageMonster.giant_spider','26.00','25.50',42,'male','L2Monster',40,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,5403,360,'258.00000','216.00000','174.00000','131.00000',230,4,500,333,0,0,0,72,174,1,1,0,1),
(20835,20835,'Zaken\'s Seer',0,'',0,'LineageMonster.liviona','15.00','28.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,2974,206,'313.00000','238.00000','212.00000','144.00000',230,1,500,333,0,0,0,80,174,1,1,0,1),
(20836,20836,'Pirate Zombie',0,'',0,'LineageMonster.pirates_zombie','10.00','23.00',44,'male','L2Monster',40,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,6799,466,'293.00000','231.00000','199.00000','139.00000',230,8,0,333,225,0,0,11,174,1,1,0,1),
(20837,20837,'Tainted Ogre',0,'',0,'LineageMonster.ogre','21.00','44.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,6158,428,'313.00000','238.00000','212.00000','144.00000',230,1,500,333,194,0,0,22,174,1,1,0,1),
(20838,20838,'Bloody Bat',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,5773,402,'313.00000','238.00000','212.00000','144.00000',230,8,0,333,0,0,0,60,174,1,1,0,1),
(20839,20839,'Unpleasant Humming',0,'',0,'LineageMonster.unpleasant_humming','12.00','26.00',46,'male','L2Monster',40,'1230.00000','580.00000','5.50000','2.10000',40,43,30,21,20,20,3453,245,'332.00000','246.00000','231.00000','149.00000',230,4,500,333,0,0,0,21,174,1,1,0,1),
(20840,20840,'Death Flyer',0,'',0,'LineageMonster.dark_horror','20.00','35.00',47,'male','L2Monster',40,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,3566,256,'353.00000','254.00000','244.00000','154.00000',230,1,0,333,0,0,0,100,174,1,1,0,1),
(20841,20841,'Fiend Archer',0,'',0,'LineageMonster.fiend_archer','17.00','55.00',48,'male','L2Monster',1100,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,3663,268,'375.00000','262.00000','260.00000','159.00000',230,8,500,333,0,0,0,70,174,1,1,0,1),
(20842,20842,'Musveren',0,'',0,'LineageMonster.field_stalker','16.00','36.00',49,'male','L2Monster',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,3492,258,'398.00000','270.00000','275.00000','164.00000',230,4,0,333,0,0,0,70,174,1,1,0,1),
(20843,20843,'Zaken\'s Royal Guard',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,4413,332,'421.00000','278.00000','286.00000','169.00000',230,8,500,333,225,945,0,80,174,1,1,0,1),
(20844,20844,'Kaim Vanul',0,'',0,'LineageMonster.kaim_vanul','24.00','40.00',51,'male','L2Monster',40,'1470.00000','706.00000','6.50000','2.40000',40,43,30,21,20,20,3936,300,'446.00000','287.00000','309.00000','174.00000',230,4,0,333,0,0,0,37,174,1,1,0,1),
(20845,20845,'Pirate\'s Zombie Captain',0,'',0,'LineageMonster.pirates_zombie_captain','17.00','28.00',52,'male','L2Monster',40,'1520.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,5945,460,'472.00000','295.00000','321.00000','179.00000',230,8,500,333,232,0,0,14,174,1,1,0,1),
(20846,20846,'Doll Blader',0,'',0,'LineageMonster.doll_blader','6.00','12.00',53,'male','L2Monster',40,'1571.00000','757.00000','6.50000','2.40000',40,43,30,21,20,20,4718,371,'498.00000','304.00000','344.00000','184.00000',230,8,0,333,5129,5129,0,22,174,1,1,0,1),
(20847,20847,'Vale Master',0,'',0,'LineageMonster.vale_master','12.00','40.00',54,'male','L2Monster',40,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,4501,359,'526.00000','313.00000','364.00000','189.00000',230,4,500,333,0,0,0,70,174,1,1,0,1),
(20848,20848,'Light Bringer',0,'',0,'LineageMonster.light_bringer','10.00','23.00',46,'male','L2Monster',40,'1230.00000','580.00000','5.50000','2.10000',40,43,30,21,20,20,5839,414,'332.00000','246.00000','231.00000','149.00000',230,4,500,333,0,0,0,60,174,1,1,0,1),
(20849,20849,'Light Worm',0,'',0,'LineageMonster.light_worm','5.00','16.00',41,'male','L2Monster',40,'1008.00000','459.00000','5.50000','2.10000',40,43,30,21,20,20,4638,304,'241.00000','209.00000','163.00000','126.00000',230,4,500,333,0,0,0,60,174,1,1,0,1),
(20850,20850,'Golden Stag Lord',0,'',0,'LineageMonster.golden_stag_lord','25.00','30.00',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,3783,284,'421.00000','278.00000','286.00000','169.00000',230,4,0,333,0,0,0,35,174,1,1,0,1),
(20851,20851,'Theeder',0,'',0,'LineageMonster.theeder','9.00','32.00',47,'male','L2Monster',40,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,3409,245,'353.00000','254.00000','244.00000','154.00000',230,1,500,333,0,0,0,80,174,1,1,0,1),
(20852,20852,'Banshee',0,'',0,'LineageMonster.banshee','9.00','23.00',60,'female','L2Monster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,5341,463,'711.00000','369.00000','491.00000','224.00000',230,8,500,333,3939,0,0,80,174,1,1,0,1),
(20853,20853,'Kel Mahum',0,'',0,'LineageMonster.kel_mahum','13.00','26.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,9389,872,'890.00000','419.00000','615.00000','253.00000',230,8,500,333,242,0,0,50,174,1,1,0,1),
(20854,20854,'Kel Mahum Warrior',0,'',0,'LineageMonster.kel_mahum_warrior','13.00','28.00',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,9224,868,'928.00000','429.00000','641.00000','260.00000',230,4,500,333,148,0,0,50,174,1,1,0,1),
(20855,20855,'Kel Mahum Archer',0,'',0,'LineageMonster.kel_mahum_archer','13.00','27.00',67,'male','L2Monster',1100,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,10680,1018,'967.00000','439.00000','663.00000','266.00000',230,8,0,333,288,0,0,50,174,1,1,0,1),
(20856,20856,'Kel Mahum Shaman',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13.00','25.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,7669,740,'1006.00000','450.00000','695.00000','272.00000',230,1,500,333,202,0,0,50,174,1,1,0,1),
(20857,20857,'Kel Mahum Champion',0,'',0,'LineageMonster.kel_mahum_champion','13.00','32.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,9780,970,'1086.00000','471.00000','749.00000','285.00000',230,4,500,333,147,0,0,50,174,1,1,0,1),
(20858,20858,'Angel',0,'',0,'LineageMonster.angel','13.50','36.50',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,10923,1110,'1168.00000','492.00000','801.00000','298.00000',230,4,500,333,148,0,0,30,174,1,1,0,1),
(20859,20859,'Guardian Angel',0,'',0,'LineageMonster.angel','13.50','36.50',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,59729,6068,'1168.00000','492.00000','801.00000','298.00000',230,4,500,333,148,0,0,30,170,1,1,0,1),
(20860,20860,'Seal Angel',0,'',0,'LineageMonster.angel','13.50','36.50',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,83696,8612,'1209.00000','502.00000','830.00000','304.00000',230,4,500,333,148,0,0,30,170,1,1,0,1),
(20861,20861,'Oel Mahum Champion',0,'',0,'LineageMonster.oel_mahum_champion','23.00','61.00',56,'male','L2Monster',40,'1725.00000','836.00000','6.50000','2.40000',40,43,30,21,20,20,6641,545,'583.00000','331.00000','404.00000','201.00000',230,4,500,333,127,0,0,67,174,1,1,0,1),
(20862,20862,'Death Lord',0,'',0,'LineageMonster.death_lord','21.00','40.00',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,9330,984,'1293.00000','524.00000','891.00000','317.00000',230,4,0,333,78,0,0,40,174,1,1,0,1),
(20919,20919,'Maille Lizardman',0,'',0,'LineageMonster.virud_lizardman','10.00','23.00',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,321,14,'48.00000','95.00000','30.00000','57.00000',230,1,0,333,291,0,0,43,130,1,1,1,1),
(20920,20920,'Maille Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman_scout','10.00','22.00',22,'male','L2Monster',1100,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,713,34,'57.00000','103.00000','36.00000','62.00000',230,8,0,333,2507,0,0,43,130,1,1,1,1),
(20921,20921,'Maille Lizardman Guard',0,'',0,'LineageMonster.virud_lizardman','10.00','23.00',24,'male','L2Monster',40,'435.00000','224.00000','3.50000','1.50000',40,43,30,21,20,20,515,25,'68.00000','112.00000','48.00000','67.00000',230,1,500,333,291,0,0,43,130,1,1,1,1),
(20922,20922,'Maille Lizardman Warrior',0,'',0,'LineageMonster.virud_lizardman_warrior','12.00','30.00',26,'male','L2Monster',40,'487.00000','248.00000','3.50000','1.50000',40,43,30,21,20,20,571,29,'79.00000','121.00000','57.00000','73.00000',230,1,0,333,16,0,0,52,130,1,1,1,1),
(20923,20923,'Maille Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman','10.00','29.00',28,'male','L2Monster',40,'544.00000','274.00000','3.50000','1.50000',40,43,30,21,20,20,836,44,'93.00000','131.00000','67.00000','80.00000',230,1,0,333,7,0,0,43,120,1,1,1,1),
(20924,20924,'Maille Lizardman Matriarch',0,'',0,'LineageMonster.virud_lizardman_matriarch','13.00','37.00',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,1025,56,'109.00000','141.00000','77.00000','85.00000',230,1,500,333,69,627,0,56,130,1,1,1,1),
(20925,20925,'Giant Araneid',0,'',0,'LineageMonster.giant_spider','26.00','25.50',24,'male','L2Monster',40,'435.00000','224.00000','3.50000','1.50000',40,43,30,21,20,20,525,26,'68.00000','112.00000','48.00000','67.00000',230,1,0,333,0,0,0,72,130,1,1,1,1),
(20926,20926,'Poison Araneid',0,'',0,'LineageMonster.poison_spider','27.00','25.50',25,'male','L2Monster',40,'461.00000','236.00000','3.50000','1.50000',40,43,30,21,20,20,607,30,'73.00000','116.00000','52.00000','70.00000',230,1,0,333,0,0,0,60,140,1,1,1,1),
(20927,20927,'King of the Araneid',0,'',0,'LineageMonster.giant_spider_50_bi','39.00','38.00',27,'male','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,872,44,'87.00000','126.00000','62.00000','76.00000',230,1,500,333,0,0,0,72,130,1,1,1,1),
(20928,20928,'Hatu Weird Bee',0,'',0,'LineageMonster.giant_bee','8.00','24.50',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,881,48,'109.00000','141.00000','77.00000','85.00000',230,1,500,333,0,0,0,90,120,1,1,1,1),
(20929,20929,'Hatu Dire Wolf',0,'',0,'LineageMonster.dire_wolf','13.00','11.00',32,'male','L2Monster',40,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,836,47,'128.00000','152.00000','85.00000','92.00000',230,1,0,333,0,0,0,24,110,1,1,1,1),
(20930,20930,'Hatu Brown Bear',0,'',0,'LineageMonster.grizzly','21.00','40.00',34,'male','L2Monster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,1317,77,'148.00000','164.00000','99.00000','99.00000',230,1,300,333,0,0,0,40,143,1,1,1,1),
(20931,20931,'Hatu Onyx Beast',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',36,'male','L2Monster',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,1221,74,'171.00000','176.00000','115.00000','107.00000',230,1,0,333,0,0,0,30,174,1,1,1,1),
(20932,20932,'Hatu Crimson Bear',0,'',0,'LineageMonster.crimson_bear','19.00','36.00',38,'male','L2Monster',40,'886.00000','407.00000','4.50000','1.80000',40,43,30,21,20,20,1613,101,'197.00000','189.00000','137.00000','114.00000',230,1,0,333,0,0,0,37,174,1,1,1,1),
(20933,20933,'Hatu Windsus',0,'',0,'LineageMonster.giant_wild_hog','25.00','27.00',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,1849,119,'226.00000','202.00000','157.00000','122.00000',230,1,500,333,0,0,0,35,174,1,1,1,1),
(20934,20934,'Wasp Worker',0,'',0,'LineageMonster.giant_bee_bi','8.00','32.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,991,59,'159.00000','170.00000','111.00000','102.00000',230,1,0,333,0,0,0,90,174,1,1,1,1),
(20935,20935,'Wasp Leader',0,'',0,'LineageMonster.giant_bee_100_bi','16.00','49.00',37,'male','L2Monster',40,'847.00000','393.00000','4.50000','1.80000',40,43,30,21,20,20,1086,67,'183.00000','182.00000','123.00000','111.00000',230,1,300,333,0,0,0,90,174,1,1,1,1),
(20936,20936,'Tanor Silenos',0,'',0,'LineageMonster.heltor_silenos','13.00','29.00',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,2066,133,'226.00000','202.00000','157.00000','122.00000',230,1,0,333,88,0,0,34,174,1,1,0,1),
(20937,20937,'Tanor Silenos Grunt',0,'',0,'LineageMonster.heltor_silenos','13.00','29.00',42,'male','L2Monster',40,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,2699,180,'258.00000','216.00000','174.00000','131.00000',230,1,0,333,158,18,0,34,174,1,1,0,1),
(20938,20938,'Tanor Silenos Scout',0,'',0,'LineageMonster.heltor_silenos','13.00','29.00',44,'male','L2Monster',40,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,2963,203,'293.00000','231.00000','199.00000','139.00000',230,1,0,333,5,0,0,34,174,1,1,0,1),
(20939,20939,'Tanor Silenos Warrior',0,'',0,'LineageMonster.heltor_silenos_warrior','13.00','31.00',46,'male','L2Monster',40,'1230.00000','580.00000','5.50000','2.10000',40,43,30,21,20,20,3303,234,'332.00000','246.00000','231.00000','149.00000',230,1,0,333,160,0,0,36,174,1,1,0,1),
(20940,20940,'Tanor Silenos Shaman',0,'',0,'LineageMonster.heltor_silenos_shaman','13.00','32.00',48,'male','L2Monster',40,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,4024,294,'375.00000','262.00000','260.00000','159.00000',230,1,0,333,9,0,0,29,174,1,1,0,1),
(20941,20941,'Tanor Silenos Chieftain',0,'',0,'LineageMonster.heltor_silenos_chieftain','13.00','31.50',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,3902,294,'421.00000','278.00000','286.00000','169.00000',230,1,500,333,75,0,0,27,174,1,1,0,1),
(20942,20942,'Nightmare Guide',0,'',0,'LineageMonster.harpy','10.00','42.00',43,'female','L2Monster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,1970,133,'275.00000','223.00000','191.00000','135.00000',230,1,0,333,0,0,0,60,174,1,1,0,1),
(20943,20943,'Nightmare Keeper',0,'',0,'LineageMonster.harpy','10.00','42.00',45,'female','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,2833,197,'313.00000','238.00000','212.00000','144.00000',230,1,0,333,0,0,0,60,174,1,1,0,1),
(20944,20944,'Nightmare Lord',0,'',0,'LineageMonster.succubus_100_bi','20.00','75.00',47,'female','L2Monster',40,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,2400,172,'353.00000','254.00000','244.00000','154.00000',230,1,500,359,0,0,0,60,174,1,1,0,1),
(20945,20945,'Cadeine',0,'',0,'LineageMonster.hobgoblin','12.00','24.00',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,2690,203,'421.00000','278.00000','286.00000','169.00000',230,1,0,333,127,625,0,45,174,1,1,0,1),
(20946,20946,'Sanhidro',0,'',0,'LineageMonster.troll','21.00','35.00',52,'male','L2Monster',40,'1520.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,4138,320,'472.00000','295.00000','321.00000','179.00000',230,1,0,333,0,0,0,55,174,1,1,0,1),
(20947,20947,'Connabi',0,'',0,'LineageMonster.bugbear','17.00','35.00',54,'male','L2Monster',40,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,4462,355,'526.00000','313.00000','364.00000','189.00000',230,1,0,359,88,0,0,55,174,1,1,0,1),
(20948,20948,'Bartal',0,'',0,'LineageMonster.liviona','15.00','28.00',56,'male','L2Monster',40,'1725.00000','836.00000','6.50000','2.40000',40,43,30,21,20,20,4431,364,'583.00000','331.00000','404.00000','201.00000',230,1,0,333,0,0,0,80,174,1,1,0,1),
(20949,20949,'Luminun',0,'',0,'LineageMonster.twin_headed_giant','17.00','39.00',58,'male','L2Monster',40,'1828.00000','889.00000','6.50000','2.40000',40,43,30,21,20,20,5220,440,'646.00000','350.00000','447.00000','212.00000',230,1,0,333,157,0,0,45,174,1,1,0,1),
(20950,20950,'Innersen',0,'',0,'LineageMonster.king_bugbear','15.00','40.00',60,'male','L2Monster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,5619,487,'711.00000','369.00000','491.00000','224.00000',230,1,500,333,160,0,0,55,174,1,1,0,1),
(20951,20951,'Pobby\'s Maid',0,'',0,'LineageMonster.manadragora','14.00','17.80',53,'female','L2Monster',40,'1571.00000','757.00000','6.50000','2.40000',40,43,30,21,20,20,3022,238,'498.00000','304.00000','344.00000','184.00000',230,1,0,333,0,0,0,80,174,1,1,0,1),
(20952,20952,'Pobby Escort',0,'',0,'LineageMonster.mandragora_b','12.00','25.50',55,'female','L2Monster',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,5461,440,'554.00000','322.00000','384.00000','195.00000',230,1,0,333,0,0,0,80,174,1,1,0,1),
(20953,20953,'Pobby',0,'',0,'LineageMonster.mandragora_a','15.00','26.00',57,'female','L2Monster',40,'1777.00000','862.00000','6.50000','2.40000',40,43,30,21,20,20,5071,421,'614.00000','340.00000','420.00000','207.00000',230,1,500,333,0,0,0,80,174,1,1,0,1),
(20954,20954,'Hungered Corpse',0,'',0,'LineageMonster.skeleton','11.00','25.00',60,'male','L2Monster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,5991,520,'711.00000','369.00000','491.00000','224.00000',230,1,0,333,123,945,0,60,180,1,1,0,1),
(20955,20955,'Ghostly Warrior',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',62,'male','L2Monster',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,6398,570,'780.00000','389.00000','535.00000','235.00000',230,1,0,333,299,0,0,50,180,1,1,0,1),
(20956,20956,'Past Knight',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',64,'male','L2Monster',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,6953,636,'853.00000','409.00000','584.00000','248.00000',230,1,500,333,150,103,0,40,174,1,1,0,1),
(20957,20957,'Nihil Invader',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,7250,683,'928.00000','429.00000','641.00000','260.00000',230,1,0,333,946,945,0,80,185,1,1,0,1),
(20958,20958,'Death Agent',0,'',0,'LineageMonster.death_blader','15.00','45.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,5411,523,'1006.00000','450.00000','695.00000','272.00000',230,1,0,333,1472,0,0,100,195,1,1,0,1),
(20959,20959,'Dark Guard',0,'',0,'LineageMonster.headless_knight','21.00','31.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,8318,824,'1086.00000','471.00000','749.00000','285.00000',230,1,500,333,124,0,0,70,170,1,1,0,1),
(20960,20960,'Bloody Ghost',0,'',0,'LineageMonster.succubus','10.00','36.00',64,'female','L2Monster',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,4793,439,'853.00000','409.00000','584.00000','248.00000',230,1,0,333,0,0,0,60,175,1,1,0,1),
(20961,20961,'Bloody Knight',0,'',0,'LineageMonster.doll_blader','6.00','12.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,7032,653,'890.00000','419.00000','615.00000','253.00000',230,1,0,333,5129,5129,0,22,175,1,1,0,1),
(20962,20962,'Bloody Priest',0,'',0,'LineageMonster.bloody_queen','14.00','40.00',66,'female','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,7827,737,'928.00000','429.00000','641.00000','260.00000',230,1,0,333,0,0,0,80,185,1,1,0,1),
(20963,20963,'Bloody Lord',0,'',0,'LineageMonster.banshee','9.00','23.00',68,'female','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,5630,544,'1006.00000','450.00000','695.00000','272.00000',230,1,500,333,3939,0,0,80,180,1,1,0,1),
(20964,20964,'Huge Footmark',0,'',0,'LineageMonster.stone_golem','20.00','31.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','285.00000',230,4,0,333,0,0,0,23,23,1,1,0,1),
(20965,20965,'Chimera Piece',0,'',0,'LineageMonster.will_o_wisp','13.00','22.00',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,22599,2237,'1209.00000','502.00000','830.00000','334.00000',230,1,0,333,0,0,0,80,140,1,1,1,1),
(20966,20966,'Changed Creation',0,'',0,'LineageMonster.leogul','15.00','35.00',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,31161,3114,'1251.00000','513.00000','863.00000','342.00000',230,4,0,333,0,0,0,80,170,1,1,1,1),
(20967,20967,'Past Creature',0,'',0,'LineageMonster.gamlin','11.00','32.00',76,'male','L2Monster',40,'2758.00000','1402.00000','8.50000','3.00000',40,43,30,21,20,20,22942,2360,'1349.00000','534.00000','931.00000','356.00000',230,4,0,333,0,0,0,80,170,1,1,1,1),
(20968,20968,'Nonexistent Man',0,'',0,'LineageMonster.susceptor','20.00','35.00',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,27816,2944,'1475.00000','556.00000','1012.00000','370.00000',230,1,0,333,0,0,0,27,150,1,1,1,1),
(20969,20969,'Giant\'s Shadow',0,'',0,'LineageMonster.lesser_giant_shooter','50.00','44.00',78,'male','L2Monster',1100,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,36095,3804,'1475.00000','556.00000','1012.00000','370.00000',230,8,0,333,4028,0,0,80,180,1,1,1,1),
(20970,20970,'Soldier of Ancient Times',0,'',0,'LineageMonster.lesser_giant','50.00','44.00',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,22599,2237,'1209.00000','502.00000','830.00000','334.00000',230,4,0,333,3937,0,0,15,180,1,1,1,1),
(20971,20971,'Warrior of Ancient Times',0,'',0,'LineageMonster.lesser_giant','50.00','44.00',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,23855,2420,'1293.00000','524.00000','891.00000','348.00000',230,4,0,333,3937,0,0,15,180,1,1,1,1),
(20972,20972,'Shaman of Ancient Times',0,'',0,'LineageMonster.lesser_giant_mage','50.00','44.00',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,24719,2511,'1293.00000','524.00000','891.00000','348.00000',230,1,0,333,3938,0,0,15,180,1,1,1,1),
(20973,20973,'Forgotten Ancient People',0,'',0,'LineageMonster.lesser_giant_mage','50.00','44.00',77,'male','L2Monster',40,'2857.00000','1432.00000','8.50000','3.00000',40,43,30,21,20,20,31618,3281,'1410.00000','545.00000','968.00000','363.00000',230,1,0,333,3938,0,0,15,180,1,1,1,1),
(20974,20974,'Spiteful Soul Leader',0,'',0,'LineageMonster.skeleton_royal_guard_bi','16.00','44.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,14127,1313,'890.00000','419.00000','615.00000','279.00000',230,4,0,333,946,945,0,80,174,1,1,0,1),
(20975,20975,'Spiteful Soul Wizard',0,'',0,'LineageMonster.elf_ghost_50_bi','10.00','32.00',63,'male','L2Monster',40,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,12599,1138,'816.00000','399.00000','559.00000','242.00000',230,4,0,333,0,0,0,80,174,1,1,0,1),
(20976,20976,'Spiteful Soul Fighter',0,'',0,'LineageMonster.human_ghost_50_bi','12.00','33.00',62,'male','L2Monster',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,10694,953,'780.00000','389.00000','535.00000','235.00000',230,4,0,333,0,0,0,80,174,1,1,0,1),
(20977,20977,'Elmoradan\'s Lady',0,'',0,'LineageMonster.banshee_50_bi','13.50','38.00',65,'female','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,18033,1675,'890.00000','419.00000','615.00000','253.00000',230,1,500,333,3939,0,0,80,160,1,1,0,1),
(20978,20978,'Elmoradan\'s Archer Escort',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',64,'male','L2Monster',1100,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,17930,1642,'853.00000','409.00000','584.00000','248.00000',230,8,0,333,284,0,0,40,140,1,1,0,1),
(20979,20979,'Elmoradan\'s Maid',0,'',0,'LineageMonster.doll_blader','6.00','12.00',64,'male','L2Monster',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,17139,1570,'853.00000','409.00000','584.00000','248.00000',230,4,0,333,5129,5129,0,22,170,1,1,0,1),
(20980,20980,'Hallate\'s Follower Mul',0,'',0,'LineageMonster.vale_master','12.00','40.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,18255,1764,'1006.00000','450.00000','695.00000','272.00000',230,1,500,333,210,0,0,70,170,1,1,0,1),
(20981,20981,'Mul\'s Wizard',0,'',0,'LineageMonster.kaim_vanul_50_bi','36.00','60.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,18154,1729,'967.00000','439.00000','663.00000','266.00000',230,1,0,333,0,0,0,37,160,1,1,0,1),
(20982,20982,'Mul\'s Knight',0,'',0,'LineageMonster.dre_vanul_100_bi','28.00','75.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,16025,1526,'967.00000','439.00000','663.00000','266.00000',230,8,0,333,0,0,0,80,143,1,1,0,1),
(20983,20983,'Binder',0,'',0,'LineageMonster.kel_mahum_champion_50_bi','19.00','48.00',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,24823,2554,'1209.00000','502.00000','830.00000','304.00000',230,4,500,333,147,0,0,50,170,1,1,0,1),
(20984,20984,'Bound Warrior',0,'',0,'LineageMonster.kel_mahum_warrior','13.00','28.00',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,23326,2370,'1168.00000','492.00000','801.00000','298.00000',230,4,0,333,148,0,0,50,160,1,1,0,1),
(20985,20985,'Bound Archer',0,'',0,'LineageMonster.kel_mahum_archer','13.00','27.00',72,'male','L2Monster',1100,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,23154,2352,'1168.00000','492.00000','801.00000','298.00000',230,8,0,333,288,0,0,50,170,1,1,0,1),
(20986,20986,'Sairon',0,'',0,'LineageMonster.doll_blader_50_bi','9.00','20.50',54,'male','L2Monster',40,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,13258,1057,'526.00000','313.00000','364.00000','189.00000',230,4,500,333,5129,5129,0,22,174,1,1,0,1),
(20987,20987,'Sairon\'s Doll',0,'',0,'LineageMonster.doll_blader','6.00','12.00',53,'male','L2Monster',40,'1571.00000','757.00000','6.50000','2.40000',40,43,30,21,20,20,12060,948,'498.00000','304.00000','344.00000','184.00000',230,4,0,333,5129,5129,0,22,174,1,1,0,1),
(20988,20988,'Sairon\'s Puppet',0,'',0,'LineageMonster.doll_blader','6.00','12.00',53,'male','L2Monster',40,'1571.00000','757.00000','6.50000','2.40000',40,43,30,21,20,20,13265,1043,'498.00000','304.00000','344.00000','184.00000',230,4,0,333,5129,5129,0,22,174,1,1,0,1),
(20989,20989,'Lageos',0,'',0,'LineageMonster.marsh_stakato_drone_50_bi','13.00','37.00',38,'male','L2Monster',40,'886.00000','407.00000','4.50000','1.80000',40,43,30,21,20,20,3299,205,'197.00000','189.00000','137.00000','114.00000',230,4,0,333,182,0,0,80,174,1,1,0,1),
(20990,20990,'Pageos',0,'',0,'LineageMonster.marsh_stakato_soldier','10.00','25.00',38,'male','L2Monster',40,'886.00000','407.00000','4.50000','1.80000',40,43,30,21,20,20,3132,196,'197.00000','189.00000','137.00000','114.00000',230,4,0,333,128,0,0,30,174,1,1,0,1),
(20991,20991,'Swamp Tribe',0,'',0,'LineageMonster.farhite_50_bi','24.00','48.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,12334,858,'313.00000','238.00000','212.00000','144.00000',230,4,500,333,5131,0,0,15,174,1,1,0,1),
(20992,20992,'Swamp Alligator',0,'',0,'LineageMonster.crokian','18.00','29.00',44,'male','L2Monster',40,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,11042,756,'293.00000','231.00000','199.00000','139.00000',230,4,0,333,5128,0,0,18,174,1,1,0,1),
(20993,20993,'Swamp Warrior',0,'',0,'LineageMonster.dailaon','20.00','28.00',44,'male','L2Monster',1100,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,11717,802,'293.00000','231.00000','199.00000','139.00000',230,8,0,333,5127,0,0,18,174,1,1,0,1),
(20994,20994,'Garden Guard Leader',0,'',0,'LineageMonster.doll_master_50_bi','30.00','63.00',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,14866,1120,'421.00000','278.00000','286.00000','169.00000',230,4,500,333,0,0,0,80,174,1,1,0,1),
(20995,20995,'Garden Guard',0,'',0,'LineageMonster.theeder','9.00','32.00',48,'male','L2Monster',40,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,10134,740,'375.00000','262.00000','260.00000','159.00000',230,4,0,333,94,0,0,80,174,1,1,0,1),
(20996,20996,'Spiteful Ghost of Ruins',0,'',0,'LineageMonster.zombie','13.00','21.00',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,6419,484,'421.00000','278.00000','286.00000','169.00000',230,1,500,333,0,0,0,15,15,1,1,0,1),
(20997,20997,'Soldier of Grief',0,'',0,'LineageMonster.unpleasant_humming','12.00','26.00',51,'male','L2Monster',40,'1470.00000','706.00000','6.50000','2.40000',40,43,30,21,20,20,4539,346,'446.00000','287.00000','309.00000','174.00000',230,1,0,333,0,0,0,21,150,1,1,0,1),
(20998,20998,'Cruel Punisher',0,'',0,'LineageMonster.hungry_spirit','13.00','40.00',52,'male','L2Monster',40,'1520.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,5002,386,'472.00000','295.00000','321.00000','179.00000',230,1,0,333,0,0,0,15,120,1,1,0,1),
(20999,20999,'Roving Soul',0,'',0,'LineageMonster.skeleton','11.00','25.00',53,'male','L2Monster',40,'1571.00000','757.00000','6.50000','2.40000',40,43,30,21,20,20,5932,467,'498.00000','304.00000','344.00000','184.00000',230,8,0,333,75,0,0,60,160,1,1,0,1),
(21000,21000,'Soul of Ruins',0,'',0,'LineageMonster.human_ghost','8.00','22.00',54,'male','L2Monster',40,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,5191,414,'526.00000','313.00000','364.00000','189.00000',230,4,500,333,0,0,0,80,174,1,1,0,1),
(21001,21001,'Wretched Archer',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',55,'male','L2Monster',1100,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,7028,568,'554.00000','322.00000','384.00000','195.00000',230,8,0,333,282,0,0,40,174,1,1,1,1),
(21002,21002,'Doom Scout',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',56,'male','L2Monster',40,'1725.00000','836.00000','6.50000','2.40000',40,43,30,21,20,20,6197,509,'583.00000','331.00000','404.00000','201.00000',230,8,500,333,242,2496,0,80,174,1,1,1,1),
(21003,21003,'Grave Lich',0,'',0,'LineageMonster.liviona','15.00','28.00',57,'male','L2Monster',40,'1777.00000','862.00000','6.50000','2.40000',40,43,30,21,20,20,5670,472,'614.00000','340.00000','420.00000','207.00000',230,4,0,333,0,0,0,80,174,1,1,1,1),
(21004,21004,'Dismal Pole',0,'',0,'LineageMonster.hanged_man_ripper','35.00','80.00',58,'male','L2Monster',80,'1828.00000','889.00000','6.50000','2.40000',40,43,30,21,20,20,6288,532,'646.00000','350.00000','447.00000','212.00000',230,4,500,333,0,0,0,55,174,1,1,1,1),
(21005,21005,'Grave Predator',0,'',0,'LineageMonster.devastator','35.00','35.00',59,'male','L2Monster',40,'1881.00000','916.00000','6.50000','2.40000',40,43,30,21,20,20,6878,588,'678.00000','359.00000','464.00000','218.00000',230,4,500,333,0,0,0,25,174,1,1,1,1),
(21006,21006,'Doom Servant',0,'',0,'LineageMonster.hungry_spirit','13.00','40.00',60,'male','L2Monster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,6537,568,'711.00000','369.00000','491.00000','224.00000',230,1,500,333,0,0,0,15,174,1,1,0,1),
(21007,21007,'Doom Guard',0,'',0,'LineageMonster.hungry_spirit','13.00','40.00',61,'male','L2Monster',40,'1985.00000','970.00000','7.50000','2.70000',40,43,30,21,20,20,7014,617,'745.00000','379.00000','510.00000','230.00000',230,1,0,333,0,0,0,15,174,1,1,0,1),
(21008,21008,'Doom Archer',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',62,'male','L2Monster',1100,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,8965,799,'780.00000','389.00000','535.00000','235.00000',230,8,500,333,286,0,0,40,174,1,1,0,1),
(21009,21009,'Doom Trooper',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',63,'male','L2Monster',80,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,9559,863,'816.00000','399.00000','559.00000','242.00000',230,4,0,333,301,0,0,50,174,1,1,0,1),
(21010,21010,'Doom Warrior',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',64,'male','L2Monster',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,7656,701,'853.00000','409.00000','584.00000','248.00000',230,8,0,333,71,0,0,40,174,1,1,0,1),
(21011,21011,'Ol Mahum Van Grunt',0,'',0,'LineageMonster.ol_mahum','13.50','25.00',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,1571,86,'109.00000','141.00000','77.00000','85.00000',230,4,0,333,5,0,0,50,150,1,1,1,1),
(21012,21012,'Magical Eye',0,'',0,'LineageMonster.magical_weaver','11.00','20.00',31,'male','L2Monster',40,'636.00000','313.00000','4.50000','1.80000',40,43,30,21,20,20,2084,115,'118.00000','146.00000','83.00000','89.00000',230,4,500,333,0,0,0,90,150,1,1,1,1),
(21013,21013,'Ol Mahum Van Archer',0,'',0,'LineageMonster.ol_mahum_archer','14.00','25.00',32,'male','L2Monster',1100,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,2305,130,'128.00000','152.00000','85.00000','92.00000',230,8,0,333,273,0,0,50,150,1,1,1,1),
(21014,21014,'Lesser Warlike Tyrant',0,'',0,'LineageMonster.grave','15.00','29.00',33,'male','L2Monster',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,2385,137,'138.00000','158.00000','96.00000','96.00000',230,4,500,333,0,0,0,70,150,1,1,1,1),
(21015,21015,'Ol Mahum Van Leader',0,'',0,'LineageMonster.ol_mahum_champion','14.00','27.00',34,'male','L2Monster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,2449,143,'148.00000','164.00000','99.00000','99.00000',230,4,500,333,67,0,0,50,150,1,1,1,1),
(21016,21016,'Warlike Tyrant',0,'',0,'LineageMonster.grave','15.00','29.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,2631,156,'159.00000','170.00000','111.00000','102.00000',230,4,0,333,0,0,0,70,174,1,1,1,1),
(21017,21017,'Fallen Orc',0,'',0,'LineageMonster.ketra_orc','12.00','29.00',55,'male','L2Monster',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,5279,426,'554.00000','322.00000','384.00000','195.00000',230,4,0,333,127,0,0,45,174,1,1,1,1),
(21018,21018,'Ancient Gargoyle',0,'',0,'LineageMonster.hunter_gargoyle','25.00','65.00',56,'male','L2Monster',40,'1725.00000','836.00000','6.50000','2.40000',40,43,30,21,20,20,6643,546,'583.00000','331.00000','404.00000','201.00000',230,4,500,333,0,0,0,100,174,1,1,1,1),
(21019,21019,'Fallen Orc Archer',0,'',0,'LineageMonster.ketra_orc_archer','12.00','27.00',57,'male','L2Monster',1100,'1777.00000','862.00000','6.50000','2.40000',40,43,30,21,20,20,7312,607,'614.00000','340.00000','420.00000','207.00000',230,8,0,333,279,0,0,45,174,1,1,1,1),
(21020,21020,'Fallen Orc Shaman',0,'',0,'LineageMonster.ketra_orc_shaman','10.00','23.00',58,'male','L2Monster',40,'1828.00000','889.00000','6.50000','2.40000',40,43,30,21,20,20,8278,700,'646.00000','350.00000','447.00000','212.00000',230,1,0,333,9,0,0,10,174,1,1,1,1),
(21021,21021,'Sharp Talon Tiger',0,'',0,'LineageMonster.saber_toothed_tiger','34.00','28.00',59,'male','L2Monster',40,'1881.00000','916.00000','6.50000','2.40000',40,43,30,21,20,20,7625,652,'678.00000','359.00000','464.00000','218.00000',230,1,500,333,0,0,0,60,174,1,1,1,1),
(21022,21022,'Fallen Orc Captain',0,'',0,'LineageMonster.ketra_orc_warrior','12.00','24.00',60,'male','L2Monster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,7754,673,'711.00000','369.00000','491.00000','224.00000',230,1,500,333,160,0,0,36,174,1,1,1,1),
(21023,21023,'Sobbing Wind',0,'',0,'LineageMonster.sylph','11.00','35.00',26,'female','L2Monster',40,'487.00000','248.00000','3.50000','1.50000',40,43,30,21,20,20,1268,64,'79.00000','121.00000','57.00000','73.00000',230,1,0,333,0,0,0,60,150,1,1,1,1),
(21024,21024,'Babbling Wind',0,'',0,'LineageMonster.sylph','11.00','35.00',27,'female','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,1336,68,'87.00000','126.00000','62.00000','76.00000',230,1,0,333,0,0,0,60,150,1,1,1,1),
(21025,21025,'Giggling Wind',0,'',0,'LineageMonster.sylph','11.00','35.00',28,'female','L2Monster',40,'544.00000','274.00000','3.50000','1.50000',40,43,30,21,20,20,1414,74,'93.00000','131.00000','67.00000','80.00000',230,1,0,333,0,0,0,60,150,1,1,1,1),
(21026,21026,'Singing Wind',0,'',0,'LineageMonster.sylph','11.00','35.00',29,'female','L2Monster',40,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,1522,82,'101.00000','136.00000','72.00000','82.00000',230,1,500,333,0,0,0,60,150,1,1,1,1),
(21034,21034,'Ogre',0,'',0,'LineageMonster.ogre','21.00','44.00',38,'male','L2Monster',40,'886.00000','407.00000','4.50000','1.80000',40,43,30,21,20,20,2157,134,'197.00000','189.00000','137.00000','114.00000',230,1,500,333,98,0,0,22,174,1,1,1,1),
(21035,21035,'Catherok',0,'',0,'LineageMonster.marsh_stakato_soldier','10.00','25.00',42,'male','L2Monster',40,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,6978,443,'258.00000','216.00000','174.00000','143.00000',230,4,500,333,144,0,0,30,155,1,1,0,1),
(21036,21036,'Shindebarn',0,'',0,'LineageMonster.magical_weaver','11.00','20.00',44,'male','L2Monster',40,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,8166,536,'293.00000','231.00000','199.00000','153.00000',230,1,0,333,0,0,0,90,90,1,1,0,1),
(21037,21037,'Ossiud',0,'',0,'LineageMonster.field_stalker','16.00','36.00',47,'male','L2Monster',40,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,10557,727,'353.00000','254.00000','244.00000','169.00000',230,4,500,333,0,0,0,70,110,1,1,0,1),
(21038,21038,'Liangma',0,'',0,'LineageMonster.will_o_wisp','13.00','22.00',49,'male','L2Monster',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,8025,560,'398.00000','270.00000','275.00000','180.00000',230,1,500,333,0,0,0,80,140,1,1,0,1),
(21039,21039,'Snipe Cohort',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',43,'male','L2Monster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,7953,515,'275.00000','223.00000','191.00000','148.00000',230,4,0,333,0,0,0,30,120,1,1,0,1),
(21040,21040,'Soldier of Darkness',0,'',0,'LineageMonster.death_knight','12.00','30.00',49,'male','L2Monster',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,12649,899,'398.00000','270.00000','275.00000','180.00000',230,4,0,333,127,0,0,27,110,1,1,0,1),
(21058,21058,'Beast Lord',0,'',0,'LineageMonster.saber_toothed_tiger','34.00','28.00',60,'male','L2Monster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,18913,1642,'711.00000','369.00000','491.00000','224.00000',230,1,500,333,0,0,0,60,174,1,1,0,1),
(21059,21059,'Beast Guardian',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',59,'male','L2Monster',40,'1881.00000','916.00000','6.50000','2.40000',40,43,30,21,20,20,15095,1290,'678.00000','359.00000','464.00000','218.00000',230,1,0,333,0,0,0,30,174,1,1,0,1),
(21060,21060,'Beast Seer',0,'',0,'LineageMonster.field_stalker','16.00','36.00',59,'male','L2Monster',40,'1881.00000','916.00000','6.50000','2.40000',40,43,30,21,20,20,15095,1290,'678.00000','359.00000','464.00000','218.00000',230,1,0,333,0,0,0,70,174,1,1,0,1),
(21061,21061,'Hallate\'s Guardian',0,'',0,'LineageMonster.kaim_vanul','24.00','40.00',69,'male','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,30701,3004,'1046.00000','460.00000','717.00000','279.00000',230,1,500,333,0,0,0,37,174,1,1,0,1),
(21062,21062,'Messenger Angel',0,'',0,'LineageMonster.angel','13.50','36.50',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,0,0,'1086.00000','471.00000','749.00000','285.00000',230,1,500,333,148,0,0,30,174,1,1,0,1),
(21063,21063,'Messenger Angel',0,'',0,'LineageMonster.angel','13.50','36.50',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,62784,6226,'1086.00000','471.00000','749.00000','285.00000',230,1,500,333,148,0,0,30,174,1,1,0,1),
(21064,21064,'Platinum Guardian Archer',0,'',0,'LineageMonster.kel_mahum_archer','13.00','27.00',71,'male','L2Monster',1100,'2493.00000','1253.00000','8.50000','3.00000',40,43,30,21,20,20,38444,3858,'1127.00000','481.00000','778.00000','292.00000',230,8,500,333,288,0,0,50,174,1,1,0,1),
(21065,21065,'Platinum Guardian Warrior',0,'',0,'LineageMonster.kel_mahum_warrior','13.00','28.00',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,36221,3680,'1168.00000','492.00000','801.00000','298.00000',230,1,500,333,148,0,0,50,174,1,1,0,1),
(21066,21066,'Platinum Guardian Shaman',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13.00','25.00',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,39180,4032,'1209.00000','502.00000','830.00000','304.00000',230,1,500,333,202,0,0,50,174,1,1,0,1),
(21067,21067,'Guardian Archangel',0,'',0,'LineageMonster.angel','13.50','36.50',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1251.00000','513.00000','863.00000','311.00000',230,1,500,333,148,0,0,30,174,1,1,0,1),
(21068,21068,'Guardian Archangel',0,'',0,'LineageMonster.angel','13.50','36.50',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,85242,8886,'1251.00000','513.00000','863.00000','311.00000',230,1,500,333,148,0,0,30,174,1,1,0,1),
(21069,21069,'Platinum Guardian Prefect',0,'',0,'LineageMonster.kel_mahum_champion','13.00','32.00',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,53456,5573,'1251.00000','513.00000','863.00000','311.00000',230,4,500,333,147,0,0,50,174,1,1,0,1),
(21070,21070,'Seal Archangel',0,'',0,'LineageMonster.angel','13.50','36.50',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,0,0,'1293.00000','524.00000','891.00000','317.00000',230,1,500,333,148,0,0,30,174,1,1,0,1),
(21071,21071,'Seal Archangel',0,'',0,'LineageMonster.angel','13.50','36.50',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,88404,9325,'1293.00000','524.00000','891.00000','317.00000',230,1,500,333,148,0,0,30,174,1,1,0,1),
(21072,21072,'Platinum Guardian Chief',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13.00','25.00',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,40513,4273,'1293.00000','524.00000','891.00000','317.00000',230,1,500,333,202,0,0,50,174,1,1,0,1),
(21073,21073,'Guardian Warrior of Elmoreden',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',64,'male','L2Monster',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,16897,1547,'853.00000','409.00000','584.00000','248.00000',230,4,0,333,84,0,0,40,174,1,1,0,1),
(21074,21074,'Bound Shaman',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13.00','25.00',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,23163,2353,'1168.00000','492.00000','801.00000','298.00000',230,1,0,333,202,0,0,50,174,1,1,0,1),
(21075,21075,'Slaughter Bathin',0,'',0,'LineageMonster.death_knight','12.00','30.00',63,'male','L2Monster',40,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,16790,1516,'816.00000','399.00000','559.00000','242.00000',230,4,500,333,84,0,0,27,174,1,1,0,1),
(21076,21076,'Bathin\'s Knight',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',62,'male','L2Monster',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,16516,1471,'780.00000','389.00000','535.00000','235.00000',230,1,0,333,78,0,0,40,174,1,1,0,1),
(21077,21077,'Bathin\'s Wizard',0,'',0,'LineageMonster.banshee','9.00','23.00',62,'female','L2Monster',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,16007,1427,'780.00000','389.00000','535.00000','235.00000',230,1,0,333,3939,0,0,80,174,1,1,0,1),
(21078,21078,'Magus Valac',0,'',0,'LineageMonster.vale_master','12.00','40.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,20355,2018,'1086.00000','471.00000','749.00000','285.00000',230,1,500,333,198,0,0,70,174,1,1,0,1),
(21079,21079,'Valac\'s Creature',0,'',0,'LineageMonster.serpent_slave','17.00','46.00',69,'male','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,18497,1810,'1046.00000','460.00000','717.00000','279.00000',230,4,0,333,150,0,0,70,174,1,1,0,1),
(21080,21080,'Valac\'s Guardian Spirit',0,'',0,'LineageMonster.shadow','10.00','30.00',69,'male','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,17096,1673,'1046.00000','460.00000','717.00000','279.00000',230,8,0,333,0,0,0,80,174,1,1,0,1),
(21081,21081,'Power Angel Amon',0,'',0,'LineageMonster.angel','13.50','36.50',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,21329,2250,'1293.00000','524.00000','891.00000','317.00000',230,1,500,333,4700,0,0,30,174,1,1,0,1),
(21082,21082,'Amon\'s Captain of the Guards',0,'',0,'LineageMonster.kel_mahum_champion','13.00','32.00',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,20511,2138,'1251.00000','513.00000','863.00000','311.00000',230,4,0,333,150,0,0,50,174,1,1,0,1),
(21083,21083,'Amon\'s Spirits',0,'',0,'LineageMonster.pixy','5.00','25.00',74,'female','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,24232,2526,'1251.00000','513.00000','863.00000','311.00000',230,1,0,333,0,0,0,80,174,1,1,0,1),
(21084,21084,'Bloody Lady',0,'',0,'LineageMonster.bloody_queen','14.00','40.00',60,'female','L2Monster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,14806,1285,'711.00000','369.00000','491.00000','224.00000',230,4,500,333,0,0,0,80,174,1,1,0,1),
(21085,21085,'Bloody Sniper',0,'',0,'LineageMonster.fiend_archer','17.00','55.00',71,'male','L2Monster',1100,'2493.00000','1253.00000','8.50000','3.00000',40,43,30,21,20,20,33449,3356,'1127.00000','481.00000','778.00000','292.00000',230,8,500,333,0,0,0,70,174,1,1,0,1),
(21086,21086,'Bloody Liviona',0,'',0,'LineageMonster.liviona','15.00','28.00',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,33396,3392,'1168.00000','492.00000','801.00000','298.00000',230,4,500,333,0,0,0,80,174,1,1,0,1),
(21087,21087,'Bloody Knight',0,'',0,'LineageMonster.death_knight','12.00','30.00',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,53594,5514,'1209.00000','502.00000','830.00000','304.00000',230,4,500,333,84,0,0,27,174,1,1,0,1),
(21088,21088,'Bloody Banshee',0,'',0,'LineageMonster.banshee','9.00','23.00',74,'female','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,35277,3677,'1251.00000','513.00000','863.00000','311.00000',230,4,500,333,3939,0,0,80,174,1,1,0,1),
(21089,21089,'Bloody Lord',0,'',0,'LineageMonster.karik','25.00','90.00',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,40903,4314,'1293.00000','524.00000','891.00000','317.00000',230,4,500,333,0,0,0,37,174,1,1,0,1),
(21090,21090,'Bloody Guardian',0,'',0,'LineageMonster.death_blader','15.00','45.00',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,31444,3317,'1293.00000','524.00000','891.00000','317.00000',230,4,500,333,1472,0,0,100,174,1,1,0,1),
(21091,21091,'Bloody Keeper',0,'',0,'LineageMonster.kaim_vanul','24.00','40.00',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,21195,2209,'1251.00000','513.00000','863.00000','311.00000',230,4,0,333,0,0,0,37,174,1,1,0,1),
(21092,21092,'Bloody Mystic',0,'',0,'LineageMonster.banshee','9.00','23.00',74,'female','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,20706,2159,'1251.00000','513.00000','863.00000','311.00000',230,4,0,333,3939,0,0,80,174,1,1,0,1),
(21093,21093,'Ratman Sub Chieftain',0,'',0,'LineageMonster.wererat','14.00','25.00',19,'male','L2Monster',40,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,692,31,'44.00000','91.00000','32.00000','55.00000',230,4,400,333,216,0,0,80,150,1,1,1,1),
(21094,21094,'Ratman Chieftain',0,'',0,'LineageMonster.wererat','14.00','25.00',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,713,32,'48.00000','95.00000','30.00000','57.00000',230,4,0,333,3,0,0,80,155,1,1,1,1),
(21095,21095,'Giant Poison Bee',0,'',0,'LineageMonster.giant_bee','8.00','24.50',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,1009,47,'53.00000','99.00000','38.00000','60.00000',230,8,0,333,0,0,0,90,90,1,1,1,1),
(21096,21096,'Cloudy Beast',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,1005,48,'57.00000','103.00000','36.00000','62.00000',230,4,400,333,0,0,0,30,140,1,1,1,1),
(21097,21097,'Young Araneid',0,'',0,'LineageMonster.poison_spider','27.00','25.50',23,'male','L2Monster',40,'411.00000','211.00000','3.50000','1.50000',40,43,30,21,20,20,1183,58,'62.00000','107.00000','40.00000','65.00000',230,4,400,333,0,0,0,60,130,1,1,1,1),
(21098,21098,'Plain Grizzly',0,'',0,'LineageMonster.grizzly','21.00','40.00',24,'male','L2Monster',40,'435.00000','224.00000','3.50000','1.50000',40,43,30,21,20,20,1123,55,'68.00000','112.00000','48.00000','67.00000',230,4,0,333,0,0,0,40,115,1,1,1,1),
(21099,21099,'Cloudy Beast Turen',0,'',0,'LineageMonster.onyx_beast','14.00','14.50',25,'male','L2Monster',40,'461.00000','236.00000','3.50000','1.50000',40,43,30,21,20,20,1215,61,'73.00000','116.00000','52.00000','70.00000',230,4,400,333,0,0,0,30,145,1,1,1,1),
(21100,21100,'Langk Lizardman Sentinel',0,'',0,'LineageMonster.virud_lizardman','10.00','23.00',19,'male','L2Monster',40,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,692,31,'44.00000','91.00000','32.00000','55.00000',230,4,500,333,2,0,0,43,130,1,1,1,1),
(21101,21101,'Langk Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman','10.00','29.00',24,'male','L2Monster',40,'435.00000','224.00000','3.50000','1.50000',40,43,30,21,20,20,1123,55,'68.00000','112.00000','48.00000','67.00000',230,1,0,333,6,0,0,43,130,1,1,1,1),
(21102,21102,'Watchman of the Plains',0,'',0,'LineageMonster.magical_weaver','11.00','20.00',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,1602,88,'109.00000','141.00000','77.00000','85.00000',230,1,500,333,0,0,0,90,160,1,1,1,1),
(21103,21103,'Roughly Hewn Rock Golem',0,'',0,'LineageMonster.stone_golem_bi','20.00','40.30',31,'male','L2Monster',40,'636.00000','313.00000','4.50000','1.80000',40,43,30,21,20,20,1677,94,'118.00000','146.00000','83.00000','89.00000',230,1,0,333,0,0,0,23,23,1,1,1,1),
(21104,21104,'Delu Lizardman Supplier',0,'',0,'LineageMonster.virud_lizardman','10.00','23.00',32,'male','L2Monster',40,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,2106,119,'128.00000','152.00000','85.00000','92.00000',230,8,0,333,223,0,0,43,135,1,1,1,1),
(21105,21105,'Delu Lizardman Special Agent',0,'',0,'LineageMonster.virud_lizardman_scout','10.00','22.00',33,'male','L2Monster',1100,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,2427,139,'138.00000','158.00000','96.00000','96.00000',230,8,0,333,2507,0,0,43,135,1,1,1,1),
(21106,21106,'Cursed Seer',0,'',0,'LineageMonster.magical_weaver','11.00','20.00',34,'male','L2Monster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,2058,120,'148.00000','164.00000','99.00000','99.00000',230,1,500,333,0,0,0,90,160,1,1,1,1),
(21107,21107,'Delu Lizardman Commander',0,'',0,'LineageMonster.virud_lizardman_warrior','12.00','30.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,4354,258,'159.00000','170.00000','111.00000','102.00000',230,4,0,333,93,0,0,52,135,1,1,1,1),
(21108,21108,'Glow Wisp',0,'',0,'LineageMonster.will_o_wisp','13.00','22.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,7835,746,'967.00000','439.00000','663.00000','266.00000',230,1,0,333,0,0,0,80,160,1,1,1,1),
(21109,21109,'Hames Orc Scout',0,'',0,'LineageMonster.ketra_orc','12.00','29.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,9699,937,'1006.00000','450.00000','695.00000','272.00000',230,8,0,333,229,0,0,45,185,1,1,1,1),
(21110,21110,'Marsh Predator',0,'',0,'LineageMonster.devastator','35.00','35.00',69,'male','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,8268,809,'1046.00000','460.00000','717.00000','279.00000',230,4,0,333,0,0,0,25,175,1,1,1,1),
(21111,21111,'Lava Wyrm',0,'',0,'LineageMonster.wyrm','29.00','72.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,8637,857,'1086.00000','471.00000','749.00000','285.00000',230,4,500,333,0,0,0,70,175,1,1,1,1),
(21112,21112,'Hames Orc Footman',0,'',0,'LineageMonster.ketra_orc','12.00','29.00',71,'male','L2Monster',40,'2493.00000','1253.00000','8.50000','3.00000',40,43,30,21,20,20,10470,1050,'1127.00000','481.00000','778.00000','292.00000',230,4,0,333,233,110,0,45,180,1,1,1,1),
(21113,21113,'Hames Orc Sniper',0,'',0,'LineageMonster.ketra_orc_archer','12.00','27.00',72,'male','L2Monster',1100,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,11667,1186,'1168.00000','492.00000','801.00000','298.00000',230,8,0,333,287,0,0,45,160,1,1,1,1),
(21114,21114,'Cursed Guardian',0,'',0,'LineageMonster.death_blader','15.00','45.00',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,11078,1140,'1209.00000','502.00000','830.00000','304.00000',230,4,0,333,1472,0,0,100,175,1,1,1,1),
(21115,21115,'Hames Orc Shaman',0,'',0,'LineageMonster.ketra_orc_shaman','10.00','23.00',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,9652,1006,'1251.00000','513.00000','863.00000','311.00000',230,1,0,333,186,0,0,10,145,1,1,1,1),
(21116,21116,'Hames Orc Overlord',0,'',0,'LineageMonster.ketra_orc_warrior','12.00','24.00',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,15240,1608,'1293.00000','524.00000','891.00000','317.00000',230,4,500,333,75,103,0,36,175,1,1,1,1),
(21117,21117,'Kasha Imp',0,'',0,'LineageMonster.imp_bi','10.00','30.00',19,'male','L2Monster',40,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,678,30,'44.00000','91.00000','32.00000','55.00000',230,4,0,333,0,0,0,60,85,1,1,1,1),
(21118,21118,'Baar Dre Vanul',0,'',0,'LineageMonster.dre_vanul','14.00','36.00',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,727,32,'48.00000','95.00000','30.00000','57.00000',230,4,400,333,0,0,0,80,85,1,1,1,1),
(21119,21119,'Hobgoblin',0,'',0,'LineageMonster.hobgoblin','12.00','24.00',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,917,42,'53.00000','99.00000','38.00000','60.00000',230,1,0,333,4,0,0,45,110,1,1,1,1),
(21120,21120,'Kasha Imp Turen',0,'',0,'LineageMonster.imp_bi','10.00','30.00',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,1196,56,'57.00000','103.00000','36.00000','62.00000',230,4,400,333,0,0,0,60,85,1,1,1,1),
(21121,21121,'Kasha Dire Wolf',0,'',0,'LineageMonster.dire_wolf','13.00','11.00',23,'male','L2Monster',40,'411.00000','211.00000','3.50000','1.50000',40,43,30,21,20,20,1075,52,'62.00000','107.00000','40.00000','65.00000',230,4,400,333,0,0,0,24,135,1,1,1,1),
(21122,21122,'Kasha Bugbear',0,'',0,'LineageMonster.bugbear','17.00','35.00',24,'male','L2Monster',40,'435.00000','224.00000','3.50000','1.50000',40,43,30,21,20,20,1145,56,'68.00000','112.00000','48.00000','67.00000',230,1,400,333,169,0,0,55,130,1,1,1,1),
(21123,21123,'Baar Dre Vanul Destroyer',0,'',0,'LineageMonster.dre_vanul','14.00','36.00',25,'male','L2Monster',40,'461.00000','236.00000','3.50000','1.50000',40,43,30,21,20,20,1521,76,'73.00000','116.00000','52.00000','70.00000',230,4,400,333,0,0,0,80,85,1,1,1,1),
(21124,21124,'Red Eye Barbed Bat',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',18,'male','L2Monster',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,640,28,'40.00000','87.00000','25.00000','52.00000',230,4,0,333,0,0,0,60,90,1,1,1,1),
(21125,21125,'Northern Trimden',0,'',0,'LineageMonster.poison_spider','27.00','25.50',19,'male','L2Monster',40,'322.00000','166.00000','2.50000','1.20000',40,43,30,21,20,20,685,31,'44.00000','91.00000','32.00000','55.00000',230,4,400,333,0,0,0,60,140,1,1,1,1),
(21126,21126,'Kerope Werewolf',0,'',0,'LineageMonster.werewolf_bi','11.00','29.70',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,713,32,'48.00000','95.00000','30.00000','57.00000',230,1,0,333,0,0,0,50,125,1,1,1,1),
(21127,21127,'Northern Goblin',0,'',0,'LineageMonster2.northern_goblin','4.00','15.00',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,917,42,'53.00000','99.00000','38.00000','60.00000',230,1,0,333,152,0,0,30,120,1,1,1,1),
(21128,21128,'Spine Golem',0,'',0,'LineageMonster.stone_golem_bi','20.00','40.30',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,986,47,'57.00000','103.00000','36.00000','62.00000',230,1,0,333,0,0,0,23,23,1,1,1,1),
(21129,21129,'Kerope Werewolf Chief',0,'',0,'LineageMonster.werewolf_bi','11.00','29.70',23,'male','L2Monster',40,'411.00000','211.00000','3.50000','1.50000',40,43,30,21,20,20,1075,52,'62.00000','107.00000','40.00000','65.00000',230,1,400,333,0,0,0,50,140,1,1,1,1),
(21130,21130,'Northern Goblin Leader',0,'',0,'LineageMonster2.northern_goblin','4.00','15.00',24,'male','L2Monster',40,'435.00000','224.00000','3.50000','1.50000',40,43,30,21,20,20,1145,56,'68.00000','112.00000','48.00000','67.00000',230,1,400,333,66,102,0,30,125,1,1,1,1),
(21131,21131,'Enchanted Spine Golem',0,'',0,'LineageMonster.stone_golem_bi','20.00','40.30',25,'male','L2Monster',40,'461.00000','236.00000','3.50000','1.50000',40,43,30,21,20,20,1191,60,'73.00000','116.00000','52.00000','70.00000',230,1,0,333,0,0,0,23,29,1,1,1,1),
(21132,21132,'Underground Kobold',0,'',0,'LineageMonster.kobold','10.00','15.00',24,'male','L2Monster',40,'435.00000','224.00000','3.50000','1.50000',40,43,30,21,20,20,935,46,'68.00000','112.00000','48.00000','67.00000',230,4,0,333,0,0,0,47,110,1,1,0,1),
(21133,21133,'Dead Pit Skeleton Archer',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',25,'male','L2Monster',1100,'461.00000','236.00000','3.50000','1.50000',40,43,30,21,20,20,1022,52,'73.00000','116.00000','52.00000','70.00000',230,8,0,333,274,0,0,40,130,1,1,0,1),
(21134,21134,'Dead Pit Spartoi',0,'',0,'LineageMonster.spartoi','11.00','27.00',26,'male','L2Monster',40,'487.00000','248.00000','3.50000','1.50000',40,43,30,21,20,20,1078,54,'79.00000','121.00000','57.00000','73.00000',230,4,400,333,219,0,0,60,145,1,1,0,1),
(21135,21135,'Underground Kobold Warrior',0,'',0,'LineageMonster.kobold','10.00','15.00',27,'male','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,1325,67,'87.00000','126.00000','62.00000','76.00000',230,4,0,333,0,0,0,47,115,1,1,0,1),
(21136,21136,'Dead Pit Horror',0,'',0,'LineageMonster.dark_horror','20.00','35.00',28,'male','L2Monster',40,'544.00000','274.00000','3.50000','1.50000',40,43,30,21,20,20,1178,62,'93.00000','131.00000','67.00000','80.00000',230,4,0,333,0,0,0,100,100,1,1,0,1),
(21137,21137,'Iron Ore Golem',0,'',0,'LineageMonster.iron_golem','18.00','34.00',29,'male','L2Monster',40,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,1268,68,'101.00000','136.00000','72.00000','82.00000',230,1,400,333,0,0,0,20,21,1,1,0,1),
(21138,21138,'Greedy Geist',0,'',0,'LineageMonster.hungry_spirit','13.00','40.00',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,1361,74,'109.00000','141.00000','77.00000','85.00000',230,1,0,333,0,0,0,15,150,1,1,0,1),
(21139,21139,'Catacomb Barbed Bat',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',23,'male','L2Monster',40,'411.00000','211.00000','3.50000','1.50000',40,43,30,21,20,20,2621,127,'62.00000','107.00000','40.00000','65.00000',230,4,500,333,0,0,0,60,130,1,1,0,1),
(21140,21140,'Catacomb Wisp',0,'',0,'LineageMonster.will_o_wisp','13.00','22.00',26,'male','L2Monster',40,'487.00000','248.00000','3.50000','1.50000',40,43,30,21,20,20,3153,159,'79.00000','121.00000','57.00000','73.00000',230,1,500,333,0,0,0,80,120,1,1,0,1),
(21141,21141,'Catacomb Serpent',0,'',0,'LineageMonster.serpent_slave','17.00','46.00',28,'male','L2Monster',40,'544.00000','274.00000','3.50000','1.50000',40,43,30,21,20,20,3706,194,'93.00000','131.00000','67.00000','80.00000',230,4,500,333,73,0,0,70,130,1,1,0,1),
(21142,21142,'Grave Keeper Spartoi',0,'',0,'LineageMonster.spartoi','11.00','27.00',29,'male','L2Monster',40,'573.00000','287.00000','3.50000','1.50000',40,43,30,21,20,20,3710,199,'101.00000','136.00000','72.00000','82.00000',230,4,500,333,221,0,0,60,140,1,1,0,1),
(21143,21143,'Catacomb Scavenger Bat',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',31,'male','L2Monster',40,'636.00000','313.00000','4.50000','1.80000',40,43,30,21,20,20,4170,231,'118.00000','146.00000','83.00000','89.00000',230,4,500,333,0,0,0,60,140,1,1,0,1),
(21144,21144,'Catacomb Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',34,'male','L2Monster',40,'737.00000','352.00000','4.50000','1.80000',40,43,30,21,20,20,5016,293,'148.00000','164.00000','99.00000','99.00000',230,1,500,333,0,0,0,80,130,1,1,0,1),
(21145,21145,'Catacomb Stakato Soldier',0,'',0,'LineageMonster.blade_stakato_soldier','15.00','38.00',38,'male','L2Monster',40,'886.00000','407.00000','4.50000','1.80000',40,43,30,21,20,20,6444,402,'197.00000','189.00000','137.00000','114.00000',230,4,500,333,232,0,0,25,150,1,1,0,1),
(21146,21146,'Grave Keeper Dark Horror',0,'',0,'LineageMonster.dark_horror','20.00','35.00',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,6943,448,'226.00000','202.00000','157.00000','122.00000',230,4,500,333,0,0,0,100,160,1,1,0,1),
(21147,21147,'Catacomb Gargoyle',0,'',0,'LineageMonster.gargoyle','16.00','50.00',43,'male','L2Monster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,8457,572,'275.00000','223.00000','191.00000','135.00000',230,4,500,333,0,0,0,140,170,1,1,0,1),
(21148,21148,'Catacomb Liviona',0,'',0,'LineageMonster.liviona','15.00','28.00',44,'male','L2Monster',40,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,8401,575,'293.00000','231.00000','199.00000','139.00000',230,1,500,333,0,0,0,80,140,1,1,0,1),
(21149,21149,'Decayed Ancient Pikeman',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',46,'male','L2Monster',40,'1230.00000','580.00000','5.50000','2.10000',40,43,30,21,20,20,9679,686,'332.00000','246.00000','231.00000','149.00000',230,4,500,333,96,0,0,50,170,1,1,0,1),
(21150,21150,'Decayed Ancient Soldier',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',49,'male','L2Monster',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,10982,812,'398.00000','270.00000','275.00000','164.00000',230,4,500,333,125,0,0,40,160,1,1,0,1),
(21151,21151,'Decayed Ancient Knight',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,11435,861,'421.00000','278.00000','286.00000','169.00000',230,4,500,333,227,0,0,80,170,1,1,0,1),
(21152,21152,'Purgatory Wisp',0,'',0,'LineageMonster.will_o_wisp','13.00','22.00',53,'male','L2Monster',40,'1571.00000','757.00000','6.50000','2.40000',40,43,30,21,20,20,12189,958,'498.00000','304.00000','344.00000','184.00000',230,1,500,333,0,0,0,80,150,1,1,0,1),
(21153,21153,'Purgatory Serpent',0,'',0,'LineageMonster.serpent_slave','17.00','46.00',56,'male','L2Monster',40,'1725.00000','836.00000','6.50000','2.40000',40,43,30,21,20,20,14344,1178,'583.00000','331.00000','404.00000','201.00000',230,4,500,333,73,0,0,70,175,1,1,0,1),
(21154,21154,'Hell Keeper Medusa',0,'',0,'LineageMonster.medusa','10.00','25.00',58,'female','L2Monster',40,'1828.00000','889.00000','6.50000','2.40000',40,43,30,21,20,20,15013,1268,'646.00000','350.00000','447.00000','212.00000',230,4,500,333,0,0,0,50,165,1,1,0,1),
(21155,21155,'Purgatory Conjurer',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',59,'male','L2Monster',40,'1881.00000','916.00000','6.50000','2.40000',40,43,30,21,20,20,15105,1291,'678.00000','359.00000','464.00000','218.00000',230,4,500,333,0,0,0,60,175,1,1,0,1),
(21156,21156,'Purgatory Shadow',0,'',0,'LineageMonster.shadow','10.00','30.00',61,'male','L2Monster',40,'1985.00000','970.00000','7.50000','2.70000',40,43,30,21,20,20,16146,1421,'745.00000','379.00000','510.00000','230.00000',230,1,500,333,0,0,0,80,155,1,1,0,1),
(21157,21157,'Purgatory Tarantula',0,'',0,'LineageMonster.poison_spider','27.00','25.50',64,'male','L2Monster',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,18280,1674,'853.00000','409.00000','584.00000','248.00000',230,4,500,333,0,0,0,60,175,1,1,0,1),
(21158,21158,'Hell Keeper Crimson Doll',0,'',0,'LineageMonster.crimson_doll','15.00','38.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,20533,1955,'967.00000','439.00000','663.00000','266.00000',230,4,500,333,0,0,0,60,180,1,1,0,1),
(21159,21159,'Purgatory Gargoyle',0,'',0,'LineageMonster.gargoyle','16.00','50.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,21151,2043,'1006.00000','450.00000','695.00000','272.00000',230,4,500,333,0,0,0,140,175,1,1,0,1),
(21160,21160,'Purgatory Liviona',0,'',0,'LineageMonster.liviona','15.00','28.00',71,'male','L2Monster',40,'2493.00000','1253.00000','8.50000','3.00000',40,43,30,21,20,20,21874,2195,'1127.00000','481.00000','778.00000','292.00000',230,1,500,333,0,0,0,80,160,1,1,0,1),
(21161,21161,'Lesser Ancient Soldier',0,'',0,'LineageMonster.medusa','10.00','25.00',73,'female','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,23782,2447,'1209.00000','502.00000','830.00000','304.00000',230,4,500,333,0,0,0,50,180,1,1,0,1),
(21162,21162,'Lesser Ancient Scout',0,'',0,'LineageMonster.blade_stakato_drone','15.00','39.00',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,23761,2477,'1251.00000','513.00000','863.00000','311.00000',230,4,500,333,135,0,0,25,160,1,1,0,1),
(21163,21163,'Lesser Ancient Shaman',0,'',0,'LineageMonster.silhouette','8.00','23.00',76,'female','L2Monster',40,'2720.00000','1402.00000','8.50000','3.00000',40,43,30,21,20,20,25063,2679,'1334.00000','534.00000','921.00000','324.00000',230,4,500,333,0,0,0,80,200,1,1,0,1),
(21164,21164,'Guardian Spirit of Ancient Holy Ground',0,'',0,'LineageMonster.death_lord','21.00','40.00',78,'male','L2Monster',40,'2871.00000','1508.00000','8.58500','3.03000',40,43,30,21,20,20,28547,3164,'1464.00000','569.00000','1020.00000','344.00000',230,4,500,333,78,0,0,40,190,1,1,0,1),
(21165,21165,'Lesser Ancient Warrior',0,'',0,'LineageMonster.shadeless','7.00','33.00',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,31048,3485,'1512.00000','581.00000','1058.00000','352.00000',230,1,500,333,0,0,0,48,200,1,1,0,1),
(21166,21166,'Lith Scout',0,'',0,'LineageMonster2.temple_guard_a_20_sm','12.00','33.60',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,2380,109,'53.00000','99.00000','38.00000','60.00000',230,8,0,333,5795,0,0,53,130,1,1,0,1),
(21167,21167,'Lith Witch',0,'',0,'LineageMonster2.temple_savant_a_20_sm','8.00','32.00',24,'male','L2Monster',40,'435.00000','224.00000','3.50000','1.50000',40,43,30,21,20,20,2763,136,'68.00000','112.00000','48.00000','67.00000',230,1,0,333,5797,0,0,25,110,1,1,0,1),
(21168,21168,'Lith Warrior',0,'',0,'LineageMonster2.temple_guard_b_20_sm','12.00','33.60',27,'male','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,3420,175,'87.00000','126.00000','62.00000','76.00000',230,4,0,333,5796,0,0,53,130,1,1,0,1),
(21169,21169,'Lith Guard',0,'',0,'LineageMonster2.temple_guard_a','15.00','42.00',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,4532,248,'109.00000','141.00000','77.00000','85.00000',230,8,0,333,5795,0,0,53,140,1,1,0,1),
(21170,21170,'Lith Medium',0,'',0,'LineageMonster2.temple_savant_a','10.00','40.00',33,'male','L2Monster',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,5231,300,'138.00000','158.00000','96.00000','96.00000',230,1,0,333,5797,0,0,25,120,1,1,0,1),
(21171,21171,'Lith Overlord',0,'',0,'LineageMonster2.temple_guard_b','15.00','42.00',36,'male','L2Monster',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,6677,404,'171.00000','176.00000','115.00000','107.00000',230,4,0,333,5796,0,0,53,140,1,1,0,1),
(21172,21172,'Lith Patrolman',0,'',0,'LineageMonster2.temple_guard_a','15.00','42.00',39,'male','L2Monster',40,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,7888,501,'211.00000','195.00000','147.00000','118.00000',230,8,0,333,5795,0,0,53,150,1,1,0,1),
(21173,21173,'Lith Shaman',0,'',0,'LineageMonster2.temple_savant_a','10.00','40.00',42,'male','L2Monster',40,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,8473,564,'258.00000','216.00000','174.00000','131.00000',230,1,0,333,5798,0,0,25,130,1,1,0,1),
(21174,21174,'Lith Commander',0,'',0,'LineageMonster2.temple_guard_b','15.00','42.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,10925,760,'313.00000','238.00000','212.00000','144.00000',230,4,0,333,5796,0,0,53,150,1,1,0,1),
(21175,21175,'Lilim Butcher',0,'',0,'LineageMonster2.lilim_assassin_10_sm','11.00','36.00',48,'male','L2Monster',40,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,12374,904,'375.00000','262.00000','260.00000','159.00000',230,8,0,333,232,232,0,36,170,1,1,0,1),
(21176,21176,'Lilim Magus',0,'',0,'LineageMonster2.lilim_wizard_10_sm','8.00','30.60',51,'female','L2Monster',40,'1470.00000','706.00000','6.50000','2.40000',40,43,30,21,20,20,12493,953,'446.00000','287.00000','309.00000','174.00000',230,1,0,333,0,0,0,50,140,1,1,0,1),
(21177,21177,'Lilim Knight Errant',0,'',0,'LineageMonster2.lilim_knight_10_sm','11.00','45.00',54,'male','L2Monster',40,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,17542,1399,'526.00000','313.00000','364.00000','189.00000',230,4,0,333,5800,5799,0,56,170,1,1,0,1),
(21178,21178,'Lilim Marauder',0,'',0,'LineageMonster2.lilim_assassin_10_sm','11.00','36.00',57,'male','L2Monster',40,'1777.00000','862.00000','6.50000','2.40000',40,43,30,21,20,20,18790,1561,'614.00000','340.00000','420.00000','207.00000',230,8,0,333,229,229,0,36,180,1,1,0,1),
(21179,21179,'Lilim Priest',0,'',0,'LineageMonster2.lilim_wizard_10_sm','8.00','30.60',60,'female','L2Monster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,17292,1501,'711.00000','369.00000','491.00000','224.00000',230,1,0,333,0,0,0,50,160,1,1,0,1),
(21180,21180,'Lilim Knight',0,'',0,'LineageMonster2.lilim_knight_10_sm','11.00','45.00',63,'male','L2Monster',40,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,25957,2344,'816.00000','399.00000','559.00000','242.00000',230,4,0,333,5800,5799,0,56,180,1,1,0,1),
(21181,21181,'Lilim Assassin',0,'',0,'LineageMonster2.lilim_assassin_10_bi','13.00','44.00',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,27475,2586,'928.00000','429.00000','641.00000','260.00000',230,8,0,333,234,234,0,36,190,1,1,0,1),
(21182,21182,'Lilim Soldier',0,'',0,'LineageMonster2.lilim_wizard_10_bi','10.00','37.50',69,'female','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,22868,2237,'1046.00000','460.00000','717.00000','279.00000',230,1,0,333,0,0,0,50,170,1,1,0,1),
(21183,21183,'Lilim Knight Commander',0,'',0,'LineageMonster2.lilim_knight_10_bi','13.00','55.00',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,33903,3444,'1168.00000','492.00000','801.00000','298.00000',230,4,0,333,5800,5799,0,56,190,1,1,0,1),
(21184,21184,'Lilim Slayer',0,'',0,'LineageMonster2.lilim_assassin_10_bi','13.00','44.00',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,35479,3742,'1293.00000','524.00000','891.00000','317.00000',230,8,0,333,236,236,0,36,200,1,1,0,1),
(21185,21185,'Lilim Great Mystic',0,'',0,'LineageMonster2.lilim_wizard_10_bi','10.00','37.50',78,'female','L2Monster',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,29223,3198,'1418.00000','556.00000','973.00000','337.00000',230,1,0,333,0,0,0,50,180,1,1,0,1),
(21186,21186,'Lilim Court Knight',0,'',0,'LineageMonster2.lilim_knight_10_bi','13.00','55.00',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,41856,4698,'1512.00000','581.00000','1058.00000','352.00000',230,4,0,333,5800,5799,0,56,200,1,1,0,1),
(21187,21187,'Gigant Slave',0,'',0,'LineageMonster2.tomb_guard_a_20_sm','8.00','32.00',21,'male','L2Monster',40,'365.00000','187.00000','3.50000','1.50000',40,43,30,21,20,20,2380,109,'53.00000','99.00000','38.00000','60.00000',230,4,0,333,5791,0,0,49,130,1,1,0,1),
(21188,21188,'Gigant Acolyte',0,'',0,'LineageMonster2.tomb_savant_a_20_sm','8.00','32.00',24,'male','L2Monster',40,'435.00000','224.00000','3.50000','1.50000',40,43,30,21,20,20,2763,136,'68.00000','112.00000','48.00000','67.00000',230,1,0,333,5793,0,0,49,110,1,1,0,1),
(21189,21189,'Gigant Overseer',0,'',0,'LineageMonster2.tomb_guard_b_20_sm','12.00','34.00',27,'male','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,3420,175,'87.00000','126.00000','62.00000','76.00000',230,4,0,333,5792,0,0,49,130,1,1,0,1),
(21190,21190,'Gigant Footman',0,'',0,'LineageMonster2.tomb_guard_a','10.00','40.00',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,4532,248,'109.00000','141.00000','77.00000','85.00000',230,4,0,333,5791,0,0,49,140,1,1,0,1),
(21191,21191,'Gigant Cleric',0,'',0,'LineageMonster2.tomb_savant_a','10.00','40.00',33,'male','L2Monster',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,5231,300,'138.00000','158.00000','96.00000','96.00000',230,1,0,333,5793,0,0,49,120,1,1,0,1),
(21192,21192,'Gigant Officer',0,'',0,'LineageMonster2.tomb_guard_b','15.00','42.50',36,'male','L2Monster',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,6677,404,'171.00000','176.00000','115.00000','107.00000',230,4,0,333,5792,0,0,49,140,1,1,0,1),
(21193,21193,'Gigant Raider',0,'',0,'LineageMonster2.tomb_guard_a','10.00','40.00',39,'male','L2Monster',40,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,7888,501,'211.00000','195.00000','147.00000','118.00000',230,4,0,333,5791,0,0,49,150,1,1,0,1),
(21194,21194,'Gigant Confessor',0,'',0,'LineageMonster2.tomb_savant_a','10.00','40.00',42,'male','L2Monster',40,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,8473,564,'258.00000','216.00000','174.00000','131.00000',230,1,0,333,5794,0,0,49,130,1,1,0,1),
(21195,21195,'Gigant Commander',0,'',0,'LineageMonster2.tomb_guard_b','15.00','42.50',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,10925,760,'313.00000','238.00000','212.00000','144.00000',230,4,0,333,5792,0,0,49,150,1,1,0,1),
(21196,21196,'Nephilim Sentinel',0,'',0,'LineageMonster2.nephilim_slayer_10_sm','11.00','32.40',48,'male','L2Monster',40,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,12374,904,'375.00000','262.00000','260.00000','159.00000',230,4,0,333,0,0,0,65,170,1,1,0,1),
(21197,21197,'Nephilim Priest',0,'',0,'LineageMonster2.nephilim_priest_10_sm','21.00','36.50',51,'male','L2Monster',40,'1470.00000','706.00000','6.50000','2.40000',40,43,30,21,20,20,13567,1034,'446.00000','287.00000','309.00000','174.00000',230,1,0,333,0,0,0,50,140,1,1,0,1),
(21198,21198,'Nephilim Swordsman',0,'',0,'LineageMonster2.nephilim_lord_10_sm','11.00','39.00',54,'male','L2Monster',40,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,17542,1399,'526.00000','313.00000','364.00000','189.00000',230,4,0,333,0,0,0,65,170,1,1,0,1),
(21199,21199,'Nephilim Guard',0,'',0,'LineageMonster2.nephilim_slayer_10_sm','11.00','32.40',57,'male','L2Monster',40,'1777.00000','862.00000','6.50000','2.40000',40,43,30,21,20,20,18790,1561,'614.00000','340.00000','420.00000','207.00000',230,4,0,333,0,0,0,65,180,1,1,0,1),
(21200,21200,'Nephilim Bishop',0,'',0,'LineageMonster2.nephilim_priest_10_sm','21.00','36.50',60,'male','L2Monster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,18777,1630,'711.00000','369.00000','491.00000','224.00000',230,1,0,333,0,0,0,50,160,1,1,0,1),
(21201,21201,'Nephilim Centurion',0,'',0,'LineageMonster2.nephilim_lord_10_sm','11.00','39.00',63,'male','L2Monster',40,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,25957,2344,'816.00000','399.00000','559.00000','242.00000',230,4,0,333,0,0,0,65,180,1,1,0,1),
(21202,21202,'Nephilim Scout',0,'',0,'LineageMonster2.nephilim_slayer_10_bi','13.00','39.60',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,27475,2586,'928.00000','429.00000','641.00000','260.00000',230,4,0,333,0,0,0,65,190,1,1,0,1),
(21203,21203,'Nephilim Archbishop',0,'',0,'LineageMonster2.nephilim_priest_10_bi','21.00','44.00',69,'male','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,24833,2430,'1046.00000','460.00000','717.00000','279.00000',230,1,0,333,0,0,0,50,170,1,1,0,1),
(21204,21204,'Nephilim Praetorian',0,'',0,'LineageMonster2.nephilim_lord_10_bi','13.00','48.00',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,33903,3444,'1168.00000','492.00000','801.00000','298.00000',230,4,0,333,0,0,0,65,190,1,1,0,1),
(21205,21205,'Nephilim Royal Guard',0,'',0,'LineageMonster2.nephilim_slayer_10_bi','13.00','39.60',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,35479,3742,'1293.00000','524.00000','891.00000','317.00000',230,4,0,333,0,0,0,65,200,1,1,0,1),
(21206,21206,'Nephilim Cardinal',0,'',0,'LineageMonster2.nephilim_priest_10_bi','21.00','44.00',78,'male','L2Monster',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,31734,3473,'1418.00000','556.00000','973.00000','337.00000',230,1,0,333,0,0,0,50,180,1,1,0,1),
(21207,21207,'Nephilim Commander',0,'',0,'LineageMonster2.nephilim_lord_10_bi','13.00','48.00',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,41856,4698,'1512.00000','581.00000','1058.00000','352.00000',230,4,0,333,0,0,0,65,200,1,1,0,1),
(21208,21208,'Hallowed Watchman',0,'',0,'LineageMonster.skeleton','11.00','25.00',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,2085,92,'48.00000','95.00000','30.00000','57.00000',230,4,0,333,216,111,0,60,130,1,1,0,1),
(21209,21209,'Hallowed Seer',0,'',0,'LineageMonster.binding','12.00','21.00',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,2450,116,'57.00000','103.00000','36.00000','62.00000',230,1,500,333,0,0,0,10,110,1,1,0,1),
(21210,21210,'Vault Guardian',0,'',0,'LineageMonster.imp','10.00','24.00',25,'male','L2Monster',40,'461.00000','236.00000','3.50000','1.50000',40,43,30,21,20,20,3121,156,'73.00000','116.00000','52.00000','70.00000',230,4,500,333,0,0,0,60,130,1,1,0,1),
(21211,21211,'Vault Seer',0,'',0,'LineageMonster.succubus','10.00','36.00',27,'female','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,3321,170,'87.00000','126.00000','62.00000','76.00000',230,4,500,333,0,0,0,60,110,1,1,0,1),
(21212,21212,'Hallowed Sentinel',0,'',0,'LineageMonster.skeleton_bi','11.00','31.00',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,3829,209,'109.00000','141.00000','77.00000','85.00000',230,4,0,333,69,646,0,60,140,1,1,0,1),
(21213,21213,'Hallowed Monk',0,'',0,'LineageMonster.binding_20_bi','14.00','25.30',32,'male','L2Monster',40,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,4443,250,'128.00000','152.00000','85.00000','92.00000',230,1,500,333,0,0,0,10,110,1,1,0,1),
(21214,21214,'Vault Sentinel',0,'',0,'LineageMonster.imp_bi','10.00','30.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,5603,332,'159.00000','170.00000','111.00000','102.00000',230,4,500,333,0,0,0,60,140,1,1,0,1),
(21215,21215,'Vault Monk',0,'',0,'LineageMonster.succubus_bi','10.00','43.20',37,'female','L2Monster',40,'847.00000','393.00000','4.50000','1.80000',40,43,30,21,20,20,5940,365,'183.00000','182.00000','123.00000','111.00000',230,4,500,333,0,0,0,60,120,1,1,0,1),
(21216,21216,'Overlord of the Holy Lands',0,'',0,'LineageMonster.skeleton_knight_20_bi','12.00','30.50',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,6807,440,'226.00000','202.00000','157.00000','122.00000',230,4,0,333,129,646,0,40,160,1,1,0,1),
(21217,21217,'Hallowed Priest',0,'',0,'LineageMonster.banshee_20_bi','10.00','27.50',42,'female','L2Monster',40,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,7654,510,'258.00000','216.00000','174.00000','131.00000',230,4,500,333,0,0,0,80,135,1,1,0,1),
(21218,21218,'Vault Overlord',0,'',0,'LineageMonster.death_blader_10_sm','14.00','40.50',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,9263,644,'313.00000','238.00000','212.00000','144.00000',230,4,500,333,297,0,0,100,160,1,1,0,1),
(21219,21219,'Vault Priest',0,'',0,'LineageMonster.bloody_queen_10_sm','13.00','38.00',47,'female','L2Monster',40,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,9585,687,'353.00000','254.00000','244.00000','154.00000',230,4,500,333,0,0,0,80,135,1,1,0,1),
(21220,21220,'Sepulcher Archon',0,'',0,'LineageMonster.skeleton_knight_30_bi','13.00','33.00',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,10635,801,'421.00000','278.00000','286.00000','169.00000',230,4,0,333,131,107,0,40,170,1,1,0,1),
(21221,21221,'Sepulcher Inquisitor',0,'',0,'LineageMonster.banshee_30_bi','11.00','30.00',52,'female','L2Monster',40,'1520.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,11733,908,'472.00000','295.00000','321.00000','179.00000',230,4,500,333,0,0,0,80,145,1,1,0,1),
(21222,21222,'Sepulcher Archon',0,'',0,'LineageMonster.death_blader_10_bi','16.00','49.50',55,'male','L2Monster',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,13837,1117,'554.00000','322.00000','384.00000','195.00000',230,4,500,333,298,0,0,100,170,1,1,0,1),
(21223,21223,'Sepulcher Inquisitor',0,'',0,'LineageMonster.bloody_queen_10_bi','15.00','46.00',57,'female','L2Monster',40,'1777.00000','862.00000','6.50000','2.40000',40,43,30,21,20,20,14098,1172,'614.00000','340.00000','420.00000','207.00000',230,4,500,333,0,0,0,80,145,1,1,0,1),
(21224,21224,'Sepulcher Guardian',0,'',0,'LineageMonster.skeleton_royal_guard_20_bi','13.00','34.50',60,'male','L2Monster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,15315,1329,'711.00000','369.00000','491.00000','224.00000',230,8,0,333,233,0,0,80,190,1,1,0,1),
(21225,21225,'Sepulcher Sage',0,'',0,'LineageMonster.vale_master_10_bi','13.00','44.00',62,'male','L2Monster',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,16680,1486,'780.00000','389.00000','535.00000','235.00000',230,4,500,333,311,0,0,70,160,1,1,0,1),
(21226,21226,'Sepulcher Guardian',0,'',0,'LineageMonster.death_knight','12.00','30.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,19326,1795,'890.00000','419.00000','615.00000','253.00000',230,4,500,333,0,0,0,27,190,1,1,0,1),
(21227,21227,'Sepulcher Sage',0,'',0,'LineageMonster.doll_master','20.00','42.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,21777,2074,'967.00000','439.00000','663.00000','266.00000',230,4,500,333,0,0,0,80,160,1,1,0,1),
(21228,21228,'Sepulcher Guard',0,'',0,'LineageMonster.skeleton_royal_guard_30_bi','14.00','37.50',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,20845,2067,'1086.00000','471.00000','749.00000','285.00000',230,8,0,333,236,0,0,80,200,1,1,0,1),
(21229,21229,'Sepulcher Preacher',0,'',0,'LineageMonster.vale_master_30_bi','15.00','52.00',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,22494,2285,'1168.00000','492.00000','801.00000','298.00000',230,4,500,333,326,0,0,70,165,1,1,0,1),
(21230,21230,'Sepulcher Guard',0,'',0,'LineageMonster.death_knight','12.00','30.00',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,25729,2714,'1293.00000','524.00000','891.00000','317.00000',230,4,500,333,0,0,0,27,200,1,1,0,1),
(21231,21231,'Sepulcher Preacher',0,'',0,'LineageMonster.doll_master_20_bi','24.00','50.40',77,'male','L2Monster',40,'2762.00000','1432.00000','8.50000','3.00000',40,43,30,21,20,20,25727,2784,'1376.00000','545.00000','944.00000','330.00000',230,4,500,333,0,0,0,80,165,1,1,0,1),
(21232,21232,'Barrow Guardian',0,'',0,'LineageMonster.skeleton','11.00','25.00',20,'male','L2Monster',40,'342.00000','175.00000','2.50000','1.20000',40,43,30,21,20,20,2085,92,'48.00000','95.00000','30.00000','57.00000',230,4,0,333,216,0,0,60,130,1,1,0,1),
(21233,21233,'Barrow Seer',0,'',0,'LineageMonster.binding','12.00','21.00',22,'male','L2Monster',40,'387.00000','199.00000','3.50000','1.50000',40,43,30,21,20,20,2450,116,'57.00000','103.00000','36.00000','62.00000',230,1,500,333,0,0,0,10,110,1,1,0,1),
(21234,21234,'Grave Guardian',0,'',0,'LineageMonster.imp','10.00','24.00',25,'male','L2Monster',40,'461.00000','236.00000','3.50000','1.50000',40,43,30,21,20,20,3121,156,'73.00000','116.00000','52.00000','70.00000',230,4,500,333,0,0,0,60,130,1,1,0,1),
(21235,21235,'Grave Seer',0,'',0,'LineageMonster.succubus','10.00','36.00',27,'female','L2Monster',40,'515.00000','261.00000','3.50000','1.50000',40,43,30,21,20,20,3321,170,'87.00000','126.00000','62.00000','76.00000',230,4,500,333,0,0,0,60,110,1,1,0,1),
(21236,21236,'Barrow Sentinel',0,'',0,'LineageMonster.skeleton_bi','11.00','31.00',30,'male','L2Monster',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,3829,209,'109.00000','141.00000','77.00000','85.00000',230,4,0,333,69,0,0,60,140,1,1,0,1),
(21237,21237,'Barrow Monk',0,'',0,'LineageMonster.binding_20_bi','14.00','25.30',32,'male','L2Monster',40,'668.00000','326.00000','4.50000','1.80000',40,43,30,21,20,20,4443,250,'128.00000','152.00000','85.00000','92.00000',230,1,500,333,0,0,0,10,110,1,1,0,1),
(21238,21238,'Grave Sentinel',0,'',0,'LineageMonster.imp_bi','10.00','30.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,5603,332,'159.00000','170.00000','111.00000','102.00000',230,4,500,333,0,0,0,60,140,1,1,0,1),
(21239,21239,'Grave Monk',0,'',0,'LineageMonster.succubus_bi','10.00','43.20',37,'female','L2Monster',40,'847.00000','393.00000','4.50000','1.80000',40,43,30,21,20,20,5940,365,'183.00000','182.00000','123.00000','111.00000',230,4,500,333,0,0,0,60,120,1,1,0,1),
(21240,21240,'Barrow Overlord',0,'',0,'LineageMonster.skeleton_knight_20_bi','12.00','30.50',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,6807,440,'226.00000','202.00000','157.00000','122.00000',230,4,0,333,129,0,0,40,160,1,1,0,1),
(21241,21241,'Barrow Priest',0,'',0,'LineageMonster.banshee_20_bi','10.00','27.50',42,'female','L2Monster',40,'1051.00000','483.00000','5.50000','2.10000',40,43,30,21,20,20,7654,510,'258.00000','216.00000','174.00000','131.00000',230,4,500,333,0,0,0,80,135,1,1,0,1),
(21242,21242,'Grave Overlord',0,'',0,'LineageMonster.death_blader_10_sm','14.00','40.50',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,9263,644,'313.00000','238.00000','212.00000','144.00000',230,4,500,333,297,0,0,100,160,1,1,0,1),
(21243,21243,'Grave Priest',0,'',0,'LineageMonster.bloody_queen_10_sm','13.00','38.00',47,'female','L2Monster',40,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,9585,687,'353.00000','254.00000','244.00000','154.00000',230,4,500,333,0,0,0,80,135,1,1,0,1),
(21244,21244,'Crypt Archon',0,'',0,'LineageMonster.skeleton_knight_30_bi','13.00','33.00',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,10635,801,'421.00000','278.00000','286.00000','169.00000',230,4,0,333,131,0,0,40,170,1,1,0,1),
(21245,21245,'Crypt Inquisitor',0,'',0,'LineageMonster.banshee_30_bi','11.00','30.00',52,'female','L2Monster',40,'1520.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,11733,908,'472.00000','295.00000','321.00000','179.00000',230,4,500,333,0,0,0,80,145,1,1,0,1),
(21246,21246,'Tomb Archon',0,'',0,'LineageMonster.death_blader_10_bi','16.00','49.50',55,'male','L2Monster',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,13837,1117,'554.00000','322.00000','384.00000','195.00000',230,4,500,333,298,0,0,100,170,1,1,0,1),
(21247,21247,'Tomb Inquisitor',0,'',0,'LineageMonster.bloody_queen_10_bi','15.00','46.00',57,'female','L2Monster',40,'1777.00000','862.00000','6.50000','2.40000',40,43,30,21,20,20,14098,1172,'614.00000','340.00000','420.00000','207.00000',230,4,500,333,0,0,0,80,145,1,1,0,1),
(21248,21248,'Crypt Guardian',0,'',0,'LineageMonster.skeleton_royal_guard_20_bi','13.00','34.50',60,'male','L2Monster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,15315,1329,'711.00000','369.00000','491.00000','224.00000',230,8,0,333,233,0,0,80,190,1,1,0,1),
(21249,21249,'Crypt Sage',0,'',0,'LineageMonster.vale_master_10_bi','13.00','44.00',62,'male','L2Monster',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,16680,1486,'780.00000','389.00000','535.00000','235.00000',230,4,500,333,311,0,0,70,160,1,1,0,1),
(21250,21250,'Tomb Guardian',0,'',0,'LineageMonster.death_knight','12.00','30.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,19326,1795,'890.00000','419.00000','615.00000','253.00000',230,4,500,333,0,0,0,27,190,1,1,0,1),
(21251,21251,'Tomb Sage',0,'',0,'LineageMonster.doll_master','20.00','42.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,21777,2074,'967.00000','439.00000','663.00000','266.00000',230,4,500,333,0,0,0,80,160,1,1,0,1),
(21252,21252,'Crypt Guard',0,'',0,'LineageMonster.skeleton_royal_guard_30_bi','14.00','37.50',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,20845,2067,'1086.00000','471.00000','749.00000','285.00000',230,8,0,333,236,0,0,80,200,1,1,0,1),
(21253,21253,'Crypt Preacher',0,'',0,'LineageMonster.vale_master_30_bi','15.00','52.00',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,22494,2285,'1168.00000','492.00000','801.00000','298.00000',230,4,500,333,326,0,0,70,165,1,1,0,1),
(21254,21254,'Tomb Guard',0,'',0,'LineageMonster.death_knight','12.00','30.00',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,25729,2714,'1293.00000','524.00000','891.00000','317.00000',230,4,500,333,78,0,0,27,200,1,1,0,1),
(21255,21255,'Tomb Preacher',0,'',0,'LineageMonster.doll_master_20_bi','24.00','50.40',77,'male','L2Monster',40,'2762.00000','1432.00000','8.50000','3.00000',40,43,30,21,20,20,28763,3113,'1376.00000','545.00000','944.00000','330.00000',230,4,500,333,0,0,0,80,165,1,1,0,1),
(21256,21256,'Underground Werewolf',0,'',0,'LineageMonster.werewolf_bi','11.00','29.70',23,'male','L2Monster',40,'411.00000','211.00000','3.50000','1.50000',40,43,30,21,20,20,905,43,'62.00000','107.00000','40.00000','65.00000',230,1,400,333,0,0,0,50,135,1,1,0,1),
(21257,21257,'Evil Eye Seer',0,'',0,'LineageMonster.monster_eye','21.00','43.00',18,'male','L2Monster',40,'302.00000','159.00000','2.50000','1.20000',40,43,30,21,20,20,646,28,'40.00000','87.00000','25.00000','52.00000',230,1,0,333,0,0,0,90,155,1,1,1,1),
(21258,21258,'Fallen Orc Shaman',0,'',0,'LineageMonster.ketra_orc_shaman','10.00','23.00',58,'male','L2Monster',40,'1828.00000','889.00000','6.50000','2.40000',40,43,30,21,20,20,0,0,'646.00000','350.00000','447.00000','212.00000',230,1,0,333,9,0,0,10,130,1,1,1,1),
(21259,21259,'Fallen Orc Shaman',0,'',0,'LineageMonster.saber_toothed_tiger','34.00','28.00',59,'male','L2Monster',40,'1881.00000','916.00000','6.50000','2.40000',40,43,30,21,20,20,15580,1332,'678.00000','359.00000','464.00000','218.00000',230,4,500,333,0,0,0,60,180,1,1,1,1),
(21260,21260,'Betrayer Orc Hero',0,'',0,'LineageMonster.ketra_orc_warrior','12.00','24.00',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,4429,334,'421.00000','278.00000','286.00000','169.00000',230,4,0,333,74,0,0,36,170,1,1,0,1),
(21261,21261,'Ol Mahum Transcender',0,'',0,'LineageMonster.ol_mahum','13.50','25.00',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,4954,372,'421.00000','278.00000','286.00000','185.00000',230,4,0,333,127,0,0,50,110,1,1,1,1),
(21262,21262,'Ol Mahum Transcender',0,'',0,'LineageMonster.ol_mahum_champion','14.00','27.00',53,'male','L2Monster',40,'1571.00000','757.00000','6.50000','2.40000',40,43,30,21,20,20,6631,496,'498.00000','304.00000','344.00000','202.00000',230,4,500,333,127,102,0,50,110,1,1,1,1),
(21263,21263,'Ol Mahum Transcender',0,'',0,'LineageMonster.oel_mahum','20.00','37.00',55,'male','L2Monster',40,'1673.00000','810.00000','6.50000','2.40000',40,43,30,21,20,20,9634,691,'554.00000','322.00000','384.00000','215.00000',230,4,500,333,127,0,0,70,110,1,1,1,1),
(21264,21264,'Ol Mahum Transcender',0,'',0,'LineageMonster.kel_mahum','13.00','26.00',58,'male','L2Monster',40,'1828.00000','889.00000','6.50000','2.40000',40,43,30,21,20,20,13535,933,'646.00000','350.00000','447.00000','233.00000',230,4,500,333,127,0,0,50,160,1,1,1,1),
(21265,21265,'Cave Ant Larva',0,'',0,'LineageMonster.ant_larva','12.00','8.00',36,'male','L2Monster',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,1904,115,'171.00000','176.00000','115.00000','107.00000',230,4,0,333,0,0,0,40,60,1,1,1,1),
(21266,21266,'Cave Ant Larva',0,'',0,'LineageMonster.ant_larva','12.00','8.00',36,'male','L2Monster',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,0,0,'171.00000','176.00000','115.00000','107.00000',230,4,0,333,0,0,0,40,60,1,1,1,1),
(21267,21267,'Cave Ant Larva',0,'',0,'LineageMonster.ant_larva','12.00','8.00',36,'male','L2Monster',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,0,0,'171.00000','176.00000','115.00000','107.00000',230,4,0,333,0,0,0,40,60,1,1,1,1),
(21268,21268,'Cave Ant Larva',0,'',0,'LineageMonster.ant_larva','12.00','8.00',36,'male','L2Monster',40,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,3541,214,'171.00000','176.00000','115.00000','107.00000',230,4,0,333,0,0,0,40,60,1,1,1,1),
(21269,21269,'Cave Ant',0,'',0,'LineageMonster.ant','26.00','15.00',37,'male','L2Monster',40,'847.00000','393.00000','4.50000','1.80000',40,43,30,21,20,20,4042,248,'183.00000','182.00000','123.00000','111.00000',230,4,500,333,0,0,0,40,130,1,1,1,1),
(21270,21270,'Cave Ant Soldier',0,'',0,'LineageMonster.ant_soldier','35.00','17.00',38,'male','L2Monster',40,'886.00000','407.00000','4.50000','1.80000',40,43,30,21,20,20,4670,292,'197.00000','189.00000','137.00000','114.00000',230,4,500,333,0,0,0,80,130,1,1,1,1),
(21271,21271,'Cave Ant',0,'',0,'LineageMonster.ant','26.00','15.00',37,'male','L2Monster',40,'847.00000','393.00000','4.50000','1.80000',40,43,30,21,20,20,2758,169,'183.00000','182.00000','123.00000','111.00000',230,4,500,333,0,0,0,40,130,1,1,1,1),
(21272,21272,'Cave Ant Soldier',0,'',0,'LineageMonster.ant_soldier','35.00','17.00',38,'male','L2Monster',40,'886.00000','407.00000','4.50000','1.80000',40,43,30,21,20,20,4902,306,'197.00000','189.00000','137.00000','114.00000',230,4,500,333,0,0,0,80,130,1,1,1,1),
(21273,21273,'Cave Noble Ant',0,'',0,'LineageMonster.noble_ant','20.00','48.00',39,'male','L2Monster',40,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,14204,902,'211.00000','195.00000','147.00000','118.00000',230,4,500,333,0,0,0,80,174,1,1,1,1),
(21274,21274,'Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8.00','26.40',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,8972,854,'967.00000','439.00000','663.00000','293.00000',230,4,0,333,0,0,0,23,190,1,1,1,1),
(21275,21275,'Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8.00','26.40',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,9030,859,'967.00000','439.00000','663.00000','293.00000',230,4,0,333,0,0,0,23,190,1,1,1,1),
(21276,21276,'Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8.00','26.40',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,8921,848,'967.00000','439.00000','663.00000','293.00000',230,4,0,333,0,0,0,23,190,1,1,1,1),
(21278,21278,'Antelope',0,'',0,'LineageMonster2.antelope','17.00','34.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,9242,892,'1006.00000','450.00000','695.00000','299.00000',230,4,0,333,0,0,0,45,185,1,1,1,1),
(21279,21279,'Antelope',0,'',0,'LineageMonster2.antelope','17.00','34.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,9189,887,'1006.00000','450.00000','695.00000','299.00000',230,4,0,333,0,0,0,45,185,1,1,1,1),
(21280,21280,'Antelope',0,'',0,'LineageMonster2.antelope','17.00','34.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,9302,898,'1006.00000','450.00000','695.00000','299.00000',230,4,0,333,0,0,0,45,185,1,1,1,1),
(21282,21282,'Bandersnatch',0,'',0,'LineageMonster2.bandersnatch','18.00','25.00',69,'male','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,9516,930,'1046.00000','460.00000','717.00000','307.00000',230,4,150,333,0,0,0,30,170,1,1,1,1),
(21283,21283,'Bandersnatch',0,'',0,'LineageMonster2.bandersnatch','18.00','25.00',69,'male','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,9578,936,'1046.00000','460.00000','717.00000','307.00000',230,4,150,333,0,0,0,30,170,1,1,1,1),
(21284,21284,'Bandersnatch',0,'',0,'LineageMonster2.bandersnatch','18.00','25.00',69,'male','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,9461,925,'1046.00000','460.00000','717.00000','307.00000',230,4,150,333,0,0,0,30,170,1,1,1,1),
(21286,21286,'Buffalo',0,'',0,'LineageMonster2.buffalo','22.00','31.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,9794,971,'1086.00000','471.00000','749.00000','313.00000',230,1,0,333,0,0,0,80,170,1,1,1,1),
(21287,21287,'Buffalo',0,'',0,'LineageMonster2.buffalo','22.00','31.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,9737,965,'1086.00000','471.00000','749.00000','313.00000',230,1,0,333,0,0,0,80,170,1,1,1,1),
(21288,21288,'Buffalo',0,'',0,'LineageMonster2.buffalo','22.00','31.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,9857,977,'1086.00000','471.00000','749.00000','313.00000',230,1,0,333,0,0,0,80,170,1,1,1,1),
(21290,21290,'Grendel',0,'',0,'LineageMonster2.bionic_bear','15.00','39.00',71,'male','L2Monster',40,'2493.00000','1253.00000','8.50000','3.00000',40,43,30,21,20,20,10076,1010,'1127.00000','481.00000','778.00000','320.00000',230,4,150,333,0,0,0,36,155,1,1,1,1),
(21291,21291,'Grendel',0,'',0,'LineageMonster2.bionic_bear','15.00','39.00',71,'male','L2Monster',40,'2493.00000','1253.00000','8.50000','3.00000',40,43,30,21,20,20,10017,1004,'1127.00000','481.00000','778.00000','320.00000',230,4,150,333,0,0,0,36,155,1,1,1,1),
(21292,21292,'Grendel',0,'',0,'LineageMonster2.bionic_bear','15.00','39.00',71,'male','L2Monster',40,'2493.00000','1253.00000','8.50000','3.00000',40,43,30,21,20,20,10141,1016,'1127.00000','481.00000','778.00000','320.00000',230,4,150,333,0,0,0,36,155,1,1,1,1),
(21294,21294,'Canyon Antelope',0,'',0,'LineageMonster2.antelope','17.00','34.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,16544,1598,'1006.00000','450.00000','695.00000','272.00000',230,4,0,333,0,0,0,45,185,1,1,0,1),
(21295,21295,'Canyon Antelope Slave',0,'',0,'LineageMonster2.antelope','17.00','34.00',69,'male','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,17547,1717,'1046.00000','460.00000','717.00000','279.00000',230,4,300,333,0,0,0,45,165,1,1,0,1),
(21296,21296,'Canyon Bandersnatch',0,'',0,'LineageMonster2.bandersnatch','18.00','25.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,26081,2586,'1086.00000','471.00000','749.00000','285.00000',230,4,300,333,0,0,0,30,180,1,1,0,1),
(21297,21297,'Canyon Bandersnatch Slave',0,'',0,'LineageMonster2.bandersnatch','18.00','25.00',71,'male','L2Monster',40,'2493.00000','1253.00000','8.50000','3.00000',40,43,30,21,20,20,26191,2628,'1127.00000','481.00000','778.00000','292.00000',230,4,200,333,0,0,0,30,170,1,1,0,1),
(21298,21298,'Eye of Restrainer',0,'',0,'LineageMonster.monster_eye','21.00','43.00',71,'male','L2Monster',40,'2493.00000','1253.00000','8.50000','3.00000',40,43,30,21,20,20,16857,1692,'1127.00000','481.00000','778.00000','292.00000',230,4,150,333,0,0,0,90,140,1,1,0,1),
(21299,21299,'Buffalo Slave',0,'',0,'LineageMonster2.buffalo_ec','22.00','31.00',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,26934,2736,'1168.00000','492.00000','801.00000','298.00000',230,1,300,333,0,0,0,20,160,1,1,0,1),
(21300,21300,'Eye of Guide',0,'',0,'LineageMonster2.parasitic_eye_20_sm','20.00','50.50',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,26498,2692,'1168.00000','492.00000','801.00000','298.00000',230,4,0,333,0,0,0,30,155,1,1,0,1),
(21301,21301,'Gaze of Nightmare',0,'',0,'LineageMonster.field_stalker','16.00','36.00',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,31797,3230,'1168.00000','492.00000','801.00000','298.00000',230,4,0,333,0,0,0,70,195,1,1,0,1),
(21302,21302,'Eye of Watchman',0,'',0,'LineageMonster2.parasitic_eye','25.00','63.00',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,25580,2632,'1209.00000','502.00000','830.00000','304.00000',230,4,300,333,0,0,0,30,160,1,1,0,1),
(21303,21303,'Homunculus',0,'',0,'LineageMonster2.homunculus_20_sm','10.00','26.00',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,25867,2662,'1209.00000','502.00000','830.00000','304.00000',230,4,150,333,0,0,0,30,185,1,1,0,1),
(21304,21304,'Grendel Slave',0,'',0,'LineageMonster2.bionic_bear','15.00','39.00',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,38011,3962,'1251.00000','513.00000','863.00000','311.00000',230,4,200,333,0,0,0,36,140,1,1,0,1),
(21305,21305,'Eye of Pilgrim',0,'',0,'LineageMonster2.parasitic_eye_20_sm','20.00','50.50',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,27990,2917,'1251.00000','513.00000','863.00000','311.00000',230,4,0,333,0,0,0,30,165,1,1,0,1),
(21306,21306,'Disciples of Protection',0,'',0,'LineageMonster2.apostle_warrior','8.00','30.00',74,'female','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,50649,5280,'1251.00000','513.00000','863.00000','311.00000',230,4,150,333,6717,0,0,50,160,1,1,0,1),
(21307,21307,'Elder Homunculus',0,'',0,'LineageMonster2.homunculus','12.00','32.50',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,35496,3744,'1293.00000','524.00000','891.00000','317.00000',230,4,150,333,0,0,0,30,200,1,1,0,1),
(21308,21308,'Disciples of Punishment',0,'',0,'LineageMonster2.apostle_warrior','8.00','30.00',75,'female','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,47163,4975,'1293.00000','524.00000','891.00000','317.00000',230,4,150,333,6717,0,0,50,190,1,1,0,1),
(21309,21309,'Disciples of Punishment',0,'',0,'LineageMonster2.apostle_warrior','8.00','30.00',75,'female','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,49155,5185,'1293.00000','524.00000','891.00000','317.00000',230,4,150,333,6717,0,0,50,190,1,1,0,1),
(21310,21310,'Disciples of Authority',0,'',0,'LineageMonster2.apostle_mage','11.00','38.50',76,'male','L2Monster',40,'2720.00000','1402.00000','8.50000','3.00000',40,43,30,21,20,20,40357,4315,'1334.00000','534.00000','921.00000','324.00000',230,1,150,333,6718,0,0,50,155,1,1,0,1),
(21311,21311,'Disciples of Authority',0,'',0,'LineageMonster2.apostle_mage','11.00','38.50',76,'male','L2Monster',40,'2720.00000','1402.00000','8.50000','3.00000',40,43,30,21,20,20,37210,3978,'1334.00000','534.00000','921.00000','324.00000',230,1,150,333,6718,0,0,50,155,1,1,0,1),
(21312,21312,'Eye of Ruler',0,'',0,'LineageMonster2.parasitic_eye','25.00','63.00',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,38709,4036,'1251.00000','513.00000','863.00000','311.00000',230,4,300,333,0,0,0,30,160,1,1,0,1),
(21313,21313,'Sly Hound Dog',0,'',0,'LineageMonster2.bandersnatch','18.00','25.00',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,37061,3766,'1168.00000','492.00000','801.00000','298.00000',230,4,0,333,0,0,0,30,185,1,1,0,1),
(21314,21314,'Hot Springs Bandersnatchling',0,'',0,'LineageMonster2.bandersnatch','18.00','25.00',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,20662,2126,'1209.00000','502.00000','830.00000','304.00000',230,4,400,333,0,0,0,30,170,1,1,1,1),
(21315,21315,'Hot Springs Buffalo',0,'',0,'LineageMonster2.buffalo','22.00','31.00',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,21532,2215,'1209.00000','502.00000','830.00000','304.00000',230,1,0,333,0,0,0,20,170,1,1,1,1),
(21316,21316,'Hot Springs Flava',0,'',0,'LineageMonster2.flava','18.00','34.00',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,25336,2641,'1251.00000','513.00000','863.00000','311.00000',230,1,450,333,0,0,0,30,165,1,1,1,1),
(21317,21317,'Hot Springs Atroxspawn',0,'',0,'LineageMonster2.kailiharim','35.00','39.00',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,21232,2213,'1251.00000','513.00000','863.00000','311.00000',230,4,500,333,0,0,0,105,175,1,1,1,1),
(21318,21318,'Hot Springs Antelope',0,'',0,'LineageMonster2.antelope','17.00','34.00',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,22193,2314,'1251.00000','513.00000','863.00000','311.00000',230,4,0,333,0,0,0,45,185,1,1,1,1),
(21319,21319,'Hot Springs Nepenthes',0,'',0,'LineageMonster2.nephenthes','28.00','43.50',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,27928,2946,'1293.00000','524.00000','891.00000','317.00000',230,1,350,333,0,0,0,48,170,1,1,1,1),
(21320,21320,'Hot Springs Yeti',0,'',0,'LineageMonster.yeti_20_bi','18.00','32.00',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,22728,2398,'1293.00000','524.00000','891.00000','317.00000',230,4,0,333,0,0,0,16,170,1,1,1,1),
(21321,21321,'Hot Springs Atrox',0,'',0,'LineageMonster2.kailiharim','35.00','39.00',76,'male','L2Monster',40,'2720.00000','1402.00000','8.50000','3.00000',40,43,30,21,20,20,22270,2381,'1334.00000','534.00000','921.00000','324.00000',230,4,500,333,0,0,0,105,175,1,1,1,1),
(21322,21322,'Hot Springs Bandersnatch',0,'',0,'LineageMonster2.bandersnatch','18.00','25.00',76,'male','L2Monster',40,'2720.00000','1402.00000','8.50000','3.00000',40,43,30,21,20,20,22270,2381,'1334.00000','534.00000','921.00000','324.00000',230,4,400,333,0,0,0,30,170,1,1,1,1),
(21323,21323,'Hot Springs Grendel',0,'',0,'LineageMonster2.bionic_bear','15.00','39.00',76,'male','L2Monster',40,'2720.00000','1402.00000','8.50000','3.00000',40,43,30,21,20,20,19507,2085,'1334.00000','534.00000','921.00000','324.00000',230,4,0,333,0,0,0,36,165,1,1,1,1),
(21324,21324,'Ketra Orc Footman',0,'',0,'LineageMonster.ketra_orc','12.00','29.00',77,'male','L2Monster',40,'2762.00000','1432.00000','8.50000','3.00000',40,43,30,21,20,20,18647,2018,'1376.00000','545.00000','944.00000','330.00000',230,4,150,333,79,0,0,45,175,1,1,1,1),
(21325,21325,'Ketra\'s War Hound',0,'',0,'LineageMonster2.bandersnatch','18.00','25.00',77,'male','L2Monster',40,'2762.00000','1432.00000','8.50000','3.00000',40,43,30,21,20,20,18031,1951,'1376.00000','545.00000','944.00000','330.00000',230,4,150,333,0,0,0,30,185,1,1,1,1),
(21326,21326,'Grazing Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8.00','26.40',77,'male','L2Monster',40,'2762.00000','1432.00000','8.50000','3.00000',40,43,30,21,20,20,18031,1951,'1376.00000','545.00000','944.00000','330.00000',230,4,150,333,0,0,0,23,190,1,1,1,1),
(21327,21327,'Ketra Orc Raider',0,'',0,'LineageMonster.ketra_orc_warrior','12.00','24.00',78,'male','L2Monster',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,20480,2241,'1418.00000','556.00000','973.00000','337.00000',230,4,150,333,79,6919,0,36,175,1,1,1,1),
(21328,21328,'Ketra Orc Scout',0,'',0,'LineageMonster.ketra_orc_archer','12.00','27.00',78,'male','L2Monster',1100,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,19634,2149,'1418.00000','556.00000','973.00000','337.00000',230,8,150,333,288,0,0,45,175,1,1,1,1),
(21329,21329,'Ketra Orc Shaman',0,'',0,'LineageMonster.ketra_orc_shaman','10.00','23.00',78,'male','L2Monster',40,'2871.00000','1508.00000','8.58500','3.03000',40,43,30,21,20,20,19912,2207,'1464.00000','569.00000','1020.00000','344.00000',230,1,150,333,92,0,0,10,150,1,1,1,1),
(21330,21330,'Grazing Buffalo',0,'',0,'LineageMonster2.buffalo','22.00','31.00',78,'male','L2Monster',40,'2871.00000','1508.00000','8.58500','3.03000',40,43,30,21,20,20,18980,2103,'1464.00000','569.00000','1020.00000','344.00000',230,1,150,333,0,0,0,20,165,1,1,1,1),
(21331,21331,'Ketra Orc Warrior',0,'',0,'LineageMonster.ketra_orc_warrior','12.00','24.00',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,18609,2089,'1512.00000','581.00000','1058.00000','352.00000',230,4,150,333,79,6919,0,36,175,1,1,1,1),
(21332,21332,'Ketra Orc Lieutenant',0,'',0,'LineageMonster2.ketra_orc_chieftain','11.00','38.50',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,20841,2339,'1512.00000','581.00000','1058.00000','352.00000',230,1,400,333,6719,0,0,24,175,1,1,1,1),
(21333,21333,'Grazing Windsus',0,'',0,'LineageMonster.giant_wild_hog','25.00','27.00',78,'male','L2Monster',40,'2975.00000','1586.00000','8.72100','3.08040',40,43,30,21,20,20,19953,2266,'1554.00000','593.00000','1099.00000','363.00000',230,1,150,333,0,0,0,35,170,1,1,1,1),
(21334,21334,'Ketra Orc Medium',0,'',0,'LineageMonster.ketra_orc_shaman','10.00','23.00',78,'male','L2Monster',40,'2975.00000','1586.00000','8.72100','3.08040',40,43,30,21,20,20,29867,3391,'1554.00000','593.00000','1099.00000','363.00000',230,1,400,333,92,0,0,10,150,1,1,1,1),
(21335,21335,'Ketra Orc Elite Soldier',0,'',0,'LineageMonster.ketra_orc','12.00','29.00',78,'male','L2Monster',40,'3011.00000','1617.00000','8.77200','3.10080',40,43,30,21,20,20,19252,2212,'1593.00000','603.00000','1133.00000','375.00000',230,4,300,333,79,0,0,45,175,1,1,1,1),
(21336,21336,'Ketra Orc White Captain',0,'',0,'LineageMonster.ketra_orc_overload_20_bi','14.00','28.80',78,'male','L2Monster',40,'3011.00000','1617.00000','8.77200','3.10080',40,43,30,21,20,20,22635,2600,'1593.00000','603.00000','1133.00000','375.00000',230,4,300,333,80,0,0,33,175,1,1,1,1),
(21337,21337,'Grazing Elder Buffalo',0,'',0,'LineageMonster2.buffalo','22.00','31.00',78,'male','L2Monster',40,'3045.00000','1649.00000','8.82300','3.11100',40,43,30,21,20,20,20950,2435,'1633.00000','613.00000','1169.00000','385.00000',230,1,150,333,0,0,0,20,165,1,1,1,1),
(21338,21338,'Ketra Orc Seer',0,'',0,'LineageMonster.ketra_orc_shaman','10.00','23.00',78,'male','L2Monster',40,'3045.00000','1649.00000','8.82300','3.11100',40,43,30,21,20,20,27568,3205,'1633.00000','613.00000','1169.00000','385.00000',230,4,350,333,213,0,0,10,160,1,1,1,1),
(21339,21339,'Ketra Orc General',0,'',0,'LineageMonster2.ketra_orc_chieftain_20_bi','17.00','46.20',78,'male','L2Monster',40,'3077.00000','1682.00000','8.87400','3.13140',40,43,30,21,20,20,20989,2469,'1672.00000','625.00000','1204.00000','397.00000',230,1,150,333,6719,0,0,24,175,1,1,1,1),
(21340,21340,'Ketra Orc Battalion Commander',0,'',0,'LineageMonster2.ketra_orc_warlord','12.00','30.00',78,'male','L2Monster',40,'3077.00000','1682.00000','8.87400','3.13140',40,43,30,21,20,20,20989,2469,'1672.00000','625.00000','1204.00000','397.00000',230,4,150,333,80,6919,0,27,175,1,1,1,1),
(21341,21341,'Grazing Elder Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8.00','26.40',78,'male','L2Monster',40,'3108.00000','1714.00000','8.92500','3.15180',40,43,30,21,20,20,21972,2615,'1711.00000','635.00000','1238.00000','407.00000',230,4,150,333,0,0,0,23,190,1,1,1,1),
(21342,21342,'Ketra Orc Grand Seer',0,'',0,'LineageMonster.ketra_orc_shaman','10.00','23.00',78,'male','L2Monster',40,'3108.00000','1714.00000','8.92500','3.15180',40,43,30,21,20,20,28912,3441,'1711.00000','635.00000','1238.00000','407.00000',230,1,150,333,213,0,0,10,160,1,1,1,1),
(21343,21343,'Ketra Commander',0,'',0,'LineageMonster2.ketra_orc_warlord_20_bi','14.00','36.00',78,'male','L2Monster',40,'2975.00000','1586.00000','8.72100','3.08040',40,43,30,21,20,20,32801,3725,'1554.00000','593.00000','1099.00000','363.00000',230,8,150,333,80,6919,0,27,175,1,1,0,1),
(21344,21344,'Ketra Elite Guard',0,'',0,'LineageMonster.ketra_orc_overload','12.00','24.00',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,22276,2500,'1512.00000','581.00000','1058.00000','352.00000',230,4,0,333,80,0,0,33,180,1,1,0,1),
(21345,21345,'Ketra\'s Head Shaman',0,'',0,'LineageMonster.ketra_orc_shaman','10.00','23.00',78,'male','L2Monster',40,'3108.00000','1714.00000','8.92500','3.15180',40,43,30,21,20,20,24720,2943,'1711.00000','635.00000','1238.00000','407.00000',230,1,150,333,210,0,0,10,175,1,1,0,1),
(21346,21346,'Ketra\'s Head Guard',0,'',0,'LineageMonster2.ketra_orc_chieftain','11.00','38.50',78,'male','L2Monster',40,'3077.00000','1682.00000','8.87400','3.13140',40,43,30,21,20,20,24560,2889,'1672.00000','625.00000','1204.00000','397.00000',230,1,0,333,6719,0,0,24,175,1,1,0,1),
(21347,21347,'Ketra Prophet',0,'',0,'LineageMonster.ketra_orc_shaman','10.00','23.00',78,'male','L2Monster',40,'3163.00000','1779.00000','9.02700','3.18240',40,43,30,21,20,20,37558,4578,'1783.00000','686.00000','1306.00000','450.00000',230,1,150,333,213,0,0,10,175,1,1,0,1),
(21348,21348,'Prophet\'s Guard',0,'',0,'LineageMonster2.ketra_orc_chieftain','11.00','38.50',78,'male','L2Monster',40,'3136.00000','1747.00000','8.97600','3.16812',40,43,30,21,20,20,25743,3101,'1748.00000','645.00000','1273.00000','419.00000',230,1,0,333,6719,0,0,24,180,1,1,0,1),
(21349,21349,'Prophet\'s Aide',0,'',0,'LineageMonster.ketra_orc_shaman','10.00','23.00',78,'male','L2Monster',40,'3136.00000','1747.00000','8.97600','3.16812',40,43,30,21,20,20,26143,3149,'1748.00000','645.00000','1273.00000','419.00000',230,1,0,333,210,0,0,10,180,1,1,0,1),
(21350,21350,'Varka Silenos Recruit',0,'',0,'LineageMonster2.barka_silenos_hunter','16.00','38.00',77,'male','L2Monster',40,'2857.00000','1432.00000','8.50000','3.00000',40,43,30,21,20,20,21105,2186,'1410.00000','545.00000','968.00000','363.00000',230,4,150,333,2504,6918,0,44,175,1,1,1,1),
(21351,21351,'Varka Silenos Footman',0,'',0,'LineageMonster2.barka_silenos_warrior','16.00','41.00',77,'male','L2Monster',40,'2857.00000','1432.00000','8.50000','3.00000',40,43,30,21,20,20,18501,1904,'1410.00000','545.00000','968.00000','363.00000',230,4,400,333,2504,6918,0,34,175,1,1,1,1),
(21352,21352,'Grazing Antelope',0,'',0,'LineageMonster2.antelope','17.00','34.00',77,'male','L2Monster',40,'2857.00000','1432.00000','8.50000','3.00000',40,43,30,21,20,20,11091,1200,'1410.00000','545.00000','968.00000','363.00000',230,4,150,333,0,0,0,45,185,1,1,1,1),
(21353,21353,'Varka Silenos Scout',0,'',0,'LineageMonster2.barka_silenos_hunter','16.00','38.00',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,25065,2642,'1475.00000','556.00000','1012.00000','370.00000',230,4,350,333,142,6918,0,44,175,1,1,1,1),
(21354,21354,'Varka Silenos Hunter',0,'',0,'LineageMonster2.barka_silenos_archer','8.00','37.50',78,'male','L2Monster',1100,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,24846,2618,'1475.00000','556.00000','1012.00000','370.00000',230,8,300,333,6917,0,0,30,175,1,1,1,1),
(21355,21355,'Varka Silenos Shaman',0,'',0,'LineageMonster2.barka_silenos_shaman','14.00','39.50',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,24583,2580,'1475.00000','556.00000','1012.00000','370.00000',230,1,300,333,6716,0,0,36,150,1,1,1,1),
(21356,21356,'Grazing Nepenthes',0,'',0,'LineageMonster2.nephenthes','28.00','43.50',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,15612,1708,'1475.00000','556.00000','1012.00000','370.00000',230,1,150,333,0,0,0,48,150,1,1,1,1),
(21357,21357,'Varka Silenos Priest',0,'',0,'LineageMonster2.barka_silenos_priest','9.00','41.50',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,25424,2681,'1475.00000','556.00000','1012.00000','370.00000',230,4,450,333,6716,0,0,36,180,1,1,1,1),
(21358,21358,'Varka Silenos Warrior',0,'',0,'LineageMonster2.barka_silenos_warrior','16.00','41.00',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,25564,2696,'1475.00000','556.00000','1012.00000','370.00000',230,4,150,333,142,6918,0,34,175,1,1,1,1),
(21359,21359,'Grazing Bandersnatch',0,'',0,'LineageMonster2.bandersnatch','18.00','25.00',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,15761,1724,'1475.00000','556.00000','1012.00000','370.00000',230,4,150,333,0,0,0,30,170,1,1,1,1),
(21360,21360,'Varka Silenos Medium',0,'',0,'LineageMonster2.barka_silenos_shaman','14.00','39.50',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,33108,3490,'1475.00000','556.00000','1012.00000','370.00000',230,1,150,333,6716,0,0,36,150,1,1,1,1),
(21361,21361,'Varka Silenos Magus',0,'',0,'LineageMonster2.barka_silenos_mage_20_bi','11.00','55.20',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,23322,2452,'1475.00000','556.00000','1012.00000','370.00000',230,1,150,333,6716,0,0,36,175,1,1,1,1),
(21362,21362,'Varka Silenos Officer',0,'',0,'LineageMonster2.barka_silenos_chieftain','18.00','42.50',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,25564,2696,'1475.00000','556.00000','1012.00000','370.00000',230,1,150,333,2504,0,0,25,175,1,1,1,1),
(21363,21363,'Grazing Flava',0,'',0,'LineageMonster2.flava','18.00','34.00',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,23952,2522,'1475.00000','556.00000','1012.00000','370.00000',230,4,150,333,0,0,0,30,165,1,1,1,1),
(21364,21364,'Varka Silenos Seer',0,'',0,'LineageMonster2.barka_silenos_shaman','14.00','39.50',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,18179,1988,'1475.00000','556.00000','1012.00000','370.00000',230,1,150,333,6716,0,0,36,150,1,1,1,1),
(21365,21365,'Varka Silenos Great Magus',0,'',0,'LineageMonster2.barka_silenos_warrior_20_bi','20.00','49.20',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,25065,2642,'1475.00000','556.00000','1012.00000','370.00000',230,4,150,333,2500,0,0,34,175,1,1,1,1),
(21366,21366,'Varka Silenos General',0,'',0,'LineageMonster2.barka_silenos_chieftain','18.00','42.50',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,27045,2858,'1475.00000','556.00000','1012.00000','370.00000',230,1,150,333,2500,0,0,25,175,1,1,1,1),
(21367,21367,'Grazing Elder Antelope',0,'',0,'LineageMonster2.antelope','17.00','34.00',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,15761,1724,'1475.00000','556.00000','1012.00000','370.00000',230,4,150,333,0,0,0,45,185,1,1,1,1),
(21368,21368,'Varka Silenos Great Seer',0,'',0,'LineageMonster2.barka_silenos_shaman','14.00','39.50',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,32232,3394,'1475.00000','556.00000','1012.00000','370.00000',230,1,150,333,6716,0,0,36,150,1,1,1,1),
(21369,21369,'Varka\'s Commander',0,'',0,'LineageMonster2.barka_silenos_chieftain_20_bi','22.00','51.00',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,31469,3310,'1475.00000','556.00000','1012.00000','370.00000',230,4,150,333,2500,0,0,25,175,1,1,0,1),
(21370,21370,'Varka\'s Elite Guard',0,'',0,'LineageMonster2.barka_silenos_warrior','16.00','41.00',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,26151,2761,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,2500,6918,0,34,175,1,1,0,1),
(21371,21371,'Varka\'s Head Magus',0,'',0,'LineageMonster2.barka_silenos_shaman','14.00','39.50',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,24846,2618,'1475.00000','556.00000','1012.00000','370.00000',230,1,150,333,6716,0,0,36,150,1,1,0,1),
(21372,21372,'Varka\'s Head Guard',0,'',0,'LineageMonster2.barka_silenos_hunter','16.00','38.00',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,16812,1840,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,2500,6918,0,44,175,1,1,0,1),
(21373,21373,'Varka\'s Prophet',0,'',0,'LineageMonster2.barka_silenos_shaman_20_bi','17.00','47.50',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,32074,3370,'1475.00000','556.00000','1012.00000','370.00000',230,1,150,333,6716,0,0,36,150,1,1,0,1),
(21374,21374,'Prophet Guard',0,'',0,'LineageMonster2.barka_silenos_warrior','16.00','41.00',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,16952,1855,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,2500,6918,0,34,175,1,1,0,1),
(21375,21375,'Disciple of Prophet',0,'',0,'LineageMonster2.barka_silenos_priest','9.00','41.50',78,'male','L2Monster',40,'2974.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,16339,1788,'1475.00000','556.00000','1012.00000','370.00000',230,4,0,333,6716,0,0,36,180,1,1,0,1),
(21376,21376,'Scarlet Stakato Worker',0,'',0,'LineageMonster.blade_stakato_worker','13.00','40.00',78,'male','L2Monster',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,35275,3860,'1418.00000','556.00000','973.00000','337.00000',230,4,150,333,235,0,0,25,130,1,1,0,1),
(21377,21377,'Scarlet Stakato Soldier',0,'',0,'LineageMonster.blade_stakato_soldier','15.00','38.00',78,'male','L2Monster',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,34523,3778,'1418.00000','556.00000','973.00000','337.00000',230,4,400,333,148,0,0,25,180,1,1,0,1),
(21378,21378,'Scarlet Stakato Noble',0,'',0,'LineageMonster.blade_stakato_drone','15.00','39.00',78,'male','L2Monster',40,'2871.00000','1508.00000','8.58500','3.03000',40,43,30,21,20,20,49148,5447,'1464.00000','569.00000','1020.00000','344.00000',230,4,450,333,235,0,0,25,180,1,1,0,1),
(21379,21379,'Tepra Scorpion',0,'',0,'LineageMonster2.scorpion_20_sm','24.00','52.80',78,'male','L2Monster',40,'2871.00000','1508.00000','8.58500','3.03000',40,43,30,21,20,20,35491,3933,'1464.00000','569.00000','1020.00000','344.00000',230,8,150,333,0,0,0,37,125,1,1,0,1),
(21380,21380,'Tepra Scarab',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2Monster',40,'2871.00000','1508.00000','8.58500','3.03000',40,43,30,21,20,20,36185,4010,'1464.00000','569.00000','1020.00000','344.00000',230,1,150,333,0,0,0,45,175,1,1,0,1),
(21381,21381,'Assassin Beetle',0,'',0,'LineageMonster2.tera_beetle','19.00','54.50',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,42075,4722,'1512.00000','581.00000','1058.00000','352.00000',230,4,500,333,0,0,0,45,145,1,1,0,1),
(21382,21382,'Mercenary of Destruction',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,51904,5826,'1512.00000','581.00000','1058.00000','352.00000',230,4,150,333,150,103,0,40,165,1,1,0,1),
(21383,21383,'Knight of Destruction',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,51983,5835,'1512.00000','581.00000','1058.00000','352.00000',230,4,150,333,946,945,0,80,185,1,1,0,1),
(21384,21384,'Necromancer of Destruction',0,'',0,'LineageMonster.vale_master_20_bi','14.50','48.00',78,'male','L2Monster',40,'2975.00000','1586.00000','8.72100','3.08040',40,43,30,21,20,20,44576,5062,'1554.00000','593.00000','1099.00000','363.00000',230,1,150,333,0,0,0,70,145,1,1,0,1),
(21385,21385,'Lavastone Golem',0,'',0,'LineageMonster.stone_golem','20.00','31.00',78,'male','L2Monster',40,'2975.00000','1586.00000','8.72100','3.08040',40,43,30,21,20,20,42930,4875,'1554.00000','593.00000','1099.00000','363.00000',230,1,150,333,0,0,0,23,40,1,1,0,1),
(21386,21386,'Magma Golem',0,'',0,'LineageMonster2.lava_golem','22.00','45.00',78,'male','L2Monster',40,'2975.00000','1586.00000','8.72100','3.08040',40,43,30,21,20,20,45872,5209,'1554.00000','593.00000','1099.00000','363.00000',230,1,150,333,0,0,0,13,60,1,1,0,1),
(21387,21387,'Arimanes of Destruction',0,'',0,'LineageMonster2.ahrimanes','14.00','57.75',78,'male','L2Monster',40,'3011.00000','1617.00000','8.77200','3.10080',40,43,30,21,20,20,36575,4202,'1593.00000','603.00000','1133.00000','375.00000',230,4,150,333,6722,0,0,35,185,1,1,0,1),
(21388,21388,'Iblis of Destruction',0,'',0,'LineageMonster.fiend_archer','17.00','55.00',78,'male','L2Monster',40,'3011.00000','1617.00000','8.77200','3.10080',40,43,30,21,20,20,55327,6356,'1593.00000','603.00000','1133.00000','375.00000',230,4,150,333,0,0,0,70,150,1,1,0,1),
(21389,21389,'Balrog of Destruction',0,'',0,'LineageMonster.kaim_vanul','24.00','40.00',78,'male','L2Monster',40,'3045.00000','1649.00000','8.82300','3.11100',40,43,30,21,20,20,59328,6897,'1633.00000','613.00000','1169.00000','385.00000',230,4,150,333,0,0,0,37,155,1,1,0,1),
(21390,21390,'Ashuras of Destruction',0,'',0,'LineageMonster2.ashuras_30_bi','17.00','49.00',78,'male','L2Monster',40,'3077.00000','1682.00000','8.87400','3.13140',40,43,30,21,20,20,68450,8052,'1672.00000','625.00000','1204.00000','397.00000',230,4,150,333,0,0,0,41,190,1,1,0,1),
(21391,21391,'Lavasillisk',0,'',0,'LineageMonster.lesser_basilisk','34.00','25.00',78,'male','L2Monster',40,'3045.00000','1649.00000','8.82300','3.11100',40,43,30,21,20,20,47322,5501,'1633.00000','613.00000','1169.00000','385.00000',230,4,150,333,0,0,0,35,140,1,1,0,1),
(21392,21392,'Blazing Ifrit',0,'',0,'LineageMonster2.ifrit_30_bi','13.00','55.00',78,'male','L2Monster',40,'3077.00000','1682.00000','8.87400','3.13140',40,43,30,21,20,20,67509,7941,'1672.00000','625.00000','1204.00000','397.00000',230,4,150,333,0,0,0,38,150,1,1,0,1),
(21393,21393,'Magma Drake',0,'',0,'LineageMonster2.inferno_drake_20_bi','29.00','42.00',78,'male','L2Monster',40,'3108.00000','1714.00000','8.92500','3.15180',40,43,30,21,20,20,56964,6780,'1711.00000','635.00000','1238.00000','407.00000',230,4,150,333,0,0,0,57,195,1,1,0,1),
(21394,21394,'Lavasaurus',0,'',0,'LineageMonster2.magmagoil','15.00','75.00',78,'male','L2Monster',1100,'2871.00000','1508.00000','8.58500','3.03000',40,43,30,21,20,20,44944,4981,'1464.00000','569.00000','1020.00000','344.00000',230,8,400,333,0,0,0,1,1,1,1,0,1),
(21395,21395,'Elder Lavasaurus',0,'',0,'LineageMonster2.magmagoil_lad','15.00','75.00',78,'male','L2Monster',1100,'3045.00000','1649.00000','8.82300','3.11100',40,43,30,21,20,20,58564,6808,'1633.00000','613.00000','1169.00000','385.00000',230,8,150,333,0,0,0,1,1,1,1,0,1),
(21396,21396,'Carrion Scarab',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2Monster',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,24549,2687,'1418.00000','556.00000','973.00000','337.00000',230,4,0,333,0,0,0,45,130,1,1,0,1),
(21397,21397,'Carrion Scarab',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2Monster',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,21310,2332,'1418.00000','556.00000','973.00000','337.00000',230,4,0,333,0,0,0,45,130,1,1,0,1),
(21398,21398,'Soldier Scarab',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2Monster',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,40465,4428,'1418.00000','556.00000','973.00000','337.00000',230,4,350,333,0,0,0,45,180,1,1,0,1),
(21399,21399,'Soldier Scarab',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2Monster',40,'2803.00000','1462.00000','8.50000','3.00000',40,43,30,21,20,20,38680,4233,'1418.00000','556.00000','973.00000','337.00000',230,4,350,333,0,0,0,45,180,1,1,0,1),
(21400,21400,'Hexa Beetle',0,'',0,'LineageMonster2.tera_beetle','19.00','54.50',78,'male','L2Monster',40,'2871.00000','1508.00000','8.58500','3.03000',40,43,30,21,20,20,33055,3663,'1464.00000','569.00000','1020.00000','344.00000',230,4,350,333,0,0,0,45,145,1,1,0,1),
(21401,21401,'Hexa Beetle',0,'',0,'LineageMonster2.tera_beetle','19.00','54.50',78,'male','L2Monster',40,'2871.00000','1508.00000','8.58500','3.03000',40,43,30,21,20,20,29087,3224,'1464.00000','569.00000','1020.00000','344.00000',230,4,350,333,0,0,0,45,145,1,1,0,1),
(21402,21402,'Katraxis',0,'',0,'LineageMonster2.scorpion_20_sm','24.00','52.80',78,'male','L2Monster',40,'2871.00000','1508.00000','8.58500','3.03000',40,43,30,21,20,20,30013,3326,'1464.00000','569.00000','1020.00000','344.00000',230,8,300,333,0,0,0,37,165,1,1,0,1),
(21403,21403,'Katraxis',0,'',0,'LineageMonster2.scorpion_20_sm','24.00','52.80',78,'male','L2Monster',40,'2871.00000','1508.00000','8.58500','3.03000',40,43,30,21,20,20,34642,3839,'1464.00000','569.00000','1020.00000','344.00000',230,8,300,333,0,0,0,37,165,1,1,0,1),
(21404,21404,'Tera Beetle',0,'',0,'LineageMonster2.tera_beetle','19.00','54.50',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,59626,6692,'1512.00000','581.00000','1058.00000','352.00000',230,4,0,333,0,0,0,45,185,1,1,0,1),
(21405,21405,'Tera Beetle',0,'',0,'LineageMonster2.tera_beetle','19.00','54.50',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,28588,3209,'1512.00000','581.00000','1058.00000','352.00000',230,4,0,333,0,0,0,45,185,1,1,0,1),
(21406,21406,'Knight of Empire',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,42272,4745,'1512.00000','581.00000','1058.00000','352.00000',230,4,300,333,150,103,0,40,145,1,1,0,1),
(21407,21407,'Knight of Empire',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,27052,3036,'1512.00000','581.00000','1058.00000','352.00000',230,4,300,333,150,103,0,40,145,1,1,0,1),
(21408,21408,'Royal Guard of Empire',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,36791,4129,'1512.00000','581.00000','1058.00000','352.00000',230,4,0,333,304,0,0,50,190,1,1,0,1),
(21409,21409,'Royal Guard of Empire',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,41142,4618,'1512.00000','581.00000','1058.00000','352.00000',230,4,0,333,304,0,0,50,190,1,1,0,1),
(21410,21410,'Guardian Scarab',0,'',0,'LineageMonster2.scarab_20_bi','17.00','26.50',78,'male','L2Monster',40,'2975.00000','1586.00000','8.72100','3.08040',40,43,30,21,20,20,38010,4316,'1554.00000','593.00000','1099.00000','363.00000',230,4,0,333,0,0,0,45,195,1,1,0,1),
(21411,21411,'Guardian Scarab',0,'',0,'LineageMonster2.scarab_20_bi','17.00','26.50',78,'male','L2Monster',40,'2975.00000','1586.00000','8.72100','3.08040',40,43,30,21,20,20,30337,3445,'1554.00000','593.00000','1099.00000','363.00000',230,4,0,333,0,0,0,45,195,1,1,0,1),
(21412,21412,'Ustralith',0,'',0,'LineageMonster2.scorpion','28.00','66.00',78,'male','L2Monster',40,'2975.00000','1586.00000','8.72100','3.08040',40,43,30,21,20,20,48414,5497,'1554.00000','593.00000','1099.00000','363.00000',230,8,150,333,0,0,0,37,130,1,1,0,1),
(21413,21413,'Ustralith',0,'',0,'LineageMonster2.scorpion','28.00','66.00',78,'male','L2Monster',40,'2975.00000','1586.00000','8.72100','3.08040',40,43,30,21,20,20,37229,4227,'1554.00000','593.00000','1099.00000','363.00000',230,8,150,333,0,0,0,37,130,1,1,0,1),
(21414,21414,'Assassin of Empire',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',78,'male','L2Monster',40,'2975.00000','1586.00000','8.72100','3.08040',40,43,30,21,20,20,36181,4108,'1554.00000','593.00000','1099.00000','363.00000',230,8,0,333,946,945,0,80,175,1,1,0,1),
(21415,21415,'Assassin of Empire',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',78,'male','L2Monster',40,'2975.00000','1586.00000','8.72100','3.08040',40,43,30,21,20,20,36499,4144,'1554.00000','593.00000','1099.00000','363.00000',230,8,0,333,946,945,0,80,175,1,1,0,1),
(21416,21416,'Imperial Commander',0,'',0,'LineageMonster2.imperial_warlord_zombie','7.00','30.00',78,'male','L2Monster',40,'2975.00000','1586.00000','8.72100','3.08040',40,43,30,21,20,20,43189,4904,'1554.00000','593.00000','1099.00000','363.00000',230,4,350,333,134,6721,0,39,140,1,1,0,1),
(21417,21417,'Imperial Commander',0,'',0,'LineageMonster2.imperial_warlord_zombie','7.00','30.00',78,'male','L2Monster',40,'2975.00000','1586.00000','8.72100','3.08040',40,43,30,21,20,20,75345,8555,'1554.00000','593.00000','1099.00000','363.00000',230,4,350,333,134,6721,0,39,140,1,1,0,1),
(21418,21418,'Imperial Royal Guard',0,'',0,'LineageMonster.death_knight','12.00','30.00',78,'male','L2Monster',40,'3011.00000','1617.00000','8.77200','3.10080',40,43,30,21,20,20,32124,3691,'1593.00000','603.00000','1133.00000','375.00000',230,4,0,333,142,0,0,27,160,1,1,0,1),
(21419,21419,'Imperial Royal Guard',0,'',0,'LineageMonster.death_knight','12.00','30.00',78,'male','L2Monster',40,'3011.00000','1617.00000','8.77200','3.10080',40,43,30,21,20,20,32694,3756,'1593.00000','603.00000','1133.00000','375.00000',230,4,0,333,142,0,0,27,160,1,1,0,1),
(21420,21420,'Ashuras',0,'',0,'LineageMonster2.ashuras','13.00','37.50',78,'male','L2Monster',40,'3011.00000','1617.00000','8.77200','3.10080',40,43,30,21,20,20,38520,4425,'1593.00000','603.00000','1133.00000','375.00000',230,4,150,333,0,0,0,41,200,1,1,0,1),
(21421,21421,'Ashuras',0,'',0,'LineageMonster2.ashuras','13.00','37.50',78,'male','L2Monster',40,'3011.00000','1617.00000','8.77200','3.10080',40,43,30,21,20,20,36159,4154,'1593.00000','603.00000','1133.00000','375.00000',230,4,150,333,0,0,0,41,200,1,1,0,1),
(21422,21422,'Dancer of Empire',0,'',0,'LineageMonster.banshee','9.00','23.00',78,'female','L2Monster',40,'3011.00000','1617.00000','8.77200','3.10080',40,43,30,21,20,20,41481,4766,'1593.00000','603.00000','1133.00000','375.00000',230,4,0,333,0,0,0,80,120,1,1,0,1),
(21423,21423,'Dancer of Empire',0,'',0,'LineageMonster.banshee','9.00','23.00',78,'female','L2Monster',40,'3011.00000','1617.00000','8.77200','3.10080',40,43,30,21,20,20,43973,5052,'1593.00000','603.00000','1133.00000','375.00000',230,4,150,333,0,0,0,80,120,1,1,0,1),
(21424,21424,'Ashkenas',0,'',0,'LineageMonster2.ashuras','13.00','37.50',78,'male','L2Monster',40,'3011.00000','1617.00000','8.77200','3.10080',40,43,30,21,20,20,55732,6403,'1593.00000','603.00000','1133.00000','375.00000',230,4,350,333,0,0,0,41,190,1,1,0,1),
(21425,21425,'Ashkenas',0,'',0,'LineageMonster2.ashuras','13.00','37.50',78,'male','L2Monster',40,'3011.00000','1617.00000','8.77200','3.10080',40,43,30,21,20,20,56668,6510,'1593.00000','603.00000','1133.00000','375.00000',230,4,350,333,0,0,0,41,190,1,1,0,1),
(21426,21426,'Abraxion',0,'',0,'LineageMonster2.erinyes','21.00','50.00',78,'male','L2Monster',40,'3045.00000','1649.00000','8.82300','3.11100',40,43,30,21,20,20,65250,7585,'1633.00000','613.00000','1169.00000','385.00000',230,1,350,333,0,0,0,31,130,1,1,0,1),
(21427,21427,'Abraxion',0,'',0,'LineageMonster2.erinyes','21.00','50.00',78,'male','L2Monster',40,'3045.00000','1649.00000','8.82300','3.11100',40,43,30,21,20,20,38349,4458,'1633.00000','613.00000','1169.00000','385.00000',230,1,350,333,0,0,0,31,130,1,1,0,1),
(21428,21428,'Hasturan',0,'',0,'LineageMonster2.erinyes','21.00','50.00',78,'male','L2Monster',40,'3045.00000','1649.00000','8.82300','3.11100',40,43,30,21,20,20,36621,4257,'1633.00000','613.00000','1169.00000','385.00000',230,1,150,333,0,0,0,31,150,1,1,0,1),
(21429,21429,'Hasturan',0,'',0,'LineageMonster2.erinyes','21.00','50.00',78,'male','L2Monster',40,'3045.00000','1649.00000','8.82300','3.11100',40,43,30,21,20,20,38239,4445,'1633.00000','613.00000','1169.00000','385.00000',230,1,150,333,0,0,0,31,150,1,1,0,1),
(21430,21430,'Arimanes',0,'',0,'LineageMonster2.ahrimanes','14.00','57.75',78,'male','L2Monster',40,'3045.00000','1649.00000','8.82300','3.11100',40,43,30,21,20,20,52810,6139,'1633.00000','613.00000','1169.00000','385.00000',230,4,0,333,6722,0,0,35,210,1,1,0,1),
(21431,21431,'Arimanes',0,'',0,'LineageMonster2.ahrimanes','14.00','57.75',78,'male','L2Monster',40,'3045.00000','1649.00000','8.82300','3.11100',40,43,30,21,20,20,45045,5236,'1633.00000','613.00000','1169.00000','385.00000',230,4,0,333,6722,0,0,35,210,1,1,0,1),
(21432,21432,'Chakram Beetle',0,'',0,'LineageMonster2.tera_beetle','19.00','54.50',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,72932,8186,'1512.00000','581.00000','1058.00000','352.00000',230,4,0,333,0,0,0,45,170,1,1,0,1),
(21433,21433,'Jamadar Beetle',0,'',0,'LineageMonster2.tera_beetle_20_sm','15.00','43.60',78,'male','L2Monster',40,'2871.00000','1508.00000','8.58500','3.03000',40,43,30,21,20,20,70729,7839,'1464.00000','569.00000','1020.00000','344.00000',230,4,0,333,0,0,0,45,175,1,1,0,1),
(21434,21434,'Seer of Blood',0,'',0,'LineageMonster2.erinyes','21.00','50.00',78,'male','L2Monster',40,'3011.00000','1617.00000','8.77200','3.10080',40,43,30,21,20,20,141369,16242,'1593.00000','603.00000','1133.00000','375.00000',230,1,0,333,0,0,0,31,150,1,1,0,1),
(21435,21435,'Guide of Offering',0,'',0,'LineageMonster2.imperial_warlord_zombie','7.00','30.00',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,71537,8029,'1512.00000','581.00000','1058.00000','352.00000',230,4,0,333,134,6721,0,39,150,1,1,0,1),
(21436,21436,'Leader of Offering',0,'',0,'LineageMonster2.imperial_warlord_zombie','7.00','30.00',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,74207,8329,'1512.00000','581.00000','1058.00000','352.00000',230,4,0,333,134,6721,0,39,150,1,1,0,1),
(21437,21437,'Offering Bug',0,'',0,'LineageMonster2.scarab','14.00','22.00',78,'male','L2Monster',40,'2871.00000','1508.00000','8.58500','3.03000',40,43,30,21,20,20,29957,3320,'1464.00000','569.00000','1020.00000','344.00000',230,4,0,333,0,0,0,45,180,1,1,0,1),
(21438,21438,'Heathen Warrior',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,1790,167,'890.00000','419.00000','615.00000','253.00000',230,8,150,333,946,945,0,80,175,1,1,0,1),
(21439,21439,'Heathen Executed',0,'',0,'LineageMonster.hungry_spirit','13.00','40.00',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,1846,174,'928.00000','429.00000','641.00000','260.00000',230,4,150,333,0,0,0,15,175,1,1,0,1),
(21440,21440,'Heathen Archer',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',67,'male','L2Monster',1100,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,2021,192,'967.00000','439.00000','663.00000','266.00000',230,8,0,333,284,0,0,40,155,1,1,0,1),
(21441,21441,'Heathen Grunt',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,1959,190,'1006.00000','450.00000','695.00000','272.00000',230,4,150,333,96,0,0,50,170,1,1,0,1),
(21442,21442,'Heathen Knight',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',69,'male','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,2017,197,'1046.00000','460.00000','717.00000','279.00000',230,4,150,333,150,103,0,40,165,1,1,0,1),
(21443,21443,'Raider of Pastureland',0,'',0,'LineageMonster.dark_mahum','13.00','26.00',63,'male','L2Monster',40,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,8408,760,'816.00000','399.00000','559.00000','242.00000',230,8,150,333,153,0,0,50,165,1,1,1,1),
(21444,21444,'Raider of Pastureland',0,'',0,'LineageMonster.dark_mahum','13.00','26.00',63,'male','L2Monster',40,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,7066,638,'816.00000','399.00000','559.00000','242.00000',230,4,150,333,153,0,0,50,165,1,1,1,1),
(21445,21445,'Alpine Bandersnatch',0,'',0,'LineageMonster2.bandersnatch','18.00','25.00',64,'male','L2Monster',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,7292,667,'853.00000','409.00000','584.00000','248.00000',230,4,150,333,0,0,0,30,170,1,1,1,1),
(21446,21446,'Raider of Pastureland',0,'',0,'LineageMonster.dark_mahum','13.00','26.00',64,'male','L2Monster',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,8972,821,'853.00000','409.00000','584.00000','248.00000',230,8,150,333,160,0,0,50,165,1,1,1,1),
(21447,21447,'Raider of Pastureland',0,'',0,'LineageMonster.dark_mahum','13.00','26.00',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,9228,869,'928.00000','429.00000','641.00000','260.00000',230,8,150,333,229,0,0,50,165,1,1,1,1),
(21448,21448,'Raider of Pastureland',0,'',0,'LineageMonster.dark_mahum','13.00','26.00',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,7754,730,'928.00000','429.00000','641.00000','260.00000',230,4,150,333,229,0,0,50,165,1,1,1,1),
(21449,21449,'Raider of Pastureland',0,'',0,'LineageMonster.dark_mahum','13.00','26.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,10128,978,'1006.00000','450.00000','695.00000','272.00000',230,8,150,333,234,0,0,50,165,1,1,1,1),
(21450,21450,'Alpine Grendel',0,'',0,'LineageMonster2.bionic_bear','15.00','39.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,9796,947,'1006.00000','450.00000','695.00000','272.00000',230,4,150,333,0,0,0,36,155,1,1,1,1),
(21451,21451,'Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7.00','15.00',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,3318,308,'890.00000','419.00000','615.00000','253.00000',230,4,0,333,0,0,0,13,110,1,1,1,1),
(21452,21452,'Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7.00','15.00',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,8775,815,'890.00000','419.00000','615.00000','253.00000',230,4,0,333,0,0,0,13,140,1,1,1,1),
(21453,21453,'Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7.00','15.00',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,7374,685,'890.00000','419.00000','615.00000','253.00000',230,4,0,333,0,0,0,13,140,1,1,1,1),
(21454,21454,'Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7.00','15.00',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,8775,815,'890.00000','419.00000','615.00000','253.00000',230,4,0,333,0,0,0,13,140,1,1,1,1),
(21455,21455,'Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7.00','15.00',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,7374,685,'890.00000','419.00000','615.00000','253.00000',230,4,0,333,0,0,0,13,140,1,1,1,1),
(21456,21456,'Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7.00','15.00',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,8775,815,'890.00000','419.00000','615.00000','253.00000',230,4,0,333,0,0,0,13,140,1,1,1,1),
(21457,21457,'Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7.00','15.00',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,7374,685,'890.00000','419.00000','615.00000','253.00000',230,4,0,333,0,0,0,13,140,1,1,1,1),
(21458,21458,'Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7.00','15.00',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,8775,815,'890.00000','419.00000','615.00000','253.00000',230,4,0,333,0,0,0,13,140,1,1,1,1),
(21459,21459,'Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7.00','15.00',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,7374,685,'890.00000','419.00000','615.00000','253.00000',230,4,0,333,0,0,0,13,140,1,1,1,1),
(21460,21460,'Alpine Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8.00','26.40',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,18387,1708,'890.00000','419.00000','615.00000','253.00000',230,4,150,333,0,0,0,23,190,1,1,0,1),
(21461,21461,'Alpine Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8.00','26.40',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,19112,1776,'890.00000','419.00000','615.00000','253.00000',230,4,150,333,0,0,0,23,190,1,1,0,1),
(21462,21462,'Alpine Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8.00','26.40',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,18387,1708,'890.00000','419.00000','615.00000','253.00000',230,4,150,333,0,0,0,23,190,1,1,0,1),
(21463,21463,'Alpine Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8.00','26.40',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,17683,1643,'890.00000','419.00000','615.00000','253.00000',230,4,150,333,0,0,0,23,190,1,1,0,1),
(21464,21464,'Alpine Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8.00','26.40',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,18387,1708,'890.00000','419.00000','615.00000','253.00000',230,4,150,333,0,0,0,23,190,1,1,0,1),
(21465,21465,'Alpine Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8.00','26.40',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,19112,1776,'890.00000','419.00000','615.00000','253.00000',230,4,150,333,0,0,0,23,190,1,1,0,1),
(21466,21466,'Alpine Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8.00','26.40',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,18387,1708,'890.00000','419.00000','615.00000','253.00000',230,4,150,333,0,0,0,23,190,1,1,0,1),
(21467,21467,'Alpine Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8.00','26.40',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,17683,1643,'890.00000','419.00000','615.00000','253.00000',230,4,150,333,0,0,0,23,190,1,1,0,1),
(21468,21468,'Alpine Kookaburra',0,'',0,'LineageMonster2.rough_ostrich','10.00','33.00',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,30997,2880,'890.00000','419.00000','615.00000','253.00000',230,4,150,333,0,0,0,23,210,1,1,0,1),
(21469,21469,'Alpine Kookaburra',0,'',0,'LineageMonster2.rough_ostrich','10.00','33.00',65,'male','L2FeedableBeast',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,29568,2747,'890.00000','419.00000','615.00000','253.00000',230,4,150,333,0,0,0,23,210,1,1,0,1),
(21470,21470,'Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12.00','15.00',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,3526,336,'967.00000','439.00000','663.00000','266.00000',230,1,0,333,0,0,0,30,110,1,1,1,1),
(21471,21471,'Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12.00','15.00',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,9323,888,'967.00000','439.00000','663.00000','266.00000',230,1,0,333,0,0,0,30,130,1,1,1,1),
(21472,21472,'Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12.00','15.00',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,7835,746,'967.00000','439.00000','663.00000','266.00000',230,1,0,333,0,0,0,30,130,1,1,1,1),
(21473,21473,'Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12.00','15.00',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,9323,888,'967.00000','439.00000','663.00000','266.00000',230,1,0,333,0,0,0,30,130,1,1,1,1),
(21474,21474,'Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12.00','15.00',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,7835,746,'967.00000','439.00000','663.00000','266.00000',230,1,0,333,0,0,0,30,130,1,1,1,1),
(21475,21475,'Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12.00','15.00',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,9323,888,'967.00000','439.00000','663.00000','266.00000',230,1,0,333,0,0,0,30,130,1,1,1,1),
(21476,21476,'Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12.00','15.00',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,7835,746,'967.00000','439.00000','663.00000','266.00000',230,1,0,333,0,0,0,30,130,1,1,1,1),
(21477,21477,'Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12.00','15.00',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,9323,888,'967.00000','439.00000','663.00000','266.00000',230,1,0,333,0,0,0,30,130,1,1,1,1),
(21478,21478,'Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12.00','15.00',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,7835,746,'967.00000','439.00000','663.00000','266.00000',230,1,0,333,0,0,0,30,130,1,1,1,1),
(21479,21479,'Alpine Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16.00','25.20',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,19535,1860,'967.00000','439.00000','663.00000','266.00000',230,1,150,333,0,0,0,20,170,1,1,0,1),
(21480,21480,'Alpine Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16.00','25.20',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,20306,1934,'967.00000','439.00000','663.00000','266.00000',230,1,150,333,0,0,0,20,170,1,1,0,1),
(21481,21481,'Alpine Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16.00','25.20',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,19535,1860,'967.00000','439.00000','663.00000','266.00000',230,1,150,333,0,0,0,20,170,1,1,0,1),
(21482,21482,'Alpine Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16.00','25.20',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,18788,1789,'967.00000','439.00000','663.00000','266.00000',230,1,150,333,0,0,0,20,170,1,1,0,1),
(21483,21483,'Alpine Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16.00','25.20',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,19535,1860,'967.00000','439.00000','663.00000','266.00000',230,1,150,333,0,0,0,20,170,1,1,0,1),
(21484,21484,'Alpine Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16.00','25.20',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,20306,1934,'967.00000','439.00000','663.00000','266.00000',230,1,150,333,0,0,0,20,170,1,1,0,1),
(21485,21485,'Alpine Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16.00','25.20',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,19535,1860,'967.00000','439.00000','663.00000','266.00000',230,1,150,333,0,0,0,20,170,1,1,0,1),
(21486,21486,'Alpine Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16.00','25.20',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,18788,1789,'967.00000','439.00000','663.00000','266.00000',230,1,150,333,0,0,0,20,170,1,1,0,1),
(21487,21487,'Alpine Buffalo',0,'',0,'LineageMonster2.buffalo','22.00','31.00',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,32934,3137,'967.00000','439.00000','663.00000','266.00000',230,1,150,333,0,0,0,20,170,1,1,0,1),
(21488,21488,'Alpine Buffalo',0,'',0,'LineageMonster2.buffalo','22.00','31.00',67,'male','L2FeedableBeast',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,31415,2992,'967.00000','439.00000','663.00000','266.00000',230,1,150,333,0,0,0,20,170,1,1,0,1),
(21489,21489,'Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11.00','15.70',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,3739,366,'1046.00000','460.00000','717.00000','279.00000',230,4,0,333,0,0,0,28,110,1,1,1,1),
(21490,21490,'Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11.00','15.70',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,9888,967,'1046.00000','460.00000','717.00000','279.00000',230,4,0,333,0,0,0,28,130,1,1,1,1),
(21491,21491,'Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11.00','15.70',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,8309,814,'1046.00000','460.00000','717.00000','279.00000',230,4,0,333,0,0,0,28,130,1,1,1,1),
(21492,21492,'Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11.00','15.70',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,9888,967,'1046.00000','460.00000','717.00000','279.00000',230,4,0,333,0,0,0,28,130,1,1,1,1),
(21493,21493,'Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11.00','15.70',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,8309,814,'1046.00000','460.00000','717.00000','279.00000',230,4,0,333,0,0,0,28,130,1,1,1,1),
(21494,21494,'Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11.00','15.70',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,9888,967,'1046.00000','460.00000','717.00000','279.00000',230,4,0,333,0,0,0,28,130,1,1,1,1),
(21495,21495,'Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11.00','15.70',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,8309,814,'1046.00000','460.00000','717.00000','279.00000',230,4,0,333,0,0,0,28,130,1,1,1,1),
(21496,21496,'Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11.00','15.70',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,9888,967,'1046.00000','460.00000','717.00000','279.00000',230,4,0,333,0,0,0,28,130,1,1,1,1),
(21497,21497,'Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11.00','15.70',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,8309,814,'1046.00000','460.00000','717.00000','279.00000',230,4,0,333,0,0,0,28,130,1,1,1,1),
(21498,21498,'Alpine Cougar',0,'',0,'LineageMonster2.youth_tiger','16.00','17.20',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,20719,2027,'1046.00000','460.00000','717.00000','279.00000',230,4,150,333,0,0,0,60,175,1,1,0,1),
(21499,21499,'Alpine Cougar',0,'',0,'LineageMonster2.youth_tiger','16.00','17.20',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,21536,2107,'1046.00000','460.00000','717.00000','279.00000',230,4,150,333,0,0,0,60,175,1,1,0,1),
(21500,21500,'Alpine Cougar',0,'',0,'LineageMonster2.youth_tiger','16.00','17.20',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,20719,2027,'1046.00000','460.00000','717.00000','279.00000',230,4,150,333,0,0,0,60,175,1,1,0,1),
(21501,21501,'Alpine Cougar',0,'',0,'LineageMonster2.youth_tiger','16.00','17.20',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,19926,1950,'1046.00000','460.00000','717.00000','279.00000',230,4,150,333,0,0,0,60,175,1,1,0,1),
(21502,21502,'Alpine Cougar',0,'',0,'LineageMonster2.youth_tiger','16.00','17.20',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,20719,2027,'1046.00000','460.00000','717.00000','279.00000',230,4,150,333,0,0,0,60,175,1,1,0,1),
(21503,21503,'Alpine Cougar',0,'',0,'LineageMonster2.youth_tiger','16.00','17.20',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,21536,2107,'1046.00000','460.00000','717.00000','279.00000',230,4,150,333,0,0,0,60,175,1,1,0,1),
(21504,21504,'Alpine Cougar',0,'',0,'LineageMonster2.youth_tiger','16.00','17.20',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,20719,2027,'1046.00000','460.00000','717.00000','279.00000',230,4,150,333,0,0,0,60,175,1,1,0,1),
(21505,21505,'Alpine Cougar',0,'',0,'LineageMonster2.youth_tiger','16.00','17.20',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,19926,1950,'1046.00000','460.00000','717.00000','279.00000',230,4,150,333,0,0,0,60,175,1,1,0,1),
(21506,21506,'Alpine Cougar',0,'',0,'LineageMonster.saber_toothed_tiger','34.00','28.00',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,34929,3418,'1046.00000','460.00000','717.00000','279.00000',230,4,150,333,0,0,0,60,200,1,1,0,1),
(21507,21507,'Alpine Cougar',0,'',0,'LineageMonster.saber_toothed_tiger','34.00','28.00',69,'male','L2FeedableBeast',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,33319,3260,'1046.00000','460.00000','717.00000','279.00000',230,4,150,333,0,0,0,60,200,1,1,0,1),
(21508,21508,'Splinter Stakato',0,'',0,'LineageMonster.blade_stakato','15.00','36.00',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,8771,825,'928.00000','429.00000','641.00000','260.00000',230,4,150,333,235,0,0,25,175,1,1,0,1),
(21509,21509,'Splinter Stakato Worker',0,'',0,'LineageMonster.blade_stakato_worker','13.00','40.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,8134,774,'967.00000','439.00000','663.00000','266.00000',230,4,150,333,0,0,0,25,180,1,1,0,1),
(21510,21510,'Splinter Stakato Soldier',0,'',0,'LineageMonster.blade_stakato_soldier','15.00','38.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,9561,923,'1006.00000','450.00000','695.00000','272.00000',230,4,150,333,148,0,0,25,180,1,1,0,1),
(21511,21511,'Splinter Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone','15.00','39.00',69,'male','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,10158,993,'1046.00000','460.00000','717.00000','279.00000',230,4,150,333,132,0,0,25,185,1,1,0,1),
(21512,21512,'Splinter Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone','15.00','39.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,9379,929,'1086.00000','471.00000','749.00000','285.00000',230,4,0,333,132,0,0,25,185,1,1,0,1),
(21513,21513,'Needle Stakato',0,'',0,'LineageMonster.blade_stakato','15.00','36.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,9867,978,'1086.00000','471.00000','749.00000','285.00000',230,4,150,333,235,0,0,25,185,1,1,0,1),
(21514,21514,'Needle Stakato Worker',0,'',0,'LineageMonster.blade_stakato_worker','13.00','40.00',71,'male','L2Monster',40,'2493.00000','1253.00000','8.50000','3.00000',40,43,30,21,20,20,9134,916,'1127.00000','481.00000','778.00000','292.00000',230,4,150,333,0,0,0,25,190,1,1,0,1),
(21515,21515,'Needle Stakato Soldier',0,'',0,'LineageMonster.blade_stakato_soldier','15.00','38.00',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,10718,1088,'1168.00000','492.00000','801.00000','298.00000',230,4,150,333,148,0,0,25,190,1,1,0,1),
(21516,21516,'Needle Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone','15.00','39.00',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,10730,1104,'1209.00000','502.00000','830.00000','304.00000',230,4,150,333,132,0,0,25,195,1,1,0,1),
(21517,21517,'Needle Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone','15.00','39.00',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,10481,1092,'1251.00000','513.00000','863.00000','311.00000',230,4,0,333,132,0,0,25,195,1,1,0,1),
(21518,21518,'Frenzy Stakato Soldier',0,'',0,'LineageMonster.blade_stakato_soldier','15.00','38.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,9228,891,'1006.00000','450.00000','695.00000','272.00000',230,4,0,333,235,0,0,25,185,1,1,0,1),
(21519,21519,'Frenzy Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone','15.00','39.00',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,10345,1051,'1168.00000','492.00000','801.00000','298.00000',230,4,0,333,235,0,0,25,195,1,1,0,1),
(21520,21520,'Eye of Splendor',0,'',0,'LineageMonster.kel_mahum','13.00','26.00',60,'male','L2Monster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,8960,778,'711.00000','369.00000','491.00000','224.00000',230,4,0,366,326,0,0,50,160,1,1,1,1),
(21521,21521,'Claws of Splendor',0,'',0,'LineageMonster.kel_mahum_warrior','13.00','28.00',60,'male','L2Monster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,8809,764,'711.00000','369.00000','491.00000','224.00000',230,4,0,366,326,0,0,50,160,1,1,1,1),
(21522,21522,'Claws of Splendor',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',60,'male','L2Monster',40,'1934.00000','943.00000','6.50000','2.40000',40,43,30,21,20,20,10498,911,'711.00000','369.00000','491.00000','224.00000',230,4,0,333,0,0,0,25,155,1,1,1,1),
(21523,21523,'Flash of Splendor',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13.00','25.00',61,'male','L2Monster',40,'1985.00000','970.00000','7.50000','2.70000',40,43,30,21,20,20,9035,796,'745.00000','379.00000','510.00000','230.00000',230,1,150,366,326,0,0,50,150,1,1,1,1),
(21524,21524,'Blade of Splendor',0,'',0,'LineageMonster.kel_mahum','13.00','26.00',61,'male','L2Monster',40,'1985.00000','970.00000','7.50000','2.70000',40,43,30,21,20,20,9634,848,'745.00000','379.00000','510.00000','230.00000',230,4,0,333,242,0,0,50,165,1,1,1,1),
(21525,21525,'Blade of Splendor',0,'',0,'LineageMonster.kel_mahum','13.00','26.00',61,'male','L2Monster',40,'1985.00000','970.00000','7.50000','2.70000',40,43,30,21,20,20,9634,848,'745.00000','379.00000','510.00000','230.00000',230,4,0,333,242,0,0,50,165,1,1,1,1),
(21526,21526,'Wisdom of Splendor',0,'',0,'LineageMonster.kel_mahum_warrior','13.00','28.00',62,'male','L2Monster',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,11065,986,'780.00000','389.00000','535.00000','235.00000',230,4,150,366,193,0,0,50,160,1,1,1,1),
(21527,21527,'Anger of Splendor',0,'',0,'LineageMonster.kel_mahum_champion','13.00','32.00',63,'male','L2Monster',40,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,9759,881,'816.00000','399.00000','559.00000','242.00000',230,4,0,476,193,0,0,50,150,1,1,1,1),
(21528,21528,'Anger of Splendor',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',63,'male','L2Monster',40,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,11574,1045,'816.00000','399.00000','559.00000','242.00000',230,4,0,333,0,0,0,25,155,1,1,1,1),
(21529,21529,'Soul of Splendor',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13.00','25.00',63,'male','L2Monster',40,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,8853,799,'816.00000','399.00000','559.00000','242.00000',230,1,150,366,193,0,0,50,160,1,1,1,1),
(21530,21530,'Victory of Splendor',0,'',0,'LineageMonster.kel_mahum','13.00','26.00',64,'male','L2Monster',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,9608,880,'853.00000','409.00000','584.00000','248.00000',230,4,0,366,196,0,0,50,160,1,1,1,1),
(21531,21531,'Punishment of Splendor',0,'',0,'LineageMonster.kel_mahum_warrior','13.00','28.00',64,'male','L2Monster',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,10605,971,'853.00000','409.00000','584.00000','248.00000',230,4,0,333,242,0,0,50,165,1,1,1,1),
(21532,21532,'Shout of Splendor',0,'',0,'LineageMonster.kel_mahum_champion','13.00','32.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,11348,1055,'890.00000','419.00000','615.00000','253.00000',230,4,150,476,196,0,0,50,150,1,1,1,1),
(21533,21533,'Alliance of Splendor',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13.00','25.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,9320,866,'890.00000','419.00000','615.00000','253.00000',230,1,0,366,196,0,0,50,160,1,1,1,1),
(21534,21534,'Alliance of Splendor',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,12321,1145,'890.00000','419.00000','615.00000','253.00000',230,4,0,333,0,0,0,25,155,1,1,1,1),
(21535,21535,'Signet of Splendor',0,'',0,'LineageMonster.kel_mahum_warrior','13.00','28.00',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,11197,1054,'928.00000','429.00000','641.00000','260.00000',230,4,150,333,189,0,0,50,160,1,1,1,1),
(21536,21536,'Crown of Splendor',0,'',0,'LineageMonster.kel_mahum_champion','13.00','32.00',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,11385,1072,'928.00000','429.00000','641.00000','260.00000',230,4,0,333,189,0,0,50,165,1,1,1,1),
(21537,21537,'Fang of Splendor',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13.00','25.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,10686,1018,'967.00000','439.00000','663.00000','266.00000',230,1,0,333,189,0,0,50,155,1,1,1,1),
(21538,21538,'Fang of Splendor',0,'',0,'LineageMonster.dark_fencer','7.00','13.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,13091,1247,'967.00000','439.00000','663.00000','266.00000',230,4,0,333,0,0,0,25,155,1,1,1,1),
(21539,21539,'Wailing of Splendor',0,'',0,'LineageMonster.kel_mahum','13.00','26.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,11622,1106,'967.00000','439.00000','663.00000','266.00000',230,4,0,333,242,0,0,50,170,1,1,1,1),
(21540,21540,'Wailing of Splendor',0,'',0,'LineageMonster.kel_mahum','13.00','26.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,11622,1106,'967.00000','439.00000','663.00000','266.00000',230,4,0,333,242,0,0,50,170,1,1,1,1),
(21541,21541,'Pilgrim of Splendor',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13.00','25.00',63,'male','L2Monster',40,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,11933,1078,'816.00000','399.00000','559.00000','242.00000',230,1,150,476,315,0,0,50,165,1,1,0,1),
(21542,21542,'Disciple of Pilgrim',0,'',0,'LineageMonster.kel_mahum_warrior','13.00','28.00',62,'male','L2Monster',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,8319,742,'780.00000','389.00000','535.00000','235.00000',230,4,0,476,193,0,0,50,165,1,1,0,1),
(21543,21543,'Page of Pilgrim',0,'',0,'LineageMonster.kel_mahum','13.00','26.00',62,'male','L2Monster',40,'2038.00000','998.00000','7.50000','2.70000',40,43,30,21,20,20,9492,846,'780.00000','389.00000','535.00000','235.00000',230,4,0,476,326,0,0,50,165,1,1,0,1),
(21544,21544,'Judge of Splendor',0,'',0,'LineageMonster.kel_mahum_champion','13.00','32.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,13598,1295,'967.00000','439.00000','663.00000','266.00000',230,4,150,512,150,0,0,50,160,1,1,0,1),
(21545,21545,'Judge of Fire',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13.00','25.00',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,9427,887,'928.00000','429.00000','641.00000','260.00000',230,1,0,476,189,0,0,50,165,1,1,0,1),
(21546,21546,'Judge of Light',0,'',0,'LineageMonster.kel_mahum','13.00','26.00',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,10756,1013,'928.00000','429.00000','641.00000','260.00000',230,4,0,476,196,0,0,50,165,1,1,0,1),
(21547,21547,'Corrupted Knight',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',63,'male','L2Monster',40,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,9739,880,'816.00000','399.00000','559.00000','242.00000',230,4,0,333,150,103,0,40,165,1,1,1,1),
(21548,21548,'Resurrected Knight',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',63,'male','L2Monster',40,'2090.00000','1025.00000','7.50000','2.70000',40,43,30,21,20,20,8423,761,'816.00000','399.00000','559.00000','242.00000',230,4,0,333,150,103,0,40,165,1,1,1,1),
(21549,21549,'Corrupted Guard',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',64,'male','L2Monster',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,10051,920,'853.00000','409.00000','584.00000','248.00000',230,8,0,333,946,0,0,80,175,1,1,1,1),
(21550,21550,'Corrupted Guard',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',64,'male','L2Monster',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,10252,938,'853.00000','409.00000','584.00000','248.00000',230,8,150,333,946,945,0,80,175,1,1,1,1),
(21551,21551,'Resurrected Guard',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,11449,1078,'928.00000','429.00000','641.00000','260.00000',230,8,0,333,221,0,0,80,175,1,1,1,1),
(21552,21552,'Resurrected Guard',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,10903,1026,'928.00000','429.00000','641.00000','260.00000',230,8,150,333,221,945,0,80,175,1,1,1,1),
(21553,21553,'Trampled Man',0,'',0,'LineageMonster.zombie','13.00','21.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,7521,698,'890.00000','419.00000','615.00000','253.00000',230,4,0,333,0,0,0,15,40,1,1,1,1),
(21554,21554,'Trampled Man',0,'',0,'LineageMonster.zombie','13.00','21.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,7521,698,'890.00000','419.00000','615.00000','253.00000',230,4,0,333,0,0,0,15,40,1,1,1,1),
(21555,21555,'Slaughter Executioner',0,'',0,'LineageMonster.dark_horror','20.00','35.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,9144,850,'890.00000','419.00000','615.00000','253.00000',230,4,0,333,0,0,0,100,160,1,1,1,1),
(21556,21556,'Slaughter Executioner',0,'',0,'LineageMonster.dark_horror','20.00','35.00',65,'male','L2Monster',40,'2194.00000','1082.00000','7.50000','2.70000',40,43,30,21,20,20,8922,829,'890.00000','419.00000','615.00000','253.00000',230,4,0,333,0,0,0,100,160,1,1,1,1),
(21557,21557,'Bone Snatcher',0,'',0,'LineageMonster2.black_magician','8.00','30.00',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,10529,991,'928.00000','429.00000','641.00000','260.00000',230,4,0,333,178,0,0,19,180,1,1,1,1),
(21558,21558,'Bone Snatcher',0,'',0,'LineageMonster2.black_magician','8.00','30.00',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,10529,991,'928.00000','429.00000','641.00000','260.00000',230,4,0,333,178,0,0,19,180,1,1,1,1),
(21559,21559,'Bone Maker',0,'',0,'LineageMonster2.black_magician','8.00','30.00',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,11515,1084,'928.00000','429.00000','641.00000','260.00000',230,4,150,333,178,0,0,19,180,1,1,1,1),
(21560,21560,'Bone Shaper',0,'',0,'LineageMonster2.black_magician','8.00','30.00',66,'male','L2Monster',40,'2245.00000','1110.00000','7.50000','2.70000',40,43,30,21,20,20,11515,1084,'928.00000','429.00000','641.00000','260.00000',230,4,150,333,178,0,0,19,180,1,1,1,1),
(21561,21561,'Sacrificed Man',0,'',0,'LineageMonster.zombie','13.00','21.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,9669,920,'967.00000','439.00000','663.00000','266.00000',230,4,150,333,0,0,0,15,40,1,1,1,1),
(21562,21562,'Guillotine\'s Ghost',0,'',0,'LineageMonster.liviona','15.00','28.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,10013,954,'967.00000','439.00000','663.00000','266.00000',230,1,150,333,0,0,0,80,150,1,1,1,1),
(21563,21563,'Bone Collector',0,'',0,'LineageMonster2.black_magician','8.00','30.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,11634,1108,'967.00000','439.00000','663.00000','266.00000',230,4,0,333,178,0,0,19,180,1,1,1,1),
(21564,21564,'Skull Collector',0,'',0,'LineageMonster2.black_magician','8.00','30.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,11068,1054,'967.00000','439.00000','663.00000','266.00000',230,4,150,333,178,0,0,19,180,1,1,1,1),
(21565,21565,'Bone Animator',0,'',0,'LineageMonster2.black_magician','8.00','30.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,11177,1080,'1006.00000','450.00000','695.00000','272.00000',230,4,0,333,178,0,0,19,180,1,1,1,1),
(21566,21566,'Skull Animator',0,'',0,'LineageMonster2.black_magician','8.00','30.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,12224,1181,'1006.00000','450.00000','695.00000','272.00000',230,4,150,333,178,0,0,19,180,1,1,1,1),
(21567,21567,'Bone Slayer',0,'',0,'LineageMonster2.black_magician','8.00','30.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,14611,1411,'1006.00000','450.00000','695.00000','272.00000',230,4,150,333,178,0,0,19,180,1,1,1,1),
(21568,21568,'Devil Bat',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,12528,1211,'1006.00000','450.00000','695.00000','272.00000',230,4,150,333,0,0,0,60,170,1,1,1,1),
(21569,21569,'Devil Bat',0,'',0,'LineageMonster.vampire_bat','10.00','33.50',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,9730,940,'1006.00000','450.00000','695.00000','272.00000',230,4,150,333,0,0,0,60,170,1,1,1,1),
(21570,21570,'Ghost of Betrayer',0,'',0,'LineageMonster.binding','12.00','21.00',69,'male','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,9069,887,'1046.00000','460.00000','717.00000','279.00000',230,4,150,333,0,0,0,10,174,1,1,1,1),
(21571,21571,'Ghost of Rebellion Soldier',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',69,'male','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,12862,1259,'1046.00000','460.00000','717.00000','279.00000',230,4,150,333,150,103,0,40,165,1,1,1,1),
(21572,21572,'Bone Sweeper',0,'',0,'LineageMonster2.black_magician','8.00','30.00',69,'male','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,12339,1207,'1046.00000','460.00000','717.00000','279.00000',230,4,0,333,178,0,0,19,185,1,1,1,1),
(21573,21573,'Atrox',0,'',0,'LineageMonster2.kailiharim','35.00','39.00',69,'male','L2Monster',40,'2396.00000','1196.00000','7.50000','2.70000',40,43,30,21,20,20,13747,1345,'1046.00000','460.00000','717.00000','279.00000',230,4,150,333,0,0,0,105,185,1,1,1,1),
(21574,21574,'Bone Grinder',0,'',0,'LineageMonster2.black_magician','8.00','30.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,15483,1535,'1086.00000','471.00000','749.00000','285.00000',230,4,150,333,178,0,0,19,185,1,1,1,1),
(21575,21575,'Bone Grinder',0,'',0,'LineageMonster2.black_magician','8.00','30.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,8723,865,'1086.00000','471.00000','749.00000','285.00000',230,4,150,333,178,0,0,19,185,1,1,1,1),
(21576,21576,'Ghost of Guillotine',0,'',0,'LineageMonster.liviona','15.00','28.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,11220,1112,'1086.00000','471.00000','749.00000','285.00000',230,1,0,333,0,0,0,80,150,1,1,1,1),
(21577,21577,'Ghost of Guillotine',0,'',0,'LineageMonster.liviona','15.00','28.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,9835,976,'1086.00000','471.00000','749.00000','285.00000',230,1,0,333,0,0,0,80,150,1,1,1,1),
(21578,21578,'Behemoth Zombie',0,'',0,'LineageMonster2.giant_zombie','13.00','40.00',71,'male','L2Monster',40,'2493.00000','1253.00000','8.50000','3.00000',40,43,30,21,20,20,12370,1241,'1127.00000','481.00000','778.00000','292.00000',230,4,0,333,0,0,0,20,90,1,1,1,1),
(21579,21579,'Ghost of Rebellion Leader',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',71,'male','L2Monster',40,'2493.00000','1253.00000','8.50000','3.00000',40,43,30,21,20,20,13012,1306,'1127.00000','481.00000','778.00000','292.00000',230,8,0,333,221,945,0,80,175,1,1,1,1),
(21580,21580,'Bone Caster',0,'',0,'LineageMonster2.black_magician','8.00','30.00',71,'male','L2Monster',40,'2493.00000','1253.00000','8.50000','3.00000',40,43,30,21,20,20,12185,1223,'1127.00000','481.00000','778.00000','292.00000',230,4,0,333,178,0,0,19,185,1,1,1,1),
(21581,21581,'Bone Puppeteer',0,'',0,'LineageMonster2.black_magician','8.00','30.00',71,'male','L2Monster',40,'2493.00000','1253.00000','8.50000','3.00000',40,43,30,21,20,20,13326,1337,'1127.00000','481.00000','778.00000','292.00000',230,4,150,333,178,0,0,19,185,1,1,1,1),
(21582,21582,'Vampire Soldier',0,'',0,'LineageMonster2.vampire_soldier','8.00','23.50',71,'male','L2Monster',40,'2493.00000','1253.00000','8.50000','3.00000',40,43,30,21,20,20,14270,1432,'1127.00000','481.00000','778.00000','292.00000',230,4,0,333,234,0,0,60,190,1,1,1,1),
(21583,21583,'Bone Scavenger',0,'',0,'LineageMonster2.black_magician','8.00','30.00',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,13436,1364,'1168.00000','492.00000','801.00000','298.00000',230,4,0,333,178,0,0,19,185,1,1,1,1),
(21584,21584,'Bone Scavenger',0,'',0,'LineageMonster2.black_magician','8.00','30.00',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,12531,1273,'1168.00000','492.00000','801.00000','298.00000',230,4,0,333,178,0,0,19,185,1,1,1,1),
(21585,21585,'Vampire Magician',0,'',0,'LineageMonster2.vampire_witch','6.00','21.50',72,'female','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,11554,1174,'1168.00000','492.00000','801.00000','298.00000',230,4,150,333,946,0,0,64,180,1,1,1,1),
(21586,21586,'Vampire Adept',0,'',0,'LineageMonster2.vampire_wizard','5.50','28.00',72,'female','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,13649,1387,'1168.00000','492.00000','801.00000','298.00000',230,4,150,333,99,0,0,46,180,1,1,1,1),
(21587,21587,'Vampire Warrior',0,'',0,'LineageMonster2.vampire_soldier_20_bi','10.00','29.00',72,'male','L2Monster',40,'2540.00000','1283.00000','8.50000','3.00000',40,43,30,21,20,20,14223,1445,'1168.00000','492.00000','801.00000','298.00000',230,4,0,333,234,0,0,60,190,1,1,1,1),
(21588,21588,'Vampire Wizard',0,'',0,'LineageMonster2.vampire_witch','6.00','21.50',73,'female','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,11923,1226,'1209.00000','502.00000','830.00000','304.00000',230,4,0,333,946,0,0,64,180,1,1,1,1),
(21589,21589,'Vampire Wizard',0,'',0,'LineageMonster2.vampire_witch','6.00','21.50',73,'female','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,12202,1255,'1209.00000','502.00000','830.00000','304.00000',230,4,0,333,946,0,0,64,180,1,1,1,1),
(21590,21590,'Vampire Magister',0,'',0,'LineageMonster2.vampire_wizard','5.50','28.00',73,'female','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,11923,1226,'1209.00000','502.00000','830.00000','304.00000',230,4,0,333,99,0,0,46,180,1,1,1,1),
(21591,21591,'Vampire Magister',0,'',0,'LineageMonster2.vampire_wizard','5.50','28.00',73,'female','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,13756,1415,'1209.00000','502.00000','830.00000','304.00000',230,4,0,333,99,0,0,46,180,1,1,1,1),
(21592,21592,'Vampire Magister',0,'',0,'LineageMonster2.vampire_wizard','5.50','28.00',73,'female','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,9301,956,'1209.00000','502.00000','830.00000','304.00000',230,4,0,333,99,0,0,46,180,1,1,1,1),
(21593,21593,'Vampire Warlord',0,'',0,'LineageMonster2.vampire_warrior','9.00','31.50',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,16016,1648,'1209.00000','502.00000','830.00000','304.00000',230,4,0,333,6723,0,0,43,190,1,1,1,1),
(21594,21594,'Vampire Warlord',0,'',0,'LineageMonster2.vampire_warrior','9.00','31.50',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,15086,1553,'1209.00000','502.00000','830.00000','304.00000',230,4,0,333,6723,0,0,43,190,1,1,1,1),
(21595,21595,'Vampire Warlord',0,'',0,'LineageMonster2.vampire_warrior','9.00','31.50',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,10993,1132,'1209.00000','502.00000','830.00000','304.00000',230,4,0,333,6723,0,0,43,190,1,1,1,1),
(21596,21596,'Requiem Lord',0,'',0,'LineageMonster2.black_magician','8.00','30.00',68,'male','L2Monster',40,'2346.00000','1166.00000','7.50000','2.70000',40,43,30,21,20,20,14446,1396,'1006.00000','450.00000','695.00000','272.00000',230,4,150,333,178,0,0,19,185,1,1,0,1),
(21597,21597,'Requiem Behemoth',0,'',0,'LineageMonster2.giant_zombie','13.00','40.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,9919,944,'967.00000','439.00000','663.00000','266.00000',230,4,0,333,0,0,0,20,100,1,1,0,1),
(21598,21598,'Requiem Behemoth',0,'',0,'LineageMonster2.giant_zombie','13.00','40.00',67,'male','L2Monster',40,'2296.00000','1139.00000','7.50000','2.70000',40,43,30,21,20,20,11015,1049,'967.00000','439.00000','663.00000','266.00000',230,4,0,333,0,0,0,20,100,1,1,0,1),
(21599,21599,'Requiem Priest',0,'',0,'LineageMonster2.black_magician','8.00','30.00',71,'male','L2Monster',40,'2493.00000','1253.00000','8.50000','3.00000',40,43,30,21,20,20,15301,1535,'1127.00000','481.00000','778.00000','292.00000',230,4,150,333,178,0,0,19,185,1,1,0,1),
(21600,21600,'Requiem Behemoth',0,'',0,'LineageMonster2.giant_zombie','13.00','40.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,10827,1074,'1086.00000','471.00000','749.00000','285.00000',230,4,0,333,0,0,0,20,100,1,1,0,1),
(21601,21601,'Requiem Behemoth',0,'',0,'LineageMonster2.giant_zombie','13.00','40.00',70,'male','L2Monster',40,'2444.00000','1225.00000','7.50000','2.70000',40,43,30,21,20,20,12879,1277,'1086.00000','471.00000','749.00000','285.00000',230,4,0,333,0,0,0,20,100,1,1,0,1),
(21602,21602,'Zaken\'s Pikeman',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',43,'male','L2Monster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,4433,300,'275.00000','223.00000','191.00000','135.00000',230,4,150,333,292,0,0,50,174,1,1,0,1),
(21603,21603,'Zaken\'s Pikeman',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',43,'male','L2Monster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,6277,425,'275.00000','223.00000','191.00000','135.00000',230,4,150,333,292,0,0,50,174,1,1,0,1),
(21604,21604,'Zaken\'s Elite Pikeman',0,'',0,'LineageMonster.skeleton_pikeman_20_bi','12.00','33.60',43,'male','L2Monster',40,'1094.00000','507.00000','5.50000','2.10000',40,43,30,21,20,20,10149,686,'275.00000','223.00000','191.00000','135.00000',230,4,150,333,292,0,0,50,174,1,1,0,1),
(21605,21605,'Zaken\'s Archer',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',44,'male','L2Monster',1100,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,4931,337,'293.00000','231.00000','199.00000','139.00000',230,8,0,333,279,0,0,40,174,1,1,0,1),
(21606,21606,'Zaken\'s Archer',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',44,'male','L2Monster',1100,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,6982,478,'293.00000','231.00000','199.00000','139.00000',230,8,0,333,279,0,0,40,174,1,1,0,1),
(21607,21607,'Zaken\'s Elite Archer',0,'',0,'LineageMonster.skeleton_archer_20_bi','13.00','32.50',44,'male','L2Monster',1100,'1139.00000','531.00000','5.50000','2.10000',40,43,30,21,20,20,10911,746,'293.00000','231.00000','199.00000','139.00000',230,8,0,333,279,0,0,40,174,1,1,0,1),
(21608,21608,'Zaken\'s Watchman',0,'',0,'LineageMonster.liviona','15.00','28.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,4039,281,'313.00000','238.00000','212.00000','144.00000',230,1,150,333,0,0,0,80,174,1,1,0,1),
(21609,21609,'Zaken\'s Watchman',0,'',0,'LineageMonster.liviona','15.00','28.00',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,5720,397,'313.00000','238.00000','212.00000','144.00000',230,1,150,333,0,0,0,80,174,1,1,0,1),
(21610,21610,'Zaken\'s High Grade Watchman',0,'',0,'LineageMonster.liviona_20_bi','18.00','33.60',45,'male','L2Monster',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,10440,726,'313.00000','238.00000','212.00000','144.00000',230,1,150,333,0,0,0,80,174,1,1,0,1),
(21611,21611,'Unpleasant Humming',0,'',0,'LineageMonster.unpleasant_humming','12.00','26.00',46,'male','L2Monster',40,'1230.00000','580.00000','5.50000','2.10000',40,43,30,21,20,20,4689,332,'332.00000','246.00000','231.00000','149.00000',230,4,150,333,0,0,0,21,174,1,1,0,1),
(21612,21612,'Unpleasant Humming',0,'',0,'LineageMonster.unpleasant_humming','12.00','26.00',46,'male','L2Monster',40,'1230.00000','580.00000','5.50000','2.10000',40,43,30,21,20,20,6640,470,'332.00000','246.00000','231.00000','149.00000',230,4,150,333,0,0,0,21,174,1,1,0,1),
(21613,21613,'Unpleasant Shout',0,'',0,'LineageMonster.unpleasant_humming_20_bi','13.50','31.20',46,'male','L2Monster',40,'1230.00000','580.00000','5.50000','2.10000',40,43,30,21,20,20,11332,803,'332.00000','246.00000','231.00000','149.00000',230,4,150,333,0,0,0,21,174,1,1,0,1),
(21614,21614,'Death Flyer',0,'',0,'LineageMonster.dark_horror','20.00','35.00',47,'male','L2Monster',40,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,4843,347,'353.00000','254.00000','244.00000','154.00000',230,1,0,333,0,0,0,100,174,1,1,0,1),
(21615,21615,'Death Flyer',0,'',0,'LineageMonster.dark_horror','20.00','35.00',47,'male','L2Monster',40,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,6858,492,'353.00000','254.00000','244.00000','154.00000',230,1,0,333,0,0,0,100,174,1,1,0,1),
(21616,21616,'Gigantic Flyer',0,'',0,'LineageMonster.dark_horror_bi','20.00','42.00',47,'male','L2Monster',40,'1277.00000','605.00000','5.50000','2.10000',40,43,30,21,20,20,12517,898,'353.00000','254.00000','244.00000','154.00000',230,1,0,333,0,0,0,100,174,1,1,0,1),
(21617,21617,'Fiend Archer',0,'',0,'LineageMonster.fiend_archer','17.00','55.00',48,'male','L2Monster',1100,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,4925,360,'375.00000','262.00000','260.00000','159.00000',230,8,150,333,0,0,0,70,174,1,1,0,1),
(21618,21618,'Fiend Archer',0,'',0,'LineageMonster.fiend_archer','17.00','55.00',48,'male','L2Monster',1100,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,6974,510,'375.00000','262.00000','260.00000','159.00000',230,8,150,333,0,0,0,70,174,1,1,0,1),
(21619,21619,'Pit Archer',0,'',0,'LineageMonster.fiend_archer_20_bi','20.00','66.00',48,'male','L2Monster',1100,'1324.00000','630.00000','5.50000','2.10000',40,43,30,21,20,20,12729,930,'375.00000','262.00000','260.00000','159.00000',230,8,150,333,0,0,0,70,174,1,1,0,1),
(21620,21620,'Musveren',0,'',0,'LineageMonster.field_stalker','16.00','36.00',49,'male','L2Monster',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,4742,350,'398.00000','270.00000','275.00000','164.00000',230,4,0,333,0,0,0,70,174,1,1,0,1),
(21621,21621,'Musveren',0,'',0,'LineageMonster.field_stalker','16.00','36.00',49,'male','L2Monster',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,6715,497,'398.00000','270.00000','275.00000','164.00000',230,4,0,333,0,0,0,70,174,1,1,0,1),
(21622,21622,'Greater Musveren',0,'',0,'LineageMonster.field_stalker_20_bi','18.00','36.00',49,'male','L2Monster',40,'1372.00000','655.00000','5.50000','2.10000',40,43,30,21,20,20,12257,906,'398.00000','270.00000','275.00000','164.00000',230,4,0,333,0,0,0,70,174,1,1,0,1),
(21623,21623,'Zaken\'s Guard',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,5993,451,'421.00000','278.00000','286.00000','169.00000',230,8,150,333,225,945,0,80,174,1,1,0,1),
(21624,21624,'Zaken\'s Guard',0,'',0,'LineageMonster.skeleton_royal_guard','11.00','28.50',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,8487,640,'421.00000','278.00000','286.00000','169.00000',230,8,150,333,225,945,0,80,174,1,1,0,1),
(21625,21625,'Zaken\'s Elite Guard',0,'',0,'LineageMonster.skeleton_royal_guard_20_bi','13.00','34.50',50,'male','L2Monster',40,'1421.00000','680.00000','5.50000','2.10000',40,43,30,21,20,20,13722,1033,'421.00000','278.00000','286.00000','169.00000',230,8,150,333,225,945,0,80,174,1,1,0,1),
(21626,21626,'Kaim Vanul',0,'',0,'LineageMonster.kaim_vanul','24.00','40.00',51,'male','L2Monster',40,'1470.00000','706.00000','6.50000','2.40000',40,43,30,21,20,20,5345,408,'446.00000','287.00000','309.00000','174.00000',230,4,0,333,0,0,0,37,174,1,1,0,1),
(21627,21627,'Kaim Vanul',0,'',0,'LineageMonster.kaim_vanul','24.00','40.00',51,'male','L2Monster',40,'1470.00000','706.00000','6.50000','2.40000',40,43,30,21,20,20,7568,577,'446.00000','287.00000','309.00000','174.00000',230,4,0,333,0,0,0,37,174,1,1,0,1),
(21628,21628,'Kaim Vanul Lad',0,'',0,'LineageMonster.kaim_vanul_20_bi','28.00','48.00',51,'male','L2Monster',40,'1470.00000','706.00000','6.50000','2.40000',40,43,30,21,20,20,13814,1054,'446.00000','287.00000','309.00000','174.00000',230,4,0,333,0,0,0,37,174,1,1,0,1),
(21629,21629,'Pirate Zombie Captain',0,'',0,'LineageMonster.pirates_zombie_captain','17.00','28.00',52,'male','L2Monster',40,'1520.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,8073,624,'472.00000','295.00000','321.00000','179.00000',230,8,150,333,232,0,0,14,174,1,1,0,1),
(21630,21630,'Pirate Zombie Captain',0,'',0,'LineageMonster.pirates_zombie_captain','17.00','28.00',52,'male','L2Monster',40,'1520.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,11432,884,'472.00000','295.00000','321.00000','179.00000',230,8,150,333,232,0,0,14,174,1,1,0,1),
(21631,21631,'Zombie Captain\'s Spiritual Body',0,'',0,'LineageMonster.pirates_zombie_captain_20_bi','20.00','33.60',52,'male','L2Monster',40,'1520.00000','731.00000','6.50000','2.40000',40,43,30,21,20,20,18953,1466,'472.00000','295.00000','321.00000','179.00000',230,8,150,333,232,0,0,14,174,1,1,0,1),
(21632,21632,'Doll Blader',0,'',0,'LineageMonster.doll_blader','6.00','12.00',53,'male','L2Monster',40,'1571.00000','757.00000','6.50000','2.40000',40,43,30,21,20,20,6407,504,'498.00000','304.00000','344.00000','184.00000',230,8,0,333,5129,5129,0,22,174,1,1,0,1),
(21633,21633,'Doll Blader',0,'',0,'LineageMonster.doll_blader','6.00','12.00',53,'male','L2Monster',40,'1571.00000','757.00000','6.50000','2.40000',40,43,30,21,20,20,9073,713,'498.00000','304.00000','344.00000','184.00000',230,8,0,333,5129,5129,0,22,174,1,1,0,1),
(21634,21634,'Crimson Doll Blader',0,'',0,'LineageMonster.doll_blader_20_bi','7.00','15.00',53,'male','L2Monster',40,'1571.00000','757.00000','6.50000','2.40000',40,43,30,21,20,20,16560,1302,'498.00000','304.00000','344.00000','184.00000',230,8,0,333,5129,5129,0,22,174,1,1,0,1),
(21635,21635,'Vale Master',0,'',0,'LineageMonster.vale_master','12.00','40.00',54,'male','L2Monster',40,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,6112,487,'526.00000','313.00000','364.00000','189.00000',230,4,150,333,0,0,0,70,174,1,1,0,1),
(21636,21636,'Vale Master',0,'',0,'LineageMonster.vale_master','12.00','40.00',54,'male','L2Monster',40,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,8655,690,'526.00000','313.00000','364.00000','189.00000',230,4,150,333,0,0,0,70,174,1,1,0,1),
(21637,21637,'Crimson Vale Master',0,'',0,'LineageMonster.vale_master_20_bi','14.50','48.00',54,'male','L2Monster',40,'1622.00000','784.00000','6.50000','2.40000',40,43,30,21,20,20,15797,1260,'526.00000','313.00000','364.00000','189.00000',230,4,150,333,0,0,0,70,174,1,1,0,1),
(21638,21638,'Dread Wolf',0,'',0,'LineageMonster.dire_wolf','13.00','11.00',35,'male','L2Monster',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,1382,82,'159.00000','170.00000','111.00000','102.00000',230,4,150,333,0,0,0,24,140,1,1,1,1),
(21639,21639,'Tasaba Lizardman',0,'',0,'LineageMonster.virud_lizardman_scout','10.00','22.00',36,'male','L2Monster',1100,'809.00000','380.00000','4.50000','1.80000',40,43,30,21,20,20,1635,98,'171.00000','176.00000','115.00000','107.00000',230,8,0,333,2507,0,0,43,140,1,1,1,1),
(21640,21640,'Tasaba Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman','10.00','29.00',37,'male','L2Monster',40,'847.00000','393.00000','4.50000','1.80000',40,43,30,21,20,20,1202,74,'183.00000','182.00000','123.00000','111.00000',230,1,0,333,7,0,0,43,140,1,1,1,1),
(21641,21641,'Ogre',0,'',0,'LineageMonster.ogre','21.00','44.00',38,'male','L2Monster',40,'886.00000','407.00000','4.50000','1.80000',40,43,30,21,20,20,2134,133,'197.00000','189.00000','137.00000','114.00000',230,1,150,333,98,0,0,22,174,1,1,1,1),
(21642,21642,'Tasaba Lizardman Sniper',0,'',0,'LineageMonster.virud_lizardman_scout','10.00','22.00',39,'male','L2Monster',1100,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,1958,125,'211.00000','195.00000','147.00000','118.00000',230,8,150,333,2507,0,0,43,140,1,1,1,1),
(21643,21643,'Tasaba Lizardman Sniper',0,'',0,'LineageMonster.virud_lizardman_scout','10.00','22.00',39,'male','L2Monster',1100,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,2488,158,'211.00000','195.00000','147.00000','118.00000',230,8,150,333,2507,0,0,43,140,1,1,1,1),
(21644,21644,'Lienrik',0,'',0,'LineageMonster.lienrik','12.00','50.00',39,'male','L2Monster',40,'926.00000','421.00000','4.50000','1.80000',40,43,30,21,20,20,1195,76,'211.00000','195.00000','147.00000','118.00000',230,8,0,333,0,0,0,100,150,1,1,1,1),
(21645,21645,'Lienrik Lad',0,'',0,'LineageMonster.lienrik','12.00','50.00',40,'male','L2Monster',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,2302,149,'226.00000','202.00000','157.00000','122.00000',230,8,150,333,0,0,0,100,174,1,1,1,1),
(21646,21646,'Grave Scarab',0,'',0,'LineageMonster2.scarab','14.00','22.00',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,12247,1260,'1209.00000','502.00000','830.00000','304.00000',230,4,0,333,0,0,0,45,180,1,1,1,1),
(21647,21647,'Scavenger Scarab',0,'',0,'LineageMonster2.scarab','14.00','22.00',73,'male','L2Monster',40,'2587.00000','1312.00000','8.50000','3.00000',40,43,30,21,20,20,10332,1063,'1209.00000','502.00000','830.00000','304.00000',230,4,150,333,0,0,0,45,180,1,1,1,1),
(21648,21648,'Grave Ant',0,'',0,'LineageMonster.ant_soldier','35.00','17.00',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,11260,1174,'1251.00000','513.00000','863.00000','311.00000',230,4,0,333,0,0,0,80,150,1,1,1,1),
(21649,21649,'Scavenger Ant',0,'',0,'LineageMonster.ant_soldier','35.00','17.00',74,'male','L2Monster',40,'2632.00000','1342.00000','8.50000','3.00000',40,43,30,21,20,20,13319,1388,'1251.00000','513.00000','863.00000','311.00000',230,4,150,333,0,0,0,80,150,1,1,1,1),
(21650,21650,'Shrine Knight',0,'',0,'LineageMonster.skeleton_knight','10.00','25.00',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,12179,1285,'1293.00000','524.00000','891.00000','317.00000',230,4,0,333,150,103,0,40,165,1,1,1,1),
(21651,21651,'Shrine Guard',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',75,'male','L2Monster',40,'2677.00000','1372.00000','8.50000','3.00000',40,43,30,21,20,20,11635,1228,'1293.00000','524.00000','891.00000','317.00000',230,4,0,333,98,0,0,50,170,1,1,1,1),
(21652,21652,'Scarlet Stakato Noble',0,'',0,'LineageMonster.blade_stakato_drone','15.00','39.00',78,'male','L2Monster',40,'2871.00000','1508.00000','8.58500','3.03000',40,43,30,21,20,20,46911,5199,'1464.00000','569.00000','1020.00000','344.00000',230,8,450,333,235,0,0,25,165,1,1,0,1),
(21653,21653,'Assassin Beetle',0,'',0,'LineageMonster2.tera_beetle','19.00','54.50',78,'male','L2Monster',40,'2938.00000','1554.00000','8.67000','3.06000',40,43,30,21,20,20,34021,3819,'1512.00000','581.00000','1058.00000','352.00000',230,4,150,333,0,0,0,45,165,1,1,0,1),
(21654,21654,'Necromancer of Destruction',0,'',0,'LineageMonster.vale_master_20_bi','14.50','48.00',78,'male','L2Monster',40,'2975.00000','1586.00000','8.72100','3.08040',40,43,30,21,20,20,40213,4566,'1554.00000','593.00000','1099.00000','363.00000',230,4,150,333,0,0,0,70,140,1,1,0,1),
(21655,21655,'Arimanes of Destruction',0,'',0,'LineageMonster2.ahrimanes','14.00','57.75',78,'male','L2Monster',40,'3011.00000','1617.00000','8.77200','3.10080',40,43,30,21,20,20,35744,4106,'1593.00000','603.00000','1133.00000','375.00000',230,4,150,333,6722,0,0,35,185,1,1,0,1),
(21656,21656,'Ashuras of Destruction',0,'',0,'LineageMonster2.ashuras_30_bi','17.00','49.00',78,'male','L2Monster',40,'3077.00000','1682.00000','8.87400','3.13140',40,43,30,21,20,20,62781,7385,'1672.00000','625.00000','1204.00000','397.00000',230,4,150,333,0,0,0,41,190,1,1,0,1),
(21657,21657,'Magma Drake',0,'',0,'LineageMonster2.inferno_drake_20_bi','29.00','42.00',78,'male','L2Monster',40,'3108.00000','1714.00000','8.92500','3.15180',40,43,30,21,20,20,54374,6472,'1711.00000','635.00000','1238.00000','407.00000',230,4,150,333,0,0,0,57,185,1,1,0,1),
(21658,21658,'Punishment of Splendor',0,'',0,'LineageMonster.kel_mahum_warrior','13.00','28.00',64,'male','L2Monster',40,'2142.00000','1053.00000','7.50000','2.70000',40,43,30,21,20,20,10605,971,'853.00000','409.00000','584.00000','248.00000',230,4,0,333,242,0,0,50,165,1,1,1,1),
(21659,21659,'Otherworldly Invader Soldier',0,'',0,'LineageMonster.neer_crawler','14.00','22.00',30,'male','L2RiftInvader',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,4372,239,'109.00000','141.00000','77.00000','85.00000',230,8,0,333,0,0,0,50,165,1,1,0,1),
(21660,21660,'Otherworldly Invader Soldier',0,'',0,'LineageMonster.neer_crawler','14.00','22.00',35,'male','L2RiftInvader',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,6221,368,'159.00000','170.00000','111.00000','102.00000',230,8,150,333,0,0,0,50,165,1,1,0,1),
(21661,21661,'Otherworldly Invader Archer',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',33,'male','L2RiftInvader',1100,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,4478,257,'138.00000','158.00000','96.00000','96.00000',230,8,150,333,275,0,0,40,165,1,1,0,1),
(21662,21662,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.dark_horror','20.00','35.00',35,'male','L2RiftInvader',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,5178,306,'159.00000','170.00000','111.00000','102.00000',230,4,150,333,0,0,0,100,165,1,1,0,1),
(21663,21663,'Otherworldly Invader Shaman',0,'',0,'LineageMonster.dark_horror','20.00','35.00',33,'male','L2RiftInvader',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,5654,324,'138.00000','158.00000','96.00000','96.00000',230,4,150,333,0,0,0,100,165,1,1,0,1),
(21664,21664,'Otherworldly Invader Priest',0,'',0,'LineageMonster.dark_horror','20.00','35.00',30,'male','L2RiftInvader',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,3023,165,'109.00000','141.00000','77.00000','85.00000',230,4,0,333,0,0,0,100,165,1,1,0,1),
(21665,21665,'Otherworldly Invader Magus',0,'',0,'LineageMonster.dark_horror','20.00','35.00',35,'male','L2RiftInvader',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,4089,242,'159.00000','170.00000','111.00000','102.00000',230,4,150,333,0,0,0,100,165,1,1,0,1),
(21666,21666,'Otherworldly Invader Martyrs',0,'',0,'LineageMonster.dark_horror','20.00','35.00',30,'male','L2RiftInvader',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,3054,167,'109.00000','141.00000','77.00000','85.00000',230,4,0,333,0,0,0,100,165,1,1,0,1),
(21667,21667,'Otherworldly Invader Warrior',0,'',0,'LineageMonster.skeleton','11.00','25.00',33,'male','L2RiftInvader',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,3635,209,'138.00000','158.00000','96.00000','96.00000',230,8,150,333,220,0,0,60,165,1,1,0,1),
(21668,21668,'Otherworldly Invader Soldier',0,'',0,'LineageMonster.neer_crawler','14.00','22.00',30,'male','L2RiftInvader',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,3215,176,'109.00000','141.00000','77.00000','85.00000',230,8,150,333,0,0,0,50,165,1,1,0,1),
(21669,21669,'Otherworldly Invader Discipline',0,'',0,'LineageMonster.skeleton','11.00','25.00',33,'male','L2RiftInvader',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,3828,220,'138.00000','158.00000','96.00000','96.00000',230,8,0,333,220,0,0,60,165,1,1,0,1),
(21670,21670,'Otherworldly Invader Berserker',0,'',0,'LineageMonster.skeleton','11.00','25.00',35,'male','L2RiftInvader',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,5356,317,'159.00000','170.00000','111.00000','102.00000',230,8,150,333,220,0,0,60,165,1,1,0,1),
(21671,21671,'Otherworldly Invader Food',0,'',0,'LineageMonster.mimic','8.50','8.50',30,'male','L2Chest',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,1309,72,'109.00000','141.00000','77.00000','85.00000',230,4,0,333,0,0,0,80,165,1,1,0,1),
(21672,21672,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',35,'male','L2RiftInvader',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,9595,568,'159.00000','170.00000','111.00000','102.00000',230,4,150,333,96,0,0,50,165,1,1,0,1),
(21673,21673,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',35,'male','L2RiftInvader',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,9777,579,'159.00000','170.00000','111.00000','102.00000',230,4,150,333,96,0,0,50,165,1,1,0,1),
(21674,21674,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',35,'male','L2RiftInvader',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,381,23,'159.00000','170.00000','111.00000','102.00000',230,4,0,333,96,0,0,50,165,1,1,0,1),
(21675,21675,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',30,'male','L2RiftInvader',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,778,42,'109.00000','141.00000','77.00000','85.00000',230,4,0,333,96,0,0,50,165,1,1,0,1),
(21676,21676,'Otherworldly Invader Warrior',0,'',0,'LineageMonster.skeleton','11.00','25.00',33,'male','L2RiftInvader',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,8716,500,'138.00000','158.00000','96.00000','96.00000',230,8,150,333,220,0,0,60,165,1,1,0,1),
(21677,21677,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',30,'male','L2RiftInvader',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,6988,382,'109.00000','141.00000','77.00000','85.00000',230,4,150,333,96,0,0,50,165,1,1,0,1),
(21678,21678,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',33,'male','L2RiftInvader',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,8456,485,'138.00000','158.00000','96.00000','96.00000',230,4,150,333,96,0,0,50,165,1,1,0,1),
(21679,21679,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',30,'male','L2RiftInvader',40,'604.00000','300.00000','3.50000','1.50000',40,43,30,21,20,20,6889,376,'109.00000','141.00000','77.00000','85.00000',230,4,150,333,96,0,0,50,165,1,1,0,1),
(21680,21680,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman','10.00','28.00',35,'male','L2RiftInvader',40,'773.00000','366.00000','4.50000','1.80000',40,43,30,21,20,20,9377,555,'159.00000','170.00000','111.00000','102.00000',230,4,150,333,96,0,0,50,165,1,1,0,1),
(21681,21681,'Otherworldly Invader Magus',0,'',0,'LineageMonster.dark_horror','20.00','35.00',33,'male','L2RiftInvader',40,'702.00000','339.00000','4.50000','1.80000',40,43,30,21,20,20,8062,463,'138.00000','158.00000','96.00000','96.00000',230,4,0,333,0,0,0,100,165,1,1,0,1),
(21682,21682,'Dimension Invader Soldier',0,'',0,'LineageMonster.neer_crawler','14.00','22.00',40,'male','L2RiftInvader',40,'966.00000','435.00000','4.50000','1.80000',40,43,30,21,20,20,7772,502,'226.00000','202.00000','157.00000','122.00000',230,8,0,333,0,0,0,50,165,1,1,0,1),
(21683,21683,'Dimension Invader Soldier',0,'',0,'LineageMonster.neer_crawler','14.00','22.00',45,'male','L2RiftInvader',40,'1184.00000','556.00000','5.50000','2.10000',40,43,30,21,20,20,10283,715,'313.00000','238.00000','212.00000','144.00000',230,8,150,333,0,0,0,50,165,1,1,0,1),
(21684,21684,'Dimension Invader Archer',0,'',0,'LineageMonster.skeleton_archer','11.00','27.00',43,'male','L2RiftInv