/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Properties;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyFile;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.__builtin__;

public class PythonInterpreter {
    PyModule module;
    protected PySystemState systemState;
    PyObject locals;
    protected CompilerFlags cflags = null;

    public static void initialize(Properties properties, Properties properties2, String[] stringArray) {
        PySystemState.initialize(properties, properties2, stringArray);
    }

    public PythonInterpreter() {
        this(null, null);
    }

    public PythonInterpreter(PyObject pyObject) {
        this(pyObject, null);
    }

    public PythonInterpreter(PyObject pyObject, PySystemState pySystemState) {
        if (pyObject == null) {
            pyObject = new PyStringMap();
        }
        if (pySystemState == null && (pySystemState = Py.getSystemState()) == null) {
            pySystemState = new PySystemState();
        }
        this.module = new PyModule("main", pyObject);
        this.systemState = pySystemState;
        this.locals = this.module.__dict__;
        this.setState();
    }

    protected void setState() {
        Py.setSystemState(this.systemState);
    }

    public void setOut(PyObject pyObject) {
        this.systemState.stdout = pyObject;
    }

    public void setOut(Writer writer) {
        this.setOut(new PyFile(writer));
    }

    public void setOut(OutputStream outputStream) {
        this.setOut(new PyFile(outputStream));
    }

    public void setErr(PyObject pyObject) {
        this.systemState.stderr = pyObject;
    }

    public void setErr(Writer writer) {
        this.setErr(new PyFile(writer));
    }

    public void setErr(OutputStream outputStream) {
        this.setErr(new PyFile(outputStream));
    }

    public PyObject eval(String string) {
        this.setState();
        return __builtin__.eval(new PyString(string), this.locals);
    }

    public void exec(String string) {
        this.setState();
        Py.exec(Py.compile_flags(string, "<string>", "exec", this.cflags), this.locals, this.locals);
    }

    public void exec(PyObject pyObject) {
        this.setState();
        Py.exec(pyObject, this.locals, this.locals);
    }

    public void execfile(String string) {
        this.setState();
        __builtin__.execfile_flags(string, this.locals, this.locals, this.cflags);
    }

    public void execfile(InputStream inputStream) {
        this.execfile(inputStream, "<iostream>");
    }

    public void execfile(InputStream inputStream, String string) {
        this.setState();
        Py.runCode(Py.compile_flags(inputStream, string, "exec", this.cflags), this.locals, this.locals);
    }

    public PyObject getLocals() {
        return this.locals;
    }

    public void setLocals(PyObject pyObject) {
        this.locals = pyObject;
    }

    public void set(String string, Object object) {
        this.locals.__setitem__(string.intern(), Py.java2py(object));
    }

    public void set(String string, PyObject pyObject) {
        this.locals.__setitem__(string.intern(), pyObject);
    }

    public PyObject get(String string) {
        return this.locals.__finditem__(string.intern());
    }

    public Object get(String string, Class clazz) {
        return Py.tojava(this.locals.__finditem__(string.intern()), clazz);
    }

    public void cleanup() {
        this.systemState.callExitFunc();
    }
}

