/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.loginserver;

import com.l2jserver.Config;
import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.L2LoginServer;
import com.l2jserver.loginserver.LoginController;
import com.l2jserver.loginserver.SessionKey;
import com.l2jserver.loginserver.gameserverpackets.BlowFishKey;
import com.l2jserver.loginserver.gameserverpackets.ChangeAccessLevel;
import com.l2jserver.loginserver.gameserverpackets.GameServerAuth;
import com.l2jserver.loginserver.gameserverpackets.PlayerAuthRequest;
import com.l2jserver.loginserver.gameserverpackets.PlayerInGame;
import com.l2jserver.loginserver.gameserverpackets.PlayerLogout;
import com.l2jserver.loginserver.gameserverpackets.PlayerTracert;
import com.l2jserver.loginserver.gameserverpackets.ServerStatus;
import com.l2jserver.loginserver.loginserverpackets.AuthResponse;
import com.l2jserver.loginserver.loginserverpackets.InitLS;
import com.l2jserver.loginserver.loginserverpackets.KickPlayer;
import com.l2jserver.loginserver.loginserverpackets.LoginServerFail;
import com.l2jserver.loginserver.loginserverpackets.PlayerAuthResponse;
import com.l2jserver.util.Util;
import com.l2jserver.util.crypt.NewCrypt;
import com.l2jserver.util.network.BaseSendablePacket;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.KeyPair;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javolution.util.FastSet;

public class GameServerThread
extends Thread {
    protected static final Logger _log = Logger.getLogger(GameServerThread.class.getName());
    private Socket _connection;
    private InputStream _in;
    private OutputStream _out;
    private RSAPublicKey _publicKey;
    private RSAPrivateKey _privateKey;
    private NewCrypt _blowfish;
    private byte[] _blowfishKey;
    private String _connectionIp;
    private GameServerTable.GameServerInfo _gsi;
    private Set<String> _accountsOnGameServer = new FastSet();
    private String _connectionIPAddress;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this._connectionIPAddress = this._connection.getInetAddress().getHostAddress();
        if (GameServerThread.isBannedGameserverIP(this._connectionIPAddress)) {
            _log.info("GameServerRegistration: IP Address " + this._connectionIPAddress + " is on Banned IP list.");
            this.forceClose(1);
            return;
        }
        InitLS startPacket = new InitLS(this._publicKey.getModulus().toByteArray());
        try {
            this.sendPacket(startPacket);
            int lengthHi = 0;
            int lengthLo = 0;
            int length = 0;
            boolean checksumOk = false;
            block16: while (true) {
                lengthLo = this._in.read();
                lengthHi = this._in.read();
                length = lengthHi * 256 + lengthLo;
                if (lengthHi < 0 || this._connection.isClosed()) {
                    _log.finer("LoginServerThread: Login terminated the connection.");
                    break;
                }
                byte[] data = new byte[length - 2];
                int receivedBytes = 0;
                int newBytes = 0;
                int left = length - 2;
                while (newBytes != -1 && receivedBytes < length - 2) {
                    newBytes = this._in.read(data, receivedBytes, left);
                    receivedBytes += newBytes;
                    left -= newBytes;
                }
                if (receivedBytes != length - 2) {
                    _log.warning("Incomplete Packet is sent to the server, closing connection.(LS)");
                    break;
                }
                this._blowfish.decryptMe(data);
                checksumOk = NewCrypt.verifyChecksum(data);
                if (!checksumOk) {
                    _log.warning("Incorrect packet checksum, closing connection (LS)");
                    return;
                }
                if (Config.DEBUG) {
                    _log.warning("[C]\n" + Util.printData(data));
                }
                int packetType = data[0] & 0xFF;
                switch (packetType) {
                    case 0: {
                        this.onReceiveBlowfishKey(data);
                        continue block16;
                    }
                    case 1: {
                        this.onGameServerAuth(data);
                        continue block16;
                    }
                    case 2: {
                        this.onReceivePlayerInGame(data);
                        continue block16;
                    }
                    case 3: {
                        this.onReceivePlayerLogOut(data);
                        continue block16;
                    }
                    case 4: {
                        this.onReceiveChangeAccessLevel(data);
                        continue block16;
                    }
                    case 5: {
                        this.onReceivePlayerAuthRequest(data);
                        continue block16;
                    }
                    case 6: {
                        this.onReceiveServerStatus(data);
                        continue block16;
                    }
                    case 7: {
                        this.onReceivePlayerTracert(data);
                        continue block16;
                    }
                }
                _log.warning("Unknown Opcode (" + Integer.toHexString(packetType).toUpperCase() + ") from GameServer, closing connection.");
                this.forceClose(6);
            }
        }
        catch (IOException e) {
            String serverName = this.getServerId() != -1 ? "[" + this.getServerId() + "] " + GameServerTable.getInstance().getServerNameById(this.getServerId()) : "(" + this._connectionIPAddress + ")";
            String msg = "GameServer " + serverName + ": Connection lost: " + e.getMessage();
            _log.info(msg);
            this.broadcastToTelnet(msg);
        }
        finally {
            if (this.isAuthed()) {
                this._gsi.setDown();
                _log.info("Server [" + this.getServerId() + "] " + GameServerTable.getInstance().getServerNameById(this.getServerId()) + " is now set as disconnected");
            }
            L2LoginServer.getInstance().getGameServerListener().removeGameServer(this);
            L2LoginServer.getInstance().getGameServerListener().removeFloodProtection(this._connectionIp);
        }
    }

    private void onReceiveBlowfishKey(byte[] data) {
        BlowFishKey bfk = new BlowFishKey(data, this._privateKey);
        this._blowfishKey = bfk.getKey();
        this._blowfish = new NewCrypt(this._blowfishKey);
        if (Config.DEBUG) {
            _log.info("New BlowFish key received, Blowfih Engine initialized:");
        }
    }

    private void onGameServerAuth(byte[] data) throws IOException {
        GameServerAuth gsa = new GameServerAuth(data);
        if (Config.DEBUG) {
            _log.info("Auth request received");
        }
        this.handleRegProcess(gsa);
        if (this.isAuthed()) {
            AuthResponse ar = new AuthResponse(this.getGameServerInfo().getId());
            this.sendPacket(ar);
            if (Config.DEBUG) {
                _log.info("Authed: id: " + this.getGameServerInfo().getId());
            }
            this.broadcastToTelnet("GameServer [" + this.getServerId() + "] " + GameServerTable.getInstance().getServerNameById(this.getServerId()) + " is connected");
        }
    }

    private void onReceivePlayerInGame(byte[] data) {
        if (this.isAuthed()) {
            PlayerInGame pig = new PlayerInGame(data);
            List<String> newAccounts = pig.getAccounts();
            for (String account : newAccounts) {
                this._accountsOnGameServer.add(account);
                if (Config.DEBUG) {
                    _log.info("Account " + account + " logged in GameServer: [" + this.getServerId() + "] " + GameServerTable.getInstance().getServerNameById(this.getServerId()));
                }
                this.broadcastToTelnet("Account " + account + " logged in GameServer " + this.getServerId());
            }
        } else {
            this.forceClose(6);
        }
    }

    private void onReceivePlayerLogOut(byte[] data) {
        if (this.isAuthed()) {
            PlayerLogout plo = new PlayerLogout(data);
            this._accountsOnGameServer.remove(plo.getAccount());
            if (Config.DEBUG) {
                _log.info("Player " + plo.getAccount() + " logged out from gameserver [" + this.getServerId() + "] " + GameServerTable.getInstance().getServerNameById(this.getServerId()));
            }
            this.broadcastToTelnet("Player " + plo.getAccount() + " disconnected from GameServer " + this.getServerId());
        } else {
            this.forceClose(6);
        }
    }

    private void onReceiveChangeAccessLevel(byte[] data) {
        if (this.isAuthed()) {
            ChangeAccessLevel cal = new ChangeAccessLevel(data);
            LoginController.getInstance().setAccountAccessLevel(cal.getAccount(), cal.getLevel());
            _log.info("Changed " + cal.getAccount() + " access level to " + cal.getLevel());
        } else {
            this.forceClose(6);
        }
    }

    private void onReceivePlayerAuthRequest(byte[] data) throws IOException {
        if (this.isAuthed()) {
            PlayerAuthResponse authResponse;
            SessionKey key;
            PlayerAuthRequest par = new PlayerAuthRequest(data);
            if (Config.DEBUG) {
                _log.info("auth request received for Player " + par.getAccount());
            }
            if ((key = LoginController.getInstance().getKeyForAccount(par.getAccount())) != null && key.equals(par.getKey())) {
                if (Config.DEBUG) {
                    _log.info("auth request: OK");
                }
                LoginController.getInstance().removeAuthedLoginClient(par.getAccount());
                authResponse = new PlayerAuthResponse(par.getAccount(), true);
            } else {
                if (Config.DEBUG) {
                    _log.info("auth request: NO");
                    _log.info("session key from self: " + key);
                    _log.info("session key sent: " + par.getKey());
                }
                authResponse = new PlayerAuthResponse(par.getAccount(), false);
            }
            this.sendPacket(authResponse);
        } else {
            this.forceClose(6);
        }
    }

    private void onReceiveServerStatus(byte[] data) {
        if (this.isAuthed()) {
            if (Config.DEBUG) {
                _log.info("ServerStatus received");
            }
            new ServerStatus(data, this.getServerId());
        } else {
            this.forceClose(6);
        }
    }

    private void onReceivePlayerTracert(byte[] data) {
        if (this.isAuthed()) {
            PlayerTracert plt = new PlayerTracert(data);
            LoginController.getInstance().setAccountLastTracert(plt.getAccount(), plt.getPcIp(), plt.getFirstHop(), plt.getSecondHop(), plt.getThirdHop(), plt.getFourthHop());
            if (Config.DEBUG) {
                _log.info("Saved " + plt.getAccount() + " last tracert");
            }
        } else {
            this.forceClose(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegProcess(GameServerAuth gameServerAuth) {
        GameServerTable gameServerTable = GameServerTable.getInstance();
        int id = gameServerAuth.getDesiredID();
        byte[] hexId = gameServerAuth.getHexID();
        GameServerTable.GameServerInfo gsi = gameServerTable.getRegisteredGameServerById(id);
        if (gsi != null) {
            if (Arrays.equals(gsi.getHexId(), hexId)) {
                GameServerTable.GameServerInfo gameServerInfo = gsi;
                synchronized (gameServerInfo) {
                    if (gsi.isAuthed()) {
                        this.forceClose(7);
                    } else {
                        this.attachGameServerInfo(gsi, gameServerAuth);
                    }
                }
            } else if (Config.ACCEPT_NEW_GAMESERVER && gameServerAuth.acceptAlternateID()) {
                gsi = new GameServerTable.GameServerInfo(id, hexId, this);
                if (gameServerTable.registerWithFirstAvaliableId(gsi)) {
                    this.attachGameServerInfo(gsi, gameServerAuth);
                    gameServerTable.registerServerOnDB(gsi);
                } else {
                    this.forceClose(5);
                }
            } else {
                this.forceClose(3);
            }
        } else if (Config.ACCEPT_NEW_GAMESERVER) {
            gsi = new GameServerTable.GameServerInfo(id, hexId, this);
            if (gameServerTable.register(id, gsi)) {
                this.attachGameServerInfo(gsi, gameServerAuth);
                gameServerTable.registerServerOnDB(gsi);
            } else {
                this.forceClose(4);
            }
        } else {
            this.forceClose(3);
        }
    }

    public boolean hasAccountOnGameServer(String account) {
        return this._accountsOnGameServer.contains(account);
    }

    public int getPlayerCount() {
        return this._accountsOnGameServer.size();
    }

    private void attachGameServerInfo(GameServerTable.GameServerInfo gsi, GameServerAuth gameServerAuth) {
        this.setGameServerInfo(gsi);
        gsi.setGameServerThread(this);
        gsi.setPort(gameServerAuth.getPort());
        this.setGameHosts(gameServerAuth.getHosts());
        gsi.setMaxPlayers(gameServerAuth.getMaxPlayers());
        gsi.setAuthed(true);
    }

    private void forceClose(int reason) {
        LoginServerFail lsf = new LoginServerFail(reason);
        try {
            this.sendPacket(lsf);
        }
        catch (IOException e) {
            _log.finer("GameServerThread: Failed kicking banned server. Reason: " + e.getMessage());
        }
        try {
            this._connection.close();
        }
        catch (IOException e) {
            _log.finer("GameServerThread: Failed disconnecting banned server, server already disconnected.");
        }
    }

    public static boolean isBannedGameserverIP(String ipAddress) {
        return false;
    }

    public GameServerThread(Socket con) {
        this._connection = con;
        this._connectionIp = con.getInetAddress().getHostAddress();
        try {
            this._in = this._connection.getInputStream();
            this._out = new BufferedOutputStream(this._connection.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        KeyPair pair = GameServerTable.getInstance().getKeyPair();
        this._privateKey = (RSAPrivateKey)pair.getPrivate();
        this._publicKey = (RSAPublicKey)pair.getPublic();
        this._blowfish = new NewCrypt("_;v.]05-31!|+-%xT!^[$\u0000");
        this.setName(this.getClass().getSimpleName() + "-" + this.getId() + "@" + this._connectionIp);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPacket(BaseSendablePacket sl) throws IOException {
        byte[] data = sl.getContent();
        NewCrypt.appendChecksum(data);
        if (Config.DEBUG) {
            _log.finest("[S] " + sl.getClass().getSimpleName() + ":\n" + Util.printData(data));
        }
        this._blowfish.cryptMe(data);
        int len = data.length + 2;
        OutputStream outputStream = this._out;
        synchronized (outputStream) {
            this._out.write(len & 0xFF);
            this._out.write(len >> 8 & 0xFF);
            this._out.write(data);
            this._out.flush();
        }
    }

    private void broadcastToTelnet(String msg) {
        if (L2LoginServer.getInstance().getStatusServer() != null) {
            L2LoginServer.getInstance().getStatusServer().sendMessageToTelnets(msg);
        }
    }

    public void kickPlayer(String account) {
        KickPlayer kp = new KickPlayer(account);
        try {
            this.sendPacket(kp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setGameHosts(String[] hosts) {
        _log.info("Updated Gameserver [" + this.getServerId() + "] " + GameServerTable.getInstance().getServerNameById(this.getServerId()) + " IP's:");
        this._gsi.clearServerAddresses();
        for (int i = 0; i < hosts.length; i += 2) {
            try {
                this._gsi.addServerAddress(hosts[i], hosts[i + 1]);
                continue;
            }
            catch (Exception e) {
                _log.warning("Couldn't resolve hostname \"" + e + "\"");
            }
        }
        for (String s : this._gsi.getServerAddresses()) {
            _log.info(s);
        }
    }

    public boolean isAuthed() {
        if (this.getGameServerInfo() == null) {
            return false;
        }
        return this.getGameServerInfo().isAuthed();
    }

    public void setGameServerInfo(GameServerTable.GameServerInfo gsi) {
        this._gsi = gsi;
    }

    public GameServerTable.GameServerInfo getGameServerInfo() {
        return this._gsi;
    }

    public String getConnectionIpAddress() {
        return this._connectionIPAddress;
    }

    private int getServerId() {
        if (this.getGameServerInfo() != null) {
            return this.getGameServerInfo().getId();
        }
        return -1;
    }
}

