/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.multisell.Entry;
import com.l2jserver.gameserver.model.multisell.Ingredient;
import com.l2jserver.gameserver.model.multisell.ListContainer;
import com.l2jserver.gameserver.model.multisell.PreparedListContainer;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.MultiSellList;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javolution.util.FastList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MultiSell {
    public static final int PAGE_SIZE = 40;
    public static final int PC_BANG_POINTS = -100;
    public static final int CLAN_REPUTATION = -200;
    public static final int FAME = -300;
    private static final Logger _log = Logger.getLogger(MultiSell.class.getName());
    private final TIntObjectHashMap<ListContainer> _entries = new TIntObjectHashMap();

    public static MultiSell getInstance() {
        return SingletonHolder._instance;
    }

    private MultiSell() {
        this.load();
    }

    public final void reload() {
        this._entries.clear();
        this.load();
    }

    public final void separateAndSend(int listId, L2PcInstance player, L2Npc npc, boolean inventoryOnly) {
        ListContainer template = (ListContainer)this._entries.get(listId);
        if (template == null) {
            _log.warning("[MultiSell] can't find list id: " + listId + " requested by player: " + player.getName() + ", npcId:" + (npc != null ? npc.getNpcId() : 0));
            return;
        }
        PreparedListContainer list = new PreparedListContainer(template, inventoryOnly, player, npc);
        int index = 0;
        do {
            player.sendPacket(new MultiSellList(list, index));
        } while ((index += 40) < list.getEntries().size());
        player.setMultiSell(list);
    }

    public static final boolean checkSpecialIngredient(int id, long amount, L2PcInstance player) {
        switch (id) {
            case -200: {
                if (player.getClan() == null) {
                    player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_ARE_NOT_A_CLAN_MEMBER));
                    break;
                }
                if (!player.isClanLeader()) {
                    player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ONLY_THE_CLAN_LEADER_IS_ENABLED));
                    break;
                }
                if ((long)player.getClan().getReputationScore() < amount) {
                    player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.THE_CLAN_REPUTATION_SCORE_IS_TOO_LOW));
                    break;
                }
                return true;
            }
            case -300: {
                if ((long)player.getFame() < amount) {
                    player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NOT_ENOUGH_FAME_POINTS));
                    break;
                }
                return true;
            }
        }
        return false;
    }

    public static final boolean getSpecialIngredient(int id, long amount, L2PcInstance player) {
        switch (id) {
            case -200: {
                player.getClan().takeReputationScore((int)amount, true);
                SystemMessage smsg = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                smsg.addItemNumber(amount);
                player.sendPacket(smsg);
                return true;
            }
            case -300: {
                player.setFame(player.getFame() - (int)amount);
                player.sendPacket(new UserInfo(player));
                player.sendPacket(new ExBrExtraUserInfo(player));
                return true;
            }
        }
        return false;
    }

    public static final void addSpecialProduct(int id, long amount, L2PcInstance player) {
        switch (id) {
            case -200: {
                player.getClan().addReputationScore((int)amount, true);
                break;
            }
            case -300: {
                player.setFame((int)((long)player.getFame() + amount));
                player.sendPacket(new UserInfo(player));
                player.sendPacket(new ExBrExtraUserInfo(player));
            }
        }
    }

    private final void load() {
        Document doc = null;
        int id = 0;
        FastList files = new FastList();
        this.hashFiles("multisell", (List<File>)files);
        for (File f : files) {
            try {
                id = Integer.parseInt(f.getName().replace(".xml", ""));
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setIgnoringComments(true);
                doc = factory.newDocumentBuilder().parse(f);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error loading file " + f, e);
                continue;
            }
            try {
                ListContainer list = this.parseDocument(doc);
                list.setListId(id);
                this._entries.put(id, (Object)list);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Error in file " + f, e);
            }
        }
        this.verify();
        _log.log(Level.INFO, "MultiSell: Loaded " + this._entries.size() + " lists.");
    }

    private final ListContainer parseDocument(Document doc) {
        int entryId = 1;
        ListContainer list = new ListContainer();
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if ("list".equalsIgnoreCase(n.getNodeName())) {
                Node attribute = n.getAttributes().getNamedItem("applyTaxes");
                if (attribute == null) {
                    list.setApplyTaxes(false);
                } else {
                    list.setApplyTaxes(Boolean.parseBoolean(attribute.getNodeValue()));
                }
                attribute = n.getAttributes().getNamedItem("maintainEnchantment");
                if (attribute == null) {
                    list.setMaintainEnchantment(false);
                } else {
                    list.setMaintainEnchantment(Boolean.parseBoolean(attribute.getNodeValue()));
                }
                for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    if (!"item".equalsIgnoreCase(d.getNodeName())) continue;
                    Entry e = this.parseEntry(d, entryId++);
                    list.getEntries().add(e);
                }
                continue;
            }
            if (!"item".equalsIgnoreCase(n.getNodeName())) continue;
            Entry e = this.parseEntry(n, entryId++);
            list.getEntries().add(e);
        }
        return list;
    }

    private final Entry parseEntry(Node n, int entryId) {
        Node first = n.getFirstChild();
        Entry entry = new Entry(entryId);
        for (n = first; n != null; n = n.getNextSibling()) {
            long count;
            int id;
            if ("ingredient".equalsIgnoreCase(n.getNodeName())) {
                id = Integer.parseInt(n.getAttributes().getNamedItem("id").getNodeValue());
                count = Long.parseLong(n.getAttributes().getNamedItem("count").getNodeValue());
                Node attribute = n.getAttributes().getNamedItem("isTaxIngredient");
                boolean isTaxIngredient = attribute != null ? Boolean.parseBoolean(attribute.getNodeValue()) : false;
                attribute = n.getAttributes().getNamedItem("maintainIngredient");
                boolean mantainIngredient = attribute != null ? Boolean.parseBoolean(attribute.getNodeValue()) : false;
                entry.addIngredient(new Ingredient(id, count, isTaxIngredient, mantainIngredient));
                continue;
            }
            if (!"production".equalsIgnoreCase(n.getNodeName())) continue;
            id = Integer.parseInt(n.getAttributes().getNamedItem("id").getNodeValue());
            count = Long.parseLong(n.getAttributes().getNamedItem("count").getNodeValue());
            entry.addProduct(new Ingredient(id, count, false, false));
        }
        return entry;
    }

    private final void hashFiles(String dirname, List<File> hash) {
        File[] files;
        File dir = new File(Config.DATAPACK_ROOT, "data/" + dirname);
        if (!dir.exists()) {
            _log.log(Level.WARNING, "Dir " + dir.getAbsolutePath() + " not exists");
            return;
        }
        for (File f : files = dir.listFiles()) {
            if (!f.getName().endsWith(".xml")) continue;
            hash.add(f);
        }
    }

    private final void verify() {
        TIntObjectIterator iter = this._entries.iterator();
        while (iter.hasNext()) {
            iter.advance();
            ListContainer list = (ListContainer)iter.value();
            for (Entry ent : list.getEntries()) {
                for (Ingredient ing : ent.getIngredients()) {
                    if (this.verifyIngredient(ing)) continue;
                    _log.warning("[MultiSell] can't find ingredient with itemId: " + ing.getItemId() + " in list: " + list.getListId());
                }
                for (Ingredient ing : ent.getProducts()) {
                    if (this.verifyIngredient(ing)) continue;
                    _log.warning("[MultiSell] can't find product with itemId: " + ing.getItemId() + " in list: " + list.getListId());
                }
            }
        }
    }

    private final boolean verifyIngredient(Ingredient ing) {
        switch (ing.getItemId()) {
            case -300: 
            case -200: {
                return true;
            }
        }
        return ing.getTemplate() != null;
    }

    private static class SingletonHolder {
        protected static final MultiSell _instance = new MultiSell();

        private SingletonHolder() {
        }
    }
}

