/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;

public class L2PenaltyMonsterInstance
extends L2MonsterInstance {
    private L2PcInstance _ptk;
    private final int[] _randomNpcStrings;
    private static final int[] S18319 = new int[]{1010400, 1010401, 1010402, 1010403, 1010404, 1010405, 1010406, 1010407, 1010408};
    private static final int[] S18320 = new int[]{1010409, 1010410, 1010411, 1010412, 1010413, 1010414, 1010415, 1010416, 1010417};
    private static final int[] S18321 = new int[]{1010418, 1010419, 1010420, 1010421, 1010422, 1010423, 1010424, 1010425, 1010426};
    private static final int[] S18322 = new int[]{1010427, 1010428, 1010429, 1010430, 1010431, 1010432, 1010433, 1010434, 1010435};
    private static final int[] S18323 = new int[]{1010436, 1010437, 1010438, 1010439, 1010440, 1010441, 1010442, 1010443, 1010444};
    private static final int[] S18324 = new int[]{1010445, 1010446, 1010447, 1010448, 1010449, 1010450, 1010451, 1010452, 1010453};
    private static final int[] S18325 = new int[]{1010454, 1010455, 1010456, 1010457, 1010458, 1010459, 1010460, 1010461, 1010462};
    private static final int[] S18326 = new int[]{1010463, 1010464, 1010465, 1010466, 1010467, 1010468, 1010469, 1010470, 1010471};

    public L2PenaltyMonsterInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2PenaltyMonsterInstance);
        switch (this.getNpcId()) {
            case 18319: {
                this._randomNpcStrings = S18319;
                break;
            }
            case 18320: {
                this._randomNpcStrings = S18320;
                break;
            }
            case 18321: {
                this._randomNpcStrings = S18321;
                break;
            }
            case 18322: {
                this._randomNpcStrings = S18322;
                break;
            }
            case 18323: {
                this._randomNpcStrings = S18323;
                break;
            }
            case 18324: {
                this._randomNpcStrings = S18324;
                break;
            }
            case 18325: {
                this._randomNpcStrings = S18325;
                break;
            }
            default: {
                this._randomNpcStrings = S18326;
            }
        }
        ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

            @Override
            public void run() {
                if (L2PenaltyMonsterInstance.this.isVisible() && !L2PenaltyMonsterInstance.this.isDead()) {
                    L2PenaltyMonsterInstance.this.broadcastPacket(new NpcSay(L2PenaltyMonsterInstance.this.getObjectId(), 0, L2PenaltyMonsterInstance.this.getNpcId(), L2PenaltyMonsterInstance.this._randomNpcStrings[Rnd.get(3, 5)]));
                    ThreadPoolManager.getInstance().scheduleGeneral(this, Rnd.get(5555, 9999));
                }
            }
        }, Rnd.get(5555, 9999));
    }

    @Override
    public L2Character getMostHated() {
        if (this._ptk != null) {
            return this._ptk;
        }
        return super.getMostHated();
    }

    public void setPlayerToKill(L2PcInstance ptk) {
        this.broadcastPacket(new NpcSay(this.getObjectId(), 0, this.getNpcId(), this._randomNpcStrings[Rnd.get(0, 2)]).addPcName(ptk));
        this._ptk = ptk;
        this.addDamageHate(ptk, 0, 10);
        this.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, ptk);
        this.addAttackerToAttackByList(ptk);
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        this.broadcastPacket(new NpcSay(this.getObjectId(), 0, this.getNpcId(), this._randomNpcStrings[Rnd.get(6, 8)]));
        return true;
    }
}

