/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreeTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2TransformSkillLearn;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillList;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2TransformManagerInstance
extends L2MerchantInstance {
    public L2TransformManagerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2TransformManagerInstance);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/default/", npcId, val);
    }

    public static void showTransformSkillList(L2PcInstance player) {
        L2TransformSkillLearn[] skills = SkillTreeTable.getInstance().getAvailableTransformSkills(player);
        AcquireSkillList asl = new AcquireSkillList(AcquireSkillList.SkillType.Usual);
        int counts = 0;
        for (L2TransformSkillLearn s : skills) {
            L2Skill sk = SkillTable.getInstance().getInfo(s.getId(), s.getLevel());
            if (sk == null) continue;
            ++counts;
            asl.addSkill(s.getId(), s.getLevel(), s.getLevel(), s.getSpCost(), 0);
        }
        if (counts == 0) {
            int minlevel = SkillTreeTable.getInstance().getMinLevelForNewTransformSkill(player);
            if (minlevel > 0) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DO_NOT_HAVE_FURTHER_SKILLS_TO_LEARN_S1);
                sm.addNumber(minlevel);
                player.sendPacket(sm);
            } else {
                player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NO_MORE_SKILLS_TO_LEARN));
            }
        } else {
            player.sendPacket(asl);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }
}

