/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillSpellbookTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreeTable;
import com.l2jserver.gameserver.datatables.SubPledgeSkillTree;
import com.l2jserver.gameserver.model.L2PledgeSkillLearn;
import com.l2jserver.gameserver.model.L2ShortCut;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.L2SquadTrainer;
import com.l2jserver.gameserver.model.L2TransformSkillLearn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2FishermanInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TransformManagerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2VillageMasterInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.AcquireSkillDone;
import com.l2jserver.gameserver.network.serverpackets.ExStorageMaxCount;
import com.l2jserver.gameserver.network.serverpackets.PledgeSkillList;
import com.l2jserver.gameserver.network.serverpackets.ShortCutRegister;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.util.logging.Logger;

public class RequestAcquireSkill
extends L2GameClientPacket {
    private static final String _C__6C_REQUESTAQUIRESKILL = "[C] 7C RequestAcquireSkill";
    private static Logger _log = Logger.getLogger(RequestAcquireSkill.class.getName());
    private int _id;
    private int _level;
    private int _skillType;
    private int subType;

    @Override
    protected void readImpl() {
        this._id = this.readD();
        this._level = this.readD();
        this._skillType = this.readD();
        if (this._skillType == 3) {
            this.subType = this.readD();
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (this._level < 1 || this._level > 1000 || this._id < 1 || this._id > 32000) {
            Util.handleIllegalPlayerAction(player, "Wrong Packet Data in Aquired Skill", Config.DEFAULT_PUNISH);
            _log.warning("Recived Wrong Packet Data in Aquired Skill - id: " + this._id + " level: " + this._level + " for " + player);
            return;
        }
        L2Npc trainer = player.getLastFolkNPC();
        if (!(trainer instanceof L2NpcInstance)) {
            return;
        }
        if (!trainer.canInteract(player) && !player.isGM()) {
            return;
        }
        if (!Config.ALT_GAME_SKILL_LEARN) {
            player.setSkillLearningClassId(player.getClassId());
        }
        if (Math.max(player.getSkillLevel(this._id), 0) + 1 != this._level && this._skillType != 3 && this._skillType != 4) {
            return;
        }
        L2Skill skill = SkillTable.getInstance().getInfo(this._id, this._level);
        int counts = 0;
        int requiredSp = 10000000;
        switch (this._skillType) {
            case 0: {
                L2SkillLearn[] skills;
                if (trainer instanceof L2TransformManagerInstance) {
                    L2TransformSkillLearn[] skillst;
                    int costId = 0;
                    for (L2TransformSkillLearn s : skillst = SkillTreeTable.getInstance().getAvailableTransformSkills(player)) {
                        L2Skill sk = SkillTable.getInstance().getInfo(s.getId(), s.getLevel());
                        if (sk == null || sk != skill) continue;
                        ++counts;
                        costId = s.getItemId();
                        requiredSp = s.getSpCost();
                    }
                    if (counts == 0) {
                        player.sendMessage("You are trying to learn skill that u can't..");
                        Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to learn skill that he can't!!!", Config.DEFAULT_PUNISH);
                        return;
                    }
                    if (player.getSp() >= requiredSp) {
                        if (!player.destroyItemByItemId("Consume", costId, 1L, trainer, false)) {
                            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ITEM_MISSING_TO_LEARN_SKILL));
                            this.showSkillList(trainer, player);
                            return;
                        }
                        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                        sm.addItemName(costId);
                        player.sendPacket(sm);
                        break;
                    }
                    player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NOT_ENOUGH_SP_TO_LEARN_SKILL));
                    this.showSkillList(trainer, player);
                    return;
                }
                for (L2SkillLearn s : skills = SkillTreeTable.getInstance().getAvailableSkills(player, player.getSkillLearningClassId())) {
                    L2Skill sk;
                    if (!s.isLearnedByNPC() || (sk = SkillTable.getInstance().getInfo(s.getId(), s.getLevel())) == null || sk != skill) continue;
                    ++counts;
                    requiredSp = SkillTreeTable.getInstance().getSkillCost(player, skill);
                }
                if (counts == 0 && !Config.ALT_GAME_SKILL_LEARN) {
                    player.sendMessage("You are trying to learn skill that u can't..");
                    Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to learn skill that he can't!!!", Config.DEFAULT_PUNISH);
                    return;
                }
                if (player.getSp() >= requiredSp) {
                    int spbId = -1;
                    if (Config.DIVINE_SP_BOOK_NEEDED && skill.getId() == 1405) {
                        spbId = SkillSpellbookTable.getInstance().getBookForSkill(skill, this._level);
                    } else if (Config.SP_BOOK_NEEDED && skill.getLevel() == 1) {
                        spbId = SkillSpellbookTable.getInstance().getBookForSkill(skill);
                    }
                    if (spbId <= -1) break;
                    if (!player.destroyItemByItemId("Consume", spbId, 1L, trainer, false)) {
                        player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ITEM_MISSING_TO_LEARN_SKILL));
                        this.showSkillList(trainer, player);
                        return;
                    }
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                    sm.addItemName(spbId);
                    player.sendPacket(sm);
                    break;
                }
                player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NOT_ENOUGH_SP_TO_LEARN_SKILL));
                this.showSkillList(trainer, player);
                return;
            }
            case 1: {
                L2SkillLearn[] skillsc;
                int costId = 0;
                int costCount = 0;
                for (L2SkillLearn s : skillsc = SkillTreeTable.getInstance().getAvailableSkills(player)) {
                    L2Skill sk;
                    if (!s.isLearnedByNPC() || (sk = SkillTable.getInstance().getInfo(s.getId(), s.getLevel())) == null || sk != skill) continue;
                    ++counts;
                    costId = s.getIdCost();
                    costCount = s.getCostCount();
                    requiredSp = s.getSpCost();
                }
                if (counts == 0) {
                    Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to learn skill that he can't!!!", Config.DEFAULT_PUNISH);
                    return;
                }
                if (player.getSp() >= requiredSp) {
                    if (!player.destroyItemByItemId("Consume", costId, costCount, trainer, false)) {
                        player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ITEM_MISSING_TO_LEARN_SKILL));
                        this.showSkillList(trainer, player);
                        return;
                    }
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                    sm.addItemName(costId);
                    sm.addItemNumber(costCount);
                    player.sendPacket(sm);
                    break;
                }
                player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NOT_ENOUGH_SP_TO_LEARN_SKILL));
                this.showSkillList(trainer, player);
                return;
            }
            case 2: {
                L2PledgeSkillLearn[] skills;
                int itemId = 0;
                int itemCount = 0;
                int repCost = 100000000;
                for (L2PledgeSkillLearn s : skills = SkillTreeTable.getInstance().getAvailablePledgeSkills(player)) {
                    L2Skill sk = SkillTable.getInstance().getInfo(s.getId(), s.getLevel());
                    if (sk == null || sk != skill) continue;
                    ++counts;
                    itemId = s.getItemId();
                    itemCount = s.getItemCount();
                    repCost = s.getRepCost();
                    break;
                }
                if (counts == 0) {
                    Util.handleIllegalPlayerAction(player, "Player " + player + " tried to learn clan skill that he can't!!!", Config.DEFAULT_PUNISH);
                    return;
                }
                if (player.getClan().getReputationScore() >= repCost) {
                    if (Config.LIFE_CRYSTAL_NEEDED) {
                        if (!player.destroyItemByItemId("Consume", itemId, itemCount, trainer, false)) {
                            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ITEM_MISSING_TO_LEARN_SKILL));
                            L2VillageMasterInstance.showPledgeSkillList(player);
                            return;
                        }
                        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                        sm.addItemName(itemId);
                        sm.addItemNumber(itemCount);
                        player.sendPacket(sm);
                    }
                } else {
                    player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ACQUIRE_SKILL_FAILED_BAD_CLAN_REP_SCORE));
                    L2VillageMasterInstance.showPledgeSkillList(player);
                    return;
                }
                player.getClan().takeReputationScore(repCost, true);
                player.getClan().addNewSkill(skill);
                if (Config.DEBUG) {
                    _log.fine("Learned pledge skill " + this._id + " for " + requiredSp + " SP.");
                }
                SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                cr.addNumber(repCost);
                player.sendPacket(cr);
                player.sendPacket(new AcquireSkillDone());
                player.getClan().broadcastToOnlineMembers(new PledgeSkillList(player.getClan()));
                L2VillageMasterInstance.showPledgeSkillList(player);
                return;
            }
            case 3: {
                if (!player.isClanLeader()) {
                    return;
                }
                if (player.getClan().getHasFort() == 0 && player.getClan().getHasCastle() == 0) {
                    return;
                }
                if (!(trainer instanceof L2SquadTrainer)) break;
                int id = 0;
                int count = 0;
                int rep = 100000000;
                boolean found = false;
                for (SubPledgeSkillTree.SubUnitSkill sus : SubPledgeSkillTree.getInstance().getAvailableSkills(player.getClan())) {
                    if (sus.getSkill() != skill) continue;
                    id = sus.getItemId();
                    count = sus.getCount();
                    rep = sus.getReputation();
                    found = true;
                    break;
                }
                if (!found) {
                    return;
                }
                if (!player.getClan().isLearnableSubSkill(skill, this.subType)) {
                    return;
                }
                if (player.getClan().getReputationScore() < rep) {
                    player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ACQUIRE_SKILL_FAILED_BAD_CLAN_REP_SCORE));
                    return;
                }
                if (!player.destroyItemByItemId("SubSkills", id, count, trainer, false)) {
                    player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ITEM_MISSING_TO_LEARN_SKILL));
                    return;
                }
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                sm.addItemName(id);
                sm.addItemNumber(count);
                player.sendPacket(sm);
                player.getClan().takeReputationScore(rep, true);
                SystemMessage cr = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                cr.addNumber(rep);
                player.sendPacket(cr);
                if (this.subType > -2) {
                    player.getClan().addNewSkill(skill, this.subType);
                }
                player.getClan().broadcastToOnlineMembers(new PledgeSkillList(player.getClan()));
                ((L2SquadTrainer)((Object)trainer)).showSubUnitSkillList(player);
                break;
            }
            case 4: 
            case 5: {
                requiredSp = 0;
                Quest[] qlst = trainer.getTemplate().getEventQuests(Quest.QuestEventType.ON_SKILL_LEARN);
                if (qlst != null && qlst.length == 1) {
                    if (qlst[0].notifyAcquireSkill(trainer, player, skill)) break;
                    qlst[0].notifyAcquireSkillList(trainer, player);
                    return;
                }
                return;
            }
            case 6: {
                L2SkillLearn[] skillsc;
                int costId = 0;
                int costCount = 0;
                for (L2SkillLearn s : skillsc = SkillTreeTable.getInstance().getAvailableSpecialSkills(player)) {
                    L2Skill sk = SkillTable.getInstance().getInfo(s.getId(), s.getLevel());
                    if (sk == null || sk != skill) continue;
                    ++counts;
                    costId = s.getIdCost();
                    costCount = s.getCostCount();
                    requiredSp = s.getSpCost();
                }
                if (counts == 0) {
                    player.sendMessage("You are trying to learn skill that u can't..");
                    Util.handleIllegalPlayerAction(player, "Player " + player.getName() + " tried to learn skill that he can't!!!", Config.DEFAULT_PUNISH);
                    return;
                }
                if (player.getSp() >= requiredSp) {
                    if (!player.destroyItemByItemId("Consume", costId, costCount, trainer, false)) {
                        player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ITEM_MISSING_TO_LEARN_SKILL));
                        this.showSkillList(trainer, player);
                        return;
                    }
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                    sm.addItemName(costId);
                    sm.addItemNumber(costCount);
                    player.sendPacket(sm);
                    break;
                }
                player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.NOT_ENOUGH_SP_TO_LEARN_SKILL));
                this.showSkillList(trainer, player);
                return;
            }
            default: {
                _log.warning("Recived Wrong Packet Data in Aquired Skill - unk1:" + this._skillType);
                return;
            }
        }
        if (Config.DEBUG) {
            _log.fine("Learned skill " + this._id + " for " + requiredSp + " SP.");
        }
        if (this._skillType != 3 && this._skillType != 2) {
            player.setSp(player.getSp() - requiredSp);
            StatusUpdate su = new StatusUpdate(player);
            su.addAttribute(13, player.getSp());
            player.sendPacket(su);
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.LEARNED_SKILL_S1);
            sm.addSkillName(skill);
            player.sendPacket(sm);
            player.sendPacket(new AcquireSkillDone());
            player.addSkill(skill, true);
            player.sendSkillList();
            this.updateShortCuts(player);
            this.showSkillList(trainer, player);
        }
    }

    private void updateShortCuts(L2PcInstance player) {
        if (this._level > 1) {
            L2ShortCut[] allShortCuts;
            for (L2ShortCut sc : allShortCuts = player.getAllShortCuts()) {
                if (sc.getId() != this._id || sc.getType() != 2) continue;
                L2ShortCut newsc = new L2ShortCut(sc.getSlot(), sc.getPage(), sc.getType(), sc.getId(), this._level, 1);
                player.sendPacket(new ShortCutRegister(newsc));
                player.registerShortCut(newsc);
            }
        }
    }

    private void showSkillList(L2Npc trainer, L2PcInstance player) {
        if (this._skillType == 4) {
            Quest[] qlst = trainer.getTemplate().getEventQuests(Quest.QuestEventType.ON_SKILL_LEARN);
            qlst[0].notifyAcquireSkillList(trainer, player);
        } else if (trainer instanceof L2FishermanInstance) {
            L2FishermanInstance.showFishSkillList(player);
        } else if (trainer instanceof L2TransformManagerInstance) {
            L2TransformManagerInstance.showTransformSkillList(player);
        } else {
            L2NpcInstance.showSkillList(player, trainer, player.getSkillLearningClassId());
        }
        if (this._id >= 1368 && this._id <= 1372) {
            player.sendPacket(new ExStorageMaxCount(player));
        }
    }

    @Override
    public String getType() {
        return _C__6C_REQUESTAQUIRESKILL;
    }
}

