/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.util.Util;
import java.util.logging.Logger;

public final class RequestGetItemFromPet
extends L2GameClientPacket {
    private static final String REQUESTGETITEMFROMPET__C__8C = "[C] 8C RequestGetItemFromPet";
    private static Logger _log = Logger.getLogger(RequestGetItemFromPet.class.getName());
    private int _objectId;
    private long _amount;
    private int _unknown;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
        this._amount = this.readQ();
        this._unknown = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null || !(player.getPet() instanceof L2PetInstance)) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("getfrompet")) {
            player.sendMessage("You get items from pet too fast.");
            return;
        }
        L2PetInstance pet = (L2PetInstance)player.getPet();
        if (player.getActiveEnchantItem() != null) {
            return;
        }
        if (this._amount < 0L) {
            Util.handleIllegalPlayerAction(player, "[RequestGetItemFromPet] Character " + player.getName() + " of account " + player.getAccountName() + " tried to get item with oid " + this._objectId + " from pet but has count < 0!", Config.DEFAULT_PUNISH);
            return;
        }
        if (this._amount == 0L) {
            return;
        }
        if (pet.transferItem("Transfer", this._objectId, this._amount, player.getInventory(), player, pet) == null) {
            _log.warning("Invalid item transfer request: " + pet.getName() + "(pet) --> " + player.getName());
        }
    }

    @Override
    public String getType() {
        return REQUESTGETITEMFROMPET__C__8C;
    }
}

