/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import java.util.logging.Logger;

public final class RequestRestartPoint
extends L2GameClientPacket {
    private static final String _C__6d_REQUESTRESTARTPOINT = "[C] 6d RequestRestartPoint";
    private static Logger _log = Logger.getLogger(RequestRestartPoint.class.getName());
    protected int _requestedPointType;
    protected boolean _continuation;

    @Override
    protected void readImpl() {
        this._requestedPointType = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (TvTEvent.isStarted() && TvTEvent.isPlayerParticipant(activeChar.getObjectId())) {
            return;
        }
        if (activeChar.isFakeDeath()) {
            activeChar.stopFakeDeath(true);
            return;
        }
        if (!activeChar.isDead()) {
            _log.warning("Living player [" + activeChar.getName() + "] called RestartPointPacket! Ban this player!");
            return;
        }
        Castle castle = CastleManager.getInstance().getCastle(activeChar.getX(), activeChar.getY(), activeChar.getZ());
        if (castle != null && castle.getSiege().getIsInProgress() && activeChar.getClan() != null && castle.getSiege().checkIsAttacker(activeChar.getClan())) {
            ThreadPoolManager.getInstance().scheduleGeneral(new DeathTask(activeChar), castle.getSiege().getAttackerRespawnDelay());
            if (castle.getSiege().getAttackerRespawnDelay() > 0) {
                activeChar.sendMessage("You will be re-spawned in " + castle.getSiege().getAttackerRespawnDelay() / 1000 + " seconds");
            }
            return;
        }
        new DeathTask(activeChar).run();
    }

    @Override
    public String getType() {
        return _C__6d_REQUESTRESTARTPOINT;
    }

    static /* synthetic */ Logger access$000() {
        return _log;
    }

    class DeathTask
    implements Runnable {
        final L2PcInstance activeChar;

        DeathTask(L2PcInstance _activeChar) {
            this.activeChar = _activeChar;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            loc = null;
            castle = null;
            fort = null;
            isInDefense = false;
            instanceId = 0;
            if (this.activeChar.isInJail()) {
                RequestRestartPoint.this._requestedPointType = 27;
            } else if (this.activeChar.isFestivalParticipant()) {
                RequestRestartPoint.this._requestedPointType = 5;
            }
            switch (RequestRestartPoint.this._requestedPointType) {
                case 1: {
                    if (this.activeChar.getClan() == null || this.activeChar.getClan().getHasHideout() == 0) {
                        RequestRestartPoint.access$000().warning("Player [" + this.activeChar.getName() + "] called RestartPointPacket - To Clanhall and he doesn't have Clanhall!");
                        return;
                    }
                    loc = MapRegionTable.getInstance().getTeleToLocation(this.activeChar, MapRegionTable.TeleportWhereType.ClanHall);
                    if (ClanHallManager.getInstance().getClanHallByOwner(this.activeChar.getClan()) == null || ClanHallManager.getInstance().getClanHallByOwner(this.activeChar.getClan()).getFunction(5) == null) break;
                    this.activeChar.restoreExp(ClanHallManager.getInstance().getClanHallByOwner(this.activeChar.getClan()).getFunction(5).getLvl());
                    break;
                }
                case 2: {
                    castle = CastleManager.getInstance().getCastle(this.activeChar);
                    if (castle == null || !castle.getSiege().getIsInProgress()) ** GOTO lbl31
                    if (castle.getSiege().checkIsDefender(this.activeChar.getClan())) {
                        loc = MapRegionTable.getInstance().getTeleToLocation(this.activeChar, MapRegionTable.TeleportWhereType.Castle);
                    } else if (castle.getSiege().checkIsAttacker(this.activeChar.getClan())) {
                        loc = MapRegionTable.getInstance().getTeleToLocation(this.activeChar, MapRegionTable.TeleportWhereType.Town);
                    } else {
                        RequestRestartPoint.access$000().warning("Player [" + this.activeChar.getName() + "] called RestartPointPacket - To Castle and he doesn't have Castle!");
                        return;
lbl31:
                        // 1 sources

                        if (this.activeChar.getClan() == null || this.activeChar.getClan().getHasCastle() == 0) {
                            return;
                        }
                        loc = MapRegionTable.getInstance().getTeleToLocation(this.activeChar, MapRegionTable.TeleportWhereType.Castle);
                    }
                    if (CastleManager.getInstance().getCastleByOwner(this.activeChar.getClan()) == null || CastleManager.getInstance().getCastleByOwner(this.activeChar.getClan()).getFunction(4) == null) break;
                    this.activeChar.restoreExp(CastleManager.getInstance().getCastleByOwner(this.activeChar.getClan()).getFunction(4).getLvl());
                    break;
                }
                case 3: {
                    if (!(this.activeChar.getClan() != null && this.activeChar.getClan().getHasFort() != 0 || isInDefense)) {
                        RequestRestartPoint.access$000().warning("Player [" + this.activeChar.getName() + "] called RestartPointPacket - To Fortress and he doesn't have Fortress!");
                        return;
                    }
                    loc = MapRegionTable.getInstance().getTeleToLocation(this.activeChar, MapRegionTable.TeleportWhereType.Fortress);
                    if (FortManager.getInstance().getFortByOwner(this.activeChar.getClan()) == null || FortManager.getInstance().getFortByOwner(this.activeChar.getClan()).getFunction(4) == null) break;
                    this.activeChar.restoreExp(FortManager.getInstance().getFortByOwner(this.activeChar.getClan()).getFunction(4).getLvl());
                    break;
                }
                case 4: {
                    siegeClan = null;
                    castle = CastleManager.getInstance().getCastle(this.activeChar);
                    fort = FortManager.getInstance().getFort(this.activeChar);
                    flag = TerritoryWarManager.getInstance().getFlagForClan(this.activeChar.getClan());
                    if (castle != null && castle.getSiege().getIsInProgress()) {
                        siegeClan = castle.getSiege().getAttackerClan(this.activeChar.getClan());
                    } else if (fort != null && fort.getSiege().getIsInProgress()) {
                        siegeClan = fort.getSiege().getAttackerClan(this.activeChar.getClan());
                    }
                    if ((siegeClan == null || siegeClan.getFlag().isEmpty()) && flag == null) {
                        RequestRestartPoint.access$000().warning("Player [" + this.activeChar.getName() + "] called RestartPointPacket - To Siege HQ and he doesn't have Siege HQ!");
                        return;
                    }
                    loc = MapRegionTable.getInstance().getTeleToLocation(this.activeChar, MapRegionTable.TeleportWhereType.SiegeFlag);
                    break;
                }
                case 5: {
                    if (!this.activeChar.isGM() && !this.activeChar.isFestivalParticipant()) {
                        RequestRestartPoint.access$000().warning("Player [" + this.activeChar.getName() + "] called RestartPointPacket - Fixed and he isn't festival participant!");
                        return;
                    }
                    instanceId = this.activeChar.getInstanceId();
                    loc = new Location(this.activeChar.getX(), this.activeChar.getY(), this.activeChar.getZ());
                    break;
                }
                case 6: {
                    break;
                }
                case 27: {
                    if (!this.activeChar.isInJail()) {
                        return;
                    }
                    loc = new Location(-114356, -249645, -2984);
                    break;
                }
                default: {
                    loc = MapRegionTable.getInstance().getTeleToLocation(this.activeChar, MapRegionTable.TeleportWhereType.Town);
                }
            }
            this.activeChar.setInstanceId(instanceId);
            this.activeChar.setIsIn7sDungeon(false);
            this.activeChar.setIsPendingRevive(true);
            this.activeChar.teleToLocation(loc, true);
        }
    }
}

