/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;

public class EffectChameleonRest
extends L2Effect {
    public EffectChameleonRest(Env env, EffectTemplate template) {
        super(env, template);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.RELAXING;
    }

    @Override
    public boolean onStart() {
        if (this.getEffected() instanceof L2PcInstance) {
            ((L2PcInstance)this.getEffected()).sitDown(false);
        } else {
            this.getEffected().getAI().setIntention(CtrlIntention.AI_INTENTION_REST);
        }
        return super.onStart();
    }

    @Override
    public void onExit() {
        super.onExit();
    }

    @Override
    public boolean onActionTime() {
        if (this.getEffected().isDead()) {
            return false;
        }
        if (this.getSkill().getSkillType() != L2SkillType.CONT) {
            return false;
        }
        if (this.getEffected() instanceof L2PcInstance && !((L2PcInstance)this.getEffected()).isSitting()) {
            return false;
        }
        double manaDam = this.calc();
        if (manaDam > this.getEffected().getCurrentMp()) {
            this.getEffected().sendPacket(SystemMessage.getSystemMessage(SystemMessageId.SKILL_REMOVED_DUE_LACK_MP));
            return false;
        }
        this.getEffected().reduceCurrentMp(manaDam);
        return true;
    }

    @Override
    public int getEffectFlags() {
        return 80;
    }
}

