/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2EffectPointInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.l2skills.L2SkillSignet;
import com.l2jserver.gameserver.skills.l2skills.L2SkillSignetCasttime;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import javolution.util.FastList;

public class EffectSignet
extends L2Effect {
    private L2Skill _skill;
    private L2EffectPointInstance _actor;
    private boolean _srcInArena;

    public EffectSignet(Env env, EffectTemplate template) {
        super(env, template);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.SIGNET_EFFECT;
    }

    @Override
    public boolean onStart() {
        if (this.getSkill() instanceof L2SkillSignet) {
            this._skill = SkillTable.getInstance().getInfo(((L2SkillSignet)this.getSkill()).effectId, this.getLevel());
        } else if (this.getSkill() instanceof L2SkillSignetCasttime) {
            this._skill = SkillTable.getInstance().getInfo(((L2SkillSignetCasttime)this.getSkill()).effectId, this.getLevel());
        }
        this._actor = (L2EffectPointInstance)this.getEffected();
        this._srcInArena = this.getEffector().isInsideZone((byte)0) && !this.getEffector().isInsideZone((byte)2);
        return true;
    }

    @Override
    public boolean onActionTime() {
        if (this._skill == null) {
            return true;
        }
        int mpConsume = this._skill.getMpConsume();
        if ((double)mpConsume > this.getEffector().getCurrentMp()) {
            this.getEffector().sendPacket(SystemMessage.getSystemMessage(SystemMessageId.SKILL_REMOVED_DUE_LACK_MP));
            return false;
        }
        this.getEffector().reduceCurrentMp(mpConsume);
        FastList targets = FastList.newInstance();
        for (L2Character cha : this._actor.getKnownList().getKnownCharactersInRadius(this.getSkill().getSkillRadius())) {
            if (cha == null || this._skill.isOffensive() && !L2Skill.checkForAreaOffensiveSkills(this.getEffector(), cha, this._skill, this._srcInArena)) continue;
            this._actor.broadcastPacket(new MagicSkillUse(this._actor, cha, this._skill.getId(), this._skill.getLevel(), 0, 0));
            targets.add((Object)cha);
        }
        if (!targets.isEmpty()) {
            this.getEffector().callSkill(this._skill, (L2Object[])targets.toArray((Object[])new L2Character[targets.size()]));
        }
        FastList.recycle((FastList)targets);
        return true;
    }

    @Override
    public void onExit() {
        if (this._actor != null) {
            this._actor.deleteMe();
        }
    }
}

