/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2EffectPointInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillLaunched;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.Formulas;
import com.l2jserver.gameserver.skills.l2skills.L2SkillSignetCasttime;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.util.Point3D;
import javolution.util.FastList;

public class EffectSignetMDam
extends L2Effect {
    private L2EffectPointInstance _actor;

    public EffectSignetMDam(Env env, EffectTemplate template) {
        super(env, template);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.SIGNET_GROUND;
    }

    @Override
    public boolean onStart() {
        Point3D wordPosition;
        if (!(this.getSkill() instanceof L2SkillSignetCasttime)) {
            return false;
        }
        L2NpcTemplate template = NpcTable.getInstance().getTemplate(((L2SkillSignetCasttime)this.getSkill())._effectNpcId);
        L2EffectPointInstance effectPoint = new L2EffectPointInstance(IdFactory.getInstance().getNextId(), template, this.getEffector());
        effectPoint.setCurrentHp(effectPoint.getMaxHp());
        effectPoint.setCurrentMp(effectPoint.getMaxMp());
        int x = this.getEffector().getX();
        int y = this.getEffector().getY();
        int z = this.getEffector().getZ();
        if (this.getEffector() instanceof L2PcInstance && this.getSkill().getTargetType() == L2Skill.SkillTargetType.TARGET_GROUND && (wordPosition = ((L2PcInstance)this.getEffector()).getCurrentSkillWorldPosition()) != null) {
            x = wordPosition.getX();
            y = wordPosition.getY();
            z = wordPosition.getZ();
        }
        effectPoint.setIsInvul(true);
        effectPoint.spawnMe(x, y, z);
        this._actor = effectPoint;
        return true;
    }

    @Override
    public boolean onActionTime() {
        if (this.getCount() >= this.getTotalCount() - 2) {
            return true;
        }
        int mpConsume = this.getSkill().getMpConsume();
        L2PcInstance caster = (L2PcInstance)this.getEffector();
        boolean ss = false;
        boolean bss = false;
        L2ItemInstance weaponInst = caster.getActiveWeaponInstance();
        if (weaponInst != null) {
            switch (weaponInst.getChargedSpiritshot()) {
                case 2: {
                    weaponInst.setChargedSpiritshot(0);
                    bss = true;
                    break;
                }
                case 1: {
                    weaponInst.setChargedSpiritshot(0);
                    ss = true;
                }
            }
        }
        FastList targets = new FastList();
        for (L2Character cha : this._actor.getKnownList().getKnownCharactersInRadius(this.getSkill().getSkillRadius())) {
            if (cha == null || cha == caster || !(cha instanceof L2Attackable) && !(cha instanceof L2Playable) || cha.isAlikeDead()) continue;
            if ((double)mpConsume > caster.getCurrentMp()) {
                caster.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.SKILL_REMOVED_DUE_LACK_MP));
                return false;
            }
            caster.reduceCurrentMp(mpConsume);
            if (cha instanceof L2Playable) {
                if (!caster.canAttackCharacter(cha)) continue;
                targets.add((Object)cha);
                caster.updatePvPStatus(cha);
                continue;
            }
            targets.add((Object)cha);
        }
        if (!targets.isEmpty()) {
            caster.broadcastPacket(new MagicSkillLaunched(caster, this.getSkill().getId(), this.getSkill().getLevel(), (L2Object[])targets.toArray((Object[])new L2Character[targets.size()])));
            for (L2Character target : targets) {
                boolean mcrit = Formulas.calcMCrit(caster.getMCriticalHit(target, this.getSkill()));
                byte shld = Formulas.calcShldUse(caster, target, this.getSkill());
                int mdam = (int)Formulas.calcMagicDam(caster, target, this.getSkill(), shld, ss, bss, mcrit);
                if (target instanceof L2Summon) {
                    target.broadcastStatusUpdate();
                }
                if (mdam > 0) {
                    if (!target.isRaid() && Formulas.calcAtkBreak(target, mdam)) {
                        target.breakAttack();
                        target.breakCast();
                    }
                    caster.sendDamageMessage(target, mdam, mcrit, false, false);
                    target.reduceCurrentHp(mdam, caster, this.getSkill());
                }
                target.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, caster);
            }
        }
        return true;
    }

    @Override
    public void onExit() {
        if (this._actor != null) {
            this._actor.deleteMe();
        }
    }
}

