DROP TABLE IF EXISTS `npc`;
CREATE TABLE `npc`(
  `id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `idTemplate` smallint(5) unsigned NOT NULL DEFAULT '0',
  `name` varchar(200) NOT NULL DEFAULT '',
  `serverSideName` tinyint(1) NOT NULL DEFAULT '0',
  `title` varchar(45) NOT NULL DEFAULT '',
  `serverSideTitle` tinyint(1) NOT NULL DEFAULT '0',
  `class` varchar(200) DEFAULT NULL,
  `collision_radius` decimal(6,2) DEFAULT NULL,
  `collision_height` decimal(6,2) DEFAULT NULL,
  `level` tinyint(2) DEFAULT NULL,
  `sex` enum('etc','female','male') NOT NULL DEFAULT 'etc',
  `type` varchar(22) DEFAULT NULL,
  `attackrange` smallint(4) DEFAULT NULL,
  `hp` decimal(30,15) DEFAULT NULL,
  `mp` decimal(30,15) DEFAULT NULL,
  `hpreg` decimal(30,15) DEFAULT NULL,
  `mpreg` decimal(30,15) DEFAULT NULL,
  `str` tinyint(2) NOT NULL DEFAULT '40',
  `con` tinyint(2) NOT NULL DEFAULT '43',
  `dex` tinyint(2) NOT NULL DEFAULT '30',
  `int` tinyint(2) NOT NULL DEFAULT '21',
  `wit` tinyint(2) NOT NULL DEFAULT '20',
  `men` tinyint(2) NOT NULL DEFAULT '20',
  `exp` int(9) NOT NULL DEFAULT '0',
  `sp` int(9) NOT NULL DEFAULT '0',
  `patk` decimal(12,5) DEFAULT NULL,
  `pdef` decimal(12,5) DEFAULT NULL,
  `matk` decimal(12,5) DEFAULT NULL,
  `mdef` decimal(12,5) DEFAULT NULL,
  `atkspd` smallint(4) NOT NULL DEFAULT '230',
  `critical` tinyint(1) NOT NULL DEFAULT '1',
  `aggro` smallint(4) NOT NULL DEFAULT '0',
  `matkspd` smallint(4) NOT NULL DEFAULT '333',
  `rhand` smallint(5) unsigned NOT NULL DEFAULT '0',
  `lhand` smallint(5) unsigned NOT NULL DEFAULT '0',
  `enchant` tinyint(1) NOT NULL DEFAULT '0',
  `walkspd` decimal(10,5) NOT NULL DEFAULT '60',
  `runspd` decimal(10,5) NOT NULL DEFAULT '120',
  `targetable` tinyint(1) NOT NULL DEFAULT '1',
  `show_name` tinyint(1) NOT NULL DEFAULT '1',
  `dropHerbGroup` tinyint(1) NOT NULL DEFAULT '0',
  `basestats` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`idTemplate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `npc` VALUES 
(1,1,'Thomas D. Turkey',0,'Misguided Holiday Scrooge',0,'LineageMonster4.br_crazy_turkey','25','35',80,'male','L2Npc',40,'680','2000','0','0.9',40,43,30,21,20,20,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,19.5,160,1,1,0,1),
(2,2,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',80,'male','L2Npc',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,20,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,1,1,1,1,0,1),
(3,3,'Santa\'s Helper',0,'',0,'LineageNPC.e_smith_master_MDwarf','8','16.5',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,490,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,120,1,1,0,1),
(4,4,'Holiday Santa',0,'Happy Holidays!',0,'LineageNPC2.br_xmas08_santa','8','24',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,490,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,120,1,1,0,1),
(5,5,'Holiday Santa',0,'Happy Holidays!',0,'LineageNPC2.br_xmas08_santa','8','24',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,490,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,120,1,1,0,1),
(6,6,'Holiday Sled',0,'Happy Holidays!',0,'LineageNPC2.br_xmas08_sled','0.01','50',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,10,490,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,30,120,1,1,0,1),
(7,7,'Birthday Cake',0,'',0,'LineageNPC2.br_birthday_cake','0.01','0.01',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,10,490,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,30,120,1,1,0,1),
(8,8,'Spirit of Fire',0,'',0,'LineageMonster4.br_fire_elemental','16','22',1,'male','L2Npc',40,'20000000','40','0','3',40,43,30,21,20,20,0,0,'8.47458','40','5.78704','30',253,1,0,333,0,0,0,25,120,1,1,0,1),
(9,9,'Explosive Spirit of Fire',0,'',0,'LineageMonster4.br_fire_elemental_of_fierce','26','35',1,'male','L2Npc',40,'20000000','40','0','3',40,43,30,21,20,20,0,0,'8.47458','40','5.78704','30',253,1,0,333,0,0,0,45,180,1,1,0,1),
(10,10,'Jack Sage',0,'Eva\'s High Priest',0,'LineageNPC2.br_archbishop_of_eva','8','26.5',85,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,723,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,120,1,1,0,1),
(11,11,'Eva\'s Obelisk',0,'',0,'LineageNPC2.br_obelisk_of_eva','40','120',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,10,490,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,30,120,0,1,0,1),
(12,12,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',80,'male','L2Npc',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,20,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,1,1,0,1,0,1),
(13,13,'Warm Hearted Sno',0,'Beginner Supporter',0,'LineageNPC2.br_tp_actor','9','16.3',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,4,180,1,1,0,1),
(14,14,'Warm Hearted Sno',0,'Beginner Supporter',0,'LineageNPC2.br_tp_actor','9','16.3',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,4,180,1,1,0,1),
(15,15,'Warm Hearted Sno',0,'Beginner Supporter',0,'LineageNPC2.br_tp_actor','9','16.3',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,4,180,1,1,0,1),
(16,16,'Warm Hearted Sno',0,'Beginner Supporter',0,'LineageNPC2.br_tp_actor','9','16.3',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,4,180,1,1,0,1),
(17,17,'Warm Hearted Sno',0,'Beginner Supporter',0,'LineageNPC2.br_tp_actor','9','16.3',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,4,180,1,1,0,1),
(18,18,'Warm Hearted Sno',0,'Beginner Supporter',0,'LineageNPC2.br_tp_actor','9','16.3',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,4,180,1,1,0,1),
(19,19,'Wooldy',0,'Halloween Children',0,'LineageMonster5.br_wooldie','10','16',80,'male','L2Npc',40,'20000000','40','8.5','3',40,43,30,21,20,20,0,0,'8.47458','40','5.78704','30',253,1,0,333,0,0,0,25,120,1,1,0,1),
(20,20,'Verdandi',0,'Halloween Children',0,'LineageMonster5.br_berdandi','10','14',80,'male','L2Npc',40,'20000000','40','8.5','3',40,43,30,21,20,20,0,0,'8.47458','40','5.78704','30',253,1,0,333,0,0,0,45,180,1,1,0,1),
(21,21,'Skooldy',0,'Jack Game Trainer',0,'LineageMonster5.br_scooldie','10','16',80,'male','L2Npc',40,'20000000','40','8.5','3',40,43,30,21,20,20,0,0,'8.47458','40','5.78704','30',253,1,0,333,0,0,0,45,180,1,1,0,1),
(22,22,'Lucky Sky Lantern',0,'',0,'LineageNPC2.br_lamp','4.2','5',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,10,490,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,30,120,1,1,0,1),
(23,23,'Ambience Sky Lantern',0,'',0,'LineageNPC2.br_lamp','4.2','5',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,10,490,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,30,120,1,1,0,1),
(24,24,'Sway Sky Lantern',0,'',0,'LineageNPC2.br_lamp','4.2','5',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,10,490,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,30,120,1,1,0,1),
(25,25,'Comfort Sky Lantern',0,'',0,'LineageNPC2.br_lamp','4.2','5',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,10,490,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,30,120,1,1,0,1),
(26,26,'Halloween Event Manager',0,'',0,'LineageNPC.clear_npc','0.1','0.1',80,'male','L2Npc',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,20,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,1,1,0,1,0,1),
(27,27,'Kadomas',0,'',0,'LineageNPC2.br_kadomatsu','24.5','14',80,'male','L2Npc',40,'1673.05473','889.8','0','0.9',40,43,30,21,20,25,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,60,180,1,1,0,1),
(28,28,'Kotatz',0,'',0,'LineageNPC2.br_kotatsu','0.01','0.01',80,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,10,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,30,120,0,0,0,1),
(29,29,'Flame Box',0,'Flame Box',0,'LineageNPC2.br_fire_box','11','12.5',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,10,490,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,30,120,1,1,0,1),
(30,30,'Santa',0,'Merry Christmas',0,'LineageNPC2.br_xmas08_santa','8','24',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,490,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,120,1,1,0,1),
(31,31,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',80,'male','L2Npc',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,20,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,1,1,1,1,0,1),
(32,32,'Jet Bike',0,'',0,'LineageNPC2.br_z_bike','30','29',80,'male','L2Npc',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,20,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,1,1,1,1,0,1),
(33,33,'Trejuo',0,'Blessed Child',0,'LineageNPC2.br_blessed_taiboy','10','13',80,'male','L2Npc',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,20,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,1,1,1,1,0,1),
(34,34,'Sujin',0,'Blessed Child',0,'LineageNPC2.br_blessed_taiboy','10','13',80,'female','L2Npc',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,20,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,1,1,1,1,0,1),
(1501,1501,'Majo Agathion',0,'',0,'LineageNPC2.br_agathion_mazu','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1502,1502,'Gold Agathion',0,'',0,'LineageNPC2.br_agathion_mazu','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1503,1503,'Black Agathion',0,'',0,'LineageNPC2.br_agathion_mazu','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1504,1504,'Plaipitak Agathion',0,'',0,'LineageNPC2.br_agathion_elephant','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1505,1505,'Baby Panda Agathion',0,'',0,'LineageNPC2.br_agathion_bpanda','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1506,1506,'Bamboo Panda Agathion',0,'',0,'LineageNPC2.br_agathion_mpanda','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1507,1507,'Sexy Panda Agathion',0,'',0,'LineageNPC2.br_agathion_wpanda','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1508,1508,'White Cupid Agathion',0,'',0,'LineageNPC2.br_agathion_wcupid','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1509,1509,'Dark Cupid Agathion',0,'',0,'LineageNPC2.br_agathion_dcupid','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1510,1510,'White Maneki Neko Agathion',0,'',0,'LineageNPC2.br_agathion_maneki','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1511,1511,'Black Maneki Neko Agathion',0,'',0,'LineageNPC2.br_agathion_maneki','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1512,1512,'Brown Maneki Neko Agathion',0,'',0,'LineageNPC2.br_agathion_maneki','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1513,1513,'One-Eyed Bat Drove Agathion',0,'',0,'LineageNPC2.br_agathion_bat','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1514,1514,'Pegasus Agathion',0,'',0,'LineageNPC2.br_agathion_pegasus','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1515,1515,'Yellow-Robed Tojigong Agathion',0,'',0,'LineageNPC2.br_agathion_tozi','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1516,1516,'Blue-Robed Tojigong Agathion',0,'',0,'LineageNPC2.br_agathion_tozi','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1517,1517,'Green-Robed Tojigong Agathion',0,'',0,'LineageNPC2.br_agathion_tozi','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1518,1518,'Bugbear Agathion',0,'',0,'LineageNPC2.br_agathion_bugbear','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1519,1519,'Red Sumo Wrestler Agathion',0,'',0,'LineageNPC2.br_agathion_redsumo','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1520,1520,'Blue Sumo Wrestler Agathion',0,'',0,'LineageNPC2.br_agathion_bluesumo','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1521,1521,'Great Sumo Match Agathion',0,'',0,'LineageNPC2.br_agathion_match','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1522,1522,'Button-Eyed Bear Doll',0,'',0,'LineageNPC2.br_agathion_bear','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1523,1523,'God of Fortune',0,'',0,'LineageNPC2.br_agathion_wealthgod','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1524,1524,'Dryad Agathion',0,'',0,'LineageNPC2.br_agathion_dryad','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1525,1525,'Wonboso Agathion',0,'',0,'LineageNPC2.br_agathion_cashcow','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1526,1526,'Daewoonso Agathion',0,'',0,'LineageNPC2.br_agathion_luckycow','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1527,1527,'Pomona Agathion',0,'',0,'LineageNPC2.br_agathion_pomona','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1528,1528,'Weaver Agathion',0,'',0,'LineageNPC2.br_agathion_womanweaver','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1529,1529,'Chon-chon Agathion',0,'',0,'LineageNPC2.br_agathion_luckygirl','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1530,1530,'Tang-tang Agathion',0,'',0,'LineageNPC2.br_agathion_luckyboy','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1531,1531,'Dancing Lucky Kid Agathion',0,'',0,'LineageNPC2.br_agathion_dancingchild','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1532,1532,'Monkey King Agathion',0,'',0,'LineageNPC2.br_agathion_sunwukong','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1533,1533,'Utanka Agathion',0,'',0,'LineageNPC2.br_agathion_uthanka','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1534,1534,'Bonus B Agathion',0,'',0,'LineageNPC2.br_agathion_bonus','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1535,1535,'Zombie Agathion',0,'',0,'LineageNPC2.br_agathion_gangsi','7','6',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1536,1536,'Baekyi Hwamae Agathion',0,'',0,'LineageNPC2.br_agathion_bluebird','6','5',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1537,1537,'Gwanwoo Hwamae Agathion',0,'',0,'LineageNPC2.br_agathion_hatbird','6','5',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1538,1538,'Baby Rudolph',0,'',0,'LineageNPC2.br_pet_rudolf','21.5','27',55,'male','L2Pet',40,'1673.05473','889.80000','6.5','2.4',35,37,30,32,20,25,0,0,'388.11142','60000','265.02979','20000',253,4,0,333,0,0,0,35,170,1,1,0,1),
(1539,1539,'Iken Agathion',0,'',0,'LineageNPC2.br_local_JP_Mfighter','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1540,1540,'Lana Agathion',0,'',0,'LineageNPC2.br_local_JP_FFighter','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1541,1541,'Gnocian Agathion',0,'',0,'LineageNPC2.br_local_JP_MElf','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1542,1542,'Orodriel Agathion',0,'',0,'LineageNPC2.br_local_JP_Felf','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1543,1543,'Lakinos Agathion',0,'',0,'LineageNPC2.br_local_JP_MDarkelf','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1544,1544,'Mortia Agathion',0,'',0,'LineageNPC2.br_local_JP_Fdarkelf','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1545,1545,'Hayance Agathion',0,'',0,'LineageNPC2.br_local_JP_MDwarf','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1546,1546,'Meruril Agathion',0,'',0,'LineageNPC2.br_local_JP_FDwarf','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1547,1547,'Taman ze Lapatui Agathion',0,'',0,'LineageNPC2.br_local_JP_MOrc','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1548,1548,'Kaurin Agathion',0,'',0,'LineageNPC2.br_local_JP_FOrc','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1549,1549,'Ahertbein Agathion',0,'',0,'LineageNPC2.br_local_JP_MKamael','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1550,1550,'Naonin Agathion',0,'',0,'LineageNPC2.br_local_JP_FKamael','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1551,1551,'Guangong Agathion',0,'',0,'LineageNPC2.br_aga_warriorgod','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1552,1552,'Gwanseum Nyang Nyang Agathion',0,'',0,'LineageNPC2.br_aga_mercygod','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1553,1553,'Blue Opera Agathion',0,'',0,'LineageNPC2.br_aga_blue_pekingopera','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1554,1554,'Red Opera Agathion',0,'',0,'LineageNPC2.br_aga_red_pekingopera','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1555,1555,'Opera Agathion',0,'',0,'LineageNPC2.br_aga_redblue_pekingopera','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1556,1556,'Mandarin Dress Agathion',0,'',0,'LineageNPC2.br_aga_chinesedress','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1557,1557,'Nepal Snow Agathion',0,'',0,'LineageNPC2.br_aga_suno_trumpet','10.5','12.5',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1558,1558,'Round Ball Snow Agathion',0,'',0,'LineageNPC2.br_aga_suno_ball','15','20.5',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1559,1559,'Ladder Snow Agathion',0,'',0,'LineageNPC2.br_aga_suno_tall','20','28',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1560,1560,'Blue Opera Agathion',0,'',0,'LineageNPC2.br_aga_blue_pekingopera','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1561,1561,'Baby Rudolph',0,'',0,'LineageNPC2.br_pet_rudolf','21.5','27',55,'male','L2Pet',40,'3862.00000','1494.00000','6.5','2.4',35,37,30,32,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,35,170,1,1,0,1),
(1562,1562,'Deseloph',0,'',0,'LineageNPC2.br_pet_rose_lover_m_a','13.2','16.9',55,'male','L2Pet',40,'1673.05473','889.80000','6.5','2.4',35,37,30,32,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,30,180,1,1,0,1),
(1563,1563,'Hyum',0,'',0,'LineageNPC2.br_pet_rose_lover_m_a','13.2','16.9',55,'male','L2Pet',40,'1673.05473','889.80000','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1564,1564,'Rekang',0,'',0,'LineageNPC2.br_pet_rose_lover_m_a','13.2','16.9',55,'male','L2Pet',40,'1673.05473','889.80000','6.5','2.4',38,40,30,26,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,1),
(1565,1565,'Lilias',0,'',0,'LineageNPC2.br_pet_rose_lover_f_a','14.5','17.5',55,'female','L2Pet',40,'1673.05473','889.80000','6.5','2.4',38,40,30,26,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,1),
(1566,1566,'Lapham',0,'',0,'LineageNPC2.br_pet_rose_lover_f_a','14.5','17.5',55,'female','L2Pet',40,'1673.05473','889.80000','6.5','2.4',38,40,30,26,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,1),
(1567,1567,'Mafum',0,'',0,'LineageNPC2.br_pet_rose_lover_f_a','14.5','17.5',55,'female','L2Pet',40,'1673.05473','889.80000','6.5','2.4',38,40,30,26,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,1),
(1568,1568,'Deseloph',0,'',0,'LineageNPC2.br_pet_rose_lover_m_b','15.3','16.6',55,'male','L2Pet',40,'1673.05473','889.80000','6.5','2.4',38,40,30,26,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,1),
(1569,1569,'Hyum',0,'',0,'LineageNPC2.br_pet_rose_lover_m_b','15.3','16.6',55,'male','L2Pet',40,'1673.05473','889.80000','6.5','2.4',38,40,30,26,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,1),
(1570,1570,'Rekang',0,'',0,'LineageNPC2.br_pet_rose_lover_m_b','15.3','16.6',55,'male','L2Pet',40,'1673.05473','889.80000','6.5','2.4',38,40,30,26,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,1),
(1571,1571,'Lilias',0,'',0,'LineageNPC2.br_pet_rose_lover_f_b','14.7','17.3',55,'female','L2Pet',40,'1673.05473','889.80000','6.5','2.4',38,40,30,26,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,1),
(1572,1572,'Lapham',0,'',0,'LineageNPC2.br_pet_rose_lover_f_b','14.7','17.3',55,'female','L2Pet',40,'1673.05473','889.80000','6.5','2.4',38,40,30,26,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,1),
(1573,1573,'Mafum',0,'',0,'LineageNPC2.br_pet_rose_lover_f_b','14.7','17.3',55,'female','L2Pet',40,'1673.05473','889.80000','6.5','2.4',38,40,30,26,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,1),
(1574,1574,'Phoenix',0,'',0,'LineageNPC2.br_aga_china_phoenix','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1575,1575,'Three-headed Dragon',0,'',0,'LineageNPC2.br_aga_threehead','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1576,1576,'Ball Trapping Gnosian',0,'',0,'LineageNPC2.br_aga_ball_male','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1577,1577,'Ball Trapping Orodriel',0,'',0,'LineageNPC2.br_aga_ball_female','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1578,1578,'Penalty Kick',0,'',0,'LineageNPC2.br_aga_ball_kick','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1579,1579,'Ball Trapping Gnosian (blue)',0,'',0,'LineageNPC2.br_aga_ball_male','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1580,1580,'Ball Trapping Orodriel (blue)',0,'',0,'LineageNPC2.br_aga_ball_female','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1581,1581,'Penalty Kick (blue)',0,'',0,'LineageNPC2.br_aga_ball_kick','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1582,1582,'Ball Trapping Gnosian (red)',0,'',0,'LineageNPC2.br_aga_ball_male','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1583,1583,'Ball Trapping Orodriel (red)',0,'',0,'LineageNPC2.br_aga_ball_female','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1584,1584,'Penalty Kick (red)',0,'',0,'LineageNPC2.br_aga_ball_kick','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1585,1585,'Granny Tiger',0,'',0,'LineageNPC2.br_aga_tiger_grandma','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1586,1586,'Flower Fairy Spirit',0,'',0,'LineageNPC2.br_aga_flower','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1587,1587,'Cheerleader Orodriel',0,'',0,'LineageNPC2.br_aga_cheer','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1588,1588,'Cheerleader Lana',0,'',0,'LineageNPC2.br_aga_cheer','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1589,1589,'Cheerleader Naonin',0,'',0,'LineageNPC2.br_aga_cheer','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1590,1590,'Cheerleader Mortia',0,'',0,'LineageNPC2.br_aga_cheer','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1591,1591,'Cheerleader Kaurin',0,'',0,'LineageNPC2.br_aga_cheer','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1592,1592,'Cheerleader Meruril',0,'',0,'LineageNPC2.br_aga_cheer','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(1593,1593,'Handy',0,'',0,'LineageNPC2.br_aga_ball_kick','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(4301,4301,'Queen of Hearts',0,'Valentine Messenger',0,'LineageMonster2.queen_of_cat','8','15',70,'female','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,26,120,1,1,0,1),
(4302,4302,'Master Dugi',0,'Soul Healer',0,'LineageNPC2.event_comic_masteryogy','9','16.7',1,'female','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,50,160,1,1,0,1),
(4303,4303,'Skooldy',0,'Halloween Children',0,'LineageMonster5.br_scooldie','10','16',85,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,723,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,120,1,1,0,1),
(4304,4304,'Santa',0,'Merry Christmas',0,'LineageNPC2.br_xmas08_santa','8','24',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,490,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,120,1,1,0,1),
(4305,4305,'Rosalia',0,'Hopeless Romantic',0,'LineageNPC2.message_event_master','10','20',70,'female','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,160,1,1,0,1),
(4306,4306,'Steve Shyagel',0,'Eva\'s High Priest',0,'LineageNPC2.br_archbishop_of_eva','8','26.5',85,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,723,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,120,1,1,0,1),
(12077,12077,'Wolf',0,'',0,'LineageMonster.pet_wolf','13','11.5',15,'male','L2Pet',40,'246.95422','149.20000','2.5','1.2',40,43,30,21,20,25,0,0,'29.61691','73.55216','20.22451','53.82228',253,4,0,333,0,0,0,24,125,1,1,0,1),
(12311,12311,'Hatchling of the Wind',0,'',0,'LineageMonster.hatchling','9','10',35,'male','L2Pet',40,'772.73802','402.60000','4.5','1.8',40,43,30,21,20,25,0,0,'129.32896','136.72948','88.31491','100.0527',253,4,0,333,0,0,0,80,140,1,1,0,1),
(12312,12312,'Hatchling of the Stars',0,'',0,'LineageMonster.hatchling','9','10',35,'male','L2Pet',40,'772.73802','402.60000','4.5','1.8',40,43,30,21,20,25,0,0,'129.32896','136.72948','88.31491','100.0527',253,4,0,333,0,0,0,80,140,1,1,0,1),
(12313,12313,'Hatchling of Twilight',0,'',0,'LineageMonster.hatchling','9','10',35,'male','L2Pet',40,'772.73802','402.60000','4.5','1.8',40,43,30,21,20,25,0,0,'129.32896','136.72948','88.31491','100.0527',253,4,0,333,0,0,0,80,140,1,1,0,1),
(12526,12526,'Wind Strider',0,'',0,'LineageMonster.strider','23','31',55,'male','L2Pet',40,'1673.05473','889.80000','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,80,170,1,1,0,1),
(12527,12527,'Star Strider',0,'',0,'LineageMonster.strider','23','31',55,'male','L2Pet',40,'1673.05473','889.80000','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,80,170,1,1,0,1),
(12528,12528,'Twilight Strider',0,'',0,'LineageMonster.strider','23','31',55,'male','L2Pet',40,'1673.05473','889.80000','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,80,170,1,1,0,1),
(12564,12564,'Sin Eater',0,'',0,'LineageMonster.imp','10','24',15,'male','L2Pet',40,'424.20000','149.20000','7.2513','1.2',40,1,30,21,20,25,0,0,'29.61691','73.55216','20.22451','53.82228',253,4,0,333,0,0,0,60,125,1,1,0,1),
(12621,12621,'Wyvern',0,'',0,'LineageMonster.wyvern','60','80',70,'male','L2Pet',40,'2444.46819','1345.80000','7.5','2.7',40,43,30,21,20,25,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,80,170,1,1,0,1),
(12774,12774,'Young Squash',0,'',0,'LineageNPC.drop_gourd_50_sm','10','10.5',1,'etc','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,10,0,0,'8.47458','44.44444','5.78704','32.52252',253,1,0,333,0,0,0,50,100,1,1,0,1),
(12775,12775,'High Quality Squash',0,'',0,'LineageNPC.drop_gourd','23','25',1,'etc','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,10,0,0,'8.47458','44.44444','5.78704','32.52252',253,1,0,333,0,0,0,50,100,1,1,0,1),
(12776,12776,'Low Quality Squash',0,'',0,'LineageNPC.drop_gourd_25_sm','15','16',1,'etc','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,10,0,0,'8.47458','44.44444','5.78704','32.52252',253,1,0,333,0,0,0,50,100,1,1,0,1),
(12777,12777,'Large Young Squash',0,'',0,'LineageNPC.drop_gourd','23','25',1,'etc','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,10,0,0,'8.47458','44.44444','5.78704','32.52252',253,1,0,333,0,0,0,50,100,1,1,0,1),
(12778,12778,'High Quality Large Squash',0,'',0,'LineageNPC.drop_gourd_50_bi','34','40',1,'etc','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,10,0,0,'8.47458','44.44444','5.78704','32.52252',253,1,0,333,0,0,0,50,100,1,1,0,1),
(12779,12779,'Low Quality Large Squash',0,'',0,'LineageNPC.drop_gourd_25_bi','28','31',1,'etc','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,10,0,0,'8.47458','44.44444','5.78704','32.52252',253,1,0,333,0,0,0,50,100,1,1,0,1),
(12780,12780,'Baby Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12','15',25,'male','L2BabyPet',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,25,0,0,'64.83203','101.83533','44.27187','74.51868',253,4,0,333,0,0,0,30,120,1,1,0,1),
(12781,12781,'Baby Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7','15',25,'male','L2BabyPet',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,25,0,0,'64.83203','101.83533','44.27187','74.51868',253,4,0,333,0,0,0,13,120,1,1,0,1),
(12782,12782,'Baby Cougar',0,'',0,'LineageMonster2.baby_tiger','11','15.7',25,'male','L2BabyPet',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,25,0,0,'64.83203','101.83533','44.27187','74.51868',253,4,0,333,0,0,0,28,120,1,1,0,1),
(13001,13001,'Heart of Warding',0,'',0,'LineageNPC.heart_of_warding','17','120',70,'etc','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,10,490,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,120,1,1,0,1),
(13002,13002,'Life Control Tower',0,'',0,'LineageNPC.broadcasting_tower','7','35',20,'etc','L2ControlTower',40,'342.5127','192','2.5','1.2',40,43,30,21,20,10,40,10,'44.32863','86.87049','30.2707','63.56806',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13003,13003,'Life Control Tower',0,'',0,'LineageNPC.dead_castle_aden_controltower_jewel','7','35',20,'etc','L2ControlTower',40,'342.5127','192','2.5','1.2',40,43,30,21,20,10,40,10,'44.32863','86.87049','30.2707','63.56806',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13004,13004,'Flame Control Tower',0,'',0,'LineageNPC.broadcasting_tower','7','35',20,'etc','L2FlameTower',40,'342.5127','192','2.5','1.2',40,43,30,21,20,10,40,10,'44.32863','86.87049','30.2707','63.56806',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13005,13005,'Flame Control Tower',0,'',0,'LineageNPC.dead_castle_aden_controltower_jewel','7','35',20,'etc','L2FlameTower',40,'342.5127','192','2.5','1.2',40,43,30,21,20,10,40,10,'44.32863','86.87049','30.2707','63.56806',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13006,13006,'Christmas Tree',0,'',0,'LineageDeco.x_mas_tree','0.01','0.01',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,10,490,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,30,120,1,1,0,1),
(13007,13007,'Special Christmas Tree',0,'',0,'LineageDeco.x_mas_tree_50_bi','0.01','0.01',70,'male','L2XmassTree',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,10,490,10,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,30,120,1,1,0,1),
(13014,13014,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',85,'male','L2Npc',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,10,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,1,160,1,1,0,1),
(13015,13015,'',0,'',0,'LineageMonster3.Evilate_weather','16','18.5',85,'female','L2Npc',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,20,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,10,1,1,1,0,1),
(13016,13016,'King Squash',0,'',0,'LineageNPC.drop_gourd','23','25',1,'etc','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,10,0,0,'8.47458','44.44444','5.78704','32.52252',253,1,0,333,0,0,0,50,100,1,1,0,1),
(13017,13017,'Emperor Squash',0,'',0,'LineageNPC.drop_gourd_50_bi','34','40',1,'etc','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,10,0,0,'8.47458','44.44444','5.78704','32.52252',253,1,0,333,0,0,0,50,100,1,1,0,1),
(13018,13018,'',0,'',0,'LineageNPC2.skill_dummy_00_a','5','10',70,'etc','L2EffectPoint',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,20,1,1,0,1),
(13019,13019,'',0,'',0,'LineageNPC2.skill_dummy_00_a','5','10',70,'etc','L2EffectPoint',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,20,1,1,0,1),
(13020,13020,'',0,'',0,'LineageNPC2.skill_dummy_00_a','5','10',70,'etc','L2EffectPoint',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,20,1,1,0,1),
(13021,13021,'',0,'',0,'LineageNPC2.skill_dummy_00_a','5','10',70,'etc','L2EffectPoint',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,20,1,1,0,1),
(13022,13022,'',0,'',0,'LineageNPC2.skill_dummy_00_a','5','10',70,'etc','L2EffectPoint',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,20,1,1,0,1),
(13023,13023,'',0,'',0,'LineageNPC2.skill_dummy_00_a','5','10',70,'etc','L2EffectPoint',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,20,1,1,0,1),
(13024,13024,'',0,'',0,'LineageNPC2.skill_dummy_00_a','5','10',70,'etc','L2EffectPoint',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,20,1,1,0,1),
(13025,13025,'',0,'',0,'LineageNPC2.skill_dummy_01_a','5','10',70,'etc','L2EffectPoint',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,20,1,1,0,1),
(13026,13026,'',0,'',0,'LineageNPC2.skill_dummy_01_a','5','10',70,'etc','L2EffectPoint',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,20,1,1,0,1),
(13027,13027,'',0,'',0,'LineageNPC2.skill_dummy_01_a','5','10',70,'etc','L2EffectPoint',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,20,1,1,0,1),
(13028,13028,'',0,'',0,'LineageNPC2.skill_dummy_01_a','5','10',70,'etc','L2EffectPoint',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,20,1,1,0,1),
(13029,13029,'',0,'',0,'LineageNPC2.skill_dummy_01_a','5','10',70,'etc','L2EffectPoint',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,20,1,1,0,1),
(13030,13030,'',0,'',0,'LineageNPC2.skill_dummy_01_a','5','10',70,'etc','L2EffectPoint',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,20,1,1,0,1),
(13031,13031,'Huge Pig',0,'',0,'LineageNPC2.E_pig_ball','15','18.3',80,'male','L2Npc',40,'680','2000','0','0.9',40,43,30,21,20,20,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,60,160,1,1,0,1),
(13032,13032,'Huge Pig',0,'',0,'LineageNPC2.E_pig_ball','15','18.3',80,'male','L2Npc',40,'680','2000','0','0.9',40,43,30,21,20,20,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,60,160,1,1,0,1),
(13033,13033,'Huge Pig',0,'',0,'LineageNPC2.E_pig_ball','15','18.3',80,'male','L2Npc',40,'680','2000','0','0.9',40,43,30,21,20,20,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,60,160,1,1,0,1),
(13034,13034,'Super Huge Pig',0,'',0,'LineageNPC2.E_pig_ball_H','29','38.7',80,'male','L2Monster',40,'3400','6000','0','0.9',40,43,30,21,20,20,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,60,160,1,1,0,1),
(13035,13035,'Golden Pig',0,'',0,'LineageNPC2.E_pig_ball','15','18.3',80,'male','L2Npc',40,'680','2000','0','0.9',40,43,30,21,20,20,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,60,160,1,1,0,1),
(13036,13036,'Alchemist\'s Chest',0,'',0,'LineageMonster.mimic_even','8.5','8.5',80,'male','L2Chest',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,20,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,80,1,1,1,0,1),
(13037,13037,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',28,'etc','L2Npc',40,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,0,0,'80.54056','111.61368','54.99876','81.67405',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13038,13038,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',36,'etc','L2Npc',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,0,0,'137.86467','140.57278','94.1437','102.86506',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13039,13039,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',43,'etc','L2Npc',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,0,0,'210.04832','169.13417','143.43577','123.76505',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13040,13040,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',49,'etc','L2Npc',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,0,0,'290.44588','195.66302','198.33688','143.17771',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13041,13041,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',55,'etc','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13042,13042,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',60,'etc','L2Npc',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,0,0,'481.34551','247.65008','328.69659','181.21958',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13043,13043,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',64,'etc','L2Npc',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,0,0,'562.02275','267.04468','383.78868','195.41171',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13044,13044,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',68,'etc','L2Npc',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,0,0,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13045,13045,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',72,'etc','L2Npc',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13046,13046,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',49,'etc','L2Npc',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,0,0,'290.44588','195.66302','198.33688','143.17771',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13047,13047,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',55,'etc','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13048,13048,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',60,'etc','L2Npc',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,0,0,'481.34551','247.65008','328.69659','181.21958',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13049,13049,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',64,'etc','L2Npc',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,0,0,'562.02275','267.04468','383.78868','195.41171',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13050,13050,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',68,'etc','L2Npc',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,0,0,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13051,13051,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',72,'etc','L2Npc',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13052,13052,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',55,'etc','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13053,13053,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',60,'etc','L2Npc',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,0,0,'481.34551','247.65008','328.69659','181.21958',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13054,13054,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',64,'etc','L2Npc',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,0,0,'562.02275','267.04468','383.78868','195.41171',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13055,13055,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',68,'etc','L2Npc',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,0,0,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13056,13056,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',72,'etc','L2Npc',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13057,13057,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',40,'etc','L2Npc',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,0,0,'176.36077','156.55035','120.43155','114.55675',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13058,13058,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',46,'etc','L2Npc',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,20,0,0,'248.0526','182.18816','169.38777','133.31739',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13059,13059,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',52,'etc','L2Npc',40,'1520.38155','804','6.5','2.4',40,43,30,21,20,20,0,0,'337.18867','209.50106','230.25615','153.30378',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13060,13060,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',58,'etc','L2Npc',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,20,0,0,'442.8992','237.99429','302.44274','174.1539',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13061,13061,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',62,'etc','L2Npc',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,0,0,'521.12391','257.34267','355.86007','188.3122',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13062,13062,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',66,'etc','L2Npc',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13063,13063,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',70,'etc','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13064,13064,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',74,'etc','L2Npc',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,0,0,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13065,13065,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',52,'etc','L2Npc',40,'1520.38155','804','6.5','2.4',40,43,30,21,20,20,0,0,'337.18867','209.50106','230.25615','153.30378',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13066,13066,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',58,'etc','L2Npc',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,20,0,0,'442.8992','237.99429','302.44274','174.1539',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13067,13067,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',62,'etc','L2Npc',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,0,0,'521.12391','257.34267','355.86007','188.3122',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13068,13068,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',66,'etc','L2Npc',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13069,13069,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',70,'etc','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13070,13070,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',74,'etc','L2Npc',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,0,0,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13071,13071,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.5','25',43,'etc','L2Decoy',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,0,0,'210.04832','169.13417','143.43577','123.76505',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13072,13072,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.5','25',52,'etc','L2Decoy',40,'1520.38155','804','6.5','2.4',40,43,30,21,20,20,0,0,'337.18867','209.50106','230.25615','153.30378',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13073,13073,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.5','25',60,'etc','L2Decoy',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,0,0,'481.34551','247.65008','328.69659','181.21958',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13074,13074,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.5','25',66,'etc','L2Decoy',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13075,13075,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.5','25',70,'etc','L2Decoy',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13076,13076,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.5','25',74,'etc','L2Decoy',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,0,0,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13077,13077,'Onyx Beast',0,'',0,'LineageMonster.onyx_beast','12','14.5',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,30,180,1,1,0,1),
(13078,13078,'Doom Wraith',0,'',0,'LineageMonster.death_blader_tr','13','25',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,100,180,1,1,0,1),
(13079,13079,'Grail Apostle',0,'',0,'LineageMonster3.apostle_grail_tr','10','35',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(13080,13080,'Grail Apostle',0,'',0,'LineageMonster2.apostle_warrior','8','30',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(13081,13081,'Unicorn',0,'',0,'LineageMonster.Unicorn_tr','15','28',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,46,180,1,1,0,1),
(13082,13082,'Lilim Knight',0,'',0,'LineageMonster4.lilim_knight_tr','12','25.5',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,56,180,1,1,0,1),
(13083,13083,'Golem Guardian',0,'',0,'LineageMonster3.golem_guardian_tr','13','25',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,53,180,1,1,0,1),
(13084,13084,'Inferno Drake',0,'',0,'LineageMonster2.inferno_drake_tr','15','24',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,57,180,1,1,0,1),
(13085,13085,'Dragon Bomber',0,'',0,'LineageMonster3.antaras_ex_b_tr','16','24',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,100,180,1,1,0,1),
(13086,13086,'Zariche',0,'',0,'LineageMonster4.Avatar_Z','12','31.5725',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,8190,0,0,80,180,1,1,0,1),
(13087,13087,'Akamanah',0,'',0,'LineageMonster4.Avatar_A','10','32.7295',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,8689,0,0,80,180,1,1,0,1),
(13088,13088,'Final Form',0,'',0,'LineageMonster4.Specular_Form','9','38',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(13089,13089,'Final Form',0,'',0,'LineageMonster4.Specular_Form_F','10','32.7615',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(13090,13090,'Native',0,'',0,'LineageNPC.a_common_peopleC_Mhuman','10','24',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(13091,13091,'Yeti',0,'',0,'LineageMonster.yeti','15','27.5',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,80,180,1,1,0,1),
(13092,13092,'Buffalo',0,'',0,'LineageMonster2.buffalo','22','31',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,80,180,1,1,0,1),
(13093,13093,'Pig',0,'',0,'LineageNPC2.E_pig_ball','15','18.3',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(13094,13094,'Zombie',0,'',0,'LineageMonster3.zombie_laborer','11','24.6',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,36,180,1,1,0,1),
(13095,13095,'Pixy',0,'',0,'LineageMonster.pixy','5','25',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,80,180,1,1,0,1),
(13096,13096,'Rabbit',0,'',0,'LineageMonster.rabbit','5','4.5',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(13097,13097,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',80,'male','L2Monster',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,20,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,1,1,1,1,0,1),
(13098,13098,'Event Treasure Chest',0,'',0,'LineageMonster.mimic_even','8.5','8.5',80,'male','L2EventChest',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,20,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,80,1,1,1,0,1),
(13099,13099,'Zaken',0,'',0,'LineageMonster.zaken_tr','16','32',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,42,180,1,1,0,1),
(13100,13100,'Anakim',0,'',0,'LineageMonster2.anakim_tr','15.5','29',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,45,180,1,1,0,1),
(13101,13101,'Benom',0,'',0,'LineageMonster3.benom_tr','20','56',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,79,180,1,1,0,1),
(13102,13102,'Gordon',0,'',0,'LineageMonster3.Cruel_Rider_tr','43','46.6',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(13103,13103,'Ranku',0,'',0,'LineageMonster4.LaneCoo_tr','13','29',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,26,180,1,1,0,1),
(13104,13104,'Kiyachi',0,'',0,'LineageMonster4.Keyache_tr','12','29',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,26,180,1,1,0,1),
(13105,13105,'Demon Prince',0,'',0,'LineageMonster4.rahuu_tr','33','49',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(13106,13106,'Heretic Male',0,'',0,'LineageMonster3.heretic_privates_tr','7.7','28.4',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(13107,13107,'Heretic Female',0,'',0,'LineageMonster3.heretic_priest_tr','8','19.1',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,30,180,1,1,0,1),
(13108,13108,'Vale master',0,'',0,'LineageMonster.vale_master_tr','12','40',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,70,180,1,1,0,1),
(13109,13109,'Saber Tooth Tiger',0,'',0,'LineageMonster.saber_toothed_tiger_tr','34','28',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,8190,0,0,60,180,1,1,0,1),
(13110,13110,'Ol Mahum',0,'',0,'LineageMonster.oel_mahum_champion_tr','23','61',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,8689,0,0,67,180,1,1,0,1),
(13111,13111,'Doll Blader',0,'',0,'LineageMonster.doll_blader_tr','6','12',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,22,180,1,1,0,1),
(13112,13112,'Divine Knight',0,'',0,'LineageMonster4.Divine_tanker','16','30',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,49,180,1,1,0,1),
(13113,13113,'Divine Warrior',0,'',0,'LineageMonster4.Divine_Warrior','14.5','29',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,46,180,1,1,0,1),
(13114,13114,'Divine Rogue',0,'',0,'LineageMonster4.Divine_Rogue','10','28',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(13115,13115,'Divine Healer',0,'',0,'LineageMonster4.Divine_healer','10','25',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(13116,13116,'Divine Wizard',0,'',0,'LineageMonster4.Divine_Wizard','10','26',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(13117,13117,'Divine Enchanter',0,'',0,'LineageMonster4.Divine_enchanter','8','18.25',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(13118,13118,'Divine Summoner',0,'',0,'LineageMonster4.Divine_healer','10','25',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(13119,13119,'Dwarf Golem',0,'',0,'LineageMonster3.chaos_golem_tr','31','51.8',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,18,180,1,1,0,1),
(13120,13120,'Giant rat',0,'',0,'LineageMonster4.little_mouse_120p','15','20',80,'male','L2Npc',40,'680','2000','0','0.9',40,43,30,21,20,20,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,19.5,160,1,1,0,1),
(13121,13121,'Giant rat',0,'',0,'LineageMonster4.little_mouse_120p','15','20',80,'male','L2Npc',40,'680','2000','0','0.9',40,43,30,21,20,20,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,19.5,160,1,1,0,1),
(13122,13122,'Giant rat',0,'',0,'LineageMonster4.little_mouse_120p','15','20',80,'male','L2Npc',40,'680','2000','0','0.9',40,43,30,21,20,20,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,19.5,160,1,1,0,1),
(13123,13123,'Super giant rat',0,'',0,'LineageMonster4.little_mouse_180p','19','33',80,'male','L2Npc',40,'3400','6000','0','0.9',40,43,30,21,20,20,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,28.5,160,1,1,0,1),
(13124,13124,'Giant rat',0,'Mr. Bashful',0,'LineageMonster4.little_mouse_120p','15','20',80,'male','L2Npc',40,'680','2000','0','0.9',40,43,30,21,20,20,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,19.5,160,1,1,0,1),
(13125,13125,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',64,'etc','L2Npc',40,'2244.67715','1219.8','0','0.9',40,43,30,21,20,20,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,50,1,1,1,0,1),
(13126,13126,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',64,'etc','L2Npc',40,'2444.46819','1345.8','0','0.9',40,43,30,21,20,20,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,50,1,1,1,0,1),
(13127,13127,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',68,'etc','L2Npc',40,'2632.19636','1475','0','0.9',40,43,30,21,20,20,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,50,1,1,1,0,1),
(13128,13128,'Golem Trader',0,'',0,'LineageNPC.e_teleporter_FDwarf','8','21.3',70,'female','L2MerchantSummon',40,'2632.19636','1475','0','0.9',40,43,30,21,20,20,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,50,1,1,1,0,1),
(13129,13129,'Teleporter',0,'',0,'LineageNPC.a_teleporter_FHuman','8','25',55,'female','L2Npc',40,'1673.05473','889.8','0','0.9',40,43,30,21,20,25,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,50,180,1,1,0,1),
(13130,13130,'Light Purple Maned Horse',0,'',0,'LineageMonster4.gray_horse','31','32.5',55,'female','L2Npc',40,'1673.05473','889.8','0','0.9',40,43,30,21,20,25,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,41,180,1,1,0,1),
(13131,13131,'Grizzly Bear',0,'',0,'LineageMonster.grizzly','21','40',55,'male','L2Npc',40,'1673.05473','889.8','0','0.9',40,43,30,21,20,25,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,40,180,1,1,0,1),
(13132,13132,'Timitran',0,'',0,'LineageMonster.ti_mi_tran','23','90',55,'male','L2Npc',40,'1673.05473','889.8','0','0.9',40,43,30,21,20,25,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,12,180,1,1,0,1),
(13133,13133,'Lava Golem',0,'',0,'LineageMonster2.lava_golem','38','45',55,'male','L2Npc',40,'1673.05473','889.8','0','0.9',40,43,30,21,20,25,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,13,180,1,1,0,1),
(13134,13134,'Yeti',0,'',0,'LineageMonster.yeti_20_bi','18','32',55,'male','L2Npc',40,'1673.05473','889.8','0','0.9',40,43,30,21,20,25,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,16,180,1,1,0,1),
(13135,13135,'Pumpkin Ghost',0,'',0,'LineageNpc2.Pumpkin_Head_man','12','18',55,'male','L2Npc',40,'1673.05473','889.8','0','0.9',40,43,30,21,20,25,0,0,'8.47458','60000','5.78704','200000',253,1,0,333,0,0,0,60,180,1,1,0,1),
(13136,13136,'',0,'',0,'LineageNpcEV.battle_banner','0.01','36',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,0,180,0,0,0,1),
(13137,13137,'',0,'',0,'LineageNpcEV.battle_banner','0.01','36',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,0,180,0,0,0,1),
(13138,13138,'',0,'',0,'LineageNpcEV.battle_banner','0.01','36',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,0,180,0,0,0,1),
(13139,13139,'',0,'',0,'LineageNpcEV.battle_banner','0.01','36',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,0,180,0,0,0,1),
(13140,13140,'',0,'',0,'LineageNpcEV.battle_banner','0.01','36',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,0,180,0,0,0,1),
(13141,13141,'',0,'',0,'LineageNpcEV.battle_banner','0.01','36',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,0,180,0,0,0,1),
(13142,13142,'Final Form',0,'',0,'LineageMonster4.Specular_Form_air','9','38',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(13143,13143,'Final Form',0,'',0,'LineageMonster4.Specular_Form_F_air','10','32.7',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(13144,13144,'Aurabird-Falcon',0,'',0,'LineageMonster4.closed_attacker','38','14.25',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,100,180,1,1,0,1),
(13145,13145,'Aurabird-Owl',0,'',0,'LineageMonster4.heavy_shooter','40','19',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,100,180,1,1,0,1),
(13146,13146,'Tawny-Maned Lion',0,'',0,'LineageMonster4.tawny_maned_lion','25','22.5',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,43,180,1,1,0,1),
(13147,13147,'Steam Sledge',0,'',0,'LineageMonster4.steam_sledge','40','27.5',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,40,180,1,1,0,1),
(13148,13148,'Lindvior',0,'',0,'LineageMonster4.lindvior_air','190','390.6',55,'female','L2FlyMonster',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,100,180,0,0,0,1),
(13149,13149,'For Presentation 1',0,'',0,'LineageNPC.clear_npc','0.1','0.1',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,10,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,160,0,0,0,1),
(13150,13150,'For Presentation 2',0,'',0,'LineageNPC.clear_npc','0.1','0.1',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,10,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,160,0,0,0,1),
(13151,13151,'For Presentation 3',0,'',0,'LineageNPC.clear_npc','0.1','0.1',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,10,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,160,0,0,0,1),
(13152,13152,'For Presentation 4',0,'',0,'LineageNPC.clear_npc','0.1','0.1',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,10,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,160,0,0,0,1),
(13153,13153,'For Presentation 5',0,'',0,'LineageNPC.clear_npc','0.1','0.1',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,10,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,160,0,0,0,1),
(13154,13154,'Demon Race',0,'',0,'LineageMonster4.summoner_demon_tr','11','27',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,0,1,0,1),
(13155,13155,'Unicorniun',0,'',0,'LineageMonster4.summoner_unicorn_tr','8','30',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,0,0,1),
(13156,13156,'Myo Race',0,'',0,'LineageMonster4.summoner_cat_tr','10','23',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,80,180,0,0,0,1),
(13157,13157,'Frog',0,'',0,'LineageMonster.poison_toad','20','10',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(13158,13158,'Young Child',0,'',0,'LineageNPC2.a_child_people_Mhuman','5','12.3',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,26,180,1,1,0,1),
(13159,13159,'Mercenary',0,'',0,'LineageNPC.a_fighterguild_master_Mhuman','8','23.5',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(13160,13160,'Snowman',0,'',0,'LineageNpc2.snow_man','28','30',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,1),
(13161,13161,'Scarecrow',0,'',0,'LineageNpc2.scarecrow','13','30',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,23,180,1,1,0,1),
(13162,13162,'Tin Plate Golem',0,'',0,'LineageNpc2.tin_golem','13','18.5',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,13,180,1,1,0,1),
(13163,13163,'Tow',0,'',0,'LineageNPC2.tow','4.4','8.25',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,155,180,1,1,0,1),
(13164,13164,'Lure Tow',0,'',0,'LineageNPC2.tow_lure','4.4','8.25',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,155,180,1,1,0,1),
(13165,13165,'Heavy Tow',0,'',0,'LineageNPC2.tow_heavy','4.4','8.25',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,165,180,1,1,0,1),
(13166,13166,'Wing Tow',0,'',0,'LineageNPC2.tow_whim','4.4','8.25',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,140,180,1,1,0,1),
(13167,13167,'Main Role A',0,'',0,'LineageNPC2.tp_actor','9','28.3',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,4,180,1,1,0,1),
(13168,13168,'Main Role B',0,'',0,'LineageNPC2.tp_actor','9','28.3',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,4,180,1,1,0,1),
(13169,13169,'Human Male Mercenary',0,'',0,'LineageNPC.a_guard_MHuman','8','24',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(13170,13170,'Male Elf Mercenary',0,'',0,'LineageNPC.a_guard_MElf','8','23.5',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(13171,13171,'Dark Elf Female Mercenary',0,'',0,'LineageNPC.a_guard_FDarkelf','7','25',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(13172,13172,'Orc Male Mercenary',0,'',0,'LineageNPC.e_guard_MOrc','8','27',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(13173,13173,'Dwarf Male Mercenary',0,'',0,'LineageNPC.e_guard_MDwarf','8','19',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(13174,13174,'Kamael Male Mercenary',0,'',0,'LineageNPC2.K_M1_guard','13','25',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,39,180,1,1,0,1),
(13175,13175,'Knight Level Mercenary',0,'',0,'LineageNPC.a_royal_guardA_MHuman','7','24',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(13176,13176,'Archer Level Mercenary',0,'',0,'LineageNPC2.archer_of_insurgents','10','23.5',55,'male','L2Npc',1100,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,8,0,333,15302,0,0,30,180,1,1,0,1),
(13177,13177,'Wizard Level Mercenary',0,'',0,'LineageNPC2.mage_of_insurgents','9','23.5',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,28,180,1,1,0,1),
(13178,13178,'Trooper Level Mercenary',0,'',0,'LineageNPC2.K_F1_guard_Master','13','22.5',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,48,180,1,1,0,1),
(13179,13179,'Knight Leader Elite Mercenary',0,'',0,'LineageMonster3.Kight_of_Dawn','12','24.5',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,36.48,180,1,1,0,1),
(13180,13180,'Commander Elite Mercenary',0,'',0,'LineageNPC2.chief_of_insurgents','10','26.985',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,29.8,180,1,1,0,1),
(13181,13181,'Treasure Box',0,'Gracia',0,'LineageMonster.mimic_even','8.5','8.5',80,'male','L2Chest',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,80,1,1,1,0,1),
(13182,13182,'Free Gift Merchant',0,'Gracia',0,'LineageMonster.silver_cat','7','15',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,48,120,1,1,0,1),
(13183,13183,'Thomas D. Turkey',0,'',0,'LineageNpc2.crazy_turkey','25','34',80,'female','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,120,1,1,0,1),
(13184,13184,'Santa Claus',0,'',0,'LineageNPC2.santa_claus','10','21',80,'male','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,120,0,1,0,1),
(13185,13185,'Santa Claus',0,'',0,'LineageNPC2.santa_claus_120p','12','25',80,'male','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,120,0,1,0,1),
(13186,13186,'Santa Claus',0,'',0,'LineageNPC2.santa_sled','0.01','50',80,'female','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,55,0,0,0,1),
(13187,13187,'Milk Cow',0,'',0,'LineageMonster4.milk_cow','16','12.5',85,'male','L2Npc',40,'601.26582278481','1846.8','0','3',40,43,30,21,20,20,0,0,'1188.87259499001','60000','5.78704','200000',253,1,0,333,0,0,0,25,120,1,1,0,1),
(13188,13188,'Head Milk Cow',0,'',0,'LineageMonster4.milk_cow_200p','26','28.5',85,'male','L2Npc',40,'7563.29113924051','1846.8','0','3',40,43,30,21,20,20,0,0,'1188.87259499001','60000','5.78704','200000',253,1,0,333,0,0,0,45,180,1,1,0,1),
(13189,13189,'Bull',0,'',0,'LineageMonster4.yellow_cow','16','12.5',85,'male','L2Npc',40,'601.26582278481','1846.8','0','3',40,43,30,21,20,20,0,0,'1188.87259499001','60000','5.78704','200000',253,1,0,333,0,0,0,25,120,1,1,0,1),
(13190,13190,'Head Bull',0,'',0,'LineageMonster4.yellow_cow_200p','26','28.5',85,'male','L2Npc',40,'7563.29113924051','1846.8','0','3',40,43,30,21,20,20,0,0,'1188.87259499001','60000','5.78704','200000',253,1,0,333,0,0,0,45,180,1,1,0,1),
(13191,13191,'Gloomy Milk Cow',0,'',0,'LineageMonster4.milk_cow_e','16','12.5',85,'male','L2Npc',40,'601.26582278481','1846.8','0','3',40,43,30,21,20,20,0,0,'1188.87259499001','60000','5.78704','200000',253,1,0,333,0,0,0,25,120,1,1,0,1),
(13192,13192,'Gloomy Head Milk Cow',0,'',0,'LineageMonster4.milk_cow_200p_e','26','28.5',85,'male','L2Npc',40,'7563.29113924051','1846.8','0','3',40,43,30,21,20,20,0,0,'1188.87259499001','60000','5.78704','200000',253,1,0,333,0,0,0,45,180,1,1,0,1),
(13193,13193,'',0,'',0,'LineageNpcEV.obelisk_of_middle_square','229','177.5',55,'female','L2Npc',40,'1673.05473','889.8','0','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,1,180,0,1,0,1),
(13194,13194,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',85,'male','L2Npc',40,'4234.06312688557','1846.8','0','3',40,43,30,21,20,20,0,0,'1188.87259499001','60000','5.78704','200000',253,1,0,333,0,0,0,1,120,1,1,0,1),
(13195,13195,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',85,'male','L2Npc',40,'4234.06312688557','1846.8','0','3',40,43,30,21,20,20,0,0,'1188.87259499001','60000','5.78704','200000',253,1,0,333,0,0,0,1,120,1,1,0,1),
(13196,13196,'Great Pig',0,'Mis-summoned',0,'LineageNPC2.E_pig_ball','15','18.3',85,'male','L2Npc',40,'7563.29113924051','1846.8','0','3',40,43,30,21,20,20,0,0,'1188.87259499001','60000','5.78704','200000',253,1,0,333,0,0,0,60,120,1,1,0,1),
(13197,13197,'Guardian\'s Strider',0,'',0,'LineageNPC.training_doll_150p','13','40',55,'etc','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(13198,13198,'Native',0,'',0,'LineageNPC.a_common_peopleC_Mhuman','10','24',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(13199,13199,'Native',0,'',0,'LineageNPC.a_common_peopleB_FHuman','8','20.5',79,'female','L2Npc',40,'3127.82459333517','1641','8.5','3',40,43,30,21,20,25,0,0,'929.930814318487','337.07008','635.022195830619','246.65326',253,4,0,333,0,0,0,50,180,1,1,0,1),
(13200,13200,'Young Child',0,'',0,'LineageNPC2.a_child_people_Fhuman','5','12.3',79,'female','L2Npc',40,'3127.82459333517','1641','8.5','3',40,43,30,21,20,25,0,0,'929.930814318487','337.07008','635.022195830619','246.65326',253,4,0,333,0,0,0,24,180,1,1,0,1),
(13201,13201,'Guards of the Dawn',0,'',0,'LineageNPC.a_fighterguild_master_FHuman','8','21.5',79,'female','L2Npc',40,'3127.82459333517','1641','8.5','3',40,43,30,21,20,25,0,0,'929.930814318487','337.07008','635.022195830619','246.65326',253,4,0,333,0,0,0,50,180,1,1,0,1),
(13202,13202,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',76,'etc','L2Npc',40,'2758.05923328','1540.8','8.5','3',40,43,30,21,20,20,0,0,'824.422073095','323.78455','562.9734023','236.93149',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13203,13203,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',77,'etc','L2Npc',40,'2856.7687256316','1574','8.5','3',40,43,30,21,20,20,0,0,'856.44055895414','328.27073','584.837886935576','240.21427',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13204,13204,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',78,'etc','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13205,13205,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',79,'etc','L2Npc',40,'3127.82459333517','1641','8.5','3',40,43,30,21,20,20,0,0,'929.930814318487','337.07008','635.022195830619','246.65326',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13206,13206,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13207,13207,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',81,'etc','L2Npc',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1012.32268463427','345.61127','691.285164307598','252.90333',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13208,13208,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',82,'etc','L2Npc',40,'3643.38976668326','1743','8.5','3',40,43,30,21,20,20,0,0,'1055.28566004965','349.77477','720.623302603812','255.95',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13209,13209,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',83,'etc','L2Npc',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13210,13210,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',84,'etc','L2Npc',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13211,13211,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',85,'etc','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13212,13212,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',86,'etc','L2Npc',40,'4439.74358540587','1881.8','8.5','3',40,43,30,21,20,20,0,0,'1233.98508337826','365.6202','842.651845283929','267.545',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13213,13213,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',76,'etc','L2Npc',40,'2758.05923328','1540.8','8.5','3',40,43,30,21,20,20,0,0,'824.422073095','323.78455','562.9734023','236.93149',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13214,13214,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',77,'etc','L2Npc',40,'2856.7687256316','1574','8.5','3',40,43,30,21,20,20,0,0,'856.44055895414','328.27073','584.837886935576','240.21427',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13215,13215,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',78,'etc','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13216,13216,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',79,'etc','L2Npc',40,'3127.82459333517','1641','8.5','3',40,43,30,21,20,20,0,0,'929.930814318487','337.07008','635.022195830619','246.65326',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13217,13217,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13218,13218,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',81,'etc','L2Npc',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1012.32268463427','345.61127','691.285164307598','252.90333',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13219,13219,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',82,'etc','L2Npc',40,'3643.38976668326','1743','8.5','3',40,43,30,21,20,20,0,0,'1055.28566004965','349.77477','720.623302603812','255.95',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13220,13220,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',83,'etc','L2Npc',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13221,13221,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',84,'etc','L2Npc',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13222,13222,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',85,'etc','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13223,13223,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',86,'etc','L2Npc',40,'4439.74358540587','1881.8','8.5','3',40,43,30,21,20,20,0,0,'1233.98508337826','365.6202','842.651845283929','267.545',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13224,13224,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',76,'etc','L2Npc',40,'2758.05923328','1540.8','8.5','3',40,43,30,21,20,20,0,0,'824.422073095','323.78455','562.9734023','236.93149',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13225,13225,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',77,'etc','L2Npc',40,'2856.7687256316','1574','8.5','3',40,43,30,21,20,20,0,0,'856.44055895414','328.27073','584.837886935576','240.21427',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13226,13226,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',78,'etc','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13227,13227,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',79,'etc','L2Npc',40,'3127.82459333517','1641','8.5','3',40,43,30,21,20,20,0,0,'929.930814318487','337.07008','635.022195830619','246.65326',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13228,13228,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13229,13229,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',81,'etc','L2Npc',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1012.32268463427','345.61127','691.285164307598','252.90333',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13230,13230,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',82,'etc','L2Npc',40,'3643.38976668326','1743','8.5','3',40,43,30,21,20,20,0,0,'1055.28566004965','349.77477','720.623302603812','255.95',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13231,13231,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',83,'etc','L2Npc',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13232,13232,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',84,'etc','L2Npc',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13233,13233,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',85,'etc','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13234,13234,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',86,'etc','L2Npc',40,'4439.74358540587','1881.8','8.5','3',40,43,30,21,20,20,0,0,'1233.98508337826','365.6202','842.651845283929','267.545',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13235,13235,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',76,'etc','L2Npc',40,'2758.05923328','1540.8','8.5','3',40,43,30,21,20,20,0,0,'824.422073095','323.78455','562.9734023','236.93149',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13236,13236,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',77,'etc','L2Npc',40,'2856.7687256316','1574','8.5','3',40,43,30,21,20,20,0,0,'856.44055895414','328.27073','584.837886935576','240.21427',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13237,13237,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',78,'etc','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13238,13238,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',79,'etc','L2Npc',40,'3127.82459333517','1641','8.5','3',40,43,30,21,20,20,0,0,'929.930814318487','337.07008','635.022195830619','246.65326',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13239,13239,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13240,13240,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',81,'etc','L2Npc',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1012.32268463427','345.61127','691.285164307598','252.90333',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13241,13241,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',82,'etc','L2Npc',40,'3643.38976668326','1743','8.5','3',40,43,30,21,20,20,0,0,'1055.28566004965','349.77477','720.623302603812','255.95',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13242,13242,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',83,'etc','L2Npc',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13243,13243,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',84,'etc','L2Npc',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13244,13244,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',85,'etc','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13245,13245,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',86,'etc','L2Npc',40,'4439.74358540587','1881.8','8.5','3',40,43,30,21,20,20,0,0,'1233.98508337826','365.6202','842.651845283929','267.545',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13246,13246,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',76,'etc','L2Npc',40,'2758.05923328','1540.8','8.5','3',40,43,30,21,20,20,0,0,'824.422073095','323.78455','562.9734023','236.93149',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13247,13247,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',77,'etc','L2Npc',40,'2856.7687256316','1574','8.5','3',40,43,30,21,20,20,0,0,'856.44055895414','328.27073','584.837886935576','240.21427',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13248,13248,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',78,'etc','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13249,13249,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',79,'etc','L2Npc',40,'3127.82459333517','1641','8.5','3',40,43,30,21,20,20,0,0,'929.930814318487','337.07008','635.022195830619','246.65326',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13250,13250,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13251,13251,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',81,'etc','L2Npc',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1012.32268463427','345.61127','691.285164307598','252.90333',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13252,13252,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',82,'etc','L2Npc',40,'3643.38976668326','1743','8.5','3',40,43,30,21,20,20,0,0,'1055.28566004965','349.77477','720.623302603812','255.95',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13253,13253,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',83,'etc','L2Npc',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13254,13254,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',84,'etc','L2Npc',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13255,13255,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',85,'etc','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13256,13256,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',86,'etc','L2Npc',40,'4439.74358540587','1881.8','8.5','3',40,43,30,21,20,20,0,0,'1233.98508337826','365.6202','842.651845283929','267.545',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13257,13257,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.5','25',76,'etc','L2Decoy',40,'2758.05923328','1540.8','8.5','3',40,43,30,21,20,20,0,0,'824.422073095','323.78455','562.9734023','236.93149',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13258,13258,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.5','25',77,'etc','L2Decoy',40,'2856.7687256316','1574','8.5','3',40,43,30,21,20,20,0,0,'856.44055895414','328.27073','584.837886935576','240.21427',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13259,13259,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.5','25',78,'etc','L2Decoy',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13260,13260,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.5','25',79,'etc','L2Decoy',40,'3127.82459333517','1641','8.5','3',40,43,30,21,20,20,0,0,'929.930814318487','337.07008','635.022195830619','246.65326',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13261,13261,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.5','25',80,'etc','L2Decoy',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13262,13262,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.5','25',81,'etc','L2Decoy',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1012.32268463427','345.61127','691.285164307598','252.90333',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13263,13263,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.5','25',82,'etc','L2Decoy',40,'3643.38976668326','1743','8.5','3',40,43,30,21,20,20,0,0,'1055.28566004965','349.77477','720.623302603812','255.95',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13264,13264,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.5','25',83,'etc','L2Decoy',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13265,13265,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.5','25',84,'etc','L2Decoy',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13266,13266,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.5','25',85,'etc','L2Decoy',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13267,13267,'Virtual Image',0,'',0,'LineageNPC2.Decoy_Medium','8.5','25',86,'etc','L2Decoy',40,'4439.74358540587','1881.8','8.5','3',40,43,30,21,20,20,0,0,'1233.98508337826','365.6202','842.651845283929','267.545',253,4,0,333,0,0,0,50,1,1,1,0,1),
(13268,13268,'Aqua Elf',0,'',0,'LineageNPC2.bikini_elf','12','27.5',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(13269,13269,'Hot Weather',0,'',0,'LineageMonster5.event_the_heat','9','14.5',80,'male','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'10','60000','662.751329129412','200000',253,4,0,333,0,0,0,30,160,1,1,0,1),
(13270,13270,'Sultriness',0,'',0,'LineageMonster5.event_terrible_heat','30','53.5',80,'male','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'10','60000','662.751329129412','200000',253,4,0,333,0,0,0,30,160,1,1,0,1),
(13271,13271,'Young Watermelon',0,'',0,'LineageNPC2.event_unripe_watermelon','11','22',1,'etc','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,10,0,0,'8.47458','44.44444','5.78704','32.52252',253,1,0,333,0,0,0,50,100,1,1,0,1),
(13272,13272,'Defective Watermelon',0,'',0,'LineageNPC2.event_bad_watermelon','14','30',1,'etc','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,10,0,0,'8.47458','44.44444','5.78704','32.52252',253,1,0,333,0,0,0,50,100,1,1,0,1),
(13273,13273,'Rain Watermelon',0,'',0,'LineageNPC2.event_good_watermelon','17','35',1,'etc','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,10,0,0,'8.47458','44.44444','5.78704','32.52252',253,1,0,333,0,0,0,50,100,1,1,0,1),
(13274,13274,'Large Rain Watermelon',0,'',0,'LineageNPC2.event_king_watermelon','30','65',1,'etc','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,10,0,0,'8.47458','44.44444','5.78704','32.52252',253,1,0,333,0,0,0,50,100,1,1,0,1),
(13275,13275,'Young Honey Watermelon',0,'',0,'LineageNPC2.event_big_watermelon','10','20',1,'etc','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,10,0,0,'8.47458','44.44444','5.78704','32.52252',253,1,0,333,0,0,0,50,100,1,1,0,1),
(13276,13276,'Defective Honey Watermelon',0,'',0,'LineageNPC2.event_bad_big_watermelon','20','40',1,'etc','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,10,0,0,'8.47458','44.44444','5.78704','32.52252',253,1,0,333,0,0,0,50,100,1,1,0,1),
(13277,13277,'Rain Honey Watermelon',0,'',0,'LineageNPC2.event_good_big_watermelon','26','52',1,'etc','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,10,0,0,'8.47458','44.44444','5.78704','32.52252',253,1,0,333,0,0,0,50,100,1,1,0,1),
(13278,13278,'Large Rain Honey Watermelon',0,'',0,'LineageNPC2.event_king_big_watermelon','30','60',1,'etc','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,10,0,0,'8.47458','44.44444','5.78704','32.52252',253,1,0,333,0,0,0,50,100,1,1,0,1),
(13279,13279,'Uldie',0,'',0,'LineageMonster4.wooldie','8','17',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,10,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,18,160,1,1,0,1),
(13280,13280,'Belldandy',0,'',0,'LineageMonster4.berdandi','9','20.5',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,22,174,1,1,0,1),
(13281,13281,'Skooldie',0,'Event manager',0,'LineageMonster4.scooldie','8','12.8',80,'male','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,15,160,1,1,0,1),
(13282,13282,'Skooldie',0,'',0,'LineageMonster4.scooldie','8','12.8',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,15,160,1,1,0,1),
(13283,13283,'Treykan',0,'',0,'LineageMonster5.traikan','25','27',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,88,180,1,1,0,1),
(13284,13284,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',80,'male','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,1,1,0,0,0,1),
(13285,13285,'Santa Claus',0,'Event manager',0,'LineageNPC2.santa_claus_120p','12','25',80,'male','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,120,1,1,0,1),
(13286,13286,'Baby White Tiger',0,'',0,'LineageMonster2.baby_tiger_e','8','15.7',85,'male','L2Npc',40,'601.26582278481','1846.8','0','3',40,43,30,21,20,20,0,0,'1188.87259499001','60000','5.78704','200000',253,1,0,333,0,0,0,28,120,1,1,0,1),
(13287,13287,'Baby White Tiger Captain',0,'',0,'LineageMonster2.baby_tiger_200p_e','22','29.5',85,'male','L2Npc',40,'7563.29113924051','1846.8','0','3',40,43,30,21,20,20,0,0,'1188.87259499001','60000','5.78704','200000',253,1,0,333,0,0,0,28,180,1,1,0,1),
(13288,13288,'Gloomy Baby White Tiger',0,'',0,'LineageMonster2.baby_tiger_de','8','15.7',85,'male','L2Npc',40,'601.26582278481','1846.8','0','3',40,43,30,21,20,20,0,0,'1188.87259499001','60000','5.78704','200000',253,1,0,333,0,0,0,28,120,1,1,0,1),
(13289,13289,'Gloomy Baby White Tiger Captain',0,'',0,'LineageMonster2.baby_tiger_200p_de','22','29.5',85,'male','L2Npc',40,'7563.29113924051','1846.8','0','3',40,43,30,21,20,20,0,0,'1188.87259499001','60000','5.78704','200000',253,1,0,333,0,0,0,28,180,1,1,0,1),
(13290,13290,'White Tiger',0,'',0,'LineageMonster2.youth_tiger_e','16','17.2',85,'male','L2Npc',40,'601.26582278481','1846.8','0','3',40,43,30,21,20,20,0,0,'1188.87259499001','60000','5.78704','200000',253,1,0,333,0,0,0,60,120,1,1,0,1),
(13291,13291,'White Tiger Captain',0,'',0,'LineageMonster2.youth_tiger_200p_e','50','34',85,'male','L2Npc',40,'7563.29113924051','1846.8','0','3',40,43,30,21,20,20,0,0,'1188.87259499001','60000','5.78704','200000',253,1,0,333,0,0,0,60,180,1,1,0,1),
(13292,13292,'Employee of Magic Research Institute',0,'Event manager',0,'LineageNPC.e_smith_Fdwarf','8','17.5',75,'female','L2Npc',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,0,0,'794.70901','319.24623','542.68324','233.61053',253,4,0,333,313,0,0,50,120,1,1,0,1),
(13293,13293,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',85,'male','L2Npc',40,'4234.06312688557','1846.8','0','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,1,0,333,0,0,0,1,120,1,1,0,1),
(13294,13294,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',85,'male','L2Npc',40,'4234.06312688557','1846.8','0','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,1,0,333,0,0,0,1,120,1,1,0,1),
(13295,13295,'Shining White',0,'Event manager',0,'LineageNPC.e_smith_Fdwarf','8','17.5',80,'female','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,160,1,1,0,1),
(13296,13296,'Freya',0,'Event manager',0,'LineageMonster5.freya_small','18','36',80,'female','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,54,160,1,1,0,1),
(14001,14001,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',46,'male','L2Pet',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,25,0,0,'248.0526','182.18816','169.38777','133.31739',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14002,14002,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',54,'male','L2Pet',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,25,0,0,'370.68904','218.89589','253.13256','160.17851',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14003,14003,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',62,'male','L2Pet',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,25,0,0,'521.12391','257.34267','355.86007','188.3122',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14004,14004,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',66,'male','L2Pet',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,25,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14005,14005,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',70,'male','L2Pet',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,25,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14006,14006,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',74,'male','L2Pet',40,'2632.19636','1475','8.5','3',40,43,30,21,20,25,0,0,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14007,14007,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',76,'male','L2Pet',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,25,0,0,'815.37145','323.78455','556.793','236.93149',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14008,14008,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',78,'male','L2Pet',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14009,14009,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',78,'male','L2Pet',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','333.7929775','587.770295','244.2552175',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14010,14010,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',78,'male','L2Pet',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','334.885345','591.13065','245.054565',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14011,14011,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',78,'male','L2Pet',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','335.9777125','594.491005','245.8539125',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14012,14012,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',79,'male','L2Pet',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14013,14013,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',79,'male','L2Pet',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','338.1624475','601.211715','247.4526075',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14014,14014,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',79,'male','L2Pet',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','339.254815','604.57207','248.251955',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14015,14015,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',79,'male','L2Pet',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','340.3471825','607.932425','249.0513025',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14016,14016,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14017,14017,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',80,'male','L2Pet',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','342.45123','614.2922725','250.5909475',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14018,14018,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',80,'male','L2Pet',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','343.52746','617.580455','251.378485',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14019,14019,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',80,'male','L2Pet',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','344.60369','620.8686375','252.1660225',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14020,14020,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',81,'male','L2Pet',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','345.61127','623.83518','252.90333',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14021,14021,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',81,'male','L2Pet',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','346.6703375','627.0429525','253.67831',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14022,14022,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',81,'male','L2Pet',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','347.729405','630.250725','254.45329',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14023,14023,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',81,'male','L2Pet',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','348.7884725','633.4584975','255.22827',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14024,14024,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',82,'male','L2Pet',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14025,14025,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',82,'male','L2Pet',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','350.815645','639.431055','256.7116675',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14026,14026,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',82,'male','L2Pet',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','351.85652','642.55023','257.473335',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14027,14027,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',82,'male','L2Pet',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','352.897395','645.669405','258.2350025',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14028,14028,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',83,'male','L2Pet',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14029,14029,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',83,'male','L2Pet',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','354.8831075','651.4242925','259.6880625',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14030,14030,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',83,'male','L2Pet',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','355.904775','654.446775','260.435675',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14031,14031,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',83,'male','L2Pet',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','356.9264425','657.4692575','261.1832875',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14032,14032,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',84,'male','L2Pet',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','357.86723','660.07304','261.87171',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14033,14033,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',84,'male','L2Pet',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','358.8686775','662.9908475','262.604525',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14034,14034,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',84,'male','L2Pet',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','359.870125','665.908655','263.33734',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14035,14035,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',85,'male','L2Pet',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14036,14036,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',85,'male','L2Pet',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','363.09511','675.034693333333','265.697243333333',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14037,14037,'Reanimated Man',0,'',0,'LineageMonster.skeleton','11','25',85,'male','L2Pet',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,60,140,1,1,0,1),
(14038,14038,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',42,'male','L2Pet',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,25,0,0,'198.34591','164.88513','135.44454','120.65578',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14039,14039,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',50,'male','L2Pet',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,25,0,0,'305.54906','200.23844','208.6504','146.5258',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14040,14040,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',58,'male','L2Pet',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,25,0,0,'442.8992','237.99429','302.44274','174.1539',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14041,14041,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',64,'male','L2Pet',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,25,0,0,'562.02275','267.04468','383.78868','195.41171',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14042,14042,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',68,'male','L2Pet',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,25,0,0,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14043,14043,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',72,'male','L2Pet',40,'2540.15331','1410','8.5','3',40,43,30,21,20,25,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14044,14044,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',78,'male','L2Pet',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14045,14045,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',78,'male','L2Pet',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','333.7929775','587.770295','244.2552175',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14046,14046,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',78,'male','L2Pet',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','334.885345','591.13065','245.054565',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14047,14047,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',78,'male','L2Pet',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','335.9777125','594.491005','245.8539125',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14048,14048,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',79,'male','L2Pet',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14049,14049,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',79,'male','L2Pet',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','338.1624475','601.211715','247.4526075',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14050,14050,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',79,'male','L2Pet',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','339.254815','604.57207','248.251955',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14051,14051,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',79,'male','L2Pet',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','340.3471825','607.932425','249.0513025',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14052,14052,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14053,14053,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',80,'male','L2Pet',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','342.45123','614.2922725','250.5909475',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14054,14054,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',80,'male','L2Pet',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','343.52746','617.580455','251.378485',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14055,14055,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',80,'male','L2Pet',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','344.60369','620.8686375','252.1660225',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14056,14056,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',81,'male','L2Pet',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','345.61127','623.83518','252.90333',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14057,14057,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',81,'male','L2Pet',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','346.6703375','627.0429525','253.67831',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14058,14058,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',81,'male','L2Pet',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','347.729405','630.250725','254.45329',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14059,14059,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',81,'male','L2Pet',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','348.7884725','633.4584975','255.22827',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14060,14060,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',82,'male','L2Pet',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14061,14061,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',82,'male','L2Pet',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','350.815645','639.431055','256.7116675',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14062,14062,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',82,'male','L2Pet',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','351.85652','642.55023','257.473335',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14063,14063,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',82,'male','L2Pet',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','352.897395','645.669405','258.2350025',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14064,14064,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',83,'male','L2Pet',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14065,14065,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',83,'male','L2Pet',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','354.8831075','651.4242925','259.6880625',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14066,14066,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',83,'male','L2Pet',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','355.904775','654.446775','260.435675',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14067,14067,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',83,'male','L2Pet',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','356.9264425','657.4692575','261.1832875',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14068,14068,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',84,'male','L2Pet',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','357.86723','660.07304','261.87171',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14069,14069,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',84,'male','L2Pet',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','358.8686775','662.9908475','262.604525',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14070,14070,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',84,'male','L2Pet',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','359.870125','665.908655','263.33734',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14071,14071,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',85,'male','L2Pet',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14072,14072,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',85,'male','L2Pet',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','363.09511','675.034693333333','265.697243333333',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14073,14073,'Corrupted Man',0,'',0,'LineageMonster.zombie','13','21',85,'male','L2Pet',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,15,140,1,1,0,1),
(14074,14074,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',58,'male','L2Pet',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,25,0,0,'442.8992','237.99429','302.44274','174.1539',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14075,14075,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',62,'male','L2Pet',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,25,0,0,'521.12391','257.34267','355.86007','188.3122',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14076,14076,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',66,'male','L2Pet',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,25,0,0,'603.79903','276.72752','412.31647','202.49719',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14077,14077,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',70,'male','L2Pet',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,25,0,0,'688.86373','295.91597','470.40463','216.53847',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14078,14078,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',72,'male','L2Pet',40,'2540.15331','1410','8.5','3',40,43,30,21,20,25,0,0,'731.52506','305.35947','499.53679','223.44881',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14079,14079,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',74,'male','L2Pet',40,'2632.19636','1475','8.5','3',40,43,30,21,20,25,0,0,'773.81598','314.65987','528.41601','230.25444',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14080,14080,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',76,'male','L2Pet',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,25,0,0,'815.37145','323.78455','556.793','236.93149',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14081,14081,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',78,'male','L2Pet',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','332.70061','584.40994','243.45587',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14082,14082,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',78,'male','L2Pet',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','333.7929775','587.770295','244.2552175',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14083,14083,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',78,'male','L2Pet',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','334.885345','591.13065','245.054565',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14084,14084,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',78,'male','L2Pet',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','335.9777125','594.491005','245.8539125',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14085,14085,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',79,'male','L2Pet',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','337.07008','597.85136','246.65326',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14086,14086,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',79,'male','L2Pet',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','338.1624475','601.211715','247.4526075',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14087,14087,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',79,'male','L2Pet',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','339.254815','604.57207','248.251955',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14088,14088,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',79,'male','L2Pet',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','340.3471825','607.932425','249.0513025',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14089,14089,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14090,14090,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',80,'male','L2Pet',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','342.45123','614.2922725','250.5909475',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14091,14091,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',80,'male','L2Pet',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','343.52746','617.580455','251.378485',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14092,14092,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',80,'male','L2Pet',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','344.60369','620.8686375','252.1660225',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14093,14093,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',81,'male','L2Pet',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','345.61127','623.83518','252.90333',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14094,14094,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',81,'male','L2Pet',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','346.6703375','627.0429525','253.67831',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14095,14095,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',81,'male','L2Pet',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','347.729405','630.250725','254.45329',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14096,14096,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',81,'male','L2Pet',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','348.7884725','633.4584975','255.22827',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14097,14097,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',82,'male','L2Pet',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','349.77477','636.31188','255.95',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14098,14098,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',82,'male','L2Pet',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','350.815645','639.431055','256.7116675',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14099,14099,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',82,'male','L2Pet',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','351.85652','642.55023','257.473335',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14100,14100,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',82,'male','L2Pet',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','352.897395','645.669405','258.2350025',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14101,14101,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',83,'male','L2Pet',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','353.86144','648.40181','258.94045',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14102,14102,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',83,'male','L2Pet',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','354.8831075','651.4242925','259.6880625',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14103,14103,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',83,'male','L2Pet',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','355.904775','654.446775','260.435675',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14104,14104,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',83,'male','L2Pet',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','356.9264425','657.4692575','261.1832875',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14105,14105,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',84,'male','L2Pet',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','357.86723','660.07304','261.87171',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14106,14106,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',84,'male','L2Pet',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','358.8686775','662.9908475','262.604525',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14107,14107,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',84,'male','L2Pet',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','359.870125','665.908655','263.33734',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14108,14108,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',85,'male','L2Pet',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','361.78814','671.29428','264.74086',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14109,14109,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',85,'male','L2Pet',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','363.09511','675.034693333333','265.697243333333',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14110,14110,'Cursed Man',0,'',0,'LineageMonster.doll_master','20','42',85,'male','L2Pet',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,8,0,333,0,0,0,80,160,1,1,0,1),
(14111,14111,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',22,'male','L2Pet',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,25,0,0,'51.75278','92.65694','35.34044','67.80232',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14112,14112,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',27,'male','L2Pet',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,25,0,0,'74.99121','108.28767','51.20928','79.24022',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14113,14113,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',32,'male','L2Pet',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,25,0,0,'106.16525','125.57727','72.49711','91.89199',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14114,14114,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',37,'male','L2Pet',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,25,0,0,'146.82587','144.47758','100.26304','105.72243',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14115,14115,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',42,'male','L2Pet',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,25,0,0,'198.34591','164.88513','135.44454','120.65578',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14116,14116,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',46,'male','L2Pet',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,25,0,0,'248.0526','182.18816','169.38777','133.31739',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14117,14117,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',50,'male','L2Pet',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,25,0,0,'305.54906','200.23844','208.6504','146.5258',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14118,14118,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',54,'male','L2Pet',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,25,0,0,'370.68904','218.89589','253.13256','160.17851',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14119,14119,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',58,'male','L2Pet',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,25,0,0,'442.8992','237.99429','302.44274','174.1539',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14120,14120,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',60,'male','L2Pet',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,25,0,0,'481.34551','247.65008','328.69659','181.21958',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14121,14121,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',62,'male','L2Pet',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,25,0,0,'521.12391','257.34267','355.86007','188.3122',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14122,14122,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',64,'male','L2Pet',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,25,0,0,'562.02275','267.04468','383.78868','195.41171',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14123,14123,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',66,'male','L2Pet',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,25,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14124,14124,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',68,'male','L2Pet',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,25,0,0,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14125,14125,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',70,'male','L2Pet',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,25,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14126,14126,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',72,'male','L2Pet',40,'2540.15331','1410','8.5','3',40,43,30,21,20,25,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14127,14127,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',74,'male','L2Pet',40,'2632.19636','1475','8.5','3',40,43,30,21,20,25,0,0,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14128,14128,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',76,'male','L2Pet',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,25,0,0,'815.37145','323.78455','556.793','236.93149',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14129,14129,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',78,'male','L2Pet',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14130,14130,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',78,'male','L2Pet',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','333.7929775','587.770295','244.2552175',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14131,14131,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',78,'male','L2Pet',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','334.885345','591.13065','245.054565',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14132,14132,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',78,'male','L2Pet',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','335.9777125','594.491005','245.8539125',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14133,14133,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',79,'male','L2Pet',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14134,14134,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',79,'male','L2Pet',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','338.1624475','601.211715','247.4526075',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14135,14135,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',79,'male','L2Pet',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','339.254815','604.57207','248.251955',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14136,14136,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',79,'male','L2Pet',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','340.3471825','607.932425','249.0513025',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14137,14137,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14138,14138,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',80,'male','L2Pet',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','342.45123','614.2922725','250.5909475',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14139,14139,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',80,'male','L2Pet',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','343.52746','617.580455','251.378485',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14140,14140,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',80,'male','L2Pet',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','344.60369','620.8686375','252.1660225',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14141,14141,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',81,'male','L2Pet',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','345.61127','623.83518','252.90333',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14142,14142,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',81,'male','L2Pet',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','346.6703375','627.0429525','253.67831',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14143,14143,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',81,'male','L2Pet',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','347.729405','630.250725','254.45329',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14144,14144,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',81,'male','L2Pet',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','348.7884725','633.4584975','255.22827',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14145,14145,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',82,'male','L2Pet',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14146,14146,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',82,'male','L2Pet',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','350.815645','639.431055','256.7116675',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14147,14147,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',82,'male','L2Pet',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','351.85652','642.55023','257.473335',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14148,14148,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',82,'male','L2Pet',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','352.897395','645.669405','258.2350025',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14149,14149,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',83,'male','L2Pet',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14150,14150,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',83,'male','L2Pet',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','354.8831075','651.4242925','259.6880625',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14151,14151,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',83,'male','L2Pet',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','355.904775','654.446775','260.435675',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14152,14152,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',83,'male','L2Pet',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','356.9264425','657.4692575','261.1832875',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14153,14153,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',84,'male','L2Pet',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','357.86723','660.07304','261.87171',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14154,14154,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',84,'male','L2Pet',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','358.8686775','662.9908475','262.604525',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14155,14155,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',84,'male','L2Pet',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','359.870125','665.908655','263.33734',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14156,14156,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',85,'male','L2Pet',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14157,14157,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',85,'male','L2Pet',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','363.09511','675.034693333333','265.697243333333',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14158,14158,'Kat the Cat',0,'',0,'LineageMonster.cat_the_cat','9','16',85,'male','L2Pet',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,80,120,1,1,0,1),
(14159,14159,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',22,'female','L2Pet',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,25,0,0,'51.75278','92.65694','35.34044','67.80232',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14160,14160,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',27,'female','L2Pet',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,25,0,0,'74.99121','108.28767','51.20928','79.24022',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14161,14161,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',32,'female','L2Pet',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,25,0,0,'106.16525','125.57727','72.49711','91.89199',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14162,14162,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',37,'female','L2Pet',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,25,0,0,'146.82587','144.47758','100.26304','105.72243',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14163,14163,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',42,'female','L2Pet',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,25,0,0,'198.34591','164.88513','135.44454','120.65578',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14164,14164,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',46,'female','L2Pet',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,25,0,0,'248.0526','182.18816','169.38777','133.31739',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14165,14165,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',50,'female','L2Pet',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,25,0,0,'305.54906','200.23844','208.6504','146.5258',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14166,14166,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',54,'female','L2Pet',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,25,0,0,'370.68904','218.89589','253.13256','160.17851',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14167,14167,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',58,'female','L2Pet',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,25,0,0,'442.8992','237.99429','302.44274','174.1539',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14168,14168,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',60,'female','L2Pet',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,25,0,0,'481.34551','247.65008','328.69659','181.21958',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14169,14169,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',62,'female','L2Pet',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,25,0,0,'521.12391','257.34267','355.86007','188.3122',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14170,14170,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',64,'female','L2Pet',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,25,0,0,'562.02275','267.04468','383.78868','195.41171',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14171,14171,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',66,'female','L2Pet',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,25,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14172,14172,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',68,'female','L2Pet',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,25,0,0,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14173,14173,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',70,'female','L2Pet',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,25,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14174,14174,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',72,'female','L2Pet',40,'2540.15331','1410','8.5','3',40,43,30,21,20,25,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14175,14175,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',74,'female','L2Pet',40,'2632.19636','1475','8.5','3',40,43,30,21,20,25,0,0,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14176,14176,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',76,'female','L2Pet',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,25,0,0,'815.37145','323.78455','556.793','236.93149',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14177,14177,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',78,'female','L2Pet',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14178,14178,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',78,'female','L2Pet',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','333.7929775','587.770295','244.2552175',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14179,14179,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',78,'female','L2Pet',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','334.885345','591.13065','245.054565',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14180,14180,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',78,'female','L2Pet',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','335.9777125','594.491005','245.8539125',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14181,14181,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',79,'female','L2Pet',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14182,14182,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',79,'female','L2Pet',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','338.1624475','601.211715','247.4526075',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14183,14183,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',79,'female','L2Pet',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','339.254815','604.57207','248.251955',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14184,14184,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',79,'female','L2Pet',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','340.3471825','607.932425','249.0513025',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14185,14185,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',80,'female','L2Pet',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14186,14186,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',80,'female','L2Pet',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','342.45123','614.2922725','250.5909475',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14187,14187,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',80,'female','L2Pet',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','343.52746','617.580455','251.378485',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14188,14188,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',80,'female','L2Pet',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','344.60369','620.8686375','252.1660225',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14189,14189,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',81,'female','L2Pet',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','345.61127','623.83518','252.90333',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14190,14190,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',81,'female','L2Pet',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','346.6703375','627.0429525','253.67831',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14191,14191,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',81,'female','L2Pet',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','347.729405','630.250725','254.45329',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14192,14192,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',81,'female','L2Pet',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','348.7884725','633.4584975','255.22827',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14193,14193,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',82,'female','L2Pet',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14194,14194,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',82,'female','L2Pet',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','350.815645','639.431055','256.7116675',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14195,14195,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',82,'female','L2Pet',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','351.85652','642.55023','257.473335',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14196,14196,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',82,'female','L2Pet',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','352.897395','645.669405','258.2350025',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14197,14197,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',83,'female','L2Pet',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14198,14198,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',83,'female','L2Pet',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','354.8831075','651.4242925','259.6880625',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14199,14199,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',83,'female','L2Pet',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','355.904775','654.446775','260.435675',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14200,14200,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',83,'female','L2Pet',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','356.9264425','657.4692575','261.1832875',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14201,14201,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',84,'female','L2Pet',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','357.86723','660.07304','261.87171',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14202,14202,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',84,'female','L2Pet',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','358.8686775','662.9908475','262.604525',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14203,14203,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',84,'female','L2Pet',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','359.870125','665.908655','263.33734',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14204,14204,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',85,'female','L2Pet',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14205,14205,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',85,'female','L2Pet',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','363.09511','675.034693333333','265.697243333333',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14206,14206,'Mew the Cat',0,'',0,'LineageMonster.cutie_cat','8','15',85,'female','L2Pet',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14207,14207,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',42,'male','L2Pet',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,25,0,0,'198.34591','164.88513','135.44454','120.65578',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14208,14208,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',46,'male','L2Pet',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,25,0,0,'248.0526','182.18816','169.38777','133.31739',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14209,14209,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',50,'male','L2Pet',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,25,0,0,'305.54906','200.23844','208.6504','146.5258',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14210,14210,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',54,'male','L2Pet',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,25,0,0,'370.68904','218.89589','253.13256','160.17851',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14211,14211,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',58,'male','L2Pet',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,25,0,0,'442.8992','237.99429','302.44274','174.1539',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14212,14212,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',60,'male','L2Pet',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,25,0,0,'481.34551','247.65008','328.69659','181.21958',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14213,14213,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',62,'male','L2Pet',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,25,0,0,'521.12391','257.34267','355.86007','188.3122',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14214,14214,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',64,'male','L2Pet',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,25,0,0,'562.02275','267.04468','383.78868','195.41171',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14215,14215,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',66,'male','L2Pet',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,25,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14216,14216,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',68,'male','L2Pet',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,25,0,0,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14217,14217,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',70,'male','L2Pet',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,25,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14218,14218,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',72,'male','L2Pet',40,'2540.15331','1410','8.5','3',40,43,30,21,20,25,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14219,14219,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',74,'male','L2Pet',40,'2632.19636','1475','8.5','3',40,43,30,21,20,25,0,0,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14220,14220,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',76,'male','L2Pet',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,25,0,0,'815.37145','323.78455','556.793','236.93149',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14221,14221,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',78,'male','L2Pet',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14222,14222,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',78,'male','L2Pet',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','333.7929775','587.770295','244.2552175',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14223,14223,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',78,'male','L2Pet',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','334.885345','591.13065','245.054565',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14224,14224,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',78,'male','L2Pet',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','335.9777125','594.491005','245.8539125',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14225,14225,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',79,'male','L2Pet',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14226,14226,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',79,'male','L2Pet',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','338.1624475','601.211715','247.4526075',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14227,14227,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',79,'male','L2Pet',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','339.254815','604.57207','248.251955',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14228,14228,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',79,'male','L2Pet',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','340.3471825','607.932425','249.0513025',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14229,14229,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14230,14230,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',80,'male','L2Pet',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','342.45123','614.2922725','250.5909475',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14231,14231,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',80,'male','L2Pet',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','343.52746','617.580455','251.378485',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14232,14232,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',80,'male','L2Pet',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','344.60369','620.8686375','252.1660225',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14233,14233,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',81,'male','L2Pet',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','345.61127','623.83518','252.90333',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14234,14234,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',81,'male','L2Pet',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','346.6703375','627.0429525','253.67831',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14235,14235,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',81,'male','L2Pet',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','347.729405','630.250725','254.45329',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14236,14236,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',81,'male','L2Pet',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','348.7884725','633.4584975','255.22827',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14237,14237,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',82,'male','L2Pet',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14238,14238,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',82,'male','L2Pet',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','350.815645','639.431055','256.7116675',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14239,14239,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',82,'male','L2Pet',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','351.85652','642.55023','257.473335',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14240,14240,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',82,'male','L2Pet',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','352.897395','645.669405','258.2350025',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14241,14241,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',83,'male','L2Pet',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14242,14242,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',83,'male','L2Pet',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','354.8831075','651.4242925','259.6880625',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14243,14243,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',83,'male','L2Pet',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','355.904775','654.446775','260.435675',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14244,14244,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',83,'male','L2Pet',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','356.9264425','657.4692575','261.1832875',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14245,14245,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',84,'male','L2Pet',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','357.86723','660.07304','261.87171',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14246,14246,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',84,'male','L2Pet',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','358.8686775','662.9908475','262.604525',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14247,14247,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',84,'male','L2Pet',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','359.870125','665.908655','263.33734',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14248,14248,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',85,'male','L2Pet',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14249,14249,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',85,'male','L2Pet',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','363.09511','675.034693333333','265.697243333333',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14250,14250,'Kai the Cat',0,'',0,'LineageMonster.silver_cat','7','15',85,'male','L2Pet',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14251,14251,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',58,'female','L2Pet',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,25,0,0,'442.8992','237.99429','302.44274','174.1539',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14252,14252,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',60,'female','L2Pet',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,25,0,0,'481.34551','247.65008','328.69659','181.21958',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14253,14253,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',62,'female','L2Pet',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,25,0,0,'521.12391','257.34267','355.86007','188.3122',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14254,14254,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',64,'female','L2Pet',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,25,0,0,'562.02275','267.04468','383.78868','195.41171',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14255,14255,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',66,'female','L2Pet',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,25,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14256,14256,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',68,'female','L2Pet',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,25,0,0,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14257,14257,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',70,'female','L2Pet',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,25,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14258,14258,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',72,'female','L2Pet',40,'2540.15331','1410','8.5','3',40,43,30,21,20,25,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14259,14259,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',74,'female','L2Pet',40,'2632.19636','1475','8.5','3',40,43,30,21,20,25,0,0,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14260,14260,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',76,'female','L2Pet',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,25,0,0,'815.37145','323.78455','556.793','236.93149',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14265,14265,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',78,'female','L2Pet',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14266,14266,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',78,'female','L2Pet',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','333.7929775','587.770295','244.2552175',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14267,14267,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',78,'female','L2Pet',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','334.885345','591.13065','245.054565',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14268,14268,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',78,'female','L2Pet',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','335.9777125','594.491005','245.8539125',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14269,14269,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',79,'female','L2Pet',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14270,14270,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',79,'female','L2Pet',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','338.1624475','601.211715','247.4526075',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14271,14271,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',79,'female','L2Pet',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','339.254815','604.57207','248.251955',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14272,14272,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',79,'female','L2Pet',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','340.3471825','607.932425','249.0513025',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14273,14273,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',80,'female','L2Pet',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14274,14274,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',80,'female','L2Pet',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','342.45123','614.2922725','250.5909475',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14275,14275,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',80,'female','L2Pet',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','343.52746','617.580455','251.378485',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14276,14276,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',80,'female','L2Pet',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','344.60369','620.8686375','252.1660225',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14277,14277,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',81,'female','L2Pet',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','345.61127','623.83518','252.90333',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14278,14278,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',81,'female','L2Pet',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','346.6703375','627.0429525','253.67831',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14279,14279,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',81,'female','L2Pet',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','347.729405','630.250725','254.45329',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14280,14280,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',81,'female','L2Pet',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','348.7884725','633.4584975','255.22827',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14281,14281,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',82,'female','L2Pet',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14282,14282,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',82,'female','L2Pet',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','350.815645','639.431055','256.7116675',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14283,14283,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',82,'female','L2Pet',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','351.85652','642.55023','257.473335',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14284,14284,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',82,'female','L2Pet',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','352.897395','645.669405','258.2350025',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14285,14285,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',83,'female','L2Pet',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14286,14286,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',83,'female','L2Pet',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','354.8831075','651.4242925','259.6880625',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14287,14287,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',83,'female','L2Pet',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','355.904775','654.446775','260.435675',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14288,14288,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',83,'female','L2Pet',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','356.9264425','657.4692575','261.1832875',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14289,14289,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',84,'female','L2Pet',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','357.86723','660.07304','261.87171',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14290,14290,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',84,'female','L2Pet',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','358.8686775','662.9908475','262.604525',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14291,14291,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',84,'female','L2Pet',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','359.870125','665.908655','263.33734',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14292,14292,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',85,'female','L2Pet',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14293,14293,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',85,'female','L2Pet',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','363.09511','675.034693333333','265.697243333333',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14294,14294,'Feline Queen',0,'',0,'LineageMonster2.queen_of_cat','8','15',85,'female','L2Pet',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,26,170,1,1,0,1),
(14295,14295,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',22,'male','L2Pet',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,25,0,0,'51.75278','92.65694','35.34044','67.80232',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14296,14296,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',27,'male','L2Pet',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,25,0,0,'74.99121','108.28767','51.20928','79.24022',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14297,14297,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',32,'male','L2Pet',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,25,0,0,'106.16525','125.57727','72.49711','91.89199',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14298,14298,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',37,'male','L2Pet',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,25,0,0,'146.82587','144.47758','100.26304','105.72243',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14299,14299,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',42,'male','L2Pet',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,25,0,0,'198.34591','164.88513','135.44454','120.65578',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14300,14300,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',46,'male','L2Pet',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,25,0,0,'248.0526','182.18816','169.38777','133.31739',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14301,14301,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',50,'male','L2Pet',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,25,0,0,'305.54906','200.23844','208.6504','146.5258',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14302,14302,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',54,'male','L2Pet',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,25,0,0,'370.68904','218.89589','253.13256','160.17851',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14303,14303,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',58,'male','L2Pet',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,25,0,0,'442.8992','237.99429','302.44274','174.1539',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14304,14304,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',60,'male','L2Pet',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,25,0,0,'481.34551','247.65008','328.69659','181.21958',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14305,14305,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',62,'male','L2Pet',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,25,0,0,'521.12391','257.34267','355.86007','188.3122',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14306,14306,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',64,'male','L2Pet',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,25,0,0,'562.02275','267.04468','383.78868','195.41171',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14307,14307,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',66,'male','L2Pet',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,25,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14308,14308,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',68,'male','L2Pet',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,25,0,0,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14309,14309,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',70,'male','L2Pet',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,25,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14310,14310,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',72,'male','L2Pet',40,'2540.15331','1410','8.5','3',40,43,30,21,20,25,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14311,14311,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',74,'male','L2Pet',40,'2632.19636','1475','8.5','3',40,43,30,21,20,25,0,0,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14312,14312,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',76,'male','L2Pet',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,25,0,0,'815.37145','323.78455','556.793','236.93149',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14313,14313,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',78,'male','L2Pet',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14314,14314,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',78,'male','L2Pet',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','333.7929775','587.770295','244.2552175',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14315,14315,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',78,'male','L2Pet',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','334.885345','591.13065','245.054565',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14316,14316,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',78,'male','L2Pet',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','335.9777125','594.491005','245.8539125',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14317,14317,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',79,'male','L2Pet',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14318,14318,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',79,'male','L2Pet',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','338.1624475','601.211715','247.4526075',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14319,14319,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',79,'male','L2Pet',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','339.254815','604.57207','248.251955',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14320,14320,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',79,'male','L2Pet',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','340.3471825','607.932425','249.0513025',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14321,14321,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14322,14322,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',80,'male','L2Pet',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','342.45123','614.2922725','250.5909475',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14323,14323,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',80,'male','L2Pet',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','343.52746','617.580455','251.378485',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14324,14324,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',80,'male','L2Pet',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','344.60369','620.8686375','252.1660225',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14325,14325,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',81,'male','L2Pet',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','345.61127','623.83518','252.90333',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14326,14326,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',81,'male','L2Pet',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','346.6703375','627.0429525','253.67831',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14327,14327,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',81,'male','L2Pet',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','347.729405','630.250725','254.45329',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14328,14328,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',81,'male','L2Pet',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','348.7884725','633.4584975','255.22827',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14329,14329,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',82,'male','L2Pet',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14330,14330,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',82,'male','L2Pet',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','350.815645','639.431055','256.7116675',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14331,14331,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',82,'male','L2Pet',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','351.85652','642.55023','257.473335',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14332,14332,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',82,'male','L2Pet',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','352.897395','645.669405','258.2350025',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14333,14333,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',83,'male','L2Pet',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14334,14334,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',83,'male','L2Pet',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','354.8831075','651.4242925','259.6880625',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14335,14335,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',83,'male','L2Pet',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','355.904775','654.446775','260.435675',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14336,14336,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',83,'male','L2Pet',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','356.9264425','657.4692575','261.1832875',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14337,14337,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',84,'male','L2Pet',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','357.86723','660.07304','261.87171',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14338,14338,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',84,'male','L2Pet',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','358.8686775','662.9908475','262.604525',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14339,14339,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',84,'male','L2Pet',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','359.870125','665.908655','263.33734',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14340,14340,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',85,'male','L2Pet',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14341,14341,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',85,'male','L2Pet',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','363.09511','675.034693333333','265.697243333333',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14342,14342,'Boxer the Unicorn',0,'',0,'LineageMonster.unicorn_boxer','11','18',85,'male','L2Pet',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14343,14343,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',22,'male','L2Pet',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,25,0,0,'51.75278','92.65694','35.34044','67.80232',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14344,14344,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',27,'male','L2Pet',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,25,0,0,'74.99121','108.28767','51.20928','79.24022',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14345,14345,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',32,'male','L2Pet',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,25,0,0,'106.16525','125.57727','72.49711','91.89199',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14346,14346,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',37,'male','L2Pet',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,25,0,0,'146.82587','144.47758','100.26304','105.72243',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14347,14347,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',42,'male','L2Pet',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,25,0,0,'198.34591','164.88513','135.44454','120.65578',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14348,14348,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',46,'male','L2Pet',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,25,0,0,'248.0526','182.18816','169.38777','133.31739',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14349,14349,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',50,'male','L2Pet',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,25,0,0,'305.54906','200.23844','208.6504','146.5258',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14350,14350,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',54,'male','L2Pet',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,25,0,0,'370.68904','218.89589','253.13256','160.17851',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14351,14351,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',58,'male','L2Pet',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,25,0,0,'442.8992','237.99429','302.44274','174.1539',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14352,14352,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',60,'male','L2Pet',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,25,0,0,'481.34551','247.65008','328.69659','181.21958',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14353,14353,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',62,'male','L2Pet',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,25,0,0,'521.12391','257.34267','355.86007','188.3122',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14354,14354,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',64,'male','L2Pet',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,25,0,0,'562.02275','267.04468','383.78868','195.41171',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14355,14355,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',66,'male','L2Pet',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,25,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14356,14356,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',68,'male','L2Pet',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,25,0,0,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14357,14357,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',70,'male','L2Pet',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,25,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14358,14358,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',72,'male','L2Pet',40,'2540.15331','1410','8.5','3',40,43,30,21,20,25,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14359,14359,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',74,'male','L2Pet',40,'2632.19636','1475','8.5','3',40,43,30,21,20,25,0,0,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14360,14360,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',76,'male','L2Pet',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,25,0,0,'815.37145','323.78455','556.793','236.93149',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14361,14361,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',78,'male','L2Pet',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14362,14362,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',78,'male','L2Pet',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','333.7929775','587.770295','244.2552175',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14363,14363,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',78,'male','L2Pet',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','334.885345','591.13065','245.054565',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14364,14364,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',78,'male','L2Pet',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','335.9777125','594.491005','245.8539125',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14365,14365,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',79,'male','L2Pet',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14366,14366,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',79,'male','L2Pet',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','338.1624475','601.211715','247.4526075',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14367,14367,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',79,'male','L2Pet',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','339.254815','604.57207','248.251955',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14368,14368,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',79,'male','L2Pet',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','340.3471825','607.932425','249.0513025',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14369,14369,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14370,14370,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',80,'male','L2Pet',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','342.45123','614.2922725','250.5909475',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14371,14371,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',80,'male','L2Pet',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','343.52746','617.580455','251.378485',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14372,14372,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',80,'male','L2Pet',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','344.60369','620.8686375','252.1660225',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14373,14373,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',81,'male','L2Pet',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','345.61127','623.83518','252.90333',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14374,14374,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',81,'male','L2Pet',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','346.6703375','627.0429525','253.67831',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14375,14375,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',81,'male','L2Pet',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','347.729405','630.250725','254.45329',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14376,14376,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',81,'male','L2Pet',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','348.7884725','633.4584975','255.22827',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14377,14377,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',82,'male','L2Pet',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14378,14378,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',82,'male','L2Pet',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','350.815645','639.431055','256.7116675',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14379,14379,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',82,'male','L2Pet',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','351.85652','642.55023','257.473335',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14380,14380,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',82,'male','L2Pet',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','352.897395','645.669405','258.2350025',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14381,14381,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',83,'male','L2Pet',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14382,14382,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',83,'male','L2Pet',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','354.8831075','651.4242925','259.6880625',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14383,14383,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',83,'male','L2Pet',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','355.904775','654.446775','260.435675',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14384,14384,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',83,'male','L2Pet',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','356.9264425','657.4692575','261.1832875',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14385,14385,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',84,'male','L2Pet',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','357.86723','660.07304','261.87171',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14386,14386,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',84,'male','L2Pet',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','358.8686775','662.9908475','262.604525',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14387,14387,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',84,'male','L2Pet',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','359.870125','665.908655','263.33734',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14388,14388,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',85,'male','L2Pet',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14389,14389,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',85,'male','L2Pet',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','363.09511','675.034693333333','265.697243333333',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14390,14390,'Mirage the Unicorn',0,'',0,'LineageMonster.unicorn_mirage','13','17',85,'male','L2Pet',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,27,140,1,1,0,1),
(14391,14391,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',42,'male','L2Pet',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,25,0,0,'198.34591','164.88513','135.44454','120.65578',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14392,14392,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',46,'male','L2Pet',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,25,0,0,'248.0526','182.18816','169.38777','133.31739',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14393,14393,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',50,'male','L2Pet',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,25,0,0,'305.54906','200.23844','208.6504','146.5258',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14394,14394,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',54,'male','L2Pet',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,25,0,0,'370.68904','218.89589','253.13256','160.17851',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14395,14395,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',58,'male','L2Pet',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,25,0,0,'442.8992','237.99429','302.44274','174.1539',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14396,14396,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',60,'male','L2Pet',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,25,0,0,'481.34551','247.65008','328.69659','181.21958',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14397,14397,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',62,'male','L2Pet',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,25,0,0,'521.12391','257.34267','355.86007','188.3122',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14398,14398,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',64,'male','L2Pet',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,25,0,0,'562.02275','267.04468','383.78868','195.41171',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14399,14399,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',66,'male','L2Pet',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,25,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14400,14400,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',68,'male','L2Pet',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,25,0,0,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14401,14401,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',70,'male','L2Pet',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,25,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14402,14402,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',72,'male','L2Pet',40,'2540.15331','1410','8.5','3',40,43,30,21,20,25,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14403,14403,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',74,'male','L2Pet',40,'2632.19636','1475','8.5','3',40,43,30,21,20,25,0,0,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14404,14404,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',76,'male','L2Pet',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,25,0,0,'815.37145','323.78455','556.793','236.93149',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14405,14405,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',78,'male','L2Pet',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14406,14406,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',78,'male','L2Pet',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','333.7929775','587.770295','244.2552175',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14407,14407,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',78,'male','L2Pet',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','334.885345','591.13065','245.054565',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14408,14408,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',78,'male','L2Pet',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','335.9777125','594.491005','245.8539125',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14409,14409,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',79,'male','L2Pet',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14410,14410,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',79,'male','L2Pet',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','338.1624475','601.211715','247.4526075',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14411,14411,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',79,'male','L2Pet',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','339.254815','604.57207','248.251955',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14412,14412,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',79,'male','L2Pet',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','340.3471825','607.932425','249.0513025',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14413,14413,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14414,14414,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',80,'male','L2Pet',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','342.45123','614.2922725','250.5909475',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14415,14415,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',80,'male','L2Pet',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','343.52746','617.580455','251.378485',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14416,14416,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',80,'male','L2Pet',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','344.60369','620.8686375','252.1660225',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14417,14417,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',81,'male','L2Pet',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','345.61127','623.83518','252.90333',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14418,14418,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',81,'male','L2Pet',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','346.6703375','627.0429525','253.67831',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14419,14419,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',81,'male','L2Pet',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','347.729405','630.250725','254.45329',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14420,14420,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',81,'male','L2Pet',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','348.7884725','633.4584975','255.22827',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14421,14421,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',82,'male','L2Pet',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14422,14422,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',82,'male','L2Pet',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','350.815645','639.431055','256.7116675',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14423,14423,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',82,'male','L2Pet',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','351.85652','642.55023','257.473335',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14424,14424,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',82,'male','L2Pet',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','352.897395','645.669405','258.2350025',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14425,14425,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',83,'male','L2Pet',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14426,14426,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',83,'male','L2Pet',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','354.8831075','651.4242925','259.6880625',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14427,14427,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',83,'male','L2Pet',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','355.904775','654.446775','260.435675',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14428,14428,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',83,'male','L2Pet',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','356.9264425','657.4692575','261.1832875',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14429,14429,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',84,'male','L2Pet',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','357.86723','660.07304','261.87171',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14430,14430,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',84,'male','L2Pet',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','358.8686775','662.9908475','262.604525',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14431,14431,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',84,'male','L2Pet',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','359.870125','665.908655','263.33734',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14432,14432,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',85,'male','L2Pet',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14433,14433,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',85,'male','L2Pet',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','363.09511','675.034693333333','265.697243333333',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14434,14434,'Merrow the Unicorn',0,'',0,'LineageMonster.blue_eye','11','16',85,'male','L2Pet',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14435,14435,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',58,'male','L2Pet',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,25,0,0,'442.8992','237.99429','302.44274','174.1539',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14436,14436,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',60,'male','L2Pet',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,25,0,0,'481.34551','247.65008','328.69659','181.21958',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14437,14437,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',62,'male','L2Pet',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,25,0,0,'521.12391','257.34267','355.86007','188.3122',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14438,14438,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',64,'male','L2Pet',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,25,0,0,'562.02275','267.04468','383.78868','195.41171',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14439,14439,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',66,'male','L2Pet',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,25,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14440,14440,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',68,'male','L2Pet',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,25,0,0,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14441,14441,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',70,'male','L2Pet',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,25,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14442,14442,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',72,'male','L2Pet',40,'2540.15331','1410','8.5','3',40,43,30,21,20,25,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14443,14443,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',74,'male','L2Pet',40,'2632.19636','1475','8.5','3',40,43,30,21,20,25,0,0,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14444,14444,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',76,'male','L2Pet',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,25,0,0,'815.37145','323.78455','556.793','236.93149',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14449,14449,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',78,'male','L2Pet',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14450,14450,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',78,'male','L2Pet',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','333.7929775','587.770295','244.2552175',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14451,14451,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',78,'male','L2Pet',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','334.885345','591.13065','245.054565',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14452,14452,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',78,'male','L2Pet',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','335.9777125','594.491005','245.8539125',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14453,14453,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',79,'male','L2Pet',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14454,14454,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',79,'male','L2Pet',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','338.1624475','601.211715','247.4526075',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14455,14455,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',79,'male','L2Pet',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','339.254815','604.57207','248.251955',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14456,14456,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',79,'male','L2Pet',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','340.3471825','607.932425','249.0513025',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14457,14457,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14458,14458,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',80,'male','L2Pet',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','342.45123','614.2922725','250.5909475',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14459,14459,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',80,'male','L2Pet',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','343.52746','617.580455','251.378485',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14460,14460,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',80,'male','L2Pet',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','344.60369','620.8686375','252.1660225',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14461,14461,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',81,'male','L2Pet',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','345.61127','623.83518','252.90333',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14462,14462,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',81,'male','L2Pet',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','346.6703375','627.0429525','253.67831',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14463,14463,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',81,'male','L2Pet',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','347.729405','630.250725','254.45329',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14464,14464,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',81,'male','L2Pet',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','348.7884725','633.4584975','255.22827',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14465,14465,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',82,'male','L2Pet',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14466,14466,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',82,'male','L2Pet',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','350.815645','639.431055','256.7116675',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14467,14467,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',82,'male','L2Pet',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','351.85652','642.55023','257.473335',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14468,14468,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',82,'male','L2Pet',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','352.897395','645.669405','258.2350025',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14469,14469,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',83,'male','L2Pet',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14470,14470,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',83,'male','L2Pet',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','354.8831075','651.4242925','259.6880625',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14471,14471,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',83,'male','L2Pet',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','355.904775','654.446775','260.435675',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14472,14472,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',83,'male','L2Pet',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','356.9264425','657.4692575','261.1832875',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14473,14473,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',84,'male','L2Pet',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','357.86723','660.07304','261.87171',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14474,14474,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',84,'male','L2Pet',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','358.8686775','662.9908475','262.604525',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14475,14475,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',84,'male','L2Pet',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','359.870125','665.908655','263.33734',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14476,14476,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',85,'male','L2Pet',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14477,14477,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',85,'male','L2Pet',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','363.09511','675.034693333333','265.697243333333',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14478,14478,'Unicorn Seraphim',0,'',0,'LineageMonster2.angelic_unicorn','9','25.5',85,'male','L2Pet',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,27,160,1,1,0,1),
(14479,14479,'Shadow',0,'',0,'LineageMonster.shadow','10','30',22,'male','L2Pet',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,25,0,0,'51.75278','92.65694','35.34044','67.80232',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14480,14480,'Shadow',0,'',0,'LineageMonster.shadow','10','30',27,'male','L2Pet',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,25,0,0,'74.99121','108.28767','51.20928','79.24022',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14481,14481,'Shadow',0,'',0,'LineageMonster.shadow','10','30',32,'male','L2Pet',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,25,0,0,'106.16525','125.57727','72.49711','91.89199',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14482,14482,'Shadow',0,'',0,'LineageMonster.shadow','10','30',37,'male','L2Pet',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,25,0,0,'146.82587','144.47758','100.26304','105.72243',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14483,14483,'Shadow',0,'',0,'LineageMonster.shadow','10','30',42,'male','L2Pet',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,25,0,0,'198.34591','164.88513','135.44454','120.65578',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14484,14484,'Shadow',0,'',0,'LineageMonster.shadow','10','30',46,'male','L2Pet',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,25,0,0,'248.0526','182.18816','169.38777','133.31739',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14485,14485,'Shadow',0,'',0,'LineageMonster.shadow','10','30',50,'male','L2Pet',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,25,0,0,'305.54906','200.23844','208.6504','146.5258',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14486,14486,'Shadow',0,'',0,'LineageMonster.shadow','10','30',54,'male','L2Pet',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,25,0,0,'370.68904','218.89589','253.13256','160.17851',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14487,14487,'Shadow',0,'',0,'LineageMonster.shadow','10','30',58,'male','L2Pet',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,25,0,0,'442.8992','237.99429','302.44274','174.1539',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14488,14488,'Shadow',0,'',0,'LineageMonster.shadow','10','30',60,'male','L2Pet',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,25,0,0,'481.34551','247.65008','328.69659','181.21958',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14489,14489,'Shadow',0,'',0,'LineageMonster.shadow','10','30',62,'male','L2Pet',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,25,0,0,'521.12391','257.34267','355.86007','188.3122',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14490,14490,'Shadow',0,'',0,'LineageMonster.shadow','10','30',64,'male','L2Pet',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,25,0,0,'562.02275','267.04468','383.78868','195.41171',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14491,14491,'Shadow',0,'',0,'LineageMonster.shadow','10','30',66,'male','L2Pet',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,25,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14492,14492,'Shadow',0,'',0,'LineageMonster.shadow','10','30',68,'male','L2Pet',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,25,0,0,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14493,14493,'Shadow',0,'',0,'LineageMonster.shadow','10','30',70,'male','L2Pet',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,25,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14494,14494,'Shadow',0,'',0,'LineageMonster.shadow','10','30',72,'male','L2Pet',40,'2540.15331','1410','8.5','3',40,43,30,21,20,25,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14495,14495,'Shadow',0,'',0,'LineageMonster.shadow','10','30',74,'male','L2Pet',40,'2632.19636','1475','8.5','3',40,43,30,21,20,25,0,0,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14496,14496,'Shadow',0,'',0,'LineageMonster.shadow','10','30',76,'male','L2Pet',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,25,0,0,'815.37145','323.78455','556.793','236.93149',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14497,14497,'Shadow',0,'',0,'LineageMonster.shadow','10','30',78,'male','L2Pet',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14498,14498,'Shadow',0,'',0,'LineageMonster.shadow','10','30',78,'male','L2Pet',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','333.7929775','587.770295','244.2552175',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14499,14499,'Shadow',0,'',0,'LineageMonster.shadow','10','30',78,'male','L2Pet',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','334.885345','591.13065','245.054565',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14500,14500,'Shadow',0,'',0,'LineageMonster.shadow','10','30',78,'male','L2Pet',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','335.9777125','594.491005','245.8539125',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14501,14501,'Shadow',0,'',0,'LineageMonster.shadow','10','30',79,'male','L2Pet',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14502,14502,'Shadow',0,'',0,'LineageMonster.shadow','10','30',79,'male','L2Pet',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','338.1624475','601.211715','247.4526075',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14503,14503,'Shadow',0,'',0,'LineageMonster.shadow','10','30',79,'male','L2Pet',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','339.254815','604.57207','248.251955',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14504,14504,'Shadow',0,'',0,'LineageMonster.shadow','10','30',79,'male','L2Pet',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','340.3471825','607.932425','249.0513025',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14505,14505,'Shadow',0,'',0,'LineageMonster.shadow','10','30',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14506,14506,'Shadow',0,'',0,'LineageMonster.shadow','10','30',80,'male','L2Pet',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','342.45123','614.2922725','250.5909475',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14507,14507,'Shadow',0,'',0,'LineageMonster.shadow','10','30',80,'male','L2Pet',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','343.52746','617.580455','251.378485',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14508,14508,'Shadow',0,'',0,'LineageMonster.shadow','10','30',80,'male','L2Pet',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','344.60369','620.8686375','252.1660225',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14509,14509,'Shadow',0,'',0,'LineageMonster.shadow','10','30',81,'male','L2Pet',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','345.61127','623.83518','252.90333',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14510,14510,'Shadow',0,'',0,'LineageMonster.shadow','10','30',81,'male','L2Pet',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','346.6703375','627.0429525','253.67831',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14511,14511,'Shadow',0,'',0,'LineageMonster.shadow','10','30',81,'male','L2Pet',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','347.729405','630.250725','254.45329',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14512,14512,'Shadow',0,'',0,'LineageMonster.shadow','10','30',81,'male','L2Pet',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','348.7884725','633.4584975','255.22827',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14513,14513,'Shadow',0,'',0,'LineageMonster.shadow','10','30',82,'male','L2Pet',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14514,14514,'Shadow',0,'',0,'LineageMonster.shadow','10','30',82,'male','L2Pet',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','350.815645','639.431055','256.7116675',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14515,14515,'Shadow',0,'',0,'LineageMonster.shadow','10','30',82,'male','L2Pet',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','351.85652','642.55023','257.473335',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14516,14516,'Shadow',0,'',0,'LineageMonster.shadow','10','30',82,'male','L2Pet',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','352.897395','645.669405','258.2350025',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14517,14517,'Shadow',0,'',0,'LineageMonster.shadow','10','30',83,'male','L2Pet',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14518,14518,'Shadow',0,'',0,'LineageMonster.shadow','10','30',83,'male','L2Pet',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','354.8831075','651.4242925','259.6880625',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14519,14519,'Shadow',0,'',0,'LineageMonster.shadow','10','30',83,'male','L2Pet',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','355.904775','654.446775','260.435675',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14520,14520,'Shadow',0,'',0,'LineageMonster.shadow','10','30',83,'male','L2Pet',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','356.9264425','657.4692575','261.1832875',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14521,14521,'Shadow',0,'',0,'LineageMonster.shadow','10','30',84,'male','L2Pet',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','357.86723','660.07304','261.87171',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14522,14522,'Shadow',0,'',0,'LineageMonster.shadow','10','30',84,'male','L2Pet',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','358.8686775','662.9908475','262.604525',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14523,14523,'Shadow',0,'',0,'LineageMonster.shadow','10','30',84,'male','L2Pet',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','359.870125','665.908655','263.33734',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14524,14524,'Shadow',0,'',0,'LineageMonster.shadow','10','30',85,'male','L2Pet',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14525,14525,'Shadow',0,'',0,'LineageMonster.shadow','10','30',85,'male','L2Pet',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','363.09511','675.034693333333','265.697243333333',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14526,14526,'Shadow',0,'',0,'LineageMonster.shadow','10','30',85,'male','L2Pet',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14527,14527,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',22,'female','L2Pet',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,25,0,0,'51.75278','92.65694','35.34044','67.80232',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14528,14528,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',27,'female','L2Pet',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,25,0,0,'74.99121','108.28767','51.20928','79.24022',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14529,14529,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',32,'female','L2Pet',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,25,0,0,'106.16525','125.57727','72.49711','91.89199',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14530,14530,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',37,'female','L2Pet',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,25,0,0,'146.82587','144.47758','100.26304','105.72243',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14531,14531,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',42,'female','L2Pet',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,25,0,0,'198.34591','164.88513','135.44454','120.65578',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14532,14532,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',46,'female','L2Pet',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,25,0,0,'248.0526','182.18816','169.38777','133.31739',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14533,14533,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',50,'female','L2Pet',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,25,0,0,'305.54906','200.23844','208.6504','146.5258',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14534,14534,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',54,'female','L2Pet',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,25,0,0,'370.68904','218.89589','253.13256','160.17851',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14535,14535,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',58,'female','L2Pet',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,25,0,0,'442.8992','237.99429','302.44274','174.1539',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14536,14536,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',60,'female','L2Pet',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,25,0,0,'481.34551','247.65008','328.69659','181.21958',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14537,14537,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',62,'female','L2Pet',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,25,0,0,'521.12391','257.34267','355.86007','188.3122',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14538,14538,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',64,'female','L2Pet',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,25,0,0,'562.02275','267.04468','383.78868','195.41171',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14539,14539,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',66,'female','L2Pet',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,25,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14540,14540,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',68,'female','L2Pet',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,25,0,0,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14541,14541,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',70,'female','L2Pet',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,25,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14542,14542,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',72,'female','L2Pet',40,'2540.15331','1410','8.5','3',40,43,30,21,20,25,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14543,14543,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',74,'female','L2Pet',40,'2632.19636','1475','8.5','3',40,43,30,21,20,25,0,0,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14544,14544,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',76,'female','L2Pet',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,25,0,0,'815.37145','323.78455','556.793','236.93149',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14545,14545,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',78,'female','L2Pet',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14546,14546,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',78,'female','L2Pet',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','333.7929775','587.770295','244.2552175',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14547,14547,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',78,'female','L2Pet',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','334.885345','591.13065','245.054565',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14548,14548,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',78,'female','L2Pet',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','335.9777125','594.491005','245.8539125',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14549,14549,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',79,'female','L2Pet',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14550,14550,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',79,'female','L2Pet',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','338.1624475','601.211715','247.4526075',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14551,14551,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',79,'female','L2Pet',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','339.254815','604.57207','248.251955',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14552,14552,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',79,'female','L2Pet',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','340.3471825','607.932425','249.0513025',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14553,14553,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',80,'female','L2Pet',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14554,14554,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',80,'female','L2Pet',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','342.45123','614.2922725','250.5909475',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14555,14555,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',80,'female','L2Pet',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','343.52746','617.580455','251.378485',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14556,14556,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',80,'female','L2Pet',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','344.60369','620.8686375','252.1660225',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14557,14557,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',81,'female','L2Pet',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','345.61127','623.83518','252.90333',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14558,14558,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',81,'female','L2Pet',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','346.6703375','627.0429525','253.67831',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14559,14559,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',81,'female','L2Pet',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','347.729405','630.250725','254.45329',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14560,14560,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',81,'female','L2Pet',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','348.7884725','633.4584975','255.22827',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14561,14561,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',82,'female','L2Pet',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14562,14562,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',82,'female','L2Pet',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','350.815645','639.431055','256.7116675',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14563,14563,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',82,'female','L2Pet',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','351.85652','642.55023','257.473335',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14564,14564,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',82,'female','L2Pet',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','352.897395','645.669405','258.2350025',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14565,14565,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',83,'female','L2Pet',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14566,14566,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',83,'female','L2Pet',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','354.8831075','651.4242925','259.6880625',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14567,14567,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',83,'female','L2Pet',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','355.904775','654.446775','260.435675',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14568,14568,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',83,'female','L2Pet',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','356.9264425','657.4692575','261.1832875',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14569,14569,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',84,'female','L2Pet',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','357.86723','660.07304','261.87171',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14570,14570,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',84,'female','L2Pet',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','358.8686775','662.9908475','262.604525',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14571,14571,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',84,'female','L2Pet',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','359.870125','665.908655','263.33734',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14572,14572,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',85,'female','L2Pet',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14573,14573,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',85,'female','L2Pet',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','363.09511','675.034693333333','265.697243333333',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14574,14574,'Silhouette',0,'',0,'LineageMonster.silhouette','8','23',85,'female','L2Pet',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,80,140,1,1,0,1),
(14575,14575,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',42,'male','L2Pet',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,25,0,0,'198.34591','164.88513','135.44454','120.65578',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14576,14576,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',46,'male','L2Pet',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,25,0,0,'248.0526','182.18816','169.38777','133.31739',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14577,14577,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',50,'male','L2Pet',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,25,0,0,'305.54906','200.23844','208.6504','146.5258',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14578,14578,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',54,'male','L2Pet',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,25,0,0,'370.68904','218.89589','253.13256','160.17851',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14579,14579,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',58,'male','L2Pet',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,25,0,0,'442.8992','237.99429','302.44274','174.1539',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14580,14580,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',60,'male','L2Pet',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,25,0,0,'481.34551','247.65008','328.69659','181.21958',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14581,14581,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',62,'male','L2Pet',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,25,0,0,'521.12391','257.34267','355.86007','188.3122',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14582,14582,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',64,'male','L2Pet',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,25,0,0,'562.02275','267.04468','383.78868','195.41171',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14583,14583,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',66,'male','L2Pet',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,25,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14584,14584,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',68,'male','L2Pet',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,25,0,0,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14585,14585,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',70,'male','L2Pet',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,25,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14586,14586,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',72,'male','L2Pet',40,'2540.15331','1410','8.5','3',40,43,30,21,20,25,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14587,14587,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',74,'male','L2Pet',40,'2632.19636','1475','8.5','3',40,43,30,21,20,25,0,0,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14588,14588,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',76,'male','L2Pet',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,25,0,0,'815.37145','323.78455','556.793','236.93149',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14589,14589,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',78,'male','L2Pet',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14590,14590,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',78,'male','L2Pet',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','333.7929775','587.770295','244.2552175',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14591,14591,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',78,'male','L2Pet',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','334.885345','591.13065','245.054565',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14592,14592,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',78,'male','L2Pet',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','335.9777125','594.491005','245.8539125',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14593,14593,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',79,'male','L2Pet',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14594,14594,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',79,'male','L2Pet',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','338.1624475','601.211715','247.4526075',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14595,14595,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',79,'male','L2Pet',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','339.254815','604.57207','248.251955',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14596,14596,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',79,'male','L2Pet',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','340.3471825','607.932425','249.0513025',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14597,14597,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14598,14598,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',80,'male','L2Pet',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','342.45123','614.2922725','250.5909475',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14599,14599,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',80,'male','L2Pet',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','343.52746','617.580455','251.378485',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14600,14600,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',80,'male','L2Pet',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','344.60369','620.8686375','252.1660225',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14601,14601,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',81,'male','L2Pet',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','345.61127','623.83518','252.90333',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14602,14602,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',81,'male','L2Pet',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','346.6703375','627.0429525','253.67831',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14603,14603,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',81,'male','L2Pet',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','347.729405','630.250725','254.45329',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14604,14604,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',81,'male','L2Pet',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','348.7884725','633.4584975','255.22827',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14605,14605,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',82,'male','L2Pet',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14606,14606,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',82,'male','L2Pet',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','350.815645','639.431055','256.7116675',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14607,14607,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',82,'male','L2Pet',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','351.85652','642.55023','257.473335',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14608,14608,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',82,'male','L2Pet',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','352.897395','645.669405','258.2350025',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14609,14609,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',83,'male','L2Pet',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14610,14610,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',83,'male','L2Pet',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','354.8831075','651.4242925','259.6880625',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14611,14611,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',83,'male','L2Pet',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','355.904775','654.446775','260.435675',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14612,14612,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',83,'male','L2Pet',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','356.9264425','657.4692575','261.1832875',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14613,14613,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',84,'male','L2Pet',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','357.86723','660.07304','261.87171',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14614,14614,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',84,'male','L2Pet',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','358.8686775','662.9908475','262.604525',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14615,14615,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',84,'male','L2Pet',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','359.870125','665.908655','263.33734',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14616,14616,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',85,'male','L2Pet',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14617,14617,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',85,'male','L2Pet',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','363.09511','675.034693333333','265.697243333333',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14618,14618,'Soulless',0,'',0,'LineageMonster.shadeless','7','28',85,'male','L2Pet',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,48,180,1,1,0,1),
(14619,14619,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',58,'male','L2Pet',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,25,0,0,'442.8992','237.99429','302.44274','174.1539',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14620,14620,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',60,'male','L2Pet',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,25,0,0,'481.34551','247.65008','328.69659','181.21958',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14621,14621,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',62,'male','L2Pet',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,25,0,0,'521.12391','257.34267','355.86007','188.3122',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14622,14622,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',64,'male','L2Pet',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,25,0,0,'562.02275','267.04468','383.78868','195.41171',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14623,14623,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',66,'male','L2Pet',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,25,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14624,14624,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',68,'male','L2Pet',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,25,0,0,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14625,14625,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',70,'male','L2Pet',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,25,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14626,14626,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',72,'male','L2Pet',40,'2540.15331','1410','8.5','3',40,43,30,21,20,25,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14627,14627,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',74,'male','L2Pet',40,'2632.19636','1475','8.5','3',40,43,30,21,20,25,0,0,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14628,14628,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',76,'male','L2Pet',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,25,0,0,'815.37145','323.78455','556.793','236.93149',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14633,14633,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',78,'male','L2Pet',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14634,14634,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',78,'male','L2Pet',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','333.7929775','587.770295','244.2552175',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14635,14635,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',78,'male','L2Pet',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','334.885345','591.13065','245.054565',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14636,14636,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',78,'male','L2Pet',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','335.9777125','594.491005','245.8539125',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14637,14637,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',79,'male','L2Pet',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14638,14638,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',79,'male','L2Pet',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','338.1624475','601.211715','247.4526075',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14639,14639,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',79,'male','L2Pet',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','339.254815','604.57207','248.251955',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14640,14640,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',79,'male','L2Pet',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','340.3471825','607.932425','249.0513025',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14641,14641,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14642,14642,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',80,'male','L2Pet',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','342.45123','614.2922725','250.5909475',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14643,14643,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',80,'male','L2Pet',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','343.52746','617.580455','251.378485',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14644,14644,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',80,'male','L2Pet',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','344.60369','620.8686375','252.1660225',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14645,14645,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',81,'male','L2Pet',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','345.61127','623.83518','252.90333',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14646,14646,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',81,'male','L2Pet',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','346.6703375','627.0429525','253.67831',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14647,14647,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',81,'male','L2Pet',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','347.729405','630.250725','254.45329',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14648,14648,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',81,'male','L2Pet',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','348.7884725','633.4584975','255.22827',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14649,14649,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',82,'male','L2Pet',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14650,14650,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',82,'male','L2Pet',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','350.815645','639.431055','256.7116675',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14651,14651,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',82,'male','L2Pet',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','351.85652','642.55023','257.473335',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14652,14652,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',82,'male','L2Pet',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','352.897395','645.669405','258.2350025',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14653,14653,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',83,'male','L2Pet',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14654,14654,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',83,'male','L2Pet',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','354.8831075','651.4242925','259.6880625',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14655,14655,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',83,'male','L2Pet',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','355.904775','654.446775','260.435675',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14656,14656,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',83,'male','L2Pet',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','356.9264425','657.4692575','261.1832875',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14657,14657,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',84,'male','L2Pet',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','357.86723','660.07304','261.87171',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14658,14658,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',84,'male','L2Pet',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','358.8686775','662.9908475','262.604525',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14659,14659,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',84,'male','L2Pet',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','359.870125','665.908655','263.33734',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14660,14660,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',85,'male','L2Pet',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14661,14661,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',85,'male','L2Pet',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','363.09511','675.034693333333','265.697243333333',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14662,14662,'Nightshade',0,'',0,'LineageMonster2.knight_of_shadow','10','35.5',85,'male','L2Pet',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,30,180,1,1,0,1),
(14663,14663,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',30,'male','L2Pet',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,25,0,0,'92.64226','118.46427','63.26266','86.68702',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14664,14664,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',38,'male','L2Pet',40,'886.09975','447.96','4.5','1.8',40,43,30,21,20,25,0,0,'156.22273','148.44287','106.67987','108.62405',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14665,14665,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',45,'male','L2Pet',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,25,0,0,'234.89829','177.78746','160.40508','130.09715',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14666,14666,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',51,'male','L2Pet',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,25,0,0,'321.13207','204.85194','219.29157','149.90176',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14667,14667,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',57,'male','L2Pet',40,'1776.58018','948','6.5','2.4',40,43,30,21,20,25,0,0,'424.23295','233.18839','289.69611','170.63714',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14668,14668,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',62,'male','L2Pet',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,25,0,0,'521.12391','257.34267','355.86007','188.3122',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14669,14669,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',66,'male','L2Pet',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,25,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14670,14670,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',70,'male','L2Pet',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,25,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14671,14671,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',74,'male','L2Pet',40,'2632.19636','1475','8.5','3',40,43,30,21,20,25,0,0,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14672,14672,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',78,'male','L2Pet',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14673,14673,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',78,'male','L2Pet',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','333.7929775','587.770295','244.2552175',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14674,14674,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',78,'male','L2Pet',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','334.885345','591.13065','245.054565',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14675,14675,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',78,'male','L2Pet',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','335.9777125','594.491005','245.8539125',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14676,14676,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',79,'male','L2Pet',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14677,14677,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',79,'male','L2Pet',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','338.1624475','601.211715','247.4526075',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14678,14678,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',79,'male','L2Pet',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','339.254815','604.57207','248.251955',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14679,14679,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',79,'male','L2Pet',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','340.3471825','607.932425','249.0513025',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14680,14680,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14681,14681,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',80,'male','L2Pet',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','342.45123','614.2922725','250.5909475',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14682,14682,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',80,'male','L2Pet',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','343.52746','617.580455','251.378485',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14683,14683,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',80,'male','L2Pet',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','344.60369','620.8686375','252.1660225',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14684,14684,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',81,'male','L2Pet',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','345.61127','623.83518','252.90333',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14685,14685,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',81,'male','L2Pet',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','346.6703375','627.0429525','253.67831',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14686,14686,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',81,'male','L2Pet',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','347.729405','630.250725','254.45329',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14687,14687,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',81,'male','L2Pet',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','348.7884725','633.4584975','255.22827',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14688,14688,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',82,'male','L2Pet',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14689,14689,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',82,'male','L2Pet',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','350.815645','639.431055','256.7116675',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14690,14690,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',82,'male','L2Pet',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','351.85652','642.55023','257.473335',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14691,14691,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',82,'male','L2Pet',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','352.897395','645.669405','258.2350025',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14692,14692,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',83,'male','L2Pet',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14693,14693,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',83,'male','L2Pet',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','354.8831075','651.4242925','259.6880625',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14694,14694,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',83,'male','L2Pet',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','355.904775','654.446775','260.435675',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14695,14695,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',83,'male','L2Pet',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','356.9264425','657.4692575','261.1832875',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14696,14696,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',84,'male','L2Pet',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','357.86723','660.07304','261.87171',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14697,14697,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',84,'male','L2Pet',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','358.8686775','662.9908475','262.604525',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14698,14698,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',84,'male','L2Pet',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','359.870125','665.908655','263.33734',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14699,14699,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',85,'male','L2Pet',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14700,14700,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',85,'male','L2Pet',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','363.09511','675.034693333333','265.697243333333',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14701,14701,'Mechanic Golem',0,'',0,'LineageMonster.mechanic_golem','5','19',85,'male','L2Pet',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,30,150,1,1,0,1),
(14702,14702,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',60,'male','L2Pet',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,25,0,0,'481.34551','247.65008','328.69659','181.21958',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14703,14703,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',64,'male','L2Pet',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,25,0,0,'562.02275','267.04468','383.78868','195.41171',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14704,14704,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',68,'male','L2Pet',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,25,0,0,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14705,14705,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',72,'male','L2Pet',40,'2540.15331','1410','8.5','3',40,43,30,21,20,25,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14706,14706,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',76,'male','L2Pet',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,25,0,0,'815.37145','323.78455','556.793','236.93149',253,4,0,333,0,0,0,48,140,1,1,0,1),
(14707,14707,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',78,'male','L2Pet',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,48,141,1,1,0,1),
(14708,14708,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',78,'male','L2Pet',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','333.7929775','587.770295','244.2552175',253,4,0,333,0,0,0,48,142,1,1,0,1),
(14709,14709,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',78,'male','L2Pet',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','334.885345','591.13065','245.054565',253,4,0,333,0,0,0,48,143,1,1,0,1),
(14710,14710,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',78,'male','L2Pet',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','335.9777125','594.491005','245.8539125',253,4,0,333,0,0,0,48,144,1,1,0,1),
(14711,14711,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',79,'male','L2Pet',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,48,145,1,1,0,1),
(14712,14712,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',79,'male','L2Pet',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','338.1624475','601.211715','247.4526075',253,4,0,333,0,0,0,48,146,1,1,0,1),
(14713,14713,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',79,'male','L2Pet',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','339.254815','604.57207','248.251955',253,4,0,333,0,0,0,48,147,1,1,0,1),
(14714,14714,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',79,'male','L2Pet',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','340.3471825','607.932425','249.0513025',253,4,0,333,0,0,0,48,148,1,1,0,1),
(14715,14715,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,48,149,1,1,0,1),
(14716,14716,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',80,'male','L2Pet',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','342.45123','614.2922725','250.5909475',253,4,0,333,0,0,0,48,150,1,1,0,1),
(14717,14717,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',80,'male','L2Pet',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','343.52746','617.580455','251.378485',253,4,0,333,0,0,0,48,151,1,1,0,1),
(14718,14718,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',80,'male','L2Pet',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','344.60369','620.8686375','252.1660225',253,4,0,333,0,0,0,48,152,1,1,0,1),
(14719,14719,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',81,'male','L2Pet',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','345.61127','623.83518','252.90333',253,4,0,333,0,0,0,48,153,1,1,0,1),
(14720,14720,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',81,'male','L2Pet',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','346.6703375','627.0429525','253.67831',253,4,0,333,0,0,0,48,154,1,1,0,1),
(14721,14721,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',81,'male','L2Pet',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','347.729405','630.250725','254.45329',253,4,0,333,0,0,0,48,155,1,1,0,1),
(14722,14722,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',81,'male','L2Pet',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','348.7884725','633.4584975','255.22827',253,4,0,333,0,0,0,48,156,1,1,0,1),
(14723,14723,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',82,'male','L2Pet',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,48,157,1,1,0,1),
(14724,14724,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',82,'male','L2Pet',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','350.815645','639.431055','256.7116675',253,4,0,333,0,0,0,48,158,1,1,0,1),
(14725,14725,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',82,'male','L2Pet',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','351.85652','642.55023','257.473335',253,4,0,333,0,0,0,48,159,1,1,0,1),
(14726,14726,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',82,'male','L2Pet',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','352.897395','645.669405','258.2350025',253,4,0,333,0,0,0,48,160,1,1,0,1),
(14727,14727,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',83,'male','L2Pet',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,48,161,1,1,0,1),
(14728,14728,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',83,'male','L2Pet',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','354.8831075','651.4242925','259.6880625',253,4,0,333,0,0,0,48,162,1,1,0,1),
(14729,14729,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',83,'male','L2Pet',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','355.904775','654.446775','260.435675',253,4,0,333,0,0,0,48,163,1,1,0,1),
(14730,14730,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',83,'male','L2Pet',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','356.9264425','657.4692575','261.1832875',253,4,0,333,0,0,0,48,164,1,1,0,1),
(14731,14731,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',84,'male','L2Pet',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','357.86723','660.07304','261.87171',253,4,0,333,0,0,0,48,165,1,1,0,1),
(14732,14732,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',84,'male','L2Pet',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','358.8686775','662.9908475','262.604525',253,4,0,333,0,0,0,48,166,1,1,0,1),
(14733,14733,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',84,'male','L2Pet',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','359.870125','665.908655','263.33734',253,4,0,333,0,0,0,48,167,1,1,0,1),
(14734,14734,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',85,'male','L2Pet',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,48,168,1,1,0,1),
(14735,14735,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',85,'male','L2Pet',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','363.09511','675.034693333333','265.697243333333',253,4,0,333,0,0,0,48,169,1,1,0,1),
(14736,14736,'Big Boom',0,'',0,'LineageMonster.big_boom','6','13',85,'male','L2Pet',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,48,170,1,1,0,1),
(14737,14737,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',55,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1500','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14738,14738,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',78,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1515','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14739,14739,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',78,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1530','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14740,14740,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',78,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1545','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14741,14741,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',78,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1560','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14742,14742,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',79,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1575','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14743,14743,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',79,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1590','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14744,14744,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',79,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1605','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14745,14745,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',79,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1620','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14746,14746,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',80,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1635','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14747,14747,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',80,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1650','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14748,14748,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',80,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1665','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14749,14749,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',80,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1680','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14750,14750,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',81,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1695','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14751,14751,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',81,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1710','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14752,14752,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',81,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1725','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14753,14753,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',81,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1740','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14754,14754,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',82,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1755','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14755,14755,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',82,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1770','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14756,14756,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',82,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1785','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14757,14757,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',82,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1800','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14758,14758,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',83,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1815','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14759,14759,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',83,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1830','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14760,14760,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',83,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1845','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14761,14761,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',83,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1860','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14762,14762,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',84,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1875','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14763,14763,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',84,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1890','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14764,14764,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',84,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1905','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14765,14765,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',85,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1920','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14766,14766,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',85,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1935','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14767,14767,'Siege Golem',0,'',0,'LineageMonster.siege_golem','60','140',85,'male','L2SiegeSummon',80,'500000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'1950','837','265.02979','674',150,4,0,333,0,0,0,40,40,1,1,0,1),
(14768,14768,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',60,'male','L2SiegeSummon',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,25,0,0,'481.34551','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14769,14769,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',78,'male','L2SiegeSummon',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','333.7929775','587.770295','244.2552175',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14770,14770,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',78,'male','L2SiegeSummon',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','334.885345','591.13065','245.054565',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14771,14771,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',78,'male','L2SiegeSummon',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','335.9777125','594.491005','245.8539125',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14772,14772,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',78,'male','L2SiegeSummon',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14773,14773,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',79,'male','L2SiegeSummon',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','338.1624475','601.211715','247.4526075',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14774,14774,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',79,'male','L2SiegeSummon',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','339.254815','604.57207','248.251955',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14775,14775,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',79,'male','L2SiegeSummon',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','340.3471825','607.932425','249.0513025',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14776,14776,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',79,'male','L2SiegeSummon',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','341.375','611.00409','249.80341',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14777,14777,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',80,'male','L2SiegeSummon',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','342.45123','614.2922725','250.5909475',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14778,14778,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',80,'male','L2SiegeSummon',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','343.52746','617.580455','251.378485',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14779,14779,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',80,'male','L2SiegeSummon',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','344.60369','620.8686375','252.1660225',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14780,14780,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',80,'male','L2SiegeSummon',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','345.61127','623.83518','252.90333',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14781,14781,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',81,'male','L2SiegeSummon',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','346.6703375','627.0429525','253.67831',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14782,14782,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',81,'male','L2SiegeSummon',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','347.729405','630.250725','254.45329',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14783,14783,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',81,'male','L2SiegeSummon',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','348.7884725','633.4584975','255.22827',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14784,14784,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',81,'male','L2SiegeSummon',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','349.77477','636.31188','255.95',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14785,14785,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',82,'male','L2SiegeSummon',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','350.815645','639.431055','256.7116675',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14786,14786,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',82,'male','L2SiegeSummon',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','351.85652','642.55023','257.473335',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14787,14787,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',82,'male','L2SiegeSummon',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','352.897395','645.669405','258.2350025',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14788,14788,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',82,'male','L2SiegeSummon',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14789,14789,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',83,'male','L2SiegeSummon',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','354.8831075','651.4242925','259.6880625',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14790,14790,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',83,'male','L2SiegeSummon',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','355.904775','654.446775','260.435675',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14791,14791,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',83,'male','L2SiegeSummon',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','356.9264425','657.4692575','261.1832875',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14792,14792,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',83,'male','L2SiegeSummon',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','357.86723','660.07304','261.87171',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14793,14793,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',84,'male','L2SiegeSummon',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','358.8686775','662.9908475','262.604525',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14794,14794,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',84,'male','L2SiegeSummon',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','359.870125','665.908655','263.33734',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14795,14795,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',84,'male','L2SiegeSummon',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14796,14796,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',85,'male','L2SiegeSummon',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','363.09511','675.034693333333','265.697243333333',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14797,14797,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',85,'male','L2SiegeSummon',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14798,14798,'Wild Hog Cannon',0,'',0,'LineageMonster.range_golem','93','90',85,'male','L2SiegeSummon',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','341.375','611.00409','249.80341',253,4,0,333,0,0,0,10,10,1,1,0,1),
(14799,14799,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',42,'male','L2Pet',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,25,0,0,'198.34591','164.88513','135.44454','120.65578',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14800,14800,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',51,'male','L2Pet',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,25,0,0,'321.13207','204.85194','219.29157','149.90176',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14801,14801,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',60,'male','L2Pet',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,25,0,0,'481.34551','247.65008','328.69659','181.21958',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14802,14802,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',64,'male','L2Pet',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,25,0,0,'562.02275','267.04468','383.78868','195.41171',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14803,14803,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',68,'male','L2Pet',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,25,0,0,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14804,14804,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',72,'male','L2Pet',40,'2540.15331','1410','8.5','3',40,43,30,21,20,25,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14805,14805,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',76,'male','L2Pet',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,25,0,0,'815.37145','323.78455','556.793','236.93149',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14806,14806,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',78,'male','L2Pet',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,25,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14807,14807,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',78,'male','L2Pet',40,'2812.763385','1615.8','8.5','3',40,43,30,21,20,25,0,0,'860.7348','333.7929775','587.770295','244.2552175',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14808,14808,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',78,'male','L2Pet',40,'2822.62688','1624.2','8.5','3',40,43,30,21,20,25,0,0,'865.65573','334.885345','591.13065','245.054565',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14809,14809,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',78,'male','L2Pet',40,'2832.490375','1632.6','8.5','3',40,43,30,21,20,25,0,0,'870.57666','335.9777125','594.491005','245.8539125',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14810,14810,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',79,'male','L2Pet',40,'2842.35387','1641','8.5','3',40,43,30,21,20,25,0,0,'875.49759','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14811,14811,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',79,'male','L2Pet',40,'2852.217365','1649.4','8.5','3',40,43,30,21,20,25,0,0,'880.41852','338.1624475','601.211715','247.4526075',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14812,14812,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',79,'male','L2Pet',40,'2862.08086','1657.8','8.5','3',40,43,30,21,20,25,0,0,'885.33945','339.254815','604.57207','248.251955',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14813,14813,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',79,'male','L2Pet',40,'2871.944355','1666.2','8.5','3',40,43,30,21,20,25,0,0,'890.26038','340.3471825','607.932425','249.0513025',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14814,14814,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14815,14815,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',80,'male','L2Pet',40,'2889.8818825','1683.25','8.5','3',40,43,30,21,20,25,0,0,'899.5737775','342.45123','614.2922725','250.5909475',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14816,14816,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',80,'male','L2Pet',40,'2899.387485','1691.7','8.5','3',40,43,30,21,20,25,0,0,'904.389015','343.52746','617.580455','251.378485',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14817,14817,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',80,'male','L2Pet',40,'2908.8930875','1700.15','8.5','3',40,43,30,21,20,25,0,0,'909.2042525','344.60369','620.8686375','252.1660225',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14818,14818,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',81,'male','L2Pet',40,'2916.89894','1708.8','8.5','3',40,43,30,21,20,25,0,0,'913.54847','345.61127','623.83518','252.90333',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14819,14819,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',81,'male','L2Pet',40,'2926.029605','1717.3','8.5','3',40,43,30,21,20,25,0,0,'918.2459525','346.6703375','627.0429525','253.67831',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14820,14820,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',81,'male','L2Pet',40,'2935.16027','1725.8','8.5','3',40,43,30,21,20,25,0,0,'922.943435','347.729405','630.250725','254.45329',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14821,14821,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',81,'male','L2Pet',40,'2944.290935','1734.3','8.5','3',40,43,30,21,20,25,0,0,'927.6409175','348.7884725','633.4584975','255.22827',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14822,14822,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',82,'male','L2Pet',40,'2951.85588','1743','8.5','3',40,43,30,21,20,25,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14823,14823,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',82,'male','L2Pet',40,'2960.595115','1751.55','8.5','3',40,43,30,21,20,25,0,0,'936.3871825','350.815645','639.431055','256.7116675',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14824,14824,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',82,'male','L2Pet',40,'2969.33435','1760.1','8.5','3',40,43,30,21,20,25,0,0,'940.954925','351.85652','642.55023','257.473335',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14825,14825,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',82,'male','L2Pet',40,'2978.073585','1768.65','8.5','3',40,43,30,21,20,25,0,0,'945.5226675','352.897395','645.669405','258.2350025',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14826,14826,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',83,'male','L2Pet',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,25,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14827,14827,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',83,'male','L2Pet',40,'2993.515405','1786','8.5','3',40,43,30,21,20,25,0,0,'953.9501525','354.8831075','651.4242925','259.6880625',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14828,14828,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',83,'male','L2Pet',40,'3001.84731','1794.6','8.5','3',40,43,30,21,20,25,0,0,'958.376295','355.904775','654.446775','260.435675',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14829,14829,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',83,'male','L2Pet',40,'3010.179215','1803.2','8.5','3',40,43,30,21,20,25,0,0,'962.8024375','356.9264425','657.4692575','261.1832875',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14830,14830,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',84,'male','L2Pet',40,'3016.82079','1812','8.5','3',40,43,30,21,20,25,0,0,'966.61544','357.86723','660.07304','261.87171',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14831,14831,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',84,'male','L2Pet',40,'3024.7301125','1820.65','8.5','3',40,43,30,21,20,25,0,0,'970.8882975','358.8686775','662.9908475','262.604525',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14832,14832,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',84,'male','L2Pet',40,'3032.639435','1829.3','8.5','3',40,43,30,21,20,25,0,0,'975.161155','359.870125','665.908655','263.33734',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14833,14833,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',85,'male','L2Pet',40,'3046.70947','1846.8','8.5','3',40,43,30,21,20,25,0,0,'983.0479','361.78814','671.29428','264.74086',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14834,14834,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',85,'male','L2Pet',40,'3056.67236333333','1858.4','8.5','3',40,43,30,21,20,25,0,0,'988.525386666667','363.09511','675.034693333333','265.697243333333',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14835,14835,'Dark Panther',0,'',0,'LineageMonster.dark_fencer','7','13',85,'male','L2Pet',40,'3066.63525666667','1870','8.5','3',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,25,150,1,1,0,1),
(14836,14836,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6','16.0055',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','6',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14837,14837,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.5','17',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','6',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14838,14838,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.5','33.5',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','6',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14839,14839,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',68,'male','L2SiegeSummon',80,'50000','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'12.475','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14840,14840,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',78,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'12.475','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14841,14841,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',78,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'12.475','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14842,14842,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',78,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'12.475','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14843,14843,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',78,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'12.82311377','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14844,14844,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',79,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'12.82311377','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14845,14845,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',79,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'12.82311377','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14846,14846,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',79,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'13.37067365','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14847,14847,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',79,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'13.37067365','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14848,14848,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',80,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'13.37067365','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14849,14849,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',80,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'13.8353869','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14850,14850,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',80,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'13.8353869','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14851,14851,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',80,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'13.8353869','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14852,14852,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',81,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'14.3796875','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14853,14853,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',81,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'14.3796875','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14854,14854,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',81,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'14.3796875','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14855,14855,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',81,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'14.9239881','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14856,14856,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',82,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'14.9239881','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14857,14857,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',82,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'14.9239881','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14858,14858,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',82,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'15.3767036','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14859,14859,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',82,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'15.3767036','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14860,14860,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',83,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'15.3767036','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14861,14861,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',83,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'15.91784024','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14862,14862,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',83,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'15.91784024','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14863,14863,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',83,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'15.91784024','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14864,14864,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',84,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'15.91784024','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14865,14865,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',84,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'16.45892012','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14866,14866,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',84,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'16.45892012','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14867,14867,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',85,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'16.45892012','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14868,14868,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',85,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'16.45892012','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14869,14869,'Swoop Cannon',0,'',0,'LineageMonster3.toad_cannon','45','47.5',85,'male','L2SiegeSummon',80,'50000','889.8','8.5','2.4',40,43,30,21,20,25,0,0,'17','837','265.02979','674',150,4,0,333,0,0,0,60,40,1,1,0,1),
(14870,14870,'Divine Beast',0,'',0,'LineageMonster4.Divine_beast','23','15.5',80,'male','L2Pet',40,'2880.37628','1674.8','8.5','6',40,43,30,21,20,25,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,40,180,1,1,0,1),
(14871,14871,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6','16.0055',81,'male','L2Pet',40,'2892.79354511111','1687.81333333333','8.5','6',40,43,30,21,20,25,0,0,'901.374828888889','342.910138666667','615.522157777778','250.926757777778',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14872,14872,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6','16.0055',81,'male','L2Pet',40,'2905.21081022222','1700.82666666667','8.5','6',40,43,30,21,20,25,0,0,'907.991117777778','344.445277333333','620.040225555556','252.050105555556',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14873,14873,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6','16.0055',81,'male','L2Pet',40,'2917.62807533333','1713.84','8.5','6',40,43,30,21,20,25,0,0,'914.607406666667','345.980416','624.558293333333','253.173453333333',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14874,14874,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6','16.0055',82,'male','L2Pet',40,'2930.04534044444','1726.85333333333','8.5','6',40,43,30,21,20,25,0,0,'921.223695555556','347.515554666667','629.076361111111','254.296801111111',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14875,14875,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6','16.0055',82,'male','L2Pet',40,'2942.46260555556','1739.86666666667','8.5','6',40,43,30,21,20,25,0,0,'927.839984444444','349.050693333333','633.594428888889','255.420148888889',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14876,14876,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6','16.0055',82,'male','L2Pet',40,'2954.87987066667','1752.88','8.5','6',40,43,30,21,20,25,0,0,'934.456273333333','350.585832','638.112496666667','256.543496666667',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14877,14877,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6','16.0055',83,'male','L2Pet',40,'2967.29713577778','1765.89333333333','8.5','6',40,43,30,21,20,25,0,0,'941.072562222222','352.120970666667','642.630564444444','257.666844444444',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14878,14878,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6','16.0055',83,'male','L2Pet',40,'2979.71440088889','1778.90666666667','8.5','6',40,43,30,21,20,25,0,0,'947.688851111111','353.656109333333','647.148632222222','258.790192222222',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14879,14879,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6','16.0055',83,'male','L2Pet',40,'2992.131666','1791.92000000000','8.5','6',40,43,30,21,20,25,0,0,'954.30514','355.191248','651.6667','259.91354',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14880,14880,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6','16.0055',84,'male','L2Pet',40,'3004.54893111111','1804.93333333333','8.5','6',40,43,30,21,20,25,0,0,'960.921428888889','356.726386666667','656.184767777778','261.036887777778',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14881,14881,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6','16.0055',84,'male','L2Pet',40,'3016.96619622222','1817.94666666667','8.5','6',40,43,30,21,20,25,0,0,'967.537717777778','358.261525333333','660.702835555556','262.160235555556',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14882,14882,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6','16.0055',84,'male','L2Pet',40,'3029.38346133333','1830.96','8.5','6',40,43,30,21,20,25,0,0,'974.154006666667','359.796664','665.220903333333','263.283583333333',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14883,14883,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6','16.0055',85,'male','L2Pet',40,'3041.80072644444','1843.97333333333','8.5','6',40,43,30,21,20,25,0,0,'980.770295555556','361.331802666667','669.738971111111','264.406931111111',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14884,14884,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6','16.0055',85,'male','L2Pet',40,'3054.21799155555','1856.98666666667','8.5','6',40,43,30,21,20,25,0,0,'987.386584444444','362.866941333333','674.257038888889','265.530278888889',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14885,14885,'Feline King',0,'',0,'LineageMonster3.king_of_cat','6','16.0055',85,'male','L2Pet',40,'3066.63525666667','1870','8.5','6',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14886,14886,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.5','17',81,'male','L2Pet',40,'2892.79354511111','1687.81333333333','8.5','6',40,43,30,21,20,25,0,0,'901.374828888889','342.910138666667','615.522157777778','250.926757777778',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14887,14887,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.5','17',81,'male','L2Pet',40,'2905.21081022222','1700.82666666667','8.5','6',40,43,30,21,20,25,0,0,'907.991117777778','344.445277333333','620.040225555556','252.050105555556',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14888,14888,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.5','17',81,'male','L2Pet',40,'2917.62807533333','1713.84','8.5','6',40,43,30,21,20,25,0,0,'914.607406666667','345.980416','624.558293333333','253.173453333333',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14889,14889,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.5','17',82,'male','L2Pet',40,'2930.04534044444','1726.85333333333','8.5','6',40,43,30,21,20,25,0,0,'921.223695555556','347.515554666667','629.076361111111','254.296801111111',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14890,14890,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.5','17',82,'male','L2Pet',40,'2942.46260555556','1739.86666666667','8.5','6',40,43,30,21,20,25,0,0,'927.839984444444','349.050693333333','633.594428888889','255.420148888889',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14891,14891,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.5','17',82,'male','L2Pet',40,'2954.87987066667','1752.88','8.5','6',40,43,30,21,20,25,0,0,'934.456273333333','350.585832','638.112496666667','256.543496666667',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14892,14892,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.5','17',83,'male','L2Pet',40,'2967.29713577778','1765.89333333333','8.5','6',40,43,30,21,20,25,0,0,'941.072562222222','352.120970666667','642.630564444444','257.666844444444',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14893,14893,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.5','17',83,'male','L2Pet',40,'2979.71440088889','1778.90666666667','8.5','6',40,43,30,21,20,25,0,0,'947.688851111111','353.656109333333','647.148632222222','258.790192222222',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14894,14894,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.5','17',83,'male','L2Pet',40,'2992.131666','1791.92','8.5','6',40,43,30,21,20,25,0,0,'954.30514','355.191248','651.6667','259.91354',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14895,14895,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.5','17',84,'male','L2Pet',40,'3004.54893111111','1804.93333333333','8.5','6',40,43,30,21,20,25,0,0,'960.921428888889','356.726386666667','656.184767777778','261.036887777778',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14896,14896,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.5','17',84,'male','L2Pet',40,'3016.96619622222','1817.94666666667','8.5','6',40,43,30,21,20,25,0,0,'967.537717777778','358.261525333333','660.702835555556','262.160235555556',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14897,14897,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.5','17',84,'male','L2Pet',40,'3029.38346133333','1830.96','8.5','6',40,43,30,21,20,25,0,0,'974.154006666667','359.796664','665.220903333333','263.283583333333',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14898,14898,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.5','17',85,'male','L2Pet',40,'3041.80072644444','1843.97333333333','8.5','6',40,43,30,21,20,25,0,0,'980.770295555556','361.331802666667','669.738971111111','264.406931111111',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14899,14899,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.5','17',85,'male','L2Pet',40,'3054.21799155555','1856.98666666667','8.5','6',40,43,30,21,20,25,0,0,'987.386584444444','362.866941333333','674.257038888889','265.530278888889',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14900,14900,'Magnus the Unicorn',0,'',0,'LineageMonster3.unicorn_magnus','13.5','17',85,'male','L2Pet',40,'3066.63525666667','1870','8.5','6',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14901,14901,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.5','33.5',81,'male','L2Pet',40,'2892.79354511111','1687.81333333333','8.5','6',40,43,30,21,20,25,0,0,'901.374828888889','342.910138666667','615.522157777778','250.926757777778',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14902,14902,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.5','33.5',81,'male','L2Pet',40,'2905.21081022222','1700.82666666667','8.5','6',40,43,30,21,20,25,0,0,'907.991117777778','344.445277333333','620.040225555556','252.050105555556',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14903,14903,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.5','33.5',81,'male','L2Pet',40,'2917.62807533333','1713.84','8.5','6',40,43,30,21,20,25,0,0,'914.607406666667','345.980416','624.558293333333','253.173453333333',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14904,14904,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.5','33.5',82,'male','L2Pet',40,'2930.04534044444','1726.85333333333','8.5','6',40,43,30,21,20,25,0,0,'921.223695555556','347.515554666667','629.076361111111','254.296801111111',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14905,14905,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.5','33.5',82,'male','L2Pet',40,'2942.46260555556','1739.86666666667','8.5','6',40,43,30,21,20,25,0,0,'927.839984444444','349.050693333333','633.594428888889','255.420148888889',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14906,14906,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.5','33.5',82,'male','L2Pet',40,'2954.87987066667','1752.88','8.5','6',40,43,30,21,20,25,0,0,'934.456273333333','350.585832','638.112496666667','256.543496666667',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14907,14907,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.5','33.5',83,'male','L2Pet',40,'2967.29713577778','1765.89333333333','8.5','6',40,43,30,21,20,25,0,0,'941.072562222222','352.120970666667','642.630564444444','257.666844444444',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14908,14908,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.5','33.5',83,'male','L2Pet',40,'2979.71440088889','1778.90666666667','8.5','6',40,43,30,21,20,25,0,0,'947.688851111111','353.656109333333','647.148632222222','258.790192222222',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14909,14909,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.5','33.5',83,'male','L2Pet',40,'2992.131666','1791.92','8.5','6',40,43,30,21,20,25,0,0,'954.30514','355.191248','651.6667','259.91354',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14910,14910,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.5','33.5',84,'male','L2Pet',40,'3004.54893111111','1804.93333333333','8.5','6',40,43,30,21,20,25,0,0,'960.921428888889','356.726386666667','656.184767777778','261.036887777778',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14911,14911,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.5','33.5',84,'male','L2Pet',40,'3016.96619622222','1817.94666666667','8.5','6',40,43,30,21,20,25,0,0,'967.537717777778','358.261525333333','660.702835555556','262.160235555556',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14912,14912,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.5','33.5',84,'male','L2Pet',40,'3029.38346133333','1830.96','8.5','6',40,43,30,21,20,25,0,0,'974.154006666667','359.796664','665.220903333333','263.283583333333',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14913,14913,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.5','33.5',85,'male','L2Pet',40,'3041.80072644444','1843.97333333333','8.5','6',40,43,30,21,20,25,0,0,'980.770295555556','361.331802666667','669.738971111111','264.406931111111',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14914,14914,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.5','33.5',85,'male','L2Pet',40,'3054.21799155555','1856.98666666667','8.5','6',40,43,30,21,20,25,0,0,'987.386584444444','362.866941333333','674.257038888889','265.530278888889',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14915,14915,'Spectral Lord',0,'',0,'LineageMonster3.spectral_knight','12.5','33.5',85,'male','L2Pet',40,'3066.63525666667','1870','8.5','6',40,43,30,21,20,25,0,0,'994.002873333333','364.40208','678.775106666667','266.653626666667',253,4,0,333,0,0,0,160,180,1,1,0,1),
(14916,14916,'Tigress',0,'',0,'LineageMonster.saber_toothed_tiger_070p','22','18.4',61,'male','L2Pet',40,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,25,0,0,'501.08068','252.49346','342.17315','184.76376',253,4,0,333,0,0,0,47,170,1,1,0,1),
(14917,14917,'Tigress',0,'',0,'LineageMonster.saber_toothed_tiger_070p','22','18.4',61,'male','L2Pet',40,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,25,0,0,'501.08068','252.49346','342.17315','184.76376',253,4,0,333,0,0,0,47,170,1,1,0,1),
(14918,14918,'Imperial Phoenix',0,'',0,'LineageMonster4.phoenix','7','34',83,'female','L2Pet',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,25,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,60,180,1,1,0,1),
(16013,16013,'Trained Buffalo',0,'',0,'LineageMonster2.buffalo','22','31',67,'male','L2TamedBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,25,0,0,'624.93199','281.55251','426.74754','206.02791',253,4,0,333,0,0,0,80,120,1,1,0,1),
(16014,16014,'Trained Buffalo',0,'',0,'LineageMonster2.buffalo','22','31',67,'male','L2TamedBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,25,0,0,'624.93199','281.55251','426.74754','206.02791',253,4,0,333,0,0,0,80,120,1,1,0,1),
(16015,16015,'Trained Cougar',0,'',0,'LineageMonster.saber_toothed_tiger','34','28',69,'male','L2TamedBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,25,0,0,'667.50361','291.15063','455.81844','213.05139',253,4,0,333,0,0,0,60,120,1,1,0,1),
(16016,16016,'Trained Cougar',0,'',0,'LineageMonster.saber_toothed_tiger','34','28',69,'male','L2TamedBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,25,0,0,'667.50361','291.15063','455.81844','213.05139',253,4,0,333,0,0,0,60,120,1,1,0,1),
(16017,16017,'Trained Kookaburra',0,'',0,'LineageMonster2.pet_ostrich','10','33',65,'male','L2TamedBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,25,0,0,'582.81759','271.89033','397.98887','198.95754',253,4,0,333,0,0,0,23,120,1,1,0,1),
(16018,16018,'Trained Kookaburra',0,'',0,'LineageMonster2.pet_ostrich','10','33',65,'male','L2TamedBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,25,0,0,'582.81759','271.89033','397.98887','198.95754',253,4,0,333,0,0,0,23,120,1,1,0,1),
(16019,16019,'Tiny Baby Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12','15',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,25,2146,200,'624.93199','281.55251','426.74754','206.02791',253,4,0,333,0,0,0,30,120,1,1,0,1),
(16020,16020,'Tame Tiny Baby Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12','15',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,25,2146,200,'624.93199','281.55251','426.74754','206.02791',253,4,0,333,0,0,0,30,120,1,1,0,1),
(16021,16021,'Tiny Baby Cougar',0,'',0,'LineageMonster2.baby_tiger','11','15.7',69,'male','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,25,2276,218,'667.50361','291.15063','455.81844','213.05139',253,4,0,333,0,0,0,28,120,1,1,0,1),
(16022,16022,'Tame Tiny Baby Cougar',0,'',0,'LineageMonster2.baby_tiger','11','15.7',69,'male','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,25,2276,218,'667.50361','291.15063','455.81844','213.05139',253,4,0,333,0,0,0,28,120,1,1,0,1),
(16023,16023,'Tiny Baby Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7','15',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,25,2020,183,'582.81759','271.89033','397.98887','198.95754',253,4,0,333,0,0,0,13,120,1,1,0,1),
(16024,16024,'Tame Tiny Baby Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7','15',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,25,2020,183,'582.81759','271.89033','397.98887','198.95754',253,4,0,333,0,0,0,13,120,1,1,0,1),
(16025,16025,'Great Wolf',0,'',0,'LineageMonster4.Pet_Wolf_B','32','21.412',55,'male','L2Pet',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,45,170,1,1,0,1),
(16026,16026,'Beastly Agathion',0,'',0,'LineageNPC2.Agathion_BF','0.01','11.3',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(16027,16027,'Rainbow Agathion',0,'',0,'LineageNPC2.Agathion_RA','0.01','6.7',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(16028,16028,'Lord Agathion',0,'',0,'LineageNPC2.Agathion_CL','0.01','9.5',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(16029,16029,'Fortress Agathion',0,'',0,'LineageNPC2.Agathion_FT','0.01','3.5',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(16030,16030,'Great Wolf',0,'',0,'LineageMonster4.Pet_Wolf_Ba','25','21.412',55,'male','L2Pet',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,45,170,1,1,0,1),
(16031,16031,'Little Angel Agathion',0,'',0,'LineageNpc2.Agathion_ag','0.01','4.5475',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(16032,16032,'Little Devil Agathion',0,'',0,'LineageNpc2.Agathion_st','0.01','5.5',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(16033,16033,'Rudolph Agathion',0,'',0,'LineageNpc2.Agathion_rd','0.01','5.271',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(16034,16034,'Improved Baby Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12','15',55,'male','L2BabyPet',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,30,170,1,1,0,1),
(16035,16035,'Improved Baby Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7','15',55,'male','L2BabyPet',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,13,170,1,1,0,1),
(16036,16036,'Improved Baby Cougar',0,'',0,'LineageMonster2.baby_tiger','11','15.7',55,'male','L2BabyPet',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,28,170,1,1,0,1),
(16037,16037,'Great Snow Wolf',0,'',0,'LineageMonster4.Pet_Wolf_Ba','25','21.412',55,'male','L2Pet',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,45,170,1,1,0,1),
(16038,16038,'Red Wind Strider',0,'',0,'LineageMonster.strider','23','31',55,'male','L2Pet',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,80,170,1,1,0,1),
(16039,16039,'Red Star Strider',0,'',0,'LineageMonster.strider','23','31',55,'male','L2Pet',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,80,170,1,1,0,1),
(16040,16040,'Red Twilight Strider',0,'',0,'LineageMonster.strider','23','31',55,'male','L2Pet',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,80,170,1,1,0,1),
(16041,16041,'Fenrir',0,'',0,'LineageMonster4.Pet_Wolf_Ba','25','21.412',55,'male','L2Pet',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,45,170,1,1,0,1),
(16042,16042,'Snow Fenrir',0,'',0,'LineageMonster4.Pet_Wolf_Ba','25','21.412',55,'male','L2Pet',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,45,170,1,1,0,1),
(16043,16043,'Fox Shaman',0,'',0,'LineageMonster4.foxian_wizard_pet','10','18.5',55,'male','L2Pet',40,'1673.05473','889.8','6.5','2.4',35,37,30,32,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,35,170,1,1,0,1),
(16044,16044,'Wild Beast Fighter',0,'',0,'LineageMonster4.beast_fighter_pet','11','16.5',55,'male','L2Pet',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,22,170,1,1,0,1),
(16045,16045,'White Weasel',0,'',0,'LineageMonster4.ferret_pet','6.5','12.5',55,'male','L2BabyPet',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,30,170,1,1,0,1),
(16046,16046,'Fairy Princess',0,'',0,'LineageMonster4.fairy_princess_pet','10','15',55,'male','L2BabyPet',40,'1673.05473','889.8','6.5','2.4',35,37,30,32,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,35,170,1,1,0,1),
(16049,16049,'Love Agathion',0,'',0,'LineageNpc2.agathion_love','5','3.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(16050,16050,'Owl Monk',0,'',0,'LineageMonster4.owl_wizard_the_pet','13','19.5',55,'female','L2Pet',40,'1673.05473','889.80000','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,30,180,1,1,0,1),
(16051,16051,'Spirit Shaman',0,'',0,'LineageMonster4.sprit_magician_the_pet','12.8','15.6',55,'male','L2BabyPet',40,'1673.05473','889.8','6.5','2.4',35,37,30,32,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,30,180,1,1,0,1),
(16052,16052,'Toy Knight',0,'',0,'LineageMonster4.toy_knight_the_pet','10','15',55,'male','L2BabyPet',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(16053,16053,'Turtle Ascetic',0,'',0,'LineageMonster4.turtle_buffer_the_pet','11','10',55,'male','L2BabyPet',40,'1673.05473','889.8','6.5','2.4',38,40,30,26,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,20,180,1,1,0,1),
(16054,16054,'Monkey',0,'',0,'LineageNpc2.agathion_mk','15','7',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(16055,16055,'Griffon',0,'',0,'LineageNpc2.agathion_gr','5','5.5',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(16056,16056,'Joy',0,'',0,'LineageNpc2.agathion_happy','6.5','6.5',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(16057,16057,'Sorrow',0,'',0,'LineageNpc2.agathion_sorrow','5','5',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(16058,16058,'Anger',0,'',0,'LineageNpc2.agathion_anger','3','3',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(16059,16059,'Boy Bear',0,'',0,'LineageNPC2.teddy_bear_boy','3','7',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(16060,16060,'Girl Bear',0,'',0,'LineageNPC2.teddy_bear_girl','3','7',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(16061,16061,'Collection Device',0,'',0,'LineageNPC2.collecting_golem','5.5','6.25',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(16062,16062,'Knight',0,'',0,'LineageNPC2.agathion_pvp','4.5','7',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,25,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(16063,16063,'Saerom',0,'',0,'LineageNPC2.agathion_gift','3','5.15',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(16064,16064,'Juju',0,'',0,'LineageNPC2.agathion_cupi','5','7',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(16065,16065,'Oink Oink',0,'',0,'LineageNPC2.agathion_pig','6','5.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(16066,16066,'Light of Dawn',0,'',0,'LineageNPC2.agathion_pig','6','5.75',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(16067,16067,'Deinonychus',0,'',0,'LineageMonster3.deinonychus','14','14.3',55,'male','L2Pet',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,0,0,'388.11142','223.6362','265.02979','163.64727',253,1,0,333,0,0,0,24,160,1,1,0,1),
(16068,16068,'Guardian\'s Strider',0,'',0,'LineageMonster4.dragon_descendant_2a','27','33.5',55,'male','L2Pet',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,40,170,1,1,0,1),
(16069,16069,'Pona',0,'',0,'LineageNPC2.agathion_pona','3','5.15',55,'female','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(16070,16070,'Towbat',0,'',0,'LineageNPC2.agathion_tow','4','5.87',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,50,180,1,1,0,1),
(16071,16071,'Maguen',0,'',0,'LineageMonster5.marguene_pet','11','13.25',55,'male','L2Pet',40,'1673.05473','889.80000','6.5','2.4',40,43,30,21,20,20,0,0,'388.11142','223.6362','265.02979','163.64727',253,1,0,333,0,0,0,15,120,1,1,0,1),
(16072,16072,'Elite Maguen',0,'',0,'LineageMonster5.marguene_pet_elite','11','13.25',55,'male','L2Pet',40,'1673.05473','889.80000','6.5','2.4',40,43,30,21,20,20,0,0,'388.11142','223.6362','265.02979','163.64727',253,1,0,333,0,0,0,15,120,1,1,0,1),
(16073,16073,'Rudolph Agathion',0,'',0,'LineageNpc2.Agathion_rd','0.01','5.271',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,60,180,1,1,0,1),
(18001,18001,'Blood Queen',0,'',0,'LineageMonster.bloody_queen','14','40',60,'female','L2Monster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,4536,394,'481.34551','247.65008','328.69659','150.021245531891',253,4,300,333,0,0,0,80,160,1,1,0,1),
(18002,18002,'Blood Queen',0,'',0,'LineageMonster.bloody_queen','14','40',60,'female','L2Monster',40,'1933.2','1036.8','6.5','2.4',40,43,30,21,20,20,4320,375,'529.48','247.65','328.7','150.021593197344',253,4,300,333,0,0,0,80,160,1,1,0,1),
(18003,18003,'Bearded Keltir',0,'',0,'LineageMonster.keltir','9.5','10',1,'male','L2Monster',40,'39.7','40','2','0.9',40,43,30,21,20,20,29,2,'4','44.44','5.79','26.9214336743691',253,4,0,333,0,0,0,23,110,1,1,0,1),
(18004,18004,'Susceptor Prime',0,'',0,'LineageMonster.susceptor_prime','45','72',49,'male','L2Monster',1100,'1372.2','720','5.5','2.1',40,43,30,21,20,20,0,1,'290.45','195.66','198.34','118.530469702895',253,8,0,333,0,0,0,78,170,1,1,0,1),
(18005,18005,'Mimic',0,'',0,'LineageMonster.mimic','8.5','8.5',52,'male','L2Monster',40,'1569.5','804','6.5','2.4',40,43,30,21,20,20,3245,251,'348.07','216.26','230.26','126.908234441282',253,4,0,333,0,0,0,80,156,1,1,0,1),
(18006,18006,'Maruk Lord',0,'',0,'LineageMonster.death_blader','15','45',68,'male','L2Monster',40,'2421.5','1282.4','7.5','2.7',40,43,30,21,20,20,6057,586,'667.04','295.61','441.26','173.47436733457',253,4,500,333,1472,0,0,100,170,1,1,0,1),
(18007,18007,'Limal Karinness',0,'',0,'LineageMonster.bloody_queen','14','40',69,'female','L2Monster',40,'2395.5','1314','7.5','2.7',40,43,30,21,20,20,5951,582,'734.25','291.15','501.4','176.371815672636',253,4,500,333,0,0,0,80,140,1,1,0,1),
(18008,18008,'Karik',0,'',0,'LineageMonster.karik','25','90',70,'male','L2Monster',40,'2444.5','1345.8','7.5','2.7',40,43,30,21,20,20,6370,632,'757.75','295.92','517.45','179.260985460277',253,4,500,333,0,0,0,37,200,1,1,0,1),
(18009,18009,'Offering of Branded Elder',0,'',0,'LineageMonster.orc_fighter_bi','12','26.4',34,'male','L2FestivalMonster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,1755,102,'121.20802','132.9486','82.76936','80.537480497082',253,4,0,333,127,0,0,45,30,1,1,0,1),
(18010,18010,'Offering of the Branded',0,'',0,'LineageMonster.orc','10','21',32,'male','L2FestivalMonster',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,1524,86,'92.89459375','106.7406795','72.49711','76.0720822329578',253,8,0,333,218,0,0,45,30,1,1,0,1),
(18011,18011,'Offering of Branded Archer',0,'',0,'LineageMonster.orc_archer','14','25',28,'male','L2FestivalMonster',1100,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,1001,53,'178.96112432','94.871628','54.99876','67.6132386264202',253,8,0,333,14,0,0,45,60,1,1,0,1),
(18012,18012,'Offering of Branded Warrior',0,'',0,'LineageMonster.orc_champion','10','23',29,'male','L2FestivalMonster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,1026,55,'86.42002','115.00598','59.01367','69.6682165612003',253,4,0,333,125,0,0,45,110,1,1,0,1),
(18013,18013,'Offering of Branded Follower',0,'',0,'LineageMonster.orc_shaman','9','22',29,'male','L2FestivalMonster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,1227,66,'75.6175175','97.755083','59.01367','69.6682165612003',253,8,0,333,316,0,0,45,150,1,1,0,1),
(18014,18014,'Offering of Branded Berserker',0,'',0,'LineageMonster.virud_lizardman','10','23',37,'male','L2FestivalMonster',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,20,2277,140,'146.82587','144.47758','100.26304','87.5215063731059',253,4,0,333,292,0,0,43,115,1,1,0,1),
(18015,18015,'Offering of Branded Zealot',0,'',0,'LineageMonster.orc_fighter_bi','12','26.4',34,'male','L2FestivalMonster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,1651,96,'106.0570175','113.00631','82.76936','80.537480497082',253,8,0,333,158,0,0,45,155,1,1,0,1),
(18016,18016,'Offering of Branded Marksman',0,'',0,'LineageMonster.orc_archer_20_bi','16','30',32,'male','L2FestivalMonster',1100,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,1266,71,'235.8991855','106.7406795','72.49711','76.0720822329578',253,8,0,333,273,0,0,45,130,1,1,0,1),
(18017,18017,'Offering of Branded Disciple',0,'',0,'LineageMonster.batur_orc','9','21.5',34,'male','L2FestivalMonster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,1651,96,'121.20802','132.9486','82.76936','80.537480497082',253,4,0,333,129,0,0,80,165,1,1,0,1),
(18018,18018,'Offering of Branded Saint',0,'',0,'LineageMonster.batur_orc_20_bi','10','25.3',39,'male','L2FestivalMonster',40,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,2172,138,'166.06476','152.46752','113.4007','92.3616440657883',253,4,0,333,72,0,0,80,165,1,1,0,1),
(18019,18019,'Apostate\'s Offering Elder',0,'',0,'LineageMonster.orc_champion_20_bi','12','27.6',45,'male','L2FestivalMonster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,3013,210,'234.89829','177.78746','160.40508','107.69993220446',253,4,0,333,72,0,0,45,30,1,1,0,1),
(18020,18020,'Apostate\'s Offering',0,'',0,'LineageMonster.orc_fighter','12','22',43,'male','L2FestivalMonster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,2751,186,'183.79228','143.7640445','143.43577','102.457951526758',253,8,0,333,223,0,0,45,30,1,1,0,1),
(18021,18021,'Apostate\'s Offering Archer',0,'',0,'LineageMonster.batur_orc_archer','11','21.5',39,'male','L2FestivalMonster',1100,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,1880,119,'368.99589672','129.597392','113.4007','92.3616440657883',253,8,0,333,275,0,0,45,60,1,1,0,1),
(18022,18022,'Apostate\'s Offering Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10','20',40,'male','L2FestivalMonster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,1920,124,'176.36077','156.55035','120.43155','94.8349307253096',253,4,0,333,127,0,0,80,115,1,1,0,1),
(18023,18023,'Apostate\'s Offering Follower',0,'',0,'LineageMonster.batur_orc_shaman','11','16',40,'male','L2FestivalMonster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,2296,148,'154.31567375','133.0677975','120.43155','94.8349307253096',253,8,0,333,316,0,0,50,155,1,1,0,1),
(18024,18024,'Apostate\'s Offering Berserker',0,'',0,'LineageMonster.zenta_lizardman','11','32',48,'male','L2FestivalMonster',40,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,3832,280,'275.82705','191.12803','188.35412','115.781370786559',253,4,0,333,297,0,0,37,120,1,1,0,1),
(18025,18025,'Apostate\'s Offering Zealot',0,'',0,'LineageMonster.batur_orc_20_bi','10','25.3',45,'male','L2FestivalMonster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,2892,201,'205.53600375','151.119341','160.40508','107.69993220446',253,8,0,333,172,0,0,80,160,1,1,0,1),
(18026,18026,'Apostate\'s Offering Marksman',0,'',0,'LineageMonster.batur_orc_archer_20_bi','13','25.3',43,'male','L2FestivalMonster',1100,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,2285,154,'466.72736704','143.7640445','143.43577','102.457951526758',253,8,0,333,277,0,0,45,135,1,1,0,1),
(18027,18027,'Apostate\'s Offering Disciple',0,'',0,'LineageMonster.batur_orc_overlord','12','24',45,'male','L2FestivalMonster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,2892,201,'234.89829','177.78746','160.40508','107.69993220446',253,4,0,333,74,0,0,80,170,1,1,0,1),
(18028,18028,'Apostate\'s Offering Saint',0,'',0,'LineageMonster.batur_orc_overlord_20_bi','14','28.8',50,'male','L2FestivalMonster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,3570,269,'305.54906','200.23844','208.6504','121.300264676839',253,4,0,333,133,0,0,80,170,1,1,0,1),
(18029,18029,'Witch\'s Offering Elder',0,'',0,'LineageMonster.batur_orc_warrior_20_bi','12','24',56,'male','L2FestivalMonster',40,'1724.6831','918.8','6.5','2.4',40,43,30,21,20,20,4666,383,'405.96455','228.40135','277.22116','138.360771274535',253,4,0,333,133,0,0,80,30,1,1,0,1),
(18030,18030,'Witch\'s Offering',0,'',0,'LineageMonster.batur_orc','9','21.5',54,'male','L2FestivalMonster',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,4339,346,'324.35291','186.0615065','253.13256','132.602556351723',253,8,0,333,226,0,0,80,30,1,1,0,1),
(18031,18031,'Witch\'s Offering Archer',0,'',0,'LineageMonster.batur_orc_archer','11','21.5',50,'male','L2FestivalMonster',1100,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,3090,233,'678.93001132','170.202674','208.6504','121.300264676839',253,8,0,333,278,0,0,45,70,1,1,0,1),
(18032,18032,'Witch\'s Offering Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10','20',51,'male','L2FestivalMonster',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,20,3121,238,'321.13207','204.85194','219.29157','124.095027325766',253,4,0,333,72,0,0,80,120,1,1,0,1),
(18033,18033,'Witch\'s Offering Follower',0,'',0,'LineageMonster.batur_orc_shaman','11','16',51,'male','L2FestivalMonster',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,20,3733,285,'280.99056125','174.124149','219.29157','124.095027325766',253,8,0,333,316,0,0,50,160,1,1,0,1),
(18034,18034,'Witch\'s Offering Berserker',0,'',0,'LineageMonster.virud_lizardman_warrior','12','30',59,'male','L2FestivalMonster',40,'1880.92519','1007','6.5','2.4',40,43,30,21,20,20,5790,495,'461.94387','242.81593','315.44778','147.092819392229',253,4,0,333,301,0,0,52,125,1,1,0,1),
(18035,18035,'Witch\'s Offering Zealot',0,'',0,'LineageMonster.batur_orc_20_bi','10','25.3',56,'male','L2FestivalMonster',40,'1724.6831','918.8','6.5','2.4',40,43,30,21,20,20,4478,368,'355.21898125','194.1411475','277.22116','138.360771274535',253,8,0,333,91,0,0,80,165,1,1,0,1),
(18036,18036,'Witch\'s Offering Marksman',0,'',0,'LineageMonster.batur_orc_archer_20_bi','13','25.3',54,'male','L2FestivalMonster',1100,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,3604,287,'823.67104688','186.0615065','253.13256','132.602556351723',253,8,0,333,282,0,0,45,140,1,1,0,1),
(18037,18037,'Witch\'s Offering Disciple',0,'',0,'LineageMonster.batur_orc_overlord','12','24',56,'male','L2FestivalMonster',40,'1724.6831','918.8','6.5','2.4',40,43,30,21,20,20,4478,368,'405.96455','228.40135','277.22116','138.360771274535',253,4,0,333,135,0,0,80,175,1,1,0,1),
(18038,18038,'Witch\'s Offering Saint',0,'',0,'LineageMonster.batur_orc_overlord_20_bi','14','28.8',61,'male','L2FestivalMonster',40,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,5314,468,'501.08068','252.49346','342.17315','152.955267893392',253,4,0,333,79,0,0,80,175,1,1,0,1),
(18039,18039,'Dark Omen Offering Elder',0,'',0,'LineageMonster.batur_orc_warrior_20_bi','12','24',67,'male','L2FestivalMonster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,6680,636,'624.93199','281.55251','426.74754','170.55863203028',253,4,0,333,79,0,0,80,30,1,1,0,1),
(18040,18040,'Dark Omen Offering',0,'',0,'LineageMonster.batur_orc','9','21.5',65,'male','L2FestivalMonster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,6287,584,'509.96539125','231.1067805','397.98887','164.705480236154',253,8,0,333,234,0,0,80,30,1,1,0,1),
(18041,18041,'Dark Omen Offering Archer',0,'',0,'LineageMonster.batur_orc_archer','11','21.5',61,'male','L2FestivalMonster',1100,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,4599,405,'1113.40127096','214.619441','342.17315','152.955267893392',253,8,0,333,283,0,0,45,70,1,1,0,1),
(18042,18042,'Dark Omen Offering Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10','20',62,'male','L2FestivalMonster',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,4613,411,'521.12391','257.34267','355.86007','155.892816770884',253,4,0,333,133,0,0,80,125,1,1,0,1),
(18043,18043,'Dark Omen Offering Follower',0,'',0,'LineageMonster.batur_orc_shaman','11','16',62,'male','L2FestivalMonster',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,5517,492,'455.98342125','218.7412695','355.86007','155.892816770884',253,8,0,333,316,0,0,50,165,1,1,0,1),
(18044,18044,'Dark Omen Offering Berserker',0,'',0,'LineageMonster.virud_lizardman_warrior','12','30',70,'male','L2FestivalMonster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,8150,808,'688.86373','295.91597','470.40463','179.259718906208',253,4,0,333,97,0,0,52,130,1,1,0,1),
(18045,18045,'Dark Omen Offering Zealot',0,'',0,'LineageMonster.batur_orc_20_bi','10','25.3',67,'male','L2FestivalMonster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,6410,610,'546.81549125','239.3196335','426.74754','170.55863203028',253,8,0,333,2503,0,0,80,170,1,1,0,1),
(18046,18046,'Dark Omen Offering Marksman',0,'',0,'LineageMonster.batur_orc_archer_20_bi','13','25.3',65,'male','L2FestivalMonster',1100,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,5222,485,'1295.02068498','231.1067805','397.98887','164.705480236154',253,8,0,333,286,0,0,45,145,1,1,0,1),
(18047,18047,'Dark Omen Offering Disciple',0,'',0,'LineageMonster.batur_orc_overlord','12','24',67,'male','L2FestivalMonster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,6410,610,'624.93199','281.55251','426.74754','170.55863203028',253,4,0,333,142,0,0,80,180,1,1,0,1),
(18048,18048,'Dark Omen Offering Saint',0,'',0,'LineageMonster.batur_orc_overlord_20_bi','14','28.8',72,'male','L2FestivalMonster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,7403,752,'731.52506','305.35947','499.53679','184.980391055502',253,4,0,333,2500,0,0,80,180,1,1,0,1),
(18049,18049,'Offering of Forbidden Path Elder',0,'',0,'LineageMonster.batur_orc_overlord_20_bi','14','28.8',78,'male','L2FestivalMonster',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,9053,991,'855.81387','332.70061','584.40994','201.543082943943',253,4,0,333,2500,0,0,80,30,1,1,0,1),
(18050,18050,'Offering of Forbidden Path',0,'',0,'LineageMonster.batur_orc_warrior','10','20',76,'male','L2FestivalMonster',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,20,8595,919,'713.45001875','275.2168675','556.793','196.141924808093',253,8,0,333,236,0,0,80,30,1,1,0,1),
(18051,18051,'Offering of Forbidden Path Archer',0,'',0,'LineageMonster.ketra_orc_archer','12','27',78,'male','L2FestivalMonster',1100,'3010.8929976','1777.86','8.772','3.0906',40,43,30,21,20,20,8311,955,'2225.9562','314.4751494','705.7121259456','224.12052',253,8,0,333,287,0,0,45,70,1,1,0,1),
(18052,18052,'Offering of Forbidden Path Warrior',0,'',0,'LineageMonster.ketra_orc_warrior','12','24',78,'male','L2FestivalMonster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,7680,862,'912.6537108','348.2025','635.688655236','210.933802353999',253,4,0,333,79,0,0,36,130,1,1,0,1),
(18053,18053,'Offering of Forbidden Path Follower',0,'',0,'LineageMonster.ketra_orc_shaman','10','23',78,'male','L2FestivalMonster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,9185,1031,'798.57199695','295.972125','635.688655236','210.933802353999',253,8,0,333,316,0,0,10,180,1,1,0,1),
(18054,18054,'Offering of Forbidden Path Berserker',0,'',0,'LineageMonster.zenta_lizardman_warrior','13','35',78,'male','L2FestivalMonster',40,'2975.2369188','1742.976','8.721','3.0702',40,43,30,21,20,20,10912,1239,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,305,0,0,40,135,1,1,0,1),
(18055,18055,'Offering of Forbidden Path Zealot',0,'',0,'LineageMonster.ketra_orc_20_bi','14','34.8',78,'male','L2FestivalMonster',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,8688,951,'748.83713625','282.7955185','584.40994','201.543082943943',253,8,0,333,175,0,0,45,195,1,1,0,1),
(18056,18056,'Offering of Forbidden Path Marksman',0,'',0,'LineageMonster.ketra_orc_archer_20_bi','14','32.4',76,'male','L2FestivalMonster',1100,'2719.97952','1540.8','8.5','3',40,43,30,21,20,20,7139,763,'1811.7553619','275.2168675','556.793','196.141924808093',253,8,0,333,289,0,0,45,150,1,1,0,1),
(18057,18057,'Offering of Forbidden Path Disciple',0,'',0,'LineageMonster.ketra_orc_overload','12','24',78,'male','L2FestivalMonster',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,8688,951,'855.81387','332.70061','584.40994','201.543082943943',253,4,0,333,151,0,0,33,195,1,1,0,1),
(18058,18058,'Offering of Forbidden Path Saint',0,'',0,'LineageMonster.ketra_orc_overload_20_bi','14','28.8',78,'male','L2FestivalMonster',40,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,9837,1144,'1045.99572','380.7902964','742.0569674364','230.674836',253,4,0,333,2500,0,0,33,195,1,1,0,1),
(18059,18059,'Offering of Branded Elder',0,'',0,'LineageMonster.orc_fighter_bi','12','26.4',34,'male','L2FestivalMonster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,1720,100,'121.20802','132.9486','82.76936','80.537480497082',253,4,0,333,127,0,0,45,30,1,1,0,1),
(18060,18060,'Offering of the Branded',0,'',0,'LineageMonster.orc','10','21',32,'male','L2FestivalMonster',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,1524,86,'92.89459375','106.7406795','72.49711','76.0720822329578',253,8,0,333,218,0,0,45,30,1,1,0,1),
(18061,18061,'Offering of Branded Archer',0,'',0,'LineageMonster.orc_archer','14','25',28,'male','L2FestivalMonster',1100,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,1001,53,'178.96112432','94.871628','54.99876','67.6132386264202',253,8,0,333,14,0,0,45,60,1,1,0,1),
(18062,18062,'Offering of Branded Warrior',0,'',0,'LineageMonster.orc_champion','10','23',29,'male','L2FestivalMonster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,1026,55,'86.42002','115.00598','59.01367','69.6682165612003',253,4,0,333,125,0,0,45,110,1,1,0,1),
(18063,18063,'Offering of Branded Follower',0,'',0,'LineageMonster.orc_shaman','9','22',29,'male','L2FestivalMonster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,1227,66,'75.6175175','97.755083','59.01367','69.6682165612003',253,8,0,333,316,0,0,45,150,1,1,0,1),
(18064,18064,'Offering of Branded Berserker',0,'',0,'LineageMonster.virud_lizardman','10','23',37,'male','L2FestivalMonster',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,20,2277,140,'146.82587','144.47758','100.26304','87.5215063731059',253,4,0,333,292,0,0,43,115,1,1,0,1),
(18065,18065,'Offering of Branded Zealot',0,'',0,'LineageMonster.orc_fighter_bi','12','26.4',34,'male','L2FestivalMonster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,1651,96,'106.0570175','113.00631','82.76936','80.537480497082',253,8,0,333,158,0,0,45,155,1,1,0,1),
(18066,18066,'Offering of Branded Marksman',0,'',0,'LineageMonster.orc_archer_20_bi','16','30',32,'male','L2FestivalMonster',1100,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,1266,71,'235.8991855','106.7406795','72.49711','76.0720822329578',253,8,0,333,273,0,0,45,130,1,1,0,1),
(18067,18067,'Offering of Branded Disciple',0,'',0,'LineageMonster.batur_orc','9','21.5',34,'male','L2FestivalMonster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,1651,96,'121.20802','132.9486','82.76936','80.537480497082',253,4,0,333,129,0,0,80,165,1,1,0,1),
(18068,18068,'Offering of Branded Saint',0,'',0,'LineageMonster.batur_orc_20_bi','10','25.3',39,'male','L2FestivalMonster',40,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,2172,138,'166.06476','152.46752','113.4007','92.3616440657883',253,4,0,333,72,0,0,80,165,1,1,0,1),
(18069,18069,'Apostate\'s Offering Elder',0,'',0,'LineageMonster.orc_champion_20_bi','12','27.6',45,'male','L2FestivalMonster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,3013,210,'234.89829','177.78746','160.40508','107.69993220446',253,4,0,333,72,0,0,45,30,1,1,0,1),
(18070,18070,'Apostate\'s Offering',0,'',0,'LineageMonster.orc_fighter','12','22',43,'male','L2FestivalMonster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,2751,186,'183.79228','143.7640445','143.43577','102.457951526758',253,8,0,333,223,0,0,45,30,1,1,0,1),
(18071,18071,'Apostate\'s Offering Archer',0,'',0,'LineageMonster.batur_orc_archer','11','21.5',39,'male','L2FestivalMonster',1100,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,1880,119,'368.99589672','129.597392','113.4007','92.3616440657883',253,8,0,333,275,0,0,45,60,1,1,0,1),
(18072,18072,'Apostate\'s Offering Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10','20',40,'male','L2FestivalMonster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,1920,124,'176.36077','156.55035','120.43155','94.8349307253096',253,4,0,333,127,0,0,80,115,1,1,0,1),
(18073,18073,'Apostate\'s Offering Follower',0,'',0,'LineageMonster.batur_orc_shaman','11','16',40,'male','L2FestivalMonster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,2296,148,'154.31567375','133.0677975','120.43155','94.8349307253096',253,8,0,333,316,0,0,50,155,1,1,0,1),
(18074,18074,'Apostate\'s Offering Berserker',0,'',0,'LineageMonster.zenta_lizardman','11','32',48,'male','L2FestivalMonster',40,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,3832,280,'275.82705','191.12803','188.35412','115.781370786559',253,4,0,333,297,0,0,37,120,1,1,0,1),
(18075,18075,'Apostate\'s Offering Zealot',0,'',0,'LineageMonster.batur_orc_20_bi','10','25.3',45,'male','L2FestivalMonster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,2892,201,'205.53600375','151.119341','160.40508','107.69993220446',253,8,0,333,172,0,0,80,160,1,1,0,1),
(18076,18076,'Apostate\'s Offering Marksman',0,'',0,'LineageMonster.batur_orc_archer_20_bi','13','25.3',43,'male','L2FestivalMonster',1100,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,2285,154,'466.72736704','143.7640445','143.43577','102.457951526758',253,8,0,333,277,0,0,45,135,1,1,0,1),
(18077,18077,'Apostate\'s Offering Disciple',0,'',0,'LineageMonster.batur_orc_overlord','12','24',45,'male','L2FestivalMonster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,2892,201,'234.89829','177.78746','160.40508','107.69993220446',253,4,0,333,74,0,0,80,170,1,1,0,1),
(18078,18078,'Apostate\'s Offering Saint',0,'',0,'LineageMonster.batur_orc_overlord_20_bi','14','28.8',50,'male','L2FestivalMonster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,3570,269,'305.54906','200.23844','208.6504','121.300264676839',253,4,0,333,133,0,0,80,170,1,1,0,1),
(18079,18079,'Witch\'s Offering Elder',0,'',0,'LineageMonster.batur_orc_warrior_20_bi','12','24',56,'male','L2FestivalMonster',40,'1724.6831','918.8','6.5','2.4',40,43,30,21,20,20,4666,383,'405.96455','228.40135','277.22116','138.360771274535',253,4,0,333,133,0,0,80,30,1,1,0,1),
(18080,18080,'Witch\'s Offering',0,'',0,'LineageMonster.batur_orc','9','21.5',54,'male','L2FestivalMonster',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,4339,346,'324.35291','186.0615065','253.13256','132.602556351723',253,8,0,333,226,0,0,80,30,1,1,0,1),
(18081,18081,'Witch\'s Offering Archer',0,'',0,'LineageMonster.batur_orc_archer','11','21.5',50,'male','L2FestivalMonster',1100,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,3090,233,'678.93001132','170.202674','208.6504','121.300264676839',253,8,0,333,278,0,0,45,70,1,1,0,1),
(18082,18082,'Witch\'s Offering Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10','20',51,'male','L2FestivalMonster',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,20,3121,238,'321.13207','204.85194','219.29157','124.095027325766',253,4,0,333,72,0,0,80,120,1,1,0,1),
(18083,18083,'Witch\'s Offering Follower',0,'',0,'LineageMonster.batur_orc_shaman','11','16',51,'male','L2FestivalMonster',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,20,3733,285,'280.99056125','174.124149','219.29157','124.095027325766',253,8,0,333,316,0,0,50,160,1,1,0,1),
(18084,18084,'Witch\'s Offering Berserker',0,'',0,'LineageMonster.virud_lizardman_warrior','12','30',59,'male','L2FestivalMonster',40,'1880.92519','1007','6.5','2.4',40,43,30,21,20,20,5790,495,'461.94387','242.81593','315.44778','147.092819392229',253,4,0,333,301,0,0,52,125,1,1,0,1),
(18085,18085,'Witch\'s Offering Zealot',0,'',0,'LineageMonster.batur_orc_20_bi','10','25.3',56,'male','L2FestivalMonster',40,'1724.6831','918.8','6.5','2.4',40,43,30,21,20,20,4478,368,'355.21898125','194.1411475','277.22116','138.360771274535',253,8,0,333,91,0,0,80,165,1,1,0,1),
(18086,18086,'Witch\'s Offering Marksman',0,'',0,'LineageMonster.batur_orc_archer_20_bi','13','25.3',54,'male','L2FestivalMonster',1100,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,3604,287,'823.67104688','186.0615065','253.13256','132.602556351723',253,8,0,333,282,0,0,45,140,1,1,0,1),
(18087,18087,'Witch\'s Offering Disciple',0,'',0,'LineageMonster.batur_orc_overlord','12','24',56,'male','L2FestivalMonster',40,'1724.6831','918.8','6.5','2.4',40,43,30,21,20,20,4478,368,'405.96455','228.40135','277.22116','138.360771274535',253,4,0,333,135,0,0,80,175,1,1,0,1),
(18088,18088,'Witch\'s Offering Saint',0,'',0,'LineageMonster.batur_orc_overlord_20_bi','14','28.8',61,'male','L2FestivalMonster',40,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,5314,468,'501.08068','252.49346','342.17315','152.955267893392',253,4,0,333,79,0,0,80,175,1,1,0,1),
(18089,18089,'Dark Omen Offering Elder',0,'',0,'LineageMonster.batur_orc_warrior_20_bi','12','24',67,'male','L2FestivalMonster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,6680,636,'624.93199','281.55251','426.74754','170.55863203028',253,4,0,333,79,0,0,80,30,1,1,0,1),
(18090,18090,'Dark Omen Offering',0,'',0,'LineageMonster.batur_orc','9','21.5',65,'male','L2FestivalMonster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,6287,584,'509.96539125','231.1067805','397.98887','164.705480236154',253,8,0,333,234,0,0,80,30,1,1,0,1),
(18091,18091,'Dark Omen Offering Archer',0,'',0,'LineageMonster.batur_orc_archer','11','21.5',61,'male','L2FestivalMonster',1100,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,4599,405,'1113.40127096','214.619441','342.17315','152.955267893392',253,8,0,333,283,0,0,45,70,1,1,0,1),
(18092,18092,'Dark Omen Offering Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10','20',62,'male','L2FestivalMonster',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,4613,411,'521.12391','257.34267','355.86007','155.892816770884',253,4,0,333,133,0,0,80,125,1,1,0,1),
(18093,18093,'Dark Omen Offering Follower',0,'',0,'LineageMonster.batur_orc_shaman','11','16',62,'male','L2FestivalMonster',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,5517,492,'455.98342125','218.7412695','355.86007','155.892816770884',253,8,0,333,316,0,0,50,165,1,1,0,1),
(18094,18094,'Dark Omen Offering Berserker',0,'',0,'LineageMonster.virud_lizardman_warrior','12','30',70,'male','L2FestivalMonster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,8150,808,'688.86373','295.91597','470.40463','179.259718906208',253,4,0,333,97,0,0,52,130,1,1,0,1),
(18095,18095,'Dark Omen Offering Zealot',0,'',0,'LineageMonster.batur_orc_20_bi','10','25.3',67,'male','L2FestivalMonster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,6410,610,'546.81549125','239.3196335','426.74754','170.55863203028',253,8,0,333,2503,0,0,80,170,1,1,0,1),
(18096,18096,'Dark Omen Offering Marksman',0,'',0,'LineageMonster.batur_orc_archer_20_bi','13','25.3',65,'male','L2FestivalMonster',1100,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,5222,485,'1295.02068498','231.1067805','397.98887','164.705480236154',253,8,0,333,286,0,0,45,145,1,1,0,1),
(18097,18097,'Dark Omen Offering Disciple',0,'',0,'LineageMonster.batur_orc_overlord','12','24',67,'male','L2FestivalMonster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,6410,610,'624.93199','281.55251','426.74754','170.55863203028',253,4,0,333,142,0,0,80,180,1,1,0,1),
(18098,18098,'Dark Omen Offering Saint',0,'',0,'LineageMonster.batur_orc_overlord_20_bi','14','28.8',72,'male','L2FestivalMonster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,7403,752,'731.52506','305.35947','499.53679','184.980391055502',253,4,0,333,2500,0,0,80,180,1,1,0,1),
(18099,18099,'Offering of Forbidden Path Elder',0,'',0,'LineageMonster.batur_orc_overlord_20_bi','14','28.8',78,'male','L2FestivalMonster',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,9053,991,'855.81387','332.70061','584.40994','201.543082943943',253,4,0,333,2500,0,0,80,30,1,1,0,1),
(18100,18100,'Offering of Forbidden Path',0,'',0,'LineageMonster.batur_orc_warrior','10','20',76,'male','L2FestivalMonster',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,20,8595,919,'713.45001875','275.2168675','556.793','196.141924808093',253,8,0,333,236,0,0,80,30,1,1,0,1),
(18101,18101,'Offering of Forbidden Path Archer',0,'',0,'LineageMonster.ketra_orc_archer','12','27',78,'male','L2FestivalMonster',1100,'3010.8929976','1777.86','8.772','3.0906',40,43,30,21,20,20,8311,955,'2225.9562','314.4751494','705.7121259456','224.12052',253,8,0,333,287,0,0,45,70,1,1,0,1),
(18102,18102,'Offering of Forbidden Path Warrior',0,'',0,'LineageMonster.ketra_orc_warrior','12','24',78,'male','L2FestivalMonster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,7680,862,'912.6537108','348.2025','635.688655236','210.933802353999',253,4,0,333,79,0,0,36,130,1,1,0,1),
(18103,18103,'Offering of Forbidden Path Follower',0,'',0,'LineageMonster.ketra_orc_shaman','10','23',78,'male','L2FestivalMonster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,9185,1031,'798.57199695','295.972125','635.688655236','210.933802353999',253,8,0,333,316,0,0,10,180,1,1,0,1),
(18104,18104,'Offering of Forbidden Path Berserker',0,'',0,'LineageMonster.zenta_lizardman_warrior','13','35',78,'male','L2FestivalMonster',40,'2975.2369188','1742.976','8.721','3.0702',40,43,30,21,20,20,10912,1239,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,305,0,0,40,135,1,1,0,1),
(18105,18105,'Offering of Forbidden Path Zealot',0,'',0,'LineageMonster.ketra_orc_20_bi','14','34.8',78,'male','L2FestivalMonster',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,8688,951,'748.83713625','282.7955185','584.40994','201.543082943943',253,8,0,333,175,0,0,45,195,1,1,0,1),
(18106,18106,'Offering of Forbidden Path Marksman',0,'',0,'LineageMonster.ketra_orc_archer_20_bi','14','32.4',76,'male','L2FestivalMonster',1100,'2719.97952','1540.8','8.5','3',40,43,30,21,20,20,7139,763,'1811.7553619','275.2168675','556.793','196.141924808093',253,8,0,333,289,0,0,45,150,1,1,0,1),
(18107,18107,'Offering of Forbidden Path Disciple',0,'',0,'LineageMonster.ketra_orc_overload','12','24',78,'male','L2FestivalMonster',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,8688,951,'855.81387','332.70061','584.40994','201.543082943943',253,4,0,333,151,0,0,33,195,1,1,0,1),
(18108,18108,'Offering of Forbidden Path Saint',0,'',0,'LineageMonster.ketra_orc_overload_20_bi','14','28.8',78,'male','L2FestivalMonster',40,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,9837,1144,'1045.99572','380.7902964','742.0569674364','230.674836',253,4,0,333,2500,0,0,33,195,1,1,0,1),
(18109,18109,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.5','8.5',30,'male','L2FestivalMonster',40,'632.8549633','329.4','3.5','1.5',40,43,30,21,20,20,90,0,'0','118.46','0','71.7656545291881',253,1,0,333,0,0,0,80,195,1,1,0,1),
(18110,18110,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.5','8.5',41,'male','L2FestivalMonster',40,'942.3925179','504.8','5.5','2.1',40,43,30,21,20,20,168,0,'0','160.69','0','97.3459836250728',253,1,0,333,0,0,0,80,195,1,1,0,1),
(18111,18111,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.5','8.5',52,'male','L2FestivalMonster',40,'1302.758046','804','6.5','2.4',40,43,30,21,20,20,270,0,'0','209.5','0','126.908234441282',253,1,0,333,0,0,0,80,195,1,1,0,1),
(18112,18112,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.5','8.5',63,'male','L2FestivalMonster',40,'1671.377796','1127.4','7.5','2.7',40,43,30,21,20,20,397,0,'0','262.19','0','158.829835915776',253,1,0,333,0,0,0,80,195,1,1,0,1),
(18113,18113,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.5','8.5',72,'male','L2FestivalMonster',40,'1938.889453','1410','8.5','3',40,43,30,21,20,20,518,0,'0','305.36','0','184.981376274429',253,1,0,333,0,0,0,80,195,1,1,0,1),
(18114,18114,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.5','8.5',30,'male','L2FestivalMonster',40,'632.8549633','329.4','3.5','1.5',40,43,30,21,20,20,90,0,'0','118.46','0','71.7656545291881',253,1,0,333,0,0,0,80,195,1,1,0,1),
(18115,18115,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.5','8.5',41,'male','L2FestivalMonster',40,'942.3925179','504.8','5.5','2.1',40,43,30,21,20,20,168,0,'0','160.69','0','97.3459836250728',253,1,0,333,0,0,0,80,195,1,1,0,1),
(18116,18116,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.5','8.5',52,'male','L2FestivalMonster',40,'1302.758046','804','6.5','2.4',40,43,30,21,20,20,270,0,'0','209.5','0','126.908234441282',253,1,0,333,0,0,0,80,195,1,1,0,1),
(18117,18117,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.5','8.5',63,'male','L2FestivalMonster',40,'1671.377796','1127.4','7.5','2.7',40,43,30,21,20,20,397,0,'0','262.19','0','158.829835915776',253,1,0,333,0,0,0,80,195,1,1,0,1),
(18118,18118,'Treasures of the Festival',0,'',0,'LineageMonster.mimic','8.5','8.5',72,'male','L2FestivalMonster',40,'1938.889453','1410','8.5','3',40,43,30,21,20,20,518,0,'0','305.36','0','184.981376274429',253,1,0,333,0,0,0,80,195,1,1,0,1),
(18119,18119,'Corpse of Deadman',0,'',0,'LineageMonster.zombie_corpse','13','21',63,'male','L2Monster',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,0,0,'541.44774','262.19426','369.73862','158.831806262641',253,4,0,333,0,0,0,15,1,1,1,0,1),
(18120,18120,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9','36',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,58584,6652,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,134,6721,0,39,150,1,1,0,1),
(18121,18121,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9','36',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,55563,6309,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,134,6721,0,39,150,1,1,0,1),
(18122,18122,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9','36',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,42434,4818,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,134,6721,0,39,150,1,1,0,1),
(18123,18123,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9','36',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,58584,6652,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,134,6721,0,39,150,1,1,0,1),
(18124,18124,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9','36',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,55563,6309,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,134,6721,0,39,150,1,1,0,1),
(18125,18125,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9','36',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,42434,4818,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,134,6721,0,39,150,1,1,0,1),
(18126,18126,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9','36',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,58584,6652,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,134,6721,0,39,150,1,1,0,1),
(18127,18127,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9','36',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,55563,6309,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,134,6721,0,39,150,1,1,0,1),
(18128,18128,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9','36',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,42434,4818,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,134,6721,0,39,150,1,1,0,1),
(18129,18129,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9','36',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,58584,6652,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,134,6721,0,39,150,1,1,0,1),
(18130,18130,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9','36',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,55563,6309,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,134,6721,0,39,150,1,1,0,1),
(18131,18131,'Halisha\'s Officer',0,'',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9','36',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,42434,4818,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,134,6721,0,39,150,1,1,0,1),
(18132,18132,'Imperial Healer',0,'',0,'LineageMonster2.tera_beetle','19','54.5',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,59699,6779,'791.661474','478.1237352','457.930728288','289.637364',253,4,0,333,0,0,0,45,170,1,1,0,1),
(18133,18133,'Imperial Mosaic',0,'',0,'LineageMonster2.scorpion','28','66',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,55141,6261,'838.171536','359.2214376','670.4563793364','217.60884',253,8,0,333,0,0,0,37,170,1,1,0,1),
(18134,18134,'Imperial Mosaic',0,'',0,'LineageMonster2.scorpion','28','66',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,41438,4705,'838.171536','359.2214376','670.4563793364','217.60884',253,8,0,333,0,0,0,37,170,1,1,0,1),
(18135,18135,'Imperial Mosaic',0,'',0,'LineageMonster2.scorpion','28','66',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,54900,6234,'838.171536','359.2214376','670.4563793364','217.60884',253,8,0,333,0,0,0,37,170,1,1,0,1),
(18136,18136,'Imperial Mosaic',0,'',0,'LineageMonster2.scorpion','28','66',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,55141,6261,'761.97417','434.6579448','554.0961810204','263.306676',253,8,0,333,0,0,0,37,170,1,1,0,1),
(18137,18137,'Imperial Mosaic',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,40876,4641,'957.910356','359.2214376','670.4563793364','217.60884',253,1,0,333,0,0,0,45,180,1,1,0,1),
(18138,18138,'Imperial Mosaic',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,54418,6179,'957.910356','359.2214376','670.4563793364','217.60884',253,1,0,333,0,0,0,45,180,1,1,0,1),
(18139,18139,'Imperial Mosaic',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,53615,6088,'957.910356','359.2214376','670.4563793364','217.60884',253,1,0,333,0,0,0,45,180,1,1,0,1),
(18140,18140,'Imperial Mosaic',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,54394,6176,'870.827652','434.6579448','554.0961810204','263.306676',253,1,0,333,0,0,0,45,180,1,1,0,1),
(18141,18141,'Beetle of Grave',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','34.884','3.0702',40,43,30,21,20,20,34982,3972,'1542.7245','245.3530746','1738.991176812','148.62981',253,1,0,333,0,0,0,45,180,1,1,0,1),
(18142,18142,'Beetle of Grave',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','34.884','3.0702',40,43,30,21,20,20,34982,3972,'1542.7245','245.3530746','1738.991176812','148.62981',253,1,0,333,0,0,0,45,180,1,1,0,1),
(18143,18143,'Beetle of Grave',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','34.884','3.0702',40,43,30,21,20,20,34982,3972,'1542.7245','245.3530746','1738.991176812','148.62981',253,1,0,333,0,0,0,45,180,1,1,0,1),
(18144,18144,'Beetle of Grave',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','34.884','3.0702',40,43,30,21,20,20,34982,3972,'1542.7245','245.3530746','1738.991176812','148.62981',253,1,0,333,0,0,0,45,180,1,1,0,1),
(18145,18145,'Beetle of Grave',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','34.884','3.0702',40,43,30,21,20,20,29597,3361,'1274.97858','296.877222','1187.754369768','179.842014',253,1,0,333,0,0,0,45,180,1,1,0,1),
(18146,18146,'Beetle of Grave',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','34.884','3.0702',40,43,30,21,20,20,30276,3438,'1274.97858','296.877222','1187.754369768','179.842014',253,1,0,333,0,0,0,45,180,1,1,0,1),
(18147,18147,'Beetle of Grave',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','34.884','3.0702',40,43,30,21,20,20,28188,3201,'1274.97858','296.877222','1187.754369768','179.842014',253,1,0,333,0,0,0,45,180,1,1,0,1),
(18148,18148,'Beetle of Grave',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','34.884','3.0702',40,43,30,21,20,20,32814,3726,'1274.97858','296.877222','1187.754369768','179.842014',253,1,0,333,0,0,0,45,180,1,1,0,1),
(18149,18149,'Beetle of Grave',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','34.884','3.0702',40,43,30,21,20,20,28991,3292,'1274.97858','296.877222','1187.754369768','179.842014',253,1,0,333,0,0,0,45,180,1,1,0,1),
(18150,18150,'Victim',0,'',0,'LineageNPC.a_tombkeeperA','8','23',78,'female','L2SepulcherMonster',40,'2975.2369188','1742.976','8.721','3.0702',40,43,30,21,20,20,0,0,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18151,18151,'Victim',0,'',0,'LineageNPC.a_tombkeeperA','8','23',78,'female','L2SepulcherMonster',40,'2975.2369188','1742.976','8.721','3.0702',40,43,30,21,20,20,0,0,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18152,18152,'Victim',0,'',0,'LineageNPC.a_tombkeeperA','8','23',78,'female','L2SepulcherMonster',40,'2975.2369188','1742.976','8.721','3.0702',40,43,30,21,20,20,0,0,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18153,18153,'Victim',0,'',0,'LineageNPC.a_tombkeeperA','8','23',78,'female','L2SepulcherMonster',40,'2975.2369188','1742.976','8.721','3.0702',40,43,30,21,20,20,0,0,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18154,18154,'Victim',0,'',0,'LineageNPC.a_tombkeeperA','8','23',78,'female','L2SepulcherMonster',40,'2975.2369188','1742.976','8.721','3.0702',40,43,30,21,20,20,0,0,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18155,18155,'Victim',0,'',0,'LineageNPC.a_tombkeeperA','8','23',78,'female','L2SepulcherMonster',40,'2975.2369188','1742.976','8.721','3.0702',40,43,30,21,20,20,0,0,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18156,18156,'Victim',0,'',0,'LineageNPC.a_tombkeeperA','8','23',78,'female','L2SepulcherMonster',40,'2975.2369188','1742.976','8.721','3.0702',40,43,30,21,20,20,0,0,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18157,18157,'Victim',0,'',0,'LineageNPC.a_tombkeeperA','8','23',78,'female','L2SepulcherMonster',40,'2975.2369188','1742.976','8.721','3.0702',40,43,30,21,20,20,0,0,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18158,18158,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes','21','50',78,'male','L2SepulcherMonster',40,'17851.4215128','1742.976','52.326','3.0702',40,43,30,21,20,20,0,0,'1159.0719','629.5247322','981.6151849884','197.826246',253,1,0,333,0,0,0,31,150,1,1,0,1),
(18159,18159,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes','21','50',78,'male','L2SepulcherMonster',40,'17851.4215128','1742.976','52.326','3.0702',40,43,30,21,20,20,0,0,'1159.0719','326.5649442','981.6151849884','381.352908',253,1,0,333,0,0,0,31,150,1,1,0,1),
(18160,18160,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes','21','50',78,'male','L2SepulcherMonster',40,'17851.4215128','1742.976','52.326','3.0702',40,43,30,21,20,20,0,0,'1159.0719','629.5247322','981.6151849884','197.826246',253,1,0,333,0,0,0,31,150,1,1,0,1),
(18161,18161,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes','21','50',78,'male','L2SepulcherMonster',40,'17851.4215128','1742.976','52.326','3.0702',40,43,30,21,20,20,0,0,'1159.0719','326.5649442','981.6151849884','381.352908',253,1,0,333,0,0,0,31,150,1,1,0,1),
(18162,18162,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes','21','50',78,'male','L2SepulcherMonster',40,'17851.4215128','1742.976','52.326','3.0702',40,43,30,21,20,20,0,0,'1159.0719','629.5247322','981.6151849884','197.826246',253,1,0,333,0,0,0,31,150,1,1,0,1),
(18163,18163,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes','21','50',78,'male','L2SepulcherMonster',40,'17851.4215128','1742.976','52.326','3.0702',40,43,30,21,20,20,0,0,'1159.0719','326.5649442','981.6151849884','381.352908',253,1,0,333,0,0,0,31,150,1,1,0,1),
(18164,18164,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes','21','50',78,'male','L2SepulcherMonster',40,'17851.4215128','1742.976','52.326','3.0702',40,43,30,21,20,20,0,0,'1159.0719','629.5247322','981.6151849884','197.826246',253,1,0,333,0,0,0,31,150,1,1,0,1),
(18165,18165,'Executioner of Halisha',0,'',0,'LineageMonster2.erinyes','21','50',78,'male','L2SepulcherMonster',40,'17851.4215128','1742.976','52.326','3.0702',40,43,30,21,20,20,0,0,'1159.0719','326.5649442','981.6151849884','381.352908',253,1,0,333,0,0,0,31,150,1,1,0,1),
(18166,18166,'Imperial Guard',0,'',0,'LineageMonster.death_knight','12','31',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,42032,4773,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,142,0,0,27,110,1,1,0,1),
(18167,18167,'Imperial Guard',0,'',0,'LineageMonster.death_knight','12','31',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,41438,4705,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,142,0,0,27,110,1,1,0,1),
(18168,18168,'Imperial Guard',0,'',0,'LineageMonster.death_knight','12','31',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,42595,4837,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,142,0,0,27,110,1,1,0,1),
(18169,18169,'Imperial Guard',0,'',0,'LineageMonster.death_knight','12','31',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,41237,4683,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,142,0,0,27,110,1,1,0,1),
(18170,18170,'Imperial Guard',0,'',0,'LineageMonster.doll_master','20','42',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,41278,4687,'1115.60664','296.877222','1187.754369768','179.842014',253,8,0,333,0,0,0,80,160,1,1,0,1),
(18171,18171,'Imperial Guard',0,'',0,'LineageMonster.doll_master','20','42',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,42884,4869,'692.703828','478.1237352','457.930728288','289.637364',253,8,0,333,0,0,0,80,160,1,1,0,1),
(18172,18172,'Imperial Guard',0,'',0,'LineageMonster.doll_master','20','42',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,40876,4641,'838.171536','359.2214376','670.4563793364','217.60884',253,8,0,333,0,0,0,80,160,1,1,0,1),
(18173,18173,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,45345,5149,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,0,0,0,37,160,1,1,0,1),
(18174,18174,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,55932,6351,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,0,0,0,37,160,1,1,0,1),
(18175,18175,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,42803,4860,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,0,0,0,37,160,1,1,0,1),
(18176,18176,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,45345,5149,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,0,0,0,37,160,1,1,0,1),
(18177,18177,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,55932,6351,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,0,0,0,37,160,1,1,0,1),
(18178,18178,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,42803,4860,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,0,0,0,37,160,1,1,0,1),
(18179,18179,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,45345,5149,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,0,0,0,37,160,1,1,0,1),
(18180,18180,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,55932,6351,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,0,0,0,37,160,1,1,0,1),
(18181,18181,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,42803,4860,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,0,0,0,37,160,1,1,0,1),
(18182,18182,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,45345,5149,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,0,0,0,37,160,1,1,0,1),
(18183,18183,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,55932,6351,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,0,0,0,37,160,1,1,0,1),
(18184,18184,'Halisha\'s Foreman',0,'',0,'LineageMonster.kaim_vanul','24','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,42803,4860,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,0,0,0,37,160,1,1,0,1),
(18185,18185,'Evil Astrologer',0,'',0,'LineageMonster.doll_blader','6','12',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,56482,6414,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,5129,5129,0,22,150,1,1,0,1),
(18186,18186,'Evil Astrologer',0,'',0,'LineageMonster.doll_blader','6','12',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,56803,6450,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,5129,5129,0,22,150,1,1,0,1),
(18187,18187,'Knight of Darkness',0,'',0,'LineageMonster.death_lord','21','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,55141,6261,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,78,0,0,40,160,1,1,0,1),
(18188,18188,'Knight of Darkness',0,'',0,'LineageMonster.death_lord','21','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,41438,4705,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,78,0,0,40,160,1,1,0,1),
(18189,18189,'Knight of Darkness',0,'',0,'LineageMonster.death_lord','21','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,54900,6234,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,78,0,0,40,160,1,1,0,1),
(18190,18190,'Knight of Darkness',0,'',0,'LineageMonster.death_lord','21','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,55141,6261,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,78,0,0,40,160,1,1,0,1),
(18191,18191,'Witch of dust',0,'',0,'LineageMonster.banshee','9','23',78,'female','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,40876,4641,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,3939,0,0,80,160,1,1,0,1),
(18192,18192,'Witch of dust',0,'',0,'LineageMonster.banshee','9','23',78,'female','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,54418,6179,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,3939,0,0,80,160,1,1,0,1),
(18193,18193,'Witch of dust',0,'',0,'LineageMonster.banshee','9','23',78,'female','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,53615,6088,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,3939,0,0,80,160,1,1,0,1),
(18194,18194,'Witch of dust',0,'',0,'LineageMonster.banshee','9','23',78,'female','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,54394,6176,'1159.0719','326.5649442','981.6151849884','197.826246',253,4,0,333,3939,0,0,80,160,1,1,0,1),
(18195,18195,'Signet of Emperor',0,'',0,'LineageMonster.ant_larva','12','8',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,41679,4733,'1542.7245','245.3530746','1738.991176812','148.62981',253,4,0,333,0,0,0,40,60,1,1,0,1),
(18196,18196,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,136143,15459,'654.265638','578.52972','312.7728489192','350.461188',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18197,18197,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,136143,15459,'654.265638','578.52972','312.7728489192','350.461188',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18198,18198,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,136143,15459,'654.265638','578.52972','312.7728489192','350.461188',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18199,18199,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,136143,15459,'654.265638','578.52972','312.7728489192','350.461188',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18200,18200,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,136143,15459,'654.265638','578.52972','312.7728489192','350.461188',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18201,18201,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,136143,15459,'654.265638','578.52972','312.7728489192','350.461188',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18202,18202,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,136143,15459,'654.265638','578.52972','312.7728489192','350.461188',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18203,18203,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,136143,15459,'654.265638','578.52972','312.7728489192','350.461188',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18204,18204,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,136143,15459,'654.265638','578.52972','312.7728489192','350.461188',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18205,18205,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,136143,15459,'654.265638','578.52972','312.7728489192','350.461188',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18206,18206,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,136143,15459,'654.265638','578.52972','312.7728489192','350.461188',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18207,18207,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,136143,15459,'654.265638','578.52972','312.7728489192','350.461188',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18208,18208,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,136143,15459,'654.265638','578.52972','312.7728489192','350.461188',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18209,18209,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,136143,15459,'654.265638','578.52972','312.7728489192','350.461188',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18210,18210,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,136143,15459,'654.265638','578.52972','312.7728489192','350.461188',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18211,18211,'Charm of Corner',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,136143,15459,'654.265638','578.52972','312.7728489192','350.461188',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18212,18212,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes','14','57.75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,173610,19713,'791.661474','478.1237352','457.930728288','289.637364',253,4,0,333,6722,0,0,35,185,1,1,0,1),
(18213,18213,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes','14','57.75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,173610,19713,'791.661474','478.1237352','457.930728288','289.637364',253,4,0,333,6722,0,0,35,185,1,1,0,1),
(18214,18214,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes','14','57.75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,173610,19713,'791.661474','478.1237352','457.930728288','289.637364',253,4,0,333,6722,0,0,35,185,1,1,0,1),
(18215,18215,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes','14','57.75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,173610,19713,'791.661474','478.1237352','457.930728288','289.637364',253,4,0,333,6722,0,0,35,185,1,1,0,1),
(18216,18216,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes','14','57.75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,173610,19713,'791.661474','478.1237352','457.930728288','289.637364',253,4,0,333,6722,0,0,35,185,1,1,0,1),
(18217,18217,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes','14','57.75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,173610,19713,'791.661474','478.1237352','457.930728288','289.637364',253,4,0,333,6722,0,0,35,185,1,1,0,1),
(18218,18218,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes','14','57.75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,173610,19713,'791.661474','478.1237352','457.930728288','289.637364',253,4,0,333,6722,0,0,35,185,1,1,0,1),
(18219,18219,'Archon of Halisha',0,'',0,'LineageMonster2.ahrimanes','14','57.75',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,173610,19713,'791.661474','478.1237352','457.930728288','289.637364',253,4,0,333,6722,0,0,35,185,1,1,0,1),
(18220,18220,'Shaman of Darkness',0,'',0,'LineageMonster.banshee','9','23',78,'female','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,56803,6450,'1053.70182','359.2214376','811.2522194028','217.60884',253,4,0,333,3939,0,0,80,160,1,1,0,1),
(18221,18221,'Shaman of Darkness',0,'',0,'LineageMonster.banshee','9','23',78,'female','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,58329,6623,'1053.70182','359.2214376','811.2522194028','217.60884',253,4,0,333,3939,0,0,80,160,1,1,0,1),
(18222,18222,'Assassin of Darkness',0,'',0,'LineageMonster2.ashuras','13','37.5',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,55261,6275,'1274.97858','296.877222','1187.754369768','179.842014',253,4,0,333,0,0,0,41,190,1,1,0,1),
(18223,18223,'Assassin of Darkness',0,'',0,'LineageMonster2.ashuras','13','37.5',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,41438,4705,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,0,0,0,41,190,1,1,0,1),
(18224,18224,'Assassin of Darkness',0,'',0,'LineageMonster2.ashuras','13','37.5',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,55823,6339,'1274.97858','296.877222','1187.754369768','179.842014',253,4,0,333,0,0,0,41,190,1,1,0,1),
(18225,18225,'Assassin of Darkness',0,'',0,'LineageMonster2.ashuras','13','37.5',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,55261,6275,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,0,0,0,41,190,1,1,0,1),
(18226,18226,'Caster of Darkness',0,'',0,'LineageMonster.vale_master','12','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,40876,4641,'1274.97858','296.877222','1187.754369768','179.842014',253,4,0,333,0,0,0,70,155,1,1,0,1),
(18227,18227,'Caster of Darkness',0,'',0,'LineageMonster.vale_master','12','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,70240,7976,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,0,0,0,70,155,1,1,0,1),
(18228,18228,'Caster of Darkness',0,'',0,'LineageMonster.vale_master','12','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,52812,5997,'1274.97858','296.877222','1187.754369768','179.842014',253,4,0,333,0,0,0,70,155,1,1,0,1),
(18229,18229,'Caster of Darkness',0,'',0,'LineageMonster.vale_master','12','40',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,54394,6176,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,0,0,0,70,155,1,1,0,1),
(18230,18230,'Signet of Emperor',0,'',0,'LineageMonster.ant_larva','12','8',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','26.163','3.0702',40,43,30,21,20,20,22486,2553,'1542.7245','245.3530746','1738.991176812','148.62981',253,4,0,333,0,0,0,40,60,1,1,0,1),
(18231,18231,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15','42',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,66895,7596,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,5795,0,0,53,140,1,1,0,1),
(18232,18232,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15','42',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,66895,7596,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,5795,0,0,53,140,1,1,0,1),
(18233,18233,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15','42',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,66895,7596,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,5795,0,0,53,140,1,1,0,1),
(18234,18234,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15','42',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,66895,7596,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,5795,0,0,53,140,1,1,0,1),
(18235,18235,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15','42',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,66895,7596,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,5795,0,0,53,140,1,1,0,1),
(18236,18236,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15','42',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,66895,7596,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,5795,0,0,53,140,1,1,0,1),
(18237,18237,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15','42',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,66895,7596,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,5795,0,0,53,140,1,1,0,1),
(18238,18238,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15','42',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,66895,7596,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,5795,0,0,53,140,1,1,0,1),
(18239,18239,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15','42',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,66895,7596,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,5795,0,0,53,140,1,1,0,1),
(18240,18240,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15','42',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,66895,7596,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,5795,0,0,53,140,1,1,0,1),
(18241,18241,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15','42',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,66895,7596,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,5795,0,0,53,140,1,1,0,1),
(18242,18242,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15','42',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,66895,7596,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,5795,0,0,53,140,1,1,0,1),
(18243,18243,'Statue of Protection',0,'',0,'LineageMonster2.temple_guard_a','15','42',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','52.326','3.0702',40,43,30,21,20,20,66895,7596,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,5795,0,0,53,140,1,1,0,1),
(18244,18244,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11','20',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','26.163','3.0702',40,43,30,21,20,20,0,0,'1274.97858','296.877222','1187.754369768','179.842014',253,4,0,333,0,0,0,90,1,1,1,0,1),
(18245,18245,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11','20',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','26.163','3.0702',40,43,30,21,20,20,0,0,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,0,0,0,90,1,1,1,0,1),
(18246,18246,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11','20',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','26.163','3.0702',40,43,30,21,20,20,0,0,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,0,0,0,90,1,1,1,0,1),
(18247,18247,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11','20',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','26.163','3.0702',40,43,30,21,20,20,0,0,'1274.97858','296.877222','1187.754369768','179.842014',253,4,0,333,0,0,0,90,1,1,1,0,1),
(18248,18248,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11','20',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','26.163','3.0702',40,43,30,21,20,20,0,0,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,0,0,0,90,1,1,1,0,1),
(18249,18249,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11','20',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','26.163','3.0702',40,43,30,21,20,20,0,0,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,0,0,0,90,1,1,1,0,1),
(18250,18250,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11','20',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','26.163','3.0702',40,43,30,21,20,20,0,0,'1274.97858','296.877222','1187.754369768','179.842014',253,4,0,333,0,0,0,90,1,1,1,0,1),
(18251,18251,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11','20',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','26.163','3.0702',40,43,30,21,20,20,0,0,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,0,0,0,90,1,1,1,0,1),
(18252,18252,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11','20',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','26.163','3.0702',40,43,30,21,20,20,0,0,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,0,0,0,90,1,1,1,0,1),
(18253,18253,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11','20',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','26.163','3.0702',40,43,30,21,20,20,0,0,'1274.97858','296.877222','1187.754369768','179.842014',253,4,0,333,0,0,0,90,1,1,1,0,1),
(18254,18254,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11','20',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','26.163','3.0702',40,43,30,21,20,20,0,0,'870.827652','434.6579448','554.0961810204','263.306676',253,4,0,333,0,0,0,90,1,1,1,0,1),
(18255,18255,'Watchman of Grave',0,'',0,'LineageMonster.mana_vampire','11','20',78,'male','L2SepulcherMonster',40,'2975.2369188','1742.976','26.163','3.0702',40,43,30,21,20,20,0,0,'957.910356','359.2214376','670.4563793364','217.60884',253,4,0,333,0,0,0,90,1,1,1,0,1),
(18256,18256,'Halisha\'s Treasure Box',0,'',0,'LineageMonster.mimic','8.5','8.5',78,'male','L2SepulcherMonster',40,'1.07','1.07','0','0',40,43,30,21,20,20,0,0,'1.07','1.07','1.1449','1.07',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18257,18257,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',78,'male','L2Chest',40,'3365.21163635201','1976.076','3.21','3.21',40,43,30,21,20,20,0,0,'1051.86125409763','399.609375916493','768.56482605536','242.075013751218',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18258,18258,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',78,'male','L2Chest',40,'3365.21163635201','1976.076','3.21','3.21',40,43,30,21,20,20,0,0,'1051.86125409763','399.609375916493','768.56482605536','242.075013751218',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18259,18259,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',78,'male','L2Chest',40,'3365.21163635201','1976.076','3.21','3.21',40,43,30,21,20,20,0,0,'1051.86125409763','399.609375916493','768.56482605536','242.075013751218',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18260,18260,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',78,'male','L2Chest',40,'3365.21163635201','1976.076','3.21','3.21',40,43,30,21,20,20,0,0,'1051.86125409763','399.609375916493','768.56482605536','242.075013751218',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18261,18261,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',78,'male','L2Chest',40,'3365.21163635201','1976.076','3.21','3.21',40,43,30,21,20,20,0,0,'1051.86125409763','399.609375916493','768.56482605536','242.075013751218',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18262,18262,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',78,'male','L2Chest',40,'3365.21163635201','1976.076','3.21','3.21',40,43,30,21,20,20,0,0,'1051.86125409763','399.609375916493','768.56482605536','242.075013751218',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18263,18263,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',78,'male','L2Chest',40,'3365.21163635201','1976.076','3.21','3.21',40,43,30,21,20,20,0,0,'1051.86125409763','399.609375916493','768.56482605536','242.075013751218',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18264,18264,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',78,'male','L2Chest',40,'3365.21163635201','1976.076','3.21','3.21',40,43,30,21,20,20,0,0,'1051.86125409763','399.609375916493','768.56482605536','242.075013751218',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18265,18265,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',21,'male','L2Chest',40,'376.063268689487','205.2','1.5','1.5',40,43,30,21,20,20,0,0,'47.919244061454','92.6271011629928','32.7226319401133','56.1115632895055',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18266,18266,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',24,'male','L2Chest',40,'449.397334531729','245.52','1.5','1.5',40,43,30,21,20,20,0,0,'60.1968712618897','101.895537364058','41.1066597737442','61.7261883679349',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18267,18267,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',27,'male','L2Chest',40,'531.808581237041','286.92','1.5','1.5',40,43,30,21,20,20,0,0,'74.9912095047522','111.783212013997','51.2092750090322','67.7159351522403',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18268,18268,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',30,'male','L2Chest',40,'623.584092631874','329.4','1.5','1.5',40,43,30,21,20,20,0,0,'92.6422612424255','122.288315384748','63.2626552465637','74.0797073634453',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18269,18269,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',33,'male','L2Chest',40,'724.871874675055','372.96','1.8','1.8',40,43,30,21,20,20,0,0,'113.490654511985','133.402537046416','77.4994052801751','80.8124707220912',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18270,18270,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',36,'male','L2Chest',40,'835.657991997797','417.6','1.8','1.8',40,43,30,21,20,20,0,0,'137.864667408402','145.110489684918','94.1436964941632','87.9049039361612',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18271,18271,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',39,'male','L2Chest',40,'955.745616539336','463.32','1.8','1.8',40,43,30,21,20,20,0,0,'166.064758291296','157.389194069391','113.400702999844','95.3430865027814',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18272,18272,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',42,'male','L2Chest',40,'1084.73699369686','531','2.1','2.1',40,43,30,21,20,20,0,0,'198.345907305602','170.207642394119','135.444543183224','103.108234870087',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18273,18273,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',45,'male','L2Chest',40,'1222.01933711761','610.8','2.1','2.1',40,43,30,21,20,20,0,0,'234.898291890002','183.526457130741','160.405083582293','111.176494647742',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18274,18274,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',48,'male','L2Chest',40,'1366.75562200403','692.4','2.1','2.1',40,43,30,21,20,20,0,0,'275.827045436369','197.297661947999','188.354116675298','119.518802878289',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18275,18275,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',51,'male','L2Chest',40,'1517.88115502146','775.8','2.4','2.4',40,43,30,21,20,20,0,0,'321.132066836175','211.464580155089','219.291573418222','128.100826028764',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18276,18276,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',54,'male','L2Chest',40,'1674.10665553836','861','2.4','2.4',40,43,30,21,20,20,0,0,'370.689038937507','225.961874482666','253.132561311492','136.882984193537',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18277,18277,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',57,'male','L2Chest',40,'1833.9283898078','948','2.4','2.4',40,43,30,21,20,20,0,0,'424.232953977617','240.715739831843','289.696114406012','145.820567650029',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18278,18278,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',60,'male','L2Chest',40,'1995.64566170597','1036.8','2.4','2.4',40,43,30,21,20,20,0,0,'481.345512250945','255.644257913984','328.696588226919','154.86395213652',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18279,18279,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',63,'male','L2Chest',40,'2157.38568876994','1127.4','2.7','2.7',40,43,30,21,20,20,0,0,'541.447737693314','270.657919510939','369.738617174833','163.958914671767',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18280,18280,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',66,'male','L2Chest',40,'2317.13559141445','1219.8','2.7','2.7',40,43,30,21,20,20,0,0,'603.799026906932','285.660316465035','412.316465133206','173.047053464993',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18281,18281,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',69,'male','L2Chest',40,'2472.78090975059','1314','2.7','2.7',40,43,30,21,20,20,0,0,'667.503610065512','300.549001539213','455.818437428996','182.066307912763',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18282,18282,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',72,'male','L2Chest',40,'2622.14975164374','1410','3','3',40,43,30,21,20,20,0,0,'731.525056113249','315.216510067462','499.536786003261','190.951578227804',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18283,18283,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',75,'male','L2Chest',40,'2763.06138388172','1507.8','3','3',40,43,30,21,20,20,0,0,'794.709014189014','329.551532957763','542.683238855925','199.635435691959',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18284,18284,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',78,'male','L2Chest',40,'2893.37782205212','1607.4','3','3',40,43,30,21,20,20,0,0,'855.813872406402','343.440226241281','584.409936018261','208.048916072236',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18285,18285,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',78,'male','L2Chest',40,'3101.38847262351','1760.064','3.09','3.1003',40,43,30,21,20,20,0,0,'967.301634','374.4526066','683.6670250269','226.835561',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18286,18286,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',78,'male','L2Chest',40,'3301.05636251825','1920.72','3.18','3.18',40,43,30,21,20,20,0,0,'1024.61236488433','391.584384310193','741.658070600305','237.213641422467',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18287,18287,'Otherworldly Invader Food',0,'',0,'LineageMonster.mimic','8.5','8.5',33,'male','L2Chest',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,0,0,'113.49065','129.23095','77.49941','78.2854098527333',253,4,0,333,0,0,0,80,165,1,1,0,1),
(18288,18288,'Otherworldly Invader Food',0,'',0,'LineageMonster.mimic','8.5','8.5',35,'male','L2Chest',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,0,0,'129.32896','136.72948','88.31491','82.8278636923005',253,4,0,333,0,0,0,80,165,1,1,0,1),
(18289,18289,'Dimension Invader Food',0,'',0,'LineageMonster.mimic','8.5','8.5',43,'male','L2Chest',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,0,0,'210.04832','169.13417','143.43577','102.457951526758',253,4,0,333,0,0,0,80,165,1,1,0,1),
(18290,18290,'Dimension Invader Food',0,'',0,'LineageMonster.mimic','8.5','8.5',45,'male','L2Chest',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,0,0,'234.89829','177.78746','160.40508','107.69993220446',253,4,0,333,0,0,0,80,165,1,1,0,1),
(18291,18291,'Purgatory Invader Food',0,'',0,'LineageMonster.mimic','8.5','8.5',53,'male','L2Chest',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,0,0,'353.71092','214.18326','241.5387','129.747742025171',253,4,0,333,0,0,0,80,165,1,1,0,1),
(18292,18292,'Purgatory Invader Food',0,'',0,'LineageMonster.mimic','8.5','8.5',55,'male','L2Chest',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,0,0,'388.11142','223.6362','265.02979','135.474142874948',253,4,0,333,0,0,0,80,165,1,1,0,1),
(18293,18293,'Forbidden Path Invader Food',0,'',0,'LineageMonster.mimic','8.5','8.5',63,'male','L2Chest',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,0,0,'541.44774','262.19426','369.73862','158.831806262641',253,4,0,333,0,0,0,80,165,1,1,0,1),
(18294,18294,'Forbidden Path Invader Food',0,'',0,'LineageMonster.mimic','8.5','8.5',65,'male','L2Chest',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,0,0,'582.81759','271.89033','397.98887','164.705480236154',253,4,0,333,0,0,0,80,165,1,1,0,1),
(18295,18295,'Dark Omen Invader Food',0,'',0,'LineageMonster.mimic','8.5','8.5',73,'male','L2Chest',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,0,0,'752.73928','310.02959','514.02335','187.809451297099',253,4,0,333,0,0,0,80,165,1,1,0,1),
(18296,18296,'Dark Omen Invader Food',0,'',0,'LineageMonster.mimic','8.5','8.5',75,'male','L2Chest',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,0,0,'794.70901','319.24623','542.68324','193.392693413113',253,4,0,333,0,0,0,80,165,1,1,0,1),
(18297,18297,'Messenger Invader Food',0,'',0,'LineageMonster.mimic','8.5','8.5',78,'male','L2Chest',40,'3134.442675','1866.27','8.925','3.15',40,43,30,21,20,20,0,0,'997.0002105','371.554512','714.862995525','225.079967926901',253,4,0,333,0,0,0,80,165,1,1,0,1),
(18298,18298,'Messenger Invader Food',0,'',0,'LineageMonster.mimic','8.5','8.5',78,'male','L2Chest',40,'3259.9791329','1976.076','9.095','3.21',40,43,30,21,20,20,0,0,'1051.861253','387.1133098','768.564821172','234.505158381112',253,4,0,333,0,0,0,80,165,1,1,0,1),
(18299,18299,'Flame of the Branded',0,'',0,'LineageMonster.big_boom','6','13',35,'male','L2Npc',40,'2318.21406','402.6','13.5','1.8',40,43,30,21,20,20,4894,290,'129.32896','136.72948','88.31491','82.8278636923005',253,1,0,333,0,0,0,48,30,1,1,0,1),
(18300,18300,'Offering of the Branded Evoked Spirit',0,'',0,'LineageMonster.orc','10','21',33,'male','L2Npc',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,1751,100,'113.49065','129.23095','77.49941','78.2854098527333',253,4,0,333,158,0,0,45,155,1,1,0,1),
(18301,18301,'Flame of Apostates',0,'',0,'LineageMonster.big_boom','6','13',46,'male','L2Npc',40,'3689.36034','637.8','16.5','2.1',40,43,30,21,20,20,8454,599,'248.0526','182.18816','169.38777','110.365783306098',253,1,0,333,0,0,0,48,30,1,1,0,1),
(18302,18302,'Offering of Apostates Evoked Spirit',0,'',0,'LineageMonster.orc_fighter','12','22',44,'male','L2Npc',40,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,3113,213,'222.23112','173.43552','151.75505','105.063618563116',253,4,0,333,172,0,0,45,160,1,1,0,1),
(18303,18303,'Flame of the Witch',0,'',0,'LineageMonster.big_boom','6','13',57,'male','L2Npc',40,'5329.74054','948','19.5','2.4',40,43,30,21,20,20,12980,1079,'424.23295','233.18839','289.69611','141.260653361756',253,1,0,333,0,0,0,48,30,1,1,0,1),
(18304,18304,'Offering of the Witch Evoked Spirit',0,'',0,'LineageMonster.batur_orc','9','21.5',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,4864,393,'388.11142','223.6362','265.02979','135.474142874948',253,4,0,333,91,0,0,80,165,1,1,0,1),
(18305,18305,'Flame of Dark Omen',0,'',0,'LineageMonster.big_boom','6','13',68,'male','L2Npc',40,'7037.30094','1282.4','22.5','2.7',40,43,30,21,20,20,18473,1784,'646.17968','286.3615','441.25696','173.471817575614',253,1,0,333,0,0,0,48,30,1,1,0,1),
(18306,18306,'Offering of Dark Omen Evoked Spirit',0,'',0,'LineageMonster.batur_orc','9','21.5',66,'male','L2Npc',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,7004,659,'603.79903','276.72752','412.31647','167.635752432965',253,4,0,333,2503,0,0,80,170,1,1,0,1),
(18307,18307,'Flame of Forbidden Path',0,'',0,'LineageMonster.big_boom','6','13',78,'male','L2Npc',40,'8612.3322261','1657.41','25.755','3.03',40,43,30,21,20,20,24933,2763,'884.2525659','340.4407808','609.868172336','206.231917983858',253,1,0,333,0,0,0,48,30,1,1,0,1),
(18308,18308,'Offering of /Forbidden Path Evoked Spirit',0,'',0,'LineageMonster.batur_orc_warrior','10','20',77,'male','L2Npc',40,'2762.08447','1574','8.5','3',40,43,30,21,20,20,9534,1032,'835.75573','328.27073','570.71283','198.859549127918',253,4,0,333,175,0,0,80,175,1,1,0,1),
(18309,18309,'Flame of the Branded',0,'',0,'LineageMonster.big_boom','6','13',35,'male','L2Npc',40,'2318.21406','402.6','13.5','1.8',40,43,30,21,20,20,4894,290,'129.32896','136.72948','88.31491','82.8278636923005',253,1,0,333,0,0,0,48,30,1,1,0,1),
(18310,18310,'Offering of the Branded Evoked Spirit',0,'',0,'LineageMonster.orc','10','21',33,'male','L2Npc',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,1751,100,'113.49065','129.23095','77.49941','78.2854098527333',253,4,0,333,158,0,0,45,155,1,1,0,1),
(18311,18311,'Flame of Apostates',0,'',0,'LineageMonster.big_boom','6','13',46,'male','L2Npc',40,'3689.36034','637.8','16.5','2.1',40,43,30,21,20,20,8454,599,'248.0526','182.18816','169.38777','110.365783306098',253,1,0,333,0,0,0,48,30,1,1,0,1),
(18312,18312,'Offering of Apostates Evoked Spirit',0,'',0,'LineageMonster.orc_fighter','12','22',44,'male','L2Npc',40,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,3113,213,'222.23112','173.43552','151.75505','105.063618563116',253,4,0,333,172,0,0,45,160,1,1,0,1),
(18313,18313,'Flame of the Witch',0,'',0,'LineageMonster.big_boom','6','13',57,'male','L2Npc',40,'5329.74054','948','19.5','2.4',40,43,30,21,20,20,12980,1079,'424.23295','233.18839','289.69611','141.260653361756',253,1,0,333,0,0,0,48,30,1,1,0,1),
(18314,18314,'Offering of the Witch Evoked Spirit',0,'',0,'LineageMonster.batur_orc','9','21.5',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,4864,393,'388.11142','223.6362','265.02979','135.474142874948',253,4,0,333,91,0,0,80,165,1,1,0,1),
(18315,18315,'Flame of Dark Omen',0,'',0,'LineageMonster.big_boom','6','13',68,'male','L2Npc',40,'7037.30094','1282.4','22.5','2.7',40,43,30,21,20,20,18473,1784,'646.17968','286.3615','441.25696','173.471817575614',253,1,0,333,0,0,0,48,30,1,1,0,1),
(18316,18316,'Offering of Dark Omen Evoked Spirit',0,'',0,'LineageMonster.batur_orc','9','21.5',66,'male','L2Npc',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,7004,659,'603.79903','276.72752','412.31647','167.635752432965',253,4,0,333,2503,0,0,80,170,1,1,0,1),
(18317,18317,'Flame of Forbidden Path',0,'',0,'LineageMonster.big_boom','6','13',78,'male','L2Npc',40,'8527.06161','1641','25.5','3',40,43,30,21,20,20,24933,2763,'875.49759','337.07008','609.868172336','204.1900178058',253,1,0,333,0,0,0,48,30,1,1,0,1),
(18318,18318,'Offering of Forbidden Path Evoked Spirit',0,'',0,'LineageMonster.batur_orc_warrior','10','20',77,'male','L2Npc',40,'2762.08447','1574','8.5','3',40,43,30,21,20,20,9534,1032,'835.75573','328.27073','570.71283','198.859549127918',253,4,0,333,175,0,0,80,175,1,1,0,1),
(18319,18319,'Caught Frog',0,'',0,'LineageMonster.poison_toad','20','10',10,'male','L2PenaltyMonster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,422,14,'19.33758','52.5514795','13.20506','37.4524577768779',253,1,0,333,0,0,0,50,110,1,1,0,1),
(18320,18320,'Caught Undine',0,'',0,'LineageMonster.undine','12','27',20,'female','L2PenaltyMonster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,844,37,'44.32863','73.8399165','30.2707','52.6243330671097',253,4,0,333,0,0,0,60,120,1,1,0,1),
(18321,18321,'Caught Rakul',0,'',0,'LineageMonster.rakul','30','39',30,'male','L2PenaltyMonster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,1550,85,'92.64226','100.6946295','63.26266','71.7631875602859',253,1,0,333,156,0,0,60,130,1,1,0,1),
(18322,18322,'Caught Sea Giant',0,'',0,'LineageMonster.water_giant','13','44',40,'male','L2PenaltyMonster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,2756,178,'176.36077','133.0677975','120.43155','94.8349307253096',253,4,0,333,131,0,0,35,140,1,1,0,1),
(18323,18323,'Caught Sea Horse Soldier',0,'',0,'LineageMonster.theeder','9','32',50,'male','L2PenaltyMonster',80,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,4306,324,'305.54906','170.202674','208.6504','121.300264676839',253,4,0,333,291,0,0,80,150,1,1,0,1),
(18324,18324,'Caught Homunculus',0,'',0,'LineageMonster2.homunculus','12','32.5',60,'male','L2PenaltyMonster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,6200,538,'481.34551','210.502568','328.69659','150.021245531891',253,4,0,333,0,0,0,30,160,1,1,0,1),
(18325,18325,'Caught Flava',0,'',0,'LineageMonster2.flava','18','34',70,'male','L2PenaltyMonster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,8439,837,'688.86373','251.5285745','470.40463','179.259718906208',253,1,0,333,0,0,0,30,170,1,1,0,1),
(18326,18326,'Caught Gigantic Eye',0,'',0,'LineageMonster2.hundred_eye','21','55',78,'male','L2PenaltyMonster',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,20,11022,1237,'894.75854','290.16875','635.688655236','206.797845445097',253,1,0,333,0,0,0,30,180,1,1,0,1),
(18327,18327,'Freya\'s Servant',0,'',0,'LineageMonster.gargoyle_02te','16','50',58,'male','L2Monster',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,20,0,0,'387.5368','237.99429','302.44274','158.4514992',253,8,500,333,0,0,0,140,140,1,1,0,1),
(18328,18328,'Hall Alarm Device',0,'',0,'LineageNPC.grave_keeper_key','8','21',83,'male','L2Monster',40,'100000','1846.8','8.8','3.1',40,43,30,21,20,20,0,0,'1034.34087','378.92625','760.9193205984','277.281785',253,4,0,333,0,0,0,50,1,1,1,0,1),
(18329,18329,'Hall Keeper Captain',0,'',0,'LineageMonster.death_lord','21','40',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,78,0,0,40,160,1,1,0,1),
(18330,18330,'Hall Keeper Wizard',0,'',0,'LineageMonster.vale_master','12','40',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,326,0,0,70,175,1,1,0,1),
(18331,18331,'Hall Keeper Guard',0,'',0,'LineageMonster.death_knight','12','31',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,142,0,0,27,110,1,1,0,1),
(18332,18332,'Hall Keeper Patrol',0,'',0,'LineageMonster.headless_knight','21','31',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,124,0,0,70,170,1,1,0,1),
(18333,18333,'Hall Keeper Suicidal Soldier',0,'',0,'LineageMonster3.self_blaster','9','25.8',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,30,150,1,1,0,1),
(18334,18334,'Dark Choir Captain',0,'',0,'LineageMonster2.erinyes_cmd','21','50',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,1,0,333,0,0,0,31,150,1,1,0,1),
(18335,18335,'Dark Choir Prima Donna',0,'',0,'LineageMonster3.portrait_spirit','23','40',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,30,200,1,1,0,1),
(18336,18336,'Dark Choir Lancer',0,'',0,'LineageMonster.death_blader','15','45',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,1472,0,0,100,180,1,1,0,1),
(18337,18337,'Dark Choir Archer',0,'',0,'LineageMonster.skeleton_archer_20_bi','13','32.5',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,1,0,333,279,0,0,40,140,1,1,0,1),
(18338,18338,'Dark Choir Witch Doctor',0,'',0,'LineageMonster3.portrait_spirit_winged','23','40',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,30,190,1,1,0,1),
(18339,18339,'Dark Choir Player',0,'',0,'LineageMonster.skeleton','11','25',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,150,103,0,60,140,1,1,0,1),
(18340,18340,'Hall Keeper Suicidal Soldier',0,'',0,'LineageMonster3.self_blaster','9','25.8',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,30,100,1,1,0,1),
(18341,18341,'Hall Keeper Suicidal Soldier',0,'',0,'LineageMonster3.self_blaster','9','25.8',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,30,150,1,1,0,1),
(18342,18342,'Gremlin',0,'',0,'LineageMonster.gremlin','10','15',1,'male','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,29,2,'8.47458','44.44444','5.78704','29.59016164',253,4,0,333,0,0,0,20,50,1,1,0,1),
(18343,18343,'Gatekeeper Zombie',0,'',0,'LineageMonster3.zombie_gateguard','17','30.5',78,'male','L2Monster',40,'2985.1835','1777.4','8.65','3.05',40,43,30,21,20,20,0,0,'1025.486','373.32382','742.0569674364','273.1822',253,1,500,333,8217,0,0,33,120,1,1,0,1),
(18344,18344,'Ancient Egg',0,'',0,'LineageNpcEV.dinosaur_nest','53','11.5',78,'etc','L2Monster',40,'10','1881.8','8.5','3',40,43,30,21,20,20,0,0,'998.77667','365.6202','709.589203596','267.545',253,1,0,333,0,0,0,50,100,1,1,0,1),
(18345,18345,'Sprigant',0,'',0,'LineageMonster3.Arachnoid','45','67',78,'female','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,8267,961,'890.50085998804','332.70061','608.096657928153','243.45587',253,1,500,333,0,0,0,60,165,1,1,0,1),
(18346,18346,'Sprigant',0,'',0,'LineageMonster3.Arachnoid','45','67',78,'female','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,8267,961,'890.50085998804','332.70061','608.096657928153','243.45587',253,1,500,333,0,0,0,60,150,1,1,0,1),
(18347,18347,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter','15.5','22.5',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,708,31,'44.32863','86.87049','30.2707','63.56806',253,4,600,333,0,0,0,36,120,1,1,0,1),
(18348,18348,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter','15.5','22.5',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,949,35,'47.91924','89.73059','32.72263','65.66095',253,4,600,333,0,0,0,36,110,1,1,0,1),
(18349,18349,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Gunner','15','24.5',21,'male','L2Monster',700,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,907,41,'47.91924','89.73059','32.72263','65.66095',253,10,600,333,10128,0,0,36,110,1,1,0,1),
(18350,18350,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter','15.5','22.5',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,1000,35,'47.91924','89.73059','32.72263','65.66095',253,4,600,333,0,0,0,36,110,1,1,0,1),
(18351,18351,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter','15.5','22.5',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,952,35,'47.91924','89.73059','32.72263','65.66095',253,4,600,333,0,0,0,36,110,1,1,0,1),
(18352,18352,'Kamael Guard',0,'',0,'LineageMonster4.Mostro_Fighter','15.5','22.5',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,1808,68,'51.75278','92.65694','35.34044','67.80232',253,4,200,333,0,0,0,36,130,1,1,0,1),
(18353,18353,'Guardian of Records',0,'',0,'LineageMonster4.Mostro_Fighter','15.5','22.5',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,2401,99,'51.75278','92.65694','35.34044','67.80232',253,4,200,333,0,0,0,36,130,1,1,0,1),
(18354,18354,'Guardian of Observation',0,'',0,'LineageMonster4.Mostro_Fighter','15.5','22.5',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,1808,68,'51.75278','92.65694','35.34044','67.80232',253,4,200,333,0,0,0,36,130,1,1,0,1),
(18355,18355,'Spicula\'s Guard',0,'',0,'LineageMonster4.Mostro_Fighter','15.5','22.5',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,2542,99,'51.75278','92.65694','35.34044','67.80232',253,4,200,333,0,0,0,36,130,1,1,0,1),
(18356,18356,'Harkilgamed\'s Gatekeeper',0,'',0,'LineageMonster4.Mostro_Gunner','15','24.5',22,'male','L2Monster',700,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,2470,111,'51.75278','92.65694','35.34044','67.80232',253,10,200,333,10128,0,0,36,130,1,1,0,1),
(18357,18357,'Rodenpicula\'s Gatekeeper',0,'',0,'LineageMonster4.Mostro_Fighter','15.5','22.5',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,2401,99,'51.75278','92.65694','35.34044','67.80232',253,4,200,333,0,0,0,36,130,1,1,0,1),
(18358,18358,'Guardian of Secrets',0,'',0,'LineageMonster4.Mostro_Fighter','15.5','22.5',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,1808,68,'51.75278','92.65694','35.34044','67.80232',253,4,200,333,0,0,0,36,130,1,1,0,1),
(18359,18359,'Arviterre\'s Guardian',0,'',0,'LineageMonster4.Mostro_Fighter','15.5','22.5',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,1808,68,'51.75278','92.65694','35.34044','67.80232',253,4,200,333,0,0,0,36,130,1,1,0,1),
(18360,18360,'Katenar\'s Gatekeeper',0,'',0,'LineageMonster4.Mostro_Fighter','15.5','22.5',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,1808,68,'51.75278','92.65694','35.34044','67.80232',253,4,200,333,0,0,0,36,130,1,1,0,1),
(18361,18361,'Guardian of Prediction',0,'',0,'LineageMonster4.Mostro_Fighter','15.5','22.5',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,2401,99,'51.75278','92.65694','35.34044','67.80232',253,4,200,333,0,0,0,36,130,1,1,0,1),
(18362,18362,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter','15.5','22.5',19,'male','L2Monster',40,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,742,30,'40.96915','84.07638','27.97662','61.52345',253,4,600,333,0,0,0,36,120,1,1,0,1),
(18363,18363,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Gunner','15','24.5',19,'male','L2Monster',700,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,670,29,'40.96915','84.07638','27.97662','61.52345',253,10,600,333,10128,0,0,36,110,1,1,0,1),
(18364,18364,'Witch Warder',0,'',0,'LineageMonster.onyx_beast','14','14.5',79,'male','L2Monster',40,'2842.35387','1641','8.5','3',40,43,30,21,20,20,0,0,'875.49759','337.07008','597.85136','246.65326',253,4,0,333,0,0,0,30,170,1,1,0,1),
(18365,18365,'Witch Warder',0,'',0,'LineageMonster.onyx_beast','14','14.5',80,'male','L2Monster',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,20,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,0,0,0,30,170,1,1,0,1),
(18366,18366,'Witch Warder',0,'',0,'LineageMonster.onyx_beast','14','14.5',82,'male','L2Monster',40,'2951.85588','1743','8.5','3',40,43,30,21,20,20,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,30,170,1,1,0,1),
(18367,18367,'Prison Guard',0,'',0,'LineageMonster3.zombie_gateguard','17','30.5',80,'male','L2Monster',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,20,0,0,'894.75854','341.375','611.00409','249.80341',253,4,0,333,8217,0,0,33,50,1,1,0,1),
(18368,18368,'Prison Guard',0,'',0,'LineageMonster3.zombie_gateguard','17','30.5',80,'male','L2Monster',40,'2880.37628','1674.8','8.5','3',40,43,30,21,20,20,8579,962,'894.75854','341.375','611.00409','249.80341',253,4,500,333,8217,0,0,33,160,1,1,0,1),
(18369,18369,'Chromatic Crystalline Golem',0,'',0,'LineageMonster4.Crystal_Golem','34','47',82,'male','L2Monster',40,'2951.85588','1743','8.5','3',40,43,30,21,20,20,9308,1017,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,54,170,1,1,0,1),
(18370,18370,'Chromatic Crystalline Golem',0,'',0,'LineageMonster4.Crystal_Golem','34','47',82,'male','L2Monster',40,'2951.85588','1743','8.5','3',40,43,30,21,20,20,8545,934,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,54,170,1,1,0,1),
(18371,18371,'Beleth Sample',0,'',0,'LineageMonster3.zombie_gateguard','17','30.5',82,'male','L2Monster',40,'2951.85588','1743','8.5','3',40,43,30,21,20,20,7697,841,'931.81944','349.77477','636.31188','255.95',253,4,0,333,8217,0,0,33,50,1,1,0,1),
(18372,18372,'Beleth Sample',0,'',0,'LineageMonster3.zombie_laborer','11','24.6',82,'male','L2Monster',40,'2951.85588','1743','8.5','3',40,43,30,21,20,20,7697,841,'931.81944','349.77477','636.31188','255.95',253,4,0,333,123,0,0,36,180,1,1,0,1),
(18373,18373,'Beleth Sample',0,'',0,'LineageMonster3.zombie_enlisted_man','17','22.3',82,'male','L2Monster',40,'2951.85588','1743','8.5','3',40,43,30,21,20,20,7697,841,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,38,200,1,1,0,1),
(18374,18374,'Beleth Sample',0,'',0,'LineageMonster3.zombie_em_knight','17','22.3',82,'male','L2Monster',40,'2951.85588','1743','8.5','3',40,43,30,21,20,20,7697,841,'931.81944','349.77477','636.31188','255.95',253,4,0,333,8215,0,0,38,200,1,1,0,1),
(18375,18375,'Beleth Sample',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',82,'male','L2Monster',40,'2951.85588','1743','8.5','3',40,43,30,21,20,20,7697,841,'931.81944','349.77477','636.31188','255.95',253,4,0,333,946,945,0,80,15,1,1,0,1),
(18376,18376,'Beleth Sample',0,'',0,'LineageMonster.vale_master','12','40',82,'male','L2Monster',40,'2951.85588','1743','8.5','3',40,43,30,21,20,20,7697,841,'931.81944','349.77477','636.31188','255.95',253,4,0,333,205,0,0,70,155,1,1,0,1),
(18377,18377,'Beleth Sample',0,'',0,'LineageMonster.skeleton_knight','10','25',82,'male','L2Monster',40,'2951.85588','1743','8.5','3',40,43,30,21,20,20,7697,841,'931.81944','349.77477','636.31188','255.95',253,4,0,333,150,103,0,40,160,1,1,0,1),
(18378,18378,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_switch','19','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18379,18379,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18380,18380,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18381,18381,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18382,18382,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18383,18383,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18384,18384,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18385,18385,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18386,18386,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18387,18387,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18388,18388,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18389,18389,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18390,18390,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18391,18391,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18392,18392,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18393,18393,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18394,18394,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18395,18395,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18396,18396,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18397,18397,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18398,18398,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18399,18399,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18400,18400,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18401,18401,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18402,18402,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18403,18403,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18404,18404,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18405,18405,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18406,18406,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18407,18407,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18408,18408,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18409,18409,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18410,18410,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18411,18411,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18412,18412,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18413,18413,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18414,18414,'Warrior\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',18,'etc','L2Npc',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,0,0,'37.82932','81.34791','25.83252','59.52687',253,4,0,333,0,0,0,50,1,1,1,0,1),
(18415,18415,'Midway Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',18,'etc','L2Npc',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,0,0,'37.82932','81.34791','25.83252','59.52687',253,4,0,333,0,0,0,50,1,1,1,0,1),
(18416,18416,'Doorman',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',18,'etc','L2Npc',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,0,0,'37.82932','81.34791','25.83252','59.52687',253,4,0,333,0,0,0,50,1,1,1,0,1),
(18417,18417,'Bridge Keeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',18,'etc','L2Npc',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,0,0,'37.82932','81.34791','25.83252','59.52687',253,4,0,333,0,0,0,50,1,1,1,0,1),
(18418,18418,'Bridge Keeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',18,'etc','L2Npc',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,0,0,'37.82932','81.34791','25.83252','59.52687',253,4,0,333,0,0,0,50,1,1,1,0,1),
(18419,18419,'Bridge Keeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',18,'etc','L2Npc',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,0,0,'37.82932','81.34791','25.83252','59.52687',253,4,0,333,0,0,0,50,1,1,1,0,1),
(18420,18420,'Trap',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',18,'etc','L2Npc',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,0,0,'37.82932','81.34791','25.83252','59.52687',253,4,0,333,0,0,0,50,1,1,1,0,1),
(18427,18427,'',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18428,18428,'',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18429,18429,'',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18430,18430,'',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18431,18431,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',70,'etc','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18432,18432,'Trap',0,'',0,'LineageNpcEV.Trap_device_wall_switch','24','38',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18433,18433,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18434,18434,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18435,18435,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18436,18436,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18437,18437,'Trap',0,'',0,'LineageNPC.clear_npc','0.1','0.1',18,'male','L2Npc',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,0,0,'37.82932','81.34791','25.83252','59.52687',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18438,18438,'Trap',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',15,'etc','L2Npc',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,0,0,'37.82932','81.34791','25.83252','59.52687',253,4,0,333,0,0,0,50,1,1,1,0,1),
(18441,18441,'Kamael Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',18,'etc','L2Npc',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,0,0,'37.82932','81.34791','25.83252','59.52687',253,4,0,333,0,0,0,50,1,1,1,0,1),
(18442,18442,'Trap',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',18,'etc','L2Npc',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,0,0,'37.82932','81.34791','25.83252','59.52687',253,4,0,333,0,0,0,50,1,1,1,0,1),
(18443,18443,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',78,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,1,160,1,1,0,1),
(18444,18444,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter','15.5','22.5',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,816,36,'44.32863','86.87049','30.2707','63.56806',253,4,600,333,0,0,0,36,120,1,1,0,1),
(18445,18445,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',80,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18446,18446,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',80,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18447,18447,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',80,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18448,18448,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',80,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18449,18449,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',80,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18450,18450,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',80,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18451,18451,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',80,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18452,18452,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',80,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18453,18453,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',80,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18454,18454,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',80,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18455,18455,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',80,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18456,18456,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',80,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18457,18457,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',80,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18458,18458,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',80,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18459,18459,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',80,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18460,18460,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',80,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18461,18461,'Tully\'s Gatekeeper',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',80,'etc','L2Npc',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,0,0,'855.81387','332.70061','584.40994','243.45587',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18463,18463,'Remnant Diabolist',0,'',0,'LineageNPC.e_traderB_Fdwarf_mon_120p','8','22',81,'female','L2Monster',1100,'65918.4456223521','1708.8','113.26544062045','3',40,43,30,21,20,20,260217,28102,'5655.33185929606','572.839225223529','3907.29217709046','628.768339764706',253,8,400,333,8527,0,0,49,160,1,1,0,1),
(18464,18464,'Remnant Diviner',0,'',0,'LineageNPC.a_mageguild_teacher_Mhuman_mon','8','23',81,'male','L2Monster',40,'65918.4456223521','1708.8','113.26544062045','3',40,43,30,21,20,20,254867,27524,'5655.33185929606','572.839225223529','3907.29217709046','628.768339764706',253,4,400,333,8532,0,0,50,160,1,1,0,1),
(18465,18465,'Derek',0,'First Generation Seer',0,'LineageNPC.a_mageguild_teacher_Mhuman_mon_120p','10','28.1',81,'male','L2Monster',40,'338766.60216791','1708.8','194.030406814438','3',40,43,30,21,20,20,1067320,115266,'7824.36514865752','572.839225223529','5405.88624976893','628.768339764706',253,4,0,333,8678,0,0,50,160,1,1,0,1),
(18466,18466,'Outpost Captain',0,'',0,'LineageMonster3.benom','20','56',81,'male','L2Monster',40,'111546.700057767','1846.8','187.260794107867','3',40,43,30,21,20,20,0,0,'9311.83314853711','592.481283388235','6508.39315054715','650.328136094118',253,4,300,333,8203,8203,0,79,220,1,1,0,1),
(18467,18467,'Wounded Land Guard',0,'',0,'LineageMonster4.eyeless','36','43.5',81,'male','L2Monster',40,'336061.04901983','1812','189.142969481803','3',40,43,30,21,20,20,0,0,'7957.47325738098','582.692054494118','5529.81543471775','639.583141129412',253,4,0,333,0,0,0,60,210,1,1,0,1),
(18468,18468,'Doorman',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',18,'etc','L2Npc',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,0,0,'37.82932','81.34791','25.83252','59.52687',253,4,0,333,0,0,0,50,1,1,1,0,1),
(18469,18469,'Hall Guard',0,'',0,'LineageMonster.blade_stakato_120p','18','43.2',83,'male','L2Npc',40,'32829.2831947712','1777.4','111.50705124295','3',40,43,30,21,20,20,253630,26086,'5815.28895362847','566.178304','3971.08850697278','621.45708',253,4,0,333,0,0,0,25,180,1,1,0,1),
(18470,18470,'Hall Guard',0,'',0,'LineageMonster.blade_stakato_soldier_120p','23','45.5',83,'male','L2Npc',40,'32829.2831947712','1777.4','111.50705124295','3',40,43,30,21,20,20,103029,11126,'5815.28895362847','566.178304','3971.08850697278','621.45708',253,4,0,333,0,0,0,25,180,1,1,0,1),
(18471,18471,'Hall Guard',0,'',0,'LineageMonster4.Anthias','20','41',83,'male','L2Npc',40,'32829.2831947712','1777.4','111.50705124295','3',40,43,30,21,20,20,45987,4761,'5815.28895362847','566.178304','3971.08850697278','621.45708',253,4,0,333,0,0,0,60,180,1,1,0,1),
(18472,18472,'Hall Guard',0,'',0,'LineageMonster4.Anthias','20','41',83,'male','L2Npc',40,'32829.2831947712','1777.4','111.50705124295','3',40,43,30,21,20,20,112394,12138,'5815.28895362847','566.178304','3971.08850697278','621.45708',253,4,0,333,0,0,0,60,180,1,1,0,1),
(18473,18473,'Hall Captain',0,'',0,'LineageMonster3.cannibal_stakato_leader_120p','34','48.8',83,'male','L2Npc',40,'336949.124088359','1777.4','190.745373183435','3',40,43,30,21,20,20,724449,78237,'7733.38415855685','566.178304','5280.89888515151','621.45708',253,4,0,333,0,0,0,40,250,1,1,0,1),
(18474,18474,'Alarm',0,'',0,'LineageNpcEV.trioll_altar','9','33.5',83,'etc','L2Monster',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,20,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,50,1,1,1,0,1),
(18475,18475,'Hall Guard',0,'',0,'LineageMonster.undine','12','27',83,'female','L2Npc',40,'32829.2831947712','1777.4','111.50705124295','3',40,43,30,21,20,20,90678,9792,'5815.28895362847','566.178304','3971.08850697278','621.45708',253,4,0,333,0,0,0,60,180,1,1,0,1),
(18476,18476,'Hall Guard',0,'',0,'LineageMonster.lienrik_210p','12','50',83,'male','L2Npc',40,'32829.2831947712','1777.4','111.50705124295','3',40,43,30,21,20,20,104688,11305,'5815.28895362847','566.178304','3971.08850697278','621.45708',253,4,0,333,0,0,0,100,180,1,1,0,1),
(18477,18477,'Coral Treasure Chest',0,'',0,'LineageMonster.mimic_even','8.5','8.5',83,'male','L2Chest',40,'2985.1835','1777.4','8.5','3',40,43,30,21,20,20,0,0,'949.52401','353.86144','648.40181','258.94045',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18478,18478,'Herb Jar',0,'',0,'LineageNpcEV.herb_pot','8','21.5',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,0,0,'29.61691','73.55216','20.22451','53.82228',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18479,18479,'Inner Castle Sentry',0,'',0,'LineageMonster.kel_mahum','13','26',81,'male','L2Npc',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1216.84606781331','370.300802117647','850.499841083446','270.970056705882',253,4,0,333,0,0,0,50,180,1,1,0,1),
(18480,18480,'Inner Castle Guard',0,'',0,'LineageMonster4.eyeless','36','43.5',81,'male','L2Npc',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1216.84606781331','370.300802117647','850.499841083446','270.970056705882',253,4,0,333,0,0,0,60,210,1,1,0,1),
(18481,18481,'Inner Castle Seer',0,'',0,'LineageMonster4.eyeless','36','43.5',81,'male','L2Npc',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1216.84606781331','370.300802117647','850.499841083446','270.970056705882',253,4,0,333,0,0,0,60,210,1,1,0,1),
(18482,18482,'Fafurion Kindred',0,'',0,'LineageMonster3.Water_Drake','55','80.5',82,'female','L2Monster',40,'2951.85588','1743','8.5','3',40,43,30,21,20,20,0,0,'931.81944','349.77477','636.31188','255.95',253,4,0,333,0,0,0,60,160,1,1,0,1),
(18483,18483,'Garden Guard',0,'',0,'LineageMonster4.Mostro_Fighter','15.5','22.5',19,'male','L2Monster',40,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,1353,57,'40.96915','84.07638','27.97662','61.52345',253,4,600,333,0,0,0,36,120,1,1,0,1),
(18484,18484,'Naia Failan',0,'',0,'LineageNPC.heart_of_warding','17','120',83,'etc','L2Npc',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,50,80,1,1,0,1),
(18485,18485,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18486,18486,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18487,18487,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18488,18488,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18489,18489,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18490,18490,'Beleth\'s Slave',0,'',0,'LineageMonster4.devil_doll','8','17.5',86,'female','L2Monster',40,'18540.1170337556','1881.8','185.679969089944','3',40,43,30,21,20,20,65975,6876,'10366.899777119','584.99232','7079.24864306088','642.108',253,4,0,333,0,0,0,60,160,1,1,0,1),
(18491,18491,'Lock',0,'Tower of Naia',0,'LineageNpcEV.soulprison','21','53',87,'male','L2Npc',40,'597541.8683162','1917','0','3',40,43,30,21,20,20,0,0,'1','1300.14544','1','1451.95953713944',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18492,18492,'Controller',0,'Tower of Naia',0,'LineageNpcEV.elobrate_machine','13','20',87,'male','L2Npc',40,'4656.72001612879','1917','8.5','3',40,43,30,21,20,20,0,0,'1280.04974647763','369.3595','874.108045171167','270.28125',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18493,18493,'Ward',0,'Tower of Naia',0,'LineageMonster2.hundred_eye','21','55',87,'male','L2Npc',40,'10160613.5393795','1917','330.315166023642','3',40,43,30,21,20,20,0,0,'13067.5473616165','738.719','8923.44082095907','1081.125',253,4,0,333,0,0,0,30,170,1,1,0,1),
(18494,18494,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13','20',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18495,18495,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13','20',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18496,18496,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13','20',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18497,18497,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13','20',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18498,18498,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13','20',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18499,18499,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13','20',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18500,18500,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13','20',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18501,18501,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13','20',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18502,18502,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13','20',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18503,18503,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13','20',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18504,18504,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13','20',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18505,18505,'Ingenious Contraption',0,'',0,'LineageNpcEV.elobrate_machine','13','20',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18506,18506,'Soul Crystal Pillar',0,'',0,'LineageNpcEV.soulprison','21','53',87,'male','L2Npc',40,'4656.72001612879','1917','8.5','3',40,43,30,21,20,20,0,0,'1280.04974647763','369.3595','874.108045171167','270.28125',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18507,18507,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18508,18508,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18509,18509,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18510,18510,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18511,18511,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18512,18512,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18513,18513,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18514,18514,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18515,18515,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18516,18516,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18517,18517,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18518,18518,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18519,18519,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18520,18520,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18521,18521,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18522,18522,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18523,18523,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18524,18524,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18525,18525,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18526,18526,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18527,18527,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18528,18528,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18529,18529,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18530,18530,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18531,18531,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18532,18532,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18533,18533,'',0,'',0,'LineageNpcEV.trap_ironcastle','12','20.4',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18534,18534,'Kertang\'s Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',45,'male','L2Npc',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,0,0,'234.89829','177.78746','160.40508','130.09715',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18535,18535,'Kertang\'s Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',55,'male','L2Npc',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,0,0,'388.11142','223.6362','265.02979','163.64727',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18536,18536,'Kertang\'s Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',65,'male','L2Npc',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,0,0,'582.81759','271.89033','397.98887','198.95754',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18537,18537,'Kertang\'s Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',75,'male','L2Npc',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,0,0,'794.70901','319.24623','542.68324','233.61053',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18538,18538,'Kertang\'s Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18539,18539,'Resurrection Tower',0,'',0,'LineageNpcEV.resurrection_tower','28','50',45,'male','L2Npc',40,'24126.895657854','610.8','52.5939791441829','2.1',40,43,30,21,20,20,0,0,'964.767353593336','284.459936','658.811030657258','312.23316',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18540,18540,'Resurrection Tower',0,'',0,'LineageNpcEV.resurrection_tower','28','50',55,'male','L2Npc',40,'46220.0506613879','889.8','93.7577782056663','2.4',40,43,30,21,20,20,0,0,'2217.1253962969','357.81792','1514.00924555179','392.753448',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18541,18541,'Resurrection Tower',0,'',0,'LineageNpcEV.resurrection_tower','28','50',65,'male','L2Npc',40,'64711.1305613164','1188.8','122.743258583495','2.7',40,43,30,21,20,20,0,0,'4492.80976280786','435.024528','3068.00671651806','477.498096',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18542,18542,'Resurrection Tower',0,'',0,'LineageNpcEV.resurrection_tower','28','50',75,'male','L2Npc',40,'74307.9465791418','1507.8','132.352087135506','3',40,43,30,21,20,20,0,0,'6388.10353954988','510.793968','4362.24666220709','560.665272',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18543,18543,'Resurrection Tower',0,'',0,'LineageNpcEV.resurrection_tower','28','50',80,'male','L2Npc',40,'113229.052561999','1674.8','195.708888732201','3',40,43,30,21,20,20,0,0,'9005.41719289368','546.2','6149.53251747042','599.528184',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18544,18544,'Cruma Border',0,'Event Monster',0,'LineageNpcEV.trap_ironcastle','12','20.4',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,0,0,'234.89829','177.78746','160.40508','130.09715',253,4,0,333,0,0,0,1,1,1,1,1,1),
(18545,18545,'Ancient Experiment',0,'Event Monster',0,'LineageMonster.marsh_stakato_soldier','10','25',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,0,0,'234.89829','177.78746','160.40508','130.09715',253,4,0,333,127,0,0,30,155,1,1,0,1),
(18546,18546,'Ancient Experiment',0,'Event Monster',0,'LineageMonster.stone_golem','20','31',45,'male','L2Monster',40,'12601.1073614331','610.8','27.4690282230768','2.1',40,43,30,21,20,20,0,0,'538.165880083998','284.459936','367.497528603312','312.23316',253,1,0,333,0,0,0,23,23,1,1,0,1),
(18547,18547,'Ancient Experiment',0,'Event Monster',0,'LineageMonster.onyx_beast','14','14.5',45,'male','L2Monster',40,'37803.3220842992','610.8','27.4690282230768','2.1',40,43,30,21,20,20,0,0,'336.33483277555','284.459936','229.673088544615','312.23316',253,4,0,333,0,0,0,30,120,1,1,0,1),
(18548,18548,'Ancient Experiment',0,'',0,'LineageMonster.onyx_beast','14','14.5',45,'male','L2Monster',40,'12601.1073614331','610.8','27.4690282230768','2.1',40,43,30,21,20,20,0,0,'538.165880083998','284.459936','367.497528603312','312.23316',253,4,0,333,0,0,0,30,120,1,1,0,1),
(18549,18549,'Ancient Experiment',0,'',0,'LineageMonster.onyx_beast','14','14.5',45,'male','L2Monster',40,'12601.1073614331','610.8','27.4690282230768','2.1',40,43,30,21,20,20,0,0,'538.165880083998','284.459936','367.497528603312','312.23316',253,4,0,333,0,0,0,30,120,1,1,0,1),
(18550,18550,'Cruma Phantom',0,'Event Monster',0,'LineageMonster.death_blader','15','45',50,'male','L2Monster',40,'17718.4028780724','747.8','37.2348110463089','2.1',40,43,30,21,20,20,0,0,'792.065949923076','320.381504','540.878369181793','351.66192',253,4,0,333,1472,0,0,100,170,1,1,0,1),
(18551,18551,'Cruma Phantom',0,'Event Monster',0,'LineageMonster.susceptor','20','35',50,'male','L2Monster',40,'53155.2086342172','747.8','37.2348110463089','2.1',40,43,30,21,20,20,0,0,'491.123464558459','320.381504','335.373662512685','351.66192',253,1,0,333,0,0,0,27,150,1,1,0,1),
(18552,18552,'Cruma Phantom',0,'',0,'LineageMonster.gamlin','11','32',50,'male','L2Monster',40,'17718.4028780724','747.8','37.2348110463089','2.1',40,43,30,21,20,20,0,0,'792.065949923076','320.381504','540.878369181793','351.66192',253,4,0,333,6307,0,0,80,170,1,1,0,1),
(18553,18553,'Cruma Phantom',0,'',0,'LineageMonster.leogul','15','35',50,'male','L2Monster',40,'17718.4028780724','747.8','37.2348110463089','2.1',40,43,30,21,20,20,0,0,'792.065949923076','320.381504','540.878369181793','351.66192',253,4,0,333,6307,0,0,80,170,1,1,0,1),
(18554,18554,'Tomlan Kamos',0,'Kaneus',0,'LineageMonster.bugbear_bi','25','53',23,'male','L2Monster',40,'51638.8844951664','1159.8','10.6620464638458','4.8',40,43,30,21,20,20,355901,19458,'68.011286251937','153.039616','46.4428982373458','167.981616',253,4,0,333,4,0,0,55,130,1,1,0,1);
INSERT INTO `npc` VALUES 
(18555,18555,'Ol Ariosh',0,'Kaneus',0,'LineageMonster.ol_mahum_champion_05te_120p','16','33.2',26,'male','L2Monster',40,'60567.008055059','1365','12.1792353154195','4.8',40,43,30,21,20,20,397272,23285,'99.2168255356476','168.045088','67.7522279641964','184.452144',253,4,0,333,67,633,0,50,110,1,1,0,1),
(18556,18556,'Follower of Ariosh',0,'',0,'LineageMonster.ol_mahum_champion','14','27',26,'male','L2Monster',40,'487.5704','1365','3.5','4.8',40,43,30,21,20,20,0,0,'69.75926','105.02818','47.63653','76.85506',253,4,0,333,69,102,0,50,110,1,1,0,1),
(18557,18557,'Ranc Deumus',0,'Kaneus',0,'LineageMonster.virud_lizardman_warrior_bi','12','34.5',26,'male','L2Monster',40,'60567.008055059','1365','12.1792353154195','4.8',40,43,30,21,20,20,397272,23285,'99.2168255356476','168.045088','67.7522279641964','184.452144',253,4,0,333,93,0,0,52,130,1,1,0,1),
(18558,18558,'Crimson Hatu Otis',0,'Kaneus',0,'LineageMonster.crimson_bear','19','36',33,'male','L2Monster',40,'77012.3816279503','1864.8','14.597633812675','6.48',40,43,30,21,20,20,549172,35415,'191.57829994383','206.76952','130.82315780595','226.95744',253,4,0,333,0,0,0,37,170,1,1,0,1),
(18559,18559,'Seer Flouros',0,'Kaneus',0,'LineageMonster.monster_eye_05te_ef','21','43',36,'male','L2Monster',40,'94225.5527374547','2088','17.4317272564291','6.48',40,43,30,21,20,20,620253,41849,'246.076786034581','224.916448','168.038549117797','246.876144',253,4,0,333,0,0,0,90,90,1,1,0,1),
(18560,18560,'Follower of Flouros',0,'',0,'LineageMonster.monster_eye','21','43',36,'male','L2Monster',40,'809.52639','2088','4.5','6.48',40,43,30,21,20,20,0,0,'137.86467','140.57278','94.1437','102.86506',253,4,0,333,0,0,0,90,90,1,1,0,1),
(18561,18561,'Granitick Duerga',0,'Kaneus',0,'LineageMonster.stone_golem','20','31',36,'male','L2Monster',40,'94225.5527374547','2088','17.4317272564291','6.48',40,43,30,21,20,20,620253,41849,'246.076786034581','224.916448','168.038549117797','246.876144',253,1,0,333,0,0,0,23,23,1,1,0,1),
(18562,18562,'Blade Otis',0,'Kaneus',0,'LineageMonster.blade_stakato_drone_10_sm','14','35.1',43,'male','L2Monster',40,'132634.618317353','2787','23.2361783984','11.55',40,43,30,21,20,20,784383,58093,'361.027339491631','270.614672','246.534866030033','297.03612',253,4,0,333,131,0,0,25,155,1,1,0,1),
(18563,18563,'Follower of Otis',0,'',0,'LineageMonster.marsh_stakato_drone','9','24',43,'male','L2Monster',40,'1094.28943','2787','5.5','11.55',40,43,30,21,20,20,0,0,'210.04832','169.13417','143.43577','123.76505',253,4,0,333,223,0,0,80,155,1,1,0,1),
(18564,18564,'Weird Bunei',0,'Kaneus',0,'LineageMonster3.Water_Drake','55','80.5',46,'female','L2Monster',40,'165222.57986374','3189','28.3020159951777','11.55',40,43,30,21,20,20,848114,69276,'470.818632922437','291.501056','321.5080926593','319.961736',253,4,0,333,0,0,0,60,160,1,1,0,1),
(18565,18565,'Brave Martim',0,'Kaneus',0,'LineageMonster.ogre_50_bi','30','66',46,'male','L2Monster',40,'165222.57986374','3189','28.3020159951777','11.55',40,43,30,21,20,20,848114,69276,'470.818632922437','291.501056','321.5080926593','319.961736',253,4,0,333,298,0,0,33,185,1,1,0,1),
(18566,18566,'Kaim Abigore',0,'Kaneus',0,'LineageMonster.kaim_vanul_50_bi','36','60',53,'male','L2Monster',40,'294174.619264419','4162','47.9069582428852','13.2',40,43,30,21,20,20,967925,88254,'805.150123040852','342.693216','549.813146917057','376.152024',253,4,0,333,0,0,0,60,250,1,1,0,1),
(18567,18567,'Follower of Abigore',0,'',0,'LineageMonster.liviona','15','28',53,'male','L2Monster',40,'1570.8463','4162','6.5','13.2',40,43,30,21,20,20,0,0,'353.71092','214.18326','241.5387','156.73001',253,4,0,333,0,0,0,80,170,1,1,0,1),
(18568,18568,'Knight Montagnar',0,'Kaneus',0,'LineageMonster.skeleton_royal_guard','11','28.5',56,'male','L2Monster',40,'318250.283048557','4594','50.7554330723992','13.2',40,43,30,21,20,20,1002611,124970,'1114.68190633232','365.44216','761.183239040102','401.12208',253,4,0,333,946,945,0,80,120,1,1,0,1),
(18569,18569,'Follower of Montagnar',0,'',0,'LineageMonster.dark_fencer','7','13',56,'male','L2Monster',40,'1724.6831','4594','6.5','13.2',40,43,30,21,20,20,0,0,'405.96455','228.40135','277.22116','167.1342',253,4,0,333,0,0,0,25,150,1,1,0,1),
(18570,18570,'Summer Yaganitan',0,'Kaneus',0,'LineageMonster2.flava_15_bi','23','39',56,'male','L2Monster',40,'318250.283048557','4594','50.7554330723992','13.2',40,43,30,21,20,20,1002611,124970,'1114.68190633232','365.44216','761.183239040102','401.12208',253,4,0,333,0,0,0,30,165,1,1,0,1),
(18571,18571,'Venomous Storace',0,'Kaneus',0,'LineageMonster.serpent_slave_50_bi','25','72',63,'male','L2Monster',40,'420501.049733155','5637','63.9742550992053','16.47',40,43,30,21,20,20,1046467,179455,'1873.164175491','419.510816','1279.12831860649','460.469712',253,4,0,333,73,0,0,70,110,1,1,0,1),
(18572,18572,'Follower of Storace',0,'',0,'LineageMonster.cave_maiden_080p','12','54',63,'female','L2Monster',40,'2089.92274','5637','7.5','16.47',40,43,30,21,20,20,0,0,'541.44774','262.19426','369.73862','191.86238',253,4,0,333,73,0,0,50,100,1,1,0,1),
(18573,18573,'Kel Bilette',0,'Kaneus',0,'LineageMonster.kel_mahum_champion_50_bi','19','48',66,'male','L2Monster',40,'445990.929574085','6099','66.5389693316175','16.47',40,43,30,21,20,20,1052061,186892,'2129.66943536181','442.764032','1454.28816580788','485.993256',253,4,0,333,75,0,0,50,170,1,1,0,1),
(18574,18574,'Follower of Bilette',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13','25',66,'male','L2Monster',40,'2244.67715','6099','7.5','16.47',40,43,30,21,20,20,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,193,0,0,50,160,1,1,0,1),
(18575,18575,'Warlord Tamuze',0,'Kaneus',0,'LineageMonster3.Vampire_Troop_Leader_120p','22','43',66,'male','L2Monster',40,'445990.929574085','6099','66.5389693316175','16.47',40,43,30,21,20,20,1052061,186892,'2129.66943536181','442.764032','1454.28816580788','485.993256',253,4,0,333,8686,0,0,60,160,1,1,0,1),
(18576,18576,'Follower of Tamuze',0,'',0,'LineageMonster3.self_blaster','9','25.8',66,'male','L2Monster',40,'2244.67715','6099','7.5','16.47',40,43,30,21,20,20,0,0,'603.79903','276.72752','412.31647','202.49719',253,4,0,333,0,0,0,30,240,1,1,0,1),
(18577,18577,'White Allosce',0,'Kaneus',0,'LineageMonster2.hundred_eye','21','55',73,'male','L2Monster',40,'475289.654476948','7212','67.8461312332064','18.3',40,43,30,21,20,20,1169076,202886,'2939.28876727043','496.047344','2007.15320551588','544.47888',253,1,0,333,0,0,0,30,170,1,1,0,1),
(18578,18578,'Follower of Allosce',0,'',0,'LineageMonster.monster_eye','21','43',73,'male','L2Monster',40,'2586.66898','7212','8.5','18.3',40,43,30,21,20,20,0,0,'752.73928','310.02959','514.02335','226.8662',253,4,0,333,0,0,0,90,90,1,1,0,1),
(18579,18579,'Hunting Ground Keeper',0,'',0,'LineageMonster4.employee_of_baroness','15','28.7',70,'male','L2Npc',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,1,0,333,13062,0,0,55,160,1,1,0,1),
(18580,18580,'Cursed Girl',0,'',0,'LineageMonster4.cursed_housemaid','8','17',71,'male','L2Npc',40,'2492.727','1377.8','8.5','3',40,43,30,21,20,20,0,0,'710.2185','300.65359','484.98717','220.00525',253,4,0,333,0,0,0,18,160,1,1,0,1),
(18581,18581,'Gardener',0,'',0,'LineageMonster4.gardener','17','26.8',72,'male','L2Npc',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,36,160,1,1,0,1),
(18582,18582,'Turned Girl',0,'Kratei\'s Fortune',0,'LineageMonster4.cursed_housemaid','8','17',75,'male','L2Npc',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,0,0,'794.70901','319.24623','542.68324','233.61053',253,4,0,333,0,0,0,18,160,1,1,0,1),
(18583,18583,'Housekeeper',0,'',0,'LineageMonster4.mad_laundry_maid','9','21.6',74,'male','L2Npc',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,0,0,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,33,160,1,1,0,1),
(18584,18584,'Turned Boy',0,'',0,'LineageMonster4.cursed_errand_boy','8','12.8',75,'male','L2Npc',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,0,0,'794.70901','319.24623','542.68324','233.61053',253,4,0,333,0,0,0,15,160,1,1,0,1),
(18585,18585,'Cursed Girl',0,'',0,'LineageMonster4.cursed_housemaid','8','17',75,'male','L2Npc',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,0,0,'794.70901','319.24623','542.68324','233.61053',253,4,0,333,0,0,0,18,160,1,1,0,1),
(18586,18586,'Gardener',0,'',0,'LineageMonster4.gardener','17','26.8',75,'male','L2Npc',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,0,0,'794.70901','319.24623','542.68324','233.61053',253,4,0,333,0,0,0,36,160,1,1,0,1),
(18587,18587,'Begrudged Maid',0,'',0,'LineageMonster4.head_parlour_maid','25','32',76,'male','L2Npc',40,'2758.05923328','1540.8','8.5','3',40,43,30,21,20,20,0,0,'824.422073095','323.78455','562.9734023','236.93149',253,4,0,333,0,0,0,50,160,1,1,0,1),
(18588,18588,'Hunting Ground Keeper',0,'',0,'LineageMonster4.employee_of_baroness','15','28.7',77,'male','L2Npc',40,'2856.7687256316','1574','8.5','3',40,43,30,21,20,20,0,0,'856.44055895414','328.27073','584.837886935576','240.21427',253,1,0,333,13062,0,0,55,160,1,1,0,1),
(18589,18589,'Cursed Gardener',0,'',0,'LineageMonster4.gardener','17','26.8',77,'male','L2Npc',40,'2856.7687256316','1574','8.5','3',40,43,30,21,20,20,0,0,'856.44055895414','328.27073','584.837886935576','240.21427',253,4,0,333,0,0,0,36,160,1,1,0,1),
(18590,18590,'Baroness\' Employee',0,'',0,'LineageMonster4.employee_of_baroness','15','28.7',78,'male','L2Npc',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,1,0,333,13061,0,0,55,160,1,1,0,1),
(18591,18591,'Begrudged Boy',0,'',0,'LineageMonster4.cursed_errand_boy','8','12.8',79,'male','L2Npc',40,'3127.82459333517','1641','8.5','3',40,43,30,21,20,20,0,0,'929.930814318487','337.07008','635.022195830619','246.65326',253,4,0,333,0,0,0,15,160,1,1,0,1),
(18592,18592,'Kratei\'s Steward',0,'',0,'LineageMonster4.chief_steward','18','31',80,'male','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,55,160,1,1,0,1),
(18593,18593,'Housekeeper',0,'',0,'LineageMonster4.mad_laundry_maid','9','21.6',80,'male','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,33,160,1,1,0,1),
(18594,18594,'Mansion Guide',0,'',0,'LineageMonster4.mad_laundry_maid','9','21.6',81,'male','L2Npc',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1012.32268463427','345.61127','691.285164307598','252.90333',253,4,0,333,0,0,0,33,160,1,1,0,1),
(18595,18595,'Baroness\' Employee',0,'',0,'LineageMonster4.employee_of_baroness','15','28.7',82,'male','L2Npc',40,'3643.38976668326','1743','8.5','3',40,43,30,21,20,20,0,0,'1055.28566004965','349.77477','720.623302603812','255.95',253,1,0,333,13061,0,0,55,160,1,1,0,1),
(18596,18596,'Cursed Gardener',0,'',0,'LineageMonster4.gardener','17','26.8',83,'male','L2Npc',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,36,160,1,1,0,1),
(18597,18597,'Begrudged Maid',0,'',0,'LineageMonster4.head_parlour_maid','25','32',84,'male','L2Npc',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,50,160,1,1,0,1),
(18598,18598,'Cursed Head Maid',0,'',0,'LineageMonster4.head_parlour_maid','25','32',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,50,160,1,1,0,1),
(18599,18599,'Mansion Manager',0,'',0,'LineageMonster4.steward','21','25',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,76,160,1,1,0,1),
(18600,18600,'Kratei\'s Steward',0,'',0,'LineageMonster4.chief_steward','18','31',86,'male','L2Npc',40,'4439.74358540587','1881.8','8.5','3',40,43,30,21,20,20,0,0,'1233.98508337826','365.6202','842.651845283929','267.545',253,4,0,333,0,0,0,55,160,1,1,0,1),
(18601,18601,'Kratei\'s Watcher',0,'',0,'LineageNpcEV.trap_ironcastle_150p_a','18','32',70,'male','L2Npc',40,'1','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18602,18602,'Kratei\'s Watcher',0,'',0,'LineageNpcEV.trap_ironcastle_150p','18','32',70,'male','L2Npc',40,'1','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18603,18603,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',73,'male','L2Npc',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,0,0,'752.73928','310.02959','514.02335','226.8662',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18604,18604,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',73,'male','L2Npc',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,0,0,'752.73928','310.02959','514.02335','226.8662',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18605,18605,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',73,'male','L2Npc',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,0,0,'752.73928','310.02959','514.02335','226.8662',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18606,18606,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',73,'male','L2Npc',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,0,0,'752.73928','310.02959','514.02335','226.8662',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18607,18607,'Gargos',0,'Spirit of Fire',0,'LineageMonster.vale_master','12','40',39,'male','L2Monster',40,'26166.4760109651','387.72','9','1.8',40,43,30,21,20,20,11225,714,'166.06476','132.9486','82.76936','97.28601',253,4,0,333,0,0,0,70,155,1,1,0,1),
(18608,18608,'Kinsus',0,'Spirit of Fire',0,'LineageMonster4.Anthias','20','41',39,'male','L2Monster',40,'16291.374214561','387.72','9','1.8',40,43,30,21,20,20,11225,714,'166.06476','132.9486','82.76936','97.28601',253,4,0,333,0,0,0,60,180,1,1,0,1),
(18609,18609,'Papion',0,'Spirit of Water',0,'LineageMonster4.Anthias','20','41',36,'male','L2Monster',40,'10512.7777620382','343.8','9','1.8',40,43,30,21,20,20,10783,652,'137.86467','121.98819','67.7543','89.26566',253,4,0,333,0,0,0,60,180,1,1,0,1),
(18610,18610,'Hillas',0,'Spirit of Water',0,'LineageMonster.sylph_100_bi','20','70',36,'female','L2Monster',40,'12143.4125711026','343.8','9','1.8',40,43,30,21,20,20,10783,652,'137.86467','121.98819','67.7543','89.26566',253,4,0,333,0,0,0,60,140,1,1,0,1),
(18611,18611,'Spirit of Water',0,'',0,'LineageMonster.undine','12','27',33,'female','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,631,22,'113.49065','129.23095','77.49941','94.5656',253,4,0,333,0,0,0,60,100,1,1,0,1),
(18612,18612,'Spirit of Water',0,'',0,'LineageMonster.sylph','11','35',36,'female','L2Monster',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,726,28,'137.86467','140.57278','94.1437','102.86506',253,4,0,333,0,0,0,60,100,1,1,0,1),
(18613,18613,'Spirit of Water',0,'',0,'LineageMonster.sylph_110p','12','39.7',39,'female','L2Monster',40,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,852,35,'166.06476','152.46752','113.4007','111.56912',253,4,0,333,0,0,0,60,100,1,1,0,1),
(18614,18614,'Spirit of Fire',0,'',0,'LineageMonster.skeleton_knight','10','25',36,'male','L2Monster',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,726,28,'137.86467','140.57278','94.1437','102.86506',253,4,0,333,150,103,0,40,160,1,1,0,1),
(18615,18615,'Spirit of Fire',0,'',0,'LineageMonster.dre_vanul','14','36',39,'male','L2Monster',40,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,852,35,'166.06476','152.46752','113.4007','111.56912',253,4,0,333,0,0,0,80,80,1,1,0,1),
(18616,18616,'Bloom',0,'',0,'LineageMonster.magical_weaver','11','20',36,'male','L2Monster',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,726,28,'137.86467','140.57278','94.1437','102.86506',253,1,0,333,0,0,0,90,90,1,1,0,1),
(18617,18617,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',36,'male','L2Npc',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,726,28,'137.86467','140.57278','94.1437','102.86506',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18618,18618,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',36,'male','L2Npc',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,726,28,'137.86467','140.57278','94.1437','102.86506',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18619,18619,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',36,'male','L2Npc',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,726,28,'137.86467','140.57278','94.1437','102.86506',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18620,18620,'Adiantum',0,'',0,'LineageMonster.onyx_beast','14','14.5',42,'male','L2Monster',40,'27474.7998115133','432.72','9','1.8',40,43,30,21,20,20,91640,4070,'198.34591','144.47758','100.26304','105.72243',253,1,0,333,0,0,0,30,120,1,1,0,1),
(18621,18621,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',42,'male','L2Npc',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,989,44,'198.34591','164.88513','135.44454','120.65578',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18622,18622,'Powder Keg',0,'',0,'LineageNPCEV.gunpowder','80','60',61,'female','L2Monster',40,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,2085,174,'501.08068','252.49346','342.17315','184.76376',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18623,18623,'Begrudged Archer',0,'',0,'LineageMonster.skeleton_archer_20_bi','13','32.5',61,'male','L2Monster',1100,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,3210,273,'501.08068','252.49346','342.17315','184.76376',253,8,400,333,279,0,0,40,140,1,1,0,1),
(18624,18624,'Deadman\'s Grudge',0,'',0,'LineageMonster.unpleasant_humming','12','26',58,'male','L2Monster',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,20,1885,151,'442.8992','237.99429','302.44274','174.1539',253,8,400,333,0,0,0,21,143,1,1,0,1),
(18625,18625,'Deadman\'s Grudge',0,'',0,'LineageMonster.skeleton_knight','10','25',61,'male','L2Monster',40,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,2085,174,'501.08068','252.49346','342.17315','184.76376',253,4,400,333,78,0,0,40,160,1,1,0,1),
(18626,18626,'Deadman\'s Grudge',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,2295,199,'562.02275','267.04468','383.78868','195.41171',253,8,400,333,225,945,0,80,120,1,1,0,1),
(18627,18627,'Deadman\'s Grudge',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,2295,199,'562.02275','267.04468','383.78868','195.41171',253,4,400,333,225,945,0,80,120,1,1,0,1),
(18628,18628,'Atan',0,'Lookout',0,'LineageMonster.pirates_zombie','10','23',61,'male','L2Monster',40,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,2934,249,'501.08068','252.49346','342.17315','184.76376',253,8,0,333,232,0,0,11,145,1,1,0,1),
(18629,18629,'Kams',0,'Panuka',0,'LineageMonster.skeleton_knight_50_bi','15','39',61,'male','L2Monster',40,'22092.8243635408','1066.8','15','2.7',40,43,30,21,20,20,63183,5562,'501.08068','252.49346','342.17315','184.76376',253,4,600,333,150,103,0,40,160,1,1,0,1),
(18630,18630,'Hikoro',0,'Panuka',0,'LineageMonster.rakul','30','39',61,'male','L2Monster',40,'22092.8243635408','1066.8','15','2.7',40,43,30,21,20,20,63183,5562,'501.08068','252.49346','342.17315','184.76376',253,4,600,333,3,0,0,60,150,1,1,0,1),
(18631,18631,'Alkaso',0,'Panuka',0,'LineageMonster.pirates_zombie_captain_20_bi','20','33.6',64,'male','L2Monster',40,'22860.7262608719','1158','15','2.7',40,43,30,21,20,20,64881,5952,'562.02275','267.04468','383.78868','195.41171',253,8,600,333,232,0,0,14,155,1,1,0,1),
(18632,18632,'Gerbera',0,'Panuka',0,'LineageMonster2.imperial_warlord_zombie_20_bi','9','36',64,'male','L2Monster',40,'24719.1969350524','1158','15','2.7',40,43,30,21,20,20,64881,5952,'562.02275','267.04468','383.78868','195.41171',253,4,600,333,134,6721,0,39,150,1,1,0,1),
(18633,18633,'Lematan',0,'',0,'LineageMonster4.cursed_pirate','24','37',67,'male','L2Monster',40,'49438.3938701049','1251','15','2.7',40,43,30,21,20,20,317821,23080,'624.93199','281.55251','426.74754','206.02791',253,4,600,333,0,0,0,25.5,120,1,1,0,1),
(18634,18634,'Lematan\'s Follower',0,'',0,'LineageMonster.pirates_zombie','10','23',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,2295,199,'562.02275','267.04468','383.78868','195.41171',253,8,0,333,232,0,0,11,145,1,1,0,1),
(18635,18635,'Varka Silenos Recruit',0,'',0,'LineageMonster2.barka_silenos_hunter','16','38',71,'male','L2Monster',40,'7483.65031581907','1410','17','3',40,43,30,21,20,20,31557,2980,'365.712','305.35947','124.8841975','223.44881',253,4,0,333,2504,6918,0,44,175,1,1,0,1),
(18636,18636,'Varka Silenos Footman',0,'',0,'LineageMonster2.barka_silenos_warrior','16','41',71,'male','L2Monster',40,'7483.65031581907','1410','17','3',40,43,30,21,20,20,31557,2980,'365.712','305.35947','124.8841975','223.44881',253,4,0,333,2504,6918,0,34,175,1,1,0,1),
(18637,18637,'Grazing Antelope',0,'',0,'LineageMonster2.antelope','17','34',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,4087,400,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,45,185,1,1,0,1),
(18638,18638,'Varka Silenos Scout',0,'',0,'LineageMonster2.barka_silenos_hunter','16','38',72,'male','L2Monster',80,'7577.69917044356','1410','8.5','3',40,43,30,21,20,20,3341,338,'365.712','305.35947','124.8841975','223.44881',253,4,0,333,2504,6918,0,44,175,1,1,0,1),
(18639,18639,'Varka Silenos Hunter',0,'',0,'LineageMonster2.barka_silenos_archer','8','37.5',72,'male','L2Monster',1100,'2540.15331','1410','8.5','3',40,43,30,21,20,20,2905,292,'731.52506','305.35947','499.53679','223.44881',253,8,0,333,6917,0,0,30,175,1,1,0,1),
(18640,18640,'Varka Silenos Shaman',0,'',0,'LineageMonster2.barka_silenos_shaman','14','39.5',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,2905,292,'731.52506','305.35947','499.53679','223.44881',253,1,0,333,6716,0,0,36,150,1,1,0,1),
(18641,18641,'Varka Silenos Priest',0,'',0,'LineageMonster2.barka_silenos_priest','9','41.5',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,4802,513,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,6716,0,0,36,180,1,1,0,1),
(18642,18642,'Varka Silenos Warrior',0,'',0,'LineageMonster2.barka_silenos_warrior','16','41',72,'male','L2Monster',40,'7577.69917044356','1475','17','3',40,43,30,21,20,20,3801,402,'386.5','314.65987','132.104','230.25444',253,4,0,333,142,6918,0,34,175,1,1,0,1),
(18643,18643,'Grazing Antelope',0,'',0,'LineageMonster2.antelope','17','34',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,4201,434,'752.73928','310.02959','514.02335','226.8662',253,4,0,333,0,0,0,45,185,1,1,0,1),
(18644,18644,'Varka Silenos Medium',0,'',0,'LineageMonster2.barka_silenos_shaman','14','39.5',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,2905,316,'731.52506','305.35947','499.53679','223.44881',253,1,0,333,6716,0,0,36,150,1,1,0,1),
(18645,18645,'Varka Silenos Magus',0,'',0,'LineageMonster2.barka_silenos_mage_20_bi','11','55.2',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,3255,360,'752.73928','310.02959','514.02335','226.8662',253,1,0,333,6716,6918,0,36,175,1,1,0,1),
(18646,18646,'Varka Silenos Officer',0,'',0,'LineageMonster2.barka_silenos_chieftain','18','42.5',73,'male','L2Monster',40,'6660.84527194068','1540.8','17','3',40,43,30,21,20,20,37623,3932,'412.21','323.78455','140.74335','236.93149',253,1,0,333,2504,6918,0,25,175,1,1,0,1),
(18647,18647,'Grazing Flava',0,'',0,'LineageMonster2.flava','18','34',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,4133,449,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,30,165,1,1,0,1),
(18648,18648,'Varka Silenos Seer',0,'',0,'LineageMonster2.barka_silenos_shaman','14','39.5',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,2807,308,'752.73928','310.02959','514.02335','226.8662',253,1,0,333,6716,0,0,36,150,1,1,0,1),
(18649,18649,'Varka Silenos Great Magus',0,'',0,'LineageMonster2.barka_silenos_warrior_20_bi','20','49.2',73,'male','L2Monster',40,'9374.13308462609','1574','17','3',40,43,30,21,20,20,37090,4028,'438.22','328.27073','146.209','240.21427',253,4,0,333,2500,6918,0,34,175,1,1,0,1),
(18650,18650,'Varka Silenos General',0,'',0,'LineageMonster2.barka_silenos_chieftain','18','42.5',73,'male','L2Monster',40,'9374.13308462609','1574','17','3',40,43,30,21,20,20,37090,4028,'438.22','328.27073','146.209','240.21427',253,1,0,333,2500,6918,0,25,175,1,1,0,1),
(18651,18651,'Grazing Elder Antelope',0,'',0,'LineageMonster2.antelope','17','34',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,4133,467,'773.81598','314.65987','528.41601','230.25444',253,1,0,333,0,0,0,45,185,1,1,0,1),
(18652,18652,'Varka Silenos Great Seer',0,'',0,'LineageMonster2.barka_silenos_shaman','14','39.5',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,2885,333,'773.81598','314.65987','528.41601','230.25444',253,1,0,333,6716,0,0,36,150,1,1,0,1),
(18653,18653,'Varka\'s Elite Guard',0,'',0,'LineageMonster2.barka_silenos_warrior','16','41',74,'male','L2Monster',40,'6703.71622103469','1475','17','3',40,43,30,21,20,20,39208,3836,'386.51','314.65987','528.41601','230.25444',253,4,0,333,2504,6918,0,34,175,1,1,0,1),
(18654,18654,'Varka\'s Commander',0,'',0,'LineageMonster2.barka_silenos_chieftain_20_bi','22','51',72,'male','L2Monster',40,'6656.85971425381','1507.8','17','3',40,43,30,21,20,20,36599,3398,'397.12','319.24623','542.68324','233.61053',253,4,0,333,2500,6918,0,25,175,1,1,0,1),
(18655,18655,'Varka\'s Head Guard',0,'',0,'LineageMonster2.barka_silenos_warrior','16','41',74,'male','L2Monster',40,'8619.06371275888','1574','17','3',40,43,30,21,20,20,38113,4028,'428.243','328.27073','146.209','240.21427',253,4,0,333,142,6918,0,34,175,1,1,0,1),
(18656,18656,'Varka\'s Head Magus',0,'',0,'LineageMonster2.barka_silenos_shaman','14','39.5',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,2885,333,'773.81598','314.65987','528.41601','230.25444',253,1,0,333,6716,0,0,36,150,1,1,0,1),
(18657,18657,'Prophet Guard',0,'',0,'LineageMonster2.barka_silenos_warrior','16','41',74,'male','L2Monster',40,'8619.06371275888','1607.4','17','3',40,43,30,21,20,20,37565,4122,'445.25','332.70061','152.024','243.45587',253,4,0,333,2504,6918,0,34,175,1,1,0,1),
(18658,18658,'Disciple of Prophet',0,'',0,'LineageMonster2.barka_silenos_priest','9','41.5',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,2885,333,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,6716,0,0,36,180,1,1,0,1),
(18659,18659,'Varka\'s Prophet',0,'',0,'LineageMonster2.barka_silenos_shaman_20_bi','17','47.5',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,2885,346,'773.81598','314.65987','528.41601','230.25444',253,1,0,333,6716,0,0,36,150,1,1,0,1),
(18660,18660,'Latana',0,'',0,'LineageMonster4.wounded_dragon','60','60',75,'female','L2Monster',40,'60325.8102951336','1251','17','2.7',40,43,30,21,20,20,453825,4067,'4768.26','319.24623','542.68324','233.61053',253,4,800,333,0,0,0,1,80,1,1,0,1),
(18661,18661,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',75,'male','L2Npc',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,8087,614,'794.70901','319.24623','542.68324','233.61053',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18662,18662,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',73,'male','L2Npc',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,7661,300,'752.73928','310.02959','514.02335','226.8662',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18663,18663,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',73,'male','L2Npc',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,0,0,'752.73928','310.02959','514.02335','226.8662',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18664,18664,'Fortune Bug',0,'',0,'LineageMonster4.jackpot_bug','16','22.5',52,'male','L2Monster',40,'1520.38155','804','6.5','2.4',40,43,30,21,20,20,0,0,'337.18867','209.50106','230.25615','153.30378',253,4,0,333,0,0,0,45,160,1,1,0,1),
(18665,18665,'Fortune Bug',0,'',0,'LineageMonster4.jackpot_bug','16','22.5',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,45,160,1,1,0,1),
(18666,18666,'Fortune Bug',0,'',0,'LineageMonster4.jackpot_bug','16','22.5',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,0,0,'794.70901','319.24623','542.68324','233.61053',253,4,0,333,0,0,0,45,160,1,1,0,1),
(18667,18667,'Ward of Death',0,'',0,'LineageNpcEV.trap_immortality','24','48.5',83,'female','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18668,18668,'Ward of Death',0,'',0,'LineageNpcEV.trap_immortality','24','48.5',83,'female','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18669,18669,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,0,0,'752.73928','310.02959','514.02335','226.8662',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18670,18670,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,0,0,'752.73928','310.02959','514.02335','226.8662',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18671,18671,'Block',0,'',0,'LineageNPC2.block','16','17',1,'female','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,50,160,1,0,0,1),
(18672,18672,'Block',0,'',0,'LineageNPC2.block','16','17',1,'female','L2Block',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,50,160,1,0,0,1),
(18673,18673,'Block',0,'',0,'LineageNPC2.block','16','17',1,'female','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,50,160,1,0,0,1),
(18674,18674,'Block',0,'',0,'LineageNPC2.block','16','17',1,'female','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,50,160,1,0,0,1),
(18675,18675,'Block',0,'',0,'LineageNPC2.block','16','17',1,'female','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,50,160,1,0,0,1),
(18676,18676,'Block-Carrying Girl',0,'',0,'LineageNPC2.block_mother','12','31',73,'female','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,0,0,'752.73928','310.02959','514.02335','226.8662',253,4,0,333,0,0,0,120,120,1,1,0,1),
(18677,18677,'Dragon Steed Troop Messenger',0,'',0,'LineageMonster4.dragon_peltast','25','46.5',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,0,0,'752.73928','310.02959','514.02335','226.8662',253,4,0,333,0,0,0,89,220,1,1,0,1),
(18678,18678,'Energy Seed - Water',0,'',0,'LineageNPC.seed_click_dummy_water','10','10',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18679,18679,'Energy Seed - Fire',0,'',0,'LineageNPC.seed_click_dummy_fire','10','10',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18680,18680,'Energy Seed - Wind',0,'',0,'LineageNPC.seed_click_dummy_wind','10','10',2,'male','L2Npc',40,'48.09168','47.28','2','0.9',40,43,30,21,20,20,0,0,'9.32203','46.15385','6.36574','33.77338',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18681,18681,'Energy Seed - Earth',0,'',0,'LineageNPC.seed_click_dummy_earth','10','10',2,'male','L2Npc',40,'48.09168','47.28','2','0.9',40,43,30,21,20,20,0,0,'9.32203','46.15385','6.36574','33.77338',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18682,18682,'Energy Seed - Divinity',0,'',0,'LineageNPC.seed_click_dummy_holy','10','10',3,'male','L2Npc',40,'57.54874','54.64','2','0.9',40,43,30,21,20,20,0,0,'10.24492','47.91652','6.99595','35.06323',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18683,18683,'Energy Seed - Darkness',0,'',0,'LineageNPC.seed_click_dummy_dark','10','10',3,'male','L2Npc',40,'57.54874','54.64','2','0.9',40,43,30,21,20,20,0,0,'10.24492','47.91652','6.99595','35.06323',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18684,18684,'Red Star Stone',0,'',0,'LineageNpcEV.star_stone_a','54','61',1,'female','L2FlyNpc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18685,18685,'Red Star Stone',0,'',0,'LineageNpcEV.star_stone_b','38','43.5',1,'female','L2FlyNpc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18686,18686,'Red Star Stone',0,'',0,'LineageNpcEV.star_stone_c','38','30.5',1,'female','L2FlyNpc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18687,18687,'Blue Star Stone',0,'',0,'LineageNpcEV.star_stone_a','54','61',1,'female','L2FlyNpc',40,'48.09168','47.28','2','0.9',40,43,30,21,20,20,0,0,'9.32203','46.15385','6.36574','33.77338',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18688,18688,'Blue Star Stone',0,'',0,'LineageNpcEV.star_stone_b','38','43.5',1,'female','L2FlyNpc',40,'48.09168','47.28','2','0.9',40,43,30,21,20,20,0,0,'9.32203','46.15385','6.36574','33.77338',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18689,18689,'Blue Star Stone',0,'',0,'LineageNpcEV.star_stone_c','38','30.5',1,'female','L2FlyNpc',40,'48.09168','47.28','2','0.9',40,43,30,21,20,20,0,0,'9.32203','46.15385','6.36574','33.77338',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18690,18690,'Green Star Stone',0,'',0,'LineageNpcEV.star_stone_a','54','61',1,'female','L2FlyNpc',40,'57.54874','54.64','2','0.9',40,43,30,21,20,20,0,0,'10.24492','47.91652','6.99595','35.06323',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18691,18691,'Green Star Stone',0,'',0,'LineageNpcEV.star_stone_b','38','43.5',1,'female','L2FlyNpc',40,'57.54874','54.64','2','0.9',40,43,30,21,20,20,0,0,'10.24492','47.91652','6.99595','35.06323',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18692,18692,'Green Star Stone',0,'',0,'LineageNpcEV.star_stone_c','38','30.5',1,'female','L2FlyNpc',40,'57.54874','54.64','2','0.9',40,43,30,21,20,20,0,0,'10.24492','47.91652','6.99595','35.06323',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18693,18693,'Treasure Box of the Ancient Giants',0,'',0,'LineageMonster.mimic','8.5','8.5',76,'male','L2Monster',40,'1','1540.8','8.5','3',40,43,30,21,20,20,0,0,'824.422073095','323.78455','562.9734023','236.93149',253,4,0,333,0,0,0,80,1,1,1,0,1),
(18694,18694,'Treasure Box Guard',0,'',0,'LineageMonster2.magmagoil_lad_20_sm','12','60',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,1,0,333,0,0,0,1,1,1,1,0,1),
(18695,18695,'Treasure Box Guard',0,'',0,'LineageMonster2.magmagoil_20_sm','12','60',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18696,18696,'Dimension Moving Device',0,'',0,'LineageNpcEV.teleport_gate_of_legion','44.5','7',80,'female','L2Monster',40,'13505.18','1846.8','95.72635','3',40,43,30,21,20,20,0,0,'1224.04634040392','1944.40778698225','860.594706323714','272.573429822485',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18697,18697,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Monster',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18698,18698,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Monster',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18699,18699,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Monster',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18700,18700,'',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Monster',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18701,18701,'',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Monster',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18702,18702,'Dimension Moving Device',0,'',0,'LineageNpcEV.teleport_gate_of_legion','44.5','7',80,'female','L2Npc',40,'113229.052561999','1674.8','195.708888732201','3',40,43,30,21,20,20,0,0,'9366.93275296632','595.987089798817','6585.64343163099','654.176231573965',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18703,18703,'Defeated Troops Controller',0,'',0,'LineageNpcEV.crystal_of_secret_door','57','74',80,'female','L2Monster',40,'113229.052561999','1674.8','195.708888732201','3',40,43,30,21,20,20,0,0,'9366.93275296632','595.987089798817','6585.64343163099','654.176231573965',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18704,18704,'Tumor of Death',0,'',0,'LineageNpcEV.tumor_immortality','42','55',79,'female','L2Monster',40,'340289.895594747','1641','197.223153775151','3',40,43,30,21,20,20,0,0,'7521.01103560974','549.451190476191','5166.44623212341','603.096804142857',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18705,18705,'Destroyed Tumor',0,'',0,'LineageNpcEV.tumor_immortality_a','0.01','55',79,'female','L2TerrainObject',40,'340289.895594747','1641','197.223153775151','3',40,43,30,21,20,20,0,0,'7521.01103560974','549.451190476191','5166.44623212341','603.096804142857',253,4,0,333,0,0,0,1,1,0,1,0,1),
(18706,18706,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality','30.5','6',79,'female','L2Monster',40,'33155.3718962619','1641','115.295936105422','3',40,43,30,21,20,20,0,0,'5781.02621320788','549.451190476191','3971.18963868307','603.096804142857',253,4,0,333,0,0,0,1,1,1,0,0,1),
(18707,18707,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,0,0,'752.73928','310.02959','514.02335','226.8662',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18708,18708,'Tumor of Death',0,'',0,'LineageNpcEV.tumor_immortality','42','55',81,'female','L2Monster',40,'112922.200722637','1708.8','194.030406814438','3',40,43,30,21,20,20,0,0,'9311.83314853711','592.481283388235','6508.39315054715','650.328136094118',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18709,18709,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality_080p','25','6',80,'female','L2Monster',40,'33093.4274797799','1674.8','114.399578021039','3',40,43,30,21,20,20,0,0,'5746.81895750842','546.2','3924.33235398589','599.528184',253,4,0,333,0,0,0,1,1,1,0,0,1),
(18710,18710,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality','30.5','6',81,'female','L2Monster',40,'33003.982801143','1708.8','113.419259781018','3',40,43,30,21,20,20,0,0,'5827.40072171705','562.931629835294','4002.76724651153','617.893411764706',253,4,0,333,0,0,0,1,1,1,0,0,1),
(18711,18711,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality_120p','36.5','8.5',81,'female','L2Monster',40,'33003.982801143','1708.8','113.419259781018','3',40,43,30,21,20,20,0,0,'5995.95197346168','592.481283388235','4190.79810952351','650.328136094118',253,4,0,333,0,0,0,1,1,1,0,0,1),
(18712,18712,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality_080p','25','6',81,'female','L2Monster',40,'65918.4456223521','1708.8','113.26544062045','3',40,43,30,21,20,20,0,0,'5756.1195067038','592.481283388235','4023.17010770831','650.328136094118',253,4,0,333,0,0,0,1,1,1,0,0,1),
(18713,18713,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality','30.5','6',81,'female','L2Monster',40,'65918.4456223521','1708.8','113.26544062045','3',40,43,30,21,20,20,0,0,'5756.1195067038','592.481283388235','4023.17010770831','650.328136094118',253,4,0,333,0,0,0,1,1,1,0,0,1),
(18714,18714,'Soul Coffin',0,'',0,'LineageNpcEV.vein_immortality_120p','36.5','8.5',81,'female','L2Monster',40,'65918.4456223521','1708.8','113.26544062045','3',40,43,30,21,20,20,0,0,'5756.1195067038','592.481283388235','4023.17010770831','650.328136094118',253,4,0,333,0,0,0,1,1,1,0,0,1),
(18715,18715,'Conquered Soul',0,'',0,'LineageMonster4.death_knight_n_104p','22.88','41.6',81,'male','L2Monster',80,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1112.35801218417','358.024515764706','768.532752324125','261.986808235294',253,4,0,333,13983,0,0,42.5,180,1,1,0,1),
(18716,18716,'Conquered Soul',0,'',0,'LineageMonster4.Death_slayer_080p','16','27.2',81,'male','L2Monster',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1112.35801218417','358.024515764706','768.532752324125','261.986808235294',253,4,0,333,13985,0,0,64,200,1,1,0,1),
(18717,18717,'Conquered Soul',0,'',0,'LineageMonster4.lich_b_088p','21.12','40.48',81,'male','L2Monster',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1112.35801218417','358.024515764706','768.532752324125','261.986808235294',253,4,0,333,0,0,0,46,200,1,1,0,1),
(18718,18718,'Sacrificed Fanatic',0,'',0,'LineageMonster4.ravager_silen_dead','27','48.5',81,'male','L2Npc',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,0,0,'799.383768882353','321.124149','549.086526672664','234.984709588235',253,4,0,333,13987,0,0,1,200,1,1,0,1),
(18719,18719,'Sacrificed Fanatic',0,'',0,'LineageMonster4.disciple_silen_dead','19','44',81,'male','L2Npc',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,0,0,'799.383768882353','321.124149','549.086526672664','234.984709588235',253,4,0,333,0,0,0,1,170,1,1,0,1),
(18720,18720,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18721,18721,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18722,18722,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18723,18723,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18724,18724,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18725,18725,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18726,18726,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18727,18727,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18728,18728,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18729,18729,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18730,18730,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18731,18731,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18732,18732,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18733,18733,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18734,18734,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18735,18735,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18736,18736,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18737,18737,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18738,18738,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18739,18739,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18740,18740,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18741,18741,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18742,18742,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18743,18743,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18744,18744,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18745,18745,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18746,18746,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18747,18747,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18748,18748,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18749,18749,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18750,18750,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18751,18751,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18752,18752,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18753,18753,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18754,18754,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18755,18755,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18756,18756,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18757,18757,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18758,18758,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18759,18759,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18760,18760,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18761,18761,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18762,18762,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18763,18763,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18764,18764,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18765,18765,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18766,18766,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18767,18767,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18768,18768,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18769,18769,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18770,18770,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18771,18771,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18772,18772,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18773,18773,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18774,18774,'Trap',0,'',0,'LineageNpc2.trap_mark','5','10',80,'etc','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18775,18775,'Seed of Destruction Control Device',0,'',0,'LineageNpcEV.crystal_of_secret_door','57','74',81,'female','L2Npc',40,'33003.982801143','1708.8','113.419259781018','3',40,43,30,21,20,20,147312,11412,'5827.40072171705','562.931629835294','4002.76724651153','617.893411764706',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18776,18776,'Obelisk',0,'',0,'LineageNpcEV.obelisk_of_middle_square','229','177.5',81,'female','L2Monster',40,'33003.982801143','1708.8','113.419259781018','3',40,43,30,21,20,20,0,0,'5827.40072171705','562.931629835294','4002.76724651153','617.893411764706',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18777,18777,'Great Powerful Device',0,'',0,'LineageNpcEV.crystal_of_secret_door','57','74',81,'female','L2Monster',40,'33003.982801143','1708.8','113.419259781018','3',40,43,30,21,20,20,0,0,'5827.40072171705','562.931629835294','4002.76724651153','617.893411764706',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18778,18778,'Throne of Destruction Powerful Device',0,'',0,'LineageNpcEV.protector_of_seed','57','74',81,'female','L2Monster',40,'33003.982801143','1708.8','113.419259781018','3',40,43,30,21,20,20,0,0,'5827.40072171705','562.931629835294','4002.76724651153','617.893411764706',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18779,18779,'',0,'',0,'LineageNPC.clear_npc','0.1','0.1',82,'male','L2Monster',40,'3643.38976668326','1743','8.5','3',40,43,30,21,20,20,0,0,'1055.28566004965','349.77477','720.623302603812','255.95',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18780,18780,'Symbol of Cohemenes',0,'',0,'LineageNpcEV.trap_immortality','24','48.5',83,'female','L2Monster',40,'65569.2570829001','1777.4','111.355378460862','3',40,43,30,21,20,20,0,0,'5589.57218651355','566.178304','3816.95321518099','621.45708',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18781,18781,'Young Drake Wing',0,'',0,'LineageMonster4.m_drake_wing_knave','153','63',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,60,150,1,1,0,1),
(18782,18782,'Zealot of Shilen',0,'',0,'LineageMonster4.disciple_silen','19','44',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,73,170,1,1,0,1),
(18783,18783,'Defeated Troops Commander',0,'',0,'LineageMonster4.Dragon_centurion_135p','28','46.5',81,'male','L2Monster',40,'112922.200722637','1708.8','194.030406814438','3',40,43,30,21,20,20,0,0,'9169.67355509905','572.839225223529','6335.36539317632','628.768339764706',253,4,0,333,13978,0,0,55,210,1,1,0,1),
(18784,18784,'Defeated Troops No 1 Battalion Commander',0,'',0,'LineageMonster4.Dragon_centurion_135p','28','46.5',81,'male','L2Monster',40,'112922.200722637','1708.8','194.030406814438','3',40,43,30,21,20,20,0,0,'9098.07293029824','562.931629835294','6249.35027997191','617.893411764706',253,4,0,333,13978,0,0,55,210,1,1,0,1),
(18785,18785,'Defeated Troops White Dragon Leader',0,'',0,'LineageMonster4.Dragon_centurion_120p','22','42',81,'male','L2Monster',40,'112922.200722637','1708.8','194.030406814438','3',40,43,30,21,20,20,0,0,'9025.28600814905','552.978032','6163.10037872993','606.967992',253,4,0,333,13979,13980,0,56,210,1,1,0,1),
(18786,18786,'Defeated Troops Infantry',0,'',0,'LineageMonster4.Dragon_centurion_120p','22','42',80,'male','L2Monster',40,'113229.052561999','1674.8','195.708888732201','3',40,43,30,21,20,20,0,0,'9005.41719289368','546.2','6149.53251747042','599.528184',253,4,0,333,13979,13980,0,56,210,1,1,0,1),
(18787,18787,'Defeated Troops Magic Leader',0,'',0,'LineageMonster4.dragon_mage_075p','28','39.5',81,'male','L2Monster',40,'56505.8603512852','1708.8','194.184225975005','3',40,43,30,21,20,20,0,0,'9320.82549056039','562.931629835294','6402.3561731433','617.893411764706',253,4,0,333,0,0,0,92,170,1,1,0,1),
(18788,18788,'Defeated Troops Magician',0,'',0,'LineageMonster4.dragon_mage_075p','28','39.5',81,'male','L2Monster',40,'56505.8603512852','1708.8','194.184225975005','3',40,43,30,21,20,20,0,0,'9242.50952208013','552.978032','6311.43587965133','606.967992',253,4,0,333,0,0,0,92,170,1,1,0,1),
(18789,18789,'Defeated Troops Magic Soldier',0,'',0,'LineageMonster4.dragon_mage_065p','25','34.5',80,'male','L2Monster',40,'33093.4274797799','1674.8','114.399578021039','3',40,43,30,21,20,20,0,0,'5746.81895750842','546.2','3924.33235398589','599.528184',253,4,0,333,13981,0,0,82,170,1,1,0,1),
(18790,18790,'Defeated Troops Healer',0,'',0,'LineageMonster4.dragon_mage_065p','25','34.5',79,'male','L2Monster',40,'33155.3718962619','1641','115.295936105422','3',40,43,30,21,20,20,0,0,'5679.07860126925','539.312128','3878.0744848375','591.967824',253,4,0,333,13981,0,0,82,170,1,1,0,1),
(18791,18791,'Defeated Troops Javelin Thrower',0,'',0,'LineageMonster4.dragon_peltast','25','46.5',80,'male','L2Monster',1100,'56659.3136360673','1674.8','195.86371266283','3',40,43,30,21,20,20,0,0,'9218.40692660222','546.2','6294.97689447958','599.528184',253,8,0,333,13843,0,0,89,220,1,1,0,1),
(18792,18792,'Defeated Troops Javelin Thrower',0,'',0,'LineageMonster4.dragon_peltast','25','46.5',80,'male','L2Monster',1100,'56659.3136360673','1674.8','195.86371266283','3',40,43,30,21,20,20,0,0,'9218.40692660222','546.2','6294.97689447958','599.528184',253,8,0,333,13843,0,0,89,220,1,1,0,1),
(18793,18793,'Bizarre Cocoon',0,'',0,'LineageNpcEV.n_event_stakato_egg_a','24','27',84,'male','L2Monster',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18794,18794,'Bizarre Cocoon',0,'',0,'LineageNpcEV.n_event_stakato_egg_b','35','27',84,'male','L2Monster',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18795,18795,'Bizarre Cocoon',0,'',0,'LineageNpcEV.n_event_stakato_egg_c','48','27',84,'male','L2Monster',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18796,18796,'Bizarre Cocoon',0,'',0,'LineageNpcEV.n_event_stakato_egg_d','24','27',84,'male','L2Monster',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18797,18797,'Bizarre Cocoon',0,'',0,'LineageNpcEV.n_event_stakato_egg_e','35','27',84,'male','L2Monster',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18798,18798,'Bizarre Cocoon',0,'',0,'LineageNpcEV.n_event_stakato_egg_f','48','27',84,'male','L2Monster',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18799,18799,'Newborn Lavasaurus',0,'',0,'LineageMonster2.magmagoil_20_sm','12','60',77,'male','L2Monster',40,'2856.7687256316','1574','8.5','3',40,43,30,21,20,20,49441,5079,'856.44055895414','328.27073','584.837886935576','240.21427',253,1,0,333,0,0,0,1,1,1,1,0,1),
(18800,18800,'Fledgling Lavasaurus',0,'',0,'LineageMonster2.magmagoil','15','75',77,'male','L2Monster',40,'2856.7687256316','1574','8.5','3',40,43,30,21,20,20,49441,5079,'856.44055895414','328.27073','584.837886935576','240.21427',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18801,18801,'Adult Lavasaurus',0,'',0,'LineageMonster2.magmagoil_lad_20_sm','12','60',77,'male','L2Monster',40,'2856.7687256316','1574','8.5','3',40,43,30,21,20,20,49441,5079,'856.44055895414','328.27073','584.837886935576','240.21427',253,1,0,333,0,0,0,1,1,1,1,0,1),
(18802,18802,'Elderly Lavasaurus',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,50733,5271,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18803,18803,'Ancient Lavasaurus',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,50733,5271,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18804,18804,'Tar Beetle',0,'',0,'LineageMonster2.scarab_20_sm_e','18','26',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,0,0,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,0,0,0,45,180,0,1,0,1),
(18805,18805,'Waste Landfill Machine',0,'',0,'LineageNpcEV.riding_control_unit_c','19','28',83,'female','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18806,18806,'Brazier of Purity',0,'',0,'LineageNpcEV.warp_gate_a','16','31',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18807,18807,'Frightened Ragna Orc',0,'',0,'LineageMonster.batur_orc_03te','9','21.5',81,'male','L2Monster',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,2639,292,'1012.32268463427','345.61127','691.285164307598','252.90333',253,4,0,333,0,0,0,80,130,1,1,0,1),
(18808,18808,'Dark Shaman Varangka',0,'',0,'LineageMonster2.ketra_orc_chieftain_20_bi_e','17','46.2',82,'male','L2Monster',40,'21860.34','17430','41.206725','50',40,43,30,21,20,20,142334,15560,'492.298548642662','349.77477','720.623302603812','255.95',253,1,0,333,6719,0,0,24,175,1,1,0,1),
(18809,18809,'Varangka\'s Retainer',0,'',0,'LineageMonster.batur_orc_overlord_03te_120p','12','28',82,'male','L2Monster',40,'1821.695','1743','8.5','3',40,43,30,21,20,20,16412,1794,'492.298548642662','349.77477','720.623302603812','255.95',253,4,0,333,6365,0,0,80,140,1,1,0,1),
(18810,18810,'Varangka\'s Page',0,'',0,'LineageMonster.batur_orc_shaman_a_01te_120p_e','13','20.8',82,'male','L2Monster',40,'1821.695','1743','8.5','3',40,43,30,21,20,20,17412,1904,'492.298548642662','349.77477','720.623302603812','255.95',253,4,0,333,8680,0,0,50,120,1,1,0,1),
(18811,18811,'Guardian of the Altar',0,'',0,'LineageMonster2.parasitic_eye_050p_e','17','29',82,'male','L2Monster',40,'3643.38976668326','1743','8.5','3',40,43,30,21,20,20,0,0,'1055.28566004965','349.77477','720.623302603812','255.95',253,1,0,333,0,0,0,30,160,1,1,0,1),
(18812,18812,'Kasha\'s Eye',0,'',0,'LineageMonster2.parasitic_eye_050p_e_r','17','29',81,'male','L2Monster',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1012.32268463427','345.61127','691.285164307598','252.90333',253,4,0,333,0,0,0,30,160,1,1,0,1),
(18813,18813,'Kasha\'s Eye',0,'',0,'LineageMonster2.parasitic_eye_050p_e_g','17','29',81,'male','L2Monster',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1012.32268463427','345.61127','691.285164307598','252.90333',253,4,0,333,0,0,0,30,160,1,1,0,1),
(18814,18814,'Kasha\'s Eye',0,'',0,'LineageMonster2.parasitic_eye_050p_e_b','17','29',81,'male','L2Monster',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1012.32268463427','345.61127','691.285164307598','252.90333',253,4,0,333,0,0,0,30,160,1,1,0,1),
(18815,18815,'Guard of the Grave',0,'Death-calling',0,'LineageMonster2.magmagoil_20_sm','12','60',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18816,18816,'Chieftain\'s Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',81,'male','L2Monster',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1012.32268463427','345.61127','691.285164307598','252.90333',253,4,0,333,0,0,0,80,120,1,1,0,1),
(18817,18817,'Invader Martyr of Nightmare',0,'',0,'LineageMonster.doll_master','20','42',81,'male','L2Monster',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1012.32268463427','345.61127','691.285164307598','252.90333',253,1,0,333,0,0,0,80,160,1,1,0,1),
(18818,18818,'Nihil Invader Martyr',0,'',0,'LineageMonster5.scapegoat','20','32.5',81,'male','L2Monster',40,'3461.77253215841','1708.8','8.5','3',40,43,30,21,20,20,0,0,'1012.32268463427','345.61127','691.285164307598','252.90333',253,4,0,333,0,0,0,45,180,1,1,0,1),
(18819,18819,'Nihil Invader Treasure Chest',0,'',0,'LineageMonster5.bounded_mimic','11','8',82,'female','L2Monster',40,'3643.38976668326','1743','8.5','3',40,43,30,21,20,20,0,0,'1055.28566004965','349.77477','720.623302603812','255.95',253,4,0,333,0,0,0,30,120,1,1,0,1),
(18820,18820,'Nihil Invader Treasure Chest',0,'',0,'LineageMonster5.bounded_mimic','11','8',82,'female','L2Monster',40,'3643.38976668326','1743','8.5','3',40,43,30,21,20,20,0,0,'1055.28566004965','349.77477','720.623302603812','255.95',253,4,0,333,0,0,0,30,120,1,1,0,1),
(18821,18821,'Mutant Martyr',0,'',0,'LineageMonster5.doll_claw','28','50',84,'male','L2Monster',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,50,165,1,1,0,1),
(18822,18822,'Mutant Treasure Chest',0,'',0,'LineageMonster5.bounded_mimic','11','8',84,'female','L2Monster',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,30,120,1,1,0,1),
(18823,18823,'Mutant Treasure Chest',0,'',0,'LineageMonster5.bounded_mimic','11','8',84,'female','L2Monster',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,30,120,1,1,0,1),
(18824,18824,'Merchant of Mammon A',0,'',0,'LineageNPC.a_warehouse_keeper_MDwarf','8','17',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18825,18825,'Merchant of Mammon B',0,'',0,'LineageNPC.e_guard_MDwarf','8','19',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18826,18826,'Shilen\'s Evil Thoughts For Presentation',0,'',0,'LineageMonster5.vicious_mind_of_silen','14','27.5',80,'male','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,30,180,1,1,0,1),
(18827,18827,'Priest Cain for Presentation',0,'',0,'LineageNPC.a_sanctuary_teacher_MHuman','8','23',80,'male','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18828,18828,'High Priest of Dawn',0,'',0,'LineageNPC2.high_priest_of_dawn','10','22.5',80,'male','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,50,100,1,1,0,1),
(18829,18829,'Shilen\'s Evil Thoughts Leader For Presentation',0,'',0,'LineageMonster5.leader_mind_of_silen','20','40',80,'male','L2Npc',40,'3290.11306877694','1674.8','8.5','3',40,43,30,21,20,20,0,0,'970.537548504614','341.375','662.751329129412','249.80341',253,4,0,333,0,0,0,45,180,1,1,0,1),
(18830,18830,'ssq For Presentation Camera Dummy 1',0,'',0,'LineageNPC.camera_target_dummy','11','25',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18831,18831,'ssq For Presentation Camera Dummy 2',0,'',0,'LineageNPC.camera_target_dummy','11','25',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18832,18832,'ssq For Presentation Camera Dummy 3',0,'',0,'LineageNPC.camera_target_dummy','11','25',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18833,18833,'Emperor\'s Seal Device',0,'',0,'LineageNPCEV.ssq_sealing_emperor','21','24',1,'female','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18834,18834,'Guards of the Dawn',0,'',0,'LineageNPC.a_fighterguild_master_Mhuman','8','23.5',85,'male','L2Npc',80,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,16,0,0,50,100,1,1,0,1),
(18835,18835,'Guards of the Dawn',0,'',0,'LineageNPC.a_mageguild_master_MHuman','8','24',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,1,0,333,5,0,0,50,100,1,1,0,1),
(18836,18836,'Varangka\'s Guardian',0,'',0,'LineageMonster2.ahrimanes_70p','14','39.5',82,'male','L2Npc',40,'3643.38976668326','1743','8.5','3',40,43,30,21,20,20,16412,1794,'1055.28566004965','349.77477','720.623302603812','255.95',253,4,0,333,0,0,0,35,185,1,1,0,1),
(18837,18837,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.1','0.1',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,0,1,0,1),
(18838,18838,'Treasure Chest of Invader Soldier of Nightmare',0,'',0,'LineageMonster5.bounded_mimic','11','8',84,'female','L2Npc',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,30,120,1,1,0,1),
(18839,18839,'Wild Maguen',0,'',0,'LineageMonster5.marguene','11','13.25',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,15,120,1,1,0,1),
(18840,18840,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.1','0.1',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18841,18841,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.1','0.1',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18842,18842,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.1','0.1',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18843,18843,'Cokrakon\'s Ward',0,'',0,'LineageNpcEV.totem_of_cocracon_a','30','54',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,1,0,1,0,1),
(18844,18844,'Reptilikon\'s Ward',0,'',0,'LineageNpcEV.totem_of_cocracon_b','30','54',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,1,0,1,0,1),
(18845,18845,'Torumba\'s Telegraph',0,'',0,'LineageNPC.camera_target_dummy_a','0.1','0.1',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18846,18846,'Kegor',0,'',0,'LineageMonster5.swordmaster_kegor','15','27.5',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,40,120,1,1,0,1),
(18847,18847,'Freya',0,'Ice Queen',0,'LineageMonster5.freya_throne','50','98.5',85,'female','L2Npc',40,'2388699.67505409','1846.8','918.195504075765','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,45,150,1,1,0,1),
(18848,18848,'Battalion Leader',0,'Jinia Guild',0,'LineageNPC2.garrison_of_insurgents','10','23.75',85,'female','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,80,641,0,30,160,1,1,0,1),
(18849,18849,'Legionnaire',0,'Jinia Guild',0,'LineageNPC2.officer_of_insurgents_orc','14.5','30',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,9813,9813,0,40,160,1,1,0,1),
(18850,18850,'Jinia',0,'',0,'LineageMonster5.guildmaster_jinia','11','23.5',85,'female','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,40,120,1,1,0,1),
(18851,18851,'Kegor',0,'',0,'LineageMonster5.swordmaster_kegor','15','27.5',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,40,120,1,1,0,1),
(18852,18852,'Sirra',0,'',0,'LineageMonster5.human_sirr','10','22',85,'female','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,40,120,1,1,0,1),
(18853,18853,'Glacier',0,'',0,'LineageNpcEV.freezing_stone','26','27',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18854,18854,'Archer\'s Breath',0,'',0,'LineageMonster5.ice_elemental_bomb','20','50',85,'male','L2Npc',40,'57746.2631712621','1846.8','109.442978618283','3',40,43,30,21,20,20,0,0,'5858.11399706027','578.861024','4000.33245360119','635.378064',253,4,0,333,0,0,0,30,80,1,1,0,1),
(18855,18855,'Archery Knight',0,'',0,'LineageMonster5.ice_knight','15','31',85,'male','L2Npc',40,'32596.260118202','1846.8','109.442978618283','3',40,43,30,21,20,20,0,0,'5858.11399706027','578.861024','4000.33245360119','635.378064',253,4,0,333,0,0,0,20,150,1,1,0,1),
(18856,18856,'Archery Knight',0,'',0,'LineageMonster5.ice_knight','15','31',85,'male','L2Npc',40,'800666.35202088','18468','109.442978618283','300',40,43,30,21,20,20,0,0,'16109.8134919157','578.861024','4000.33245360119','635.378064',253,4,0,333,0,0,0,20,150,1,1,0,1),
(18857,18857,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.1','0.1',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18858,18858,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.1','0.1',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18859,18859,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.1','0.1',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18860,18860,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.1','0.1',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18861,18861,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.1','0.1',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18862,18862,'Tanta Lizardman Guard',0,'Escort of Ugoros',0,'LineageMonster.zenta_lizardman_warrior','13','35',82,'male','L2Monster',80,'3643.38976668326','1743','8.5','3',40,43,30,21,20,20,19616,2145,'1055.28566004965','349.77477','720.623302603812','255.95',253,4,0,333,98,0,0,40,140,1,1,0,1),
(18863,18863,'Seer Ugoros',0,'Tanta Lizardmen',0,'LineageMonster5.tantaar_lizardman_high_sorcerer','40','53.5',84,'male','L2Monster',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,90,150,1,1,0,1),
(18864,18864,'Fantasy Mushroom',0,'',0,'LineageNpcEV.target_board_a','16','23',85,'male','L2Monster',40,'1000','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18865,18865,'Sticky Mushroom',0,'',0,'LineageNpcEV.rug_fungus','15','25',85,'male','L2Monster',40,'1000','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18866,18866,'Rainbow Frog',0,'',0,'LineageMonster5.poison_arrow_frog','20','18',85,'male','L2Monster',40,'1000','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,15,40,1,1,0,1),
(18867,18867,'Abyss Weed',0,'',0,'LineageNpcEV.poison_plant_b','30','27',85,'male','L2Monster',40,'1000','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18868,18868,'Energy Plant',0,'',0,'LineageNpcEV.rosehip_fragrant','15','33',85,'male','L2Monster',40,'1000','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18869,18869,'Kookaburra',1,'Tame',0,'LineageMonster2.baby_ostrich','6','15',83,'male','L2TamedBeast',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,13,110,1,1,0,1),
(18870,18870,'Cougar',1,'Tame',0,'LineageMonster2.baby_tiger','8','15.7',83,'male','L2TamedBeast',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,1,0,333,0,0,0,28,110,1,1,0,1),
(18871,18871,'Buffalo',1,'Tame',0,'LineageMonster2.baby_buffalo','8','15',84,'male','L2TamedBeast',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,30,110,1,1,0,1),
(18872,18872,'Grendel',1,'Tame',0,'LineageMonster5.baby_bionic_bear','9','12.5',84,'male','L2TamedBeast',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,40,120,1,1,0,1),
(18873,18873,'Baby Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','6','15',83,'male','L2FeedableBeast',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,11630,1256,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,13,110,1,1,1,1),
(18874,18874,'Young Kookaburra',0,'',0,'LineageMonster2.baby_ostrich_140p','12','21',83,'male','L2FeedableBeast',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,18776,1918,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,13,110,1,1,1,1),
(18875,18875,'Young Kookaburra',0,'',0,'LineageMonster2.baby_ostrich_140p','12','21',83,'male','L2FeedableBeast',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,25005,2686,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,13,110,1,1,1,1),
(18876,18876,'Adult Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8','26.4',83,'male','L2FeedableBeast',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,8516,874,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,23,190,1,1,1,1),
(18877,18877,'Adult Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8','26.4',83,'male','L2FeedableBeast',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,72113,7459,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,23,190,1,1,1,1),
(18878,18878,'Full Grown Kookaburra',0,'',0,'LineageMonster2.rough_ostrich','10','33',83,'male','L2FeedableBeast',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,11959,1246,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,23,190,1,1,1,1),
(18879,18879,'Full Grown Kookaburra',0,'',0,'LineageMonster2.rough_ostrich','10','33',83,'male','L2FeedableBeast',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,76500,6972,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,23,190,1,1,1,1),
(18880,18880,'Baby Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','8','15.7',83,'male','L2FeedableBeast',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,11630,1256,'1099.42361669366','353.86144','750.763809564873','258.94045',253,1,0,333,0,0,0,28,110,1,1,1,1),
(18881,18881,'Young Cougar',0,'',0,'LineageMonster2.baby_tiger_130p','13','21',83,'male','L2FeedableBeast',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,18776,1918,'1099.42361669366','353.86144','750.763809564873','258.94045',253,1,0,333,0,0,0,28,110,1,1,1,1),
(18882,18882,'Young Cougar',0,'',0,'LineageMonster2.baby_tiger_130p','13','21',83,'male','L2FeedableBeast',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,25005,2686,'1099.42361669366','353.86144','750.763809564873','258.94045',253,1,0,333,0,0,0,28,110,1,1,1,1),
(18883,18883,'Adult Cougar',0,'',0,'LineageMonster2.youth_tiger','16','17.2',83,'male','L2FeedableBeast',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,8516,874,'1099.42361669366','353.86144','750.763809564873','258.94045',253,1,0,333,0,0,0,60,170,1,1,1,1),
(18884,18884,'Adult Cougar',0,'',0,'LineageMonster2.youth_tiger','16','17.2',83,'male','L2FeedableBeast',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,72113,7459,'1099.42361669366','353.86144','750.763809564873','258.94045',253,1,0,333,0,0,0,60,170,1,1,1,1),
(18885,18885,'Full Grown Cougar',0,'',0,'LineageMonster.saber_toothed_tiger','34','28',83,'male','L2FeedableBeast',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,11959,1246,'1099.42361669366','353.86144','750.763809564873','258.94045',253,1,0,333,0,0,0,60,170,1,1,1,1),
(18886,18886,'Full Grown Cougar',0,'',0,'LineageMonster.saber_toothed_tiger','34','28',83,'male','L2FeedableBeast',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,76500,6972,'1099.42361669366','353.86144','750.763809564873','258.94045',253,1,0,333,0,0,0,60,170,1,1,1,1),
(18887,18887,'Baby Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','8','15',84,'male','L2FeedableBeast',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,12929,1379,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,30,110,1,1,1,1),
(18888,18888,'Young Buffalo',0,'',0,'LineageMonster2.baby_buffalo_140p','16','22',84,'male','L2FeedableBeast',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,20911,2111,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,30,110,1,1,1,1),
(18889,18889,'Young Buffalo',0,'',0,'LineageMonster2.baby_buffalo_140p','16','22',84,'male','L2FeedableBeast',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,27445,2908,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,30,110,1,1,1,1),
(18890,18890,'Adult Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16','25.2',84,'male','L2FeedableBeast',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,9438,957,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,20,170,1,1,1,1),
(18891,18891,'Adult Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16','25.2',84,'male','L2FeedableBeast',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,79302,8101,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,20,170,1,1,1,1),
(18892,18892,'Full Grown Buffalo',0,'',0,'LineageMonster2.buffalo','22','31',84,'male','L2FeedableBeast',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,13050,1342,'1144.73130112535','357.86723','781.703083407155','261.87171',253,1,0,333,0,0,0,80,170,1,1,1,1),
(18893,18893,'Full Grown Buffalo',0,'',0,'LineageMonster2.buffalo','22','31',84,'male','L2FeedableBeast',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,83904,7596,'1144.73130112535','357.86723','781.703083407155','261.87171',253,1,0,333,0,0,0,80,170,1,1,1,1),
(18894,18894,'Baby Alpine Grendel',0,'',0,'LineageMonster5.baby_bionic_bear','9','12.5',84,'male','L2FeedableBeast',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,12929,1379,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,40,120,1,1,1,1),
(18895,18895,'Young Grendel',0,'',0,'LineageMonster5.baby_bionic_bear_e','9','12.5',84,'male','L2FeedableBeast',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,20911,2111,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,40,120,1,1,1,1),
(18896,18896,'Young Grendel',0,'',0,'LineageMonster5.baby_bionic_bear_e','9','12.5',84,'male','L2FeedableBeast',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,27445,2908,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,40,120,1,1,1,1),
(18897,18897,'Adult Grendel',0,'',0,'LineageMonster2.bionic_bear','15','39',84,'male','L2FeedableBeast',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,9438,957,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,36,155,1,1,1,1),
(18898,18898,'Adult Grendel',0,'',0,'LineageMonster2.bionic_bear','15','39',84,'male','L2FeedableBeast',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,79302,8101,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,36,155,1,1,1,1),
(18899,18899,'Full Grown Grendel',0,'',0,'LineageMonster5.rough_bionic_bear','34','32.5',84,'male','L2FeedableBeast',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,13050,1342,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,40,120,1,1,1,1),
(18900,18900,'Full Grown Grendel',0,'',0,'LineageMonster5.rough_bionic_bear','34','32.5',84,'male','L2FeedableBeast',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,83904,7596,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,40,120,1,1,1,1),
(18901,18901,'Kookaburra',0,'Golden',0,'LineageMonster2.baby_ostrich_140p_e','12','21',83,'male','L2Npc',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,13,110,1,1,0,1),
(18902,18902,'Cougar',0,'Golden',0,'LineageMonster2.baby_tiger_130p_e','13','21',83,'male','L2Npc',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,0,0,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,28,110,1,1,0,1),
(18903,18903,'Buffalo',0,'Golden',0,'LineageMonster2.baby_buffalo_140p_e','16','22',84,'male','L2Npc',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,30,110,1,1,0,1),
(18904,18904,'Grendel',0,'Golden',0,'LineageMonster5.baby_bionic_bear_160p','12','17',84,'male','L2Npc',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,40,120,1,1,0,1),
(18905,18905,'Farm Ravager',0,'Crazed',0,'LineageMonster5.xel_mahum_warrior','29','37',84,'male','L2Npc',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,243976,2243,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,60,180,1,1,0,1),
(18906,18906,'Farm Bandit',0,'',0,'LineageMonster5.xel_mahum_warrior','29','37',84,'male','L2Monster',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,17662,1884,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,400,333,0,0,0,60,180,1,1,1,1),
(18907,18907,'Beast Devourer',0,'',0,'LineageMonster5.xel_mahum_sniper','27','31',84,'male','L2Monster',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,18652,1990,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,400,333,0,0,0,60,150,1,1,1,1),
(18908,18908,'Sel Mahum Chef',0,'',0,'LineageMonster5.ol_mahum_cooker','35','32.5',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,17548,1759,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,0,333,0,0,0,40,120,1,1,0,1),
(18909,18909,'Solina Knights',0,'',0,'LineageMonster3.monk_warrior','12','28.4',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,29810,3060,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,200,333,8211,8210,0,53,150,1,1,0,1),
(18910,18910,'Solina Knight Captain',0,'',0,'LineageMonster5.solina_knight','14','31.5',83,'male','L2Monster',40,'3835.59060587002','1777.4','8.5','3',40,43,30,21,20,20,44216,4545,'1099.42361669366','353.86144','750.763809564873','258.94045',253,4,200,333,0,0,0,30,66,1,1,0,1),
(18911,18911,'Abbey Treasure Chest',0,'',0,'LineageNpcEV.monastery_treasurebox','17','13',84,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18912,18912,'Scarecrow',0,'',0,'LineageNpcEV.puppet','27','37.5',1,'male','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,200,333,0,0,0,1,1,1,1,0,1),
(18913,18913,'Furnace',0,'',0,'LineageNpcEV.secret_pot_b','18','30',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18914,18914,'Furnace',0,'',0,'LineageNpcEV.secret_pot_a','18','30',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18915,18915,'Divine Furnace',0,'',0,'LineageNpcEV.secret_pot_c','18','30',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18916,18916,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.1','0.1',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18917,18917,'Pavel Safety Device',0,'',0,'LineageMonster4.giga_whirligig_40p','12','22.5',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,0,0,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,0,0,0,250,250,1,1,0,1),
(18918,18918,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.1','0.1',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18919,18919,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.1','0.1',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18920,18920,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.1','0.1',84,'male','L2Npc',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18921,18921,'Square Base',0,'',0,'LineageNpcEV.dark_clouds_crystal','23','37',84,'male','L2Npc',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18922,18922,'Door Golem',0,'Final',0,'LineageMonster2.baby_buffalo','8','15',84,'male','L2Npc',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,30,80,1,1,0,1),
(18923,18923,'Door Golem',0,'Final',0,'LineageMonster2.baby_buffalo','8','15',84,'male','L2Npc',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,30,80,1,1,0,1),
(18924,18924,'Door Golem',0,'',0,'LineageMonster2.baby_buffalo','8','15',84,'male','L2Npc',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,30,80,1,1,0,1),
(18925,18925,'Trap',0,'',0,'LineageNpcEV.Trap_device_bottom_staff','30','13',84,'etc','L2Npc',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18926,18926,'Mercenary Archer',0,'Jinia Guild',0,'LineageNPC2.archer_of_insurgents','10','23.5',85,'male','L2Npc',1100,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,8,0,333,0,0,0,30,160,1,1,0,1),
(18927,18927,'Fire',0,'',0,'LineageNpcEV.camp_fire_a','29','30.5',84,'male','L2Npc',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18928,18928,'Annihilation Furnace',0,'',0,'LineageNpcEV.gracia_fire_pot','63','33.5',85,'male','L2TerrainObject',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18929,18929,'Ward of the Grail',0,'',0,'LineageMonster.will_o_wisp','13','22',84,'male','L2Npc',40,'4039.04270539801','1812','8.5','3',40,43,30,21,20,20,0,0,'1144.73130112535','357.86723','781.703083407155','261.87171',253,1,0,333,0,0,0,25,140,0,1,0,1),
(18930,18930,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.1','0.1',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18931,18931,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.1','0.1',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18932,18932,'',0,'',0,'LineageNpcEV.freezing_dummy','0.1','0.1',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18933,18933,'Fire Feed',0,'',0,'LineageNpcEV.camp_fire_c','29','30.5',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,1,0,0,1),
(18934,18934,'Abbey Treasure Chest',0,'',0,'LineageNpcEV.monastery_treasurebox','17','13',84,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,1,1,0,1),
(18935,18935,'Divine Sword Protection',0,'',0,'LineageNPC.camera_target_dummy_a','0.1','0.1',85,'male','L2Npc',40,'4234.06312688557','1846.8','8.5','3',40,43,30,21,20,20,0,0,'1188.87259499001','361.78814','811.84586495282','264.74086',253,4,0,333,0,0,0,1,1,0,0,0,1),
(18936,18936,'',0,'',0,'LineageNPC.camera_target_dummy_a','0.1','0.1',1,'male','L2Npc',40,'39.74519','40','2','0.9',40,43,30,21,20,20,0,0,'8.47458','44.44444','5.78704','32.52252',253,4,0,333,0,0,0,1,1,0,0,0,1),
(20001,20001,'Gremlin',0,'',0,'LineageMonster.gremlin','10','15',1,'male','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,29,2,'8.47458','44.44444','5.78704','29.5916164000214',253,4,0,333,0,0,0,20,50,1,1,0,1),
(20002,20002,'Rabbit',0,'',0,'LineageMonster.rabbit','5','4.5',1,'male','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,29,2,'8.47458','44.44444','5.78704','29.5916164000214',253,4,0,333,0,0,0,50,80,1,1,0,1),
(20003,20003,'Goblin',0,'',0,'LineageMonster.goblin','10','16.5',5,'male','L2Monster',40,'80.17319','69.6','2','0.9',40,43,30,21,20,20,178,5,'12.34006','51.60553','8.42666','34.3595464531323',253,1,0,333,4,0,0,40,110,1,1,1,1),
(20004,20004,'Imp',0,'',0,'LineageMonster.imp','10','24',6,'male','L2Monster',40,'93.54158','77.2','2','0.9',40,43,30,21,20,20,214,6,'13.52471','53.53373','9.23562','35.6433609604933',253,4,0,333,0,0,0,60,80,1,1,1,1),
(20005,20005,'Imp Elder',0,'',0,'LineageMonster.imp','10','24',7,'male','L2Monster',40,'108.42254','84.88','2','0.9',40,43,30,21,20,20,249,8,'14.80956','55.51894','10.11301','36.965135694682',253,4,0,333,0,0,0,60,80,1,1,1,1),
(20006,20006,'Orc Archer',0,'',0,'LineageMonster.orc_archer','14','25',8,'male','L2Monster',1100,'124.92828','92.64','2','0.9',40,43,30,21,20,20,293,10,'16.20165','57.56203','11.06363','38.3254529794081',253,8,0,333,14,0,0,45,110,1,1,1,1),
(20007,20007,'Green Fungus',0,'',0,'LineageMonster.walking_fungus','15','22.5',9,'male','L2Monster',40,'143.17564','100.48','2','0.9',40,43,30,21,20,20,321,11,'17.70841','59.66387','12.09255','39.7248769407655',253,4,0,333,0,0,0,70,110,1,1,1,1),
(20008,20008,'Felim Lizardman',0,'',0,'LineageMonster.virud_lizardman','10','23',14,'male','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,499,19,'27.24646','71.08179','18.6058','47.3270583783809',253,4,0,333,1,0,0,43,130,1,1,1,1),
(20009,20009,'Vuku Orc',0,'',0,'LineageMonster.orc','10','21',14,'male','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,499,19,'27.24646','71.08179','18.6058','47.3270583783809',253,1,0,333,156,0,0,45,110,1,1,1,1),
(20010,20010,'Felim Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman','10','23',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,534,22,'29.61691','73.55216','20.22451','48.9718589929237',253,4,0,333,16,0,0,43,130,1,1,1,1),
(20011,20011,'Vuku Orc Archer',0,'',0,'LineageMonster.orc_archer','14','25',15,'male','L2Monster',1100,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,551,22,'29.61691','73.55216','20.22451','48.9718589929237',253,8,0,333,14,0,0,45,110,1,1,1,1),
(20012,20012,'Gora Werewolf',0,'',0,'LineageMonster.werewolf','10','26',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,582,23,'32.16396','76.08628','21.96382','50.6590964478128',253,1,500,333,0,0,0,50,120,1,1,1,1),
(20013,20013,'Dryad',0,'',0,'LineageMonster.dryad','9','20',13,'female','L2Monster',40,'214.61578','132.64','2.5','1.2',40,43,30,21,20,20,463,18,'25.04271','68.67458','17.10092','45.7243124542497',253,4,0,333,0,0,0,40,110,1,1,1,1),
(20014,20014,'Felim Lizardman Warrior',0,'',0,'LineageMonster.virud_lizardman_warrior','12','30',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,606,25,'34.8979','78.68469','23.83074','52.3891528929827',253,4,0,333,16,0,0,52,130,1,1,1,1),
(20015,20015,'Marsh Zombie',0,'',0,'LineageMonster.zombie','13','21',13,'male','L2Monster',40,'214.61578','132.64','2.5','1.2',40,43,30,21,20,20,655,26,'25.04271','68.67458','17.10092','45.7243124542497',253,4,0,333,0,0,0,15,15,1,1,1,1),
(20016,20016,'Stone Golem',0,'',0,'LineageMonster.stone_golem','20','31',13,'male','L2Monster',40,'214.61578','132.64','2.5','1.2',40,43,30,21,20,20,655,26,'25.04271','68.67458','17.10092','45.7243124542497',253,4,0,333,0,0,0,23,23,1,1,1,1),
(20017,20017,'Vuku Orc Fighter',0,'',0,'LineageMonster.orc_fighter','12','22',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,618,26,'34.8979','78.68469','23.83074','52.3891528929827',253,4,500,333,2,0,0,45,110,1,1,1,1),
(20018,20018,'Carnivorous Fungus',0,'',0,'LineageMonster.walking_fungus','15','22.5',14,'male','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,424,16,'27.24646','71.08179','18.6058','47.3270583783809',253,4,500,333,0,0,0,70,110,1,1,0,1),
(20019,20019,'Dryad Elder',0,'',0,'LineageMonster.dryad','9','20',14,'female','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,499,19,'27.24646','71.08179','18.6058','47.3270583783809',253,4,0,333,0,0,0,40,110,1,1,1,1),
(20020,20020,'Marsh Zombie Lord',0,'',0,'LineageMonster.zombie','13','21',14,'male','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,705,27,'27.24646','71.08179','18.6058','47.3270583783809',253,4,0,333,0,0,0,15,15,1,1,1,1),
(20021,20021,'Red Bear',0,'',0,'LineageMonster.grizzly','21','40',14,'male','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,499,19,'27.24646','71.08179','18.6058','47.3270583783809',253,4,0,333,0,0,0,40,110,1,1,1,1),
(20022,20022,'Misery Skeleton',0,'',0,'LineageMonster.skeleton','11','25',14,'male','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,424,16,'27.24646','71.08179','18.6058','47.3270583783809',253,8,500,333,946,945,0,60,140,1,1,0,1),
(20023,20023,'Shadow Beast',0,'',0,'LineageMonster.onyx_beast','14','14.5',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,534,22,'29.61691','73.55216','20.22451','48.9718589929237',253,4,0,333,0,0,0,30,120,1,1,1,1),
(20024,20024,'Langk Lizardman Warrior',0,'',0,'LineageMonster.virud_lizardman_warrior','12','30',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,618,26,'34.8979','78.68469','23.83074','52.3891528929827',253,4,500,333,16,0,0,52,130,1,1,1,1),
(20025,20025,'Lesser Dark Horror',0,'',0,'LineageMonster.dark_horror','20','35',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,545,22,'29.61691','73.55216','20.22451','48.9718589929237',253,4,500,333,0,0,0,100,100,1,1,1,1),
(20026,20026,'Ruin Zombie',0,'',0,'LineageMonster.zombie','13','21',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,756,31,'29.61691','73.55216','20.22451','48.9718589929237',253,4,0,333,0,0,0,15,15,1,1,1,1),
(20027,20027,'Langk Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman','10','23',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,571,23,'32.16396','76.08628','21.96382','50.6590964478128',253,4,0,333,16,0,0,43,130,1,1,1,1),
(20028,20028,'Pincher',0,'',0,'LineageMonster.giant_spider','26','25.5',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,571,23,'32.16396','76.08628','21.96382','50.6590964478128',253,4,0,333,0,0,0,72,130,1,1,1,1),
(20029,20029,'Ruin Zombie Leader',0,'',0,'LineageMonster.zombie','13','21',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,807,33,'32.16396','76.08628','21.96382','50.6590964478128',253,4,0,333,0,0,0,15,15,1,1,1,1),
(20030,20030,'Langk Lizardman',0,'',0,'LineageMonster.virud_lizardman','10','23',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,534,22,'29.61691','73.55216','20.22451','48.9718589929237',253,4,0,333,1,0,0,43,130,1,1,1,1),
(20031,20031,'Omen Beast',0,'',0,'LineageMonster.onyx_beast','14','14.5',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,505,21,'34.8979','78.68469','23.83074','52.3891528929827',253,4,0,333,0,0,0,30,120,1,1,0,1),
(20032,20032,'Pinrul',0,'',0,'LineageMonster.giant_spider','26','25.5',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,606,25,'34.8979','78.68469','23.83074','52.3891528929827',253,4,0,333,0,0,0,72,130,1,1,1,1),
(20033,20033,'Shade Horror',0,'',0,'LineageMonster.dark_horror','20','35',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,505,21,'34.8979','78.68469','23.83074','52.3891528929827',253,4,0,333,0,0,0,100,100,1,1,0,1),
(20034,20034,'Prowler',0,'',0,'LineageMonster.giant_spider','26','25.5',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,618,26,'34.8979','78.68469','23.83074','52.3891528929827',253,4,500,333,0,0,0,72,130,1,1,1,1),
(20035,20035,'Tracker Skeleton',0,'',0,'LineageMonster.skeleton','11','25',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,606,25,'34.8979','78.68469','23.83074','52.3891528929827',253,8,0,333,946,945,0,60,140,1,1,1,1),
(20036,20036,'Lirein',0,'',0,'LineageMonster.sylph','11','35',18,'female','L2Monster',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,653,28,'37.82932','81.34791','25.83252','54.1623558855199',253,4,500,333,0,0,0,60,60,1,1,1,1),
(20037,20037,'Mana Seeker',0,'',0,'LineageMonster.mana_vampire','11','20',18,'male','L2Monster',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,992,43,'37.82932','81.34791','25.83252','54.1623558855199',253,1,0,333,0,0,0,90,90,1,1,0,1),
(20038,20038,'Venomous Spider',0,'',0,'LineageMonster.poison_spider','27','25.5',18,'male','L2Monster',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,704,31,'37.82932','81.34791','25.83252','54.1623558855199',253,4,0,333,0,0,0,60,140,1,1,1,1),
(20039,20039,'Scavenger Wererat',0,'',0,'LineageMonster.wererat','14','25',18,'male','L2Monster',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,640,28,'37.82932','81.34791','25.83252','54.1623558855199',253,8,0,333,12,0,0,80,120,1,1,1,1),
(20040,20040,'Sukar Wererat',0,'',0,'LineageMonster.wererat','14','25',18,'male','L2Monster',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,533,23,'37.82932','81.34791','25.83252','54.1623558855199',253,8,0,333,216,0,0,80,120,1,1,0,1),
(20041,20041,'Tainted Zombie',0,'',0,'LineageMonster.zombie','13','21',18,'male','L2Monster',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,754,33,'37.82932','81.34791','25.83252','54.1623558855199',253,4,0,333,0,0,0,15,15,1,1,0,1),
(20042,20042,'Tracker Skeleton Leader',0,'',0,'LineageMonster.skeleton','11','25',18,'male','L2Monster',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,653,28,'37.82932','81.34791','25.83252','54.1623558855199',253,8,500,333,946,945,0,60,140,1,1,1,1),
(20043,20043,'Arachnid Tracker',0,'',0,'LineageMonster.poison_spider','27','25.5',19,'male','L2Monster',40,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,761,34,'40.96915','84.07638','27.97662','55.9790056860875',253,4,500,333,0,0,0,60,140,1,1,1,1),
(20044,20044,'Lirein Elder',0,'',0,'LineageMonster.sylph','11','35',19,'female','L2Monster',40,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,692,31,'40.96915','84.07638','27.97662','55.9790056860875',253,4,500,333,0,0,0,60,60,1,1,1,1),
(20045,20045,'Skeleton Scout',0,'',0,'LineageMonster.skeleton_archer','11','27',19,'male','L2Monster',1100,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,699,31,'40.96915','84.07638','27.97662','55.9790056860875',253,8,0,333,275,0,0,40,140,1,1,1,1),
(20046,20046,'Stink Zombie',0,'',0,'LineageMonster.zombie','13','21',19,'male','L2Monster',40,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,799,36,'40.96915','84.07638','27.97662','55.9790056860875',253,4,0,333,0,0,0,15,15,1,1,0,1),
(20047,20047,'Sukar Wererat Leader',0,'',0,'LineageMonster.wererat','14','25',19,'male','L2Monster',40,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,576,26,'40.96915','84.07638','27.97662','55.9790056860875',253,8,500,333,216,0,0,80,120,1,1,0,1),
(20048,20048,'Lesser Succubus',0,'',0,'LineageMonster.succubus','10','36',20,'female','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,606,27,'44.32863','86.87049','30.2707','57.8393570613084',253,4,500,333,0,0,0,60,100,1,1,0,1),
(20049,20049,'Lycanthrope',0,'',0,'LineageMonster.werewolf','10','26',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,727,32,'44.32863','86.87049','30.2707','57.8393570613084',253,1,500,333,0,0,0,50,120,1,1,1,1),
(20050,20050,'Arachnid Predator',0,'',0,'LineageMonster.poison_spider','27','25.5',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,800,35,'44.32863','86.87049','30.2707','57.8393570613084',253,4,500,333,0,0,0,60,140,1,1,1,1),
(20051,20051,'Skeleton Bowman',0,'',0,'LineageMonster.skeleton_archer','11','27',20,'male','L2Monster',1100,'342.5127','192','2.5','1.2',40,43,30,21,20,20,734,32,'44.32863','86.87049','30.2707','57.8393570613084',253,8,0,333,275,0,0,40,140,1,1,1,1),
(20052,20052,'Lesser Succubus Turen',0,'',0,'LineageMonster.succubus','10','36',21,'female','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,780,36,'47.91924','89.73059','32.72263','59.7436374813816',253,4,500,333,0,0,0,60,100,1,1,0,1),
(20053,20053,'Ol Mahum Patrol',0,'',0,'LineageMonster.ol_mahum_archer','14','25',21,'male','L2Monster',1100,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,945,43,'47.91924','89.73059','32.72263','59.7436374813816',253,8,0,333,14,0,0,50,110,1,1,1,1),
(20054,20054,'Ruin Spartoi',0,'',0,'LineageMonster.spartoi','11','27',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,917,42,'47.91924','89.73059','32.72263','59.7436374813816',253,4,0,333,73,0,0,60,140,1,1,1,1),
(20055,20055,'Wandering Eye',0,'',0,'LineageMonster.monster_eye','21','43',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,917,42,'47.91924','89.73059','32.72263','59.7436374813816',253,4,0,333,0,0,0,90,159,1,1,1,1),
(20056,20056,'Dre Vanul Disposer',0,'',0,'LineageMonster.dre_vanul','14','36',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,921,43,'51.75278','92.65694','35.34044','61.6920289224665',253,1,500,333,0,0,0,80,80,1,1,0,1),
(20057,20057,'Lesser Succubus Tilfo',0,'',0,'LineageMonster.succubus','10','36',22,'female','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,838,40,'51.75278','92.65694','35.34044','61.6920289224665',253,4,500,333,0,0,0,60,100,1,1,0,1),
(20058,20058,'Ol Mahum Guard',0,'',0,'LineageMonster.ol_mahum','13.5','25',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,986,47,'51.75278','92.65694','35.34044','61.6920289224665',253,4,0,333,2,0,0,50,110,1,1,1,1),
(20059,20059,'Hungry Eye',0,'',0,'LineageMonster.monster_eye','21','43',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,986,47,'51.75278','92.65694','35.34044','61.6920289224665',253,4,0,333,0,0,0,90,159,1,1,1,1),
(20060,20060,'Raging Spartoi',0,'',0,'LineageMonster.spartoi','11','27',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,1005,48,'51.75278','92.65694','35.34044','61.6920289224665',253,8,500,333,946,945,0,60,140,1,1,1,1),
(20061,20061,'Ol Mahum Straggler',0,'',0,'LineageMonster.ol_mahum','13.5','25',23,'male','L2Monster',40,'410.70422','231.96','3.5','1.5',40,43,30,21,20,20,1075,52,'55.84125','95.64976','38.13234','63.6846860642986',253,4,500,333,2,0,0,50,110,1,1,1,1),
(20062,20062,'Tumran Bugbear',0,'',0,'LineageMonster.bugbear','17','35',23,'male','L2Monster',40,'410.70422','231.96','3.5','1.5',40,43,30,21,20,20,1054,50,'55.84125','95.64976','38.13234','63.6846860642986',253,1,0,333,156,0,0,55,130,1,1,1,1),
(20063,20063,'Ol Mahum Shooter',0,'',0,'LineageMonster.ol_mahum_archer','14','25',24,'male','L2Monster',1100,'435.34437','245.52','3.5','1.5',40,43,30,21,20,20,1156,56,'60.19687','98.70919','41.10666','65.7216907961494',253,8,0,333,14,0,0,50,110,1,1,1,1),
(20064,20064,'Tumran Bugbear Warrior',0,'',0,'LineageMonster.bugbear','17','35',24,'male','L2Monster',40,'435.34437','245.52','3.5','1.5',40,43,30,21,20,20,1145,56,'60.19687','98.70919','41.10666','65.7216907961494',253,1,500,333,88,0,0,55,130,1,1,1,1),
(20065,20065,'Ol Mahum Patrolman',0,'',0,'LineageMonster.ol_mahum','13.5','25',25,'male','L2Monster',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,992,49,'64.83203','101.83533','44.27187','67.8031159084826',253,4,0,333,2,0,0,50,110,1,1,0,1),
(20066,20066,'Ol Mahum Captain',0,'',0,'LineageMonster.ol_mahum_champion','14','27',25,'male','L2Monster',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,1263,64,'64.83203','101.83533','44.27187','67.8031159084826',253,4,500,333,69,0,0,50,110,1,1,1,1),
(20067,20067,'Monster Eye Watcher',0,'',0,'LineageMonster.monster_eye','21','43',25,'male','L2Monster',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,1191,60,'64.83203','101.83533','44.27187','67.8031159084826',253,4,0,333,0,0,0,90,159,1,1,1,1),
(20068,20068,'Monster Eye Destroyer',0,'',0,'LineageMonster.monster_eye','21','43',26,'male','L2Monster',40,'487.5704','273','3.5','1.5',40,43,30,21,20,20,1294,65,'69.75926','105.02818','47.63653','69.9289432036824',253,4,500,333,0,0,0,90,159,1,1,1,1),
(20069,20069,'Selu Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman','10','23',26,'male','L2Monster',40,'487.5704','273','3.5','1.5',40,43,30,21,20,20,1057,53,'69.75926','105.02818','47.63653','69.9289432036824',253,4,0,333,16,0,0,43,130,1,1,0,1),
(20070,20070,'Lesser Basilisk',0,'',0,'LineageMonster.lesser_basilisk','34','25',27,'male','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,1349,70,'74.99121','108.28767','51.20928','72.0991544841329',253,4,500,333,0,0,0,35,131,1,1,1,1),
(20071,20071,'Selu Lizardman Warrior',0,'',0,'LineageMonster.virud_lizardman_warrior','12','30',27,'male','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,1136,58,'74.99121','108.28767','51.20928','72.0991544841329',253,4,500,333,16,0,0,52,130,1,1,0,1),
(20072,20072,'Basilisk',0,'',0,'LineageMonster.lesser_basilisk','34','25',28,'male','L2Monster',40,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,1428,74,'80.54056','111.61368','54.99876','74.3136496629463',253,4,500,333,0,0,0,35,131,1,1,1,1),
(20073,20073,'Ol Mahum Legionnaire',0,'',0,'LineageMonster.ol_mahum','13.5','25',28,'male','L2Monster',40,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,1178,62,'80.54056','111.61368','54.99876','74.3136496629463',253,4,0,333,2,0,0,50,110,1,1,0,1),
(20074,20074,'Androscorpio',0,'',0,'LineageMonster.onyx_beast','14','14.5',29,'male','L2Monster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,1492,80,'86.42002','115.00598','59.01367','76.5722740603874',253,4,0,333,0,0,0,30,120,1,1,1,1),
(20075,20075,'Ant Larva',0,'',0,'LineageMonster.ant_larva','12','8',29,'male','L2Monster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,1368,73,'86.42002','115.00598','59.01367','76.5722740603874',253,4,0,333,0,0,0,40,60,1,1,0,1),
(20076,20076,'Ol Mahum Commander',0,'',0,'LineageMonster.ol_mahum_champion','14','27',29,'male','L2Monster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,1583,85,'86.42002','115.00598','59.01367','76.5722740603874',253,4,500,333,69,0,0,50,110,1,1,1,1),
(20077,20077,'Androscorpio Hunter',0,'',0,'LineageMonster.onyx_beast','14','14.5',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,1571,86,'92.64226','118.46427','63.26266','78.8748547991048',253,4,0,333,0,0,0,30,120,1,1,1,1),
(20078,20078,'Whispering Wind',0,'',0,'LineageMonster.sylph_100_bi','20','70',30,'female','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,1571,86,'92.64226','118.46427','63.26266','78.8748547991048',253,4,0,333,0,0,0,60,60,1,1,1,1),
(20079,20079,'Ant',0,'',0,'LineageMonster.ant','26','15',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,1571,86,'92.64226','118.46427','63.26266','78.8748547991048',253,4,0,333,0,0,0,40,130,1,1,0,1),
(20080,20080,'Ant Captain',0,'',0,'LineageMonster.ant','26','15',31,'male','L2Monster',40,'635.76437','343.8','4.5','1.8',40,43,30,21,20,20,1711,95,'99.21986','121.98819','67.7543','81.2211098160515',253,4,500,333,0,0,0,40,130,1,1,0,1),
(20081,20081,'Ant Overseer',0,'',0,'LineageMonster.ant','26','15',32,'male','L2Monster',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,2881,162,'106.16525','125.57727','72.49711','83.6107570481808',253,4,0,333,0,0,0,40,130,1,1,0,1),
(20082,20082,'Ant Recruit',0,'',0,'LineageMonster.ant_soldier','35','17',33,'male','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,1742,100,'113.49065','129.23095','77.49941','86.043423444366',253,4,0,333,0,0,0,80,130,1,1,0,1),
(20083,20083,'Granite Golem',0,'',0,'LineageMonster.stone_golem','20','31',33,'male','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,2687,155,'113.49065','129.23095','77.49941','86.043423444366',253,4,0,333,0,0,0,23,23,1,1,1,1),
(20084,20084,'Ant Patrol',0,'',0,'LineageMonster.ant_soldier','35','17',34,'male','L2Monster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,2001,116,'121.20802','132.9486','82.76936','88.5186722618248',253,4,0,333,0,0,0,80,130,1,1,0,1),
(20085,20085,'Puncher',0,'',0,'LineageMonster.stone_golem','20','31',34,'male','L2Monster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,2910,170,'121.20802','132.9486','82.76936','88.5186722618248',253,4,500,333,0,0,0,23,23,1,1,1,1),
(20086,20086,'Ant Guard',0,'',0,'LineageMonster.ant_soldier','35','17',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,1782,106,'129.32896','136.72948','88.31491','91.0360303625432',253,4,0,333,0,0,0,80,174,1,1,0,1),
(20087,20087,'Ant Soldier',0,'',0,'LineageMonster.ant_soldier','35','17',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,4274,253,'129.32896','136.72948','88.31491','91.0360303625432',253,4,500,333,0,0,0,80,174,1,1,0,1),
(20088,20088,'Ant Warrior Captain',0,'',0,'LineageMonster.ant_soldier','35','17',36,'male','L2Monster',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,4763,288,'137.86467','140.57278','94.1437','93.5949427192352',253,4,500,333,0,0,0,80,174,1,1,0,1),
(20089,20089,'Noble Ant',0,'',0,'LineageMonster.noble_ant','20','48',37,'male','L2Monster',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,20,1991,122,'146.82587','144.47758','100.26304','96.1948088105753',253,4,0,333,0,0,0,80,174,1,1,0,1),
(20090,20090,'Noble Ant Leader',0,'',0,'LineageMonster.noble_ant','20','48',38,'male','L2Monster',40,'886.09975','447.96','4.5','1.8',40,43,30,21,20,20,4391,274,'156.22273','148.44287','106.67987','98.8349371271581',253,4,500,333,0,0,0,80,174,1,1,0,1),
(20091,20091,'Young Fox',0,'',0,'LineageMonster.fox','9.5','10',1,'male','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,29,2,'8.47458','44.44444','5.78704','29.5916164000214',253,4,0,333,0,0,0,23,110,1,1,0,1),
(20092,20092,'Monster Eye',0,'',0,'LineageMonster.monster_eye','21','43',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,294,10,'19.33758','61.82527','13.20506','41.16396260604',253,1,0,333,0,0,0,90,134,1,1,0,1),
(20093,20093,'Orc Fighter',0,'',0,'LineageMonster.orc_fighter','12','22',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,363,12,'19.33758','61.82527','13.20506','41.16396260604',253,4,500,333,1,0,0,45,110,1,1,1,1),
(20094,20094,'Orc Marksman',0,'',0,'LineageMonster.orc_archer','14','25',10,'male','L2Monster',1100,'163.28607','108.4','2','0.9',40,43,30,21,20,20,306,10,'19.33758','61.82527','13.20506','41.16396260604',253,8,0,333,14,0,0,45,110,1,1,0,1),
(20095,20095,'Vampire Bat',0,'',0,'LineageMonster.vampire_bat','10','33.5',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,297,10,'19.33758','61.82527','13.20506','41.16396260604',253,1,0,333,0,0,0,60,80,1,1,0,1),
(20096,20096,'Orc Lieutenant',0,'',0,'LineageMonster.orc_fighter','12','22',11,'male','L2Monster',40,'185.38552','116.4','2.5','1.2',40,43,30,21,20,20,392,15,'21.0973','64.04702','14.40672','42.6432286072855',253,4,0,333,2,0,0,45,110,1,1,1,1),
(20097,20097,'Drill Bat',0,'',0,'LineageMonster.vampire_bat','10','33.5',11,'male','L2Monster',40,'185.38552','116.4','2.5','1.2',40,43,30,21,20,20,326,12,'21.0973','64.04702','14.40672','42.6432286072855',253,1,0,333,0,0,0,60,80,1,1,0,1),
(20098,20098,'Orc Fighter Leader',0,'',0,'LineageMonster.orc_fighter','12','22',12,'male','L2Monster',40,'199.62322','124.48','2.5','1.2',40,43,30,21,20,20,448,17,'22.99606','66.32989','15.70333','44.163184477748',253,4,500,333,2,0,0,45,110,1,1,1,1),
(20099,20099,'Skeleton',0,'',0,'LineageMonster.skeleton','11','25',12,'male','L2Monster',40,'199.62322','124.48','2.5','1.2',40,43,30,21,20,20,363,13,'22.99606','66.32989','15.70333','44.163184477748',253,8,500,333,946,945,0,60,140,1,1,0,1),
(20100,20100,'Skeleton Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',13,'male','L2Monster',1100,'214.61578','132.64','2.5','1.2',40,43,30,21,20,20,405,16,'25.04271','68.67458','17.10092','45.7243124542497',253,8,500,333,14,0,0,40,140,1,1,0,1),
(20101,20101,'Crasher',0,'',0,'LineageMonster.stone_golem','20','31',14,'male','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,705,27,'27.24646','71.08179','18.6058','47.3270583783809',253,4,0,333,0,0,0,23,23,1,1,1,1),
(20102,20102,'Skeleton Marksman',0,'',0,'LineageMonster.skeleton_archer','11','27',14,'male','L2Monster',1100,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,428,17,'27.24646','71.08179','18.6058','47.3270583783809',253,8,0,333,14,0,0,40,140,1,1,0,1),
(20103,20103,'Giant Spider',0,'',0,'LineageMonster.giant_spider','26','25.5',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,545,22,'29.61691','73.55216','20.22451','48.9718589929237',253,4,500,333,0,0,0,72,130,1,1,1,1),
(20104,20104,'Skeleton Lord',0,'',0,'LineageMonster.skeleton','11','25',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,445,18,'29.61691','73.55216','20.22451','48.9718589929237',253,8,0,333,946,945,0,60,140,1,1,0,1),
(20105,20105,'Dark Horror',0,'',0,'LineageMonster.dark_horror','20','35',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,577,23,'32.16396','76.08628','21.96382','50.6590964478128',253,4,500,333,0,0,0,100,100,1,1,1,1),
(20106,20106,'Talon Spider',0,'',0,'LineageMonster.giant_spider','26','25.5',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,571,23,'32.16396','76.08628','21.96382','50.6590964478128',253,4,0,333,0,0,0,72,130,1,1,1,1),
(20107,20107,'Wererat',0,'',0,'LineageMonster.wererat','14','25',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,476,19,'32.16396','76.08628','21.96382','50.6590964478128',253,1,0,333,0,0,0,80,120,1,1,0,1),
(20108,20108,'Blade Spider',0,'',0,'LineageMonster.giant_spider','26','25.5',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,618,26,'34.8979','78.68469','23.83074','52.3891528929827',253,4,500,333,0,0,0,72,130,1,1,1,1),
(20109,20109,'Salamander',0,'',0,'LineageMonster.salamander','16','6.8',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,990,42,'34.8979','78.68469','23.83074','52.3891528929827',253,1,0,333,0,0,0,64,96,1,1,0,1),
(20110,20110,'Undine',0,'',0,'LineageMonster.undine','12','27',17,'female','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,958,40,'34.8979','78.68469','23.83074','52.3891528929827',253,1,500,333,0,0,0,60,60,1,1,0,1),
(20111,20111,'Wererat Leader',0,'',0,'LineageMonster.wererat','14','25',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,958,40,'34.8979','78.68469','23.83074','52.3891528929827',253,4,500,333,1,0,0,80,120,1,1,0,1),
(20112,20112,'Salamander Elder',0,'',0,'LineageMonster.salamander','16','6.8',18,'male','L2Monster',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,992,43,'37.82932','81.34791','25.83252','54.1623558855199',253,1,0,333,0,0,0,64,96,1,1,0,1),
(20113,20113,'Undine Elder',0,'',0,'LineageMonster.undine','12','27',18,'female','L2Monster',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,1012,44,'37.82932','81.34791','25.83252','54.1623558855199',253,1,500,333,0,0,0,60,60,1,1,0,1),
(20114,20114,'Salamander Noble',0,'',0,'LineageMonster.salamander','16','6.8',19,'male','L2Monster',40,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,1051,47,'40.96915','84.07638','27.97662','55.9790056860875',253,1,0,333,0,0,0,64,96,1,1,0,1),
(20115,20115,'Undine Noble',0,'',0,'LineageMonster.undine','12','27',19,'female','L2Monster',40,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,1072,48,'40.96915','84.07638','27.97662','55.9790056860875',253,1,500,333,0,0,0,60,60,1,1,0,1),
(20116,20116,'Fox',0,'',0,'LineageMonster.fox','9.5','10',2,'male','L2Monster',40,'48.09168','47.28','2','0.9',40,43,30,21,20,20,59,2,'9.32203','46.15385','6.36574','30.7297498930634',253,4,0,333,0,0,0,23,110,1,1,0,1),
(20117,20117,'Dre Vanul',0,'',0,'LineageMonster.dre_vanul','14','36',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,666,29,'44.32863','86.87049','30.2707','57.8393570613084',253,1,500,333,0,0,0,80,80,1,1,0,1),
(20118,20118,'Dre Vanul Scout',0,'',0,'LineageMonster.dre_vanul','14','36',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,780,36,'47.91924','89.73059','32.72263','59.7436374813816',253,1,0,333,0,0,0,80,80,1,1,0,1),
(20119,20119,'Elder Fox',0,'',0,'LineageMonster.fox','9.5','10',3,'male','L2Monster',40,'57.54874','54.64','2','0.9',40,43,30,21,20,20,88,2,'10.24492','47.91652','6.99595','31.9033596383589',253,4,0,333,0,0,0,23,110,1,1,0,1),
(20120,20120,'Wolf',0,'',0,'LineageMonster.wolf','13','9',4,'male','L2Monster',40,'68.20985','62.08','2','0.9',40,43,30,21,20,20,141,4,'11.24892','49.73343','7.68155','33.1130825524654',253,4,0,333,0,0,0,24,110,1,1,1,1),
(20121,20121,'Giant Toad',0,'',0,'LineageMonster.poison_toad','20','10',5,'male','L2Monster',40,'80.17319','69.6','2','0.9',40,43,30,21,20,20,178,5,'12.34006','51.60553','8.42666','34.3595464531323',253,4,0,333,0,0,0,50,100,1,1,1,1),
(20130,20130,'Orc',0,'',0,'LineageMonster.orc','10','21',6,'male','L2Monster',40,'93.54158','77.2','2','0.9',40,43,30,21,20,20,214,6,'13.52471','53.53373','9.23562','35.6433609604933',253,1,0,333,156,0,0,45,110,1,1,1,1),
(20131,20131,'Orc Grunt',0,'',0,'LineageMonster.orc','10','21',7,'male','L2Monster',40,'108.42254','84.88','2','0.9',40,43,30,21,20,20,249,8,'14.80956','55.51894','10.11301','36.965135694682',253,1,0,333,4,0,0,45,110,1,1,1,1),
(20132,20132,'Werewolf',0,'',0,'LineageMonster.werewolf','10','26',9,'male','L2Monster',40,'143.17564','100.48','2','0.9',40,43,30,21,20,20,321,11,'17.70841','59.66387','12.09255','39.7248769407655',253,1,0,333,0,0,0,50,120,1,1,1,1),
(20133,20133,'Bugbear',0,'',0,'LineageMonster.bugbear','17','35',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,780,36,'47.91924','89.73059','32.72263','59.7436374813816',253,1,500,333,4,0,0,55,130,1,1,0,1),
(20134,20134,'Cave Maiden',0,'',0,'LineageMonster.cave_maiden','25','65',59,'female','L2Monster',40,'1880.92519','1007','6.5','2.4',40,43,30,21,20,20,6135,524,'461.94387','242.81593','315.44778','161.669585254993',253,4,500,333,68,0,0,70,174,1,1,0,1),
(20135,20135,'Alligator',0,'',0,'LineageMonster.crocodile','28','11.5',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,2848,184,'176.36077','156.55035','120.43155','104.232986928232',253,4,500,333,0,0,0,70,174,1,1,1,1),
(20136,20136,'Death Knight',0,'',0,'LineageMonster.death_knight','12','31',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,14026,1012,'305.54906','200.23844','208.6504','146.5258',253,4,500,333,75,0,0,27,110,1,1,0,1),
(20137,20137,'Drake',0,'',0,'LineageMonster.drake','30','100',57,'male','L2Monster',40,'1776.58018','948','6.5','2.4',40,43,30,21,20,20,5784,481,'424.23295','233.18839','289.69611','155.259456846417',253,4,500,333,0,0,0,70,174,1,1,0,1),
(20138,20138,'Gargoyle',0,'',0,'LineageMonster.gargoyle','16','50',27,'male','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,1136,58,'74.99121','108.28767','51.20928','72.0991544841329',253,4,500,333,0,0,0,140,140,1,1,0,1),
(20139,20139,'Giant Bee',0,'',0,'LineageMonster.giant_bee','8','24.5',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,471,19,'32.16396','76.08628','21.96382','50.6590964478128',253,4,0,333,0,0,0,90,90,1,1,0,1),
(20140,20140,'Giant Leech',0,'',0,'LineageMonster.giant_leech','70','29',24,'male','L2Monster',40,'435.34437','245.52','3.5','1.5',40,43,30,21,20,20,954,47,'60.19687','98.70919','41.10666','65.7216907961494',253,4,500,333,0,0,0,50,110,1,1,0,1),
(20141,20141,'Giant Wild Hog',0,'',0,'LineageMonster.giant_wild_hog','35','27',47,'male','L2Monster',40,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,3277,235,'261.69549','186.63569','178.7041','124.264149144103',253,4,500,333,0,0,0,35,120,1,1,0,1),
(20142,20142,'Griffon',0,'',0,'LineageMonster.griffin','20','44',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,594,26,'44.32863','86.87049','30.2707','57.8393570613084',253,4,0,333,0,0,0,90,90,1,1,0,1),
(20143,20143,'Grizzly',0,'',0,'LineageMonster.grizzly','21','40',12,'male','L2Monster',40,'199.62322','124.48','2.5','1.2',40,43,30,21,20,20,436,16,'22.99606','66.32989','15.70333','44.163184477748',253,4,500,333,0,0,0,40,110,1,1,1,1),
(20144,20144,'Hangman Tree',0,'',0,'LineageMonster.hanged_man_ripper','35','80',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,2181,130,'129.32896','136.72948','88.31491','91.0360303625432',253,4,500,333,0,0,0,55,174,1,1,1,1),
(20145,20145,'Harpy',0,'',0,'LineageMonster.harpy','10','42',32,'female','L2Monster',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,1805,101,'106.16525','125.57727','72.49711','83.6107570481808',253,4,500,333,0,0,0,60,100,1,1,1,1),
(20146,20146,'Headless Knight',0,'',0,'LineageMonster.headless_knight','21','31',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,4450,335,'305.54906','200.23844','208.6504','133.321011603844',253,4,500,333,124,0,0,70,174,1,1,0,1),
(20147,20147,'Hobgoblin',0,'',0,'LineageMonster.hobgoblin','12','24',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,917,42,'47.91924','89.73059','32.72263','59.7436374813816',253,1,0,333,4,0,0,45,110,1,1,1,1),
(20148,20148,'Hungry Spirit',0,'',0,'LineageMonster.hungry_spirit','30','40',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,2350,151,'176.36077','156.55035','120.43155','104.232986928232',253,4,500,333,0,0,0,15,120,1,1,0,1),
(20149,20149,'Iron Golem',0,'',0,'LineageMonster.iron_golem','18','34',38,'male','L2Monster',40,'886.09975','447.96','4.5','1.8',40,43,30,21,20,20,3029,188,'156.22273','148.44287','106.67987','98.8349371271581',253,4,500,333,0,0,0,20,20,1,1,0,1),
(20150,20150,'King Bugbear',0,'',0,'LineageMonster.king_bugbear','15','40',32,'male','L2Monster',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,1519,85,'106.16525','125.57727','72.49711','83.6107570481808',253,1,500,333,88,0,0,55,130,1,1,0,1),
(20151,20151,'Kobold',0,'',0,'LineageMonster.kobold','10','15',4,'male','L2Monster',40,'68.20985','62.08','2','0.9',40,43,30,21,20,20,119,3,'11.24892','49.73343','7.68155','33.1130825524654',253,1,0,333,4,0,0,47,110,1,1,0,1),
(20152,20152,'Lizardman',0,'',0,'LineageMonster.virud_lizardman','10','23',19,'male','L2Monster',40,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,565,25,'40.96915','84.07638','27.97662','55.9790056860875',253,4,0,333,291,0,0,43,130,1,1,0,1),
(20153,20153,'Magical Weaver',0,'',0,'LineageMonster.magical_weaver','11','20',11,'male','L2Monster',40,'185.38552','116.4','2.5','1.2',40,43,30,21,20,20,392,15,'21.0973','64.04702','14.40672','42.6432286072855',253,4,0,333,0,0,0,90,90,1,1,1,1),
(20154,20154,'Mandragora Sprout',0,'',0,'LineageMonster.manadragora','14','17.8',21,'female','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,917,42,'47.91924','89.73059','32.72263','59.7436374813816',253,4,0,333,0,0,0,80,80,1,1,1,1),
(20155,20155,'Mandragora Sapling',0,'',0,'LineageMonster.mandragora_a','15','26',23,'female','L2Monster',40,'410.70422','231.96','3.5','1.5',40,43,30,21,20,20,1075,52,'55.84125','95.64976','38.13234','63.6846860642986',253,4,500,333,0,0,0,80,120,1,1,1,1),
(20156,20156,'Mandragora Blossom',0,'',0,'LineageMonster.mandragora_b','12','25.5',25,'female','L2Monster',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,1215,61,'64.83203','101.83533','44.27187','67.8031159084826',253,4,500,333,0,0,0,80,120,1,1,1,1),
(20157,20157,'Marsh Stakato',0,'',0,'LineageMonster.marsh_stakato','10','20',29,'male','L2Monster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,1811,97,'86.42002','115.00598','59.01367','76.5722740603874',253,8,500,333,223,0,0,21,120,1,1,1,1),
(20158,20158,'Medusa',0,'',0,'LineageMonster.medusa','10','25',34,'female','L2Monster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,2058,120,'121.20802','132.9486','82.76936','88.5186722618248',253,4,500,333,0,0,0,50,110,1,1,1,1),
(20159,20159,'Minotaur',0,'',0,'LineageMonster.minotaur','21','45.5',43,'male','L2Monster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,2716,184,'210.04832','169.13417','143.43577','112.611442266143',253,1,500,333,300,0,0,40,120,1,1,0,1),
(20160,20160,'Neer Crawler',0,'',0,'LineageMonster.neer_crawler','14','22',28,'male','L2Monster',40,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,1442,76,'80.54056','111.61368','54.99876','74.3136496629463',253,4,500,333,0,0,0,50,90,1,1,1,1),
(20161,20161,'Oel Mahum',0,'',0,'LineageMonster.oel_mahum','20','37',53,'male','L2Monster',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,4846,380,'353.71092','214.18326','241.5387','156.73001',253,4,500,333,127,0,0,70,110,1,1,1,1),
(20162,20162,'Ogre',0,'',0,'LineageMonster.ogre','21','44',41,'male','L2Monster',40,'1008.23781','504.8','5.5','2.1',40,43,30,21,20,20,2469,162,'187.11878','160.69002','127.77787','106.989225133249',253,4,500,333,98,0,0,22,80,1,1,0,1),
(20163,20163,'Ol Mahum',0,'',0,'LineageMonster.ol_mahum','13.5','25',23,'male','L2Monster',40,'410.70422','231.96','3.5','1.5',40,43,30,21,20,20,878,42,'55.84125','95.64976','38.13234','63.6846860642986',253,4,0,333,2,0,0,50,110,1,1,0,1),
(20164,20164,'Ol Mahum Archer',0,'',0,'LineageMonster.ol_mahum_archer','14','25',25,'male','L2Monster',1100,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,1043,53,'64.83203','101.83533','44.27187','67.8031159084826',253,8,500,333,14,0,0,50,110,1,1,0,1),
(20165,20165,'Ol Mahum Champion',0,'',0,'LineageMonster.ol_mahum_champion','14','27',29,'male','L2Monster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,1509,80,'86.42002','115.00598','59.01367','76.5722740603874',253,4,500,333,69,0,0,50,110,1,1,0,1),
(20166,20166,'Succubus',0,'',0,'LineageMonster.succubus','10','36',32,'female','L2Monster',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,1519,85,'106.16525','125.57727','72.49711','83.6107570481808',253,4,500,333,0,0,0,60,100,1,1,0,1),
(20167,20167,'Serpent Slave',0,'',0,'LineageMonster.serpent_slave','17','46',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,2374,154,'176.36077','156.55035','120.43155','104.232986928232',253,4,500,333,73,0,0,70,110,1,1,0,1),
(20168,20168,'Silenos',0,'',0,'LineageMonster.silenos','14','32.5',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,1571,86,'92.64226','118.46427','63.26266','78.8748547991048',253,1,0,333,88,0,0,70,110,1,1,1,1),
(20169,20169,'Skeleton Royal Guard',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',26,'male','L2Monster',40,'487.5704','273','3.5','1.5',40,43,30,21,20,20,1078,54,'69.75926','105.02818','47.63653','69.9289432036824',253,8,500,333,946,945,0,80,120,1,1,0,1),
(20170,20170,'Spartoi',0,'',0,'LineageMonster.spartoi','11','27',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,454,19,'29.61691','73.55216','20.22451','48.9718589929237',253,8,500,333,946,945,0,60,140,1,1,0,1),
(20171,20171,'Specter',0,'',0,'LineageMonster.dark_horror','20','35',26,'male','L2Monster',40,'487.5704','273','3.5','1.5',40,43,30,21,20,20,1294,65,'69.75926','105.02818','47.63653','69.9289432036824',253,4,500,333,0,0,0,100,100,1,1,1,1),
(20172,20172,'Sylph',0,'',0,'LineageMonster.sylph','11','35',10,'female','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,297,10,'19.33758','61.82527','13.20506','41.16396260604',253,4,0,333,0,0,0,60,60,1,1,0,1),
(20173,20173,'Troll',0,'',0,'LineageMonster.troll','21','35',33,'male','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,1600,91,'113.49065','129.23095','77.49941','86.043423444366',253,1,500,333,0,0,0,55,110,1,1,0,1),
(20174,20174,'Two-Headed Giant',0,'',0,'LineageMonster.twin_headed_giant','17','39',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,1799,107,'129.32896','136.72948','88.31491','91.0360303625432',253,1,500,333,4,0,0,45,100,1,1,0,1),
(20175,20175,'Walking Fungus',0,'',0,'LineageMonster.walking_fungus','15','22.5',8,'male','L2Monster',40,'124.92828','92.64','2','0.9',40,43,30,21,20,20,237,8,'16.20165','57.56203','11.06363','38.3254529794081',253,4,0,333,0,0,0,70,110,1,1,0,1),
(20176,20176,'Wyrm',0,'',0,'LineageMonster.wyrm','29','72',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,2181,130,'129.32896','136.72948','88.31491','91.0360303625432',253,4,500,333,0,0,0,70,174,1,1,1,1),
(20177,20177,'Zombie',0,'',0,'LineageMonster.zombie','13','21',6,'male','L2Monster',40,'93.54158','77.2','2','0.9',40,43,30,21,20,20,178,5,'13.52471','53.53373','9.23562','35.6433609604933',253,4,0,333,0,0,0,15,15,1,1,0,1),
(20189,20189,'Puma',0,'',0,'LineageMonster.onyx_beast','14','14.5',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,441,18,'29.61691','73.55216','20.22451','48.9718589929237',253,4,0,333,0,0,0,30,120,1,1,0,1),
(20190,20190,'Skeleton Marauder',0,'',0,'LineageMonster.skeleton_archer','11','27',29,'male','L2Monster',1100,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,1568,84,'86.42002','115.00598','59.01367','76.5722740603874',253,8,500,333,14,0,0,40,140,1,1,1,1),
(20191,20191,'Skeleton Raider',0,'',0,'LineageMonster.skeleton','11','25',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,1602,88,'92.64226','118.46427','63.26266','78.8748547991048',253,8,500,333,946,945,0,60,140,1,1,1,1),
(20192,20192,'Tyrant',0,'',0,'LineageMonster.grave','15','29',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,2138,126,'129.32896','136.72948','88.31491','91.0360303625432',253,4,0,333,0,0,0,70,174,1,1,1,1),
(20193,20193,'Tyrant Kingpin',0,'',0,'LineageMonster.grave','15','29',36,'male','L2Monster',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,2307,139,'137.86467','140.57278','94.1437','93.5949427192352',253,4,500,333,0,0,0,70,174,1,1,1,1),
(20194,20194,'Queen Undine',0,'',0,'LineageMonster.undine','12','27',50,'female','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,3709,280,'305.54906','200.23844','208.6504','133.321011603844',253,4,500,333,0,0,0,60,60,1,1,0,1),
(20197,20197,'Sorrow Maiden',0,'',0,'LineageMonster.sylph','11','35',27,'female','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,1323,67,'74.99121','108.28767','51.20928','72.0991544841329',253,4,0,333,0,0,0,60,60,1,1,1,1),
(20198,20198,'Neer Ghoul Berserker',0,'',0,'LineageMonster.neer_crawler','14','22',29,'male','L2Monster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,1522,82,'86.42002','115.00598','59.01367','76.5722740603874',253,4,500,333,0,0,0,50,90,1,1,1,1),
(20199,20199,'Amber Basilisk',0,'',0,'LineageMonster.lesser_basilisk','34','25',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,1869,102,'92.64226','118.46427','63.26266','78.8748547991048',253,4,0,333,0,0,0,35,131,1,1,1,1),
(20200,20200,'Strain',0,'',0,'LineageMonster.hungry_spirit','30','40',31,'male','L2Monster',40,'635.76437','343.8','4.5','1.8',40,43,30,21,20,20,1661,92,'99.21986','121.98819','67.7543','81.2211098160515',253,4,0,333,0,0,0,15,120,1,1,1,1),
(20201,20201,'Ghoul',0,'',0,'LineageMonster.zombie','13','21',32,'male','L2Monster',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,2502,140,'106.16525','125.57727','72.49711','83.6107570481808',253,4,0,333,0,0,0,15,15,1,1,1,1),
(20202,20202,'Dead Seeker',0,'',0,'LineageMonster.vampire_bat','10','33.5',34,'male','L2Monster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,1998,116,'121.20802','132.9486','82.76936','88.5186722618248',253,4,0,333,0,0,0,60,80,1,1,1,1),
(20203,20203,'Dion Grizzly',0,'',0,'LineageMonster.grizzly','21','40',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,706,31,'44.32863','86.87049','30.2707','57.8393570613084',253,4,0,333,0,0,0,40,110,1,1,1,1),
(20204,20204,'Bloody Bee',0,'',0,'LineageMonster.giant_bee','8','24.5',23,'male','L2Monster',40,'410.70422','231.96','3.5','1.5',40,43,30,21,20,20,1148,55,'55.84125','95.64976','38.13234','63.6846860642986',253,4,0,333,0,0,0,90,90,1,1,1,1),
(20205,20205,'Dire Wolf',0,'',0,'LineageMonster.dire_wolf','13','11',24,'male','L2Monster',40,'435.34437','245.52','3.5','1.5',40,43,30,21,20,20,1145,56,'60.19687','98.70919','41.10666','65.7216907961494',253,4,500,333,0,0,0,24,110,1,1,1,1),
(20206,20206,'Kadif Werewolf',0,'',0,'LineageMonster.werewolf','10','26',25,'male','L2Monster',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,1179,59,'64.83203','101.83533','44.27187','67.8031159084826',253,4,0,333,0,0,0,50,120,1,1,1,1),
(20207,20207,'Ol Mahum Guerilla',0,'',0,'LineageMonster.ol_mahum','13.5','25',26,'male','L2Monster',40,'487.5704','273','3.5','1.5',40,43,30,21,20,20,2359,119,'69.75926','105.02818','47.63653','69.9289432036824',253,4,0,333,2,19,0,50,110,1,1,1,1),
(20208,20208,'Ol Mahum Raider',0,'',0,'LineageMonster.ol_mahum','13.5','25',27,'male','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,2485,127,'74.99121','108.28767','51.20928','72.0991544841329',253,8,0,333,10,0,0,50,110,1,1,1,1),
(20209,20209,'Ol Mahum Marksman',0,'',0,'LineageMonster.ol_mahum_archer','14','25',28,'male','L2Monster',1100,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,2709,142,'80.54056','111.61368','54.99876','74.3136496629463',253,8,0,333,275,0,0,50,110,1,1,1,1),
(20210,20210,'Ol Mahum Sergeant',0,'',0,'LineageMonster.ol_mahum','13.5','25',29,'male','L2Monster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,2776,149,'86.42002','115.00598','59.01367','76.5722740603874',253,4,0,333,68,19,0,50,110,1,1,1,1),
(20211,20211,'Ol Mahum Captain',0,'',0,'LineageMonster.ol_mahum_champion','14','27',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,2980,163,'92.64226','118.46427','63.26266','78.8748547991048',253,4,500,333,123,19,0,50,110,1,1,1,1),
(20212,20212,'Bloody Axe Turmak',0,'Ol Mahum Lord',0,'LineageMonster.ol_mahum_champion','14','27',34,'male','L2Monster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,3528,206,'121.20802','132.9486','82.76936','88.5186722618248',253,4,500,333,69,19,0,50,110,1,1,0,1),
(20213,20213,'Porta',0,'',0,'LineageMonster.stone_golem','20','31',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,10438,647,'176.36077','156.55035','120.43155','114.55675',253,1,0,333,0,0,0,23,23,1,1,0,1),
(20214,20214,'Excuro',0,'',0,'LineageMonster.mana_vampire','11','20',41,'male','L2Monster',40,'1008.23781','504.8','5.5','2.1',40,43,30,21,20,20,6668,417,'187.11878','160.69002','127.77787','117.58598',253,4,0,333,0,0,0,90,90,1,1,0,1),
(20215,20215,'Mordeo',0,'',0,'LineageMonster.onyx_beast','14','14.5',42,'male','L2Monster',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,7709,493,'198.34591','164.88513','135.44454','120.65578',253,4,500,333,0,0,0,30,120,1,1,0,1),
(20216,20216,'Ricenseo',0,'',0,'LineageMonster.monster_eye','21','43',43,'male','L2Monster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,6864,442,'210.04832','169.13417','143.43577','123.76505',253,1,0,333,0,0,0,90,90,1,1,0,1),
(20217,20217,'Krator',0,'',0,'LineageMonster.stone_golem','20','31',44,'male','L2Monster',40,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,7997,523,'222.23112','173.43552','151.75505','126.91259',253,1,0,333,0,0,0,23,23,1,1,0,1),
(20218,20218,'Premo',0,'',0,'LineageMonster.troll','21','35',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,8303,552,'234.89829','177.78746','160.40508','130.09715',253,1,0,333,0,0,0,55,110,1,1,0,1),
(20219,20219,'Validus',0,'',0,'LineageMonster.grave','15','29',46,'male','L2Monster',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,20,9348,635,'248.0526','182.18816','169.38777','133.31739',253,4,0,333,0,0,0,70,110,1,1,0,1),
(20220,20220,'Dicor',0,'',0,'LineageMonster.mandragora_b','12','25.5',47,'female','L2Monster',40,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,9429,646,'261.69549','186.63569','178.7041','136.5719',253,4,500,333,0,0,0,80,120,1,1,0,1),
(20221,20221,'Perum',0,'',0,'LineageMonster.iron_golem','18','34',48,'male','L2Monster',40,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,13708,955,'275.82705','191.12803','188.35412','139.8592',253,1,500,333,0,0,0,20,20,1,1,0,1),
(20222,20222,'Torfe',0,'',0,'LineageMonster.grave','15','29',49,'male','L2Monster',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,10330,730,'290.44588','195.66302','198.33688','143.17771',253,4,0,333,0,0,0,70,110,1,1,0,1),
(20223,20223,'Mandragora Sprout',0,'',0,'LineageMonster.manadragora','14','17.8',20,'female','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,784,35,'44.32863','86.87049','30.2707','57.8393570613084',253,4,0,333,0,0,0,80,80,1,1,1,1),
(20224,20224,'Ol Mahum Ranger',0,'',0,'LineageMonster.ol_mahum_archer','14','25',22,'male','L2Monster',1100,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,1271,60,'51.75278','92.65694','35.34044','61.6920289224665',253,8,0,333,13,0,0,50,110,1,1,1,1),
(20225,20225,'Giant Mist Leech',0,'',0,'LineageMonster.giant_leech','70','29',25,'male','L2Monster',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,1191,60,'64.83203','101.83533','44.27187','67.8031159084826',253,4,0,333,0,0,0,50,110,1,1,1,1),
(20226,20226,'Gray Ant',0,'',0,'LineageMonster.ant','26','15',26,'male','L2Monster',40,'487.5704','273','3.5','1.5',40,43,30,21,20,20,1268,64,'69.75926','105.02818','47.63653','69.9289432036824',253,4,0,333,0,0,0,40,130,1,1,1,1),
(20227,20227,'Horror Mist Ripper',0,'',0,'LineageMonster.dark_horror','20','35',27,'male','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,1349,70,'74.99121','108.28767','51.20928','72.0991544841329',253,4,500,333,0,0,0,100,100,1,1,1,1),
(20228,20228,'Giant Crimson Ant',0,'',0,'LineageMonster.ant_soldier','35','17',28,'male','L2Monster',40,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,1555,82,'80.54056','111.61368','54.99876','74.3136496629463',253,4,0,333,0,0,0,80,130,1,1,1,1),
(20229,20229,'Stinger Wasp',0,'',0,'LineageMonster.giant_bee','8','24.5',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,1745,95,'92.64226','118.46427','63.26266','78.8748547991048',253,4,500,333,0,0,0,90,90,1,1,1,1),
(20230,20230,'Marsh Stakato Worker',0,'',0,'LineageMonster.marsh_stakato_worker','9','21',31,'male','L2Monster',40,'635.76437','343.8','4.5','1.8',40,43,30,21,20,20,1996,110,'99.21986','121.98819','67.7543','81.2211098160515',253,1,0,333,153,0,0,20,140,1,1,1,1),
(20231,20231,'Toad Lord',0,'',0,'LineageMonster.poison_toad','20','10',32,'male','L2Monster',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,1946,109,'106.16525','125.57727','72.49711','83.6107570481808',253,4,0,333,0,0,0,50,100,1,1,1,1),
(20232,20232,'Marsh Stakato Soldier',0,'',0,'LineageMonster.marsh_stakato_soldier','10','25',33,'male','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,1901,109,'113.49065','129.23095','77.49941','86.043423444366',253,8,0,333,217,0,0,30,155,1,1,1,1),
(20233,20233,'Marsh Spider',0,'',0,'LineageMonster.poison_spider','27','25.5',34,'male','L2Monster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,2241,131,'121.20802','132.9486','82.76936','88.5186722618248',253,4,500,333,0,0,0,60,140,1,1,1,1),
(20234,20234,'Marsh Stakato Drone',0,'',0,'LineageMonster.marsh_stakato_drone','9','24',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,2268,134,'129.32896','136.72948','88.31491','91.0360303625432',253,8,500,333,219,0,0,80,174,1,1,1,1),
(20235,20235,'Shackle',0,'',0,'LineageMonster.hungry_spirit','30','40',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,3569,248,'234.89829','177.78746','160.40508','118.372898457316',253,4,500,333,0,0,0,15,174,1,1,0,1),
(20236,20236,'Cave Servant',0,'',0,'LineageMonster.skeleton','11','25',46,'male','L2Monster',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,20,3693,262,'248.0526','182.18816','169.38777','121.302932993263',253,4,0,333,79,945,0,60,174,1,1,0,1),
(20237,20237,'Cave Servant Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',47,'male','L2Monster',1100,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,4972,356,'261.69549','186.63569','178.7041','124.264149144103',253,8,0,333,14,0,0,40,174,1,1,0,1),
(20238,20238,'Cave Servant Warrior',0,'',0,'LineageMonster.skeleton','11','25',48,'male','L2Monster',40,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,4785,349,'275.82705','191.12803','188.35412','127.255200286259',253,4,0,333,77,2495,0,60,174,1,1,0,1),
(20239,20239,'Cave Servant Captain',0,'',0,'LineageMonster.spartoi','11','27',49,'male','L2Monster',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,5086,376,'290.44588','195.66302','198.33688','130.274648808072',253,4,500,333,73,2495,0,60,174,1,1,0,1),
(20240,20240,'Royal Cave Servant',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',51,'male','L2Monster',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,20,5455,416,'321.13207','204.85194','219.29157','136.392732777413',253,8,0,333,946,945,0,80,174,1,1,0,1),
(20241,20241,'Hunter Gargoyle',0,'',0,'LineageMonster.hunter_gargoyle','25','65',52,'male','L2Monster',40,'1520.38155','804','6.5','2.4',40,43,30,21,20,20,5420,419,'337.18867','209.50106','230.25615','153.30378',253,4,0,333,0,0,0,100,100,1,1,1,1),
(20242,20242,'Dustwind Gargoyle',0,'',0,'LineageMonster.hunter_gargoyle','25','65',53,'male','L2Monster',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,5776,454,'353.71092','214.18326','241.5387','142.605626325743',253,4,0,333,0,0,0,100,174,1,1,0,1),
(20243,20243,'Thunder Wyrm',0,'',0,'LineageMonster.wyrm','29','72',54,'male','L2Monster',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,5140,409,'370.68904','218.89589','253.13256','145.743350252286',253,4,500,333,0,0,0,70,174,1,1,0,1),
(20244,20244,'Malruk Succubus',0,'',0,'LineageMonster.succubus','10','36',55,'female','L2Monster',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,5279,426,'388.11142','223.6362','265.02979','148.899508363765',253,4,0,333,0,0,0,60,174,1,1,0,1),
(20245,20245,'Malruk Succubus Turen',0,'',0,'LineageMonster.succubus','10','36',56,'female','L2Monster',40,'1724.6831','918.8','6.5','2.4',40,43,30,21,20,20,5473,450,'405.96455','228.40135','277.22116','152.072199009316',253,4,0,333,0,0,0,60,174,1,1,0,1),
(20246,20246,'Cave Keeper',0,'',0,'LineageMonster.serpent_slave','17','46',58,'male','L2Monster',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,20,6987,590,'442.8992','237.99429','302.44274','158.459289236126',253,8,0,333,223,0,0,70,174,1,1,0,1),
(20248,20248,'Turak Bugbear',0,'',0,'LineageMonster.bugbear','17','35',31,'male','L2Monster',40,'635.76437','343.8','4.5','1.8',40,43,30,21,20,20,1677,94,'99.21986','121.98819','67.7543','81.2211098160515',253,1,0,333,88,0,0,55,130,1,1,1,1),
(20249,20249,'Turak Bugbear Warrior',0,'',0,'LineageMonster.bugbear','17','35',33,'male','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,3606,206,'113.49065','129.23095','77.49941','86.043423444366',253,4,500,333,73,0,0,55,130,1,1,1,1),
(20250,20250,'Glass Jaguar',0,'',0,'LineageMonster.onyx_beast','14','14.5',27,'male','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,1323,67,'74.99121','108.28767','51.20928','72.0991544841329',253,4,0,333,0,0,0,30,120,1,1,1,1),
(20251,20251,'Delu Lizardman',0,'',0,'LineageMonster.virud_lizardman','10','23',28,'male','L2Monster',40,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,1400,73,'80.54056','111.61368','54.99876','74.3136496629463',253,4,0,333,1,19,0,43,130,1,1,1,1),
(20252,20252,'Delu Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman','10','23',29,'male','L2Monster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,1477,79,'86.42002','115.00598','59.01367','76.5722740603874',253,4,0,333,123,0,0,43,130,1,1,1,1),
(20253,20253,'Delu Lizardman Warrior',0,'',0,'LineageMonster.virud_lizardman_warrior','12','30',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,1586,86,'92.64226','118.46427','63.26266','78.8748547991048',253,4,500,333,16,0,0,52,130,1,1,1,1),
(20254,20254,'Skeleton Axeman',0,'',0,'LineageMonster.skeleton','11','25',28,'male','L2Monster',40,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,1442,76,'80.54056','111.61368','54.99876','74.3136496629463',253,1,500,333,86,0,0,60,140,1,1,1,1),
(20255,20255,'Batur Orc',0,'',0,'LineageMonster.batur_orc','9','21.5',31,'male','L2Monster',40,'635.76437','343.8','4.5','1.8',40,43,30,21,20,20,1398,78,'99.21986','121.98819','67.7543','81.2211098160515',253,4,0,333,123,0,0,80,130,1,1,0,1),
(20256,20256,'Batur Orc Archer',0,'',0,'LineageMonster.batur_orc_archer','11','21.5',32,'male','L2Monster',1100,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,1921,108,'106.16525','125.57727','72.49711','83.6107570481808',253,8,0,333,13,0,0,45,130,1,1,0,1),
(20257,20257,'Batur Orc Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10','20',33,'male','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,1922,110,'113.49065','129.23095','77.49941','86.043423444366',253,4,500,333,123,19,0,80,120,1,1,0,1),
(20258,20258,'Batur Orc Shaman',0,'',0,'LineageMonster.batur_orc_shaman','11','16',34,'male','L2Monster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,1681,98,'121.20802','132.9486','82.76936','88.5186722618248',253,1,0,333,7,0,0,50,120,1,1,0,1),
(20259,20259,'Batur Orc Overlord',0,'',0,'LineageMonster.batur_orc_overlord','12','24',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,2163,128,'129.32896','136.72948','88.31491','91.0360303625432',253,4,500,333,79,0,0,80,140,1,1,0,1),
(20260,20260,'Orc Champion',0,'',0,'LineageMonster.orc_champion','10','23',14,'male','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,435,17,'27.24646','71.08179','18.6058','47.3270583783809',253,4,500,333,2,0,0,45,130,1,1,0,1),
(20261,20261,'Orc Shaman',0,'',0,'LineageMonster.orc_shaman','9','22',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,505,21,'34.8979','78.68469','23.83074','52.3891528929827',253,1,0,333,7,0,0,45,120,1,1,0,1),
(20265,20265,'Monster Eye Searcher',0,'',0,'LineageMonster.monster_eye','21','43',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,1833,86,'51.75278','92.65694','35.34044','61.6920289224665',253,1,0,333,0,0,0,90,159,1,1,1,1),
(20266,20266,'Monster Eye Gazer',0,'',0,'LineageMonster.monster_eye','21','43',25,'male','L2Monster',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,1191,60,'64.83203','101.83533','44.27187','67.8031159084826',253,4,0,333,0,0,0,90,159,1,1,1,1),
(20267,20267,'Breka Orc',0,'',0,'LineageMonster.batur_orc','9','21.5',31,'male','L2Monster',40,'635.76437','343.8','4.5','1.8',40,43,30,21,20,20,1677,94,'99.21986','121.98819','67.7543','81.2211098160515',253,8,0,333,215,0,0,80,130,1,1,1,1),
(20268,20268,'Breka Orc Archer',0,'',0,'LineageMonster.batur_orc_archer','11','21.5',32,'male','L2Monster',1100,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,2305,130,'106.16525','125.57727','72.49711','83.6107570481808',253,8,0,333,275,0,0,45,130,1,1,1,1),
(20269,20269,'Breka Orc Shaman',0,'',0,'LineageMonster.batur_orc_shaman','11','16',34,'male','L2Monster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,2018,118,'121.20802','132.9486','82.76936','88.5186722618248',253,1,0,333,7,0,0,50,120,1,1,1,1),
(20270,20270,'Breka Orc Overlord',0,'',0,'LineageMonster.batur_orc_overlord','12','24',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,2857,169,'129.32896','136.72948','88.31491','91.0360303625432',253,4,500,333,79,0,0,80,174,1,1,1,1),
(20271,20271,'Breka Orc Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10','20',33,'male','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,2307,132,'113.49065','129.23095','77.49941','86.043423444366',253,4,500,333,123,20,0,80,120,1,1,1,1),
(20272,20272,'Cave Servant',0,'',0,'LineageMonster.skeleton','11','25',46,'male','L2Monster',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,20,3078,218,'248.0526','182.18816','169.38777','121.302932993263',253,4,0,333,79,945,0,60,140,1,1,0,1),
(20273,20273,'Cave Servant Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',47,'male','L2Monster',1100,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,3309,238,'261.69549','186.63569','178.7041','124.264149144103',253,8,0,333,275,0,0,40,140,1,1,0,1),
(20274,20274,'Cave Servant Warrior',0,'',0,'LineageMonster.skeleton','11','25',48,'male','L2Monster',40,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,3351,245,'275.82705','191.12803','188.35412','127.255200286259',253,4,0,333,77,0,0,60,140,1,1,0,1),
(20275,20275,'Cave Servant Captain',0,'',0,'LineageMonster.spartoi','11','27',49,'male','L2Monster',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,3562,263,'290.44588','195.66302','198.33688','130.274648808072',253,4,500,333,73,0,0,60,140,1,1,0,1),
(20276,20276,'Royal Cave Servant',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',51,'male','L2Monster',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,20,3783,288,'321.13207','204.85194','219.29157','136.392732777413',253,8,0,333,946,945,0,80,120,1,1,0,1),
(20277,20277,'Cave Keeper',0,'',0,'LineageMonster.serpent_slave','17','46',58,'male','L2Monster',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,20,4893,413,'442.8992','237.99429','302.44274','158.459289236126',253,8,0,333,223,0,0,70,110,1,1,0,1),
(20279,20279,'Shackle',0,'',0,'LineageMonster.hungry_spirit','30','40',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,2974,206,'234.89829','177.78746','160.40508','118.372898457316',253,4,500,333,0,0,0,15,120,1,1,0,1),
(20280,20280,'Headless Knight',0,'',0,'LineageMonster.headless_knight','21','31',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,3709,280,'305.54906','200.23844','208.6504','133.321011603844',253,4,500,333,124,0,0,70,110,1,1,0,1),
(20281,20281,'Dustwind Gargoyle',0,'',0,'LineageMonster.hunter_gargoyle','25','65',53,'male','L2Monster',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,4045,318,'353.71092','214.18326','241.5387','142.605626325743',253,4,0,333,0,0,0,100,100,1,1,0,1),
(20282,20282,'Thunder Wyrm',0,'',0,'LineageMonster.wyrm','29','72',54,'male','L2Monster',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,4283,342,'370.68904','218.89589','253.13256','145.743350252286',253,4,500,333,0,0,0,70,70,1,1,0,1),
(20283,20283,'Malruk Succubus',0,'',0,'LineageMonster.succubus','10','36',55,'female','L2Monster',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,4400,355,'388.11142','223.6362','265.02979','148.899508363765',253,4,0,333,0,0,0,60,100,1,1,0,1),
(20284,20284,'Malruk Succubus Turen',0,'',0,'LineageMonster.succubus','10','36',56,'female','L2Monster',40,'1724.6831','918.8','6.5','2.4',40,43,30,21,20,20,4561,374,'405.96455','228.40135','277.22116','152.072199009316',253,4,0,333,0,0,0,60,100,1,1,0,1),
(20285,20285,'Drake',0,'',0,'LineageMonster.drake','30','100',57,'male','L2Monster',40,'1776.58018','948','6.5','2.4',40,43,30,21,20,20,4820,401,'424.23295','233.18839','289.69611','155.259456846417',253,4,500,333,0,0,0,70,70,1,1,0,1),
(20286,20286,'Hunter Gargoyle',0,'',0,'LineageMonster.hunter_gargoyle','25','65',52,'male','L2Monster',40,'1520.38155','804','6.5','2.4',40,43,30,21,20,20,3894,301,'337.18867','209.50106','230.25615','139.488165444537',253,4,0,333,0,0,0,100,100,1,1,0,1),
(20287,20287,'Cave Maiden',0,'',0,'LineageMonster.cave_maiden','25','65',59,'female','L2Monster',40,'1880.92519','1007','6.5','2.4',40,43,30,21,20,20,5113,437,'461.94387','242.81593','315.44778','161.669585254993',253,4,500,333,68,0,0,70,120,1,1,0,1),
(20291,20291,'Enku Orc Champion',0,'',0,'LineageMonster.orc_champion','10','23',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,1113,52,'47.91924','89.73059','32.72263','59.7436374813816',253,4,500,333,2,0,0,45,130,1,1,1,1),
(20292,20292,'Enku Orc Shaman',0,'',0,'LineageMonster.orc_shaman','9','22',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,813,36,'44.32863','86.87049','30.2707','57.8393570613084',253,1,0,333,7,0,0,45,120,1,1,1,1),
(20293,20293,'Virud Lizardman',0,'',0,'LineageMonster.virud_lizardman','10','23',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,594,26,'44.32863','86.87049','30.2707','57.8393570613084',253,4,0,333,291,0,0,43,130,1,1,0,1),
(20294,20294,'Virud Lizardman Matriarch',0,'',0,'LineageMonster.virud_lizardman_matriarch','13','37',24,'male','L2Monster',40,'435.34437','245.52','3.5','1.5',40,43,30,21,20,20,1142,56,'60.19687','98.70919','41.10666','65.7216907961494',253,4,500,333,2,19,0,56,130,1,1,0,1),
(20295,20295,'Virud Lizardman Warrior',0,'',0,'LineageMonster.virud_lizardman_warrior','12','30',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,838,40,'51.75278','92.65694','35.34044','61.6920289224665',253,4,500,333,16,0,0,52,130,1,1,0,1),
(20296,20296,'Virud Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman_scout','10','22',21,'male','L2Monster',1100,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,787,36,'47.91924','89.73059','32.72263','59.7436374813816',253,8,0,333,2507,0,0,43,130,1,1,0,1),
(20297,20297,'Virud Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman','10','29',23,'male','L2Monster',40,'410.70422','231.96','3.5','1.5',40,43,30,21,20,20,878,42,'55.84125','95.64976','38.13234','63.6846860642986',253,1,0,333,7,0,0,43,120,1,1,0,1),
(20298,20298,'Virud Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman','10','29',23,'male','L2Monster',40,'410.70422','231.96','3.5','1.5',40,43,30,21,20,20,878,42,'55.84125','95.64976','38.13234','63.6846860642986',253,1,0,333,7,0,0,43,120,1,1,0,1),
(20299,20299,'Zenta Lizardman',0,'',0,'LineageMonster.zenta_lizardman','11','32',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,2327,150,'176.36077','156.55035','120.43155','104.232986928232',253,4,0,333,68,0,0,37,140,1,1,0,1),
(20300,20300,'Zenta Lizardman Matriarch',0,'',0,'LineageMonster.zenta_lizardman_matriarch','20','40',44,'male','L2Monster',40,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,3418,234,'222.23112','173.43552','151.75505','115.475328468187',253,8,500,333,221,0,0,53,140,1,1,0,1),
(20301,20301,'Zenta Lizardman Scout',0,'',0,'LineageMonster.zenta_lizardman_scout','11','30',41,'male','L2Monster',1100,'1008.23781','504.8','5.5','2.1',40,43,30,21,20,20,2518,164,'187.11878','160.69002','127.77787','106.989225133249',253,8,0,333,14,0,0,37,150,1,1,0,1),
(20302,20302,'Zenta Lizardman Warrior',0,'',0,'LineageMonster.zenta_lizardman_warrior','13','35',42,'male','L2Monster',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,2617,174,'198.34591','164.88513','135.44454','109.782377202178',253,4,500,333,16,0,0,40,140,1,1,0,1),
(20303,20303,'Zenta Lizardman Shaman',0,'',0,'LineageMonster.zenta_lizardman_shaman','13','35',43,'male','L2Monster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,2689,182,'210.04832','169.13417','143.43577','112.611442266143',253,1,0,333,7,0,0,43,130,1,1,0,1),
(20304,20304,'Marsh Stakato Queen',0,'',0,'LineageMonster.marsh_stakato_queen','15','37',36,'female','L2Monster',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,2288,138,'137.86467','140.57278','94.1437','93.5949427192352',253,4,500,333,74,0,0,130,130,1,1,0,1),
(20305,20305,'Grave',0,'',0,'LineageMonster.grave','15','29',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,2350,151,'176.36077','156.55035','120.43155','104.232986928232',253,4,500,333,0,0,0,70,110,1,1,0,1),
(20307,20307,'Garum Werewolf',0,'',0,'LineageMonster.werewolf','10','26',9,'male','L2Monster',40,'143.17564','100.48','2','0.9',40,43,30,21,20,20,321,11,'17.70841','59.66387','12.09255','39.7248769407655',253,1,0,333,5,0,0,50,120,1,1,1,1),
(20308,20308,'Hook Spider',0,'',0,'LineageMonster.giant_spider','26','25.5',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,571,23,'32.16396','76.08628','21.96382','50.6590964478128',253,4,0,333,0,0,0,72,130,1,1,1,1),
(20309,20309,'Brown Fox',0,'',0,'LineageMonster.fox','9.5','10',2,'male','L2Monster',40,'48.09168','47.28','2','0.9',40,43,30,21,20,20,59,2,'9.32203','46.15385','6.36574','30.7297498930634',253,4,0,333,0,0,0,23,110,1,1,0,1),
(20310,20310,'Brown Bear',0,'',0,'LineageMonster.grizzly_bi','21','50',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,577,23,'32.16396','76.08628','21.96382','50.6590964478128',253,4,500,333,0,0,0,40,110,1,1,1,1),
(20311,20311,'Rakeclaw Imp',0,'',0,'LineageMonster.imp','10','24',6,'male','L2Monster',40,'93.54158','77.2','2','0.9',40,43,30,21,20,20,214,6,'13.52471','53.53373','9.23562','35.6433609604933',253,4,0,333,0,0,0,60,80,1,1,1,1),
(20312,20312,'Rakeclaw Imp Hunter',0,'',0,'LineageMonster.imp','10','24',7,'male','L2Monster',40,'108.42254','84.88','2','0.9',40,43,30,21,20,20,249,8,'14.80956','55.51894','10.11301','36.965135694682',253,4,0,333,0,0,0,60,80,1,1,1,1),
(20313,20313,'Rakeclaw Imp Chieftain',0,'',0,'LineageMonster.imp_bi','10','30',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,363,12,'19.33758','61.82527','13.20506','41.16396260604',253,4,500,333,0,0,0,60,80,1,1,1,1),
(20314,20314,'Great White Shark',0,'',0,'LineageMonster.great_white_shark','20','7',42,'male','L2Monster',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,2617,174,'198.34591','164.88513','135.44454','109.782377202178',253,4,500,333,0,0,0,80,174,1,1,0,1),
(20316,20316,'Darkwing Bat',0,'',0,'LineageMonster.vampire_bat','10','33.5',11,'male','L2Monster',40,'185.38552','116.4','2.5','1.2',40,43,30,21,20,20,392,15,'21.0973','64.04702','14.40672','42.6432286072855',253,4,0,333,0,0,0,60,80,1,1,1,1),
(20317,20317,'Black Wolf',0,'',0,'LineageMonster.wolf','13','9',4,'male','L2Monster',40,'68.20985','62.08','2','0.9',40,43,30,21,20,20,141,4,'11.24892','49.73343','7.68155','33.1130825524654',253,4,0,333,0,0,0,24,110,1,1,1,1),
(20318,20318,'Black Timber Wolf',0,'',0,'LineageMonster.wolf_bi','13','10.8',6,'male','L2Monster',40,'93.54158','77.2','2','0.9',40,43,30,21,20,20,212,6,'13.52471','53.53373','9.23562','35.6433609604933',253,4,0,333,0,0,0,24,110,1,1,1,1),
(20319,20319,'Goblin Grave Robber',0,'',0,'LineageMonster.goblin','10','16.5',5,'male','L2Monster',40,'80.17319','69.6','2','0.9',40,43,30,21,20,20,178,5,'12.34006','51.60553','8.42666','34.3595464531323',253,1,0,333,4,0,0,40,110,1,1,1,1),
(20320,20320,'Goblin Tomb Raider Leader',0,'',0,'LineageMonster.goblin_bi','10','21.4',12,'male','L2Monster',40,'199.62322','124.48','2.5','1.2',40,43,30,21,20,20,428,16,'22.99606','66.32989','15.70333','44.163184477748',253,8,0,333,12,0,0,40,110,1,1,1,1),
(20321,20321,'Goblin Thief',0,'',0,'LineageMonster.goblin_bi','10','21.4',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,356,12,'19.33758','61.82527','13.20506','41.16396260604',253,8,0,333,217,0,0,40,110,1,1,1,1),
(20322,20322,'Goblin Brigand',0,'',0,'LineageMonster.goblin','10','16.5',8,'male','L2Monster',40,'124.92828','92.64','2','0.9',40,43,30,21,20,20,285,10,'16.20165','57.56203','11.06363','38.3254529794081',253,1,0,333,4,0,0,40,110,1,1,1,1),
(20323,20323,'Goblin Brigand Leader',0,'',0,'LineageMonster.goblin_bi','10','21.4',14,'male','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,509,20,'27.24646','71.08179','18.6058','47.3270583783809',253,8,500,333,217,0,0,40,110,1,1,1,1),
(20324,20324,'Goblin Brigand Lieutenant',0,'',0,'LineageMonster.goblin','10','16.5',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,363,12,'19.33758','61.82527','13.20506','41.16396260604',253,8,500,333,10,0,0,40,110,1,1,1,1),
(20325,20325,'Goblin Raider',0,'',0,'LineageMonster.goblin','10','16.5',5,'male','L2Monster',40,'80.17319','69.6','2','0.9',40,43,30,21,20,20,178,5,'12.34006','51.60553','8.42666','34.3595464531323',253,1,0,333,4,0,0,40,110,1,1,1,1),
(20326,20326,'Goblin Scout',0,'',0,'LineageMonster.goblin','10','16.5',8,'male','L2Monster',40,'124.92828','92.64','2','0.9',40,43,30,21,20,20,285,10,'16.20165','57.56203','11.06363','38.3254529794081',253,1,0,333,4,0,0,40,110,1,1,1,1),
(20327,20327,'Goblin Snooper',0,'',0,'LineageMonster.goblin','10','16.5',5,'male','L2Monster',40,'80.17319','69.6','2','0.9',40,43,30,21,20,20,178,5,'12.34006','51.60553','8.42666','34.3595464531323',253,1,0,333,4,0,0,40,110,1,1,1,1),
(20328,20328,'Goblin Lookout',0,'',0,'LineageMonster.goblin','10','16.5',8,'male','L2Monster',40,'124.92828','92.64','2','0.9',40,43,30,21,20,20,285,10,'16.20165','57.56203','11.06363','38.3254529794081',253,8,0,333,12,0,0,40,110,1,1,1,1),
(20329,20329,'Ghost Guardian',0,'',0,'LineageMonster.human_ghost','8','22',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,772,36,'47.91924','89.73059','32.72263','59.7436374813816',253,4,500,333,0,0,0,80,140,1,1,0,1),
(20330,20330,'Mineshaft Bat',0,'',0,'LineageMonster.vampire_bat','10','33.5',11,'male','L2Monster',40,'185.38552','116.4','2.5','1.2',40,43,30,21,20,20,326,12,'21.0973','64.04702','14.40672','42.6432286072855',253,4,0,333,0,0,0,60,80,1,1,0,1),
(20331,20331,'Monster Eye Tracker',0,'',0,'LineageMonster.monster_eye','21','43',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,297,10,'19.33758','61.82527','13.20506','41.16396260604',253,4,0,333,0,0,0,90,134,1,1,0,1),
(20333,20333,'Greystone Golem',0,'',0,'LineageMonster.stone_golem','20','31',13,'male','L2Monster',40,'214.61578','132.64','2.5','1.2',40,43,30,21,20,20,655,26,'25.04271','68.67458','17.10092','45.7243124542497',253,4,0,333,0,0,0,23,23,1,1,1,1),
(20334,20334,'Gremlin Scavenger',0,'',0,'LineageMonster.gremlin','10','15',1,'male','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,29,2,'8.47458','44.44444','5.78704','29.5916164000214',253,4,0,333,0,0,0,20,50,1,1,0,1),
(20335,20335,'Grizzly Bear',0,'',0,'LineageMonster.grizzly_bi','21','50',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,600,25,'34.8979','78.68469','23.83074','52.3891528929827',253,4,0,333,0,0,0,40,110,1,1,1,1),
(20336,20336,'Green Dryad',0,'',0,'LineageMonster.dryad_sm','6','15',8,'female','L2Monster',40,'124.92828','92.64','2','0.9',40,43,30,21,20,20,285,10,'16.20165','57.56203','11.06363','38.3254529794081',253,4,0,333,0,0,0,40,110,1,1,1,1),
(20337,20337,'Longtail Fox',0,'',0,'LineageMonster.fox','9.5','10',2,'male','L2Monster',40,'48.09168','47.28','2','0.9',40,43,30,21,20,20,59,2,'9.32203','46.15385','6.36574','30.7297498930634',253,4,0,333,0,0,0,23,110,1,1,0,1),
(20338,20338,'Nightmare Weaver',0,'',0,'LineageMonster.magical_weaver','11','20',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,849,40,'47.91924','89.73059','32.72263','59.7436374813816',253,4,500,333,0,0,0,90,90,1,1,0,1),
(20340,20340,'Slave Skeleton',0,'',0,'LineageMonster.skeleton','11','25',12,'male','L2Monster',40,'199.62322','124.48','2.5','1.2',40,43,30,21,20,20,363,13,'22.99606','66.32989','15.70333','44.163184477748',253,8,500,333,946,0,0,60,140,1,1,0,1),
(20341,20341,'Undead Slave',0,'',0,'LineageMonster.zombie','13','21',19,'male','L2Monster',40,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,799,36,'40.96915','84.07638','27.97662','55.9790056860875',253,4,0,333,0,0,0,15,15,1,1,0,1),
(20342,20342,'Werewolf Chieftain',0,'',0,'LineageMonster.werewolf_bi','11','29.7',12,'male','L2Monster',40,'199.62322','124.48','2.5','1.2',40,43,30,21,20,20,436,16,'22.99606','66.32989','15.70333','44.163184477748',253,1,500,333,5,0,0,50,120,1,1,1,1),
(20343,20343,'Werewolf Hunter',0,'',0,'LineageMonster.werewolf','10','26',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,363,12,'19.33758','61.82527','13.20506','41.16396260604',253,1,500,333,5,0,0,50,120,1,1,1,1),
(20345,20345,'Dark Terror',0,'',0,'LineageMonster.dark_horror','20','35',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,534,22,'32.16396','76.08628','21.96382','50.6590964478128',253,4,500,333,0,0,0,100,100,1,1,0,1),
(20346,20346,'Darkstone Golem',0,'',0,'LineageMonster.stone_golem','20','31',13,'male','L2Monster',40,'214.61578','132.64','2.5','1.2',40,43,30,21,20,20,545,21,'25.04271','68.67458','17.10092','45.7243124542497',253,4,0,333,0,0,0,23,23,1,1,0,1),
(20347,20347,'Doom Wraith',0,'',0,'LineageMonster.death_blader','15','45',55,'male','L2Monster',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,4488,362,'388.11142','223.6362','265.02979','148.899508363765',253,4,500,333,1472,0,0,100,174,1,1,0,1),
(20348,20348,'Cave Spider',0,'',0,'LineageMonster.giant_spider','26','25.5',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,445,18,'29.61691','73.55216','20.22451','48.9718589929237',253,4,0,333,0,0,0,72,130,1,1,0,1),
(20349,20349,'Cave Bat',0,'',0,'LineageMonster.vampire_bat','10','33.5',13,'male','L2Monster',40,'214.61578','132.64','2.5','1.2',40,43,30,21,20,20,386,15,'25.04271','68.67458','17.10092','45.7243124542497',253,4,0,333,0,0,0,60,80,1,1,0,1),
(20350,20350,'Cave Fang Spider',0,'',0,'LineageMonster.giant_spider','26','25.5',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,485,20,'32.16396','76.08628','21.96382','50.6590964478128',253,4,500,333,0,0,0,72,130,1,1,0,1),
(20351,20351,'Dre Vanul Tracker',0,'',0,'LineageMonster.dre_vanul','14','36',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,606,27,'44.32863','86.87049','30.2707','57.8393570613084',253,4,500,333,0,0,0,80,80,1,1,0,1),
(20352,20352,'Dre Vanul Slayer',0,'',0,'LineageMonster.dre_vanul','14','36',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,921,43,'51.75278','92.65694','35.34044','61.6920289224665',253,4,500,333,0,0,0,80,80,1,1,0,1),
(20353,20353,'Dre Vanul Beholder',0,'',0,'LineageMonster.dre_vanul','14','36',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,780,36,'47.91924','89.73059','32.72263','59.7436374813816',253,4,500,333,0,0,0,80,80,1,1,0,1),
(20354,20354,'Dwarf Ghost',0,'',0,'LineageMonster.dwarf_ghost','9','16.5',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,606,27,'44.32863','86.87049','30.2707','57.8393570613084',253,4,500,333,0,0,0,80,140,1,1,0,1),
(20356,20356,'Langk Lizardman Leader',0,'',0,'LineageMonster.virud_lizardman_warrior_bi','12','34.5',25,'male','L2Monster',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,1215,61,'64.83203','101.83533','44.27187','67.8031159084826',253,4,500,333,16,0,0,52,130,1,1,1,1),
(20357,20357,'Langk Lizardman Lieutenant',0,'',0,'LineageMonster.virud_lizardman_warrior','12','30',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,986,47,'51.75278','92.65694','35.34044','61.6920289224665',253,4,0,333,16,0,0,52,130,1,1,1,1),
(20358,20358,'Ratman Hunter',0,'',0,'LineageMonster.wererat','14','25',18,'male','L2Monster',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,640,28,'37.82932','81.34791','25.83252','54.1623558855199',253,8,0,333,11,0,0,80,120,1,1,1,1),
(20359,20359,'Ratman Warrior',0,'',0,'LineageMonster.wererat','14','25',19,'male','L2Monster',40,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,678,30,'40.96915','84.07638','27.97662','55.9790056860875',253,4,0,333,2,0,0,80,120,1,1,1,1),
(20360,20360,'Ratman Spy',0,'',0,'LineageMonster.wererat_sm','12','18.7',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,571,23,'32.16396','76.08628','21.96382','50.6590964478128',253,8,0,333,12,0,0,80,120,1,1,1,1),
(20361,20361,'Tunath Orc Marksman',0,'',0,'LineageMonster.orc_archer','14','25',10,'male','L2Monster',1100,'163.28607','108.4','2','0.9',40,43,30,21,20,20,306,10,'19.33758','61.82527','13.20506','41.16396260604',253,8,0,333,14,0,0,45,110,1,1,0,1),
(20362,20362,'Tunath Orc Warrior',0,'',0,'LineageMonster.orc_fighter','12','22',12,'male','L2Monster',40,'199.62322','124.48','2.5','1.2',40,43,30,21,20,20,363,13,'22.99606','66.32989','15.70333','44.163184477748',253,4,500,333,2,0,0,45,110,1,1,0,1),
(20363,20363,'Maraku Werewolf',0,'',0,'LineageMonster.werewolf','10','26',9,'male','L2Monster',40,'143.17564','100.48','2','0.9',40,43,30,21,20,20,321,11,'17.70841','59.66387','12.09255','39.7248769407655',253,4,0,333,0,0,0,50,120,1,1,1,1),
(20364,20364,'Maraku Werewolf Chieftain',0,'',0,'LineageMonster.werewolf_bi','11','29.7',14,'male','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,509,20,'27.24646','71.08179','18.6058','47.3270583783809',253,8,500,333,217,0,0,50,120,1,1,1,1),
(20365,20365,'Mountain Fungus',0,'',0,'LineageMonster.walking_fungus','15','22.5',8,'male','L2Monster',40,'124.92828','92.64','2','0.9',40,43,30,21,20,20,285,10,'16.20165','57.56203','11.06363','38.3254529794081',253,4,0,333,0,0,0,70,110,1,1,1,1),
(20367,20367,'Merkenis Escort',0,'',0,'LineageMonster.spartoi','11','27',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,606,27,'44.32863','86.87049','30.2707','57.8393570613084',253,4,0,333,68,0,0,60,140,1,1,0,1),
(20368,20368,'Grave Keeper',0,'',0,'LineageMonster.stone_golem','20','31',13,'male','L2Monster',40,'214.61578','132.64','2.5','1.2',40,43,30,21,20,20,545,21,'25.04271','68.67458','17.10092','45.7243124542497',253,4,0,333,0,0,0,23,23,1,1,0,1),
(20369,20369,'Moonstone Beast',0,'',0,'LineageMonster.onyx_beast','14','14.5',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,600,25,'34.8979','78.68469','23.83074','52.3891528929827',253,4,0,333,0,0,0,30,120,1,1,1,1),
(20370,20370,'Barbed Bat',0,'',0,'LineageMonster.vampire_bat','10','33.5',12,'male','L2Monster',40,'199.62322','124.48','2.5','1.2',40,43,30,21,20,20,428,16,'22.99606','66.32989','15.70333','44.163184477748',253,4,0,333,0,0,0,60,80,1,1,1,1),
(20371,20371,'Mist Terror',0,'',0,'LineageMonster.dark_horror','20','35',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,454,19,'29.61691','73.55216','20.22451','48.9718589929237',253,4,500,333,0,0,0,100,100,1,1,0,1),
(20372,20372,'Baraq Orc Fighter',0,'',0,'LineageMonster.orc_fighter','12','22',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,303,10,'19.33758','61.82527','13.20506','41.16396260604',253,4,500,333,2,0,0,45,110,1,1,0,1),
(20373,20373,'Baraq Orc Warrior Leader',0,'',0,'LineageMonster.orc_fighter','12','22',11,'male','L2Monster',40,'185.38552','116.4','2.5','1.2',40,43,30,21,20,20,326,12,'21.0973','64.04702','14.40672','42.6432286072855',253,4,0,333,2,0,0,45,110,1,1,0,1),
(20374,20374,'Baranka\'s Guard',0,'',0,'LineageMonster.spartoi','11','27',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,1093,52,'51.75278','92.65694','35.34044','61.6920289224665',253,4,500,333,68,0,0,60,140,1,1,0,1),
(20375,20375,'Baranka\'s Escort',0,'',0,'LineageMonster.spartoi','11','27',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,780,36,'47.91924','89.73059','32.72263','59.7436374813816',253,8,500,333,946,0,0,60,140,1,1,0,1),
(20376,20376,'Varikan Brigand Leader',0,'',0,'LineageMonster.goblin_bi','10','21.4',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,1007,34,'19.33758','61.82527','13.20506','41.16396260604',253,1,500,333,12,0,0,40,110,1,1,0,1),
(20377,20377,'Varika\'s Bandit',0,'',0,'LineageMonster.goblin','10','16.5',7,'male','L2Monster',40,'108.42254','84.88','2','0.9',40,43,30,21,20,20,167,6,'14.80956','55.51894','10.11301','36.965135694682',253,1,0,333,0,0,0,40,110,1,1,0,1),
(20378,20378,'Stone Giant',0,'',0,'LineageMonster.stone_golem','20','31',13,'male','L2Monster',40,'214.61578','132.64','2.5','1.2',40,43,30,21,20,20,545,21,'25.04271','68.67458','17.10092','45.7243124542497',253,1,0,333,0,0,0,23,23,1,1,0,1),
(20379,20379,'Stone Soldier',0,'',0,'LineageMonster.stone_golem','20','31',14,'male','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,705,27,'27.24646','71.08179','18.6058','47.3270583783809',253,4,0,333,0,0,0,23,23,1,1,1,1),
(20380,20380,'Stone Guardian',0,'',0,'LineageMonster.stone_golem','20','31',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,807,33,'32.16396','76.08628','21.96382','50.6590964478128',253,4,0,333,0,0,0,23,23,1,1,1,1),
(20381,20381,'Vaiss Orc',0,'',0,'LineageMonster.orc','10','21',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,297,10,'19.33758','61.82527','13.20506','41.16396260604',253,1,0,333,156,0,0,45,110,1,1,0,1),
(20382,20382,'Vaiss Orc Warrior Leader',0,'',0,'LineageMonster.orc_fighter','12','22',11,'male','L2Monster',40,'185.38552','116.4','2.5','1.2',40,43,30,21,20,20,326,12,'21.0973','64.04702','14.40672','42.6432286072855',253,4,0,333,2,0,0,45,110,1,1,0,1),
(20383,20383,'Arachnid Hunter',0,'',0,'LineageMonster.binding','12','21',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,1469,80,'92.64226','118.46427','63.26266','78.8748547991048',253,4,500,333,0,0,0,10,140,1,1,0,1),
(20385,20385,'Balor Orc Archer',0,'',0,'LineageMonster.orc_archer','14','25',8,'male','L2Monster',1100,'124.92828','92.64','2','0.9',40,43,30,21,20,20,293,10,'16.20165','57.56203','11.06363','38.3254529794081',253,8,0,333,14,0,0,45,110,1,1,1,1),
(20386,20386,'Balor Orc Fighter',0,'',0,'LineageMonster.orc_fighter','12','22',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,363,12,'19.33758','61.82527','13.20506','41.16396260604',253,4,500,333,2,0,0,45,110,1,1,1,1),
(20387,20387,'Balor Orc Fighter Leader',0,'',0,'LineageMonster.orc_fighter','12','22',12,'male','L2Monster',40,'199.62322','124.48','2.5','1.2',40,43,30,21,20,20,436,16,'22.99606','66.32989','15.70333','44.163184477748',253,4,500,333,2,0,0,45,110,1,1,1,1),
(20388,20388,'Balor Orc Lieutenant',0,'',0,'LineageMonster.orc_fighter','12','22',11,'male','L2Monster',40,'185.38552','116.4','2.5','1.2',40,43,30,21,20,20,392,15,'21.0973','64.04702','14.40672','42.6432286072855',253,4,0,333,2,0,0,45,110,1,1,1,1),
(20389,20389,'Boogle Ratman',0,'',0,'LineageMonster.wererat','14','25',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,476,19,'32.16396','76.08628','21.96382','50.6590964478128',253,8,0,333,12,0,0,80,120,1,1,0,1),
(20390,20390,'Boogle Ratman Leader',0,'',0,'LineageMonster.wererat','14','25',18,'male','L2Monster',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,533,23,'37.82932','81.34791','25.83252','54.1623558855199',253,8,0,333,12,0,0,80,120,1,1,0,1),
(20391,20391,'Red Fox',0,'',0,'LineageMonster.fox','9.5','10',2,'male','L2Monster',40,'48.09168','47.28','2','0.9',40,43,30,21,20,20,59,2,'9.32203','46.15385','6.36574','30.7297498930634',253,4,0,333,0,0,0,23,110,1,1,0,1),
(20392,20392,'Redeye Bat',0,'',0,'LineageMonster.vampire_bat_bi','10','42',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,534,22,'29.61691','73.55216','20.22451','48.9718589929237',253,4,0,333,0,0,0,60,80,1,1,1,1),
(20393,20393,'Red Scavenger Spider',0,'',0,'LineageMonster.giant_spider','26','25.5',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,571,23,'32.16396','76.08628','21.96382','50.6590964478128',253,4,0,333,0,0,0,72,130,1,1,1,1),
(20394,20394,'Crimson Tarantula',0,'',0,'LineageMonster.giant_spider','26','25.5',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,450,18,'29.61691','73.55216','20.22451','48.9718589929237',253,4,500,333,0,0,0,72,130,1,1,0,1),
(20398,20398,'Vrykolakas',0,'',0,'LineageMonster.werewolf_bi','11','29.7',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,1386,57,'29.61691','73.55216','20.22451','48.9718589929237',253,1,500,333,0,0,0,50,120,1,1,0,1),
(20399,20399,'Vrykolakas Wolfkin',0,'',0,'LineageMonster.wolf_bi','13','10.8',9,'male','L2Monster',40,'143.17564','100.48','2','0.9',40,43,30,21,20,20,177,6,'17.70841','59.66387','12.09255','39.7248769407655',253,1,0,333,0,0,0,24,110,1,1,0,1),
(20400,20400,'Blood Fungus',0,'',0,'LineageMonster.walking_fungus','15','22.5',12,'male','L2Monster',40,'199.62322','124.48','2.5','1.2',40,43,30,21,20,20,428,16,'22.99606','66.32989','15.70333','44.163184477748',253,4,0,333,0,0,0,70,110,1,1,1,1),
(20401,20401,'Veelan Bugbear',0,'',0,'LineageMonster.bugbear','17','35',23,'male','L2Monster',40,'410.70422','231.96','3.5','1.5',40,43,30,21,20,20,1054,50,'55.84125','95.64976','38.13234','63.6846860642986',253,1,0,333,156,0,0,55,130,1,1,1,1),
(20402,20402,'Veelan Bugbear Warrior',0,'',0,'LineageMonster.bugbear','17','35',24,'male','L2Monster',40,'435.34437','245.52','3.5','1.5',40,43,30,21,20,20,1145,56,'60.19687','98.70919','41.10666','65.7216907961494',253,1,500,333,88,0,0,55,130,1,1,1,1),
(20403,20403,'Hunter Tarantula',0,'',0,'LineageMonster.giant_spider','26','25.5',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,571,23,'32.16396','76.08628','21.96382','50.6590964478128',253,4,0,333,0,0,0,72,130,1,1,1,1),
(20404,20404,'Silent Horror',0,'',0,'LineageMonster.dark_horror','20','35',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,485,20,'32.16396','76.08628','21.96382','50.6590964478128',253,1,500,333,0,0,0,100,100,1,1,0,1),
(20405,20405,'Young Brown Fox',0,'',0,'LineageMonster.fox','9.5','10',1,'male','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,29,2,'8.47458','44.44444','5.78704','29.5916164000214',253,4,0,333,0,0,0,23,110,1,1,0,1),
(20406,20406,'Young Red Fox',0,'',0,'LineageMonster.fox','9.5','10',1,'male','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,29,2,'8.47458','44.44444','5.78704','29.5916164000214',253,4,0,333,0,0,0,23,110,1,1,0,1),
(20407,20407,'Young Crimson Fox',0,'',0,'LineageMonster.fox','9.5','10',1,'male','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,29,2,'8.47458','44.44444','5.78704','29.5916164000214',253,4,0,333,0,0,0,23,110,1,1,0,1),
(20410,20410,'Scavenger Spider',0,'',0,'LineageMonster.giant_spider','26','25.5',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,545,22,'29.61691','73.55216','20.22451','48.9718589929237',253,4,500,333,0,0,0,72,130,1,1,1,1),
(20411,20411,'Scavenger Bat',0,'',0,'LineageMonster.vampire_bat','10','33.5',18,'male','L2Monster',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,640,28,'37.82932','81.34791','25.83252','54.1623558855199',253,4,0,333,0,0,0,60,80,1,1,1,1),
(20412,20412,'Susceptor',0,'',0,'LineageMonster.susceptor','20','35',49,'male','L2Monster',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,3492,258,'290.44588','195.66302','198.33688','130.274648808072',253,4,500,333,0,0,0,27,174,1,1,0,1),
(20415,20415,'Scarlet Salamander',0,'',0,'LineageMonster.salamander','16','6.8',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,555,23,'34.8979','78.68469','23.83074','52.3891528929827',253,4,0,333,0,0,0,64,96,1,1,0,1),
(20416,20416,'Scarlet Salamander Elder',0,'',0,'LineageMonster.salamander','16','6.8',18,'male','L2Monster',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,587,26,'37.82932','81.34791','25.83252','54.1623558855199',253,4,0,333,0,0,0,64,96,1,1,0,1),
(20418,20418,'Crystalline Beast',0,'',0,'LineageMonster.onyx_beast','14','14.5',18,'male','L2Monster',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,634,28,'37.82932','81.34791','25.83252','54.1623558855199',253,4,0,333,0,0,0,30,120,1,1,1,1),
(20419,20419,'Akaste Succubus',0,'',0,'LineageMonster.succubus','10','36',20,'female','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,606,27,'44.32863','86.87049','30.2707','57.8393570613084',253,4,500,333,0,0,0,60,100,1,1,0,1),
(20420,20420,'Akaste Succubus Turen',0,'',0,'LineageMonster.succubus','10','36',21,'female','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,780,36,'47.91924','89.73059','32.72263','59.7436374813816',253,4,500,333,0,0,0,60,100,1,1,0,1),
(20421,20421,'Akaste Succubus Tilfo',0,'',0,'LineageMonster.succubus_bi','10','43.2',22,'female','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,838,40,'51.75278','92.65694','35.34044','61.6920289224665',253,4,500,333,0,0,0,60,100,1,1,0,1),
(20422,20422,'Akaste Bone Warlord',0,'',0,'LineageMonster.skeleton','11','25',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,613,26,'34.8979','78.68469','23.83074','52.3891528929827',253,4,500,333,2,18,0,60,140,1,1,0,1),
(20423,20423,'Akaste Bone Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',14,'male','L2Monster',1100,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,428,17,'27.24646','71.08179','18.6058','47.3270583783809',253,8,0,333,275,0,0,40,140,1,1,0,1),
(20424,20424,'Akaste Bone Lord',0,'',0,'LineageMonster.skeleton','11','25',19,'male','L2Monster',40,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,592,26,'40.96915','84.07638','27.97662','55.9790056860875',253,4,500,333,68,19,0,60,140,1,1,0,1),
(20425,20425,'Akaste Bone Soldier',0,'',0,'LineageMonster.skeleton','11','25',12,'male','L2Monster',40,'199.62322','124.48','2.5','1.2',40,43,30,21,20,20,363,13,'22.99606','66.32989','15.70333','44.163184477748',253,8,500,333,946,0,0,60,140,1,1,0,1),
(20426,20426,'Evil Eye',0,'',0,'LineageMonster.monster_eye','21','43',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,356,12,'19.33758','61.82527','13.20506','41.16396260604',253,4,0,333,0,0,0,90,134,1,1,1,1),
(20427,20427,'Evil Eye Watcher',0,'',0,'LineageMonster.monster_eye','21','43',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,297,10,'19.33758','61.82527','13.20506','41.16396260604',253,4,0,333,0,0,0,90,134,1,1,0,1),
(20428,20428,'Evil Eye Patroller',0,'',0,'LineageMonster.monster_eye','21','43',14,'male','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,499,19,'27.24646','71.08179','18.6058','47.3270583783809',253,4,0,333,0,0,0,90,134,1,1,1,1),
(20429,20429,'Evil Eye Lookout',0,'',0,'LineageMonster.monster_eye','21','43',14,'male','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,416,16,'27.24646','71.08179','18.6058','47.3270583783809',253,4,0,333,0,0,0,90,134,1,1,0,1),
(20431,20431,'Elf Ghost',0,'',0,'LineageMonster.elf_ghost','7','21',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,606,27,'44.32863','86.87049','30.2707','57.8393570613084',253,4,500,333,0,0,0,80,140,1,1,0,1),
(20432,20432,'Elpy',0,'',0,'LineageMonster.elpy','5','4.5',1,'male','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,35,2,'8.47458','44.44444','5.78704','29.5916164000214',253,4,0,333,0,0,0,50,80,1,1,1,1),
(20433,20433,'Festering Bat',0,'',0,'LineageMonster.vampire_bat','10','33.5',13,'male','L2Monster',40,'214.61578','132.64','2.5','1.2',40,43,30,21,20,20,463,18,'25.04271','68.67458','17.10092','45.7243124542497',253,4,0,333,0,0,0,60,80,1,1,1,1),
(20435,20435,'Opal Beast',0,'',0,'LineageMonster.onyx_beast','14','14.5',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,450,18,'29.61691','73.55216','20.22451','48.9718589929237',253,4,500,333,0,0,0,30,120,1,1,0,1),
(20436,20436,'Ol Mahum Supplier',0,'',0,'LineageMonster.ol_mahum_bi','14','29.2',23,'male','L2Monster',40,'410.70422','231.96','3.5','1.5',40,43,30,21,20,20,1054,50,'55.84125','95.64976','38.13234','63.6846860642986',253,4,0,333,2,19,0,50,110,1,1,1,1),
(20437,20437,'Ol Mahum Recruit',0,'',0,'LineageMonster.ol_mahum','13.5','25',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,917,42,'47.91924','89.73059','32.72263','59.7436374813816',253,4,0,333,68,19,0,50,110,1,1,1,1),
(20438,20438,'Ol Mahum General',0,'',0,'LineageMonster.ol_mahum_champion','14','27',26,'male','L2Monster',40,'487.5704','273','3.5','1.5',40,43,30,21,20,20,1294,65,'69.75926','105.02818','47.63653','69.9289432036824',253,4,500,333,67,102,0,50,110,1,1,1,1),
(20439,20439,'Ol Mahum Officer',0,'',0,'LineageMonster.ol_mahum','13.5','25',24,'male','L2Monster',40,'435.34437','245.52','3.5','1.5',40,43,30,21,20,20,1123,55,'60.19687','98.70919','41.10666','65.7216907961494',253,4,0,333,66,0,0,50,110,1,1,1,1),
(20440,20440,'Elder Brown Fox',0,'',0,'LineageMonster.fox','9.5','10',3,'male','L2Monster',40,'57.54874','54.64','2','0.9',40,43,30,21,20,20,88,2,'10.24492','47.91652','6.99595','31.9033596383589',253,4,0,333,0,0,0,23,110,1,1,0,1),
(20441,20441,'Elder Longtail Fox',0,'',0,'LineageMonster.fox','9.5','10',3,'male','L2Monster',40,'57.54874','54.64','2','0.9',40,43,30,21,20,20,88,2,'10.24492','47.91652','6.99595','31.9033596383589',253,4,0,333,0,0,0,23,110,1,1,0,1),
(20442,20442,'Elder Wolf',0,'',0,'LineageMonster.wolf','13','9',5,'male','L2Monster',40,'80.17319','69.6','2','0.9',40,43,30,21,20,20,176,5,'12.34006','51.60553','8.42666','34.3595464531323',253,4,0,333,0,0,0,24,110,1,1,1,1),
(20443,20443,'Elder Red Fox',0,'',0,'LineageMonster.fox','9.5','10',3,'male','L2Monster',40,'57.54874','54.64','2','0.9',40,43,30,21,20,20,88,2,'10.24492','47.91652','6.99595','31.9033596383589',253,4,0,333,0,0,0,23,110,1,1,0,1),
(20444,20444,'Elder Prairie Fox',0,'',0,'LineageMonster.fox','9.5','10',3,'male','L2Monster',40,'57.54874','54.64','2','0.9',40,43,30,21,20,20,88,2,'10.24492','47.91652','6.99595','31.9033596383589',253,4,0,333,0,0,0,23,110,1,1,0,1),
(20445,20445,'Uthanka Pirate',0,'',0,'LineageMonster.orc','10','21',7,'male','L2Monster',40,'108.42254','84.88','2','0.9',40,43,30,21,20,20,154,5,'14.80956','55.51894','10.11301','36.965135694682',253,4,0,333,3,0,0,45,110,1,1,0,1),
(20446,20446,'Utuku Orc',0,'',0,'LineageMonster.orc','10','21',6,'male','L2Monster',40,'93.54158','77.2','2','0.9',40,43,30,21,20,20,214,6,'13.52471','53.53373','9.23562','35.6433609604933',253,1,0,333,156,0,0,45,110,1,1,1,1),
(20447,20447,'Utuku Orc Archer',0,'',0,'LineageMonster.orc_archer','14','25',8,'male','L2Monster',1100,'124.92828','92.64','2','0.9',40,43,30,21,20,20,293,10,'16.20165','57.56203','11.06363','38.3254529794081',253,8,0,333,14,0,0,45,110,1,1,1,1),
(20448,20448,'Utuku Orc Grunt',0,'',0,'LineageMonster.orc','10','21',7,'male','L2Monster',40,'108.42254','84.88','2','0.9',40,43,30,21,20,20,249,8,'14.80956','55.51894','10.11301','36.965135694682',253,4,0,333,3,0,0,45,110,1,1,1,1),
(20449,20449,'Will-O-Wisp',0,'',0,'LineageMonster.will_o_wisp','13','22',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,533,22,'29.61691','73.55216','20.22451','48.9718589929237',253,4,0,333,0,0,0,80,140,1,1,0,1),
(20450,20450,'Relic Werewolf',0,'',0,'LineageMonster.werewolf','10','26',9,'male','L2Monster',40,'143.17564','100.48','2','0.9',40,43,30,21,20,20,268,9,'17.70841','59.66387','12.09255','39.7248769407655',253,1,0,333,0,0,0,50,120,1,1,0,1),
(20451,20451,'Relic Spartoi',0,'',0,'LineageMonster.spartoi','11','27',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,1422,65,'47.91924','89.73059','32.72263','59.7436374813816',253,4,0,333,68,0,0,60,140,1,1,0,1),
(20453,20453,'Human Ghost',0,'',0,'LineageMonster.human_ghost','8','22',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,606,27,'44.32863','86.87049','30.2707','57.8393570613084',253,4,500,333,0,0,0,80,140,1,1,0,1),
(20454,20454,'Oblivion Watcher',0,'',0,'LineageMonster.monster_eye','21','43',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,227,10,'34.8979','78.68469','23.83074','52.3891528929827',253,1,0,333,0,0,0,90,90,1,1,0,1),
(20455,20455,'Doom Soldier',0,'',0,'LineageMonster.skeleton','11','25',14,'male','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,424,16,'27.24646','71.08179','18.6058','47.3270583783809',253,8,500,333,946,0,0,60,140,1,1,0,1),
(20456,20456,'Ashen Wolf',0,'',0,'LineageMonster.wolf','13','9',4,'male','L2Monster',40,'68.20985','62.08','2','0.9',40,43,30,21,20,20,141,4,'11.24892','49.73343','7.68155','33.1130825524654',253,4,0,333,0,0,0,24,110,1,1,1,1),
(20457,20457,'Zombie Soldier',0,'',0,'LineageMonster.zombie','13','21',19,'male','L2Monster',40,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,959,43,'40.96915','84.07638','27.97662','55.9790056860875',253,4,0,333,0,0,0,15,15,1,1,1,1),
(20458,20458,'Zombie Warrior',0,'',0,'LineageMonster.zombie_bi','12','27.5',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,1421,67,'51.75278','92.65694','35.34044','61.6920289224665',253,4,500,333,0,0,0,15,15,1,1,1,1),
(20460,20460,'Crimson Spider',0,'',0,'LineageMonster.giant_spider','26','25.5',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,545,22,'29.61691','73.55216','20.22451','48.9718589929237',253,4,500,333,0,0,0,72,130,1,1,1,1),
(20461,20461,'Dungeon Spider',0,'',0,'LineageMonster.giant_spider','26','25.5',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,454,19,'29.61691','73.55216','20.22451','48.9718589929237',253,1,500,333,0,0,0,72,130,1,1,0,1),
(20462,20462,'Cave Blade Spider',0,'',0,'LineageMonster.giant_spider','26','25.5',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,515,22,'34.8979','78.68469','23.83074','52.3891528929827',253,1,500,333,0,0,0,72,130,1,1,0,1),
(20463,20463,'Dungeon Skeleton Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',13,'male','L2Monster',1100,'214.61578','132.64','2.5','1.2',40,43,30,21,20,20,397,16,'25.04271','68.67458','17.10092','45.7243124542497',253,8,0,333,275,0,0,40,140,1,1,0,1),
(20464,20464,'Dungeon Skeleton',0,'',0,'LineageMonster.skeleton','11','25',12,'male','L2Monster',40,'199.62322','124.48','2.5','1.2',40,43,30,21,20,20,363,13,'22.99606','66.32989','15.70333','44.163184477748',253,8,500,333,946,0,0,60,140,1,1,0,1),
(20465,20465,'Prairie Fox',0,'',0,'LineageMonster.fox','9.5','10',2,'male','L2Monster',40,'48.09168','47.28','2','0.9',40,43,30,21,20,20,59,2,'9.32203','46.15385','6.36574','30.7297498930634',253,4,0,333,0,0,0,23,110,1,1,0,1),
(20466,20466,'Pincer Spider',0,'',0,'LineageMonster.giant_spider','26','25.5',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,618,26,'34.8979','78.68469','23.83074','52.3891528929827',253,4,500,333,0,0,0,72,130,1,1,1,1),
(20468,20468,'Kaboo Orc',0,'',0,'LineageMonster.orc','10','21',6,'male','L2Monster',40,'93.54158','77.2','2','0.9',40,43,30,21,20,20,214,6,'13.52471','53.53373','9.23562','35.6433609604933',253,1,0,333,156,0,0,45,110,1,1,1,1),
(20469,20469,'Kaboo Orc Archer',0,'',0,'LineageMonster.orc_archer','14','25',8,'male','L2Monster',1100,'124.92828','92.64','2','0.9',40,43,30,21,20,20,293,10,'16.20165','57.56203','11.06363','38.3254529794081',253,8,0,333,14,0,0,45,110,1,1,1,1),
(20470,20470,'Kaboo Orc Grunt',0,'',0,'LineageMonster.orc','10','21',7,'male','L2Monster',40,'108.42254','84.88','2','0.9',40,43,30,21,20,20,249,8,'14.80956','55.51894','10.11301','36.965135694682',253,4,0,333,3,0,0,45,110,1,1,1,1),
(20471,20471,'Kaboo Orc Fighter',0,'',0,'LineageMonster.orc_fighter','12','22',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,363,12,'19.33758','61.82527','13.20506','41.16396260604',253,4,500,333,2,0,0,45,110,1,1,1,1),
(20472,20472,'Kaboo Orc Fighter Leader',0,'',0,'LineageMonster.orc_fighter','12','22',12,'male','L2Monster',40,'199.62322','124.48','2.5','1.2',40,43,30,21,20,20,436,16,'22.99606','66.32989','15.70333','44.163184477748',253,4,500,333,2,0,0,45,110,1,1,1,1),
(20473,20473,'Kaboo Orc Fighter Lieutenant',0,'',0,'LineageMonster.orc_fighter','12','22',11,'male','L2Monster',40,'185.38552','116.4','2.5','1.2',40,43,30,21,20,20,392,15,'21.0973','64.04702','14.40672','42.6432286072855',253,4,0,333,2,0,0,45,110,1,1,1,1),
(20474,20474,'Kasha Spider',0,'',0,'LineageMonster.giant_spider','26','25.5',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,534,22,'29.61691','73.55216','20.22451','48.9718589929237',253,4,0,333,0,0,0,72,130,1,1,1,1),
(20475,20475,'Kasha Wolf',0,'',0,'LineageMonster.wolf','13','9',4,'male','L2Monster',40,'68.20985','62.08','2','0.9',40,43,30,21,20,20,141,4,'11.24892','49.73343','7.68155','33.1130825524654',253,4,0,333,0,0,0,24,110,1,1,1,1),
(20476,20476,'Kasha Fang Spider',0,'',0,'LineageMonster.giant_spider','26','25.5',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,571,23,'32.16396','76.08628','21.96382','50.6590964478128',253,4,0,333,0,0,0,72,130,1,1,1,1),
(20477,20477,'Kasha Timber Wolf',0,'',0,'LineageMonster.wolf_bi','13','10.8',6,'male','L2Monster',40,'93.54158','77.2','2','0.9',40,43,30,21,20,20,212,6,'13.52471','53.53373','9.23562','35.6433609604933',253,4,0,333,0,0,0,24,110,1,1,1,1),
(20478,20478,'Kasha Blade Spider',0,'',0,'LineageMonster.giant_spider','26','25.5',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,667,28,'34.8979','78.68469','23.83074','52.3891528929827',253,4,0,333,0,0,0,72,130,1,1,1,1),
(20479,20479,'Kasha Bear',0,'',0,'LineageMonster.grizzly_bi','21','50',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,540,22,'29.61691','73.55216','20.22451','48.9718589929237',253,4,500,333,0,0,0,40,110,1,1,1,1),
(20480,20480,'Blade Bat',0,'',0,'LineageMonster.vampire_bat','10','33.5',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,356,12,'19.33758','61.82527','13.20506','41.16396260604',253,4,0,333,0,0,0,60,80,1,1,1,1),
(20481,20481,'Bearded Keltir',0,'',0,'LineageMonster.keltir','9.5','10',1,'male','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,35,2,'8.47458','44.44444','5.78704','29.5916164000214',253,4,0,333,0,0,0,23,110,1,1,1,1),
(20483,20483,'Corpse Candle',0,'',0,'LineageMonster.will_o_wisp','13','22',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,604,25,'34.8979','78.68469','23.83074','52.3891528929827',253,4,0,333,0,0,0,80,140,1,1,0,1),
(20487,20487,'Kuruka Ratman',0,'',0,'LineageMonster.wererat','14','25',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,476,19,'32.16396','76.08628','21.96382','50.6590964478128',253,8,0,333,216,0,0,80,120,1,1,0,1),
(20488,20488,'Kuruka Ratman Hunter',0,'',0,'LineageMonster.wererat','14','25',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,505,21,'34.8979','78.68469','23.83074','52.3891528929827',253,4,0,333,3,0,0,80,120,1,1,0,1),
(20489,20489,'Quicksilver Beast',0,'',0,'LineageMonster.onyx_beast','14','14.5',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,450,18,'29.61691','73.55216','20.22451','48.9718589929237',253,4,500,333,0,0,0,30,120,1,1,0,1),
(20490,20490,'Death Doll',0,'',0,'LineageMonster.crimson_doll','15','38',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,2611,169,'176.36077','156.55035','120.43155','104.232986928232',253,4,500,333,0,0,0,60,150,1,1,0,1),
(20491,20491,'Crypt Horror',0,'',0,'LineageMonster.dark_horror','20','35',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,454,19,'29.61691','73.55216','20.22451','48.9718589929237',253,4,500,333,0,0,0,100,100,1,1,0,1),
(20492,20492,'Kirunak\'s Guards',0,'',0,'LineageMonster.spartoi','11','27',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,764,35,'47.91924','89.73059','32.72263','59.7436374813816',253,4,0,333,68,0,0,60,140,1,1,0,1),
(20494,20494,'Turek War Hound',0,'',0,'LineageMonster.dire_wolf','13','11',24,'male','L2Monster',40,'435.34437','245.52','3.5','1.5',40,43,30,21,20,20,2088,103,'60.19687','98.70919','41.10666','65.7216907961494',253,4,0,333,0,0,0,24,110,1,1,0,1),
(20495,20495,'Turek Orc Warlord',0,'',0,'LineageMonster.orc_champion','10','23',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,3338,182,'92.64226','118.46427','63.26266','78.8748547991048',253,4,500,333,127,0,0,45,130,1,1,0,1),
(20496,20496,'Turek Orc Archer',0,'',0,'LineageMonster.orc_archer','14','25',27,'male','L2Monster',1100,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,2585,132,'74.99121','108.28767','51.20928','72.0991544841329',253,8,0,333,14,0,0,45,110,1,1,0,1),
(20497,20497,'Turek Orc Skirmisher',0,'',0,'LineageMonster.orc_fighter','12','22',28,'male','L2Monster',40,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,2682,140,'80.54056','111.61368','54.99876','74.3136496629463',253,4,500,333,121,0,0,45,110,1,1,0,1),
(20498,20498,'Turek Orc Supplier',0,'',0,'LineageMonster.orc_fighter','12','22',27,'male','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,2485,127,'74.99121','108.28767','51.20928','72.0991544841329',253,8,0,333,11,0,0,45,110,1,1,0,1),
(20499,20499,'Turek Orc Footman',0,'',0,'LineageMonster.orc','10','21',26,'male','L2Monster',40,'487.5704','273','3.5','1.5',40,43,30,21,20,20,2359,119,'69.75926','105.02818','47.63653','69.9289432036824',253,4,0,333,2,0,0,45,110,1,1,0,1),
(20500,20500,'Turek Orc Sentinel',0,'',0,'LineageMonster.orc','10','21',25,'male','L2Monster',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,2215,110,'64.83203','101.83533','44.27187','67.8031159084826',253,4,0,333,3,0,0,45,110,1,1,0,1),
(20501,20501,'Turek Orc Shaman',0,'',0,'LineageMonster.orc_shaman','9','22',29,'male','L2Monster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,2776,149,'86.42002','115.00598','59.01367','76.5722740603874',253,1,0,333,7,0,0,45,120,1,1,0,1),
(20502,20502,'Twink Puma',0,'',0,'LineageMonster.onyx_beast','14','14.5',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,540,22,'29.61691','73.55216','20.22451','48.9718589929237',253,4,500,333,0,0,0,30,120,1,1,1,1),
(20504,20504,'Dread Soldier',0,'',0,'LineageMonster.skeleton','11','25',14,'male','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,424,16,'27.24646','71.08179','18.6058','47.3270583783809',253,8,500,333,946,0,0,60,140,1,1,0,1),
(20505,20505,'Ruin Bat',0,'',0,'LineageMonster.vampire_bat_bi','10','42',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,713,32,'44.32863','86.87049','30.2707','57.8393570613084',253,4,0,333,0,0,0,60,80,1,1,1,1),
(20506,20506,'Ruin Imp',0,'',0,'LineageMonster.imp_bi','10','30',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,606,25,'34.8979','78.68469','23.83074','52.3891528929827',253,4,0,333,0,0,0,60,80,1,1,1,1),
(20507,20507,'Ruin Imp Elder',0,'',0,'LineageMonster.imp_bi','10','30',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,936,43,'47.91924','89.73059','32.72263','59.7436374813816',253,4,500,333,0,0,0,60,80,1,1,1,1),
(20508,20508,'Plunder Tarantula',0,'',0,'LineageMonster.giant_spider','26','25.5',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,618,26,'34.8979','78.68469','23.83074','52.3891528929827',253,4,500,333,0,0,0,72,130,1,1,1,1),
(20509,20509,'Spore Fungus',0,'',0,'LineageMonster.walking_fungus','15','22.5',9,'male','L2Monster',40,'143.17564','100.48','2','0.9',40,43,30,21,20,20,321,11,'17.70841','59.66387','12.09255','39.7248769407655',253,4,0,333,0,0,0,70,110,1,1,1,1),
(20510,20510,'Puma',0,'',0,'LineageMonster.onyx_beast','14','14.5',12,'male','L2Monster',40,'199.62322','124.48','2.5','1.2',40,43,30,21,20,20,423,16,'22.99606','66.32989','15.70333','44.163184477748',253,4,0,333,0,0,0,30,120,1,1,1,1),
(20511,20511,'Pitchstone Golem',0,'',0,'LineageMonster.stone_golem','20','31',19,'male','L2Monster',40,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,799,36,'40.96915','84.07638','27.97662','55.9790056860875',253,4,0,333,0,0,0,23,23,1,1,0,1),
(20512,20512,'Field Stalker',0,'',0,'LineageMonster.field_stalker','15','30',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,2175,128,'129.32896','136.72948','88.31491','91.0360303625432',253,4,500,333,0,0,0,70,110,1,1,0,1),
(20513,20513,'Skeleton Knight',0,'',0,'LineageMonster.skeleton_knight','10','25',32,'male','L2Monster',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,1519,85,'106.16525','125.57727','72.49711','83.6107570481808',253,4,500,333,150,0,0,40,160,1,1,0,1),
(20514,20514,'Shield Skeleton',0,'',0,'LineageMonster.skeleton','11','25',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,534,22,'29.61691','73.55216','20.22451','48.9718589929237',253,1,0,333,157,103,0,60,140,1,1,1,1),
(20515,20515,'Skeleton Infantryman',0,'',0,'LineageMonster.skeleton','11','25',16,'male','L2Monster',40,'264.34345','157.6','2.5','1.2',40,43,30,21,20,20,571,23,'32.16396','76.08628','21.96382','50.6590964478128',253,1,0,333,157,18,0,60,140,1,1,1,1),
(20516,20516,'Skeleton Sentinel',0,'',0,'LineageMonster.skeleton_bi','11','31',14,'male','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,424,16,'27.24646','71.08179','18.6058','47.3270583783809',253,8,500,333,946,0,0,60,140,1,1,0,1),
(20517,20517,'Skeleton Hunter',0,'',0,'LineageMonster.skeleton','11','25',12,'male','L2Monster',40,'199.62322','124.48','2.5','1.2',40,43,30,21,20,20,363,13,'22.99606','66.32989','15.70333','44.163184477748',253,8,500,333,946,0,0,60,140,1,1,0,1),
(20518,20518,'Skeleton Hunter Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',13,'male','L2Monster',1100,'214.61578','132.64','2.5','1.2',40,43,30,21,20,20,397,16,'25.04271','68.67458','17.10092','45.7243124542497',253,8,0,333,275,0,0,40,140,1,1,0,1),
(20519,20519,'Skeleton Pikeman',0,'',0,'LineageMonster.skeleton_pikeman','10','28',27,'male','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,1136,58,'74.99121','108.28767','51.20928','72.0991544841329',253,4,500,333,299,0,0,50,155,1,1,0,1),
(20520,20520,'Pirate Captain Uthanka',0,'',0,'LineageMonster.orc_fighter_bi','12','26.4',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,926,32,'19.33758','61.82527','13.20506','41.16396260604',253,1,500,333,2,0,0,45,110,1,1,0,1),
(20521,20521,'Whinstone Golem',0,'',0,'LineageMonster.stone_golem','20','31',14,'male','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,705,27,'27.24646','71.08179','18.6058','47.3270583783809',253,4,0,333,0,0,0,23,23,1,1,1,1),
(20522,20522,'White Fang',0,'',0,'LineageMonster.wolf_bi','13','10.8',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,917,31,'19.33758','61.82527','13.20506','41.16396260604',253,1,500,333,0,0,0,24,110,1,1,0,1),
(20524,20524,'Grey Wolf Elder',0,'',0,'LineageMonster.wolf','13','9',7,'male','L2Monster',40,'108.42254','84.88','2','0.9',40,43,30,21,20,20,152,5,'14.80956','55.51894','10.11301','36.965135694682',253,1,0,333,0,0,0,24,110,1,1,0,1),
(20525,20525,'Gray Wolf',0,'',0,'LineageMonster.wolf','13','9',4,'male','L2Monster',40,'68.20985','62.08','2','0.9',40,43,30,21,20,20,141,4,'11.24892','49.73343','7.68155','33.1130825524654',253,4,0,333,0,0,0,24,110,1,1,1,1),
(20526,20526,'Obsidian Golem',0,'',0,'LineageMonster.stone_golem','20','31',15,'male','L2Monster',40,'246.95422','149.2','2.5','1.2',40,43,30,21,20,20,756,31,'29.61691','73.55216','20.22451','48.9718589929237',253,4,0,333,0,0,0,23,23,1,1,1,1),
(20527,20527,'Great Snow Wolf',0,'',0,'LineageMonster.dire_wolf','13','11',4,'male','L2Monster',40,'68.20985','62.08','2','0.9',40,43,30,21,20,20,121,3,'11.24892','49.73343','7.68155','33.1130825524654',253,4,500,333,0,0,0,24,110,1,1,0,1),
(20528,20528,'Goblin Lord',0,'',0,'LineageMonster.goblin','10','16.5',13,'male','L2Monster',40,'214.61578','132.64','2.5','1.2',40,43,30,21,20,20,458,18,'25.04271','68.67458','17.10092','45.7243124542497',253,8,0,333,217,0,0,40,110,1,1,1,1),
(20529,20529,'Young Brown Keltir',0,'',0,'LineageMonster.keltir','9.5','10',1,'male','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,35,2,'8.47458','44.44444','5.78704','29.5916164000214',253,4,0,333,0,0,0,23,110,1,1,1,1),
(20530,20530,'Young Red Keltir',0,'',0,'LineageMonster.keltir','9.5','10',1,'male','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,35,2,'8.47458','44.44444','5.78704','29.5916164000214',253,4,0,333,0,0,0,23,110,1,1,1,1),
(20531,20531,'Young Prairie Keltir',0,'',0,'LineageMonster.keltir','9.5','10',1,'male','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,35,2,'8.47458','44.44444','5.78704','29.5916164000214',253,4,0,333,0,0,0,23,110,1,1,1,1),
(20532,20532,'Brown Keltir',0,'',0,'LineageMonster.keltir','9.5','10',2,'male','L2Monster',40,'48.09168','47.28','2','0.9',40,43,30,21,20,20,71,2,'9.32203','46.15385','6.36574','30.7297498930634',253,4,0,333,0,0,0,23,110,1,1,1,1),
(20533,20533,'Longtail Keltir',0,'',0,'LineageMonster.keltir','9.5','10',2,'male','L2Monster',40,'48.09168','47.28','2','0.9',40,43,30,21,20,20,71,2,'9.32203','46.15385','6.36574','30.7297498930634',253,4,0,333,0,0,0,23,110,1,1,1,1),
(20534,20534,'Red Keltir',0,'',0,'LineageMonster.keltir','9.5','10',2,'male','L2Monster',40,'48.09168','47.28','2','0.9',40,43,30,21,20,20,71,2,'9.32203','46.15385','6.36574','30.7297498930634',253,4,0,333,0,0,0,23,110,1,1,1,1),
(20535,20535,'Prairie Keltir',0,'',0,'LineageMonster.keltir','9.5','10',2,'male','L2Monster',40,'48.09168','47.28','2','0.9',40,43,30,21,20,20,71,2,'9.32203','46.15385','6.36574','30.7297498930634',253,4,0,333,0,0,0,23,110,1,1,1,1),
(20536,20536,'Elder Brown Keltir',0,'',0,'LineageMonster.keltir','9.5','10',3,'male','L2Monster',40,'57.54874','54.64','2','0.9',40,43,30,21,20,20,106,2,'10.24492','47.91652','6.99595','31.9033596383589',253,4,0,333,0,0,0,23,110,1,1,1,1),
(20537,20537,'Elder Red Keltir',0,'',0,'LineageMonster.keltir','9.5','10',3,'male','L2Monster',40,'57.54874','54.64','2','0.9',40,43,30,21,20,20,106,2,'10.24492','47.91652','6.99595','31.9033596383589',253,4,0,333,0,0,0,23,110,1,1,1,1),
(20538,20538,'Elder Prairie Keltir',0,'',0,'LineageMonster.keltir','9.5','10',3,'male','L2Monster',40,'57.54874','54.64','2','0.9',40,43,30,21,20,20,106,2,'10.24492','47.91652','6.99595','31.9033596383589',253,4,0,333,0,0,0,23,110,1,1,1,1),
(20539,20539,'Elder Longtail Keltir',0,'',0,'LineageMonster.keltir','9.5','10',3,'male','L2Monster',40,'57.54874','54.64','2','0.9',40,43,30,21,20,20,106,2,'10.24492','47.91652','6.99595','31.9033596383589',253,4,0,333,0,0,0,23,110,1,1,1,1),
(20540,20540,'Gemstone Beast',0,'',0,'LineageMonster.onyx_beast','14','14.5',12,'male','L2Monster',40,'199.62322','124.48','2.5','1.2',40,43,30,21,20,20,353,13,'22.99606','66.32989','15.70333','44.163184477748',253,4,0,333,0,0,0,30,120,1,1,0,1),
(20541,20541,'Ore Bat',0,'',0,'LineageMonster.vampire_bat','10','33.5',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,500,21,'34.8979','78.68469','23.83074','52.3891528929827',253,4,0,333,0,0,0,60,80,1,1,0,1),
(20542,20542,'Skeleton Longbowman',0,'',0,'LineageMonster.skeleton_archer','11','27',19,'male','L2Monster',1100,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,588,26,'40.96915','84.07638','27.97662','55.9790056860875',253,8,500,333,275,0,0,40,140,1,1,0,1),
(20543,20543,'Ghost',0,'',0,'LineageMonster.human_ghost','8','22',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,600,27,'44.32863','86.87049','30.2707','57.8393570613084',253,4,500,333,0,0,0,80,140,1,1,0,1),
(20544,20544,'Elder Keltir',0,'',0,'LineageMonster.keltir','9.5','10',3,'male','L2Monster',40,'57.54874','54.64','2','0.9',40,43,30,21,20,20,106,2,'10.24492','47.91652','6.99595','31.9033596383589',253,4,0,333,0,0,0,23,110,1,1,1,1),
(20545,20545,'Young Keltir',0,'',0,'LineageMonster.keltir','9.5','10',1,'male','L2Monster',40,'39.74519','40','2','0.9',40,43,30,21,20,20,35,2,'8.47458','44.44444','5.78704','29.5916164000214',253,4,0,333,0,0,0,23,110,1,1,1,1),
(20546,20546,'Turek Orc Elder',0,'',0,'LineageMonster.orc_shaman','9','22',34,'male','L2Monster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,2058,120,'121.20802','132.9486','82.76936','88.5186722618248',253,1,500,333,7,0,0,45,120,1,1,0,1),
(20547,20547,'Ol Mahum Reserve',0,'',0,'LineageMonster.ol_mahum_bi','14','29.2',23,'male','L2Monster',40,'410.70422','231.96','3.5','1.5',40,43,30,21,20,20,1054,50,'55.84125','95.64976','38.13234','63.6846860642986',253,4,0,333,2,0,0,50,110,1,1,1,1),
(20548,20548,'Ol Mahum Deserter',0,'',0,'LineageMonster.ol_mahum','13.5','25',23,'male','L2Monster',40,'410.70422','231.96','3.5','1.5',40,43,30,21,20,20,1075,52,'55.84125','95.64976','38.13234','63.6846860642986',253,4,500,333,2,0,0,50,110,1,1,1,1),
(20549,20549,'Ol Mahum Lord',0,'',0,'LineageMonster.ol_mahum_champion','14','27',34,'male','L2Monster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,4233,247,'121.20802','132.9486','82.76936','88.5186722618248',253,4,500,333,69,19,0,50,110,1,1,1,1),
(20550,20550,'Guardian Basilisk',0,'',0,'LineageMonster.lesser_basilisk','34','25',36,'male','L2Monster',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,2352,142,'137.86467','140.57278','94.1437','93.5949427192352',253,4,0,333,0,0,0,35,174,1,1,1,1),
(20551,20551,'Road Scavenger',0,'',0,'LineageMonster.wererat','14','25',37,'male','L2Monster',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,20,2389,146,'146.82587','144.47758','100.26304','96.1948088105753',253,8,0,333,221,0,0,80,174,1,1,1,1),
(20552,20552,'Fettered Soul',0,'',0,'LineageMonster.binding','12','21',38,'male','L2Monster',40,'886.09975','447.96','4.5','1.8',40,43,30,21,20,20,5152,322,'156.22273','148.44287','106.67987','98.8349371271581',253,4,0,333,0,0,0,10,174,1,1,1,1),
(20553,20553,'Windsus',0,'',0,'LineageMonster.giant_wild_hog','35','27',39,'male','L2Monster',40,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,2655,169,'166.06476','152.46752','113.4007','101.514599764346',253,4,0,333,0,0,0,35,174,1,1,1,1),
(20554,20554,'Grandis',0,'',0,'LineageMonster.twin_headed_giant','17','39',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,3102,200,'176.36077','156.55035','120.43155','104.232986928232',253,4,500,333,0,0,0,45,174,1,1,1,1),
(20555,20555,'Giant Fungus',0,'',0,'LineageMonster.walking_fungus_bi','15','31.3',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,2792,180,'176.36077','156.55035','120.43155','104.232986928232',253,4,0,333,0,0,0,70,174,1,1,1,1),
(20556,20556,'Giant Monstereye',0,'',0,'LineageMonster.monster_eye_bi','29','60',41,'male','L2Monster',40,'1008.23781','504.8','5.5','2.1',40,43,30,21,20,20,2934,192,'187.11878','160.69002','127.77787','106.989225133249',253,4,0,333,0,0,0,90,174,1,1,1,1),
(20557,20557,'Dire Wyrm',0,'',0,'LineageMonster.wyrm','29','72',42,'male','L2Monster',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,3109,208,'198.34591','164.88513','135.44454','109.782377202178',253,4,500,333,0,0,0,70,174,1,1,1,1),
(20558,20558,'Rotting tree',0,'',0,'LineageMonster.hanged_man_ripper','35','80',43,'male','L2Monster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,3195,216,'210.04832','169.13417','143.43577','112.611442266143',253,4,0,333,0,0,0,55,174,1,1,1,1),
(20559,20559,'Rotting Golem',0,'',0,'LineageMonster.stone_golem_bi_one','22','43.4',44,'male','L2Monster',40,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,4730,324,'222.23112','173.43552','151.75505','115.475328468187',253,4,0,333,0,0,0,23,23,1,1,1,1),
(20560,20560,'Trisalim Spider',0,'',0,'LineageMonster.giant_spider','26','25.5',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,3499,244,'234.89829','177.78746','160.40508','118.372898457316',253,4,0,333,0,0,0,72,174,1,1,1,1),
(20561,20561,'Trisalim Tarantula',0,'',0,'LineageMonster.poison_spider','27','25.5',46,'male','L2Monster',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,20,4144,294,'248.0526','182.18816','169.38777','121.302932993263',253,4,500,333,0,0,0,60,174,1,1,1,1),
(20562,20562,'Spore Zombie',0,'',0,'LineageMonster.zombie_bi','12','27.5',47,'male','L2Monster',40,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,4310,308,'261.69549','186.63569','178.7041','124.264149144103',253,4,0,333,0,0,0,15,15,1,1,1,1),
(20563,20563,'Manashen Gargoyle',0,'',0,'LineageMonster.gargoyle','16','50',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,3323,215,'176.36077','156.55035','120.43155','104.232986928232',253,4,0,333,0,0,0,140,174,1,1,1,1),
(20564,20564,'Enchanted Monstereye',0,'',0,'LineageMonster.monster_eye','21','43',41,'male','L2Monster',40,'1008.23781','504.8','5.5','2.1',40,43,30,21,20,20,2992,196,'187.11878','160.69002','127.77787','106.989225133249',253,4,500,333,0,0,0,90,174,1,1,1,1),
(20565,20565,'Enchanted Stone Golem',0,'',0,'LineageMonster.stone_golem_bi','20','40.3',42,'male','L2Monster',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,4353,290,'198.34591','164.88513','135.44454','109.782377202178',253,4,0,333,0,0,0,23,23,1,1,1,1),
(20566,20566,'Enchanted Iron Golem',0,'',0,'LineageMonster.iron_golem','18','34',43,'male','L2Monster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,4563,308,'210.04832','169.13417','143.43577','112.611442266143',253,4,0,333,0,0,0,20,20,1,1,1,1),
(20567,20567,'Enchanted Gargoyle',0,'',0,'LineageMonster.gargoyle','16','50',44,'male','L2Monster',40,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,4021,275,'222.23112','173.43552','151.75505','115.475328468187',253,4,0,333,0,0,0,140,174,1,1,1,1),
(20568,20568,'Formor',0,'',0,'LineageMonster.troll','21','35',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,3534,246,'234.89829','177.78746','160.40508','118.372898457316',253,4,0,333,0,0,0,55,174,1,1,1,1),
(20569,20569,'Formor Elder',0,'',0,'LineageMonster.troll','21','35',46,'male','L2Monster',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,20,3841,272,'248.0526','182.18816','169.38777','121.302932993263',253,4,0,333,0,0,0,55,174,1,1,1,1),
(20570,20570,'Tarlk Bugbear',0,'',0,'LineageMonster.bugbear','17','35',47,'male','L2Monster',40,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,3855,276,'261.69549','186.63569','178.7041','124.264149144103',253,1,0,333,88,0,0,55,174,1,1,1,1),
(20571,20571,'Tarlk Bugbear Warrior',0,'',0,'LineageMonster.bugbear','17','35',48,'male','L2Monster',40,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,4553,332,'275.82705','191.12803','188.35412','127.255200286259',253,1,500,333,169,0,0,55,174,1,1,1,1),
(20572,20572,'Tarlk Bugbear High Warrior',0,'',0,'LineageMonster.king_bugbear','15','40',49,'male','L2Monster',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,4987,368,'290.44588','195.66302','198.33688','130.274648808072',253,1,0,333,160,0,0,55,174,1,1,1,1),
(20573,20573,'Tarlk Basilisk',0,'',0,'LineageMonster.lesser_basilisk','34','25',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,4288,323,'305.54906','200.23844','208.6504','146.5258',253,4,0,333,0,0,0,35,100,1,1,1,1),
(20574,20574,'Elder Tarlk Basilisk',0,'',0,'LineageMonster.lesser_basilisk','34','25',51,'male','L2Monster',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,20,4506,343,'321.13207','204.85194','219.29157','149.90176',253,4,500,333,0,0,0,35,100,1,1,1,1),
(20575,20575,'Oel Mahum Warrior',0,'',0,'LineageMonster.oel_mahum_warrior','20','38',54,'male','L2Monster',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,5051,402,'370.68904','218.89589','253.13256','160.17851',253,4,0,333,72,0,0,70,160,1,1,1,1),
(20576,20576,'Oel Mahum Witch Doctor',0,'',0,'LineageMonster.oel_mahum_witch_doctor','15','34',55,'male','L2Monster',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,10289,791,'388.11142','223.6362','265.02979','163.64727',253,1,0,333,201,0,0,70,130,1,1,1,1),
(20577,20577,'Leto Lizardman',0,'',0,'LineageMonster.zenta_lizardman','11','32',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,2138,126,'129.32896','136.72948','88.31491','91.0360303625432',253,4,0,333,66,0,0,37,174,1,1,1,1),
(20578,20578,'Leto Lizardman Archer',0,'',0,'LineageMonster.zenta_lizardman_scout','11','30',36,'male','L2Monster',1100,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,2330,140,'137.86467','140.57278','94.1437','93.5949427192352',253,8,0,333,14,0,0,37,174,1,1,1,1),
(20579,20579,'Leto Lizardman Soldier',0,'',0,'LineageMonster.zenta_lizardman','11','32',37,'male','L2Monster',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,20,2437,150,'146.82587','144.47758','100.26304','96.1948088105753',253,4,500,333,68,0,0,37,174,1,1,1,1),
(20580,20580,'Leto Lizardman Warrior',0,'',0,'LineageMonster.zenta_lizardman_warrior','13','35',38,'male','L2Monster',40,'886.09975','447.96','4.5','1.8',40,43,30,21,20,20,4688,292,'156.22273','148.44287','106.67987','98.8349371271581',253,4,0,333,93,0,0,40,174,1,1,1,1),
(20581,20581,'Leto Lizardman Shaman',0,'',0,'LineageMonster.zenta_lizardman_shaman','13','35',39,'male','L2Monster',40,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,2655,169,'166.06476','152.46752','113.4007','101.514599764346',253,1,0,333,159,0,0,43,174,1,1,1,1),
(20582,20582,'Leto Lizardman Overlord',0,'',0,'LineageMonster.zenta_lizardman_matriarch','20','40',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,5298,342,'176.36077','156.55035','120.43155','104.232986928232',253,8,500,333,221,0,0,53,174,1,1,1,1),
(20583,20583,'Timak Orc',0,'',0,'LineageMonster.batur_orc','9','21.5',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,2792,180,'176.36077','156.55035','120.43155','104.232986928232',253,4,0,333,2,0,0,80,174,1,1,1,1),
(20584,20584,'Timak Orc Archer',0,'',0,'LineageMonster.batur_orc_archer','11','21.5',41,'male','L2Monster',1100,'1008.23781','504.8','5.5','2.1',40,43,30,21,20,20,3783,247,'187.11878','160.69002','127.77787','106.989225133249',253,8,0,333,14,0,0,45,174,1,1,1,1),
(20585,20585,'Timak Orc Soldier',0,'',0,'LineageMonster.batur_orc','9','21.5',42,'male','L2Monster',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,3737,248,'198.34591','164.88513','135.44454','109.782377202178',253,4,500,333,66,0,0,80,174,1,1,1,1),
(20586,20586,'Timak Orc Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10','20',43,'male','L2Monster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,3582,242,'210.04832','169.13417','143.43577','112.611442266143',253,4,0,333,68,0,0,80,174,1,1,1,1),
(20587,20587,'Timak Orc Shaman',0,'',0,'LineageMonster.batur_orc_shaman','11','16',44,'male','L2Monster',40,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,3379,232,'222.23112','173.43552','151.75505','115.475328468187',253,1,0,333,179,0,0,50,174,1,1,1,1),
(20588,20588,'Timak Orc Overlord',0,'',0,'LineageMonster.batur_orc_overlord','12','24',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,4441,308,'234.89829','177.78746','160.40508','118.372898457316',253,4,500,333,127,0,0,80,174,1,1,1,1),
(20589,20589,'Fline',0,'',0,'LineageMonster.sylph','11','35',45,'female','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,6639,462,'234.89829','177.78746','160.40508','118.372898457316',253,4,0,333,0,0,0,60,174,1,1,0,1),
(20590,20590,'Liele',0,'',0,'LineageMonster.undine','12','27',46,'female','L2Monster',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,20,6869,487,'248.0526','182.18816','169.38777','121.302932993263',253,4,0,333,0,0,0,60,174,1,1,0,1),
(20591,20591,'Valley Treant',0,'',0,'LineageMonster.ti_mi_tran','23','90',47,'male','L2Monster',40,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,10140,727,'261.69549','186.63569','178.7041','124.264149144103',253,4,0,333,0,0,0,12,12,1,1,0,1),
(20592,20592,'Satyr',0,'',0,'LineageMonster.pan','14','35',48,'male','L2Monster',40,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,11074,809,'275.82705','191.12803','188.35412','127.255200286259',253,4,500,333,291,0,0,45,174,1,1,0,1),
(20593,20593,'Unicorn',0,'',0,'LineageMonster.unicorn','14','30',49,'male','L2Monster',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,11880,878,'290.44588','195.66302','198.33688','130.274648808072',253,4,0,333,0,0,0,46,174,1,1,0,1),
(20594,20594,'Forest Runner',0,'',0,'LineageMonster.mandragora_b','12','25.5',50,'female','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,8116,611,'305.54906','200.23844','208.6504','133.321011603844',253,4,0,333,0,0,0,80,174,1,1,0,1),
(20595,20595,'Fline Elder',0,'',0,'LineageMonster.sylph','11','35',51,'female','L2Monster',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,20,8443,644,'321.13207','204.85194','219.29157','136.392732777413',253,4,0,333,0,0,0,60,174,1,1,0,1),
(20596,20596,'Liele Elder',0,'',0,'LineageMonster.undine','12','27',52,'female','L2Monster',40,'1520.38155','804','6.5','2.4',40,43,30,21,20,20,8953,692,'337.18867','209.50106','230.25615','139.488165444537',253,4,500,333,0,0,0,60,174,1,1,0,1),
(20597,20597,'Valley Treant Elder',0,'',0,'LineageMonster.ti_mi_tran','23','90',53,'male','L2Monster',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,18717,1471,'353.71092','214.18326','241.5387','142.605626325743',253,4,0,333,0,0,0,12,12,1,1,0,1),
(20598,20598,'Satyr Elder',0,'',0,'LineageMonster.pan','14','35',54,'male','L2Monster',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,13741,1096,'370.68904','218.89589','253.13256','145.743350252286',253,4,0,333,297,0,0,45,174,1,1,0,1),
(20599,20599,'Unicorn Elder',0,'',0,'LineageMonster.unicorn','14','30',55,'male','L2Monster',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,14255,1151,'388.11142','223.6362','265.02979','148.899508363765',253,4,0,333,0,0,0,46,174,1,1,0,1),
(20600,20600,'Karul Bugbear',0,'',0,'LineageMonster.bugbear','17','35',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,3290,212,'176.36077','156.55035','120.43155','104.232986928232',253,1,0,333,88,0,0,55,174,1,1,1,1),
(20601,20601,'Tamlin Orc',0,'',0,'LineageMonster.batur_orc','9','21.5',41,'male','L2Monster',40,'1008.23781','504.8','5.5','2.1',40,43,30,21,20,20,2934,192,'187.11878','160.69002','127.77787','106.989225133249',253,4,0,333,2,0,0,80,174,1,1,1,1),
(20602,20602,'Tamlin Orc Archer',0,'',0,'LineageMonster.batur_orc_archer','11','21.5',42,'male','L2Monster',1100,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,3970,264,'198.34591','164.88513','135.44454','109.782377202178',253,8,0,333,14,0,0,45,174,1,1,1,1),
(20603,20603,'Kronbe Spider',0,'',0,'LineageMonster.giant_spider','26','25.5',43,'male','L2Monster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,3259,221,'210.04832','169.13417','143.43577','112.611442266143',253,4,500,333,0,0,0,72,174,1,1,1,1),
(20604,20604,'Rakin',0,'',0,'LineageMonster.twin_headed_giant','17','39',44,'male','L2Monster',40,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,3981,272,'222.23112','173.43552','151.75505','115.475328468187',253,1,0,333,89,0,0,45,174,1,1,1,1),
(20605,20605,'Weird Drake',0,'',0,'LineageMonster.drake','30','100',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,3605,251,'234.89829','177.78746','160.40508','118.372898457316',253,4,500,333,0,0,0,70,174,1,1,1,1),
(20606,20606,'Kuran Kobold',0,'',0,'LineageMonster.kobold','10','15',27,'male','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,2282,116,'74.99121','108.28767','51.20928','72.0991544841329',253,4,0,333,0,0,0,47,110,1,1,0,1),
(20607,20607,'Kuran Kobold Warrior',0,'',0,'LineageMonster.kobold','10','15',28,'male','L2Monster',40,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,2415,127,'80.54056','111.61368','54.99876','74.3136496629463',253,4,0,333,0,0,0,47,110,1,1,0,1),
(20608,20608,'Patin Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',29,'male','L2Monster',1100,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,2454,132,'86.42002','115.00598','59.01367','76.5722740603874',253,8,500,333,14,0,0,40,140,1,1,0,1),
(20609,20609,'Rakin Salamander',0,'',0,'LineageMonster.salamander','16','6.8',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,2566,140,'92.64226','118.46427','63.26266','78.8748547991048',253,1,0,333,0,0,0,64,96,1,1,0,1),
(20610,20610,'Sentinel Of Water',0,'',0,'LineageMonster.monster_eye','21','43',31,'male','L2Monster',40,'635.76437','343.8','4.5','1.8',40,43,30,21,20,20,2600,144,'99.21986','121.98819','67.7543','81.2211098160515',253,4,0,333,0,0,0,90,90,1,1,0,1),
(20611,20611,'Dre Vanul Warrior',0,'',0,'LineageMonster.dre_vanul','14','36',32,'male','L2Monster',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,2770,156,'106.16525','125.57727','72.49711','83.6107570481808',253,4,0,333,0,0,0,80,80,1,1,0,1),
(20612,20612,'Salamander Rowin',0,'',0,'LineageMonster.salamander','16','6.8',33,'male','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,3166,181,'113.49065','129.23095','77.49941','86.043423444366',253,1,500,333,0,0,0,64,96,1,1,0,1),
(20613,20613,'Lafi Lizardman',0,'',0,'LineageMonster.virud_lizardman','10','23',27,'male','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,2282,116,'74.99121','108.28767','51.20928','72.0991544841329',253,4,0,333,291,0,0,43,130,1,1,0,1),
(20614,20614,'Lafi Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman_scout','10','22',28,'male','L2Monster',1100,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,2257,119,'80.54056','111.61368','54.99876','74.3136496629463',253,8,0,333,2507,0,0,43,130,1,1,0,1),
(20615,20615,'Ritmal Swordsman',0,'',0,'LineageMonster.spartoi','11','27',29,'male','L2Monster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,2626,140,'86.42002','115.00598','59.01367','76.5722740603874',253,4,500,333,73,0,0,60,140,1,1,0,1),
(20616,20616,'Rakin Undine',0,'',0,'LineageMonster.undine','12','27',30,'female','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,3443,188,'92.64226','118.46427','63.26266','78.8748547991048',253,1,0,333,0,0,0,60,60,1,1,0,1),
(20617,20617,'Sentinel Of Water',0,'',0,'LineageMonster.magical_weaver','11','20',31,'male','L2Monster',40,'635.76437','343.8','4.5','1.8',40,43,30,21,20,20,2625,145,'99.21986','121.98819','67.7543','81.2211098160515',253,4,0,333,0,0,0,90,90,1,1,0,1),
(20618,20618,'Kanil Succubus',0,'',0,'LineageMonster.succubus','10','36',32,'female','L2Monster',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,2919,164,'106.16525','125.57727','72.49711','83.6107570481808',253,4,0,333,0,0,0,60,100,1,1,0,1),
(20619,20619,'Rowin Undine',0,'',0,'LineageMonster.undine','12','27',33,'female','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,3005,173,'113.49065','129.23095','77.49941','86.043423444366',253,1,500,333,0,0,0,60,60,1,1,0,1),
(20620,20620,'Cave Beast',0,'',0,'LineageMonster.troll','21','35',61,'male','L2Monster',40,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,15494,1363,'501.08068','252.49346','342.17315','168.112997103103',253,4,500,333,0,0,0,55,174,1,1,0,1),
(20621,20621,'Death Wave',0,'',0,'LineageMonster.will_o_wisp','13','22',62,'male','L2Monster',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,16701,1488,'521.12391','257.34267','355.86007','171.341654516443',253,4,500,333,0,0,0,80,174,1,1,0,1),
(20622,20622,'Malruk Soldier',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',63,'male','L2Monster',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,17833,1610,'541.44774','262.19426','369.73862','174.571895122369',253,8,500,333,221,0,0,80,174,1,1,0,1),
(20623,20623,'Plando',0,'',0,'LineageMonster.virud_lizardman_scout','10','22',64,'male','L2Monster',1100,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,23778,2177,'562.02275','267.04468','383.78868','177.801362329617',253,8,500,333,2507,0,0,43,174,1,1,0,1),
(20624,20624,'Cave Howler',0,'',0,'LineageMonster.twin_headed_giant','17','39',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,24178,2246,'582.81759','271.89033','397.98887','181.027644954078',253,4,500,333,0,0,0,45,174,1,1,0,1),
(20625,20625,'Malruk Knight',0,'',0,'LineageMonster.skeleton_knight','10','25',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,24146,2273,'603.79903','276.72752','412.31647','184.248304515217',253,4,500,333,78,0,0,40,174,1,1,0,1),
(20626,20626,'Malruk Berserker',0,'',0,'LineageMonster.death_knight','12','31',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,34656,3300,'624.93199','281.55251','426.74754','187.460838840844',253,4,500,333,77,0,0,27,174,1,1,0,1),
(20627,20627,'Malruk Lord',0,'',0,'LineageMonster.death_blader','15','45',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,29789,2878,'646.17968','286.3615','441.25696','190.662718462344',253,4,500,333,1472,0,0,100,174,1,1,0,1),
(20628,20628,'Limal Karinness',0,'',0,'LineageMonster.bloody_queen','14','40',69,'female','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,32098,3140,'667.50361','291.15063','455.81844','193.851368417065',253,4,500,333,0,0,0,80,174,1,1,0,1),
(20629,20629,'Karik',0,'',0,'LineageMonster.karik','25','90',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,39507,3917,'688.86373','295.91597','470.40463','197.024195544734',253,4,500,333,0,0,0,37,174,1,1,0,1),
(20630,20630,'Taik Orc',0,'',0,'LineageMonster.ketra_orc','12','29',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,2792,180,'176.36077','156.55035','120.43155','104.232986928232',253,4,0,333,127,0,0,45,174,1,1,1,1),
(20631,20631,'Taik Orc Archer',0,'',0,'LineageMonster.ketra_orc_archer','12','27',41,'male','L2Monster',1100,'1008.23781','504.8','5.5','2.1',40,43,30,21,20,20,3783,247,'187.11878','160.69002','127.77787','106.989225133249',253,8,0,333,14,0,0,45,174,1,1,1,1),
(20632,20632,'Taik Orc Warrior',0,'',0,'LineageMonster.ketra_orc_warrior','12','24',42,'male','L2Monster',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,3774,251,'198.34591','164.88513','135.44454','109.782377202178',253,4,500,333,75,0,0,36,174,1,1,1,1),
(20633,20633,'Taik Orc Shaman',0,'',0,'LineageMonster.ketra_orc_shaman','10','23',43,'male','L2Monster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,3682,248,'210.04832','169.13417','143.43577','112.611442266143',253,1,0,333,9,0,0,10,174,1,1,1,1),
(20634,20634,'Taik Orc Captain',0,'',0,'LineageMonster.ketra_orc_warrior','12','24',44,'male','L2Monster',40,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,7065,484,'222.23112','173.43552','151.75505','115.475328468187',253,4,500,333,75,104,0,36,174,1,1,1,1),
(20635,20635,'Carinkain',0,'',0,'LineageMonster.mana_vampire','11','20',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,3569,248,'234.89829','177.78746','160.40508','118.372898457316',253,4,500,333,0,0,0,90,174,1,1,1,1),
(20636,20636,'Forest of Mirrors Ghost',0,'',0,'LineageMonster.dwarf_ghost','9','16.5',46,'male','L2Monster',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,20,3973,282,'248.0526','182.18816','169.38777','121.302932993263',253,4,500,333,0,0,0,80,174,1,1,1,1),
(20637,20637,'Forest of Mirrors Ghost',0,'',0,'LineageMonster.elf_ghost','7','21',47,'male','L2Monster',40,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,4148,298,'261.69549','186.63569','178.7041','124.264149144103',253,4,500,333,0,0,0,80,174,1,1,1,1),
(20638,20638,'Forest of Mirrors Ghost',0,'',0,'LineageMonster.human_ghost','8','22',48,'male','L2Monster',40,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,4326,316,'275.82705','191.12803','188.35412','127.255200286259',253,4,500,333,0,0,0,80,174,1,1,1,1),
(20639,20639,'Mirror',0,'',0,'LineageMonster.mirror','26','52',49,'male','L2Monster',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,10210,755,'290.44588','195.66302','198.33688','130.274648808072',253,4,0,333,0,0,0,80,174,1,1,1,1),
(20640,20640,'Harit Lizardman',0,'',0,'LineageMonster.zenta_lizardman','11','32',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,4363,329,'305.54906','200.23844','208.6504','133.321011603844',253,1,0,333,88,945,0,37,174,1,1,1,1),
(20641,20641,'Harit Lizardman Grunt',0,'',0,'LineageMonster.zenta_lizardman','11','32',51,'male','L2Monster',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,20,5402,412,'321.13207','204.85194','219.29157','136.392732777413',253,4,0,333,70,0,0,37,174,1,1,1,1),
(20642,20642,'Harit Lizardman Archer',0,'',0,'LineageMonster.zenta_lizardman_scout','11','30',52,'male','L2Monster',1100,'1520.38155','804','6.5','2.4',40,43,30,21,20,20,5057,391,'337.18867','209.50106','230.25615','139.488165444537',253,8,500,333,14,0,0,37,174,1,1,1,1),
(20643,20643,'Harit Lizardman Warrior',0,'',0,'LineageMonster.zenta_lizardman_warrior','13','35',53,'male','L2Monster',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,5199,409,'353.71092','214.18326','241.5387','142.605626325743',253,4,0,333,291,0,0,40,174,1,1,1,1),
(20644,20644,'Harit Lizardman Shaman',0,'',0,'LineageMonster.zenta_lizardman_shaman','13','35',54,'male','L2Monster',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,5089,406,'370.68904','218.89589','253.13256','145.743350252286',253,1,0,333,9,0,0,43,174,1,1,1,1),
(20645,20645,'Harit Lizardman Matriarch',0,'',0,'LineageMonster.zenta_lizardman_matriarch','20','40',55,'male','L2Monster',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,11444,924,'388.11142','223.6362','265.02979','148.899508363765',253,4,500,333,221,0,0,53,174,1,1,1,1),
(20646,20646,'Halingka',0,'',0,'LineageMonster.saber_toothed_tiger','34','28',55,'male','L2Monster',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,8623,696,'388.11142','223.6362','265.02979','148.899508363765',253,1,0,333,0,0,0,60,170,1,1,0,1),
(20647,20647,'Yintzu',0,'',0,'LineageMonster.field_stalker','15','30',56,'male','L2Monster',40,'1724.6831','918.8','6.5','2.4',40,43,30,21,20,20,8653,710,'405.96455','228.40135','277.22116','152.072199009316',253,1,500,333,0,0,0,70,110,1,1,0,1),
(20648,20648,'Paliote',0,'',0,'LineageMonster.will_o_wisp','13','22',57,'male','L2Monster',40,'1776.58018','948','6.5','2.4',40,43,30,21,20,20,9826,816,'424.23295','233.18839','289.69611','155.259456846417',253,1,0,333,0,0,0,80,140,1,1,0,1),
(20649,20649,'Hamrut',0,'',0,'LineageMonster.poison_spider','27','25.5',58,'male','L2Monster',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,20,9781,827,'442.8992','237.99429','302.44274','158.459289236126',253,1,500,333,0,0,0,60,140,1,1,0,1),
(20650,20650,'Kranrot',0,'',0,'LineageMonster.crimson_bear','19','36',59,'male','L2Monster',40,'1880.92519','1007','6.5','2.4',40,43,30,21,20,20,10586,905,'461.94387','242.81593','315.44778','161.669585254993',253,1,500,333,0,0,0,37,170,1,1,0,1),
(20651,20651,'Gamlin',0,'',0,'LineageMonster.gamlin','11','32',60,'male','L2Monster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,9835,853,'481.34551','247.65008','328.69659','164.888215781956',253,1,0,333,0,0,0,80,170,1,1,0,1),
(20652,20652,'Leogul',0,'',0,'LineageMonster.leogul','15','35',61,'male','L2Monster',40,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,10369,913,'501.08068','252.49346','342.17315','168.112997103103',253,1,500,333,0,0,0,80,170,1,1,0,1),
(20653,20653,'Lesser Giant',0,'',0,'LineageMonster.lesser_giant','21','44',61,'male','L2Monster',40,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,14612,1286,'501.08068','252.49346','342.17315','168.112997103103',253,1,0,333,3937,0,0,15,180,1,1,0,1),
(20654,20654,'Lesser Giant Soldier',0,'',0,'LineageMonster.lesser_giant','21','44',62,'male','L2Monster',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,22406,1997,'521.12391','257.34267','355.86007','171.341654516443',253,1,0,333,3937,0,0,15,180,1,1,0,1),
(20655,20655,'Lesser Giant Shooter',0,'',0,'LineageMonster.lesser_giant_shooter','21','44',63,'male','L2Monster',1100,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,18307,1652,'541.44774','262.19426','369.73862','174.571895122369',253,8,500,333,4028,0,0,80,180,1,1,0,1),
(20656,20656,'Lesser Giant Scout',0,'',0,'LineageMonster.lesser_giant_shooter','21','44',63,'male','L2Monster',1100,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,16702,1508,'541.44774','262.19426','369.73862','174.571895122369',253,8,500,333,4028,0,0,80,180,1,1,0,1),
(20657,20657,'Lesser Giant Mage',0,'',0,'LineageMonster.lesser_giant_mage','21','44',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,13228,1211,'562.02275','267.04468','383.78868','177.801362329617',253,1,0,333,3938,0,0,15,180,1,1,0,1),
(20658,20658,'Lesser Giant Elder',0,'',0,'LineageMonster.lesser_giant_mage','21','44',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,12778,1187,'582.81759','271.89033','397.98887','181.027644954078',253,1,0,333,3938,0,0,15,180,1,1,0,1),
(20659,20659,'Grave Wanderer',0,'',0,'LineageMonster.zombie','13','21',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,4948,344,'234.89829','177.78746','160.40508','118.372898457316',253,4,0,333,0,0,0,15,15,1,1,1,1),
(20660,20660,'Archer of Greed',0,'',0,'LineageMonster.skeleton_archer','11','27',46,'male','L2Monster',1100,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,20,4858,344,'248.0526','182.18816','169.38777','121.302932993263',253,8,500,333,14,0,0,40,174,1,1,1,1),
(20661,20661,'Hatar Ratman Thief',0,'',0,'LineageMonster.wererat','14','25',47,'male','L2Monster',40,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,4588,329,'261.69549','186.63569','178.7041','124.264149144103',253,8,0,333,946,0,0,80,174,1,1,1,1),
(20662,20662,'Hatar Ratman Boss',0,'',0,'LineageMonster.wererat','14','25',48,'male','L2Monster',40,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,4785,349,'275.82705','191.12803','188.35412','127.255200286259',253,8,0,333,221,0,0,80,174,1,1,1,1),
(20663,20663,'Hatar Hanishee',0,'',0,'LineageMonster.medusa','10','25',49,'female','L2Monster',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,4190,310,'290.44588','195.66302','198.33688','130.274648808072',253,4,0,333,0,0,0,50,174,1,1,1,1),
(20664,20664,'Deprive',0,'',0,'LineageMonster.field_stalker','15','30',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,4406,332,'305.54906','200.23844','208.6504','133.321011603844',253,4,500,333,0,0,0,70,174,1,1,1,1),
(20665,20665,'Taik Orc Supply',0,'',0,'LineageMonster.ketra_orc','12','29',51,'male','L2Monster',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,20,5402,412,'321.13207','204.85194','219.29157','136.392732777413',253,4,0,333,69,0,0,45,174,1,1,1,1),
(20666,20666,'Taik Orc Seeker',0,'',0,'LineageMonster.ketra_orc','12','29',52,'male','L2Monster',40,'1520.38155','804','6.5','2.4',40,43,30,21,20,20,5616,434,'337.18867','209.50106','230.25615','139.488165444537',253,4,0,333,72,0,0,45,174,1,1,0,1),
(20667,20667,'Farcran',0,'',0,'LineageMonster.crimson_bear','19','36',53,'male','L2Monster',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,5776,454,'353.71092','214.18326','241.5387','142.605626325743',253,4,0,333,0,0,0,37,174,1,1,1,1),
(20668,20668,'Grave Guard',0,'',0,'LineageMonster.gargoyle','16','50',54,'male','L2Monster',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,5140,409,'370.68904','218.89589','253.13256','145.743350252286',253,4,500,333,0,0,0,140,174,1,1,0,1),
(20669,20669,'Taik Orc Supply Leader',0,'',0,'LineageMonster.ketra_orc_warrior','12','24',55,'male','L2Monster',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,6408,517,'388.11142','223.6362','265.02979','148.899508363765',253,4,500,333,75,0,0,36,174,1,1,0,1),
(20670,20670,'Crimson Drake',0,'',0,'LineageMonster.drake','30','100',61,'male','L2Monster',40,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,6558,577,'501.08068','252.49346','342.17315','168.112997103103',253,4,200,333,0,0,0,70,174,1,1,0,1),
(20671,20671,'Kadios',0,'',0,'LineageMonster.devastator','35','35',62,'male','L2Monster',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,6843,610,'521.12391','257.34267','355.86007','171.341654516443',253,4,200,333,0,0,0,25,174,1,1,0,1),
(20672,20672,'Trives',0,'',0,'LineageMonster.serpent_slave','17','46',63,'male','L2Monster',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,6927,625,'541.44774','262.19426','369.73862','174.571895122369',253,4,0,333,127,0,0,70,174,1,1,0,1),
(20673,20673,'Falibati',0,'',0,'LineageMonster.cave_maiden','25','65',64,'female','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,7219,661,'562.02275','267.04468','383.78868','177.801362329617',253,4,300,333,73,0,0,70,174,1,1,0,1),
(20674,20674,'Doom Knight',0,'',0,'LineageMonster.death_blader','15','45',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,10379,965,'582.81759','271.89033','397.98887','181.027644954078',253,4,300,333,1472,0,0,100,174,1,1,0,1),
(20675,20675,'Tairim',0,'',0,'LineageMonster.will_o_wisp','13','22',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,4581,346,'305.54906','200.23844','208.6504','133.321011603844',253,4,0,333,0,0,0,80,174,1,1,0,1),
(20676,20676,'Judge of Marsh',0,'',0,'LineageMonster.hanged_man_ripper','35','80',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,7447,692,'582.81759','271.89033','397.98887','181.027644954078',253,4,500,333,0,0,0,55,174,1,1,1,1),
(20677,20677,'Tulben',0,'',0,'LineageMonster.vampire_bat','10','33.5',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,8363,787,'603.79903','276.72752','412.31647','184.248304515217',253,4,0,333,0,0,0,60,174,1,1,1,1),
(20678,20678,'Tortured Undead',0,'',0,'LineageMonster.hungry_spirit','30','40',53,'male','L2Monster',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,4902,385,'353.71092','214.18326','241.5387','142.605626325743',253,4,0,333,0,0,0,15,174,1,1,0,1),
(20679,20679,'Marsh Stalker',0,'',0,'LineageMonster.gargoyle','16','50',54,'male','L2Monster',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,5039,402,'370.68904','218.89589','253.13256','145.743350252286',253,4,0,333,0,0,0,140,174,1,1,1,1),
(20680,20680,'Marsh Drake',0,'',0,'LineageMonster.drake','30','100',55,'male','L2Monster',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,5332,431,'388.11142','223.6362','265.02979','148.899508363765',253,4,500,333,0,0,0,70,174,1,1,1,1),
(20681,20681,'Vanor Silenos',0,'',0,'LineageMonster.heltor_silenos','13','29',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,3711,258,'234.89829','177.78746','160.40508','118.372898457316',253,1,0,333,88,0,0,34,174,1,1,1,1),
(20682,20682,'Vanor Silenos Grunt',0,'',0,'LineageMonster.heltor_silenos','13','29',46,'male','L2Monster',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,20,3693,262,'248.0526','182.18816','169.38777','121.302932993263',253,1,0,333,158,18,0,34,174,1,1,1,1),
(20683,20683,'Vanor Silenos Scout',0,'',0,'LineageMonster.heltor_silenos','13','29',47,'male','L2Monster',40,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,4805,344,'261.69549','186.63569','178.7041','124.264149144103',253,1,500,333,5,0,0,34,174,1,1,1,1),
(20684,20684,'Vanor Silenos Warrior',0,'',0,'LineageMonster.heltor_silenos_warrior','13','31',48,'male','L2Monster',40,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,5026,367,'275.82705','191.12803','188.35412','127.255200286259',253,1,0,333,160,0,0,36,174,1,1,1,1),
(20685,20685,'Vanor Silenos Shaman',0,'',0,'LineageMonster.heltor_silenos_shaman','13','32',49,'male','L2Monster',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,4190,310,'290.44588','195.66302','198.33688','130.274648808072',253,1,0,333,9,0,0,29,174,1,1,1,1),
(20686,20686,'Vanor Silenos Chieftain',0,'',0,'LineageMonster.heltor_silenos_chieftain','13','31.5',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,8731,658,'305.54906','200.23844','208.6504','133.321011603844',253,4,0,333,75,0,0,27,174,1,1,1,1),
(20738,20738,'Kobold Looter Bepook',0,'',0,'LineageMonster.kobold_bi','15','24',13,'male','L2Monster',40,'214.61578','132.64','2.5','1.2',40,43,30,21,20,20,1326,52,'25.04271','68.67458','17.10092','45.7243124542497',253,1,500,333,4,0,0,47,110,1,1,0,1),
(20739,20739,'Bepook\'s Pet',0,'',0,'LineageMonster.wolf','13','9',10,'male','L2Monster',40,'163.28607','108.4','2','0.9',40,43,30,21,20,20,220,7,'19.33758','61.82527','13.20506','41.16396260604',253,1,0,333,0,0,0,24,110,1,1,0,1),
(20742,20742,'Mystical Weaver',0,'',0,'LineageMonster.magical_weaver','11','20',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,821,38,'51.75278','92.65694','35.34044','61.6920289224665',253,4,0,333,0,0,0,90,90,1,1,0,1),
(20743,20743,'Howler',0,'',0,'LineageMonster.werewolf','10','26',25,'male','L2Monster',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,1012,50,'64.83203','101.83533','44.27187','67.8031159084826',253,4,500,333,0,0,0,50,120,1,1,0,1),
(20744,20744,'Red Eye Vampire Bat',0,'',0,'LineageMonster.vampire_bat','10','33.5',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,821,38,'51.75278','92.65694','35.34044','61.6920289224665',253,4,0,333,0,0,0,60,80,1,1,0,1),
(20745,20745,'Gigantiops',0,'',0,'LineageMonster.ant_soldier','35','17',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,3218,191,'129.32896','136.72948','88.31491','91.0360303625432',253,4,500,333,0,0,0,80,174,1,1,0,1),
(20746,20746,'Young Gigantiops',0,'',0,'LineageMonster.ant','26','15',31,'male','L2Monster',40,'635.76437','343.8','4.5','1.8',40,43,30,21,20,20,2475,137,'99.21986','121.98819','67.7543','81.2211098160515',253,4,0,333,0,0,0,40,139,1,1,0,1),
(20747,20747,'Roxide',0,'',0,'LineageMonster.succubus','10','36',32,'female','L2Monster',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,3504,197,'106.16525','125.57727','72.49711','83.6107570481808',253,4,500,333,0,0,0,60,159,1,1,0,1),
(20748,20748,'Roxide Cohort',0,'',0,'LineageMonster.spartoi','11','27',29,'male','L2Monster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,3240,174,'86.42002','115.00598','59.01367','76.5722740603874',253,4,0,333,73,0,0,60,159,1,1,0,1),
(20749,20749,'Death Fire',0,'',0,'LineageMonster.dre_vanul','14','36',32,'male','L2Monster',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,3504,197,'106.16525','125.57727','72.49711','83.6107570481808',253,4,500,333,0,0,0,80,159,1,1,0,1),
(20750,20750,'Fire Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',29,'male','L2Monster',1100,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,3354,180,'86.42002','115.00598','59.01367','76.5722740603874',253,8,0,333,14,0,0,40,159,1,1,0,1),
(20751,20751,'Snipe',0,'',0,'LineageMonster.onyx_beast','14','14.5',44,'male','L2Monster',40,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,13373,880,'222.23112','173.43552','151.75505','126.91259',253,4,0,333,0,0,0,30,120,1,1,0,1),
(20752,20752,'Snipe Cohort',0,'',0,'LineageMonster.onyx_beast','14','14.5',42,'male','L2Monster',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,7085,451,'198.34591','164.88513','135.44454','120.65578',253,4,0,333,0,0,0,30,120,1,1,0,1),
(20753,20753,'Dark Lord',0,'',0,'LineageMonster.death_blader','15','45',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,11417,826,'305.54906','200.23844','208.6504','146.5258',253,4,500,333,1472,0,0,100,170,1,1,0,1),
(20754,20754,'Dark Knight',0,'',0,'LineageMonster.death_knight','12','31',48,'male','L2Monster',40,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,12549,887,'275.82705','191.12803','188.35412','139.8592',253,4,0,333,127,0,0,27,110,1,1,0,1),
(20755,20755,'Talakin',0,'',0,'LineageMonster.ol_mahum_champion','14','27',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,2364,130,'92.64226','118.46427','63.26266','78.8748547991048',253,4,500,333,2,0,0,50,133,1,1,0,1),
(20756,20756,'Talakin Archer',0,'',0,'LineageMonster.ol_mahum_archer','14','25',28,'male','L2Monster',1100,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,2261,119,'80.54056','111.61368','54.99876','74.3136496629463',253,8,0,333,14,0,0,50,133,1,1,0,1),
(20757,20757,'Talakin Raider',0,'',0,'LineageMonster.ol_mahum','13.5','25',27,'male','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,1657,85,'74.99121','108.28767','51.20928','72.0991544841329',253,4,0,333,3,0,0,50,133,1,1,0,1),
(20758,20758,'Dragon Bearer Chief',0,'',0,'LineageMonster.spartoi','11','27',49,'male','L2Monster',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,6307,467,'290.44588','195.66302','198.33688','130.274648808072',253,4,500,333,123,945,0,60,174,1,1,0,1),
(20759,20759,'Dragon Bearer Warrior',0,'',0,'LineageMonster.skeleton','11','25',48,'male','L2Monster',40,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,5934,433,'275.82705','191.12803','188.35412','127.255200286259',253,4,0,333,2,945,0,60,174,1,1,0,1),
(20760,20760,'Dragon Bearer Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',47,'male','L2Monster',1100,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,6165,442,'261.69549','186.63569','178.7041','124.264149144103',253,8,0,333,14,0,0,40,174,1,1,0,1),
(20761,20761,'Pytan',0,'',0,'LineageMonster.bloody_queen','14','40',69,'female','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,23881,2336,'667.50361','291.15063','455.81844','193.851368417065',253,4,500,333,0,0,0,80,174,1,1,0,1),
(20762,20762,'Pytan Knight',0,'',0,'LineageMonster.death_blader','15','45',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,16852,1628,'646.17968','286.3615','441.25696','190.662718462344',253,4,0,333,1472,0,0,100,174,1,1,0,1),
(20763,20763,'Lord of the Plains',0,'',0,'LineageMonster.zenta_lizardman_matriarch','20','40',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,4644,300,'176.36077','156.55035','120.43155','104.232986928232',253,8,500,333,221,0,0,53,174,1,1,0,1),
(20764,20764,'Shaman of the Plains',0,'',0,'LineageMonster.zenta_lizardman_shaman','13','35',39,'male','L2Monster',40,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,4150,264,'166.06476','152.46752','113.4007','101.514599764346',253,1,0,333,179,0,0,43,174,1,1,0,1),
(20765,20765,'Warrior of the Plains',0,'',0,'LineageMonster.zenta_lizardman_warrior','13','35',38,'male','L2Monster',40,'886.09975','447.96','4.5','1.8',40,43,30,21,20,20,3591,224,'156.22273','148.44287','106.67987','98.8349371271581',253,4,0,333,16,0,0,40,174,1,1,0,1),
(20766,20766,'Scout of the Plains',0,'',0,'LineageMonster.zenta_lizardman_scout','11','30',36,'male','L2Monster',1100,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,3192,193,'137.86467','140.57278','94.1437','93.5949427192352',253,8,0,333,14,0,0,37,174,1,1,0,1),
(20767,20767,'Timak Orc Troop Leader',0,'',0,'LineageMonster.batur_orc_overlord','12','24',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,5762,401,'234.89829','177.78746','160.40508','118.372898457316',253,4,0,333,79,0,0,80,174,1,1,0,1),
(20768,20768,'Timak Orc Troop Shaman',0,'',0,'LineageMonster.batur_orc_shaman','11','16',44,'male','L2Monster',40,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,5559,380,'222.23112','173.43552','151.75505','115.475328468187',253,1,0,333,7,0,0,50,174,1,1,0,1),
(20769,20769,'Timak Orc Troop Warrior',0,'',0,'LineageMonster.batur_orc_warrior','10','20',43,'male','L2Monster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,4421,299,'210.04832','169.13417','143.43577','112.611442266143',253,4,0,333,123,19,0,80,174,1,1,0,1),
(20770,20770,'Timak Orc Troop Archer',0,'',0,'LineageMonster.batur_orc_archer','11','21.5',41,'male','L2Monster',1100,'1008.23781','504.8','5.5','2.1',40,43,30,21,20,20,5183,340,'187.11878','160.69002','127.77787','106.989225133249',253,8,0,333,13,0,0,45,174,1,1,0,1),
(20771,20771,'Barif',0,'',0,'LineageMonster.lesser_giant_mage','21','44',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,15637,1432,'562.02275','267.04468','383.78868','177.801362329617',253,1,500,333,3938,0,0,15,180,1,1,0,1),
(20772,20772,'Barif\'s Pet',0,'',0,'LineageMonster.leogul','15','35',61,'male','L2Monster',40,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,15199,1338,'501.08068','252.49346','342.17315','168.112997103103',253,1,0,333,0,0,0,80,170,1,1,0,1),
(20773,20773,'Conjurer Bat Lord',0,'',0,'LineageMonster.vampire_bat','10','33.5',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,12643,1284,'731.52506','305.35947','499.53679','203.311781207645',253,4,500,333,0,0,0,60,174,1,1,0,1),
(20774,20774,'Conjurer Bat',0,'',0,'LineageMonster.vampire_bat','10','33.5',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,13368,1326,'688.86373','295.91597','470.40463','197.024195544734',253,4,0,333,0,0,0,60,174,1,1,0,1),
(20775,20775,'Bugbear Raider',0,'',0,'LineageMonster.bugbear','17','35',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,600,25,'34.8979','78.68469','23.83074','52.3891528929827',253,4,0,333,0,0,0,55,130,1,1,1,1),
(20776,20776,'Dark Succubus',0,'',0,'LineageMonster.succubus','10','36',20,'female','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,784,35,'44.32863','86.87049','30.2707','57.8393570613084',253,4,0,333,0,0,0,60,100,1,1,1,1),
(20777,20777,'Hunter Bear',0,'',0,'LineageMonster.grizzly','21','40',14,'male','L2Monster',40,'230.38548','140.88','2.5','1.2',40,43,30,21,20,20,499,19,'27.24646','71.08179','18.6058','47.3270583783809',253,4,0,333,0,0,0,40,110,1,1,1,1),
(20778,20778,'Ragna Orc Overlord',0,'',0,'LineageMonster.orc_champion','10','23',39,'male','L2Monster',40,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,2973,188,'166.06476','152.46752','113.4007','101.514599764346',253,4,0,333,2,0,0,45,174,1,1,0,1),
(20779,20779,'Ragna Orc Seer',0,'',0,'LineageMonster.orc_shaman','9','22',39,'male','L2Monster',40,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,2655,169,'166.06476','152.46752','113.4007','101.514599764346',253,1,0,333,7,0,0,45,174,1,1,0,1),
(20780,20780,'Bloody Axe Elite',0,'',0,'LineageMonster.ol_mahum_champion','14','27',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,2159,127,'129.32896','136.72948','88.31491','91.0360303625432',253,4,500,333,2,0,0,50,174,1,1,1,1),
(20781,20781,'Delu Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman','10','29',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,2138,126,'129.32896','136.72948','88.31491','91.0360303625432',253,1,0,333,7,0,0,43,174,1,1,1,1),
(20782,20782,'Ol Mahum Novice',0,'',0,'LineageMonster.ol_mahum','13.5','25',17,'male','L2Monster',40,'282.57403','166.08','2.5','1.2',40,43,30,21,20,20,618,26,'34.8979','78.68469','23.83074','52.3891528929827',253,4,500,333,1,0,0,50,110,1,1,1,1),
(20783,20783,'Dread Wolf',0,'',0,'LineageMonster.dire_wolf','13','11',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,981,58,'129.32896','136.72948','88.31491','91.0360303625432',253,4,500,333,0,0,0,24,140,1,1,1,1),
(20784,20784,'Tasaba Lizardman',0,'',0,'LineageMonster.virud_lizardman_scout','10','22',36,'male','L2Monster',1100,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,1111,67,'137.86467','140.57278','94.1437','93.5949427192352',253,8,0,333,2507,0,0,43,140,1,1,1,1),
(20785,20785,'Tasaba Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman','10','29',37,'male','L2Monster',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,20,1075,66,'146.82587','144.47758','100.26304','96.1948088105753',253,1,0,333,7,0,0,43,140,1,1,1,1),
(20786,20786,'Lienrik',0,'',0,'LineageMonster.lienrik','12','50',39,'male','L2Monster',40,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,1195,76,'166.06476','152.46752','113.4007','101.514599764346',253,8,0,333,0,0,0,100,150,1,1,1,1),
(20787,20787,'Lienrik Lad',0,'',0,'LineageMonster.lienrik','12','50',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,1453,94,'176.36077','156.55035','120.43155','104.232986928232',253,8,500,333,0,0,0,100,174,1,1,1,1),
(20788,20788,'Rakul',0,'',0,'LineageMonster.rakul','30','39',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,2544,150,'129.32896','136.72948','88.31491','91.0360303625432',253,4,0,333,3,0,0,60,174,1,1,1,1),
(20789,20789,'Crokian',0,'',0,'LineageMonster.crokian','18','29',36,'male','L2Monster',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,2399,145,'137.86467','140.57278','94.1437','93.5949427192352',253,4,500,333,5128,0,0,18,174,1,1,1,1),
(20790,20790,'Dailaon',0,'',0,'LineageMonster.dailaon','20','28',37,'male','L2Monster',1100,'847.31754','432.72','4.5','1.8',40,43,30,21,20,20,3081,190,'146.82587','144.47758','100.26304','96.1948088105753',253,8,0,333,5127,0,0,18,174,1,1,1,1),
(20791,20791,'Crokian Warrior',0,'',0,'LineageMonster.crokian','18','29',38,'male','L2Monster',40,'886.09975','447.96','4.5','1.8',40,43,30,21,20,20,5307,331,'156.22273','148.44287','106.67987','98.8349371271581',253,4,500,333,5128,0,0,18,174,1,1,1,1),
(20792,20792,'Farhite',0,'',0,'LineageMonster.farhite','16','31',39,'male','L2Monster',40,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,4938,314,'166.06476','152.46752','113.4007','101.514599764346',253,1,0,333,5131,0,0,15,174,1,1,1,1),
(20793,20793,'Nos',0,'',0,'LineageMonster.nos','26','42',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,5404,349,'176.36077','156.55035','120.43155','104.232986928232',253,4,500,333,5130,0,0,18,174,1,1,1,1),
(20794,20794,'Blade Stakato',0,'',0,'LineageMonster.blade_stakato','15','36',41,'male','L2Monster',40,'1008.23781','504.8','5.5','2.1',40,43,30,21,20,20,5048,330,'187.11878','160.69002','127.77787','106.989225133249',253,4,0,333,223,0,0,25,174,1,1,0,1),
(20795,20795,'Blade Stakato Worker',0,'',0,'LineageMonster.blade_stakato_worker','13','40',42,'male','L2Monster',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,4772,318,'198.34591','164.88513','135.44454','109.782377202178',253,8,0,333,226,0,0,25,174,1,1,0,1),
(20796,20796,'Blade Stakato Warrior',0,'',0,'LineageMonster.blade_stakato_soldier','15','38',43,'male','L2Monster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,5102,344,'210.04832','169.13417','143.43577','112.611442266143',253,1,500,333,232,0,0,25,174,1,1,0,1),
(20797,20797,'Blade Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone','15','39',44,'male','L2Monster',40,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,7754,530,'222.23112','173.43552','151.75505','115.475328468187',253,4,0,333,74,0,0,25,174,1,1,0,1),
(20798,20798,'Water Giant',0,'',0,'LineageMonster.water_giant','13','44',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,6270,436,'234.89829','177.78746','160.40508','118.372898457316',253,4,500,333,5132,0,0,35,174,1,1,0,1),
(20799,20799,'Queen Undine Lad',0,'',0,'LineageMonster.undine','12','27',46,'female','L2Monster',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,20,6312,448,'248.0526','182.18816','169.38777','121.302932993263',253,4,0,333,0,0,0,60,174,1,1,0,1),
(20800,20800,'Eva\'s Seeker',0,'',0,'LineageMonster.field_stalker','15','30',47,'male','L2Monster',40,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,5917,424,'261.69549','186.63569','178.7041','124.264149144103',253,4,0,333,0,0,0,70,174,1,1,0,1),
(20801,20801,'Theeder Piker',0,'',0,'LineageMonster.theeder','9','32',48,'male','L2Monster',80,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,7134,521,'275.82705','191.12803','188.35412','127.255200286259',253,4,500,333,302,0,0,80,174,1,1,0,1),
(20802,20802,'Theeder Mage',0,'',0,'LineageMonster.theeder','9','32',49,'male','L2Monster',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,7262,536,'290.44588','195.66302','198.33688','130.274648808072',253,1,0,333,192,0,0,80,174,1,1,0,1),
(20803,20803,'Doll Master',0,'',0,'LineageMonster.doll_master','20','42',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,14218,1072,'305.54906','200.23844','208.6504','133.321011603844',253,4,500,333,0,0,0,80,174,1,1,0,1),
(20804,20804,'Crokian Lad',0,'',0,'LineageMonster.crokian_100_bi','36','61',41,'male','L2Monster',40,'1008.23781','504.8','5.5','2.1',40,43,30,21,20,20,6178,404,'187.11878','160.69002','127.77787','106.989225133249',253,4,500,333,5128,0,0,18,174,1,1,0,1),
(20805,20805,'Dailaon Lad',0,'',0,'LineageMonster.dailaon_100_bi','40','58',42,'male','L2Monster',1100,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,6697,446,'198.34591','164.88513','135.44454','109.782377202178',253,8,0,333,5127,0,0,18,174,1,1,0,1),
(20806,20806,'Crokian Lad Warrior',0,'',0,'LineageMonster.crokian_100_bi','36','61',43,'male','L2Monster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,6428,434,'210.04832','169.13417','143.43577','112.611442266143',253,4,500,333,5128,0,0,18,174,1,1,0,1),
(20807,20807,'Farhite Lad',0,'',0,'LineageMonster.farhite_50_bi','24','48',44,'male','L2Monster',40,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,6761,463,'222.23112','173.43552','151.75505','115.475328468187',253,1,0,333,5131,0,0,15,174,1,1,0,1),
(20808,20808,'Nos Lad',0,'',0,'LineageMonster.nos_100_bi','52','86',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,8371,582,'234.89829','177.78746','160.40508','118.372898457316',253,4,500,333,128,0,0,18,174,1,1,0,1),
(20809,20809,'Ghost of the Tower',0,'',0,'LineageMonster.human_ghost','8','22',60,'male','L2Monster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,14562,1264,'481.34551','247.65008','328.69659','164.888215781956',253,1,500,333,0,0,0,80,143,1,1,0,1),
(20810,20810,'Seer of Hallate',0,'',0,'LineageMonster.field_stalker','15','30',60,'male','L2Monster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,14562,1264,'481.34551','247.65008','328.69659','164.888215781956',253,1,500,333,0,0,0,70,170,1,1,0,1),
(20811,20811,'Ghastly Warrior',0,'',0,'LineageMonster.unpleasant_humming','12','26',61,'male','L2Monster',40,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,17170,1511,'501.08068','252.49346','342.17315','168.112997103103',253,8,500,333,0,0,0,21,150,1,1,0,1),
(20812,20812,'Archer of Despair',0,'',0,'LineageMonster.skeleton_archer','11','27',61,'male','L2Monster',1100,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,16950,1492,'501.08068','252.49346','342.17315','168.112997103103',253,8,500,333,284,0,0,40,160,1,1,0,1),
(20813,20813,'Crendion',0,'',0,'LineageMonster.liviona','15','28',62,'male','L2Monster',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,15397,1372,'521.12391','257.34267','355.86007','171.341654516443',253,4,500,333,0,0,0,80,160,1,1,0,1),
(20814,20814,'Blader of Despair',0,'',0,'LineageMonster.spartoi','11','27',62,'male','L2Monster',80,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,17778,1584,'521.12391','257.34267','355.86007','171.341654516443',253,4,500,333,79,0,0,60,143,1,1,0,1),
(20815,20815,'Hound Dog of Hallate',0,'',0,'LineageMonster.dire_wolf','13','11',63,'male','L2Monster',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,22001,1986,'541.44774','262.19426','369.73862','174.571895122369',253,1,500,333,0,0,0,24,165,1,1,0,1),
(20816,20816,'Hallate\'s Royal Guard',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',63,'male','L2Monster',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,18356,1657,'541.44774','262.19426','369.73862','174.571895122369',253,8,500,333,946,945,0,80,164,1,1,0,1),
(20817,20817,'Corrupt Sage',0,'',0,'LineageMonster.vale_master','12','40',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,19137,1752,'562.02275','267.04468','383.78868','177.801362329617',253,1,500,333,210,0,0,70,160,1,1,0,1),
(20818,20818,'Hallate\'s Warrior',0,'',0,'LineageMonster.skeleton_knight','10','25',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,17735,1624,'562.02275','267.04468','383.78868','177.801362329617',253,4,500,333,78,0,0,40,160,1,1,0,1),
(20819,20819,'Archer of Abyss',0,'',0,'LineageMonster.fiend_archer','17','55',65,'male','L2Monster',1100,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,17603,1636,'582.81759','271.89033','397.98887','181.027644954078',253,8,500,333,0,0,0,70,165,1,1,0,1),
(20820,20820,'Hallate\'s Knight',0,'',0,'LineageMonster.death_knight','12','31',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,35090,3260,'582.81759','271.89033','397.98887','181.027644954078',253,4,500,333,80,0,0,27,160,1,1,0,1),
(20821,20821,'Erin Ediunce',0,'',0,'LineageMonster.banshee','9','23',66,'female','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,25609,2411,'603.79903','276.72752','412.31647','184.248304515217',253,1,500,333,3939,0,0,80,165,1,1,0,1),
(20822,20822,'Hallate\'s Maid',0,'',0,'LineageMonster.bloody_queen','14','40',66,'female','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,23832,2243,'603.79903','276.72752','412.31647','184.248304515217',253,8,500,333,0,0,0,80,160,1,1,0,1),
(20823,20823,'Platinum Tribe Soldier',0,'',0,'LineageMonster.kel_mahum','13','26',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,27669,2635,'624.93199','281.55251','426.74754','187.460838840844',253,8,500,333,242,0,0,50,160,1,1,0,1),
(20824,20824,'Hallate\'s Commander',0,'',0,'LineageMonster.death_blader','15','45',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,24884,2370,'624.93199','281.55251','426.74754','187.460838840844',253,1,500,333,1472,0,0,100,170,1,1,0,1),
(20825,20825,'Hallate\'s Inspector',0,'',0,'LineageMonster.karik_25_bi','31','110',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,25991,2510,'646.17968','286.3615','441.25696','190.662718462344',253,1,500,333,0,0,0,37,170,1,1,0,1),
(20826,20826,'Platinum Tribe Archer',0,'',0,'LineageMonster.kel_mahum_archer','13','27',68,'male','L2Monster',1100,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,27541,2660,'646.17968','286.3615','441.25696','190.662718462344',253,8,500,333,288,0,0,50,160,1,1,0,1),
(20827,20827,'Platinum Tribe Warrior',0,'',0,'LineageMonster.kel_mahum_warrior','13','28',69,'male','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,28758,2814,'667.50361','291.15063','455.81844','193.851368417065',253,4,500,333,148,0,0,50,160,1,1,0,1),
(20828,20828,'Platinum Tribe Shaman',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13','25',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,35291,3499,'688.86373','295.91597','470.40463','197.024195544734',253,1,500,333,202,0,0,50,160,1,1,0,1),
(20829,20829,'Platinum Tribe Overlord',0,'',0,'LineageMonster.kel_mahum_champion','13','32',71,'male','L2Monster',40,'2492.727','1377.8','8.5','3',40,43,30,21,20,20,50697,5087,'710.2185','300.65359','484.98717','200.178552092236',253,4,500,333,147,0,0,50,170,1,1,0,1),
(20830,20830,'Guardian Angel',0,'',0,'LineageMonster.angel','13.5','36.5',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,0,0,'731.52506','305.35947','499.53679','203.311781207645',253,4,500,333,148,0,0,30,170,1,1,0,1),
(20831,20831,'Seal Angel',0,'',0,'LineageMonster.angel','13.5','36.5',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,0,0,'752.73928','310.02959','514.02335','206.421198742611',253,4,500,333,148,0,0,30,170,1,1,0,1),
(20832,20832,'Zaken\'s Pikeman',0,'',0,'LineageMonster.skeleton_pikeman','10','28',43,'male','L2Monster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,3264,221,'210.04832','169.13417','143.43577','112.611442266143',253,4,500,333,292,0,0,50,174,1,1,0,1),
(20833,20833,'Zaken\'s Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',44,'male','L2Monster',1100,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,3631,248,'222.23112','173.43552','151.75505','115.475328468187',253,8,0,333,279,0,0,40,174,1,1,0,1),
(20834,20834,'Mardian',0,'',0,'LineageMonster.giant_spider','26','25.5',42,'male','L2Monster',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,5403,360,'198.34591','164.88513','135.44454','109.782377202178',253,4,500,333,0,0,0,72,174,1,1,0,1),
(20835,20835,'Zaken\'s Seer',0,'',0,'LineageMonster.liviona','15','28',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,2974,206,'234.89829','177.78746','160.40508','118.372898457316',253,1,500,333,0,0,0,80,174,1,1,0,1),
(20836,20836,'Pirate Zombie',0,'',0,'LineageMonster.pirates_zombie','10','23',44,'male','L2Monster',40,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,6799,466,'222.23112','173.43552','151.75505','115.475328468187',253,8,0,333,225,0,0,11,174,1,1,0,1),
(20837,20837,'Tainted Ogre',0,'',0,'LineageMonster.ogre','21','44',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,6158,428,'234.89829','177.78746','160.40508','118.372898457316',253,1,500,333,194,0,0,22,174,1,1,0,1),
(20838,20838,'Bloody Bat',0,'',0,'LineageMonster.vampire_bat','10','33.5',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,5773,402,'234.89829','177.78746','160.40508','118.372898457316',253,8,0,333,0,0,0,60,174,1,1,0,1),
(20839,20839,'Unpleasant Humming',0,'',0,'LineageMonster.unpleasant_humming','12','26',46,'male','L2Monster',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,20,3453,245,'248.0526','182.18816','169.38777','121.302932993263',253,4,500,333,0,0,0,21,174,1,1,0,1),
(20840,20840,'Death Flyer',0,'',0,'LineageMonster.dark_horror','20','35',47,'male','L2Monster',40,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,3566,256,'261.69549','186.63569','178.7041','124.264149144103',253,1,0,333,0,0,0,100,174,1,1,0,1),
(20841,20841,'Fiend Archer',0,'',0,'LineageMonster.fiend_archer','17','55',48,'male','L2Monster',1100,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,3663,268,'275.82705','191.12803','188.35412','127.255200286259',253,8,500,333,0,0,0,70,174,1,1,0,1),
(20842,20842,'Musveren',0,'',0,'LineageMonster.field_stalker','15','30',49,'male','L2Monster',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,3492,258,'290.44588','195.66302','198.33688','130.274648808072',253,4,0,333,0,0,0,70,174,1,1,0,1),
(20843,20843,'Zaken\'s Royal Guard',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,4413,332,'305.54906','200.23844','208.6504','133.321011603844',253,8,500,333,225,945,0,80,174,1,1,0,1),
(20844,20844,'Kaim Vanul',0,'',0,'LineageMonster.kaim_vanul','24','40',51,'male','L2Monster',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,20,3936,300,'321.13207','204.85194','219.29157','136.392732777413',253,4,0,333,0,0,0,37,174,1,1,0,1),
(20845,20845,'Pirate\'s Zombie Captain',0,'',0,'LineageMonster.pirates_zombie_captain','17','28',52,'male','L2Monster',40,'1520.38155','804','6.5','2.4',40,43,30,21,20,20,5945,460,'337.18867','209.50106','230.25615','139.488165444537',253,8,500,333,232,0,0,14,174,1,1,0,1),
(20846,20846,'Doll Blader',0,'',0,'LineageMonster.doll_blader','6','12',53,'male','L2Monster',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,4718,371,'353.71092','214.18326','241.5387','142.605626325743',253,8,0,333,5129,5129,0,22,174,1,1,0,1),
(20847,20847,'Vale Master',0,'',0,'LineageMonster.vale_master','12','40',54,'male','L2Monster',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,4501,359,'370.68904','218.89589','253.13256','145.743350252286',253,4,500,333,0,0,0,70,174,1,1,0,1),
(20848,20848,'Light Bringer',0,'',0,'LineageMonster.light_bringer','10','23',46,'male','L2Monster',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,20,5839,414,'248.0526','182.18816','169.38777','121.302932993263',253,4,500,333,0,0,0,60,174,1,1,0,1),
(20849,20849,'Light Worm',0,'',0,'LineageMonster.light_worm','5','16',41,'male','L2Monster',40,'1008.23781','504.8','5.5','2.1',40,43,30,21,20,20,4638,304,'187.11878','160.69002','127.77787','106.989225133249',253,4,500,333,0,0,0,60,174,1,1,0,1),
(20850,20850,'Golden Stag Lord',0,'',0,'LineageMonster.golden_stag_lord','25','30',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,3783,284,'305.54906','200.23844','208.6504','133.321011603844',253,4,0,333,0,0,0,35,174,1,1,0,1),
(20851,20851,'Theeder',0,'',0,'LineageMonster.theeder','9','32',47,'male','L2Monster',40,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,3409,245,'261.69549','186.63569','178.7041','124.264149144103',253,1,500,333,0,0,0,80,174,1,1,0,1),
(20852,20852,'Banshee',0,'',0,'LineageMonster.banshee','9','23',60,'female','L2Monster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,5341,463,'481.34551','247.65008','328.69659','164.888215781956',253,8,500,333,3939,0,0,80,174,1,1,0,1),
(20853,20853,'Kel Mahum',0,'',0,'LineageMonster.kel_mahum','13','26',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,9389,872,'582.81759','271.89033','397.98887','181.027644954078',253,8,500,333,242,0,0,50,174,1,1,0,1),
(20854,20854,'Kel Mahum Warrior',0,'',0,'LineageMonster.kel_mahum_warrior','13','28',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,9224,868,'603.79903','276.72752','412.31647','184.248304515217',253,4,500,333,148,0,0,50,174,1,1,0,1),
(20855,20855,'Kel Mahum Archer',0,'',0,'LineageMonster.kel_mahum_archer','13','27',67,'male','L2Monster',1100,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,10680,1018,'624.93199','281.55251','426.74754','187.460838840844',253,8,0,333,288,0,0,50,174,1,1,0,1),
(20856,20856,'Kel Mahum Shaman',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13','25',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,7669,740,'646.17968','286.3615','441.25696','190.662718462344',253,1,500,333,202,0,0,50,174,1,1,0,1),
(20857,20857,'Kel Mahum Champion',0,'',0,'LineageMonster.kel_mahum_champion','13','32',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,9780,970,'688.86373','295.91597','470.40463','197.024195544734',253,4,500,333,147,0,0,50,174,1,1,0,1),
(20858,20858,'Angel',0,'',0,'LineageMonster.angel','13.5','36.5',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,10923,1110,'731.52506','305.35947','499.53679','203.311781207645',253,4,500,333,148,0,0,30,174,1,1,0,1),
(20859,20859,'Guardian Angel',0,'',0,'LineageMonster.angel','13.5','36.5',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,59729,6068,'731.52506','305.35947','499.53679','223.44881',253,4,500,333,148,0,0,30,170,1,1,0,1),
(20860,20860,'Seal Angel',0,'',0,'LineageMonster.angel','13.5','36.5',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,83696,8612,'752.73928','310.02959','514.02335','226.8662',253,4,500,333,148,0,0,30,170,1,1,0,1),
(20861,20861,'Oel Mahum Champion',0,'',0,'LineageMonster.oel_mahum_champion','23','61',56,'male','L2Monster',40,'1724.6831','918.8','6.5','2.4',40,43,30,21,20,20,6641,545,'405.96455','228.40135','277.22116','152.072199009316',253,4,500,333,127,0,0,67,174,1,1,0,1),
(20862,20862,'Death Lord',0,'',0,'LineageMonster.death_lord','21','40',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,9330,984,'794.70901','319.24623','542.68324','212.557735094503',253,4,0,333,78,0,0,40,174,1,1,0,1),
(20919,20919,'Maille Lizardman',0,'',0,'LineageMonster.virud_lizardman','10','23',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,321,14,'44.32863','86.87049','30.2707','57.8393570613084',253,1,0,333,291,0,0,43,130,1,1,1,1),
(20920,20920,'Maille Lizardman Scout',0,'',0,'LineageMonster.virud_lizardman_scout','10','22',22,'male','L2Monster',1100,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,713,34,'51.75278','92.65694','35.34044','61.6920289224665',253,8,0,333,2507,0,0,43,130,1,1,1,1),
(20921,20921,'Maille Lizardman Guard',0,'',0,'LineageMonster.virud_lizardman','10','23',24,'male','L2Monster',40,'435.34437','245.52','3.5','1.5',40,43,30,21,20,20,515,25,'60.19687','98.70919','41.10666','65.7216907961494',253,1,500,333,291,0,0,43,130,1,1,1,1),
(20922,20922,'Maille Lizardman Warrior',0,'',0,'LineageMonster.virud_lizardman_warrior','12','30',26,'male','L2Monster',40,'487.5704','273','3.5','1.5',40,43,30,21,20,20,571,29,'69.75926','105.02818','47.63653','69.9289432036824',253,1,0,333,16,0,0,52,130,1,1,1,1),
(20923,20923,'Maille Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman','10','29',28,'male','L2Monster',40,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,836,44,'80.54056','111.61368','54.99876','74.3136496629463',253,1,0,333,7,0,0,43,120,1,1,1,1),
(20924,20924,'Maille Lizardman Matriarch',0,'',0,'LineageMonster.virud_lizardman_matriarch','13','37',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,1025,56,'92.64226','118.46427','63.26266','78.8748547991048',253,1,500,333,69,627,0,56,130,1,1,1,1),
(20925,20925,'Giant Araneid',0,'',0,'LineageMonster.giant_spider','26','25.5',24,'male','L2Monster',40,'435.34437','245.52','3.5','1.5',40,43,30,21,20,20,525,26,'60.19687','98.70919','41.10666','65.7216907961494',253,1,0,333,0,0,0,72,130,1,1,1,1),
(20926,20926,'Poison Araneid',0,'',0,'LineageMonster.poison_spider','27','25.5',25,'male','L2Monster',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,607,30,'64.83203','101.83533','44.27187','67.8031159084826',253,1,0,333,0,0,0,60,140,1,1,1,1),
(20927,20927,'King of the Araneid',0,'',0,'LineageMonster.giant_spider_50_bi','39','38',27,'male','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,872,44,'74.99121','108.28767','51.20928','72.0991544841329',253,1,500,333,0,0,0,72,130,1,1,1,1),
(20928,20928,'Hatu Weird Bee',0,'',0,'LineageMonster.giant_bee','8','24.5',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,881,48,'92.64226','118.46427','63.26266','78.8748547991048',253,1,500,333,0,0,0,90,120,1,1,1,1),
(20929,20929,'Hatu Dire Wolf',0,'',0,'LineageMonster.dire_wolf','13','11',32,'male','L2Monster',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,836,47,'106.16525','125.57727','72.49711','83.6107570481808',253,1,0,333,0,0,0,24,110,1,1,1,1),
(20930,20930,'Hatu Brown Bear',0,'',0,'LineageMonster.grizzly','21','40',34,'male','L2Monster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,1317,77,'121.20802','132.9486','82.76936','88.5186722618248',253,1,300,333,0,0,0,40,143,1,1,1,1),
(20931,20931,'Hatu Onyx Beast',0,'',0,'LineageMonster.onyx_beast','14','14.5',36,'male','L2Monster',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,1221,74,'137.86467','140.57278','94.1437','93.5949427192352',253,1,0,333,0,0,0,30,174,1,1,1,1),
(20932,20932,'Hatu Crimson Bear',0,'',0,'LineageMonster.crimson_bear','19','36',38,'male','L2Monster',40,'886.09975','447.96','4.5','1.8',40,43,30,21,20,20,1613,101,'156.22273','148.44287','106.67987','98.8349371271581',253,1,0,333,0,0,0,37,174,1,1,1,1),
(20933,20933,'Hatu Windsus',0,'',0,'LineageMonster.giant_wild_hog','35','27',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,1849,119,'176.36077','156.55035','120.43155','104.232986928232',253,1,500,333,0,0,0,35,174,1,1,1,1),
(20934,20934,'Wasp Worker',0,'',0,'LineageMonster.giant_bee_bi','8','32',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,991,59,'129.32896','136.72948','88.31491','91.0360303625432',253,1,0,333,0,0,0,90,174,1,1,1,1),
(20935,20935,'Wasp Leader',0,'',0,'LineageMonster.giant_bee_100_bi','16','49',37,'male','L2Monster',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,20,1086,67,'146.82587','144.47758','100.26304','96.1948088105753',253,1,300,333,0,0,0,90,174,1,1,1,1),
(20936,20936,'Tanor Silenos',0,'',0,'LineageMonster.heltor_silenos','13','29',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,2066,133,'176.36077','156.55035','120.43155','104.232986928232',253,1,0,333,88,0,0,34,174,1,1,0,1),
(20937,20937,'Tanor Silenos Grunt',0,'',0,'LineageMonster.heltor_silenos','13','29',42,'male','L2Monster',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,2699,180,'198.34591','164.88513','135.44454','109.782377202178',253,1,0,333,158,18,0,34,174,1,1,0,1),
(20938,20938,'Tanor Silenos Scout',0,'',0,'LineageMonster.heltor_silenos','13','29',44,'male','L2Monster',40,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,2963,203,'222.23112','173.43552','151.75505','115.475328468187',253,1,0,333,5,0,0,34,174,1,1,0,1),
(20939,20939,'Tanor Silenos Warrior',0,'',0,'LineageMonster.heltor_silenos_warrior','13','31',46,'male','L2Monster',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,20,3303,234,'248.0526','182.18816','169.38777','121.302932993263',253,1,0,333,160,0,0,36,174,1,1,0,1),
(20940,20940,'Tanor Silenos Shaman',0,'',0,'LineageMonster.heltor_silenos_shaman','13','32',48,'male','L2Monster',40,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,4024,294,'275.82705','191.12803','188.35412','127.255200286259',253,1,0,333,9,0,0,29,174,1,1,0,1),
(20941,20941,'Tanor Silenos Chieftain',0,'',0,'LineageMonster.heltor_silenos_chieftain','13','31.5',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,3902,294,'305.54906','200.23844','208.6504','133.321011603844',253,1,500,333,75,0,0,27,174,1,1,0,1),
(20942,20942,'Nightmare Guide',0,'',0,'LineageMonster.harpy','10','42',43,'female','L2Monster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,1970,133,'210.04832','169.13417','143.43577','112.611442266143',253,1,0,333,0,0,0,60,174,1,1,0,1),
(20943,20943,'Nightmare Keeper',0,'',0,'LineageMonster.harpy','10','42',45,'female','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,2833,197,'234.89829','177.78746','160.40508','118.372898457316',253,1,0,333,0,0,0,60,174,1,1,0,1),
(20944,20944,'Nightmare Lord',0,'',0,'LineageMonster.succubus_100_bi','20','75',47,'female','L2Monster',40,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,2400,172,'261.69549','186.63569','178.7041','124.264149144103',253,1,500,333,0,0,0,60,174,1,1,0,1),
(20945,20945,'Cadeine',0,'',0,'LineageMonster.hobgoblin','12','24',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,2690,203,'305.54906','200.23844','208.6504','133.321011603844',253,1,0,333,127,625,0,45,174,1,1,0,1),
(20946,20946,'Sanhidro',0,'',0,'LineageMonster.troll','21','35',52,'male','L2Monster',40,'1520.38155','804','6.5','2.4',40,43,30,21,20,20,4138,320,'337.18867','209.50106','230.25615','139.488165444537',253,1,0,333,0,0,0,55,174,1,1,0,1),
(20947,20947,'Connabi',0,'',0,'LineageMonster.bugbear','17','35',54,'male','L2Monster',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,4462,355,'370.68904','218.89589','253.13256','145.743350252286',253,1,0,333,88,0,0,55,174,1,1,0,1),
(20948,20948,'Bartal',0,'',0,'LineageMonster.liviona','15','28',56,'male','L2Monster',40,'1724.6831','918.8','6.5','2.4',40,43,30,21,20,20,4431,364,'405.96455','228.40135','277.22116','152.072199009316',253,1,0,333,0,0,0,80,174,1,1,0,1),
(20949,20949,'Luminun',0,'',0,'LineageMonster.twin_headed_giant','17','39',58,'male','L2Monster',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,20,5220,440,'442.8992','237.99429','302.44274','158.459289236126',253,1,0,333,157,0,0,45,174,1,1,0,1),
(20950,20950,'Innersen',0,'',0,'LineageMonster.king_bugbear','15','40',60,'male','L2Monster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,5619,487,'481.34551','247.65008','328.69659','164.888215781956',253,1,500,333,160,0,0,55,174,1,1,0,1),
(20951,20951,'Pobby\'s Maid',0,'',0,'LineageMonster.manadragora','14','17.8',53,'female','L2Monster',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,3022,238,'353.71092','214.18326','241.5387','142.605626325743',253,1,0,333,0,0,0,80,174,1,1,0,1),
(20952,20952,'Pobby Escort',0,'',0,'LineageMonster.mandragora_b','12','25.5',55,'female','L2Monster',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,5461,440,'388.11142','223.6362','265.02979','148.899508363765',253,1,0,333,0,0,0,80,174,1,1,0,1),
(20953,20953,'Pobby',0,'',0,'LineageMonster.mandragora_a','15','26',57,'female','L2Monster',40,'1776.58018','948','6.5','2.4',40,43,30,21,20,20,5071,421,'424.23295','233.18839','289.69611','155.259456846417',253,1,500,333,0,0,0,80,174,1,1,0,1),
(20954,20954,'Hungered Corpse',0,'',0,'LineageMonster.skeleton','11','25',60,'male','L2Monster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,5991,520,'481.34551','247.65008','328.69659','164.888215781956',253,1,0,333,123,945,0,60,180,1,1,0,1),
(20955,20955,'Ghostly Warrior',0,'',0,'LineageMonster.skeleton_pikeman','10','28',62,'male','L2Monster',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,6398,570,'521.12391','257.34267','355.86007','171.341654516443',253,1,0,333,299,0,0,50,180,1,1,0,1),
(20956,20956,'Past Knight',0,'',0,'LineageMonster.skeleton_knight','10','25',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,6953,636,'562.02275','267.04468','383.78868','177.801362329617',253,1,500,333,150,103,0,40,174,1,1,0,1),
(20957,20957,'Nihil Invader',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,7250,683,'603.79903','276.72752','412.31647','184.248304515217',253,1,0,333,946,945,0,80,185,1,1,0,1),
(20958,20958,'Death Agent',0,'',0,'LineageMonster.death_blader','15','45',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,5411,523,'646.17968','286.3615','441.25696','190.662718462344',253,1,0,333,1472,0,0,100,195,1,1,0,1),
(20959,20959,'Dark Guard',0,'',0,'LineageMonster.headless_knight','21','31',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,8318,824,'688.86373','295.91597','470.40463','197.024195544734',253,1,500,333,124,0,0,70,170,1,1,0,1),
(20960,20960,'Bloody Ghost',0,'',0,'LineageMonster.succubus','10','36',64,'female','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,4793,439,'562.02275','267.04468','383.78868','177.801362329617',253,1,0,333,0,0,0,60,175,1,1,0,1),
(20961,20961,'Bloody Knight',0,'',0,'LineageMonster.doll_blader','6','12',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,7032,653,'582.81759','271.89033','397.98887','181.027644954078',253,1,0,333,5129,5129,0,22,175,1,1,0,1),
(20962,20962,'Bloody Priest',0,'',0,'LineageMonster.bloody_queen','14','40',66,'female','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,7827,737,'603.79903','276.72752','412.31647','184.248304515217',253,1,0,333,0,0,0,80,185,1,1,0,1),
(20963,20963,'Bloody Lord',0,'',0,'LineageMonster.banshee','9','23',68,'female','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,5630,544,'646.17968','286.3615','441.25696','190.662718462344',253,1,500,333,3939,0,0,80,180,1,1,0,1),
(20964,20964,'Huge Footmark',0,'',0,'LineageMonster.stone_golem','20','31',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,0,0,0,23,23,1,1,0,1),
(20965,20965,'Chimera Piece',0,'',0,'LineageMonster.will_o_wisp','13','22',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,22599,2237,'752.73928','310.02959','514.02335','226.8662',253,1,0,333,0,0,0,80,140,1,1,1,1),
(20966,20966,'Changed Creation',0,'',0,'LineageMonster.leogul','15','35',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,31161,3114,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,0,0,0,80,170,1,1,1,1),
(20967,20967,'Past Creature',0,'',0,'LineageMonster.gamlin','11','32',76,'male','L2Monster',40,'2758.05923328','1540.8','8.5','3',40,43,30,21,20,20,22942,2360,'824.422073095','323.78455','562.9734023','236.93149',253,4,0,333,0,0,0,80,170,1,1,1,1),
(20968,20968,'Nonexistent Man',0,'',0,'LineageMonster.susceptor','20','35',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,27816,2944,'890.50085998804','332.70061','608.096657928153','243.45587',253,1,0,333,0,0,0,27,150,1,1,1,1),
(20969,20969,'Giant\'s Shadow',0,'',0,'LineageMonster.lesser_giant_shooter','50','44',78,'male','L2Monster',1100,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,36095,3804,'890.50085998804','332.70061','608.096657928153','243.45587',253,8,0,333,4028,0,0,80,180,1,1,1,1),
(20970,20970,'Soldier of Ancient Times',0,'',0,'LineageMonster.lesser_giant','50','44',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,22599,2237,'752.73928','310.02959','514.02335','226.8662',253,4,0,333,3937,0,0,15,180,1,1,1,1),
(20971,20971,'Warrior of Ancient Times',0,'',0,'LineageMonster.lesser_giant','50','44',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,23855,2420,'794.70901','319.24623','542.68324','233.61053',253,4,0,333,3937,0,0,15,180,1,1,1,1),
(20972,20972,'Shaman of Ancient Times',0,'',0,'LineageMonster.lesser_giant_mage','50','44',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,24719,2511,'794.70901','319.24623','542.68324','233.61053',253,1,0,333,3938,0,0,15,180,1,1,1,1),
(20973,20973,'Forgotten Ancient People',0,'',0,'LineageMonster.lesser_giant_mage','50','44',77,'male','L2Monster',40,'2856.7687256316','1574','8.5','3',40,43,30,21,20,20,31618,3281,'856.44055895414','328.27073','584.837886935576','240.21427',253,1,0,333,3938,0,0,15,180,1,1,1,1),
(20974,20974,'Spiteful Soul Leader',0,'',0,'LineageMonster.skeleton_royal_guard_bi','16','44',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,14127,1313,'582.81759','271.89033','397.98887','198.95754',253,4,0,333,946,945,0,80,174,1,1,0,1),
(20975,20975,'Spiteful Soul Wizard',0,'',0,'LineageMonster.elf_ghost_50_bi','10','32',63,'male','L2Monster',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,12599,1138,'541.44774','262.19426','369.73862','174.571895122369',253,4,0,333,0,0,0,80,174,1,1,0,1),
(20976,20976,'Spiteful Soul Fighter',0,'',0,'LineageMonster.human_ghost_50_bi','12','33',62,'male','L2Monster',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,10694,953,'521.12391','257.34267','355.86007','171.341654516443',253,4,0,333,0,0,0,80,174,1,1,0,1),
(20977,20977,'Elmoradan\'s Lady',0,'',0,'LineageMonster.banshee_50_bi','13.5','38',65,'female','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,18033,1675,'582.81759','271.89033','397.98887','181.027644954078',253,1,500,333,3939,0,0,80,160,1,1,0,1),
(20978,20978,'Elmoradan\'s Archer Escort',0,'',0,'LineageMonster.skeleton_archer','11','27',64,'male','L2Monster',1100,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,17930,1642,'562.02275','267.04468','383.78868','177.801362329617',253,8,0,333,284,0,0,40,140,1,1,0,1),
(20979,20979,'Elmoradan\'s Maid',0,'',0,'LineageMonster.doll_blader','6','12',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,17139,1570,'562.02275','267.04468','383.78868','177.801362329617',253,4,0,333,5129,5129,0,22,170,1,1,0,1),
(20980,20980,'Hallate\'s Follower Mul',0,'',0,'LineageMonster.vale_master','12','40',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,18255,1764,'646.17968','286.3615','441.25696','190.662718462344',253,1,500,333,210,0,0,70,170,1,1,0,1),
(20981,20981,'Mul\'s Wizard',0,'',0,'LineageMonster.kaim_vanul_50_bi','36','60',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,18154,1729,'624.93199','281.55251','426.74754','187.460838840844',253,1,0,333,0,0,0,37,160,1,1,0,1),
(20982,20982,'Mul\'s Knight',0,'',0,'LineageMonster.dre_vanul_100_bi','28','75',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,16025,1526,'624.93199','281.55251','426.74754','187.460838840844',253,8,0,333,0,0,0,80,143,1,1,0,1),
(20983,20983,'Binder',0,'',0,'LineageMonster.kel_mahum_champion_50_bi','19','48',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,24823,2554,'752.73928','310.02959','514.02335','206.421198742611',253,4,500,333,147,0,0,50,170,1,1,0,1),
(20984,20984,'Bound Warrior',0,'',0,'LineageMonster.kel_mahum_warrior','13','28',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,23326,2370,'731.52506','305.35947','499.53679','203.311781207645',253,4,0,333,148,0,0,50,160,1,1,0,1),
(20985,20985,'Bound Archer',0,'',0,'LineageMonster.kel_mahum_archer','13','27',72,'male','L2Monster',1100,'2540.15331','1410','8.5','3',40,43,30,21,20,20,23154,2352,'731.52506','305.35947','499.53679','203.311781207645',253,8,0,333,288,0,0,50,170,1,1,0,1),
(20986,20986,'Sairon',0,'',0,'LineageMonster.doll_blader_50_bi','9','20.5',54,'male','L2Monster',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,13258,1057,'370.68904','218.89589','253.13256','145.743350252286',253,4,500,333,5129,5129,0,22,174,1,1,0,1),
(20987,20987,'Sairon\'s Doll',0,'',0,'LineageMonster.doll_blader','6','12',53,'male','L2Monster',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,12060,948,'353.71092','214.18326','241.5387','142.605626325743',253,4,0,333,5129,5129,0,22,174,1,1,0,1),
(20988,20988,'Sairon\'s Puppet',0,'',0,'LineageMonster.doll_blader','6','12',53,'male','L2Monster',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,13265,1043,'353.71092','214.18326','241.5387','142.605626325743',253,4,0,333,5129,5129,0,22,174,1,1,0,1),
(20989,20989,'Lageos',0,'',0,'LineageMonster.marsh_stakato_drone_50_bi','13','37',38,'male','L2Monster',40,'886.09975','447.96','4.5','1.8',40,43,30,21,20,20,3299,205,'156.22273','148.44287','106.67987','98.8349371271581',253,4,0,333,182,0,0,80,174,1,1,0,1),
(20990,20990,'Pageos',0,'',0,'LineageMonster.marsh_stakato_soldier','10','25',38,'male','L2Monster',40,'886.09975','447.96','4.5','1.8',40,43,30,21,20,20,3132,196,'156.22273','148.44287','106.67987','98.8349371271581',253,4,0,333,128,0,0,30,174,1,1,0,1),
(20991,20991,'Swamp Tribe',0,'',0,'LineageMonster.farhite_50_bi','24','48',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,12334,858,'234.89829','177.78746','160.40508','118.372898457316',253,4,500,333,5131,0,0,15,174,1,1,0,1),
(20992,20992,'Swamp Alligator',0,'',0,'LineageMonster.crokian','18','29',44,'male','L2Monster',40,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,11042,756,'222.23112','173.43552','151.75505','115.475328468187',253,4,0,333,5128,0,0,18,174,1,1,0,1),
(20993,20993,'Swamp Warrior',0,'',0,'LineageMonster.dailaon','20','28',44,'male','L2Monster',1100,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,11717,802,'222.23112','173.43552','151.75505','115.475328468187',253,8,0,333,5127,0,0,18,174,1,1,0,1),
(20994,20994,'Garden Guard Leader',0,'',0,'LineageMonster.doll_master_50_bi','30','63',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,14866,1120,'305.54906','200.23844','208.6504','133.321011603844',253,4,500,333,0,0,0,80,174,1,1,0,1),
(20995,20995,'Garden Guard',0,'',0,'LineageMonster.theeder','9','32',48,'male','L2Monster',40,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,10134,740,'275.82705','191.12803','188.35412','127.255200286259',253,4,0,333,94,0,0,80,174,1,1,0,1),
(20996,20996,'Spiteful Ghost of Ruins',0,'',0,'LineageMonster.zombie','13','21',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,6419,484,'305.54906','200.23844','208.6504','133.321011603844',253,1,500,333,0,0,0,15,15,1,1,0,1),
(20997,20997,'Soldier of Grief',0,'',0,'LineageMonster.unpleasant_humming','12','26',51,'male','L2Monster',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,20,4539,346,'321.13207','204.85194','219.29157','136.392732777413',253,1,0,333,0,0,0,21,150,1,1,0,1),
(20998,20998,'Cruel Punisher',0,'',0,'LineageMonster.hungry_spirit','30','40',52,'male','L2Monster',40,'1520.38155','804','6.5','2.4',40,43,30,21,20,20,5002,386,'337.18867','209.50106','230.25615','139.488165444537',253,1,0,333,0,0,0,15,120,1,1,0,1),
(20999,20999,'Roving Soul',0,'',0,'LineageMonster.skeleton','11','25',53,'male','L2Monster',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,5932,467,'353.71092','214.18326','241.5387','142.605626325743',253,8,0,333,75,0,0,60,160,1,1,0,1),
(21000,21000,'Soul of Ruins',0,'',0,'LineageMonster.human_ghost','8','22',54,'male','L2Monster',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,5191,414,'370.68904','218.89589','253.13256','145.743350252286',253,4,500,333,0,0,0,80,174,1,1,0,1),
(21001,21001,'Wretched Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',55,'male','L2Monster',1100,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,7028,568,'388.11142','223.6362','265.02979','148.899508363765',253,8,0,333,282,0,0,40,174,1,1,1,1),
(21002,21002,'Doom Scout',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',56,'male','L2Monster',40,'1724.6831','918.8','6.5','2.4',40,43,30,21,20,20,6197,509,'405.96455','228.40135','277.22116','152.072199009316',253,8,500,333,242,2496,0,80,174,1,1,1,1),
(21003,21003,'Grave Lich',0,'',0,'LineageMonster.liviona','15','28',57,'male','L2Monster',40,'1776.58018','948','6.5','2.4',40,43,30,21,20,20,5670,472,'424.23295','233.18839','289.69611','155.259456846417',253,4,0,333,0,0,0,80,174,1,1,1,1),
(21004,21004,'Dismal Pole',0,'',0,'LineageMonster.hanged_man_ripper','35','80',58,'male','L2Monster',80,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,20,6288,532,'442.8992','237.99429','302.44274','158.459289236126',253,4,500,333,0,0,0,55,174,1,1,1,1),
(21005,21005,'Grave Predator',0,'',0,'LineageMonster.devastator','35','35',59,'male','L2Monster',40,'1880.92519','1007','6.5','2.4',40,43,30,21,20,20,6878,588,'461.94387','242.81593','315.44778','161.669585254993',253,4,500,333,0,0,0,25,174,1,1,1,1),
(21006,21006,'Doom Servant',0,'',0,'LineageMonster.hungry_spirit','30','40',60,'male','L2Monster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,6537,568,'481.34551','247.65008','328.69659','164.888215781956',253,1,500,333,0,0,0,15,174,1,1,0,1),
(21007,21007,'Doom Guard',0,'',0,'LineageMonster.hungry_spirit','30','40',61,'male','L2Monster',40,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,7014,617,'501.08068','252.49346','342.17315','168.112997103103',253,1,0,333,0,0,0,15,174,1,1,0,1),
(21008,21008,'Doom Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',62,'male','L2Monster',1100,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,8965,799,'521.12391','257.34267','355.86007','171.341654516443',253,8,500,333,286,0,0,40,174,1,1,0,1),
(21009,21009,'Doom Trooper',0,'',0,'LineageMonster.skeleton_pikeman','10','28',63,'male','L2Monster',80,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,9559,863,'541.44774','262.19426','369.73862','174.571895122369',253,4,0,333,301,0,0,50,174,1,1,0,1),
(21010,21010,'Doom Warrior',0,'',0,'LineageMonster.skeleton_knight','10','25',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,7656,701,'562.02275','267.04468','383.78868','177.801362329617',253,8,0,333,71,0,0,40,174,1,1,0,1),
(21011,21011,'Ol Mahum Van Grunt',0,'',0,'LineageMonster.ol_mahum','13.5','25',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,1571,86,'92.64226','118.46427','63.26266','78.8748547991048',253,4,0,333,5,0,0,50,150,1,1,1,1),
(21012,21012,'Magical Eye',0,'',0,'LineageMonster.magical_weaver','11','20',31,'male','L2Monster',40,'635.76437','343.8','4.5','1.8',40,43,30,21,20,20,2084,115,'99.21986','121.98819','67.7543','81.2211098160515',253,4,500,333,0,0,0,90,150,1,1,1,1),
(21013,21013,'Ol Mahum Van Archer',0,'',0,'LineageMonster.ol_mahum_archer','14','25',32,'male','L2Monster',1100,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,2305,130,'106.16525','125.57727','72.49711','83.6107570481808',253,8,0,333,273,0,0,50,150,1,1,1,1),
(21014,21014,'Lesser Warlike Tyrant',0,'',0,'LineageMonster.grave','15','29',33,'male','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,2385,137,'113.49065','129.23095','77.49941','86.043423444366',253,4,500,333,0,0,0,70,150,1,1,1,1),
(21015,21015,'Ol Mahum Van Leader',0,'',0,'LineageMonster.ol_mahum_champion','14','27',34,'male','L2Monster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,2449,143,'121.20802','132.9486','82.76936','88.5186722618248',253,4,500,333,67,0,0,50,150,1,1,1,1),
(21016,21016,'Warlike Tyrant',0,'',0,'LineageMonster.grave','15','29',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,2631,156,'129.32896','136.72948','88.31491','91.0360303625432',253,4,0,333,0,0,0,70,174,1,1,1,1),
(21017,21017,'Fallen Orc',0,'',0,'LineageMonster.ketra_orc','12','29',55,'male','L2Monster',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,5279,426,'388.11142','223.6362','265.02979','148.899508363765',253,4,0,333,127,0,0,45,174,1,1,1,1),
(21018,21018,'Ancient Gargoyle',0,'',0,'LineageMonster.hunter_gargoyle','25','65',56,'male','L2Monster',40,'1724.6831','918.8','6.5','2.4',40,43,30,21,20,20,6643,546,'405.96455','228.40135','277.22116','152.072199009316',253,4,500,333,0,0,0,100,174,1,1,1,1),
(21019,21019,'Fallen Orc Archer',0,'',0,'LineageMonster.ketra_orc_archer','12','27',57,'male','L2Monster',1100,'1776.58018','948','6.5','2.4',40,43,30,21,20,20,7312,607,'424.23295','233.18839','289.69611','155.259456846417',253,8,0,333,279,0,0,45,174,1,1,1,1),
(21020,21020,'Fallen Orc Shaman',0,'',0,'LineageMonster.ketra_orc_shaman','10','23',58,'male','L2Monster',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,20,8278,700,'442.8992','237.99429','302.44274','158.459289236126',253,1,0,333,9,0,0,10,174,1,1,1,1),
(21021,21021,'Sharp Talon Tiger',0,'',0,'LineageMonster.saber_toothed_tiger','34','28',59,'male','L2Monster',40,'1880.92519','1007','6.5','2.4',40,43,30,21,20,20,7625,652,'461.94387','242.81593','315.44778','161.669585254993',253,1,500,333,0,0,0,60,174,1,1,1,1),
(21022,21022,'Fallen Orc Captain',0,'',0,'LineageMonster.ketra_orc_warrior','12','24',60,'male','L2Monster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,7754,673,'481.34551','247.65008','328.69659','164.888215781956',253,1,500,333,160,0,0,36,174,1,1,1,1),
(21023,21023,'Sobbing Wind',0,'',0,'LineageMonster.sylph','11','35',26,'female','L2Monster',40,'487.5704','273','3.5','1.5',40,43,30,21,20,20,1268,64,'69.75926','105.02818','47.63653','69.9289432036824',253,1,0,333,0,0,0,60,150,1,1,1,1),
(21024,21024,'Babbling Wind',0,'',0,'LineageMonster.sylph','11','35',27,'female','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,1336,68,'74.99121','108.28767','51.20928','72.0991544841329',253,1,0,333,0,0,0,60,150,1,1,1,1),
(21025,21025,'Giggling Wind',0,'',0,'LineageMonster.sylph','11','35',28,'female','L2Monster',40,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,1414,74,'80.54056','111.61368','54.99876','74.3136496629463',253,1,0,333,0,0,0,60,150,1,1,1,1),
(21026,21026,'Singing Wind',0,'',0,'LineageMonster.sylph','11','35',29,'female','L2Monster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,1522,82,'86.42002','115.00598','59.01367','76.5722740603874',253,1,500,333,0,0,0,60,150,1,1,1,1),
(21034,21034,'Ogre',0,'',0,'LineageMonster.ogre','21','44',38,'male','L2Monster',40,'886.09975','447.96','4.5','1.8',40,43,30,21,20,20,2157,134,'156.22273','148.44287','106.67987','98.8349371271581',253,1,500,333,98,0,0,22,174,1,1,1,1),
(21035,21035,'Catherok',0,'',0,'LineageMonster.marsh_stakato_soldier','10','25',42,'male','L2Monster',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,6978,443,'198.34591','164.88513','135.44454','120.65578',253,4,500,333,144,0,0,30,155,1,1,0,1),
(21036,21036,'Shindebarn',0,'',0,'LineageMonster.magical_weaver','11','20',44,'male','L2Monster',40,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,8166,536,'222.23112','173.43552','151.75505','126.91259',253,1,0,333,0,0,0,90,90,1,1,0,1),
(21037,21037,'Ossiud',0,'',0,'LineageMonster.field_stalker','15','30',47,'male','L2Monster',40,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,10557,727,'261.69549','186.63569','178.7041','136.5719',253,4,500,333,0,0,0,70,110,1,1,0,1),
(21038,21038,'Liangma',0,'',0,'LineageMonster.will_o_wisp','13','22',49,'male','L2Monster',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,8025,560,'290.44588','195.66302','198.33688','143.17771',253,1,500,333,0,0,0,80,140,1,1,0,1),
(21039,21039,'Snipe Cohort',0,'',0,'LineageMonster.onyx_beast','14','14.5',43,'male','L2Monster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,7953,515,'210.04832','169.13417','143.43577','123.76505',253,4,0,333,0,0,0,30,120,1,1,0,1),
(21040,21040,'Soldier of Darkness',0,'',0,'LineageMonster.death_knight','12','31',49,'male','L2Monster',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,12649,899,'290.44588','195.66302','198.33688','143.17771',253,4,0,333,127,0,0,27,110,1,1,0,1),
(21058,21058,'Beast Lord',0,'',0,'LineageMonster.saber_toothed_tiger','34','28',60,'male','L2Monster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,18913,1642,'481.34551','247.65008','328.69659','164.888215781956',253,1,500,333,0,0,0,60,174,1,1,0,1),
(21059,21059,'Beast Guardian',0,'',0,'LineageMonster.onyx_beast','14','14.5',59,'male','L2Monster',40,'1880.92519','1007','6.5','2.4',40,43,30,21,20,20,15095,1290,'461.94387','242.81593','315.44778','161.669585254993',253,1,0,333,0,0,0,30,174,1,1,0,1),
(21060,21060,'Beast Seer',0,'',0,'LineageMonster.field_stalker','15','30',59,'male','L2Monster',40,'1880.92519','1007','6.5','2.4',40,43,30,21,20,20,15095,1290,'461.94387','242.81593','315.44778','161.669585254993',253,1,0,333,0,0,0,70,174,1,1,0,1),
(21061,21061,'Hallate\'s Guardian',0,'',0,'LineageMonster.kaim_vanul','24','40',69,'male','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,30701,3004,'667.50361','291.15063','455.81844','193.851368417065',253,1,500,333,0,0,0,37,174,1,1,0,1),
(21062,21062,'Messenger Angel',0,'',0,'LineageMonster.angel','13.5','36.5',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,0,0,'688.86373','295.91597','470.40463','197.024195544734',253,1,500,333,148,0,0,30,174,1,1,0,1),
(21063,21063,'Messenger Angel',0,'',0,'LineageMonster.angel','13.5','36.5',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,62784,6226,'688.86373','295.91597','470.40463','197.024195544734',253,1,500,333,148,0,0,30,174,1,1,0,1),
(21064,21064,'Platinum Guardian Archer',0,'',0,'LineageMonster.kel_mahum_archer','13','27',71,'male','L2Monster',1100,'2492.727','1377.8','8.5','3',40,43,30,21,20,20,38444,3858,'710.2185','300.65359','484.98717','200.178552092236',253,8,500,333,288,0,0,50,174,1,1,0,1),
(21065,21065,'Platinum Guardian Warrior',0,'',0,'LineageMonster.kel_mahum_warrior','13','28',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,36221,3680,'731.52506','305.35947','499.53679','203.311781207645',253,1,500,333,148,0,0,50,174,1,1,0,1),
(21066,21066,'Platinum Guardian Shaman',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13','25',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,39180,4032,'752.73928','310.02959','514.02335','206.421198742611',253,1,500,333,202,0,0,50,174,1,1,0,1),
(21067,21067,'Guardian Archangel',0,'',0,'LineageMonster.angel','13.5','36.5',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,0,0,'773.81598','314.65987','528.41601','209.50409325236',253,1,500,333,148,0,0,30,174,1,1,0,1),
(21068,21068,'Guardian Archangel',0,'',0,'LineageMonster.angel','13.5','36.5',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,85242,8886,'773.81598','314.65987','528.41601','209.50409325236',253,1,500,333,148,0,0,30,174,1,1,0,1),
(21069,21069,'Platinum Guardian Prefect',0,'',0,'LineageMonster.kel_mahum_champion','13','32',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,53456,5573,'773.81598','314.65987','528.41601','209.50409325236',253,4,500,333,147,0,0,50,174,1,1,0,1),
(21070,21070,'Seal Archangel',0,'',0,'LineageMonster.angel','13.5','36.5',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,0,0,'794.70901','319.24623','542.68324','212.557735094503',253,1,500,333,148,0,0,30,174,1,1,0,1),
(21071,21071,'Seal Archangel',0,'',0,'LineageMonster.angel','13.5','36.5',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,88404,9325,'794.70901','319.24623','542.68324','233.61053',253,1,500,333,148,0,0,30,174,1,1,0,1),
(21072,21072,'Platinum Guardian Chief',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13','25',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,40513,4273,'794.70901','319.24623','542.68324','212.557735094503',253,1,500,333,202,0,0,50,174,1,1,0,1),
(21073,21073,'Guardian Warrior of Elmoreden',0,'',0,'LineageMonster.skeleton_knight','10','25',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,16897,1547,'562.02275','267.04468','383.78868','177.801362329617',253,4,0,333,84,0,0,40,174,1,1,0,1),
(21074,21074,'Bound Shaman',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13','25',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,23163,2353,'731.52506','305.35947','499.53679','203.311781207645',253,1,0,333,202,0,0,50,174,1,1,0,1),
(21075,21075,'Slaughter Bathin',0,'',0,'LineageMonster.death_knight','12','31',63,'male','L2Monster',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,16790,1516,'541.44774','262.19426','369.73862','174.571895122369',253,4,500,333,84,0,0,27,174,1,1,0,1),
(21076,21076,'Bathin\'s Knight',0,'',0,'LineageMonster.skeleton_knight','10','25',62,'male','L2Monster',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,16516,1471,'521.12391','257.34267','355.86007','171.341654516443',253,1,0,333,78,0,0,40,174,1,1,0,1),
(21077,21077,'Bathin\'s Wizard',0,'',0,'LineageMonster.banshee','9','23',62,'female','L2Monster',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,16007,1427,'521.12391','257.34267','355.86007','171.341654516443',253,1,0,333,3939,0,0,80,174,1,1,0,1),
(21078,21078,'Magus Valac',0,'',0,'LineageMonster.vale_master','12','40',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,20355,2018,'688.86373','295.91597','470.40463','197.024195544734',253,1,500,333,198,0,0,70,174,1,1,0,1),
(21079,21079,'Valac\'s Creature',0,'',0,'LineageMonster.serpent_slave','17','46',69,'male','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,18497,1810,'667.50361','291.15063','455.81844','193.851368417065',253,4,0,333,150,0,0,70,174,1,1,0,1),
(21080,21080,'Valac\'s Guardian Spirit',0,'',0,'LineageMonster.shadow','10','30',69,'male','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,17096,1673,'667.50361','291.15063','455.81844','193.851368417065',253,8,0,333,0,0,0,80,174,1,1,0,1),
(21081,21081,'Power Angel Amon',0,'',0,'LineageMonster.angel','13.5','36.5',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,21329,2250,'794.70901','319.24623','542.68324','212.557735094503',253,1,500,333,4700,0,0,30,174,1,1,0,1),
(21082,21082,'Amon\'s Captain of the Guards',0,'',0,'LineageMonster.kel_mahum_champion','13','32',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,20511,2138,'773.81598','314.65987','528.41601','209.50409325236',253,4,0,333,150,0,0,50,174,1,1,0,1),
(21083,21083,'Amon\'s Spirits',0,'',0,'LineageMonster.pixy','5','25',74,'female','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,24232,2526,'773.81598','314.65987','528.41601','209.50409325236',253,1,0,333,0,0,0,80,174,1,1,0,1),
(21084,21084,'Bloody Lady',0,'',0,'LineageMonster.bloody_queen','14','40',60,'female','L2Monster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,14806,1285,'481.34551','247.65008','328.69659','164.888215781956',253,4,500,333,0,0,0,80,174,1,1,0,1),
(21085,21085,'Bloody Sniper',0,'',0,'LineageMonster.fiend_archer','17','55',71,'male','L2Monster',1100,'2492.727','1377.8','8.5','3',40,43,30,21,20,20,33449,3356,'710.2185','300.65359','484.98717','200.178552092236',253,8,500,333,0,0,0,70,174,1,1,0,1),
(21086,21086,'Bloody Liviona',0,'',0,'LineageMonster.liviona','15','28',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,33396,3392,'731.52506','305.35947','499.53679','203.311781207645',253,4,500,333,0,0,0,80,174,1,1,0,1),
(21087,21087,'Bloody Knight',0,'',0,'LineageMonster.death_knight','12','31',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,53594,5514,'752.73928','310.02959','514.02335','206.421198742611',253,4,500,333,84,0,0,27,174,1,1,0,1),
(21088,21088,'Bloody Banshee',0,'',0,'LineageMonster.banshee','9','23',74,'female','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,35277,3677,'773.81598','314.65987','528.41601','209.50409325236',253,4,500,333,3939,0,0,80,174,1,1,0,1),
(21089,21089,'Bloody Lord',0,'',0,'LineageMonster.karik','25','90',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,40903,4314,'794.70901','319.24623','542.68324','212.557735094503',253,4,500,333,0,0,0,37,174,1,1,0,1),
(21090,21090,'Bloody Guardian',0,'',0,'LineageMonster.death_blader','15','45',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,31444,3317,'794.70901','319.24623','542.68324','212.557735094503',253,4,500,333,1472,0,0,100,174,1,1,0,1),
(21091,21091,'Bloody Keeper',0,'',0,'LineageMonster.kaim_vanul','24','40',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,21195,2209,'773.81598','314.65987','528.41601','209.50409325236',253,4,0,333,0,0,0,37,174,1,1,0,1),
(21092,21092,'Bloody Mystic',0,'',0,'LineageMonster.banshee','9','23',74,'female','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,20706,2159,'773.81598','314.65987','528.41601','209.50409325236',253,4,0,333,3939,0,0,80,174,1,1,0,1),
(21093,21093,'Ratman Sub Chieftain',0,'',0,'LineageMonster.wererat','14','25',19,'male','L2Monster',40,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,692,31,'40.96915','84.07638','27.97662','55.9790056860875',253,4,400,333,216,0,0,80,150,1,1,1,1),
(21094,21094,'Ratman Chieftain',0,'',0,'LineageMonster.wererat','14','25',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,713,32,'44.32863','86.87049','30.2707','57.8393570613084',253,4,0,333,3,0,0,80,155,1,1,1,1),
(21095,21095,'Giant Poison Bee',0,'',0,'LineageMonster.giant_bee','8','24.5',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,1009,47,'47.91924','89.73059','32.72263','59.7436374813816',253,8,0,333,0,0,0,90,90,1,1,1,1),
(21096,21096,'Cloudy Beast',0,'',0,'LineageMonster.onyx_beast','14','14.5',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,1005,48,'51.75278','92.65694','35.34044','61.6920289224665',253,4,400,333,0,0,0,30,140,1,1,1,1),
(21097,21097,'Young Araneid',0,'',0,'LineageMonster.poison_spider','27','25.5',23,'male','L2Monster',40,'410.70422','231.96','3.5','1.5',40,43,30,21,20,20,1183,58,'55.84125','95.64976','38.13234','63.6846860642986',253,4,400,333,0,0,0,60,130,1,1,1,1),
(21098,21098,'Plain Grizzly',0,'',0,'LineageMonster.grizzly','21','40',24,'male','L2Monster',40,'435.34437','245.52','3.5','1.5',40,43,30,21,20,20,1123,55,'60.19687','98.70919','41.10666','65.7216907961494',253,4,0,333,0,0,0,40,115,1,1,1,1),
(21099,21099,'Cloudy Beast Turen',0,'',0,'LineageMonster.onyx_beast','14','14.5',25,'male','L2Monster',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,1215,61,'64.83203','101.83533','44.27187','67.8031159084826',253,4,400,333,0,0,0,30,145,1,1,1,1),
(21100,21100,'Langk Lizardman Sentinel',0,'',0,'LineageMonster.virud_lizardman','10','23',19,'male','L2Monster',40,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,692,31,'40.96915','84.07638','27.97662','55.9790056860875',253,4,500,333,2,0,0,43,130,1,1,1,1),
(21101,21101,'Langk Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman','10','29',24,'male','L2Monster',40,'435.34437','245.52','3.5','1.5',40,43,30,21,20,20,1123,55,'60.19687','98.70919','41.10666','65.7216907961494',253,1,0,333,6,0,0,43,130,1,1,1,1),
(21102,21102,'Watchman of the Plains',0,'',0,'LineageMonster.magical_weaver','11','20',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,1602,88,'92.64226','118.46427','63.26266','78.8748547991048',253,1,500,333,0,0,0,90,160,1,1,1,1),
(21103,21103,'Roughly Hewn Rock Golem',0,'',0,'LineageMonster.stone_golem_bi','20','40.3',31,'male','L2Monster',40,'635.76437','343.8','4.5','1.8',40,43,30,21,20,20,1677,94,'99.21986','121.98819','67.7543','81.2211098160515',253,1,0,333,0,0,0,23,23,1,1,1,1),
(21104,21104,'Delu Lizardman Supplier',0,'',0,'LineageMonster.virud_lizardman','10','23',32,'male','L2Monster',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,2106,119,'106.16525','125.57727','72.49711','83.6107570481808',253,8,0,333,223,0,0,43,135,1,1,1,1),
(21105,21105,'Delu Lizardman Special Agent',0,'',0,'LineageMonster.virud_lizardman_scout','10','22',33,'male','L2Monster',1100,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,2427,139,'113.49065','129.23095','77.49941','86.043423444366',253,8,0,333,2507,0,0,43,135,1,1,1,1),
(21106,21106,'Cursed Seer',0,'',0,'LineageMonster.magical_weaver','11','20',34,'male','L2Monster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,2058,120,'121.20802','132.9486','82.76936','88.5186722618248',253,1,500,333,0,0,0,90,160,1,1,1,1),
(21107,21107,'Delu Lizardman Commander',0,'',0,'LineageMonster.virud_lizardman_warrior','12','30',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,4354,258,'129.32896','136.72948','88.31491','91.0360303625432',253,4,0,333,93,0,0,52,135,1,1,1,1),
(21108,21108,'Glow Wisp',0,'',0,'LineageMonster.will_o_wisp','13','22',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,7835,746,'624.93199','281.55251','426.74754','187.460838840844',253,1,0,333,0,0,0,80,160,1,1,1,1),
(21109,21109,'Hames Orc Scout',0,'',0,'LineageMonster.ketra_orc','12','29',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,9699,937,'646.17968','286.3615','441.25696','190.662718462344',253,8,0,333,229,0,0,45,185,1,1,1,1),
(21110,21110,'Marsh Predator',0,'',0,'LineageMonster.devastator','35','35',69,'male','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,8268,809,'667.50361','291.15063','455.81844','193.851368417065',253,4,0,333,0,0,0,25,175,1,1,1,1),
(21111,21111,'Lava Wyrm',0,'',0,'LineageMonster.wyrm','29','72',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,8637,857,'688.86373','295.91597','470.40463','197.024195544734',253,4,500,333,0,0,0,70,175,1,1,1,1),
(21112,21112,'Hames Orc Footman',0,'',0,'LineageMonster.ketra_orc','12','29',71,'male','L2Monster',40,'2492.727','1377.8','8.5','3',40,43,30,21,20,20,10470,1050,'710.2185','300.65359','484.98717','200.178552092236',253,4,0,333,233,110,0,45,180,1,1,1,1),
(21113,21113,'Hames Orc Sniper',0,'',0,'LineageMonster.ketra_orc_archer','12','27',72,'male','L2Monster',1100,'2540.15331','1410','8.5','3',40,43,30,21,20,20,11667,1186,'731.52506','305.35947','499.53679','203.311781207645',253,8,0,333,287,0,0,45,160,1,1,1,1),
(21114,21114,'Cursed Guardian',0,'',0,'LineageMonster.death_blader','15','45',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,11078,1140,'752.73928','310.02959','514.02335','206.421198742611',253,4,0,333,1472,0,0,100,175,1,1,1,1),
(21115,21115,'Hames Orc Shaman',0,'',0,'LineageMonster.ketra_orc_shaman','10','23',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,9652,1006,'773.81598','314.65987','528.41601','209.50409325236',253,1,0,333,186,0,0,10,145,1,1,1,1),
(21116,21116,'Hames Orc Overlord',0,'',0,'LineageMonster.ketra_orc_warrior','12','24',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,15240,1608,'794.70901','319.24623','542.68324','212.557735094503',253,4,500,333,75,103,0,36,175,1,1,1,1),
(21117,21117,'Kasha Imp',0,'',0,'LineageMonster.imp_bi','10','30',19,'male','L2Monster',40,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,678,30,'40.96915','84.07638','27.97662','55.9790056860875',253,4,0,333,0,0,0,60,85,1,1,1,1),
(21118,21118,'Baar Dre Vanul',0,'',0,'LineageMonster.dre_vanul','14','36',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,727,32,'44.32863','86.87049','30.2707','57.8393570613084',253,4,400,333,0,0,0,80,85,1,1,1,1),
(21119,21119,'Hobgoblin',0,'',0,'LineageMonster.hobgoblin','12','24',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,917,42,'47.91924','89.73059','32.72263','59.7436374813816',253,1,0,333,4,0,0,45,110,1,1,1,1),
(21120,21120,'Kasha Imp Turen',0,'',0,'LineageMonster.imp_bi','10','30',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,1196,56,'51.75278','92.65694','35.34044','61.6920289224665',253,4,400,333,0,0,0,60,85,1,1,1,1),
(21121,21121,'Kasha Dire Wolf',0,'',0,'LineageMonster.dire_wolf','13','11',23,'male','L2Monster',40,'410.70422','231.96','3.5','1.5',40,43,30,21,20,20,1075,52,'55.84125','95.64976','38.13234','63.6846860642986',253,4,400,333,0,0,0,24,135,1,1,1,1),
(21122,21122,'Kasha Bugbear',0,'',0,'LineageMonster.bugbear','17','35',24,'male','L2Monster',40,'435.34437','245.52','3.5','1.5',40,43,30,21,20,20,1145,56,'60.19687','98.70919','41.10666','65.7216907961494',253,1,400,333,169,0,0,55,130,1,1,1,1),
(21123,21123,'Baar Dre Vanul Destroyer',0,'',0,'LineageMonster.dre_vanul','14','36',25,'male','L2Monster',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,1521,76,'64.83203','101.83533','44.27187','67.8031159084826',253,4,400,333,0,0,0,80,85,1,1,1,1),
(21124,21124,'Red Eye Barbed Bat',0,'',0,'LineageMonster.vampire_bat','10','33.5',18,'male','L2Monster',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,640,28,'37.82932','81.34791','25.83252','54.1623558855199',253,4,0,333,0,0,0,60,90,1,1,1,1),
(21125,21125,'Northern Trimden',0,'',0,'LineageMonster.poison_spider','27','25.5',19,'male','L2Monster',40,'321.63954','183.28','2.5','1.2',40,43,30,21,20,20,685,31,'40.96915','84.07638','27.97662','55.9790056860875',253,4,400,333,0,0,0,60,140,1,1,1,1),
(21126,21126,'Kerope Werewolf',0,'',0,'LineageMonster.werewolf_bi','11','29.7',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,713,32,'44.32863','86.87049','30.2707','57.8393570613084',253,1,0,333,0,0,0,50,125,1,1,1,1),
(21127,21127,'Northern Goblin',0,'',0,'LineageMonster2.northern_goblin','4','15',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,917,42,'47.91924','89.73059','32.72263','59.7436374813816',253,1,0,333,152,0,0,30,120,1,1,1,1),
(21128,21128,'Spine Golem',0,'',0,'LineageMonster.stone_golem_bi','20','40.3',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,986,47,'51.75278','92.65694','35.34044','61.6920289224665',253,1,0,333,0,0,0,23,23,1,1,1,1),
(21129,21129,'Kerope Werewolf Chief',0,'',0,'LineageMonster.werewolf_bi','11','29.7',23,'male','L2Monster',40,'410.70422','231.96','3.5','1.5',40,43,30,21,20,20,1075,52,'55.84125','95.64976','38.13234','63.6846860642986',253,1,400,333,0,0,0,50,140,1,1,1,1),
(21130,21130,'Northern Goblin Leader',0,'',0,'LineageMonster2.northern_goblin','4','15',24,'male','L2Monster',40,'435.34437','245.52','3.5','1.5',40,43,30,21,20,20,1145,56,'60.19687','98.70919','41.10666','65.7216907961494',253,1,400,333,66,102,0,30,125,1,1,1,1),
(21131,21131,'Enchanted Spine Golem',0,'',0,'LineageMonster.stone_golem_bi','20','40.3',25,'male','L2Monster',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,1191,60,'64.83203','101.83533','44.27187','67.8031159084826',253,1,0,333,0,0,0,23,29,1,1,1,1),
(21132,21132,'Underground Kobold',0,'',0,'LineageMonster.kobold','10','15',24,'male','L2Monster',40,'435.34437','245.52','3.5','1.5',40,43,30,21,20,20,935,46,'60.19687','98.70919','41.10666','65.7216907961494',253,4,0,333,0,0,0,47,110,1,1,0,1),
(21133,21133,'Dead Pit Skeleton Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',25,'male','L2Monster',1100,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,1022,52,'64.83203','101.83533','44.27187','67.8031159084826',253,8,0,333,274,0,0,40,130,1,1,0,1),
(21134,21134,'Dead Pit Spartoi',0,'',0,'LineageMonster.spartoi','11','27',26,'male','L2Monster',40,'487.5704','273','3.5','1.5',40,43,30,21,20,20,1078,54,'69.75926','105.02818','47.63653','69.9289432036824',253,4,400,333,219,0,0,60,145,1,1,0,1),
(21135,21135,'Underground Kobold Warrior',0,'',0,'LineageMonster.kobold','10','15',27,'male','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,1325,67,'74.99121','108.28767','51.20928','72.0991544841329',253,4,0,333,0,0,0,47,115,1,1,0,1),
(21136,21136,'Dead Pit Horror',0,'',0,'LineageMonster.dark_horror','20','35',28,'male','L2Monster',40,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,1178,62,'80.54056','111.61368','54.99876','74.3136496629463',253,4,0,333,0,0,0,100,100,1,1,0,1),
(21137,21137,'Iron Ore Golem',0,'',0,'LineageMonster.iron_golem','18','34',29,'male','L2Monster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,1268,68,'86.42002','115.00598','59.01367','76.5722740603874',253,1,400,333,0,0,0,20,21,1,1,0,1),
(21138,21138,'Greedy Geist',0,'',0,'LineageMonster.hungry_spirit','30','40',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,1361,74,'92.64226','118.46427','63.26266','78.8748547991048',253,1,0,333,0,0,0,15,150,1,1,0,1),
(21139,21139,'Catacomb Barbed Bat',0,'',0,'LineageMonster.vampire_bat','10','33.5',23,'male','L2Monster',40,'410.70422','231.96','3.5','1.5',40,43,30,21,20,20,2621,127,'55.84125','95.64976','38.13234','63.6846860642986',253,4,500,333,0,0,0,60,130,1,1,0,1),
(21140,21140,'Catacomb Wisp',0,'',0,'LineageMonster.will_o_wisp','13','22',26,'male','L2Monster',40,'487.5704','273','3.5','1.5',40,43,30,21,20,20,3153,159,'69.75926','105.02818','47.63653','69.9289432036824',253,1,500,333,0,0,0,80,120,1,1,0,1),
(21141,21141,'Catacomb Serpent',0,'',0,'LineageMonster.serpent_slave','17','46',28,'male','L2Monster',40,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,3706,194,'80.54056','111.61368','54.99876','74.3136496629463',253,4,500,333,73,0,0,70,130,1,1,0,1),
(21142,21142,'Grave Keeper Spartoi',0,'',0,'LineageMonster.spartoi','11','27',29,'male','L2Monster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,3710,199,'86.42002','115.00598','59.01367','76.5722740603874',253,4,500,333,221,0,0,60,140,1,1,0,1),
(21143,21143,'Catacomb Scavenger Bat',0,'',0,'LineageMonster.vampire_bat','10','33.5',31,'male','L2Monster',40,'635.76437','343.8','4.5','1.8',40,43,30,21,20,20,4170,231,'99.21986','121.98819','67.7543','81.2211098160515',253,4,500,333,0,0,0,60,140,1,1,0,1),
(21144,21144,'Catacomb Shadow',0,'',0,'LineageMonster.shadow','10','30',34,'male','L2Monster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,5016,293,'121.20802','132.9486','82.76936','88.5186722618248',253,1,500,333,0,0,0,80,130,1,1,0,1),
(21145,21145,'Catacomb Stakato Soldier',0,'',0,'LineageMonster.blade_stakato_soldier','15','38',38,'male','L2Monster',40,'886.09975','447.96','4.5','1.8',40,43,30,21,20,20,6444,402,'156.22273','148.44287','106.67987','98.8349371271581',253,4,500,333,232,0,0,25,150,1,1,0,1),
(21146,21146,'Grave Keeper Dark Horror',0,'',0,'LineageMonster.dark_horror','20','35',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,6943,448,'176.36077','156.55035','120.43155','104.232986928232',253,4,500,333,0,0,0,100,160,1,1,0,1),
(21147,21147,'Catacomb Gargoyle',0,'',0,'LineageMonster.gargoyle','16','50',43,'male','L2Monster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,8457,572,'210.04832','169.13417','143.43577','112.611442266143',253,4,500,333,0,0,0,140,170,1,1,0,1),
(21148,21148,'Catacomb Liviona',0,'',0,'LineageMonster.liviona','15','28',44,'male','L2Monster',40,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,8401,575,'222.23112','173.43552','151.75505','115.475328468187',253,1,500,333,0,0,0,80,140,1,1,0,1),
(21149,21149,'Decayed Ancient Pikeman',0,'',0,'LineageMonster.skeleton_pikeman','10','28',46,'male','L2Monster',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,20,9679,686,'248.0526','182.18816','169.38777','121.302932993263',253,4,500,333,96,0,0,50,170,1,1,0,1),
(21150,21150,'Decayed Ancient Soldier',0,'',0,'LineageMonster.skeleton_knight','10','25',49,'male','L2Monster',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,10982,812,'290.44588','195.66302','198.33688','130.274648808072',253,4,500,333,125,0,0,40,160,1,1,0,1),
(21151,21151,'Decayed Ancient Knight',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,11435,861,'305.54906','200.23844','208.6504','133.321011603844',253,4,500,333,227,0,0,80,170,1,1,0,1),
(21152,21152,'Purgatory Wisp',0,'',0,'LineageMonster.will_o_wisp','13','22',53,'male','L2Monster',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,12189,958,'353.71092','214.18326','241.5387','142.605626325743',253,1,500,333,0,0,0,80,150,1,1,0,1),
(21153,21153,'Purgatory Serpent',0,'',0,'LineageMonster.serpent_slave','17','46',56,'male','L2Monster',40,'1724.6831','918.8','6.5','2.4',40,43,30,21,20,20,14344,1178,'405.96455','228.40135','277.22116','152.072199009316',253,4,500,333,73,0,0,70,175,1,1,0,1),
(21154,21154,'Hell Keeper Medusa',0,'',0,'LineageMonster.medusa','10','25',58,'female','L2Monster',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,20,15013,1268,'442.8992','237.99429','302.44274','158.459289236126',253,4,500,333,0,0,0,50,165,1,1,0,1),
(21155,21155,'Purgatory Conjurer',0,'',0,'LineageMonster.vampire_bat','10','33.5',59,'male','L2Monster',40,'1880.92519','1007','6.5','2.4',40,43,30,21,20,20,15105,1291,'461.94387','242.81593','315.44778','161.669585254993',253,4,500,333,0,0,0,60,175,1,1,0,1),
(21156,21156,'Purgatory Shadow',0,'',0,'LineageMonster.shadow','10','30',61,'male','L2Monster',40,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,16146,1421,'501.08068','252.49346','342.17315','168.112997103103',253,1,500,333,0,0,0,80,155,1,1,0,1),
(21157,21157,'Purgatory Tarantula',0,'',0,'LineageMonster.poison_spider','27','25.5',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,18280,1674,'562.02275','267.04468','383.78868','177.801362329617',253,4,500,333,0,0,0,60,175,1,1,0,1),
(21158,21158,'Hell Keeper Crimson Doll',0,'',0,'LineageMonster.crimson_doll','15','38',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,20533,1955,'624.93199','281.55251','426.74754','187.460838840844',253,4,500,333,0,0,0,60,180,1,1,0,1),
(21159,21159,'Purgatory Gargoyle',0,'',0,'LineageMonster.gargoyle','16','50',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,21151,2043,'646.17968','286.3615','441.25696','190.662718462344',253,4,500,333,0,0,0,140,175,1,1,0,1),
(21160,21160,'Purgatory Liviona',0,'',0,'LineageMonster.liviona','15','28',71,'male','L2Monster',40,'2492.727','1377.8','8.5','3',40,43,30,21,20,20,21874,2195,'710.2185','300.65359','484.98717','200.178552092236',253,1,500,333,0,0,0,80,160,1,1,0,1),
(21161,21161,'Lesser Ancient Soldier',0,'',0,'LineageMonster.medusa','10','25',73,'female','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,23782,2447,'752.73928','310.02959','514.02335','206.421198742611',253,4,500,333,0,0,0,50,180,1,1,0,1),
(21162,21162,'Lesser Ancient Scout',0,'',0,'LineageMonster.blade_stakato_drone','15','39',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,23761,2477,'773.81598','314.65987','528.41601','209.50409325236',253,4,500,333,135,0,0,25,160,1,1,0,1),
(21163,21163,'Lesser Ancient Shaman',0,'',0,'LineageMonster.silhouette','8','23',76,'female','L2Monster',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,20,25063,2679,'815.37145','323.78455','556.793','215.579412824268',253,4,500,333,0,0,0,80,200,1,1,0,1),
(21164,21164,'Guardian Spirit of Ancient Holy Ground',0,'',0,'LineageMonster.death_lord','21','40',78,'male','L2Monster',40,'2870.7774087','1657.41','8.585','3.03',40,43,30,21,20,20,28547,3164,'884.2525659','340.4407808','609.868172336','226.669315301277',253,4,500,333,78,0,0,40,190,1,1,0,1),
(21165,21165,'Lesser Ancient Warrior',0,'',0,'LineageMonster.shadeless','7','28',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,31048,3485,'912.6537108','348.2025','635.688655236','231.837152158566',253,1,500,333,0,0,0,48,200,1,1,0,1),
(21166,21166,'Lith Scout',0,'',0,'LineageMonster2.temple_guard_a_20_sm','12','33.6',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,2380,109,'47.91924','89.73059','32.72263','59.7436374813816',253,8,0,333,5795,0,0,53,130,1,1,0,1),
(21167,21167,'Lith Witch',0,'',0,'LineageMonster2.temple_savant_a_20_sm','8','32',24,'male','L2Monster',40,'435.34437','245.52','3.5','1.5',40,43,30,21,20,20,2763,136,'60.19687','98.70919','41.10666','65.7216907961494',253,1,0,333,5797,0,0,25,110,1,1,0,1),
(21168,21168,'Lith Warrior',0,'',0,'LineageMonster2.temple_guard_b_20_sm','12','33.6',27,'male','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,3420,175,'74.99121','108.28767','51.20928','72.0991544841329',253,4,0,333,5796,0,0,53,130,1,1,0,1),
(21169,21169,'Lith Guard',0,'',0,'LineageMonster2.temple_guard_a','15','42',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,4532,248,'92.64226','118.46427','63.26266','78.8748547991048',253,8,0,333,5795,0,0,53,140,1,1,0,1),
(21170,21170,'Lith Medium',0,'',0,'LineageMonster2.temple_savant_a','10','40',33,'male','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,5231,300,'113.49065','129.23095','77.49941','86.043423444366',253,1,0,333,5797,0,0,25,120,1,1,0,1),
(21171,21171,'Lith Overlord',0,'',0,'LineageMonster2.temple_guard_b','15','42',36,'male','L2Monster',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,6677,404,'137.86467','140.57278','94.1437','93.5949427192352',253,4,0,333,5796,0,0,53,140,1,1,0,1),
(21172,21172,'Lith Patrolman',0,'',0,'LineageMonster2.temple_guard_a','15','42',39,'male','L2Monster',40,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,7888,501,'166.06476','152.46752','113.4007','101.514599764346',253,8,0,333,5795,0,0,53,150,1,1,0,1),
(21173,21173,'Lith Shaman',0,'',0,'LineageMonster2.temple_savant_a','10','40',42,'male','L2Monster',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,8473,564,'198.34591','164.88513','135.44454','109.782377202178',253,1,0,333,5798,0,0,25,130,1,1,0,1),
(21174,21174,'Lith Commander',0,'',0,'LineageMonster2.temple_guard_b','15','42',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,10925,760,'234.89829','177.78746','160.40508','118.372898457316',253,4,0,333,5796,0,0,53,150,1,1,0,1),
(21175,21175,'Lilim Butcher',0,'',0,'LineageMonster2.lilim_assassin_10_sm','11','36',48,'male','L2Monster',40,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,12374,904,'275.82705','191.12803','188.35412','127.255200286259',253,8,0,333,232,232,0,36,170,1,1,0,1),
(21176,21176,'Lilim Magus',0,'',0,'LineageMonster2.lilim_wizard_10_sm','8','30.6',51,'female','L2Monster',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,20,12493,953,'321.13207','204.85194','219.29157','136.392732777413',253,1,0,333,0,0,0,50,140,1,1,0,1),
(21177,21177,'Lilim Knight Errant',0,'',0,'LineageMonster2.lilim_knight_10_sm','11','45',54,'male','L2Monster',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,17542,1399,'370.68904','218.89589','253.13256','145.743350252286',253,4,0,333,5800,5799,0,56,170,1,1,0,1),
(21178,21178,'Lilim Marauder',0,'',0,'LineageMonster2.lilim_assassin_10_sm','11','36',57,'male','L2Monster',40,'1776.58018','948','6.5','2.4',40,43,30,21,20,20,18790,1561,'424.23295','233.18839','289.69611','155.259456846417',253,8,0,333,229,229,0,36,180,1,1,0,1),
(21179,21179,'Lilim Priest',0,'',0,'LineageMonster2.lilim_wizard_10_sm','8','30.6',60,'female','L2Monster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,17292,1501,'481.34551','247.65008','328.69659','164.888215781956',253,1,0,333,0,0,0,50,160,1,1,0,1),
(21180,21180,'Lilim Knight',0,'',0,'LineageMonster2.lilim_knight_10_sm','11','45',63,'male','L2Monster',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,25957,2344,'541.44774','262.19426','369.73862','174.571895122369',253,4,0,333,5800,5799,0,56,180,1,1,0,1),
(21181,21181,'Lilim Assassin',0,'',0,'LineageMonster2.lilim_assassin_10_bi','13','44',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,27475,2586,'603.79903','276.72752','412.31647','184.248304515217',253,8,0,333,234,234,0,36,190,1,1,0,1),
(21182,21182,'Lilim Soldier',0,'',0,'LineageMonster2.lilim_wizard_10_bi','10','37.5',69,'female','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,22868,2237,'667.50361','291.15063','455.81844','193.851368417065',253,1,0,333,0,0,0,50,170,1,1,0,1),
(21183,21183,'Lilim Knight Commander',0,'',0,'LineageMonster2.lilim_knight_10_bi','13','55',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,33903,3444,'731.52506','305.35947','499.53679','203.311781207645',253,4,0,333,5800,5799,0,56,190,1,1,0,1),
(21184,21184,'Lilim Slayer',0,'',0,'LineageMonster2.lilim_assassin_10_bi','13','44',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,35479,3742,'794.70901','319.24623','542.68324','212.557735094503',253,8,0,333,236,236,0,36,200,1,1,0,1),
(21185,21185,'Lilim Great Mystic',0,'',0,'LineageMonster2.lilim_wizard_10_bi','10','37.5',78,'female','L2Monster',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,29223,3198,'855.81387','332.70061','584.40994','221.515820894982',253,1,0,333,0,0,0,50,180,1,1,0,1),
(21186,21186,'Lilim Court Knight',0,'',0,'LineageMonster2.lilim_knight_10_bi','13','55',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,41856,4698,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,0,333,5800,5799,0,56,200,1,1,0,1),
(21187,21187,'Gigant Slave',0,'',0,'LineageMonster2.tomb_guard_a_20_sm','8','32',21,'male','L2Monster',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,2380,109,'47.91924','89.73059','32.72263','59.7436374813816',253,4,0,333,5791,0,0,49,130,1,1,0,1),
(21188,21188,'Gigant Acolyte',0,'',0,'LineageMonster2.tomb_savant_a_20_sm','8','32',24,'male','L2Monster',40,'435.34437','245.52','3.5','1.5',40,43,30,21,20,20,2763,136,'60.19687','98.70919','41.10666','65.7216907961494',253,1,0,333,5793,0,0,49,110,1,1,0,1),
(21189,21189,'Gigant Overseer',0,'',0,'LineageMonster2.tomb_guard_b_20_sm','12','34',27,'male','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,3420,175,'74.99121','108.28767','51.20928','72.0991544841329',253,4,0,333,5792,0,0,49,130,1,1,0,1),
(21190,21190,'Gigant Footman',0,'',0,'LineageMonster2.tomb_guard_a','10','40',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,4532,248,'92.64226','118.46427','63.26266','78.8748547991048',253,4,0,333,5791,0,0,49,140,1,1,0,1),
(21191,21191,'Gigant Cleric',0,'',0,'LineageMonster2.tomb_savant_a','10','40',33,'male','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,5231,300,'113.49065','129.23095','77.49941','86.043423444366',253,1,0,333,5793,0,0,49,120,1,1,0,1),
(21192,21192,'Gigant Officer',0,'',0,'LineageMonster2.tomb_guard_b','15','42.5',36,'male','L2Monster',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,6677,404,'137.86467','140.57278','94.1437','93.5949427192352',253,4,0,333,5792,0,0,49,140,1,1,0,1),
(21193,21193,'Gigant Raider',0,'',0,'LineageMonster2.tomb_guard_a','10','40',39,'male','L2Monster',40,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,7888,501,'166.06476','152.46752','113.4007','101.514599764346',253,4,0,333,5791,0,0,49,150,1,1,0,1),
(21194,21194,'Gigant Confessor',0,'',0,'LineageMonster2.tomb_savant_a','10','40',42,'male','L2Monster',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,8473,564,'198.34591','164.88513','135.44454','109.782377202178',253,1,0,333,5794,0,0,49,130,1,1,0,1),
(21195,21195,'Gigant Commander',0,'',0,'LineageMonster2.tomb_guard_b','15','42.5',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,10925,760,'234.89829','177.78746','160.40508','118.372898457316',253,4,0,333,5792,0,0,49,150,1,1,0,1),
(21196,21196,'Nephilim Sentinel',0,'',0,'LineageMonster2.nephilim_slayer_10_sm','11','32.4',48,'male','L2Monster',40,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,12374,904,'275.82705','191.12803','188.35412','127.255200286259',253,4,0,333,0,0,0,65,170,1,1,0,1),
(21197,21197,'Nephilim Priest',0,'',0,'LineageMonster2.nephilim_priest_10_sm','21','36.5',51,'male','L2Monster',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,20,13567,1034,'321.13207','204.85194','219.29157','136.392732777413',253,1,0,333,0,0,0,50,140,1,1,0,1),
(21198,21198,'Nephilim Swordsman',0,'',0,'LineageMonster2.nephilim_lord_10_sm','11','39',54,'male','L2Monster',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,17542,1399,'370.68904','218.89589','253.13256','145.743350252286',253,4,0,333,0,0,0,65,170,1,1,0,1),
(21199,21199,'Nephilim Guard',0,'',0,'LineageMonster2.nephilim_slayer_10_sm','11','32.4',57,'male','L2Monster',40,'1776.58018','948','6.5','2.4',40,43,30,21,20,20,18790,1561,'424.23295','233.18839','289.69611','155.259456846417',253,4,0,333,0,0,0,65,180,1,1,0,1),
(21200,21200,'Nephilim Bishop',0,'',0,'LineageMonster2.nephilim_priest_10_sm','21','36.5',60,'male','L2Monster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,18777,1630,'481.34551','247.65008','328.69659','164.888215781956',253,1,0,333,0,0,0,50,160,1,1,0,1),
(21201,21201,'Nephilim Centurion',0,'',0,'LineageMonster2.nephilim_lord_10_sm','11','39',63,'male','L2Monster',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,25957,2344,'541.44774','262.19426','369.73862','174.571895122369',253,4,0,333,0,0,0,65,180,1,1,0,1),
(21202,21202,'Nephilim Scout',0,'',0,'LineageMonster2.nephilim_slayer_10_bi','13','39.6',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,27475,2586,'603.79903','276.72752','412.31647','184.248304515217',253,4,0,333,0,0,0,65,190,1,1,0,1),
(21203,21203,'Nephilim Archbishop',0,'',0,'LineageMonster2.nephilim_priest_10_bi','21','44',69,'male','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,24833,2430,'667.50361','291.15063','455.81844','193.851368417065',253,1,0,333,0,0,0,50,170,1,1,0,1),
(21204,21204,'Nephilim Praetorian',0,'',0,'LineageMonster2.nephilim_lord_10_bi','13','48',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,33903,3444,'731.52506','305.35947','499.53679','203.311781207645',253,4,0,333,0,0,0,65,190,1,1,0,1),
(21205,21205,'Nephilim Royal Guard',0,'',0,'LineageMonster2.nephilim_slayer_10_bi','13','39.6',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,35479,3742,'794.70901','319.24623','542.68324','212.557735094503',253,4,0,333,0,0,0,65,200,1,1,0,1),
(21206,21206,'Nephilim Cardinal',0,'',0,'LineageMonster2.nephilim_priest_10_bi','21','44',78,'male','L2Monster',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,31734,3473,'855.81387','332.70061','584.40994','221.515820894982',253,1,0,333,0,0,0,50,180,1,1,0,1),
(21207,21207,'Nephilim Commander',0,'',0,'LineageMonster2.nephilim_lord_10_bi','13','48',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,41856,4698,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,0,333,0,0,0,65,200,1,1,0,1),
(21208,21208,'Hallowed Watchman',0,'',0,'LineageMonster.skeleton','11','25',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,2085,92,'44.32863','86.87049','30.2707','57.8393570613084',253,4,0,333,216,111,0,60,130,1,1,0,1),
(21209,21209,'Hallowed Seer',0,'',0,'LineageMonster.binding','12','21',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,2450,116,'51.75278','92.65694','35.34044','61.6920289224665',253,1,500,333,0,0,0,10,110,1,1,0,1),
(21210,21210,'Vault Guardian',0,'',0,'LineageMonster.imp','10','24',25,'male','L2Monster',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,3121,156,'64.83203','101.83533','44.27187','67.8031159084826',253,4,500,333,0,0,0,60,130,1,1,0,1),
(21211,21211,'Vault Seer',0,'',0,'LineageMonster.succubus','10','36',27,'female','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,3321,170,'74.99121','108.28767','51.20928','72.0991544841329',253,4,500,333,0,0,0,60,110,1,1,0,1),
(21212,21212,'Hallowed Sentinel',0,'',0,'LineageMonster.skeleton_bi','11','31',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,3829,209,'92.64226','118.46427','63.26266','78.8748547991048',253,4,0,333,69,646,0,60,140,1,1,0,1),
(21213,21213,'Hallowed Monk',0,'',0,'LineageMonster.binding_20_bi','14','25.3',32,'male','L2Monster',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,4443,250,'106.16525','125.57727','72.49711','83.6107570481808',253,1,500,333,0,0,0,10,110,1,1,0,1),
(21214,21214,'Vault Sentinel',0,'',0,'LineageMonster.imp_bi','10','30',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,5603,332,'129.32896','136.72948','88.31491','91.0360303625432',253,4,500,333,0,0,0,60,140,1,1,0,1),
(21215,21215,'Vault Monk',0,'',0,'LineageMonster.succubus_bi','10','43.2',37,'female','L2Monster',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,20,5940,365,'146.82587','144.47758','100.26304','96.1948088105753',253,4,500,333,0,0,0,60,120,1,1,0,1),
(21216,21216,'Overlord of the Holy Lands',0,'',0,'LineageMonster.skeleton_knight_20_bi','12','30.5',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,6807,440,'176.36077','156.55035','120.43155','104.232986928232',253,4,0,333,129,646,0,40,160,1,1,0,1),
(21217,21217,'Hallowed Priest',0,'',0,'LineageMonster.banshee_20_bi','10','27.5',42,'female','L2Monster',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,7654,510,'198.34591','164.88513','135.44454','109.782377202178',253,4,500,333,0,0,0,80,135,1,1,0,1),
(21218,21218,'Vault Overlord',0,'',0,'LineageMonster.death_blader_10_sm','14','40.5',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,9263,644,'234.89829','177.78746','160.40508','118.372898457316',253,4,500,333,297,0,0,100,160,1,1,0,1),
(21219,21219,'Vault Priest',0,'',0,'LineageMonster.bloody_queen_10_sm','13','38',47,'female','L2Monster',40,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,9585,687,'261.69549','186.63569','178.7041','124.264149144103',253,4,500,333,0,0,0,80,135,1,1,0,1),
(21220,21220,'Sepulcher Archon',0,'',0,'LineageMonster.skeleton_knight_30_bi','13','33',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,10635,801,'305.54906','200.23844','208.6504','133.321011603844',253,4,0,333,131,107,0,40,170,1,1,0,1),
(21221,21221,'Sepulcher Inquisitor',0,'',0,'LineageMonster.banshee_30_bi','11','30',52,'female','L2Monster',40,'1520.38155','804','6.5','2.4',40,43,30,21,20,20,11733,908,'337.18867','209.50106','230.25615','139.488165444537',253,4,500,333,0,0,0,80,145,1,1,0,1),
(21222,21222,'Sepulcher Archon',0,'',0,'LineageMonster.death_blader_10_bi','16','49.5',55,'male','L2Monster',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,13837,1117,'388.11142','223.6362','265.02979','148.899508363765',253,4,500,333,298,0,0,100,170,1,1,0,1),
(21223,21223,'Sepulcher Inquisitor',0,'',0,'LineageMonster.bloody_queen_10_bi','15','46',57,'female','L2Monster',40,'1776.58018','948','6.5','2.4',40,43,30,21,20,20,14098,1172,'424.23295','233.18839','289.69611','155.259456846417',253,4,500,333,0,0,0,80,145,1,1,0,1),
(21224,21224,'Sepulcher Guardian',0,'',0,'LineageMonster.skeleton_royal_guard_20_bi','13','34.5',60,'male','L2Monster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,15315,1329,'481.34551','247.65008','328.69659','164.888215781956',253,8,0,333,233,0,0,80,190,1,1,0,1),
(21225,21225,'Sepulcher Sage',0,'',0,'LineageMonster.vale_master_10_bi','13','44',62,'male','L2Monster',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,16680,1486,'521.12391','257.34267','355.86007','171.341654516443',253,4,500,333,311,0,0,70,160,1,1,0,1),
(21226,21226,'Sepulcher Guardian',0,'',0,'LineageMonster.death_knight','12','31',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,19326,1795,'582.81759','271.89033','397.98887','181.027644954078',253,4,500,333,0,0,0,27,190,1,1,0,1),
(21227,21227,'Sepulcher Sage',0,'',0,'LineageMonster.doll_master','20','42',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,21777,2074,'624.93199','281.55251','426.74754','187.460838840844',253,4,500,333,0,0,0,80,160,1,1,0,1),
(21228,21228,'Sepulcher Guard',0,'',0,'LineageMonster.skeleton_royal_guard_30_bi','14','37.5',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,20845,2067,'688.86373','295.91597','470.40463','197.024195544734',253,8,0,333,236,0,0,80,200,1,1,0,1),
(21229,21229,'Sepulcher Preacher',0,'',0,'LineageMonster.vale_master_30_bi','15','52',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,22494,2285,'731.52506','305.35947','499.53679','203.311781207645',253,4,500,333,326,0,0,70,165,1,1,0,1),
(21230,21230,'Sepulcher Guard',0,'',0,'LineageMonster.death_knight','12','31',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,25729,2714,'794.70901','319.24623','542.68324','212.557735094503',253,4,500,333,0,0,0,27,200,1,1,0,1),
(21231,21231,'Sepulcher Preacher',0,'',0,'LineageMonster.doll_master_20_bi','24','50.4',77,'male','L2Monster',40,'2762.08447','1574','8.5','3',40,43,30,21,20,20,25727,2784,'835.75573','328.27073','570.71283','218.566351305224',253,4,500,333,0,0,0,80,165,1,1,0,1),
(21232,21232,'Barrow Guardian',0,'',0,'LineageMonster.skeleton','11','25',20,'male','L2Monster',40,'342.5127','192','2.5','1.2',40,43,30,21,20,20,2085,92,'44.32863','86.87049','30.2707','57.8393570613084',253,4,0,333,216,0,0,60,130,1,1,0,1),
(21233,21233,'Barrow Seer',0,'',0,'LineageMonster.binding','12','21',22,'male','L2Monster',40,'387.02878','218.52','3.5','1.5',40,43,30,21,20,20,2450,116,'51.75278','92.65694','35.34044','61.6920289224665',253,1,500,333,0,0,0,10,110,1,1,0,1),
(21234,21234,'Grave Guardian',0,'',0,'LineageMonster.imp','10','24',25,'male','L2Monster',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,3121,156,'64.83203','101.83533','44.27187','67.8031159084826',253,4,500,333,0,0,0,60,130,1,1,0,1),
(21235,21235,'Grave Seer',0,'',0,'LineageMonster.succubus','10','36',27,'female','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,3321,170,'74.99121','108.28767','51.20928','72.0991544841329',253,4,500,333,0,0,0,60,110,1,1,0,1),
(21236,21236,'Barrow Sentinel',0,'',0,'LineageMonster.skeleton_bi','11','31',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,3829,209,'92.64226','118.46427','63.26266','78.8748547991048',253,4,0,333,69,0,0,60,140,1,1,0,1),
(21237,21237,'Barrow Monk',0,'',0,'LineageMonster.binding_20_bi','14','25.3',32,'male','L2Monster',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,4443,250,'106.16525','125.57727','72.49711','83.6107570481808',253,1,500,333,0,0,0,10,110,1,1,0,1),
(21238,21238,'Grave Sentinel',0,'',0,'LineageMonster.imp_bi','10','30',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,5603,332,'129.32896','136.72948','88.31491','91.0360303625432',253,4,500,333,0,0,0,60,140,1,1,0,1),
(21239,21239,'Grave Monk',0,'',0,'LineageMonster.succubus_bi','10','43.2',37,'female','L2Monster',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,20,5940,365,'146.82587','144.47758','100.26304','96.1948088105753',253,4,500,333,0,0,0,60,120,1,1,0,1),
(21240,21240,'Barrow Overlord',0,'',0,'LineageMonster.skeleton_knight_20_bi','12','30.5',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,6807,440,'176.36077','156.55035','120.43155','104.232986928232',253,4,0,333,129,0,0,40,160,1,1,0,1),
(21241,21241,'Barrow Priest',0,'',0,'LineageMonster.banshee_20_bi','10','27.5',42,'female','L2Monster',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,7654,510,'198.34591','164.88513','135.44454','109.782377202178',253,4,500,333,0,0,0,80,135,1,1,0,1),
(21242,21242,'Grave Overlord',0,'',0,'LineageMonster.death_blader_10_sm','14','40.5',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,9263,644,'234.89829','177.78746','160.40508','118.372898457316',253,4,500,333,297,0,0,100,160,1,1,0,1),
(21243,21243,'Grave Priest',0,'',0,'LineageMonster.bloody_queen_10_sm','13','38',47,'female','L2Monster',40,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,9585,687,'261.69549','186.63569','178.7041','124.264149144103',253,4,500,333,0,0,0,80,135,1,1,0,1),
(21244,21244,'Crypt Archon',0,'',0,'LineageMonster.skeleton_knight_30_bi','13','33',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,10635,801,'305.54906','200.23844','208.6504','133.321011603844',253,4,0,333,131,0,0,40,170,1,1,0,1),
(21245,21245,'Crypt Inquisitor',0,'',0,'LineageMonster.banshee_30_bi','11','30',52,'female','L2Monster',40,'1520.38155','804','6.5','2.4',40,43,30,21,20,20,11733,908,'337.18867','209.50106','230.25615','139.488165444537',253,4,500,333,0,0,0,80,145,1,1,0,1),
(21246,21246,'Tomb Archon',0,'',0,'LineageMonster.death_blader_10_bi','16','49.5',55,'male','L2Monster',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,13837,1117,'388.11142','223.6362','265.02979','148.899508363765',253,4,500,333,298,0,0,100,170,1,1,0,1),
(21247,21247,'Tomb Inquisitor',0,'',0,'LineageMonster.bloody_queen_10_bi','15','46',57,'female','L2Monster',40,'1776.58018','948','6.5','2.4',40,43,30,21,20,20,14098,1172,'424.23295','233.18839','289.69611','155.259456846417',253,4,500,333,0,0,0,80,145,1,1,0,1),
(21248,21248,'Crypt Guardian',0,'',0,'LineageMonster.skeleton_royal_guard_20_bi','13','34.5',60,'male','L2Monster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,15315,1329,'481.34551','247.65008','328.69659','164.888215781956',253,8,0,333,233,0,0,80,190,1,1,0,1),
(21249,21249,'Crypt Sage',0,'',0,'LineageMonster.vale_master_10_bi','13','44',62,'male','L2Monster',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,16680,1486,'521.12391','257.34267','355.86007','171.341654516443',253,4,500,333,311,0,0,70,160,1,1,0,1),
(21250,21250,'Tomb Guardian',0,'',0,'LineageMonster.death_knight','12','31',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,19326,1795,'582.81759','271.89033','397.98887','181.027644954078',253,4,500,333,0,0,0,27,190,1,1,0,1),
(21251,21251,'Tomb Sage',0,'',0,'LineageMonster.doll_master','20','42',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,21777,2074,'624.93199','281.55251','426.74754','187.460838840844',253,4,500,333,0,0,0,80,160,1,1,0,1),
(21252,21252,'Crypt Guard',0,'',0,'LineageMonster.skeleton_royal_guard_30_bi','14','37.5',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,20845,2067,'688.86373','295.91597','470.40463','197.024195544734',253,8,0,333,236,0,0,80,200,1,1,0,1),
(21253,21253,'Crypt Preacher',0,'',0,'LineageMonster.vale_master_30_bi','15','52',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,22494,2285,'731.52506','305.35947','499.53679','203.311781207645',253,4,500,333,326,0,0,70,165,1,1,0,1),
(21254,21254,'Tomb Guard',0,'',0,'LineageMonster.death_knight','12','31',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,25729,2714,'794.70901','319.24623','542.68324','212.557735094503',253,4,500,333,78,0,0,27,200,1,1,0,1),
(21255,21255,'Tomb Preacher',0,'',0,'LineageMonster.doll_master_20_bi','24','50.4',77,'male','L2Monster',40,'2762.08447','1574','8.5','3',40,43,30,21,20,20,28763,3113,'835.75573','328.27073','570.71283','218.566351305224',253,4,500,333,0,0,0,80,165,1,1,0,1),
(21256,21256,'Underground Werewolf',0,'',0,'LineageMonster.werewolf_bi','11','29.7',23,'male','L2Monster',40,'410.70422','231.96','3.5','1.5',40,43,30,21,20,20,905,43,'55.84125','95.64976','38.13234','63.6846860642986',253,1,400,333,0,0,0,50,135,1,1,0,1),
(21257,21257,'Evil Eye Seer',0,'',0,'LineageMonster.monster_eye','21','43',18,'male','L2Monster',40,'301.66622','174.64','2.5','1.2',40,43,30,21,20,20,646,28,'37.82932','81.34791','25.83252','54.1623558855199',253,1,0,333,0,0,0,90,155,1,1,1,1),
(21258,21258,'Fallen Orc Shaman',0,'',0,'LineageMonster.ketra_orc_shaman','10','23',58,'male','L2Monster',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,20,0,0,'442.8992','237.99429','302.44274','158.459289236126',253,1,0,333,9,0,0,10,130,1,1,1,1),
(21259,21259,'Fallen Orc Shaman',0,'',0,'LineageMonster.saber_toothed_tiger','34','28',59,'male','L2Monster',40,'1880.92519','1007','6.5','2.4',40,43,30,21,20,20,15580,1332,'461.94387','242.81593','315.44778','161.669585254993',253,4,500,333,0,0,0,60,180,1,1,1,1),
(21260,21260,'Betrayer Orc Hero',0,'',0,'LineageMonster.ketra_orc_warrior','12','24',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,4429,334,'305.54906','200.23844','208.6504','133.321011603844',253,4,0,333,74,0,0,36,170,1,1,0,1),
(21261,21261,'Ol Mahum Transcender',0,'',0,'LineageMonster.ol_mahum','13.5','25',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,4954,372,'305.54906','200.23844','208.6504','146.5258',253,4,0,333,127,0,0,50,110,1,1,1,1),
(21262,21262,'Ol Mahum Transcender',0,'',0,'LineageMonster.ol_mahum_champion','14','27',53,'male','L2Monster',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,6631,496,'353.71092','214.18326','241.5387','156.73001',253,4,500,333,127,102,0,50,110,1,1,1,1),
(21263,21263,'Ol Mahum Transcender',0,'',0,'LineageMonster.oel_mahum','20','37',55,'male','L2Monster',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,9634,691,'388.11142','223.6362','265.02979','163.64727',253,4,500,333,127,0,0,70,110,1,1,1,1),
(21264,21264,'Ol Mahum Transcender',0,'',0,'LineageMonster.kel_mahum','13','26',58,'male','L2Monster',40,'1828.68266','977.4','6.5','2.4',40,43,30,21,20,20,13535,933,'442.8992','237.99429','302.44274','174.1539',253,4,500,333,127,0,0,50,160,1,1,1,1),
(21265,21265,'Cave Ant Larva',0,'',0,'LineageMonster.ant_larva','12','8',36,'male','L2Monster',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,1904,115,'137.86467','140.57278','94.1437','93.5949427192352',253,4,0,333,0,0,0,40,60,1,1,1,1),
(21266,21266,'Cave Ant Larva',0,'',0,'LineageMonster.ant_larva','12','8',36,'male','L2Monster',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,0,0,'137.86467','140.57278','94.1437','93.5949427192352',253,4,0,333,0,0,0,40,60,1,1,1,1),
(21267,21267,'Cave Ant Larva',0,'',0,'LineageMonster.ant_larva','12','8',36,'male','L2Monster',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,0,0,'137.86467','140.57278','94.1437','93.5949427192352',253,4,0,333,0,0,0,40,60,1,1,1,1),
(21268,21268,'Cave Ant Larva',0,'',0,'LineageMonster.ant_larva','12','8',36,'male','L2Monster',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,3541,214,'137.86467','140.57278','94.1437','93.5949427192352',253,4,0,333,0,0,0,40,60,1,1,1,1),
(21269,21269,'Cave Ant',0,'',0,'LineageMonster.ant','26','15',37,'male','L2Monster',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,20,4042,248,'146.82587','144.47758','100.26304','96.1948088105753',253,4,500,333,0,0,0,40,130,1,1,1,1),
(21270,21270,'Cave Ant Soldier',0,'',0,'LineageMonster.ant_soldier','35','17',38,'male','L2Monster',40,'886.09975','447.96','4.5','1.8',40,43,30,21,20,20,4670,292,'156.22273','148.44287','106.67987','98.8349371271581',253,4,500,333,0,0,0,80,130,1,1,1,1),
(21271,21271,'Cave Ant',0,'',0,'LineageMonster.ant','26','15',37,'male','L2Monster',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,20,2758,169,'146.82587','144.47758','100.26304','96.1948088105753',253,4,500,333,0,0,0,40,130,1,1,1,1),
(21272,21272,'Cave Ant Soldier',0,'',0,'LineageMonster.ant_soldier','35','17',38,'male','L2Monster',40,'886.09975','447.96','4.5','1.8',40,43,30,21,20,20,4902,306,'156.22273','148.44287','106.67987','98.8349371271581',253,4,500,333,0,0,0,80,130,1,1,1,1),
(21273,21273,'Cave Noble Ant',0,'',0,'LineageMonster.noble_ant','20','48',39,'male','L2Monster',40,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,14204,902,'166.06476','152.46752','113.4007','101.514599764346',253,4,500,333,0,0,0,80,174,1,1,1,1),
(21274,21274,'Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8','26.4',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,8972,854,'624.93199','281.55251','426.74754','206.02791',253,4,0,333,0,0,0,23,190,1,1,1,1),
(21275,21275,'Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8','26.4',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,9030,859,'624.93199','281.55251','426.74754','206.02791',253,4,0,333,0,0,0,23,190,1,1,1,1),
(21276,21276,'Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8','26.4',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,8921,848,'624.93199','281.55251','426.74754','206.02791',253,4,0,333,0,0,0,23,190,1,1,1,1),
(21278,21278,'Antelope',0,'',0,'LineageMonster2.antelope','17','34',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,9242,892,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,45,185,1,1,1,1),
(21279,21279,'Antelope',0,'',0,'LineageMonster2.antelope','17','34',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,9189,887,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,45,185,1,1,1,1),
(21280,21280,'Antelope',0,'',0,'LineageMonster2.antelope','17','34',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,9302,898,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,0,0,0,45,185,1,1,1,1),
(21282,21282,'Bandersnatch',0,'',0,'LineageMonster2.bandersnatch','18','25',69,'male','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,9516,930,'667.50361','291.15063','455.81844','213.05139',253,4,150,333,0,0,0,30,170,1,1,1,1),
(21283,21283,'Bandersnatch',0,'',0,'LineageMonster2.bandersnatch','18','25',69,'male','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,9578,936,'667.50361','291.15063','455.81844','213.05139',253,4,150,333,0,0,0,30,170,1,1,1,1),
(21284,21284,'Bandersnatch',0,'',0,'LineageMonster2.bandersnatch','18','25',69,'male','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,9461,925,'667.50361','291.15063','455.81844','213.05139',253,4,150,333,0,0,0,30,170,1,1,1,1),
(21286,21286,'Buffalo',0,'',0,'LineageMonster2.buffalo','22','31',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,9794,971,'688.86373','295.91597','470.40463','216.53847',253,1,0,333,0,0,0,80,170,1,1,1,1),
(21287,21287,'Buffalo',0,'',0,'LineageMonster2.buffalo','22','31',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,9737,965,'688.86373','295.91597','470.40463','216.53847',253,1,0,333,0,0,0,80,170,1,1,1,1),
(21288,21288,'Buffalo',0,'',0,'LineageMonster2.buffalo','22','31',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,9857,977,'688.86373','295.91597','470.40463','216.53847',253,1,0,333,0,0,0,80,170,1,1,1,1),
(21290,21290,'Grendel',0,'',0,'LineageMonster2.bionic_bear','15','39',71,'male','L2Monster',40,'2492.727','1377.8','8.5','3',40,43,30,21,20,20,10076,1010,'710.2185','300.65359','484.98717','220.00525',253,4,150,333,0,0,0,36,155,1,1,1,1),
(21291,21291,'Grendel',0,'',0,'LineageMonster2.bionic_bear','15','39',71,'male','L2Monster',40,'2492.727','1377.8','8.5','3',40,43,30,21,20,20,10017,1004,'710.2185','300.65359','484.98717','220.00525',253,4,150,333,0,0,0,36,155,1,1,1,1),
(21292,21292,'Grendel',0,'',0,'LineageMonster2.bionic_bear','15','39',71,'male','L2Monster',40,'2492.727','1377.8','8.5','3',40,43,30,21,20,20,10141,1016,'710.2185','300.65359','484.98717','220.00525',253,4,150,333,0,0,0,36,155,1,1,1,1),
(21294,21294,'Canyon Antelope',0,'',0,'LineageMonster2.antelope','17','34',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,16544,1598,'646.17968','286.3615','441.25696','190.662718462344',253,4,0,333,0,0,0,45,185,1,1,0,1),
(21295,21295,'Canyon Antelope Slave',0,'',0,'LineageMonster2.antelope','17','34',69,'male','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,17547,1717,'667.50361','291.15063','455.81844','193.851368417065',253,4,300,333,0,0,0,45,165,1,1,0,1),
(21296,21296,'Canyon Bandersnatch',0,'',0,'LineageMonster2.bandersnatch','18','25',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,26081,2586,'688.86373','295.91597','470.40463','197.024195544734',253,4,300,333,0,0,0,30,180,1,1,0,1),
(21297,21297,'Canyon Bandersnatch Slave',0,'',0,'LineageMonster2.bandersnatch','18','25',71,'male','L2Monster',40,'2492.727','1377.8','8.5','3',40,43,30,21,20,20,26191,2628,'710.2185','300.65359','484.98717','200.178552092236',253,4,200,333,0,0,0,30,170,1,1,0,1),
(21298,21298,'Eye of Restrainer',0,'',0,'LineageMonster.monster_eye','21','43',71,'male','L2Monster',40,'2492.727','1377.8','8.5','3',40,43,30,21,20,20,16857,1692,'710.2185','300.65359','484.98717','200.178552092236',253,4,150,333,0,0,0,90,140,1,1,0,1),
(21299,21299,'Buffalo Slave',0,'',0,'LineageMonster2.buffalo_ec','22','31',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,26934,2736,'731.52506','305.35947','499.53679','203.311781207645',253,1,300,333,0,0,0,20,160,1,1,0,1),
(21300,21300,'Eye of Guide',0,'',0,'LineageMonster2.parasitic_eye_20_sm','20','50.5',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,26498,2692,'731.52506','305.35947','499.53679','203.311781207645',253,4,0,333,0,0,0,30,155,1,1,0,1),
(21301,21301,'Gaze of Nightmare',0,'',0,'LineageMonster.field_stalker','15','30',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,31797,3230,'731.52506','305.35947','499.53679','203.311781207645',253,4,0,333,0,0,0,70,195,1,1,0,1),
(21302,21302,'Eye of Watchman',0,'',0,'LineageMonster2.parasitic_eye','25','63',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,25580,2632,'752.73928','310.02959','514.02335','206.421198742611',253,4,300,333,0,0,0,30,160,1,1,0,1),
(21303,21303,'Homunculus',0,'',0,'LineageMonster2.homunculus_20_sm','10','26',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,25867,2662,'752.73928','310.02959','514.02335','206.421198742611',253,4,150,333,0,0,0,30,185,1,1,0,1),
(21304,21304,'Grendel Slave',0,'',0,'LineageMonster2.bionic_bear','15','39',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,38011,3962,'773.81598','314.65987','528.41601','209.50409325236',253,4,200,333,0,0,0,36,140,1,1,0,1),
(21305,21305,'Eye of Pilgrim',0,'',0,'LineageMonster2.parasitic_eye_20_sm','20','50.5',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,27990,2917,'773.81598','314.65987','528.41601','209.50409325236',253,4,0,333,0,0,0,30,165,1,1,0,1),
(21306,21306,'Disciples of Protection',0,'',0,'LineageMonster2.apostle_warrior','8','30',74,'female','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,50649,5280,'773.81598','314.65987','528.41601','209.50409325236',253,4,150,333,6717,0,0,50,160,1,1,0,1),
(21307,21307,'Elder Homunculus',0,'',0,'LineageMonster2.homunculus','12','32.5',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,35496,3744,'794.70901','319.24623','542.68324','212.557735094503',253,4,150,333,0,0,0,30,200,1,1,0,1),
(21308,21308,'Disciples of Punishment',0,'',0,'LineageMonster2.apostle_warrior','8','30',75,'female','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,47163,4975,'794.70901','319.24623','542.68324','212.557735094503',253,4,150,333,6717,0,0,50,190,1,1,0,1),
(21309,21309,'Disciples of Punishment',0,'',0,'LineageMonster2.apostle_warrior','8','30',75,'female','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,49155,5185,'794.70901','319.24623','542.68324','212.557735094503',253,4,150,333,6717,0,0,50,190,1,1,0,1),
(21310,21310,'Disciples of Authority',0,'',0,'LineageMonster2.apostle_mage','11','38.5',76,'male','L2Monster',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,20,40357,4315,'815.37145','323.78455','556.793','215.579412824268',253,1,150,333,6718,0,0,50,155,1,1,0,1),
(21311,21311,'Disciples of Authority',0,'',0,'LineageMonster2.apostle_mage','11','38.5',76,'male','L2Monster',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,20,37210,3978,'815.37145','323.78455','556.793','215.579412824268',253,1,150,333,6718,0,0,50,155,1,1,0,1),
(21312,21312,'Eye of Ruler',0,'',0,'LineageMonster2.parasitic_eye','25','63',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,38709,4036,'773.81598','314.65987','528.41601','209.50409325236',253,4,300,333,0,0,0,30,160,1,1,0,1),
(21313,21313,'Sly Hound Dog',0,'',0,'LineageMonster2.bandersnatch','18','25',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,37061,3766,'731.52506','305.35947','499.53679','203.311781207645',253,4,0,333,0,0,0,30,185,1,1,0,1),
(21314,21314,'Hot Springs Bandersnatchling',0,'',0,'LineageMonster2.bandersnatch','18','25',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,20662,2126,'752.73928','310.02959','514.02335','206.421198742611',253,4,400,333,0,0,0,30,170,1,1,1,1),
(21315,21315,'Hot Springs Buffalo',0,'',0,'LineageMonster2.buffalo','22','31',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,21532,2215,'752.73928','310.02959','514.02335','206.421198742611',253,1,0,333,0,0,0,20,170,1,1,1,1),
(21316,21316,'Hot Springs Flava',0,'',0,'LineageMonster2.flava','18','34',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,25336,2641,'773.81598','314.65987','528.41601','209.50409325236',253,1,450,333,0,0,0,30,165,1,1,1,1),
(21317,21317,'Hot Springs Atroxspawn',0,'',0,'LineageMonster2.kailiharim','45','39',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,21232,2213,'773.81598','314.65987','528.41601','209.50409325236',253,4,500,333,0,0,0,105,175,1,1,1,1),
(21318,21318,'Hot Springs Antelope',0,'',0,'LineageMonster2.antelope','17','34',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,22193,2314,'773.81598','314.65987','528.41601','209.50409325236',253,4,0,333,0,0,0,45,185,1,1,1,1),
(21319,21319,'Hot Springs Nepenthes',0,'',0,'LineageMonster2.nephenthes','28','43.5',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,27928,2946,'794.70901','319.24623','542.68324','212.557735094503',253,1,350,333,0,0,0,48,170,1,1,1,1),
(21320,21320,'Hot Springs Yeti',0,'',0,'LineageMonster.yeti_20_bi','18','32',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,22728,2398,'794.70901','319.24623','542.68324','212.557735094503',253,4,0,333,0,0,0,16,170,1,1,1,1),
(21321,21321,'Hot Springs Atrox',0,'',0,'LineageMonster2.kailiharim','45','39',76,'male','L2Monster',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,20,22270,2381,'815.37145','323.78455','556.793','215.579412824268',253,4,500,333,0,0,0,105,175,1,1,1,1),
(21322,21322,'Hot Springs Bandersnatch',0,'',0,'LineageMonster2.bandersnatch','18','25',76,'male','L2Monster',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,20,22270,2381,'815.37145','323.78455','556.793','215.579412824268',253,4,400,333,0,0,0,30,170,1,1,1,1),
(21323,21323,'Hot Springs Grendel',0,'',0,'LineageMonster2.bionic_bear','15','39',76,'male','L2Monster',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,20,19507,2085,'815.37145','323.78455','556.793','215.579412824268',253,4,0,333,0,0,0,36,165,1,1,1,1),
(21324,21324,'Ketra Orc Footman',0,'',0,'LineageMonster.ketra_orc','12','29',77,'male','L2Monster',40,'2762.08447','1574','8.5','3',40,43,30,21,20,20,18647,2018,'835.75573','328.27073','570.71283','218.566351305224',253,4,150,333,79,0,0,45,175,1,1,1,1),
(21325,21325,'Ketra\'s War Hound',0,'',0,'LineageMonster2.bandersnatch','18','25',77,'male','L2Monster',40,'2762.08447','1574','8.5','3',40,43,30,21,20,20,18031,1951,'835.75573','328.27073','570.71283','218.566351305224',253,4,150,333,0,0,0,30,185,1,1,1,1),
(21326,21326,'Grazing Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8','26.4',77,'male','L2Monster',40,'2762.08447','1574','8.5','3',40,43,30,21,20,20,18031,1951,'835.75573','328.27073','570.71283','218.566351305224',253,4,150,333,0,0,0,23,190,1,1,1,1),
(21327,21327,'Ketra Orc Raider',0,'',0,'LineageMonster.ketra_orc_warrior','12','24',78,'male','L2Monster',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,20480,2241,'855.81387','332.70061','584.40994','221.515820894982',253,4,150,333,79,6919,0,36,175,1,1,1,1),
(21328,21328,'Ketra Orc Scout',0,'',0,'LineageMonster.ketra_orc_archer','12','27',78,'male','L2Monster',1100,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,19634,2149,'855.81387','332.70061','584.40994','221.515820894982',253,8,150,333,288,0,0,45,175,1,1,1,1),
(21329,21329,'Ketra Orc Shaman',0,'',0,'LineageMonster.ketra_orc_shaman','10','23',78,'male','L2Monster',40,'2870.7774087','1657.41','8.585','3.03',40,43,30,21,20,20,19912,2207,'884.2525659','340.4407808','609.868172336','226.669315301277',253,1,150,333,92,0,0,10,150,1,1,1,1),
(21330,21330,'Grazing Buffalo',0,'',0,'LineageMonster2.buffalo','22','31',78,'male','L2Monster',40,'2870.7774087','1657.41','8.585','3.03',40,43,30,21,20,20,18980,2103,'884.2525659','340.4407808','609.868172336','226.669315301277',253,1,150,333,0,0,0,20,165,1,1,1,1),
(21331,21331,'Ketra Orc Warrior',0,'',0,'LineageMonster.ketra_orc_warrior','12','24',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,18609,2089,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,150,333,79,6919,0,36,175,1,1,1,1),
(21332,21332,'Ketra Orc Lieutenant',0,'',0,'LineageMonster2.ketra_orc_chieftain','11','38.5',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,20841,2339,'912.6537108','348.2025','635.688655236','231.837152158566',253,1,400,333,6719,0,0,24,175,1,1,1,1),
(21333,21333,'Grazing Windsus',0,'',0,'LineageMonster.giant_wild_hog','35','27',78,'male','L2Monster',40,'2975.2369188','1742.976','8.721','3.0804',40,43,30,21,20,20,19953,2266,'938.20801458','354.8183475','656.66638089','239.180922',253,1,150,333,0,0,0,35,170,1,1,1,1),
(21334,21334,'Ketra Orc Medium',0,'',0,'LineageMonster.ketra_orc_shaman','10','23',78,'male','L2Monster',40,'2975.2369188','1742.976','8.721','3.0804',40,43,30,21,20,20,29867,3391,'938.20801458','354.8183475','656.66638089','239.180922',253,1,400,333,92,0,0,10,150,1,1,1,1),
(21335,21335,'Ketra Orc Elite Soldier',0,'',0,'LineageMonster.ketra_orc','12','29',78,'male','L2Monster',40,'3010.8929976','1777.86','8.772','3.1008',40,43,30,21,20,20,19252,2212,'961.93701102','361.0859925','677.644106544','246.330714',253,4,300,333,79,0,0,45,175,1,1,1,1),
(21336,21336,'Ketra Orc White Captain',0,'',0,'LineageMonster.ketra_orc_overload_20_bi','14','28.8',78,'male','L2Monster',40,'3010.8929976','1777.86','8.772','3.1008',40,43,30,21,20,20,22635,2600,'961.93701102','361.0859925','677.644106544','246.330714',253,4,300,333,80,0,0,33,175,1,1,1,1),
(21337,21337,'Grazing Elder Buffalo',0,'',0,'LineageMonster2.buffalo','22','31',78,'male','L2Monster',40,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,20950,2435,'985.66600746','367.3536375','699.2575207596','253.534464',253,1,150,333,0,0,0,20,165,1,1,1,1),
(21338,21338,'Ketra Orc Seer',0,'',0,'LineageMonster.ketra_orc_shaman','10','23',78,'male','L2Monster',40,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,27568,3205,'985.66600746','367.3536375','699.2575207596','253.534464',253,4,350,333,213,0,0,10,160,1,1,1,1),
(21339,21339,'Ketra Orc General',0,'',0,'LineageMonster2.ketra_orc_chieftain_20_bi','17','46.2',78,'male','L2Monster',40,'3077.1572058','1848.24','8.874','3.1314',40,43,30,21,20,20,20989,2469,'1009.3950039','373.969485','719.599557852','261.022284',253,1,150,333,6719,0,0,24,175,1,1,1,1),
(21340,21340,'Ketra Orc Battalion Commander',0,'',0,'LineageMonster2.ketra_orc_warlord','12','30',78,'male','L2Monster',40,'3077.1572058','1848.24','8.874','3.1314',40,43,30,21,20,20,20989,2469,'1009.3950039','373.969485','719.599557852','261.022284',253,4,150,333,80,6919,0,27,175,1,1,1,1),
(21341,21341,'Grazing Elder Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8','26.4',78,'male','L2Monster',40,'3107.6436594','1883.736','8.925','3.1518',40,43,30,21,20,20,21972,2615,'1033.1240034','380.23713','740.577283506','268.304676',253,4,150,333,0,0,0,23,190,1,1,1,1),
(21342,21342,'Ketra Orc Grand Seer',0,'',0,'LineageMonster.ketra_orc_shaman','10','23',78,'male','L2Monster',40,'3107.6436594','1883.736','8.925','3.1518',40,43,30,21,20,20,28912,3441,'1033.1240034','380.23713','740.577283506','268.304676',253,1,150,333,213,0,0,10,160,1,1,1,1),
(21343,21343,'Ketra Commander',0,'',0,'LineageMonster2.ketra_orc_warlord_20_bi','15','36',78,'male','L2Monster',40,'2975.2369188','1742.976','8.721','3.0804',40,43,30,21,20,20,32801,3725,'938.20801458','354.8183475','656.66638089','239.180922',253,8,150,333,80,6919,0,27,175,1,1,0,1),
(21344,21344,'Ketra Elite Guard',0,'',0,'LineageMonster.ketra_orc_overload','12','24',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,22276,2500,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,0,333,80,0,0,33,180,1,1,0,1),
(21345,21345,'Ketra\'s Head Shaman',0,'',0,'LineageMonster.ketra_orc_shaman','10','23',78,'male','L2Monster',40,'3107.6436594','1883.736','8.925','3.1518',40,43,30,21,20,20,24720,2943,'1033.1240034','380.23713','740.577283506','268.304676',253,1,150,333,210,0,0,10,175,1,1,0,1),
(21346,21346,'Ketra\'s Head Guard',0,'',0,'LineageMonster2.ketra_orc_chieftain','11','38.5',78,'male','L2Monster',40,'3077.1572058','1848.24','8.874','3.1314',40,43,30,21,20,20,24560,2889,'1009.3950039','373.969485','719.599557852','261.022284',253,1,0,333,6719,0,0,24,175,1,1,0,1),
(21347,21347,'Ketra Prophet',0,'',0,'LineageMonster.ketra_orc_shaman','10','23',78,'male','L2Monster',40,'3163.0432152','1955.34','9.027','3.1824',40,43,30,21,20,20,37558,4578,'1076.9313816','410.87895','781.2613576908','295.9938',253,1,150,333,213,0,0,10,175,1,1,0,1),
(21348,21348,'Prophet\'s Guard',0,'',0,'LineageMonster2.ketra_orc_chieftain','11','38.5',78,'male','L2Monster',40,'3136.2900942','1919.436','8.976','3.16812',40,43,30,21,20,20,25743,3101,'1055.0276874','386.504775','760.9193205984','275.616036',253,1,0,333,6719,0,0,24,180,1,1,0,1),
(21349,21349,'Prophet\'s Aide',0,'',0,'LineageMonster.ketra_orc_shaman','10','23',78,'male','L2Monster',40,'3136.2900942','1919.436','8.976','3.16812',40,43,30,21,20,20,26143,3149,'1055.0276874','386.504775','760.9193205984','275.616036',253,1,0,333,210,0,0,10,180,1,1,0,1),
(21350,21350,'Varka Silenos Recruit',0,'',0,'LineageMonster2.barka_silenos_hunter','16','38',77,'male','L2Monster',40,'2856.7687256316','1574','8.5','3',40,43,30,21,20,20,21105,2186,'856.44055895414','328.27073','584.837886935576','240.21427',253,4,150,333,2504,6918,0,44,175,1,1,1,1),
(21351,21351,'Varka Silenos Footman',0,'',0,'LineageMonster2.barka_silenos_warrior','16','41',77,'male','L2Monster',40,'2856.7687256316','1574','8.5','3',40,43,30,21,20,20,18501,1904,'856.44055895414','328.27073','584.837886935576','240.21427',253,4,400,333,2504,6918,0,34,175,1,1,1,1),
(21352,21352,'Grazing Antelope',0,'',0,'LineageMonster2.antelope','17','34',77,'male','L2Monster',40,'2856.7687256316','1574','8.5','3',40,43,30,21,20,20,11091,1200,'856.44055895414','328.27073','584.837886935576','240.21427',253,4,150,333,0,0,0,45,185,1,1,1,1),
(21353,21353,'Varka Silenos Scout',0,'',0,'LineageMonster2.barka_silenos_hunter','16','38',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,25065,2642,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,350,333,142,6918,0,44,175,1,1,1,1),
(21354,21354,'Varka Silenos Hunter',0,'',0,'LineageMonster2.barka_silenos_archer','8','37.5',78,'male','L2Monster',1100,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,24846,2618,'890.50085998804','332.70061','608.096657928153','243.45587',253,8,300,333,6917,0,0,30,175,1,1,1,1),
(21355,21355,'Varka Silenos Shaman',0,'',0,'LineageMonster2.barka_silenos_shaman','14','39.5',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,24583,2580,'890.50085998804','332.70061','608.096657928153','243.45587',253,1,300,333,6716,0,0,36,150,1,1,1,1),
(21356,21356,'Grazing Nepenthes',0,'',0,'LineageMonster2.nephenthes','28','43.5',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,15612,1708,'890.50085998804','332.70061','608.096657928153','243.45587',253,1,150,333,0,0,0,48,150,1,1,1,1),
(21357,21357,'Varka Silenos Priest',0,'',0,'LineageMonster2.barka_silenos_priest','9','41.5',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,25424,2681,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,450,333,6716,0,0,36,180,1,1,1,1),
(21358,21358,'Varka Silenos Warrior',0,'',0,'LineageMonster2.barka_silenos_warrior','16','41',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,25564,2696,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,150,333,142,6918,0,34,175,1,1,1,1),
(21359,21359,'Grazing Bandersnatch',0,'',0,'LineageMonster2.bandersnatch','18','25',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,15761,1724,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,150,333,0,0,0,30,170,1,1,1,1),
(21360,21360,'Varka Silenos Medium',0,'',0,'LineageMonster2.barka_silenos_shaman','14','39.5',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,33108,3490,'890.50085998804','332.70061','608.096657928153','243.45587',253,1,150,333,6716,0,0,36,150,1,1,1,1),
(21361,21361,'Varka Silenos Magus',0,'',0,'LineageMonster2.barka_silenos_mage_20_bi','11','55.2',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,23322,2452,'890.50085998804','332.70061','608.096657928153','243.45587',253,1,150,333,6716,0,0,36,175,1,1,1,1),
(21362,21362,'Varka Silenos Officer',0,'',0,'LineageMonster2.barka_silenos_chieftain','18','42.5',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,25564,2696,'890.50085998804','332.70061','608.096657928153','243.45587',253,1,150,333,2504,0,0,25,175,1,1,1,1),
(21363,21363,'Grazing Flava',0,'',0,'LineageMonster2.flava','18','34',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,23952,2522,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,150,333,0,0,0,30,165,1,1,1,1),
(21364,21364,'Varka Silenos Seer',0,'',0,'LineageMonster2.barka_silenos_shaman','14','39.5',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,18179,1988,'890.50085998804','332.70061','608.096657928153','243.45587',253,1,150,333,6716,0,0,36,150,1,1,1,1),
(21365,21365,'Varka Silenos Great Magus',0,'',0,'LineageMonster2.barka_silenos_warrior_20_bi','20','49.2',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,25065,2642,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,150,333,2500,0,0,34,175,1,1,1,1),
(21366,21366,'Varka Silenos General',0,'',0,'LineageMonster2.barka_silenos_chieftain','18','42.5',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,27045,2858,'890.50085998804','332.70061','608.096657928153','243.45587',253,1,150,333,2500,0,0,25,175,1,1,1,1),
(21367,21367,'Grazing Elder Antelope',0,'',0,'LineageMonster2.antelope','17','34',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,15761,1724,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,150,333,0,0,0,45,185,1,1,1,1),
(21368,21368,'Varka Silenos Great Seer',0,'',0,'LineageMonster2.barka_silenos_shaman','14','39.5',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,32232,3394,'890.50085998804','332.70061','608.096657928153','243.45587',253,1,150,333,6716,0,0,36,150,1,1,1,1),
(21369,21369,'Varka\'s Commander',0,'',0,'LineageMonster2.barka_silenos_chieftain_20_bi','22','51',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,31469,3310,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,150,333,2500,0,0,25,175,1,1,0,1),
(21370,21370,'Varka\'s Elite Guard',0,'',0,'LineageMonster2.barka_silenos_warrior','16','41',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,26151,2761,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,2500,6918,0,34,175,1,1,0,1),
(21371,21371,'Varka\'s Head Magus',0,'',0,'LineageMonster2.barka_silenos_shaman','14','39.5',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,24846,2618,'890.50085998804','332.70061','608.096657928153','243.45587',253,1,150,333,6716,0,0,36,150,1,1,0,1),
(21372,21372,'Varka\'s Head Guard',0,'',0,'LineageMonster2.barka_silenos_hunter','16','38',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,16812,1840,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,2500,6918,0,44,175,1,1,0,1),
(21373,21373,'Varka\'s Prophet',0,'',0,'LineageMonster2.barka_silenos_shaman_20_bi','17','47.5',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,32074,3370,'890.50085998804','332.70061','608.096657928153','243.45587',253,1,150,333,6716,0,0,36,150,1,1,0,1),
(21374,21374,'Prophet Guard',0,'',0,'LineageMonster2.barka_silenos_warrior','16','41',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,16952,1855,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,2500,6918,0,34,175,1,1,0,1),
(21375,21375,'Disciple of Prophet',0,'',0,'LineageMonster2.barka_silenos_priest','9','41.5',78,'male','L2Monster',40,'2974.35686398316','1607.4','8.5','3',40,43,30,21,20,20,16339,1788,'890.50085998804','332.70061','608.096657928153','243.45587',253,4,0,333,6716,0,0,36,180,1,1,0,1),
(21376,21376,'Scarlet Stakato Worker',0,'',0,'LineageMonster.blade_stakato_worker','13','40',78,'male','L2Monster',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,35275,3860,'855.81387','332.70061','584.40994','221.515820894982',253,4,150,333,235,0,0,25,130,1,1,0,1),
(21377,21377,'Scarlet Stakato Soldier',0,'',0,'LineageMonster.blade_stakato_soldier','15','38',78,'male','L2Monster',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,34523,3778,'855.81387','332.70061','584.40994','221.515820894982',253,4,400,333,148,0,0,25,180,1,1,0,1),
(21378,21378,'Scarlet Stakato Noble',0,'',0,'LineageMonster.blade_stakato_drone','15','39',78,'male','L2Monster',40,'2870.7774087','1657.41','8.585','3.03',40,43,30,21,20,20,49148,5447,'884.2525659','340.4407808','609.868172336','226.669315301277',253,4,450,333,235,0,0,25,180,1,1,0,1),
(21379,21379,'Tepra Scorpion',0,'',0,'LineageMonster2.scorpion_20_sm','24','52.8',78,'male','L2Monster',40,'2870.7774087','1657.41','8.585','3.03',40,43,30,21,20,20,35491,3933,'884.2525659','340.4407808','609.868172336','226.669315301277',253,8,150,333,0,0,0,37,125,1,1,0,1),
(21380,21380,'Tepra Scarab',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2Monster',40,'2870.7774087','1657.41','8.585','3.03',40,43,30,21,20,20,36185,4010,'884.2525659','340.4407808','609.868172336','226.669315301277',253,1,150,333,0,0,0,45,175,1,1,0,1),
(21381,21381,'Assassin Beetle',0,'',0,'LineageMonster2.tera_beetle','19','54.5',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,42075,4722,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,500,333,0,0,0,45,145,1,1,0,1),
(21382,21382,'Mercenary of Destruction',0,'',0,'LineageMonster.skeleton_knight','10','25',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,51904,5826,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,150,333,150,103,0,40,165,1,1,0,1),
(21383,21383,'Knight of Destruction',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,51983,5835,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,150,333,946,945,0,80,185,1,1,0,1),
(21384,21384,'Necromancer of Destruction',0,'',0,'LineageMonster.vale_master_20_bi','14.5','48',78,'male','L2Monster',40,'2975.2369188','1742.976','8.721','3.0804',40,43,30,21,20,20,44576,5062,'938.20801458','354.8183475','656.66638089','239.180922',253,1,150,333,0,0,0,70,145,1,1,0,1),
(21385,21385,'Lavastone Golem',0,'',0,'LineageMonster.stone_golem','20','31',78,'male','L2Monster',40,'2975.2369188','1742.976','8.721','3.0804',40,43,30,21,20,20,42930,4875,'938.20801458','354.8183475','656.66638089','239.180922',253,1,150,333,0,0,0,23,40,1,1,0,1),
(21386,21386,'Magma Golem',0,'',0,'LineageMonster2.lava_golem','22','45',78,'male','L2Monster',40,'2975.2369188','1742.976','8.721','3.0804',40,43,30,21,20,20,45872,5209,'938.20801458','354.8183475','656.66638089','239.180922',253,1,150,333,0,0,0,13,60,1,1,0,1),
(21387,21387,'Arimanes of Destruction',0,'',0,'LineageMonster2.ahrimanes','14','57.75',78,'male','L2Monster',40,'3010.8929976','1777.86','8.772','3.1008',40,43,30,21,20,20,36575,4202,'961.93701102','361.0859925','677.644106544','246.330714',253,4,150,333,6722,0,0,35,185,1,1,0,1),
(21388,21388,'Iblis of Destruction',0,'',0,'LineageMonster.fiend_archer','17','55',78,'male','L2Monster',40,'3010.8929976','1777.86','8.772','3.1008',40,43,30,21,20,20,55327,6356,'961.93701102','361.0859925','677.644106544','246.330714',253,4,150,333,0,0,0,70,150,1,1,0,1),
(21389,21389,'Balrog of Destruction',0,'',0,'LineageMonster.kaim_vanul','24','40',78,'male','L2Monster',40,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,59328,6897,'985.66600746','367.3536375','699.2575207596','253.534464',253,4,150,333,0,0,0,37,155,1,1,0,1),
(21390,21390,'Ashuras of Destruction',0,'',0,'LineageMonster2.ashuras_30_bi','17','49',78,'male','L2Monster',40,'3077.1572058','1848.24','8.874','3.1314',40,43,30,21,20,20,68450,8052,'1009.3950039','373.969485','719.599557852','261.022284',253,4,150,333,0,0,0,41,190,1,1,0,1),
(21391,21391,'Lavasillisk',0,'',0,'LineageMonster.lesser_basilisk','34','25',78,'male','L2Monster',40,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,47322,5501,'985.66600746','367.3536375','699.2575207596','253.534464',253,4,150,333,0,0,0,35,140,1,1,0,1),
(21392,21392,'Blazing Ifrit',0,'',0,'LineageMonster2.ifrit_30_bi','13','55',78,'male','L2Monster',40,'3077.1572058','1848.24','8.874','3.1314',40,43,30,21,20,20,67509,7941,'1009.3950039','373.969485','719.599557852','261.022284',253,4,150,333,0,0,0,38,150,1,1,0,1),
(21393,21393,'Magma Drake',0,'',0,'LineageMonster2.inferno_drake_20_bi','29','42',78,'male','L2Monster',40,'3107.6436594','1883.736','8.925','3.1518',40,43,30,21,20,20,56964,6780,'1033.1240034','380.23713','740.577283506','268.304676',253,4,150,333,0,0,0,57,195,1,1,0,1),
(21394,21394,'Lavasaurus',0,'',0,'LineageMonster2.magmagoil','15','75',78,'male','L2Monster',1100,'2870.7774087','1657.41','8.585','3.03',40,43,30,21,20,20,44944,4981,'884.2525659','340.4407808','609.868172336','226.669315301277',253,8,400,333,0,0,0,1,1,1,1,0,1),
(21395,21395,'Elder Lavasaurus',0,'',0,'LineageMonster2.magmagoil_lad','15','75',78,'male','L2Monster',1100,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,58564,6808,'985.66600746','367.3536375','699.2575207596','253.534464',253,8,150,333,0,0,0,1,1,1,1,0,1),
(21396,21396,'Carrion Scarab',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2Monster',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,24549,2687,'855.81387','332.70061','584.40994','221.515820894982',253,4,0,333,0,0,0,45,130,1,1,0,1),
(21397,21397,'Carrion Scarab',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2Monster',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,21310,2332,'855.81387','332.70061','584.40994','221.515820894982',253,4,0,333,0,0,0,45,130,1,1,0,1),
(21398,21398,'Soldier Scarab',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2Monster',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,40465,4428,'855.81387','332.70061','584.40994','221.515820894982',253,4,350,333,0,0,0,45,180,1,1,0,1),
(21399,21399,'Soldier Scarab',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2Monster',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,38680,4233,'855.81387','332.70061','584.40994','221.515820894982',253,4,350,333,0,0,0,45,180,1,1,0,1),
(21400,21400,'Hexa Beetle',0,'',0,'LineageMonster2.tera_beetle','25','54.5',78,'male','L2Monster',40,'2870.7774087','1657.41','8.585','3.03',40,43,30,21,20,20,33055,3663,'884.2525659','340.4407808','609.868172336','226.669315301277',253,4,350,333,0,0,0,45,145,1,1,0,1),
(21401,21401,'Hexa Beetle',0,'',0,'LineageMonster2.tera_beetle','25','54.5',78,'male','L2Monster',40,'2870.7774087','1657.41','8.585','3.03',40,43,30,21,20,20,29087,3224,'884.2525659','340.4407808','609.868172336','226.669315301277',253,4,350,333,0,0,0,45,145,1,1,0,1),
(21402,21402,'Katraxis',0,'',0,'LineageMonster2.scorpion_20_sm','24','52.8',78,'male','L2Monster',40,'2870.7774087','1657.41','8.585','3.03',40,43,30,21,20,20,30013,3326,'884.2525659','340.4407808','609.868172336','226.669315301277',253,8,300,333,0,0,0,37,165,1,1,0,1),
(21403,21403,'Katraxis',0,'',0,'LineageMonster2.scorpion_20_sm','24','52.8',78,'male','L2Monster',40,'2870.7774087','1657.41','8.585','3.03',40,43,30,21,20,20,34642,3839,'884.2525659','340.4407808','609.868172336','226.669315301277',253,8,300,333,0,0,0,37,165,1,1,0,1),
(21404,21404,'Tera Beetle',0,'',0,'LineageMonster2.tera_beetle','25','54.5',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,59626,6692,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,0,333,0,0,0,45,185,1,1,0,1),
(21405,21405,'Tera Beetle',0,'',0,'LineageMonster2.tera_beetle','25','54.5',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,28588,3209,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,0,333,0,0,0,45,185,1,1,0,1),
(21406,21406,'Knight of Empire',0,'',0,'LineageMonster.skeleton_knight','10','25',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,42272,4745,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,300,333,150,103,0,40,145,1,1,0,1),
(21407,21407,'Knight of Empire',0,'',0,'LineageMonster.skeleton_knight','10','25',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,27052,3036,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,300,333,150,103,0,40,145,1,1,0,1),
(21408,21408,'Royal Guard of Empire',0,'',0,'LineageMonster.skeleton_pikeman','10','28',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,36791,4129,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,0,333,304,0,0,50,190,1,1,0,1),
(21409,21409,'Royal Guard of Empire',0,'',0,'LineageMonster.skeleton_pikeman','10','28',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,41142,4618,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,0,333,304,0,0,50,190,1,1,0,1),
(21410,21410,'Guardian Scarab',0,'',0,'LineageMonster2.scarab_20_bi','17','26.5',78,'male','L2Monster',40,'2975.2369188','1742.976','8.721','3.0804',40,43,30,21,20,20,38010,4316,'938.20801458','354.8183475','656.66638089','239.180922',253,4,0,333,0,0,0,45,195,1,1,0,1),
(21411,21411,'Guardian Scarab',0,'',0,'LineageMonster2.scarab_20_bi','17','26.5',78,'male','L2Monster',40,'2975.2369188','1742.976','8.721','3.0804',40,43,30,21,20,20,30337,3445,'938.20801458','354.8183475','656.66638089','239.180922',253,4,0,333,0,0,0,45,195,1,1,0,1),
(21412,21412,'Ustralith',0,'',0,'LineageMonster2.scorpion','28','66',78,'male','L2Monster',40,'2975.2369188','1742.976','8.721','3.0804',40,43,30,21,20,20,48414,5497,'938.20801458','354.8183475','656.66638089','239.180922',253,8,150,333,0,0,0,37,130,1,1,0,1),
(21413,21413,'Ustralith',0,'',0,'LineageMonster2.scorpion','28','66',78,'male','L2Monster',40,'2975.2369188','1742.976','8.721','3.0804',40,43,30,21,20,20,37229,4227,'938.20801458','354.8183475','656.66638089','239.180922',253,8,150,333,0,0,0,37,130,1,1,0,1),
(21414,21414,'Assassin of Empire',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',78,'male','L2Monster',40,'2975.2369188','1742.976','8.721','3.0804',40,43,30,21,20,20,36181,4108,'938.20801458','354.8183475','656.66638089','239.180922',253,8,0,333,946,945,0,80,175,1,1,0,1),
(21415,21415,'Assassin of Empire',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',78,'male','L2Monster',40,'2975.2369188','1742.976','8.721','3.0804',40,43,30,21,20,20,36499,4144,'938.20801458','354.8183475','656.66638089','239.180922',253,8,0,333,946,945,0,80,175,1,1,0,1),
(21416,21416,'Imperial Commander',0,'',0,'LineageMonster2.imperial_warlord_zombie','7','30',78,'male','L2Monster',40,'2975.2369188','1742.976','8.721','3.0804',40,43,30,21,20,20,43189,4904,'938.20801458','354.8183475','656.66638089','239.180922',253,4,350,333,134,6721,0,39,140,1,1,0,1),
(21417,21417,'Imperial Commander',0,'',0,'LineageMonster2.imperial_warlord_zombie','7','30',78,'male','L2Monster',40,'2975.2369188','1742.976','8.721','3.0804',40,43,30,21,20,20,75345,8555,'938.20801458','354.8183475','656.66638089','239.180922',253,4,350,333,134,6721,0,39,140,1,1,0,1),
(21418,21418,'Imperial Royal Guard',0,'',0,'LineageMonster.death_knight','12','31',78,'male','L2Monster',40,'3010.8929976','1777.86','8.772','3.1008',40,43,30,21,20,20,32124,3691,'961.93701102','361.0859925','677.644106544','246.330714',253,4,0,333,142,0,0,27,160,1,1,0,1),
(21419,21419,'Imperial Royal Guard',0,'',0,'LineageMonster.death_knight','12','31',78,'male','L2Monster',40,'3010.8929976','1777.86','8.772','3.1008',40,43,30,21,20,20,32694,3756,'961.93701102','361.0859925','677.644106544','246.330714',253,4,0,333,142,0,0,27,160,1,1,0,1),
(21420,21420,'Ashuras',0,'',0,'LineageMonster2.ashuras','13','37.5',78,'male','L2Monster',40,'3010.8929976','1777.86','8.772','3.1008',40,43,30,21,20,20,38520,4425,'961.93701102','361.0859925','677.644106544','246.330714',253,4,150,333,0,0,0,41,200,1,1,0,1),
(21421,21421,'Ashuras',0,'',0,'LineageMonster2.ashuras','13','37.5',78,'male','L2Monster',40,'3010.8929976','1777.86','8.772','3.1008',40,43,30,21,20,20,36159,4154,'961.93701102','361.0859925','677.644106544','246.330714',253,4,150,333,0,0,0,41,200,1,1,0,1),
(21422,21422,'Dancer of Empire',0,'',0,'LineageMonster.banshee','9','23',78,'female','L2Monster',40,'3010.8929976','1777.86','8.772','3.1008',40,43,30,21,20,20,41481,4766,'961.93701102','361.0859925','677.644106544','246.330714',253,4,0,333,0,0,0,80,120,1,1,0,1),
(21423,21423,'Dancer of Empire',0,'',0,'LineageMonster.banshee','9','23',78,'female','L2Monster',40,'3010.8929976','1777.86','8.772','3.1008',40,43,30,21,20,20,43973,5052,'961.93701102','361.0859925','677.644106544','246.330714',253,4,150,333,0,0,0,80,120,1,1,0,1),
(21424,21424,'Ashkenas',0,'',0,'LineageMonster2.ashuras','13','37.5',78,'male','L2Monster',40,'3010.8929976','1777.86','8.772','3.1008',40,43,30,21,20,20,55732,6403,'961.93701102','361.0859925','677.644106544','246.330714',253,4,350,333,0,0,0,41,190,1,1,0,1),
(21425,21425,'Ashkenas',0,'',0,'LineageMonster2.ashuras','13','37.5',78,'male','L2Monster',40,'3010.8929976','1777.86','8.772','3.1008',40,43,30,21,20,20,56668,6510,'961.93701102','361.0859925','677.644106544','246.330714',253,4,350,333,0,0,0,41,190,1,1,0,1),
(21426,21426,'Abraxion',0,'',0,'LineageMonster2.erinyes','21','50',78,'male','L2Monster',40,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,65250,7585,'985.66600746','367.3536375','699.2575207596','253.534464',253,1,350,333,0,0,0,31,130,1,1,0,1),
(21427,21427,'Abraxion',0,'',0,'LineageMonster2.erinyes','21','50',78,'male','L2Monster',40,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,38349,4458,'985.66600746','367.3536375','699.2575207596','253.534464',253,1,350,333,0,0,0,31,130,1,1,0,1),
(21428,21428,'Hasturan',0,'',0,'LineageMonster2.erinyes','21','50',78,'male','L2Monster',40,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,36621,4257,'985.66600746','367.3536375','699.2575207596','253.534464',253,1,150,333,0,0,0,31,150,1,1,0,1),
(21429,21429,'Hasturan',0,'',0,'LineageMonster2.erinyes','21','50',78,'male','L2Monster',40,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,38239,4445,'985.66600746','367.3536375','699.2575207596','253.534464',253,1,150,333,0,0,0,31,150,1,1,0,1),
(21430,21430,'Arimanes',0,'',0,'LineageMonster2.ahrimanes','14','57.75',78,'male','L2Monster',40,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,52810,6139,'985.66600746','367.3536375','699.2575207596','253.534464',253,4,0,333,6722,0,0,35,210,1,1,0,1),
(21431,21431,'Arimanes',0,'',0,'LineageMonster2.ahrimanes','14','57.75',78,'male','L2Monster',40,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,45045,5236,'985.66600746','367.3536375','699.2575207596','253.534464',253,4,0,333,6722,0,0,35,210,1,1,0,1),
(21432,21432,'Chakram Beetle',0,'',0,'LineageMonster2.tera_beetle','19','54.5',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,72932,8186,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,0,333,0,0,0,45,170,1,1,0,1),
(21433,21433,'Jamadar Beetle',0,'',0,'LineageMonster2.tera_beetle_20_sm','20','43.6',78,'male','L2Monster',40,'2870.7774087','1657.41','8.585','3.03',40,43,30,21,20,20,70729,7839,'884.2525659','340.4407808','609.868172336','226.669315301277',253,4,0,333,0,0,0,45,175,1,1,0,1),
(21434,21434,'Seer of Blood',0,'',0,'LineageMonster2.erinyes','21','50',78,'male','L2Monster',40,'3010.8929976','1777.86','8.772','3.1008',40,43,30,21,20,20,141369,16242,'961.93701102','361.0859925','677.644106544','246.330714',253,1,0,333,0,0,0,31,150,1,1,0,1),
(21435,21435,'Guide of Offering',0,'',0,'LineageMonster2.imperial_warlord_zombie','7','30',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,71537,8029,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,0,333,134,6721,0,39,150,1,1,0,1),
(21436,21436,'Leader of Offering',0,'',0,'LineageMonster2.imperial_warlord_zombie','7','30',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,74207,8329,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,0,333,134,6721,0,39,150,1,1,0,1),
(21437,21437,'Offering Bug',0,'',0,'LineageMonster2.scarab','14','22',78,'male','L2Monster',40,'2870.7774087','1657.41','8.585','3.03',40,43,30,21,20,20,29957,3320,'884.2525659','340.4407808','609.868172336','226.669315301277',253,4,0,333,0,0,0,45,180,1,1,0,1),
(21438,21438,'Heathen Warrior',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,1790,167,'582.81759','271.89033','397.98887','181.027644954078',253,8,150,333,946,945,0,80,175,1,1,0,1),
(21439,21439,'Heathen Executed',0,'',0,'LineageMonster.hungry_spirit','30','40',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,1846,174,'603.79903','276.72752','412.31647','184.248304515217',253,4,150,333,0,0,0,15,175,1,1,0,1),
(21440,21440,'Heathen Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',67,'male','L2Monster',1100,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,2021,192,'624.93199','281.55251','426.74754','187.460838840844',253,8,0,333,284,0,0,40,155,1,1,0,1),
(21441,21441,'Heathen Grunt',0,'',0,'LineageMonster.skeleton_pikeman','10','28',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,1959,190,'646.17968','286.3615','441.25696','190.662718462344',253,4,150,333,96,0,0,50,170,1,1,0,1),
(21442,21442,'Heathen Knight',0,'',0,'LineageMonster.skeleton_knight','10','25',69,'male','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,2017,197,'667.50361','291.15063','455.81844','193.851368417065',253,4,150,333,150,103,0,40,165,1,1,0,1),
(21443,21443,'Raider of Pastureland',0,'',0,'LineageMonster.dark_mahum','13','26',63,'male','L2Monster',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,8408,760,'541.44774','262.19426','369.73862','174.571895122369',253,8,150,333,153,0,0,50,165,1,1,1,1),
(21444,21444,'Raider of Pastureland',0,'',0,'LineageMonster.dark_mahum','13','26',63,'male','L2Monster',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,7066,638,'541.44774','262.19426','369.73862','174.571895122369',253,4,150,333,153,0,0,50,165,1,1,1,1),
(21445,21445,'Alpine Bandersnatch',0,'',0,'LineageMonster2.bandersnatch','18','25',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,7292,667,'562.02275','267.04468','383.78868','177.801362329617',253,4,150,333,0,0,0,30,170,1,1,1,1),
(21446,21446,'Raider of Pastureland',0,'',0,'LineageMonster.dark_mahum','13','26',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,8972,821,'562.02275','267.04468','383.78868','177.801362329617',253,8,150,333,160,0,0,50,165,1,1,1,1),
(21447,21447,'Raider of Pastureland',0,'',0,'LineageMonster.dark_mahum','13','26',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,9228,869,'603.79903','276.72752','412.31647','184.248304515217',253,8,150,333,229,0,0,50,165,1,1,1,1),
(21448,21448,'Raider of Pastureland',0,'',0,'LineageMonster.dark_mahum','13','26',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,7754,730,'603.79903','276.72752','412.31647','184.248304515217',253,4,150,333,229,0,0,50,165,1,1,1,1),
(21449,21449,'Raider of Pastureland',0,'',0,'LineageMonster.dark_mahum','13','26',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,10128,978,'646.17968','286.3615','441.25696','190.662718462344',253,8,150,333,234,0,0,50,165,1,1,1,1),
(21450,21450,'Alpine Grendel',0,'',0,'LineageMonster2.bionic_bear','15','39',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,9796,947,'646.17968','286.3615','441.25696','190.662718462344',253,4,150,333,0,0,0,36,155,1,1,1,1),
(21451,21451,'Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7','15',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,3318,308,'582.81759','271.89033','397.98887','181.027644954078',253,4,0,333,0,0,0,13,110,1,1,1,1),
(21452,21452,'Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7','15',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,8775,815,'582.81759','271.89033','397.98887','181.027644954078',253,4,0,333,0,0,0,13,140,1,1,1,1),
(21453,21453,'Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7','15',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,7374,685,'582.81759','271.89033','397.98887','181.027644954078',253,4,0,333,0,0,0,13,140,1,1,1,1),
(21454,21454,'Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7','15',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,8775,815,'582.81759','271.89033','397.98887','181.027644954078',253,4,0,333,0,0,0,13,140,1,1,1,1),
(21455,21455,'Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7','15',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,7374,685,'582.81759','271.89033','397.98887','181.027644954078',253,4,0,333,0,0,0,13,140,1,1,1,1),
(21456,21456,'Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7','15',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,8775,815,'582.81759','271.89033','397.98887','181.027644954078',253,4,0,333,0,0,0,13,140,1,1,1,1),
(21457,21457,'Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7','15',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,7374,685,'582.81759','271.89033','397.98887','181.027644954078',253,4,0,333,0,0,0,13,140,1,1,1,1),
(21458,21458,'Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7','15',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,8775,815,'582.81759','271.89033','397.98887','181.027644954078',253,4,0,333,0,0,0,13,140,1,1,1,1),
(21459,21459,'Alpine Kookaburra',0,'',0,'LineageMonster2.baby_ostrich','7','15',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,7374,685,'582.81759','271.89033','397.98887','181.027644954078',253,4,0,333,0,0,0,13,140,1,1,1,1),
(21460,21460,'Alpine Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8','26.4',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,18387,1708,'582.81759','271.89033','397.98887','181.027644954078',253,4,150,333,0,0,0,23,190,1,1,0,1),
(21461,21461,'Alpine Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8','26.4',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,19112,1776,'582.81759','271.89033','397.98887','181.027644954078',253,4,150,333,0,0,0,23,190,1,1,0,1),
(21462,21462,'Alpine Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8','26.4',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,18387,1708,'582.81759','271.89033','397.98887','181.027644954078',253,4,150,333,0,0,0,23,190,1,1,0,1),
(21463,21463,'Alpine Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8','26.4',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,17683,1643,'582.81759','271.89033','397.98887','181.027644954078',253,4,150,333,0,0,0,23,190,1,1,0,1),
(21464,21464,'Alpine Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8','26.4',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,18387,1708,'582.81759','271.89033','397.98887','181.027644954078',253,4,150,333,0,0,0,23,190,1,1,0,1),
(21465,21465,'Alpine Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8','26.4',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,19112,1776,'582.81759','271.89033','397.98887','181.027644954078',253,4,150,333,0,0,0,23,190,1,1,0,1),
(21466,21466,'Alpine Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8','26.4',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,18387,1708,'582.81759','271.89033','397.98887','181.027644954078',253,4,150,333,0,0,0,23,190,1,1,0,1),
(21467,21467,'Alpine Kookaburra',0,'',0,'LineageMonster2.youth_ostrich','8','26.4',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,17683,1643,'582.81759','271.89033','397.98887','181.027644954078',253,4,150,333,0,0,0,23,190,1,1,0,1),
(21468,21468,'Alpine Kookaburra',0,'',0,'LineageMonster2.rough_ostrich','10','33',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,30997,2880,'582.81759','271.89033','397.98887','181.027644954078',253,4,150,333,0,0,0,23,210,1,1,0,1),
(21469,21469,'Alpine Kookaburra',0,'',0,'LineageMonster2.rough_ostrich','10','33',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,29568,2747,'582.81759','271.89033','397.98887','181.027644954078',253,4,150,333,0,0,0,23,210,1,1,0,1),
(21470,21470,'Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12','15',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,3526,336,'624.93199','281.55251','426.74754','187.460838840844',253,1,0,333,0,0,0,30,110,1,1,1,1),
(21471,21471,'Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12','15',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,9323,888,'624.93199','281.55251','426.74754','187.460838840844',253,1,0,333,0,0,0,30,130,1,1,1,1),
(21472,21472,'Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12','15',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,7835,746,'624.93199','281.55251','426.74754','187.460838840844',253,1,0,333,0,0,0,30,130,1,1,1,1),
(21473,21473,'Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12','15',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,9323,888,'624.93199','281.55251','426.74754','187.460838840844',253,1,0,333,0,0,0,30,130,1,1,1,1),
(21474,21474,'Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12','15',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,7835,746,'624.93199','281.55251','426.74754','187.460838840844',253,1,0,333,0,0,0,30,130,1,1,1,1),
(21475,21475,'Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12','15',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,9323,888,'624.93199','281.55251','426.74754','187.460838840844',253,1,0,333,0,0,0,30,130,1,1,1,1),
(21476,21476,'Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12','15',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,7835,746,'624.93199','281.55251','426.74754','187.460838840844',253,1,0,333,0,0,0,30,130,1,1,1,1),
(21477,21477,'Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12','15',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,9323,888,'624.93199','281.55251','426.74754','187.460838840844',253,1,0,333,0,0,0,30,130,1,1,1,1),
(21478,21478,'Alpine Buffalo',0,'',0,'LineageMonster2.baby_buffalo','12','15',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,7835,746,'624.93199','281.55251','426.74754','187.460838840844',253,1,0,333,0,0,0,30,130,1,1,1,1),
(21479,21479,'Alpine Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16','25.2',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,19535,1860,'624.93199','281.55251','426.74754','187.460838840844',253,1,150,333,0,0,0,20,170,1,1,0,1),
(21480,21480,'Alpine Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16','25.2',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,20306,1934,'624.93199','281.55251','426.74754','187.460838840844',253,1,150,333,0,0,0,20,170,1,1,0,1),
(21481,21481,'Alpine Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16','25.2',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,19535,1860,'624.93199','281.55251','426.74754','187.460838840844',253,1,150,333,0,0,0,20,170,1,1,0,1),
(21482,21482,'Alpine Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16','25.2',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,18788,1789,'624.93199','281.55251','426.74754','187.460838840844',253,1,150,333,0,0,0,20,170,1,1,0,1),
(21483,21483,'Alpine Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16','25.2',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,19535,1860,'624.93199','281.55251','426.74754','187.460838840844',253,1,150,333,0,0,0,20,170,1,1,0,1),
(21484,21484,'Alpine Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16','25.2',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,20306,1934,'624.93199','281.55251','426.74754','187.460838840844',253,1,150,333,0,0,0,20,170,1,1,0,1),
(21485,21485,'Alpine Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16','25.2',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,19535,1860,'624.93199','281.55251','426.74754','187.460838840844',253,1,150,333,0,0,0,20,170,1,1,0,1),
(21486,21486,'Alpine Buffalo',0,'',0,'LineageMonster2.youth_buffalo','16','25.2',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,18788,1789,'624.93199','281.55251','426.74754','187.460838840844',253,1,150,333,0,0,0,20,170,1,1,0,1),
(21487,21487,'Alpine Buffalo',0,'',0,'LineageMonster2.buffalo','22','31',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,32934,3137,'624.93199','281.55251','426.74754','187.460838840844',253,1,150,333,0,0,0,20,170,1,1,0,1),
(21488,21488,'Alpine Buffalo',0,'',0,'LineageMonster2.buffalo','22','31',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,31415,2992,'624.93199','281.55251','426.74754','187.460838840844',253,1,150,333,0,0,0,20,170,1,1,0,1),
(21489,21489,'Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11','15.7',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,3739,366,'667.50361','291.15063','455.81844','193.851368417065',253,4,0,333,0,0,0,28,110,1,1,1,1),
(21490,21490,'Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11','15.7',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,9888,967,'667.50361','291.15063','455.81844','193.851368417065',253,4,0,333,0,0,0,28,130,1,1,1,1),
(21491,21491,'Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11','15.7',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,8309,814,'667.50361','291.15063','455.81844','193.851368417065',253,4,0,333,0,0,0,28,130,1,1,1,1),
(21492,21492,'Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11','15.7',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,9888,967,'667.50361','291.15063','455.81844','193.851368417065',253,4,0,333,0,0,0,28,130,1,1,1,1),
(21493,21493,'Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11','15.7',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,8309,814,'667.50361','291.15063','455.81844','193.851368417065',253,4,0,333,0,0,0,28,130,1,1,1,1),
(21494,21494,'Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11','15.7',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,9888,967,'667.50361','291.15063','455.81844','193.851368417065',253,4,0,333,0,0,0,28,130,1,1,1,1),
(21495,21495,'Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11','15.7',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,8309,814,'667.50361','291.15063','455.81844','193.851368417065',253,4,0,333,0,0,0,28,130,1,1,1,1),
(21496,21496,'Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11','15.7',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,9888,967,'667.50361','291.15063','455.81844','193.851368417065',253,4,0,333,0,0,0,28,130,1,1,1,1),
(21497,21497,'Alpine Cougar',0,'',0,'LineageMonster2.baby_tiger','11','15.7',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,8309,814,'667.50361','291.15063','455.81844','193.851368417065',253,4,0,333,0,0,0,28,130,1,1,1,1),
(21498,21498,'Alpine Cougar',0,'',0,'LineageMonster2.youth_tiger','16','17.2',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,20719,2027,'667.50361','291.15063','455.81844','193.851368417065',253,4,150,333,0,0,0,60,175,1,1,0,1),
(21499,21499,'Alpine Cougar',0,'',0,'LineageMonster2.youth_tiger','16','17.2',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,21536,2107,'667.50361','291.15063','455.81844','193.851368417065',253,4,150,333,0,0,0,60,175,1,1,0,1),
(21500,21500,'Alpine Cougar',0,'',0,'LineageMonster2.youth_tiger','16','17.2',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,20719,2027,'667.50361','291.15063','455.81844','193.851368417065',253,4,150,333,0,0,0,60,175,1,1,0,1),
(21501,21501,'Alpine Cougar',0,'',0,'LineageMonster2.youth_tiger','16','17.2',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,19926,1950,'667.50361','291.15063','455.81844','193.851368417065',253,4,150,333,0,0,0,60,175,1,1,0,1),
(21502,21502,'Alpine Cougar',0,'',0,'LineageMonster2.youth_tiger','16','17.2',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,20719,2027,'667.50361','291.15063','455.81844','193.851368417065',253,4,150,333,0,0,0,60,175,1,1,0,1),
(21503,21503,'Alpine Cougar',0,'',0,'LineageMonster2.youth_tiger','16','17.2',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,21536,2107,'667.50361','291.15063','455.81844','193.851368417065',253,4,150,333,0,0,0,60,175,1,1,0,1),
(21504,21504,'Alpine Cougar',0,'',0,'LineageMonster2.youth_tiger','16','17.2',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,20719,2027,'667.50361','291.15063','455.81844','193.851368417065',253,4,150,333,0,0,0,60,175,1,1,0,1),
(21505,21505,'Alpine Cougar',0,'',0,'LineageMonster2.youth_tiger','16','17.2',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,19926,1950,'667.50361','291.15063','455.81844','193.851368417065',253,4,150,333,0,0,0,60,175,1,1,0,1),
(21506,21506,'Alpine Cougar',0,'',0,'LineageMonster.saber_toothed_tiger','34','28',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,34929,3418,'667.50361','291.15063','455.81844','193.851368417065',253,4,150,333,0,0,0,60,200,1,1,0,1),
(21507,21507,'Alpine Cougar',0,'',0,'LineageMonster.saber_toothed_tiger','34','28',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,33319,3260,'667.50361','291.15063','455.81844','193.851368417065',253,4,150,333,0,0,0,60,200,1,1,0,1),
(21508,21508,'Splinter Stakato',0,'',0,'LineageMonster.blade_stakato','15','36',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,8771,825,'603.79903','276.72752','412.31647','202.49719',253,4,150,333,235,0,0,25,175,1,1,0,1),
(21509,21509,'Splinter Stakato Worker',0,'',0,'LineageMonster.blade_stakato_worker','13','40',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,8134,774,'624.93199','281.55251','426.74754','206.02791',253,4,150,333,0,0,0,25,180,1,1,0,1),
(21510,21510,'Splinter Stakato Soldier',0,'',0,'LineageMonster.blade_stakato_soldier','15','38',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,9561,923,'646.17968','286.3615','441.25696','209.54692',253,4,150,333,148,0,0,25,180,1,1,0,1),
(21511,21511,'Splinter Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone','15','39',69,'male','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,10158,993,'667.50361','291.15063','455.81844','213.05139',253,4,150,333,132,0,0,25,185,1,1,0,1),
(21512,21512,'Splinter Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone','15','39',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,9379,929,'688.86373','295.91597','470.40463','216.53847',253,4,0,333,132,0,0,25,185,1,1,0,1),
(21513,21513,'Needle Stakato',0,'',0,'LineageMonster.blade_stakato','15','36',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,9867,978,'688.86373','295.91597','470.40463','216.53847',253,4,150,333,235,0,0,25,185,1,1,0,1),
(21514,21514,'Needle Stakato Worker',0,'',0,'LineageMonster.blade_stakato_worker','13','40',71,'male','L2Monster',40,'2492.727','1377.8','8.5','3',40,43,30,21,20,20,9134,916,'710.2185','300.65359','484.98717','220.00525',253,4,150,333,0,0,0,25,190,1,1,0,1),
(21515,21515,'Needle Stakato Soldier',0,'',0,'LineageMonster.blade_stakato_soldier','15','38',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,10718,1088,'731.52506','305.35947','499.53679','223.44881',253,4,150,333,148,0,0,25,190,1,1,0,1),
(21516,21516,'Needle Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone','15','39',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,10730,1104,'752.73928','310.02959','514.02335','226.8662',253,4,150,333,132,0,0,25,195,1,1,0,1),
(21517,21517,'Needle Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone','15','39',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,10481,1092,'773.81598','314.65987','528.41601','230.25444',253,4,0,333,132,0,0,25,195,1,1,0,1),
(21518,21518,'Frenzy Stakato Soldier',0,'',0,'LineageMonster.blade_stakato_soldier','15','38',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,9228,891,'646.17968','286.3615','441.25696','209.54692',253,4,0,333,235,0,0,25,185,1,1,0,1),
(21519,21519,'Frenzy Stakato Drone',0,'',0,'LineageMonster.blade_stakato_drone','15','39',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,10345,1051,'731.52506','305.35947','499.53679','223.44881',253,4,0,333,235,0,0,25,195,1,1,0,1),
(21520,21520,'Eye of Splendor',0,'',0,'LineageMonster.kel_mahum','13','26',60,'male','L2Monster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,8960,778,'481.34551','247.65008','328.69659','164.888215781956',253,4,0,333,326,0,0,50,160,1,1,1,1),
(21521,21521,'Claws of Splendor',0,'',0,'LineageMonster.kel_mahum_warrior','13','28',60,'male','L2Monster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,8809,764,'481.34551','247.65008','328.69659','164.888215781956',253,4,0,333,326,0,0,50,160,1,1,1,1),
(21522,21522,'Claws of Splendor',0,'',0,'LineageMonster.dark_fencer','7','13',60,'male','L2Monster',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,10498,911,'481.34551','247.65008','328.69659','164.888215781956',253,4,0,333,0,0,0,25,155,1,1,1,1),
(21523,21523,'Flash of Splendor',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13','25',61,'male','L2Monster',40,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,9035,796,'501.08068','252.49346','342.17315','168.112997103103',253,1,150,333,326,0,0,50,150,1,1,1,1),
(21524,21524,'Blade of Splendor',0,'',0,'LineageMonster.kel_mahum','13','26',61,'male','L2Monster',40,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,9634,848,'501.08068','252.49346','342.17315','168.112997103103',253,4,0,333,242,0,0,50,165,1,1,1,1),
(21525,21525,'Blade of Splendor',0,'',0,'LineageMonster.kel_mahum','13','26',61,'male','L2Monster',40,'1985.55926','1066.8','7.5','2.7',40,43,30,21,20,20,9634,848,'501.08068','252.49346','342.17315','168.112997103103',253,4,0,333,242,0,0,50,165,1,1,1,1),
(21526,21526,'Wisdom of Splendor',0,'',0,'LineageMonster.kel_mahum_warrior','13','28',62,'male','L2Monster',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,11065,986,'521.12391','257.34267','355.86007','171.341654516443',253,4,150,333,193,0,0,50,160,1,1,1,1),
(21527,21527,'Anger of Splendor',0,'',0,'LineageMonster.kel_mahum_champion','13','32',63,'male','L2Monster',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,9759,881,'541.44774','262.19426','369.73862','174.571895122369',253,4,0,333,193,0,0,50,150,1,1,1,1),
(21528,21528,'Anger of Splendor',0,'',0,'LineageMonster.dark_fencer','7','13',63,'male','L2Monster',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,11574,1045,'541.44774','262.19426','369.73862','174.571895122369',253,4,0,333,0,0,0,25,155,1,1,1,1),
(21529,21529,'Soul of Splendor',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13','25',63,'male','L2Monster',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,8853,799,'541.44774','262.19426','369.73862','174.571895122369',253,1,150,333,193,0,0,50,160,1,1,1,1),
(21530,21530,'Victory of Splendor',0,'',0,'LineageMonster.kel_mahum','13','26',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,9608,880,'562.02275','267.04468','383.78868','177.801362329617',253,4,0,333,196,0,0,50,160,1,1,1,1),
(21531,21531,'Punishment of Splendor',0,'',0,'LineageMonster.kel_mahum_warrior','13','28',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,10605,971,'562.02275','267.04468','383.78868','177.801362329617',253,4,0,333,242,0,0,50,165,1,1,1,1),
(21532,21532,'Shout of Splendor',0,'',0,'LineageMonster.kel_mahum_champion','13','32',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,11348,1055,'582.81759','271.89033','397.98887','181.027644954078',253,4,150,333,196,0,0,50,150,1,1,1,1),
(21533,21533,'Alliance of Splendor',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13','25',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,9320,866,'582.81759','271.89033','397.98887','181.027644954078',253,1,0,333,196,0,0,50,160,1,1,1,1),
(21534,21534,'Alliance of Splendor',0,'',0,'LineageMonster.dark_fencer','7','13',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,12321,1145,'582.81759','271.89033','397.98887','181.027644954078',253,4,0,333,0,0,0,25,155,1,1,1,1),
(21535,21535,'Signet of Splendor',0,'',0,'LineageMonster.kel_mahum_warrior','13','28',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,11197,1054,'603.79903','276.72752','412.31647','184.248304515217',253,4,150,333,189,0,0,50,160,1,1,1,1),
(21536,21536,'Crown of Splendor',0,'',0,'LineageMonster.kel_mahum_champion','13','32',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,11385,1072,'603.79903','276.72752','412.31647','184.248304515217',253,4,0,333,189,0,0,50,165,1,1,1,1),
(21537,21537,'Fang of Splendor',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13','25',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,10686,1018,'624.93199','281.55251','426.74754','187.460838840844',253,1,0,333,189,0,0,50,155,1,1,1,1),
(21538,21538,'Fang of Splendor',0,'',0,'LineageMonster.dark_fencer','7','13',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,13091,1247,'624.93199','281.55251','426.74754','187.460838840844',253,4,0,333,0,0,0,25,155,1,1,1,1),
(21539,21539,'Wailing of Splendor',0,'',0,'LineageMonster.kel_mahum','13','26',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,11622,1106,'624.93199','281.55251','426.74754','187.460838840844',253,4,0,333,242,0,0,50,170,1,1,1,1),
(21540,21540,'Wailing of Splendor',0,'',0,'LineageMonster.kel_mahum','13','26',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,11622,1106,'624.93199','281.55251','426.74754','187.460838840844',253,4,0,333,242,0,0,50,170,1,1,1,1),
(21541,21541,'Pilgrim of Splendor',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13','25',63,'male','L2Monster',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,11933,1078,'541.44774','262.19426','369.73862','174.571895122369',253,1,150,333,315,0,0,50,165,1,1,0,1),
(21542,21542,'Disciple of Pilgrim',0,'',0,'LineageMonster.kel_mahum_warrior','13','28',62,'male','L2Monster',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,8319,742,'521.12391','257.34267','355.86007','171.341654516443',253,4,0,333,193,0,0,50,165,1,1,0,1),
(21543,21543,'Page of Pilgrim',0,'',0,'LineageMonster.kel_mahum','13','26',62,'male','L2Monster',40,'2037.81082','1097','7.5','2.7',40,43,30,21,20,20,9492,846,'521.12391','257.34267','355.86007','171.341654516443',253,4,0,333,326,0,0,50,165,1,1,0,1),
(21544,21544,'Judge of Splendor',0,'',0,'LineageMonster.kel_mahum_champion','13','32',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,13598,1295,'624.93199','281.55251','426.74754','187.460838840844',253,4,150,333,150,0,0,50,160,1,1,0,1),
(21545,21545,'Judge of Fire',0,'',0,'LineageMonster.kel_mahum_witch_doctor','13','25',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,9427,887,'603.79903','276.72752','412.31647','184.248304515217',253,1,0,333,189,0,0,50,165,1,1,0,1),
(21546,21546,'Judge of Light',0,'',0,'LineageMonster.kel_mahum','13','26',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,10756,1013,'603.79903','276.72752','412.31647','184.248304515217',253,4,0,333,196,0,0,50,165,1,1,0,1),
(21547,21547,'Corrupted Knight',0,'',0,'LineageMonster.skeleton_knight','10','25',63,'male','L2Monster',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,9739,880,'541.44774','262.19426','369.73862','191.86238',253,4,0,333,150,103,0,40,165,1,1,1,1),
(21548,21548,'Resurrected Knight',0,'',0,'LineageMonster.skeleton_knight','10','25',63,'male','L2Monster',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,8423,761,'541.44774','262.19426','369.73862','191.86238',253,4,0,333,150,103,0,40,165,1,1,1,1),
(21549,21549,'Corrupted Guard',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,10051,920,'562.02275','267.04468','383.78868','195.41171',253,8,0,333,946,0,0,80,175,1,1,1,1),
(21550,21550,'Corrupted Guard',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,10252,938,'562.02275','267.04468','383.78868','195.41171',253,8,150,333,946,945,0,80,175,1,1,1,1),
(21551,21551,'Resurrected Guard',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,11449,1078,'603.79903','276.72752','412.31647','202.49719',253,8,0,333,221,0,0,80,175,1,1,1,1),
(21552,21552,'Resurrected Guard',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,10903,1026,'603.79903','276.72752','412.31647','202.49719',253,8,150,333,221,945,0,80,175,1,1,1,1),
(21553,21553,'Trampled Man',0,'',0,'LineageMonster.zombie','13','21',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,7521,698,'582.81759','271.89033','397.98887','181.027644954078',253,4,0,333,0,0,0,15,40,1,1,1,1),
(21554,21554,'Trampled Man',0,'',0,'LineageMonster.zombie','13','21',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,7521,698,'582.81759','271.89033','397.98887','181.027644954078',253,4,0,333,0,0,0,15,40,1,1,1,1),
(21555,21555,'Slaughter Executioner',0,'',0,'LineageMonster.dark_horror','20','35',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,9144,850,'582.81759','271.89033','397.98887','181.027644954078',253,4,0,333,0,0,0,100,160,1,1,1,1),
(21556,21556,'Slaughter Executioner',0,'',0,'LineageMonster.dark_horror','20','35',65,'male','L2Monster',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,8922,829,'582.81759','271.89033','397.98887','181.027644954078',253,4,0,333,0,0,0,100,160,1,1,1,1),
(21557,21557,'Bone Snatcher',0,'',0,'LineageMonster2.black_magician','8','30',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,10529,991,'603.79903','276.72752','412.31647','184.248304515217',253,4,0,333,178,0,0,19,180,1,1,1,1),
(21558,21558,'Bone Snatcher',0,'',0,'LineageMonster2.black_magician','8','30',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,10529,991,'603.79903','276.72752','412.31647','184.248304515217',253,4,0,333,178,0,0,19,180,1,1,1,1),
(21559,21559,'Bone Maker',0,'',0,'LineageMonster2.black_magician','8','30',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,11515,1084,'603.79903','276.72752','412.31647','184.248304515217',253,4,150,333,178,0,0,19,180,1,1,1,1),
(21560,21560,'Bone Shaper',0,'',0,'LineageMonster2.black_magician','8','30',66,'male','L2Monster',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,11515,1084,'603.79903','276.72752','412.31647','184.248304515217',253,4,150,333,178,0,0,19,180,1,1,1,1),
(21561,21561,'Sacrificed Man',0,'',0,'LineageMonster.zombie','13','21',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,9669,920,'624.93199','281.55251','426.74754','187.460838840844',253,4,150,333,0,0,0,15,40,1,1,1,1),
(21562,21562,'Guillotine\'s Ghost',0,'',0,'LineageMonster.liviona','15','28',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,10013,954,'624.93199','281.55251','426.74754','187.460838840844',253,1,150,333,0,0,0,80,150,1,1,1,1),
(21563,21563,'Bone Collector',0,'',0,'LineageMonster2.black_magician','8','30',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,11634,1108,'624.93199','281.55251','426.74754','187.460838840844',253,4,0,333,178,0,0,19,180,1,1,1,1),
(21564,21564,'Skull Collector',0,'',0,'LineageMonster2.black_magician','8','30',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,11068,1054,'624.93199','281.55251','426.74754','187.460838840844',253,4,150,333,178,0,0,19,180,1,1,1,1),
(21565,21565,'Bone Animator',0,'',0,'LineageMonster2.black_magician','8','30',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,11177,1080,'646.17968','286.3615','441.25696','190.662718462344',253,4,0,333,178,0,0,19,180,1,1,1,1),
(21566,21566,'Skull Animator',0,'',0,'LineageMonster2.black_magician','8','30',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,12224,1181,'646.17968','286.3615','441.25696','190.662718462344',253,4,150,333,178,0,0,19,180,1,1,1,1),
(21567,21567,'Bone Slayer',0,'',0,'LineageMonster2.black_magician','8','30',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,14611,1411,'646.17968','286.3615','441.25696','190.662718462344',253,4,150,333,178,0,0,19,180,1,1,1,1),
(21568,21568,'Devil Bat',0,'',0,'LineageMonster.vampire_bat','10','33.5',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,12528,1211,'646.17968','286.3615','441.25696','190.662718462344',253,4,150,333,0,0,0,60,170,1,1,1,1),
(21569,21569,'Devil Bat',0,'',0,'LineageMonster.vampire_bat','10','33.5',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,9730,940,'646.17968','286.3615','441.25696','190.662718462344',253,4,150,333,0,0,0,60,170,1,1,1,1),
(21570,21570,'Ghost of Betrayer',0,'',0,'LineageMonster.binding','12','21',69,'male','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,9069,887,'667.50361','291.15063','455.81844','193.851368417065',253,4,150,333,0,0,0,10,174,1,1,1,1),
(21571,21571,'Ghost of Rebellion Soldier',0,'',0,'LineageMonster.skeleton_knight','10','25',69,'male','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,12862,1259,'667.50361','291.15063','455.81844','193.851368417065',253,4,150,333,150,103,0,40,165,1,1,1,1),
(21572,21572,'Bone Sweeper',0,'',0,'LineageMonster2.black_magician','8','30',69,'male','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,12339,1207,'667.50361','291.15063','455.81844','193.851368417065',253,4,0,333,178,0,0,19,185,1,1,1,1),
(21573,21573,'Atrox',0,'',0,'LineageMonster2.kailiharim','45','39',69,'male','L2Monster',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,13747,1345,'667.50361','291.15063','455.81844','193.851368417065',253,4,150,333,0,0,0,105,185,1,1,1,1),
(21574,21574,'Bone Grinder',0,'',0,'LineageMonster2.black_magician','8','30',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,15483,1535,'688.86373','295.91597','470.40463','197.024195544734',253,4,150,333,178,0,0,19,185,1,1,1,1),
(21575,21575,'Bone Grinder',0,'',0,'LineageMonster2.black_magician','8','30',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,8723,865,'688.86373','295.91597','470.40463','197.024195544734',253,4,150,333,178,0,0,19,185,1,1,1,1),
(21576,21576,'Ghost of Guillotine',0,'',0,'LineageMonster.liviona','15','28',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,11220,1112,'688.86373','295.91597','470.40463','197.024195544734',253,1,0,333,0,0,0,80,150,1,1,1,1),
(21577,21577,'Ghost of Guillotine',0,'',0,'LineageMonster.liviona','15','28',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,9835,976,'688.86373','295.91597','470.40463','197.024195544734',253,1,0,333,0,0,0,80,150,1,1,1,1),
(21578,21578,'Behemoth Zombie',0,'',0,'LineageMonster2.giant_zombie','13','40',71,'male','L2Monster',40,'2492.727','1377.8','8.5','3',40,43,30,21,20,20,12370,1241,'710.2185','300.65359','484.98717','200.178552092236',253,4,0,333,0,0,0,20,90,1,1,1,1),
(21579,21579,'Ghost of Rebellion Leader',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',71,'male','L2Monster',40,'2492.727','1377.8','8.5','3',40,43,30,21,20,20,13012,1306,'710.2185','300.65359','484.98717','200.178552092236',253,8,0,333,221,945,0,80,175,1,1,1,1),
(21580,21580,'Bone Caster',0,'',0,'LineageMonster2.black_magician','8','30',71,'male','L2Monster',40,'2492.727','1377.8','8.5','3',40,43,30,21,20,20,12185,1223,'710.2185','300.65359','484.98717','200.178552092236',253,4,0,333,178,0,0,19,185,1,1,1,1),
(21581,21581,'Bone Puppeteer',0,'',0,'LineageMonster2.black_magician','8','30',71,'male','L2Monster',40,'2492.727','1377.8','8.5','3',40,43,30,21,20,20,13326,1337,'710.2185','300.65359','484.98717','200.178552092236',253,4,150,333,178,0,0,19,185,1,1,1,1),
(21582,21582,'Vampire Soldier',0,'',0,'LineageMonster2.vampire_soldier','8','23.5',71,'male','L2Monster',40,'2492.727','1377.8','8.5','3',40,43,30,21,20,20,14270,1432,'710.2185','300.65359','484.98717','200.178552092236',253,4,0,333,234,0,0,60,190,1,1,1,1),
(21583,21583,'Bone Scavenger',0,'',0,'LineageMonster2.black_magician','8','30',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,13436,1364,'731.52506','305.35947','499.53679','203.311781207645',253,4,0,333,178,0,0,19,185,1,1,1,1),
(21584,21584,'Bone Scavenger',0,'',0,'LineageMonster2.black_magician','8','30',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,12531,1273,'731.52506','305.35947','499.53679','203.311781207645',253,4,0,333,178,0,0,19,185,1,1,1,1),
(21585,21585,'Vampire Magician',0,'',0,'LineageMonster2.vampire_witch','6','21.5',72,'female','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,11554,1174,'731.52506','305.35947','499.53679','203.311781207645',253,4,150,333,946,0,0,64,180,1,1,1,1),
(21586,21586,'Vampire Adept',0,'',0,'LineageMonster2.vampire_wizard','5.5','28',72,'female','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,13649,1387,'731.52506','305.35947','499.53679','203.311781207645',253,4,150,333,99,0,0,46,180,1,1,1,1),
(21587,21587,'Vampire Warrior',0,'',0,'LineageMonster2.vampire_soldier_20_bi','10','29',72,'male','L2Monster',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,14223,1445,'731.52506','305.35947','499.53679','203.311781207645',253,4,0,333,234,0,0,60,190,1,1,1,1),
(21588,21588,'Vampire Wizard',0,'',0,'LineageMonster2.vampire_witch','6','21.5',73,'female','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,11923,1226,'752.73928','310.02959','514.02335','206.421198742611',253,4,0,333,946,0,0,64,180,1,1,1,1),
(21589,21589,'Vampire Wizard',0,'',0,'LineageMonster2.vampire_witch','6','21.5',73,'female','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,12202,1255,'752.73928','310.02959','514.02335','206.421198742611',253,4,0,333,946,0,0,64,180,1,1,1,1),
(21590,21590,'Vampire Magister',0,'',0,'LineageMonster2.vampire_wizard','5.5','28',73,'female','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,11923,1226,'752.73928','310.02959','514.02335','206.421198742611',253,4,0,333,99,0,0,46,180,1,1,1,1),
(21591,21591,'Vampire Magister',0,'',0,'LineageMonster2.vampire_wizard','5.5','28',73,'female','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,13756,1415,'752.73928','310.02959','514.02335','206.421198742611',253,4,0,333,99,0,0,46,180,1,1,1,1),
(21592,21592,'Vampire Magister',0,'',0,'LineageMonster2.vampire_wizard','5.5','28',73,'female','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,9301,956,'752.73928','310.02959','514.02335','206.421198742611',253,4,0,333,99,0,0,46,180,1,1,1,1),
(21593,21593,'Vampire Warlord',0,'',0,'LineageMonster2.vampire_warrior','9','31.5',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,16016,1648,'752.73928','310.02959','514.02335','206.421198742611',253,4,0,333,6723,0,0,43,190,1,1,1,1),
(21594,21594,'Vampire Warlord',0,'',0,'LineageMonster2.vampire_warrior','9','31.5',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,15086,1553,'752.73928','310.02959','514.02335','206.421198742611',253,4,0,333,6723,0,0,43,190,1,1,1,1),
(21595,21595,'Vampire Warlord',0,'',0,'LineageMonster2.vampire_warrior','9','31.5',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,10993,1132,'752.73928','310.02959','514.02335','206.421198742611',253,4,0,333,6723,0,0,43,190,1,1,1,1),
(21596,21596,'Requiem Lord',0,'',0,'LineageMonster2.black_magician','8','30',68,'male','L2Monster',40,'2345.76698','1282.4','7.5','2.7',40,43,30,21,20,20,14446,1396,'646.17968','286.3615','441.25696','190.662718462344',253,4,150,333,178,0,0,19,185,1,1,0,1),
(21597,21597,'Requiem Behemoth',0,'',0,'LineageMonster2.giant_zombie','13','40',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,9919,944,'624.93199','281.55251','426.74754','187.460838840844',253,4,0,333,0,0,0,20,100,1,1,0,1),
(21598,21598,'Requiem Behemoth',0,'',0,'LineageMonster2.giant_zombie','13','40',67,'male','L2Monster',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,11015,1049,'624.93199','281.55251','426.74754','187.460838840844',253,4,0,333,0,0,0,20,100,1,1,0,1),
(21599,21599,'Requiem Priest',0,'',0,'LineageMonster2.black_magician','8','30',71,'male','L2Monster',40,'2492.727','1377.8','8.5','3',40,43,30,21,20,20,15301,1535,'710.2185','300.65359','484.98717','200.178552092236',253,4,150,333,178,0,0,19,185,1,1,0,1),
(21600,21600,'Requiem Behemoth',0,'',0,'LineageMonster2.giant_zombie','13','40',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,10827,1074,'688.86373','295.91597','470.40463','197.024195544734',253,4,0,333,0,0,0,20,100,1,1,0,1),
(21601,21601,'Requiem Behemoth',0,'',0,'LineageMonster2.giant_zombie','13','40',70,'male','L2Monster',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,12879,1277,'688.86373','295.91597','470.40463','197.024195544734',253,4,0,333,0,0,0,20,100,1,1,0,1),
(21602,21602,'Zaken\'s Pikeman',0,'',0,'LineageMonster.skeleton_pikeman','10','28',43,'male','L2Monster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,4433,300,'210.04832','169.13417','143.43577','112.611442266143',253,4,150,333,292,0,0,50,174,1,1,0,1),
(21603,21603,'Zaken\'s Pikeman',0,'',0,'LineageMonster.skeleton_pikeman','10','28',43,'male','L2Monster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,6277,425,'210.04832','169.13417','143.43577','112.611442266143',253,4,150,333,292,0,0,50,174,1,1,0,1),
(21604,21604,'Zaken\'s Elite Pikeman',0,'',0,'LineageMonster.skeleton_pikeman_20_bi','12','33.6',43,'male','L2Monster',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,10149,686,'210.04832','169.13417','143.43577','112.611442266143',253,4,150,333,292,0,0,50,174,1,1,0,1),
(21605,21605,'Zaken\'s Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',44,'male','L2Monster',1100,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,4931,337,'222.23112','173.43552','151.75505','115.475328468187',253,8,0,333,279,0,0,40,174,1,1,0,1),
(21606,21606,'Zaken\'s Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',44,'male','L2Monster',1100,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,6982,478,'222.23112','173.43552','151.75505','115.475328468187',253,8,0,333,279,0,0,40,174,1,1,0,1),
(21607,21607,'Zaken\'s Elite Archer',0,'',0,'LineageMonster.skeleton_archer_20_bi','13','32.5',44,'male','L2Monster',1100,'1138.62924','584','5.5','2.1',40,43,30,21,20,20,10911,746,'222.23112','173.43552','151.75505','115.475328468187',253,8,0,333,279,0,0,40,174,1,1,0,1),
(21608,21608,'Zaken\'s Watchman',0,'',0,'LineageMonster.liviona','15','28',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,4039,281,'234.89829','177.78746','160.40508','118.372898457316',253,1,150,333,0,0,0,80,174,1,1,0,1),
(21609,21609,'Zaken\'s Watchman',0,'',0,'LineageMonster.liviona','15','28',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,5720,397,'234.89829','177.78746','160.40508','118.372898457316',253,1,150,333,0,0,0,80,174,1,1,0,1),
(21610,21610,'Zaken\'s High Grade Watchman',0,'',0,'LineageMonster.liviona_20_bi','18','33.6',45,'male','L2Monster',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,10440,726,'234.89829','177.78746','160.40508','118.372898457316',253,1,150,333,0,0,0,80,174,1,1,0,1),
(21611,21611,'Unpleasant Humming',0,'',0,'LineageMonster.unpleasant_humming','12','26',46,'male','L2Monster',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,20,4689,332,'248.0526','182.18816','169.38777','121.302932993263',253,4,150,333,0,0,0,21,174,1,1,0,1),
(21612,21612,'Unpleasant Humming',0,'',0,'LineageMonster.unpleasant_humming','12','26',46,'male','L2Monster',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,20,6640,470,'248.0526','182.18816','169.38777','121.302932993263',253,4,150,333,0,0,0,21,174,1,1,0,1),
(21613,21613,'Unpleasant Shout',0,'',0,'LineageMonster.unpleasant_humming_20_bi','13.5','31.2',46,'male','L2Monster',40,'1229.78678','637.8','5.5','2.1',40,43,30,21,20,20,11332,803,'248.0526','182.18816','169.38777','121.302932993263',253,4,150,333,0,0,0,21,174,1,1,0,1),
(21614,21614,'Death Flyer',0,'',0,'LineageMonster.dark_horror','20','35',47,'male','L2Monster',40,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,4843,347,'261.69549','186.63569','178.7041','124.264149144103',253,1,0,333,0,0,0,100,174,1,1,0,1),
(21615,21615,'Death Flyer',0,'',0,'LineageMonster.dark_horror','20','35',47,'male','L2Monster',40,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,6858,492,'261.69549','186.63569','178.7041','124.264149144103',253,1,0,333,0,0,0,100,174,1,1,0,1),
(21616,21616,'Gigantic Flyer',0,'',0,'LineageMonster.dark_horror_bi','20','42',47,'male','L2Monster',40,'1276.53628','665','5.5','2.1',40,43,30,21,20,20,12517,898,'261.69549','186.63569','178.7041','124.264149144103',253,1,0,333,0,0,0,100,174,1,1,0,1),
(21617,21617,'Fiend Archer',0,'',0,'LineageMonster.fiend_archer','17','55',48,'male','L2Monster',1100,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,4925,360,'275.82705','191.12803','188.35412','127.255200286259',253,8,150,333,0,0,0,70,174,1,1,0,1),
(21618,21618,'Fiend Archer',0,'',0,'LineageMonster.fiend_archer','17','55',48,'male','L2Monster',1100,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,6974,510,'275.82705','191.12803','188.35412','127.255200286259',253,8,150,333,0,0,0,70,174,1,1,0,1),
(21619,21619,'Pit Archer',0,'',0,'LineageMonster.fiend_archer_20_bi','20','66',48,'male','L2Monster',1100,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,12729,930,'275.82705','191.12803','188.35412','127.255200286259',253,8,150,333,0,0,0,70,174,1,1,0,1),
(21620,21620,'Musveren',0,'',0,'LineageMonster.field_stalker','15','30',49,'male','L2Monster',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,4742,350,'290.44588','195.66302','198.33688','130.274648808072',253,4,0,333,0,0,0,70,174,1,1,0,1),
(21621,21621,'Musveren',0,'',0,'LineageMonster.field_stalker','15','30',49,'male','L2Monster',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,6715,497,'290.44588','195.66302','198.33688','130.274648808072',253,4,0,333,0,0,0,70,174,1,1,0,1),
(21622,21622,'Greater Musveren',0,'',0,'LineageMonster.field_stalker_20_bi','18','36',49,'male','L2Monster',40,'1372.18568','720','5.5','2.1',40,43,30,21,20,20,12257,906,'290.44588','195.66302','198.33688','130.274648808072',253,4,0,333,0,0,0,70,174,1,1,0,1),
(21623,21623,'Zaken\'s Guard',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,5993,451,'305.54906','200.23844','208.6504','133.321011603844',253,8,150,333,225,945,0,80,174,1,1,0,1),
(21624,21624,'Zaken\'s Guard',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,8487,640,'305.54906','200.23844','208.6504','133.321011603844',253,8,150,333,225,945,0,80,174,1,1,0,1),
(21625,21625,'Zaken\'s Elite Guard',0,'',0,'LineageMonster.skeleton_royal_guard_20_bi','13','34.5',50,'male','L2Monster',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,13722,1033,'305.54906','200.23844','208.6504','133.321011603844',253,8,150,333,225,945,0,80,174,1,1,0,1),
(21626,21626,'Kaim Vanul',0,'',0,'LineageMonster.kaim_vanul','24','40',51,'male','L2Monster',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,20,5345,408,'321.13207','204.85194','219.29157','136.392732777413',253,4,0,333,0,0,0,37,174,1,1,0,1),
(21627,21627,'Kaim Vanul',0,'',0,'LineageMonster.kaim_vanul','24','40',51,'male','L2Monster',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,20,7568,577,'321.13207','204.85194','219.29157','136.392732777413',253,4,0,333,0,0,0,37,174,1,1,0,1),
(21628,21628,'Kaim Vanul Lad',0,'',0,'LineageMonster.kaim_vanul_20_bi','28','48',51,'male','L2Monster',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,20,13814,1054,'321.13207','204.85194','219.29157','136.392732777413',253,4,0,333,0,0,0,37,174,1,1,0,1),
(21629,21629,'Pirate Zombie Captain',0,'',0,'LineageMonster.pirates_zombie_captain','17','28',52,'male','L2Monster',40,'1520.38155','804','6.5','2.4',40,43,30,21,20,20,8073,624,'337.18867','209.50106','230.25615','139.488165444537',253,8,150,333,232,0,0,14,174,1,1,0,1),
(21630,21630,'Pirate Zombie Captain',0,'',0,'LineageMonster.pirates_zombie_captain','17','28',52,'male','L2Monster',40,'1520.38155','804','6.5','2.4',40,43,30,21,20,20,11432,884,'337.18867','209.50106','230.25615','139.488165444537',253,8,150,333,232,0,0,14,174,1,1,0,1),
(21631,21631,'Zombie Captain\'s Spiritual Body',0,'',0,'LineageMonster.pirates_zombie_captain_20_bi','20','33.6',52,'male','L2Monster',40,'1520.38155','804','6.5','2.4',40,43,30,21,20,20,18953,1466,'337.18867','209.50106','230.25615','139.488165444537',253,8,150,333,232,0,0,14,174,1,1,0,1),
(21632,21632,'Doll Blader',0,'',0,'LineageMonster.doll_blader','6','12',53,'male','L2Monster',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,6407,504,'353.71092','214.18326','241.5387','142.605626325743',253,8,0,333,5129,5129,0,22,174,1,1,0,1),
(21633,21633,'Doll Blader',0,'',0,'LineageMonster.doll_blader','6','12',53,'male','L2Monster',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,9073,713,'353.71092','214.18326','241.5387','142.605626325743',253,8,0,333,5129,5129,0,22,174,1,1,0,1),
(21634,21634,'Crimson Doll Blader',0,'',0,'LineageMonster.doll_blader_20_bi','7','15',53,'male','L2Monster',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,16560,1302,'353.71092','214.18326','241.5387','142.605626325743',253,8,0,333,5129,5129,0,22,174,1,1,0,1),
(21635,21635,'Vale Master',0,'',0,'LineageMonster.vale_master','12','40',54,'male','L2Monster',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,6112,487,'370.68904','218.89589','253.13256','145.743350252286',253,4,150,333,0,0,0,70,174,1,1,0,1),
(21636,21636,'Vale Master',0,'',0,'LineageMonster.vale_master','12','40',54,'male','L2Monster',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,8655,690,'370.68904','218.89589','253.13256','145.743350252286',253,4,150,333,0,0,0,70,174,1,1,0,1),
(21637,21637,'Crimson Vale Master',0,'',0,'LineageMonster.vale_master_20_bi','14.5','48',54,'male','L2Monster',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,15797,1260,'370.68904','218.89589','253.13256','145.743350252286',253,4,150,333,0,0,0,70,174,1,1,0,1),
(21638,21638,'Dread Wolf',0,'',0,'LineageMonster.dire_wolf','13','11',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,1382,82,'129.32896','136.72948','88.31491','91.0360303625432',253,4,150,333,0,0,0,24,140,1,1,1,1),
(21639,21639,'Tasaba Lizardman',0,'',0,'LineageMonster.virud_lizardman_scout','10','22',36,'male','L2Monster',1100,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,1635,98,'137.86467','140.57278','94.1437','93.5949427192352',253,8,0,333,2507,0,0,43,140,1,1,1,1),
(21640,21640,'Tasaba Lizardman Shaman',0,'',0,'LineageMonster.virud_lizardman_shaman','10','29',37,'male','L2Monster',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,20,1202,74,'146.82587','144.47758','100.26304','96.1948088105753',253,1,0,333,7,0,0,43,140,1,1,1,1),
(21641,21641,'Ogre',0,'',0,'LineageMonster.ogre','21','44',38,'male','L2Monster',40,'886.09975','447.96','4.5','1.8',40,43,30,21,20,20,2134,133,'156.22273','148.44287','106.67987','98.8349371271581',253,1,150,333,98,0,0,22,174,1,1,1,1),
(21642,21642,'Tasaba Lizardman Sniper',0,'',0,'LineageMonster.virud_lizardman_scout','10','22',39,'male','L2Monster',1100,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,1958,125,'166.06476','152.46752','113.4007','101.514599764346',253,8,150,333,2507,0,0,43,140,1,1,1,1),
(21643,21643,'Tasaba Lizardman Sniper',0,'',0,'LineageMonster.virud_lizardman_scout','10','22',39,'male','L2Monster',1100,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,2488,158,'166.06476','152.46752','113.4007','101.514599764346',253,8,150,333,2507,0,0,43,140,1,1,1,1),
(21644,21644,'Lienrik',0,'',0,'LineageMonster.lienrik','12','50',39,'male','L2Monster',40,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,1195,76,'166.06476','152.46752','113.4007','101.514599764346',253,8,0,333,0,0,0,100,150,1,1,1,1),
(21645,21645,'Lienrik Lad',0,'',0,'LineageMonster.lienrik','12','50',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,2302,149,'176.36077','156.55035','120.43155','104.232986928232',253,8,150,333,0,0,0,100,174,1,1,1,1),
(21646,21646,'Grave Scarab',0,'',0,'LineageMonster2.scarab','14','22',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,12247,1260,'752.73928','310.02959','514.02335','206.421198742611',253,4,0,333,0,0,0,45,180,1,1,1,1),
(21647,21647,'Scavenger Scarab',0,'',0,'LineageMonster2.scarab','14','22',73,'male','L2Monster',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,10332,1063,'752.73928','310.02959','514.02335','206.421198742611',253,4,150,333,0,0,0,45,180,1,1,1,1),
(21648,21648,'Grave Ant',0,'',0,'LineageMonster.ant_soldier','35','17',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,11260,1174,'773.81598','314.65987','528.41601','209.50409325236',253,4,0,333,0,0,0,80,150,1,1,1,1),
(21649,21649,'Scavenger Ant',0,'',0,'LineageMonster.ant_soldier','35','17',74,'male','L2Monster',40,'2632.19636','1475','8.5','3',40,43,30,21,20,20,13319,1388,'773.81598','314.65987','528.41601','209.50409325236',253,4,150,333,0,0,0,80,150,1,1,1,1),
(21650,21650,'Shrine Knight',0,'',0,'LineageMonster.skeleton_knight','10','25',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,12179,1285,'794.70901','319.24623','542.68324','212.557735094503',253,4,0,333,150,103,0,40,165,1,1,1,1),
(21651,21651,'Shrine Guard',0,'',0,'LineageMonster.skeleton_pikeman','10','28',75,'male','L2Monster',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,11635,1228,'794.70901','319.24623','542.68324','212.557735094503',253,4,0,333,98,0,0,50,170,1,1,1,1),
(21652,21652,'Scarlet Stakato Noble',0,'',0,'LineageMonster.blade_stakato_drone','15','39',78,'male','L2Monster',40,'2870.7774087','1657.41','8.585','3.03',40,43,30,21,20,20,46911,5199,'884.2525659','340.4407808','609.868172336','226.669315301277',253,8,450,333,235,0,0,25,165,1,1,0,1),
(21653,21653,'Assassin Beetle',0,'',0,'LineageMonster2.tera_beetle','19','54.5',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,34021,3819,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,150,333,0,0,0,45,165,1,1,0,1),
(21654,21654,'Necromancer of Destruction',0,'',0,'LineageMonster.vale_master_20_bi','14.5','48',78,'male','L2Monster',40,'2975.2369188','1742.976','8.721','3.0804',40,43,30,21,20,20,40213,4566,'938.20801458','354.8183475','656.66638089','239.180922',253,4,150,333,0,0,0,70,140,1,1,0,1),
(21655,21655,'Arimanes of Destruction',0,'',0,'LineageMonster2.ahrimanes','14','57.75',78,'male','L2Monster',40,'3010.8929976','1777.86','8.772','3.1008',40,43,30,21,20,20,35744,4106,'961.93701102','361.0859925','677.644106544','246.330714',253,4,150,333,6722,0,0,35,185,1,1,0,1),
(21656,21656,'Ashuras of Destruction',0,'',0,'LineageMonster2.ashuras_30_bi','17','49',78,'male','L2Monster',40,'3077.1572058','1848.24','8.874','3.1314',40,43,30,21,20,20,62781,7385,'1009.3950039','373.969485','719.599557852','261.022284',253,4,150,333,0,0,0,41,190,1,1,0,1),
(21657,21657,'Magma Drake',0,'',0,'LineageMonster2.inferno_drake_20_bi','29','42',78,'male','L2Monster',40,'3107.6436594','1883.736','8.925','3.1518',40,43,30,21,20,20,54374,6472,'1033.1240034','380.23713','740.577283506','268.304676',253,4,150,333,0,0,0,57,185,1,1,0,1),
(21658,21658,'Punishment of Splendor',0,'',0,'LineageMonster.kel_mahum_warrior','13','28',64,'male','L2Monster',40,'2141.82127','1158','7.5','2.7',40,43,30,21,20,20,10605,971,'562.02275','267.04468','383.78868','177.801362329617',253,4,0,333,242,0,0,50,165,1,1,1,1),
(21659,21659,'Otherworldly Invader Soldier',0,'',0,'LineageMonster.neer_crawler','14','22',30,'male','L2RiftInvader',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,4372,239,'92.64226','118.46427','63.26266','78.8748547991048',253,8,0,333,0,0,0,50,165,1,1,0,1),
(21660,21660,'Otherworldly Invader Soldier',0,'',0,'LineageMonster.neer_crawler','14','22',35,'male','L2RiftInvader',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,6221,368,'129.32896','136.72948','88.31491','91.0360303625432',253,8,150,333,0,0,0,50,165,1,1,0,1),
(21661,21661,'Otherworldly Invader Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',33,'male','L2RiftInvader',1100,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,4478,257,'113.49065','129.23095','77.49941','86.043423444366',253,8,150,333,275,0,0,40,165,1,1,0,1),
(21662,21662,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.dark_horror','20','35',35,'male','L2RiftInvader',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,5178,306,'129.32896','136.72948','88.31491','91.0360303625432',253,4,150,333,0,0,0,100,165,1,1,0,1),
(21663,21663,'Otherworldly Invader Shaman',0,'',0,'LineageMonster.dark_horror','20','35',33,'male','L2RiftInvader',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,5654,324,'113.49065','129.23095','77.49941','86.043423444366',253,4,150,333,0,0,0,100,165,1,1,0,1),
(21664,21664,'Otherworldly Invader Priest',0,'',0,'LineageMonster.dark_horror','20','35',30,'male','L2RiftInvader',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,3023,165,'92.64226','118.46427','63.26266','78.8748547991048',253,4,0,333,0,0,0,100,165,1,1,0,1),
(21665,21665,'Otherworldly Invader Magus',0,'',0,'LineageMonster.dark_horror','20','35',35,'male','L2RiftInvader',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,4089,242,'129.32896','136.72948','88.31491','91.0360303625432',253,4,150,333,0,0,0,100,165,1,1,0,1),
(21666,21666,'Otherworldly Invader Martyrs',0,'',0,'LineageMonster.dark_horror','20','35',30,'male','L2RiftInvader',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,3054,167,'92.64226','118.46427','63.26266','78.8748547991048',253,4,0,333,0,0,0,100,165,1,1,0,1),
(21667,21667,'Otherworldly Invader Warrior',0,'',0,'LineageMonster.skeleton','11','25',33,'male','L2RiftInvader',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,3635,209,'113.49065','129.23095','77.49941','86.043423444366',253,8,150,333,220,0,0,60,165,1,1,0,1),
(21668,21668,'Otherworldly Invader Soldier',0,'',0,'LineageMonster.neer_crawler','14','22',30,'male','L2RiftInvader',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,3215,176,'92.64226','118.46427','63.26266','78.8748547991048',253,8,150,333,0,0,0,50,165,1,1,0,1),
(21669,21669,'Otherworldly Invader Discipline',0,'',0,'LineageMonster.skeleton','11','25',33,'male','L2RiftInvader',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,3828,220,'113.49065','129.23095','77.49941','86.043423444366',253,8,0,333,220,0,0,60,165,1,1,0,1),
(21670,21670,'Otherworldly Invader Berserker',0,'',0,'LineageMonster.skeleton','11','25',35,'male','L2RiftInvader',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,5356,317,'129.32896','136.72948','88.31491','91.0360303625432',253,8,150,333,220,0,0,60,165,1,1,0,1),
(21671,21671,'Otherworldly Invader Food',0,'',0,'LineageMonster.mimic','8.5','8.5',30,'male','L2Chest',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,1309,72,'92.64226','118.46427','63.26266','78.8748547991048',253,4,0,333,0,0,0,80,165,1,1,0,1),
(21672,21672,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman','10','28',35,'male','L2RiftInvader',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,9595,568,'129.32896','136.72948','88.31491','91.0360303625432',253,4,150,333,96,0,0,50,165,1,1,0,1),
(21673,21673,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman','10','28',35,'male','L2RiftInvader',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,9777,579,'129.32896','136.72948','88.31491','91.0360303625432',253,4,150,333,96,0,0,50,165,1,1,0,1),
(21674,21674,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman','10','28',35,'male','L2RiftInvader',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,381,23,'129.32896','136.72948','88.31491','91.0360303625432',253,4,0,333,96,0,0,50,165,1,1,0,1),
(21675,21675,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman','10','28',30,'male','L2RiftInvader',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,778,42,'92.64226','118.46427','63.26266','78.8748547991048',253,4,0,333,96,0,0,50,165,1,1,0,1),
(21676,21676,'Otherworldly Invader Warrior',0,'',0,'LineageMonster.skeleton','11','25',33,'male','L2RiftInvader',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,8716,500,'113.49065','129.23095','77.49941','86.043423444366',253,8,150,333,220,0,0,60,165,1,1,0,1),
(21677,21677,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman','10','28',30,'male','L2RiftInvader',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,6988,382,'92.64226','118.46427','63.26266','78.8748547991048',253,4,150,333,96,0,0,50,165,1,1,0,1),
(21678,21678,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman','10','28',33,'male','L2RiftInvader',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,8456,485,'113.49065','129.23095','77.49941','86.043423444366',253,4,150,333,96,0,0,50,165,1,1,0,1),
(21679,21679,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman','10','28',30,'male','L2RiftInvader',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,6889,376,'92.64226','118.46427','63.26266','78.8748547991048',253,4,150,333,96,0,0,50,165,1,1,0,1),
(21680,21680,'Otherworldly Invader Elite Soldier',0,'',0,'LineageMonster.skeleton_pikeman','10','28',35,'male','L2RiftInvader',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,9377,555,'129.32896','136.72948','88.31491','91.0360303625432',253,4,150,333,96,0,0,50,165,1,1,0,1),
(21681,21681,'Otherworldly Invader Magus',0,'',0,'LineageMonster.dark_horror','20','35',33,'male','L2RiftInvader',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,8062,463,'113.49065','129.23095','77.49941','86.043423444366',253,4,0,333,0,0,0,100,165,1,1,0,1),
(21682,21682,'Dimension Invader Soldier',0,'',0,'LineageMonster.neer_crawler','14','22',40,'male','L2RiftInvader',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,7772,502,'176.36077','156.55035','120.43155','104.232986928232',253,8,0,333,0,0,0,50,165,1,1,0,1),
(21683,21683,'Dimension Invader Soldier',0,'',0,'LineageMonster.neer_crawler','14','22',45,'male','L2RiftInvader',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,10283,715,'234.89829','177.78746','160.40508','118.372898457316',253,8,150,333,0,0,0,50,165,1,1,0,1),
(21684,21684,'Dimension Invader Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',43,'male','L2RiftInvader',1100,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,7603,514,'210.04832','169.13417','143.43577','112.611442266143',253,8,150,333,279,0,0,40,165,1,1,0,1),
(21685,21685,'Dimension Invader Elite Soldier',0,'',0,'LineageMonster.crimson_doll','15','38',45,'male','L2RiftInvader',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,8560,595,'234.89829','177.78746','160.40508','118.372898457316',253,4,150,333,0,0,0,60,165,1,1,0,1),
(21686,21686,'Dimension Invader Shaman',0,'',0,'LineageMonster.crimson_doll','15','38',43,'male','L2RiftInvader',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,9599,649,'210.04832','169.13417','143.43577','112.611442266143',253,4,150,333,0,0,0,60,165,1,1,0,1),
(21687,21687,'Dimension Invader Priest',0,'',0,'LineageMonster.crimson_doll','15','38',40,'male','L2RiftInvader',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,5374,347,'176.36077','156.55035','120.43155','104.232986928232',253,4,0,333,0,0,0,60,165,1,1,0,1),
(21688,21688,'Dimension Invader Magus',0,'',0,'LineageMonster.crimson_doll','15','38',45,'male','L2RiftInvader',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,6759,470,'234.89829','177.78746','160.40508','118.372898457316',253,4,150,333,0,0,0,60,165,1,1,0,1),
(21689,21689,'Dimension Invader Martyrs',0,'',0,'LineageMonster.crimson_doll','15','38',40,'male','L2RiftInvader',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,5430,351,'176.36077','156.55035','120.43155','104.232986928232',253,4,0,333,0,0,0,60,165,1,1,0,1),
(21690,21690,'Dimension Invader Warrior',0,'',0,'LineageMonster.skeleton_knight','10','25',43,'male','L2RiftInvader',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,6172,417,'210.04832','169.13417','143.43577','112.611442266143',253,4,150,333,70,0,0,40,165,1,1,0,1),
(21691,21691,'Dimension Invader Soldier',0,'',0,'LineageMonster.neer_crawler','14','22',40,'male','L2RiftInvader',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,5716,369,'176.36077','156.55035','120.43155','104.232986928232',253,8,150,333,0,0,0,50,165,1,1,0,1),
(21692,21692,'Dimension Invader Discipline',0,'',0,'LineageMonster.skeleton_knight','10','25',43,'male','L2RiftInvader',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,6499,439,'210.04832','169.13417','143.43577','112.611442266143',253,4,0,333,70,0,0,40,165,1,1,0,1),
(21693,21693,'Dimension Invader Berserker',0,'',0,'LineageMonster.skeleton_knight','10','25',45,'male','L2RiftInvader',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,8854,616,'234.89829','177.78746','160.40508','118.372898457316',253,4,150,333,70,0,0,40,165,1,1,0,1),
(21694,21694,'Dimension Invader Food',0,'',0,'LineageMonster.mimic','8.5','8.5',40,'male','L2Chest',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,2327,150,'176.36077','156.55035','120.43155','104.232986928232',253,4,0,333,0,0,0,80,165,1,1,0,1),
(21695,21695,'Dimension Invader Elite Soldier',0,'',0,'LineageMonster.headless_knight','21','31',45,'male','L2RiftInvader',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,15861,1103,'234.89829','177.78746','160.40508','118.372898457316',253,4,150,333,135,0,0,70,165,1,1,0,1),
(21696,21696,'Dimension Invader Elite Soldier',0,'',0,'LineageMonster.headless_knight','21','31',45,'male','L2RiftInvader',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,16162,1124,'234.89829','177.78746','160.40508','118.372898457316',253,4,150,333,135,0,0,70,165,1,1,0,1),
(21697,21697,'Dimension Invader Elite Soldier',0,'',0,'LineageMonster.headless_knight','21','31',45,'male','L2RiftInvader',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,630,44,'234.89829','177.78746','160.40508','118.372898457316',253,4,0,333,135,0,0,70,165,1,1,0,1),
(21698,21698,'Dimension Invader Elite Soldier',0,'',0,'LineageMonster.headless_knight','21','31',40,'male','L2RiftInvader',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,1382,89,'176.36077','156.55035','120.43155','104.232986928232',253,4,0,333,135,0,0,70,165,1,1,0,1),
(21699,21699,'Dimension Invader Warrior',0,'',0,'LineageMonster.skeleton_knight','10','25',43,'male','L2RiftInvader',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,14798,1000,'210.04832','169.13417','143.43577','112.611442266143',253,4,150,333,70,0,0,40,165,1,1,0,1),
(21700,21700,'Dimension Invader Elite Soldier',0,'',0,'LineageMonster.headless_knight','21','31',40,'male','L2RiftInvader',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,12423,802,'176.36077','156.55035','120.43155','104.232986928232',253,4,150,333,135,0,0,70,165,1,1,0,1),
(21701,21701,'Dimension Invader Elite Soldier',0,'',0,'LineageMonster.headless_knight','21','31',43,'male','L2RiftInvader',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,14357,971,'210.04832','169.13417','143.43577','112.611442266143',253,4,150,333,135,0,0,70,165,1,1,0,1),
(21702,21702,'Dimension Invader Elite Soldier',0,'',0,'LineageMonster.headless_knight','21','31',40,'male','L2RiftInvader',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,12248,791,'176.36077','156.55035','120.43155','104.232986928232',253,4,150,333,135,0,0,70,165,1,1,0,1),
(21703,21703,'Dimension Invader Elite Soldier',0,'',0,'LineageMonster.headless_knight','21','31',45,'male','L2RiftInvader',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,15501,1078,'234.89829','177.78746','160.40508','118.372898457316',253,4,150,333,135,0,0,70,165,1,1,0,1),
(21704,21704,'Dimension Invader Magus',0,'',0,'LineageMonster.crimson_doll','15','38',43,'male','L2RiftInvader',40,'1094.28943','557.4','5.5','2.1',40,43,30,21,20,20,13688,925,'210.04832','169.13417','143.43577','112.611442266143',253,4,0,333,0,0,0,60,165,1,1,0,1),
(21705,21705,'Purgatory Invader Soldier',0,'',0,'LineageMonster.doll_blader','6','12',50,'male','L2RiftInvader',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,12144,915,'305.54906','200.23844','208.6504','133.321011603844',253,8,0,333,5129,5129,0,22,165,1,1,0,1),
(21706,21706,'Purgatory Invader Soldier',0,'',0,'LineageMonster.doll_blader','6','12',55,'male','L2RiftInvader',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,15362,1240,'388.11142','223.6362','265.02979','148.899508363765',253,8,150,333,5129,5129,0,22,165,1,1,0,1),
(21707,21707,'Purgatory Invader Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',53,'male','L2RiftInvader',1100,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,11550,908,'353.71092','214.18326','241.5387','142.605626325743',253,8,150,333,282,0,0,40,165,1,1,0,1),
(21708,21708,'Purgatory Invader Elite Soldier',0,'',0,'LineageMonster.banshee','9','23',55,'female','L2RiftInvader',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,12787,1032,'388.11142','223.6362','265.02979','148.899508363765',253,1,150,333,3939,0,0,80,165,1,1,0,1),
(21709,21709,'Purgatory Invader Shaman',0,'',0,'LineageMonster.banshee','9','23',53,'female','L2RiftInvader',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,14583,1146,'353.71092','214.18326','241.5387','142.605626325743',253,1,150,333,3939,0,0,80,165,1,1,0,1),
(21710,21710,'Purgatory Invader Priest',0,'',0,'LineageMonster.banshee','9','23',50,'female','L2RiftInvader',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,8396,633,'305.54906','200.23844','208.6504','133.321011603844',253,1,0,333,3939,0,0,80,165,1,1,0,1),
(21711,21711,'Purgatory Invader Magus',0,'',0,'LineageMonster.banshee','9','23',55,'female','L2RiftInvader',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,10097,815,'388.11142','223.6362','265.02979','148.899508363765',253,1,150,333,3939,0,0,80,165,1,1,0,1),
(21712,21712,'Purgatory Invader Martyrs',0,'',0,'LineageMonster.banshee','9','23',50,'female','L2RiftInvader',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,8484,639,'305.54906','200.23844','208.6504','133.321011603844',253,1,0,333,3939,0,0,80,165,1,1,0,1),
(21713,21713,'Purgatory Invader Warrior',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',53,'male','L2RiftInvader',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,9376,737,'353.71092','214.18326','241.5387','142.605626325743',253,8,150,333,946,946,0,80,165,1,1,0,1),
(21714,21714,'Purgatory Invader Soldier',0,'',0,'LineageMonster.doll_blader','6','12',50,'male','L2RiftInvader',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,8932,673,'305.54906','200.23844','208.6504','133.321011603844',253,8,150,333,5129,5129,0,22,165,1,1,0,1),
(21715,21715,'Purgatory Invader Disciples',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',53,'male','L2RiftInvader',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,9873,776,'353.71092','214.18326','241.5387','142.605626325743',253,8,0,333,946,946,0,80,165,1,1,0,1),
(21716,21716,'Purgatory Invader Berserker',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',55,'male','L2RiftInvader',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,13227,1068,'388.11142','223.6362','265.02979','148.899508363765',253,8,150,333,946,946,0,80,165,1,1,0,1),
(21717,21717,'Purgatory Invader Food',0,'',0,'LineageMonster.mimic','8.5','8.5',50,'male','L2Chest',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,3636,274,'305.54906','200.23844','208.6504','133.321011603844',253,4,0,333,0,0,0,80,165,1,1,0,1),
(21718,21718,'Purgatory Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen','14','40',55,'female','L2RiftInvader',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,23694,1913,'388.11142','223.6362','265.02979','148.899508363765',253,4,150,333,0,0,0,80,165,1,1,0,1),
(21719,21719,'Purgatory Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen','14','40',55,'female','L2RiftInvader',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,24143,1949,'388.11142','223.6362','265.02979','148.899508363765',253,4,150,333,0,0,0,80,165,1,1,0,1),
(21720,21720,'Purgatory Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen','14','40',55,'female','L2RiftInvader',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,942,76,'388.11142','223.6362','265.02979','148.899508363765',253,4,0,333,0,0,0,80,165,1,1,0,1),
(21721,21721,'Purgatory Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen','14','40',50,'female','L2RiftInvader',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,2160,163,'305.54906','200.23844','208.6504','133.321011603844',253,4,0,333,0,0,0,80,165,1,1,0,1),
(21722,21722,'Purgatory Invader Warrior',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',53,'male','L2RiftInvader',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,22482,1767,'353.71092','214.18326','241.5387','142.605626325743',253,8,150,333,946,946,0,80,165,1,1,0,1),
(21723,21723,'Purgatory Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen','14','40',50,'female','L2RiftInvader',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,19411,1462,'305.54906','200.23844','208.6504','133.321011603844',253,4,150,333,0,0,0,80,165,1,1,0,1),
(21724,21724,'Purgatory Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen','14','40',53,'female','L2RiftInvader',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,21811,1715,'353.71092','214.18326','241.5387','142.605626325743',253,4,150,333,0,0,0,80,165,1,1,0,1),
(21725,21725,'Purgatory Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen','14','40',50,'female','L2RiftInvader',40,'1421.00103','747.8','5.5','2.1',40,43,30,21,20,20,19137,1442,'305.54906','200.23844','208.6504','133.321011603844',253,4,150,333,0,0,0,80,165,1,1,0,1),
(21726,21726,'Purgatory Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen','14','40',55,'female','L2RiftInvader',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,23156,1869,'388.11142','223.6362','265.02979','148.899508363765',253,4,150,333,0,0,0,80,165,1,1,0,1),
(21727,21727,'Purgatory Invader Magus',0,'',0,'LineageMonster.banshee','9','23',53,'female','L2RiftInvader',40,'1570.8463','832.4','6.5','2.4',40,43,30,21,20,20,20795,1635,'353.71092','214.18326','241.5387','142.605626325743',253,1,0,333,3939,0,0,80,165,1,1,0,1),
(21728,21728,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.doll_blader','6','12',60,'male','L2RiftInvader',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,17487,1518,'481.34551','247.65008','328.69659','164.888215781956',253,8,0,333,5129,5129,0,22,165,1,1,0,1),
(21729,21729,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.doll_blader','6','12',65,'male','L2RiftInvader',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,21456,1993,'582.81759','271.89033','397.98887','181.027644954078',253,8,150,333,5129,5129,0,22,165,1,1,0,1),
(21730,21730,'Forbidden Path Invader Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',63,'male','L2RiftInvader',1100,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,16320,1473,'541.44774','262.19426','369.73862','174.571895122369',253,8,150,333,284,0,0,40,165,1,1,0,1),
(21731,21731,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.banshee','9','23',65,'female','L2RiftInvader',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,17859,1659,'582.81759','271.89033','397.98887','181.027644954078',253,1,150,333,3939,0,0,80,165,1,1,0,1),
(21732,21732,'Forbidden Path Invader Shaman',0,'',0,'LineageMonster.banshee','9','23',63,'female','L2RiftInvader',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,20606,1860,'541.44774','262.19426','369.73862','174.571895122369',253,1,150,333,3939,0,0,80,165,1,1,0,1),
(21733,21733,'Forbidden Path Invader Priest',0,'',0,'LineageMonster.banshee','9','23',60,'female','L2RiftInvader',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,12091,1050,'481.34551','247.65008','328.69659','164.888215781956',253,1,0,333,3939,0,0,80,165,1,1,0,1),
(21734,21734,'Forbidden Path Invader Magus',0,'',0,'LineageMonster.banshee','9','23',65,'female','L2RiftInvader',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,14102,1310,'582.81759','271.89033','397.98887','181.027644954078',253,1,150,333,3939,0,0,80,165,1,1,0,1),
(21735,21735,'Forbidden Path Invader Martyrs',0,'',0,'LineageMonster.banshee','9','23',60,'female','L2RiftInvader',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,12217,1060,'481.34551','247.65008','328.69659','164.888215781956',253,1,0,333,3939,0,0,80,165,1,1,0,1),
(21736,21736,'Forbidden Path Invader Warrior',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',63,'male','L2RiftInvader',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,13248,1196,'541.44774','262.19426','369.73862','174.571895122369',253,8,150,333,946,946,0,80,165,1,1,0,1),
(21737,21737,'Forbidden Path Invader Soldier',0,'',0,'LineageMonster.doll_blader','6','12',60,'male','L2RiftInvader',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,12862,1116,'481.34551','247.65008','328.69659','164.888215781956',253,8,150,333,5129,5129,0,22,165,1,1,0,1),
(21738,21738,'Forbidden Path Invader Disciple',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',63,'male','L2RiftInvader',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,13950,1259,'541.44774','262.19426','369.73862','174.571895122369',253,8,0,333,946,946,0,80,165,1,1,0,1),
(21739,21739,'Forbidden Path Invader Berserker',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',65,'male','L2RiftInvader',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,18474,1716,'582.81759','271.89033','397.98887','181.027644954078',253,8,150,333,946,946,0,80,165,1,1,0,1),
(21740,21740,'Forbidden Path Invader Food',0,'',0,'LineageMonster.mimic','8.5','8.5',60,'male','L2Chest',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,5236,454,'481.34551','247.65008','328.69659','164.888215781956',253,4,0,333,0,0,0,80,165,1,1,0,1),
(21741,21741,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen','14','40',65,'female','L2RiftInvader',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,33094,3074,'582.81759','271.89033','397.98887','181.027644954078',253,4,150,333,0,0,0,80,165,1,1,0,1),
(21742,21742,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen','14','40',65,'female','L2RiftInvader',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,33720,3133,'582.81759','271.89033','397.98887','181.027644954078',253,4,150,333,0,0,0,80,165,1,1,0,1),
(21743,21743,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen','14','40',65,'female','L2RiftInvader',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,1315,122,'582.81759','271.89033','397.98887','181.027644954078',253,4,0,333,0,0,0,80,165,1,1,0,1),
(21744,21744,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen','14','40',60,'female','L2RiftInvader',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,3110,270,'481.34551','247.65008','328.69659','164.888215781956',253,4,0,333,0,0,0,80,165,1,1,0,1),
(21745,21745,'Forbidden Path Invader Warrior',0,'',0,'LineageMonster.skeleton_royal_guard','11','28.5',63,'male','L2RiftInvader',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,31766,2868,'541.44774','262.19426','369.73862','174.571895122369',253,8,150,333,946,946,0,80,165,1,1,0,1),
(21746,21746,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen','14','40',60,'female','L2RiftInvader',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,27952,2426,'481.34551','247.65008','328.69659','164.888215781956',253,4,150,333,0,0,0,80,165,1,1,0,1),
(21747,21747,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen','14','40',63,'female','L2RiftInvader',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,30818,2782,'541.44774','262.19426','369.73862','174.571895122369',253,4,150,333,0,0,0,80,165,1,1,0,1),
(21748,21748,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen','14','40',60,'female','L2RiftInvader',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,27557,2392,'481.34551','247.65008','328.69659','164.888215781956',253,4,150,333,0,0,0,80,165,1,1,0,1),
(21749,21749,'Forbidden Path Invader Elite Soldier',0,'',0,'LineageMonster.bloody_queen','14','40',65,'female','L2RiftInvader',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,32342,3005,'582.81759','271.89033','397.98887','181.027644954078',253,4,150,333,0,0,0,80,165,1,1,0,1),
(21750,21750,'Forbidden Path Invader Magus',0,'',0,'LineageMonster.banshee','9','23',63,'female','L2RiftInvader',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,29382,2653,'541.44774','262.19426','369.73862','174.571895122369',253,1,0,333,3939,0,0,80,165,1,1,0,1),
(21751,21751,'Dark Omen Invader Soldier',0,'',0,'LineageMonster2.giant_zombie','13','40',70,'male','L2RiftInvader',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,23802,2360,'688.86373','295.91597','470.40463','197.024195544734',253,4,0,333,0,0,0,20,165,1,1,0,1),
(21752,21752,'Dark Omen Invader Soldier',0,'',0,'LineageMonster2.giant_zombie','13','40',75,'male','L2RiftInvader',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,28565,3013,'794.70901','319.24623','542.68324','212.557735094503',253,4,150,333,0,0,0,20,165,1,1,0,1),
(21753,21753,'Dark Omen Invader Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',73,'male','L2RiftInvader',1100,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,21912,2255,'752.73928','310.02959','514.02335','206.421198742611',253,8,150,333,288,0,0,40,165,1,1,0,1),
(21754,21754,'Dark Omen Invader Elite Soldier',0,'',0,'LineageMonster.doll_master','20','42',75,'male','L2RiftInvader',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,23777,2508,'794.70901','319.24623','542.68324','212.557735094503',253,8,150,333,0,0,0,80,165,1,1,0,1),
(21755,21755,'Dark Omen Invader Shaman',0,'',0,'LineageMonster.doll_master','20','42',73,'male','L2RiftInvader',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,27667,2847,'752.73928','310.02959','514.02335','206.421198742611',253,8,150,333,0,0,0,80,165,1,1,0,1),
(21756,21756,'Dark Omen Invader Priest',0,'',0,'LineageMonster.doll_master','20','42',70,'male','L2RiftInvader',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,16457,1632,'688.86373','295.91597','470.40463','197.024195544734',253,8,0,333,0,0,0,80,165,1,1,0,1),
(21757,21757,'Dark Omen Invader Magus',0,'',0,'LineageMonster.doll_master','20','42',75,'male','L2RiftInvader',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,18775,1980,'794.70901','319.24623','542.68324','212.557735094503',253,8,150,333,0,0,0,80,165,1,1,0,1),
(21758,21758,'Dark Omen Invader Martyrs',0,'',0,'LineageMonster.doll_master','20','42',70,'male','L2RiftInvader',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,16629,1649,'688.86373','295.91597','470.40463','197.024195544734',253,8,0,333,0,0,0,80,165,1,1,0,1),
(21759,21759,'Dark Omen Invader Warrior',0,'',0,'LineageMonster2.imperial_warlord_zombie','7','30',73,'male','L2RiftInvader',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,17787,1830,'752.73928','310.02959','514.02335','206.421198742611',253,4,150,333,134,6721,0,39,165,1,1,0,1),
(21760,21760,'Dark Omen Invader Soldier',0,'',0,'LineageMonster2.giant_zombie','13','40',70,'male','L2RiftInvader',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,17506,1736,'688.86373','295.91597','470.40463','197.024195544734',253,4,150,333,0,0,0,20,165,1,1,0,1),
(21761,21761,'Dark Omen Invader Disciple',0,'',0,'LineageMonster2.imperial_warlord_zombie','7','30',73,'male','L2RiftInvader',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,18730,1927,'752.73928','310.02959','514.02335','206.421198742611',253,4,0,333,134,6721,0,39,165,1,1,0,1),
(21762,21762,'Dark Omen Invader Berserker',0,'',0,'LineageMonster2.imperial_warlord_zombie','7','30',75,'male','L2RiftInvader',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,24596,2594,'794.70901','319.24623','542.68324','212.557735094503',253,4,150,333,134,6721,0,39,165,1,1,0,1),
(21763,21763,'Dark Omen Invader Food',0,'',0,'LineageMonster.mimic','8.5','8.5',70,'male','L2Chest',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,7127,707,'688.86373','295.91597','470.40463','197.024195544734',253,4,0,333,0,0,0,80,165,1,1,0,1),
(21764,21764,'Dark Omen Invader Elite Soldier',0,'',0,'LineageMonster.death_blader','15','45',75,'male','L2RiftInvader',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,44060,4647,'794.70901','319.24623','542.68324','212.557735094503',253,4,150,333,1472,0,0,100,165,1,1,0,1),
(21765,21765,'Dark Omen Invader Elite Soldier',0,'',0,'LineageMonster.death_blader','15','45',75,'male','L2RiftInvader',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,44894,4735,'794.70901','319.24623','542.68324','212.557735094503',253,4,150,333,1472,0,0,100,165,1,1,0,1),
(21766,21766,'Dark Omen Invader Elite Soldier',0,'',0,'LineageMonster.death_blader','15','45',75,'male','L2RiftInvader',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,1751,185,'794.70901','319.24623','542.68324','212.557735094503',253,4,0,333,1472,0,0,100,165,1,1,0,1),
(21767,21767,'Dark Omen Invader Elite Soldier',0,'',0,'LineageMonster.death_blader','15','45',70,'male','L2RiftInvader',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,4233,420,'688.86373','295.91597','470.40463','197.024195544734',253,4,0,333,1472,0,0,100,165,1,1,0,1),
(21768,21768,'Dark Omen Invader Warrior',0,'',0,'LineageMonster2.imperial_warlord_zombie','7','30',73,'male','L2RiftInvader',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,42650,4389,'752.73928','310.02959','514.02335','206.421198742611',253,4,150,333,134,6721,0,39,165,1,1,0,1),
(21769,21769,'Dark Omen Invader Elite Soldier',0,'',0,'LineageMonster.death_blader','15','45',70,'male','L2RiftInvader',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,38046,3772,'688.86373','295.91597','470.40463','197.024195544734',253,4,150,333,1472,0,0,100,165,1,1,0,1),
(21770,21770,'Dark Omen Invader Elite Soldier',0,'',0,'LineageMonster.death_blader','15','45',73,'male','L2RiftInvader',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,41377,4258,'752.73928','310.02959','514.02335','206.421198742611',253,4,150,333,1472,0,0,100,165,1,1,0,1),
(21771,21771,'Dark Omen Invader Elite Soldier',0,'',0,'LineageMonster.death_blader','15','45',70,'male','L2RiftInvader',40,'2444.46819','1345.8','7.5','2.7',40,43,30,21,20,20,37509,3719,'688.86373','295.91597','470.40463','197.024195544734',253,4,150,333,1472,0,0,100,165,1,1,0,1),
(21772,21772,'Dark Omen Invader Elite Soldier',0,'',0,'LineageMonster.death_blader','15','45',75,'male','L2RiftInvader',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,43058,4542,'794.70901','319.24623','542.68324','212.557735094503',253,4,150,333,1472,0,0,100,165,1,1,0,1),
(21773,21773,'Dark Omen Invader Magus',0,'',0,'LineageMonster.doll_master','20','42',73,'male','L2RiftInvader',40,'2586.66898','1442.4','8.5','3',40,43,30,21,20,20,39450,4059,'752.73928','310.02959','514.02335','206.421198742611',253,8,0,333,0,0,0,80,165,1,1,0,1),
(21774,21774,'Messenger Invader Soldier',0,'',0,'LineageMonster2.giant_zombie','13','40',78,'male','L2RiftInvader',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,31088,3489,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,0,333,0,0,0,20,165,1,1,0,1),
(21775,21775,'Messenger Invader Soldier',0,'',0,'LineageMonster2.giant_zombie','13','40',78,'male','L2RiftInvader',40,'3107.6436594','1883.736','8.925','3.1518',40,43,30,21,20,20,36690,4367,'1033.1240034','380.23713','740.577283506','268.304676',253,4,150,333,0,0,0,20,165,1,1,0,1),
(21776,21776,'Messenger Invader Archer',0,'',0,'LineageMonster.skeleton_archer','11','27',78,'male','L2RiftInvader',1100,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,28326,3293,'985.66600746','367.3536375','699.2575207596','253.534464',253,8,150,333,289,0,0,40,165,1,1,0,1),
(21777,21777,'Messenger Invader Elite Soldier',0,'',0,'LineageMonster.doll_master','20','42',78,'male','L2RiftInvader',40,'3107.6436594','1883.736','8.925','3.1518',40,43,30,21,20,20,30540,3635,'1033.1240034','380.23713','740.577283506','268.304676',253,8,150,333,0,0,0,80,165,1,1,0,1),
(21778,21778,'Messenger Invader Shaman',0,'',0,'LineageMonster.doll_master','20','42',78,'male','L2RiftInvader',40,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,35766,4158,'985.66600746','367.3536375','699.2575207596','253.534464',253,8,150,333,0,0,0,80,165,1,1,0,1),
(21779,21779,'Messenger Invader Priest',0,'',0,'LineageMonster.doll_master','20','42',78,'male','L2RiftInvader',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,21494,2413,'912.6537108','348.2025','635.688655236','231.837152158566',253,8,0,333,0,0,0,80,165,1,1,0,1),
(21780,21780,'Messenger Invader Magus',0,'',0,'LineageMonster.doll_master','20','42',78,'male','L2RiftInvader',40,'3107.6436594','1883.736','8.925','3.1518',40,43,30,21,20,20,24116,2871,'1033.1240034','380.23713','740.577283506','268.304676',253,8,150,333,0,0,0,80,165,1,1,0,1),
(21781,21781,'Messenger Invader Martyrs',0,'',0,'LineageMonster.doll_master','20','42',78,'male','L2RiftInvader',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,21719,2438,'912.6537108','348.2025','635.688655236','231.837152158566',253,8,0,333,0,0,0,80,165,1,1,0,1),
(21782,21782,'Messenger Invader Warrior',0,'',0,'LineageMonster2.imperial_warlord_zombie','7','30',78,'male','L2RiftInvader',40,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,22994,2673,'985.66600746','367.3536375','699.2575207596','253.534464',253,4,150,333,134,6721,0,39,165,1,1,0,1),
(21783,21783,'Messenger Invader Soldier',0,'',0,'LineageMonster2.giant_zombie','13','40',78,'male','L2RiftInvader',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,22865,2566,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,150,333,0,0,0,20,165,1,1,0,1),
(21784,21784,'Messenger Invader Disciple',0,'',0,'LineageMonster2.imperial_warlord_zombie','7','30',78,'male','L2RiftInvader',40,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,24213,2815,'985.66600746','367.3536375','699.2575207596','253.534464',253,4,0,333,134,6721,0,39,165,1,1,0,1),
(21785,21785,'Messenger Invader Berserker',0,'',0,'LineageMonster2.imperial_warlord_zombie','7','30',78,'male','L2RiftInvader',40,'3107.6436594','1883.736','8.925','3.1518',40,43,30,21,20,20,31592,3760,'1033.1240034','380.23713','740.577283506','268.304676',253,4,150,333,134,6721,0,39,165,1,1,0,1),
(21786,21786,'Messenger Invader Food',0,'',0,'LineageMonster.mimic','8.5','8.5',78,'male','L2Chest',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,9308,1045,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,0,333,0,0,0,80,165,1,1,0,1),
(21787,21787,'Messenger Invader Elite Soldier',0,'',0,'LineageMonster.death_lord','21','40',78,'male','L2RiftInvader',40,'3107.6436594','1883.736','8.925','3.1518',40,43,30,21,20,20,56592,6736,'1033.1240034','380.23713','740.577283506','268.304676',253,4,150,333,78,0,0,40,165,1,1,0,1),
(21788,21788,'Messenger Invader Elite Soldier',0,'',0,'LineageMonster.death_lord','21','40',78,'male','L2RiftInvader',40,'3107.6436594','1883.736','8.925','3.1518',40,43,30,21,20,20,57664,6864,'1033.1240034','380.23713','740.577283506','268.304676',253,4,150,333,78,0,0,40,165,1,1,0,1),
(21789,21789,'Messenger Invader Elite Soldier',0,'',0,'LineageMonster.death_lord','21','40',78,'male','L2RiftInvader',40,'3107.6436594','1883.736','8.925','3.1518',40,43,30,21,20,20,2249,268,'1033.1240034','380.23713','740.577283506','268.304676',253,4,0,333,78,0,0,40,165,1,1,0,1),
(21790,21790,'Messenger Invader Elite Soldier',0,'',0,'LineageMonster.death_lord','21','40',78,'male','L2RiftInvader',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,5529,621,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,0,333,78,0,0,40,165,1,1,0,1),
(21791,21791,'Messenger Invader Warrior',0,'',0,'LineageMonster2.imperial_warlord_zombie','7','30',78,'male','L2RiftInvader',40,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,55136,6409,'985.66600746','367.3536375','699.2575207596','253.534464',253,4,150,333,134,6721,0,39,165,1,1,0,1),
(21792,21792,'Messenger Invader Elite Soldier',0,'',0,'LineageMonster.death_lord','21','40',78,'male','L2RiftInvader',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,49693,5578,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,150,333,78,0,0,40,165,1,1,0,1),
(21793,21793,'Messenger Invader Elite Soldier',0,'',0,'LineageMonster.death_lord','21','40',78,'male','L2RiftInvader',40,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,53490,6218,'985.66600746','367.3536375','699.2575207596','253.534464',253,4,150,333,78,0,0,40,165,1,1,0,1),
(21794,21794,'Messenger Invader Elite Soldier',0,'',0,'LineageMonster.death_lord','21','40',78,'male','L2RiftInvader',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,48991,5499,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,150,333,78,0,0,40,165,1,1,0,1),
(21795,21795,'Messenger Invader Elite Soldier',0,'',0,'LineageMonster.death_lord','21','40',78,'male','L2RiftInvader',40,'3107.6436594','1883.736','8.925','3.1518',40,43,30,21,20,20,55306,6583,'1033.1240034','380.23713','740.577283506','268.304676',253,4,150,333,78,0,0,40,165,1,1,0,1),
(21796,21796,'Messenger Invader Magus',0,'',0,'LineageMonster.doll_master','20','42',78,'male','L2RiftInvader',40,'3044.88717','1812.948','8.823','3.111',40,43,30,21,20,20,50999,5928,'985.66600746','367.3536375','699.2575207596','253.534464',253,8,0,333,0,0,0,80,165,1,1,0,1),
(21797,21797,'Spirit of Timiniel',0,'',0,'LineageMonster.pixy','5','25',55,'female','L2Monster',40,'1673.05473','889.8','6.5','2.4',40,43,30,21,20,20,2376,192,'388.11142','223.6362','265.02979','148.899508363765',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21798,21798,'Ghost of a Gatekeeper',0,'',0,'LineageMonster.skeleton_knight','10','25',76,'male','L2Monster',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,20,14209,1519,'815.37145','323.78455','556.793','215.579412824268',253,4,0,333,150,103,0,40,165,1,1,0,1),
(21799,21799,'Ghost of a Gatekeeper',0,'',0,'LineageMonster.skeleton_knight','10','25',76,'male','L2Monster',40,'2719.97952','1540.8','8.5','3',40,43,30,21,20,20,26132,2794,'815.37145','323.78455','556.793','215.579412824268',253,4,0,333,150,103,0,40,165,1,1,0,1),
(21800,21800,'Vassal Ghost',0,'',0,'LineageMonster.zombie','13','21',77,'male','L2Monster',40,'2762.08447','1574','8.5','3',40,43,30,21,20,20,13234,1432,'835.75573','328.27073','570.71283','218.566351305224',253,4,0,333,0,0,0,15,15,1,1,0,1),
(21801,21801,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',21,'male','L2Chest',40,'364.30351','205.2','3.5','1.5',40,43,30,21,20,20,631,29,'47.91924','89.73059','32.72263','59.7436374813816',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21802,21802,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',24,'male','L2Chest',40,'435.34437','245.52','3.5','1.5',40,43,30,21,20,20,772,38,'60.19687','98.70919','41.10666','65.7216907961494',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21803,21803,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',27,'male','L2Chest',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,919,47,'74.99121','108.28767','51.20928','72.0991544841329',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21804,21804,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',30,'male','L2Chest',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,1080,59,'92.64226','118.46427','63.26266','78.8748547991048',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21805,21805,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',33,'male','L2Chest',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,1307,75,'113.49065','129.23095','77.49941','86.043423444366',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21806,21806,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',36,'male','L2Chest',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,1555,94,'137.86467','140.57278','94.1437','93.5949427192352',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21807,21807,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',39,'male','L2Chest',40,'925.85879','463.32','4.5','1.8',40,43,30,21,20,20,1825,116,'166.06476','152.46752','113.4007','101.514599764346',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21808,21808,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',42,'male','L2Chest',40,'1050.81652','531','5.5','2.1',40,43,30,21,20,20,2117,141,'198.34591','164.88513','135.44454','109.782377202178',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21809,21809,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',45,'male','L2Chest',40,'1183.80594','610.8','5.5','2.1',40,43,30,21,20,20,2430,169,'234.89829','177.78746','160.40508','118.372898457316',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21810,21810,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',48,'male','L2Chest',40,'1324.01623','692.4','5.5','2.1',40,43,30,21,20,20,2765,202,'275.82705','191.12803','188.35412','127.255200286259',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21811,21811,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',51,'male','L2Chest',40,'1470.41596','775.8','6.5','2.4',40,43,30,21,20,20,3121,238,'321.13207','204.85194','219.29157','136.392732777413',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21812,21812,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',54,'male','L2Chest',40,'1621.75618','861','6.5','2.4',40,43,30,21,20,20,3499,279,'370.68904','218.89589','253.13256','145.743350252286',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21813,21813,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',57,'male','L2Chest',40,'1776.58018','948','6.5','2.4',40,43,30,21,20,20,3899,324,'424.23295','233.18839','289.69611','155.259456846417',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21814,21814,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',60,'male','L2Chest',40,'1933.24044','1036.8','6.5','2.4',40,43,30,21,20,20,4320,375,'481.34551','247.65008','328.69659','164.888215781956',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21815,21815,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',63,'male','L2Chest',40,'2089.92274','1127.4','7.5','2.7',40,43,30,21,20,20,4763,430,'541.44774','262.19426','369.73862','174.571895122369',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21816,21816,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',66,'male','L2Chest',40,'2244.67715','1219.8','7.5','2.7',40,43,30,21,20,20,5227,492,'603.79903','276.72752','412.31647','184.248304515217',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21817,21817,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',69,'male','L2Chest',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,5713,559,'667.50361','291.15063','455.81844','193.851368417065',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21818,21818,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',72,'male','L2Chest',40,'2540.15331','1410','8.5','3',40,43,30,21,20,20,6221,632,'731.52506','305.35947','499.53679','203.311781207645',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21819,21819,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',75,'male','L2Chest',40,'2676.65854','1507.8','8.5','3',40,43,30,21,20,20,6750,712,'794.70901','319.24623','542.68324','212.557735094503',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21820,21820,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',78,'male','L2Chest',40,'2802.89989','1607.4','8.5','3',40,43,30,21,20,20,7301,799,'855.81387','332.70061','584.40994','221.515820894982',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21821,21821,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',78,'male','L2Chest',40,'3004.4059082','1760.064','8.755','3.09',40,43,30,21,20,20,7873,894,'940.9565','355.9783','661.831856','237.312',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21822,21822,'Treasure Chest',0,'',0,'LineageMonster.mimic','8.5','8.5',80,'male','L2Chest',40,'3137.4936216','1884.48','8.84','3.12',40,43,30,21,20,20,8467,996,'1005.2800576','372.1819192','713.935000064','247.802921663855',253,1,0,333,0,0,0,80,165,1,1,0,1),
(21823,21823,'Executor of Sacrificial Offerings',0,'',0,'LineageMonster2.imperial_warlord_zombie','7','30',78,'male','L2Monster',40,'2937.9838056','1708.296','8.67','3.06',40,43,30,21,20,20,72252,8110,'912.6537108','348.2025','635.688655236','231.837152158566',253,4,0,333,134,6721,0,39,190,1,1,0,1),
(21824,21824,'Alpine Kookaburra',0,'',0,'LineageMonster2.rough_ostrich','10','33',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,30997,2880,'582.81759','271.89033','397.98887','181.027644954078',253,4,0,333,0,0,0,23,210,1,1,0,1),
(21825,21825,'Alpine Kookaburra',0,'',0,'LineageMonster2.rough_ostrich','10','33',65,'male','L2FeedableBeast',40,'2193.43142','1188.8','7.5','2.7',40,43,30,21,20,20,29568,2747,'582.81759','271.89033','397.98887','181.027644954078',253,4,0,333,0,0,0,23,210,1,1,0,1),
(21826,21826,'Alpine Buffalo',0,'',0,'LineageMonster2.buffalo','22','31',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,32934,3137,'624.93199','281.55251','426.74754','187.460838840844',253,1,0,333,0,0,0,20,170,1,1,0,1),
(21827,21827,'Alpine Buffalo',0,'',0,'LineageMonster2.buffalo','22','31',67,'male','L2FeedableBeast',40,'2295.48154','1251','7.5','2.7',40,43,30,21,20,20,31415,2992,'624.93199','281.55251','426.74754','187.460838840844',253,1,0,333,0,0,0,20,170,1,1,0,1),
(21828,21828,'Alpine Cougar',0,'',0,'LineageMonster.saber_toothed_tiger','34','28',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,34929,3418,'667.50361','291.15063','455.81844','193.851368417065',253,4,0,333,0,0,0,60,200,1,1,0,1),
(21829,21829,'Alpine Cougar',0,'',0,'LineageMonster.saber_toothed_tiger','34','28',69,'male','L2FeedableBeast',40,'2395.45533','1314','7.5','2.7',40,43,30,21,20,20,33319,3260,'667.50361','291.15063','455.81844','193.851368417065',253,4,0,333,0,0,0,60,200,1,1,0,1),
(22001,22001,'Grim Wolf',0,'',0,'LineageMonster.dire_wolf','13','11',25,'male','L2Monster',40,'460.96247','259.2','3.5','1.5',40,43,30,21,20,20,1052,52,'64.83203','101.83533','44.27187','74.51868',253,4,0,333,0,0,0,24,130,1,1,1,1),
(22002,22002,'Grim Grizzly',0,'',0,'LineageMonster.grizzly','21','40',26,'male','L2Monster',40,'487.5704','273','3.5','1.5',40,43,30,21,20,20,1120,56,'69.75926','105.02818','47.63653','76.85506',253,4,0,333,0,0,0,40,110,1,1,1,1),
(22003,22003,'Grave Robber Scout',0,'',0,'LineageNPC.e_traderB_Fdwarf_mon','7','18',27,'female','L2Monster',1100,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,1395,71,'74.99121','108.28767','51.20928','79.24022',253,8,0,333,8527,0,0,49,110,1,1,1,1),
(22004,22004,'Grave Robber Lookout',0,'',0,'LineageMonster.dwarf_ghost','9','16.5',27,'male','L2Monster',40,'515.17856','286.92','3.5','1.5',40,43,30,21,20,20,1659,84,'74.99121','108.28767','51.20928','79.24022',253,1,0,333,0,0,0,80,120,1,1,1,1),
(22005,22005,'Grave Robber Ranger',0,'',0,'LineageNPC.e_collector_teacher_Fdwarf_mon','8','17.5',28,'female','L2Monster',40,'543.79576','300.96','3.5','1.5',40,43,30,21,20,20,1477,77,'80.54056','111.61368','54.99876','81.67405',253,8,0,333,8529,0,0,45,110,1,1,1,1),
(22006,22006,'Grave Robber Guard',0,'',0,'LineageNPC.e_collector_teacher_Mdwarf_mon','8','17.5',29,'male','L2Monster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,1559,83,'86.42002','115.00598','59.01367','84.15638',253,1,0,333,8528,0,0,36,110,1,1,1,1),
(22007,22007,'Ghost of a Soldier',0,'',0,'LineageMonster.orc','10','21',29,'male','L2Monster',40,'573.42917','315.12','3.5','1.5',40,43,30,21,20,20,1699,90,'86.42002','115.00598','59.01367','84.15638',253,4,0,333,8530,0,0,45,120,1,1,0,1),
(22008,22008,'Grave Robber Fighter',0,'',0,'LineageNPC.e_collector_teacher_Mdwarf_mon','8','17.5',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,1641,89,'92.64226','118.46427','63.26266','86.68702',253,1,0,333,8528,0,0,36,110,1,1,1,1),
(22009,22009,'Ghost of a Loyal Vassal',0,'',0,'LineageMonster.orc_shaman','9','22',31,'male','L2Monster',40,'635.76437','343.8','4.5','1.8',40,43,30,21,20,20,1910,106,'99.21986','121.98819','67.7543','89.26566',253,1,0,333,8532,0,0,45,120,1,1,0,1),
(22010,22010,'Ghost of a General',0,'',0,'LineageMonster.orc_fighter','12','22',32,'male','L2Monster',40,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,2035,114,'106.16525','125.57727','72.49711','91.89199',253,4,500,333,8532,0,0,45,120,1,1,0,1),
(22011,22011,'Ghost of a Batur Chief',0,'',0,'LineageMonster.orc_champion','10','23',33,'male','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,2337,133,'113.49065','129.23095','77.49941','94.5656',253,4,500,333,8533,0,0,45,130,1,1,0,1),
(22012,22012,'Ghost of a Batur Chief',0,'',0,'LineageMonster.orc_champion','10','23',33,'male','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,2337,133,'113.49065','129.23095','77.49941','94.5656',253,4,500,333,8533,0,0,45,130,1,1,0,1),
(22013,22013,'Ghost of a Morek Chief',0,'',0,'LineageMonster.orc_champion','10','23',33,'male','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,2337,133,'113.49065','129.23095','77.49941','94.5656',253,4,500,333,8533,0,0,45,130,1,1,0,1),
(22014,22014,'Ghost of a Morek Chief',0,'',0,'LineageMonster.orc_champion','10','23',33,'male','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,2337,133,'113.49065','129.23095','77.49941','94.5656',253,4,500,333,8533,0,0,45,130,1,1,0,1),
(22015,22015,'Ghost of a Turka Chief',0,'',0,'LineageMonster.orc_champion','10','23',33,'male','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,2337,133,'113.49065','129.23095','77.49941','94.5656',253,4,500,333,8533,0,0,45,130,1,1,0,1),
(22016,22016,'Ghost of a Turka Chief',0,'',0,'LineageMonster.orc_champion','10','23',33,'male','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,2337,133,'113.49065','129.23095','77.49941','94.5656',253,4,500,333,8533,0,0,45,130,1,1,0,1),
(22017,22017,'Bandit Sweeper',0,'',0,'LineageMonster2.northern_goblin','4','15',30,'male','L2Monster',40,'604.08419','329.4','3.5','1.5',40,43,30,21,20,20,1750,95,'92.64226','118.46427','63.26266','86.68702',253,4,500,333,152,0,0,30,145,1,1,1,1),
(22018,22018,'Bandit Hound',0,'',0,'LineageMonster.dire_wolf','13','11',31,'male','L2Monster',40,'635.76437','343.8','4.5','1.8',40,43,30,21,20,20,1501,83,'99.21986','121.98819','67.7543','89.26566',253,4,500,333,0,0,0,24,130,1,1,1,1),
(22019,22019,'Bandit Watchman',0,'',0,'LineageMonster.ol_mahum_archer_04te','14','25',32,'male','L2Monster',1100,'668.47132','358.32','4.5','1.8',40,43,30,21,20,20,2056,115,'106.16525','125.57727','72.49711','91.89199',253,8,0,333,273,0,0,50,130,1,1,1,1),
(22020,22020,'Snow Lynx',0,'',0,'LineageMonster.onyx_beast','14','14.5',33,'male','L2Monster',40,'702.20463','372.96','4.5','1.8',40,43,30,21,20,20,1701,97,'113.49065','129.23095','77.49941','94.5656',253,4,0,333,0,0,0,30,140,1,1,1,1),
(22021,22021,'Bandit Undertaker',0,'',0,'LineageMonster2.northern_goblin_110p','6','16.6',34,'male','L2Monster',40,'736.96177','387.72','4.5','1.8',40,43,30,21,20,20,2081,121,'121.20802','132.9486','82.76936','97.28601',253,1,0,333,66,102,0,30,140,1,1,1,1),
(22022,22022,'Bandit Assassin',0,'',0,'LineageMonster.wererat_01te','14','25',35,'male','L2Monster',40,'772.73802','402.6','4.5','1.8',40,43,30,21,20,20,2470,145,'129.32896','136.72948','88.31491','100.0527',253,8,500,333,221,0,0,80,150,1,1,1,1),
(22023,22023,'Bandit Warrior',0,'',0,'LineageMonster.ol_mahum_04te','13.5','25',36,'male','L2Monster',40,'809.52639','417.6','4.5','1.8',40,43,30,21,20,20,2825,170,'137.86467','140.57278','94.1437','102.86506',253,4,500,333,2,0,0,50,135,1,1,1,1),
(22024,22024,'Bandit Inspector',0,'',0,'LineageMonster2.northern_goblin_120p','7','18.5',37,'male','L2Monster',40,'847.31754','432.72','4.5','1.8',40,43,30,21,20,20,2661,163,'146.82587','144.47758','100.26304','105.72243',253,1,500,333,66,0,0,30,145,1,1,1,1),
(22025,22025,'Frozen Wasteland Werewolf',0,'',0,'LineageMonster.werewolf','10','26',38,'male','L2Monster',40,'886.09975','447.96','4.5','1.8',40,43,30,21,20,20,2662,166,'156.22273','148.44287','106.67987','108.62405',253,4,0,333,0,0,0,50,145,1,1,1,1),
(22026,22026,'Bandit Captain',0,'',0,'LineageMonster.ol_mahum_champion_04te','14','27',40,'male','L2Monster',40,'966.57792','478.8','4.5','1.8',40,43,30,21,20,20,3488,224,'176.36077','156.55035','120.43155','114.55675',253,1,500,333,69,19,0,50,145,1,1,1,1),
(22027,22027,'Forgotten Crewman',0,'',0,'LineageMonster.dwarf_ghost','9','16.5',39,'male','L2Monster',40,'925.85879','4