/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.skills.SkillsEngine;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.util.logging.Logger;

public class SkillTable {
    private static Logger _log = Logger.getLogger(SkillTable.class.getName());
    private final TIntObjectHashMap<L2Skill> _skills = new TIntObjectHashMap();
    private final TIntIntHashMap _skillMaxLevel = new TIntIntHashMap();
    private final TIntArrayList _enchantable = new TIntArrayList();

    public static SkillTable getInstance() {
        return SingletonHolder._instance;
    }

    private SkillTable() {
        this.load();
    }

    public void reload() {
        this.load();
        SkillTreesData.getInstance().load();
    }

    private void load() {
        this._skills.clear();
        SkillsEngine.getInstance().loadAllSkills(this._skills);
        this._skillMaxLevel.clear();
        for (L2Skill l2Skill : (L2Skill[])this._skills.getValues((Object[])new L2Skill[this._skills.size()])) {
            int skillId = l2Skill.getId();
            int skillLvl = l2Skill.getLevel();
            if (skillLvl > 99) {
                if (this._enchantable.contains(skillId)) continue;
                this._enchantable.add(skillId);
                continue;
            }
            int maxLvl = this._skillMaxLevel.get(skillId);
            if (skillLvl <= maxLvl) continue;
            this._skillMaxLevel.put(skillId, skillLvl);
        }
        this._enchantable.sort();
        for (FrequentSkill frequentSkill : FrequentSkill.values()) {
            frequentSkill._skill = this.getInfo(frequentSkill._id, frequentSkill._level);
        }
    }

    public static int getSkillHashCode(L2Skill skill) {
        return SkillTable.getSkillHashCode(skill.getId(), skill.getLevel());
    }

    public static int getSkillHashCode(int skillId, int skillLevel) {
        return skillId * 1021 + skillLevel;
    }

    public final L2Skill getInfo(int skillId, int level) {
        L2Skill result = (L2Skill)this._skills.get(SkillTable.getSkillHashCode(skillId, level));
        if (result != null) {
            return result;
        }
        int maxLvl = this._skillMaxLevel.get(skillId);
        if (maxLvl > 0 && level > maxLvl) {
            return (L2Skill)this._skills.get(SkillTable.getSkillHashCode(skillId, maxLvl));
        }
        _log.warning("No skill info found for skill id " + skillId + " and skill level " + level + ".");
        return null;
    }

    public final int getMaxLevel(int skillId) {
        return this._skillMaxLevel.get(skillId);
    }

    public final boolean isEnchantable(int skillId) {
        return this._enchantable.binarySearch(skillId) >= 0;
    }

    public L2Skill[] getSiegeSkills(boolean addNoble, boolean hasCastle) {
        L2Skill[] temp = new L2Skill[2 + (addNoble ? 1 : 0) + (hasCastle ? 2 : 0)];
        int i = 0;
        temp[i++] = (L2Skill)this._skills.get(SkillTable.getSkillHashCode(246, 1));
        temp[i++] = (L2Skill)this._skills.get(SkillTable.getSkillHashCode(247, 1));
        if (addNoble) {
            temp[i++] = (L2Skill)this._skills.get(SkillTable.getSkillHashCode(326, 1));
        }
        if (hasCastle) {
            temp[i++] = (L2Skill)this._skills.get(SkillTable.getSkillHashCode(844, 1));
            temp[i++] = (L2Skill)this._skills.get(SkillTable.getSkillHashCode(845, 1));
        }
        return temp;
    }

    public static enum FrequentSkill {
        RAID_CURSE(4215, 1),
        RAID_CURSE2(4515, 1),
        SEAL_OF_RULER(246, 1),
        BUILD_HEADQUARTERS(247, 1),
        WYVERN_BREATH(4289, 1),
        STRIDER_SIEGE_ASSAULT(325, 1),
        FAKE_PETRIFICATION(4616, 1),
        FIREWORK(5965, 1),
        LARGE_FIREWORK(2025, 1),
        BLESSING_OF_PROTECTION(5182, 1),
        ARENA_CP_RECOVERY(4380, 1),
        VOID_BURST(3630, 1),
        VOID_FLOW(3631, 1),
        THE_VICTOR_OF_WAR(5074, 1),
        THE_VANQUISHED_OF_WAR(5075, 1),
        SPECIAL_TREE_RECOVERY_BONUS(2139, 1);

        private final int _id;
        private final int _level;
        private L2Skill _skill = null;

        private FrequentSkill(int id, int level) {
            this._id = id;
            this._level = level;
        }

        public L2Skill getSkill() {
            return this._skill;
        }
    }

    private static class SingletonHolder {
        protected static final SkillTable _instance = new SkillTable();

        private SingletonHolder() {
        }
    }
}

