/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SepulcherMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SepulcherNpcInstance;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.zone.type.L2BossZone;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import com.l2jserver.util.Util;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class FourSepulchersManager {
    protected static final Logger _log = Logger.getLogger(FourSepulchersManager.class.getName());
    private static final String QUEST_ID = "620_FourGoblets";
    private static final int ENTRANCE_PASS = 7075;
    private static final int USED_PASS = 7261;
    private static final int CHAPEL_KEY = 7260;
    private static final int ANTIQUE_BROOCH = 7262;
    protected boolean _inEntryTime = false;
    protected boolean _inWarmUpTime = false;
    protected boolean _inAttackTime = false;
    protected boolean _inCoolDownTime = false;
    protected ScheduledFuture<?> _changeCoolDownTimeTask = null;
    protected ScheduledFuture<?> _changeEntryTimeTask = null;
    protected ScheduledFuture<?> _changeWarmUpTimeTask = null;
    protected ScheduledFuture<?> _changeAttackTimeTask = null;
    protected ScheduledFuture<?> _onPartyAnnihilatedTask = null;
    private int[][] _startHallSpawn = new int[][]{{181632, -85587, -7218}, {179963, -88978, -7218}, {173217, -86132, -7218}, {175608, -82296, -7218}};
    private int[][][] _shadowSpawnLoc = new int[][][]{new int[][]{{25339, 191231, -85574, -7216, 33380}, {25349, 189534, -88969, -7216, 32768}, {25346, 173195, -76560, -7215, 49277}, {25342, 175591, -72744, -7215, 49317}}, new int[][]{{25342, 191231, -85574, -7216, 33380}, {25339, 189534, -88969, -7216, 32768}, {25349, 173195, -76560, -7215, 49277}, {25346, 175591, -72744, -7215, 49317}}, new int[][]{{25346, 191231, -85574, -7216, 33380}, {25342, 189534, -88969, -7216, 32768}, {25339, 173195, -76560, -7215, 49277}, {25349, 175591, -72744, -7215, 49317}}, new int[][]{{25349, 191231, -85574, -7216, 33380}, {25346, 189534, -88969, -7216, 32768}, {25342, 173195, -76560, -7215, 49277}, {25339, 175591, -72744, -7215, 49317}}};
    protected FastMap<Integer, Boolean> _archonSpawned = new FastMap();
    protected FastMap<Integer, Boolean> _hallInUse = new FastMap();
    protected FastMap<Integer, L2PcInstance> _challengers = new FastMap();
    protected TIntObjectHashMap<int[]> _startHallSpawns = new TIntObjectHashMap();
    protected TIntIntHashMap _hallGateKeepers = new TIntIntHashMap();
    protected TIntIntHashMap _keyBoxNpc = new TIntIntHashMap();
    protected TIntIntHashMap _victim = new TIntIntHashMap();
    protected TIntObjectHashMap<L2Spawn> _mysteriousBoxSpawns = new TIntObjectHashMap();
    protected TIntObjectHashMap<L2Spawn> _shadowSpawns = new TIntObjectHashMap();
    protected TIntObjectHashMap<FastList<L2Spawn>> _dukeFinalMobs = new TIntObjectHashMap();
    protected TIntObjectHashMap<FastList<L2SepulcherMonsterInstance>> _dukeMobs = new TIntObjectHashMap();
    protected TIntObjectHashMap<FastList<L2Spawn>> _emperorsGraveNpcs = new TIntObjectHashMap();
    protected TIntObjectHashMap<FastList<L2Spawn>> _magicalMonsters = new TIntObjectHashMap();
    protected TIntObjectHashMap<FastList<L2Spawn>> _physicalMonsters = new TIntObjectHashMap();
    protected TIntObjectHashMap<FastList<L2SepulcherMonsterInstance>> _viscountMobs = new TIntObjectHashMap();
    protected FastList<L2Spawn> _physicalSpawns;
    protected FastList<L2Spawn> _magicalSpawns;
    protected FastList<L2Spawn> _managers;
    protected FastList<L2Spawn> _dukeFinalSpawns;
    protected FastList<L2Spawn> _emperorsGraveSpawns;
    protected FastList<L2Npc> _allMobs = new FastList();
    private long _attackTimeStart;
    private static final int NEW_CYCLE_MINUTE = 55;
    private static final int OUST_PLAYER_MARGIN_TIME = 60000;

    private FourSepulchersManager() {
    }

    public static final FourSepulchersManager getInstance() {
        return SingletonHolder._instance;
    }

    public void init() {
        if (this._changeCoolDownTimeTask != null) {
            this._changeCoolDownTimeTask.cancel(true);
        }
        if (this._changeEntryTimeTask != null) {
            this._changeEntryTimeTask.cancel(true);
        }
        if (this._changeWarmUpTimeTask != null) {
            this._changeWarmUpTimeTask.cancel(true);
        }
        if (this._changeAttackTimeTask != null) {
            this._changeAttackTimeTask.cancel(true);
        }
        this._changeCoolDownTimeTask = null;
        this._changeEntryTimeTask = null;
        this._changeWarmUpTimeTask = null;
        this._changeAttackTimeTask = null;
        this._inEntryTime = false;
        this._inWarmUpTime = false;
        this._inAttackTime = false;
        this._inCoolDownTime = false;
        this.initFixedInfo();
        this.loadMysteriousBox();
        this.initKeyBoxSpawns();
        this.loadPhysicalMonsters();
        this.loadMagicalMonsters();
        this.initLocationShadowSpawns();
        this.initExecutionerSpawns();
        this.loadDukeMonsters();
        this.loadEmperorsGraveMonsters();
        this.spawnManagers();
        this._changeCoolDownTimeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ChangeCoolDownTime(), 0L);
        _log.info("FourSepulchersManager: Beginning in Cooldown time");
    }

    public void clean() {
        for (int i = 31921; i <= 31924; ++i) {
            int[] location = (int[])this._startHallSpawns.get(i);
            L2BossZone zone = GrandBossManager.getInstance().getZone(location[0], location[1], location[2]);
            if (zone != null) {
                zone.oustAllPlayers();
                continue;
            }
            if (GrandBossManager.getInstance().getZones().size() <= 0) continue;
            throw new RuntimeException();
        }
        this.deleteAllMobs();
        this.closeAllDoors();
        this._hallInUse.clear();
        this._hallInUse.put((Object)31921, (Object)false);
        this._hallInUse.put((Object)31922, (Object)false);
        this._hallInUse.put((Object)31923, (Object)false);
        this._hallInUse.put((Object)31924, (Object)false);
        if (this._archonSpawned.size() != 0) {
            Set npcIdSet = this._archonSpawned.keySet();
            Iterator i$ = npcIdSet.iterator();
            while (i$.hasNext()) {
                int npcId = (Integer)i$.next();
                this._archonSpawned.put((Object)npcId, (Object)false);
            }
        }
    }

    protected void spawnManagers() {
        this._managers = new FastList();
        for (int i = 31921; i <= 31924; ++i) {
            L2Spawn spawnDat = SpawnTable.getInstance().getSpawnOne(i);
            this._managers.add((Object)spawnDat);
            _log.info("FourSepulchersManager: spawned " + spawnDat.getTemplate().getName());
        }
    }

    protected void initFixedInfo() {
        this._startHallSpawns.put(31921, (Object)this._startHallSpawn[0]);
        this._startHallSpawns.put(31922, (Object)this._startHallSpawn[1]);
        this._startHallSpawns.put(31923, (Object)this._startHallSpawn[2]);
        this._startHallSpawns.put(31924, (Object)this._startHallSpawn[3]);
        this._hallInUse.put((Object)31921, (Object)false);
        this._hallInUse.put((Object)31922, (Object)false);
        this._hallInUse.put((Object)31923, (Object)false);
        this._hallInUse.put((Object)31924, (Object)false);
        this._hallGateKeepers.put(31925, 25150012);
        this._hallGateKeepers.put(31926, 25150013);
        this._hallGateKeepers.put(31927, 25150014);
        this._hallGateKeepers.put(31928, 25150015);
        this._hallGateKeepers.put(31929, 25150016);
        this._hallGateKeepers.put(31930, 25150002);
        this._hallGateKeepers.put(31931, 25150003);
        this._hallGateKeepers.put(31932, 25150004);
        this._hallGateKeepers.put(31933, 25150005);
        this._hallGateKeepers.put(31934, 25150006);
        this._hallGateKeepers.put(31935, 25150032);
        this._hallGateKeepers.put(31936, 25150033);
        this._hallGateKeepers.put(31937, 25150034);
        this._hallGateKeepers.put(31938, 25150035);
        this._hallGateKeepers.put(31939, 25150036);
        this._hallGateKeepers.put(31940, 25150022);
        this._hallGateKeepers.put(31941, 25150023);
        this._hallGateKeepers.put(31942, 25150024);
        this._hallGateKeepers.put(31943, 25150025);
        this._hallGateKeepers.put(31944, 25150026);
        this._keyBoxNpc.put(18120, 31455);
        this._keyBoxNpc.put(18121, 31455);
        this._keyBoxNpc.put(18122, 31455);
        this._keyBoxNpc.put(18123, 31455);
        this._keyBoxNpc.put(18124, 31456);
        this._keyBoxNpc.put(18125, 31456);
        this._keyBoxNpc.put(18126, 31456);
        this._keyBoxNpc.put(18127, 31456);
        this._keyBoxNpc.put(18128, 31457);
        this._keyBoxNpc.put(18129, 31457);
        this._keyBoxNpc.put(18130, 31457);
        this._keyBoxNpc.put(18131, 31457);
        this._keyBoxNpc.put(18149, 31458);
        this._keyBoxNpc.put(18150, 31459);
        this._keyBoxNpc.put(18151, 31459);
        this._keyBoxNpc.put(18152, 31459);
        this._keyBoxNpc.put(18153, 31459);
        this._keyBoxNpc.put(18154, 31460);
        this._keyBoxNpc.put(18155, 31460);
        this._keyBoxNpc.put(18156, 31460);
        this._keyBoxNpc.put(18157, 31460);
        this._keyBoxNpc.put(18158, 31461);
        this._keyBoxNpc.put(18159, 31461);
        this._keyBoxNpc.put(18160, 31461);
        this._keyBoxNpc.put(18161, 31461);
        this._keyBoxNpc.put(18162, 31462);
        this._keyBoxNpc.put(18163, 31462);
        this._keyBoxNpc.put(18164, 31462);
        this._keyBoxNpc.put(18165, 31462);
        this._keyBoxNpc.put(18183, 31463);
        this._keyBoxNpc.put(18184, 31464);
        this._keyBoxNpc.put(18212, 31465);
        this._keyBoxNpc.put(18213, 31465);
        this._keyBoxNpc.put(18214, 31465);
        this._keyBoxNpc.put(18215, 31465);
        this._keyBoxNpc.put(18216, 31466);
        this._keyBoxNpc.put(18217, 31466);
        this._keyBoxNpc.put(18218, 31466);
        this._keyBoxNpc.put(18219, 31466);
        this._victim.put(18150, 18158);
        this._victim.put(18151, 18159);
        this._victim.put(18152, 18160);
        this._victim.put(18153, 18161);
        this._victim.put(18154, 18162);
        this._victim.put(18155, 18163);
        this._victim.put(18156, 18164);
        this._victim.put(18157, 18165);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMysteriousBox() {
        Connection con = null;
        this._mysteriousBoxSpawns.clear();
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY id");
            statement.setInt(1, 0);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rset.getInt("npc_templateid"));
                if (template1 != null) {
                    L2Spawn spawnDat = new L2Spawn(template1);
                    spawnDat.setAmount(rset.getInt("count"));
                    spawnDat.setLocx(rset.getInt("locx"));
                    spawnDat.setLocy(rset.getInt("locy"));
                    spawnDat.setLocz(rset.getInt("locz"));
                    spawnDat.setHeading(rset.getInt("heading"));
                    spawnDat.setRespawnDelay(rset.getInt("respawn_delay"));
                    int keyNpcId = rset.getInt("key_npc_id");
                    this._mysteriousBoxSpawns.put(keyNpcId, (Object)spawnDat);
                    continue;
                }
                _log.warning("FourSepulchersManager.LoadMysteriousBox: Data missing in NPC table for ID: " + rset.getInt("npc_templateid") + ".");
            }
            rset.close();
            statement.close();
            _log.info("FourSepulchersManager: loaded " + this._mysteriousBoxSpawns.size() + " Mysterious-Box spawns.");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "FourSepulchersManager.LoadMysteriousBox: Spawn could not be initialized: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    private void initKeyBoxSpawns() {
        for (int keyNpcId : this._keyBoxNpc.keys()) {
            int spawnNpcId = this._keyBoxNpc.get(keyNpcId);
            try {
                L2NpcTemplate template = NpcTable.getInstance().getTemplate(spawnNpcId);
                if (template == null) {
                    throw new AssertionError();
                }
                new L2Spawn(template);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "FourSepulchersManager.InitKeyBoxSpawns: Spawn could not be initialized: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPhysicalMonsters() {
        this._physicalMonsters.clear();
        int loaded = 0;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement1 = con.prepareStatement("SELECT Distinct key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY key_npc_id");
            statement1.setInt(1, 1);
            ResultSet rset1 = statement1.executeQuery();
            PreparedStatement statement2 = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist Where key_npc_id = ? and spawntype = ? ORDER BY id");
            while (rset1.next()) {
                int keyNpcId = rset1.getInt("key_npc_id");
                statement2.setInt(1, keyNpcId);
                statement2.setInt(2, 1);
                ResultSet rset2 = statement2.executeQuery();
                statement2.clearParameters();
                this._physicalSpawns = new FastList();
                while (rset2.next()) {
                    L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rset2.getInt("npc_templateid"));
                    if (template1 != null) {
                        L2Spawn spawnDat = new L2Spawn(template1);
                        spawnDat.setAmount(rset2.getInt("count"));
                        spawnDat.setLocx(rset2.getInt("locx"));
                        spawnDat.setLocy(rset2.getInt("locy"));
                        spawnDat.setLocz(rset2.getInt("locz"));
                        spawnDat.setHeading(rset2.getInt("heading"));
                        spawnDat.setRespawnDelay(rset2.getInt("respawn_delay"));
                        this._physicalSpawns.add((Object)spawnDat);
                        ++loaded;
                        continue;
                    }
                    _log.warning("FourSepulchersManager.LoadPhysicalMonsters: Data missing in NPC table for ID: " + rset2.getInt("npc_templateid") + ".");
                }
                rset2.close();
                this._physicalMonsters.put(keyNpcId, this._physicalSpawns);
            }
            rset1.close();
            statement1.close();
            statement2.close();
            _log.info("FourSepulchersManager: loaded " + loaded + " Physical type monsters spawns.");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "FourSepulchersManager.LoadPhysicalMonsters: Spawn could not be initialized: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMagicalMonsters() {
        this._magicalMonsters.clear();
        int loaded = 0;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement1 = con.prepareStatement("SELECT Distinct key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY key_npc_id");
            statement1.setInt(1, 2);
            ResultSet rset1 = statement1.executeQuery();
            PreparedStatement statement2 = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist WHERE key_npc_id = ? AND spawntype = ? ORDER BY id");
            while (rset1.next()) {
                int keyNpcId = rset1.getInt("key_npc_id");
                statement2.setInt(1, keyNpcId);
                statement2.setInt(2, 2);
                ResultSet rset2 = statement2.executeQuery();
                statement2.clearParameters();
                this._magicalSpawns = new FastList();
                while (rset2.next()) {
                    L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rset2.getInt("npc_templateid"));
                    if (template1 != null) {
                        L2Spawn spawnDat = new L2Spawn(template1);
                        spawnDat.setAmount(rset2.getInt("count"));
                        spawnDat.setLocx(rset2.getInt("locx"));
                        spawnDat.setLocy(rset2.getInt("locy"));
                        spawnDat.setLocz(rset2.getInt("locz"));
                        spawnDat.setHeading(rset2.getInt("heading"));
                        spawnDat.setRespawnDelay(rset2.getInt("respawn_delay"));
                        this._magicalSpawns.add((Object)spawnDat);
                        ++loaded;
                        continue;
                    }
                    _log.warning("FourSepulchersManager.LoadMagicalMonsters: Data missing in NPC table for ID: " + rset2.getInt("npc_templateid") + ".");
                }
                rset2.close();
                this._magicalMonsters.put(keyNpcId, this._magicalSpawns);
            }
            rset1.close();
            statement1.close();
            statement2.close();
            _log.info("FourSepulchersManager: loaded " + loaded + " Magical type monsters spawns.");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "FourSepulchersManager.LoadMagicalMonsters: Spawn could not be initialized: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDukeMonsters() {
        this._dukeFinalMobs.clear();
        this._archonSpawned.clear();
        int loaded = 0;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement1 = con.prepareStatement("SELECT Distinct key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY key_npc_id");
            statement1.setInt(1, 5);
            ResultSet rset1 = statement1.executeQuery();
            PreparedStatement statement2 = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist WHERE key_npc_id = ? AND spawntype = ? ORDER BY id");
            while (rset1.next()) {
                int keyNpcId = rset1.getInt("key_npc_id");
                statement2.setInt(1, keyNpcId);
                statement2.setInt(2, 5);
                ResultSet rset2 = statement2.executeQuery();
                statement2.clearParameters();
                this._dukeFinalSpawns = new FastList();
                while (rset2.next()) {
                    L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rset2.getInt("npc_templateid"));
                    if (template1 != null) {
                        L2Spawn spawnDat = new L2Spawn(template1);
                        spawnDat.setAmount(rset2.getInt("count"));
                        spawnDat.setLocx(rset2.getInt("locx"));
                        spawnDat.setLocy(rset2.getInt("locy"));
                        spawnDat.setLocz(rset2.getInt("locz"));
                        spawnDat.setHeading(rset2.getInt("heading"));
                        spawnDat.setRespawnDelay(rset2.getInt("respawn_delay"));
                        this._dukeFinalSpawns.add((Object)spawnDat);
                        ++loaded;
                        continue;
                    }
                    _log.warning("FourSepulchersManager.LoadDukeMonsters: Data missing in NPC table for ID: " + rset2.getInt("npc_templateid") + ".");
                }
                rset2.close();
                this._dukeFinalMobs.put(keyNpcId, this._dukeFinalSpawns);
                this._archonSpawned.put((Object)keyNpcId, (Object)false);
            }
            rset1.close();
            statement1.close();
            statement2.close();
            _log.info("FourSepulchersManager: loaded " + loaded + " Church of duke monsters spawns.");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "FourSepulchersManager.LoadDukeMonsters: Spawn could not be initialized: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadEmperorsGraveMonsters() {
        this._emperorsGraveNpcs.clear();
        int loaded = 0;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement1 = con.prepareStatement("SELECT Distinct key_npc_id FROM four_sepulchers_spawnlist Where spawntype = ? ORDER BY key_npc_id");
            statement1.setInt(1, 6);
            ResultSet rset1 = statement1.executeQuery();
            PreparedStatement statement2 = con.prepareStatement("SELECT id, count, npc_templateid, locx, locy, locz, heading, respawn_delay, key_npc_id FROM four_sepulchers_spawnlist WHERE key_npc_id = ? and spawntype = ? ORDER BY id");
            while (rset1.next()) {
                int keyNpcId = rset1.getInt("key_npc_id");
                statement2.setInt(1, keyNpcId);
                statement2.setInt(2, 6);
                ResultSet rset2 = statement2.executeQuery();
                statement2.clearParameters();
                this._emperorsGraveSpawns = new FastList();
                while (rset2.next()) {
                    L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rset2.getInt("npc_templateid"));
                    if (template1 != null) {
                        L2Spawn spawnDat = new L2Spawn(template1);
                        spawnDat.setAmount(rset2.getInt("count"));
                        spawnDat.setLocx(rset2.getInt("locx"));
                        spawnDat.setLocy(rset2.getInt("locy"));
                        spawnDat.setLocz(rset2.getInt("locz"));
                        spawnDat.setHeading(rset2.getInt("heading"));
                        spawnDat.setRespawnDelay(rset2.getInt("respawn_delay"));
                        this._emperorsGraveSpawns.add((Object)spawnDat);
                        ++loaded;
                        continue;
                    }
                    _log.warning("FourSepulchersManager.LoadEmperorsGraveMonsters: Data missing in NPC table for ID: " + rset2.getInt("npc_templateid") + ".");
                }
                rset2.close();
                this._emperorsGraveNpcs.put(keyNpcId, this._emperorsGraveSpawns);
            }
            rset1.close();
            statement1.close();
            statement2.close();
            _log.info("FourSepulchersManager: loaded " + loaded + " Emperor's grave NPC spawns.");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "FourSepulchersManager.LoadEmperorsGraveMonsters: Spawn could not be initialized: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    protected void initLocationShadowSpawns() {
        int locNo = Rnd.get(4);
        int[] gateKeeper = new int[]{31929, 31934, 31939, 31944};
        this._shadowSpawns.clear();
        for (int i = 0; i <= 3; ++i) {
            int[] loc = this._shadowSpawnLoc[locNo][i];
            L2NpcTemplate template = NpcTable.getInstance().getTemplate(loc[0]);
            if (template != null) {
                try {
                    L2Spawn spawnDat = new L2Spawn(template);
                    spawnDat.setAmount(1);
                    spawnDat.setXYZ(loc[1], loc[2], loc[3]);
                    spawnDat.setHeading(loc[4]);
                    int keyNpcId = gateKeeper[i];
                    this._shadowSpawns.put(keyNpcId, (Object)spawnDat);
                }
                catch (Exception e) {
                    _log.log(Level.SEVERE, "Error on InitLocationShadowSpawns", e);
                }
                continue;
            }
            _log.warning("FourSepulchersManager.InitLocationShadowSpawns: Data missing in NPC table for ID: " + loc[0] + ".");
        }
    }

    protected void initExecutionerSpawns() {
        for (int keyNpcId : this._victim.keys()) {
            int spawnNpcId = this._victim.get(keyNpcId);
            try {
                L2NpcTemplate template = NpcTable.getInstance().getTemplate(spawnNpcId);
                if (template == null) {
                    throw new AssertionError();
                }
                new L2Spawn(template);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "FourSepulchersManager.InitExecutionerSpawns: Spawn could not be initialized: " + e.getMessage(), e);
            }
        }
    }

    public boolean isEntryTime() {
        return this._inEntryTime;
    }

    public boolean isAttackTime() {
        return this._inAttackTime;
    }

    public synchronized void tryEntry(L2Npc npc, L2PcInstance player) {
        int npcId = npc.getNpcId();
        switch (npcId) {
            case 31921: 
            case 31922: 
            case 31923: 
            case 31924: {
                break;
            }
            default: {
                if (!player.isGM()) {
                    _log.warning("Player " + player.getName() + "(" + player.getObjectId() + ") tried to cheat in four sepulchers.");
                    com.l2jserver.gameserver.util.Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " tried to enter four sepulchers with invalid npc id.", Config.DEFAULT_PUNISH);
                }
                return;
            }
        }
        if (((Boolean)this._hallInUse.get((Object)npcId)).booleanValue()) {
            this.showHtmlFile(player, npcId + "-FULL.htm", npc, null);
            return;
        }
        if (Config.FS_PARTY_MEMBER_COUNT > 1) {
            if (!player.isInParty() || player.getParty().getMemberCount() < Config.FS_PARTY_MEMBER_COUNT) {
                this.showHtmlFile(player, npcId + "-SP.htm", npc, null);
                return;
            }
            if (!player.getParty().isLeader(player)) {
                this.showHtmlFile(player, npcId + "-NL.htm", npc, null);
                return;
            }
            for (L2PcInstance mem : player.getParty().getPartyMembers()) {
                QuestState qs = mem.getQuestState(QUEST_ID);
                if (qs == null || !qs.isStarted() && !qs.isCompleted()) {
                    this.showHtmlFile(player, npcId + "-NS.htm", npc, mem);
                    return;
                }
                if (mem.getInventory().getItemByItemId(7075) == null) {
                    this.showHtmlFile(player, npcId + "-SE.htm", npc, mem);
                    return;
                }
                if (player.getWeightPenalty() < 3) continue;
                mem.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.INVENTORY_LESS_THAN_80_PERCENT));
                return;
            }
        } else if (Config.FS_PARTY_MEMBER_COUNT <= 1 && player.isInParty()) {
            if (!player.getParty().isLeader(player)) {
                this.showHtmlFile(player, npcId + "-NL.htm", npc, null);
                return;
            }
            for (L2PcInstance mem : player.getParty().getPartyMembers()) {
                QuestState qs = mem.getQuestState(QUEST_ID);
                if (qs == null || !qs.isStarted() && !qs.isCompleted()) {
                    this.showHtmlFile(player, npcId + "-NS.htm", npc, mem);
                    return;
                }
                if (mem.getInventory().getItemByItemId(7075) == null) {
                    this.showHtmlFile(player, npcId + "-SE.htm", npc, mem);
                    return;
                }
                if (player.getWeightPenalty() < 3) continue;
                mem.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.INVENTORY_LESS_THAN_80_PERCENT));
                return;
            }
        } else {
            QuestState qs = player.getQuestState(QUEST_ID);
            if (qs == null || !qs.isStarted() && !qs.isCompleted()) {
                this.showHtmlFile(player, npcId + "-NS.htm", npc, player);
                return;
            }
            if (player.getInventory().getItemByItemId(7075) == null) {
                this.showHtmlFile(player, npcId + "-SE.htm", npc, player);
                return;
            }
            if (player.getWeightPenalty() >= 3) {
                player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.INVENTORY_LESS_THAN_80_PERCENT));
                return;
            }
        }
        if (!this.isEntryTime()) {
            this.showHtmlFile(player, npcId + "-NE.htm", npc, null);
            return;
        }
        this.showHtmlFile(player, npcId + "-OK.htm", npc, null);
        this.entry(npcId, player);
    }

    private void entry(int npcId, L2PcInstance player) {
        L2ItemInstance hallsKey;
        int drifty;
        int driftx;
        FastList members;
        int[] Location2 = (int[])this._startHallSpawns.get(npcId);
        if (Config.FS_PARTY_MEMBER_COUNT > 1) {
            members = new FastList();
            for (L2PcInstance mem : player.getParty().getPartyMembers()) {
                if (mem.isDead() || !com.l2jserver.gameserver.util.Util.checkIfInRange(700, player, mem, true)) continue;
                members.add(mem);
            }
            for (L2PcInstance mem : members) {
                GrandBossManager.getInstance().getZone(Location2[0], Location2[1], Location2[2]).allowPlayerEntry(mem, 30);
                driftx = Rnd.get(-80, 80);
                drifty = Rnd.get(-80, 80);
                mem.teleToLocation(Location2[0] + driftx, Location2[1] + drifty, Location2[2]);
                mem.destroyItemByItemId("Quest", 7075, 1L, mem, true);
                if (mem.getInventory().getItemByItemId(7262) == null) {
                    mem.addItem("Quest", 7261, 1L, mem, true);
                }
                if ((hallsKey = mem.getInventory().getItemByItemId(7260)) == null) continue;
                mem.destroyItemByItemId("Quest", 7260, hallsKey.getCount(), mem, true);
            }
            this._challengers.remove((Object)npcId);
            this._challengers.put((Object)npcId, (Object)player);
            this._hallInUse.remove((Object)npcId);
            this._hallInUse.put((Object)npcId, (Object)true);
        }
        if (Config.FS_PARTY_MEMBER_COUNT <= 1 && player.isInParty()) {
            members = new FastList();
            for (L2PcInstance mem : player.getParty().getPartyMembers()) {
                if (mem.isDead() || !com.l2jserver.gameserver.util.Util.checkIfInRange(700, player, mem, true)) continue;
                members.add(mem);
            }
            for (L2PcInstance mem : members) {
                GrandBossManager.getInstance().getZone(Location2[0], Location2[1], Location2[2]).allowPlayerEntry(mem, 30);
                driftx = Rnd.get(-80, 80);
                drifty = Rnd.get(-80, 80);
                mem.teleToLocation(Location2[0] + driftx, Location2[1] + drifty, Location2[2]);
                mem.destroyItemByItemId("Quest", 7075, 1L, mem, true);
                if (mem.getInventory().getItemByItemId(7262) == null) {
                    mem.addItem("Quest", 7261, 1L, mem, true);
                }
                if ((hallsKey = mem.getInventory().getItemByItemId(7260)) == null) continue;
                mem.destroyItemByItemId("Quest", 7260, hallsKey.getCount(), mem, true);
            }
            this._challengers.remove((Object)npcId);
            this._challengers.put((Object)npcId, (Object)player);
            this._hallInUse.remove((Object)npcId);
            this._hallInUse.put((Object)npcId, (Object)true);
        } else {
            L2ItemInstance hallsKey2;
            GrandBossManager.getInstance().getZone(Location2[0], Location2[1], Location2[2]).allowPlayerEntry(player, 30);
            driftx = Rnd.get(-80, 80);
            drifty = Rnd.get(-80, 80);
            player.teleToLocation(Location2[0] + driftx, Location2[1] + drifty, Location2[2]);
            player.destroyItemByItemId("Quest", 7075, 1L, player, true);
            if (player.getInventory().getItemByItemId(7262) == null) {
                player.addItem("Quest", 7261, 1L, player, true);
            }
            if ((hallsKey2 = player.getInventory().getItemByItemId(7260)) != null) {
                player.destroyItemByItemId("Quest", 7260, hallsKey2.getCount(), player, true);
            }
            this._challengers.remove((Object)npcId);
            this._challengers.put((Object)npcId, (Object)player);
            this._hallInUse.remove((Object)npcId);
            this._hallInUse.put((Object)npcId, (Object)true);
        }
    }

    public void spawnMysteriousBox(int npcId) {
        if (!this.isAttackTime()) {
            return;
        }
        L2Spawn spawnDat = (L2Spawn)this._mysteriousBoxSpawns.get(npcId);
        if (spawnDat != null) {
            this._allMobs.add((Object)spawnDat.doSpawn());
            spawnDat.stopRespawn();
        }
    }

    public void spawnMonster(int npcId) {
        if (!this.isAttackTime()) {
            return;
        }
        FastList mobs = new FastList();
        FastList monsterList = Rnd.get(2) == 0 ? (FastList)this._physicalMonsters.get(npcId) : (FastList)this._magicalMonsters.get(npcId);
        if (monsterList != null) {
            boolean spawnKeyBoxMob = false;
            boolean spawnedKeyBoxMob = false;
            for (L2Spawn spawnDat : monsterList) {
                if (spawnedKeyBoxMob) {
                    spawnKeyBoxMob = false;
                } else {
                    switch (npcId) {
                        case 31469: 
                        case 31474: 
                        case 31479: 
                        case 31484: {
                            if (Rnd.get(48) != 0) break;
                            spawnKeyBoxMob = true;
                            break;
                        }
                        default: {
                            spawnKeyBoxMob = false;
                        }
                    }
                }
                L2SepulcherMonsterInstance mob = null;
                if (spawnKeyBoxMob) {
                    try {
                        L2NpcTemplate template = NpcTable.getInstance().getTemplate(18149);
                        if (template != null) {
                            L2Spawn keyBoxMobSpawn = new L2Spawn(template);
                            keyBoxMobSpawn.setAmount(1);
                            keyBoxMobSpawn.setLocx(spawnDat.getLocx());
                            keyBoxMobSpawn.setLocy(spawnDat.getLocy());
                            keyBoxMobSpawn.setLocz(spawnDat.getLocz());
                            keyBoxMobSpawn.setHeading(spawnDat.getHeading());
                            keyBoxMobSpawn.setRespawnDelay(3600);
                            mob = (L2SepulcherMonsterInstance)keyBoxMobSpawn.doSpawn();
                            keyBoxMobSpawn.stopRespawn();
                        } else {
                            _log.warning("FourSepulchersManager.SpawnMonster: Data missing in NPC table for ID: 18149");
                        }
                    }
                    catch (Exception e) {
                        _log.log(Level.WARNING, "FourSepulchersManager.SpawnMonster: Spawn could not be initialized: " + e.getMessage(), e);
                    }
                    spawnedKeyBoxMob = true;
                } else {
                    mob = (L2SepulcherMonsterInstance)spawnDat.doSpawn();
                    spawnDat.stopRespawn();
                }
                if (mob == null) continue;
                mob.mysteriousBoxId = npcId;
                switch (npcId) {
                    case 31469: 
                    case 31472: 
                    case 31474: 
                    case 31477: 
                    case 31479: 
                    case 31482: 
                    case 31484: 
                    case 31487: {
                        mobs.add((Object)mob);
                    }
                }
                this._allMobs.add((Object)mob);
            }
            switch (npcId) {
                case 31469: 
                case 31474: 
                case 31479: 
                case 31484: {
                    this._viscountMobs.put(npcId, (Object)mobs);
                    break;
                }
                case 31472: 
                case 31477: 
                case 31482: 
                case 31487: {
                    this._dukeMobs.put(npcId, (Object)mobs);
                }
            }
        }
    }

    public synchronized boolean isViscountMobsAnnihilated(int npcId) {
        FastList mobs = (FastList)this._viscountMobs.get(npcId);
        if (mobs == null) {
            return true;
        }
        for (L2SepulcherMonsterInstance mob : mobs) {
            if (mob.isDead()) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean isDukeMobsAnnihilated(int npcId) {
        FastList mobs = (FastList)this._dukeMobs.get(npcId);
        if (mobs == null) {
            return true;
        }
        for (L2SepulcherMonsterInstance mob : mobs) {
            if (mob.isDead()) continue;
            return false;
        }
        return true;
    }

    public void spawnKeyBox(L2Npc activeChar) {
        if (!this.isAttackTime()) {
            return;
        }
        int keyNpcId = activeChar.getNpcId();
        int spawnNpcId = this._keyBoxNpc.get(keyNpcId);
        try {
            L2NpcTemplate template = NpcTable.getInstance().getTemplate(spawnNpcId);
            if (template == null) {
                throw new AssertionError();
            }
            L2Spawn spawnDat = new L2Spawn(template);
            spawnDat.setAmount(1);
            spawnDat.setXYZ(activeChar.getX(), activeChar.getY(), activeChar.getZ());
            spawnDat.setHeading(activeChar.getHeading());
            spawnDat.setRespawnDelay(3600);
            this._allMobs.add((Object)spawnDat.doSpawn());
            spawnDat.stopRespawn();
        }
        catch (Exception e) {
            _log.warning("FourSepulchersManager.spawnKeyBox(" + keyNpcId + "): Data missing in NPC table for ID: " + spawnNpcId + ".");
        }
    }

    public void spawnExecutionerOfHalisha(L2Npc activeChar) {
        if (!this.isAttackTime()) {
            return;
        }
        int keyNpcId = activeChar.getNpcId();
        int spawnNpcId = this._victim.get(keyNpcId);
        try {
            L2NpcTemplate template = NpcTable.getInstance().getTemplate(spawnNpcId);
            if (template == null) {
                throw new AssertionError();
            }
            L2Spawn spawnDat = new L2Spawn(template);
            spawnDat.setAmount(1);
            spawnDat.setXYZ(activeChar.getX(), activeChar.getY(), activeChar.getZ());
            spawnDat.setHeading(activeChar.getHeading());
            spawnDat.setRespawnDelay(3600);
            this._allMobs.add((Object)spawnDat.doSpawn());
            spawnDat.stopRespawn();
        }
        catch (Exception e) {
            _log.warning("FourSepulchersManager.spawnExecutionerOfHalisha(" + keyNpcId + "): Data missing in NPC table for ID: " + spawnNpcId + ".");
        }
    }

    public void spawnArchonOfHalisha(int npcId) {
        if (!this.isAttackTime()) {
            return;
        }
        if (((Boolean)this._archonSpawned.get((Object)npcId)).booleanValue()) {
            return;
        }
        FastList monsterList = (FastList)this._dukeFinalMobs.get(npcId);
        if (monsterList != null) {
            for (L2Spawn spawnDat : monsterList) {
                L2SepulcherMonsterInstance mob = (L2SepulcherMonsterInstance)spawnDat.doSpawn();
                spawnDat.stopRespawn();
                if (mob == null) continue;
                mob.mysteriousBoxId = npcId;
                this._allMobs.add((Object)mob);
            }
            this._archonSpawned.put((Object)npcId, (Object)true);
        }
    }

    public void spawnEmperorsGraveNpc(int npcId) {
        if (!this.isAttackTime()) {
            return;
        }
        FastList monsterList = (FastList)this._emperorsGraveNpcs.get(npcId);
        if (monsterList != null) {
            for (L2Spawn spawnDat : monsterList) {
                this._allMobs.add((Object)spawnDat.doSpawn());
                spawnDat.stopRespawn();
            }
        }
    }

    protected void locationShadowSpawns() {
        int locNo = Rnd.get(4);
        int[] gateKeeper = new int[]{31929, 31934, 31939, 31944};
        for (int i = 0; i <= 3; ++i) {
            int keyNpcId = gateKeeper[i];
            int[] loc = this._shadowSpawnLoc[locNo][i];
            L2Spawn spawnDat = (L2Spawn)this._shadowSpawns.get(keyNpcId);
            spawnDat.setXYZ(loc[1], loc[2], loc[3]);
            spawnDat.setHeading(loc[4]);
            this._shadowSpawns.put(keyNpcId, (Object)spawnDat);
        }
    }

    public void spawnShadow(int npcId) {
        if (!this.isAttackTime()) {
            return;
        }
        L2Spawn spawnDat = (L2Spawn)this._shadowSpawns.get(npcId);
        if (spawnDat != null) {
            L2SepulcherMonsterInstance mob = (L2SepulcherMonsterInstance)spawnDat.doSpawn();
            spawnDat.stopRespawn();
            if (mob != null) {
                mob.mysteriousBoxId = npcId;
                this._allMobs.add((Object)mob);
            }
        }
    }

    public void deleteAllMobs() {
        for (L2Npc mob : this._allMobs) {
            if (mob == null) continue;
            try {
                if (mob.getSpawn() != null) {
                    mob.getSpawn().stopRespawn();
                }
                mob.deleteMe();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "FourSepulchersManager: Failed deleting mob.", e);
            }
        }
        this._allMobs.clear();
    }

    protected void closeAllDoors() {
        for (int doorId : this._hallGateKeepers.getValues()) {
            try {
                L2DoorInstance door = DoorTable.getInstance().getDoor(doorId);
                if (door != null) {
                    door.closeMe();
                    continue;
                }
                _log.warning("FourSepulchersManager: Attempted to close undefined door. doorId: " + doorId);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "FourSepulchersManager: Failed closing door", e);
            }
        }
    }

    public void managerSay(int min) {
        block8: {
            block7: {
                if (!this._inAttackTime) break block7;
                if (min < 5) {
                    return;
                }
                String msg = (min = (min + 2) / 5 * 5) >= Config.FS_TIME_ATTACK ? "\u30b2\u30fc\u30e0\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002\u9593\u3082\u306a\u304f\u81ea\u52d5\u30c6\u30ec\u30dd\u30fc\u30c8\u3057\u307e\u3059\u3002" : "\u73fe\u5728" + min + "\u5206\u304c\u7d4c\u904e\u3057\u307e\u3057\u305f";
                for (L2Spawn temp : this._managers) {
                    if (temp == null) {
                        _log.warning("FourSepulchersManager: managerSay(): manager is null");
                        continue;
                    }
                    if (!(temp.getLastSpawn() instanceof L2SepulcherNpcInstance)) {
                        _log.warning("FourSepulchersManager: managerSay(): manager is not Sepulcher instance");
                        continue;
                    }
                    if (!((Boolean)this._hallInUse.get((Object)temp.getNpcid())).booleanValue()) continue;
                    ((L2SepulcherNpcInstance)temp.getLastSpawn()).sayInShout(msg);
                }
                break block8;
            }
            if (!this._inEntryTime) break block8;
            NpcStringId msg1 = NpcStringId.YOU_MAY_NOW_ENTER_THE_SEPULCHER;
            NpcStringId msg2 = NpcStringId.IF_YOU_PLACE_YOUR_HAND_ON_THE_STONE_STATUE_IN_FRONT_OF_EACH_SEPULCHER_YOU_WILL_BE_ABLE_TO_ENTER;
            for (L2Spawn temp : this._managers) {
                if (temp == null) {
                    _log.warning("FourSepulchersManager: Something goes wrong in managerSay()...");
                    continue;
                }
                if (!(temp.getLastSpawn() instanceof L2SepulcherNpcInstance)) {
                    _log.warning("FourSepulchersManager: Something goes wrong in managerSay()...");
                    continue;
                }
                ((L2SepulcherNpcInstance)temp.getLastSpawn()).sayInShout(msg1);
                ((L2SepulcherNpcInstance)temp.getLastSpawn()).sayInShout(msg2);
            }
        }
    }

    public TIntIntHashMap getHallGateKeepers() {
        return this._hallGateKeepers;
    }

    public void showHtmlFile(L2PcInstance player, String file, L2Npc npc, L2PcInstance member) {
        NpcHtmlMessage html = new NpcHtmlMessage(npc.getObjectId());
        html.setFile(player.getHtmlPrefix(), "data/html/SepulcherNpc/" + file);
        if (member != null) {
            html.replace((CharSequence)"%member%", member.getName());
        }
        player.sendPacket(html);
    }

    private static class SingletonHolder {
        protected static final FourSepulchersManager _instance = new FourSepulchersManager();

        private SingletonHolder() {
        }
    }

    protected class ChangeCoolDownTime
    implements Runnable {
        protected ChangeCoolDownTime() {
        }

        @Override
        public void run() {
            FourSepulchersManager.this._inEntryTime = false;
            FourSepulchersManager.this._inWarmUpTime = false;
            FourSepulchersManager.this._inAttackTime = false;
            FourSepulchersManager.this._inCoolDownTime = true;
            FourSepulchersManager.this.clean();
            Calendar time = Calendar.getInstance();
            if (Calendar.getInstance().get(12) > 55) {
                time.set(10, Calendar.getInstance().get(10) + 1);
            }
            time.set(12, 55);
            time.set(13, 0);
            time.set(14, 0);
            _log.info("FourSepulchersManager: Entry time: " + Util.dateFormat(time));
            long interval = time.getTimeInMillis() - Calendar.getInstance().getTimeInMillis();
            FourSepulchersManager.this._changeEntryTimeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ChangeEntryTime(), interval);
            if (FourSepulchersManager.this._changeCoolDownTimeTask != null) {
                FourSepulchersManager.this._changeCoolDownTimeTask.cancel(true);
                FourSepulchersManager.this._changeCoolDownTimeTask = null;
            }
        }
    }

    protected class ChangeAttackTime
    implements Runnable {
        protected ChangeAttackTime() {
        }

        @Override
        public void run() {
            FourSepulchersManager.this._inEntryTime = false;
            FourSepulchersManager.this._inWarmUpTime = false;
            FourSepulchersManager.this._inAttackTime = true;
            FourSepulchersManager.this._inCoolDownTime = false;
            FourSepulchersManager.this.locationShadowSpawns();
            FourSepulchersManager.this.spawnMysteriousBox(31921);
            FourSepulchersManager.this.spawnMysteriousBox(31922);
            FourSepulchersManager.this.spawnMysteriousBox(31923);
            FourSepulchersManager.this.spawnMysteriousBox(31924);
            FourSepulchersManager.this._attackTimeStart = Calendar.getInstance().getTimeInMillis();
            ThreadPoolManager.getInstance().scheduleGeneral(new ManagerSay(), 302000L);
            long interval = (long)Config.FS_TIME_ATTACK * 60000L;
            FourSepulchersManager.this._changeCoolDownTimeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ChangeCoolDownTime(), interval + 60000L);
            if (FourSepulchersManager.this._changeAttackTimeTask != null) {
                FourSepulchersManager.this._changeAttackTimeTask.cancel(true);
                FourSepulchersManager.this._changeAttackTimeTask = null;
            }
        }
    }

    protected class ChangeWarmUpTime
    implements Runnable {
        protected ChangeWarmUpTime() {
        }

        @Override
        public void run() {
            FourSepulchersManager.this._inEntryTime = true;
            FourSepulchersManager.this._inWarmUpTime = false;
            FourSepulchersManager.this._inAttackTime = false;
            FourSepulchersManager.this._inCoolDownTime = false;
            long interval = (long)Config.FS_TIME_WARMUP * 60000L;
            FourSepulchersManager.this._changeAttackTimeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ChangeAttackTime(), interval);
            if (FourSepulchersManager.this._changeWarmUpTimeTask != null) {
                FourSepulchersManager.this._changeWarmUpTimeTask.cancel(true);
                FourSepulchersManager.this._changeWarmUpTimeTask = null;
            }
        }
    }

    protected class ChangeEntryTime
    implements Runnable {
        protected ChangeEntryTime() {
        }

        @Override
        public void run() {
            FourSepulchersManager.this._inEntryTime = true;
            FourSepulchersManager.this._inWarmUpTime = false;
            FourSepulchersManager.this._inAttackTime = false;
            FourSepulchersManager.this._inCoolDownTime = false;
            long interval = (long)Config.FS_TIME_ENTRY * 60000L;
            ThreadPoolManager.getInstance().scheduleGeneral(new ManagerSay(), 0L);
            FourSepulchersManager.this._changeWarmUpTimeTask = ThreadPoolManager.getInstance().scheduleEffect(new ChangeWarmUpTime(), interval);
            if (FourSepulchersManager.this._changeEntryTimeTask != null) {
                FourSepulchersManager.this._changeEntryTimeTask.cancel(true);
                FourSepulchersManager.this._changeEntryTimeTask = null;
            }
        }
    }

    protected class ManagerSay
    implements Runnable {
        protected ManagerSay() {
        }

        @Override
        public void run() {
            if (FourSepulchersManager.this._inAttackTime) {
                Calendar tmp = Calendar.getInstance();
                tmp.setTimeInMillis(Calendar.getInstance().getTimeInMillis() - FourSepulchersManager.this._attackTimeStart);
                int min = tmp.get(12);
                FourSepulchersManager.this.managerSay(min);
                if (min + 5 <= Config.FS_TIME_ATTACK) {
                    ThreadPoolManager.getInstance().scheduleGeneral(new ManagerSay(), 300000L);
                }
            } else if (FourSepulchersManager.this._inEntryTime) {
                FourSepulchersManager.this.managerSay(0);
            }
        }
    }
}

