/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.CharTemplateTable;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.TutorialCloseHtml;
import com.l2jserver.gameserver.network.serverpackets.TutorialShowHtml;
import com.l2jserver.gameserver.network.serverpackets.TutorialShowQuestionMark;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.StringUtil;

public final class L2ClassMasterInstance
extends L2MerchantInstance {
    public L2ClassMasterInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2ClassMasterInstance);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/classmaster/", npcId, val);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("1stClass")) {
            L2ClassMasterInstance.showHtmlMenu(player, this.getObjectId(), 1);
        } else if (command.startsWith("2ndClass")) {
            L2ClassMasterInstance.showHtmlMenu(player, this.getObjectId(), 2);
        } else if (command.startsWith("3rdClass")) {
            L2ClassMasterInstance.showHtmlMenu(player, this.getObjectId(), 3);
        } else if (command.startsWith("change_class")) {
            int val = Integer.parseInt(command.substring(13));
            if (L2ClassMasterInstance.checkAndChangeClass(player, val)) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/classmaster/ok.htm");
                html.replace((CharSequence)"%name%", CharTemplateTable.getInstance().getClassNameById(val));
                player.sendPacket(html);
            }
        } else if (command.startsWith("become_noble")) {
            if (!player.isNoble()) {
                player.setNoble(true);
                player.sendPacket(new UserInfo(player));
                player.sendPacket(new ExBrExtraUserInfo(player));
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/classmaster/nobleok.htm");
                player.sendPacket(html);
            }
        } else if (command.startsWith("learn_skills")) {
            player.giveAvailableSkills(Config.AUTO_LEARN_FS_SKILLS, true);
        } else if (command.startsWith("increase_clan_level")) {
            if (!player.isClanLeader()) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/classmaster/noclanleader.htm");
                player.sendPacket(html);
            } else if (player.getClan().getLevel() >= 5) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/classmaster/noclanlevel.htm");
                player.sendPacket(html);
            } else {
                player.getClan().changeLevel(5);
            }
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    public static final void onTutorialLink(L2PcInstance player, String request) {
        if (!Config.ALTERNATE_CLASS_MASTER || request == null || !request.startsWith("CO")) {
            return;
        }
        if (!player.getFloodProtectors().getServerBypass().tryPerformAction("changeclass")) {
            return;
        }
        try {
            int val = Integer.parseInt(request.substring(2));
            L2ClassMasterInstance.checkAndChangeClass(player, val);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        player.sendPacket(new TutorialCloseHtml());
    }

    public static final void onTutorialQuestionMark(L2PcInstance player, int number) {
        if (!Config.ALTERNATE_CLASS_MASTER || number != 1001) {
            return;
        }
        L2ClassMasterInstance.showTutorialHtml(player);
    }

    public static final void showQuestionMark(L2PcInstance player) {
        if (!Config.ALTERNATE_CLASS_MASTER) {
            return;
        }
        ClassId classId = player.getClassId();
        if (L2ClassMasterInstance.getMinLevel(classId.level()) > player.getLevel()) {
            return;
        }
        if (!Config.CLASS_MASTER_SETTINGS.isAllowed(classId.level() + 1)) {
            return;
        }
        player.sendPacket(new TutorialShowQuestionMark(1001));
    }

    private static final void showHtmlMenu(L2PcInstance player, int objectId, int level) {
        NpcHtmlMessage html = new NpcHtmlMessage(objectId);
        if (!Config.ALLOW_CLASS_MASTERS) {
            html.setFile(player.getHtmlPrefix(), "data/html/classmaster/disabled.htm");
        } else if (!Config.CLASS_MASTER_SETTINGS.isAllowed(level)) {
            int jobLevel = player.getClassId().level();
            StringBuilder sb = new StringBuilder(100);
            sb.append("<html><body>");
            switch (jobLevel) {
                case 0: {
                    if (Config.CLASS_MASTER_SETTINGS.isAllowed(1)) {
                        sb.append("Come back here when you reached level 20 to change your class.<br>");
                        break;
                    }
                    if (Config.CLASS_MASTER_SETTINGS.isAllowed(2)) {
                        sb.append("Come back after your first occupation change.<br>");
                        break;
                    }
                    if (Config.CLASS_MASTER_SETTINGS.isAllowed(3)) {
                        sb.append("Come back after your second occupation change.<br>");
                        break;
                    }
                    sb.append("I can't change your occupation.<br>");
                    break;
                }
                case 1: {
                    if (Config.CLASS_MASTER_SETTINGS.isAllowed(2)) {
                        sb.append("Come back here when you reached level 40 to change your class.<br>");
                        break;
                    }
                    if (Config.CLASS_MASTER_SETTINGS.isAllowed(3)) {
                        sb.append("Come back after your second occupation change.<br>");
                        break;
                    }
                    sb.append("I can't change your occupation.<br>");
                    break;
                }
                case 2: {
                    if (Config.CLASS_MASTER_SETTINGS.isAllowed(3)) {
                        sb.append("Come back here when you reached level 76 to change your class.<br>");
                        break;
                    }
                    sb.append("I can't change your occupation.<br>");
                    break;
                }
                case 3: {
                    sb.append("There is no class change available for you anymore.<br>");
                }
            }
            sb.append("</body></html>");
            html.setHtml(sb.toString());
        } else {
            ClassId currentClassId = player.getClassId();
            if (currentClassId.level() >= level) {
                html.setFile(player.getHtmlPrefix(), "data/html/classmaster/nomore.htm");
            } else {
                int minLevel = L2ClassMasterInstance.getMinLevel(currentClassId.level());
                if (player.getLevel() >= minLevel || Config.ALLOW_ENTIRE_TREE) {
                    StringBuilder menu = new StringBuilder(100);
                    for (ClassId cid : ClassId.values()) {
                        if (cid == ClassId.inspector && player.getTotalSubClasses() < 2 || !L2ClassMasterInstance.validateClassId(currentClassId, cid) || cid.level() != level) continue;
                        StringUtil.append(menu, "<a action=\"bypass -h npc_%objectId%_change_class ", String.valueOf(cid.getId()), "\">", CharTemplateTable.getInstance().getClassNameById(cid.getId()), "</a><br>");
                    }
                    if (menu.length() > 0) {
                        html.setFile(player.getHtmlPrefix(), "data/html/classmaster/template.htm");
                        html.replace((CharSequence)"%name%", CharTemplateTable.getInstance().getClassNameById(currentClassId.getId()));
                        html.replace((CharSequence)"%menu%", menu.toString());
                    } else {
                        html.setFile(player.getHtmlPrefix(), "data/html/classmaster/comebacklater.htm");
                        html.replace((CharSequence)"%level%", L2ClassMasterInstance.getMinLevel(level - 1));
                    }
                } else if (minLevel < Integer.MAX_VALUE) {
                    html.setFile(player.getHtmlPrefix(), "data/html/classmaster/comebacklater.htm");
                    html.replace((CharSequence)"%level%", minLevel);
                } else {
                    html.setFile(player.getHtmlPrefix(), "data/html/classmaster/nomore.htm");
                }
            }
        }
        html.replace((CharSequence)"%objectId%", objectId);
        html.replace((CharSequence)"%req_items%", L2ClassMasterInstance.getRequiredItems(level));
        player.sendPacket(html);
    }

    private static final void showTutorialHtml(L2PcInstance player) {
        ClassId currentClassId = player.getClassId();
        if (L2ClassMasterInstance.getMinLevel(currentClassId.level()) > player.getLevel() && !Config.ALLOW_ENTIRE_TREE) {
            return;
        }
        String msg = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/classmaster/tutorialtemplate.htm");
        msg = msg.replaceAll("%name%", CharTemplateTable.getInstance().getClassNameById(currentClassId.getId()));
        StringBuilder menu = new StringBuilder(100);
        for (ClassId cid : ClassId.values()) {
            if (cid == ClassId.inspector && player.getTotalSubClasses() < 2 || !L2ClassMasterInstance.validateClassId(currentClassId, cid)) continue;
            StringUtil.append(menu, "<a action=\"link CO", String.valueOf(cid.getId()), "\">", CharTemplateTable.getInstance().getClassNameById(cid.getId()), "</a><br>");
        }
        msg = msg.replaceAll("%menu%", menu.toString());
        msg = msg.replace("%req_items%", L2ClassMasterInstance.getRequiredItems(currentClassId.level() + 1));
        player.sendPacket(new TutorialShowHtml(msg));
    }

    private static final boolean checkAndChangeClass(L2PcInstance player, int val) {
        int _count;
        ClassId currentClassId = player.getClassId();
        if (L2ClassMasterInstance.getMinLevel(currentClassId.level()) > player.getLevel() && !Config.ALLOW_ENTIRE_TREE) {
            return false;
        }
        if (!L2ClassMasterInstance.validateClassId(currentClassId, val)) {
            return false;
        }
        int newJobLevel = currentClassId.level() + 1;
        if (!Config.CLASS_MASTER_SETTINGS.getRewardItems(newJobLevel).isEmpty() && !player.isInventoryUnder80(false)) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.INVENTORY_LESS_THAN_80_PERCENT));
            return false;
        }
        for (int _itemId : Config.CLASS_MASTER_SETTINGS.getRequireItems(newJobLevel).keys()) {
            _count = Config.CLASS_MASTER_SETTINGS.getRequireItems(newJobLevel).get(_itemId);
            if (player.getInventory().getInventoryItemCount(_itemId, -1) >= (long)_count) continue;
            player.sendPacket(SystemMessageId.NOT_ENOUGH_ITEMS);
            return false;
        }
        for (int _itemId : Config.CLASS_MASTER_SETTINGS.getRequireItems(newJobLevel).keys()) {
            _count = Config.CLASS_MASTER_SETTINGS.getRequireItems(newJobLevel).get(_itemId);
            if (player.destroyItemByItemId("ClassMaster", _itemId, _count, player, true)) continue;
            return false;
        }
        for (int _itemId : Config.CLASS_MASTER_SETTINGS.getRewardItems(newJobLevel).keys()) {
            _count = Config.CLASS_MASTER_SETTINGS.getRewardItems(newJobLevel).get(_itemId);
            player.addItem("ClassMaster", _itemId, _count, player, true);
        }
        player.setClassId(val);
        if (player.isSubClassActive()) {
            player.getSubClasses().get(player.getClassIndex()).setClassId(player.getActiveClass());
        } else {
            player.setBaseClass(player.getActiveClass());
        }
        Quest q = QuestManager.getInstance().getQuest("SkillTransfer");
        if (q != null) {
            q.startQuestTimer("givePormanders", 1L, null, player);
        }
        player.broadcastUserInfo();
        if (Config.CLASS_MASTER_SETTINGS.isAllowed(player.getClassId().level() + 1) && Config.ALTERNATE_CLASS_MASTER && (player.getClassId().level() == 1 && player.getLevel() >= 40 || player.getClassId().level() == 2 && player.getLevel() >= 76)) {
            L2ClassMasterInstance.showQuestionMark(player);
        }
        return true;
    }

    private static final int getMinLevel(int level) {
        switch (level) {
            case 0: {
                return 20;
            }
            case 1: {
                return 40;
            }
            case 2: {
                return 76;
            }
        }
        return Integer.MAX_VALUE;
    }

    private static final boolean validateClassId(ClassId oldCID, int val) {
        try {
            return L2ClassMasterInstance.validateClassId(oldCID, ClassId.values()[val]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static final boolean validateClassId(ClassId oldCID, ClassId newCID) {
        if (newCID == null || newCID.getRace() == null) {
            return false;
        }
        if (oldCID.equals((Object)newCID.getParent())) {
            return true;
        }
        return Config.ALLOW_ENTIRE_TREE && newCID.childOf(oldCID);
    }

    private static String getRequiredItems(int level) {
        if (Config.CLASS_MASTER_SETTINGS.getRequireItems(level) == null || Config.CLASS_MASTER_SETTINGS.getRequireItems(level).isEmpty()) {
            return "<tr><td>none</td></r>";
        }
        StringBuilder sb = new StringBuilder(256);
        for (int _itemId : Config.CLASS_MASTER_SETTINGS.getRequireItems(level).keys()) {
            int _count = Config.CLASS_MASTER_SETTINGS.getRequireItems(level).get(_itemId);
            sb.append("<tr><td><font color=\"LEVEL\">").append(_count).append("</font></td><td>").append(ItemTable.getInstance().getTemplate(_itemId).getName()).append("</td></tr>");
        }
        return sb.toString();
    }
}

