/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.util.Map;
import javolution.util.FastMap;

public class TvTEventTeam {
    private String _name;
    private int[] _coordinates = new int[3];
    private short _points;
    private Map<Integer, L2PcInstance> _participatedPlayers = new FastMap();

    public TvTEventTeam(String name, int[] coordinates) {
        this._name = name;
        this._coordinates = coordinates;
        this._points = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPlayer(L2PcInstance playerInstance) {
        if (playerInstance == null) {
            return false;
        }
        Map<Integer, L2PcInstance> map = this._participatedPlayers;
        synchronized (map) {
            this._participatedPlayers.put(playerInstance.getObjectId(), playerInstance);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePlayer(int playerObjectId) {
        Map<Integer, L2PcInstance> map = this._participatedPlayers;
        synchronized (map) {
            this._participatedPlayers.remove(playerObjectId);
        }
    }

    public void increasePoints() {
        this._points = (short)(this._points + 1);
    }

    public void cleanMe() {
        this._participatedPlayers.clear();
        this._participatedPlayers = new FastMap();
        this._points = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsPlayer(int playerObjectId) {
        boolean containsPlayer;
        Map<Integer, L2PcInstance> map = this._participatedPlayers;
        synchronized (map) {
            containsPlayer = this._participatedPlayers.containsKey(playerObjectId);
        }
        return containsPlayer;
    }

    public String getName() {
        return this._name;
    }

    public int[] getCoordinates() {
        return this._coordinates;
    }

    public short getPoints() {
        return this._points;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, L2PcInstance> getParticipatedPlayers() {
        Map<Integer, L2PcInstance> participatedPlayers = null;
        Map<Integer, L2PcInstance> map = this._participatedPlayers;
        synchronized (map) {
            participatedPlayers = this._participatedPlayers;
        }
        return participatedPlayers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getParticipatedPlayerCount() {
        int participatedPlayerCount;
        Map<Integer, L2PcInstance> map = this._participatedPlayers;
        synchronized (map) {
            participatedPlayerCount = this._participatedPlayers.size();
        }
        return participatedPlayerCount;
    }
}

