/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.AbstractRefinePacket;
import com.l2jserver.gameserver.network.serverpackets.ExPutIntensiveResultForVariationMake;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class RequestConfirmRefinerItem
extends AbstractRefinePacket {
    private static final String _C__D0_27_REQUESTCONFIRMREFINERITEM = "[C] D0:27 RequestConfirmRefinerItem";
    private int _targetItemObjId;
    private int _refinerItemObjId;

    @Override
    protected void readImpl() {
        this._targetItemObjId = this.readD();
        this._refinerItemObjId = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2ItemInstance targetItem = activeChar.getInventory().getItemByObjectId(this._targetItemObjId);
        if (targetItem == null) {
            return;
        }
        L2ItemInstance refinerItem = activeChar.getInventory().getItemByObjectId(this._refinerItemObjId);
        if (refinerItem == null) {
            return;
        }
        if (!RequestConfirmRefinerItem.isValid(activeChar, targetItem, refinerItem)) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.THIS_IS_NOT_A_SUITABLE_ITEM));
            return;
        }
        int refinerItemId = refinerItem.getItem().getItemId();
        int grade = targetItem.getItem().getItemGrade();
        AbstractRefinePacket.LifeStone ls = RequestConfirmRefinerItem.getLifeStone(refinerItemId);
        int gemStoneId = RequestConfirmRefinerItem.getGemStoneId(grade);
        int gemStoneCount = RequestConfirmRefinerItem.getGemStoneCount(grade, ls.getGrade());
        activeChar.sendPacket(new ExPutIntensiveResultForVariationMake(this._refinerItemObjId, refinerItemId, gemStoneId, gemStoneCount));
    }

    @Override
    public String getType() {
        return _C__D0_27_REQUESTCONFIRMREFINERITEM;
    }
}

