/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.TaskPriority;
import com.l2jserver.gameserver.instancemanager.BoatManager;
import com.l2jserver.gameserver.model.actor.instance.L2BoatInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.MoveToLocationInVehicle;
import com.l2jserver.gameserver.network.serverpackets.StopMoveInVehicle;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import com.l2jserver.gameserver.util.Point3D;

public final class RequestMoveToLocationInVehicle
extends L2GameClientPacket {
    private static final String _C__75_MOVETOLOCATIONINVEHICLE = "[C] 75 RequestMoveToLocationInVehicle";
    private int _boatId;
    private int _targetX;
    private int _targetY;
    private int _targetZ;
    private int _originX;
    private int _originY;
    private int _originZ;

    public TaskPriority getPriority() {
        return TaskPriority.PR_HIGH;
    }

    @Override
    protected void readImpl() {
        this._boatId = this.readD();
        this._targetX = this.readD();
        this._targetY = this.readD();
        this._targetZ = this.readD();
        this._originX = this.readD();
        this._originY = this.readD();
        this._originZ = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (this._targetX == this._originX && this._targetY == this._originY && this._targetZ == this._originZ) {
            activeChar.sendPacket(new StopMoveInVehicle(activeChar, this._boatId));
            return;
        }
        if (activeChar.isAttackingNow() && activeChar.getActiveWeaponItem() != null && activeChar.getActiveWeaponItem().getItemType() == L2WeaponType.BOW) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (activeChar.isSitting() || activeChar.isMovementDisabled()) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (activeChar.getPet() != null) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.RELEASE_PET_ON_BOAT));
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (activeChar.isTransformed()) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANT_POLYMORPH_ON_BOAT));
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (activeChar.isInBoat()) {
            L2BoatInstance boat = activeChar.getBoat();
            if (boat.getObjectId() != this._boatId) {
                activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
        } else {
            L2BoatInstance boat = BoatManager.getInstance().getBoat(this._boatId);
            if (boat == null || !boat.isInsideRadius(activeChar, 300, true, false)) {
                activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            activeChar.setVehicle(boat);
        }
        Point3D pos = new Point3D(this._targetX, this._targetY, this._targetZ);
        Point3D originPos = new Point3D(this._originX, this._originY, this._originZ);
        activeChar.setInVehiclePosition(pos);
        activeChar.broadcastPacket(new MoveToLocationInVehicle(activeChar, pos, originPos));
    }

    @Override
    public String getType() {
        return _C__75_MOVETOLOCATIONINVEHICLE;
    }
}

