/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2TradeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.List;
import javolution.util.FastList;

public class ExBuySellListPacket
extends L2GameServerPacket {
    private static final String _S__B7_ExBuySellListPacket = "[S] B7 ExBuySellListPacket";
    private List<L2TradeList.L2TradeItem> _buyList = new FastList();
    private L2ItemInstance[] _sellList = null;
    private L2ItemInstance[] _refundList = null;
    private boolean _done;

    public ExBuySellListPacket(L2PcInstance player, L2TradeList list, double taxRate, boolean done) {
        for (L2TradeList.L2TradeItem item : list.getItems()) {
            if (item.hasLimitedStock() && item.getCurrentCount() <= 0L) continue;
            this._buyList.add(item);
        }
        this._sellList = player.getInventory().getAvailableItems(false, false, false);
        if (player.hasRefund()) {
            this._refundList = player.getRefund().getItems();
        }
        this._done = done;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(254);
        this.writeH(183);
        this.writeD(1);
        if (this._sellList != null && this._sellList.length > 0) {
            this.writeH(this._sellList.length);
            for (L2ItemInstance item : this._sellList) {
                this.writeD(item.getObjectId());
                this.writeD(item.getItemId());
                this.writeD(item.getLocationSlot());
                this.writeQ(item.getCount());
                this.writeH(item.getItem().getType2());
                this.writeH(item.getCustomType1());
                this.writeH(0);
                this.writeD(item.getItem().getBodyPart());
                this.writeH(item.getEnchantLevel());
                this.writeH(item.getCustomType2());
                this.writeD(0);
                this.writeD(-1);
                this.writeD(-9999);
                this.writeH(item.getAttackElementType());
                this.writeH(item.getAttackElementPower());
                for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                    this.writeH(item.getElementDefAttr(i));
                }
                this.writeH(0);
                this.writeH(0);
                this.writeH(0);
                this.writeQ(item.getItem().getReferencePrice() / 2);
            }
        } else {
            this.writeH(0);
        }
        if (this._refundList != null && this._refundList.length > 0) {
            this.writeH(this._refundList.length);
            int idx = 0;
            for (L2ItemInstance item : this._refundList) {
                this.writeD(item.getObjectId());
                this.writeD(item.getItemId());
                this.writeD(0);
                this.writeQ(item.getCount());
                this.writeH(item.getItem().getType2());
                this.writeH(item.getCustomType1());
                this.writeH(0);
                this.writeD(item.getItem().getBodyPart());
                this.writeH(item.getEnchantLevel());
                this.writeH(item.getCustomType2());
                this.writeD(0);
                this.writeD(-1);
                this.writeD(-9999);
                this.writeH(item.getAttackElementType());
                this.writeH(item.getAttackElementPower());
                for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                    this.writeH(item.getElementDefAttr(i));
                }
                this.writeH(0);
                this.writeH(0);
                this.writeH(0);
                this.writeD(idx++);
                this.writeQ((long)(item.getItem().getReferencePrice() / 2) * item.getCount());
            }
        } else {
            this.writeH(0);
        }
        this.writeC(this._done ? 1 : 0);
        this._buyList.clear();
    }

    @Override
    public String getType() {
        return _S__B7_ExBuySellListPacket;
    }
}

