/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import javolution.util.FastList;

public class ExShowFortressMapInfo
extends L2GameServerPacket {
    private final Fort _fortress;

    public ExShowFortressMapInfo(Fort fortress) {
        this._fortress = fortress;
    }

    @Override
    public String getType() {
        return "[S] FE:7D ExShowFortressMapInfo";
    }

    @Override
    protected void writeImpl() {
        block11: {
            block10: {
                this.writeC(254);
                this.writeH(125);
                this.writeD(this._fortress.getFortId());
                this.writeD(this._fortress.getSiege().getIsInProgress() ? 1 : 0);
                this.writeD(this._fortress.getFortSize());
                FastList<FortSiegeManager.SiegeSpawn> commanders = FortSiegeManager.getInstance().getCommanderSpawnList(this._fortress.getFortId());
                if (commanders == null || commanders.size() == 0 || !this._fortress.getSiege().getIsInProgress()) break block10;
                switch (commanders.size()) {
                    case 3: {
                        for (FortSiegeManager.SiegeSpawn spawn : commanders) {
                            if (this.isSpawned(spawn.getNpcId())) {
                                this.writeD(0);
                                continue;
                            }
                            this.writeD(1);
                        }
                        break block11;
                    }
                    case 4: {
                        int count = 0;
                        for (FortSiegeManager.SiegeSpawn spawn : commanders) {
                            if (++count == 4) {
                                this.writeD(1);
                            }
                            if (this.isSpawned(spawn.getNpcId())) {
                                this.writeD(0);
                                continue;
                            }
                            this.writeD(1);
                        }
                        break block11;
                    }
                }
                break block11;
            }
            for (int i = 0; i < this._fortress.getFortSize(); ++i) {
                this.writeD(0);
            }
        }
    }

    private boolean isSpawned(int npcId) {
        boolean ret = false;
        for (L2Spawn spawn : this._fortress.getSiege().getCommanders()) {
            if (spawn.getNpcid() != npcId) continue;
            ret = true;
        }
        return ret;
    }
}

