/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.pathfinding;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.pathfinding.AbstractNodeLoc;
import com.l2jserver.gameserver.pathfinding.cellnodes.CellPathFinding;
import com.l2jserver.gameserver.pathfinding.geonodes.GeoPathFinding;
import java.util.List;

public abstract class PathFinding {
    public static PathFinding getInstance() {
        if (!Config.GEODATA_CELLFINDING) {
            return GeoPathFinding.getInstance();
        }
        return CellPathFinding.getInstance();
    }

    public abstract boolean pathNodesExist(short var1);

    public abstract List<AbstractNodeLoc> findPath(int var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    public short getNodePos(int geo_pos) {
        return (short)(geo_pos >> 3);
    }

    public short getNodeBlock(int node_pos) {
        return (short)(node_pos % 256);
    }

    public byte getRegionX(int node_pos) {
        return (byte)((node_pos >> 8) + Config.WORLD_X_MIN);
    }

    public byte getRegionY(int node_pos) {
        return (byte)((node_pos >> 8) + Config.WORLD_Y_MIN);
    }

    public short getRegionOffset(byte rx, byte ry) {
        return (short)((rx << 5) + ry);
    }

    public int calculateWorldX(short node_x) {
        return L2World.MAP_MIN_X + node_x * 128 + 48;
    }

    public int calculateWorldY(short node_y) {
        return L2World.MAP_MIN_Y + node_y * 128 + 48;
    }

    public String[] getStat() {
        return null;
    }
}

